"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class SupportInfoDump(google.protobuf.message.Message):
    """
    The SupportInfoDump is a collection of SupportInfoItems.
    Each SupportInfoItem is a pair of a unique label and any content.
    The label describes the type of support info that is contained in
    the content field. It can be used by the client to form a file name
    for a file that the content is stored in.
    Labels must be unique within the collection of SupportInfoItems.
    The content can be any data that should be delivered to support for
    the given label and is mostly opaque to the client.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class SupportInfoItem(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        LABEL_FIELD_NUMBER: builtins.int
        CONTENT_FIELD_NUMBER: builtins.int
        label: builtins.str
        """Label describing the content. Defined labels: configlayer, delosconfig, pib, syslog"""
        content: builtins.bytes
        """Any type of support info content."""
        def __init__(
            self,
            *,
            label: builtins.str = ...,
            content: builtins.bytes = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["content", b"content", "label", b"label"]) -> None: ...

    ITEMS_FIELD_NUMBER: builtins.int
    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___SupportInfoDump.SupportInfoItem]:
        """A list of label-content pairs that make up multiple support info items for this device."""
    def __init__(
        self,
        *,
        items: collections.abc.Iterable[global___SupportInfoDump.SupportInfoItem] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["items", b"items"]) -> None: ...

global___SupportInfoDump = SupportInfoDump

class SupportInfoDumpResponse(google.protobuf.message.Message):
    """
    Response to calling the "SupportInfoDump" endpoint to collect support info data from a device.
    The response is made up of a result code, in case something went wrong, and a SupportInfoDump
    which contains the collection of support info items that the client needs to store in a file
    to be sent to devolo support.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Result:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ResultEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SupportInfoDumpResponse._Result.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SUCCESS: SupportInfoDumpResponse._Result.ValueType  # 0
        """Successful operation, support items are returned."""
        UNKNOWN_ERROR: SupportInfoDumpResponse._Result.ValueType  # 255
        """Some error occured, returned info is unreliable."""

    class Result(_Result, metaclass=_ResultEnumTypeWrapper): ...
    SUCCESS: SupportInfoDumpResponse.Result.ValueType  # 0
    """Successful operation, support items are returned."""
    UNKNOWN_ERROR: SupportInfoDumpResponse.Result.ValueType  # 255
    """Some error occured, returned info is unreliable."""

    RESULT_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    result: global___SupportInfoDumpResponse.Result.ValueType
    """The return code of the opration, success or error."""
    @property
    def info(self) -> global___SupportInfoDump:
        """The collected support information."""
    def __init__(
        self,
        *,
        result: global___SupportInfoDumpResponse.Result.ValueType = ...,
        info: global___SupportInfoDump | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["info", b"info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["info", b"info", "result", b"result"]) -> None: ...

global___SupportInfoDumpResponse = SupportInfoDumpResponse
