// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53resolver

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateFirewallRuleGroup = "AssociateFirewallRuleGroup"

// AssociateFirewallRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the AssociateFirewallRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateFirewallRuleGroup for more information on using the AssociateFirewallRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateFirewallRuleGroupRequest method.
//	req, resp := client.AssociateFirewallRuleGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateFirewallRuleGroup
func (c *Route53Resolver) AssociateFirewallRuleGroupRequest(input *AssociateFirewallRuleGroupInput) (req *request.Request, output *AssociateFirewallRuleGroupOutput) {
	op := &request.Operation{
		Name:       opAssociateFirewallRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateFirewallRuleGroupInput{}
	}

	output = &AssociateFirewallRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateFirewallRuleGroup API operation for Amazon Route 53 Resolver.
//
// Associates a FirewallRuleGroup with a VPC, to provide DNS filtering for the
// VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation AssociateFirewallRuleGroup for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - ConflictException
//     The requested state transition isn't valid. For example, you can't delete
//     a firewall domain list if it is in the process of being deleted, or you can't
//     import domains into a domain list that is in the process of being deleted.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateFirewallRuleGroup
func (c *Route53Resolver) AssociateFirewallRuleGroup(input *AssociateFirewallRuleGroupInput) (*AssociateFirewallRuleGroupOutput, error) {
	req, out := c.AssociateFirewallRuleGroupRequest(input)
	return out, req.Send()
}

// AssociateFirewallRuleGroupWithContext is the same as AssociateFirewallRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateFirewallRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) AssociateFirewallRuleGroupWithContext(ctx aws.Context, input *AssociateFirewallRuleGroupInput, opts ...request.Option) (*AssociateFirewallRuleGroupOutput, error) {
	req, out := c.AssociateFirewallRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateResolverEndpointIpAddress = "AssociateResolverEndpointIpAddress"

// AssociateResolverEndpointIpAddressRequest generates a "aws/request.Request" representing the
// client's request for the AssociateResolverEndpointIpAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateResolverEndpointIpAddress for more information on using the AssociateResolverEndpointIpAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateResolverEndpointIpAddressRequest method.
//	req, resp := client.AssociateResolverEndpointIpAddressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverEndpointIpAddress
func (c *Route53Resolver) AssociateResolverEndpointIpAddressRequest(input *AssociateResolverEndpointIpAddressInput) (req *request.Request, output *AssociateResolverEndpointIpAddressOutput) {
	op := &request.Operation{
		Name:       opAssociateResolverEndpointIpAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateResolverEndpointIpAddressInput{}
	}

	output = &AssociateResolverEndpointIpAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateResolverEndpointIpAddress API operation for Amazon Route 53 Resolver.
//
// Adds IP addresses to an inbound or an outbound Resolver endpoint. If you
// want to add more than one IP address, submit one AssociateResolverEndpointIpAddress
// request for each IP address.
//
// To remove an IP address from an endpoint, see DisassociateResolverEndpointIpAddress
// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverEndpointIpAddress.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation AssociateResolverEndpointIpAddress for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceExistsException
//     The resource that you tried to create already exists.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverEndpointIpAddress
func (c *Route53Resolver) AssociateResolverEndpointIpAddress(input *AssociateResolverEndpointIpAddressInput) (*AssociateResolverEndpointIpAddressOutput, error) {
	req, out := c.AssociateResolverEndpointIpAddressRequest(input)
	return out, req.Send()
}

// AssociateResolverEndpointIpAddressWithContext is the same as AssociateResolverEndpointIpAddress with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateResolverEndpointIpAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) AssociateResolverEndpointIpAddressWithContext(ctx aws.Context, input *AssociateResolverEndpointIpAddressInput, opts ...request.Option) (*AssociateResolverEndpointIpAddressOutput, error) {
	req, out := c.AssociateResolverEndpointIpAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateResolverQueryLogConfig = "AssociateResolverQueryLogConfig"

// AssociateResolverQueryLogConfigRequest generates a "aws/request.Request" representing the
// client's request for the AssociateResolverQueryLogConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateResolverQueryLogConfig for more information on using the AssociateResolverQueryLogConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateResolverQueryLogConfigRequest method.
//	req, resp := client.AssociateResolverQueryLogConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverQueryLogConfig
func (c *Route53Resolver) AssociateResolverQueryLogConfigRequest(input *AssociateResolverQueryLogConfigInput) (req *request.Request, output *AssociateResolverQueryLogConfigOutput) {
	op := &request.Operation{
		Name:       opAssociateResolverQueryLogConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateResolverQueryLogConfigInput{}
	}

	output = &AssociateResolverQueryLogConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateResolverQueryLogConfig API operation for Amazon Route 53 Resolver.
//
// Associates an Amazon VPC with a specified query logging configuration. Route
// 53 Resolver logs DNS queries that originate in all of the Amazon VPCs that
// are associated with a specified query logging configuration. To associate
// more than one VPC with a configuration, submit one AssociateResolverQueryLogConfig
// request for each VPC.
//
// The VPCs that you associate with a query logging configuration must be in
// the same Region as the configuration.
//
// To remove a VPC from a query logging configuration, see DisassociateResolverQueryLogConfig
// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation AssociateResolverQueryLogConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceExistsException
//     The resource that you tried to create already exists.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverQueryLogConfig
func (c *Route53Resolver) AssociateResolverQueryLogConfig(input *AssociateResolverQueryLogConfigInput) (*AssociateResolverQueryLogConfigOutput, error) {
	req, out := c.AssociateResolverQueryLogConfigRequest(input)
	return out, req.Send()
}

// AssociateResolverQueryLogConfigWithContext is the same as AssociateResolverQueryLogConfig with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateResolverQueryLogConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) AssociateResolverQueryLogConfigWithContext(ctx aws.Context, input *AssociateResolverQueryLogConfigInput, opts ...request.Option) (*AssociateResolverQueryLogConfigOutput, error) {
	req, out := c.AssociateResolverQueryLogConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateResolverRule = "AssociateResolverRule"

// AssociateResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the AssociateResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateResolverRule for more information on using the AssociateResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateResolverRuleRequest method.
//	req, resp := client.AssociateResolverRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverRule
func (c *Route53Resolver) AssociateResolverRuleRequest(input *AssociateResolverRuleInput) (req *request.Request, output *AssociateResolverRuleOutput) {
	op := &request.Operation{
		Name:       opAssociateResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateResolverRuleInput{}
	}

	output = &AssociateResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateResolverRule API operation for Amazon Route 53 Resolver.
//
// Associates a Resolver rule with a VPC. When you associate a rule with a VPC,
// Resolver forwards all DNS queries for the domain name that is specified in
// the rule and that originate in the VPC. The queries are forwarded to the
// IP addresses for the DNS resolvers that are specified in the rule. For more
// information about rules, see CreateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation AssociateResolverRule for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ResourceUnavailableException
//     The specified resource isn't available.
//
//   - ResourceExistsException
//     The resource that you tried to create already exists.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/AssociateResolverRule
func (c *Route53Resolver) AssociateResolverRule(input *AssociateResolverRuleInput) (*AssociateResolverRuleOutput, error) {
	req, out := c.AssociateResolverRuleRequest(input)
	return out, req.Send()
}

// AssociateResolverRuleWithContext is the same as AssociateResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) AssociateResolverRuleWithContext(ctx aws.Context, input *AssociateResolverRuleInput, opts ...request.Option) (*AssociateResolverRuleOutput, error) {
	req, out := c.AssociateResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFirewallDomainList = "CreateFirewallDomainList"

// CreateFirewallDomainListRequest generates a "aws/request.Request" representing the
// client's request for the CreateFirewallDomainList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFirewallDomainList for more information on using the CreateFirewallDomainList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFirewallDomainListRequest method.
//	req, resp := client.CreateFirewallDomainListRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateFirewallDomainList
func (c *Route53Resolver) CreateFirewallDomainListRequest(input *CreateFirewallDomainListInput) (req *request.Request, output *CreateFirewallDomainListOutput) {
	op := &request.Operation{
		Name:       opCreateFirewallDomainList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFirewallDomainListInput{}
	}

	output = &CreateFirewallDomainListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFirewallDomainList API operation for Amazon Route 53 Resolver.
//
// Creates an empty firewall domain list for use in DNS Firewall rules. You
// can populate the domains for the new list with a file, using ImportFirewallDomains,
// or with domain strings, using UpdateFirewallDomains.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation CreateFirewallDomainList for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateFirewallDomainList
func (c *Route53Resolver) CreateFirewallDomainList(input *CreateFirewallDomainListInput) (*CreateFirewallDomainListOutput, error) {
	req, out := c.CreateFirewallDomainListRequest(input)
	return out, req.Send()
}

// CreateFirewallDomainListWithContext is the same as CreateFirewallDomainList with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFirewallDomainList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) CreateFirewallDomainListWithContext(ctx aws.Context, input *CreateFirewallDomainListInput, opts ...request.Option) (*CreateFirewallDomainListOutput, error) {
	req, out := c.CreateFirewallDomainListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFirewallRule = "CreateFirewallRule"

// CreateFirewallRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateFirewallRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFirewallRule for more information on using the CreateFirewallRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFirewallRuleRequest method.
//	req, resp := client.CreateFirewallRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateFirewallRule
func (c *Route53Resolver) CreateFirewallRuleRequest(input *CreateFirewallRuleInput) (req *request.Request, output *CreateFirewallRuleOutput) {
	op := &request.Operation{
		Name:       opCreateFirewallRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFirewallRuleInput{}
	}

	output = &CreateFirewallRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFirewallRule API operation for Amazon Route 53 Resolver.
//
// Creates a single DNS Firewall rule in the specified rule group, using the
// specified domain list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation CreateFirewallRule for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateFirewallRule
func (c *Route53Resolver) CreateFirewallRule(input *CreateFirewallRuleInput) (*CreateFirewallRuleOutput, error) {
	req, out := c.CreateFirewallRuleRequest(input)
	return out, req.Send()
}

// CreateFirewallRuleWithContext is the same as CreateFirewallRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFirewallRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) CreateFirewallRuleWithContext(ctx aws.Context, input *CreateFirewallRuleInput, opts ...request.Option) (*CreateFirewallRuleOutput, error) {
	req, out := c.CreateFirewallRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFirewallRuleGroup = "CreateFirewallRuleGroup"

// CreateFirewallRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateFirewallRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFirewallRuleGroup for more information on using the CreateFirewallRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFirewallRuleGroupRequest method.
//	req, resp := client.CreateFirewallRuleGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateFirewallRuleGroup
func (c *Route53Resolver) CreateFirewallRuleGroupRequest(input *CreateFirewallRuleGroupInput) (req *request.Request, output *CreateFirewallRuleGroupOutput) {
	op := &request.Operation{
		Name:       opCreateFirewallRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateFirewallRuleGroupInput{}
	}

	output = &CreateFirewallRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFirewallRuleGroup API operation for Amazon Route 53 Resolver.
//
// Creates an empty DNS Firewall rule group for filtering DNS network traffic
// in a VPC. You can add rules to the new rule group by calling CreateFirewallRule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation CreateFirewallRuleGroup for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateFirewallRuleGroup
func (c *Route53Resolver) CreateFirewallRuleGroup(input *CreateFirewallRuleGroupInput) (*CreateFirewallRuleGroupOutput, error) {
	req, out := c.CreateFirewallRuleGroupRequest(input)
	return out, req.Send()
}

// CreateFirewallRuleGroupWithContext is the same as CreateFirewallRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFirewallRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) CreateFirewallRuleGroupWithContext(ctx aws.Context, input *CreateFirewallRuleGroupInput, opts ...request.Option) (*CreateFirewallRuleGroupOutput, error) {
	req, out := c.CreateFirewallRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateOutpostResolver = "CreateOutpostResolver"

// CreateOutpostResolverRequest generates a "aws/request.Request" representing the
// client's request for the CreateOutpostResolver operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOutpostResolver for more information on using the CreateOutpostResolver
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateOutpostResolverRequest method.
//	req, resp := client.CreateOutpostResolverRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateOutpostResolver
func (c *Route53Resolver) CreateOutpostResolverRequest(input *CreateOutpostResolverInput) (req *request.Request, output *CreateOutpostResolverOutput) {
	op := &request.Operation{
		Name:       opCreateOutpostResolver,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOutpostResolverInput{}
	}

	output = &CreateOutpostResolverOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOutpostResolver API operation for Amazon Route 53 Resolver.
//
// Creates an Route 53 Resolver on an Outpost.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation CreateOutpostResolver for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ServiceQuotaExceededException
//     Fulfilling the request would cause one or more quotas to be exceeded.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateOutpostResolver
func (c *Route53Resolver) CreateOutpostResolver(input *CreateOutpostResolverInput) (*CreateOutpostResolverOutput, error) {
	req, out := c.CreateOutpostResolverRequest(input)
	return out, req.Send()
}

// CreateOutpostResolverWithContext is the same as CreateOutpostResolver with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOutpostResolver for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) CreateOutpostResolverWithContext(ctx aws.Context, input *CreateOutpostResolverInput, opts ...request.Option) (*CreateOutpostResolverOutput, error) {
	req, out := c.CreateOutpostResolverRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResolverEndpoint = "CreateResolverEndpoint"

// CreateResolverEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateResolverEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResolverEndpoint for more information on using the CreateResolverEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateResolverEndpointRequest method.
//	req, resp := client.CreateResolverEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverEndpoint
func (c *Route53Resolver) CreateResolverEndpointRequest(input *CreateResolverEndpointInput) (req *request.Request, output *CreateResolverEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateResolverEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResolverEndpointInput{}
	}

	output = &CreateResolverEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResolverEndpoint API operation for Amazon Route 53 Resolver.
//
// Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound
// and outbound:
//
//   - An inbound Resolver endpoint forwards DNS queries to the DNS service
//     for a VPC from your network.
//
//   - An outbound Resolver endpoint forwards DNS queries from the DNS service
//     for a VPC to your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation CreateResolverEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceExistsException
//     The resource that you tried to create already exists.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverEndpoint
func (c *Route53Resolver) CreateResolverEndpoint(input *CreateResolverEndpointInput) (*CreateResolverEndpointOutput, error) {
	req, out := c.CreateResolverEndpointRequest(input)
	return out, req.Send()
}

// CreateResolverEndpointWithContext is the same as CreateResolverEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResolverEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) CreateResolverEndpointWithContext(ctx aws.Context, input *CreateResolverEndpointInput, opts ...request.Option) (*CreateResolverEndpointOutput, error) {
	req, out := c.CreateResolverEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResolverQueryLogConfig = "CreateResolverQueryLogConfig"

// CreateResolverQueryLogConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateResolverQueryLogConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResolverQueryLogConfig for more information on using the CreateResolverQueryLogConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateResolverQueryLogConfigRequest method.
//	req, resp := client.CreateResolverQueryLogConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverQueryLogConfig
func (c *Route53Resolver) CreateResolverQueryLogConfigRequest(input *CreateResolverQueryLogConfigInput) (req *request.Request, output *CreateResolverQueryLogConfigOutput) {
	op := &request.Operation{
		Name:       opCreateResolverQueryLogConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResolverQueryLogConfigInput{}
	}

	output = &CreateResolverQueryLogConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResolverQueryLogConfig API operation for Amazon Route 53 Resolver.
//
// Creates a Resolver query logging configuration, which defines where you want
// Resolver to save DNS query logs that originate in your VPCs. Resolver can
// log queries only for VPCs that are in the same Region as the query logging
// configuration.
//
// To specify which VPCs you want to log queries for, you use AssociateResolverQueryLogConfig.
// For more information, see AssociateResolverQueryLogConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html).
//
// You can optionally use Resource Access Manager (RAM) to share a query logging
// configuration with other Amazon Web Services accounts. The other accounts
// can then associate VPCs with the configuration. The query logs that Resolver
// creates for a configuration include all DNS queries that originate in all
// VPCs that are associated with the configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation CreateResolverQueryLogConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceExistsException
//     The resource that you tried to create already exists.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverQueryLogConfig
func (c *Route53Resolver) CreateResolverQueryLogConfig(input *CreateResolverQueryLogConfigInput) (*CreateResolverQueryLogConfigOutput, error) {
	req, out := c.CreateResolverQueryLogConfigRequest(input)
	return out, req.Send()
}

// CreateResolverQueryLogConfigWithContext is the same as CreateResolverQueryLogConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResolverQueryLogConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) CreateResolverQueryLogConfigWithContext(ctx aws.Context, input *CreateResolverQueryLogConfigInput, opts ...request.Option) (*CreateResolverQueryLogConfigOutput, error) {
	req, out := c.CreateResolverQueryLogConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResolverRule = "CreateResolverRule"

// CreateResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResolverRule for more information on using the CreateResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateResolverRuleRequest method.
//	req, resp := client.CreateResolverRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverRule
func (c *Route53Resolver) CreateResolverRuleRequest(input *CreateResolverRuleInput) (req *request.Request, output *CreateResolverRuleOutput) {
	op := &request.Operation{
		Name:       opCreateResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResolverRuleInput{}
	}

	output = &CreateResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResolverRule API operation for Amazon Route 53 Resolver.
//
// For DNS queries that originate in your VPCs, specifies which Resolver endpoint
// the queries pass through, one domain name that you want to forward to your
// network, and the IP addresses of the DNS resolvers in your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation CreateResolverRule for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ResourceExistsException
//     The resource that you tried to create already exists.
//
//   - ResourceUnavailableException
//     The specified resource isn't available.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/CreateResolverRule
func (c *Route53Resolver) CreateResolverRule(input *CreateResolverRuleInput) (*CreateResolverRuleOutput, error) {
	req, out := c.CreateResolverRuleRequest(input)
	return out, req.Send()
}

// CreateResolverRuleWithContext is the same as CreateResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) CreateResolverRuleWithContext(ctx aws.Context, input *CreateResolverRuleInput, opts ...request.Option) (*CreateResolverRuleOutput, error) {
	req, out := c.CreateResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFirewallDomainList = "DeleteFirewallDomainList"

// DeleteFirewallDomainListRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFirewallDomainList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFirewallDomainList for more information on using the DeleteFirewallDomainList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFirewallDomainListRequest method.
//	req, resp := client.DeleteFirewallDomainListRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteFirewallDomainList
func (c *Route53Resolver) DeleteFirewallDomainListRequest(input *DeleteFirewallDomainListInput) (req *request.Request, output *DeleteFirewallDomainListOutput) {
	op := &request.Operation{
		Name:       opDeleteFirewallDomainList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFirewallDomainListInput{}
	}

	output = &DeleteFirewallDomainListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFirewallDomainList API operation for Amazon Route 53 Resolver.
//
// Deletes the specified domain list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DeleteFirewallDomainList for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ConflictException
//     The requested state transition isn't valid. For example, you can't delete
//     a firewall domain list if it is in the process of being deleted, or you can't
//     import domains into a domain list that is in the process of being deleted.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteFirewallDomainList
func (c *Route53Resolver) DeleteFirewallDomainList(input *DeleteFirewallDomainListInput) (*DeleteFirewallDomainListOutput, error) {
	req, out := c.DeleteFirewallDomainListRequest(input)
	return out, req.Send()
}

// DeleteFirewallDomainListWithContext is the same as DeleteFirewallDomainList with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFirewallDomainList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DeleteFirewallDomainListWithContext(ctx aws.Context, input *DeleteFirewallDomainListInput, opts ...request.Option) (*DeleteFirewallDomainListOutput, error) {
	req, out := c.DeleteFirewallDomainListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFirewallRule = "DeleteFirewallRule"

// DeleteFirewallRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFirewallRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFirewallRule for more information on using the DeleteFirewallRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFirewallRuleRequest method.
//	req, resp := client.DeleteFirewallRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteFirewallRule
func (c *Route53Resolver) DeleteFirewallRuleRequest(input *DeleteFirewallRuleInput) (req *request.Request, output *DeleteFirewallRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteFirewallRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFirewallRuleInput{}
	}

	output = &DeleteFirewallRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFirewallRule API operation for Amazon Route 53 Resolver.
//
// Deletes the specified firewall rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DeleteFirewallRule for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteFirewallRule
func (c *Route53Resolver) DeleteFirewallRule(input *DeleteFirewallRuleInput) (*DeleteFirewallRuleOutput, error) {
	req, out := c.DeleteFirewallRuleRequest(input)
	return out, req.Send()
}

// DeleteFirewallRuleWithContext is the same as DeleteFirewallRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFirewallRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DeleteFirewallRuleWithContext(ctx aws.Context, input *DeleteFirewallRuleInput, opts ...request.Option) (*DeleteFirewallRuleOutput, error) {
	req, out := c.DeleteFirewallRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFirewallRuleGroup = "DeleteFirewallRuleGroup"

// DeleteFirewallRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFirewallRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFirewallRuleGroup for more information on using the DeleteFirewallRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFirewallRuleGroupRequest method.
//	req, resp := client.DeleteFirewallRuleGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteFirewallRuleGroup
func (c *Route53Resolver) DeleteFirewallRuleGroupRequest(input *DeleteFirewallRuleGroupInput) (req *request.Request, output *DeleteFirewallRuleGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteFirewallRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteFirewallRuleGroupInput{}
	}

	output = &DeleteFirewallRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFirewallRuleGroup API operation for Amazon Route 53 Resolver.
//
// Deletes the specified firewall rule group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DeleteFirewallRuleGroup for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ConflictException
//     The requested state transition isn't valid. For example, you can't delete
//     a firewall domain list if it is in the process of being deleted, or you can't
//     import domains into a domain list that is in the process of being deleted.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteFirewallRuleGroup
func (c *Route53Resolver) DeleteFirewallRuleGroup(input *DeleteFirewallRuleGroupInput) (*DeleteFirewallRuleGroupOutput, error) {
	req, out := c.DeleteFirewallRuleGroupRequest(input)
	return out, req.Send()
}

// DeleteFirewallRuleGroupWithContext is the same as DeleteFirewallRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFirewallRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DeleteFirewallRuleGroupWithContext(ctx aws.Context, input *DeleteFirewallRuleGroupInput, opts ...request.Option) (*DeleteFirewallRuleGroupOutput, error) {
	req, out := c.DeleteFirewallRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteOutpostResolver = "DeleteOutpostResolver"

// DeleteOutpostResolverRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOutpostResolver operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteOutpostResolver for more information on using the DeleteOutpostResolver
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteOutpostResolverRequest method.
//	req, resp := client.DeleteOutpostResolverRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteOutpostResolver
func (c *Route53Resolver) DeleteOutpostResolverRequest(input *DeleteOutpostResolverInput) (req *request.Request, output *DeleteOutpostResolverOutput) {
	op := &request.Operation{
		Name:       opDeleteOutpostResolver,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOutpostResolverInput{}
	}

	output = &DeleteOutpostResolverOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteOutpostResolver API operation for Amazon Route 53 Resolver.
//
// Deletes a Resolver on the Outpost.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DeleteOutpostResolver for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - ConflictException
//     The requested state transition isn't valid. For example, you can't delete
//     a firewall domain list if it is in the process of being deleted, or you can't
//     import domains into a domain list that is in the process of being deleted.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteOutpostResolver
func (c *Route53Resolver) DeleteOutpostResolver(input *DeleteOutpostResolverInput) (*DeleteOutpostResolverOutput, error) {
	req, out := c.DeleteOutpostResolverRequest(input)
	return out, req.Send()
}

// DeleteOutpostResolverWithContext is the same as DeleteOutpostResolver with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteOutpostResolver for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DeleteOutpostResolverWithContext(ctx aws.Context, input *DeleteOutpostResolverInput, opts ...request.Option) (*DeleteOutpostResolverOutput, error) {
	req, out := c.DeleteOutpostResolverRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResolverEndpoint = "DeleteResolverEndpoint"

// DeleteResolverEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResolverEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResolverEndpoint for more information on using the DeleteResolverEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResolverEndpointRequest method.
//	req, resp := client.DeleteResolverEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverEndpoint
func (c *Route53Resolver) DeleteResolverEndpointRequest(input *DeleteResolverEndpointInput) (req *request.Request, output *DeleteResolverEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteResolverEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResolverEndpointInput{}
	}

	output = &DeleteResolverEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResolverEndpoint API operation for Amazon Route 53 Resolver.
//
// Deletes a Resolver endpoint. The effect of deleting a Resolver endpoint depends
// on whether it's an inbound or an outbound Resolver endpoint:
//
//   - Inbound: DNS queries from your network are no longer routed to the DNS
//     service for the specified VPC.
//
//   - Outbound: DNS queries from a VPC are no longer routed to your network.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DeleteResolverEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverEndpoint
func (c *Route53Resolver) DeleteResolverEndpoint(input *DeleteResolverEndpointInput) (*DeleteResolverEndpointOutput, error) {
	req, out := c.DeleteResolverEndpointRequest(input)
	return out, req.Send()
}

// DeleteResolverEndpointWithContext is the same as DeleteResolverEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResolverEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DeleteResolverEndpointWithContext(ctx aws.Context, input *DeleteResolverEndpointInput, opts ...request.Option) (*DeleteResolverEndpointOutput, error) {
	req, out := c.DeleteResolverEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResolverQueryLogConfig = "DeleteResolverQueryLogConfig"

// DeleteResolverQueryLogConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResolverQueryLogConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResolverQueryLogConfig for more information on using the DeleteResolverQueryLogConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResolverQueryLogConfigRequest method.
//	req, resp := client.DeleteResolverQueryLogConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverQueryLogConfig
func (c *Route53Resolver) DeleteResolverQueryLogConfigRequest(input *DeleteResolverQueryLogConfigInput) (req *request.Request, output *DeleteResolverQueryLogConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteResolverQueryLogConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResolverQueryLogConfigInput{}
	}

	output = &DeleteResolverQueryLogConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResolverQueryLogConfig API operation for Amazon Route 53 Resolver.
//
// Deletes a query logging configuration. When you delete a configuration, Resolver
// stops logging DNS queries for all of the Amazon VPCs that are associated
// with the configuration. This also applies if the query logging configuration
// is shared with other Amazon Web Services accounts, and the other accounts
// have associated VPCs with the shared configuration.
//
// Before you can delete a query logging configuration, you must first disassociate
// all VPCs from the configuration. See DisassociateResolverQueryLogConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html).
//
// If you used Resource Access Manager (RAM) to share a query logging configuration
// with other accounts, you must stop sharing the configuration before you can
// delete a configuration. The accounts that you shared the configuration with
// can first disassociate VPCs that they associated with the configuration,
// but that's not necessary. If you stop sharing the configuration, those VPCs
// are automatically disassociated from the configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DeleteResolverQueryLogConfig for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverQueryLogConfig
func (c *Route53Resolver) DeleteResolverQueryLogConfig(input *DeleteResolverQueryLogConfigInput) (*DeleteResolverQueryLogConfigOutput, error) {
	req, out := c.DeleteResolverQueryLogConfigRequest(input)
	return out, req.Send()
}

// DeleteResolverQueryLogConfigWithContext is the same as DeleteResolverQueryLogConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResolverQueryLogConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DeleteResolverQueryLogConfigWithContext(ctx aws.Context, input *DeleteResolverQueryLogConfigInput, opts ...request.Option) (*DeleteResolverQueryLogConfigOutput, error) {
	req, out := c.DeleteResolverQueryLogConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResolverRule = "DeleteResolverRule"

// DeleteResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResolverRule for more information on using the DeleteResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResolverRuleRequest method.
//	req, resp := client.DeleteResolverRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverRule
func (c *Route53Resolver) DeleteResolverRuleRequest(input *DeleteResolverRuleInput) (req *request.Request, output *DeleteResolverRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResolverRuleInput{}
	}

	output = &DeleteResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteResolverRule API operation for Amazon Route 53 Resolver.
//
// Deletes a Resolver rule. Before you can delete a Resolver rule, you must
// disassociate it from all the VPCs that you associated the Resolver rule with.
// For more information, see DisassociateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DeleteResolverRule for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ResourceInUseException
//     The resource that you tried to update or delete is currently in use.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DeleteResolverRule
func (c *Route53Resolver) DeleteResolverRule(input *DeleteResolverRuleInput) (*DeleteResolverRuleOutput, error) {
	req, out := c.DeleteResolverRuleRequest(input)
	return out, req.Send()
}

// DeleteResolverRuleWithContext is the same as DeleteResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DeleteResolverRuleWithContext(ctx aws.Context, input *DeleteResolverRuleInput, opts ...request.Option) (*DeleteResolverRuleOutput, error) {
	req, out := c.DeleteResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateFirewallRuleGroup = "DisassociateFirewallRuleGroup"

// DisassociateFirewallRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateFirewallRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateFirewallRuleGroup for more information on using the DisassociateFirewallRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateFirewallRuleGroupRequest method.
//	req, resp := client.DisassociateFirewallRuleGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateFirewallRuleGroup
func (c *Route53Resolver) DisassociateFirewallRuleGroupRequest(input *DisassociateFirewallRuleGroupInput) (req *request.Request, output *DisassociateFirewallRuleGroupOutput) {
	op := &request.Operation{
		Name:       opDisassociateFirewallRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateFirewallRuleGroupInput{}
	}

	output = &DisassociateFirewallRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateFirewallRuleGroup API operation for Amazon Route 53 Resolver.
//
// Disassociates a FirewallRuleGroup from a VPC, to remove DNS filtering from
// the VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DisassociateFirewallRuleGroup for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - ConflictException
//     The requested state transition isn't valid. For example, you can't delete
//     a firewall domain list if it is in the process of being deleted, or you can't
//     import domains into a domain list that is in the process of being deleted.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateFirewallRuleGroup
func (c *Route53Resolver) DisassociateFirewallRuleGroup(input *DisassociateFirewallRuleGroupInput) (*DisassociateFirewallRuleGroupOutput, error) {
	req, out := c.DisassociateFirewallRuleGroupRequest(input)
	return out, req.Send()
}

// DisassociateFirewallRuleGroupWithContext is the same as DisassociateFirewallRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateFirewallRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DisassociateFirewallRuleGroupWithContext(ctx aws.Context, input *DisassociateFirewallRuleGroupInput, opts ...request.Option) (*DisassociateFirewallRuleGroupOutput, error) {
	req, out := c.DisassociateFirewallRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateResolverEndpointIpAddress = "DisassociateResolverEndpointIpAddress"

// DisassociateResolverEndpointIpAddressRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateResolverEndpointIpAddress operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateResolverEndpointIpAddress for more information on using the DisassociateResolverEndpointIpAddress
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateResolverEndpointIpAddressRequest method.
//	req, resp := client.DisassociateResolverEndpointIpAddressRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverEndpointIpAddress
func (c *Route53Resolver) DisassociateResolverEndpointIpAddressRequest(input *DisassociateResolverEndpointIpAddressInput) (req *request.Request, output *DisassociateResolverEndpointIpAddressOutput) {
	op := &request.Operation{
		Name:       opDisassociateResolverEndpointIpAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateResolverEndpointIpAddressInput{}
	}

	output = &DisassociateResolverEndpointIpAddressOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateResolverEndpointIpAddress API operation for Amazon Route 53 Resolver.
//
// Removes IP addresses from an inbound or an outbound Resolver endpoint. If
// you want to remove more than one IP address, submit one DisassociateResolverEndpointIpAddress
// request for each IP address.
//
// To add an IP address to an endpoint, see AssociateResolverEndpointIpAddress
// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverEndpointIpAddress.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DisassociateResolverEndpointIpAddress for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - ResourceExistsException
//     The resource that you tried to create already exists.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverEndpointIpAddress
func (c *Route53Resolver) DisassociateResolverEndpointIpAddress(input *DisassociateResolverEndpointIpAddressInput) (*DisassociateResolverEndpointIpAddressOutput, error) {
	req, out := c.DisassociateResolverEndpointIpAddressRequest(input)
	return out, req.Send()
}

// DisassociateResolverEndpointIpAddressWithContext is the same as DisassociateResolverEndpointIpAddress with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateResolverEndpointIpAddress for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DisassociateResolverEndpointIpAddressWithContext(ctx aws.Context, input *DisassociateResolverEndpointIpAddressInput, opts ...request.Option) (*DisassociateResolverEndpointIpAddressOutput, error) {
	req, out := c.DisassociateResolverEndpointIpAddressRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateResolverQueryLogConfig = "DisassociateResolverQueryLogConfig"

// DisassociateResolverQueryLogConfigRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateResolverQueryLogConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateResolverQueryLogConfig for more information on using the DisassociateResolverQueryLogConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateResolverQueryLogConfigRequest method.
//	req, resp := client.DisassociateResolverQueryLogConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverQueryLogConfig
func (c *Route53Resolver) DisassociateResolverQueryLogConfigRequest(input *DisassociateResolverQueryLogConfigInput) (req *request.Request, output *DisassociateResolverQueryLogConfigOutput) {
	op := &request.Operation{
		Name:       opDisassociateResolverQueryLogConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateResolverQueryLogConfigInput{}
	}

	output = &DisassociateResolverQueryLogConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateResolverQueryLogConfig API operation for Amazon Route 53 Resolver.
//
// Disassociates a VPC from a query logging configuration.
//
// Before you can delete a query logging configuration, you must first disassociate
// all VPCs from the configuration. If you used Resource Access Manager (RAM)
// to share a query logging configuration with other accounts, VPCs can be disassociated
// from the configuration in the following ways:
//
//   - The accounts that you shared the configuration with can disassociate
//     VPCs from the configuration.
//
//   - You can stop sharing the configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DisassociateResolverQueryLogConfig for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverQueryLogConfig
func (c *Route53Resolver) DisassociateResolverQueryLogConfig(input *DisassociateResolverQueryLogConfigInput) (*DisassociateResolverQueryLogConfigOutput, error) {
	req, out := c.DisassociateResolverQueryLogConfigRequest(input)
	return out, req.Send()
}

// DisassociateResolverQueryLogConfigWithContext is the same as DisassociateResolverQueryLogConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateResolverQueryLogConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DisassociateResolverQueryLogConfigWithContext(ctx aws.Context, input *DisassociateResolverQueryLogConfigInput, opts ...request.Option) (*DisassociateResolverQueryLogConfigOutput, error) {
	req, out := c.DisassociateResolverQueryLogConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateResolverRule = "DisassociateResolverRule"

// DisassociateResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateResolverRule for more information on using the DisassociateResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateResolverRuleRequest method.
//	req, resp := client.DisassociateResolverRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverRule
func (c *Route53Resolver) DisassociateResolverRuleRequest(input *DisassociateResolverRuleInput) (req *request.Request, output *DisassociateResolverRuleOutput) {
	op := &request.Operation{
		Name:       opDisassociateResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateResolverRuleInput{}
	}

	output = &DisassociateResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateResolverRule API operation for Amazon Route 53 Resolver.
//
// Removes the association between a specified Resolver rule and a specified
// VPC.
//
// If you disassociate a Resolver rule from a VPC, Resolver stops forwarding
// DNS queries for the domain name that you specified in the Resolver rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation DisassociateResolverRule for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/DisassociateResolverRule
func (c *Route53Resolver) DisassociateResolverRule(input *DisassociateResolverRuleInput) (*DisassociateResolverRuleOutput, error) {
	req, out := c.DisassociateResolverRuleRequest(input)
	return out, req.Send()
}

// DisassociateResolverRuleWithContext is the same as DisassociateResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) DisassociateResolverRuleWithContext(ctx aws.Context, input *DisassociateResolverRuleInput, opts ...request.Option) (*DisassociateResolverRuleOutput, error) {
	req, out := c.DisassociateResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFirewallConfig = "GetFirewallConfig"

// GetFirewallConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetFirewallConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFirewallConfig for more information on using the GetFirewallConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFirewallConfigRequest method.
//	req, resp := client.GetFirewallConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallConfig
func (c *Route53Resolver) GetFirewallConfigRequest(input *GetFirewallConfigInput) (req *request.Request, output *GetFirewallConfigOutput) {
	op := &request.Operation{
		Name:       opGetFirewallConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetFirewallConfigInput{}
	}

	output = &GetFirewallConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFirewallConfig API operation for Amazon Route 53 Resolver.
//
// Retrieves the configuration of the firewall behavior provided by DNS Firewall
// for a single VPC from Amazon Virtual Private Cloud (Amazon VPC).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetFirewallConfig for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallConfig
func (c *Route53Resolver) GetFirewallConfig(input *GetFirewallConfigInput) (*GetFirewallConfigOutput, error) {
	req, out := c.GetFirewallConfigRequest(input)
	return out, req.Send()
}

// GetFirewallConfigWithContext is the same as GetFirewallConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetFirewallConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetFirewallConfigWithContext(ctx aws.Context, input *GetFirewallConfigInput, opts ...request.Option) (*GetFirewallConfigOutput, error) {
	req, out := c.GetFirewallConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFirewallDomainList = "GetFirewallDomainList"

// GetFirewallDomainListRequest generates a "aws/request.Request" representing the
// client's request for the GetFirewallDomainList operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFirewallDomainList for more information on using the GetFirewallDomainList
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFirewallDomainListRequest method.
//	req, resp := client.GetFirewallDomainListRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallDomainList
func (c *Route53Resolver) GetFirewallDomainListRequest(input *GetFirewallDomainListInput) (req *request.Request, output *GetFirewallDomainListOutput) {
	op := &request.Operation{
		Name:       opGetFirewallDomainList,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetFirewallDomainListInput{}
	}

	output = &GetFirewallDomainListOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFirewallDomainList API operation for Amazon Route 53 Resolver.
//
// Retrieves the specified firewall domain list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetFirewallDomainList for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallDomainList
func (c *Route53Resolver) GetFirewallDomainList(input *GetFirewallDomainListInput) (*GetFirewallDomainListOutput, error) {
	req, out := c.GetFirewallDomainListRequest(input)
	return out, req.Send()
}

// GetFirewallDomainListWithContext is the same as GetFirewallDomainList with the addition of
// the ability to pass a context and additional request options.
//
// See GetFirewallDomainList for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetFirewallDomainListWithContext(ctx aws.Context, input *GetFirewallDomainListInput, opts ...request.Option) (*GetFirewallDomainListOutput, error) {
	req, out := c.GetFirewallDomainListRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFirewallRuleGroup = "GetFirewallRuleGroup"

// GetFirewallRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetFirewallRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFirewallRuleGroup for more information on using the GetFirewallRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFirewallRuleGroupRequest method.
//	req, resp := client.GetFirewallRuleGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallRuleGroup
func (c *Route53Resolver) GetFirewallRuleGroupRequest(input *GetFirewallRuleGroupInput) (req *request.Request, output *GetFirewallRuleGroupOutput) {
	op := &request.Operation{
		Name:       opGetFirewallRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetFirewallRuleGroupInput{}
	}

	output = &GetFirewallRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFirewallRuleGroup API operation for Amazon Route 53 Resolver.
//
// Retrieves the specified firewall rule group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetFirewallRuleGroup for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallRuleGroup
func (c *Route53Resolver) GetFirewallRuleGroup(input *GetFirewallRuleGroupInput) (*GetFirewallRuleGroupOutput, error) {
	req, out := c.GetFirewallRuleGroupRequest(input)
	return out, req.Send()
}

// GetFirewallRuleGroupWithContext is the same as GetFirewallRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetFirewallRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetFirewallRuleGroupWithContext(ctx aws.Context, input *GetFirewallRuleGroupInput, opts ...request.Option) (*GetFirewallRuleGroupOutput, error) {
	req, out := c.GetFirewallRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFirewallRuleGroupAssociation = "GetFirewallRuleGroupAssociation"

// GetFirewallRuleGroupAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetFirewallRuleGroupAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFirewallRuleGroupAssociation for more information on using the GetFirewallRuleGroupAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFirewallRuleGroupAssociationRequest method.
//	req, resp := client.GetFirewallRuleGroupAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallRuleGroupAssociation
func (c *Route53Resolver) GetFirewallRuleGroupAssociationRequest(input *GetFirewallRuleGroupAssociationInput) (req *request.Request, output *GetFirewallRuleGroupAssociationOutput) {
	op := &request.Operation{
		Name:       opGetFirewallRuleGroupAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetFirewallRuleGroupAssociationInput{}
	}

	output = &GetFirewallRuleGroupAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFirewallRuleGroupAssociation API operation for Amazon Route 53 Resolver.
//
// Retrieves a firewall rule group association, which enables DNS filtering
// for a VPC with one rule group. A VPC can have more than one firewall rule
// group association, and a rule group can be associated with more than one
// VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetFirewallRuleGroupAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallRuleGroupAssociation
func (c *Route53Resolver) GetFirewallRuleGroupAssociation(input *GetFirewallRuleGroupAssociationInput) (*GetFirewallRuleGroupAssociationOutput, error) {
	req, out := c.GetFirewallRuleGroupAssociationRequest(input)
	return out, req.Send()
}

// GetFirewallRuleGroupAssociationWithContext is the same as GetFirewallRuleGroupAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetFirewallRuleGroupAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetFirewallRuleGroupAssociationWithContext(ctx aws.Context, input *GetFirewallRuleGroupAssociationInput, opts ...request.Option) (*GetFirewallRuleGroupAssociationOutput, error) {
	req, out := c.GetFirewallRuleGroupAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFirewallRuleGroupPolicy = "GetFirewallRuleGroupPolicy"

// GetFirewallRuleGroupPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetFirewallRuleGroupPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFirewallRuleGroupPolicy for more information on using the GetFirewallRuleGroupPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFirewallRuleGroupPolicyRequest method.
//	req, resp := client.GetFirewallRuleGroupPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallRuleGroupPolicy
func (c *Route53Resolver) GetFirewallRuleGroupPolicyRequest(input *GetFirewallRuleGroupPolicyInput) (req *request.Request, output *GetFirewallRuleGroupPolicyOutput) {
	op := &request.Operation{
		Name:       opGetFirewallRuleGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetFirewallRuleGroupPolicyInput{}
	}

	output = &GetFirewallRuleGroupPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFirewallRuleGroupPolicy API operation for Amazon Route 53 Resolver.
//
// Returns the Identity and Access Management (Amazon Web Services IAM) policy
// for sharing the specified rule group. You can use the policy to share the
// rule group using Resource Access Manager (RAM).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetFirewallRuleGroupPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetFirewallRuleGroupPolicy
func (c *Route53Resolver) GetFirewallRuleGroupPolicy(input *GetFirewallRuleGroupPolicyInput) (*GetFirewallRuleGroupPolicyOutput, error) {
	req, out := c.GetFirewallRuleGroupPolicyRequest(input)
	return out, req.Send()
}

// GetFirewallRuleGroupPolicyWithContext is the same as GetFirewallRuleGroupPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetFirewallRuleGroupPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetFirewallRuleGroupPolicyWithContext(ctx aws.Context, input *GetFirewallRuleGroupPolicyInput, opts ...request.Option) (*GetFirewallRuleGroupPolicyOutput, error) {
	req, out := c.GetFirewallRuleGroupPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOutpostResolver = "GetOutpostResolver"

// GetOutpostResolverRequest generates a "aws/request.Request" representing the
// client's request for the GetOutpostResolver operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOutpostResolver for more information on using the GetOutpostResolver
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetOutpostResolverRequest method.
//	req, resp := client.GetOutpostResolverRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetOutpostResolver
func (c *Route53Resolver) GetOutpostResolverRequest(input *GetOutpostResolverInput) (req *request.Request, output *GetOutpostResolverOutput) {
	op := &request.Operation{
		Name:       opGetOutpostResolver,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOutpostResolverInput{}
	}

	output = &GetOutpostResolverOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOutpostResolver API operation for Amazon Route 53 Resolver.
//
// Gets information about a specified Resolver on the Outpost, such as its instance
// count and type, name, and the current status of the Resolver.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetOutpostResolver for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetOutpostResolver
func (c *Route53Resolver) GetOutpostResolver(input *GetOutpostResolverInput) (*GetOutpostResolverOutput, error) {
	req, out := c.GetOutpostResolverRequest(input)
	return out, req.Send()
}

// GetOutpostResolverWithContext is the same as GetOutpostResolver with the addition of
// the ability to pass a context and additional request options.
//
// See GetOutpostResolver for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetOutpostResolverWithContext(ctx aws.Context, input *GetOutpostResolverInput, opts ...request.Option) (*GetOutpostResolverOutput, error) {
	req, out := c.GetOutpostResolverRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverConfig = "GetResolverConfig"

// GetResolverConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverConfig for more information on using the GetResolverConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResolverConfigRequest method.
//	req, resp := client.GetResolverConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverConfig
func (c *Route53Resolver) GetResolverConfigRequest(input *GetResolverConfigInput) (req *request.Request, output *GetResolverConfigOutput) {
	op := &request.Operation{
		Name:       opGetResolverConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverConfigInput{}
	}

	output = &GetResolverConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverConfig API operation for Amazon Route 53 Resolver.
//
// Retrieves the behavior configuration of Route 53 Resolver behavior for a
// single VPC from Amazon Virtual Private Cloud.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverConfig for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverConfig
func (c *Route53Resolver) GetResolverConfig(input *GetResolverConfigInput) (*GetResolverConfigOutput, error) {
	req, out := c.GetResolverConfigRequest(input)
	return out, req.Send()
}

// GetResolverConfigWithContext is the same as GetResolverConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverConfigWithContext(ctx aws.Context, input *GetResolverConfigInput, opts ...request.Option) (*GetResolverConfigOutput, error) {
	req, out := c.GetResolverConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverDnssecConfig = "GetResolverDnssecConfig"

// GetResolverDnssecConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverDnssecConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverDnssecConfig for more information on using the GetResolverDnssecConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResolverDnssecConfigRequest method.
//	req, resp := client.GetResolverDnssecConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverDnssecConfig
func (c *Route53Resolver) GetResolverDnssecConfigRequest(input *GetResolverDnssecConfigInput) (req *request.Request, output *GetResolverDnssecConfigOutput) {
	op := &request.Operation{
		Name:       opGetResolverDnssecConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverDnssecConfigInput{}
	}

	output = &GetResolverDnssecConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverDnssecConfig API operation for Amazon Route 53 Resolver.
//
// Gets DNSSEC validation information for a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverDnssecConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverDnssecConfig
func (c *Route53Resolver) GetResolverDnssecConfig(input *GetResolverDnssecConfigInput) (*GetResolverDnssecConfigOutput, error) {
	req, out := c.GetResolverDnssecConfigRequest(input)
	return out, req.Send()
}

// GetResolverDnssecConfigWithContext is the same as GetResolverDnssecConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverDnssecConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverDnssecConfigWithContext(ctx aws.Context, input *GetResolverDnssecConfigInput, opts ...request.Option) (*GetResolverDnssecConfigOutput, error) {
	req, out := c.GetResolverDnssecConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverEndpoint = "GetResolverEndpoint"

// GetResolverEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverEndpoint for more information on using the GetResolverEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResolverEndpointRequest method.
//	req, resp := client.GetResolverEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverEndpoint
func (c *Route53Resolver) GetResolverEndpointRequest(input *GetResolverEndpointInput) (req *request.Request, output *GetResolverEndpointOutput) {
	op := &request.Operation{
		Name:       opGetResolverEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverEndpointInput{}
	}

	output = &GetResolverEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverEndpoint API operation for Amazon Route 53 Resolver.
//
// Gets information about a specified Resolver endpoint, such as whether it's
// an inbound or an outbound Resolver endpoint, and the current status of the
// endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverEndpoint
func (c *Route53Resolver) GetResolverEndpoint(input *GetResolverEndpointInput) (*GetResolverEndpointOutput, error) {
	req, out := c.GetResolverEndpointRequest(input)
	return out, req.Send()
}

// GetResolverEndpointWithContext is the same as GetResolverEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverEndpointWithContext(ctx aws.Context, input *GetResolverEndpointInput, opts ...request.Option) (*GetResolverEndpointOutput, error) {
	req, out := c.GetResolverEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverQueryLogConfig = "GetResolverQueryLogConfig"

// GetResolverQueryLogConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverQueryLogConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverQueryLogConfig for more information on using the GetResolverQueryLogConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResolverQueryLogConfigRequest method.
//	req, resp := client.GetResolverQueryLogConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfig
func (c *Route53Resolver) GetResolverQueryLogConfigRequest(input *GetResolverQueryLogConfigInput) (req *request.Request, output *GetResolverQueryLogConfigOutput) {
	op := &request.Operation{
		Name:       opGetResolverQueryLogConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverQueryLogConfigInput{}
	}

	output = &GetResolverQueryLogConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverQueryLogConfig API operation for Amazon Route 53 Resolver.
//
// Gets information about a specified Resolver query logging configuration,
// such as the number of VPCs that the configuration is logging queries for
// and the location that logs are sent to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverQueryLogConfig for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfig
func (c *Route53Resolver) GetResolverQueryLogConfig(input *GetResolverQueryLogConfigInput) (*GetResolverQueryLogConfigOutput, error) {
	req, out := c.GetResolverQueryLogConfigRequest(input)
	return out, req.Send()
}

// GetResolverQueryLogConfigWithContext is the same as GetResolverQueryLogConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverQueryLogConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverQueryLogConfigWithContext(ctx aws.Context, input *GetResolverQueryLogConfigInput, opts ...request.Option) (*GetResolverQueryLogConfigOutput, error) {
	req, out := c.GetResolverQueryLogConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverQueryLogConfigAssociation = "GetResolverQueryLogConfigAssociation"

// GetResolverQueryLogConfigAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverQueryLogConfigAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverQueryLogConfigAssociation for more information on using the GetResolverQueryLogConfigAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResolverQueryLogConfigAssociationRequest method.
//	req, resp := client.GetResolverQueryLogConfigAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigAssociation
func (c *Route53Resolver) GetResolverQueryLogConfigAssociationRequest(input *GetResolverQueryLogConfigAssociationInput) (req *request.Request, output *GetResolverQueryLogConfigAssociationOutput) {
	op := &request.Operation{
		Name:       opGetResolverQueryLogConfigAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverQueryLogConfigAssociationInput{}
	}

	output = &GetResolverQueryLogConfigAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverQueryLogConfigAssociation API operation for Amazon Route 53 Resolver.
//
// Gets information about a specified association between a Resolver query logging
// configuration and an Amazon VPC. When you associate a VPC with a query logging
// configuration, Resolver logs DNS queries that originate in that VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverQueryLogConfigAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigAssociation
func (c *Route53Resolver) GetResolverQueryLogConfigAssociation(input *GetResolverQueryLogConfigAssociationInput) (*GetResolverQueryLogConfigAssociationOutput, error) {
	req, out := c.GetResolverQueryLogConfigAssociationRequest(input)
	return out, req.Send()
}

// GetResolverQueryLogConfigAssociationWithContext is the same as GetResolverQueryLogConfigAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverQueryLogConfigAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverQueryLogConfigAssociationWithContext(ctx aws.Context, input *GetResolverQueryLogConfigAssociationInput, opts ...request.Option) (*GetResolverQueryLogConfigAssociationOutput, error) {
	req, out := c.GetResolverQueryLogConfigAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverQueryLogConfigPolicy = "GetResolverQueryLogConfigPolicy"

// GetResolverQueryLogConfigPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverQueryLogConfigPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverQueryLogConfigPolicy for more information on using the GetResolverQueryLogConfigPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResolverQueryLogConfigPolicyRequest method.
//	req, resp := client.GetResolverQueryLogConfigPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigPolicy
func (c *Route53Resolver) GetResolverQueryLogConfigPolicyRequest(input *GetResolverQueryLogConfigPolicyInput) (req *request.Request, output *GetResolverQueryLogConfigPolicyOutput) {
	op := &request.Operation{
		Name:       opGetResolverQueryLogConfigPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverQueryLogConfigPolicyInput{}
	}

	output = &GetResolverQueryLogConfigPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverQueryLogConfigPolicy API operation for Amazon Route 53 Resolver.
//
// Gets information about a query logging policy. A query logging policy specifies
// the Resolver query logging operations and resources that you want to allow
// another Amazon Web Services account to be able to use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverQueryLogConfigPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - UnknownResourceException
//     The specified resource doesn't exist.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverQueryLogConfigPolicy
func (c *Route53Resolver) GetResolverQueryLogConfigPolicy(input *GetResolverQueryLogConfigPolicyInput) (*GetResolverQueryLogConfigPolicyOutput, error) {
	req, out := c.GetResolverQueryLogConfigPolicyRequest(input)
	return out, req.Send()
}

// GetResolverQueryLogConfigPolicyWithContext is the same as GetResolverQueryLogConfigPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverQueryLogConfigPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverQueryLogConfigPolicyWithContext(ctx aws.Context, input *GetResolverQueryLogConfigPolicyInput, opts ...request.Option) (*GetResolverQueryLogConfigPolicyOutput, error) {
	req, out := c.GetResolverQueryLogConfigPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverRule = "GetResolverRule"

// GetResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverRule for more information on using the GetResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResolverRuleRequest method.
//	req, resp := client.GetResolverRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRule
func (c *Route53Resolver) GetResolverRuleRequest(input *GetResolverRuleInput) (req *request.Request, output *GetResolverRuleOutput) {
	op := &request.Operation{
		Name:       opGetResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverRuleInput{}
	}

	output = &GetResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverRule API operation for Amazon Route 53 Resolver.
//
// Gets information about a specified Resolver rule, such as the domain name
// that the rule forwards DNS queries for and the ID of the outbound Resolver
// endpoint that the rule is associated with.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverRule for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRule
func (c *Route53Resolver) GetResolverRule(input *GetResolverRuleInput) (*GetResolverRuleOutput, error) {
	req, out := c.GetResolverRuleRequest(input)
	return out, req.Send()
}

// GetResolverRuleWithContext is the same as GetResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverRuleWithContext(ctx aws.Context, input *GetResolverRuleInput, opts ...request.Option) (*GetResolverRuleOutput, error) {
	req, out := c.GetResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverRuleAssociation = "GetResolverRuleAssociation"

// GetResolverRuleAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverRuleAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverRuleAssociation for more information on using the GetResolverRuleAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResolverRuleAssociationRequest method.
//	req, resp := client.GetResolverRuleAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRuleAssociation
func (c *Route53Resolver) GetResolverRuleAssociationRequest(input *GetResolverRuleAssociationInput) (req *request.Request, output *GetResolverRuleAssociationOutput) {
	op := &request.Operation{
		Name:       opGetResolverRuleAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverRuleAssociationInput{}
	}

	output = &GetResolverRuleAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverRuleAssociation API operation for Amazon Route 53 Resolver.
//
// Gets information about an association between a specified Resolver rule and
// a VPC. You associate a Resolver rule and a VPC using AssociateResolverRule
// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverRuleAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRuleAssociation
func (c *Route53Resolver) GetResolverRuleAssociation(input *GetResolverRuleAssociationInput) (*GetResolverRuleAssociationOutput, error) {
	req, out := c.GetResolverRuleAssociationRequest(input)
	return out, req.Send()
}

// GetResolverRuleAssociationWithContext is the same as GetResolverRuleAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverRuleAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverRuleAssociationWithContext(ctx aws.Context, input *GetResolverRuleAssociationInput, opts ...request.Option) (*GetResolverRuleAssociationOutput, error) {
	req, out := c.GetResolverRuleAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResolverRulePolicy = "GetResolverRulePolicy"

// GetResolverRulePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetResolverRulePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResolverRulePolicy for more information on using the GetResolverRulePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResolverRulePolicyRequest method.
//	req, resp := client.GetResolverRulePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRulePolicy
func (c *Route53Resolver) GetResolverRulePolicyRequest(input *GetResolverRulePolicyInput) (req *request.Request, output *GetResolverRulePolicyOutput) {
	op := &request.Operation{
		Name:       opGetResolverRulePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverRulePolicyInput{}
	}

	output = &GetResolverRulePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResolverRulePolicy API operation for Amazon Route 53 Resolver.
//
// Gets information about the Resolver rule policy for a specified rule. A Resolver
// rule policy includes the rule that you want to share with another account,
// the account that you want to share the rule with, and the Resolver operations
// that you want to allow the account to use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation GetResolverRulePolicy for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - UnknownResourceException
//     The specified resource doesn't exist.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRulePolicy
func (c *Route53Resolver) GetResolverRulePolicy(input *GetResolverRulePolicyInput) (*GetResolverRulePolicyOutput, error) {
	req, out := c.GetResolverRulePolicyRequest(input)
	return out, req.Send()
}

// GetResolverRulePolicyWithContext is the same as GetResolverRulePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetResolverRulePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) GetResolverRulePolicyWithContext(ctx aws.Context, input *GetResolverRulePolicyInput, opts ...request.Option) (*GetResolverRulePolicyOutput, error) {
	req, out := c.GetResolverRulePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportFirewallDomains = "ImportFirewallDomains"

// ImportFirewallDomainsRequest generates a "aws/request.Request" representing the
// client's request for the ImportFirewallDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportFirewallDomains for more information on using the ImportFirewallDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ImportFirewallDomainsRequest method.
//	req, resp := client.ImportFirewallDomainsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ImportFirewallDomains
func (c *Route53Resolver) ImportFirewallDomainsRequest(input *ImportFirewallDomainsInput) (req *request.Request, output *ImportFirewallDomainsOutput) {
	op := &request.Operation{
		Name:       opImportFirewallDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportFirewallDomainsInput{}
	}

	output = &ImportFirewallDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportFirewallDomains API operation for Amazon Route 53 Resolver.
//
// Imports domain names from a file into a domain list, for use in a DNS firewall
// rule group.
//
// Each domain specification in your domain list must satisfy the following
// requirements:
//
//   - It can optionally start with * (asterisk).
//
//   - With the exception of the optional starting asterisk, it must only contain
//     the following characters: A-Z, a-z, 0-9, - (hyphen).
//
//   - It must be from 1-255 characters in length.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ImportFirewallDomains for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - ConflictException
//     The requested state transition isn't valid. For example, you can't delete
//     a firewall domain list if it is in the process of being deleted, or you can't
//     import domains into a domain list that is in the process of being deleted.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ImportFirewallDomains
func (c *Route53Resolver) ImportFirewallDomains(input *ImportFirewallDomainsInput) (*ImportFirewallDomainsOutput, error) {
	req, out := c.ImportFirewallDomainsRequest(input)
	return out, req.Send()
}

// ImportFirewallDomainsWithContext is the same as ImportFirewallDomains with the addition of
// the ability to pass a context and additional request options.
//
// See ImportFirewallDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ImportFirewallDomainsWithContext(ctx aws.Context, input *ImportFirewallDomainsInput, opts ...request.Option) (*ImportFirewallDomainsOutput, error) {
	req, out := c.ImportFirewallDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListFirewallConfigs = "ListFirewallConfigs"

// ListFirewallConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListFirewallConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFirewallConfigs for more information on using the ListFirewallConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFirewallConfigsRequest method.
//	req, resp := client.ListFirewallConfigsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallConfigs
func (c *Route53Resolver) ListFirewallConfigsRequest(input *ListFirewallConfigsInput) (req *request.Request, output *ListFirewallConfigsOutput) {
	op := &request.Operation{
		Name:       opListFirewallConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFirewallConfigsInput{}
	}

	output = &ListFirewallConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFirewallConfigs API operation for Amazon Route 53 Resolver.
//
// Retrieves the firewall configurations that you have defined. DNS Firewall
// uses the configurations to manage firewall behavior for your VPCs.
//
// A single call might return only a partial list of the configurations. For
// information, see MaxResults.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListFirewallConfigs for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallConfigs
func (c *Route53Resolver) ListFirewallConfigs(input *ListFirewallConfigsInput) (*ListFirewallConfigsOutput, error) {
	req, out := c.ListFirewallConfigsRequest(input)
	return out, req.Send()
}

// ListFirewallConfigsWithContext is the same as ListFirewallConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListFirewallConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListFirewallConfigsWithContext(ctx aws.Context, input *ListFirewallConfigsInput, opts ...request.Option) (*ListFirewallConfigsOutput, error) {
	req, out := c.ListFirewallConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFirewallConfigsPages iterates over the pages of a ListFirewallConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFirewallConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFirewallConfigs operation.
//	pageNum := 0
//	err := client.ListFirewallConfigsPages(params,
//	    func(page *route53resolver.ListFirewallConfigsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListFirewallConfigsPages(input *ListFirewallConfigsInput, fn func(*ListFirewallConfigsOutput, bool) bool) error {
	return c.ListFirewallConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFirewallConfigsPagesWithContext same as ListFirewallConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListFirewallConfigsPagesWithContext(ctx aws.Context, input *ListFirewallConfigsInput, fn func(*ListFirewallConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFirewallConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFirewallConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFirewallConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFirewallDomainLists = "ListFirewallDomainLists"

// ListFirewallDomainListsRequest generates a "aws/request.Request" representing the
// client's request for the ListFirewallDomainLists operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFirewallDomainLists for more information on using the ListFirewallDomainLists
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFirewallDomainListsRequest method.
//	req, resp := client.ListFirewallDomainListsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallDomainLists
func (c *Route53Resolver) ListFirewallDomainListsRequest(input *ListFirewallDomainListsInput) (req *request.Request, output *ListFirewallDomainListsOutput) {
	op := &request.Operation{
		Name:       opListFirewallDomainLists,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFirewallDomainListsInput{}
	}

	output = &ListFirewallDomainListsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFirewallDomainLists API operation for Amazon Route 53 Resolver.
//
// Retrieves the firewall domain lists that you have defined. For each firewall
// domain list, you can retrieve the domains that are defined for a list by
// calling ListFirewallDomains.
//
// A single call to this list operation might return only a partial list of
// the domain lists. For information, see MaxResults.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListFirewallDomainLists for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallDomainLists
func (c *Route53Resolver) ListFirewallDomainLists(input *ListFirewallDomainListsInput) (*ListFirewallDomainListsOutput, error) {
	req, out := c.ListFirewallDomainListsRequest(input)
	return out, req.Send()
}

// ListFirewallDomainListsWithContext is the same as ListFirewallDomainLists with the addition of
// the ability to pass a context and additional request options.
//
// See ListFirewallDomainLists for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListFirewallDomainListsWithContext(ctx aws.Context, input *ListFirewallDomainListsInput, opts ...request.Option) (*ListFirewallDomainListsOutput, error) {
	req, out := c.ListFirewallDomainListsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFirewallDomainListsPages iterates over the pages of a ListFirewallDomainLists operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFirewallDomainLists method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFirewallDomainLists operation.
//	pageNum := 0
//	err := client.ListFirewallDomainListsPages(params,
//	    func(page *route53resolver.ListFirewallDomainListsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListFirewallDomainListsPages(input *ListFirewallDomainListsInput, fn func(*ListFirewallDomainListsOutput, bool) bool) error {
	return c.ListFirewallDomainListsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFirewallDomainListsPagesWithContext same as ListFirewallDomainListsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListFirewallDomainListsPagesWithContext(ctx aws.Context, input *ListFirewallDomainListsInput, fn func(*ListFirewallDomainListsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFirewallDomainListsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFirewallDomainListsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFirewallDomainListsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFirewallDomains = "ListFirewallDomains"

// ListFirewallDomainsRequest generates a "aws/request.Request" representing the
// client's request for the ListFirewallDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFirewallDomains for more information on using the ListFirewallDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFirewallDomainsRequest method.
//	req, resp := client.ListFirewallDomainsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallDomains
func (c *Route53Resolver) ListFirewallDomainsRequest(input *ListFirewallDomainsInput) (req *request.Request, output *ListFirewallDomainsOutput) {
	op := &request.Operation{
		Name:       opListFirewallDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFirewallDomainsInput{}
	}

	output = &ListFirewallDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFirewallDomains API operation for Amazon Route 53 Resolver.
//
// Retrieves the domains that you have defined for the specified firewall domain
// list.
//
// A single call might return only a partial list of the domains. For information,
// see MaxResults.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListFirewallDomains for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallDomains
func (c *Route53Resolver) ListFirewallDomains(input *ListFirewallDomainsInput) (*ListFirewallDomainsOutput, error) {
	req, out := c.ListFirewallDomainsRequest(input)
	return out, req.Send()
}

// ListFirewallDomainsWithContext is the same as ListFirewallDomains with the addition of
// the ability to pass a context and additional request options.
//
// See ListFirewallDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListFirewallDomainsWithContext(ctx aws.Context, input *ListFirewallDomainsInput, opts ...request.Option) (*ListFirewallDomainsOutput, error) {
	req, out := c.ListFirewallDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFirewallDomainsPages iterates over the pages of a ListFirewallDomains operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFirewallDomains method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFirewallDomains operation.
//	pageNum := 0
//	err := client.ListFirewallDomainsPages(params,
//	    func(page *route53resolver.ListFirewallDomainsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListFirewallDomainsPages(input *ListFirewallDomainsInput, fn func(*ListFirewallDomainsOutput, bool) bool) error {
	return c.ListFirewallDomainsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFirewallDomainsPagesWithContext same as ListFirewallDomainsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListFirewallDomainsPagesWithContext(ctx aws.Context, input *ListFirewallDomainsInput, fn func(*ListFirewallDomainsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFirewallDomainsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFirewallDomainsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFirewallDomainsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFirewallRuleGroupAssociations = "ListFirewallRuleGroupAssociations"

// ListFirewallRuleGroupAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListFirewallRuleGroupAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFirewallRuleGroupAssociations for more information on using the ListFirewallRuleGroupAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFirewallRuleGroupAssociationsRequest method.
//	req, resp := client.ListFirewallRuleGroupAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRuleGroupAssociations
func (c *Route53Resolver) ListFirewallRuleGroupAssociationsRequest(input *ListFirewallRuleGroupAssociationsInput) (req *request.Request, output *ListFirewallRuleGroupAssociationsOutput) {
	op := &request.Operation{
		Name:       opListFirewallRuleGroupAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFirewallRuleGroupAssociationsInput{}
	}

	output = &ListFirewallRuleGroupAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFirewallRuleGroupAssociations API operation for Amazon Route 53 Resolver.
//
// Retrieves the firewall rule group associations that you have defined. Each
// association enables DNS filtering for a VPC with one rule group.
//
// A single call might return only a partial list of the associations. For information,
// see MaxResults.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListFirewallRuleGroupAssociations for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRuleGroupAssociations
func (c *Route53Resolver) ListFirewallRuleGroupAssociations(input *ListFirewallRuleGroupAssociationsInput) (*ListFirewallRuleGroupAssociationsOutput, error) {
	req, out := c.ListFirewallRuleGroupAssociationsRequest(input)
	return out, req.Send()
}

// ListFirewallRuleGroupAssociationsWithContext is the same as ListFirewallRuleGroupAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListFirewallRuleGroupAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListFirewallRuleGroupAssociationsWithContext(ctx aws.Context, input *ListFirewallRuleGroupAssociationsInput, opts ...request.Option) (*ListFirewallRuleGroupAssociationsOutput, error) {
	req, out := c.ListFirewallRuleGroupAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFirewallRuleGroupAssociationsPages iterates over the pages of a ListFirewallRuleGroupAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFirewallRuleGroupAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFirewallRuleGroupAssociations operation.
//	pageNum := 0
//	err := client.ListFirewallRuleGroupAssociationsPages(params,
//	    func(page *route53resolver.ListFirewallRuleGroupAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListFirewallRuleGroupAssociationsPages(input *ListFirewallRuleGroupAssociationsInput, fn func(*ListFirewallRuleGroupAssociationsOutput, bool) bool) error {
	return c.ListFirewallRuleGroupAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFirewallRuleGroupAssociationsPagesWithContext same as ListFirewallRuleGroupAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListFirewallRuleGroupAssociationsPagesWithContext(ctx aws.Context, input *ListFirewallRuleGroupAssociationsInput, fn func(*ListFirewallRuleGroupAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFirewallRuleGroupAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFirewallRuleGroupAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFirewallRuleGroupAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFirewallRuleGroups = "ListFirewallRuleGroups"

// ListFirewallRuleGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListFirewallRuleGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFirewallRuleGroups for more information on using the ListFirewallRuleGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFirewallRuleGroupsRequest method.
//	req, resp := client.ListFirewallRuleGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRuleGroups
func (c *Route53Resolver) ListFirewallRuleGroupsRequest(input *ListFirewallRuleGroupsInput) (req *request.Request, output *ListFirewallRuleGroupsOutput) {
	op := &request.Operation{
		Name:       opListFirewallRuleGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFirewallRuleGroupsInput{}
	}

	output = &ListFirewallRuleGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFirewallRuleGroups API operation for Amazon Route 53 Resolver.
//
// Retrieves the minimal high-level information for the rule groups that you
// have defined.
//
// A single call might return only a partial list of the rule groups. For information,
// see MaxResults.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListFirewallRuleGroups for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRuleGroups
func (c *Route53Resolver) ListFirewallRuleGroups(input *ListFirewallRuleGroupsInput) (*ListFirewallRuleGroupsOutput, error) {
	req, out := c.ListFirewallRuleGroupsRequest(input)
	return out, req.Send()
}

// ListFirewallRuleGroupsWithContext is the same as ListFirewallRuleGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListFirewallRuleGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListFirewallRuleGroupsWithContext(ctx aws.Context, input *ListFirewallRuleGroupsInput, opts ...request.Option) (*ListFirewallRuleGroupsOutput, error) {
	req, out := c.ListFirewallRuleGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFirewallRuleGroupsPages iterates over the pages of a ListFirewallRuleGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFirewallRuleGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFirewallRuleGroups operation.
//	pageNum := 0
//	err := client.ListFirewallRuleGroupsPages(params,
//	    func(page *route53resolver.ListFirewallRuleGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListFirewallRuleGroupsPages(input *ListFirewallRuleGroupsInput, fn func(*ListFirewallRuleGroupsOutput, bool) bool) error {
	return c.ListFirewallRuleGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFirewallRuleGroupsPagesWithContext same as ListFirewallRuleGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListFirewallRuleGroupsPagesWithContext(ctx aws.Context, input *ListFirewallRuleGroupsInput, fn func(*ListFirewallRuleGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFirewallRuleGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFirewallRuleGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFirewallRuleGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFirewallRules = "ListFirewallRules"

// ListFirewallRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListFirewallRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFirewallRules for more information on using the ListFirewallRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFirewallRulesRequest method.
//	req, resp := client.ListFirewallRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRules
func (c *Route53Resolver) ListFirewallRulesRequest(input *ListFirewallRulesInput) (req *request.Request, output *ListFirewallRulesOutput) {
	op := &request.Operation{
		Name:       opListFirewallRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFirewallRulesInput{}
	}

	output = &ListFirewallRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFirewallRules API operation for Amazon Route 53 Resolver.
//
// Retrieves the firewall rules that you have defined for the specified firewall
// rule group. DNS Firewall uses the rules in a rule group to filter DNS network
// traffic for a VPC.
//
// A single call might return only a partial list of the rules. For information,
// see MaxResults.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListFirewallRules for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListFirewallRules
func (c *Route53Resolver) ListFirewallRules(input *ListFirewallRulesInput) (*ListFirewallRulesOutput, error) {
	req, out := c.ListFirewallRulesRequest(input)
	return out, req.Send()
}

// ListFirewallRulesWithContext is the same as ListFirewallRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListFirewallRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListFirewallRulesWithContext(ctx aws.Context, input *ListFirewallRulesInput, opts ...request.Option) (*ListFirewallRulesOutput, error) {
	req, out := c.ListFirewallRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFirewallRulesPages iterates over the pages of a ListFirewallRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFirewallRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFirewallRules operation.
//	pageNum := 0
//	err := client.ListFirewallRulesPages(params,
//	    func(page *route53resolver.ListFirewallRulesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListFirewallRulesPages(input *ListFirewallRulesInput, fn func(*ListFirewallRulesOutput, bool) bool) error {
	return c.ListFirewallRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFirewallRulesPagesWithContext same as ListFirewallRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListFirewallRulesPagesWithContext(ctx aws.Context, input *ListFirewallRulesInput, fn func(*ListFirewallRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFirewallRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFirewallRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFirewallRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOutpostResolvers = "ListOutpostResolvers"

// ListOutpostResolversRequest generates a "aws/request.Request" representing the
// client's request for the ListOutpostResolvers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOutpostResolvers for more information on using the ListOutpostResolvers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListOutpostResolversRequest method.
//	req, resp := client.ListOutpostResolversRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListOutpostResolvers
func (c *Route53Resolver) ListOutpostResolversRequest(input *ListOutpostResolversInput) (req *request.Request, output *ListOutpostResolversOutput) {
	op := &request.Operation{
		Name:       opListOutpostResolvers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOutpostResolversInput{}
	}

	output = &ListOutpostResolversOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOutpostResolvers API operation for Amazon Route 53 Resolver.
//
// Lists all the Resolvers on Outposts that were created using the current Amazon
// Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListOutpostResolvers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListOutpostResolvers
func (c *Route53Resolver) ListOutpostResolvers(input *ListOutpostResolversInput) (*ListOutpostResolversOutput, error) {
	req, out := c.ListOutpostResolversRequest(input)
	return out, req.Send()
}

// ListOutpostResolversWithContext is the same as ListOutpostResolvers with the addition of
// the ability to pass a context and additional request options.
//
// See ListOutpostResolvers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListOutpostResolversWithContext(ctx aws.Context, input *ListOutpostResolversInput, opts ...request.Option) (*ListOutpostResolversOutput, error) {
	req, out := c.ListOutpostResolversRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOutpostResolversPages iterates over the pages of a ListOutpostResolvers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOutpostResolvers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListOutpostResolvers operation.
//	pageNum := 0
//	err := client.ListOutpostResolversPages(params,
//	    func(page *route53resolver.ListOutpostResolversOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListOutpostResolversPages(input *ListOutpostResolversInput, fn func(*ListOutpostResolversOutput, bool) bool) error {
	return c.ListOutpostResolversPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOutpostResolversPagesWithContext same as ListOutpostResolversPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListOutpostResolversPagesWithContext(ctx aws.Context, input *ListOutpostResolversInput, fn func(*ListOutpostResolversOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOutpostResolversInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOutpostResolversRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOutpostResolversOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResolverConfigs = "ListResolverConfigs"

// ListResolverConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverConfigs for more information on using the ListResolverConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResolverConfigsRequest method.
//	req, resp := client.ListResolverConfigsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverConfigs
func (c *Route53Resolver) ListResolverConfigsRequest(input *ListResolverConfigsInput) (req *request.Request, output *ListResolverConfigsOutput) {
	op := &request.Operation{
		Name:       opListResolverConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverConfigsInput{}
	}

	output = &ListResolverConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverConfigs API operation for Amazon Route 53 Resolver.
//
// Retrieves the Resolver configurations that you have defined. Route 53 Resolver
// uses the configurations to manage DNS resolution behavior for your VPCs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverConfigs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNextTokenException
//     The value that you specified for NextToken in a List request isn't valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverConfigs
func (c *Route53Resolver) ListResolverConfigs(input *ListResolverConfigsInput) (*ListResolverConfigsOutput, error) {
	req, out := c.ListResolverConfigsRequest(input)
	return out, req.Send()
}

// ListResolverConfigsWithContext is the same as ListResolverConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverConfigsWithContext(ctx aws.Context, input *ListResolverConfigsInput, opts ...request.Option) (*ListResolverConfigsOutput, error) {
	req, out := c.ListResolverConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverConfigsPages iterates over the pages of a ListResolverConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResolverConfigs operation.
//	pageNum := 0
//	err := client.ListResolverConfigsPages(params,
//	    func(page *route53resolver.ListResolverConfigsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListResolverConfigsPages(input *ListResolverConfigsInput, fn func(*ListResolverConfigsOutput, bool) bool) error {
	return c.ListResolverConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverConfigsPagesWithContext same as ListResolverConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverConfigsPagesWithContext(ctx aws.Context, input *ListResolverConfigsInput, fn func(*ListResolverConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResolverConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResolverDnssecConfigs = "ListResolverDnssecConfigs"

// ListResolverDnssecConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverDnssecConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverDnssecConfigs for more information on using the ListResolverDnssecConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResolverDnssecConfigsRequest method.
//	req, resp := client.ListResolverDnssecConfigsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverDnssecConfigs
func (c *Route53Resolver) ListResolverDnssecConfigsRequest(input *ListResolverDnssecConfigsInput) (req *request.Request, output *ListResolverDnssecConfigsOutput) {
	op := &request.Operation{
		Name:       opListResolverDnssecConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverDnssecConfigsInput{}
	}

	output = &ListResolverDnssecConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverDnssecConfigs API operation for Amazon Route 53 Resolver.
//
// Lists the configurations for DNSSEC validation that are associated with the
// current Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverDnssecConfigs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNextTokenException
//     The value that you specified for NextToken in a List request isn't valid.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverDnssecConfigs
func (c *Route53Resolver) ListResolverDnssecConfigs(input *ListResolverDnssecConfigsInput) (*ListResolverDnssecConfigsOutput, error) {
	req, out := c.ListResolverDnssecConfigsRequest(input)
	return out, req.Send()
}

// ListResolverDnssecConfigsWithContext is the same as ListResolverDnssecConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverDnssecConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverDnssecConfigsWithContext(ctx aws.Context, input *ListResolverDnssecConfigsInput, opts ...request.Option) (*ListResolverDnssecConfigsOutput, error) {
	req, out := c.ListResolverDnssecConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverDnssecConfigsPages iterates over the pages of a ListResolverDnssecConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverDnssecConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResolverDnssecConfigs operation.
//	pageNum := 0
//	err := client.ListResolverDnssecConfigsPages(params,
//	    func(page *route53resolver.ListResolverDnssecConfigsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListResolverDnssecConfigsPages(input *ListResolverDnssecConfigsInput, fn func(*ListResolverDnssecConfigsOutput, bool) bool) error {
	return c.ListResolverDnssecConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverDnssecConfigsPagesWithContext same as ListResolverDnssecConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverDnssecConfigsPagesWithContext(ctx aws.Context, input *ListResolverDnssecConfigsInput, fn func(*ListResolverDnssecConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverDnssecConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverDnssecConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResolverDnssecConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResolverEndpointIpAddresses = "ListResolverEndpointIpAddresses"

// ListResolverEndpointIpAddressesRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverEndpointIpAddresses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverEndpointIpAddresses for more information on using the ListResolverEndpointIpAddresses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResolverEndpointIpAddressesRequest method.
//	req, resp := client.ListResolverEndpointIpAddressesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpointIpAddresses
func (c *Route53Resolver) ListResolverEndpointIpAddressesRequest(input *ListResolverEndpointIpAddressesInput) (req *request.Request, output *ListResolverEndpointIpAddressesOutput) {
	op := &request.Operation{
		Name:       opListResolverEndpointIpAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverEndpointIpAddressesInput{}
	}

	output = &ListResolverEndpointIpAddressesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverEndpointIpAddresses API operation for Amazon Route 53 Resolver.
//
// Gets the IP addresses for a specified Resolver endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverEndpointIpAddresses for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - InvalidNextTokenException
//     The value that you specified for NextToken in a List request isn't valid.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpointIpAddresses
func (c *Route53Resolver) ListResolverEndpointIpAddresses(input *ListResolverEndpointIpAddressesInput) (*ListResolverEndpointIpAddressesOutput, error) {
	req, out := c.ListResolverEndpointIpAddressesRequest(input)
	return out, req.Send()
}

// ListResolverEndpointIpAddressesWithContext is the same as ListResolverEndpointIpAddresses with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverEndpointIpAddresses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverEndpointIpAddressesWithContext(ctx aws.Context, input *ListResolverEndpointIpAddressesInput, opts ...request.Option) (*ListResolverEndpointIpAddressesOutput, error) {
	req, out := c.ListResolverEndpointIpAddressesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverEndpointIpAddressesPages iterates over the pages of a ListResolverEndpointIpAddresses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverEndpointIpAddresses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResolverEndpointIpAddresses operation.
//	pageNum := 0
//	err := client.ListResolverEndpointIpAddressesPages(params,
//	    func(page *route53resolver.ListResolverEndpointIpAddressesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListResolverEndpointIpAddressesPages(input *ListResolverEndpointIpAddressesInput, fn func(*ListResolverEndpointIpAddressesOutput, bool) bool) error {
	return c.ListResolverEndpointIpAddressesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverEndpointIpAddressesPagesWithContext same as ListResolverEndpointIpAddressesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverEndpointIpAddressesPagesWithContext(ctx aws.Context, input *ListResolverEndpointIpAddressesInput, fn func(*ListResolverEndpointIpAddressesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverEndpointIpAddressesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverEndpointIpAddressesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResolverEndpointIpAddressesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResolverEndpoints = "ListResolverEndpoints"

// ListResolverEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverEndpoints for more information on using the ListResolverEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResolverEndpointsRequest method.
//	req, resp := client.ListResolverEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints
func (c *Route53Resolver) ListResolverEndpointsRequest(input *ListResolverEndpointsInput) (req *request.Request, output *ListResolverEndpointsOutput) {
	op := &request.Operation{
		Name:       opListResolverEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverEndpointsInput{}
	}

	output = &ListResolverEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverEndpoints API operation for Amazon Route 53 Resolver.
//
// Lists all the Resolver endpoints that were created using the current Amazon
// Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNextTokenException
//     The value that you specified for NextToken in a List request isn't valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverEndpoints
func (c *Route53Resolver) ListResolverEndpoints(input *ListResolverEndpointsInput) (*ListResolverEndpointsOutput, error) {
	req, out := c.ListResolverEndpointsRequest(input)
	return out, req.Send()
}

// ListResolverEndpointsWithContext is the same as ListResolverEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverEndpointsWithContext(ctx aws.Context, input *ListResolverEndpointsInput, opts ...request.Option) (*ListResolverEndpointsOutput, error) {
	req, out := c.ListResolverEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverEndpointsPages iterates over the pages of a ListResolverEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResolverEndpoints operation.
//	pageNum := 0
//	err := client.ListResolverEndpointsPages(params,
//	    func(page *route53resolver.ListResolverEndpointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListResolverEndpointsPages(input *ListResolverEndpointsInput, fn func(*ListResolverEndpointsOutput, bool) bool) error {
	return c.ListResolverEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverEndpointsPagesWithContext same as ListResolverEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverEndpointsPagesWithContext(ctx aws.Context, input *ListResolverEndpointsInput, fn func(*ListResolverEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResolverEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResolverQueryLogConfigAssociations = "ListResolverQueryLogConfigAssociations"

// ListResolverQueryLogConfigAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverQueryLogConfigAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverQueryLogConfigAssociations for more information on using the ListResolverQueryLogConfigAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResolverQueryLogConfigAssociationsRequest method.
//	req, resp := client.ListResolverQueryLogConfigAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigAssociations
func (c *Route53Resolver) ListResolverQueryLogConfigAssociationsRequest(input *ListResolverQueryLogConfigAssociationsInput) (req *request.Request, output *ListResolverQueryLogConfigAssociationsOutput) {
	op := &request.Operation{
		Name:       opListResolverQueryLogConfigAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverQueryLogConfigAssociationsInput{}
	}

	output = &ListResolverQueryLogConfigAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverQueryLogConfigAssociations API operation for Amazon Route 53 Resolver.
//
// Lists information about associations between Amazon VPCs and query logging
// configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverQueryLogConfigAssociations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigAssociations
func (c *Route53Resolver) ListResolverQueryLogConfigAssociations(input *ListResolverQueryLogConfigAssociationsInput) (*ListResolverQueryLogConfigAssociationsOutput, error) {
	req, out := c.ListResolverQueryLogConfigAssociationsRequest(input)
	return out, req.Send()
}

// ListResolverQueryLogConfigAssociationsWithContext is the same as ListResolverQueryLogConfigAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverQueryLogConfigAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverQueryLogConfigAssociationsWithContext(ctx aws.Context, input *ListResolverQueryLogConfigAssociationsInput, opts ...request.Option) (*ListResolverQueryLogConfigAssociationsOutput, error) {
	req, out := c.ListResolverQueryLogConfigAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverQueryLogConfigAssociationsPages iterates over the pages of a ListResolverQueryLogConfigAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverQueryLogConfigAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResolverQueryLogConfigAssociations operation.
//	pageNum := 0
//	err := client.ListResolverQueryLogConfigAssociationsPages(params,
//	    func(page *route53resolver.ListResolverQueryLogConfigAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListResolverQueryLogConfigAssociationsPages(input *ListResolverQueryLogConfigAssociationsInput, fn func(*ListResolverQueryLogConfigAssociationsOutput, bool) bool) error {
	return c.ListResolverQueryLogConfigAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverQueryLogConfigAssociationsPagesWithContext same as ListResolverQueryLogConfigAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverQueryLogConfigAssociationsPagesWithContext(ctx aws.Context, input *ListResolverQueryLogConfigAssociationsInput, fn func(*ListResolverQueryLogConfigAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverQueryLogConfigAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverQueryLogConfigAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResolverQueryLogConfigAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResolverQueryLogConfigs = "ListResolverQueryLogConfigs"

// ListResolverQueryLogConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverQueryLogConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverQueryLogConfigs for more information on using the ListResolverQueryLogConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResolverQueryLogConfigsRequest method.
//	req, resp := client.ListResolverQueryLogConfigsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigs
func (c *Route53Resolver) ListResolverQueryLogConfigsRequest(input *ListResolverQueryLogConfigsInput) (req *request.Request, output *ListResolverQueryLogConfigsOutput) {
	op := &request.Operation{
		Name:       opListResolverQueryLogConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverQueryLogConfigsInput{}
	}

	output = &ListResolverQueryLogConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverQueryLogConfigs API operation for Amazon Route 53 Resolver.
//
// Lists information about the specified query logging configurations. Each
// configuration defines where you want Resolver to save DNS query logs and
// specifies the VPCs that you want to log queries for.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverQueryLogConfigs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNextTokenException
//     The value that you specified for NextToken in a List request isn't valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverQueryLogConfigs
func (c *Route53Resolver) ListResolverQueryLogConfigs(input *ListResolverQueryLogConfigsInput) (*ListResolverQueryLogConfigsOutput, error) {
	req, out := c.ListResolverQueryLogConfigsRequest(input)
	return out, req.Send()
}

// ListResolverQueryLogConfigsWithContext is the same as ListResolverQueryLogConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverQueryLogConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverQueryLogConfigsWithContext(ctx aws.Context, input *ListResolverQueryLogConfigsInput, opts ...request.Option) (*ListResolverQueryLogConfigsOutput, error) {
	req, out := c.ListResolverQueryLogConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverQueryLogConfigsPages iterates over the pages of a ListResolverQueryLogConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverQueryLogConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResolverQueryLogConfigs operation.
//	pageNum := 0
//	err := client.ListResolverQueryLogConfigsPages(params,
//	    func(page *route53resolver.ListResolverQueryLogConfigsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListResolverQueryLogConfigsPages(input *ListResolverQueryLogConfigsInput, fn func(*ListResolverQueryLogConfigsOutput, bool) bool) error {
	return c.ListResolverQueryLogConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverQueryLogConfigsPagesWithContext same as ListResolverQueryLogConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverQueryLogConfigsPagesWithContext(ctx aws.Context, input *ListResolverQueryLogConfigsInput, fn func(*ListResolverQueryLogConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverQueryLogConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverQueryLogConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResolverQueryLogConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResolverRuleAssociations = "ListResolverRuleAssociations"

// ListResolverRuleAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverRuleAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverRuleAssociations for more information on using the ListResolverRuleAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResolverRuleAssociationsRequest method.
//	req, resp := client.ListResolverRuleAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations
func (c *Route53Resolver) ListResolverRuleAssociationsRequest(input *ListResolverRuleAssociationsInput) (req *request.Request, output *ListResolverRuleAssociationsOutput) {
	op := &request.Operation{
		Name:       opListResolverRuleAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverRuleAssociationsInput{}
	}

	output = &ListResolverRuleAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverRuleAssociations API operation for Amazon Route 53 Resolver.
//
// Lists the associations that were created between Resolver rules and VPCs
// using the current Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverRuleAssociations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNextTokenException
//     The value that you specified for NextToken in a List request isn't valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRuleAssociations
func (c *Route53Resolver) ListResolverRuleAssociations(input *ListResolverRuleAssociationsInput) (*ListResolverRuleAssociationsOutput, error) {
	req, out := c.ListResolverRuleAssociationsRequest(input)
	return out, req.Send()
}

// ListResolverRuleAssociationsWithContext is the same as ListResolverRuleAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverRuleAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverRuleAssociationsWithContext(ctx aws.Context, input *ListResolverRuleAssociationsInput, opts ...request.Option) (*ListResolverRuleAssociationsOutput, error) {
	req, out := c.ListResolverRuleAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverRuleAssociationsPages iterates over the pages of a ListResolverRuleAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverRuleAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResolverRuleAssociations operation.
//	pageNum := 0
//	err := client.ListResolverRuleAssociationsPages(params,
//	    func(page *route53resolver.ListResolverRuleAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListResolverRuleAssociationsPages(input *ListResolverRuleAssociationsInput, fn func(*ListResolverRuleAssociationsOutput, bool) bool) error {
	return c.ListResolverRuleAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverRuleAssociationsPagesWithContext same as ListResolverRuleAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverRuleAssociationsPagesWithContext(ctx aws.Context, input *ListResolverRuleAssociationsInput, fn func(*ListResolverRuleAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverRuleAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverRuleAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResolverRuleAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListResolverRules = "ListResolverRules"

// ListResolverRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListResolverRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListResolverRules for more information on using the ListResolverRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListResolverRulesRequest method.
//	req, resp := client.ListResolverRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules
func (c *Route53Resolver) ListResolverRulesRequest(input *ListResolverRulesInput) (req *request.Request, output *ListResolverRulesOutput) {
	op := &request.Operation{
		Name:       opListResolverRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResolverRulesInput{}
	}

	output = &ListResolverRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListResolverRules API operation for Amazon Route 53 Resolver.
//
// Lists the Resolver rules that were created using the current Amazon Web Services
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListResolverRules for usage and error information.
//
// Returned Error Types:
//
//   - InvalidNextTokenException
//     The value that you specified for NextToken in a List request isn't valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListResolverRules
func (c *Route53Resolver) ListResolverRules(input *ListResolverRulesInput) (*ListResolverRulesOutput, error) {
	req, out := c.ListResolverRulesRequest(input)
	return out, req.Send()
}

// ListResolverRulesWithContext is the same as ListResolverRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListResolverRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverRulesWithContext(ctx aws.Context, input *ListResolverRulesInput, opts ...request.Option) (*ListResolverRulesOutput, error) {
	req, out := c.ListResolverRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListResolverRulesPages iterates over the pages of a ListResolverRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListResolverRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListResolverRules operation.
//	pageNum := 0
//	err := client.ListResolverRulesPages(params,
//	    func(page *route53resolver.ListResolverRulesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListResolverRulesPages(input *ListResolverRulesInput, fn func(*ListResolverRulesOutput, bool) bool) error {
	return c.ListResolverRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListResolverRulesPagesWithContext same as ListResolverRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListResolverRulesPagesWithContext(ctx aws.Context, input *ListResolverRulesInput, fn func(*ListResolverRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListResolverRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListResolverRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListResolverRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListTagsForResource
func (c *Route53Resolver) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Route 53 Resolver.
//
// Lists the tags that you associated with the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InvalidNextTokenException
//     The value that you specified for NextToken in a List request isn't valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/ListTagsForResource
func (c *Route53Resolver) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTagsForResource operation.
//	pageNum := 0
//	err := client.ListTagsForResourcePages(params,
//	    func(page *route53resolver.ListTagsForResourceOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Resolver) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutFirewallRuleGroupPolicy = "PutFirewallRuleGroupPolicy"

// PutFirewallRuleGroupPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutFirewallRuleGroupPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutFirewallRuleGroupPolicy for more information on using the PutFirewallRuleGroupPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutFirewallRuleGroupPolicyRequest method.
//	req, resp := client.PutFirewallRuleGroupPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutFirewallRuleGroupPolicy
func (c *Route53Resolver) PutFirewallRuleGroupPolicyRequest(input *PutFirewallRuleGroupPolicyInput) (req *request.Request, output *PutFirewallRuleGroupPolicyOutput) {
	op := &request.Operation{
		Name:       opPutFirewallRuleGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutFirewallRuleGroupPolicyInput{}
	}

	output = &PutFirewallRuleGroupPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutFirewallRuleGroupPolicy API operation for Amazon Route 53 Resolver.
//
// Attaches an Identity and Access Management (Amazon Web Services IAM) policy
// for sharing the rule group. You can use the policy to share the rule group
// using Resource Access Manager (RAM).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation PutFirewallRuleGroupPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutFirewallRuleGroupPolicy
func (c *Route53Resolver) PutFirewallRuleGroupPolicy(input *PutFirewallRuleGroupPolicyInput) (*PutFirewallRuleGroupPolicyOutput, error) {
	req, out := c.PutFirewallRuleGroupPolicyRequest(input)
	return out, req.Send()
}

// PutFirewallRuleGroupPolicyWithContext is the same as PutFirewallRuleGroupPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutFirewallRuleGroupPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) PutFirewallRuleGroupPolicyWithContext(ctx aws.Context, input *PutFirewallRuleGroupPolicyInput, opts ...request.Option) (*PutFirewallRuleGroupPolicyOutput, error) {
	req, out := c.PutFirewallRuleGroupPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResolverQueryLogConfigPolicy = "PutResolverQueryLogConfigPolicy"

// PutResolverQueryLogConfigPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResolverQueryLogConfigPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResolverQueryLogConfigPolicy for more information on using the PutResolverQueryLogConfigPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutResolverQueryLogConfigPolicyRequest method.
//	req, resp := client.PutResolverQueryLogConfigPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverQueryLogConfigPolicy
func (c *Route53Resolver) PutResolverQueryLogConfigPolicyRequest(input *PutResolverQueryLogConfigPolicyInput) (req *request.Request, output *PutResolverQueryLogConfigPolicyOutput) {
	op := &request.Operation{
		Name:       opPutResolverQueryLogConfigPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResolverQueryLogConfigPolicyInput{}
	}

	output = &PutResolverQueryLogConfigPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResolverQueryLogConfigPolicy API operation for Amazon Route 53 Resolver.
//
// Specifies an Amazon Web Services account that you want to share a query logging
// configuration with, the query logging configuration that you want to share,
// and the operations that you want the account to be able to perform on the
// configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation PutResolverQueryLogConfigPolicy for usage and error information.
//
// Returned Error Types:
//
//   - InvalidPolicyDocument
//     The specified Resolver rule policy is invalid.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - UnknownResourceException
//     The specified resource doesn't exist.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverQueryLogConfigPolicy
func (c *Route53Resolver) PutResolverQueryLogConfigPolicy(input *PutResolverQueryLogConfigPolicyInput) (*PutResolverQueryLogConfigPolicyOutput, error) {
	req, out := c.PutResolverQueryLogConfigPolicyRequest(input)
	return out, req.Send()
}

// PutResolverQueryLogConfigPolicyWithContext is the same as PutResolverQueryLogConfigPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResolverQueryLogConfigPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) PutResolverQueryLogConfigPolicyWithContext(ctx aws.Context, input *PutResolverQueryLogConfigPolicyInput, opts ...request.Option) (*PutResolverQueryLogConfigPolicyOutput, error) {
	req, out := c.PutResolverQueryLogConfigPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutResolverRulePolicy = "PutResolverRulePolicy"

// PutResolverRulePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResolverRulePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResolverRulePolicy for more information on using the PutResolverRulePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutResolverRulePolicyRequest method.
//	req, resp := client.PutResolverRulePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverRulePolicy
func (c *Route53Resolver) PutResolverRulePolicyRequest(input *PutResolverRulePolicyInput) (req *request.Request, output *PutResolverRulePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResolverRulePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResolverRulePolicyInput{}
	}

	output = &PutResolverRulePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResolverRulePolicy API operation for Amazon Route 53 Resolver.
//
// Specifies an Amazon Web Services rule that you want to share with another
// account, the account that you want to share the rule with, and the operations
// that you want the account to be able to perform on the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation PutResolverRulePolicy for usage and error information.
//
// Returned Error Types:
//
//   - InvalidPolicyDocument
//     The specified Resolver rule policy is invalid.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - UnknownResourceException
//     The specified resource doesn't exist.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/PutResolverRulePolicy
func (c *Route53Resolver) PutResolverRulePolicy(input *PutResolverRulePolicyInput) (*PutResolverRulePolicyOutput, error) {
	req, out := c.PutResolverRulePolicyRequest(input)
	return out, req.Send()
}

// PutResolverRulePolicyWithContext is the same as PutResolverRulePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResolverRulePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) PutResolverRulePolicyWithContext(ctx aws.Context, input *PutResolverRulePolicyInput, opts ...request.Option) (*PutResolverRulePolicyOutput, error) {
	req, out := c.PutResolverRulePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/TagResource
func (c *Route53Resolver) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Route 53 Resolver.
//
// Adds one or more tags to a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InvalidTagException
//     The specified tag is invalid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/TagResource
func (c *Route53Resolver) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UntagResource
func (c *Route53Resolver) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Route 53 Resolver.
//
// Removes one or more tags from a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UntagResource
func (c *Route53Resolver) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFirewallConfig = "UpdateFirewallConfig"

// UpdateFirewallConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFirewallConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFirewallConfig for more information on using the UpdateFirewallConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFirewallConfigRequest method.
//	req, resp := client.UpdateFirewallConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallConfig
func (c *Route53Resolver) UpdateFirewallConfigRequest(input *UpdateFirewallConfigInput) (req *request.Request, output *UpdateFirewallConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateFirewallConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFirewallConfigInput{}
	}

	output = &UpdateFirewallConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFirewallConfig API operation for Amazon Route 53 Resolver.
//
// Updates the configuration of the firewall behavior provided by DNS Firewall
// for a single VPC from Amazon Virtual Private Cloud (Amazon VPC).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UpdateFirewallConfig for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallConfig
func (c *Route53Resolver) UpdateFirewallConfig(input *UpdateFirewallConfigInput) (*UpdateFirewallConfigOutput, error) {
	req, out := c.UpdateFirewallConfigRequest(input)
	return out, req.Send()
}

// UpdateFirewallConfigWithContext is the same as UpdateFirewallConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFirewallConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UpdateFirewallConfigWithContext(ctx aws.Context, input *UpdateFirewallConfigInput, opts ...request.Option) (*UpdateFirewallConfigOutput, error) {
	req, out := c.UpdateFirewallConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFirewallDomains = "UpdateFirewallDomains"

// UpdateFirewallDomainsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFirewallDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFirewallDomains for more information on using the UpdateFirewallDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFirewallDomainsRequest method.
//	req, resp := client.UpdateFirewallDomainsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallDomains
func (c *Route53Resolver) UpdateFirewallDomainsRequest(input *UpdateFirewallDomainsInput) (req *request.Request, output *UpdateFirewallDomainsOutput) {
	op := &request.Operation{
		Name:       opUpdateFirewallDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFirewallDomainsInput{}
	}

	output = &UpdateFirewallDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFirewallDomains API operation for Amazon Route 53 Resolver.
//
// Updates the firewall domain list from an array of domain specifications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UpdateFirewallDomains for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - ConflictException
//     The requested state transition isn't valid. For example, you can't delete
//     a firewall domain list if it is in the process of being deleted, or you can't
//     import domains into a domain list that is in the process of being deleted.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallDomains
func (c *Route53Resolver) UpdateFirewallDomains(input *UpdateFirewallDomainsInput) (*UpdateFirewallDomainsOutput, error) {
	req, out := c.UpdateFirewallDomainsRequest(input)
	return out, req.Send()
}

// UpdateFirewallDomainsWithContext is the same as UpdateFirewallDomains with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFirewallDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UpdateFirewallDomainsWithContext(ctx aws.Context, input *UpdateFirewallDomainsInput, opts ...request.Option) (*UpdateFirewallDomainsOutput, error) {
	req, out := c.UpdateFirewallDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFirewallRule = "UpdateFirewallRule"

// UpdateFirewallRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFirewallRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFirewallRule for more information on using the UpdateFirewallRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFirewallRuleRequest method.
//	req, resp := client.UpdateFirewallRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallRule
func (c *Route53Resolver) UpdateFirewallRuleRequest(input *UpdateFirewallRuleInput) (req *request.Request, output *UpdateFirewallRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateFirewallRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFirewallRuleInput{}
	}

	output = &UpdateFirewallRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFirewallRule API operation for Amazon Route 53 Resolver.
//
// Updates the specified firewall rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UpdateFirewallRule for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - ConflictException
//     The requested state transition isn't valid. For example, you can't delete
//     a firewall domain list if it is in the process of being deleted, or you can't
//     import domains into a domain list that is in the process of being deleted.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallRule
func (c *Route53Resolver) UpdateFirewallRule(input *UpdateFirewallRuleInput) (*UpdateFirewallRuleOutput, error) {
	req, out := c.UpdateFirewallRuleRequest(input)
	return out, req.Send()
}

// UpdateFirewallRuleWithContext is the same as UpdateFirewallRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFirewallRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UpdateFirewallRuleWithContext(ctx aws.Context, input *UpdateFirewallRuleInput, opts ...request.Option) (*UpdateFirewallRuleOutput, error) {
	req, out := c.UpdateFirewallRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFirewallRuleGroupAssociation = "UpdateFirewallRuleGroupAssociation"

// UpdateFirewallRuleGroupAssociationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFirewallRuleGroupAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFirewallRuleGroupAssociation for more information on using the UpdateFirewallRuleGroupAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFirewallRuleGroupAssociationRequest method.
//	req, resp := client.UpdateFirewallRuleGroupAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallRuleGroupAssociation
func (c *Route53Resolver) UpdateFirewallRuleGroupAssociationRequest(input *UpdateFirewallRuleGroupAssociationInput) (req *request.Request, output *UpdateFirewallRuleGroupAssociationOutput) {
	op := &request.Operation{
		Name:       opUpdateFirewallRuleGroupAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFirewallRuleGroupAssociationInput{}
	}

	output = &UpdateFirewallRuleGroupAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFirewallRuleGroupAssociation API operation for Amazon Route 53 Resolver.
//
// Changes the association of a FirewallRuleGroup with a VPC. The association
// enables DNS filtering for the VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UpdateFirewallRuleGroupAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
//   - ConflictException
//     The requested state transition isn't valid. For example, you can't delete
//     a firewall domain list if it is in the process of being deleted, or you can't
//     import domains into a domain list that is in the process of being deleted.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateFirewallRuleGroupAssociation
func (c *Route53Resolver) UpdateFirewallRuleGroupAssociation(input *UpdateFirewallRuleGroupAssociationInput) (*UpdateFirewallRuleGroupAssociationOutput, error) {
	req, out := c.UpdateFirewallRuleGroupAssociationRequest(input)
	return out, req.Send()
}

// UpdateFirewallRuleGroupAssociationWithContext is the same as UpdateFirewallRuleGroupAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFirewallRuleGroupAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UpdateFirewallRuleGroupAssociationWithContext(ctx aws.Context, input *UpdateFirewallRuleGroupAssociationInput, opts ...request.Option) (*UpdateFirewallRuleGroupAssociationOutput, error) {
	req, out := c.UpdateFirewallRuleGroupAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateOutpostResolver = "UpdateOutpostResolver"

// UpdateOutpostResolverRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOutpostResolver operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateOutpostResolver for more information on using the UpdateOutpostResolver
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateOutpostResolverRequest method.
//	req, resp := client.UpdateOutpostResolverRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateOutpostResolver
func (c *Route53Resolver) UpdateOutpostResolverRequest(input *UpdateOutpostResolverInput) (req *request.Request, output *UpdateOutpostResolverOutput) {
	op := &request.Operation{
		Name:       opUpdateOutpostResolver,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateOutpostResolverInput{}
	}

	output = &UpdateOutpostResolverOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateOutpostResolver API operation for Amazon Route 53 Resolver.
//
// You can use UpdateOutpostResolver to update the instance count, type, or
// name of a Resolver on an Outpost.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UpdateOutpostResolver for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - ConflictException
//     The requested state transition isn't valid. For example, you can't delete
//     a firewall domain list if it is in the process of being deleted, or you can't
//     import domains into a domain list that is in the process of being deleted.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ServiceQuotaExceededException
//     Fulfilling the request would cause one or more quotas to be exceeded.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateOutpostResolver
func (c *Route53Resolver) UpdateOutpostResolver(input *UpdateOutpostResolverInput) (*UpdateOutpostResolverOutput, error) {
	req, out := c.UpdateOutpostResolverRequest(input)
	return out, req.Send()
}

// UpdateOutpostResolverWithContext is the same as UpdateOutpostResolver with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateOutpostResolver for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UpdateOutpostResolverWithContext(ctx aws.Context, input *UpdateOutpostResolverInput, opts ...request.Option) (*UpdateOutpostResolverOutput, error) {
	req, out := c.UpdateOutpostResolverRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResolverConfig = "UpdateResolverConfig"

// UpdateResolverConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResolverConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResolverConfig for more information on using the UpdateResolverConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateResolverConfigRequest method.
//	req, resp := client.UpdateResolverConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverConfig
func (c *Route53Resolver) UpdateResolverConfigRequest(input *UpdateResolverConfigInput) (req *request.Request, output *UpdateResolverConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateResolverConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResolverConfigInput{}
	}

	output = &UpdateResolverConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResolverConfig API operation for Amazon Route 53 Resolver.
//
// Updates the behavior configuration of Route 53 Resolver behavior for a single
// VPC from Amazon Virtual Private Cloud.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UpdateResolverConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ResourceUnavailableException
//     The specified resource isn't available.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
//   - ValidationException
//     You have provided an invalid command. Supported values are ADD, REMOVE, or
//     REPLACE a domain.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverConfig
func (c *Route53Resolver) UpdateResolverConfig(input *UpdateResolverConfigInput) (*UpdateResolverConfigOutput, error) {
	req, out := c.UpdateResolverConfigRequest(input)
	return out, req.Send()
}

// UpdateResolverConfigWithContext is the same as UpdateResolverConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResolverConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UpdateResolverConfigWithContext(ctx aws.Context, input *UpdateResolverConfigInput, opts ...request.Option) (*UpdateResolverConfigOutput, error) {
	req, out := c.UpdateResolverConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResolverDnssecConfig = "UpdateResolverDnssecConfig"

// UpdateResolverDnssecConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResolverDnssecConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResolverDnssecConfig for more information on using the UpdateResolverDnssecConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateResolverDnssecConfigRequest method.
//	req, resp := client.UpdateResolverDnssecConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverDnssecConfig
func (c *Route53Resolver) UpdateResolverDnssecConfigRequest(input *UpdateResolverDnssecConfigInput) (req *request.Request, output *UpdateResolverDnssecConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateResolverDnssecConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResolverDnssecConfigInput{}
	}

	output = &UpdateResolverDnssecConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResolverDnssecConfig API operation for Amazon Route 53 Resolver.
//
// Updates an existing DNSSEC validation configuration. If there is no existing
// DNSSEC validation configuration, one is created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UpdateResolverDnssecConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified Resolver operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverDnssecConfig
func (c *Route53Resolver) UpdateResolverDnssecConfig(input *UpdateResolverDnssecConfigInput) (*UpdateResolverDnssecConfigOutput, error) {
	req, out := c.UpdateResolverDnssecConfigRequest(input)
	return out, req.Send()
}

// UpdateResolverDnssecConfigWithContext is the same as UpdateResolverDnssecConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResolverDnssecConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UpdateResolverDnssecConfigWithContext(ctx aws.Context, input *UpdateResolverDnssecConfigInput, opts ...request.Option) (*UpdateResolverDnssecConfigOutput, error) {
	req, out := c.UpdateResolverDnssecConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResolverEndpoint = "UpdateResolverEndpoint"

// UpdateResolverEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResolverEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResolverEndpoint for more information on using the UpdateResolverEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateResolverEndpointRequest method.
//	req, resp := client.UpdateResolverEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverEndpoint
func (c *Route53Resolver) UpdateResolverEndpointRequest(input *UpdateResolverEndpointInput) (req *request.Request, output *UpdateResolverEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateResolverEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResolverEndpointInput{}
	}

	output = &UpdateResolverEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResolverEndpoint API operation for Amazon Route 53 Resolver.
//
// Updates the name, or enpoint type for an inbound or an outbound Resolver
// endpoint. You can only update between IPV4 and DUALSTACK, IPV6 endpoint type
// can't be updated to other type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UpdateResolverEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverEndpoint
func (c *Route53Resolver) UpdateResolverEndpoint(input *UpdateResolverEndpointInput) (*UpdateResolverEndpointOutput, error) {
	req, out := c.UpdateResolverEndpointRequest(input)
	return out, req.Send()
}

// UpdateResolverEndpointWithContext is the same as UpdateResolverEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResolverEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UpdateResolverEndpointWithContext(ctx aws.Context, input *UpdateResolverEndpointInput, opts ...request.Option) (*UpdateResolverEndpointOutput, error) {
	req, out := c.UpdateResolverEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResolverRule = "UpdateResolverRule"

// UpdateResolverRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResolverRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResolverRule for more information on using the UpdateResolverRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateResolverRuleRequest method.
//	req, resp := client.UpdateResolverRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverRule
func (c *Route53Resolver) UpdateResolverRuleRequest(input *UpdateResolverRuleInput) (req *request.Request, output *UpdateResolverRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResolverRuleInput{}
	}

	output = &UpdateResolverRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResolverRule API operation for Amazon Route 53 Resolver.
//
// Updates settings for a specified Resolver rule. ResolverRuleId is required,
// and all other parameters are optional. If you don't specify a parameter,
// it retains its current value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Route 53 Resolver's
// API operation UpdateResolverRule for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is invalid.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ResourceNotFoundException
//     The specified resource doesn't exist.
//
//   - ResourceUnavailableException
//     The specified resource isn't available.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - InternalServiceErrorException
//     We encountered an unknown error. Try again in a few minutes.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/UpdateResolverRule
func (c *Route53Resolver) UpdateResolverRule(input *UpdateResolverRuleInput) (*UpdateResolverRuleOutput, error) {
	req, out := c.UpdateResolverRuleRequest(input)
	return out, req.Send()
}

// UpdateResolverRuleWithContext is the same as UpdateResolverRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResolverRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Resolver) UpdateResolverRuleWithContext(ctx aws.Context, input *UpdateResolverRuleInput, opts ...request.Option) (*UpdateResolverRuleOutput, error) {
	req, out := c.UpdateResolverRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The current account doesn't have the IAM permissions required to perform
// the specified Resolver operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AssociateFirewallRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed requests
	// to be retried without the risk of running the operation twice. CreatorRequestId
	// can be any unique string, for example, a date/time stamp.
	CreatorRequestId *string `min:"1" type:"string" idempotencyToken:"true"`

	// The unique identifier of the firewall rule group.
	//
	// FirewallRuleGroupId is a required field
	FirewallRuleGroupId *string `min:"1" type:"string" required:"true"`

	// If enabled, this setting disallows modification or removal of the association,
	// to help prevent against accidentally altering DNS firewall protections. When
	// you create the association, the default setting is DISABLED.
	MutationProtection *string `type:"string" enum:"MutationProtectionStatus"`

	// A name that lets you identify the association, to manage and use it.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The setting that determines the processing order of the rule group among
	// the rule groups that you associate with the specified VPC. DNS Firewall filters
	// VPC traffic starting from the rule group with the lowest numeric priority
	// setting.
	//
	// You must specify a unique priority for each rule group that you associate
	// with a single VPC. To make it easier to insert rule groups later, leave space
	// between the numbers, for example, use 101, 200, and so on. You can change
	// the priority setting for a rule group association after you create it.
	//
	// The allowed values for Priority are between 100 and 9900.
	//
	// Priority is a required field
	Priority *int64 `type:"integer" required:"true"`

	// A list of the tag keys and values that you want to associate with the rule
	// group association.
	Tags []*Tag `type:"list"`

	// The unique identifier of the VPC that you want to associate with the rule
	// group.
	//
	// VpcId is a required field
	VpcId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateFirewallRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateFirewallRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateFirewallRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateFirewallRuleGroupInput"}
	if s.CreatorRequestId != nil && len(*s.CreatorRequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorRequestId", 1))
	}
	if s.FirewallRuleGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallRuleGroupId"))
	}
	if s.FirewallRuleGroupId != nil && len(*s.FirewallRuleGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallRuleGroupId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.VpcId != nil && len(*s.VpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *AssociateFirewallRuleGroupInput) SetCreatorRequestId(v string) *AssociateFirewallRuleGroupInput {
	s.CreatorRequestId = &v
	return s
}

// SetFirewallRuleGroupId sets the FirewallRuleGroupId field's value.
func (s *AssociateFirewallRuleGroupInput) SetFirewallRuleGroupId(v string) *AssociateFirewallRuleGroupInput {
	s.FirewallRuleGroupId = &v
	return s
}

// SetMutationProtection sets the MutationProtection field's value.
func (s *AssociateFirewallRuleGroupInput) SetMutationProtection(v string) *AssociateFirewallRuleGroupInput {
	s.MutationProtection = &v
	return s
}

// SetName sets the Name field's value.
func (s *AssociateFirewallRuleGroupInput) SetName(v string) *AssociateFirewallRuleGroupInput {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *AssociateFirewallRuleGroupInput) SetPriority(v int64) *AssociateFirewallRuleGroupInput {
	s.Priority = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssociateFirewallRuleGroupInput) SetTags(v []*Tag) *AssociateFirewallRuleGroupInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *AssociateFirewallRuleGroupInput) SetVpcId(v string) *AssociateFirewallRuleGroupInput {
	s.VpcId = &v
	return s
}

type AssociateFirewallRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// The association that you just created. The association has an ID that you
	// can use to identify it in other requests, like update and delete.
	FirewallRuleGroupAssociation *FirewallRuleGroupAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateFirewallRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateFirewallRuleGroupOutput) GoString() string {
	return s.String()
}

// SetFirewallRuleGroupAssociation sets the FirewallRuleGroupAssociation field's value.
func (s *AssociateFirewallRuleGroupOutput) SetFirewallRuleGroupAssociation(v *FirewallRuleGroupAssociation) *AssociateFirewallRuleGroupOutput {
	s.FirewallRuleGroupAssociation = v
	return s
}

type AssociateResolverEndpointIpAddressInput struct {
	_ struct{} `type:"structure"`

	// Either the IPv4 address that you want to add to a Resolver endpoint or a
	// subnet ID. If you specify a subnet ID, Resolver chooses an IP address for
	// you from the available IPs in the specified subnet.
	//
	// IpAddress is a required field
	IpAddress *IpAddressUpdate `type:"structure" required:"true"`

	// The ID of the Resolver endpoint that you want to associate IP addresses with.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResolverEndpointIpAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResolverEndpointIpAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateResolverEndpointIpAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateResolverEndpointIpAddressInput"}
	if s.IpAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAddress"))
	}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}
	if s.IpAddress != nil {
		if err := s.IpAddress.Validate(); err != nil {
			invalidParams.AddNested("IpAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpAddress sets the IpAddress field's value.
func (s *AssociateResolverEndpointIpAddressInput) SetIpAddress(v *IpAddressUpdate) *AssociateResolverEndpointIpAddressInput {
	s.IpAddress = v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *AssociateResolverEndpointIpAddressInput) SetResolverEndpointId(v string) *AssociateResolverEndpointIpAddressInput {
	s.ResolverEndpointId = &v
	return s
}

type AssociateResolverEndpointIpAddressOutput struct {
	_ struct{} `type:"structure"`

	// The response to an AssociateResolverEndpointIpAddress request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResolverEndpointIpAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResolverEndpointIpAddressOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *AssociateResolverEndpointIpAddressOutput) SetResolverEndpoint(v *ResolverEndpoint) *AssociateResolverEndpointIpAddressOutput {
	s.ResolverEndpoint = v
	return s
}

type AssociateResolverQueryLogConfigInput struct {
	_ struct{} `type:"structure"`

	// The ID of the query logging configuration that you want to associate a VPC
	// with.
	//
	// ResolverQueryLogConfigId is a required field
	ResolverQueryLogConfigId *string `min:"1" type:"string" required:"true"`

	// The ID of an Amazon VPC that you want this query logging configuration to
	// log queries for.
	//
	// The VPCs and the query logging configuration must be in the same Region.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResolverQueryLogConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResolverQueryLogConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateResolverQueryLogConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateResolverQueryLogConfigInput"}
	if s.ResolverQueryLogConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverQueryLogConfigId"))
	}
	if s.ResolverQueryLogConfigId != nil && len(*s.ResolverQueryLogConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverQueryLogConfigId", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverQueryLogConfigId sets the ResolverQueryLogConfigId field's value.
func (s *AssociateResolverQueryLogConfigInput) SetResolverQueryLogConfigId(v string) *AssociateResolverQueryLogConfigInput {
	s.ResolverQueryLogConfigId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AssociateResolverQueryLogConfigInput) SetResourceId(v string) *AssociateResolverQueryLogConfigInput {
	s.ResourceId = &v
	return s
}

type AssociateResolverQueryLogConfigOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for a specified association between
	// an Amazon VPC and a query logging configuration.
	ResolverQueryLogConfigAssociation *ResolverQueryLogConfigAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResolverQueryLogConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResolverQueryLogConfigOutput) GoString() string {
	return s.String()
}

// SetResolverQueryLogConfigAssociation sets the ResolverQueryLogConfigAssociation field's value.
func (s *AssociateResolverQueryLogConfigOutput) SetResolverQueryLogConfigAssociation(v *ResolverQueryLogConfigAssociation) *AssociateResolverQueryLogConfigOutput {
	s.ResolverQueryLogConfigAssociation = v
	return s
}

type AssociateResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// A name for the association that you're creating between a Resolver rule and
	// a VPC.
	Name *string `type:"string"`

	// The ID of the Resolver rule that you want to associate with the VPC. To list
	// the existing Resolver rules, use ListResolverRules (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html).
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`

	// The ID of the VPC that you want to associate the Resolver rule with.
	//
	// VPCId is a required field
	VPCId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateResolverRuleInput"}
	if s.ResolverRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleId", 1))
	}
	if s.VPCId == nil {
		invalidParams.Add(request.NewErrParamRequired("VPCId"))
	}
	if s.VPCId != nil && len(*s.VPCId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AssociateResolverRuleInput) SetName(v string) *AssociateResolverRuleInput {
	s.Name = &v
	return s
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *AssociateResolverRuleInput) SetResolverRuleId(v string) *AssociateResolverRuleInput {
	s.ResolverRuleId = &v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *AssociateResolverRuleInput) SetVPCId(v string) *AssociateResolverRuleInput {
	s.VPCId = &v
	return s
}

type AssociateResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the AssociateResolverRule request, including the status
	// of the request.
	ResolverRuleAssociation *ResolverRuleAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRuleAssociation sets the ResolverRuleAssociation field's value.
func (s *AssociateResolverRuleOutput) SetResolverRuleAssociation(v *ResolverRuleAssociation) *AssociateResolverRuleOutput {
	s.ResolverRuleAssociation = v
	return s
}

// The requested state transition isn't valid. For example, you can't delete
// a firewall domain list if it is in the process of being deleted, or you can't
// import domains into a domain list that is in the process of being deleted.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateFirewallDomainListInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows you to retry
	// failed requests without the risk of running the operation twice. CreatorRequestId
	// can be any unique string, for example, a date/time stamp.
	CreatorRequestId *string `min:"1" type:"string" idempotencyToken:"true"`

	// A name that lets you identify the domain list to manage and use it.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A list of the tag keys and values that you want to associate with the domain
	// list.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallDomainListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallDomainListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFirewallDomainListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFirewallDomainListInput"}
	if s.CreatorRequestId != nil && len(*s.CreatorRequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorRequestId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateFirewallDomainListInput) SetCreatorRequestId(v string) *CreateFirewallDomainListInput {
	s.CreatorRequestId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFirewallDomainListInput) SetName(v string) *CreateFirewallDomainListInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFirewallDomainListInput) SetTags(v []*Tag) *CreateFirewallDomainListInput {
	s.Tags = v
	return s
}

type CreateFirewallDomainListOutput struct {
	_ struct{} `type:"structure"`

	// The domain list that you just created.
	FirewallDomainList *FirewallDomainList `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallDomainListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallDomainListOutput) GoString() string {
	return s.String()
}

// SetFirewallDomainList sets the FirewallDomainList field's value.
func (s *CreateFirewallDomainListOutput) SetFirewallDomainList(v *FirewallDomainList) *CreateFirewallDomainListOutput {
	s.FirewallDomainList = v
	return s
}

type CreateFirewallRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// A unique string defined by you to identify the request. This allows you to
	// retry failed requests without the risk of running the operation twice. This
	// can be any unique string, for example, a timestamp.
	CreatorRequestId *string `min:"1" type:"string" idempotencyToken:"true"`

	// A name that lets you identify the rule group, to manage and use it.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A list of the tag keys and values that you want to associate with the rule
	// group.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFirewallRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFirewallRuleGroupInput"}
	if s.CreatorRequestId != nil && len(*s.CreatorRequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorRequestId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateFirewallRuleGroupInput) SetCreatorRequestId(v string) *CreateFirewallRuleGroupInput {
	s.CreatorRequestId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFirewallRuleGroupInput) SetName(v string) *CreateFirewallRuleGroupInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFirewallRuleGroupInput) SetTags(v []*Tag) *CreateFirewallRuleGroupInput {
	s.Tags = v
	return s
}

type CreateFirewallRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// A collection of rules used to filter DNS network traffic.
	FirewallRuleGroup *FirewallRuleGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallRuleGroupOutput) GoString() string {
	return s.String()
}

// SetFirewallRuleGroup sets the FirewallRuleGroup field's value.
func (s *CreateFirewallRuleGroupOutput) SetFirewallRuleGroup(v *FirewallRuleGroup) *CreateFirewallRuleGroupOutput {
	s.FirewallRuleGroup = v
	return s
}

type CreateFirewallRuleInput struct {
	_ struct{} `type:"structure"`

	// The action that DNS Firewall should take on a DNS query when it matches one
	// of the domains in the rule's domain list:
	//
	//    * ALLOW - Permit the request to go through.
	//
	//    * ALERT - Permit the request and send metrics and logs to Cloud Watch.
	//
	//    * BLOCK - Disallow the request. This option requires additional details
	//    in the rule's BlockResponse.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"Action"`

	// The DNS record's type. This determines the format of the record value that
	// you provided in BlockOverrideDomain. Used for the rule action BLOCK with
	// a BlockResponse setting of OVERRIDE.
	//
	// This setting is required if the BlockResponse setting is OVERRIDE.
	BlockOverrideDnsType *string `type:"string" enum:"BlockOverrideDnsType"`

	// The custom DNS record to send back in response to the query. Used for the
	// rule action BLOCK with a BlockResponse setting of OVERRIDE.
	//
	// This setting is required if the BlockResponse setting is OVERRIDE.
	BlockOverrideDomain *string `min:"1" type:"string"`

	// The recommended amount of time, in seconds, for the DNS resolver or web browser
	// to cache the provided override record. Used for the rule action BLOCK with
	// a BlockResponse setting of OVERRIDE.
	//
	// This setting is required if the BlockResponse setting is OVERRIDE.
	BlockOverrideTtl *int64 `type:"integer"`

	// The way that you want DNS Firewall to block the request, used with the rule
	// action setting BLOCK.
	//
	//    * NODATA - Respond indicating that the query was successful, but no response
	//    is available for it.
	//
	//    * NXDOMAIN - Respond indicating that the domain name that's in the query
	//    doesn't exist.
	//
	//    * OVERRIDE - Provide a custom override in the response. This option requires
	//    custom handling details in the rule's BlockOverride* settings.
	//
	// This setting is required if the rule action setting is BLOCK.
	BlockResponse *string `type:"string" enum:"BlockResponse"`

	// A unique string that identifies the request and that allows you to retry
	// failed requests without the risk of running the operation twice. CreatorRequestId
	// can be any unique string, for example, a date/time stamp.
	CreatorRequestId *string `min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the domain list that you want to use in the rule.
	//
	// FirewallDomainListId is a required field
	FirewallDomainListId *string `min:"1" type:"string" required:"true"`

	// The unique identifier of the firewall rule group where you want to create
	// the rule.
	//
	// FirewallRuleGroupId is a required field
	FirewallRuleGroupId *string `min:"1" type:"string" required:"true"`

	// A name that lets you identify the rule in the rule group.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The setting that determines the processing order of the rule in the rule
	// group. DNS Firewall processes the rules in a rule group by order of priority,
	// starting from the lowest setting.
	//
	// You must specify a unique priority for each rule in a rule group. To make
	// it easier to insert rules later, leave space between the numbers, for example,
	// use 100, 200, and so on. You can change the priority setting for the rules
	// in a rule group at any time.
	//
	// Priority is a required field
	Priority *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFirewallRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFirewallRuleInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.BlockOverrideDomain != nil && len(*s.BlockOverrideDomain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BlockOverrideDomain", 1))
	}
	if s.CreatorRequestId != nil && len(*s.CreatorRequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorRequestId", 1))
	}
	if s.FirewallDomainListId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallDomainListId"))
	}
	if s.FirewallDomainListId != nil && len(*s.FirewallDomainListId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallDomainListId", 1))
	}
	if s.FirewallRuleGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallRuleGroupId"))
	}
	if s.FirewallRuleGroupId != nil && len(*s.FirewallRuleGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallRuleGroupId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *CreateFirewallRuleInput) SetAction(v string) *CreateFirewallRuleInput {
	s.Action = &v
	return s
}

// SetBlockOverrideDnsType sets the BlockOverrideDnsType field's value.
func (s *CreateFirewallRuleInput) SetBlockOverrideDnsType(v string) *CreateFirewallRuleInput {
	s.BlockOverrideDnsType = &v
	return s
}

// SetBlockOverrideDomain sets the BlockOverrideDomain field's value.
func (s *CreateFirewallRuleInput) SetBlockOverrideDomain(v string) *CreateFirewallRuleInput {
	s.BlockOverrideDomain = &v
	return s
}

// SetBlockOverrideTtl sets the BlockOverrideTtl field's value.
func (s *CreateFirewallRuleInput) SetBlockOverrideTtl(v int64) *CreateFirewallRuleInput {
	s.BlockOverrideTtl = &v
	return s
}

// SetBlockResponse sets the BlockResponse field's value.
func (s *CreateFirewallRuleInput) SetBlockResponse(v string) *CreateFirewallRuleInput {
	s.BlockResponse = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateFirewallRuleInput) SetCreatorRequestId(v string) *CreateFirewallRuleInput {
	s.CreatorRequestId = &v
	return s
}

// SetFirewallDomainListId sets the FirewallDomainListId field's value.
func (s *CreateFirewallRuleInput) SetFirewallDomainListId(v string) *CreateFirewallRuleInput {
	s.FirewallDomainListId = &v
	return s
}

// SetFirewallRuleGroupId sets the FirewallRuleGroupId field's value.
func (s *CreateFirewallRuleInput) SetFirewallRuleGroupId(v string) *CreateFirewallRuleInput {
	s.FirewallRuleGroupId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFirewallRuleInput) SetName(v string) *CreateFirewallRuleInput {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *CreateFirewallRuleInput) SetPriority(v int64) *CreateFirewallRuleInput {
	s.Priority = &v
	return s
}

type CreateFirewallRuleOutput struct {
	_ struct{} `type:"structure"`

	// The firewall rule that you just created.
	FirewallRule *FirewallRule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFirewallRuleOutput) GoString() string {
	return s.String()
}

// SetFirewallRule sets the FirewallRule field's value.
func (s *CreateFirewallRuleOutput) SetFirewallRule(v *FirewallRule) *CreateFirewallRuleOutput {
	s.FirewallRule = v
	return s
}

type CreateOutpostResolverInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed requests
	// to be retried without the risk of running the operation twice.
	//
	// CreatorRequestId can be any unique string, for example, a date/time stamp.
	//
	// CreatorRequestId is a required field
	CreatorRequestId *string `min:"1" type:"string" required:"true"`

	// Number of Amazon EC2 instances for the Resolver on Outpost. The default and
	// minimal value is 4.
	InstanceCount *int64 `type:"integer"`

	// A friendly name that lets you easily find a configuration in the Resolver
	// dashboard in the Route 53 console.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Outpost. If you specify this, you must
	// also specify a value for the PreferredInstanceType.
	//
	// OutpostArn is a required field
	OutpostArn *string `min:"1" type:"string" required:"true"`

	// The Amazon EC2 instance type. If you specify this, you must also specify
	// a value for the OutpostArn.
	//
	// PreferredInstanceType is a required field
	PreferredInstanceType *string `min:"1" type:"string" required:"true"`

	// A string that helps identify the Route 53 Resolvers on Outpost.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutpostResolverInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutpostResolverInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOutpostResolverInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOutpostResolverInput"}
	if s.CreatorRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatorRequestId"))
	}
	if s.CreatorRequestId != nil && len(*s.CreatorRequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorRequestId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OutpostArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OutpostArn"))
	}
	if s.OutpostArn != nil && len(*s.OutpostArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutpostArn", 1))
	}
	if s.PreferredInstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("PreferredInstanceType"))
	}
	if s.PreferredInstanceType != nil && len(*s.PreferredInstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PreferredInstanceType", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateOutpostResolverInput) SetCreatorRequestId(v string) *CreateOutpostResolverInput {
	s.CreatorRequestId = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *CreateOutpostResolverInput) SetInstanceCount(v int64) *CreateOutpostResolverInput {
	s.InstanceCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateOutpostResolverInput) SetName(v string) *CreateOutpostResolverInput {
	s.Name = &v
	return s
}

// SetOutpostArn sets the OutpostArn field's value.
func (s *CreateOutpostResolverInput) SetOutpostArn(v string) *CreateOutpostResolverInput {
	s.OutpostArn = &v
	return s
}

// SetPreferredInstanceType sets the PreferredInstanceType field's value.
func (s *CreateOutpostResolverInput) SetPreferredInstanceType(v string) *CreateOutpostResolverInput {
	s.PreferredInstanceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateOutpostResolverInput) SetTags(v []*Tag) *CreateOutpostResolverInput {
	s.Tags = v
	return s
}

type CreateOutpostResolverOutput struct {
	_ struct{} `type:"structure"`

	// Information about the CreateOutpostResolver request, including the status
	// of the request.
	OutpostResolver *OutpostResolver `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutpostResolverOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateOutpostResolverOutput) GoString() string {
	return s.String()
}

// SetOutpostResolver sets the OutpostResolver field's value.
func (s *CreateOutpostResolverOutput) SetOutpostResolver(v *OutpostResolver) *CreateOutpostResolverOutput {
	s.OutpostResolver = v
	return s
}

type CreateResolverEndpointInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed requests
	// to be retried without the risk of running the operation twice. CreatorRequestId
	// can be any unique string, for example, a date/time stamp.
	//
	// CreatorRequestId is a required field
	CreatorRequestId *string `min:"1" type:"string" required:"true"`

	// Specify the applicable value:
	//
	//    * INBOUND: Resolver forwards DNS queries to the DNS service for a VPC
	//    from your network
	//
	//    * OUTBOUND: Resolver forwards DNS queries from the DNS service for a VPC
	//    to your network
	//
	// Direction is a required field
	Direction *string `type:"string" required:"true" enum:"ResolverEndpointDirection"`

	// The subnets and IP addresses in your VPC that DNS queries originate from
	// (for outbound endpoints) or that you forward DNS queries to (for inbound
	// endpoints). The subnet ID uniquely identifies a VPC.
	//
	// IpAddresses is a required field
	IpAddresses []*IpAddressRequest `min:"1" type:"list" required:"true"`

	// A friendly name that lets you easily find a configuration in the Resolver
	// dashboard in the Route 53 console.
	Name *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Outpost. If you specify this, you must
	// also specify a value for the PreferredInstanceType.
	OutpostArn *string `min:"1" type:"string"`

	// The instance type. If you specify this, you must also specify a value for
	// the OutpostArn.
	PreferredInstanceType *string `min:"1" type:"string"`

	// For the endpoint type you can choose either IPv4, IPv6, or dual-stack. A
	// dual-stack endpoint means that it will resolve via both IPv4 and IPv6. This
	// endpoint type is applied to all IP addresses.
	ResolverEndpointType *string `type:"string" enum:"ResolverEndpointType"`

	// The ID of one or more security groups that you want to use to control access
	// to this VPC. The security group that you specify must include one or more
	// inbound rules (for inbound Resolver endpoints) or outbound rules (for outbound
	// Resolver endpoints). Inbound and outbound rules must allow TCP and UDP access.
	// For inbound access, open port 53. For outbound access, open the port that
	// you're using for DNS queries on your network.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `type:"list" required:"true"`

	// A list of the tag keys and values that you want to associate with the endpoint.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResolverEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResolverEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResolverEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResolverEndpointInput"}
	if s.CreatorRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatorRequestId"))
	}
	if s.CreatorRequestId != nil && len(*s.CreatorRequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorRequestId", 1))
	}
	if s.Direction == nil {
		invalidParams.Add(request.NewErrParamRequired("Direction"))
	}
	if s.IpAddresses == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAddresses"))
	}
	if s.IpAddresses != nil && len(s.IpAddresses) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IpAddresses", 1))
	}
	if s.OutpostArn != nil && len(*s.OutpostArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutpostArn", 1))
	}
	if s.PreferredInstanceType != nil && len(*s.PreferredInstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PreferredInstanceType", 1))
	}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.IpAddresses != nil {
		for i, v := range s.IpAddresses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "IpAddresses", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateResolverEndpointInput) SetCreatorRequestId(v string) *CreateResolverEndpointInput {
	s.CreatorRequestId = &v
	return s
}

// SetDirection sets the Direction field's value.
func (s *CreateResolverEndpointInput) SetDirection(v string) *CreateResolverEndpointInput {
	s.Direction = &v
	return s
}

// SetIpAddresses sets the IpAddresses field's value.
func (s *CreateResolverEndpointInput) SetIpAddresses(v []*IpAddressRequest) *CreateResolverEndpointInput {
	s.IpAddresses = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResolverEndpointInput) SetName(v string) *CreateResolverEndpointInput {
	s.Name = &v
	return s
}

// SetOutpostArn sets the OutpostArn field's value.
func (s *CreateResolverEndpointInput) SetOutpostArn(v string) *CreateResolverEndpointInput {
	s.OutpostArn = &v
	return s
}

// SetPreferredInstanceType sets the PreferredInstanceType field's value.
func (s *CreateResolverEndpointInput) SetPreferredInstanceType(v string) *CreateResolverEndpointInput {
	s.PreferredInstanceType = &v
	return s
}

// SetResolverEndpointType sets the ResolverEndpointType field's value.
func (s *CreateResolverEndpointInput) SetResolverEndpointType(v string) *CreateResolverEndpointInput {
	s.ResolverEndpointType = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateResolverEndpointInput) SetSecurityGroupIds(v []*string) *CreateResolverEndpointInput {
	s.SecurityGroupIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResolverEndpointInput) SetTags(v []*Tag) *CreateResolverEndpointInput {
	s.Tags = v
	return s
}

type CreateResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Information about the CreateResolverEndpoint request, including the status
	// of the request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResolverEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *CreateResolverEndpointOutput) SetResolverEndpoint(v *ResolverEndpoint) *CreateResolverEndpointOutput {
	s.ResolverEndpoint = v
	return s
}

type CreateResolverQueryLogConfigInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed requests
	// to be retried without the risk of running the operation twice. CreatorRequestId
	// can be any unique string, for example, a date/time stamp.
	CreatorRequestId *string `min:"1" type:"string" idempotencyToken:"true"`

	// The ARN of the resource that you want Resolver to send query logs. You can
	// send query logs to an S3 bucket, a CloudWatch Logs log group, or a Kinesis
	// Data Firehose delivery stream. Examples of valid values include the following:
	//
	//    * S3 bucket: arn:aws:s3:::examplebucket You can optionally append a file
	//    prefix to the end of the ARN. arn:aws:s3:::examplebucket/development/
	//
	//    * CloudWatch Logs log group: arn:aws:logs:us-west-1:123456789012:log-group:/mystack-testgroup-12ABC1AB12A1:*
	//
	//    * Kinesis Data Firehose delivery stream: arn:aws:kinesis:us-east-2:0123456789:stream/my_stream_name
	//
	// DestinationArn is a required field
	DestinationArn *string `min:"1" type:"string" required:"true"`

	// The name that you want to give the query logging configuration.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of the tag keys and values that you want to associate with the query
	// logging configuration.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResolverQueryLogConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResolverQueryLogConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResolverQueryLogConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResolverQueryLogConfigInput"}
	if s.CreatorRequestId != nil && len(*s.CreatorRequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorRequestId", 1))
	}
	if s.DestinationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationArn"))
	}
	if s.DestinationArn != nil && len(*s.DestinationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationArn", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateResolverQueryLogConfigInput) SetCreatorRequestId(v string) *CreateResolverQueryLogConfigInput {
	s.CreatorRequestId = &v
	return s
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *CreateResolverQueryLogConfigInput) SetDestinationArn(v string) *CreateResolverQueryLogConfigInput {
	s.DestinationArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResolverQueryLogConfigInput) SetName(v string) *CreateResolverQueryLogConfigInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResolverQueryLogConfigInput) SetTags(v []*Tag) *CreateResolverQueryLogConfigInput {
	s.Tags = v
	return s
}

type CreateResolverQueryLogConfigOutput struct {
	_ struct{} `type:"structure"`

	// Information about the CreateResolverQueryLogConfig request, including the
	// status of the request.
	ResolverQueryLogConfig *ResolverQueryLogConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResolverQueryLogConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResolverQueryLogConfigOutput) GoString() string {
	return s.String()
}

// SetResolverQueryLogConfig sets the ResolverQueryLogConfig field's value.
func (s *CreateResolverQueryLogConfigOutput) SetResolverQueryLogConfig(v *ResolverQueryLogConfig) *CreateResolverQueryLogConfigOutput {
	s.ResolverQueryLogConfig = v
	return s
}

type CreateResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed requests
	// to be retried without the risk of running the operation twice. CreatorRequestId
	// can be any unique string, for example, a date/time stamp.
	//
	// CreatorRequestId is a required field
	CreatorRequestId *string `min:"1" type:"string" required:"true"`

	// DNS queries for this domain name are forwarded to the IP addresses that you
	// specify in TargetIps. If a query matches multiple Resolver rules (example.com
	// and www.example.com), outbound DNS queries are routed using the Resolver
	// rule that contains the most specific domain name (www.example.com).
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// A friendly name that lets you easily find a rule in the Resolver dashboard
	// in the Route 53 console.
	Name *string `type:"string"`

	// The ID of the outbound Resolver endpoint that you want to use to route DNS
	// queries to the IP addresses that you specify in TargetIps.
	ResolverEndpointId *string `min:"1" type:"string"`

	// When you want to forward DNS queries for specified domain name to resolvers
	// on your network, specify FORWARD.
	//
	// When you have a forwarding rule to forward DNS queries for a domain to your
	// network and you want Resolver to process queries for a subdomain of that
	// domain, specify SYSTEM.
	//
	// For example, to forward DNS queries for example.com to resolvers on your
	// network, you create a rule and specify FORWARD for RuleType. To then have
	// Resolver process queries for apex.example.com, you create a rule and specify
	// SYSTEM for RuleType.
	//
	// Currently, only Resolver can create rules that have a value of RECURSIVE
	// for RuleType.
	//
	// RuleType is a required field
	RuleType *string `type:"string" required:"true" enum:"RuleTypeOption"`

	// A list of the tag keys and values that you want to associate with the endpoint.
	Tags []*Tag `type:"list"`

	// The IPs that you want Resolver to forward DNS queries to. You can specify
	// either Ipv4 or Ipv6 addresses but not both in the same rule. Separate IP
	// addresses with a space.
	//
	// TargetIps is available only when the value of Rule type is FORWARD.
	TargetIps []*TargetAddress `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResolverRuleInput"}
	if s.CreatorRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("CreatorRequestId"))
	}
	if s.CreatorRequestId != nil && len(*s.CreatorRequestId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreatorRequestId", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}
	if s.RuleType == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleType"))
	}
	if s.TargetIps != nil && len(s.TargetIps) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetIps", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TargetIps != nil {
		for i, v := range s.TargetIps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetIps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateResolverRuleInput) SetCreatorRequestId(v string) *CreateResolverRuleInput {
	s.CreatorRequestId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateResolverRuleInput) SetDomainName(v string) *CreateResolverRuleInput {
	s.DomainName = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResolverRuleInput) SetName(v string) *CreateResolverRuleInput {
	s.Name = &v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *CreateResolverRuleInput) SetResolverEndpointId(v string) *CreateResolverRuleInput {
	s.ResolverEndpointId = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *CreateResolverRuleInput) SetRuleType(v string) *CreateResolverRuleInput {
	s.RuleType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateResolverRuleInput) SetTags(v []*Tag) *CreateResolverRuleInput {
	s.Tags = v
	return s
}

// SetTargetIps sets the TargetIps field's value.
func (s *CreateResolverRuleInput) SetTargetIps(v []*TargetAddress) *CreateResolverRuleInput {
	s.TargetIps = v
	return s
}

type CreateResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the CreateResolverRule request, including the status of
	// the request.
	ResolverRule *ResolverRule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRule sets the ResolverRule field's value.
func (s *CreateResolverRuleOutput) SetResolverRule(v *ResolverRule) *CreateResolverRuleOutput {
	s.ResolverRule = v
	return s
}

type DeleteFirewallDomainListInput struct {
	_ struct{} `type:"structure"`

	// The ID of the domain list that you want to delete.
	//
	// FirewallDomainListId is a required field
	FirewallDomainListId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallDomainListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallDomainListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFirewallDomainListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFirewallDomainListInput"}
	if s.FirewallDomainListId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallDomainListId"))
	}
	if s.FirewallDomainListId != nil && len(*s.FirewallDomainListId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallDomainListId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallDomainListId sets the FirewallDomainListId field's value.
func (s *DeleteFirewallDomainListInput) SetFirewallDomainListId(v string) *DeleteFirewallDomainListInput {
	s.FirewallDomainListId = &v
	return s
}

type DeleteFirewallDomainListOutput struct {
	_ struct{} `type:"structure"`

	// The domain list that you just deleted.
	FirewallDomainList *FirewallDomainList `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallDomainListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallDomainListOutput) GoString() string {
	return s.String()
}

// SetFirewallDomainList sets the FirewallDomainList field's value.
func (s *DeleteFirewallDomainListOutput) SetFirewallDomainList(v *FirewallDomainList) *DeleteFirewallDomainListOutput {
	s.FirewallDomainList = v
	return s
}

type DeleteFirewallRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the firewall rule group that you want to delete.
	//
	// FirewallRuleGroupId is a required field
	FirewallRuleGroupId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFirewallRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFirewallRuleGroupInput"}
	if s.FirewallRuleGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallRuleGroupId"))
	}
	if s.FirewallRuleGroupId != nil && len(*s.FirewallRuleGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallRuleGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallRuleGroupId sets the FirewallRuleGroupId field's value.
func (s *DeleteFirewallRuleGroupInput) SetFirewallRuleGroupId(v string) *DeleteFirewallRuleGroupInput {
	s.FirewallRuleGroupId = &v
	return s
}

type DeleteFirewallRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// A collection of rules used to filter DNS network traffic.
	FirewallRuleGroup *FirewallRuleGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallRuleGroupOutput) GoString() string {
	return s.String()
}

// SetFirewallRuleGroup sets the FirewallRuleGroup field's value.
func (s *DeleteFirewallRuleGroupOutput) SetFirewallRuleGroup(v *FirewallRuleGroup) *DeleteFirewallRuleGroupOutput {
	s.FirewallRuleGroup = v
	return s
}

type DeleteFirewallRuleInput struct {
	_ struct{} `type:"structure"`

	// The ID of the domain list that's used in the rule.
	//
	// FirewallDomainListId is a required field
	FirewallDomainListId *string `min:"1" type:"string" required:"true"`

	// The unique identifier of the firewall rule group that you want to delete
	// the rule from.
	//
	// FirewallRuleGroupId is a required field
	FirewallRuleGroupId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFirewallRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFirewallRuleInput"}
	if s.FirewallDomainListId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallDomainListId"))
	}
	if s.FirewallDomainListId != nil && len(*s.FirewallDomainListId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallDomainListId", 1))
	}
	if s.FirewallRuleGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallRuleGroupId"))
	}
	if s.FirewallRuleGroupId != nil && len(*s.FirewallRuleGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallRuleGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallDomainListId sets the FirewallDomainListId field's value.
func (s *DeleteFirewallRuleInput) SetFirewallDomainListId(v string) *DeleteFirewallRuleInput {
	s.FirewallDomainListId = &v
	return s
}

// SetFirewallRuleGroupId sets the FirewallRuleGroupId field's value.
func (s *DeleteFirewallRuleInput) SetFirewallRuleGroupId(v string) *DeleteFirewallRuleInput {
	s.FirewallRuleGroupId = &v
	return s
}

type DeleteFirewallRuleOutput struct {
	_ struct{} `type:"structure"`

	// The specification for the firewall rule that you just deleted.
	FirewallRule *FirewallRule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFirewallRuleOutput) GoString() string {
	return s.String()
}

// SetFirewallRule sets the FirewallRule field's value.
func (s *DeleteFirewallRuleOutput) SetFirewallRule(v *FirewallRule) *DeleteFirewallRuleOutput {
	s.FirewallRule = v
	return s
}

type DeleteOutpostResolverInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the Resolver on the Outpost.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutpostResolverInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutpostResolverInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOutpostResolverInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOutpostResolverInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteOutpostResolverInput) SetId(v string) *DeleteOutpostResolverInput {
	s.Id = &v
	return s
}

type DeleteOutpostResolverOutput struct {
	_ struct{} `type:"structure"`

	// Information about the DeleteOutpostResolver request, including the status
	// of the request.
	OutpostResolver *OutpostResolver `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutpostResolverOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteOutpostResolverOutput) GoString() string {
	return s.String()
}

// SetOutpostResolver sets the OutpostResolver field's value.
func (s *DeleteOutpostResolverOutput) SetOutpostResolver(v *OutpostResolver) *DeleteOutpostResolverOutput {
	s.OutpostResolver = v
	return s
}

type DeleteResolverEndpointInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver endpoint that you want to delete.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResolverEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResolverEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResolverEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResolverEndpointInput"}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *DeleteResolverEndpointInput) SetResolverEndpointId(v string) *DeleteResolverEndpointInput {
	s.ResolverEndpointId = &v
	return s
}

type DeleteResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Information about the DeleteResolverEndpoint request, including the status
	// of the request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResolverEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *DeleteResolverEndpointOutput) SetResolverEndpoint(v *ResolverEndpoint) *DeleteResolverEndpointOutput {
	s.ResolverEndpoint = v
	return s
}

type DeleteResolverQueryLogConfigInput struct {
	_ struct{} `type:"structure"`

	// The ID of the query logging configuration that you want to delete.
	//
	// ResolverQueryLogConfigId is a required field
	ResolverQueryLogConfigId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResolverQueryLogConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResolverQueryLogConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResolverQueryLogConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResolverQueryLogConfigInput"}
	if s.ResolverQueryLogConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverQueryLogConfigId"))
	}
	if s.ResolverQueryLogConfigId != nil && len(*s.ResolverQueryLogConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverQueryLogConfigId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverQueryLogConfigId sets the ResolverQueryLogConfigId field's value.
func (s *DeleteResolverQueryLogConfigInput) SetResolverQueryLogConfigId(v string) *DeleteResolverQueryLogConfigInput {
	s.ResolverQueryLogConfigId = &v
	return s
}

type DeleteResolverQueryLogConfigOutput struct {
	_ struct{} `type:"structure"`

	// Information about the query logging configuration that you deleted, including
	// the status of the request.
	ResolverQueryLogConfig *ResolverQueryLogConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResolverQueryLogConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResolverQueryLogConfigOutput) GoString() string {
	return s.String()
}

// SetResolverQueryLogConfig sets the ResolverQueryLogConfig field's value.
func (s *DeleteResolverQueryLogConfigOutput) SetResolverQueryLogConfig(v *ResolverQueryLogConfig) *DeleteResolverQueryLogConfigOutput {
	s.ResolverQueryLogConfig = v
	return s
}

type DeleteResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver rule that you want to delete.
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResolverRuleInput"}
	if s.ResolverRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *DeleteResolverRuleInput) SetResolverRuleId(v string) *DeleteResolverRuleInput {
	s.ResolverRuleId = &v
	return s
}

type DeleteResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the DeleteResolverRule request, including the status of
	// the request.
	ResolverRule *ResolverRule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRule sets the ResolverRule field's value.
func (s *DeleteResolverRuleOutput) SetResolverRule(v *ResolverRule) *DeleteResolverRuleOutput {
	s.ResolverRule = v
	return s
}

type DisassociateFirewallRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the FirewallRuleGroupAssociation.
	//
	// FirewallRuleGroupAssociationId is a required field
	FirewallRuleGroupAssociationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateFirewallRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateFirewallRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateFirewallRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateFirewallRuleGroupInput"}
	if s.FirewallRuleGroupAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallRuleGroupAssociationId"))
	}
	if s.FirewallRuleGroupAssociationId != nil && len(*s.FirewallRuleGroupAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallRuleGroupAssociationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallRuleGroupAssociationId sets the FirewallRuleGroupAssociationId field's value.
func (s *DisassociateFirewallRuleGroupInput) SetFirewallRuleGroupAssociationId(v string) *DisassociateFirewallRuleGroupInput {
	s.FirewallRuleGroupAssociationId = &v
	return s
}

type DisassociateFirewallRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// The firewall rule group association that you just removed.
	FirewallRuleGroupAssociation *FirewallRuleGroupAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateFirewallRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateFirewallRuleGroupOutput) GoString() string {
	return s.String()
}

// SetFirewallRuleGroupAssociation sets the FirewallRuleGroupAssociation field's value.
func (s *DisassociateFirewallRuleGroupOutput) SetFirewallRuleGroupAssociation(v *FirewallRuleGroupAssociation) *DisassociateFirewallRuleGroupOutput {
	s.FirewallRuleGroupAssociation = v
	return s
}

type DisassociateResolverEndpointIpAddressInput struct {
	_ struct{} `type:"structure"`

	// The IPv4 address that you want to remove from a Resolver endpoint.
	//
	// IpAddress is a required field
	IpAddress *IpAddressUpdate `type:"structure" required:"true"`

	// The ID of the Resolver endpoint that you want to disassociate an IP address
	// from.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResolverEndpointIpAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResolverEndpointIpAddressInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateResolverEndpointIpAddressInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateResolverEndpointIpAddressInput"}
	if s.IpAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("IpAddress"))
	}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}
	if s.IpAddress != nil {
		if err := s.IpAddress.Validate(); err != nil {
			invalidParams.AddNested("IpAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpAddress sets the IpAddress field's value.
func (s *DisassociateResolverEndpointIpAddressInput) SetIpAddress(v *IpAddressUpdate) *DisassociateResolverEndpointIpAddressInput {
	s.IpAddress = v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *DisassociateResolverEndpointIpAddressInput) SetResolverEndpointId(v string) *DisassociateResolverEndpointIpAddressInput {
	s.ResolverEndpointId = &v
	return s
}

type DisassociateResolverEndpointIpAddressOutput struct {
	_ struct{} `type:"structure"`

	// The response to an DisassociateResolverEndpointIpAddress request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResolverEndpointIpAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResolverEndpointIpAddressOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *DisassociateResolverEndpointIpAddressOutput) SetResolverEndpoint(v *ResolverEndpoint) *DisassociateResolverEndpointIpAddressOutput {
	s.ResolverEndpoint = v
	return s
}

type DisassociateResolverQueryLogConfigInput struct {
	_ struct{} `type:"structure"`

	// The ID of the query logging configuration that you want to disassociate a
	// specified VPC from.
	//
	// ResolverQueryLogConfigId is a required field
	ResolverQueryLogConfigId *string `min:"1" type:"string" required:"true"`

	// The ID of the Amazon VPC that you want to disassociate from a specified query
	// logging configuration.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResolverQueryLogConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResolverQueryLogConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateResolverQueryLogConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateResolverQueryLogConfigInput"}
	if s.ResolverQueryLogConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverQueryLogConfigId"))
	}
	if s.ResolverQueryLogConfigId != nil && len(*s.ResolverQueryLogConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverQueryLogConfigId", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverQueryLogConfigId sets the ResolverQueryLogConfigId field's value.
func (s *DisassociateResolverQueryLogConfigInput) SetResolverQueryLogConfigId(v string) *DisassociateResolverQueryLogConfigInput {
	s.ResolverQueryLogConfigId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DisassociateResolverQueryLogConfigInput) SetResourceId(v string) *DisassociateResolverQueryLogConfigInput {
	s.ResourceId = &v
	return s
}

type DisassociateResolverQueryLogConfigOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for the association that you deleted
	// between an Amazon VPC and a query logging configuration.
	ResolverQueryLogConfigAssociation *ResolverQueryLogConfigAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResolverQueryLogConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResolverQueryLogConfigOutput) GoString() string {
	return s.String()
}

// SetResolverQueryLogConfigAssociation sets the ResolverQueryLogConfigAssociation field's value.
func (s *DisassociateResolverQueryLogConfigOutput) SetResolverQueryLogConfigAssociation(v *ResolverQueryLogConfigAssociation) *DisassociateResolverQueryLogConfigOutput {
	s.ResolverQueryLogConfigAssociation = v
	return s
}

type DisassociateResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver rule that you want to disassociate from the specified
	// VPC.
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`

	// The ID of the VPC that you want to disassociate the Resolver rule from.
	//
	// VPCId is a required field
	VPCId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateResolverRuleInput"}
	if s.ResolverRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleId", 1))
	}
	if s.VPCId == nil {
		invalidParams.Add(request.NewErrParamRequired("VPCId"))
	}
	if s.VPCId != nil && len(*s.VPCId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *DisassociateResolverRuleInput) SetResolverRuleId(v string) *DisassociateResolverRuleInput {
	s.ResolverRuleId = &v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *DisassociateResolverRuleInput) SetVPCId(v string) *DisassociateResolverRuleInput {
	s.VPCId = &v
	return s
}

type DisassociateResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the DisassociateResolverRule request, including the status
	// of the request.
	ResolverRuleAssociation *ResolverRuleAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRuleAssociation sets the ResolverRuleAssociation field's value.
func (s *DisassociateResolverRuleOutput) SetResolverRuleAssociation(v *ResolverRuleAssociation) *DisassociateResolverRuleOutput {
	s.ResolverRuleAssociation = v
	return s
}

// For Resolver list operations (ListResolverEndpoints (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html),
// ListResolverRules (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html),
// ListResolverRuleAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html),
// ListResolverQueryLogConfigs (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html),
// ListResolverQueryLogConfigAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html)),
// and ListResolverDnssecConfigs (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverDnssecConfigs.html)),
// an optional specification to return a subset of objects.
//
// To filter objects, such as Resolver endpoints or Resolver rules, you specify
// Name and Values. For example, to list only inbound Resolver endpoints, specify
// Direction for Name and specify INBOUND for Values.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the parameter that you want to use to filter objects.
	//
	// The valid values for Name depend on the action that you're including the
	// filter in, ListResolverEndpoints (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html),
	// ListResolverRules (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html),
	// ListResolverRuleAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html),
	// ListResolverQueryLogConfigs (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html),
	// or ListResolverQueryLogConfigAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html).
	//
	// In early versions of Resolver, values for Name were listed as uppercase,
	// with underscore (_) delimiters. For example, CreatorRequestId was originally
	// listed as CREATOR_REQUEST_ID. Uppercase values for Name are still supported.
	//
	// ListResolverEndpoints
	//
	// Valid values for Name include the following:
	//
	//    * CreatorRequestId: The value that you specified when you created the
	//    Resolver endpoint.
	//
	//    * Direction: Whether you want to return inbound or outbound Resolver endpoints.
	//    If you specify DIRECTION for Name, specify INBOUND or OUTBOUND for Values.
	//
	//    * HostVPCId: The ID of the VPC that inbound DNS queries pass through on
	//    the way from your network to your VPCs in a region, or the VPC that outbound
	//    queries pass through on the way from your VPCs to your network. In a CreateResolverEndpoint
	//    (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html)
	//    request, SubnetId indirectly identifies the VPC. In a GetResolverEndpoint
	//    (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html)
	//    request, the VPC ID for a Resolver endpoint is returned in the HostVPCId
	//    element.
	//
	//    * IpAddressCount: The number of IP addresses that you have associated
	//    with the Resolver endpoint.
	//
	//    * Name: The name of the Resolver endpoint.
	//
	//    * SecurityGroupIds: The IDs of the VPC security groups that you specified
	//    when you created the Resolver endpoint.
	//
	//    * Status: The status of the Resolver endpoint. If you specify Status for
	//    Name, specify one of the following status codes for Values: CREATING,
	//    OPERATIONAL, UPDATING, AUTO_RECOVERING, ACTION_NEEDED, or DELETING. For
	//    more information, see Status in ResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverEndpoint.html).
	//
	// ListResolverRules
	//
	// Valid values for Name include the following:
	//
	//    * CreatorRequestId: The value that you specified when you created the
	//    Resolver rule.
	//
	//    * DomainName: The domain name for which Resolver is forwarding DNS queries
	//    to your network. In the value that you specify for Values, include a trailing
	//    dot (.) after the domain name. For example, if the domain name is example.com,
	//    specify the following value. Note the "." after com: example.com.
	//
	//    * Name: The name of the Resolver rule.
	//
	//    * ResolverEndpointId: The ID of the Resolver endpoint that the Resolver
	//    rule is associated with. You can filter on the Resolver endpoint only
	//    for rules that have a value of FORWARD for RuleType.
	//
	//    * Status: The status of the Resolver rule. If you specify Status for Name,
	//    specify one of the following status codes for Values: COMPLETE, DELETING,
	//    UPDATING, or FAILED.
	//
	//    * Type: The type of the Resolver rule. If you specify TYPE for Name, specify
	//    FORWARD or SYSTEM for Values.
	//
	// ListResolverRuleAssociations
	//
	// Valid values for Name include the following:
	//
	//    * Name: The name of the Resolver rule association.
	//
	//    * ResolverRuleId: The ID of the Resolver rule that is associated with
	//    one or more VPCs.
	//
	//    * Status: The status of the Resolver rule association. If you specify
	//    Status for Name, specify one of the following status codes for Values:
	//    CREATING, COMPLETE, DELETING, or FAILED.
	//
	//    * VPCId: The ID of the VPC that the Resolver rule is associated with.
	//
	// ListResolverQueryLogConfigs
	//
	// Valid values for Name include the following:
	//
	//    * Arn: The ARN for the query logging configuration.
	//
	//    * AssociationCount: The number of VPCs that are associated with the query
	//    logging configuration.
	//
	//    * CreationTime: The date and time that the query logging configuration
	//    was created, in Unix time format and Coordinated Universal Time (UTC).
	//
	//    * CreatorRequestId: A unique string that identifies the request that created
	//    the query logging configuration.
	//
	//    * Destination: The Amazon Web Services service that you want to forward
	//    query logs to. Valid values include the following: S3 CloudWatchLogs KinesisFirehose
	//
	//    * DestinationArn: The ARN of the location that Resolver is sending query
	//    logs to. This value can be the ARN for an S3 bucket, a CloudWatch Logs
	//    log group, or a Kinesis Data Firehose delivery stream.
	//
	//    * Id: The ID of the query logging configuration
	//
	//    * Name: The name of the query logging configuration
	//
	//    * OwnerId: The Amazon Web Services account ID for the account that created
	//    the query logging configuration.
	//
	//    * ShareStatus: An indication of whether the query logging configuration
	//    is shared with other Amazon Web Services accounts, or was shared with
	//    the current account by another Amazon Web Services account. Valid values
	//    include: NOT_SHARED, SHARED_WITH_ME, or SHARED_BY_ME.
	//
	//    * Status: The status of the query logging configuration. If you specify
	//    Status for Name, specify the applicable status code for Values: CREATING,
	//    CREATED, DELETING, or FAILED. For more information, see Status (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverQueryLogConfig.html#Route53Resolver-Type-route53resolver_ResolverQueryLogConfig-Status).
	//
	// ListResolverQueryLogConfigAssociations
	//
	// Valid values for Name include the following:
	//
	//    * CreationTime: The date and time that the VPC was associated with the
	//    query logging configuration, in Unix time format and Coordinated Universal
	//    Time (UTC).
	//
	//    * Error: If the value of Status is FAILED, specify the cause: DESTINATION_NOT_FOUND
	//    or ACCESS_DENIED.
	//
	//    * Id: The ID of the query logging association.
	//
	//    * ResolverQueryLogConfigId: The ID of the query logging configuration
	//    that a VPC is associated with.
	//
	//    * ResourceId: The ID of the Amazon VPC that is associated with the query
	//    logging configuration.
	//
	//    * Status: The status of the query logging association. If you specify
	//    Status for Name, specify the applicable status code for Values: CREATING,
	//    CREATED, DELETING, or FAILED. For more information, see Status (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ResolverQueryLogConfigAssociation.html#Route53Resolver-Type-route53resolver_ResolverQueryLogConfigAssociation-Status).
	Name *string `min:"1" type:"string"`

	// When you're using a List operation and you want the operation to return a
	// subset of objects, such as Resolver endpoints or Resolver rules, the value
	// of the parameter that you want to use to filter objects. For example, to
	// list only inbound Resolver endpoints, specify Direction for Name and specify
	// INBOUND for Values.
	Values []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// Configuration of the firewall behavior provided by DNS Firewall for a single
// VPC from Amazon Virtual Private Cloud (Amazon VPC).
type FirewallConfig struct {
	_ struct{} `type:"structure"`

	// Determines how DNS Firewall operates during failures, for example when all
	// traffic that is sent to DNS Firewall fails to receive a reply.
	//
	//    * By default, fail open is disabled, which means the failure mode is closed.
	//    This approach favors security over availability. DNS Firewall returns
	//    a failure error when it is unable to properly evaluate a query.
	//
	//    * If you enable this option, the failure mode is open. This approach favors
	//    availability over security. DNS Firewall allows queries to proceed if
	//    it is unable to properly evaluate them.
	//
	// This behavior is only enforced for VPCs that have at least one DNS Firewall
	// rule group association.
	FirewallFailOpen *string `type:"string" enum:"FirewallFailOpenStatus"`

	// The ID of the firewall configuration.
	Id *string `min:"1" type:"string"`

	// The Amazon Web Services account ID of the owner of the VPC that this firewall
	// configuration applies to.
	OwnerId *string `min:"12" type:"string"`

	// The ID of the VPC that this firewall configuration applies to.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallConfig) GoString() string {
	return s.String()
}

// SetFirewallFailOpen sets the FirewallFailOpen field's value.
func (s *FirewallConfig) SetFirewallFailOpen(v string) *FirewallConfig {
	s.FirewallFailOpen = &v
	return s
}

// SetId sets the Id field's value.
func (s *FirewallConfig) SetId(v string) *FirewallConfig {
	s.Id = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *FirewallConfig) SetOwnerId(v string) *FirewallConfig {
	s.OwnerId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *FirewallConfig) SetResourceId(v string) *FirewallConfig {
	s.ResourceId = &v
	return s
}

// High-level information about a list of firewall domains for use in a FirewallRule.
// This is returned by GetFirewallDomainList.
//
// To retrieve the domains that are defined for this domain list, call ListFirewallDomains.
type FirewallDomainList struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall domain list.
	Arn *string `min:"1" type:"string"`

	// The date and time that the domain list was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// A unique string defined by you to identify the request. This allows you to
	// retry failed requests without the risk of running the operation twice. This
	// can be any unique string, for example, a timestamp.
	CreatorRequestId *string `min:"1" type:"string"`

	// The number of domain names that are specified in the domain list.
	DomainCount *int64 `type:"integer"`

	// The ID of the domain list.
	Id *string `min:"1" type:"string"`

	// The owner of the list, used only for lists that are not managed by you. For
	// example, the managed domain list AWSManagedDomainsMalwareDomainList has the
	// managed owner name Route 53 Resolver DNS Firewall.
	ManagedOwnerName *string `min:"1" type:"string"`

	// The date and time that the domain list was last modified, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string `min:"20" type:"string"`

	// The name of the domain list.
	Name *string `type:"string"`

	// The status of the domain list.
	Status *string `type:"string" enum:"FirewallDomainListStatus"`

	// Additional information about the status of the list, if available.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallDomainList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallDomainList) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *FirewallDomainList) SetArn(v string) *FirewallDomainList {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *FirewallDomainList) SetCreationTime(v string) *FirewallDomainList {
	s.CreationTime = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *FirewallDomainList) SetCreatorRequestId(v string) *FirewallDomainList {
	s.CreatorRequestId = &v
	return s
}

// SetDomainCount sets the DomainCount field's value.
func (s *FirewallDomainList) SetDomainCount(v int64) *FirewallDomainList {
	s.DomainCount = &v
	return s
}

// SetId sets the Id field's value.
func (s *FirewallDomainList) SetId(v string) *FirewallDomainList {
	s.Id = &v
	return s
}

// SetManagedOwnerName sets the ManagedOwnerName field's value.
func (s *FirewallDomainList) SetManagedOwnerName(v string) *FirewallDomainList {
	s.ManagedOwnerName = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *FirewallDomainList) SetModificationTime(v string) *FirewallDomainList {
	s.ModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *FirewallDomainList) SetName(v string) *FirewallDomainList {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FirewallDomainList) SetStatus(v string) *FirewallDomainList {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *FirewallDomainList) SetStatusMessage(v string) *FirewallDomainList {
	s.StatusMessage = &v
	return s
}

// Minimal high-level information for a firewall domain list. The action ListFirewallDomainLists
// returns an array of these objects.
//
// To retrieve full information for a firewall domain list, call GetFirewallDomainList
// and ListFirewallDomains.
type FirewallDomainListMetadata struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall domain list metadata.
	Arn *string `min:"1" type:"string"`

	// A unique string defined by you to identify the request. This allows you to
	// retry failed requests without the risk of running the operation twice. This
	// can be any unique string, for example, a timestamp.
	CreatorRequestId *string `min:"1" type:"string"`

	// The ID of the domain list.
	Id *string `min:"1" type:"string"`

	// The owner of the list, used only for lists that are not managed by you. For
	// example, the managed domain list AWSManagedDomainsMalwareDomainList has the
	// managed owner name Route 53 Resolver DNS Firewall.
	ManagedOwnerName *string `min:"1" type:"string"`

	// The name of the domain list.
	Name *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallDomainListMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallDomainListMetadata) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *FirewallDomainListMetadata) SetArn(v string) *FirewallDomainListMetadata {
	s.Arn = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *FirewallDomainListMetadata) SetCreatorRequestId(v string) *FirewallDomainListMetadata {
	s.CreatorRequestId = &v
	return s
}

// SetId sets the Id field's value.
func (s *FirewallDomainListMetadata) SetId(v string) *FirewallDomainListMetadata {
	s.Id = &v
	return s
}

// SetManagedOwnerName sets the ManagedOwnerName field's value.
func (s *FirewallDomainListMetadata) SetManagedOwnerName(v string) *FirewallDomainListMetadata {
	s.ManagedOwnerName = &v
	return s
}

// SetName sets the Name field's value.
func (s *FirewallDomainListMetadata) SetName(v string) *FirewallDomainListMetadata {
	s.Name = &v
	return s
}

// A single firewall rule in a rule group.
type FirewallRule struct {
	_ struct{} `type:"structure"`

	// The action that DNS Firewall should take on a DNS query when it matches one
	// of the domains in the rule's domain list:
	//
	//    * ALLOW - Permit the request to go through.
	//
	//    * ALERT - Permit the request to go through but send an alert to the logs.
	//
	//    * BLOCK - Disallow the request. If this is specified, additional handling
	//    details are provided in the rule's BlockResponse setting.
	Action *string `type:"string" enum:"Action"`

	// The DNS record's type. This determines the format of the record value that
	// you provided in BlockOverrideDomain. Used for the rule action BLOCK with
	// a BlockResponse setting of OVERRIDE.
	BlockOverrideDnsType *string `type:"string" enum:"BlockOverrideDnsType"`

	// The custom DNS record to send back in response to the query. Used for the
	// rule action BLOCK with a BlockResponse setting of OVERRIDE.
	BlockOverrideDomain *string `min:"1" type:"string"`

	// The recommended amount of time, in seconds, for the DNS resolver or web browser
	// to cache the provided override record. Used for the rule action BLOCK with
	// a BlockResponse setting of OVERRIDE.
	BlockOverrideTtl *int64 `type:"integer"`

	// The way that you want DNS Firewall to block the request. Used for the rule
	// action setting BLOCK.
	//
	//    * NODATA - Respond indicating that the query was successful, but no response
	//    is available for it.
	//
	//    * NXDOMAIN - Respond indicating that the domain name that's in the query
	//    doesn't exist.
	//
	//    * OVERRIDE - Provide a custom override in the response. This option requires
	//    custom handling details in the rule's BlockOverride* settings.
	BlockResponse *string `type:"string" enum:"BlockResponse"`

	// The date and time that the rule was created, in Unix time format and Coordinated
	// Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// A unique string defined by you to identify the request. This allows you to
	// retry failed requests without the risk of executing the operation twice.
	// This can be any unique string, for example, a timestamp.
	CreatorRequestId *string `min:"1" type:"string"`

	// The ID of the domain list that's used in the rule.
	FirewallDomainListId *string `min:"1" type:"string"`

	// The unique identifier of the firewall rule group of the rule.
	FirewallRuleGroupId *string `min:"1" type:"string"`

	// The date and time that the rule was last modified, in Unix time format and
	// Coordinated Universal Time (UTC).
	ModificationTime *string `min:"20" type:"string"`

	// The name of the rule.
	Name *string `type:"string"`

	// The priority of the rule in the rule group. This value must be unique within
	// the rule group. DNS Firewall processes the rules in a rule group by order
	// of priority, starting from the lowest setting.
	Priority *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallRule) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *FirewallRule) SetAction(v string) *FirewallRule {
	s.Action = &v
	return s
}

// SetBlockOverrideDnsType sets the BlockOverrideDnsType field's value.
func (s *FirewallRule) SetBlockOverrideDnsType(v string) *FirewallRule {
	s.BlockOverrideDnsType = &v
	return s
}

// SetBlockOverrideDomain sets the BlockOverrideDomain field's value.
func (s *FirewallRule) SetBlockOverrideDomain(v string) *FirewallRule {
	s.BlockOverrideDomain = &v
	return s
}

// SetBlockOverrideTtl sets the BlockOverrideTtl field's value.
func (s *FirewallRule) SetBlockOverrideTtl(v int64) *FirewallRule {
	s.BlockOverrideTtl = &v
	return s
}

// SetBlockResponse sets the BlockResponse field's value.
func (s *FirewallRule) SetBlockResponse(v string) *FirewallRule {
	s.BlockResponse = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *FirewallRule) SetCreationTime(v string) *FirewallRule {
	s.CreationTime = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *FirewallRule) SetCreatorRequestId(v string) *FirewallRule {
	s.CreatorRequestId = &v
	return s
}

// SetFirewallDomainListId sets the FirewallDomainListId field's value.
func (s *FirewallRule) SetFirewallDomainListId(v string) *FirewallRule {
	s.FirewallDomainListId = &v
	return s
}

// SetFirewallRuleGroupId sets the FirewallRuleGroupId field's value.
func (s *FirewallRule) SetFirewallRuleGroupId(v string) *FirewallRule {
	s.FirewallRuleGroupId = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *FirewallRule) SetModificationTime(v string) *FirewallRule {
	s.ModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *FirewallRule) SetName(v string) *FirewallRule {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *FirewallRule) SetPriority(v int64) *FirewallRule {
	s.Priority = &v
	return s
}

// High-level information for a firewall rule group. A firewall rule group is
// a collection of rules that DNS Firewall uses to filter DNS network traffic
// for a VPC. To retrieve the rules for the rule group, call ListFirewallRules.
type FirewallRuleGroup struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the rule group.
	Arn *string `min:"1" type:"string"`

	// The date and time that the rule group was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// A unique string defined by you to identify the request. This allows you to
	// retry failed requests without the risk of running the operation twice. This
	// can be any unique string, for example, a timestamp.
	CreatorRequestId *string `min:"1" type:"string"`

	// The ID of the rule group.
	Id *string `min:"1" type:"string"`

	// The date and time that the rule group was last modified, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string `min:"20" type:"string"`

	// The name of the rule group.
	Name *string `type:"string"`

	// The Amazon Web Services account ID for the account that created the rule
	// group. When a rule group is shared with your account, this is the account
	// that has shared the rule group with you.
	OwnerId *string `min:"12" type:"string"`

	// The number of rules in the rule group.
	RuleCount *int64 `type:"integer"`

	// Whether the rule group is shared with other Amazon Web Services accounts,
	// or was shared with the current account by another Amazon Web Services account.
	// Sharing is configured through Resource Access Manager (RAM).
	ShareStatus *string `type:"string" enum:"ShareStatus"`

	// The status of the domain list.
	Status *string `type:"string" enum:"FirewallRuleGroupStatus"`

	// Additional information about the status of the rule group, if available.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallRuleGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallRuleGroup) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *FirewallRuleGroup) SetArn(v string) *FirewallRuleGroup {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *FirewallRuleGroup) SetCreationTime(v string) *FirewallRuleGroup {
	s.CreationTime = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *FirewallRuleGroup) SetCreatorRequestId(v string) *FirewallRuleGroup {
	s.CreatorRequestId = &v
	return s
}

// SetId sets the Id field's value.
func (s *FirewallRuleGroup) SetId(v string) *FirewallRuleGroup {
	s.Id = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *FirewallRuleGroup) SetModificationTime(v string) *FirewallRuleGroup {
	s.ModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *FirewallRuleGroup) SetName(v string) *FirewallRuleGroup {
	s.Name = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *FirewallRuleGroup) SetOwnerId(v string) *FirewallRuleGroup {
	s.OwnerId = &v
	return s
}

// SetRuleCount sets the RuleCount field's value.
func (s *FirewallRuleGroup) SetRuleCount(v int64) *FirewallRuleGroup {
	s.RuleCount = &v
	return s
}

// SetShareStatus sets the ShareStatus field's value.
func (s *FirewallRuleGroup) SetShareStatus(v string) *FirewallRuleGroup {
	s.ShareStatus = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FirewallRuleGroup) SetStatus(v string) *FirewallRuleGroup {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *FirewallRuleGroup) SetStatusMessage(v string) *FirewallRuleGroup {
	s.StatusMessage = &v
	return s
}

// An association between a firewall rule group and a VPC, which enables DNS
// filtering for the VPC.
type FirewallRuleGroupAssociation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the firewall rule group association.
	Arn *string `min:"1" type:"string"`

	// The date and time that the association was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// A unique string defined by you to identify the request. This allows you to
	// retry failed requests without the risk of running the operation twice. This
	// can be any unique string, for example, a timestamp.
	CreatorRequestId *string `min:"1" type:"string"`

	// The unique identifier of the firewall rule group.
	FirewallRuleGroupId *string `min:"1" type:"string"`

	// The identifier for the association.
	Id *string `min:"1" type:"string"`

	// The owner of the association, used only for associations that are not managed
	// by you. If you use Firewall Manager to manage your DNS Firewalls, then this
	// reports Firewall Manager as the managed owner.
	ManagedOwnerName *string `min:"1" type:"string"`

	// The date and time that the association was last modified, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string `min:"20" type:"string"`

	// If enabled, this setting disallows modification or removal of the association,
	// to help prevent against accidentally altering DNS firewall protections.
	MutationProtection *string `type:"string" enum:"MutationProtectionStatus"`

	// The name of the association.
	Name *string `type:"string"`

	// The setting that determines the processing order of the rule group among
	// the rule groups that are associated with a single VPC. DNS Firewall filters
	// VPC traffic starting from rule group with the lowest numeric priority setting.
	Priority *int64 `type:"integer"`

	// The current status of the association.
	Status *string `type:"string" enum:"FirewallRuleGroupAssociationStatus"`

	// Additional information about the status of the response, if available.
	StatusMessage *string `type:"string"`

	// The unique identifier of the VPC that is associated with the rule group.
	VpcId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallRuleGroupAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallRuleGroupAssociation) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *FirewallRuleGroupAssociation) SetArn(v string) *FirewallRuleGroupAssociation {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *FirewallRuleGroupAssociation) SetCreationTime(v string) *FirewallRuleGroupAssociation {
	s.CreationTime = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *FirewallRuleGroupAssociation) SetCreatorRequestId(v string) *FirewallRuleGroupAssociation {
	s.CreatorRequestId = &v
	return s
}

// SetFirewallRuleGroupId sets the FirewallRuleGroupId field's value.
func (s *FirewallRuleGroupAssociation) SetFirewallRuleGroupId(v string) *FirewallRuleGroupAssociation {
	s.FirewallRuleGroupId = &v
	return s
}

// SetId sets the Id field's value.
func (s *FirewallRuleGroupAssociation) SetId(v string) *FirewallRuleGroupAssociation {
	s.Id = &v
	return s
}

// SetManagedOwnerName sets the ManagedOwnerName field's value.
func (s *FirewallRuleGroupAssociation) SetManagedOwnerName(v string) *FirewallRuleGroupAssociation {
	s.ManagedOwnerName = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *FirewallRuleGroupAssociation) SetModificationTime(v string) *FirewallRuleGroupAssociation {
	s.ModificationTime = &v
	return s
}

// SetMutationProtection sets the MutationProtection field's value.
func (s *FirewallRuleGroupAssociation) SetMutationProtection(v string) *FirewallRuleGroupAssociation {
	s.MutationProtection = &v
	return s
}

// SetName sets the Name field's value.
func (s *FirewallRuleGroupAssociation) SetName(v string) *FirewallRuleGroupAssociation {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *FirewallRuleGroupAssociation) SetPriority(v int64) *FirewallRuleGroupAssociation {
	s.Priority = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FirewallRuleGroupAssociation) SetStatus(v string) *FirewallRuleGroupAssociation {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *FirewallRuleGroupAssociation) SetStatusMessage(v string) *FirewallRuleGroupAssociation {
	s.StatusMessage = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *FirewallRuleGroupAssociation) SetVpcId(v string) *FirewallRuleGroupAssociation {
	s.VpcId = &v
	return s
}

// Minimal high-level information for a firewall rule group. The action ListFirewallRuleGroups
// returns an array of these objects.
//
// To retrieve full information for a firewall rule group, call GetFirewallRuleGroup
// and ListFirewallRules.
type FirewallRuleGroupMetadata struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the rule group.
	Arn *string `min:"1" type:"string"`

	// A unique string defined by you to identify the request. This allows you to
	// retry failed requests without the risk of running the operation twice. This
	// can be any unique string, for example, a timestamp.
	CreatorRequestId *string `min:"1" type:"string"`

	// The ID of the rule group.
	Id *string `min:"1" type:"string"`

	// The name of the rule group.
	Name *string `type:"string"`

	// The Amazon Web Services account ID for the account that created the rule
	// group. When a rule group is shared with your account, this is the account
	// that has shared the rule group with you.
	OwnerId *string `min:"12" type:"string"`

	// Whether the rule group is shared with other Amazon Web Services accounts,
	// or was shared with the current account by another Amazon Web Services account.
	// Sharing is configured through Resource Access Manager (RAM).
	ShareStatus *string `type:"string" enum:"ShareStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallRuleGroupMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirewallRuleGroupMetadata) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *FirewallRuleGroupMetadata) SetArn(v string) *FirewallRuleGroupMetadata {
	s.Arn = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *FirewallRuleGroupMetadata) SetCreatorRequestId(v string) *FirewallRuleGroupMetadata {
	s.CreatorRequestId = &v
	return s
}

// SetId sets the Id field's value.
func (s *FirewallRuleGroupMetadata) SetId(v string) *FirewallRuleGroupMetadata {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *FirewallRuleGroupMetadata) SetName(v string) *FirewallRuleGroupMetadata {
	s.Name = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *FirewallRuleGroupMetadata) SetOwnerId(v string) *FirewallRuleGroupMetadata {
	s.OwnerId = &v
	return s
}

// SetShareStatus sets the ShareStatus field's value.
func (s *FirewallRuleGroupMetadata) SetShareStatus(v string) *FirewallRuleGroupMetadata {
	s.ShareStatus = &v
	return s
}

type GetFirewallConfigInput struct {
	_ struct{} `type:"structure"`

	// The ID of the VPC from Amazon VPC that the configuration is for.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFirewallConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFirewallConfigInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *GetFirewallConfigInput) SetResourceId(v string) *GetFirewallConfigInput {
	s.ResourceId = &v
	return s
}

type GetFirewallConfigOutput struct {
	_ struct{} `type:"structure"`

	// Configuration of the firewall behavior provided by DNS Firewall for a single
	// VPC from AmazonVPC.
	FirewallConfig *FirewallConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallConfigOutput) GoString() string {
	return s.String()
}

// SetFirewallConfig sets the FirewallConfig field's value.
func (s *GetFirewallConfigOutput) SetFirewallConfig(v *FirewallConfig) *GetFirewallConfigOutput {
	s.FirewallConfig = v
	return s
}

type GetFirewallDomainListInput struct {
	_ struct{} `type:"structure"`

	// The ID of the domain list.
	//
	// FirewallDomainListId is a required field
	FirewallDomainListId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallDomainListInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallDomainListInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFirewallDomainListInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFirewallDomainListInput"}
	if s.FirewallDomainListId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallDomainListId"))
	}
	if s.FirewallDomainListId != nil && len(*s.FirewallDomainListId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallDomainListId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallDomainListId sets the FirewallDomainListId field's value.
func (s *GetFirewallDomainListInput) SetFirewallDomainListId(v string) *GetFirewallDomainListInput {
	s.FirewallDomainListId = &v
	return s
}

type GetFirewallDomainListOutput struct {
	_ struct{} `type:"structure"`

	// The domain list that you requested.
	FirewallDomainList *FirewallDomainList `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallDomainListOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallDomainListOutput) GoString() string {
	return s.String()
}

// SetFirewallDomainList sets the FirewallDomainList field's value.
func (s *GetFirewallDomainListOutput) SetFirewallDomainList(v *FirewallDomainList) *GetFirewallDomainListOutput {
	s.FirewallDomainList = v
	return s
}

type GetFirewallRuleGroupAssociationInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the FirewallRuleGroupAssociation.
	//
	// FirewallRuleGroupAssociationId is a required field
	FirewallRuleGroupAssociationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallRuleGroupAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallRuleGroupAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFirewallRuleGroupAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFirewallRuleGroupAssociationInput"}
	if s.FirewallRuleGroupAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallRuleGroupAssociationId"))
	}
	if s.FirewallRuleGroupAssociationId != nil && len(*s.FirewallRuleGroupAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallRuleGroupAssociationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallRuleGroupAssociationId sets the FirewallRuleGroupAssociationId field's value.
func (s *GetFirewallRuleGroupAssociationInput) SetFirewallRuleGroupAssociationId(v string) *GetFirewallRuleGroupAssociationInput {
	s.FirewallRuleGroupAssociationId = &v
	return s
}

type GetFirewallRuleGroupAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The association that you requested.
	FirewallRuleGroupAssociation *FirewallRuleGroupAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallRuleGroupAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallRuleGroupAssociationOutput) GoString() string {
	return s.String()
}

// SetFirewallRuleGroupAssociation sets the FirewallRuleGroupAssociation field's value.
func (s *GetFirewallRuleGroupAssociationOutput) SetFirewallRuleGroupAssociation(v *FirewallRuleGroupAssociation) *GetFirewallRuleGroupAssociationOutput {
	s.FirewallRuleGroupAssociation = v
	return s
}

type GetFirewallRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the firewall rule group.
	//
	// FirewallRuleGroupId is a required field
	FirewallRuleGroupId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFirewallRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFirewallRuleGroupInput"}
	if s.FirewallRuleGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallRuleGroupId"))
	}
	if s.FirewallRuleGroupId != nil && len(*s.FirewallRuleGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallRuleGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallRuleGroupId sets the FirewallRuleGroupId field's value.
func (s *GetFirewallRuleGroupInput) SetFirewallRuleGroupId(v string) *GetFirewallRuleGroupInput {
	s.FirewallRuleGroupId = &v
	return s
}

type GetFirewallRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// A collection of rules used to filter DNS network traffic.
	FirewallRuleGroup *FirewallRuleGroup `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallRuleGroupOutput) GoString() string {
	return s.String()
}

// SetFirewallRuleGroup sets the FirewallRuleGroup field's value.
func (s *GetFirewallRuleGroupOutput) SetFirewallRuleGroup(v *FirewallRuleGroup) *GetFirewallRuleGroupOutput {
	s.FirewallRuleGroup = v
	return s
}

type GetFirewallRuleGroupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the rule group.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallRuleGroupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallRuleGroupPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFirewallRuleGroupPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFirewallRuleGroupPolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetFirewallRuleGroupPolicyInput) SetArn(v string) *GetFirewallRuleGroupPolicyInput {
	s.Arn = &v
	return s
}

type GetFirewallRuleGroupPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Identity and Access Management (Amazon Web Services IAM) policy for sharing
	// the specified rule group. You can use the policy to share the rule group
	// using Resource Access Manager (RAM).
	FirewallRuleGroupPolicy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallRuleGroupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFirewallRuleGroupPolicyOutput) GoString() string {
	return s.String()
}

// SetFirewallRuleGroupPolicy sets the FirewallRuleGroupPolicy field's value.
func (s *GetFirewallRuleGroupPolicyOutput) SetFirewallRuleGroupPolicy(v string) *GetFirewallRuleGroupPolicyOutput {
	s.FirewallRuleGroupPolicy = &v
	return s
}

type GetOutpostResolverInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver on the Outpost.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOutpostResolverInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOutpostResolverInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOutpostResolverInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOutpostResolverInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetOutpostResolverInput) SetId(v string) *GetOutpostResolverInput {
	s.Id = &v
	return s
}

type GetOutpostResolverOutput struct {
	_ struct{} `type:"structure"`

	// Information about the GetOutpostResolver request, including the status of
	// the request.
	OutpostResolver *OutpostResolver `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOutpostResolverOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetOutpostResolverOutput) GoString() string {
	return s.String()
}

// SetOutpostResolver sets the OutpostResolver field's value.
func (s *GetOutpostResolverOutput) SetOutpostResolver(v *OutpostResolver) *GetOutpostResolverOutput {
	s.OutpostResolver = v
	return s
}

type GetResolverConfigInput struct {
	_ struct{} `type:"structure"`

	// Resource ID of the Amazon VPC that you want to get information about.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverConfigInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *GetResolverConfigInput) SetResourceId(v string) *GetResolverConfigInput {
	s.ResourceId = &v
	return s
}

type GetResolverConfigOutput struct {
	_ struct{} `type:"structure"`

	// Information about the behavior configuration of Route 53 Resolver behavior
	// for the VPC you specified in the GetResolverConfig request.
	ResolverConfig *ResolverConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverConfigOutput) GoString() string {
	return s.String()
}

// SetResolverConfig sets the ResolverConfig field's value.
func (s *GetResolverConfigOutput) SetResolverConfig(v *ResolverConfig) *GetResolverConfigOutput {
	s.ResolverConfig = v
	return s
}

type GetResolverDnssecConfigInput struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual private cloud (VPC) for the DNSSEC validation status.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverDnssecConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverDnssecConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverDnssecConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverDnssecConfigInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *GetResolverDnssecConfigInput) SetResourceId(v string) *GetResolverDnssecConfigInput {
	s.ResourceId = &v
	return s
}

type GetResolverDnssecConfigOutput struct {
	_ struct{} `type:"structure"`

	// The information about a configuration for DNSSEC validation.
	ResolverDNSSECConfig *ResolverDnssecConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverDnssecConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverDnssecConfigOutput) GoString() string {
	return s.String()
}

// SetResolverDNSSECConfig sets the ResolverDNSSECConfig field's value.
func (s *GetResolverDnssecConfigOutput) SetResolverDNSSECConfig(v *ResolverDnssecConfig) *GetResolverDnssecConfigOutput {
	s.ResolverDNSSECConfig = v
	return s
}

type GetResolverEndpointInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver endpoint that you want to get information about.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverEndpointInput"}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *GetResolverEndpointInput) SetResolverEndpointId(v string) *GetResolverEndpointInput {
	s.ResolverEndpointId = &v
	return s
}

type GetResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Resolver endpoint that you specified in a GetResolverEndpoint
	// request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *GetResolverEndpointOutput) SetResolverEndpoint(v *ResolverEndpoint) *GetResolverEndpointOutput {
	s.ResolverEndpoint = v
	return s
}

type GetResolverQueryLogConfigAssociationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver query logging configuration association that you want
	// to get information about.
	//
	// ResolverQueryLogConfigAssociationId is a required field
	ResolverQueryLogConfigAssociationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverQueryLogConfigAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverQueryLogConfigAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverQueryLogConfigAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverQueryLogConfigAssociationInput"}
	if s.ResolverQueryLogConfigAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverQueryLogConfigAssociationId"))
	}
	if s.ResolverQueryLogConfigAssociationId != nil && len(*s.ResolverQueryLogConfigAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverQueryLogConfigAssociationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverQueryLogConfigAssociationId sets the ResolverQueryLogConfigAssociationId field's value.
func (s *GetResolverQueryLogConfigAssociationInput) SetResolverQueryLogConfigAssociationId(v string) *GetResolverQueryLogConfigAssociationInput {
	s.ResolverQueryLogConfigAssociationId = &v
	return s
}

type GetResolverQueryLogConfigAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Resolver query logging configuration association that
	// you specified in a GetQueryLogConfigAssociation request.
	ResolverQueryLogConfigAssociation *ResolverQueryLogConfigAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverQueryLogConfigAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverQueryLogConfigAssociationOutput) GoString() string {
	return s.String()
}

// SetResolverQueryLogConfigAssociation sets the ResolverQueryLogConfigAssociation field's value.
func (s *GetResolverQueryLogConfigAssociationOutput) SetResolverQueryLogConfigAssociation(v *ResolverQueryLogConfigAssociation) *GetResolverQueryLogConfigAssociationOutput {
	s.ResolverQueryLogConfigAssociation = v
	return s
}

type GetResolverQueryLogConfigInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver query logging configuration that you want to get information
	// about.
	//
	// ResolverQueryLogConfigId is a required field
	ResolverQueryLogConfigId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverQueryLogConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverQueryLogConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverQueryLogConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverQueryLogConfigInput"}
	if s.ResolverQueryLogConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverQueryLogConfigId"))
	}
	if s.ResolverQueryLogConfigId != nil && len(*s.ResolverQueryLogConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverQueryLogConfigId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverQueryLogConfigId sets the ResolverQueryLogConfigId field's value.
func (s *GetResolverQueryLogConfigInput) SetResolverQueryLogConfigId(v string) *GetResolverQueryLogConfigInput {
	s.ResolverQueryLogConfigId = &v
	return s
}

type GetResolverQueryLogConfigOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Resolver query logging configuration that you specified
	// in a GetQueryLogConfig request.
	ResolverQueryLogConfig *ResolverQueryLogConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverQueryLogConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverQueryLogConfigOutput) GoString() string {
	return s.String()
}

// SetResolverQueryLogConfig sets the ResolverQueryLogConfig field's value.
func (s *GetResolverQueryLogConfigOutput) SetResolverQueryLogConfig(v *ResolverQueryLogConfig) *GetResolverQueryLogConfigOutput {
	s.ResolverQueryLogConfig = v
	return s
}

type GetResolverQueryLogConfigPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the query logging configuration that you want to get the query
	// logging policy for.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverQueryLogConfigPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverQueryLogConfigPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverQueryLogConfigPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverQueryLogConfigPolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetResolverQueryLogConfigPolicyInput) SetArn(v string) *GetResolverQueryLogConfigPolicyInput {
	s.Arn = &v
	return s
}

type GetResolverQueryLogConfigPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the query logging policy for the query logging configuration
	// that you specified in a GetResolverQueryLogConfigPolicy request.
	ResolverQueryLogConfigPolicy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverQueryLogConfigPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverQueryLogConfigPolicyOutput) GoString() string {
	return s.String()
}

// SetResolverQueryLogConfigPolicy sets the ResolverQueryLogConfigPolicy field's value.
func (s *GetResolverQueryLogConfigPolicyOutput) SetResolverQueryLogConfigPolicy(v string) *GetResolverQueryLogConfigPolicyOutput {
	s.ResolverQueryLogConfigPolicy = &v
	return s
}

type GetResolverRuleAssociationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver rule association that you want to get information
	// about.
	//
	// ResolverRuleAssociationId is a required field
	ResolverRuleAssociationId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverRuleAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverRuleAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverRuleAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverRuleAssociationInput"}
	if s.ResolverRuleAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleAssociationId"))
	}
	if s.ResolverRuleAssociationId != nil && len(*s.ResolverRuleAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleAssociationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverRuleAssociationId sets the ResolverRuleAssociationId field's value.
func (s *GetResolverRuleAssociationInput) SetResolverRuleAssociationId(v string) *GetResolverRuleAssociationInput {
	s.ResolverRuleAssociationId = &v
	return s
}

type GetResolverRuleAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Resolver rule association that you specified in a GetResolverRuleAssociation
	// request.
	ResolverRuleAssociation *ResolverRuleAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverRuleAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverRuleAssociationOutput) GoString() string {
	return s.String()
}

// SetResolverRuleAssociation sets the ResolverRuleAssociation field's value.
func (s *GetResolverRuleAssociationOutput) SetResolverRuleAssociation(v *ResolverRuleAssociation) *GetResolverRuleAssociationOutput {
	s.ResolverRuleAssociation = v
	return s
}

type GetResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver rule that you want to get information about.
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverRuleInput"}
	if s.ResolverRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *GetResolverRuleInput) SetResolverRuleId(v string) *GetResolverRuleInput {
	s.ResolverRuleId = &v
	return s
}

type GetResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Resolver rule that you specified in a GetResolverRule
	// request.
	ResolverRule *ResolverRule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRule sets the ResolverRule field's value.
func (s *GetResolverRuleOutput) SetResolverRule(v *ResolverRule) *GetResolverRuleOutput {
	s.ResolverRule = v
	return s
}

type GetResolverRulePolicyInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Resolver rule that you want to get the Resolver rule policy
	// for.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverRulePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverRulePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverRulePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResolverRulePolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetResolverRulePolicyInput) SetArn(v string) *GetResolverRulePolicyInput {
	s.Arn = &v
	return s
}

type GetResolverRulePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Resolver rule policy for the rule that you specified in a GetResolverRulePolicy
	// request.
	ResolverRulePolicy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverRulePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResolverRulePolicyOutput) GoString() string {
	return s.String()
}

// SetResolverRulePolicy sets the ResolverRulePolicy field's value.
func (s *GetResolverRulePolicyOutput) SetResolverRulePolicy(v string) *GetResolverRulePolicyOutput {
	s.ResolverRulePolicy = &v
	return s
}

type ImportFirewallDomainsInput struct {
	_ struct{} `type:"structure"`

	// The fully qualified URL or URI of the file stored in Amazon Simple Storage
	// Service (Amazon S3) that contains the list of domains to import.
	//
	// The file must be in an S3 bucket that's in the same Region as your DNS Firewall.
	// The file must be a text file and must contain a single domain per line.
	//
	// DomainFileUrl is a required field
	DomainFileUrl *string `min:"1" type:"string" required:"true"`

	// The ID of the domain list that you want to modify with the import operation.
	//
	// FirewallDomainListId is a required field
	FirewallDomainListId *string `min:"1" type:"string" required:"true"`

	// What you want DNS Firewall to do with the domains that are listed in the
	// file. This must be set to REPLACE, which updates the domain list to exactly
	// match the list in the file.
	//
	// Operation is a required field
	Operation *string `type:"string" required:"true" enum:"FirewallDomainImportOperation"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportFirewallDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportFirewallDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportFirewallDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportFirewallDomainsInput"}
	if s.DomainFileUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainFileUrl"))
	}
	if s.DomainFileUrl != nil && len(*s.DomainFileUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainFileUrl", 1))
	}
	if s.FirewallDomainListId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallDomainListId"))
	}
	if s.FirewallDomainListId != nil && len(*s.FirewallDomainListId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallDomainListId", 1))
	}
	if s.Operation == nil {
		invalidParams.Add(request.NewErrParamRequired("Operation"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainFileUrl sets the DomainFileUrl field's value.
func (s *ImportFirewallDomainsInput) SetDomainFileUrl(v string) *ImportFirewallDomainsInput {
	s.DomainFileUrl = &v
	return s
}

// SetFirewallDomainListId sets the FirewallDomainListId field's value.
func (s *ImportFirewallDomainsInput) SetFirewallDomainListId(v string) *ImportFirewallDomainsInput {
	s.FirewallDomainListId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *ImportFirewallDomainsInput) SetOperation(v string) *ImportFirewallDomainsInput {
	s.Operation = &v
	return s
}

type ImportFirewallDomainsOutput struct {
	_ struct{} `type:"structure"`

	// The Id of the firewall domain list that DNS Firewall just updated.
	Id *string `min:"1" type:"string"`

	// The name of the domain list.
	Name *string `type:"string"`

	// Status of the import request.
	Status *string `type:"string" enum:"FirewallDomainListStatus"`

	// Additional information about the status of the list, if available.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportFirewallDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportFirewallDomainsOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ImportFirewallDomainsOutput) SetId(v string) *ImportFirewallDomainsOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ImportFirewallDomainsOutput) SetName(v string) *ImportFirewallDomainsOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ImportFirewallDomainsOutput) SetStatus(v string) *ImportFirewallDomainsOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ImportFirewallDomainsOutput) SetStatusMessage(v string) *ImportFirewallDomainsOutput {
	s.StatusMessage = &v
	return s
}

// We encountered an unknown error. Try again in a few minutes.
type InternalServiceErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServiceErrorException(v protocol.ResponseMetadata) error {
	return &InternalServiceErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceErrorException) Code() string {
	return "InternalServiceErrorException"
}

// Message returns the exception's message.
func (s *InternalServiceErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceErrorException) OrigErr() error {
	return nil
}

func (s *InternalServiceErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The value that you specified for NextToken in a List request isn't valid.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more parameters in this request are not valid.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// For an InvalidParameterException error, the name of the parameter that's
	// invalid.
	FieldName *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified Resolver rule policy is invalid.
type InvalidPolicyDocument struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPolicyDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPolicyDocument) GoString() string {
	return s.String()
}

func newErrorInvalidPolicyDocument(v protocol.ResponseMetadata) error {
	return &InvalidPolicyDocument{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPolicyDocument) Code() string {
	return "InvalidPolicyDocument"
}

// Message returns the exception's message.
func (s *InvalidPolicyDocument) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPolicyDocument) OrigErr() error {
	return nil
}

func (s *InvalidPolicyDocument) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPolicyDocument) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPolicyDocument) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request is invalid.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified tag is invalid.
type InvalidTagException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTagException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidTagException) GoString() string {
	return s.String()
}

func newErrorInvalidTagException(v protocol.ResponseMetadata) error {
	return &InvalidTagException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidTagException) Code() string {
	return "InvalidTagException"
}

// Message returns the exception's message.
func (s *InvalidTagException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidTagException) OrigErr() error {
	return nil
}

func (s *InvalidTagException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidTagException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidTagException) RequestID() string {
	return s.RespMetadata.RequestID
}

// In a CreateResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html)
// request, the IP address that DNS queries originate from (for outbound endpoints)
// or that you forward DNS queries to (for inbound endpoints). IpAddressRequest
// also includes the ID of the subnet that contains the IP address.
type IpAddressRequest struct {
	_ struct{} `type:"structure"`

	// The IPv4 address that you want to use for DNS queries.
	Ip *string `min:"7" type:"string"`

	// The IPv6 address that you want to use for DNS queries.
	Ipv6 *string `min:"7" type:"string"`

	// The ID of the subnet that contains the IP address.
	//
	// SubnetId is a required field
	SubnetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpAddressRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpAddressRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IpAddressRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IpAddressRequest"}
	if s.Ip != nil && len(*s.Ip) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Ip", 7))
	}
	if s.Ipv6 != nil && len(*s.Ipv6) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Ipv6", 7))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}
	if s.SubnetId != nil && len(*s.SubnetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIp sets the Ip field's value.
func (s *IpAddressRequest) SetIp(v string) *IpAddressRequest {
	s.Ip = &v
	return s
}

// SetIpv6 sets the Ipv6 field's value.
func (s *IpAddressRequest) SetIpv6(v string) *IpAddressRequest {
	s.Ipv6 = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *IpAddressRequest) SetSubnetId(v string) *IpAddressRequest {
	s.SubnetId = &v
	return s
}

// In the response to a GetResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html)
// request, information about the IP addresses that the Resolver endpoint uses
// for DNS queries.
type IpAddressResponse struct {
	_ struct{} `type:"structure"`

	// The date and time that the IP address was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// One IPv4 address that the Resolver endpoint uses for DNS queries.
	Ip *string `min:"7" type:"string"`

	// The ID of one IP address.
	IpId *string `min:"1" type:"string"`

	// One IPv6 address that the Resolver endpoint uses for DNS queries.
	Ipv6 *string `min:"7" type:"string"`

	// The date and time that the IP address was last modified, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string `min:"20" type:"string"`

	// A status code that gives the current status of the request.
	Status *string `type:"string" enum:"IpAddressStatus"`

	// A message that provides additional information about the status of the request.
	StatusMessage *string `type:"string"`

	// The ID of one subnet.
	SubnetId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpAddressResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpAddressResponse) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *IpAddressResponse) SetCreationTime(v string) *IpAddressResponse {
	s.CreationTime = &v
	return s
}

// SetIp sets the Ip field's value.
func (s *IpAddressResponse) SetIp(v string) *IpAddressResponse {
	s.Ip = &v
	return s
}

// SetIpId sets the IpId field's value.
func (s *IpAddressResponse) SetIpId(v string) *IpAddressResponse {
	s.IpId = &v
	return s
}

// SetIpv6 sets the Ipv6 field's value.
func (s *IpAddressResponse) SetIpv6(v string) *IpAddressResponse {
	s.Ipv6 = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *IpAddressResponse) SetModificationTime(v string) *IpAddressResponse {
	s.ModificationTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *IpAddressResponse) SetStatus(v string) *IpAddressResponse {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *IpAddressResponse) SetStatusMessage(v string) *IpAddressResponse {
	s.StatusMessage = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *IpAddressResponse) SetSubnetId(v string) *IpAddressResponse {
	s.SubnetId = &v
	return s
}

// In an UpdateResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html)
// request, information about an IP address to update.
type IpAddressUpdate struct {
	_ struct{} `type:"structure"`

	// The new IPv4 address.
	Ip *string `min:"7" type:"string"`

	// Only when removing an IP address from a Resolver endpoint: The ID of the
	// IP address that you want to remove. To get this ID, use GetResolverEndpoint
	// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html).
	IpId *string `min:"1" type:"string"`

	// The new IPv6 address.
	Ipv6 *string `min:"7" type:"string"`

	// The ID of the subnet that includes the IP address that you want to update.
	// To get this ID, use GetResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html).
	SubnetId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpAddressUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpAddressUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IpAddressUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IpAddressUpdate"}
	if s.Ip != nil && len(*s.Ip) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Ip", 7))
	}
	if s.IpId != nil && len(*s.IpId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IpId", 1))
	}
	if s.Ipv6 != nil && len(*s.Ipv6) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Ipv6", 7))
	}
	if s.SubnetId != nil && len(*s.SubnetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIp sets the Ip field's value.
func (s *IpAddressUpdate) SetIp(v string) *IpAddressUpdate {
	s.Ip = &v
	return s
}

// SetIpId sets the IpId field's value.
func (s *IpAddressUpdate) SetIpId(v string) *IpAddressUpdate {
	s.IpId = &v
	return s
}

// SetIpv6 sets the Ipv6 field's value.
func (s *IpAddressUpdate) SetIpv6(v string) *IpAddressUpdate {
	s.Ipv6 = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *IpAddressUpdate) SetSubnetId(v string) *IpAddressUpdate {
	s.SubnetId = &v
	return s
}

// The request caused one or more limits to be exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// For a LimitExceededException error, the type of resource that exceeded the
	// current limit.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListFirewallConfigsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want Resolver to return for this request.
	// If more objects are available, in the response, Resolver provides a NextToken
	// value that you can use in a subsequent call to get the next batch of objects.
	//
	// If you don't specify a value for MaxResults, Resolver returns up to 100 objects.
	MaxResults *int64 `min:"5" type:"integer"`

	// For the first call to this list request, omit this value.
	//
	// When you request a list of objects, Resolver returns at most the number of
	// objects specified in MaxResults. If more objects are available for retrieval,
	// Resolver returns a NextToken value in the response. To retrieve the next
	// batch of objects, use the token that was returned for the prior request in
	// your next request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFirewallConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFirewallConfigsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFirewallConfigsInput) SetMaxResults(v int64) *ListFirewallConfigsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallConfigsInput) SetNextToken(v string) *ListFirewallConfigsInput {
	s.NextToken = &v
	return s
}

type ListFirewallConfigsOutput struct {
	_ struct{} `type:"structure"`

	// The configurations for the firewall behavior provided by DNS Firewall for
	// VPCs from Amazon Virtual Private Cloud (Amazon VPC).
	FirewallConfigs []*FirewallConfig `type:"list"`

	// If objects are still available for retrieval, Resolver returns this token
	// in the response. To retrieve the next batch of objects, provide this token
	// in your next request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallConfigsOutput) GoString() string {
	return s.String()
}

// SetFirewallConfigs sets the FirewallConfigs field's value.
func (s *ListFirewallConfigsOutput) SetFirewallConfigs(v []*FirewallConfig) *ListFirewallConfigsOutput {
	s.FirewallConfigs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallConfigsOutput) SetNextToken(v string) *ListFirewallConfigsOutput {
	s.NextToken = &v
	return s
}

type ListFirewallDomainListsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want Resolver to return for this request.
	// If more objects are available, in the response, Resolver provides a NextToken
	// value that you can use in a subsequent call to get the next batch of objects.
	//
	// If you don't specify a value for MaxResults, Resolver returns up to 100 objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first call to this list request, omit this value.
	//
	// When you request a list of objects, Resolver returns at most the number of
	// objects specified in MaxResults. If more objects are available for retrieval,
	// Resolver returns a NextToken value in the response. To retrieve the next
	// batch of objects, use the token that was returned for the prior request in
	// your next request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallDomainListsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallDomainListsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFirewallDomainListsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFirewallDomainListsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFirewallDomainListsInput) SetMaxResults(v int64) *ListFirewallDomainListsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallDomainListsInput) SetNextToken(v string) *ListFirewallDomainListsInput {
	s.NextToken = &v
	return s
}

type ListFirewallDomainListsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the domain lists that you have defined.
	//
	// This might be a partial list of the domain lists that you've defined. For
	// information, see MaxResults.
	FirewallDomainLists []*FirewallDomainListMetadata `type:"list"`

	// If objects are still available for retrieval, Resolver returns this token
	// in the response. To retrieve the next batch of objects, provide this token
	// in your next request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallDomainListsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallDomainListsOutput) GoString() string {
	return s.String()
}

// SetFirewallDomainLists sets the FirewallDomainLists field's value.
func (s *ListFirewallDomainListsOutput) SetFirewallDomainLists(v []*FirewallDomainListMetadata) *ListFirewallDomainListsOutput {
	s.FirewallDomainLists = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallDomainListsOutput) SetNextToken(v string) *ListFirewallDomainListsOutput {
	s.NextToken = &v
	return s
}

type ListFirewallDomainsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the domain list whose domains you want to retrieve.
	//
	// FirewallDomainListId is a required field
	FirewallDomainListId *string `min:"1" type:"string" required:"true"`

	// The maximum number of objects that you want Resolver to return for this request.
	// If more objects are available, in the response, Resolver provides a NextToken
	// value that you can use in a subsequent call to get the next batch of objects.
	//
	// If you don't specify a value for MaxResults, Resolver returns up to 100 objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first call to this list request, omit this value.
	//
	// When you request a list of objects, Resolver returns at most the number of
	// objects specified in MaxResults. If more objects are available for retrieval,
	// Resolver returns a NextToken value in the response. To retrieve the next
	// batch of objects, use the token that was returned for the prior request in
	// your next request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFirewallDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFirewallDomainsInput"}
	if s.FirewallDomainListId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallDomainListId"))
	}
	if s.FirewallDomainListId != nil && len(*s.FirewallDomainListId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallDomainListId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallDomainListId sets the FirewallDomainListId field's value.
func (s *ListFirewallDomainsInput) SetFirewallDomainListId(v string) *ListFirewallDomainsInput {
	s.FirewallDomainListId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFirewallDomainsInput) SetMaxResults(v int64) *ListFirewallDomainsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallDomainsInput) SetNextToken(v string) *ListFirewallDomainsInput {
	s.NextToken = &v
	return s
}

type ListFirewallDomainsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the domains in the firewall domain list.
	//
	// This might be a partial list of the domains that you've defined in the domain
	// list. For information, see MaxResults.
	Domains []*string `type:"list"`

	// If objects are still available for retrieval, Resolver returns this token
	// in the response. To retrieve the next batch of objects, provide this token
	// in your next request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallDomainsOutput) GoString() string {
	return s.String()
}

// SetDomains sets the Domains field's value.
func (s *ListFirewallDomainsOutput) SetDomains(v []*string) *ListFirewallDomainsOutput {
	s.Domains = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallDomainsOutput) SetNextToken(v string) *ListFirewallDomainsOutput {
	s.NextToken = &v
	return s
}

type ListFirewallRuleGroupAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the firewall rule group that you want to retrieve
	// the associations for. Leave this blank to retrieve associations for any rule
	// group.
	FirewallRuleGroupId *string `min:"1" type:"string"`

	// The maximum number of objects that you want Resolver to return for this request.
	// If more objects are available, in the response, Resolver provides a NextToken
	// value that you can use in a subsequent call to get the next batch of objects.
	//
	// If you don't specify a value for MaxResults, Resolver returns up to 100 objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first call to this list request, omit this value.
	//
	// When you request a list of objects, Resolver returns at most the number of
	// objects specified in MaxResults. If more objects are available for retrieval,
	// Resolver returns a NextToken value in the response. To retrieve the next
	// batch of objects, use the token that was returned for the prior request in
	// your next request.
	NextToken *string `type:"string"`

	// The setting that determines the processing order of the rule group among
	// the rule groups that are associated with a single VPC. DNS Firewall filters
	// VPC traffic starting from the rule group with the lowest numeric priority
	// setting.
	Priority *int64 `type:"integer"`

	// The association Status setting that you want DNS Firewall to filter on for
	// the list. If you don't specify this, then DNS Firewall returns all associations,
	// regardless of status.
	Status *string `type:"string" enum:"FirewallRuleGroupAssociationStatus"`

	// The unique identifier of the VPC that you want to retrieve the associations
	// for. Leave this blank to retrieve associations for any VPC.
	VpcId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallRuleGroupAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallRuleGroupAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFirewallRuleGroupAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFirewallRuleGroupAssociationsInput"}
	if s.FirewallRuleGroupId != nil && len(*s.FirewallRuleGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallRuleGroupId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.VpcId != nil && len(*s.VpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallRuleGroupId sets the FirewallRuleGroupId field's value.
func (s *ListFirewallRuleGroupAssociationsInput) SetFirewallRuleGroupId(v string) *ListFirewallRuleGroupAssociationsInput {
	s.FirewallRuleGroupId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFirewallRuleGroupAssociationsInput) SetMaxResults(v int64) *ListFirewallRuleGroupAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallRuleGroupAssociationsInput) SetNextToken(v string) *ListFirewallRuleGroupAssociationsInput {
	s.NextToken = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *ListFirewallRuleGroupAssociationsInput) SetPriority(v int64) *ListFirewallRuleGroupAssociationsInput {
	s.Priority = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListFirewallRuleGroupAssociationsInput) SetStatus(v string) *ListFirewallRuleGroupAssociationsInput {
	s.Status = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *ListFirewallRuleGroupAssociationsInput) SetVpcId(v string) *ListFirewallRuleGroupAssociationsInput {
	s.VpcId = &v
	return s
}

type ListFirewallRuleGroupAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of your firewall rule group associations.
	//
	// This might be a partial list of the associations that you have defined. For
	// information, see MaxResults.
	FirewallRuleGroupAssociations []*FirewallRuleGroupAssociation `type:"list"`

	// If objects are still available for retrieval, Resolver returns this token
	// in the response. To retrieve the next batch of objects, provide this token
	// in your next request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallRuleGroupAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallRuleGroupAssociationsOutput) GoString() string {
	return s.String()
}

// SetFirewallRuleGroupAssociations sets the FirewallRuleGroupAssociations field's value.
func (s *ListFirewallRuleGroupAssociationsOutput) SetFirewallRuleGroupAssociations(v []*FirewallRuleGroupAssociation) *ListFirewallRuleGroupAssociationsOutput {
	s.FirewallRuleGroupAssociations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallRuleGroupAssociationsOutput) SetNextToken(v string) *ListFirewallRuleGroupAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListFirewallRuleGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects that you want Resolver to return for this request.
	// If more objects are available, in the response, Resolver provides a NextToken
	// value that you can use in a subsequent call to get the next batch of objects.
	//
	// If you don't specify a value for MaxResults, Resolver returns up to 100 objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first call to this list request, omit this value.
	//
	// When you request a list of objects, Resolver returns at most the number of
	// objects specified in MaxResults. If more objects are available for retrieval,
	// Resolver returns a NextToken value in the response. To retrieve the next
	// batch of objects, use the token that was returned for the prior request in
	// your next request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallRuleGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallRuleGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFirewallRuleGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFirewallRuleGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFirewallRuleGroupsInput) SetMaxResults(v int64) *ListFirewallRuleGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallRuleGroupsInput) SetNextToken(v string) *ListFirewallRuleGroupsInput {
	s.NextToken = &v
	return s
}

type ListFirewallRuleGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of your firewall rule groups.
	//
	// This might be a partial list of the rule groups that you have defined. For
	// information, see MaxResults.
	FirewallRuleGroups []*FirewallRuleGroupMetadata `type:"list"`

	// If objects are still available for retrieval, Resolver returns this token
	// in the response. To retrieve the next batch of objects, provide this token
	// in your next request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallRuleGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallRuleGroupsOutput) GoString() string {
	return s.String()
}

// SetFirewallRuleGroups sets the FirewallRuleGroups field's value.
func (s *ListFirewallRuleGroupsOutput) SetFirewallRuleGroups(v []*FirewallRuleGroupMetadata) *ListFirewallRuleGroupsOutput {
	s.FirewallRuleGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallRuleGroupsOutput) SetNextToken(v string) *ListFirewallRuleGroupsOutput {
	s.NextToken = &v
	return s
}

type ListFirewallRulesInput struct {
	_ struct{} `type:"structure"`

	// Optional additional filter for the rules to retrieve.
	//
	// The action that DNS Firewall should take on a DNS query when it matches one
	// of the domains in the rule's domain list:
	//
	//    * ALLOW - Permit the request to go through.
	//
	//    * ALERT - Permit the request to go through but send an alert to the logs.
	//
	//    * BLOCK - Disallow the request. If this is specified, additional handling
	//    details are provided in the rule's BlockResponse setting.
	Action *string `type:"string" enum:"Action"`

	// The unique identifier of the firewall rule group that you want to retrieve
	// the rules for.
	//
	// FirewallRuleGroupId is a required field
	FirewallRuleGroupId *string `min:"1" type:"string" required:"true"`

	// The maximum number of objects that you want Resolver to return for this request.
	// If more objects are available, in the response, Resolver provides a NextToken
	// value that you can use in a subsequent call to get the next batch of objects.
	//
	// If you don't specify a value for MaxResults, Resolver returns up to 100 objects.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first call to this list request, omit this value.
	//
	// When you request a list of objects, Resolver returns at most the number of
	// objects specified in MaxResults. If more objects are available for retrieval,
	// Resolver returns a NextToken value in the response. To retrieve the next
	// batch of objects, use the token that was returned for the prior request in
	// your next request.
	NextToken *string `type:"string"`

	// Optional additional filter for the rules to retrieve.
	//
	// The setting that determines the processing order of the rules in a rule group.
	// DNS Firewall processes the rules in a rule group by order of priority, starting
	// from the lowest setting.
	Priority *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFirewallRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFirewallRulesInput"}
	if s.FirewallRuleGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallRuleGroupId"))
	}
	if s.FirewallRuleGroupId != nil && len(*s.FirewallRuleGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallRuleGroupId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *ListFirewallRulesInput) SetAction(v string) *ListFirewallRulesInput {
	s.Action = &v
	return s
}

// SetFirewallRuleGroupId sets the FirewallRuleGroupId field's value.
func (s *ListFirewallRulesInput) SetFirewallRuleGroupId(v string) *ListFirewallRulesInput {
	s.FirewallRuleGroupId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFirewallRulesInput) SetMaxResults(v int64) *ListFirewallRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallRulesInput) SetNextToken(v string) *ListFirewallRulesInput {
	s.NextToken = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *ListFirewallRulesInput) SetPriority(v int64) *ListFirewallRulesInput {
	s.Priority = &v
	return s
}

type ListFirewallRulesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the rules that you have defined.
	//
	// This might be a partial list of the firewall rules that you've defined. For
	// information, see MaxResults.
	FirewallRules []*FirewallRule `type:"list"`

	// If objects are still available for retrieval, Resolver returns this token
	// in the response. To retrieve the next batch of objects, provide this token
	// in your next request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFirewallRulesOutput) GoString() string {
	return s.String()
}

// SetFirewallRules sets the FirewallRules field's value.
func (s *ListFirewallRulesOutput) SetFirewallRules(v []*FirewallRule) *ListFirewallRulesOutput {
	s.FirewallRules = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFirewallRulesOutput) SetNextToken(v string) *ListFirewallRulesOutput {
	s.NextToken = &v
	return s
}

type ListOutpostResolversInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of Resolvers on the Outpost that you want to return in
	// the response to a ListOutpostResolver request. If you don't specify a value
	// for MaxResults, the request returns up to 100 Resolvers.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListOutpostResolver request, omit this value.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Outpost.
	OutpostArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOutpostResolversInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOutpostResolversInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOutpostResolversInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOutpostResolversInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.OutpostArn != nil && len(*s.OutpostArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutpostArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOutpostResolversInput) SetMaxResults(v int64) *ListOutpostResolversInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOutpostResolversInput) SetNextToken(v string) *ListOutpostResolversInput {
	s.NextToken = &v
	return s
}

// SetOutpostArn sets the OutpostArn field's value.
func (s *ListOutpostResolversInput) SetOutpostArn(v string) *ListOutpostResolversInput {
	s.OutpostArn = &v
	return s
}

type ListOutpostResolversOutput struct {
	_ struct{} `type:"structure"`

	// If more than MaxResults Resolvers match the specified criteria, you can submit
	// another ListOutpostResolver request to get the next group of results. In
	// the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The Resolvers on Outposts that were created by using the current Amazon Web
	// Services account, and that match the specified filters, if any.
	OutpostResolvers []*OutpostResolver `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOutpostResolversOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListOutpostResolversOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOutpostResolversOutput) SetNextToken(v string) *ListOutpostResolversOutput {
	s.NextToken = &v
	return s
}

// SetOutpostResolvers sets the OutpostResolvers field's value.
func (s *ListOutpostResolversOutput) SetOutpostResolvers(v []*OutpostResolver) *ListOutpostResolversOutput {
	s.OutpostResolvers = v
	return s
}

type ListResolverConfigsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of Resolver configurations that you want to return in
	// the response to a ListResolverConfigs request. If you don't specify a value
	// for MaxResults, up to 100 Resolver configurations are returned.
	MaxResults *int64 `min:"5" type:"integer"`

	// (Optional) If the current Amazon Web Services account has more than MaxResults
	// Resolver configurations, use NextToken to get the second and subsequent pages
	// of results.
	//
	// For the first ListResolverConfigs request, omit this value.
	//
	// For the second and subsequent requests, get the value of NextToken from the
	// previous response and specify that value for NextToken in the request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverConfigsInput"}
	if s.MaxResults != nil && *s.MaxResults < 5 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverConfigsInput) SetMaxResults(v int64) *ListResolverConfigsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverConfigsInput) SetNextToken(v string) *ListResolverConfigsInput {
	s.NextToken = &v
	return s
}

type ListResolverConfigsOutput struct {
	_ struct{} `type:"structure"`

	// If a response includes the last of the Resolver configurations that are associated
	// with the current Amazon Web Services account, NextToken doesn't appear in
	// the response.
	//
	// If a response doesn't include the last of the configurations, you can get
	// more configurations by submitting another ListResolverConfigs request. Get
	// the value of NextToken that Amazon Route 53 returned in the previous response
	// and include it in NextToken in the next request.
	NextToken *string `type:"string"`

	// An array that contains one ResolverConfigs element for each Resolver configuration
	// that is associated with the current Amazon Web Services account.
	ResolverConfigs []*ResolverConfig `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverConfigsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverConfigsOutput) SetNextToken(v string) *ListResolverConfigsOutput {
	s.NextToken = &v
	return s
}

// SetResolverConfigs sets the ResolverConfigs field's value.
func (s *ListResolverConfigsOutput) SetResolverConfigs(v []*ResolverConfig) *ListResolverConfigsOutput {
	s.ResolverConfigs = v
	return s
}

type ListResolverDnssecConfigsInput struct {
	_ struct{} `type:"structure"`

	// An optional specification to return a subset of objects.
	Filters []*Filter `type:"list"`

	// Optional: An integer that specifies the maximum number of DNSSEC configuration
	// results that you want Amazon Route 53 to return. If you don't specify a value
	// for MaxResults, Route 53 returns up to 100 configuration per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) If the current Amazon Web Services account has more than MaxResults
	// DNSSEC configurations, use NextToken to get the second and subsequent pages
	// of results.
	//
	// For the first ListResolverDnssecConfigs request, omit this value.
	//
	// For the second and subsequent requests, get the value of NextToken from the
	// previous response and specify that value for NextToken in the request.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverDnssecConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverDnssecConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverDnssecConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverDnssecConfigsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResolverDnssecConfigsInput) SetFilters(v []*Filter) *ListResolverDnssecConfigsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverDnssecConfigsInput) SetMaxResults(v int64) *ListResolverDnssecConfigsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverDnssecConfigsInput) SetNextToken(v string) *ListResolverDnssecConfigsInput {
	s.NextToken = &v
	return s
}

type ListResolverDnssecConfigsOutput struct {
	_ struct{} `type:"structure"`

	// If a response includes the last of the DNSSEC configurations that are associated
	// with the current Amazon Web Services account, NextToken doesn't appear in
	// the response.
	//
	// If a response doesn't include the last of the configurations, you can get
	// more configurations by submitting another ListResolverDnssecConfigs (https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListResolverDnssecConfigs.html)
	// request. Get the value of NextToken that Amazon Route 53 returned in the
	// previous response and include it in NextToken in the next request.
	NextToken *string `type:"string"`

	// An array that contains one ResolverDnssecConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResolverDnssecConfig.html)
	// element for each configuration for DNSSEC validation that is associated with
	// the current Amazon Web Services account.
	ResolverDnssecConfigs []*ResolverDnssecConfig `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverDnssecConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverDnssecConfigsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverDnssecConfigsOutput) SetNextToken(v string) *ListResolverDnssecConfigsOutput {
	s.NextToken = &v
	return s
}

// SetResolverDnssecConfigs sets the ResolverDnssecConfigs field's value.
func (s *ListResolverDnssecConfigsOutput) SetResolverDnssecConfigs(v []*ResolverDnssecConfig) *ListResolverDnssecConfigsOutput {
	s.ResolverDnssecConfigs = v
	return s
}

type ListResolverEndpointIpAddressesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of IP addresses that you want to return in the response
	// to a ListResolverEndpointIpAddresses request. If you don't specify a value
	// for MaxResults, Resolver returns up to 100 IP addresses.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverEndpointIpAddresses request, omit this value.
	//
	// If the specified Resolver endpoint has more than MaxResults IP addresses,
	// you can submit another ListResolverEndpointIpAddresses request to get the
	// next group of IP addresses. In the next request, specify the value of NextToken
	// from the previous response.
	NextToken *string `type:"string"`

	// The ID of the Resolver endpoint that you want to get IP addresses for.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverEndpointIpAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverEndpointIpAddressesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverEndpointIpAddressesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverEndpointIpAddressesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverEndpointIpAddressesInput) SetMaxResults(v int64) *ListResolverEndpointIpAddressesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverEndpointIpAddressesInput) SetNextToken(v string) *ListResolverEndpointIpAddressesInput {
	s.NextToken = &v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *ListResolverEndpointIpAddressesInput) SetResolverEndpointId(v string) *ListResolverEndpointIpAddressesInput {
	s.ResolverEndpointId = &v
	return s
}

type ListResolverEndpointIpAddressesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the IP addresses in your VPC that DNS queries originate
	// from (for outbound endpoints) or that you forward DNS queries to (for inbound
	// endpoints).
	IpAddresses []*IpAddressResponse `type:"list"`

	// The value that you specified for MaxResults in the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the specified endpoint has more than MaxResults IP addresses, you can
	// submit another ListResolverEndpointIpAddresses request to get the next group
	// of IP addresses. In the next request, specify the value of NextToken from
	// the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverEndpointIpAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverEndpointIpAddressesOutput) GoString() string {
	return s.String()
}

// SetIpAddresses sets the IpAddresses field's value.
func (s *ListResolverEndpointIpAddressesOutput) SetIpAddresses(v []*IpAddressResponse) *ListResolverEndpointIpAddressesOutput {
	s.IpAddresses = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverEndpointIpAddressesOutput) SetMaxResults(v int64) *ListResolverEndpointIpAddressesOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverEndpointIpAddressesOutput) SetNextToken(v string) *ListResolverEndpointIpAddressesOutput {
	s.NextToken = &v
	return s
}

type ListResolverEndpointsInput struct {
	_ struct{} `type:"structure"`

	// An optional specification to return a subset of Resolver endpoints, such
	// as all inbound Resolver endpoints.
	//
	// If you submit a second or subsequent ListResolverEndpoints request and specify
	// the NextToken parameter, you must use the same values for Filters, if any,
	// as in the previous request.
	Filters []*Filter `type:"list"`

	// The maximum number of Resolver endpoints that you want to return in the response
	// to a ListResolverEndpoints request. If you don't specify a value for MaxResults,
	// Resolver returns up to 100 Resolver endpoints.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverEndpoints request, omit this value.
	//
	// If you have more than MaxResults Resolver endpoints, you can submit another
	// ListResolverEndpoints request to get the next group of Resolver endpoints.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverEndpointsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResolverEndpointsInput) SetFilters(v []*Filter) *ListResolverEndpointsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverEndpointsInput) SetMaxResults(v int64) *ListResolverEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverEndpointsInput) SetNextToken(v string) *ListResolverEndpointsInput {
	s.NextToken = &v
	return s
}

type ListResolverEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// The value that you specified for MaxResults in the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If more than MaxResults IP addresses match the specified criteria, you can
	// submit another ListResolverEndpoint request to get the next group of results.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The Resolver endpoints that were created by using the current Amazon Web
	// Services account, and that match the specified filters, if any.
	ResolverEndpoints []*ResolverEndpoint `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverEndpointsOutput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverEndpointsOutput) SetMaxResults(v int64) *ListResolverEndpointsOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverEndpointsOutput) SetNextToken(v string) *ListResolverEndpointsOutput {
	s.NextToken = &v
	return s
}

// SetResolverEndpoints sets the ResolverEndpoints field's value.
func (s *ListResolverEndpointsOutput) SetResolverEndpoints(v []*ResolverEndpoint) *ListResolverEndpointsOutput {
	s.ResolverEndpoints = v
	return s
}

type ListResolverQueryLogConfigAssociationsInput struct {
	_ struct{} `type:"structure"`

	// An optional specification to return a subset of query logging associations.
	//
	// If you submit a second or subsequent ListResolverQueryLogConfigAssociations
	// request and specify the NextToken parameter, you must use the same values
	// for Filters, if any, as in the previous request.
	Filters []*Filter `type:"list"`

	// The maximum number of query logging associations that you want to return
	// in the response to a ListResolverQueryLogConfigAssociations request. If you
	// don't specify a value for MaxResults, Resolver returns up to 100 query logging
	// associations.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverQueryLogConfigAssociations request, omit this value.
	//
	// If there are more than MaxResults query logging associations that match the
	// values that you specify for Filters, you can submit another ListResolverQueryLogConfigAssociations
	// request to get the next group of associations. In the next request, specify
	// the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The element that you want Resolver to sort query logging associations by.
	//
	// If you submit a second or subsequent ListResolverQueryLogConfigAssociations
	// request and specify the NextToken parameter, you must use the same value
	// for SortBy, if any, as in the previous request.
	//
	// Valid values include the following elements:
	//
	//    * CreationTime: The ID of the query logging association.
	//
	//    * Error: If the value of Status is FAILED, the value of Error indicates
	//    the cause: DESTINATION_NOT_FOUND: The specified destination (for example,
	//    an Amazon S3 bucket) was deleted. ACCESS_DENIED: Permissions don't allow
	//    sending logs to the destination. If Status is a value other than FAILED,
	//    ERROR is null.
	//
	//    * Id: The ID of the query logging association
	//
	//    * ResolverQueryLogConfigId: The ID of the query logging configuration
	//
	//    * ResourceId: The ID of the VPC that is associated with the query logging
	//    configuration
	//
	//    * Status: The current status of the configuration. Valid values include
	//    the following: CREATING: Resolver is creating an association between an
	//    Amazon VPC and a query logging configuration. CREATED: The association
	//    between an Amazon VPC and a query logging configuration was successfully
	//    created. Resolver is logging queries that originate in the specified VPC.
	//    DELETING: Resolver is deleting this query logging association. FAILED:
	//    Resolver either couldn't create or couldn't delete the query logging association.
	//    Here are two common causes: The specified destination (for example, an
	//    Amazon S3 bucket) was deleted. Permissions don't allow sending logs to
	//    the destination.
	SortBy *string `min:"1" type:"string"`

	// If you specified a value for SortBy, the order that you want query logging
	// associations to be listed in, ASCENDING or DESCENDING.
	//
	// If you submit a second or subsequent ListResolverQueryLogConfigAssociations
	// request and specify the NextToken parameter, you must use the same value
	// for SortOrder, if any, as in the previous request.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverQueryLogConfigAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverQueryLogConfigAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverQueryLogConfigAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverQueryLogConfigAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SortBy != nil && len(*s.SortBy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SortBy", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResolverQueryLogConfigAssociationsInput) SetFilters(v []*Filter) *ListResolverQueryLogConfigAssociationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverQueryLogConfigAssociationsInput) SetMaxResults(v int64) *ListResolverQueryLogConfigAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverQueryLogConfigAssociationsInput) SetNextToken(v string) *ListResolverQueryLogConfigAssociationsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListResolverQueryLogConfigAssociationsInput) SetSortBy(v string) *ListResolverQueryLogConfigAssociationsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListResolverQueryLogConfigAssociationsInput) SetSortOrder(v string) *ListResolverQueryLogConfigAssociationsInput {
	s.SortOrder = &v
	return s
}

type ListResolverQueryLogConfigAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more than MaxResults query logging associations, you can submit
	// another ListResolverQueryLogConfigAssociations request to get the next group
	// of associations. In the next request, specify the value of NextToken from
	// the previous response.
	NextToken *string `type:"string"`

	// A list that contains one ResolverQueryLogConfigAssociations element for each
	// query logging association that matches the values that you specified for
	// Filter.
	ResolverQueryLogConfigAssociations []*ResolverQueryLogConfigAssociation `type:"list"`

	// The total number of query logging associations that were created by the current
	// account in the specified Region. This count can differ from the number of
	// associations that are returned in a ListResolverQueryLogConfigAssociations
	// response, depending on the values that you specify in the request.
	TotalCount *int64 `type:"integer"`

	// The total number of query logging associations that were created by the current
	// account in the specified Region and that match the filters that were specified
	// in the ListResolverQueryLogConfigAssociations request. For the total number
	// of associations that were created by the current account in the specified
	// Region, see TotalCount.
	TotalFilteredCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverQueryLogConfigAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverQueryLogConfigAssociationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverQueryLogConfigAssociationsOutput) SetNextToken(v string) *ListResolverQueryLogConfigAssociationsOutput {
	s.NextToken = &v
	return s
}

// SetResolverQueryLogConfigAssociations sets the ResolverQueryLogConfigAssociations field's value.
func (s *ListResolverQueryLogConfigAssociationsOutput) SetResolverQueryLogConfigAssociations(v []*ResolverQueryLogConfigAssociation) *ListResolverQueryLogConfigAssociationsOutput {
	s.ResolverQueryLogConfigAssociations = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListResolverQueryLogConfigAssociationsOutput) SetTotalCount(v int64) *ListResolverQueryLogConfigAssociationsOutput {
	s.TotalCount = &v
	return s
}

// SetTotalFilteredCount sets the TotalFilteredCount field's value.
func (s *ListResolverQueryLogConfigAssociationsOutput) SetTotalFilteredCount(v int64) *ListResolverQueryLogConfigAssociationsOutput {
	s.TotalFilteredCount = &v
	return s
}

type ListResolverQueryLogConfigsInput struct {
	_ struct{} `type:"structure"`

	// An optional specification to return a subset of query logging configurations.
	//
	// If you submit a second or subsequent ListResolverQueryLogConfigs request
	// and specify the NextToken parameter, you must use the same values for Filters,
	// if any, as in the previous request.
	Filters []*Filter `type:"list"`

	// The maximum number of query logging configurations that you want to return
	// in the response to a ListResolverQueryLogConfigs request. If you don't specify
	// a value for MaxResults, Resolver returns up to 100 query logging configurations.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverQueryLogConfigs request, omit this value.
	//
	// If there are more than MaxResults query logging configurations that match
	// the values that you specify for Filters, you can submit another ListResolverQueryLogConfigs
	// request to get the next group of configurations. In the next request, specify
	// the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The element that you want Resolver to sort query logging configurations by.
	//
	// If you submit a second or subsequent ListResolverQueryLogConfigs request
	// and specify the NextToken parameter, you must use the same value for SortBy,
	// if any, as in the previous request.
	//
	// Valid values include the following elements:
	//
	//    * Arn: The ARN of the query logging configuration
	//
	//    * AssociationCount: The number of VPCs that are associated with the specified
	//    configuration
	//
	//    * CreationTime: The date and time that Resolver returned when the configuration
	//    was created
	//
	//    * CreatorRequestId: The value that was specified for CreatorRequestId
	//    when the configuration was created
	//
	//    * DestinationArn: The location that logs are sent to
	//
	//    * Id: The ID of the configuration
	//
	//    * Name: The name of the configuration
	//
	//    * OwnerId: The Amazon Web Services account number of the account that
	//    created the configuration
	//
	//    * ShareStatus: Whether the configuration is shared with other Amazon Web
	//    Services accounts or shared with the current account by another Amazon
	//    Web Services account. Sharing is configured through Resource Access Manager
	//    (RAM).
	//
	//    * Status: The current status of the configuration. Valid values include
	//    the following: CREATING: Resolver is creating the query logging configuration.
	//    CREATED: The query logging configuration was successfully created. Resolver
	//    is logging queries that originate in the specified VPC. DELETING: Resolver
	//    is deleting this query logging configuration. FAILED: Resolver either
	//    couldn't create or couldn't delete the query logging configuration. Here
	//    are two common causes: The specified destination (for example, an Amazon
	//    S3 bucket) was deleted. Permissions don't allow sending logs to the destination.
	SortBy *string `min:"1" type:"string"`

	// If you specified a value for SortBy, the order that you want query logging
	// configurations to be listed in, ASCENDING or DESCENDING.
	//
	// If you submit a second or subsequent ListResolverQueryLogConfigs request
	// and specify the NextToken parameter, you must use the same value for SortOrder,
	// if any, as in the previous request.
	SortOrder *string `type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverQueryLogConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverQueryLogConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverQueryLogConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverQueryLogConfigsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SortBy != nil && len(*s.SortBy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SortBy", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResolverQueryLogConfigsInput) SetFilters(v []*Filter) *ListResolverQueryLogConfigsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverQueryLogConfigsInput) SetMaxResults(v int64) *ListResolverQueryLogConfigsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverQueryLogConfigsInput) SetNextToken(v string) *ListResolverQueryLogConfigsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListResolverQueryLogConfigsInput) SetSortBy(v string) *ListResolverQueryLogConfigsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListResolverQueryLogConfigsInput) SetSortOrder(v string) *ListResolverQueryLogConfigsInput {
	s.SortOrder = &v
	return s
}

type ListResolverQueryLogConfigsOutput struct {
	_ struct{} `type:"structure"`

	// If there are more than MaxResults query logging configurations, you can submit
	// another ListResolverQueryLogConfigs request to get the next group of configurations.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// A list that contains one ResolverQueryLogConfig element for each query logging
	// configuration that matches the values that you specified for Filter.
	ResolverQueryLogConfigs []*ResolverQueryLogConfig `type:"list"`

	// The total number of query logging configurations that were created by the
	// current account in the specified Region. This count can differ from the number
	// of query logging configurations that are returned in a ListResolverQueryLogConfigs
	// response, depending on the values that you specify in the request.
	TotalCount *int64 `type:"integer"`

	// The total number of query logging configurations that were created by the
	// current account in the specified Region and that match the filters that were
	// specified in the ListResolverQueryLogConfigs request. For the total number
	// of query logging configurations that were created by the current account
	// in the specified Region, see TotalCount.
	TotalFilteredCount *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverQueryLogConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverQueryLogConfigsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverQueryLogConfigsOutput) SetNextToken(v string) *ListResolverQueryLogConfigsOutput {
	s.NextToken = &v
	return s
}

// SetResolverQueryLogConfigs sets the ResolverQueryLogConfigs field's value.
func (s *ListResolverQueryLogConfigsOutput) SetResolverQueryLogConfigs(v []*ResolverQueryLogConfig) *ListResolverQueryLogConfigsOutput {
	s.ResolverQueryLogConfigs = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListResolverQueryLogConfigsOutput) SetTotalCount(v int64) *ListResolverQueryLogConfigsOutput {
	s.TotalCount = &v
	return s
}

// SetTotalFilteredCount sets the TotalFilteredCount field's value.
func (s *ListResolverQueryLogConfigsOutput) SetTotalFilteredCount(v int64) *ListResolverQueryLogConfigsOutput {
	s.TotalFilteredCount = &v
	return s
}

type ListResolverRuleAssociationsInput struct {
	_ struct{} `type:"structure"`

	// An optional specification to return a subset of Resolver rules, such as Resolver
	// rules that are associated with the same VPC ID.
	//
	// If you submit a second or subsequent ListResolverRuleAssociations request
	// and specify the NextToken parameter, you must use the same values for Filters,
	// if any, as in the previous request.
	Filters []*Filter `type:"list"`

	// The maximum number of rule associations that you want to return in the response
	// to a ListResolverRuleAssociations request. If you don't specify a value for
	// MaxResults, Resolver returns up to 100 rule associations.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverRuleAssociation request, omit this value.
	//
	// If you have more than MaxResults rule associations, you can submit another
	// ListResolverRuleAssociation request to get the next group of rule associations.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverRuleAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverRuleAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverRuleAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverRuleAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResolverRuleAssociationsInput) SetFilters(v []*Filter) *ListResolverRuleAssociationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverRuleAssociationsInput) SetMaxResults(v int64) *ListResolverRuleAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverRuleAssociationsInput) SetNextToken(v string) *ListResolverRuleAssociationsInput {
	s.NextToken = &v
	return s
}

type ListResolverRuleAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The value that you specified for MaxResults in the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If more than MaxResults rule associations match the specified criteria, you
	// can submit another ListResolverRuleAssociation request to get the next group
	// of results. In the next request, specify the value of NextToken from the
	// previous response.
	NextToken *string `type:"string"`

	// The associations that were created between Resolver rules and VPCs using
	// the current Amazon Web Services account, and that match the specified filters,
	// if any.
	ResolverRuleAssociations []*ResolverRuleAssociation `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverRuleAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverRuleAssociationsOutput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverRuleAssociationsOutput) SetMaxResults(v int64) *ListResolverRuleAssociationsOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverRuleAssociationsOutput) SetNextToken(v string) *ListResolverRuleAssociationsOutput {
	s.NextToken = &v
	return s
}

// SetResolverRuleAssociations sets the ResolverRuleAssociations field's value.
func (s *ListResolverRuleAssociationsOutput) SetResolverRuleAssociations(v []*ResolverRuleAssociation) *ListResolverRuleAssociationsOutput {
	s.ResolverRuleAssociations = v
	return s
}

type ListResolverRulesInput struct {
	_ struct{} `type:"structure"`

	// An optional specification to return a subset of Resolver rules, such as all
	// Resolver rules that are associated with the same Resolver endpoint.
	//
	// If you submit a second or subsequent ListResolverRules request and specify
	// the NextToken parameter, you must use the same values for Filters, if any,
	// as in the previous request.
	Filters []*Filter `type:"list"`

	// The maximum number of Resolver rules that you want to return in the response
	// to a ListResolverRules request. If you don't specify a value for MaxResults,
	// Resolver returns up to 100 Resolver rules.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListResolverRules request, omit this value.
	//
	// If you have more than MaxResults Resolver rules, you can submit another ListResolverRules
	// request to get the next group of Resolver rules. In the next request, specify
	// the value of NextToken from the previous response.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResolverRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResolverRulesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListResolverRulesInput) SetFilters(v []*Filter) *ListResolverRulesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverRulesInput) SetMaxResults(v int64) *ListResolverRulesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverRulesInput) SetNextToken(v string) *ListResolverRulesInput {
	s.NextToken = &v
	return s
}

type ListResolverRulesOutput struct {
	_ struct{} `type:"structure"`

	// The value that you specified for MaxResults in the request.
	MaxResults *int64 `min:"1" type:"integer"`

	// If more than MaxResults Resolver rules match the specified criteria, you
	// can submit another ListResolverRules request to get the next group of results.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The Resolver rules that were created using the current Amazon Web Services
	// account and that match the specified filters, if any.
	ResolverRules []*ResolverRule `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListResolverRulesOutput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListResolverRulesOutput) SetMaxResults(v int64) *ListResolverRulesOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListResolverRulesOutput) SetNextToken(v string) *ListResolverRulesOutput {
	s.NextToken = &v
	return s
}

// SetResolverRules sets the ResolverRules field's value.
func (s *ListResolverRulesOutput) SetResolverRules(v []*ResolverRule) *ListResolverRulesOutput {
	s.ResolverRules = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of tags that you want to return in the response to a ListTagsForResource
	// request. If you don't specify a value for MaxResults, Resolver returns up
	// to 100 tags.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListTagsForResource request, omit this value.
	//
	// If you have more than MaxResults tags, you can submit another ListTagsForResource
	// request to get the next group of tags for the resource. In the next request,
	// specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The Amazon Resource Name (ARN) for the resource that you want to list tags
	// for.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// If more than MaxResults tags match the specified criteria, you can submit
	// another ListTagsForResource request to get the next group of results. In
	// the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// The tags that are associated with the resource that you specified in the
	// ListTagsForResource request.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A complex type that contains settings for an existing Resolver on an Outpost.
type OutpostResolver struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the Resolver on an Outpost.
	Arn *string `min:"1" type:"string"`

	// The date and time that the Outpost Resolver was created, in Unix time format
	// and Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// A unique string that identifies the request that created the Resolver endpoint.
	// The CreatorRequestId allows failed requests to be retried without the risk
	// of running the operation twice.
	CreatorRequestId *string `min:"1" type:"string"`

	// The ID of the Resolver on Outpost.
	Id *string `min:"1" type:"string"`

	// Amazon EC2 instance count for the Resolver on the Outpost.
	InstanceCount *int64 `type:"integer"`

	// The date and time that the Outpost Resolver was modified, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string `min:"20" type:"string"`

	// Name of the Resolver.
	Name *string `min:"1" type:"string"`

	// The ARN (Amazon Resource Name) for the Outpost.
	OutpostArn *string `min:"1" type:"string"`

	// The Amazon EC2 instance type.
	PreferredInstanceType *string `min:"1" type:"string"`

	// Status of the Resolver.
	Status *string `type:"string" enum:"OutpostResolverStatus"`

	// A detailed description of the Resolver.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutpostResolver) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutpostResolver) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *OutpostResolver) SetArn(v string) *OutpostResolver {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *OutpostResolver) SetCreationTime(v string) *OutpostResolver {
	s.CreationTime = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *OutpostResolver) SetCreatorRequestId(v string) *OutpostResolver {
	s.CreatorRequestId = &v
	return s
}

// SetId sets the Id field's value.
func (s *OutpostResolver) SetId(v string) *OutpostResolver {
	s.Id = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *OutpostResolver) SetInstanceCount(v int64) *OutpostResolver {
	s.InstanceCount = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *OutpostResolver) SetModificationTime(v string) *OutpostResolver {
	s.ModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *OutpostResolver) SetName(v string) *OutpostResolver {
	s.Name = &v
	return s
}

// SetOutpostArn sets the OutpostArn field's value.
func (s *OutpostResolver) SetOutpostArn(v string) *OutpostResolver {
	s.OutpostArn = &v
	return s
}

// SetPreferredInstanceType sets the PreferredInstanceType field's value.
func (s *OutpostResolver) SetPreferredInstanceType(v string) *OutpostResolver {
	s.PreferredInstanceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OutpostResolver) SetStatus(v string) *OutpostResolver {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *OutpostResolver) SetStatusMessage(v string) *OutpostResolver {
	s.StatusMessage = &v
	return s
}

type PutFirewallRuleGroupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the rule group that you want to share.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// The Identity and Access Management (Amazon Web Services IAM) policy to attach
	// to the rule group.
	//
	// FirewallRuleGroupPolicy is a required field
	FirewallRuleGroupPolicy *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFirewallRuleGroupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFirewallRuleGroupPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutFirewallRuleGroupPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutFirewallRuleGroupPolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.FirewallRuleGroupPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallRuleGroupPolicy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *PutFirewallRuleGroupPolicyInput) SetArn(v string) *PutFirewallRuleGroupPolicyInput {
	s.Arn = &v
	return s
}

// SetFirewallRuleGroupPolicy sets the FirewallRuleGroupPolicy field's value.
func (s *PutFirewallRuleGroupPolicyInput) SetFirewallRuleGroupPolicy(v string) *PutFirewallRuleGroupPolicyInput {
	s.FirewallRuleGroupPolicy = &v
	return s
}

type PutFirewallRuleGroupPolicyOutput struct {
	_ struct{} `type:"structure"`

	ReturnValue *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFirewallRuleGroupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFirewallRuleGroupPolicyOutput) GoString() string {
	return s.String()
}

// SetReturnValue sets the ReturnValue field's value.
func (s *PutFirewallRuleGroupPolicyOutput) SetReturnValue(v bool) *PutFirewallRuleGroupPolicyOutput {
	s.ReturnValue = &v
	return s
}

type PutResolverQueryLogConfigPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the account that you want to share rules
	// with.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// An Identity and Access Management policy statement that lists the query logging
	// configurations that you want to share with another Amazon Web Services account
	// and the operations that you want the account to be able to perform. You can
	// specify the following operations in the Actions section of the statement:
	//
	//    * route53resolver:AssociateResolverQueryLogConfig
	//
	//    * route53resolver:DisassociateResolverQueryLogConfig
	//
	//    * route53resolver:ListResolverQueryLogConfigs
	//
	// In the Resource section of the statement, you specify the ARNs for the query
	// logging configurations that you want to share with the account that you specified
	// in Arn.
	//
	// ResolverQueryLogConfigPolicy is a required field
	ResolverQueryLogConfigPolicy *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResolverQueryLogConfigPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResolverQueryLogConfigPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResolverQueryLogConfigPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResolverQueryLogConfigPolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.ResolverQueryLogConfigPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverQueryLogConfigPolicy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *PutResolverQueryLogConfigPolicyInput) SetArn(v string) *PutResolverQueryLogConfigPolicyInput {
	s.Arn = &v
	return s
}

// SetResolverQueryLogConfigPolicy sets the ResolverQueryLogConfigPolicy field's value.
func (s *PutResolverQueryLogConfigPolicyInput) SetResolverQueryLogConfigPolicy(v string) *PutResolverQueryLogConfigPolicyInput {
	s.ResolverQueryLogConfigPolicy = &v
	return s
}

// The response to a PutResolverQueryLogConfigPolicy request.
type PutResolverQueryLogConfigPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Whether the PutResolverQueryLogConfigPolicy request was successful.
	ReturnValue *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResolverQueryLogConfigPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResolverQueryLogConfigPolicyOutput) GoString() string {
	return s.String()
}

// SetReturnValue sets the ReturnValue field's value.
func (s *PutResolverQueryLogConfigPolicyOutput) SetReturnValue(v bool) *PutResolverQueryLogConfigPolicyOutput {
	s.ReturnValue = &v
	return s
}

type PutResolverRulePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule that you want to share with another
	// account.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// An Identity and Access Management policy statement that lists the rules that
	// you want to share with another Amazon Web Services account and the operations
	// that you want the account to be able to perform. You can specify the following
	// operations in the Action section of the statement:
	//
	//    * route53resolver:GetResolverRule
	//
	//    * route53resolver:AssociateResolverRule
	//
	//    * route53resolver:DisassociateResolverRule
	//
	//    * route53resolver:ListResolverRules
	//
	//    * route53resolver:ListResolverRuleAssociations
	//
	// In the Resource section of the statement, specify the ARN for the rule that
	// you want to share with another account. Specify the same ARN that you specified
	// in Arn.
	//
	// ResolverRulePolicy is a required field
	ResolverRulePolicy *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResolverRulePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResolverRulePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResolverRulePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResolverRulePolicyInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}
	if s.ResolverRulePolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRulePolicy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *PutResolverRulePolicyInput) SetArn(v string) *PutResolverRulePolicyInput {
	s.Arn = &v
	return s
}

// SetResolverRulePolicy sets the ResolverRulePolicy field's value.
func (s *PutResolverRulePolicyInput) SetResolverRulePolicy(v string) *PutResolverRulePolicyInput {
	s.ResolverRulePolicy = &v
	return s
}

// The response to a PutResolverRulePolicy request.
type PutResolverRulePolicyOutput struct {
	_ struct{} `type:"structure"`

	// Whether the PutResolverRulePolicy request was successful.
	ReturnValue *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResolverRulePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResolverRulePolicyOutput) GoString() string {
	return s.String()
}

// SetReturnValue sets the ReturnValue field's value.
func (s *PutResolverRulePolicyOutput) SetReturnValue(v bool) *PutResolverRulePolicyOutput {
	s.ReturnValue = &v
	return s
}

// A complex type that contains information about a Resolver configuration for
// a VPC.
type ResolverConfig struct {
	_ struct{} `type:"structure"`

	// The status of whether or not the Resolver will create autodefined rules for
	// reverse DNS lookups. This is enabled by default. The status can be one of
	// following:
	//
	//    * ENABLING: Autodefined rules for reverse DNS lookups are being enabled
	//    but are not complete.
	//
	//    * ENABLED: Autodefined rules for reverse DNS lookups are enabled.
	//
	//    * DISABLING: Autodefined rules for reverse DNS lookups are being disabled
	//    but are not complete.
	//
	//    * DISABLED: Autodefined rules for reverse DNS lookups are disabled.
	AutodefinedReverse *string `type:"string" enum:"ResolverAutodefinedReverseStatus"`

	// ID for the Resolver configuration.
	Id *string `min:"1" type:"string"`

	// The owner account ID of the Amazon Virtual Private Cloud VPC.
	OwnerId *string `min:"12" type:"string"`

	// The ID of the Amazon Virtual Private Cloud VPC that you're configuring Resolver
	// for.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverConfig) GoString() string {
	return s.String()
}

// SetAutodefinedReverse sets the AutodefinedReverse field's value.
func (s *ResolverConfig) SetAutodefinedReverse(v string) *ResolverConfig {
	s.AutodefinedReverse = &v
	return s
}

// SetId sets the Id field's value.
func (s *ResolverConfig) SetId(v string) *ResolverConfig {
	s.Id = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *ResolverConfig) SetOwnerId(v string) *ResolverConfig {
	s.OwnerId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ResolverConfig) SetResourceId(v string) *ResolverConfig {
	s.ResourceId = &v
	return s
}

// A complex type that contains information about a configuration for DNSSEC
// validation.
type ResolverDnssecConfig struct {
	_ struct{} `type:"structure"`

	// The ID for a configuration for DNSSEC validation.
	Id *string `min:"1" type:"string"`

	// The owner account ID of the virtual private cloud (VPC) for a configuration
	// for DNSSEC validation.
	OwnerId *string `min:"12" type:"string"`

	// The ID of the virtual private cloud (VPC) that you're configuring the DNSSEC
	// validation status for.
	ResourceId *string `min:"1" type:"string"`

	// The validation status for a DNSSEC configuration. The status can be one of
	// the following:
	//
	//    * ENABLING: DNSSEC validation is being enabled but is not complete.
	//
	//    * ENABLED: DNSSEC validation is enabled.
	//
	//    * DISABLING: DNSSEC validation is being disabled but is not complete.
	//
	//    * DISABLED DNSSEC validation is disabled.
	ValidationStatus *string `type:"string" enum:"ResolverDNSSECValidationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverDnssecConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverDnssecConfig) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ResolverDnssecConfig) SetId(v string) *ResolverDnssecConfig {
	s.Id = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *ResolverDnssecConfig) SetOwnerId(v string) *ResolverDnssecConfig {
	s.OwnerId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ResolverDnssecConfig) SetResourceId(v string) *ResolverDnssecConfig {
	s.ResourceId = &v
	return s
}

// SetValidationStatus sets the ValidationStatus field's value.
func (s *ResolverDnssecConfig) SetValidationStatus(v string) *ResolverDnssecConfig {
	s.ValidationStatus = &v
	return s
}

// In the response to a CreateResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html),
// DeleteResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverEndpoint.html),
// GetResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html),
// Updates the name, or ResolverEndpointType for an endpoint, or UpdateResolverEndpoint
// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html)
// request, a complex type that contains settings for an existing inbound or
// outbound Resolver endpoint.
type ResolverEndpoint struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the Resolver endpoint.
	Arn *string `min:"1" type:"string"`

	// The date and time that the endpoint was created, in Unix time format and
	// Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// A unique string that identifies the request that created the Resolver endpoint.
	// The CreatorRequestId allows failed requests to be retried without the risk
	// of running the operation twice.
	CreatorRequestId *string `min:"1" type:"string"`

	// Indicates whether the Resolver endpoint allows inbound or outbound DNS queries:
	//
	//    * INBOUND: allows DNS queries to your VPC from your network
	//
	//    * OUTBOUND: allows DNS queries from your VPC to your network
	Direction *string `type:"string" enum:"ResolverEndpointDirection"`

	// The ID of the VPC that you want to create the Resolver endpoint in.
	HostVPCId *string `min:"1" type:"string"`

	// The ID of the Resolver endpoint.
	Id *string `min:"1" type:"string"`

	// The number of IP addresses that the Resolver endpoint can use for DNS queries.
	IpAddressCount *int64 `type:"integer"`

	// The date and time that the endpoint was last modified, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string `min:"20" type:"string"`

	// The name that you assigned to the Resolver endpoint when you submitted a
	// CreateResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverEndpoint.html)
	// request.
	Name *string `type:"string"`

	// The ARN (Amazon Resource Name) for the Outpost.
	OutpostArn *string `min:"1" type:"string"`

	// The Amazon EC2 instance type.
	PreferredInstanceType *string `min:"1" type:"string"`

	// The Resolver endpoint IP address type.
	ResolverEndpointType *string `type:"string" enum:"ResolverEndpointType"`

	// The ID of one or more security groups that control access to this VPC. The
	// security group must include one or more inbound rules (for inbound endpoints)
	// or outbound rules (for outbound endpoints). Inbound and outbound rules must
	// allow TCP and UDP access. For inbound access, open port 53. For outbound
	// access, open the port that you're using for DNS queries on your network.
	SecurityGroupIds []*string `type:"list"`

	// A code that specifies the current status of the Resolver endpoint. Valid
	// values include the following:
	//
	//    * CREATING: Resolver is creating and configuring one or more Amazon VPC
	//    network interfaces for this endpoint.
	//
	//    * OPERATIONAL: The Amazon VPC network interfaces for this endpoint are
	//    correctly configured and able to pass inbound or outbound DNS queries
	//    between your network and Resolver.
	//
	//    * UPDATING: Resolver is associating or disassociating one or more network
	//    interfaces with this endpoint.
	//
	//    * AUTO_RECOVERING: Resolver is trying to recover one or more of the network
	//    interfaces that are associated with this endpoint. During the recovery
	//    process, the endpoint functions with limited capacity because of the limit
	//    on the number of DNS queries per IP address (per network interface). For
	//    the current limit, see Limits on Route 53 Resolver (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html#limits-api-entities-resolver).
	//
	//    * ACTION_NEEDED: This endpoint is unhealthy, and Resolver can't automatically
	//    recover it. To resolve the problem, we recommend that you check each IP
	//    address that you associated with the endpoint. For each IP address that
	//    isn't available, add another IP address and then delete the IP address
	//    that isn't available. (An endpoint must always include at least two IP
	//    addresses.) A status of ACTION_NEEDED can have a variety of causes. Here
	//    are two common causes: One or more of the network interfaces that are
	//    associated with the endpoint were deleted using Amazon VPC. The network
	//    interface couldn't be created for some reason that's outside the control
	//    of Resolver.
	//
	//    * DELETING: Resolver is deleting this endpoint and the associated network
	//    interfaces.
	Status *string `type:"string" enum:"ResolverEndpointStatus"`

	// A detailed description of the status of the Resolver endpoint.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverEndpoint) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResolverEndpoint) SetArn(v string) *ResolverEndpoint {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResolverEndpoint) SetCreationTime(v string) *ResolverEndpoint {
	s.CreationTime = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *ResolverEndpoint) SetCreatorRequestId(v string) *ResolverEndpoint {
	s.CreatorRequestId = &v
	return s
}

// SetDirection sets the Direction field's value.
func (s *ResolverEndpoint) SetDirection(v string) *ResolverEndpoint {
	s.Direction = &v
	return s
}

// SetHostVPCId sets the HostVPCId field's value.
func (s *ResolverEndpoint) SetHostVPCId(v string) *ResolverEndpoint {
	s.HostVPCId = &v
	return s
}

// SetId sets the Id field's value.
func (s *ResolverEndpoint) SetId(v string) *ResolverEndpoint {
	s.Id = &v
	return s
}

// SetIpAddressCount sets the IpAddressCount field's value.
func (s *ResolverEndpoint) SetIpAddressCount(v int64) *ResolverEndpoint {
	s.IpAddressCount = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *ResolverEndpoint) SetModificationTime(v string) *ResolverEndpoint {
	s.ModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResolverEndpoint) SetName(v string) *ResolverEndpoint {
	s.Name = &v
	return s
}

// SetOutpostArn sets the OutpostArn field's value.
func (s *ResolverEndpoint) SetOutpostArn(v string) *ResolverEndpoint {
	s.OutpostArn = &v
	return s
}

// SetPreferredInstanceType sets the PreferredInstanceType field's value.
func (s *ResolverEndpoint) SetPreferredInstanceType(v string) *ResolverEndpoint {
	s.PreferredInstanceType = &v
	return s
}

// SetResolverEndpointType sets the ResolverEndpointType field's value.
func (s *ResolverEndpoint) SetResolverEndpointType(v string) *ResolverEndpoint {
	s.ResolverEndpointType = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *ResolverEndpoint) SetSecurityGroupIds(v []*string) *ResolverEndpoint {
	s.SecurityGroupIds = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResolverEndpoint) SetStatus(v string) *ResolverEndpoint {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ResolverEndpoint) SetStatusMessage(v string) *ResolverEndpoint {
	s.StatusMessage = &v
	return s
}

// In the response to a CreateResolverQueryLogConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverQueryLogConfig.html),
// DeleteResolverQueryLogConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverQueryLogConfig.html),
// GetResolverQueryLogConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfig.html),
// or ListResolverQueryLogConfigs (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigs.html)
// request, a complex type that contains settings for one query logging configuration.
type ResolverQueryLogConfig struct {
	_ struct{} `type:"structure"`

	// The ARN for the query logging configuration.
	Arn *string `min:"1" type:"string"`

	// The number of VPCs that are associated with the query logging configuration.
	AssociationCount *int64 `type:"integer"`

	// The date and time that the query logging configuration was created, in Unix
	// time format and Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// A unique string that identifies the request that created the query logging
	// configuration. The CreatorRequestId allows failed requests to be retried
	// without the risk of running the operation twice.
	CreatorRequestId *string `min:"1" type:"string"`

	// The ARN of the resource that you want Resolver to send query logs: an Amazon
	// S3 bucket, a CloudWatch Logs log group, or a Kinesis Data Firehose delivery
	// stream.
	DestinationArn *string `min:"1" type:"string"`

	// The ID for the query logging configuration.
	Id *string `min:"1" type:"string"`

	// The name of the query logging configuration.
	Name *string `min:"1" type:"string"`

	// The Amazon Web Services account ID for the account that created the query
	// logging configuration.
	OwnerId *string `min:"12" type:"string"`

	// An indication of whether the query logging configuration is shared with other
	// Amazon Web Services accounts, or was shared with the current account by another
	// Amazon Web Services account. Sharing is configured through Resource Access
	// Manager (RAM).
	ShareStatus *string `type:"string" enum:"ShareStatus"`

	// The status of the specified query logging configuration. Valid values include
	// the following:
	//
	//    * CREATING: Resolver is creating the query logging configuration.
	//
	//    * CREATED: The query logging configuration was successfully created. Resolver
	//    is logging queries that originate in the specified VPC.
	//
	//    * DELETING: Resolver is deleting this query logging configuration.
	//
	//    * FAILED: Resolver can't deliver logs to the location that is specified
	//    in the query logging configuration. Here are two common causes: The specified
	//    destination (for example, an Amazon S3 bucket) was deleted. Permissions
	//    don't allow sending logs to the destination.
	Status *string `type:"string" enum:"ResolverQueryLogConfigStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverQueryLogConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverQueryLogConfig) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResolverQueryLogConfig) SetArn(v string) *ResolverQueryLogConfig {
	s.Arn = &v
	return s
}

// SetAssociationCount sets the AssociationCount field's value.
func (s *ResolverQueryLogConfig) SetAssociationCount(v int64) *ResolverQueryLogConfig {
	s.AssociationCount = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResolverQueryLogConfig) SetCreationTime(v string) *ResolverQueryLogConfig {
	s.CreationTime = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *ResolverQueryLogConfig) SetCreatorRequestId(v string) *ResolverQueryLogConfig {
	s.CreatorRequestId = &v
	return s
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *ResolverQueryLogConfig) SetDestinationArn(v string) *ResolverQueryLogConfig {
	s.DestinationArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ResolverQueryLogConfig) SetId(v string) *ResolverQueryLogConfig {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResolverQueryLogConfig) SetName(v string) *ResolverQueryLogConfig {
	s.Name = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *ResolverQueryLogConfig) SetOwnerId(v string) *ResolverQueryLogConfig {
	s.OwnerId = &v
	return s
}

// SetShareStatus sets the ShareStatus field's value.
func (s *ResolverQueryLogConfig) SetShareStatus(v string) *ResolverQueryLogConfig {
	s.ShareStatus = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResolverQueryLogConfig) SetStatus(v string) *ResolverQueryLogConfig {
	s.Status = &v
	return s
}

// In the response to an AssociateResolverQueryLogConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html),
// DisassociateResolverQueryLogConfig (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html),
// GetResolverQueryLogConfigAssociation (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfigAssociation.html),
// or ListResolverQueryLogConfigAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html),
// request, a complex type that contains settings for a specified association
// between an Amazon VPC and a query logging configuration.
type ResolverQueryLogConfigAssociation struct {
	_ struct{} `type:"structure"`

	// The date and time that the VPC was associated with the query logging configuration,
	// in Unix time format and Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// If the value of Status is FAILED, the value of Error indicates the cause:
	//
	//    * DESTINATION_NOT_FOUND: The specified destination (for example, an Amazon
	//    S3 bucket) was deleted.
	//
	//    * ACCESS_DENIED: Permissions don't allow sending logs to the destination.
	//
	// If the value of Status is a value other than FAILED, Error is null.
	Error *string `type:"string" enum:"ResolverQueryLogConfigAssociationError"`

	// Contains additional information about the error. If the value or Error is
	// null, the value of ErrorMessage also is null.
	ErrorMessage *string `type:"string"`

	// The ID of the query logging association.
	Id *string `min:"1" type:"string"`

	// The ID of the query logging configuration that a VPC is associated with.
	ResolverQueryLogConfigId *string `min:"1" type:"string"`

	// The ID of the Amazon VPC that is associated with the query logging configuration.
	ResourceId *string `min:"1" type:"string"`

	// The status of the specified query logging association. Valid values include
	// the following:
	//
	//    * CREATING: Resolver is creating an association between an Amazon VPC
	//    and a query logging configuration.
	//
	//    * CREATED: The association between an Amazon VPC and a query logging configuration
	//    was successfully created. Resolver is logging queries that originate in
	//    the specified VPC.
	//
	//    * DELETING: Resolver is deleting this query logging association.
	//
	//    * FAILED: Resolver either couldn't create or couldn't delete the query
	//    logging association.
	Status *string `type:"string" enum:"ResolverQueryLogConfigAssociationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverQueryLogConfigAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverQueryLogConfigAssociation) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResolverQueryLogConfigAssociation) SetCreationTime(v string) *ResolverQueryLogConfigAssociation {
	s.CreationTime = &v
	return s
}

// SetError sets the Error field's value.
func (s *ResolverQueryLogConfigAssociation) SetError(v string) *ResolverQueryLogConfigAssociation {
	s.Error = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ResolverQueryLogConfigAssociation) SetErrorMessage(v string) *ResolverQueryLogConfigAssociation {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *ResolverQueryLogConfigAssociation) SetId(v string) *ResolverQueryLogConfigAssociation {
	s.Id = &v
	return s
}

// SetResolverQueryLogConfigId sets the ResolverQueryLogConfigId field's value.
func (s *ResolverQueryLogConfigAssociation) SetResolverQueryLogConfigId(v string) *ResolverQueryLogConfigAssociation {
	s.ResolverQueryLogConfigId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ResolverQueryLogConfigAssociation) SetResourceId(v string) *ResolverQueryLogConfigAssociation {
	s.ResourceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResolverQueryLogConfigAssociation) SetStatus(v string) *ResolverQueryLogConfigAssociation {
	s.Status = &v
	return s
}

// For queries that originate in your VPC, detailed information about a Resolver
// rule, which specifies how to route DNS queries out of the VPC. The ResolverRule
// parameter appears in the response to a CreateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html),
// DeleteResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DeleteResolverRule.html),
// GetResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html),
// ListResolverRules (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html),
// or UpdateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverRule.html)
// request.
type ResolverRule struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) for the Resolver rule specified by Id.
	Arn *string `min:"1" type:"string"`

	// The date and time that the Resolver rule was created, in Unix time format
	// and Coordinated Universal Time (UTC).
	CreationTime *string `min:"20" type:"string"`

	// A unique string that you specified when you created the Resolver rule. CreatorRequestId
	// identifies the request and allows failed requests to be retried without the
	// risk of running the operation twice.
	CreatorRequestId *string `min:"1" type:"string"`

	// DNS queries for this domain name are forwarded to the IP addresses that are
	// specified in TargetIps. If a query matches multiple Resolver rules (example.com
	// and www.example.com), the query is routed using the Resolver rule that contains
	// the most specific domain name (www.example.com).
	DomainName *string `min:"1" type:"string"`

	// The ID that Resolver assigned to the Resolver rule when you created it.
	Id *string `min:"1" type:"string"`

	// The date and time that the Resolver rule was last updated, in Unix time format
	// and Coordinated Universal Time (UTC).
	ModificationTime *string `min:"20" type:"string"`

	// The name for the Resolver rule, which you specified when you created the
	// Resolver rule.
	Name *string `type:"string"`

	// When a rule is shared with another Amazon Web Services account, the account
	// ID of the account that the rule is shared with.
	OwnerId *string `min:"12" type:"string"`

	// The ID of the endpoint that the rule is associated with.
	ResolverEndpointId *string `min:"1" type:"string"`

	// When you want to forward DNS queries for specified domain name to resolvers
	// on your network, specify FORWARD.
	//
	// When you have a forwarding rule to forward DNS queries for a domain to your
	// network and you want Resolver to process queries for a subdomain of that
	// domain, specify SYSTEM.
	//
	// For example, to forward DNS queries for example.com to resolvers on your
	// network, you create a rule and specify FORWARD for RuleType. To then have
	// Resolver process queries for apex.example.com, you create a rule and specify
	// SYSTEM for RuleType.
	//
	// Currently, only Resolver can create rules that have a value of RECURSIVE
	// for RuleType.
	RuleType *string `type:"string" enum:"RuleTypeOption"`

	// Whether the rule is shared and, if so, whether the current account is sharing
	// the rule with another account, or another account is sharing the rule with
	// the current account.
	ShareStatus *string `type:"string" enum:"ShareStatus"`

	// A code that specifies the current status of the Resolver rule.
	Status *string `type:"string" enum:"ResolverRuleStatus"`

	// A detailed description of the status of a Resolver rule.
	StatusMessage *string `type:"string"`

	// An array that contains the IP addresses and ports that an outbound endpoint
	// forwards DNS queries to. Typically, these are the IP addresses of DNS resolvers
	// on your network.
	TargetIps []*TargetAddress `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverRule) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResolverRule) SetArn(v string) *ResolverRule {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ResolverRule) SetCreationTime(v string) *ResolverRule {
	s.CreationTime = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *ResolverRule) SetCreatorRequestId(v string) *ResolverRule {
	s.CreatorRequestId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *ResolverRule) SetDomainName(v string) *ResolverRule {
	s.DomainName = &v
	return s
}

// SetId sets the Id field's value.
func (s *ResolverRule) SetId(v string) *ResolverRule {
	s.Id = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *ResolverRule) SetModificationTime(v string) *ResolverRule {
	s.ModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResolverRule) SetName(v string) *ResolverRule {
	s.Name = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *ResolverRule) SetOwnerId(v string) *ResolverRule {
	s.OwnerId = &v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *ResolverRule) SetResolverEndpointId(v string) *ResolverRule {
	s.ResolverEndpointId = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *ResolverRule) SetRuleType(v string) *ResolverRule {
	s.RuleType = &v
	return s
}

// SetShareStatus sets the ShareStatus field's value.
func (s *ResolverRule) SetShareStatus(v string) *ResolverRule {
	s.ShareStatus = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResolverRule) SetStatus(v string) *ResolverRule {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ResolverRule) SetStatusMessage(v string) *ResolverRule {
	s.StatusMessage = &v
	return s
}

// SetTargetIps sets the TargetIps field's value.
func (s *ResolverRule) SetTargetIps(v []*TargetAddress) *ResolverRule {
	s.TargetIps = v
	return s
}

// In the response to an AssociateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html),
// DisassociateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverRule.html),
// or ListResolverRuleAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html)
// request, provides information about an association between a Resolver rule
// and a VPC. The association determines which DNS queries that originate in
// the VPC are forwarded to your network.
type ResolverRuleAssociation struct {
	_ struct{} `type:"structure"`

	// The ID of the association between a Resolver rule and a VPC. Resolver assigns
	// this value when you submit an AssociateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverRule.html)
	// request.
	Id *string `min:"1" type:"string"`

	// The name of an association between a Resolver rule and a VPC.
	Name *string `type:"string"`

	// The ID of the Resolver rule that you associated with the VPC that is specified
	// by VPCId.
	ResolverRuleId *string `min:"1" type:"string"`

	// A code that specifies the current status of the association between a Resolver
	// rule and a VPC.
	Status *string `type:"string" enum:"ResolverRuleAssociationStatus"`

	// A detailed description of the status of the association between a Resolver
	// rule and a VPC.
	StatusMessage *string `type:"string"`

	// The ID of the VPC that you associated the Resolver rule with.
	VPCId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverRuleAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverRuleAssociation) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ResolverRuleAssociation) SetId(v string) *ResolverRuleAssociation {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResolverRuleAssociation) SetName(v string) *ResolverRuleAssociation {
	s.Name = &v
	return s
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *ResolverRuleAssociation) SetResolverRuleId(v string) *ResolverRuleAssociation {
	s.ResolverRuleId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResolverRuleAssociation) SetStatus(v string) *ResolverRuleAssociation {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ResolverRuleAssociation) SetStatusMessage(v string) *ResolverRuleAssociation {
	s.StatusMessage = &v
	return s
}

// SetVPCId sets the VPCId field's value.
func (s *ResolverRuleAssociation) SetVPCId(v string) *ResolverRuleAssociation {
	s.VPCId = &v
	return s
}

// In an UpdateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverRule.html)
// request, information about the changes that you want to make.
type ResolverRuleConfig struct {
	_ struct{} `type:"structure"`

	// The new name for the Resolver rule. The name that you specify appears in
	// the Resolver dashboard in the Route 53 console.
	Name *string `type:"string"`

	// The ID of the new outbound Resolver endpoint that you want to use to route
	// DNS queries to the IP addresses that you specify in TargetIps.
	ResolverEndpointId *string `min:"1" type:"string"`

	// For DNS queries that originate in your VPC, the new IP addresses that you
	// want to route outbound DNS queries to.
	TargetIps []*TargetAddress `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverRuleConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResolverRuleConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResolverRuleConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResolverRuleConfig"}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}
	if s.TargetIps != nil && len(s.TargetIps) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetIps", 1))
	}
	if s.TargetIps != nil {
		for i, v := range s.TargetIps {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TargetIps", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ResolverRuleConfig) SetName(v string) *ResolverRuleConfig {
	s.Name = &v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *ResolverRuleConfig) SetResolverEndpointId(v string) *ResolverRuleConfig {
	s.ResolverEndpointId = &v
	return s
}

// SetTargetIps sets the TargetIps field's value.
func (s *ResolverRuleConfig) SetTargetIps(v []*TargetAddress) *ResolverRuleConfig {
	s.TargetIps = v
	return s
}

// The resource that you tried to create already exists.
type ResourceExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// For a ResourceExistsException error, the type of resource that the error
	// applies to.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceExistsException) GoString() string {
	return s.String()
}

func newErrorResourceExistsException(v protocol.ResponseMetadata) error {
	return &ResourceExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceExistsException) Code() string {
	return "ResourceExistsException"
}

// Message returns the exception's message.
func (s *ResourceExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceExistsException) OrigErr() error {
	return nil
}

func (s *ResourceExistsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource that you tried to update or delete is currently in use.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// For a ResourceInUseException error, the type of resource that is currently
	// in use.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// For a ResourceNotFoundException error, the type of resource that doesn't
	// exist.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource isn't available.
type ResourceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// For a ResourceUnavailableException error, the type of resource that isn't
	// available.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) GoString() string {
	return s.String()
}

func newErrorResourceUnavailableException(v protocol.ResponseMetadata) error {
	return &ResourceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceUnavailableException) Code() string {
	return "ResourceUnavailableException"
}

// Message returns the exception's message.
func (s *ResourceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceUnavailableException) OrigErr() error {
	return nil
}

func (s *ResourceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Fulfilling the request would cause one or more quotas to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One tag that you want to add to the specified resource. A tag consists of
// a Key (a name for the tag) and a Value.
type Tag struct {
	_ struct{} `type:"structure"`

	// The name for the tag. For example, if you want to associate Resolver resources
	// with the account IDs of your customers for billing purposes, the value of
	// Key might be account-id.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value for the tag. For example, if Key is account-id, then Value might
	// be the ID of the customer account that you're creating the resource for.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the resource that you want to add tags
	// to. To get the ARN for a resource, use the applicable Get or List command:
	//
	//    * GetResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html)
	//
	//    * GetResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html)
	//
	//    * GetResolverRuleAssociation (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html)
	//
	//    * ListResolverEndpoints (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html)
	//
	//    * ListResolverRuleAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html)
	//
	//    * ListResolverRules (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html)
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The tags that you want to add to the specified resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// In a CreateResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_CreateResolverRule.html)
// request, an array of the IPs that you want to forward DNS queries to.
type TargetAddress struct {
	_ struct{} `type:"structure"`

	// One IPv4 address that you want to forward DNS queries to.
	Ip *string `min:"7" type:"string"`

	// One IPv6 address that you want to forward DNS queries to.
	Ipv6 *string `min:"7" type:"string"`

	// The port at Ip that you want to forward DNS queries to.
	Port *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetAddress) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetAddress) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetAddress"}
	if s.Ip != nil && len(*s.Ip) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Ip", 7))
	}
	if s.Ipv6 != nil && len(*s.Ipv6) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Ipv6", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIp sets the Ip field's value.
func (s *TargetAddress) SetIp(v string) *TargetAddress {
	s.Ip = &v
	return s
}

// SetIpv6 sets the Ipv6 field's value.
func (s *TargetAddress) SetIpv6(v string) *TargetAddress {
	s.Ipv6 = &v
	return s
}

// SetPort sets the Port field's value.
func (s *TargetAddress) SetPort(v int64) *TargetAddress {
	s.Port = &v
	return s
}

// The request was throttled. Try again in a few minutes.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource doesn't exist.
type UnknownResourceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnknownResourceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnknownResourceException) GoString() string {
	return s.String()
}

func newErrorUnknownResourceException(v protocol.ResponseMetadata) error {
	return &UnknownResourceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnknownResourceException) Code() string {
	return "UnknownResourceException"
}

// Message returns the exception's message.
func (s *UnknownResourceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnknownResourceException) OrigErr() error {
	return nil
}

func (s *UnknownResourceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnknownResourceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnknownResourceException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the resource that you want to remove tags
	// from. To get the ARN for a resource, use the applicable Get or List command:
	//
	//    * GetResolverEndpoint (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html)
	//
	//    * GetResolverRule (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html)
	//
	//    * GetResolverRuleAssociation (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html)
	//
	//    * ListResolverEndpoints (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html)
	//
	//    * ListResolverRuleAssociations (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html)
	//
	//    * ListResolverRules (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html)
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The tags that you want to remove to the specified resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateFirewallConfigInput struct {
	_ struct{} `type:"structure"`

	// Determines how Route 53 Resolver handles queries during failures, for example
	// when all traffic that is sent to DNS Firewall fails to receive a reply.
	//
	//    * By default, fail open is disabled, which means the failure mode is closed.
	//    This approach favors security over availability. DNS Firewall blocks queries
	//    that it is unable to evaluate properly.
	//
	//    * If you enable this option, the failure mode is open. This approach favors
	//    availability over security. DNS Firewall allows queries to proceed if
	//    it is unable to properly evaluate them.
	//
	// This behavior is only enforced for VPCs that have at least one DNS Firewall
	// rule group association.
	//
	// FirewallFailOpen is a required field
	FirewallFailOpen *string `type:"string" required:"true" enum:"FirewallFailOpenStatus"`

	// The ID of the VPC that the configuration is for.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFirewallConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFirewallConfigInput"}
	if s.FirewallFailOpen == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallFailOpen"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallFailOpen sets the FirewallFailOpen field's value.
func (s *UpdateFirewallConfigInput) SetFirewallFailOpen(v string) *UpdateFirewallConfigInput {
	s.FirewallFailOpen = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateFirewallConfigInput) SetResourceId(v string) *UpdateFirewallConfigInput {
	s.ResourceId = &v
	return s
}

type UpdateFirewallConfigOutput struct {
	_ struct{} `type:"structure"`

	// Configuration of the firewall behavior provided by DNS Firewall for a single
	// VPC.
	FirewallConfig *FirewallConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallConfigOutput) GoString() string {
	return s.String()
}

// SetFirewallConfig sets the FirewallConfig field's value.
func (s *UpdateFirewallConfigOutput) SetFirewallConfig(v *FirewallConfig) *UpdateFirewallConfigOutput {
	s.FirewallConfig = v
	return s
}

type UpdateFirewallDomainsInput struct {
	_ struct{} `type:"structure"`

	// A list of domains to use in the update operation.
	//
	// There is a limit of 1000 domains per request.
	//
	// Each domain specification in your domain list must satisfy the following
	// requirements:
	//
	//    * It can optionally start with * (asterisk).
	//
	//    * With the exception of the optional starting asterisk, it must only contain
	//    the following characters: A-Z, a-z, 0-9, - (hyphen).
	//
	//    * It must be from 1-255 characters in length.
	//
	// Domains is a required field
	Domains []*string `type:"list" required:"true"`

	// The ID of the domain list whose domains you want to update.
	//
	// FirewallDomainListId is a required field
	FirewallDomainListId *string `min:"1" type:"string" required:"true"`

	// What you want DNS Firewall to do with the domains that you are providing:
	//
	//    * ADD - Add the domains to the ones that are already in the domain list.
	//
	//    * REMOVE - Search the domain list for the domains and remove them from
	//    the list.
	//
	//    * REPLACE - Update the domain list to exactly match the list that you
	//    are providing.
	//
	// Operation is a required field
	Operation *string `type:"string" required:"true" enum:"FirewallDomainUpdateOperation"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFirewallDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFirewallDomainsInput"}
	if s.Domains == nil {
		invalidParams.Add(request.NewErrParamRequired("Domains"))
	}
	if s.FirewallDomainListId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallDomainListId"))
	}
	if s.FirewallDomainListId != nil && len(*s.FirewallDomainListId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallDomainListId", 1))
	}
	if s.Operation == nil {
		invalidParams.Add(request.NewErrParamRequired("Operation"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomains sets the Domains field's value.
func (s *UpdateFirewallDomainsInput) SetDomains(v []*string) *UpdateFirewallDomainsInput {
	s.Domains = v
	return s
}

// SetFirewallDomainListId sets the FirewallDomainListId field's value.
func (s *UpdateFirewallDomainsInput) SetFirewallDomainListId(v string) *UpdateFirewallDomainsInput {
	s.FirewallDomainListId = &v
	return s
}

// SetOperation sets the Operation field's value.
func (s *UpdateFirewallDomainsInput) SetOperation(v string) *UpdateFirewallDomainsInput {
	s.Operation = &v
	return s
}

type UpdateFirewallDomainsOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the firewall domain list that DNS Firewall just updated.
	Id *string `min:"1" type:"string"`

	// The name of the domain list.
	Name *string `type:"string"`

	// Status of the UpdateFirewallDomains request.
	Status *string `type:"string" enum:"FirewallDomainListStatus"`

	// Additional information about the status of the list, if available.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallDomainsOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *UpdateFirewallDomainsOutput) SetId(v string) *UpdateFirewallDomainsOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFirewallDomainsOutput) SetName(v string) *UpdateFirewallDomainsOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateFirewallDomainsOutput) SetStatus(v string) *UpdateFirewallDomainsOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *UpdateFirewallDomainsOutput) SetStatusMessage(v string) *UpdateFirewallDomainsOutput {
	s.StatusMessage = &v
	return s
}

type UpdateFirewallRuleGroupAssociationInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the FirewallRuleGroupAssociation.
	//
	// FirewallRuleGroupAssociationId is a required field
	FirewallRuleGroupAssociationId *string `min:"1" type:"string" required:"true"`

	// If enabled, this setting disallows modification or removal of the association,
	// to help prevent against accidentally altering DNS firewall protections.
	MutationProtection *string `type:"string" enum:"MutationProtectionStatus"`

	// The name of the rule group association.
	Name *string `type:"string"`

	// The setting that determines the processing order of the rule group among
	// the rule groups that you associate with the specified VPC. DNS Firewall filters
	// VPC traffic starting from the rule group with the lowest numeric priority
	// setting.
	//
	// You must specify a unique priority for each rule group that you associate
	// with a single VPC. To make it easier to insert rule groups later, leave space
	// between the numbers, for example, use 100, 200, and so on. You can change
	// the priority setting for a rule group association after you create it.
	Priority *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallRuleGroupAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallRuleGroupAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFirewallRuleGroupAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFirewallRuleGroupAssociationInput"}
	if s.FirewallRuleGroupAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallRuleGroupAssociationId"))
	}
	if s.FirewallRuleGroupAssociationId != nil && len(*s.FirewallRuleGroupAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallRuleGroupAssociationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirewallRuleGroupAssociationId sets the FirewallRuleGroupAssociationId field's value.
func (s *UpdateFirewallRuleGroupAssociationInput) SetFirewallRuleGroupAssociationId(v string) *UpdateFirewallRuleGroupAssociationInput {
	s.FirewallRuleGroupAssociationId = &v
	return s
}

// SetMutationProtection sets the MutationProtection field's value.
func (s *UpdateFirewallRuleGroupAssociationInput) SetMutationProtection(v string) *UpdateFirewallRuleGroupAssociationInput {
	s.MutationProtection = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFirewallRuleGroupAssociationInput) SetName(v string) *UpdateFirewallRuleGroupAssociationInput {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *UpdateFirewallRuleGroupAssociationInput) SetPriority(v int64) *UpdateFirewallRuleGroupAssociationInput {
	s.Priority = &v
	return s
}

type UpdateFirewallRuleGroupAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The association that you just updated.
	FirewallRuleGroupAssociation *FirewallRuleGroupAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallRuleGroupAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallRuleGroupAssociationOutput) GoString() string {
	return s.String()
}

// SetFirewallRuleGroupAssociation sets the FirewallRuleGroupAssociation field's value.
func (s *UpdateFirewallRuleGroupAssociationOutput) SetFirewallRuleGroupAssociation(v *FirewallRuleGroupAssociation) *UpdateFirewallRuleGroupAssociationOutput {
	s.FirewallRuleGroupAssociation = v
	return s
}

type UpdateFirewallRuleInput struct {
	_ struct{} `type:"structure"`

	// The action that DNS Firewall should take on a DNS query when it matches one
	// of the domains in the rule's domain list:
	//
	//    * ALLOW - Permit the request to go through.
	//
	//    * ALERT - Permit the request to go through but send an alert to the logs.
	//
	//    * BLOCK - Disallow the request. This option requires additional details
	//    in the rule's BlockResponse.
	Action *string `type:"string" enum:"Action"`

	// The DNS record's type. This determines the format of the record value that
	// you provided in BlockOverrideDomain. Used for the rule action BLOCK with
	// a BlockResponse setting of OVERRIDE.
	BlockOverrideDnsType *string `type:"string" enum:"BlockOverrideDnsType"`

	// The custom DNS record to send back in response to the query. Used for the
	// rule action BLOCK with a BlockResponse setting of OVERRIDE.
	BlockOverrideDomain *string `min:"1" type:"string"`

	// The recommended amount of time, in seconds, for the DNS resolver or web browser
	// to cache the provided override record. Used for the rule action BLOCK with
	// a BlockResponse setting of OVERRIDE.
	BlockOverrideTtl *int64 `type:"integer"`

	// The way that you want DNS Firewall to block the request. Used for the rule
	// action setting BLOCK.
	//
	//    * NODATA - Respond indicating that the query was successful, but no response
	//    is available for it.
	//
	//    * NXDOMAIN - Respond indicating that the domain name that's in the query
	//    doesn't exist.
	//
	//    * OVERRIDE - Provide a custom override in the response. This option requires
	//    custom handling details in the rule's BlockOverride* settings.
	BlockResponse *string `type:"string" enum:"BlockResponse"`

	// The ID of the domain list to use in the rule.
	//
	// FirewallDomainListId is a required field
	FirewallDomainListId *string `min:"1" type:"string" required:"true"`

	// The unique identifier of the firewall rule group for the rule.
	//
	// FirewallRuleGroupId is a required field
	FirewallRuleGroupId *string `min:"1" type:"string" required:"true"`

	// The name of the rule.
	Name *string `type:"string"`

	// The setting that determines the processing order of the rule in the rule
	// group. DNS Firewall processes the rules in a rule group by order of priority,
	// starting from the lowest setting.
	//
	// You must specify a unique priority for each rule in a rule group. To make
	// it easier to insert rules later, leave space between the numbers, for example,
	// use 100, 200, and so on. You can change the priority setting for the rules
	// in a rule group at any time.
	Priority *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFirewallRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFirewallRuleInput"}
	if s.BlockOverrideDomain != nil && len(*s.BlockOverrideDomain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BlockOverrideDomain", 1))
	}
	if s.FirewallDomainListId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallDomainListId"))
	}
	if s.FirewallDomainListId != nil && len(*s.FirewallDomainListId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallDomainListId", 1))
	}
	if s.FirewallRuleGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("FirewallRuleGroupId"))
	}
	if s.FirewallRuleGroupId != nil && len(*s.FirewallRuleGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirewallRuleGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *UpdateFirewallRuleInput) SetAction(v string) *UpdateFirewallRuleInput {
	s.Action = &v
	return s
}

// SetBlockOverrideDnsType sets the BlockOverrideDnsType field's value.
func (s *UpdateFirewallRuleInput) SetBlockOverrideDnsType(v string) *UpdateFirewallRuleInput {
	s.BlockOverrideDnsType = &v
	return s
}

// SetBlockOverrideDomain sets the BlockOverrideDomain field's value.
func (s *UpdateFirewallRuleInput) SetBlockOverrideDomain(v string) *UpdateFirewallRuleInput {
	s.BlockOverrideDomain = &v
	return s
}

// SetBlockOverrideTtl sets the BlockOverrideTtl field's value.
func (s *UpdateFirewallRuleInput) SetBlockOverrideTtl(v int64) *UpdateFirewallRuleInput {
	s.BlockOverrideTtl = &v
	return s
}

// SetBlockResponse sets the BlockResponse field's value.
func (s *UpdateFirewallRuleInput) SetBlockResponse(v string) *UpdateFirewallRuleInput {
	s.BlockResponse = &v
	return s
}

// SetFirewallDomainListId sets the FirewallDomainListId field's value.
func (s *UpdateFirewallRuleInput) SetFirewallDomainListId(v string) *UpdateFirewallRuleInput {
	s.FirewallDomainListId = &v
	return s
}

// SetFirewallRuleGroupId sets the FirewallRuleGroupId field's value.
func (s *UpdateFirewallRuleInput) SetFirewallRuleGroupId(v string) *UpdateFirewallRuleInput {
	s.FirewallRuleGroupId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFirewallRuleInput) SetName(v string) *UpdateFirewallRuleInput {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *UpdateFirewallRuleInput) SetPriority(v int64) *UpdateFirewallRuleInput {
	s.Priority = &v
	return s
}

type UpdateFirewallRuleOutput struct {
	_ struct{} `type:"structure"`

	// The firewall rule that you just updated.
	FirewallRule *FirewallRule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFirewallRuleOutput) GoString() string {
	return s.String()
}

// SetFirewallRule sets the FirewallRule field's value.
func (s *UpdateFirewallRuleOutput) SetFirewallRule(v *FirewallRule) *UpdateFirewallRuleOutput {
	s.FirewallRule = v
	return s
}

// Provides information about the IP address type in response to UpdateResolverEndpoint
// (https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_UpdateResolverEndpoint.html).
type UpdateIpAddress struct {
	_ struct{} `type:"structure"`

	// The ID of the IP address, specified by the ResolverEndpointId.
	//
	// IpId is a required field
	IpId *string `min:"1" type:"string" required:"true"`

	// The IPv6 address that you want to use for DNS queries.
	//
	// Ipv6 is a required field
	Ipv6 *string `min:"7" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIpAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIpAddress) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIpAddress) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIpAddress"}
	if s.IpId == nil {
		invalidParams.Add(request.NewErrParamRequired("IpId"))
	}
	if s.IpId != nil && len(*s.IpId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IpId", 1))
	}
	if s.Ipv6 == nil {
		invalidParams.Add(request.NewErrParamRequired("Ipv6"))
	}
	if s.Ipv6 != nil && len(*s.Ipv6) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("Ipv6", 7))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpId sets the IpId field's value.
func (s *UpdateIpAddress) SetIpId(v string) *UpdateIpAddress {
	s.IpId = &v
	return s
}

// SetIpv6 sets the Ipv6 field's value.
func (s *UpdateIpAddress) SetIpv6(v string) *UpdateIpAddress {
	s.Ipv6 = &v
	return s
}

type UpdateOutpostResolverInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies Resolver on an Outpost.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The Amazon EC2 instance count for a Resolver on the Outpost.
	InstanceCount *int64 `type:"integer"`

	// Name of the Resolver on the Outpost.
	Name *string `min:"1" type:"string"`

	// Amazon EC2 instance type.
	PreferredInstanceType *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOutpostResolverInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOutpostResolverInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOutpostResolverInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOutpostResolverInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PreferredInstanceType != nil && len(*s.PreferredInstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PreferredInstanceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdateOutpostResolverInput) SetId(v string) *UpdateOutpostResolverInput {
	s.Id = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *UpdateOutpostResolverInput) SetInstanceCount(v int64) *UpdateOutpostResolverInput {
	s.InstanceCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateOutpostResolverInput) SetName(v string) *UpdateOutpostResolverInput {
	s.Name = &v
	return s
}

// SetPreferredInstanceType sets the PreferredInstanceType field's value.
func (s *UpdateOutpostResolverInput) SetPreferredInstanceType(v string) *UpdateOutpostResolverInput {
	s.PreferredInstanceType = &v
	return s
}

type UpdateOutpostResolverOutput struct {
	_ struct{} `type:"structure"`

	// The response to an UpdateOutpostResolver request.
	OutpostResolver *OutpostResolver `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOutpostResolverOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateOutpostResolverOutput) GoString() string {
	return s.String()
}

// SetOutpostResolver sets the OutpostResolver field's value.
func (s *UpdateOutpostResolverOutput) SetOutpostResolver(v *OutpostResolver) *UpdateOutpostResolverOutput {
	s.OutpostResolver = v
	return s
}

type UpdateResolverConfigInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether or not the Resolver will create autodefined rules for reverse
	// DNS lookups. This is enabled by default. Disabling this option will also
	// affect EC2-Classic instances using ClassicLink. For more information, see
	// ClassicLink (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon EC2 guide.
	//
	// We are retiring EC2-Classic on August 15, 2022. We recommend that you migrate
	// from EC2-Classic to a VPC. For more information, see Migrate from EC2-Classic
	// to a VPC (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html)
	// in the Amazon EC2 guide and the blog EC2-Classic Networking is Retiring –
	// Here’s How to Prepare (http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/).
	//
	// It can take some time for the status change to be completed.
	//
	// AutodefinedReverseFlag is a required field
	AutodefinedReverseFlag *string `type:"string" required:"true" enum:"AutodefinedReverseFlag"`

	// Resource ID of the Amazon VPC that you want to update the Resolver configuration
	// for.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResolverConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResolverConfigInput"}
	if s.AutodefinedReverseFlag == nil {
		invalidParams.Add(request.NewErrParamRequired("AutodefinedReverseFlag"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutodefinedReverseFlag sets the AutodefinedReverseFlag field's value.
func (s *UpdateResolverConfigInput) SetAutodefinedReverseFlag(v string) *UpdateResolverConfigInput {
	s.AutodefinedReverseFlag = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateResolverConfigInput) SetResourceId(v string) *UpdateResolverConfigInput {
	s.ResourceId = &v
	return s
}

type UpdateResolverConfigOutput struct {
	_ struct{} `type:"structure"`

	// An array that contains settings for the specified Resolver configuration.
	ResolverConfig *ResolverConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverConfigOutput) GoString() string {
	return s.String()
}

// SetResolverConfig sets the ResolverConfig field's value.
func (s *UpdateResolverConfigOutput) SetResolverConfig(v *ResolverConfig) *UpdateResolverConfigOutput {
	s.ResolverConfig = v
	return s
}

type UpdateResolverDnssecConfigInput struct {
	_ struct{} `type:"structure"`

	// The ID of the virtual private cloud (VPC) that you're updating the DNSSEC
	// validation status for.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The new value that you are specifying for DNSSEC validation for the VPC.
	// The value can be ENABLE or DISABLE. Be aware that it can take time for a
	// validation status change to be completed.
	//
	// Validation is a required field
	Validation *string `type:"string" required:"true" enum:"Validation"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverDnssecConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverDnssecConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResolverDnssecConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResolverDnssecConfigInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.Validation == nil {
		invalidParams.Add(request.NewErrParamRequired("Validation"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateResolverDnssecConfigInput) SetResourceId(v string) *UpdateResolverDnssecConfigInput {
	s.ResourceId = &v
	return s
}

// SetValidation sets the Validation field's value.
func (s *UpdateResolverDnssecConfigInput) SetValidation(v string) *UpdateResolverDnssecConfigInput {
	s.Validation = &v
	return s
}

type UpdateResolverDnssecConfigOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains settings for the specified DNSSEC configuration.
	ResolverDNSSECConfig *ResolverDnssecConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverDnssecConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverDnssecConfigOutput) GoString() string {
	return s.String()
}

// SetResolverDNSSECConfig sets the ResolverDNSSECConfig field's value.
func (s *UpdateResolverDnssecConfigOutput) SetResolverDNSSECConfig(v *ResolverDnssecConfig) *UpdateResolverDnssecConfigOutput {
	s.ResolverDNSSECConfig = v
	return s
}

type UpdateResolverEndpointInput struct {
	_ struct{} `type:"structure"`

	// The name of the Resolver endpoint that you want to update.
	Name *string `type:"string"`

	// The ID of the Resolver endpoint that you want to update.
	//
	// ResolverEndpointId is a required field
	ResolverEndpointId *string `min:"1" type:"string" required:"true"`

	// Specifies the endpoint type for what type of IP address the endpoint uses
	// to forward DNS queries.
	//
	// Updating to IPV6 type isn't currently supported.
	ResolverEndpointType *string `type:"string" enum:"ResolverEndpointType"`

	// Specifies the IPv6 address when you update the Resolver endpoint from IPv4
	// to dual-stack. If you don't specify an IPv6 address, one will be automatically
	// chosen from your subnet.
	UpdateIpAddresses []*UpdateIpAddress `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResolverEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResolverEndpointInput"}
	if s.ResolverEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverEndpointId"))
	}
	if s.ResolverEndpointId != nil && len(*s.ResolverEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverEndpointId", 1))
	}
	if s.UpdateIpAddresses != nil {
		for i, v := range s.UpdateIpAddresses {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UpdateIpAddresses", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateResolverEndpointInput) SetName(v string) *UpdateResolverEndpointInput {
	s.Name = &v
	return s
}

// SetResolverEndpointId sets the ResolverEndpointId field's value.
func (s *UpdateResolverEndpointInput) SetResolverEndpointId(v string) *UpdateResolverEndpointInput {
	s.ResolverEndpointId = &v
	return s
}

// SetResolverEndpointType sets the ResolverEndpointType field's value.
func (s *UpdateResolverEndpointInput) SetResolverEndpointType(v string) *UpdateResolverEndpointInput {
	s.ResolverEndpointType = &v
	return s
}

// SetUpdateIpAddresses sets the UpdateIpAddresses field's value.
func (s *UpdateResolverEndpointInput) SetUpdateIpAddresses(v []*UpdateIpAddress) *UpdateResolverEndpointInput {
	s.UpdateIpAddresses = v
	return s
}

type UpdateResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The response to an UpdateResolverEndpoint request.
	ResolverEndpoint *ResolverEndpoint `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetResolverEndpoint sets the ResolverEndpoint field's value.
func (s *UpdateResolverEndpointOutput) SetResolverEndpoint(v *ResolverEndpoint) *UpdateResolverEndpointOutput {
	s.ResolverEndpoint = v
	return s
}

type UpdateResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// The new settings for the Resolver rule.
	//
	// Config is a required field
	Config *ResolverRuleConfig `type:"structure" required:"true"`

	// The ID of the Resolver rule that you want to update.
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResolverRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResolverRuleInput"}
	if s.Config == nil {
		invalidParams.Add(request.NewErrParamRequired("Config"))
	}
	if s.ResolverRuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResolverRuleId", 1))
	}
	if s.Config != nil {
		if err := s.Config.Validate(); err != nil {
			invalidParams.AddNested("Config", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfig sets the Config field's value.
func (s *UpdateResolverRuleInput) SetConfig(v *ResolverRuleConfig) *UpdateResolverRuleInput {
	s.Config = v
	return s
}

// SetResolverRuleId sets the ResolverRuleId field's value.
func (s *UpdateResolverRuleInput) SetResolverRuleId(v string) *UpdateResolverRuleInput {
	s.ResolverRuleId = &v
	return s
}

type UpdateResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// The response to an UpdateResolverRule request.
	ResolverRule *ResolverRule `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResolverRuleOutput) GoString() string {
	return s.String()
}

// SetResolverRule sets the ResolverRule field's value.
func (s *UpdateResolverRuleOutput) SetResolverRule(v *ResolverRule) *UpdateResolverRuleOutput {
	s.ResolverRule = v
	return s
}

// You have provided an invalid command. Supported values are ADD, REMOVE, or
// REPLACE a domain.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ActionAllow is a Action enum value
	ActionAllow = "ALLOW"

	// ActionBlock is a Action enum value
	ActionBlock = "BLOCK"

	// ActionAlert is a Action enum value
	ActionAlert = "ALERT"
)

// Action_Values returns all elements of the Action enum
func Action_Values() []string {
	return []string{
		ActionAllow,
		ActionBlock,
		ActionAlert,
	}
}

const (
	// AutodefinedReverseFlagEnable is a AutodefinedReverseFlag enum value
	AutodefinedReverseFlagEnable = "ENABLE"

	// AutodefinedReverseFlagDisable is a AutodefinedReverseFlag enum value
	AutodefinedReverseFlagDisable = "DISABLE"

	// AutodefinedReverseFlagUseLocalResourceSetting is a AutodefinedReverseFlag enum value
	AutodefinedReverseFlagUseLocalResourceSetting = "USE_LOCAL_RESOURCE_SETTING"
)

// AutodefinedReverseFlag_Values returns all elements of the AutodefinedReverseFlag enum
func AutodefinedReverseFlag_Values() []string {
	return []string{
		AutodefinedReverseFlagEnable,
		AutodefinedReverseFlagDisable,
		AutodefinedReverseFlagUseLocalResourceSetting,
	}
}

const (
	// BlockOverrideDnsTypeCname is a BlockOverrideDnsType enum value
	BlockOverrideDnsTypeCname = "CNAME"
)

// BlockOverrideDnsType_Values returns all elements of the BlockOverrideDnsType enum
func BlockOverrideDnsType_Values() []string {
	return []string{
		BlockOverrideDnsTypeCname,
	}
}

const (
	// BlockResponseNodata is a BlockResponse enum value
	BlockResponseNodata = "NODATA"

	// BlockResponseNxdomain is a BlockResponse enum value
	BlockResponseNxdomain = "NXDOMAIN"

	// BlockResponseOverride is a BlockResponse enum value
	BlockResponseOverride = "OVERRIDE"
)

// BlockResponse_Values returns all elements of the BlockResponse enum
func BlockResponse_Values() []string {
	return []string{
		BlockResponseNodata,
		BlockResponseNxdomain,
		BlockResponseOverride,
	}
}

const (
	// FirewallDomainImportOperationReplace is a FirewallDomainImportOperation enum value
	FirewallDomainImportOperationReplace = "REPLACE"
)

// FirewallDomainImportOperation_Values returns all elements of the FirewallDomainImportOperation enum
func FirewallDomainImportOperation_Values() []string {
	return []string{
		FirewallDomainImportOperationReplace,
	}
}

const (
	// FirewallDomainListStatusComplete is a FirewallDomainListStatus enum value
	FirewallDomainListStatusComplete = "COMPLETE"

	// FirewallDomainListStatusCompleteImportFailed is a FirewallDomainListStatus enum value
	FirewallDomainListStatusCompleteImportFailed = "COMPLETE_IMPORT_FAILED"

	// FirewallDomainListStatusImporting is a FirewallDomainListStatus enum value
	FirewallDomainListStatusImporting = "IMPORTING"

	// FirewallDomainListStatusDeleting is a FirewallDomainListStatus enum value
	FirewallDomainListStatusDeleting = "DELETING"

	// FirewallDomainListStatusUpdating is a FirewallDomainListStatus enum value
	FirewallDomainListStatusUpdating = "UPDATING"
)

// FirewallDomainListStatus_Values returns all elements of the FirewallDomainListStatus enum
func FirewallDomainListStatus_Values() []string {
	return []string{
		FirewallDomainListStatusComplete,
		FirewallDomainListStatusCompleteImportFailed,
		FirewallDomainListStatusImporting,
		FirewallDomainListStatusDeleting,
		FirewallDomainListStatusUpdating,
	}
}

const (
	// FirewallDomainUpdateOperationAdd is a FirewallDomainUpdateOperation enum value
	FirewallDomainUpdateOperationAdd = "ADD"

	// FirewallDomainUpdateOperationRemove is a FirewallDomainUpdateOperation enum value
	FirewallDomainUpdateOperationRemove = "REMOVE"

	// FirewallDomainUpdateOperationReplace is a FirewallDomainUpdateOperation enum value
	FirewallDomainUpdateOperationReplace = "REPLACE"
)

// FirewallDomainUpdateOperation_Values returns all elements of the FirewallDomainUpdateOperation enum
func FirewallDomainUpdateOperation_Values() []string {
	return []string{
		FirewallDomainUpdateOperationAdd,
		FirewallDomainUpdateOperationRemove,
		FirewallDomainUpdateOperationReplace,
	}
}

const (
	// FirewallFailOpenStatusEnabled is a FirewallFailOpenStatus enum value
	FirewallFailOpenStatusEnabled = "ENABLED"

	// FirewallFailOpenStatusDisabled is a FirewallFailOpenStatus enum value
	FirewallFailOpenStatusDisabled = "DISABLED"

	// FirewallFailOpenStatusUseLocalResourceSetting is a FirewallFailOpenStatus enum value
	FirewallFailOpenStatusUseLocalResourceSetting = "USE_LOCAL_RESOURCE_SETTING"
)

// FirewallFailOpenStatus_Values returns all elements of the FirewallFailOpenStatus enum
func FirewallFailOpenStatus_Values() []string {
	return []string{
		FirewallFailOpenStatusEnabled,
		FirewallFailOpenStatusDisabled,
		FirewallFailOpenStatusUseLocalResourceSetting,
	}
}

const (
	// FirewallRuleGroupAssociationStatusComplete is a FirewallRuleGroupAssociationStatus enum value
	FirewallRuleGroupAssociationStatusComplete = "COMPLETE"

	// FirewallRuleGroupAssociationStatusDeleting is a FirewallRuleGroupAssociationStatus enum value
	FirewallRuleGroupAssociationStatusDeleting = "DELETING"

	// FirewallRuleGroupAssociationStatusUpdating is a FirewallRuleGroupAssociationStatus enum value
	FirewallRuleGroupAssociationStatusUpdating = "UPDATING"
)

// FirewallRuleGroupAssociationStatus_Values returns all elements of the FirewallRuleGroupAssociationStatus enum
func FirewallRuleGroupAssociationStatus_Values() []string {
	return []string{
		FirewallRuleGroupAssociationStatusComplete,
		FirewallRuleGroupAssociationStatusDeleting,
		FirewallRuleGroupAssociationStatusUpdating,
	}
}

const (
	// FirewallRuleGroupStatusComplete is a FirewallRuleGroupStatus enum value
	FirewallRuleGroupStatusComplete = "COMPLETE"

	// FirewallRuleGroupStatusDeleting is a FirewallRuleGroupStatus enum value
	FirewallRuleGroupStatusDeleting = "DELETING"

	// FirewallRuleGroupStatusUpdating is a FirewallRuleGroupStatus enum value
	FirewallRuleGroupStatusUpdating = "UPDATING"
)

// FirewallRuleGroupStatus_Values returns all elements of the FirewallRuleGroupStatus enum
func FirewallRuleGroupStatus_Values() []string {
	return []string{
		FirewallRuleGroupStatusComplete,
		FirewallRuleGroupStatusDeleting,
		FirewallRuleGroupStatusUpdating,
	}
}

const (
	// IpAddressStatusCreating is a IpAddressStatus enum value
	IpAddressStatusCreating = "CREATING"

	// IpAddressStatusFailedCreation is a IpAddressStatus enum value
	IpAddressStatusFailedCreation = "FAILED_CREATION"

	// IpAddressStatusAttaching is a IpAddressStatus enum value
	IpAddressStatusAttaching = "ATTACHING"

	// IpAddressStatusAttached is a IpAddressStatus enum value
	IpAddressStatusAttached = "ATTACHED"

	// IpAddressStatusRemapDetaching is a IpAddressStatus enum value
	IpAddressStatusRemapDetaching = "REMAP_DETACHING"

	// IpAddressStatusRemapAttaching is a IpAddressStatus enum value
	IpAddressStatusRemapAttaching = "REMAP_ATTACHING"

	// IpAddressStatusDetaching is a IpAddressStatus enum value
	IpAddressStatusDetaching = "DETACHING"

	// IpAddressStatusFailedResourceGone is a IpAddressStatus enum value
	IpAddressStatusFailedResourceGone = "FAILED_RESOURCE_GONE"

	// IpAddressStatusDeleting is a IpAddressStatus enum value
	IpAddressStatusDeleting = "DELETING"

	// IpAddressStatusDeleteFailedFasExpired is a IpAddressStatus enum value
	IpAddressStatusDeleteFailedFasExpired = "DELETE_FAILED_FAS_EXPIRED"

	// IpAddressStatusUpdating is a IpAddressStatus enum value
	IpAddressStatusUpdating = "UPDATING"

	// IpAddressStatusUpdateFailed is a IpAddressStatus enum value
	IpAddressStatusUpdateFailed = "UPDATE_FAILED"
)

// IpAddressStatus_Values returns all elements of the IpAddressStatus enum
func IpAddressStatus_Values() []string {
	return []string{
		IpAddressStatusCreating,
		IpAddressStatusFailedCreation,
		IpAddressStatusAttaching,
		IpAddressStatusAttached,
		IpAddressStatusRemapDetaching,
		IpAddressStatusRemapAttaching,
		IpAddressStatusDetaching,
		IpAddressStatusFailedResourceGone,
		IpAddressStatusDeleting,
		IpAddressStatusDeleteFailedFasExpired,
		IpAddressStatusUpdating,
		IpAddressStatusUpdateFailed,
	}
}

const (
	// MutationProtectionStatusEnabled is a MutationProtectionStatus enum value
	MutationProtectionStatusEnabled = "ENABLED"

	// MutationProtectionStatusDisabled is a MutationProtectionStatus enum value
	MutationProtectionStatusDisabled = "DISABLED"
)

// MutationProtectionStatus_Values returns all elements of the MutationProtectionStatus enum
func MutationProtectionStatus_Values() []string {
	return []string{
		MutationProtectionStatusEnabled,
		MutationProtectionStatusDisabled,
	}
}

const (
	// OutpostResolverStatusCreating is a OutpostResolverStatus enum value
	OutpostResolverStatusCreating = "CREATING"

	// OutpostResolverStatusOperational is a OutpostResolverStatus enum value
	OutpostResolverStatusOperational = "OPERATIONAL"

	// OutpostResolverStatusUpdating is a OutpostResolverStatus enum value
	OutpostResolverStatusUpdating = "UPDATING"

	// OutpostResolverStatusDeleting is a OutpostResolverStatus enum value
	OutpostResolverStatusDeleting = "DELETING"

	// OutpostResolverStatusActionNeeded is a OutpostResolverStatus enum value
	OutpostResolverStatusActionNeeded = "ACTION_NEEDED"

	// OutpostResolverStatusFailedCreation is a OutpostResolverStatus enum value
	OutpostResolverStatusFailedCreation = "FAILED_CREATION"

	// OutpostResolverStatusFailedDeletion is a OutpostResolverStatus enum value
	OutpostResolverStatusFailedDeletion = "FAILED_DELETION"
)

// OutpostResolverStatus_Values returns all elements of the OutpostResolverStatus enum
func OutpostResolverStatus_Values() []string {
	return []string{
		OutpostResolverStatusCreating,
		OutpostResolverStatusOperational,
		OutpostResolverStatusUpdating,
		OutpostResolverStatusDeleting,
		OutpostResolverStatusActionNeeded,
		OutpostResolverStatusFailedCreation,
		OutpostResolverStatusFailedDeletion,
	}
}

const (
	// ResolverAutodefinedReverseStatusEnabling is a ResolverAutodefinedReverseStatus enum value
	ResolverAutodefinedReverseStatusEnabling = "ENABLING"

	// ResolverAutodefinedReverseStatusEnabled is a ResolverAutodefinedReverseStatus enum value
	ResolverAutodefinedReverseStatusEnabled = "ENABLED"

	// ResolverAutodefinedReverseStatusDisabling is a ResolverAutodefinedReverseStatus enum value
	ResolverAutodefinedReverseStatusDisabling = "DISABLING"

	// ResolverAutodefinedReverseStatusDisabled is a ResolverAutodefinedReverseStatus enum value
	ResolverAutodefinedReverseStatusDisabled = "DISABLED"

	// ResolverAutodefinedReverseStatusUpdatingToUseLocalResourceSetting is a ResolverAutodefinedReverseStatus enum value
	ResolverAutodefinedReverseStatusUpdatingToUseLocalResourceSetting = "UPDATING_TO_USE_LOCAL_RESOURCE_SETTING"

	// ResolverAutodefinedReverseStatusUseLocalResourceSetting is a ResolverAutodefinedReverseStatus enum value
	ResolverAutodefinedReverseStatusUseLocalResourceSetting = "USE_LOCAL_RESOURCE_SETTING"
)

// ResolverAutodefinedReverseStatus_Values returns all elements of the ResolverAutodefinedReverseStatus enum
func ResolverAutodefinedReverseStatus_Values() []string {
	return []string{
		ResolverAutodefinedReverseStatusEnabling,
		ResolverAutodefinedReverseStatusEnabled,
		ResolverAutodefinedReverseStatusDisabling,
		ResolverAutodefinedReverseStatusDisabled,
		ResolverAutodefinedReverseStatusUpdatingToUseLocalResourceSetting,
		ResolverAutodefinedReverseStatusUseLocalResourceSetting,
	}
}

const (
	// ResolverDNSSECValidationStatusEnabling is a ResolverDNSSECValidationStatus enum value
	ResolverDNSSECValidationStatusEnabling = "ENABLING"

	// ResolverDNSSECValidationStatusEnabled is a ResolverDNSSECValidationStatus enum value
	ResolverDNSSECValidationStatusEnabled = "ENABLED"

	// ResolverDNSSECValidationStatusDisabling is a ResolverDNSSECValidationStatus enum value
	ResolverDNSSECValidationStatusDisabling = "DISABLING"

	// ResolverDNSSECValidationStatusDisabled is a ResolverDNSSECValidationStatus enum value
	ResolverDNSSECValidationStatusDisabled = "DISABLED"

	// ResolverDNSSECValidationStatusUpdatingToUseLocalResourceSetting is a ResolverDNSSECValidationStatus enum value
	ResolverDNSSECValidationStatusUpdatingToUseLocalResourceSetting = "UPDATING_TO_USE_LOCAL_RESOURCE_SETTING"

	// ResolverDNSSECValidationStatusUseLocalResourceSetting is a ResolverDNSSECValidationStatus enum value
	ResolverDNSSECValidationStatusUseLocalResourceSetting = "USE_LOCAL_RESOURCE_SETTING"
)

// ResolverDNSSECValidationStatus_Values returns all elements of the ResolverDNSSECValidationStatus enum
func ResolverDNSSECValidationStatus_Values() []string {
	return []string{
		ResolverDNSSECValidationStatusEnabling,
		ResolverDNSSECValidationStatusEnabled,
		ResolverDNSSECValidationStatusDisabling,
		ResolverDNSSECValidationStatusDisabled,
		ResolverDNSSECValidationStatusUpdatingToUseLocalResourceSetting,
		ResolverDNSSECValidationStatusUseLocalResourceSetting,
	}
}

const (
	// ResolverEndpointDirectionInbound is a ResolverEndpointDirection enum value
	ResolverEndpointDirectionInbound = "INBOUND"

	// ResolverEndpointDirectionOutbound is a ResolverEndpointDirection enum value
	ResolverEndpointDirectionOutbound = "OUTBOUND"
)

// ResolverEndpointDirection_Values returns all elements of the ResolverEndpointDirection enum
func ResolverEndpointDirection_Values() []string {
	return []string{
		ResolverEndpointDirectionInbound,
		ResolverEndpointDirectionOutbound,
	}
}

const (
	// ResolverEndpointStatusCreating is a ResolverEndpointStatus enum value
	ResolverEndpointStatusCreating = "CREATING"

	// ResolverEndpointStatusOperational is a ResolverEndpointStatus enum value
	ResolverEndpointStatusOperational = "OPERATIONAL"

	// ResolverEndpointStatusUpdating is a ResolverEndpointStatus enum value
	ResolverEndpointStatusUpdating = "UPDATING"

	// ResolverEndpointStatusAutoRecovering is a ResolverEndpointStatus enum value
	ResolverEndpointStatusAutoRecovering = "AUTO_RECOVERING"

	// ResolverEndpointStatusActionNeeded is a ResolverEndpointStatus enum value
	ResolverEndpointStatusActionNeeded = "ACTION_NEEDED"

	// ResolverEndpointStatusDeleting is a ResolverEndpointStatus enum value
	ResolverEndpointStatusDeleting = "DELETING"
)

// ResolverEndpointStatus_Values returns all elements of the ResolverEndpointStatus enum
func ResolverEndpointStatus_Values() []string {
	return []string{
		ResolverEndpointStatusCreating,
		ResolverEndpointStatusOperational,
		ResolverEndpointStatusUpdating,
		ResolverEndpointStatusAutoRecovering,
		ResolverEndpointStatusActionNeeded,
		ResolverEndpointStatusDeleting,
	}
}

const (
	// ResolverEndpointTypeIpv6 is a ResolverEndpointType enum value
	ResolverEndpointTypeIpv6 = "IPV6"

	// ResolverEndpointTypeIpv4 is a ResolverEndpointType enum value
	ResolverEndpointTypeIpv4 = "IPV4"

	// ResolverEndpointTypeDualstack is a ResolverEndpointType enum value
	ResolverEndpointTypeDualstack = "DUALSTACK"
)

// ResolverEndpointType_Values returns all elements of the ResolverEndpointType enum
func ResolverEndpointType_Values() []string {
	return []string{
		ResolverEndpointTypeIpv6,
		ResolverEndpointTypeIpv4,
		ResolverEndpointTypeDualstack,
	}
}

const (
	// ResolverQueryLogConfigAssociationErrorNone is a ResolverQueryLogConfigAssociationError enum value
	ResolverQueryLogConfigAssociationErrorNone = "NONE"

	// ResolverQueryLogConfigAssociationErrorDestinationNotFound is a ResolverQueryLogConfigAssociationError enum value
	ResolverQueryLogConfigAssociationErrorDestinationNotFound = "DESTINATION_NOT_FOUND"

	// ResolverQueryLogConfigAssociationErrorAccessDenied is a ResolverQueryLogConfigAssociationError enum value
	ResolverQueryLogConfigAssociationErrorAccessDenied = "ACCESS_DENIED"

	// ResolverQueryLogConfigAssociationErrorInternalServiceError is a ResolverQueryLogConfigAssociationError enum value
	ResolverQueryLogConfigAssociationErrorInternalServiceError = "INTERNAL_SERVICE_ERROR"
)

// ResolverQueryLogConfigAssociationError_Values returns all elements of the ResolverQueryLogConfigAssociationError enum
func ResolverQueryLogConfigAssociationError_Values() []string {
	return []string{
		ResolverQueryLogConfigAssociationErrorNone,
		ResolverQueryLogConfigAssociationErrorDestinationNotFound,
		ResolverQueryLogConfigAssociationErrorAccessDenied,
		ResolverQueryLogConfigAssociationErrorInternalServiceError,
	}
}

const (
	// ResolverQueryLogConfigAssociationStatusCreating is a ResolverQueryLogConfigAssociationStatus enum value
	ResolverQueryLogConfigAssociationStatusCreating = "CREATING"

	// ResolverQueryLogConfigAssociationStatusActive is a ResolverQueryLogConfigAssociationStatus enum value
	ResolverQueryLogConfigAssociationStatusActive = "ACTIVE"

	// ResolverQueryLogConfigAssociationStatusActionNeeded is a ResolverQueryLogConfigAssociationStatus enum value
	ResolverQueryLogConfigAssociationStatusActionNeeded = "ACTION_NEEDED"

	// ResolverQueryLogConfigAssociationStatusDeleting is a ResolverQueryLogConfigAssociationStatus enum value
	ResolverQueryLogConfigAssociationStatusDeleting = "DELETING"

	// ResolverQueryLogConfigAssociationStatusFailed is a ResolverQueryLogConfigAssociationStatus enum value
	ResolverQueryLogConfigAssociationStatusFailed = "FAILED"
)

// ResolverQueryLogConfigAssociationStatus_Values returns all elements of the ResolverQueryLogConfigAssociationStatus enum
func ResolverQueryLogConfigAssociationStatus_Values() []string {
	return []string{
		ResolverQueryLogConfigAssociationStatusCreating,
		ResolverQueryLogConfigAssociationStatusActive,
		ResolverQueryLogConfigAssociationStatusActionNeeded,
		ResolverQueryLogConfigAssociationStatusDeleting,
		ResolverQueryLogConfigAssociationStatusFailed,
	}
}

const (
	// ResolverQueryLogConfigStatusCreating is a ResolverQueryLogConfigStatus enum value
	ResolverQueryLogConfigStatusCreating = "CREATING"

	// ResolverQueryLogConfigStatusCreated is a ResolverQueryLogConfigStatus enum value
	ResolverQueryLogConfigStatusCreated = "CREATED"

	// ResolverQueryLogConfigStatusDeleting is a ResolverQueryLogConfigStatus enum value
	ResolverQueryLogConfigStatusDeleting = "DELETING"

	// ResolverQueryLogConfigStatusFailed is a ResolverQueryLogConfigStatus enum value
	ResolverQueryLogConfigStatusFailed = "FAILED"
)

// ResolverQueryLogConfigStatus_Values returns all elements of the ResolverQueryLogConfigStatus enum
func ResolverQueryLogConfigStatus_Values() []string {
	return []string{
		ResolverQueryLogConfigStatusCreating,
		ResolverQueryLogConfigStatusCreated,
		ResolverQueryLogConfigStatusDeleting,
		ResolverQueryLogConfigStatusFailed,
	}
}

const (
	// ResolverRuleAssociationStatusCreating is a ResolverRuleAssociationStatus enum value
	ResolverRuleAssociationStatusCreating = "CREATING"

	// ResolverRuleAssociationStatusComplete is a ResolverRuleAssociationStatus enum value
	ResolverRuleAssociationStatusComplete = "COMPLETE"

	// ResolverRuleAssociationStatusDeleting is a ResolverRuleAssociationStatus enum value
	ResolverRuleAssociationStatusDeleting = "DELETING"

	// ResolverRuleAssociationStatusFailed is a ResolverRuleAssociationStatus enum value
	ResolverRuleAssociationStatusFailed = "FAILED"

	// ResolverRuleAssociationStatusOverridden is a ResolverRuleAssociationStatus enum value
	ResolverRuleAssociationStatusOverridden = "OVERRIDDEN"
)

// ResolverRuleAssociationStatus_Values returns all elements of the ResolverRuleAssociationStatus enum
func ResolverRuleAssociationStatus_Values() []string {
	return []string{
		ResolverRuleAssociationStatusCreating,
		ResolverRuleAssociationStatusComplete,
		ResolverRuleAssociationStatusDeleting,
		ResolverRuleAssociationStatusFailed,
		ResolverRuleAssociationStatusOverridden,
	}
}

const (
	// ResolverRuleStatusComplete is a ResolverRuleStatus enum value
	ResolverRuleStatusComplete = "COMPLETE"

	// ResolverRuleStatusDeleting is a ResolverRuleStatus enum value
	ResolverRuleStatusDeleting = "DELETING"

	// ResolverRuleStatusUpdating is a ResolverRuleStatus enum value
	ResolverRuleStatusUpdating = "UPDATING"

	// ResolverRuleStatusFailed is a ResolverRuleStatus enum value
	ResolverRuleStatusFailed = "FAILED"
)

// ResolverRuleStatus_Values returns all elements of the ResolverRuleStatus enum
func ResolverRuleStatus_Values() []string {
	return []string{
		ResolverRuleStatusComplete,
		ResolverRuleStatusDeleting,
		ResolverRuleStatusUpdating,
		ResolverRuleStatusFailed,
	}
}

const (
	// RuleTypeOptionForward is a RuleTypeOption enum value
	RuleTypeOptionForward = "FORWARD"

	// RuleTypeOptionSystem is a RuleTypeOption enum value
	RuleTypeOptionSystem = "SYSTEM"

	// RuleTypeOptionRecursive is a RuleTypeOption enum value
	RuleTypeOptionRecursive = "RECURSIVE"
)

// RuleTypeOption_Values returns all elements of the RuleTypeOption enum
func RuleTypeOption_Values() []string {
	return []string{
		RuleTypeOptionForward,
		RuleTypeOptionSystem,
		RuleTypeOptionRecursive,
	}
}

const (
	// ShareStatusNotShared is a ShareStatus enum value
	ShareStatusNotShared = "NOT_SHARED"

	// ShareStatusSharedWithMe is a ShareStatus enum value
	ShareStatusSharedWithMe = "SHARED_WITH_ME"

	// ShareStatusSharedByMe is a ShareStatus enum value
	ShareStatusSharedByMe = "SHARED_BY_ME"
)

// ShareStatus_Values returns all elements of the ShareStatus enum
func ShareStatus_Values() []string {
	return []string{
		ShareStatusNotShared,
		ShareStatusSharedWithMe,
		ShareStatusSharedByMe,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}

const (
	// ValidationEnable is a Validation enum value
	ValidationEnable = "ENABLE"

	// ValidationDisable is a Validation enum value
	ValidationDisable = "DISABLE"

	// ValidationUseLocalResourceSetting is a Validation enum value
	ValidationUseLocalResourceSetting = "USE_LOCAL_RESOURCE_SETTING"
)

// Validation_Values returns all elements of the Validation enum
func Validation_Values() []string {
	return []string{
		ValidationEnable,
		ValidationDisable,
		ValidationUseLocalResourceSetting,
	}
}
