package keyvault

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/keyvault/mgmt/2022-07-01/keyvault"

// AccessPolicyEntry an identity that have access to the key vault. All identities in the array must use
// the same tenant ID as the key vault's tenant ID.
type AccessPolicyEntry struct {
	// TenantID - The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// ObjectID - The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID must be unique for the list of access policies.
	ObjectID *string `json:"objectId,omitempty"`
	// ApplicationID -  Application ID of the client making request on behalf of a principal
	ApplicationID *uuid.UUID `json:"applicationId,omitempty"`
	// Permissions - Permissions the identity has for keys, secrets and certificates.
	Permissions *Permissions `json:"permissions,omitempty"`
}

// Action ...
type Action struct {
	// Type - The type of action. Possible values include: 'Rotate', 'Notify'
	Type KeyRotationPolicyActionType `json:"type,omitempty"`
}

// Attributes the object attributes managed by the KeyVault service.
type Attributes struct {
	// Enabled - Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// NotBefore - Not before date in seconds since 1970-01-01T00:00:00Z.
	NotBefore *date.UnixTime `json:"nbf,omitempty"`
	// Expires - Expiry date in seconds since 1970-01-01T00:00:00Z.
	Expires *date.UnixTime `json:"exp,omitempty"`
	// Created - READ-ONLY; Creation time in seconds since 1970-01-01T00:00:00Z.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in seconds since 1970-01-01T00:00:00Z.
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// MarshalJSON is the custom marshaler for Attributes.
func (a Attributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Enabled != nil {
		objectMap["enabled"] = a.Enabled
	}
	if a.NotBefore != nil {
		objectMap["nbf"] = a.NotBefore
	}
	if a.Expires != nil {
		objectMap["exp"] = a.Expires
	}
	return json.Marshal(objectMap)
}

// CheckMhsmNameAvailabilityParameters the parameters used to check the availability of the managed hsm
// name.
type CheckMhsmNameAvailabilityParameters struct {
	// Name - The managed hsm name.
	Name *string `json:"name,omitempty"`
}

// CheckMhsmNameAvailabilityResult the CheckMhsmNameAvailability operation response.
type CheckMhsmNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; A boolean value that indicates whether the name is available for you to use. If true, the name is available. If false, the name has already been taken or is invalid and cannot be used.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; The reason that a managed hsm name could not be used. The reason element is only returned if NameAvailable is false. Possible values include: 'ReasonForManagedHsmAccountNameInvalid', 'ReasonForManagedHsmAlreadyExists'
	Reason ReasonForManagedHsm `json:"reason,omitempty"`
	// Message - READ-ONLY; An error message explaining the Reason value in more detail.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckMhsmNameAvailabilityResult.
func (cmnar CheckMhsmNameAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CheckNameAvailabilityResult the CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	// NameAvailable - READ-ONLY; A boolean value that indicates whether the name is available for you to use. If true, the name is available. If false, the name has already been taken or is invalid and cannot be used.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - READ-ONLY; The reason that a vault name could not be used. The Reason element is only returned if NameAvailable is false. Possible values include: 'AccountNameInvalid', 'AlreadyExists'
	Reason ReasonForKeyVault `json:"reason,omitempty"`
	// Message - READ-ONLY; An error message explaining the Reason value in more detail.
	Message *string `json:"message,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckNameAvailabilityResult.
func (cnar CheckNameAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// CloudError an error response from Key Vault resource provider
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody an error response from Key Vault resource provider
type CloudErrorBody struct {
	// Code - Error code. This is a mnemonic that can be consumed programmatically.
	Code *string `json:"code,omitempty"`
	// Message - User friendly error message. The message is typically localized and may vary with service version.
	Message *string `json:"message,omitempty"`
}

// DeletedManagedHsm ...
type DeletedManagedHsm struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The Azure Resource Manager resource ID for the deleted managed HSM Pool.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the managed HSM Pool.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type of the managed HSM Pool.
	Type *string `json:"type,omitempty"`
	// Properties - Properties of the deleted managed HSM
	Properties *DeletedManagedHsmProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedManagedHsm.
func (dmh DeletedManagedHsm) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dmh.Properties != nil {
		objectMap["properties"] = dmh.Properties
	}
	return json.Marshal(objectMap)
}

// DeletedManagedHsmListResult list of deleted managed HSM Pools
type DeletedManagedHsmListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of deleted managed HSM Pools.
	Value *[]DeletedManagedHsm `json:"value,omitempty"`
	// NextLink - The URL to get the next set of deleted managed HSM Pools.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeletedManagedHsmListResultIterator provides access to a complete listing of DeletedManagedHsm values.
type DeletedManagedHsmListResultIterator struct {
	i    int
	page DeletedManagedHsmListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedManagedHsmListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedManagedHsmListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeletedManagedHsmListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedManagedHsmListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedManagedHsmListResultIterator) Response() DeletedManagedHsmListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedManagedHsmListResultIterator) Value() DeletedManagedHsm {
	if !iter.page.NotDone() {
		return DeletedManagedHsm{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeletedManagedHsmListResultIterator type.
func NewDeletedManagedHsmListResultIterator(page DeletedManagedHsmListResultPage) DeletedManagedHsmListResultIterator {
	return DeletedManagedHsmListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dmhlr DeletedManagedHsmListResult) IsEmpty() bool {
	return dmhlr.Value == nil || len(*dmhlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dmhlr DeletedManagedHsmListResult) hasNextLink() bool {
	return dmhlr.NextLink != nil && len(*dmhlr.NextLink) != 0
}

// deletedManagedHsmListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dmhlr DeletedManagedHsmListResult) deletedManagedHsmListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dmhlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dmhlr.NextLink)))
}

// DeletedManagedHsmListResultPage contains a page of DeletedManagedHsm values.
type DeletedManagedHsmListResultPage struct {
	fn    func(context.Context, DeletedManagedHsmListResult) (DeletedManagedHsmListResult, error)
	dmhlr DeletedManagedHsmListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedManagedHsmListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedManagedHsmListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dmhlr)
		if err != nil {
			return err
		}
		page.dmhlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeletedManagedHsmListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedManagedHsmListResultPage) NotDone() bool {
	return !page.dmhlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedManagedHsmListResultPage) Response() DeletedManagedHsmListResult {
	return page.dmhlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedManagedHsmListResultPage) Values() []DeletedManagedHsm {
	if page.dmhlr.IsEmpty() {
		return nil
	}
	return *page.dmhlr.Value
}

// Creates a new instance of the DeletedManagedHsmListResultPage type.
func NewDeletedManagedHsmListResultPage(cur DeletedManagedHsmListResult, getNextPage func(context.Context, DeletedManagedHsmListResult) (DeletedManagedHsmListResult, error)) DeletedManagedHsmListResultPage {
	return DeletedManagedHsmListResultPage{
		fn:    getNextPage,
		dmhlr: cur,
	}
}

// DeletedManagedHsmProperties properties of the deleted managed HSM.
type DeletedManagedHsmProperties struct {
	// MhsmID - READ-ONLY; The resource id of the original managed HSM.
	MhsmID *string `json:"mhsmId,omitempty"`
	// Location - READ-ONLY; The location of the original managed HSM.
	Location *string `json:"location,omitempty"`
	// DeletionDate - READ-ONLY; The deleted date.
	DeletionDate *date.Time `json:"deletionDate,omitempty"`
	// ScheduledPurgeDate - READ-ONLY; The scheduled purged date.
	ScheduledPurgeDate *date.Time `json:"scheduledPurgeDate,omitempty"`
	// PurgeProtectionEnabled - READ-ONLY; Purge protection status of the original managed HSM.
	PurgeProtectionEnabled *bool `json:"purgeProtectionEnabled,omitempty"`
	// Tags - READ-ONLY; Tags of the original managed HSM.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DeletedManagedHsmProperties.
func (dmhp DeletedManagedHsmProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DeletedVault deleted vault information with extended details.
type DeletedVault struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The resource ID for the deleted key vault.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the key vault.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type of the key vault.
	Type *string `json:"type,omitempty"`
	// Properties - Properties of the vault
	Properties *DeletedVaultProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedVault.
func (dv DeletedVault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dv.Properties != nil {
		objectMap["properties"] = dv.Properties
	}
	return json.Marshal(objectMap)
}

// DeletedVaultListResult list of vaults
type DeletedVaultListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of deleted vaults.
	Value *[]DeletedVault `json:"value,omitempty"`
	// NextLink - The URL to get the next set of deleted vaults.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeletedVaultListResultIterator provides access to a complete listing of DeletedVault values.
type DeletedVaultListResultIterator struct {
	i    int
	page DeletedVaultListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeletedVaultListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedVaultListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeletedVaultListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeletedVaultListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeletedVaultListResultIterator) Response() DeletedVaultListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeletedVaultListResultIterator) Value() DeletedVault {
	if !iter.page.NotDone() {
		return DeletedVault{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeletedVaultListResultIterator type.
func NewDeletedVaultListResultIterator(page DeletedVaultListResultPage) DeletedVaultListResultIterator {
	return DeletedVaultListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dvlr DeletedVaultListResult) IsEmpty() bool {
	return dvlr.Value == nil || len(*dvlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dvlr DeletedVaultListResult) hasNextLink() bool {
	return dvlr.NextLink != nil && len(*dvlr.NextLink) != 0
}

// deletedVaultListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dvlr DeletedVaultListResult) deletedVaultListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dvlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dvlr.NextLink)))
}

// DeletedVaultListResultPage contains a page of DeletedVault values.
type DeletedVaultListResultPage struct {
	fn   func(context.Context, DeletedVaultListResult) (DeletedVaultListResult, error)
	dvlr DeletedVaultListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeletedVaultListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeletedVaultListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dvlr)
		if err != nil {
			return err
		}
		page.dvlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeletedVaultListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeletedVaultListResultPage) NotDone() bool {
	return !page.dvlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeletedVaultListResultPage) Response() DeletedVaultListResult {
	return page.dvlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeletedVaultListResultPage) Values() []DeletedVault {
	if page.dvlr.IsEmpty() {
		return nil
	}
	return *page.dvlr.Value
}

// Creates a new instance of the DeletedVaultListResultPage type.
func NewDeletedVaultListResultPage(cur DeletedVaultListResult, getNextPage func(context.Context, DeletedVaultListResult) (DeletedVaultListResult, error)) DeletedVaultListResultPage {
	return DeletedVaultListResultPage{
		fn:   getNextPage,
		dvlr: cur,
	}
}

// DeletedVaultProperties properties of the deleted vault.
type DeletedVaultProperties struct {
	// VaultID - READ-ONLY; The resource id of the original vault.
	VaultID *string `json:"vaultId,omitempty"`
	// Location - READ-ONLY; The location of the original vault.
	Location *string `json:"location,omitempty"`
	// DeletionDate - READ-ONLY; The deleted date.
	DeletionDate *date.Time `json:"deletionDate,omitempty"`
	// ScheduledPurgeDate - READ-ONLY; The scheduled purged date.
	ScheduledPurgeDate *date.Time `json:"scheduledPurgeDate,omitempty"`
	// Tags - READ-ONLY; Tags of the original vault.
	Tags map[string]*string `json:"tags"`
	// PurgeProtectionEnabled - READ-ONLY; Purge protection status of the original vault.
	PurgeProtectionEnabled *bool `json:"purgeProtectionEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for DeletedVaultProperties.
func (dvp DeletedVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DimensionProperties type of operation: get, read, delete, etc.
type DimensionProperties struct {
	// Name - Name of dimension.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of dimension.
	DisplayName *string `json:"displayName,omitempty"`
	// ToBeExportedForShoebox - Property to specify whether the dimension should be exported for Shoebox.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// Error the server error.
type Error struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// InnerError - READ-ONLY; The inner error, contains a more specific error code.
	InnerError *Error `json:"innererror,omitempty"`
}

// MarshalJSON is the custom marshaler for Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// IPRule a rule governing the accessibility of a vault from a specific ip address or ip range.
type IPRule struct {
	// Value - An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
	Value *string `json:"value,omitempty"`
}

// Key the key resource.
type Key struct {
	autorest.Response `json:"-"`
	// KeyProperties - The properties of the key.
	*KeyProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Key.
func (kVar Key) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kVar.KeyProperties != nil {
		objectMap["properties"] = kVar.KeyProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Key struct.
func (kVar *Key) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var keyProperties KeyProperties
				err = json.Unmarshal(*v, &keyProperties)
				if err != nil {
					return err
				}
				kVar.KeyProperties = &keyProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				kVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				kVar.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				kVar.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				kVar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				kVar.Tags = tags
			}
		}
	}

	return nil
}

// KeyAttributes the object attributes managed by the Azure Key Vault service.
type KeyAttributes struct {
	// Enabled - Determines whether or not the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// NotBefore - Not before date in seconds since 1970-01-01T00:00:00Z.
	NotBefore *int64 `json:"nbf,omitempty"`
	// Expires - Expiry date in seconds since 1970-01-01T00:00:00Z.
	Expires *int64 `json:"exp,omitempty"`
	// Created - READ-ONLY; Creation time in seconds since 1970-01-01T00:00:00Z.
	Created *int64 `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in seconds since 1970-01-01T00:00:00Z.
	Updated *int64 `json:"updated,omitempty"`
	// RecoveryLevel - READ-ONLY; The deletion recovery level currently in effect for the object. If it contains 'Purgeable', then the object can be permanently deleted by a privileged user; otherwise, only the system can purge the object at the end of the retention interval. Possible values include: 'Purgeable', 'RecoverablePurgeable', 'Recoverable', 'RecoverableProtectedSubscription'
	RecoveryLevel DeletionRecoveryLevel `json:"recoveryLevel,omitempty"`
	// Exportable - Indicates if the private key can be exported.
	Exportable *bool `json:"exportable,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyAttributes.
func (ka KeyAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ka.Enabled != nil {
		objectMap["enabled"] = ka.Enabled
	}
	if ka.NotBefore != nil {
		objectMap["nbf"] = ka.NotBefore
	}
	if ka.Expires != nil {
		objectMap["exp"] = ka.Expires
	}
	if ka.Exportable != nil {
		objectMap["exportable"] = ka.Exportable
	}
	return json.Marshal(objectMap)
}

// KeyCreateParameters the parameters used to create a key.
type KeyCreateParameters struct {
	// Tags - The tags that will be assigned to the key.
	Tags map[string]*string `json:"tags"`
	// Properties - The properties of the key to be created.
	Properties *KeyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyCreateParameters.
func (kcp KeyCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kcp.Tags != nil {
		objectMap["tags"] = kcp.Tags
	}
	if kcp.Properties != nil {
		objectMap["properties"] = kcp.Properties
	}
	return json.Marshal(objectMap)
}

// KeyListResult the page of keys.
type KeyListResult struct {
	autorest.Response `json:"-"`
	// Value - The key resources.
	Value *[]Key `json:"value,omitempty"`
	// NextLink - The URL to get the next page of keys.
	NextLink *string `json:"nextLink,omitempty"`
}

// KeyListResultIterator provides access to a complete listing of Key values.
type KeyListResultIterator struct {
	i    int
	page KeyListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *KeyListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KeyListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *KeyListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter KeyListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter KeyListResultIterator) Response() KeyListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter KeyListResultIterator) Value() Key {
	if !iter.page.NotDone() {
		return Key{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the KeyListResultIterator type.
func NewKeyListResultIterator(page KeyListResultPage) KeyListResultIterator {
	return KeyListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (klr KeyListResult) IsEmpty() bool {
	return klr.Value == nil || len(*klr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (klr KeyListResult) hasNextLink() bool {
	return klr.NextLink != nil && len(*klr.NextLink) != 0
}

// keyListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (klr KeyListResult) keyListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !klr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(klr.NextLink)))
}

// KeyListResultPage contains a page of Key values.
type KeyListResultPage struct {
	fn  func(context.Context, KeyListResult) (KeyListResult, error)
	klr KeyListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *KeyListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/KeyListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.klr)
		if err != nil {
			return err
		}
		page.klr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *KeyListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page KeyListResultPage) NotDone() bool {
	return !page.klr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page KeyListResultPage) Response() KeyListResult {
	return page.klr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page KeyListResultPage) Values() []Key {
	if page.klr.IsEmpty() {
		return nil
	}
	return *page.klr.Value
}

// Creates a new instance of the KeyListResultPage type.
func NewKeyListResultPage(cur KeyListResult, getNextPage func(context.Context, KeyListResult) (KeyListResult, error)) KeyListResultPage {
	return KeyListResultPage{
		fn:  getNextPage,
		klr: cur,
	}
}

// KeyProperties the properties of the key.
type KeyProperties struct {
	// Attributes - The attributes of the key.
	Attributes *KeyAttributes `json:"attributes,omitempty"`
	// Kty - The type of the key. For valid values, see JsonWebKeyType. Possible values include: 'EC', 'ECHSM', 'RSA', 'RSAHSM'
	Kty    JSONWebKeyType         `json:"kty,omitempty"`
	KeyOps *[]JSONWebKeyOperation `json:"keyOps,omitempty"`
	// KeySize - The key size in bits. For example: 2048, 3072, or 4096 for RSA.
	KeySize *int32 `json:"keySize,omitempty"`
	// CurveName - The elliptic curve name. For valid values, see JsonWebKeyCurveName. Possible values include: 'P256', 'P384', 'P521', 'P256K'
	CurveName JSONWebKeyCurveName `json:"curveName,omitempty"`
	// KeyURI - READ-ONLY; The URI to retrieve the current version of the key.
	KeyURI *string `json:"keyUri,omitempty"`
	// KeyURIWithVersion - READ-ONLY; The URI to retrieve the specific version of the key.
	KeyURIWithVersion *string `json:"keyUriWithVersion,omitempty"`
	// RotationPolicy - Key rotation policy in response. It will be used for both output and input. Omitted if empty
	RotationPolicy *RotationPolicy `json:"rotationPolicy,omitempty"`
	// ReleasePolicy - Key release policy in response. It will be used for both output and input. Omitted if empty
	ReleasePolicy *KeyReleasePolicy `json:"release_policy,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyProperties.
func (kp KeyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kp.Attributes != nil {
		objectMap["attributes"] = kp.Attributes
	}
	if kp.Kty != "" {
		objectMap["kty"] = kp.Kty
	}
	if kp.KeyOps != nil {
		objectMap["keyOps"] = kp.KeyOps
	}
	if kp.KeySize != nil {
		objectMap["keySize"] = kp.KeySize
	}
	if kp.CurveName != "" {
		objectMap["curveName"] = kp.CurveName
	}
	if kp.RotationPolicy != nil {
		objectMap["rotationPolicy"] = kp.RotationPolicy
	}
	if kp.ReleasePolicy != nil {
		objectMap["release_policy"] = kp.ReleasePolicy
	}
	return json.Marshal(objectMap)
}

// KeyReleasePolicy ...
type KeyReleasePolicy struct {
	// ContentType - Content type and version of key release policy
	ContentType *string `json:"contentType,omitempty"`
	// Data - Blob encoding the policy rules under which the key can be released. (a URL-encoded base64 string)
	Data *string `json:"data,omitempty"`
}

// KeyRotationPolicyAttributes ...
type KeyRotationPolicyAttributes struct {
	// Created - READ-ONLY; Creation time in seconds since 1970-01-01T00:00:00Z.
	Created *int64 `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in seconds since 1970-01-01T00:00:00Z.
	Updated *int64 `json:"updated,omitempty"`
	// ExpiryTime - The expiration time for the new key version. It should be in ISO8601 format. Eg: 'P90D', 'P1Y'.
	ExpiryTime *string `json:"expiryTime,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyRotationPolicyAttributes.
func (krpa KeyRotationPolicyAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if krpa.ExpiryTime != nil {
		objectMap["expiryTime"] = krpa.ExpiryTime
	}
	return json.Marshal(objectMap)
}

// LifetimeAction ...
type LifetimeAction struct {
	// Trigger - The trigger of key rotation policy lifetimeAction.
	Trigger *Trigger `json:"trigger,omitempty"`
	// Action - The action of key rotation policy lifetimeAction.
	Action *Action `json:"action,omitempty"`
}

// LogSpecification log specification of operation.
type LogSpecification struct {
	// Name - Name of log specification.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of log specification.
	DisplayName *string `json:"displayName,omitempty"`
	// BlobDuration - Blob duration of specification.
	BlobDuration *string `json:"blobDuration,omitempty"`
}

// ManagedHsm resource information with extended details.
type ManagedHsm struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the managed HSM
	Properties *ManagedHsmProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The Azure Resource Manager resource ID for the managed HSM Pool.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the managed HSM Pool.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type of the managed HSM Pool.
	Type *string `json:"type,omitempty"`
	// Location - The supported Azure location where the managed HSM Pool should be created.
	Location *string `json:"location,omitempty"`
	// Sku - SKU details
	Sku *ManagedHsmSku `json:"sku,omitempty"`
	// Tags - Resource tags
	Tags       map[string]*string `json:"tags"`
	SystemData *SystemData        `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedHsm.
func (mh ManagedHsm) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mh.Properties != nil {
		objectMap["properties"] = mh.Properties
	}
	if mh.Location != nil {
		objectMap["location"] = mh.Location
	}
	if mh.Sku != nil {
		objectMap["sku"] = mh.Sku
	}
	if mh.Tags != nil {
		objectMap["tags"] = mh.Tags
	}
	if mh.SystemData != nil {
		objectMap["systemData"] = mh.SystemData
	}
	return json.Marshal(objectMap)
}

// ManagedHsmError the error exception.
type ManagedHsmError struct {
	// Error - READ-ONLY; The server error.
	Error *Error `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedHsmError.
func (mhe ManagedHsmError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedHsmListResult list of managed HSM Pools
type ManagedHsmListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of managed HSM Pools.
	Value *[]ManagedHsm `json:"value,omitempty"`
	// NextLink - The URL to get the next set of managed HSM Pools.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedHsmListResultIterator provides access to a complete listing of ManagedHsm values.
type ManagedHsmListResultIterator struct {
	i    int
	page ManagedHsmListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ManagedHsmListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ManagedHsmListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ManagedHsmListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ManagedHsmListResultIterator) Response() ManagedHsmListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ManagedHsmListResultIterator) Value() ManagedHsm {
	if !iter.page.NotDone() {
		return ManagedHsm{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ManagedHsmListResultIterator type.
func NewManagedHsmListResultIterator(page ManagedHsmListResultPage) ManagedHsmListResultIterator {
	return ManagedHsmListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mhlr ManagedHsmListResult) IsEmpty() bool {
	return mhlr.Value == nil || len(*mhlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mhlr ManagedHsmListResult) hasNextLink() bool {
	return mhlr.NextLink != nil && len(*mhlr.NextLink) != 0
}

// managedHsmListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mhlr ManagedHsmListResult) managedHsmListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mhlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mhlr.NextLink)))
}

// ManagedHsmListResultPage contains a page of ManagedHsm values.
type ManagedHsmListResultPage struct {
	fn   func(context.Context, ManagedHsmListResult) (ManagedHsmListResult, error)
	mhlr ManagedHsmListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ManagedHsmListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ManagedHsmListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mhlr)
		if err != nil {
			return err
		}
		page.mhlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ManagedHsmListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ManagedHsmListResultPage) NotDone() bool {
	return !page.mhlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ManagedHsmListResultPage) Response() ManagedHsmListResult {
	return page.mhlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ManagedHsmListResultPage) Values() []ManagedHsm {
	if page.mhlr.IsEmpty() {
		return nil
	}
	return *page.mhlr.Value
}

// Creates a new instance of the ManagedHsmListResultPage type.
func NewManagedHsmListResultPage(cur ManagedHsmListResult, getNextPage func(context.Context, ManagedHsmListResult) (ManagedHsmListResult, error)) ManagedHsmListResultPage {
	return ManagedHsmListResultPage{
		fn:   getNextPage,
		mhlr: cur,
	}
}

// ManagedHsmProperties properties of the managed HSM Pool
type ManagedHsmProperties struct {
	// TenantID - The Azure Active Directory tenant ID that should be used for authenticating requests to the managed HSM pool.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// InitialAdminObjectIds - Array of initial administrators object ids for this managed hsm pool.
	InitialAdminObjectIds *[]string `json:"initialAdminObjectIds,omitempty"`
	// HsmURI - READ-ONLY; The URI of the managed hsm pool for performing operations on keys.
	HsmURI *string `json:"hsmUri,omitempty"`
	// EnableSoftDelete - Property to specify whether the 'soft delete' functionality is enabled for this managed HSM pool. If it's not set to any value(true or false) when creating new managed HSM pool, it will be set to true by default. Once set to true, it cannot be reverted to false.
	EnableSoftDelete *bool `json:"enableSoftDelete,omitempty"`
	// SoftDeleteRetentionInDays - softDelete data retention days. It accepts >=7 and <=90.
	SoftDeleteRetentionInDays *int32 `json:"softDeleteRetentionInDays,omitempty"`
	// EnablePurgeProtection - Property specifying whether protection against purge is enabled for this managed HSM pool. Setting this property to true activates protection against purge for this managed HSM pool and its content - only the Managed HSM service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling this functionality is irreversible.
	EnablePurgeProtection *bool `json:"enablePurgeProtection,omitempty"`
	// CreateMode - The create mode to indicate whether the resource is being created or is being recovered from a deleted resource. Possible values include: 'CreateModeRecover', 'CreateModeDefault'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// StatusMessage - READ-ONLY; Resource Status Message.
	StatusMessage *string `json:"statusMessage,omitempty"`
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateProvisioning', 'ProvisioningStateFailed', 'ProvisioningStateUpdating', 'ProvisioningStateDeleting', 'ProvisioningStateActivated', 'ProvisioningStateSecurityDomainRestore', 'ProvisioningStateRestoring'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// NetworkAcls - Rules governing the accessibility of the key vault from specific network locations.
	NetworkAcls *MHSMNetworkRuleSet `json:"networkAcls,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of private endpoint connections associated with the managed hsm pool.
	PrivateEndpointConnections *[]MHSMPrivateEndpointConnectionItem `json:"privateEndpointConnections,omitempty"`
	// PublicNetworkAccess - Control permission for data plane traffic coming from public networks while private endpoint is enabled. Possible values include: 'Enabled', 'Disabled'
	PublicNetworkAccess PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
	// ScheduledPurgeDate - READ-ONLY; The scheduled purge date in UTC.
	ScheduledPurgeDate *date.Time `json:"scheduledPurgeDate,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedHsmProperties.
func (mhp ManagedHsmProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mhp.TenantID != nil {
		objectMap["tenantId"] = mhp.TenantID
	}
	if mhp.InitialAdminObjectIds != nil {
		objectMap["initialAdminObjectIds"] = mhp.InitialAdminObjectIds
	}
	if mhp.EnableSoftDelete != nil {
		objectMap["enableSoftDelete"] = mhp.EnableSoftDelete
	}
	if mhp.SoftDeleteRetentionInDays != nil {
		objectMap["softDeleteRetentionInDays"] = mhp.SoftDeleteRetentionInDays
	}
	if mhp.EnablePurgeProtection != nil {
		objectMap["enablePurgeProtection"] = mhp.EnablePurgeProtection
	}
	if mhp.CreateMode != "" {
		objectMap["createMode"] = mhp.CreateMode
	}
	if mhp.NetworkAcls != nil {
		objectMap["networkAcls"] = mhp.NetworkAcls
	}
	if mhp.PublicNetworkAccess != "" {
		objectMap["publicNetworkAccess"] = mhp.PublicNetworkAccess
	}
	return json.Marshal(objectMap)
}

// ManagedHsmResource managed HSM resource
type ManagedHsmResource struct {
	// ID - READ-ONLY; The Azure Resource Manager resource ID for the managed HSM Pool.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the managed HSM Pool.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type of the managed HSM Pool.
	Type *string `json:"type,omitempty"`
	// Location - The supported Azure location where the managed HSM Pool should be created.
	Location *string `json:"location,omitempty"`
	// Sku - SKU details
	Sku *ManagedHsmSku `json:"sku,omitempty"`
	// Tags - Resource tags
	Tags       map[string]*string `json:"tags"`
	SystemData *SystemData        `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedHsmResource.
func (mhr ManagedHsmResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mhr.Location != nil {
		objectMap["location"] = mhr.Location
	}
	if mhr.Sku != nil {
		objectMap["sku"] = mhr.Sku
	}
	if mhr.Tags != nil {
		objectMap["tags"] = mhr.Tags
	}
	if mhr.SystemData != nil {
		objectMap["systemData"] = mhr.SystemData
	}
	return json.Marshal(objectMap)
}

// ManagedHsmsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ManagedHsmsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedHsmsClient) (ManagedHsm, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedHsmsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedHsmsCreateOrUpdateFuture.Result.
func (future *ManagedHsmsCreateOrUpdateFuture) result(client ManagedHsmsClient) (mh ManagedHsm, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mh.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("keyvault.ManagedHsmsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mh.Response.Response, err = future.GetResult(sender); err == nil && mh.Response.Response.StatusCode != http.StatusNoContent {
		mh, err = client.CreateOrUpdateResponder(mh.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsCreateOrUpdateFuture", "Result", mh.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ManagedHsmsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedHsmsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedHsmsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedHsmsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedHsmsDeleteFuture.Result.
func (future *ManagedHsmsDeleteFuture) result(client ManagedHsmsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("keyvault.ManagedHsmsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedHSMSecurityDomainProperties the security domain properties of the managed hsm.
type ManagedHSMSecurityDomainProperties struct {
	// ActivationStatus - READ-ONLY; Activation Status. Possible values include: 'Active', 'NotActivated', 'Unknown', 'Failed'
	ActivationStatus ActivationStatus `json:"activationStatus,omitempty"`
	// ActivationStatusMessage - READ-ONLY; Activation Status Message.
	ActivationStatusMessage *string `json:"activationStatusMessage,omitempty"`
}

// MarshalJSON is the custom marshaler for ManagedHSMSecurityDomainProperties.
func (mhsdp ManagedHSMSecurityDomainProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ManagedHsmSku SKU details
type ManagedHsmSku struct {
	// Family - SKU Family of the managed HSM Pool
	Family *string `json:"family,omitempty"`
	// Name - SKU of the managed HSM Pool. Possible values include: 'StandardB1', 'CustomB32'
	Name ManagedHsmSkuName `json:"name,omitempty"`
}

// ManagedHsmsPurgeDeletedFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedHsmsPurgeDeletedFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedHsmsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedHsmsPurgeDeletedFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedHsmsPurgeDeletedFuture.Result.
func (future *ManagedHsmsPurgeDeletedFuture) result(client ManagedHsmsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsPurgeDeletedFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("keyvault.ManagedHsmsPurgeDeletedFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ManagedHsmsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ManagedHsmsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ManagedHsmsClient) (ManagedHsm, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ManagedHsmsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ManagedHsmsUpdateFuture.Result.
func (future *ManagedHsmsUpdateFuture) result(client ManagedHsmsClient) (mh ManagedHsm, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mh.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("keyvault.ManagedHsmsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mh.Response.Response, err = future.GetResult(sender); err == nil && mh.Response.Response.StatusCode != http.StatusNoContent {
		mh, err = client.UpdateResponder(mh.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "keyvault.ManagedHsmsUpdateFuture", "Result", mh.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MetricSpecification metric specification of operation.
type MetricSpecification struct {
	// Name - Name of metric specification.
	Name *string `json:"name,omitempty"`
	// DisplayName - Display name of metric specification.
	DisplayName *string `json:"displayName,omitempty"`
	// DisplayDescription - Display description of metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`
	// Unit - The metric unit. Possible values include: 'Bytes', 'Count', 'Milliseconds'.
	Unit *string `json:"unit,omitempty"`
	// AggregationType - The metric aggregation type. Possible values include: 'Average', 'Count', 'Total'.
	AggregationType *string `json:"aggregationType,omitempty"`
	// SupportedAggregationTypes - The supported aggregation types for the metrics.
	SupportedAggregationTypes *[]string `json:"supportedAggregationTypes,omitempty"`
	// SupportedTimeGrainTypes - The supported time grain types for the metrics.
	SupportedTimeGrainTypes *[]string `json:"supportedTimeGrainTypes,omitempty"`
	// LockAggregationType - The metric lock aggregation type.
	LockAggregationType *string `json:"lockAggregationType,omitempty"`
	// Dimensions - The dimensions of metric
	Dimensions *[]DimensionProperties `json:"dimensions,omitempty"`
	// FillGapWithZero - Property to specify whether to fill gap with zero.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`
	// InternalMetricName - The internal metric name.
	InternalMetricName *string `json:"internalMetricName,omitempty"`
}

// MHSMIPRule a rule governing the accessibility of a managed hsm pool from a specific ip address or ip
// range.
type MHSMIPRule struct {
	// Value - An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
	Value *string `json:"value,omitempty"`
}

// MHSMNetworkRuleSet a set of rules governing the network accessibility of a managed hsm pool.
type MHSMNetworkRuleSet struct {
	// Bypass - Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'. Possible values include: 'NetworkRuleBypassOptionsAzureServices', 'NetworkRuleBypassOptionsNone'
	Bypass NetworkRuleBypassOptions `json:"bypass,omitempty"`
	// DefaultAction - The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated. Possible values include: 'Allow', 'Deny'
	DefaultAction NetworkRuleAction `json:"defaultAction,omitempty"`
	// IPRules - The list of IP address rules.
	IPRules *[]MHSMIPRule `json:"ipRules,omitempty"`
	// VirtualNetworkRules - The list of virtual network rules.
	VirtualNetworkRules *[]MHSMVirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
}

// MHSMPrivateEndpoint private endpoint object properties.
type MHSMPrivateEndpoint struct {
	// ID - READ-ONLY; Full identifier of the private endpoint resource.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for MHSMPrivateEndpoint.
func (mpe MHSMPrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// MHSMPrivateEndpointConnection private endpoint connection resource.
type MHSMPrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// MHSMPrivateEndpointConnectionProperties - Resource properties.
	*MHSMPrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// Etag - Modified whenever there is a change in the state of private endpoint connection.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; The Azure Resource Manager resource ID for the managed HSM Pool.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the managed HSM Pool.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type of the managed HSM Pool.
	Type *string `json:"type,omitempty"`
	// Location - The supported Azure location where the managed HSM Pool should be created.
	Location *string `json:"location,omitempty"`
	// Sku - SKU details
	Sku *ManagedHsmSku `json:"sku,omitempty"`
	// Tags - Resource tags
	Tags       map[string]*string `json:"tags"`
	SystemData *SystemData        `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for MHSMPrivateEndpointConnection.
func (mpec MHSMPrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mpec.MHSMPrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = mpec.MHSMPrivateEndpointConnectionProperties
	}
	if mpec.Etag != nil {
		objectMap["etag"] = mpec.Etag
	}
	if mpec.Location != nil {
		objectMap["location"] = mpec.Location
	}
	if mpec.Sku != nil {
		objectMap["sku"] = mpec.Sku
	}
	if mpec.Tags != nil {
		objectMap["tags"] = mpec.Tags
	}
	if mpec.SystemData != nil {
		objectMap["systemData"] = mpec.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MHSMPrivateEndpointConnection struct.
func (mpec *MHSMPrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mHSMPrivateEndpointConnectionProperties MHSMPrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &mHSMPrivateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				mpec.MHSMPrivateEndpointConnectionProperties = &mHSMPrivateEndpointConnectionProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mpec.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mpec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mpec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mpec.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mpec.Location = &location
			}
		case "sku":
			if v != nil {
				var sku ManagedHsmSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				mpec.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mpec.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mpec.SystemData = &systemData
			}
		}
	}

	return nil
}

// MHSMPrivateEndpointConnectionItem private endpoint connection item.
type MHSMPrivateEndpointConnectionItem struct {
	// ID - Id of private endpoint connection.
	ID *string `json:"id,omitempty"`
	// Etag - Modified whenever there is a change in the state of private endpoint connection.
	Etag *string `json:"etag,omitempty"`
	// MHSMPrivateEndpointConnectionProperties - Private endpoint connection properties.
	*MHSMPrivateEndpointConnectionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for MHSMPrivateEndpointConnectionItem.
func (mpeci MHSMPrivateEndpointConnectionItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mpeci.ID != nil {
		objectMap["id"] = mpeci.ID
	}
	if mpeci.Etag != nil {
		objectMap["etag"] = mpeci.Etag
	}
	if mpeci.MHSMPrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = mpeci.MHSMPrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MHSMPrivateEndpointConnectionItem struct.
func (mpeci *MHSMPrivateEndpointConnectionItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mpeci.ID = &ID
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				mpeci.Etag = &etag
			}
		case "properties":
			if v != nil {
				var mHSMPrivateEndpointConnectionProperties MHSMPrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &mHSMPrivateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				mpeci.MHSMPrivateEndpointConnectionProperties = &mHSMPrivateEndpointConnectionProperties
			}
		}
	}

	return nil
}

// MHSMPrivateEndpointConnectionProperties properties of the private endpoint connection resource.
type MHSMPrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - Properties of the private endpoint object.
	PrivateEndpoint *MHSMPrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - Approval state of the private link connection.
	PrivateLinkServiceConnectionState *MHSMPrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - Provisioning state of the private endpoint connection. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateUpdating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed', 'PrivateEndpointConnectionProvisioningStateDisconnected'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// MHSMPrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MHSMPrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(MHSMPrivateEndpointConnectionsClient) (MHSMPrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MHSMPrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MHSMPrivateEndpointConnectionsDeleteFuture.Result.
func (future *MHSMPrivateEndpointConnectionsDeleteFuture) result(client MHSMPrivateEndpointConnectionsClient) (mpec MHSMPrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		mpec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("keyvault.MHSMPrivateEndpointConnectionsDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if mpec.Response.Response, err = future.GetResult(sender); err == nil && mpec.Response.Response.StatusCode != http.StatusNoContent {
		mpec, err = client.DeleteResponder(mpec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsDeleteFuture", "Result", mpec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MHSMPrivateEndpointConnectionsListResult list of private endpoint connections associated with a managed
// HSM Pools
type MHSMPrivateEndpointConnectionsListResult struct {
	autorest.Response `json:"-"`
	// Value - The private endpoint connection associated with a managed HSM Pools.
	Value *[]MHSMPrivateEndpointConnection `json:"value,omitempty"`
	// NextLink - The URL to get the next set of managed HSM Pools.
	NextLink *string `json:"nextLink,omitempty"`
}

// MHSMPrivateEndpointConnectionsListResultIterator provides access to a complete listing of
// MHSMPrivateEndpointConnection values.
type MHSMPrivateEndpointConnectionsListResultIterator struct {
	i    int
	page MHSMPrivateEndpointConnectionsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *MHSMPrivateEndpointConnectionsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MHSMPrivateEndpointConnectionsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *MHSMPrivateEndpointConnectionsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter MHSMPrivateEndpointConnectionsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter MHSMPrivateEndpointConnectionsListResultIterator) Response() MHSMPrivateEndpointConnectionsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter MHSMPrivateEndpointConnectionsListResultIterator) Value() MHSMPrivateEndpointConnection {
	if !iter.page.NotDone() {
		return MHSMPrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the MHSMPrivateEndpointConnectionsListResultIterator type.
func NewMHSMPrivateEndpointConnectionsListResultIterator(page MHSMPrivateEndpointConnectionsListResultPage) MHSMPrivateEndpointConnectionsListResultIterator {
	return MHSMPrivateEndpointConnectionsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (mpeclr MHSMPrivateEndpointConnectionsListResult) IsEmpty() bool {
	return mpeclr.Value == nil || len(*mpeclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (mpeclr MHSMPrivateEndpointConnectionsListResult) hasNextLink() bool {
	return mpeclr.NextLink != nil && len(*mpeclr.NextLink) != 0
}

// mHSMPrivateEndpointConnectionsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (mpeclr MHSMPrivateEndpointConnectionsListResult) mHSMPrivateEndpointConnectionsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !mpeclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(mpeclr.NextLink)))
}

// MHSMPrivateEndpointConnectionsListResultPage contains a page of MHSMPrivateEndpointConnection values.
type MHSMPrivateEndpointConnectionsListResultPage struct {
	fn     func(context.Context, MHSMPrivateEndpointConnectionsListResult) (MHSMPrivateEndpointConnectionsListResult, error)
	mpeclr MHSMPrivateEndpointConnectionsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *MHSMPrivateEndpointConnectionsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MHSMPrivateEndpointConnectionsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.mpeclr)
		if err != nil {
			return err
		}
		page.mpeclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *MHSMPrivateEndpointConnectionsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page MHSMPrivateEndpointConnectionsListResultPage) NotDone() bool {
	return !page.mpeclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page MHSMPrivateEndpointConnectionsListResultPage) Response() MHSMPrivateEndpointConnectionsListResult {
	return page.mpeclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page MHSMPrivateEndpointConnectionsListResultPage) Values() []MHSMPrivateEndpointConnection {
	if page.mpeclr.IsEmpty() {
		return nil
	}
	return *page.mpeclr.Value
}

// Creates a new instance of the MHSMPrivateEndpointConnectionsListResultPage type.
func NewMHSMPrivateEndpointConnectionsListResultPage(cur MHSMPrivateEndpointConnectionsListResult, getNextPage func(context.Context, MHSMPrivateEndpointConnectionsListResult) (MHSMPrivateEndpointConnectionsListResult, error)) MHSMPrivateEndpointConnectionsListResultPage {
	return MHSMPrivateEndpointConnectionsListResultPage{
		fn:     getNextPage,
		mpeclr: cur,
	}
}

// MHSMPrivateLinkResource a private link resource
type MHSMPrivateLinkResource struct {
	// MHSMPrivateLinkResourceProperties - Resource properties.
	*MHSMPrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The Azure Resource Manager resource ID for the managed HSM Pool.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the managed HSM Pool.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource type of the managed HSM Pool.
	Type *string `json:"type,omitempty"`
	// Location - The supported Azure location where the managed HSM Pool should be created.
	Location *string `json:"location,omitempty"`
	// Sku - SKU details
	Sku *ManagedHsmSku `json:"sku,omitempty"`
	// Tags - Resource tags
	Tags       map[string]*string `json:"tags"`
	SystemData *SystemData        `json:"systemData,omitempty"`
}

// MarshalJSON is the custom marshaler for MHSMPrivateLinkResource.
func (mplr MHSMPrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mplr.MHSMPrivateLinkResourceProperties != nil {
		objectMap["properties"] = mplr.MHSMPrivateLinkResourceProperties
	}
	if mplr.Location != nil {
		objectMap["location"] = mplr.Location
	}
	if mplr.Sku != nil {
		objectMap["sku"] = mplr.Sku
	}
	if mplr.Tags != nil {
		objectMap["tags"] = mplr.Tags
	}
	if mplr.SystemData != nil {
		objectMap["systemData"] = mplr.SystemData
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for MHSMPrivateLinkResource struct.
func (mplr *MHSMPrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var mHSMPrivateLinkResourceProperties MHSMPrivateLinkResourceProperties
				err = json.Unmarshal(*v, &mHSMPrivateLinkResourceProperties)
				if err != nil {
					return err
				}
				mplr.MHSMPrivateLinkResourceProperties = &mHSMPrivateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mplr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mplr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mplr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mplr.Location = &location
			}
		case "sku":
			if v != nil {
				var sku ManagedHsmSku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				mplr.Sku = &sku
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mplr.Tags = tags
			}
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				mplr.SystemData = &systemData
			}
		}
	}

	return nil
}

// MHSMPrivateLinkResourceListResult a list of private link resources
type MHSMPrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]MHSMPrivateLinkResource `json:"value,omitempty"`
}

// MHSMPrivateLinkResourceProperties properties of a private link resource.
type MHSMPrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; Group identifier of private link resource.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; Required member names of private link resource.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - Required DNS zone names of the the private link resource.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for MHSMPrivateLinkResourceProperties.
func (mplrp MHSMPrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mplrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = mplrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// MHSMPrivateLinkServiceConnectionState an object that represents the approval state of the private link
// connection.
type MHSMPrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been approved, rejected or removed by the key vault owner. Possible values include: 'Pending', 'Approved', 'Rejected', 'Disconnected'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval or rejection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer. Possible values include: 'None'
	ActionsRequired ActionsRequired `json:"actionsRequired,omitempty"`
}

// MHSMVirtualNetworkRule a rule governing the accessibility of a managed hsm pool from a specific virtual
// network.
type MHSMVirtualNetworkRule struct {
	// ID - Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
	ID *string `json:"id,omitempty"`
}

// NetworkRuleSet a set of rules governing the network accessibility of a vault.
type NetworkRuleSet struct {
	// Bypass - Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'.  If not specified the default is 'AzureServices'. Possible values include: 'NetworkRuleBypassOptionsAzureServices', 'NetworkRuleBypassOptionsNone'
	Bypass NetworkRuleBypassOptions `json:"bypass,omitempty"`
	// DefaultAction - The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property has been evaluated. Possible values include: 'Allow', 'Deny'
	DefaultAction NetworkRuleAction `json:"defaultAction,omitempty"`
	// IPRules - The list of IP address rules.
	IPRules *[]IPRule `json:"ipRules,omitempty"`
	// VirtualNetworkRules - The list of virtual network rules.
	VirtualNetworkRules *[]VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
}

// Operation key Vault REST API operation definition.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - The origin of operations.
	Origin *string `json:"origin,omitempty"`
	// OperationProperties - Properties of operation, include metric specifications.
	*OperationProperties `json:"properties,omitempty"`
	// IsDataAction - Property to specify whether the action is a data action.
	IsDataAction *bool `json:"isDataAction,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	if o.Origin != nil {
		objectMap["origin"] = o.Origin
	}
	if o.OperationProperties != nil {
		objectMap["properties"] = o.OperationProperties
	}
	if o.IsDataAction != nil {
		objectMap["isDataAction"] = o.IsDataAction
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Operation struct.
func (o *Operation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				o.Name = &name
			}
		case "display":
			if v != nil {
				var display OperationDisplay
				err = json.Unmarshal(*v, &display)
				if err != nil {
					return err
				}
				o.Display = &display
			}
		case "origin":
			if v != nil {
				var origin string
				err = json.Unmarshal(*v, &origin)
				if err != nil {
					return err
				}
				o.Origin = &origin
			}
		case "properties":
			if v != nil {
				var operationProperties OperationProperties
				err = json.Unmarshal(*v, &operationProperties)
				if err != nil {
					return err
				}
				o.OperationProperties = &operationProperties
			}
		case "isDataAction":
			if v != nil {
				var isDataAction bool
				err = json.Unmarshal(*v, &isDataAction)
				if err != nil {
					return err
				}
				o.IsDataAction = &isDataAction
			}
		}
	}

	return nil
}

// OperationDisplay display metadata associated with the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft Key Vault.
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list Storage operations. It contains a list of operations
// and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Storage operations supported by the Storage resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - The URL to get the next set of operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// OperationProperties properties of operation, include metric specifications.
type OperationProperties struct {
	// ServiceSpecification - One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// Permissions permissions the identity has for keys, secrets, certificates and storage.
type Permissions struct {
	// Keys - Permissions to keys
	Keys *[]KeyPermissions `json:"keys,omitempty"`
	// Secrets - Permissions to secrets
	Secrets *[]SecretPermissions `json:"secrets,omitempty"`
	// Certificates - Permissions to certificates
	Certificates *[]CertificatePermissions `json:"certificates,omitempty"`
	// Storage - Permissions to storage accounts
	Storage *[]StoragePermissions `json:"storage,omitempty"`
}

// PrivateEndpoint private endpoint object properties.
type PrivateEndpoint struct {
	// ID - READ-ONLY; Full identifier of the private endpoint resource.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpoint.
func (peVar PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PrivateEndpointConnection private endpoint connection resource.
type PrivateEndpointConnection struct {
	autorest.Response `json:"-"`
	// PrivateEndpointConnectionProperties - Resource properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
	// Etag - Modified whenever there is a change in the state of private endpoint connection.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnection.
func (pec PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pec.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = pec.PrivateEndpointConnectionProperties
	}
	if pec.Etag != nil {
		objectMap["etag"] = pec.Etag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnection struct.
func (pec *PrivateEndpointConnection) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				pec.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				pec.Etag = &etag
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pec.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pec.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pec.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pec.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pec.Tags = tags
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionItem private endpoint connection item.
type PrivateEndpointConnectionItem struct {
	// ID - Id of private endpoint connection.
	ID *string `json:"id,omitempty"`
	// Etag - Modified whenever there is a change in the state of private endpoint connection.
	Etag *string `json:"etag,omitempty"`
	// PrivateEndpointConnectionProperties - Private endpoint connection properties.
	*PrivateEndpointConnectionProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateEndpointConnectionItem.
func (peci PrivateEndpointConnectionItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if peci.ID != nil {
		objectMap["id"] = peci.ID
	}
	if peci.Etag != nil {
		objectMap["etag"] = peci.Etag
	}
	if peci.PrivateEndpointConnectionProperties != nil {
		objectMap["properties"] = peci.PrivateEndpointConnectionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateEndpointConnectionItem struct.
func (peci *PrivateEndpointConnectionItem) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				peci.ID = &ID
			}
		case "etag":
			if v != nil {
				var etag string
				err = json.Unmarshal(*v, &etag)
				if err != nil {
					return err
				}
				peci.Etag = &etag
			}
		case "properties":
			if v != nil {
				var privateEndpointConnectionProperties PrivateEndpointConnectionProperties
				err = json.Unmarshal(*v, &privateEndpointConnectionProperties)
				if err != nil {
					return err
				}
				peci.PrivateEndpointConnectionProperties = &privateEndpointConnectionProperties
			}
		}
	}

	return nil
}

// PrivateEndpointConnectionListResult list of private endpoint connections.
type PrivateEndpointConnectionListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of private endpoint connections.
	Value *[]PrivateEndpointConnection `json:"value,omitempty"`
	// NextLink - The URL to get the next set of private endpoint connections.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateEndpointConnectionListResultIterator provides access to a complete listing of
// PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultIterator struct {
	i    int
	page PrivateEndpointConnectionListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PrivateEndpointConnectionListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PrivateEndpointConnectionListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PrivateEndpointConnectionListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PrivateEndpointConnectionListResultIterator) Response() PrivateEndpointConnectionListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PrivateEndpointConnectionListResultIterator) Value() PrivateEndpointConnection {
	if !iter.page.NotDone() {
		return PrivateEndpointConnection{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PrivateEndpointConnectionListResultIterator type.
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return PrivateEndpointConnectionListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (peclr PrivateEndpointConnectionListResult) IsEmpty() bool {
	return peclr.Value == nil || len(*peclr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (peclr PrivateEndpointConnectionListResult) hasNextLink() bool {
	return peclr.NextLink != nil && len(*peclr.NextLink) != 0
}

// privateEndpointConnectionListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (peclr PrivateEndpointConnectionListResult) privateEndpointConnectionListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !peclr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(peclr.NextLink)))
}

// PrivateEndpointConnectionListResultPage contains a page of PrivateEndpointConnection values.
type PrivateEndpointConnectionListResultPage struct {
	fn    func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)
	peclr PrivateEndpointConnectionListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PrivateEndpointConnectionListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.peclr)
		if err != nil {
			return err
		}
		page.peclr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PrivateEndpointConnectionListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PrivateEndpointConnectionListResultPage) NotDone() bool {
	return !page.peclr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PrivateEndpointConnectionListResultPage) Response() PrivateEndpointConnectionListResult {
	return page.peclr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PrivateEndpointConnectionListResultPage) Values() []PrivateEndpointConnection {
	if page.peclr.IsEmpty() {
		return nil
	}
	return *page.peclr.Value
}

// Creates a new instance of the PrivateEndpointConnectionListResultPage type.
func NewPrivateEndpointConnectionListResultPage(cur PrivateEndpointConnectionListResult, getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return PrivateEndpointConnectionListResultPage{
		fn:    getNextPage,
		peclr: cur,
	}
}

// PrivateEndpointConnectionProperties properties of the private endpoint connection resource.
type PrivateEndpointConnectionProperties struct {
	// PrivateEndpoint - Properties of the private endpoint object.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`
	// PrivateLinkServiceConnectionState - Approval state of the private link connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
	// ProvisioningState - Provisioning state of the private endpoint connection. Possible values include: 'PrivateEndpointConnectionProvisioningStateSucceeded', 'PrivateEndpointConnectionProvisioningStateCreating', 'PrivateEndpointConnectionProvisioningStateUpdating', 'PrivateEndpointConnectionProvisioningStateDeleting', 'PrivateEndpointConnectionProvisioningStateFailed', 'PrivateEndpointConnectionProvisioningStateDisconnected'
	ProvisioningState PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type PrivateEndpointConnectionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(PrivateEndpointConnectionsClient) (PrivateEndpointConnection, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *PrivateEndpointConnectionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for PrivateEndpointConnectionsDeleteFuture.Result.
func (future *PrivateEndpointConnectionsDeleteFuture) result(client PrivateEndpointConnectionsClient) (pec PrivateEndpointConnection, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.PrivateEndpointConnectionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		pec.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("keyvault.PrivateEndpointConnectionsDeleteFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if pec.Response.Response, err = future.GetResult(sender); err == nil && pec.Response.Response.StatusCode != http.StatusNoContent {
		pec, err = client.DeleteResponder(pec.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "keyvault.PrivateEndpointConnectionsDeleteFuture", "Result", pec.Response.Response, "Failure responding to request")
		}
	}
	return
}

// PrivateLinkResource a private link resource
type PrivateLinkResource struct {
	// PrivateLinkResourceProperties - Resource properties.
	*PrivateLinkResourceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResource.
func (plr PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.PrivateLinkResourceProperties != nil {
		objectMap["properties"] = plr.PrivateLinkResourceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PrivateLinkResource struct.
func (plr *PrivateLinkResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var privateLinkResourceProperties PrivateLinkResourceProperties
				err = json.Unmarshal(*v, &privateLinkResourceProperties)
				if err != nil {
					return err
				}
				plr.PrivateLinkResourceProperties = &privateLinkResourceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				plr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				plr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				plr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				plr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				plr.Tags = tags
			}
		}
	}

	return nil
}

// PrivateLinkResourceListResult a list of private link resources
type PrivateLinkResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - Array of private link resources
	Value *[]PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// GroupID - READ-ONLY; Group identifier of private link resource.
	GroupID *string `json:"groupId,omitempty"`
	// RequiredMembers - READ-ONLY; Required member names of private link resource.
	RequiredMembers *[]string `json:"requiredMembers,omitempty"`
	// RequiredZoneNames - Required DNS zone names of the the private link resource.
	RequiredZoneNames *[]string `json:"requiredZoneNames,omitempty"`
}

// MarshalJSON is the custom marshaler for PrivateLinkResourceProperties.
func (plrp PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plrp.RequiredZoneNames != nil {
		objectMap["requiredZoneNames"] = plrp.RequiredZoneNames
	}
	return json.Marshal(objectMap)
}

// PrivateLinkServiceConnectionState an object that represents the approval state of the private link
// connection.
type PrivateLinkServiceConnectionState struct {
	// Status - Indicates whether the connection has been approved, rejected or removed by the key vault owner. Possible values include: 'Pending', 'Approved', 'Rejected', 'Disconnected'
	Status PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
	// Description - The reason for approval or rejection.
	Description *string `json:"description,omitempty"`
	// ActionsRequired - A message indicating if changes on the service provider require any updates on the consumer. Possible values include: 'None'
	ActionsRequired ActionsRequired `json:"actionsRequired,omitempty"`
}

// Resource key Vault resource
type Resource struct {
	// ID - READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ResourceListResult list of vault resources.
type ResourceListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of vault resources.
	Value *[]Resource `json:"value,omitempty"`
	// NextLink - The URL to get the next set of vault resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ResourceListResultIterator provides access to a complete listing of Resource values.
type ResourceListResultIterator struct {
	i    int
	page ResourceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ResourceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ResourceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ResourceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ResourceListResultIterator) Response() ResourceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ResourceListResultIterator) Value() Resource {
	if !iter.page.NotDone() {
		return Resource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ResourceListResultIterator type.
func NewResourceListResultIterator(page ResourceListResultPage) ResourceListResultIterator {
	return ResourceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr ResourceListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr ResourceListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// resourceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr ResourceListResult) resourceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// ResourceListResultPage contains a page of Resource values.
type ResourceListResultPage struct {
	fn  func(context.Context, ResourceListResult) (ResourceListResult, error)
	rlr ResourceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ResourceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ResourceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ResourceListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ResourceListResultPage) Response() ResourceListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ResourceListResultPage) Values() []Resource {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the ResourceListResultPage type.
func NewResourceListResultPage(cur ResourceListResult, getNextPage func(context.Context, ResourceListResult) (ResourceListResult, error)) ResourceListResultPage {
	return ResourceListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// RotationPolicy ...
type RotationPolicy struct {
	// Attributes - The attributes of key rotation policy.
	Attributes *KeyRotationPolicyAttributes `json:"attributes,omitempty"`
	// LifetimeActions - The lifetimeActions for key rotation action.
	LifetimeActions *[]LifetimeAction `json:"lifetimeActions,omitempty"`
}

// Secret resource information with extended details.
type Secret struct {
	autorest.Response `json:"-"`
	// Properties - Properties of the secret
	Properties *SecretProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty"`
	// Tags - READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Secret.
func (s Secret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Properties != nil {
		objectMap["properties"] = s.Properties
	}
	return json.Marshal(objectMap)
}

// SecretAttributes the secret management attributes.
type SecretAttributes struct {
	// Enabled - Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`
	// NotBefore - Not before date in seconds since 1970-01-01T00:00:00Z.
	NotBefore *date.UnixTime `json:"nbf,omitempty"`
	// Expires - Expiry date in seconds since 1970-01-01T00:00:00Z.
	Expires *date.UnixTime `json:"exp,omitempty"`
	// Created - READ-ONLY; Creation time in seconds since 1970-01-01T00:00:00Z.
	Created *date.UnixTime `json:"created,omitempty"`
	// Updated - READ-ONLY; Last updated time in seconds since 1970-01-01T00:00:00Z.
	Updated *date.UnixTime `json:"updated,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretAttributes.
func (sa SecretAttributes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sa.Enabled != nil {
		objectMap["enabled"] = sa.Enabled
	}
	if sa.NotBefore != nil {
		objectMap["nbf"] = sa.NotBefore
	}
	if sa.Expires != nil {
		objectMap["exp"] = sa.Expires
	}
	return json.Marshal(objectMap)
}

// SecretCreateOrUpdateParameters parameters for creating or updating a secret
type SecretCreateOrUpdateParameters struct {
	// Tags - The tags that will be assigned to the secret.
	Tags map[string]*string `json:"tags"`
	// Properties - Properties of the secret
	Properties *SecretProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretCreateOrUpdateParameters.
func (scoup SecretCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if scoup.Tags != nil {
		objectMap["tags"] = scoup.Tags
	}
	if scoup.Properties != nil {
		objectMap["properties"] = scoup.Properties
	}
	return json.Marshal(objectMap)
}

// SecretListResult list of secrets
type SecretListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of secrets.
	Value *[]Secret `json:"value,omitempty"`
	// NextLink - The URL to get the next set of secrets.
	NextLink *string `json:"nextLink,omitempty"`
}

// SecretListResultIterator provides access to a complete listing of Secret values.
type SecretListResultIterator struct {
	i    int
	page SecretListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *SecretListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecretListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *SecretListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter SecretListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter SecretListResultIterator) Response() SecretListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter SecretListResultIterator) Value() Secret {
	if !iter.page.NotDone() {
		return Secret{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the SecretListResultIterator type.
func NewSecretListResultIterator(page SecretListResultPage) SecretListResultIterator {
	return SecretListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr SecretListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr SecretListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// secretListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr SecretListResult) secretListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// SecretListResultPage contains a page of Secret values.
type SecretListResultPage struct {
	fn  func(context.Context, SecretListResult) (SecretListResult, error)
	slr SecretListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *SecretListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/SecretListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *SecretListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page SecretListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page SecretListResultPage) Response() SecretListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page SecretListResultPage) Values() []Secret {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the SecretListResultPage type.
func NewSecretListResultPage(cur SecretListResult, getNextPage func(context.Context, SecretListResult) (SecretListResult, error)) SecretListResultPage {
	return SecretListResultPage{
		fn:  getNextPage,
		slr: cur,
	}
}

// SecretPatchParameters parameters for patching a secret
type SecretPatchParameters struct {
	// Tags - The tags that will be assigned to the secret.
	Tags map[string]*string `json:"tags"`
	// Properties - Properties of the secret
	Properties *SecretPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretPatchParameters.
func (spp SecretPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spp.Tags != nil {
		objectMap["tags"] = spp.Tags
	}
	if spp.Properties != nil {
		objectMap["properties"] = spp.Properties
	}
	return json.Marshal(objectMap)
}

// SecretPatchProperties properties of the secret
type SecretPatchProperties struct {
	// Value - The value of the secret.
	Value *string `json:"value,omitempty"`
	// ContentType - The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`
	// Attributes - The attributes of the secret.
	Attributes *SecretAttributes `json:"attributes,omitempty"`
}

// SecretProperties properties of the secret
type SecretProperties struct {
	// Value - The value of the secret. NOTE: 'value' will never be returned from the service, as APIs using this model are is intended for internal use in ARM deployments. Users should use the data-plane REST service for interaction with vault secrets.
	Value *string `json:"value,omitempty"`
	// ContentType - The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`
	// Attributes - The attributes of the secret.
	Attributes *SecretAttributes `json:"attributes,omitempty"`
	// SecretURI - READ-ONLY; The URI to retrieve the current version of the secret.
	SecretURI *string `json:"secretUri,omitempty"`
	// SecretURIWithVersion - READ-ONLY; The URI to retrieve the specific version of the secret.
	SecretURIWithVersion *string `json:"secretUriWithVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for SecretProperties.
func (sp SecretProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.Value != nil {
		objectMap["value"] = sp.Value
	}
	if sp.ContentType != nil {
		objectMap["contentType"] = sp.ContentType
	}
	if sp.Attributes != nil {
		objectMap["attributes"] = sp.Attributes
	}
	return json.Marshal(objectMap)
}

// ServiceSpecification one property of operation, include log specifications.
type ServiceSpecification struct {
	// LogSpecifications - Log specifications of operation.
	LogSpecifications *[]LogSpecification `json:"logSpecifications,omitempty"`
	// MetricSpecifications - Metric specifications of operation.
	MetricSpecifications *[]MetricSpecification `json:"metricSpecifications,omitempty"`
}

// Sku SKU details
type Sku struct {
	// Family - SKU family name
	Family *string `json:"family,omitempty"`
	// Name - SKU name to specify whether the key vault is a standard vault or a premium vault. Possible values include: 'Standard', 'Premium'
	Name SkuName `json:"name,omitempty"`
}

// SystemData metadata pertaining to creation and last modification of the key vault resource.
type SystemData struct {
	// CreatedBy - The identity that created the key vault resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the key vault resource. Possible values include: 'IdentityTypeUser', 'IdentityTypeApplication', 'IdentityTypeManagedIdentity', 'IdentityTypeKey'
	CreatedByType IdentityType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of the key vault resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the key vault resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the key vault resource. Possible values include: 'IdentityTypeUser', 'IdentityTypeApplication', 'IdentityTypeManagedIdentity', 'IdentityTypeKey'
	LastModifiedByType IdentityType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of the key vault resource last modification (UTC).
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// Trigger ...
type Trigger struct {
	// TimeAfterCreate - The time duration after key creation to rotate the key. It only applies to rotate. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
	TimeAfterCreate *string `json:"timeAfterCreate,omitempty"`
	// TimeBeforeExpiry - The time duration before key expiring to rotate or notify. It will be in ISO 8601 duration format. Eg: 'P90D', 'P1Y'.
	TimeBeforeExpiry *string `json:"timeBeforeExpiry,omitempty"`
}

// Vault resource information with extended details.
type Vault struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty"`
	// Location - Azure location of the key vault resource.
	Location *string `json:"location,omitempty"`
	// Tags - Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags"`
	// SystemData - System metadata for the key vault.
	SystemData *SystemData `json:"systemData,omitempty"`
	// Properties - Properties of the vault
	Properties *VaultProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for Vault.
func (vVar Vault) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vVar.Location != nil {
		objectMap["location"] = vVar.Location
	}
	if vVar.Tags != nil {
		objectMap["tags"] = vVar.Tags
	}
	if vVar.SystemData != nil {
		objectMap["systemData"] = vVar.SystemData
	}
	if vVar.Properties != nil {
		objectMap["properties"] = vVar.Properties
	}
	return json.Marshal(objectMap)
}

// VaultAccessPolicyParameters parameters for updating the access policy in a vault
type VaultAccessPolicyParameters struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The resource id of the access policy.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The resource name of the access policy.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The resource name of the access policy.
	Type *string `json:"type,omitempty"`
	// Location - READ-ONLY; The resource type of the access policy.
	Location *string `json:"location,omitempty"`
	// Properties - Properties of the access policy
	Properties *VaultAccessPolicyProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VaultAccessPolicyParameters.
func (vapp VaultAccessPolicyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vapp.Properties != nil {
		objectMap["properties"] = vapp.Properties
	}
	return json.Marshal(objectMap)
}

// VaultAccessPolicyProperties properties of the vault access policy
type VaultAccessPolicyProperties struct {
	// AccessPolicies - An array of 0 to 16 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID.
	AccessPolicies *[]AccessPolicyEntry `json:"accessPolicies,omitempty"`
}

// VaultCheckNameAvailabilityParameters the parameters used to check the availability of the vault name.
type VaultCheckNameAvailabilityParameters struct {
	// Name - The vault name.
	Name *string `json:"name,omitempty"`
	// Type - The type of resource, Microsoft.KeyVault/vaults
	Type *string `json:"type,omitempty"`
}

// VaultCreateOrUpdateParameters parameters for creating or updating a vault
type VaultCreateOrUpdateParameters struct {
	// Location - The supported Azure location where the key vault should be created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags that will be assigned to the key vault.
	Tags map[string]*string `json:"tags"`
	// Properties - Properties of the vault
	Properties *VaultProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VaultCreateOrUpdateParameters.
func (vcoup VaultCreateOrUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vcoup.Location != nil {
		objectMap["location"] = vcoup.Location
	}
	if vcoup.Tags != nil {
		objectMap["tags"] = vcoup.Tags
	}
	if vcoup.Properties != nil {
		objectMap["properties"] = vcoup.Properties
	}
	return json.Marshal(objectMap)
}

// VaultListResult list of vaults
type VaultListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of vaults.
	Value *[]Vault `json:"value,omitempty"`
	// NextLink - The URL to get the next set of vaults.
	NextLink *string `json:"nextLink,omitempty"`
}

// VaultListResultIterator provides access to a complete listing of Vault values.
type VaultListResultIterator struct {
	i    int
	page VaultListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *VaultListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VaultListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *VaultListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter VaultListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter VaultListResultIterator) Response() VaultListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter VaultListResultIterator) Value() Vault {
	if !iter.page.NotDone() {
		return Vault{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the VaultListResultIterator type.
func NewVaultListResultIterator(page VaultListResultPage) VaultListResultIterator {
	return VaultListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (vlr VaultListResult) IsEmpty() bool {
	return vlr.Value == nil || len(*vlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (vlr VaultListResult) hasNextLink() bool {
	return vlr.NextLink != nil && len(*vlr.NextLink) != 0
}

// vaultListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (vlr VaultListResult) vaultListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !vlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(vlr.NextLink)))
}

// VaultListResultPage contains a page of Vault values.
type VaultListResultPage struct {
	fn  func(context.Context, VaultListResult) (VaultListResult, error)
	vlr VaultListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *VaultListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VaultListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.vlr)
		if err != nil {
			return err
		}
		page.vlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *VaultListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page VaultListResultPage) NotDone() bool {
	return !page.vlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page VaultListResultPage) Response() VaultListResult {
	return page.vlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page VaultListResultPage) Values() []Vault {
	if page.vlr.IsEmpty() {
		return nil
	}
	return *page.vlr.Value
}

// Creates a new instance of the VaultListResultPage type.
func NewVaultListResultPage(cur VaultListResult, getNextPage func(context.Context, VaultListResult) (VaultListResult, error)) VaultListResultPage {
	return VaultListResultPage{
		fn:  getNextPage,
		vlr: cur,
	}
}

// VaultPatchParameters parameters for creating or updating a vault
type VaultPatchParameters struct {
	// Tags - The tags that will be assigned to the key vault.
	Tags map[string]*string `json:"tags"`
	// Properties - Properties of the vault
	Properties *VaultPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for VaultPatchParameters.
func (vpp VaultPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vpp.Tags != nil {
		objectMap["tags"] = vpp.Tags
	}
	if vpp.Properties != nil {
		objectMap["properties"] = vpp.Properties
	}
	return json.Marshal(objectMap)
}

// VaultPatchProperties properties of the vault
type VaultPatchProperties struct {
	// TenantID - The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// Sku - SKU details
	Sku *Sku `json:"sku,omitempty"`
	// AccessPolicies - An array of 0 to 16 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID.
	AccessPolicies *[]AccessPolicyEntry `json:"accessPolicies,omitempty"`
	// EnabledForDeployment - Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
	EnabledForDeployment *bool `json:"enabledForDeployment,omitempty"`
	// EnabledForDiskEncryption - Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
	EnabledForDiskEncryption *bool `json:"enabledForDiskEncryption,omitempty"`
	// EnabledForTemplateDeployment - Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
	EnabledForTemplateDeployment *bool `json:"enabledForTemplateDeployment,omitempty"`
	// EnableSoftDelete - Property to specify whether the 'soft delete' functionality is enabled for this key vault. Once set to true, it cannot be reverted to false.
	EnableSoftDelete *bool `json:"enableSoftDelete,omitempty"`
	// EnableRbacAuthorization - Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC) for authorization of data actions, and the access policies specified in vault properties will be  ignored. When false, the key vault will use the access policies specified in vault properties, and any policy stored on Azure Resource Manager will be ignored. If null or not specified, the value of this property will not change.
	EnableRbacAuthorization *bool `json:"enableRbacAuthorization,omitempty"`
	// SoftDeleteRetentionInDays - softDelete data retention days. It accepts >=7 and <=90.
	SoftDeleteRetentionInDays *int32 `json:"softDeleteRetentionInDays,omitempty"`
	// CreateMode - The vault's create mode to indicate whether the vault need to be recovered or not. Possible values include: 'CreateModeRecover', 'CreateModeDefault'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// EnablePurgeProtection - Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates protection against purge for this vault and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling this functionality is irreversible - that is, the property does not accept false as its value.
	EnablePurgeProtection *bool `json:"enablePurgeProtection,omitempty"`
	// NetworkAcls - A collection of rules governing the accessibility of the vault from specific network locations.
	NetworkAcls *NetworkRuleSet `json:"networkAcls,omitempty"`
	// PublicNetworkAccess - Property to specify whether the vault will accept traffic from public internet. If set to 'disabled' all traffic except private endpoint traffic and that that originates from trusted services will be blocked. This will override the set firewall rules, meaning that even if the firewall rules are present we will not honor the rules.
	PublicNetworkAccess *string `json:"publicNetworkAccess,omitempty"`
}

// VaultProperties properties of the vault
type VaultProperties struct {
	// TenantID - The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *uuid.UUID `json:"tenantId,omitempty"`
	// Sku - SKU details
	Sku *Sku `json:"sku,omitempty"`
	// AccessPolicies - An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID. When `createMode` is set to `recover`, access policies are not required. Otherwise, access policies are required.
	AccessPolicies *[]AccessPolicyEntry `json:"accessPolicies,omitempty"`
	// VaultURI - The URI of the vault for performing operations on keys and secrets.
	VaultURI *string `json:"vaultUri,omitempty"`
	// HsmPoolResourceID - READ-ONLY; The resource id of HSM Pool.
	HsmPoolResourceID *string `json:"hsmPoolResourceId,omitempty"`
	// EnabledForDeployment - Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
	EnabledForDeployment *bool `json:"enabledForDeployment,omitempty"`
	// EnabledForDiskEncryption - Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
	EnabledForDiskEncryption *bool `json:"enabledForDiskEncryption,omitempty"`
	// EnabledForTemplateDeployment - Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
	EnabledForTemplateDeployment *bool `json:"enabledForTemplateDeployment,omitempty"`
	// EnableSoftDelete - Property to specify whether the 'soft delete' functionality is enabled for this key vault. If it's not set to any value(true or false) when creating new key vault, it will be set to true by default. Once set to true, it cannot be reverted to false.
	EnableSoftDelete *bool `json:"enableSoftDelete,omitempty"`
	// SoftDeleteRetentionInDays - softDelete data retention days. It accepts >=7 and <=90.
	SoftDeleteRetentionInDays *int32 `json:"softDeleteRetentionInDays,omitempty"`
	// EnableRbacAuthorization - Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC) for authorization of data actions, and the access policies specified in vault properties will be  ignored. When false, the key vault will use the access policies specified in vault properties, and any policy stored on Azure Resource Manager will be ignored. If null or not specified, the vault is created with the default value of false. Note that management actions are always authorized with RBAC.
	EnableRbacAuthorization *bool `json:"enableRbacAuthorization,omitempty"`
	// CreateMode - The vault's create mode to indicate whether the vault need to be recovered or not. Possible values include: 'CreateModeRecover', 'CreateModeDefault'
	CreateMode CreateMode `json:"createMode,omitempty"`
	// EnablePurgeProtection - Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates protection against purge for this vault and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling this functionality is irreversible - that is, the property does not accept false as its value.
	EnablePurgeProtection *bool `json:"enablePurgeProtection,omitempty"`
	// NetworkAcls - Rules governing the accessibility of the key vault from specific network locations.
	NetworkAcls *NetworkRuleSet `json:"networkAcls,omitempty"`
	// ProvisioningState - Provisioning state of the vault. Possible values include: 'Succeeded', 'RegisteringDNS'
	ProvisioningState VaultProvisioningState `json:"provisioningState,omitempty"`
	// PrivateEndpointConnections - READ-ONLY; List of private endpoint connections associated with the key vault.
	PrivateEndpointConnections *[]PrivateEndpointConnectionItem `json:"privateEndpointConnections,omitempty"`
	// PublicNetworkAccess - Property to specify whether the vault will accept traffic from public internet. If set to 'disabled' all traffic except private endpoint traffic and that that originates from trusted services will be blocked. This will override the set firewall rules, meaning that even if the firewall rules are present we will not honor the rules.
	PublicNetworkAccess *string `json:"publicNetworkAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for VaultProperties.
func (vp VaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vp.TenantID != nil {
		objectMap["tenantId"] = vp.TenantID
	}
	if vp.Sku != nil {
		objectMap["sku"] = vp.Sku
	}
	if vp.AccessPolicies != nil {
		objectMap["accessPolicies"] = vp.AccessPolicies
	}
	if vp.VaultURI != nil {
		objectMap["vaultUri"] = vp.VaultURI
	}
	if vp.EnabledForDeployment != nil {
		objectMap["enabledForDeployment"] = vp.EnabledForDeployment
	}
	if vp.EnabledForDiskEncryption != nil {
		objectMap["enabledForDiskEncryption"] = vp.EnabledForDiskEncryption
	}
	if vp.EnabledForTemplateDeployment != nil {
		objectMap["enabledForTemplateDeployment"] = vp.EnabledForTemplateDeployment
	}
	if vp.EnableSoftDelete != nil {
		objectMap["enableSoftDelete"] = vp.EnableSoftDelete
	}
	if vp.SoftDeleteRetentionInDays != nil {
		objectMap["softDeleteRetentionInDays"] = vp.SoftDeleteRetentionInDays
	}
	if vp.EnableRbacAuthorization != nil {
		objectMap["enableRbacAuthorization"] = vp.EnableRbacAuthorization
	}
	if vp.CreateMode != "" {
		objectMap["createMode"] = vp.CreateMode
	}
	if vp.EnablePurgeProtection != nil {
		objectMap["enablePurgeProtection"] = vp.EnablePurgeProtection
	}
	if vp.NetworkAcls != nil {
		objectMap["networkAcls"] = vp.NetworkAcls
	}
	if vp.ProvisioningState != "" {
		objectMap["provisioningState"] = vp.ProvisioningState
	}
	if vp.PublicNetworkAccess != nil {
		objectMap["publicNetworkAccess"] = vp.PublicNetworkAccess
	}
	return json.Marshal(objectMap)
}

// VaultsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VaultsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VaultsClient) (Vault, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VaultsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VaultsCreateOrUpdateFuture.Result.
func (future *VaultsCreateOrUpdateFuture) result(client VaultsClient) (vVar Vault, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.VaultsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		vVar.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("keyvault.VaultsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if vVar.Response.Response, err = future.GetResult(sender); err == nil && vVar.Response.Response.StatusCode != http.StatusNoContent {
		vVar, err = client.CreateOrUpdateResponder(vVar.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "keyvault.VaultsCreateOrUpdateFuture", "Result", vVar.Response.Response, "Failure responding to request")
		}
	}
	return
}

// VaultsPurgeDeletedFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type VaultsPurgeDeletedFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(VaultsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *VaultsPurgeDeletedFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for VaultsPurgeDeletedFuture.Result.
func (future *VaultsPurgeDeletedFuture) result(client VaultsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.VaultsPurgeDeletedFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("keyvault.VaultsPurgeDeletedFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// VirtualNetworkRule a rule governing the accessibility of a vault from a specific virtual network.
type VirtualNetworkRule struct {
	// ID - Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
	ID *string `json:"id,omitempty"`
	// IgnoreMissingVnetServiceEndpoint - Property to specify whether NRP will ignore the check if parent subnet has serviceEndpoints configured.
	IgnoreMissingVnetServiceEndpoint *bool `json:"ignoreMissingVnetServiceEndpoint,omitempty"`
}
