package storsimple

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// CloudAppliancesClient is the client for the CloudAppliances methods of the Storsimple service.
type CloudAppliancesClient struct {
	BaseClient
}

// NewCloudAppliancesClient creates an instance of the CloudAppliancesClient client.
func NewCloudAppliancesClient(subscriptionID string) CloudAppliancesClient {
	return NewCloudAppliancesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewCloudAppliancesClientWithBaseURI creates an instance of the CloudAppliancesClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewCloudAppliancesClientWithBaseURI(baseURI string, subscriptionID string) CloudAppliancesClient {
	return CloudAppliancesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ListSupportedConfigurations lists supported cloud appliance models and supported configurations.
// Parameters:
// resourceGroupName - the resource group name
// managerName - the manager name
func (client CloudAppliancesClient) ListSupportedConfigurations(ctx context.Context, resourceGroupName string, managerName string) (result CloudApplianceConfigurationList, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudAppliancesClient.ListSupportedConfigurations")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewError("storsimple.CloudAppliancesClient", "ListSupportedConfigurations", err.Error())
	}

	req, err := client.ListSupportedConfigurationsPreparer(ctx, resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.CloudAppliancesClient", "ListSupportedConfigurations", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSupportedConfigurationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storsimple.CloudAppliancesClient", "ListSupportedConfigurations", resp, "Failure sending request")
		return
	}

	result, err = client.ListSupportedConfigurationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.CloudAppliancesClient", "ListSupportedConfigurations", resp, "Failure responding to request")
		return
	}

	return
}

// ListSupportedConfigurationsPreparer prepares the ListSupportedConfigurations request.
func (client CloudAppliancesClient) ListSupportedConfigurationsPreparer(ctx context.Context, resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/cloudApplianceConfigurations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSupportedConfigurationsSender sends the ListSupportedConfigurations request. The method will close the
// http.Response Body if it receives an error.
func (client CloudAppliancesClient) ListSupportedConfigurationsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListSupportedConfigurationsResponder handles the response to the ListSupportedConfigurations request. The method always
// closes the http.Response Body.
func (client CloudAppliancesClient) ListSupportedConfigurationsResponder(resp *http.Response) (result CloudApplianceConfigurationList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Provision provisions cloud appliance.
// Parameters:
// parameters - the cloud appliance
// resourceGroupName - the resource group name
// managerName - the manager name
func (client CloudAppliancesClient) Provision(ctx context.Context, parameters CloudAppliance, resourceGroupName string, managerName string) (result CloudAppliancesProvisionFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/CloudAppliancesClient.Provision")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Name", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.VnetRegion", Name: validation.Null, Rule: true, Chain: nil}}},
		{TargetValue: managerName,
			Constraints: []validation.Constraint{{Target: "managerName", Name: validation.MaxLength, Rule: 50, Chain: nil},
				{Target: "managerName", Name: validation.MinLength, Rule: 2, Chain: nil}}}}); err != nil {
		return result, validation.NewError("storsimple.CloudAppliancesClient", "Provision", err.Error())
	}

	req, err := client.ProvisionPreparer(ctx, parameters, resourceGroupName, managerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.CloudAppliancesClient", "Provision", nil, "Failure preparing request")
		return
	}

	result, err = client.ProvisionSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storsimple.CloudAppliancesClient", "Provision", result.Response(), "Failure sending request")
		return
	}

	return
}

// ProvisionPreparer prepares the Provision request.
func (client CloudAppliancesClient) ProvisionPreparer(ctx context.Context, parameters CloudAppliance, resourceGroupName string, managerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managerName":       managerName,
		"resourceGroupName": resourceGroupName,
		"subscriptionId":    client.SubscriptionID,
	}

	const APIVersion = "2017-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/provisionCloudAppliance", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ProvisionSender sends the Provision request. The method will close the
// http.Response Body if it receives an error.
func (client CloudAppliancesClient) ProvisionSender(req *http.Request) (future CloudAppliancesProvisionFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// ProvisionResponder handles the response to the Provision request. The method always
// closes the http.Response Body.
func (client CloudAppliancesClient) ProvisionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}
