/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.choose.process;

import com.aspect.snoop.ui.choose.process.ClasspathEntry;
import com.aspect.snoop.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ByteArrayClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class ClasspathTreeModel
extends DefaultTreeModel {
    List<ClasspathEntry> entries = new ArrayList<ClasspathEntry>();
    List<String> classesSeen;
    private static Comparator alphabeticComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            String s1 = ((ClasspathEntry)o1).getStringEntry();
            String s2 = ((ClasspathEntry)o2).getStringEntry();
            return s1.toLowerCase().compareTo(s2.toLowerCase());
        }
    };

    public ClasspathTreeModel(TreeNode root) {
        super(root);
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof CtMethod;
    }

    private boolean hasEntry(String file) {
        for (ClasspathEntry entry : this.entries) {
            if (!entry.getStringEntry().equals(file)) continue;
            return true;
        }
        return false;
    }

    public void addEntry(ClasspathEntry entry) {
        String file = entry.getStringEntry();
        File f = new File(file);
        if (f.isFile() && this.hasEntry(file)) {
            return;
        }
        if (f.isDirectory()) {
            for (ClasspathEntry existingEntry : this.entries) {
                File existing = new File(existingEntry.getStringEntry());
                if (!f.getAbsolutePath().startsWith(existing.getAbsolutePath())) continue;
                return;
            }
        }
        this.entries.add(entry);
        Collections.sort(this.entries, alphabeticComparator);
    }

    public void removeEntry(ClasspathEntry entry) {
        this.entries.remove(entry);
        Collections.sort(this.entries, alphabeticComparator);
    }

    public List<ClasspathEntry> getEntries() {
        return this.entries;
    }

    public int getSize() {
        return this.entries.size();
    }

    @Override
    public void reload() {
        DefaultMutableTreeNode top = (DefaultMutableTreeNode)this.root;
        top.removeAllChildren();
        this.classesSeen = new ArrayList<String>();
        ClassPool pool = new ClassPool();
        for (ClasspathEntry entry : this.entries) {
            DefaultMutableTreeNode jarNode = new DefaultMutableTreeNode(entry);
            pool.insertClassPath(entry.getEntry());
            if (!entry.isJar()) continue;
            try {
                JarFile jar = new JarFile(entry.getStringEntry());
                Enumeration<JarEntry> jarEntries = jar.entries();
                while (jarEntries.hasMoreElements()) {
                    JarEntry jarEntry = jarEntries.nextElement();
                    if (jarEntry.isDirectory()) continue;
                    String entryName = jarEntry.getName();
                    if (entryName.endsWith(".class")) {
                        try {
                            String cls = jarEntry.getName().replaceAll("/", "\\.");
                            String shortendCls = cls.substring(0, cls.length() - 6);
                            this.classesSeen.add(shortendCls);
                            byte[] bytecode = IOUtil.getBytesFromStream(jar.getInputStream(jarEntry));
                            pool.insertClassPath((ClassPath)new ByteArrayClassPath(shortendCls, bytecode));
                            CtClass clazz = pool.get(shortendCls);
                            DefaultMutableTreeNode classNode = new DefaultMutableTreeNode(clazz);
                            for (CtMethod method : clazz.getDeclaredMethods()) {
                                DefaultMutableTreeNode methodNode = new DefaultMutableTreeNode(method);
                                classNode.add(methodNode);
                            }
                            jarNode.add(classNode);
                        }
                        catch (NotFoundException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    DefaultMutableTreeNode resourceNode = new DefaultMutableTreeNode(entryName);
                    jarNode.add(resourceNode);
                }
                top.add(jarNode);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    List<String> getClassesSeen() {
        return this.classesSeen;
    }
}

