/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui.tamper;

import com.aspect.snoop.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PrimitiveTableModel
extends AbstractTableModel {
    private List<Field> fields;
    private Object toEdit;
    private static String[] columnNames = new String[]{"Name", "Type", "Value"};

    public PrimitiveTableModel(Object o, List<Field> fields) {
        this.toEdit = o;
        this.fields = fields;
    }

    @Override
    public String getColumnName(int column) {
        return columnNames[column];
    }

    @Override
    public int getRowCount() {
        return this.fields.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 2;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.fields.get(rowIndex).getName();
            }
            case 1: 
            case 2: {
                try {
                    Field f = this.fields.get(rowIndex);
                    f.setAccessible(true);
                    Object innerObject = f.get(this.toEdit);
                    if (columnIndex == 1) {
                        return f.getType().getName();
                    }
                    return String.valueOf(innerObject);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object newObject, int rowIndex, int columnIndex) {
        Field f = this.fields.get(rowIndex);
        try {
            String s = (String)newObject;
            if (ReflectionUtil.isCharacter(f)) {
                f.setChar(this.toEdit, s.charAt(0));
            } else if (ReflectionUtil.isBoolean(f)) {
                f.setBoolean(this.toEdit, Boolean.parseBoolean(s));
            } else if (ReflectionUtil.isCharacter(f)) {
                f.setChar(this.toEdit, s.charAt(0));
            } else if (ReflectionUtil.isString(f)) {
                f.set(this.toEdit, s);
            } else if (ReflectionUtil.isByte(f)) {
                f.setByte(this.toEdit, Byte.parseByte(s));
            } else if (ReflectionUtil.isShort(f)) {
                f.setShort(this.toEdit, Short.parseShort(s));
            } else if (ReflectionUtil.isInteger(f)) {
                f.setInt(this.toEdit, Integer.parseInt(s));
            } else if (ReflectionUtil.isLong(f)) {
                f.setLong(this.toEdit, Long.parseLong(s));
            } else if (ReflectionUtil.isDouble(f)) {
                f.setDouble(this.toEdit, Double.parseDouble(s));
            } else if (ReflectionUtil.isFloat(f)) {
                f.setFloat(this.toEdit, Float.parseFloat(s));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

