// Copyright (c) 2012 Ecma International.  All rights reserved.
// Ecma International makes this code available under the terms and conditions set
// forth on http://hg.ecmascript.org/tests/test262/raw-file/tip/LICENSE (the
// "Use Terms").   Any redistribution of this code must retain the above
// copyright and this notice and otherwise comply with the Use Terms.

/*---
es5id: 15.4.4.17-7-c-i-7
description: >
    Array.prototype.some - element to be retrieved is inherited data
    property on an Array-like object
includes: [runTestCase.js]
---*/

function testcase() {

        var kValue = 'abc';

        function callbackfn(val, idx, obj) {
            if (5 === idx) {
                return kValue === val;
            }
            return false;
        }

        var proto = { 5: kValue };

        var Con = function () { };
        Con.prototype = proto;

        var child = new Con();
        child.length = 10;

        return Array.prototype.some.call(child, callbackfn);
    }
runTestCase(testcase);
