<!--===- docs/GettingInvolved.md

   Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
   See https://llvm.org/LICENSE.txt for license information.
   SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception

-->
# Getting Involved

```{contents}
---
local:
---
```

The Flang Project welcomes contributions of all kinds.
Please feel free to join the mailing list or the slack channel for discussions related to development of Flang.
To understand the status of various developments in Flang please join the respective call.

## Forum and Mailing Lists

[Forum](https://discourse.llvm.org/c/subprojects/flang)

  Flang forums are for technical discussions, questions about writing code for, or using Flang tools.


[Commits Archive (flang-commits)](http://lists.llvm.org/pipermail/flang-commits)

  This list contains all commit messages that are made when Flang developers
  commit code changes to the repository. It also serves as a forum for
  patch review (i.e. send patches here). It is useful for those who want to
  stay on the bleeding edge of Flang development. This list is high
  volume.

## Chat

### Flang Slack Workspace

-   There is a Slack workspace dedicated to Flang.
-   There are a number of topic-oriented channels available (e.g., #driver, #f18-semantics, #fir).
-   Add yourself via the *[invitation link](https://join.slack.com/t/flang-compiler/shared_invite/zt-2pcn51lh-VrRQL_YUOkxA_1CEfMGQhw "title")*

## Calls

### Flang Community Biweekly Call

-   General updates on the Flang project.
-   Join [Flang Community Biweekly Call](https://lanl-us.webex.com/lanl-us/j.php?MTID=mdce13c9bd55202e8071d8128fb953614)
    - If you prefer to join using a meeting number and password, those can be 
      found in this [Google Doc](https://docs.google.com/document/d/1Z2U5UAtJ-Dag5wlMaLaW1KRmNgENNAYynJqLW2j2AZQ/). Alternative methods of joining, such as call-in numbers, are also available.
-   Time: Wednesdays, 8:30 a.m. Pacific Time, on the weeks alternating with regular Flang Community Technical Biweekly Call.
-   Meeting minutes are available in this [Google Doc](https://docs.google.com/document/d/1Z2U5UAtJ-Dag5wlMaLaW1KRmNgENNAYynJqLW2j2AZQ/edit).
-   Minutes from older meetings were posted on the [Flang forum](https://discourse.llvm.org/c/subprojects/flang). Search for `Flang Biweekly Sync - Notes`.

### Flang Community Technical Biweekly Call

-   Technical topics call.
-   Join [Flang Community Technical Biweekly Call](https://teams.microsoft.com/l/meetup-join/19%3ameeting_YWU1NzU4ZjQtOTljOS00NWU1LTg5NjktYTUzOTU3MGEwMzAx%40thread.v2/0?context=%7b%22Tid%22%3a%22f34e5979-57d9-4aaa-ad4d-b122a662184d%22%2c%22Oid%22%3a%223641875c-ef5b-4767-8105-0787a195852f%22%7d)
    - If you prefer to join using a meeting ID and passcode, those can be 
      found in this [Google Doc](https://docs.google.com/document/d/1Z2U5UAtJ-Dag5wlMaLaW1KRmNgENNAYynJqLW2j2AZQ/). Alternative methods of joining, such as call-in numbers, are also available.
-   Time: Mondays, 8:30 a.m. Pacific Time, on the weeks alternating with regular Flang Community Biweekly Call.
-   The agenda is in this [Google Doc](https://docs.google.com/document/d/1Z2U5UAtJ-Dag5wlMaLaW1KRmNgENNAYynJqLW2j2AZQ/).

### LLVM Alias Analysis Technical Call

-   For people working on improvements to LLVM alias analysis.
-   Join [LLVM Alias Analysis Technical Call](https://teams.microsoft.com/l/meetup-join/19%3ameeting_MGI1Zjc1MGItZjJjZS00ZmE5LTg0OGYtMmQzNDU5YjQwODA2%40thread.v2/0?context=%7b%22Tid%22%3a%220cfca185-25f7-49e3-8ae7-704d5326e285%22%2c%22Oid%22%3a%220cacfb51-1523-4455-a443-adca936d1af0%22%7d)
-   Time: Tuesdays 10:00 AM Pacific Time, every 4 weeks.
-   The agenda is in this [Google Doc](https://docs.google.com/document/d/17U-WvX8qyKc3S36YUKr3xfF-GHunWyYowXbxEdpHscw).

### OpenMP in Flang Biweekly Technical Call

-   Development updates on OpenMP and OpenACC in the Flang Project.
-   Join [OpenMP in Flang Technical Call](https://bit.ly/39eQW3o)
-   Time: Biweekly call on Thursdays 8:00 AM Pacific time.
-   Meeting minutes are [here](https://docs.google.com/document/d/1yA-MeJf6RYY-ZXpdol0t7YoDoqtwAyBhFLr5thu5pFI).
-   Status tracking [page](https://docs.google.com/spreadsheets/d/1FvHPuSkGbl4mQZRAwCIndvQx9dQboffiD-xD0oqxgU0/edit#gid=0).

### OpenMP in LLVM Technical Call

-   Development updates on OpenMP (and OpenACC) in the LLVM Project, including Clang, optimization, and runtime work.
-   Join [OpenMP in LLVM Technical Call](https://bluejeans.com/544112769//webrtc)
-   Time: Weekly call on every Wednesday 7:00 AM Pacific time.
-   Meeting minutes are [here](https://docs.google.com/document/d/1Tz8WFN13n7yJ-SCE0Qjqf9LmjGUw0dWO9Ts1ss4YOdg/edit).
-   Status tracking [page](https://openmp.llvm.org/docs).

### Classic Flang Biweekly Technical Call

-   For people working on Classic Flang, the original Flang Fortran 2003/2008 compiler.
-   Join [Classic Flang Biweekly Technical Call](https://teams.microsoft.com/l/meetup-join/19%3ameeting_YjM5YjlmNGEtMjA0MS00MTRlLTg5ZjUtOTM1ZGIxOTU2NWQy%40thread.v2)
-   The call is held every other Wednesday in the same week as the LLVM Flang Technical call (alternate week with the Flang Community Biweekly call).
-   The agenda is available [here](https://docs.google.com/document/d/1-OuiKx4d7O6eLEJDBDKSRnSiUO2rgRR-c2Ga4AkrzOI)
