/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.api.Benchmark;
import com.google.caliper.model.Measurement;
import com.google.caliper.util.LastNValues;
import com.google.caliper.util.Util;
import com.google.caliper.worker.Worker;
import com.google.caliper.worker.WorkerEventLog;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;

public class MicrobenchmarkWorker
implements Worker {
    @Override
    public Collection<Measurement> measure(Benchmark benchmark, String methodName, Map<String, String> optionMap, WorkerEventLog log) throws Exception {
        Options options = new Options(optionMap);
        Trial trial = new Trial(benchmark, methodName, options, log);
        int targetReps = trial.warmUp();
        if (targetReps < 100) {
            throw new Exception("Too few reps");
        }
        return trial.run(targetReps);
    }

    private static class Options {
        long warmupNanos;
        long timingIntervalNanos;
        int reportedIntervals;
        double shortCircuitTolerance;
        long maxTotalRuntimeNanos;
        boolean gcBeforeEach;

        Options(Map<String, String> optionMap) {
            this.warmupNanos = Long.parseLong(optionMap.get("warmupNanos"));
            this.timingIntervalNanos = Long.parseLong(optionMap.get("timingIntervalNanos"));
            this.reportedIntervals = Integer.parseInt(optionMap.get("reportedIntervals"));
            this.shortCircuitTolerance = Double.parseDouble(optionMap.get("shortCircuitTolerance"));
            this.maxTotalRuntimeNanos = Long.parseLong(optionMap.get("maxTotalRuntimeNanos"));
            this.gcBeforeEach = Boolean.parseBoolean(optionMap.get("gcBeforeEach"));
            if (this.warmupNanos + (long)this.reportedIntervals * this.timingIntervalNanos > this.maxTotalRuntimeNanos) {
                throw new RuntimeException("maxTotalRuntime is too low");
            }
        }
    }

    private static class Trial {
        final Benchmark benchmark;
        final Method timeMethod;
        final Options options;
        final WorkerEventLog log;
        final long startTick;

        Trial(Benchmark benchmark, String methodName, Options options, WorkerEventLog log) throws Exception {
            this.benchmark = benchmark;
            this.timeMethod = benchmark.getClass().getDeclaredMethod("time" + methodName, Integer.TYPE);
            this.options = options;
            this.log = log;
            this.startTick = System.nanoTime();
            this.timeMethod.setAccessible(true);
        }

        int warmUp() throws Exception {
            this.log.notifyWarmupPhaseStarting();
            int targetReps = 1;
            long timeToEndWarmup = this.startTick + this.options.warmupNanos - this.options.timingIntervalNanos;
            while (System.nanoTime() < timeToEndWarmup) {
                long nanos = this.invokeTimeMethod(targetReps);
                targetReps = Trial.adjustRepCount(targetReps, nanos, this.options.timingIntervalNanos);
            }
            return targetReps;
        }

        Collection<Measurement> run(int targetReps) throws Exception {
            int[] repCounts = new int[]{(int)((double)targetReps * 0.7), (int)((double)targetReps * 0.9), (int)((double)targetReps * 1.1), (int)((double)targetReps * 1.3)};
            long timeToStop = this.startTick + this.options.maxTotalRuntimeNanos - this.options.timingIntervalNanos;
            LinkedList<Measurement> measurements = new LinkedList<Measurement>();
            LastNValues recentValues = new LastNValues(this.options.reportedIntervals);
            int i = 0;
            this.log.notifyMeasurementPhaseStarting();
            while (System.nanoTime() < timeToStop) {
                int reps = repCounts[i++ % repCounts.length];
                if (this.options.gcBeforeEach) {
                    Util.forceGc();
                }
                this.log.notifyMeasurementStarting();
                long nanos = this.invokeTimeMethod(reps);
                Measurement m = new Measurement();
                m.value = nanos;
                m.weight = reps;
                m.unit = "ns";
                m.description = "runtime";
                double nanosPerRep = m.value / m.weight;
                this.log.notifyMeasurementEnding(nanosPerRep);
                measurements.add(m);
                if (measurements.size() > this.options.reportedIntervals) {
                    measurements.remove();
                }
                recentValues.add(nanosPerRep);
                if (!this.shouldShortCircuit(recentValues)) continue;
                break;
            }
            return measurements;
        }

        private boolean shouldShortCircuit(LastNValues lastN) {
            return lastN.isFull() && lastN.normalizedStddev() < this.options.shortCircuitTolerance;
        }

        private static int adjustRepCount(int previousReps, long previousNanos, long targetNanos) {
            return (int)((long)previousReps * targetNanos / previousNanos);
        }

        private long invokeTimeMethod(int reps) throws Exception {
            long before = System.nanoTime();
            this.timeMethod.invoke((Object)this.benchmark, reps);
            return System.nanoTime() - before;
        }
    }
}

