// Copyright 2020 Google LLC.
// Use of this source code is governed by a BSD-style license that can be found in the LICENSE file.
#include "tools/fiddle/examples.h"
REG_FIDDLE(bug583299, 350, 256, false, 0) {
struct PieWedge {
    double fMove[2];
    double fLine1[2];
    double fArc1Angles[2];
    double fLine2[2];
    double fArc2Angles[2];
    unsigned char fRGB[3];
} wedges[] = {
    {{209, 62},
     {208.99999999999997, 15},
     {4.71238898038469, 4.864188625411087},
     {214.8974757323885, 62.4484788888183},
     {4.864188625411087, 4.71238898038469},
     {66, 165, 245}},
    {{214.8974757323885, 62.4484788888183},
     {222.00469007654902, 15.988953447137789},
     {4.864188625411087, 5.939986109728601},
     {245.72563512075425, 87.87644388981317},
     {5.939986109728601, 4.864188625411087},
     {239, 83, 80}},
    {{245.72563512075425, 87.87644388981317},
     {289.9847338560222, 72.06087626984443},
     {5.939986109728601, 0.6071985801055906},
     {241.02873602896423, 123.25219244000306},
     {0.6071985801055906, 5.939986109728601},
     {255, 202, 40}},
    {{241.02873602896423, 123.25219244000306},
     {279.62746919207495, 150.06893717539134},
     {0.6071985801055906, 1.2143971602111803},
     {222.6071759801575, 137.54921013982414},
     {1.2143971602111803, 0.6071985801055906},
     {102, 187, 106}},
    {{222.6071759801575, 137.54921013982414},
     {239.00556754598836, 181.59569415448402},
     {1.2143971602111803, 1.5905962804939922},
     {208.2278522599403, 139.99235550550287},
     {1.5905962804939922, 1.2143971602111803},
     {171, 71, 188}},
    {{208.2278522599403, 139.99235550550287},
     {207.29731523986837, 186.98314290957046},
     {1.5905962804939922, 1.8479956785822313},
     {198.32714338718876, 138.51120008373994},
     {1.8479956785822313, 1.5905962804939922},
     {38, 198, 218}},
    {{198.32714338718876, 138.51120008373994},
     {185.46498285380088, 183.71700531286245},
     {1.8479956785822313, 2.0657951692722794},
     {190.473805325209, 135.3188011281243},
     {2.0657951692722794, 1.8479956785822313},
     {255, 110, 64}},
    {{190.47380532520896, 135.31880112812428},
     {168.1473655889223, 176.6773563338125},
     {2.065795169272281, 2.296794629095059},
     {183.10858870915067, 130.16564453887622},
     {2.296794629095059, 2.065795169272281},
     {212, 225, 87}},
    {{183.10858870915067, 130.16564453887622},
     {151.90611869197326, 165.31398539341933},
     {2.296794629095059, 2.461794243254186},
     {178.66972101612106, 125.51681416416235},
     {2.461794243254186, 2.296794629095059},
     {189, 189, 189}},
    {{178.66972101612106, 125.51681416416235},
     {142.1178463432413, 155.06271841328106},
     {2.461794243254186, 2.5937939345814893},
     {175.7067515538738, 121.31156340374902},
     {2.5937939345814893, 2.461794243254186},
     {92, 107, 192}},
    {{175.70675155387386, 121.31156340374908},
     {135.58411881110644, 145.78960135185693},
     {2.5937939345814875, 2.719193641342425},
     {173.4277844354395, 116.98804177591612},
     {2.719193641342425, 2.5937939345814875},
     {79, 195, 247}},
    {{173.4277844354395, 116.98804177591612},
     {130.55870413968708, 136.25568186484068},
     {2.719193641342425, 2.831393378970633},
     {171.86136233918353, 112.90468784549111},
     {2.831393378970633, 2.719193641342425},
     {255, 167, 38}},
    {{171.86136233918353, 112.90468784549111},
     {127.104542594097, 127.25136294133937},
     {2.831393378970633, 2.9435931165988407},
     {170.76198015985182, 108.67162555814826},
     {2.9435931165988407, 2.831393378970633},
     {66, 165, 245}},
    {{170.76198015985182, 108.67162555814826},
     {124.68026394223733, 117.91691789745515},
     {2.9435931165988407, 2.99639299312976},
     {170.41039556773984, 106.64290968930811},
     {2.99639299312976, 2.9435931165988407},
     {239, 83, 80}},
    {{170.41039556773984, 106.64290968930811},
     {123.90497484168273, 113.44333931488454},
     {2.99639299312976, 3.095392761625238},
     {170.04161398270747, 102.80115488718383},
     {3.095392761625238, 2.99639299312976},
     {255, 202, 40}},
    {{170.04161398270747, 102.80115488718383},
     {123.09176416699597, 104.97177744353357},
     {3.095392761625238, 3.194392530120716},
     {170.05434999746018, 98.9417614619119},
     {3.194392530120716, 3.095392761625238},
     {102, 187, 106}},
    {{170.05434999746018, 98.94176146191197},
     {123.1198487123481, 96.46132014678024},
     {3.194392530120714, 3.2735923449170947},
     {170.33927335887392, 95.86694870665369},
     {3.2735923449170947, 3.194392530120714},
     {171, 71, 188}},
    {{170.33927335887392, 95.86694870665369},
     {123.74814125290146, 89.68096381467222},
     {3.2735923449170947, 3.352792159713477},
     {170.86657367205342, 92.82431675692668},
     {3.352792159713477, 3.2735923449170947},
     {38, 198, 218}},
    {{170.86657367205342, 92.82431675692668},
     {124.9109060460665, 82.97157028450496},
     {3.352792159713477, 3.412192020810762},
     {171.41917672588357, 90.57494738432324},
     {3.412192020810762, 3.352792159713477},
     {255, 110, 64}},
    {{171.41917672588357, 90.57494738432324},
     {126.12946662630736, 78.0114224372256},
     {3.412192020810762, 3.471591881908047},
     {172.1043388501384, 88.36235036430459},
     {3.471591881908047, 3.412192020810762},
     {212, 225, 87}},
    {{172.1043388501384, 88.36235036430453},
     {127.64033695158726, 73.13236234179972},
     {3.471591881908049, 3.5375917275716997},
     {173.01814557458636, 85.9565246000686},
     {3.5375917275716997, 3.471591881908049},
     {189, 189, 189}},
    {{173.01814557458636, 85.9565246000686},
     {129.65539793370326, 67.82720809245897},
     {3.5375917275716997, 3.5441917121380655},
     {173.11821523751334, 85.71937428445484},
     {3.5441917121380655, 3.5375917275716997},
     {92, 107, 192}},
    {{173.11821523751334, 85.71937428445484},
     {129.8760643699012, 67.30426124264403},
     {3.5441917121380655, 3.5969915886689847},
     {173.97466004891183, 83.84699556023183},
     {3.5969915886689847, 3.5441917121380655},
     {79, 195, 247}},
    {{173.97466004891183, 83.84699556023183},
     {131.7646349796517, 63.17542610717788},
     {3.5969915886689847, 3.6497914651999075},
     {174.9287267647916, 82.02242533589258},
     {3.6497914651999075, 3.5969915886689847},
     {255, 167, 38}},
    {{174.9287267647916, 82.02242533589258},
     {133.86847440441224, 59.15201484325031},
     {3.6497914651999075, 3.689391372598097},
     {175.7067515538738, 80.688436596251},
     {3.689391372598097, 3.6497914651999075},
     {66, 165, 245}},
    {{175.70675155387386, 80.68843659625094},
     {135.5841188111064, 56.210398648143084},
     {3.6893913725980987, 3.728991279996288},
     {176.53697841699477, 79.38629532677618},
     {3.728991279996288, 3.6893913725980987},
     {239, 83, 80}},
    {{176.53697841699477, 79.38629532677618},
     {137.41487548362952, 53.33901020776284},
     {3.728991279996288, 3.7619912028281135},
     {177.26777398454274, 78.32698008416307},
     {3.7619912028281135, 3.728991279996288},
     {255, 202, 40}},
    {{177.26777398454274, 78.32698008416307},
     {139.0263734018122, 51.003084288154476},
     {3.7619912028281135, 3.788391141093573},
     {177.87732813607064, 77.49724918120904},
     {3.788391141093573, 3.7619912028281135},
     {102, 187, 106}},
    {{177.87732813607064, 77.49724918120904},
     {140.37051845389936, 49.17342127138402},
     {3.788391141093573, 3.8147910793590345},
     {178.50857218374682, 76.68389772750939},
     {3.8147910793590345, 3.788391141093573},
     {171, 71, 188}},
    {{178.50857218374682, 76.68389772750939},
     {141.7624925077494, 47.379877040148926},
     {3.8147910793590345, 3.83459103305813},
     {178.99597513166773, 76.0849745795735},
     {3.83459103305813, 3.8147910793590345},
     {38, 198, 218}},
    {{178.99597513166773, 76.0849745795735},
     {142.83727849547242, 46.05917471393132},
     {3.83459103305813, 3.8543909867572257},
     {179.49514041820387, 75.49581875341823},
     {3.8543909867572257, 3.83459103305813},
     {255, 110, 64}},
    {{179.49514041820387, 75.49581875341823},
     {143.93800194783418, 44.76001058446072},
     {3.8543909867572257, 3.8741909404563213},
     {180.0058723579047, 74.91666121306773},
     {3.8741909404563213, 3.8543909867572257},
     {212, 225, 87}},
    {{180.00587235790465, 74.91666121306778},
     {145.0642313533282, 43.482893957021275},
     {3.8741909404563195, 3.893990894155415},
     {180.52797073089823, 74.34772900296463},
     {3.893990894155415, 3.8741909404563195},
     {189, 189, 189}},
    {{180.52797073089823, 74.34772900296463},
     {146.21552520146793, 42.22832549371687},
     {3.893990894155415, 3.9137908478545107},
     {181.06123086138257, 73.78924515896263},
     {3.9137908478545107, 3.893990894155415},
     {92, 107, 192}},
    {{181.06123086138257, 73.78924515896263},
     {147.39143215586927, 40.996797017199654},
     {3.9137908478545107, 3.9335908015536063},
     {181.60544369786365, 73.24142862089114},
     {3.9335908015536063, 3.9137908478545107},
     {79, 195, 247}},
    {{181.60544369786365, 73.24142862089114},
     {148.59149123118652, 39.78879131786252},
     {3.9335908015536063, 3.953390755252702},
     {182.16039589510896, 72.70449414672505},
     {3.953390755252702, 3.9335908015536063},
     {255, 167, 38}},
    {{182.16039589510896, 72.70449414672505},
     {149.81523197383004, 38.604781964573206},
     {3.953390755252702, 3.9731907089517975},
     {182.72586989778426, 72.1786522283943},
     {3.9731907089517975, 3.953390755252702},
     {66, 165, 245}},
    {{182.72586989778426, 72.1786522283943},
     {151.0621746463961, 37.44523311902331},
     {3.9731907089517975, 3.9863906780845255},
     {183.1085887091506, 71.83435546112383},
     {3.9863906780845255, 3.9731907089517975},
     {239, 83, 80}},
    {{183.10858870915067, 71.83435546112379},
     {151.90611869197326, 36.68601460658067},
     {3.9863906780845273, 3.999590647217257},
     {183.49581875341823, 71.49514041820387},
     {3.999590647217257, 3.9863906780845273},
     {255, 202, 40}},
    {{183.49581875341823, 71.49514041820387},
     {152.7600105844607, 35.938001947834195},
     {3.999590647217257, 4.012790616349987},
     {183.88749256091927, 71.161066203329},
     {4.012790616349987, 3.999590647217257},
     {102, 187, 106}},
    {{183.8874925609193, 71.16106620332897},
     {153.6237015445913, 35.20132547400746},
     {4.012790616349989, 4.025990585482717},
     {184.28354188771962, 70.83219102447296},
     {4.025990585482717, 4.012790616349989},
     {171, 71, 188}},
    {{184.28354188771968, 70.83219102447292},
     {154.49704108574082, 34.47611354114541},
     {4.0259905854827185, 4.039190554615448},
     {184.6838977275094, 70.50857218374685},
     {4.039190554615448, 4.0259905854827185},
     {38, 198, 218}},
    {{184.6838977275094, 70.50857218374685},
     {155.3798770401489, 33.76249250774944},
     {4.039190554615448, 4.052390523748178},
     {185.08849032362605, 70.19026606741508},
     {4.052390523748178, 4.039190554615448},
     {255, 110, 64}},
    {{185.0884903236261, 70.19026606741504},
     {156.2720555854319, 33.06058671276138},
     {4.05239052374818, 4.065590492880908},
     {185.49724918120899, 69.87732813607067},
     {4.065590492880908, 4.05239052374818},
     {212, 225, 87}},
    {{185.49724918120899, 69.87732813607067},
     {157.1734212713839, 32.37051845389945},
     {4.065590492880908, 4.0787904620136395},
     {185.91010307948213, 69.56981291497203},
     {4.0787904620136395, 4.065590492880908},
     {189, 189, 189}},
    {{185.91010307948213, 69.56981291497203},
     {158.08381704706312, 31.692407966348583},
     {4.0787904620136395, 4.091990431146369},
     {186.32698008416307, 69.26777398454276},
     {4.091990431146369, 4.0787904620136395},
     {92, 107, 192}},
    {{186.32698008416307, 69.26777398454276},
     {159.00308428815444, 31.026373401812222},
     {4.091990431146369, 4.105190400279099},
     {186.74780755999694, 68.97126397103578},
     {4.105190400279099, 4.091990431146369},
     {79, 195, 247}},
    {{186.74780755999694, 68.97126397103578},
     {159.93106282460863, 30.37253080792506},
     {4.105190400279099, 4.118390369411829},
     {187.17251218341195, 68.68033453736409},
     {4.118390369411829, 4.105190400279099},
     {255, 167, 38}},
    {{187.172512183412, 68.68033453736405},
     {160.86759096854956, 29.730994108033556},
     {4.118390369411831, 4.131590338544559},
     {187.60101995529507, 68.3950363740991},
     {4.131590338544559, 4.118390369411831},
     {66, 165, 245}},
    {{187.60101995529507, 68.3950363740991},
     {161.81250554244556, 29.101875081346734},
     {4.131590338544559, 4.14479030767729},
     {188.0332562138855, 68.11541919063848},
     {4.14479030767729, 4.131590338544559},
     {239, 83, 80}},
    {{188.0332562138855, 68.11541919063848},
     {162.76564190754235, 28.4852833434592},
     {4.14479030767729, 4.151390292243654},
     {188.25074901590185, 67.97775623009694},
     {4.151390292243654, 4.14479030767729},
     {255, 202, 40}},
    {{188.25074901590185, 67.97775623009694},
     {163.24524141968098, 28.181718866367618},
     {4.151390292243654, 4.15799027681002},
     {188.4691456477831, 67.84153170654506},
     {4.15799027681002, 4.151390292243654},
     {102, 187, 106}},
    {{188.4691456477831, 67.84153170654506},
     {163.72683399254737, 27.88132632725319},
     {4.15799027681002, 4.164590261376386},
     {188.688436596251, 67.70675155387381},
     {4.164590261376386, 4.15799027681002},
     {171, 71, 188}},
    {{188.688436596251, 67.70675155387381},
     {164.21039864814318, 27.584118811106364},
     {4.164590261376386, 4.17119024594275},
     {188.90861230907103, 67.57342164305794},
     {4.17119024594275, 4.164590261376386},
     {38, 198, 218}},
    {{188.90861230907103, 67.57342164305794},
     {164.6959143225669, 27.290109264179037},
     {4.17119024594275, 4.177790230509116},
     {189.129663195469, 67.44154778190001},
     {4.177790230509116, 4.17119024594275},
     {255, 110, 64}},
    {{189.129663195469, 67.44154778190001},
     {165.1833598669316, 26.999310493420538},
     {4.177790230509116, 4.1843902150754815},
     {189.35157962654816, 67.31113571477775},
     {4.1843902150754815, 4.177790230509116},
     {212, 225, 87}},
    {{189.35157962654816, 67.31113571477775},
     {165.6727140482857, 26.711735165920174},
     {4.1843902150754815, 4.1909901996418455},
     {189.57435193570907, 67.18219112239366},
     {4.1909901996418455, 4.1843902150754815},
     {189, 189, 189}},
    {{189.57435193570907, 67.18219112239366},
     {166.16395555053796, 26.427395808355243},
     {4.1909901996418455, 4.1975901842082095},
     {189.7979704190706, 67.05471962152747},
     {4.1975901842082095, 4.1909901996418455},
     {92, 107, 192}},
    {{189.7979704190706, 67.05471962152747},
     {166.65706297538645, 26.146304806445187},
     {4.1975901842082095, 4.204190168774575},
     {190.02242533589256, 66.9287267647916},
     {4.204190168774575, 4.1975901842082095},
     {79, 195, 247}},
    {{190.02242533589262, 66.92872676479158},
     {167.1520148432504, 25.868474404412183},
     {4.204190168774577, 4.210790153340941},
     {190.247706909, 66.80421804038936},
     {4.210790153340941, 4.204190168774577},
     {255, 167, 38}},
    {{190.247706909, 66.80421804038936},
     {167.64878959420508, 25.593916704448333},
     {4.210790153340941, 4.217390137907305},
     {190.47380532520896, 66.68119887187574},
     {4.217390137907305, 4.210790153340941},
     {66, 165, 245}},
    {{190.47380532520896, 66.68119887187574},
     {168.1473655889223, 25.322643666187517},
     {4.217390137907305, 4.223990122473671},
     {190.7007107357544, 66.55967461792113},
     {4.223990122473671, 4.217390137907305},
     {239, 83, 80}},
    {{190.70071073575446, 66.5596746179211},
     {168.6477211096124, 25.054667106185008},
     {4.223990122473673, 4.230590107040037},
     {190.9284132567187, 66.43965057207814},
     {4.230590107040037, 4.223990122473673},
     {255, 202, 40}},
    {{190.9284132567187, 66.43965057207814},
     {169.14983436096944, 24.789998697403064},
     {4.230590107040037, 4.237190091606401},
     {191.15690296946235, 66.32113196255075},
     {4.237190091606401, 4.230590107040037},
     {102, 187, 106}},
    {{191.15690296946235, 66.32113196255075},
     {169.65368347112212, 24.528649968701657},
     {4.237190091606401, 4.2437900761727665},
     {191.3861699210563, 66.2041239519667},
     {4.2437900761727665, 4.237190091606401},
     {171, 71, 188}},
    {{191.38616992105636, 66.20412395196666},
     {170.15924649258585, 24.27063230433673},
     {4.243790076172768, 4.250390060739132},
     {191.616204124715, 66.08863163715256},
     {4.250390060739132, 4.243790076172768},
     {38, 198, 218}},
    {{191.616204124715, 66.08863163715256},
     {170.66650140321772, 24.01595694346463},
     {4.250390060739132, 4.256990045305496},
     {191.84699556023176, 65.97466004891186},
     {4.256990045305496, 4.250390060739132},
     {255, 110, 64}},
    {{191.84699556023176, 65.97466004891186},
     {171.1754261071777, 23.764634979651802},
     {4.256990045305496, 4.263590029871862},
     {192.07853417441524, 65.86221415180566},
     {4.263590029871862, 4.256990045305496},
     {212, 225, 87}},
    {{192.07853417441524, 65.86221415180566},
     {171.68599843588999, 23.516677360391967},
     {4.263590029871862, 4.270190014438228},
     {192.31080988152712, 65.75129884393658},
     {4.270190014438228, 4.263590029871862},
     {189, 189, 189}},
    {{192.31080988152712, 65.75129884393658},
     {172.1981961490085, 23.272094886629375},
     {4.270190014438228, 4.276789999004592},
     {192.54381256372162, 65.64191895673532},
     {4.276789999004592, 4.270190014438228},
     {92, 107, 192}},
    {{192.54381256372162, 65.64191895673532},
     {172.7119969353861, 23.03089821228815},
     {4.276789999004592, 4.283389983570958},
     {192.7775320714863, 65.53407925475014},
     {4.283389983570958, 4.276789999004592},
     {79, 195, 247}},
    {{192.7775320714863, 65.53407925475014},
     {173.2273784140467, 22.793097843808},
     {4.283389983570958, 4.2899899681373235},
     {193.01195822408394, 65.42778443543946},
     {4.2899899681373235, 4.283389983570958},
     {255, 167, 38}},
    {{193.01195822408394, 65.42778443543946},
     {173.74431813515946, 22.558704139687023},
     {4.2899899681373235, 4.2965899527036875},
     {193.24708080999608, 65.3230391289672},
     {4.2965899527036875, 4.2899899681373235},
     {66, 165, 245}},
    {{193.24708080999608, 65.3230391289672},
     {174.262793581017, 22.327727310030212},
     {4.2965899527036875, 4.3031899372700515},
     {193.48288958736805, 65.21984789800092},
     {4.3031899372700515, 4.2965899527036875},
     {239, 83, 80}},
    {{193.48288958736805, 65.21984789800092},
     {174.7827821670167, 22.1001774161046},
     {4.3031899372700515, 4.309789921836417},
     {193.71937428445483, 65.11821523751334},
     {4.309789921836417, 4.3031899372700515},
     {255, 202, 40}},
    {{193.7193742844549, 65.11821523751331},
     {175.30426124264415, 21.876064369901144},
     {4.309789921836419, 4.316389906402783},
     {193.95652460006858, 65.01814557458637},
     {4.316389906402783, 4.309789921836419},
     {102, 187, 106}},
    {{193.95652460006858, 65.01814557458637},
     {175.82720809245893, 21.65539793370327},
     {4.316389906402783, 4.322989890969147},
     {194.1943302040273, 64.91964326821835},
     {4.322989890969147, 4.316389906402783},
     {171, 71, 188}},
    {{194.1943302040273, 64.91964326821835},
     {176.35159993708584, 21.438187719660974},
     {4.322989890969147, 4.329589875535513},
     {194.43278073760504, 64.82271260913404},
     {4.329589875535513, 4.322989890969147},
     {38, 198, 218}},
    {{194.43278073760504, 64.82271260913404},
     {176.87741393420595, 21.224443189372508},
     {4.329589875535513, 4.336189860101879},
     {194.67186581398275, 64.72735781959793},
     {4.336189860101879, 4.329589875535513},
     {255, 110, 64}},
    {{194.67186581398275, 64.72735781959793},
     {177.4046271795517, 21.01417365347234},
     {4.336189860101879, 4.342789844668243},
     {194.911575018701, 64.63358305323013},
     {4.342789844668243, 4.336189860101879},
     {212, 225, 87}},
    {{194.911575018701, 64.63358305323013},
     {177.93321670790476, 20.807388271225435},
     {4.342789844668243, 4.3493898292346085},
     {195.15189791011366, 64.54139239482552},
     {4.3493898292346085, 4.342789844668243},
     {189, 189, 189}},
    {{195.15189791011366, 64.54139239482552},
     {178.46315949409683, 20.604096050128078},
     {4.3493898292346085, 4.355989813800974},
     {195.39282401984252, 64.45078986017583},
     {4.355989813800974, 4.3493898292346085},
     {92, 107, 192}},
    {{195.39282401984252, 64.45078986017583},
     {178.9944324540117, 20.40430584551595},
     {4.355989813800974, 4.362589798367338},
     {195.6343428532333, 64.36177939589473},
     {4.362589798367338, 4.355989813800974},
     {79, 195, 247}},
    {{195.6343428532333, 64.36177939589473},
     {179.52701244559137, 20.20802636017811},
     {4.362589798367338, 4.369189782933702},
     {195.87644388981312, 64.27436487924578},
     {4.369189782933702, 4.362589798367338},
     {255, 167, 38}},
    {{195.87644388981317, 64.27436487924575},
     {180.0608762698444, 20.01526614397781},
     {4.369189782933704, 4.37578976750007},
     {196.1191165837485, 64.18855011797365},
     {4.37578976750007, 4.369189782933704},
     {66, 165, 245}},
    {{196.1191165837485, 64.18855011797365},
     {180.59600067185568, 19.826033593480375},
     {4.37578976750007, 4.382389752066434},
     {196.36235036430452, 64.10433885013842},
     {4.382389752066434, 4.37578976750007},
     {239, 83, 80}},
    {{196.36235036430452, 64.10433885013842},
     {181.1323623417997, 19.640336951587273},
     {4.382389752066434, 4.388989736632798},
     {196.60613463630577, 64.02173474395235},
     {4.388989736632798, 4.382389752066434},
     {255, 202, 40}},
    {{196.60613463630577, 64.02173474395235},
     {181.66993791595633, 19.458184307176978},
     {4.388989736632798, 4.395589721199164},
     {196.8504587805977, 63.94074139762042},
     {4.395589721199164, 4.388989736632798},
     {102, 187, 106}},
    {{196.8504587805977, 63.94074139762042},
     {182.20870397772828, 19.279583594752737},
     {4.395589721199164, 4.4021897057655295},
     {197.0953121545089, 63.86136233918352},
     {4.4021897057655295, 4.395589721199164},
     {171, 71, 188}},
    {{197.0953121545089, 63.86136233918352},
     {182.74863705866062, 19.104542594096998},
     {4.4021897057655295, 4.4087896903318935},
     {197.34068409231492, 63.783601026364714},
     {4.4087896903318935, 4.4021897057655295},
     {38, 198, 218}},
    {{197.34068409231492, 63.783601026364714},
     {183.28971363946366, 18.933068929932446},
     {4.4087896903318935, 4.415389674898259},
     {197.5865639057031, 63.70746084641862},
     {4.415389674898259, 4.4087896903318935},
     {255, 110, 64}},
    {{197.5865639057031, 63.70746084641862},
     {183.83191015103756, 18.76517007158978},
     {4.415389674898259, 4.421989659464625},
     {197.83294088423762, 63.632945115983944},
     {4.421989659464625, 4.415389674898259},
     {212, 225, 87}},
    {{197.83294088423762, 63.632945115983944},
     {184.37520297549833, 18.600853332682547},
     {4.421989659464625, 4.428589644030989},
     {198.07980429582642, 63.56005708093896},
     {4.428589644030989, 4.421989659464625},
     {189, 189, 189}},
    {{198.07980429582642, 63.56005708093896},
     {184.91956844720698, 18.440125870788478},
     {4.428589644030989, 4.435189628597355},
     {198.32714338718876, 63.48879991626006},
     {4.435189628597355, 4.428589644030989},
     {92, 107, 192}},
    {{198.32714338718876, 63.48879991626006},
     {185.46498285380085, 18.28299468713756},
     {4.435189628597355, 4.441789613163721},
     {198.57494738432322, 63.419176725883574},
     {4.441789613163721, 4.435189628597355},
     {79, 195, 247}},
    {{198.57494738432322, 63.419176725883574},
     {186.01142243722558, 18.129466626307362},
     {4.441789613163721, 4.448389597730085},
     {198.8232054929773, 63.3511905425705},
     {4.448389597730085, 4.441789613163721},
     {255, 167, 38}},
    {{198.8232054929773, 63.3511905425705},
     {186.5588633947705, 17.97954837592468},
     {4.448389597730085, 4.461589566862816},
     {199.3210407694013, 63.220140971512244},
     {4.461589566862816, 4.448389597730085},
     {66, 165, 245}},
    {{199.3210407694013, 63.220140971512244},
     {187.6566540043208, 17.690567270514165},
     {4.461589566862816, 4.46818955142918},
     {199.57059625164655, 63.15708329223899},
     {4.46818955142918, 4.461589566862816},
     {239, 83, 80}},
    {{199.57059625164655, 63.15708329223899},
     {188.20695583696417, 17.551517003398786},
     {4.46818955142918, 4.474789535995544},
     {199.8205624753071, 63.095674036724255},
     {4.474789535995544, 4.46818955142918},
     {255, 202, 40}},
    {{199.82056247530716, 63.09567403672424},
     {188.75816340708758, 17.416101722007298},
     {4.474789535995546, 4.481389520561912},
     {200.0709285519448, 63.03591587993297},
     {4.481389520561912, 4.474789535995546},
     {102, 187, 106}},
    {{200.0709285519448, 63.03591587993297},
     {189.31025270428856, 17.284327324980396},
     {4.481389520561912, 4.487989505128276},
     {200.32168357570373, 62.97781142490888},
     {4.487989505128276, 4.481389520561912},
     {171, 71, 188}},
    {{200.32168357570373, 62.97781142490888},
     {189.86319967975695, 17.156199552363162},
     {4.487989505128276, 4.49458948969464},
     {200.57281662378588, 62.921363202660984},
     {4.49458948969464, 4.487989505128276},
     {38, 198, 218}},
    {{200.57281662378588, 62.921363202660984},
     {190.41698024732275, 17.031723985355},
     {4.49458948969464, 4.501189474261006},
     {200.82431675692666, 62.86657367205342},
     {4.501189474261006, 4.49458948969464},
     {255, 110, 64}},
    {{200.82431675692672, 62.8665736720534},
     {190.9715702845051, 16.910906046066472},
     {4.5011894742610075, 4.5077894588273715},
     {201.07617301987116, 62.8134452196983},
     {4.5077894588273715, 4.5011894742610075},
     {212, 225, 87}},
    {{201.07617301987116, 62.8134452196983},
     {191.52694563356206, 16.79375099728344},
     {4.5077894588273715, 4.5143894433937355},
     {201.32837444185168, 62.76198015985183},
     {4.5143894433937355, 4.5077894588273715},
     {189, 189, 189}},
    {{201.32837444185168, 62.76198015985183},
     {192.0830821025447, 16.68026394223736},
     {4.5143894433937355, 4.520989427960101},
     {201.5809100370656, 62.71218073431335},
     {4.520989427960101, 4.5143894433937355},
     {92, 107, 192}},
    {{201.5809100370656, 62.71218073431335},
     {192.6399554663498, 16.570449824383275},
     {4.520989427960101, 4.527589412526467},
     {201.83376880515377, 62.664049112327824},
     {4.527589412526467, 4.520989427960101},
     {79, 195, 247}},
    {{201.83376880515377, 62.664049112327824},
     {193.19754146777498, 16.464313427184436},
     {4.527589412526467, 4.534189397092831},
     {202.08693973167965, 62.61758739049132},
     {4.534189397092831, 4.527589412526467},
     {255, 167, 38}},
    {{202.08693973167965, 62.61758739049132},
     {193.75581581857563, 16.36185937390394},
     {4.534189397092831, 4.540789381659197},
     {202.34041178860943, 62.5727975926596},
     {4.540789381659197, 4.534189397092831},
     {66, 165, 245}},
    {{202.34041178860943, 62.5727975926596},
     {194.31475420052337, 16.263092127403226},
     {4.540789381659197, 4.547389366225563},
     {202.59417393479197, 62.529681669860054},
     {4.547389366225563, 4.540789381659197},
     {239, 83, 80}},
    {{202.59417393479197, 62.529681669860054},
     {194.87433226646434, 16.16801598994782},
     {4.547389366225563, 4.553989350791927},
     {202.84821511643992, 62.4882415002067},
     {4.553989350791927, 4.547389366225563},
     {255, 202, 40}},
    {{202.84821511643992, 62.4882415002067},
     {195.43452564138033, 16.076635103019896},
     {4.553989350791927, 4.560589335358291},
     {203.10252426761141, 62.44847888881831},
     {4.560589335358291, 4.553989350791927},
     {102, 187, 106}},
    {{203.10252426761141, 62.44847888881831},
     {195.99530992345078, 15.988953447137803},
     {4.560589335358291, 4.5671893199246565},
     {203.3570903106919, 62.41039556773984},
     {4.5671893199246565, 4.560589335358291},
     {171, 71, 188}},
    {{203.35709031069194, 62.41039556773983},
     {196.5566606851156, 15.904974841682716},
     {4.567189319924658, 4.573789304491022},
     {203.6119021568766, 62.373993195867},
     {4.573789304491022, 4.567189319924658},
     {38, 198, 218}},
    {{203.6119021568766, 62.373993195867},
     {197.1185534741381, 15.824702944732365},
     {4.573789304491022, 4.580389289057386},
     {203.8669487066536, 62.33927335887393},
     {4.580389289057386, 4.573789304491022},
     {255, 110, 64}},
    {{203.8669487066536, 62.33927335887393},
     {197.68096381467205, 15.74814125290149},
     {4.580389289057386, 4.586989273623752},
     {204.12221885028765, 62.30623756914416},
     {4.586989273623752, 4.580389289057386},
     {212, 225, 87}},
    {{204.12221885028765, 62.30623756914416},
     {198.24386720832663, 15.67529310118968},
     {4.586989273623752, 4.593589258190118},
     {204.3777014683036, 62.274887265704734},
     {4.593589258190118, 4.586989273623752},
     {189, 189, 189}},
    {{204.3777014683036, 62.274887265704734},
     {198.80723913523357, 15.606161662836087},
     {4.593589258190118, 4.600189242756482},
     {204.63338543197096, 62.245223814163545},
     {4.600189242756482, 4.593589258190118},
     {92, 107, 192}},
    {{204.63338543197096, 62.245223814163545},
     {199.37105505511542, 15.540749949181148},
     {4.600189242756482, 4.606789227322848},
     {204.88925960378893, 62.21724850664979},
     {4.606789227322848, 4.600189242756482},
     {79, 195, 247}},
    {{204.88925960378893, 62.21724850664979},
     {199.93529040835506, 15.479060809535426},
     {4.606789227322848, 4.6133892118892135},
     {205.1453128379711, 62.190962561757736},
     {4.6133892118892135, 4.606789227322848},
     {255, 167, 38}},
    {{205.1453128379711, 62.190962561757736},
     {200.49992061706448, 15.42109693105553},
     {4.6133892118892135, 4.6199891964555775},
     {205.4015339809312, 62.166367124493654},
     {4.6199891964555775, 4.6133892118892135},
     {66, 165, 245}},
    {{205.4015339809312, 62.166367124493654},
     {201.06492108615595, 15.366860838627034},
     {4.6199891964555775, 4.626589181021943},
     {205.65791187176904, 62.14346326622588},
     {4.626589181021943, 4.6199891964555775},
     {239, 83, 80}},
    {{205.65791187176904, 62.14346326622588},
     {201.6302672044138, 15.316354894754497},
     {4.626589181021943, 4.633189165588309},
     {205.91443534275646, 62.12225198463818},
     {4.633189165588309, 4.626589181021943},
     {255, 202, 40}},
    {{205.91443534275646, 62.12225198463818},
     {202.19593434556555, 15.269581299458551},
     {4.633189165588309, 4.639789150154673},
     {206.17109321982377, 62.10273420368633},
     {4.639789150154673, 4.633189165588309},
     {102, 187, 106}},
    {{206.17109321982377, 62.10273420368633},
     {202.761897869355, 15.226542090180118},
     {4.639789150154673, 4.646389134721039},
     {206.4278743230469, 62.084910773557795},
     {4.646389134721039, 4.639789150154673},
     {171, 71, 188}},
    {{206.4278743230469, 62.084910773557795},
     {203.3281331226162, 15.187239141691535},
     {4.646389134721039, 4.652989119287405},
     {206.68476746713378, 62.06878247063473},
     {4.652989119287405, 4.646389134721039},
     {38, 198, 218}},
    {{206.68476746713378, 62.06878247063473},
     {203.89461544034626, 15.151674166015042},
     {4.652989119287405, 4.659589103853769},
     {206.94176146191197, 62.054349997460186},
     {4.659589103853769, 4.652989119287405},
     {255, 110, 64}},
    {{206.94176146191197, 62.054349997460186},
     {204.46132014678022, 15.119848712348102},
     {4.659589103853769, 4.666189088420133},
     {207.19884511281612, 62.041613982707474},
     {4.666189088420133, 4.659589103853769},
     {212, 225, 87}},
    {{207.19884511281617, 62.041613982707474},
     {205.02822255646643, 15.091764166995972},
     {4.6661890884201345, 4.6727890729865},
     {207.45600722137553, 62.03057498115278},
     {4.6727890729865, 4.6661890884201345},
     {189, 189, 189}},
    {{207.45600722137553, 62.03057498115278},
     {205.5952979753409, 15.067421753311265},
     {4.6727890729865, 4.679389057552864},
     {207.71323658570157, 62.02123347365103},
     {4.679389057552864, 4.6727890729865},
     {92, 107, 192}},
    {{207.71323658570157, 62.02123347365103},
     {206.16252170180348, 15.046822531640728},
     {4.679389057552864, 4.685989042119228},
     {207.97052200097633, 62.0135898671149},
     {4.685989042119228, 4.679389057552864},
     {79, 195, 247}},
    {{207.97052200097633, 62.0135898671149},
     {206.72986902779397, 15.029967399279002},
     {4.685989042119228, 4.692589026685594},
     {208.2278522599403, 62.00764449449712},
     {4.692589026685594, 4.685989042119228},
     {255, 167, 38}},
    {{208.2278522599403, 62.00764449449712},
     {207.29731523986834, 15.016857090429554},
     {4.692589026685594, 4.69918901125196},
     {208.4852161533804, 62.003397614775984},
     {4.69918901125196, 4.692589026685594},
     {66, 165, 245}},
    {{208.4852161533804, 62.003397614775984},
     {207.86483562027476, 15.00749217617269},
     {4.69918901125196, 4.705788995818324},
     {208.74260247061855, 62.00084941294403},
     {4.705788995818324, 4.69918901125196},
     {239, 83, 80}},
    {{208.74260247061855, 62.00084941294403},
     {208.43240544803064, 15.001873064440673},
     {4.705788995818324, 4.71238898038469},
     {209, 62},
     {4.71238898038469, 4.705788995818324},
     {255, 202, 40}},
};
void draw(SkCanvas* canvas) {
    SkRect oval1 = {209 - 86, 101 - 86, 209 + 86, 101 + 86};
    SkRect oval2 = {209 - 39, 101 - 39, 209 + 39, 101 + 39};
    for (const auto& wedge : wedges) {
        SkPath path;
        path.moveTo(SkDoubleToScalar(wedge.fMove[0]), SkDoubleToScalar(wedge.fMove[1]));
        path.lineTo(SkDoubleToScalar(wedge.fLine1[0]), SkDoubleToScalar(wedge.fLine1[1]));
        SkASSERT(wedge.fArc1Angles[0] == wedge.fArc2Angles[1]);
        SkASSERT(wedge.fArc1Angles[1] == wedge.fArc2Angles[0]);
        SkScalar start = SkDoubleToScalar(wedge.fArc1Angles[0] * 180.f / SK_ScalarPI);
        SkScalar end = SkDoubleToScalar(wedge.fArc1Angles[1] * 180.f / SK_ScalarPI);
        if (end < start) {
            end += 360;
        }
        path.arcTo(oval1, start, end - start, false);
        path.lineTo(SkDoubleToScalar(wedge.fLine2[0]), SkDoubleToScalar(wedge.fLine2[1]));
        path.arcTo(oval2, end, start - end, false);
        path.close();
        SkPaint paint;
        paint.setAntiAlias(true);
        paint.setARGB(255, wedge.fRGB[0], wedge.fRGB[1], wedge.fRGB[2]);
        canvas->drawPath(path, paint);
    }
}
}  // END FIDDLE
