/*
 * libthai - Thai Language Support Library
 * Copyright (C) 2001  Theppitak Karoonboonyanan <theppitak@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * tis.h - TIS-620 character names
 * Created: 2010-02-24
 */

#ifndef THAI_TIS_H
#define THAI_TIS_H

/**
 * @file   tis.h
 * @brief  TIS-620 character names
 */

#define TIS_KO_KAI		0xa1
#define TIS_KHO_KHAI		0xa2
#define TIS_KHO_KHUAT		0xa3
#define TIS_KHO_KHWAI		0xa4
#define TIS_KHO_KHON		0xa5
#define TIS_KHO_RAKHANG		0xa6
#define TIS_NGO_NGU		0xa7
#define TIS_CHO_CHAN		0xa8
#define TIS_CHO_CHING		0xa9
#define TIS_CHO_CHANG		0xaa
#define TIS_SO_SO		0xab
#define TIS_CHO_CHOE		0xac
#define TIS_YO_YING		0xad
#define TIS_DO_CHADA		0xae
#define TIS_TO_PATAK		0xaf
#define TIS_THO_THAN		0xb0
#define TIS_THO_NANGMONTHO	0xb1
#define TIS_THO_PHUTHAO		0xb2
#define TIS_NO_NEN		0xb3
#define TIS_DO_DEK		0xb4
#define TIS_TO_TAO		0xb5
#define TIS_THO_THUNG		0xb6
#define TIS_THO_THAHAN		0xb7
#define TIS_THO_THONG		0xb8
#define TIS_NO_NU		0xb9
#define TIS_BO_BAIMAI		0xba
#define TIS_PO_PLA		0xbb
#define TIS_PHO_PHUNG		0xbc
#define TIS_FO_FA		0xbd
#define TIS_PHO_PHAN		0xbe
#define TIS_FO_FAN		0xbf
#define TIS_PHO_SAMPHAO		0xc0
#define TIS_MO_MA		0xc1
#define TIS_YO_YAK		0xc2
#define TIS_RO_RUA		0xc3
#define TIS_RU			0xc4
#define TIS_LO_LING		0xc5
#define TIS_LU			0xc6
#define TIS_WO_WAEN		0xc7
#define TIS_SO_SALA		0xc8
#define TIS_SO_RUSI		0xc9
#define TIS_SO_SUA		0xca
#define TIS_HO_HIP		0xcb
#define TIS_LO_CHULA		0xcc
#define TIS_O_ANG		0xcd
#define TIS_HO_NOKHUK		0xce
#define TIS_PAIYANNOI		0xcf
#define TIS_SARA_A		0xd0
#define TIS_MAI_HAN_AKAT	0xd1
#define TIS_SARA_AA		0xd2
#define TIS_SARA_AM		0xd3
#define TIS_SARA_I		0xd4
#define TIS_SARA_II		0xd5
#define TIS_SARA_UE		0xd6
#define TIS_SARA_UEE		0xd7
#define TIS_SARA_U		0xd8
#define TIS_SARA_UU		0xd9
#define TIS_PHINTHU		0xda
#define TIS_SYMBOL_BAHT		0xdf
#define TIS_SARA_E		0xe0
#define TIS_SARA_AE		0xe1
#define TIS_SARA_O		0xe2
#define TIS_SARA_AI_MAIMUAN	0xe3
#define TIS_SARA_AI_MAIMALAI	0xe4
#define TIS_LAKKHANGYAO		0xe5
#define TIS_MAIYAMOK		0xe6
#define TIS_MAITAIKHU		0xe7
#define TIS_MAI_EK		0xe8
#define TIS_MAI_THO		0xe9
#define TIS_MAI_TRI		0xea
#define TIS_MAI_CHATTAWA	0xeb
#define TIS_THANTHAKHAT		0xec
#define TIS_NIKHAHIT		0xed
#define TIS_YAMAKKAN		0xee
#define TIS_FONGMAN		0xef
#define TIS_THAI_DIGIT_ZERO	0xf0
#define TIS_THAI_DIGIT_ONE	0xf1
#define TIS_THAI_DIGIT_TWO	0xf2
#define TIS_THAI_DIGIT_THREE	0xf3
#define TIS_THAI_DIGIT_FOUR	0xf4
#define TIS_THAI_DIGIT_FIVE	0xf5
#define TIS_THAI_DIGIT_SIX	0xf6
#define TIS_THAI_DIGIT_SEVEN	0xf7
#define TIS_THAI_DIGIT_EIGHT	0xf8
#define TIS_THAI_DIGIT_NINE	0xf9
#define TIS_ANGKHANKHU		0xfa
#define TIS_KHOMUT		0xfb

/* For backward compatibility with libthai 0.1.28 and below */
#define TIS_YMBOL_BAHT		0xdf

#endif  /* THAI_TIS_H */


