
;;; file:pao.scm

; (load "~/minlog/init.scm")



(display"
pao.scm is loading the following files

1) ~/minlog/src/thiel.scm
2) pao_pos.scm
3) pao_term.scm
4) pao_smaller.scm
5) pao_equal.scm
6) pao_suc.scm
7) pao_cnf.scm
8) pao_end.scm

At the end you cantest the extracted
ordinal funcions by loading

pao_test.scm

")


(define (oload path) 
  (load
   (string-append minlogpath
		  "/examples/ordinals/" path)))

(mload "thiel.scm")







; Positive Natural Numbers

(display"

The file pao_pos.scm introduces the positive numbers
and proves some basic properties .

")

(oload "pao_pos.scm")


(begin

(display"

The binary relation <

")
(display-program-constants "LESS")
 
;;;;;;;;LESS is linear order ;;;;;;;

(display "

< is strict linear order:

")
(display "pos<pos                                   ")
    (pnt "pos<pos")
(display "pos1<pos2 and pos2<pos1                   ")
    (pnt "pos1<pos2 and pos2<pos1")
(display "(pos1<pos2 and pos2<pos3) → (pos1<pos3)  ")
    (pnt "(pos1<pos2 and pos2<pos3) → (pos1<pos3)")
(display "pos1<pos2 | pos2<pos1 | pos1=pos2         ")
(pnt(ORB "pos1<pos2" "pos2<pos1" "pos1=pos2"))


(display"

S O M E   L O G I C

")

(display-program-constants "AndConst")

)




(display"

The file pao_term introduces the algebra ord.

")


(oload "pao_term.scm")

(begin

(display"

We define the algebra ord of Ordinals
as follows:

O ,   α,β  ->  ω^α + β

So we have:

    O : ø
    1 : OP NULL NULL
    2 : OP NULL (OP NULL NULL)
  n+1 : OP NULL n

   ω  : OP (OP NULL NULL) NULL
  ω+1 : OP (OP NULL NULL) (OP NULL NULL)
1+ω+1 : OP NULL (OP (OP NULL NULL) (OP NULL NULL))
  1+α : OP NULL α

")

(display-program-constants "ω⋆")

(display-program-constants "ω^")

(display-theorems "Comp")
(test-extracted-unary "Comp")


(display "
We define inductively the prediacte FORD⊆ pos@ord
for finite ordinal.

and

extract an embedding of pos -> ord:

")

(deanimate "FO")
(animate-posuposind)
(animate "FO")


(display"

Test of cFO:

")
(display "cFO    1 ")
(pp(nt(pt"cFO 1")))
(display "cFO   16 ")
(pp(nt(pt"cFO 16")))
(deanimate "FO")
(deanimate-posuposind)

)



(display"

The file pao_smaller.scm defines
two binary relations ≺ and ≼ .

")




(oload "pao_smaller.scm")


(begin

(display"

The binary relation ≺

")
(display-program-constants "SMALLER")

(display"

The binary relation ≼

")

(display-program-constants "LE")

 
;;;;;;;;SMALLER is partial order ;;;;;;;

(display "

≺ is strict partial order:

")
(display "ord≺ord                                   ")
    (pnt "ord≺ord")
(display "ord1≺ord2 and ord2≺ord1                   ")
    (pnt "ord1≺ord2 and ord2≺ord1")
(display "(ord1≺ord2 and ord2≺ord3) → (ord1≺ord3)  ")
    (pnt "(ord1≺ord2 and ord2≺ord3) → (ord1≺ord3)")

(display "≼
")
(display "ord≼ord                                   ")
    (pnt "ord≼ord")
(display "(ord1≼ord2 and ord2≼ord3) → (ord1≼ord3)  ")
    (pnt "(ord1≼ord2 and ord2≼ord3) → (ord1≼ord3)")


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

)



(display"

The file pao_equal.scm
defines an equality relation on the ordinal terms

")

(oload "pao_equal.scm")


(begin

(display"

The binary relation ~

")
(display-program-constants "IC")

(display-theorems "ic")
(display-theorems"ICsym")
(display "(ord1~ord2 and ord2~ord3) → ord1~ord3   :  ")
(pnt"(ord1~ord2 and ord2~ord3) → ord1~ord3")
(display "ord1~ord2 | ord1≺ord2 | ord2≺ord1   :  ")
(pnt"ord1~ord2 | ord1≺ord2 | ord2≺ord1")

(test-extracted-binary "SMALLERlinear")
(animate "SMALLERlinear")
(test-extracted-binary "MAX")
(deanimate "SMALLERlinear")

(display "equalsmaller
ord1~ord2 → ((ord3 ≺ ord1) = (ord3 ≺ ord2))   :  ")
(pnt"ord1~ord2 → ((ord3 ≺ ord1) = (ord3 ≺ ord2))")
(display"
equalslarger:
ord1~ord2 → ((ord1 ≺ ord3) = (ord1 ≺ ord3))   :  ")
(pnt "ord1~ord2 → ((ord1 ≺ ord3) = (ord1 ≺ ord3))")

(test-extracted-binary "minusexp")

(display-theorems "minusexp")
(display-theorems "minexp")
(display"
OPfunctional:
(ord1~ord3 and ord2~ord4) → OP ord1 ord2 ~ OP ord3 ord4  :  ")
(pnt "(ord1~ord3 and ord2~ord4) → OP ord1 ord2 ~ OP ord3 ord4")

)


(display"

In the next file we extract

cS    : successor
cPred : extended predecessor
cP    : predecessor
cSORD : successor predicate
")

(oload "pao_suc.scm")

(begin

(test-extracted-unary "S")
(test-extracted-unary "Pred")
(test-extracted-unary "P")
(test-extracted-unary "SORD")

)


(display"

The file pao_cnf.scm defines
normality of a term:

N: ord -> boole

and extracts

cnf   : Cantor-Normal-Form

")


(oload "pao_cnf.scm")


(begin

(display"

Normality of a term
as boolean valued function.
")

(display-program-constants "N")


(display"


There is only one normal term :

(ord1~ord2 and N ord1 and N ord2) → (ord1=ord2)   ")
(pnt "(ord1~ord2 and N ord1 and N ord2) → (ord1=ord2)")

(display"

The height of an ordinal term
ht : ord -> pos
")
(display-program-constants "ht")

(display"


Extracted Cantor-Normal-Form
 
ex ord2.ord1~ord2 and N ord2
")
(animate "Comp")
(test-extracted-unary "nf")
(deanimate "Comp")


(display "

There is a unique term in CNF

ord1 ~ ord2 → cnf ord1 = cnf ord2   ")
(pnt "ord1 ~ ord2 → cnf ord1 = cnf ord2")
)


(oload "pao_end.scm")
