
;;; file pao_suc.scm



(display"

Begin of pao_suc.scm

")



(display"

Extraction of successor function

succ(α,β) :≡  ∀γ (α<β and  (γ≺β → γ≼α))

S: ∀α ∃β succ(α,β)

")

; (hide-output)


(define (succ var1 var2)
  (string-append "all ord." var1 " ≺ " var2 " and ( ord ≺ " var2 " → ord ≼ " var1 ")"))



(set! COMMENT-FLAG #f)


(sg "ex ord2." (succ "ord1" "ord2"))
(time(begin
(ind); on ord1
   (ex-intro (pt"①"))
   (cases)
   (search)
   (search)
(assume "ord11" "ord12" "IH11" "IH12")

; let ord be ord12's successor
(by-assume-with "IH12" "ord" "IH12ord")
(drop "IH11" "IH12")

; OP ord11 ord is successor of OP ord11 ord12
(ex-intro (pt"OP ord11 ord"))

; we have to show the successor properties
(ng #t)
(simp(pf"ord12≺ord"))
(ng #t)
(ind)
   (search)
(assume "ord31" "ord32")
(ng #t)

(cd "ord31 ≺ ord11" "31<11")
(simp(pf "¬(ord11 ≺ ord31)"))
(search)
(use "SMALLERantisym")
(use "31<11")

; ?_19: (ord31≺ord11 -> F) ->...
(assume "31≮11")
(ng #t)
(cd "ord11 ≺ ord31" "11<31")
(ng #t)
(strip 2)
(use-with "IH12ord" (pt"OP ord31 ord32") 'right)
(strip 3)
(ng #t)
(use-with "IH12ord" (pt"ord32") 'right)
(use-with "IH12ord" (pt"ord12") 'left)
))
; Proof finished.

(save "S")
(display-theorems "S")

(add-theorem "S_Soundness"
	     (np(proof-to-soundness-proof 
		 (theorem-name-to-proof "S"))))
(display-theorems "S_Soundness")




(test-extracted-unary "S")



(display"

α ≺ Sα

")

(begin
(animate "S")
(sg "ord ≺ cS ord")
(assume "ord")
(use-with "S_Soundness" (pt"ord")(pt "ord"))

; Proof finished.

(deanimate "S")

(add-rewrite-rule (pt"ord ≺ cS ord")(pt"T"))
(add-rewrite-rule (pt"ord≺(Rec ord=>ord)①([ord0,ord1,ord2]OP ord0)ord")(pt"T"))

)


(display"

Sα ⊀ α

")

(sg"¬(cS ord ≺ ord)")
(begin
(assume "ord")
(use "SMALLERantisym")
(auto)
)
; Proof finished.

(add-rewrite-rule (pt"cS ord ≺ ord")(pt"F"))
(add-rewrite-rule (pt"(Rec ord=>ord)①([ord0,ord1,ord2]OP ord0)ord ≺ ord")(pt"F"))



(display"

Some more RW-rules with cS

")

(begin

(animate "S")

(sg "(OPøord ≺ cS ord)=(ω ≼ ord)")
(ind)
  (ng #t)
  (use "Truth-Axiom")
(assume "ord1" "ord2" "IH1" "IH2")
(ng #t)
(cds "ord1= ø" "1=0")
  (use "IH2")
(assume "1≠0")
(use "Truth-Axiom")

; Proof finished.

(add-rewrite-rule (pt"OPøord ≺ cS ord")(pt "ω ≼ ord"))
(add-rewrite-rule (pt"OPøord ≺ ((Rec ord=>ord)①([ord0,ord1,ord2]OP ord0)ord)")
		  (pt "ω ≼ ord"))



(sg "¬(cS ord ≺ OPøord)")
(auto)

(add-rewrite-rule (pt"cS ord ≺ OPøord")(pt "F"))
(add-rewrite-rule (pt"((Rec ord=>ord)①([ord0,ord1,ord2]OP ord0)ord) ≺ OPøord")
		  (pt "F"))




(sg "(ord~cS(OP ord1 ord2)) = (ord~OP ord1 (cS ord2))")
(auto)

; Proof finished.

(add-rewrite-rule (pt"ord~cS(OP ord1 ord2)")(pt"ord~OP ord1 (cS ord2)"))
(add-rewrite-rule (pt"ord~OP ord1((Rec ord=>ord)①([ord3,ord4,ord5]OP ord3)ord2)")(pt"ord~OP ord1 (cS ord2)"))


(sg "(cS ord1 ≺ OP (OP ord3 ord4) ø)=(ord1 ≺ OP (OP ord3 ord4) ø)")
(ind)
  (auto)
(assume "ord11" "ord12" "IH11" "IH12" "ord3" "ord4")
(ng #t)
(cd "ord11≺OP ord3 ord4" "11<3 4")
(use "IH12")
(search)

; Proof finished.


(add-rewrite-rule (pt"cS ord1 ≺ OP (OP ord3 ord4) ø")(pt"ord1 ≺ OP (OP ord3 ord4) ø"))
(add-rewrite-rule (pt"(Rec ord=>ord)①([ord2,ord3,ord4]OP ord2)ord1 ≺ OP (OP ord3 ord4) ø")
		  (pt"ord1 ≺ OP (OP ord3 ord4) ø"))



(sg "(cS ord ~ OP ø ord) = (ord ≺ ω)")
(ind)
    (search)
(assume "ord1" "ord2" "IH1" "IH2")
(ng #t)
(cds "ord1= ø" "1=0")
(auto)

; Proof finished.

(add-rewrite-rule (pt"cS ord ~ OP ø ord")(pt"ord ≺ ω"))
(add-rewrite-rule (pt"(Rec ord=>ord)①([ord0,ord1,ord2]OP ord0)ord  ~ OP ø  ord")(pt"ord ≺ ω"))

(deanimate "S")

(display"

End of cS RW-rules

")
)



; Thms

(animate "S")

(display "

(Sn=1+n) = (n≺ω)

")

(begin

(sg"(cS ord = OP ø ord) = (ord ≺ ω)")
(ind)
    (search)
(assume "ord1" "ord2" "IH1" "IH2")
(ng #t)
(cds "ord1= ø" "1=0")
(auto)

; Proof finished.

(save "FinSucc")
(display-theorems "FinSucc")
)


(display"

Extraction of
Extended Predecessor THM

∀α ∃β . (α=ωβ) ∨ (α=Sβ)

(takes a while !)
")


(sg "ex ord0. (ord ~ ω⋆ord0)   ∨ ord ~ (cS ord0)")
(time(begin
(ind)

; ord = 0

(ex-intro(pt"ø"))
(ex-intro(pt"F"))
(ng #t)
(search)

; Induction step

; ord = 1
(cases)
(assume "ord2" "IHø" "IH2")
(drop  "IHø")
(cds "ord2= ø" "2=0")
(ex-intro(pt"ø"))
(ex-intro (pt"T"))
(search)
(assume "2≠0")

; ?_17: ex ord0,q.(q=False -> OPøord2~ ω⋆ord0) & (q -> OPøord2~cS ord0)

(cd "ord2≺ ω" "2<ω") ;18 20

; ord = 1+n
(exel "IH2" "ord" "IH2α")
(exel "IH2α" "boole" "IH2αp")
(ca "boole" "p=T")
(ca "(ord2 ~ cS ord)"  "IH2αpr")
(drop "IH2" "IH2α" "IH2αp")
(ex-intro (pt"OP ø ord"))
(ex-intro (pt"T"))
(split)
(use "Efq-Atom")
(search)
(use "IH2αp" 'right)
(use "p=T")
(simp-with "<-" "BooleStab" (pt"boole"))
(use "Atom-False")
(assume "¬boole")
(use "2≠0")
(cut (pf"ord2 ~  ω⋆ord"))
(simp(pf"ord= ø"))
(ng #t)
(simp"BooleStab")
(search)
(cut (pf"ω⋆ord ≺ ω"))
(search)
(cases (pt"ω⋆ord≺ ω"))
  (search)
(assume "w≤w^a")
(simp "<-" (pf"(ω⋆ord ≼ ord2 and ord2≺ ω) → (ω⋆ord≺ ω)"))
(simp "2<ω")
(simp "w≤w^a")
(ng #t)
(use-with (pf"ord2 ≼ ω⋆ord and ω⋆ord ≼ ord2") 'right)
(use "IH2αp")
(use "¬boole")
(use(pf"all ord1,ord2,ord3.(ord1≼ord2 and ord2≺ ord3)→ ord1≺ord3"))
(search)
(use "IH2αp")
(use "¬boole")
(assume "2≮ω")

; ?_54: ex ord0,q.(q=False -> OPøord2~ ω⋆ord0) & (q -> OPøord2~cS ord0)

(ca "OPøord2~ord2" "1+2=2")
(exel "IH2" "ord" "IH2α")
(exel "IH2α" "boole" "IH2αp")
(drop "IH2" "IH2α")
(ex-intro (pt"ord"))
(ex-intro (pt"boole"))
(split)
(assume "b=⊥")
(use "ICtrans" (pt"ord2"))
(use "1+2=2")
(use "IH2αp")
(use "b=⊥")
(assume "b=T")
; ?_71: OPøord2~cS ord from
(use "ICtrans" (pt"ord2"))
(use "1+2=2")
(use "IH2αp")
(use "b=T")
(ng #t)
(simp "2≮ω")
(search)
(assume "ord11" "ord12" "ord2" "IHl" "IHr")
(exel "IHl" "ord3" "IHl3")
(exel "IHl3" "boole3" "IHl3b")
(exel "IHr" "ord4" "IHr4")
(exel "IHr4" "boole4" "IHr4b")
(drop "IHl" "IHr" "IHl3" "IHr4")

; ?_93: ex ord0,q.
;        (q=False -> OP(OP ord11 ord12)ord2~ ω⋆ord0) & 
;        (q -> OP(OP ord11 ord12)ord2~cS ord0)

(cd "(OP ord11 ord12)≺ ω" "l<w")
(cas "ord11= ø" "11=0")
(ca "ord12≺ ω" "12<w")
(ca "¬boole3 -> ord3= ø" "¬3->3=0")
(ca "OPøord12 ~ cS ord12" "ø12=S12")

; ?_109: ex ord0,q.
;        (q=False -> OP(OPøord12)ord2~ ω⋆ord0) & 
;        (q -> OP(OPøord12)ord2~cS ord0)

(cd "boole4" "4")
(ex-intro(pt"OP (OP ø ord12) ord4"))
(ex-intro(pt"boole4"))
(simp "4")
(split)
  (use "Efq-Atom")
(assume "T")
(use "IHr4b")
(use "4")
(assume "¬4")

; ?_120: ex ord0,q.
;         (q=False -> OP(OPøord12)ord2~ ω⋆ord0) & 
;         (q -> OP(OPøord12)ord2~cS ord0)

(ex-intro(pt"OP ord3 ord4"))
(ex-intro(pt"boole4"))
(simp "¬4")
(split)
(assume "FF")
(simp(pf"ω⋆(OP ord3 ord4) = OP (OP ø ord3) (ω⋆ ord4)"))
(cut(pf"ord2~ ω⋆ord4"))
(cut(pf"OPøord12~OPøord3"))
(use-with "OPfunctional" (pt"OPøord12")(pt"OPøord3")(pt"ord2")(pt"ω⋆ord4"))
(cut(pf "OP ord11 ord12 ~ OPøord3"))
(cut(pf "OPøord12~OP ord11 ord12"))
(use-with "ICtrans"  (pt"OPøord12") (pt"OP ord11 ord12") (pt"OPøord3"))
(simp "11=0")
(use "Truth-Axiom")
(cut(pf"cS ord3~OPøord3"))
(cut(pf"OP ord11 ord12~cS ord3"))
(use-with "ICtrans" (pt"OP ord11 ord12") (pt"cS ord3") (pt "OPøord3"))
(use "IHl3b")
(simp-with "<-" "BooleStab" (pt"boole3"))
(use "Atom-False")
(assume "¬3")
(cut(pf "OP ord11 ord12~ ω⋆ord3"))
(simp(pf"ord3= ø"))
(search)
(use "¬3->3=0")
(use "¬3")
(use "IHl3b")
(use "¬3")
(ng #t)
(cd "boole3" "3")
(ng #t)
(simp (pf"ord3≺ ω"))
(use "Truth-Axiom")
(drop "IHr4b")
(use "SMALLERtrans" (pt"OP ord11 ord12"))
(cases(pt"ord3≺OP ord11 ord12"))
  (strip)
  (use "Truth-Axiom")
(assume "(11 12)≤3")
(simp "<-" (pf"(ord3≺cS(ord3) and cS(ord3)≼OP ord11 ord12) → ord3≺OP ord11 ord12"))
(simp"(11 12)≤3")
(ng #t)
(use-with (pf"OP ord11 ord12 ≼ cS ord3 and  cS ord3 ≼ OP ord11 ord12") 'right)
(use "IHl3b" 'right)
(use "3")
(use(pf"all ord1,ord2,ord3.(ord1≺ord2 and ord2≼ ord3)→ ord1≺ord3"))
(strip)
(use "Truth-Axiom")
(use "l<w")
(assume "¬3")
(simp "¬3->3=0")
(use "Truth-Axiom")
(simp "¬3")
(use "Truth-Axiom")
(use "IHr4b")
(simp "¬4")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Efq-Atom")
(ng #t)
(simp "12<w")
(use "Truth-Axiom")
(assume "¬3")
(cut(pf"ω⋆ord3 ≺ ω"))
(ng #t)
(assume "idem")
(use "idem")
(cases(pt"ω⋆ord3≺ ω"))
(strip)
(use "Truth-Axiom")
(assume "w≤w3")
(simp "<-" (pf"(ω⋆ord3 ≼ OP ord11 ord12 and OP ord11 ord12≺ ω) → ω⋆ord3≺ ω"))
(simp "w≤w3")
(simp"l<w")
(ng #t)
(use-with (pf"OP ord11 ord12 ≼ ω⋆ord3 and  ω⋆ord3 ≼ OP ord11 ord12") 'right)
(use "IHl3b")
(use "¬3")
(use(pf"all ord1,ord2,ord3.(ord1≼ord2 and ord2≺ ord3)→ ord1≺ord3"))
(strip)
(use "Truth-Axiom")
(cases(pt"ord12≺ ω"))
(strip)
(use "Truth-Axiom")
(assume "w≤12")
(simp "<-"(pf"(ord12 ≼ OP ord11 ord12 and OP ord11 ord12≺ ω) → ord12≺ ω"))
(simp "w≤12")
(simp "l<w")
(use "Truth-Axiom")
(use(pf"all ord1,ord2,ord3.(ord1≼ord2 and ord2≺ ord3)→ ord1≺ord3"))
(strip)
(use "Truth-Axiom")
(cut(pf"OP ord11 ord12≺ ω"))
(ng #t)
(cases(pt"ord11= ø"))
(strip)
(use "Truth-Axiom")
(strip 1)
(ng #t)
(assume "idem")
(use "idem")
(use "l<w")
(assume "11 12≮w")

; ?_187: ex ord0,q.
;         (q=False -> OP(OP ord11 ord12)ord2~ ω⋆ord0) & 
;         (q -> OP(OP ord11 ord12)ord2~cS ord0)

(ex-intro(pt"OP (OP ord11 ord12) ord4"))
(ex-intro(pt"boole4"))
(cd "boole4" "4")
 (split)
   (use "Efq-Atom")
 (assume "T")
 (search)
(assume "¬4")
(split)
(assume "FF")
(use "ICtrans" (pt"OP(OP ord11 ord12)(ω⋆ord4)"))
(use "OPfunctional")
(use "Truth-Axiom")
(use "IHr4b")
(simp "¬4")
(use "Truth-Axiom")
(use "ICtrans" (pt"OP(OPø(OP ord11 ord12))(ω⋆ord4)"))
(use "OPfunctional")
(cut(pf"OP ord11 ord12≺ ω -> F"))
(ng #t)
(cds "ord11= ø" "11=0")
(ng #t)
(cases(pt"ord12≺ ω"))
(search)
(search)
(ng #t)
(strip)
(use "Truth-Axiom")
(use "11 12≮w")
(use "Truth-Axiom")
(use "Truth-Axiom")
(use "Efq-Atom")
))
; ok, ?_198 is proved.  Proof finished.

(save "Pred")
(display-theorems "Pred")

;(add-theorem "Pred_Soundness"
;	     (np(proof-to-soundness-proof 
;		 (theorem-name-to-proof "Pred"))))
;(display-theorems "Pred_Soundness")


(test-extracted-unary "Pred")


(display"

Extraction of Predecessor function cP
and predicate SORD(α) from

THM: (∀ξ<α) (cS(ξ)<α)  ∨  (∃ξ<β) (α=cS(ξ))

")


(animate "Comp")

(time(begin

(sg "all ord. (all ord0. ord0≺ord→cS(ord0) ≺ ord) ∨ (ex ord0.ord0≺ord and ord= cS ord0)")
(ind)
  (ex-intro(pt"F"))
  (ng #t)
  (split)
  (search)
  (assume "F")
  (ex-intro (pt"ø"))
  (use "F")
(assume "ord1" "ord2" "IH1" "IH2")
(exel "IH2" "boole" "IH2p")
(cd "boole" "p=T")
(ex-intro (pt"T"))
(ex-elim (pf"ex ord0 ord0≺ord2 and ord2=cS ord0"))
(use "IH2p")
(use "p=T")
(assume "ord3" "IH2pT3")
(drop  "IH1" "IH2" "IH2p")
(ng #t)
(split)
  (assume "F" "ord0")
  (use "Efq-Atom")
  (use "F")
(assume "T")
(ex-intro(pt"OP ord1 ord3"))
(use "IH2pT3")

(assume "¬p")
(ca "all ord0.ord0≺ord2 → cS ord0≺ord2" "IH2pF")
(drop  "IH1" "IH2" "IH2p")
(cds "ord2= ø" "2=0")
(cds "ord1= ø" "1=0")
(ex-intro(pt"T"))
(ng #t)
(split)
  (assume "F" "ord0")
  (use "Efq-Atom")
  (use "F")
(assume "T")
(ex-intro(pt"ø"))
(use "T")
(assume "1≠0")
(ex-intro(pt"F"))
(ng #t)
(split)
  (assume "T")
  (cases)
  (ng #t)
  (simp "1≠0")
  (use "Truth-Axiom")
  (assume "ord3" "ord4")
  (ng #t)
  (cd "ord3≺ord1" "3<1")
  (simp (pf"ord1= OP left(right(cComp ord1)) right(right(cComp ord1))"))
  (use "Truth-Axiom")
  (use "NonZeroConstructed")
  (simp "1≠0")
  (use "Truth-Axiom")
  (assume "3≮1")
  (use "Truth-Axiom")
(assume "F")
(ex-intro(pt"OP ord1ø"))
(use "Efq-Atom")
(use "F")

(assume "2≠0")
(ex-intro(pt"F"))
(ng #t)
(split)
  (assume "T")
  (ind)
     (ng #t)
     (simp "2≠0")
     (use "Truth-Axiom")
  (assume "ord3" "ord4" "IH3" "IH4")
  (ng #t)
  (cd "ord3≺ord1" "3<1")
    (use "IH4")
  (ng #t)
  (assume "3≮1")
  (cd "ord1≺ord3" "1<3")
    (ng #t)
    (use-with "IH2pF" (pt"OP ord3 ord4"))
  (assume "1≮3")
    (use-with "IH2pF" (pt"ord4"))
(assume "F")
(ex-intro(pt"OP ord1 ord2"))
(use "Efq-Atom")
(use "F")

(use "IH2p")
(simp "¬p")
(use "Truth-Axiom")

; Proof finished.

(save "P")
(display-theorems "P")

))


(test-extracted-unary "P")



(display"

Extraction of predicate SORD(α) from

THM: (∀ξ<α) (cS(ξ)<α)  ∨  (∃nc ξ<β) (α=cS(ξ))

")

(time(begin

(sg "all ord. (all ord0. ord0≺ord→cS(ord0) ≺ ord) ∨ (exnc ord0.ord0≺ord and ord= cS ord0)")
(ind)
  (ex-intro(pt"F"))
  (ng #t)
  (split)
  (search)
  (assume "F")
  (exnc-intro (pt"ø"))
  (use "F")
(assume "ord1" "ord2" "IH1" "IH2")
(exel "IH2" "boole" "IH2p")
(cd "boole" "p=T")
(ex-intro (pt"T"))
(exnc-elim (pf"exnc ord0 ord0≺ord2 and ord2=cS ord0"))
(use "IH2p")
(use "p=T")
(assume "ord3" "IH2pT3")
(drop  "IH1" "IH2" "IH2p")
(ng #t)
(split)
  (assume "F" "ord0")
  (use "Efq-Atom")
  (use "F")
(assume "T")
(exnc-intro(pt"OP ord1 ord3"))
(use "IH2pT3")


(assume "¬p")
(ca "all ord0.ord0≺ord2 → cS ord0≺ord2" "IH2pF")
(drop  "IH1" "IH2" "IH2p")
(cds "ord2= ø" "2=0")
(cds "ord1= ø" "1=0")
(ex-intro(pt"T"))
(ng #t)
(split)
  (assume "F" "ord0")
  (use "Efq-Atom")
  (use "F")
(assume "T")
(exnc-intro(pt"ø"))
(use "T")
(assume "1≠0")
(ex-intro(pt"F"))
(ng #t)
(split)
  (assume "T")
  (cases)
  (ng #t)
  (simp "1≠0")
  (use "Truth-Axiom")
  (assume "ord3" "ord4")
  (ng #t)
  (cd "ord3≺ord1" "3<1")
  (simp (pf"ord1= OP left(right(cComp ord1)) right(right(cComp ord1))"))
  (use "Truth-Axiom")
  (use "NonZeroConstructed")
  (simp "1≠0")
  (use "Truth-Axiom")
  (assume "3≮1")
  (use "Truth-Axiom")
(assume "F")
(exnc-intro(pt"OP ord1ø"))
(use "Efq-Atom")
(use "F")

(assume "2≠0")
(ex-intro(pt"F"))
(ng #t)
(split)
  (assume "T")
  (ind)
     (ng #t)
     (simp "2≠0")
     (use "Truth-Axiom")
  (assume "ord3" "ord4" "IH3" "IH4")
  (ng #t)
  (cd "ord3≺ord1" "3<1")
    (use "IH4")
  (ng #t)
  (assume "3≮1")
  (cd "ord1≺ord3" "1<3")
    (ng #t)
    (use-with "IH2pF" (pt"OP ord3 ord4"))
  (assume "1≮3")
    (use-with "IH2pF" (pt"ord4"))
(assume "F")
(exnc-intro(pt"OP ord1 ord2"))
(use "Efq-Atom")
(use "F")

(use "IH2p")
(simp "¬p")
(use "Truth-Axiom")

; Proof finished.

(save "SORD")
(display-theorems "SORD")

))

(deanimate "S")
(deanimate "Comp")

(test-extracted-unary "SORD")




(begin
  (deanimate "Pred")
  (deanimate "P")
  (deanimate "SORD")
  (animate "Pred")
  (animate "P")
  (animate "SORD")
  (display "


 Comparing cPred ,  cP  and cSord :

")
  (display "\n Successor Ordinal ω₇+15:\n")
  (display "\n cPred (OP ω₇ ⑮)\t= ")
  (time(pnt "cPred (OP ω₇ ⑮)"))
  (display "\n cP (OP ω₇ ⑮)\t\t= ")
  (time(pnt "cP (OP ω₇ ⑮)"))
  (display "\n cSORD (OP ω₇ ⑮)\t= ")
  (time(pnt "cSORD (OP ω₇ ⑮)"))
  (display "
Limit Ordinal ω₇+ω⁸:
")
  (display "\n cPred (OP ω₇ ω⁸)\t= ")
  (time(pnt "cPred (OP ω₇ ω⁸)"))
  (display "\n cP (OP ω₇ ω⁸)\t\t= ")
  (time(pnt "cP (OP ω₇ ω⁸)"))
  (display "\n cSORD (OP ω₇ ω⁸)\t= ")
  (time(pnt "cSORD (OP ω₇ ω⁸)"))
  (display"\n\n")
  (deanimate "Pred")
  (deanimate "P")
)


; (show-output)



(set! COMMENT-FLAG #t)


(display "

End of pao_suc.scm
")



;EOF
