// Copyright 2023 Google Inc. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-initializenumberformat
description: >
    Tests that the options maximumFractionDigits limit to the range 0 - 100.
info: |
    InitializeNumberFormat ( numberFormat, locales, options )

    25.a.ii. Set mxfd to ? DefaultNumberOption(mxfd, 0, 100, undefined).

    DefaultNumberOption ( value, minimum, maximum, fallback )

    3. If value is NaN or less than minimum or greater than maximum, throw a RangeError exception.
---*/

let wontThrow = new Intl.NumberFormat(undefined, {maximumFractionDigits: 0});

assert.throws(RangeError, function () {
        return new Intl.NumberFormat(undefined, {maximumFractionDigits: -1});
}, "Throws RangeError when maximumFractionDigits is less than 0.");

reportCompare(0, 0);
