# Phoenix common environment variables

## CAUTION: Do NOT source this directly!
## Source 'env.sh' instead.

## Additionally, if you need to override any variables here, export them to your shell manually or use `env_override.sh`.
## Do NOT edit this file directly.

# If variables are defined with a custom `env_override.sh` file (located at the root project directory), let's use those
## These need to be set first, to ensure that they don't interfere with certain variables
PHOENIX_ENV_OVERRIDE="${PHOENIX_ROOT}/env_override.sh"
if [[ -f "${PHOENIX_ENV_OVERRIDE}" ]]; then
    source "${PHOENIX_ENV_OVERRIDE}"
fi

# Phoenix

# Archives directory
export PHOENIX_ARCHIVES="${PHOENIX_ROOT}/archives"

# Build directory
export PHOENIX_BUILD="${PHOENIX_ROOT}/build"

# Directory for unused/extra files
export PHOENIX_UNUSED="${PHOENIX_ROOT}/unused"

# Temporary build directory
export PHOENIX_TEMP="${PHOENIX_BUILD}/tmp"

# Android directory
export PHOENIX_ANDROID_DIR="${PHOENIX_ROOT}/android"

# Linux directory
export PHOENIX_LINUX_DIR="${PHOENIX_ROOT}/linux"

## Linux (Flatpak) directory
export PHOENIX_LINUX_FLATPAK_DIR="${PHOENIX_ROOT}/linux-flatpak"

# OS X directory
export PHOENIX_OSX_DIR="${PHOENIX_ROOT}/macos"

## OS X (Intel) directory
export PHOENIX_OSX_INTEL_DIR="${PHOENIX_ROOT}/macos-intel"

# Windows directory
export PHOENIX_WINDOWS_DIR="${PHOENIX_ROOT}/windows"

# Set our platform, OS, and architecture
export PHOENIX_ENV_HELPERS="${PHOENIX_BUILD}/env_helpers.sh"
source "${PHOENIX_ENV_HELPERS}"

# Version info
export PHOENIX_VERSIONS="${PHOENIX_BUILD}/versions.sh"

# Should we create a build log file? (Default)
PHOENIX_LOG_BUILD_DEFAULT=1
if [[ -z "${PHOENIX_LOG_BUILD+x}" ]]; then
    export PHOENIX_LOG_BUILD="${PHOENIX_LOG_BUILD_DEFAULT}"
fi

# Directory where we should store log files (if logging is desired)
PHOENIX_LOG_DIR_DEFAULT="${PHOENIX_BUILD}/logs"
if [[ -z "${PHOENIX_LOG_DIR+x}" ]]; then
    export PHOENIX_LOG_DIR="${PHOENIX_LOG_DIR_DEFAULT}"
fi

# GNU sed
if [[ "${PHOENIX_OS}" == 'osx' ]]; then
    PHOENIX_SED_DEFAULT='gsed'
else
    PHOENIX_SED_DEFAULT='sed'
fi
if [[ -z "${PHOENIX_SED+x}" ]]; then
    export PHOENIX_SED="${PHOENIX_SED_DEFAULT}"
fi

# GNU tar
if [[ "${PHOENIX_OS}" == 'osx' ]]; then
    PHOENIX_TAR_DEFAULT='gtar'
else
    PHOENIX_TAR_DEFAULT='tar'
fi
if [[ -z "${PHOENIX_TAR+x}" ]]; then
    export PHOENIX_TAR="${PHOENIX_TAR_DEFAULT}"
fi

# Whether we're ONLY building Phoenix for Android
PHOENIX_ANDROID_ONLY_DEFAULT=0
if [[ -z "${PHOENIX_ANDROID_ONLY+x}" ]]; then
    export PHOENIX_ANDROID_ONLY="${PHOENIX_ANDROID_ONLY_DEFAULT}"
fi
if [ "${PHOENIX_ANDROID_ONLY}" == 1 ]; then
    export PHOENIX_ANDROID=1
    export PHOENIX_LINUX=0
    export PHOENIX_LINUX_FLATPAK=0
    export PHOENIX_OSX=0
    export PHOENIX_OSX_INTEL=0
    export PHOENIX_WINDOWS=0

    # Android doesn't want or need specialized configs
    export PHOENIX_SPECS=0
fi

# Whether we're ONLY building Phoenix for Linux
PHOENIX_LINUX_ONLY_DEFAULT=0
if [[ -z "${PHOENIX_LINUX_ONLY+x}" ]]; then
    export PHOENIX_LINUX_ONLY="${PHOENIX_LINUX_ONLY_DEFAULT}"
fi
if [ "${PHOENIX_LINUX_ONLY}" == 1 ]; then
    export PHOENIX_LINUX=1
    export PHOENIX_ANDROID=0
    export PHOENIX_LINUX_FLATPAK=0
    export PHOENIX_OSX=0
    export PHOENIX_OSX_INTEL=0
    export PHOENIX_WINDOWS=0
fi

# Whether we're ONLY building Phoenix for Linux (Flatpak)
PHOENIX_LINUX_FLATPAK_ONLY_DEFAULT=0
if [[ -z "${PHOENIX_LINUX_FLATPAK_ONLY+x}" ]]; then
    export PHOENIX_LINUX_FLATPAK_ONLY="${PHOENIX_LINUX_FLATPAK_ONLY_DEFAULT}"
fi
if [ "${PHOENIX_LINUX_FLATPAK_ONLY}" == 1 ]; then
    export PHOENIX_LINUX_FLATPAK=1
    export PHOENIX_ANDROID=0
    export PHOENIX_LINUX=0
    export PHOENIX_OSX=0
    export PHOENIX_OSX_INTEL=0
    export PHOENIX_WINDOWS=0
fi

# Whether we're ONLY building Phoenix for OS X
PHOENIX_OSX_ONLY_DEFAULT=0
if [[ -z "${PHOENIX_OSX_ONLY+x}" ]]; then
    export PHOENIX_OSX_ONLY="${PHOENIX_OSX_ONLY_DEFAULT}"
fi
if [ "${PHOENIX_OSX_ONLY}" == 1 ]; then
    export PHOENIX_OSX=1
    export PHOENIX_ANDROID=0
    export PHOENIX_LINUX=0
    export PHOENIX_LINUX_FLATPAK=0
    export PHOENIX_OSX_INTEL=0
    export PHOENIX_WINDOWS=0
fi

# Whether we're ONLY building Phoenix for OS X (Intel)
PHOENIX_OSX_INTEL_ONLY_DEFAULT=0
if [[ -z "${PHOENIX_OSX_INTEL_ONLY+x}" ]]; then
    export PHOENIX_OSX_INTEL_ONLY="${PHOENIX_OSX_INTEL_ONLY_DEFAULT}"
fi
if [ "${PHOENIX_OSX_INTEL_ONLY}" == 1 ]; then
    export PHOENIX_OSX_INTEL=1
    export PHOENIX_ANDROID=0
    export PHOENIX_LINUX=0
    export PHOENIX_LINUX_FLATPAK=0
    export PHOENIX_OSX=0
    export PHOENIX_WINDOWS=0
fi

# Whether we're ONLY building Phoenix for Windows
PHOENIX_WINDOWS_ONLY_DEFAULT=0
if [[ -z "${PHOENIX_WINDOWS_ONLY+x}" ]]; then
    export PHOENIX_WINDOWS_ONLY="${PHOENIX_WINDOWS_ONLY_DEFAULT}"
fi
if [ "${PHOENIX_WINDOWS_ONLY}" == 1 ]; then
    export PHOENIX_WINDOWS=1
    export PHOENIX_ANDROID=0
    export PHOENIX_LINUX=0
    export PHOENIX_LINUX_FLATPAK=0
    export PHOENIX_OSX=0
    export PHOENIX_OSX_INTEL=0
fi

# Whether we're building Phoenix for Android (Default)
PHOENIX_ANDROID_DEFAULT=1
if [[ -z "${PHOENIX_ANDROID+x}" ]]; then
    export PHOENIX_ANDROID="${PHOENIX_ANDROID_DEFAULT}"
fi

# Whether we're building Phoenix for Linux (Default)
PHOENIX_LINUX_DEFAULT=1
if [[ -z "${PHOENIX_LINUX+x}" ]]; then
    export PHOENIX_LINUX="${PHOENIX_LINUX_DEFAULT}"
fi

# Whether we're building Phoenix for Linux (Flatpak) (Default)
PHOENIX_LINUX_FLATPAK_DEFAULT=1
if [[ -z "${PHOENIX_LINUX_FLATPAK+x}" ]]; then
    export PHOENIX_LINUX_FLATPAK="${PHOENIX_LINUX_FLATPAK_DEFAULT}"
fi

# Whether we're building Phoenix for OS X (Default)
PHOENIX_OSX_DEFAULT=1
if [[ -z "${PHOENIX_OSX+x}" ]]; then
    export PHOENIX_OSX="${PHOENIX_OSX_DEFAULT}"
fi

# Whether we're building Phoenix for OS X (Intel) (Default)
PHOENIX_OSX_INTEL_DEFAULT=1
if [[ -z "${PHOENIX_OSX_INTEL+x}" ]]; then
    export PHOENIX_OSX_INTEL="${PHOENIX_OSX_INTEL_DEFAULT}"
fi

# Whether we're building Phoenix for Windows (Default)
PHOENIX_WINDOWS_DEFAULT=1
if [[ -z "${PHOENIX_WINDOWS+x}" ]]; then
    export PHOENIX_WINDOWS="${PHOENIX_WINDOWS_DEFAULT}"
fi

# Whether we should exclude "NO-MAIL" preferences when building Phoenix
## (ex. for Dove)
PHOENIX_MAIL_DEFAULT=0
if [[ -z "${PHOENIX_MAIL+x}" ]]; then
    export PHOENIX_MAIL="${PHOENIX_MAIL_DEFAULT}"
fi

# Whether we should ONLY build Phoenix standard
PHOENIX_STANDARD_ONLY_DEFAULT=0
if [[ -z "${PHOENIX_STANDARD_ONLY+x}" ]]; then
    export PHOENIX_STANDARD_ONLY="${PHOENIX_STANDARD_ONLY_DEFAULT}"
fi
if [ "${PHOENIX_STANDARD_ONLY}" == 1 ]; then
    export PHOENIX_STANDARD=1
    export PHOENIX_EXTENDED=0
fi

# Whether we should ONLY build Phoenix extended
PHOENIX_EXTENDED_ONLY_DEFAULT=0
if [ "${PHOENIX_MAIL}" == 1 ]; then
    # Mail only wants/needs extended
    export PHOENIX_EXTENDED_ONLY=1
elif [[ -z "${PHOENIX_EXTENDED_ONLY+x}" ]]; then
    export PHOENIX_EXTENDED_ONLY="${PHOENIX_EXTENDED_ONLY_DEFAULT}"
fi
if [ "${PHOENIX_EXTENDED_ONLY}" == 1 ]; then
    export PHOENIX_EXTENDED=1
    export PHOENIX_STANDARD=0
fi

# Whether we should build Phoenix standard (Default)
PHOENIX_STANDARD_DEFAULT=1
if [[ -z "${PHOENIX_STANDARD+x}" ]]; then
    export PHOENIX_STANDARD="${PHOENIX_STANDARD_DEFAULT}"
fi

# Whether we should build Phoenix extended (Default)
PHOENIX_EXTENDED_DEFAULT=1
if [[ -z "${PHOENIX_EXTENDED+x}" ]]; then
    export PHOENIX_EXTENDED="${PHOENIX_EXTENDED_DEFAULT}"
fi

# Whether we should build Phoenix's specialized configs (Default)
PHOENIX_SPECS_DEFAULT=1
if [ "${PHOENIX_MAIL}" == 1 ]; then
    # Mail never wants or need specialized configs
    export PHOENIX_SPECS=0
elif [[ -z "${PHOENIX_SPECS+x}" ]]; then
    export PHOENIX_SPECS="${PHOENIX_SPECS_DEFAULT}"
fi

# Whether we should append contents of an additional .cfg file
## Meant for downstream projects (ex. Dove, IronFox, LibreWolf) to simplify the process of overriding/setting additional preferences
PHOENIX_EXTRA_CFG_DEFAULT=0
if [[ -z "${PHOENIX_EXTRA_CFG+x}" ]]; then
    export PHOENIX_EXTRA_CFG="${PHOENIX_EXTRA_CFG_DEFAULT}"
fi

## This points to the location of the .cfg file that we should append the contents of
PHOENIX_EXTRA_CFG_FILE_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_CFG}" != 1 ] || [ -z "${PHOENIX_EXTRA_CFG_FILE+x}" ]; then
    export PHOENIX_EXTRA_CFG_FILE="${PHOENIX_EXTRA_CFG_FILE_DEFAULT}"
elif [[ -f "${PHOENIX_EXTRA_CFG_FILE+x}" ]]; then
    export PHOENIX_EXTRA_CFG_FILE="${PHOENIX_EXTRA_CFG_FILE}"
fi

## This points to the directory where we should put our (final) output files
PHOENIX_EXTRA_CFG_OUTPUT_DIR_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_CFG}" != 1 ] || [ -z "${PHOENIX_EXTRA_CFG_OUTPUT_DIR+x}" ]; then
    export PHOENIX_EXTRA_CFG_OUTPUT_DIR="${PHOENIX_EXTRA_CFG_OUTPUT_DIR_DEFAULT}"
elif [[ -d "${PHOENIX_EXTRA_CFG_OUTPUT_DIR+x}" ]]; then
    export PHOENIX_EXTRA_CFG_OUTPUT_DIR="${PHOENIX_EXTRA_CFG_OUTPUT_DIR}"
fi

# Whether we should append contents of an additional .js prefs file
## Meant for downstream projects (ex. Dove, IronFox, LibreWolf) to simplify the process of overriding/setting additional preferences
PHOENIX_EXTRA_PREFS_JS_DEFAULT=0
if [[ -z "${PHOENIX_EXTRA_PREFS_JS+x}" ]]; then
    export PHOENIX_EXTRA_PREFS_JS="${PHOENIX_EXTRA_PREFS_JS_DEFAULT}"
fi

## This points to the location of the .cfg file that we should append the contents of
PHOENIX_EXTRA_PREFS_JS_FILE_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_PREFS_JS}" != 1 ] || [ -z "${PHOENIX_EXTRA_PREFS_JS_FILE+x}" ]; then
    export PHOENIX_EXTRA_PREFS_JS_FILE="${PHOENIX_EXTRA_PREFS_JS_FILE_DEFAULT}"
elif [[ -f "${PHOENIX_EXTRA_PREFS_JS_FILE+x}" ]]; then
    export PHOENIX_EXTRA_PREFS_JS_FILE="${PHOENIX_EXTRA_PREFS_JS_FILE}"
fi

## This points to the directory where we should put our (final) output files
PHOENIX_EXTRA_PREFS_JS_OUTPUT_DIR_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_PREFS_JS}" != 1 ] || [ -z "${PHOENIX_EXTRA_PREFS_JS_OUTPUT_DIR+x}" ]; then
    export PHOENIX_EXTRA_PREFS_JS_OUTPUT_DIR="${PHOENIX_EXTRA_PREFS_JS_OUTPUT_DIR_DEFAULT}"
elif [[ -d "${PHOENIX_EXTRA_PREFS_JS_OUTPUT_DIR+x}" ]]; then
    export PHOENIX_EXTRA_PREFS_JS_OUTPUT_DIR="${PHOENIX_EXTRA_PREFS_JS_OUTPUT_DIR}"
fi

## What should we name our output files?
PHOENIX_EXTRA_OUTPUT_FILENAME_DEFAULT='phoenix'
if [[ -z "${PHOENIX_EXTRA_OUTPUT_FILENAME+x}" ]]; then
    export PHOENIX_EXTRA_OUTPUT_FILENAME="${PHOENIX_EXTRA_OUTPUT_FILENAME_DEFAULT}"
fi
PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_DEFAULT='phoenix-extended'
if [[ -z "${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME+x}" ]]; then
    export PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME="${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_DEFAULT}"
fi

## What should we name our Android output files?
PHOENIX_EXTRA_OUTPUT_FILENAME_ANDROID_DEFAULT="${PHOENIX_EXTRA_OUTPUT_FILENAME}-android"
if [[ -z "${PHOENIX_EXTRA_OUTPUT_FILENAME_ANDROID+x}" ]]; then
    export PHOENIX_EXTRA_OUTPUT_FILENAME_ANDROID="${PHOENIX_EXTRA_OUTPUT_FILENAME_ANDROID_DEFAULT}"
fi
PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_ANDROID_DEFAULT="${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME}-android"
if [[ -z "${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_ANDROID+x}" ]]; then
    export PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_ANDROID="${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_ANDROID_DEFAULT}"
fi

## What should we name our Linux output files?
PHOENIX_EXTRA_OUTPUT_FILENAME_LINUX_DEFAULT="${PHOENIX_EXTRA_OUTPUT_FILENAME}-linux"
if [[ -z "${PHOENIX_EXTRA_OUTPUT_FILENAME_LINUX+x}" ]]; then
    export PHOENIX_EXTRA_OUTPUT_FILENAME_LINUX="${PHOENIX_EXTRA_OUTPUT_FILENAME_LINUX_DEFAULT}"
fi
PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_LINUX_DEFAULT="${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME}-linux"
if [[ -z "${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_LINUX+x}" ]]; then
    export PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_LINUX="${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_LINUX_DEFAULT}"
fi

## What should we name our Linux (Flatpak) output files?
PHOENIX_EXTRA_OUTPUT_FILENAME_LINUX_FLATPAK_DEFAULT="${PHOENIX_EXTRA_OUTPUT_FILENAME}-linux-flatpak"
if [[ -z "${PHOENIX_EXTRA_OUTPUT_FILENAME_LINUX_FLATPAK+x}" ]]; then
    export PHOENIX_EXTRA_OUTPUT_FILENAME_LINUX_FLATPAK="${PHOENIX_EXTRA_OUTPUT_FILENAME_LINUX_FLATPAK_DEFAULT}"
fi
PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_LINUX_FLATPAK_DEFAULT="${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME}-linux-flatpak"
if [[ -z "${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_LINUX_FLATPAK+x}" ]]; then
    export PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_LINUX_FLATPAK="${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_LINUX_FLATPAK_DEFAULT}"
fi

## What should we name our OS X output files?
PHOENIX_EXTRA_OUTPUT_FILENAME_OSX_DEFAULT="${PHOENIX_EXTRA_OUTPUT_FILENAME}-osx"
if [[ -z "${PHOENIX_EXTRA_OUTPUT_FILENAME_OSX+x}" ]]; then
    export PHOENIX_EXTRA_OUTPUT_FILENAME_OSX="${PHOENIX_EXTRA_OUTPUT_FILENAME_OSX_DEFAULT}"
fi
PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_OSX_DEFAULT="${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME}-osx"
if [[ -z "${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_OSX+x}" ]]; then
    export PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_OSX="${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_OSX_DEFAULT}"
fi

## What should we name our OS X (Intel) output files?
PHOENIX_EXTRA_OUTPUT_FILENAME_OSX_INTEL_DEFAULT="${PHOENIX_EXTRA_OUTPUT_FILENAME}-osx-intel"
if [[ -z "${PHOENIX_EXTRA_OUTPUT_FILENAME_OSX_INTEL+x}" ]]; then
    export PHOENIX_EXTRA_OUTPUT_FILENAME_OSX_INTEL="${PHOENIX_EXTRA_OUTPUT_FILENAME_OSX_INTEL_DEFAULT}"
fi
PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_OSX_INTEL_DEFAULT="${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME}-osx-intel"
if [[ -z "${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_OSX_INTEL+x}" ]]; then
    export PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_OSX_INTEL="${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_OSX_INTEL_DEFAULT}"
fi

## What should we name our Windows output files?
PHOENIX_EXTRA_OUTPUT_FILENAME_WINDOWS_DEFAULT="${PHOENIX_EXTRA_OUTPUT_FILENAME}-windows"
if [[ -z "${PHOENIX_EXTRA_OUTPUT_FILENAME_WINDOWS+x}" ]]; then
    export PHOENIX_EXTRA_OUTPUT_FILENAME_WINDOWS="${PHOENIX_EXTRA_OUTPUT_FILENAME_WINDOWS_DEFAULT}"
fi
PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_WINDOWS_DEFAULT="${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME}-windows"
if [[ -z "${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_WINDOWS+x}" ]]; then
    export PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_WINDOWS="${PHOENIX_EXTRA_EXTENDED_OUTPUT_FILENAME_WINDOWS_DEFAULT}"
fi

# Whether we should append contents of an additional policies.json file
## Meant for downstream projects (ex. Dove, IronFox, LibreWolf) to simplify the process of overriding/setting additional policies
PHOENIX_EXTRA_POLICIES_DEFAULT=0
if [[ -z "${PHOENIX_EXTRA_POLICIES+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES="${PHOENIX_EXTRA_POLICIES_DEFAULT}"
fi

## This points to the location of the policies.json file that we should append the contents of
PHOENIX_EXTRA_POLICIES_FILE_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_POLICIES}" != 1 ] || [ -z "${PHOENIX_EXTRA_POLICIES_FILE+x}" ]; then
    export PHOENIX_EXTRA_POLICIES_FILE="${PHOENIX_EXTRA_POLICIES_FILE_DEFAULT}"
elif [[ -f "${PHOENIX_EXTRA_POLICIES_FILE+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_FILE="${PHOENIX_EXTRA_POLICIES_FILE}"
fi

# Whether we should append contents of an additional policies.json file for Android only
PHOENIX_EXTRA_POLICIES_ANDROID_DEFAULT=0
if [[ -z "${PHOENIX_EXTRA_POLICIES_ANDROID+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_ANDROID="${PHOENIX_EXTRA_POLICIES_ANDROID_DEFAULT}"
fi

## This points to the location of the policies.json file that we should append the contents of
PHOENIX_EXTRA_POLICIES_FILE_ANDROID_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_POLICIES_ANDROID}" != 1 ] || [ -z "${PHOENIX_EXTRA_POLICIES_FILE_ANDROID+x}" ]; then
    export PHOENIX_EXTRA_POLICIES_FILE_ANDROID="${PHOENIX_EXTRA_POLICIES_FILE_ANDROID_DEFAULT}"
elif [[ -f "${PHOENIX_EXTRA_POLICIES_FILE_ANDROID+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_FILE_ANDROID="${PHOENIX_EXTRA_POLICIES_FILE_ANDROID}"
fi

## This points to the directory where we should put our (final) output files
PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_ANDROID_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_POLICIES_ANDROID}" != 1 ] || [ -z "${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_ANDROID+x}" ]; then
    export PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_ANDROID="${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_ANDROID_DEFAULT}"
elif [[ -d "${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_ANDROID+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_ANDROID="${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_ANDROID}"
fi

# Whether we should append contents of an additional policies.json file for Linux only
PHOENIX_EXTRA_POLICIES_LINUX_DEFAULT=0
if [[ -z "${PHOENIX_EXTRA_POLICIES_LINUX+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_LINUX="${PHOENIX_EXTRA_POLICIES_LINUX_DEFAULT}"
fi

## This points to the location of the policies.json file that we should append the contents of
PHOENIX_EXTRA_POLICIES_FILE_LINUX_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_POLICIES_LINUX}" != 1 ] || [ -z "${PHOENIX_EXTRA_POLICIES_FILE_LINUX+x}" ]; then
    export PHOENIX_EXTRA_POLICIES_FILE_LINUX="${PHOENIX_EXTRA_POLICIES_FILE_LINUX_DEFAULT}"
elif [[ -f "${PHOENIX_EXTRA_POLICIES_FILE_LINUX+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_FILE_LINUX="${PHOENIX_EXTRA_POLICIES_FILE_LINUX}"
fi

# Whether we should append contents of an additional policies.json file for Linux (non-Flatpak) only
PHOENIX_EXTRA_POLICIES_LINUX_NONFLATPAK_DEFAULT=0
if [[ -z "${PHOENIX_EXTRA_POLICIES_LINUX_NONFLATPAK+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_LINUX_NONFLATPAK="${PHOENIX_EXTRA_POLICIES_LINUX_NONFLATPAK_DEFAULT}"
fi

## This points to the location of the policies.json file that we should append the contents of
PHOENIX_EXTRA_POLICIES_FILE_LINUX_NONFLATPAK_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_POLICIES_LINUX_NONFLATPAK}" != 1 ] || [ -z "${PHOENIX_EXTRA_POLICIES_FILE_LINUX_NONFLATPAK+x}" ]; then
    export PHOENIX_EXTRA_POLICIES_FILE_LINUX_NONFLATPAK="${PHOENIX_EXTRA_POLICIES_FILE_LINUX_NONFLATPAK_DEFAULT}"
elif [[ -f "${PHOENIX_EXTRA_POLICIES_FILE_LINUX_NONFLATPAK+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_FILE_LINUX_NONFLATPAK="${PHOENIX_EXTRA_POLICIES_FILE_LINUX_NONFLATPAK}"
fi

## This points to the directory where we should put our (final) output files
PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_LINUX_NONFLATPAK_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_POLICIES_LINUX_NONFLATPAK}" != 1 ] || [ -z "${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_LINUX_NONFLATPAK+x}" ]; then
    export PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_LINUX_NONFLATPAK="${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_LINUX_NONFLATPAK_DEFAULT}"
elif [[ -d "${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_LINUX_NONFLATPAK+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_LINUX_NONFLATPAK="${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_LINUX_NONFLATPAK}"
fi

# Whether we should append contents of an additional policies.json file for Linux (Flatpak) only
PHOENIX_EXTRA_POLICIES_LINUX_FLATPAK_DEFAULT=0
if [[ -z "${PHOENIX_EXTRA_POLICIES_LINUX_FLATPAK+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_LINUX_FLATPAK="${PHOENIX_EXTRA_POLICIES_LINUX_FLATPAK_DEFAULT}"
fi

## This points to the location of the policies.json file that we should append the contents of
PHOENIX_EXTRA_POLICIES_FILE_LINUX_FLATPAK_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_POLICIES_LINUX_FLATPAK}" != 1 ] || [ -z "${PHOENIX_EXTRA_POLICIES_FILE_LINUX_FLATPAK+x}" ]; then
    export PHOENIX_EXTRA_POLICIES_FILE_LINUX_FLATPAK="${PHOENIX_EXTRA_POLICIES_FILE_LINUX_FLATPAK_DEFAULT}"
elif [[ -f "${PHOENIX_EXTRA_POLICIES_FILE_LINUX_FLATPAK+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_FILE_LINUX_FLATPAK="${PHOENIX_EXTRA_POLICIES_FILE_LINUX_FLATPAK}"
fi

## This points to the directory where we should put our (final) output files
PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_LINUX_FLATPAK_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_POLICIES_LINUX_FLATPAK}" != 1 ] || [ -z "${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_LINUX_FLATPAK+x}" ]; then
    export PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_LINUX_FLATPAK="${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_LINUX_FLATPAK_DEFAULT}"
elif [[ -d "${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_LINUX_FLATPAK+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_LINUX_FLATPAK="${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_LINUX_FLATPAK}"
fi

# Whether we should append contents of an additional policies.json file for OS X only
PHOENIX_EXTRA_POLICIES_OSX_DEFAULT=0
if [[ -z "${PHOENIX_EXTRA_POLICIES_OSX+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_OSX="${PHOENIX_EXTRA_POLICIES_OSX_DEFAULT}"
fi

## This points to the location of the policies.json file that we should append the contents of
PHOENIX_EXTRA_POLICIES_FILE_OSX_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_POLICIES_OSX}" != 1 ] || [ -z "${PHOENIX_EXTRA_POLICIES_FILE_OSX+x}" ]; then
    export PHOENIX_EXTRA_POLICIES_FILE_OSX="${PHOENIX_EXTRA_POLICIES_FILE_OSX_DEFAULT}"
elif [[ -f "${PHOENIX_EXTRA_POLICIES_FILE_OSX+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_FILE_OSX="${PHOENIX_EXTRA_POLICIES_FILE_OSX}"
fi

# Whether we should append contents of an additional policies.json file for OS X (Apple Silicon) only
PHOENIX_EXTRA_POLICIES_OSX_SILICON_DEFAULT=0
if [[ -z "${PHOENIX_EXTRA_POLICIES_OSX_SILICON+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_OSX_SILICON="${PHOENIX_EXTRA_POLICIES_OSX_SILICON_DEFAULT}"
fi

## This points to the location of the policies.json file that we should append the contents of
PHOENIX_EXTRA_POLICIES_FILE_OSX_SILICON_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_POLICIES_OSX_SILICON}" != 1 ] || [ -z "${PHOENIX_EXTRA_POLICIES_FILE_OSX_SILICON+x}" ]; then
    export PHOENIX_EXTRA_POLICIES_FILE_OSX_SILICON="${PHOENIX_EXTRA_POLICIES_FILE_OSX_SILICON_DEFAULT}"
elif [[ -f "${PHOENIX_EXTRA_POLICIES_FILE_OSX_SILICON+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_FILE_OSX_SILICON="${PHOENIX_EXTRA_POLICIES_FILE_OSX_SILICON}"
fi

## This points to the directory where we should put our (final) output files
PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_OSX_SILICON_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_POLICIES_OSX_SILICON}" != 1 ] || [ -z "${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_OSX_SILICON+x}" ]; then
    export PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_OSX_SILICON="${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_OSX_SILICON_DEFAULT}"
elif [[ -d "${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_OSX_SILICON+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_OSX_SILICON="${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_OSX_SILICON}"
fi

# Whether we should append contents of an additional policies.json file for OS X (Intel) only
PHOENIX_EXTRA_POLICIES_OSX_INTEL_DEFAULT=0
if [[ -z "${PHOENIX_EXTRA_POLICIES_OSX_INTEL+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_OSX_INTEL="${PHOENIX_EXTRA_POLICIES_OSX_INTEL_DEFAULT}"
fi

## This points to the location of the policies.json file that we should append the contents of
PHOENIX_EXTRA_POLICIES_FILE_OSX_INTEL_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_POLICIES_OSX_INTEL}" != 1 ] || [ -z "${PHOENIX_EXTRA_POLICIES_FILE_OSX_INTEL+x}" ]; then
    export PHOENIX_EXTRA_POLICIES_FILE_OSX_INTEL="${PHOENIX_EXTRA_POLICIES_FILE_OSX_INTEL_DEFAULT}"
elif [[ -f "${PHOENIX_EXTRA_POLICIES_FILE_OSX_INTEL+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_FILE_OSX_INTEL="${PHOENIX_EXTRA_POLICIES_FILE_OSX_INTEL}"
fi

## This points to the directory where we should put our (final) output files
PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_OSX_INTEL_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_POLICIES_OSX_INTEL}" != 1 ] || [ -z "${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_OSX_INTEL+x}" ]; then
    export PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_OSX_INTEL="${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_OSX_INTEL_DEFAULT}"
elif [[ -d "${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_OSX_INTEL+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_OSX_INTEL="${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_OSX_INTEL}"
fi

# Whether we should append contents of an additional policies.json file for Windows only
PHOENIX_EXTRA_POLICIES_WINDOWS_DEFAULT=0
if [[ -z "${PHOENIX_EXTRA_POLICIES_WINDOWS+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_WINDOWS="${PHOENIX_EXTRA_POLICIES_WINDOWS_DEFAULT}"
fi

## This points to the location of the policies.json file that we should append the contents of
PHOENIX_EXTRA_POLICIES_FILE_WINDOWS_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_POLICIES_WINDOWS}" != 1 ] || [ -z "${PHOENIX_EXTRA_POLICIES_FILE_WINDOWS+x}" ]; then
    export PHOENIX_EXTRA_POLICIES_FILE_WINDOWS="${PHOENIX_EXTRA_POLICIES_FILE_WINDOWS_DEFAULT}"
elif [[ -f "${PHOENIX_EXTRA_POLICIES_FILE_WINDOWS+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_FILE_WINDOWS="${PHOENIX_EXTRA_POLICIES_FILE_WINDOWS}"
fi

## This points to the directory where we should put our (final) output files
PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_WINDOWS_DEFAULT='undefined'
if [ "${PHOENIX_EXTRA_POLICIES_WINDOWS}" != 1 ] || [ -z "${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_WINDOWS+x}" ]; then
    export PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_WINDOWS="${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_WINDOWS_DEFAULT}"
elif [[ -d "${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_WINDOWS+x}" ]]; then
    export PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_WINDOWS="${PHOENIX_EXTRA_POLICIES_OUTPUT_DIR_WINDOWS}"
fi

