# Written by Micah Hoffman (@webbreacher)
# PT-BR version by Daniel Marques (@0xc0da)

require_relative "../list_checker.rb"

register_checker("PTBR_Emotion_Checker")

class PTBR_Emotion_Checker < List_Checker
	def initialize
		super
		@description = "List of Brazilian Portuguese emotional terms"
		@list = {
								"abatimento" => 0,
								"abatida" => 0,
								"abatido" => 0,
		            "aborrecimento" => 0,
		            "aborrecida" => 0,
								"aborrecido" => 0,
		            "adoracao" => 0,
								"adorado" => 0,
								"adorada" => 0,
		            "afeto" => 0,
		            "aflicao" => 0,
								"aflito" => 0,
								"aflita" => 0,
		            "agitacao" => 0,
								"agitado" => 0,
								"agitada" => 0,
		            "agonia" => 0,
		            "alarme" => 0,
		            "alegria" => 0,
								"alegre" => 0,
		            "alivio" => 0,
								"aliviada" => 0,
								"aliviado" => 0,
		            "amargura" => 0,
								"amargurada" => 0,
								"amargurado" => 0,
		            "amor" => 0,
								"amado" => 0,
								"amada" => 0,
		            "angustia" => 0,
								"angustiado" => 0,
								"angustiada" => 0,
		            "ansia" => 0,
		            "ansiedade" => 0,
								"apaixonado" => 0,
								"apaixonada" => 0,
								"apreensao" => 0,
		            "arrependimento" => 0,
								"arrependida" => 0,
								"arrependido" => 0,
		            "assombro" => 0,
								"assombrada" => 0,
								"assombrado" => 0,
		            "atracao" => 0,
								"atraido" => 0,
								"atraida" => 0,
		            "avareza" => 0,
		            "aversao" => 0,
		            "carinho" => 0,
		            "ciume" => 0,
		            "comocao" => 0,
		            "compaixao" => 0,
		            "culpa" => 0,
								"culpado" => 0,
								"culpada" => 0,
		            "dano" => 0,
		            "deleite" => 0,
		            "depressao" => 0,
								"deprimido" => 0,
								"deprimida" => 0,
		            "derrota" => 0,
								"derrotado" => 0,
								"derrotada" => 0,
		            "desanimo" => 0,
								"desanimado" => 0,
								"desanimada" => 0,
		            "desapontamento" => 0,
								"desapontada" => 0,
								"desapontado" => 0,
		            "desejo" => 0,
								"desejado" => 0,
								"desejada" => 0,
		            "desespero" => 0,
		            "desesperanca" => 0,
		            "desgosto" => 0,
		            "desprezo" => 0,
		            "diversao" => 0,
		            "divertimento" => 0,
		            "dor" => 0,
		            "embaraco" => 0,
		            "entusiasmo" => 0,
								"entusiasmado" => 0,
								"entusiasmada" => 0,
		            "esperanca" => 0,
		            "euforia" => 0,
		            "exasperacao" => 0,
		            "excitacao" => 0,
								"excitado" => 0,
								"excitada" => 0,
		            "excitamento" => 0,
		            "extase" => 0,
		            "felicidade" => 0,
								"feliz" => 0,
		            "ferocidade" => 0,
		            "frustracao" => 0,
		            "furia" => 0,
								"furiosa" => 0,
								"furioso" => 0,
		            "histeria" => 0,
		            "horror" => 0,
		            "hostilidade" => 0,
								"hostil" => 0,
		            "humilhacao" => 0,
								"humilhado" => 0,
								"humilhada" => 0,
		            "inclinacao" => 0,
		            "indignacao" => 0,
		            "infidelidade" => 0,
								"infiel" => 0,
		            "inseguranca" => 0,
		            "insolacao" => 0,
		            "insulto" => 0,
		            "inveja" => 0,
		            "irado" => 0,
								"irada" => 0,
		            "irritacao" => 0,
		            "jubilo" => 0,
		            "luxuria" => 0,
		            "medo" => 0,
		            "melancolia" => 0,
		            "miseria" => 0,
		            "mortificacao" => 0,
		            "nervosismo" => 0,
								"nervoso" => 0,
								"nervosa" => 0,
		            "nostalgia" => 0,
		            "obsessao" => 0,
		            "odio" => 0,
		            "orgulho" => 0,
								"orgulhoso" => 0,
								"orgulhosa" => 0,
		            "otimista" => 0,
		            "paixao" => 0,
		            "panico" => 0,
		            "pena" => 0,
		            "pesar" => 0,
		            "prazer" => 0,
		            "preocupacao" => 0,
		            "raiva" => 0,
		            "rancor" => 0,
		            "recreacao" => 0,
		            "rejeicao" => 0,
		            "remorso" => 0,
		            "ressentimento" => 0,
		            "satisfacao" => 0,
		            "sofrimento" => 0,
		            "solidao" => 0,
		            "surpresa" => 0,
		            "susto" => 0,
		            "temor" => 0,
		            "tensao" => 0,
		            "ternura" => 0,
		            "terror" => 0,
		            "tormento" => 0,
		            "tristeza" => 0,
		            "triunfo" => 0,
		            "vergonha" => 0,
		            "zelo" => 0
		        }
	end

	def get_results()
		return super("Brazilian Portuguese Emotion")
	end
end
