# WARNING: this file is auto-generated by 'build_sync_library.py'
# from the original file 'cases.py'
# DO NOT CHANGE! Change the original file instead.
from datetime import datetime, timezone
from typing import Any

FIXED_DATETIME = datetime(2025, 1, 1, 0, 0, 0, tzinfo=timezone.utc)
FIXED_TIME = FIXED_DATETIME.time()

LARGE_STRING: str = "a" * 10000  # 10KB
LARGE_INT: int = 1 * 10**18  # 18 digits
LARGE_FLOAT: float = 1.0 * 10**63  # 63 digits

SIMPLE_CASE: dict[str, Any] = {
    "key_1": "value_1",
    "key_2": 1,
    "key_3": 1.0,
    "key_4": [1, 2, 3],
    "key_5": {"nested": "value"},
    "key_6": True,
    "key_7": False,
    "key_8": None,
}

SIMPLE_CASE_JSON: str = '{"key_1": "value_1", "key_2": 1, "key_3": 1.0, "key_4": [1, 2, 3], "key_5": {"nested": "value"}, "key_6": true, "key_7": false, "key_8": null}'

# ({"key": (1, 2, 3)}, '{"key": [1, 2, 3]}'),
DICTIONARY_TO_JSON_TEST_CASES: list[tuple[dict[str, Any], str]] = [
    ({"key": "value"}, '{"key": "value"}'),
    ({"key": 1}, '{"key": 1}'),
    ({"key": 1.0}, '{"key": 1.0}'),
    ({"key": [1, 2, 3]}, '{"key": [1, 2, 3]}'),
    ({"key": {"nested": "value"}}, '{"key": {"nested": "value"}}'),
    ({"key": True}, '{"key": true}'),
    ({"key": False}, '{"key": false}'),
    ({"key": None}, '{"key": null}'),
    (
        {"key": {"int": 1, "float": 1.0, "list": [1, 2, 3], "dict": {"nested": "value"}, "bool": True, "null": None}},
        '{"key": {"int": 1, "float": 1.0, "list": [1, 2, 3], "dict": {"nested": "value"}, "bool": true, "null": null}}',
    ),
    ({"key": LARGE_STRING}, f'{{"key": "{LARGE_STRING}"}}'),
    ({"key": LARGE_INT}, f'{{"key": {LARGE_INT}}}'),
    ({"key": LARGE_FLOAT}, f'{{"key": {LARGE_FLOAT}}}'),
]

# "tuple",
DICTIONARY_TO_JSON_TEST_CASES_NAMES: list[str] = [
    "string",
    "int",
    "float",
    "list",
    "dict",
    "bool-true",
    "bool-false",
    "null",
    "dict-nested",
    "large-string",
    "large-int",
    "large-float",
]

OBJECT_TEST_CASES: list[dict[str, Any]] = [test_case[0] for test_case in DICTIONARY_TO_JSON_TEST_CASES]

JSON_TEST_CASES: list[str] = [test_case[1] for test_case in DICTIONARY_TO_JSON_TEST_CASES]
