"""vulnerability is_main

Revision ID: 618a59151523
Revises: 7c223e63007f
Create Date: 2024-11-21 18:59:20.567581+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '618a59151523'
down_revision = '7c223e63007f'
branch_labels = None
depends_on = None


def upgrade():
    # Add the is_main column
    op.add_column('vulnerability', sa.Column('is_main', sa.Boolean(), nullable=True))

    # Set is_main = True for main vulnerabilities
    op.execute("""
        UPDATE vulnerability
        SET is_main = True
        WHERE id IN (
            SELECT DISTINCT vulnerability_duplicate_id
            FROM vulnerability
            WHERE vulnerability_duplicate_id IS NOT NULL
        )
    """)


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('vulnerability', 'is_main')
    # ### end Alembic commands ###
