---
name: Bug report
about: Create a report an issue

---

Please search the [Wiki](https://github.com/infobyte/faraday/wiki) for a solution before posting a ticket. Use the <strong>“New Support Request”</strong> button to the right of the screen to submit a ticket for technical support.

## Issue Type
 - Bug Re port
 - Feature Idea
 - Documentation Report


## Faraday version

Paste the output of the *./faraday.py --version* command

## Component Name

If you know where the problem lays indicate it:
WebGui/GTKGui/Plugin/Console/Continuous Scanning/Etc.

## Steps to reproduce

Provide detailed steps on how the issue happened so we can try to reproduce it. If the issue is random, please provide as much information as possible.

## Expected results

What did you expect to happen when following the steps above?

### Debugging tracebacks (current results)

Try to reproduce the bug with the server and/or gtk client in debug mode and check the logs for the ERROR string.
Add here any errors you find while running in debug mode or, if possible, Faraday’s log files (located at *$HOME/.faraday/logs/*).

If you need help on how to execute in debug mode [click here for more information](https://github.com/infobyte/faraday/wiki/troubleshooting).

Please attach the result of:

pip freeze > requirements_freeze.txt

### Screenshots

If you don't find anything on the logs, please provide screenshots of the error.

## Environment information

### Configuration files

Mention any settings you have changed/added/removed.

### Reports/Extra data

If you are having issues with plugins, please attach relevant files if possible.
(strip your reports of all sensitive information beforehand).

### OS

Provide information on your operating system. Example:

$ cat /etc/lsb-release
DISTRIB_ID=Ubuntu
DISTRIB_RELEASE=16.10
DISTRIB_CODENAME=yakkety
DISTRIB_DESCRIPTION="Ubuntu 16.10"
