"""cloud_agent_scheduler_and_scheduler_token

Revision ID: e9a3ba96ea46
Revises: 47e0c8f9856d
Create Date: 2024-09-17 18:54:47.529304+00:00

"""
from alembic import op
import sqlalchemy as sa
from faraday.server.models import UserToken

# revision identifiers, used by Alembic.
revision = 'e9a3ba96ea46'
down_revision = '47e0c8f9856d'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    scheduler_types_enum = sa.Enum('cloud_agent', 'agent', name='scheduler_types')
    scheduler_types_enum.create(op.get_bind(), checkfirst=True)
    op.add_column('agent_schedule', sa.Column('type', sa.Enum('cloud_agent', 'agent', name='scheduler_types'), nullable=False, server_default='agent'))
    op.add_column('agent_schedule', sa.Column('cloud_agent_id', sa.Integer(), nullable=True))
    op.alter_column('agent_schedule', 'executor_id',
               existing_type=sa.INTEGER(),
               nullable=True)
    op.create_index(op.f('ix_agent_schedule_cloud_agent_id'), 'agent_schedule', ['cloud_agent_id'], unique=False)
    op.create_foreign_key('agent_schedule_cloud_agent_id_fkey', 'agent_schedule', 'cloud_agent', ['cloud_agent_id'], ['id'])
    with op.get_context().autocommit_block():
        op.execute("ALTER TYPE token_scopes ADD VALUE IF NOT EXISTS 'scheduler'")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('agent_schedule_cloud_agent_id_fkey', 'agent_schedule', type_='foreignkey')
    op.drop_index(op.f('ix_agent_schedule_cloud_agent_id'), table_name='agent_schedule')
    op.alter_column('agent_schedule', 'executor_id',
               existing_type=sa.INTEGER(),
               nullable=False)
    op.drop_column('agent_schedule', 'cloud_agent_id')
    op.drop_column('agent_schedule', 'type')
    scheduler_types_enum = sa.Enum('cloud_agent', 'agent', name='scheduler_types')
    scheduler_types_enum.drop(op.get_bind(), checkfirst=True)

    # Step 1: Create a new enum type without the 'scheduler' value

    scopes = [scope for scope in UserToken.SCOPES if scope != UserToken.SCHEDULER_SCOPE]

    scopes_str = ', '.join(f"'{scope}'" for scope in scopes)

    op.execute(f"CREATE TYPE token_scopes_tmp AS ENUM({scopes_str})")

    # Step 2: Alter the table to use the new enum type
    op.execute("""
            ALTER TABLE user_token
            ALTER COLUMN scope
            SET DATA TYPE token_scopes_tmp
            USING scope::text::token_scopes_tmp
        """)

    # Step 3: Drop the old enum type
    op.execute("DROP TYPE token_scopes")

    # Step 4: Rename the new enum type to the original one
    op.execute("ALTER TYPE token_scopes_tmp RENAME TO token_scopes")
    # ### end Alembic commands ###
