% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_check.R
\name{pp_check.brmsfit}
\alias{pp_check.brmsfit}
\alias{pp_check}
\title{Posterior Predictive Checks for \code{brmsfit} Objects}
\usage{
\method{pp_check}{brmsfit}(
  object,
  type,
  ndraws = NULL,
  prefix = c("ppc", "ppd"),
  group = NULL,
  x = NULL,
  newdata = NULL,
  resp = NULL,
  draw_ids = NULL,
  nsamples = NULL,
  subset = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{brmsfit}.}

\item{type}{Type of the ppc plot as given by a character string.
See \code{\link[bayesplot:PPC-overview]{PPC}} for an overview
of currently supported types. You may also use an invalid
type (e.g. \code{type = "xyz"}) to get a list of supported
types in the resulting error message.}

\item{ndraws}{Positive integer indicating how many
posterior draws should be used.
If \code{NULL} all draws are used. If not specified,
the number of posterior draws is chosen automatically.
Ignored if \code{draw_ids} is not \code{NULL}.}

\item{prefix}{The prefix of the \pkg{bayesplot} function to be applied.
Either `"ppc"` (posterior predictive check; the default)
or `"ppd"` (posterior predictive distribution), the latter being the same
as the former except that the observed data is not shown for `"ppd"`.}

\item{group}{Optional name of a factor variable in the model
by which to stratify the ppc plot. This argument is required for
ppc \code{*_grouped} types and ignored otherwise.}

\item{x}{Optional name of a variable in the model.
Only used for ppc types having an \code{x} argument
and ignored otherwise.}

\item{newdata}{An optional data.frame for which to evaluate predictions. If
\code{NULL} (default), the original data of the model is used. \code{NA}
values within factors (excluding grouping variables) are interpreted as if
all dummy variables of this factor are zero. This allows, for instance, to
make predictions of the grand mean when using sum coding. \code{NA} values
within grouping variables are treated as a new level.}

\item{resp}{Optional names of response variables. If specified, predictions
are performed only for the specified response variables.}

\item{draw_ids}{An integer vector specifying the posterior draws to be used.
If \code{NULL} (the default), all draws are used.}

\item{nsamples}{Deprecated alias of \code{ndraws}.}

\item{subset}{Deprecated alias of \code{draw_ids}.}

\item{...}{Further arguments passed to \code{\link{predict.brmsfit}}
as well as to the PPC function specified in \code{type}.}
}
\value{
A ggplot object that can be further
 customized using the \pkg{ggplot2} package.
}
\description{
Perform posterior predictive checks with the help
of the \pkg{bayesplot} package.
}
\details{
For a detailed explanation of each of the ppc functions,
see the \code{\link[bayesplot:PPC-overview]{PPC}}
documentation of the \pkg{\link[bayesplot:bayesplot-package]{bayesplot}}
package.
}
\examples{
\dontrun{
fit <-  brm(count ~ zAge + zBase * Trt
            + (1|patient) + (1|obs),
            data = epilepsy, family = poisson())

pp_check(fit)  # shows dens_overlay plot by default
pp_check(fit, type = "error_hist", ndraws = 11)
pp_check(fit, type = "scatter_avg", ndraws = 100)
pp_check(fit, type = "stat_2d")
pp_check(fit, type = "rootogram")
pp_check(fit, type = "loo_pit")

## get an overview of all valid types
pp_check(fit, type = "xyz")

## get a plot without the observed data
pp_check(fit, prefix = "ppd")
}

}
