% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_indices.R
\name{fit_indices}
\alias{fit_indices}
\title{Calculates the fit indices}
\usage{
fit_indices(model, CV = FALSE, CovMat = NULL, data = NULL, n.obs = NULL)
}
\arguments{
\item{model}{regsem model object.}

\item{CV}{cross-validation. Note that this requires splitting the dataset
into a training and test set prior to running the model. The
model should be run on the training set, with the test set
held out and then passed to CovMat=.}

\item{CovMat}{If CV=T then test covariance matrix must be supplied. Note
That this should be done before running the lavaan model and should
not overlap with the data or covariance matrix used to run the model.}

\item{data}{supply the dataset?}

\item{n.obs}{Number of observations in the test set for CV.}
}
\value{
fits Full set of fit indices
}
\description{
Calculates the fit indices
}
\examples{
\dontrun{
fit_indices()
}
}
\keyword{chisq}
\keyword{fit}
\keyword{ncp}
\keyword{rmsea}
