% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_test.R
\name{t_test}
\alias{t_test}
\alias{pairwise_t_test}
\title{T-test}
\usage{
t_test(
  data,
  formula,
  comparisons = NULL,
  ref.group = NULL,
  p.adjust.method = "holm",
  paired = FALSE,
  var.equal = FALSE,
  alternative = "two.sided",
  mu = 0,
  conf.level = 0.95,
  detailed = FALSE
)

pairwise_t_test(
  data,
  formula,
  comparisons = NULL,
  ref.group = NULL,
  p.adjust.method = "holm",
  paired = FALSE,
  pool.sd = !paired,
  detailed = FALSE,
  ...
)
}
\arguments{
\item{data}{a data.frame containing the variables in the formula.}

\item{formula}{a formula of the form \code{x ~ group} where \code{x} is a
numeric variable giving the data values and \code{group} is a factor with
one or multiple levels giving the corresponding groups. For example,
\code{formula = TP53 ~ cancer_group}.}

\item{comparisons}{A list of length-2 vectors specifying the groups of
interest to be compared. For example to compare groups "A" vs "B" and "B" vs
"C", the argument is as follow: \code{comparisons = list(c("A", "B"), c("B",
"C"))}}

\item{ref.group}{a character string specifying the reference group. If
 specified, for a given grouping variable, each of the group levels will be
 compared to the reference group (i.e. control group).

 If \code{ref.group = "all"}, pairwise two sample tests are performed for
 comparing each grouping variable levels against all (i.e. basemean).}

\item{p.adjust.method}{method to adjust p values for multiple comparisons.
Used when pairwise comparisons are performed. Allowed values include "holm",
"hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none". If you don't
want to adjust the p value (not recommended), use p.adjust.method = "none".}

\item{paired}{a logical indicating whether you want a paired test.}

\item{var.equal}{a logical variable indicating whether to treat the
    two variances as being equal. If \code{TRUE} then the pooled
    variance is used to estimate the variance otherwise the Welch
    (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{alternative}{a character string specifying the alternative
    hypothesis, must be one of \code{"two.sided"} (default),
    \code{"greater"} or \code{"less"}.  You can specify just the initial
    letter.}

\item{mu}{a number specifying an optional parameter used to form the null hypothesis.}

\item{conf.level}{confidence level of the interval.}

\item{detailed}{logical value. Default is FALSE. If TRUE, a detailed result is
shown.}

\item{pool.sd}{logical value used in the function \code{pairwise_t_test()}.
 Switch to allow/disallow the use of a pooled SD.

 The \code{pool.sd = TRUE} (default) calculates a common SD for all groups
 and uses that for all comparisons (this can be useful if some groups are
 small). This method does not actually call t.test, so extra arguments are
 ignored. Pooling does not generalize to paired tests so pool.sd and paired
 cannot both be TRUE.

 If \code{pool.sd = FALSE} the standard two sample t-test is applied to all
 possible pairs of groups. This method calls the \code{t.test()}, so extra
 arguments, such as \code{var.equal} are accepted.}

\item{...}{other arguments to be passed to the function
\code{\link[stats]{t.test}}.}
}
\value{
return a data frame with some the following columns: \itemize{ \item
 \code{.y.}: the y variable used in the test. \item \code{group1,group2}: the
 compared groups in the pairwise tests. \item \code{n,n1,n2}: Sample counts.
 \item \code{statistic}: Test statistic used to compute the p-value. \item
 \code{df}: degrees of freedom. \item \code{p}: p-value. \item \code{p.adj}:
 the adjusted p-value. \item \code{method}: the statistical test used to
 compare groups. \item \code{p.signif, p.adj.signif}: the significance level
 of p-values and adjusted p-values, respectively. \item \code{estimate}:
 estimate of the effect size. It corresponds to the estimated mean or
 difference in means depending on whether it was a one-sample test or a
 two-sample test. \item \code{estimate1, estimate2}: show the mean values of
 the two groups, respectively, for independent samples t-tests. \item
 \code{alternative}: a character string describing the alternative
 hypothesis. \item \code{conf.low,conf.high}: Lower and upper bound on a
 confidence interval. }

 The \strong{returned object has an attribute called args}, which is a list
 holding the test arguments.
}
\description{
Provides a pipe-friendly framework to performs one and two sample
 t-tests. Read more: \href{https://www.datanovia.com/en/lessons/t-test-in-r/}{T-test in R}.
}
\details{
- If a list of comparisons is specified, the result of the pairwise tests is
filtered to keep only the comparisons of interest. The p-value is adjusted
after filtering.

- For a grouped data, if pairwise test is performed, then the p-values are
adjusted for each group level independently.
}
\section{Functions}{
\itemize{
\item \code{t_test()}: t test

\item \code{pairwise_t_test()}: performs pairwise two sample t-test. Wrapper around the R
base function \code{\link[stats]{pairwise.t.test}}.

}}
\examples{
# Load data
#:::::::::::::::::::::::::::::::::::::::
data("ToothGrowth")
df <- ToothGrowth

# One-sample test
#:::::::::::::::::::::::::::::::::::::::::
df \%>\% t_test(len ~ 1, mu = 0)


# Two-samples unpaired test
#:::::::::::::::::::::::::::::::::::::::::
df \%>\% t_test(len ~ supp)

# Two-samples paired test
#:::::::::::::::::::::::::::::::::::::::::
df \%>\% t_test (len ~ supp, paired = TRUE)

# Compare supp levels after grouping the data by "dose"
#::::::::::::::::::::::::::::::::::::::::
df \%>\%
  group_by(dose) \%>\%
  t_test(data =., len ~ supp) \%>\%
  adjust_pvalue(method = "bonferroni") \%>\%
  add_significance("p.adj")

# pairwise comparisons
#::::::::::::::::::::::::::::::::::::::::
# As dose contains more than two levels ==>
# pairwise test is automatically performed.
df \%>\% t_test(len ~ dose)

# Comparison against reference group
#::::::::::::::::::::::::::::::::::::::::
# each level is compared to the ref group
df \%>\% t_test(len ~ dose, ref.group = "0.5")

# Comparison against all
#::::::::::::::::::::::::::::::::::::::::
df \%>\% t_test(len ~ dose, ref.group = "all")

}
