\name{runifpoint}
\alias{runifpoint}
\title{Generate N Uniform Random Points}
\description{
  Generate a random point pattern
  containing \eqn{n} independent uniform random points.
}
\usage{
 runifpoint(n, win=owin(c(0,1),c(0,1)), giveup=1000, warn=TRUE, \dots,
            nsim=1, drop=TRUE, ex=NULL)
}
\arguments{
  \item{n}{
    Number of points.
  }
  \item{win}{
    Window in which to simulate the pattern.
    An object of class \code{"owin"}
    or something acceptable to \code{\link[spatstat.geom]{as.owin}}.
    (Alternatively a tessellation; see the section on
    tessellations).
  }
  \item{giveup}{
    Number of attempts in the rejection method after which
    the algorithm should stop trying to generate new points.
  }
  \item{warn}{
    Logical. Whether to issue a warning if \code{n} is very large.
    See Details.
  }
  \item{\dots}{Ignored.}
  \item{nsim}{Number of simulated realisations to be generated.}
  \item{drop}{
    Logical. If \code{nsim=1} and \code{drop=TRUE} (the default), the
    result will be a point pattern, rather than a list 
    containing a point pattern.
  }
  \item{ex}{
    Optional. A point pattern to use as the example.
    If \code{ex} is given and \code{n} and \code{win} are missing,
    then \code{n} and \code{win} will be calculated from
    the point pattern \code{ex}.
  }
}
\value{
  A point pattern (an object of class \code{"ppp"})
  or a list of point patterns.
}
\details{
  This function generates \code{n} independent random points,
  uniformly distributed in the window \code{win}.
  (For nonuniform distributions, see \code{\link{rpoint}}.)

  The algorithm depends on the type of window, as follows:
  \itemize{
    \item
    If \code{win} is a rectangle then 
    \eqn{n} independent random points, uniformly distributed
    in the rectangle, are generated by assigning uniform random values to their
    cartesian coordinates.
    \item
    If \code{win} is a binary image mask, then a random sequence of 
    pixels is selected (using \code{\link{sample}})
    with equal probabilities. Then for each pixel in the sequence
    we generate a uniformly distributed random point in that pixel.
    \item
    If \code{win} is a polygonal window, the algorithm uses the rejection
    method. It finds a rectangle enclosing the window,
    generates points in this rectangle, and tests whether they fall in
    the desired window. It gives up when \code{giveup * n} tests
    have been performed without yielding \code{n} successes.
  }
  The algorithm for binary image masks is faster than the rejection
  method but involves discretisation.

  If \code{warn=TRUE} (the default), a warning will be issued if \code{n} is very large.
  The threshold is \code{\link[spatstat.geom]{spatstat.options}("huge.npoints")}.
  This warning has no consequences,
  but it helps to trap a number of common errors.
}
\section{Tessellation}{
  The argument \code{win} may be a tessellation
  (object of class \code{"tess"}, see \code{\link[spatstat.geom]{tess}}).
  Then the specified number of points \code{n} will be randomly generated
  inside each tile of the tessellation. The argument \code{n} may be
  either a single integer, or an integer vector specifying the number
  of points to be generated in each individual tile. The result will
  be a point pattern in the window \code{\link[spatstat.geom]{as.owin}(win)}.
}
\seealso{
\code{\link[spatstat.geom]{ppp.object}},
\code{\link[spatstat.geom]{owin.object}},
\code{\link{rpoispp}},
\code{\link{rpoint}}
}
\examples{
 # 100 random points in the unit square
 pp <- runifpoint(100)
 # irregular window
 letterR
 # polygonal
 pp <- runifpoint(100, letterR)
 # binary image mask
 pp <- runifpoint(100, as.mask(letterR))

 # randomising an existing point pattern
 runifpoint(npoints(cells), win=Window(cells))
 runifpoint(ex=cells)

 # tessellation
 A <- quadrats(unit.square(), 2, 3)
 # different numbers of points in each cell
 X <- runifpoint(1:6, A)
}
\author{\adrian
  and \rolf
}
\keyword{spatial}
\keyword{datagen}

