#ifndef _WINBASE_H
#define _WINBASE_H
#if __GNUC__ >= 3
#pragma GCC system_header
#endif

#ifndef WINBASEAPI
#ifdef __W32API_USE_DLLIMPORT__
#define WINBASEAPI DECLSPEC_IMPORT
#else
#define WINBASEAPI
#endif
#endif

#ifndef WINADVAPI
#ifdef __W32API_USE_DLLIMPORT__
#define WINADVAPI DECLSPEC_IMPORT
#else
#define WINADVAPI
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define SP_SERIALCOMM 1
#define PST_UNSPECIFIED	0
#define PST_RS232	1
#define PST_PARALLELPORT	2
#define PST_RS422	3
#define PST_RS423	4
#define PST_RS449	5
#define PST_MODEM	6
#define PST_FAX	0x21
#define PST_SCANNER	0x22
#define PST_NETWORK_BRIDGE	0x100
#define PST_LAT	0x101
#define PST_TCPIP_TELNET	0x102
#define PST_X25	0x103
#define BAUD_075	1
#define BAUD_110	2
#define BAUD_134_5	4
#define BAUD_150	8
#define BAUD_300	16
#define BAUD_600	32
#define BAUD_1200	64
#define BAUD_1800	128
#define BAUD_2400	256
#define BAUD_4800	512
#define BAUD_7200	1024
#define BAUD_9600	2048
#define BAUD_14400	4096
#define BAUD_19200	8192
#define BAUD_38400	16384
#define BAUD_56K	32768
#define BAUD_128K	65536
#define BAUD_115200	131072
#define BAUD_57600	262144
#define BAUD_USER	0x10000000
#define PCF_DTRDSR	1
#define PCF_RTSCTS	2
#define PCF_RLSD	4
#define PCF_PARITY_CHECK	8
#define PCF_XONXOFF	16
#define PCF_SETXCHAR	32
#define PCF_TOTALTIMEOUTS	64
#define PCF_INTTIMEOUTS	128
#define PCF_SPECIALCHARS	256
#define PCF_16BITMODE	512
#define SP_PARITY	1
#define SP_BAUD	2
#define SP_DATABITS	4
#define SP_STOPBITS	8
#define SP_HANDSHAKING	16
#define SP_PARITY_CHECK	32
#define SP_RLSD	64
#define DATABITS_5	1
#define DATABITS_6	2
#define DATABITS_7	4
#define DATABITS_8	8
#define DATABITS_16	16
#define DATABITS_16X	32
#define STOPBITS_10	1
#define STOPBITS_15	2
#define STOPBITS_20	4
#define PARITY_NONE	256
#define PARITY_ODD	512
#define PARITY_EVEN	1024
#define PARITY_MARK	2048
#define PARITY_SPACE	4096
#define EXCEPTION_DEBUG_EVENT	1
#define CREATE_THREAD_DEBUG_EVENT	2
#define CREATE_PROCESS_DEBUG_EVENT	3
#define EXIT_THREAD_DEBUG_EVENT	4
#define EXIT_PROCESS_DEBUG_EVENT	5
#define LOAD_DLL_DEBUG_EVENT	6
#define UNLOAD_DLL_DEBUG_EVENT	7
#define OUTPUT_DEBUG_STRING_EVENT	8
#define RIP_EVENT	9
#define HFILE_ERROR ((HFILE)-1)
#define FILE_BEGIN	0
#define FILE_CURRENT	1
#define FILE_END	2
#define INVALID_SET_FILE_POINTER	((DWORD)-1)
#define OF_READ 0
#define OF_READWRITE	2
#define OF_WRITE	1
#define OF_SHARE_COMPAT	0
#define OF_SHARE_DENY_NONE	64
#define OF_SHARE_DENY_READ	48
#define OF_SHARE_DENY_WRITE	32
#define OF_SHARE_EXCLUSIVE	16
#define OF_CANCEL	2048
#define OF_CREATE	4096
#define OF_DELETE	512
#define OF_EXIST	16384
#define OF_PARSE	256
#define OF_PROMPT	8192
#define OF_REOPEN	32768
#define OF_VERIFY	1024
#define NMPWAIT_NOWAIT	1
#define NMPWAIT_WAIT_FOREVER	((DWORD)-1)
#define NMPWAIT_USE_DEFAULT_WAIT	0
#define CE_BREAK	16
#define CE_DNS	2048
#define CE_FRAME	8
#define CE_IOE	1024
#define CE_MODE	32768
#define CE_OOP	4096
#define CE_OVERRUN	2
#define CE_PTO	512
#define CE_RXOVER	1
#define CE_RXPARITY	4
#define CE_TXFULL	256
#define PROGRESS_CONTINUE	0
#define PROGRESS_CANCEL	1
#define PROGRESS_STOP	2
#define PROGRESS_QUIET	3
#define CALLBACK_CHUNK_FINISHED	0
#define CALLBACK_STREAM_SWITCH	1
#define COPY_FILE_FAIL_IF_EXISTS	1
#define COPY_FILE_RESTARTABLE	2
#define OFS_MAXPATHNAME 128
#define FILE_MAP_ALL_ACCESS     0xf001f
#define FILE_MAP_READ   4
#define FILE_MAP_WRITE  2
#define FILE_MAP_COPY   1
#define MUTEX_ALL_ACCESS	0x1f0001
#define MUTEX_MODIFY_STATE	1
#define SEMAPHORE_ALL_ACCESS	0x1f0003
#define SEMAPHORE_MODIFY_STATE	2
#define EVENT_ALL_ACCESS	0x1f0003
#define EVENT_MODIFY_STATE	2
#define PIPE_ACCESS_DUPLEX      3
#define PIPE_ACCESS_INBOUND     1
#define PIPE_ACCESS_OUTBOUND    2
#define PIPE_TYPE_BYTE	0
#define PIPE_TYPE_MESSAGE	4
#define PIPE_READMODE_BYTE	0
#define PIPE_READMODE_MESSAGE	2
#define PIPE_WAIT	0
#define PIPE_NOWAIT	1
#define PIPE_CLIENT_END 0
#define PIPE_SERVER_END 1
#define PIPE_UNLIMITED_INSTANCES 255
#define DEBUG_PROCESS			0x00000001
#define DEBUG_ONLY_THIS_PROCESS		0x00000002
#define CREATE_SUSPENDED		0x00000004
#define DETACHED_PROCESS		0x00000008
#define CREATE_NEW_CONSOLE		0x00000010
#define NORMAL_PRIORITY_CLASS		0x00000020
#define IDLE_PRIORITY_CLASS		0x00000040
#define HIGH_PRIORITY_CLASS		0x00000080
#define REALTIME_PRIORITY_CLASS		0x00000100
#define CREATE_NEW_PROCESS_GROUP	0x00000200
#define CREATE_UNICODE_ENVIRONMENT	0x00000400
#define CREATE_SEPARATE_WOW_VDM		0x00000800
#define CREATE_SHARED_WOW_VDM		0x00001000
#define CREATE_FORCEDOS			0x00002000
#define BELOW_NORMAL_PRIORITY_CLASS	0x00004000
#define ABOVE_NORMAL_PRIORITY_CLASS	0x00008000
#define CREATE_BREAKAWAY_FROM_JOB	0x01000000
#define CREATE_WITH_USERPROFILE		0x02000000
#define CREATE_DEFAULT_ERROR_MODE	0x04000000
#define CREATE_NO_WINDOW		0x08000000
#define PROFILE_USER			0x10000000
#define PROFILE_KERNEL			0x20000000
#define PROFILE_SERVER			0x40000000
#define CONSOLE_TEXTMODE_BUFFER 1
#define CREATE_NEW	1
#define CREATE_ALWAYS	2
#define OPEN_EXISTING	3
#define OPEN_ALWAYS	4
#define TRUNCATE_EXISTING	5
#define FILE_FLAG_WRITE_THROUGH	0x80000000
#define FILE_FLAG_OVERLAPPED	1073741824
#define FILE_FLAG_NO_BUFFERING	536870912
#define FILE_FLAG_RANDOM_ACCESS	268435456
#define FILE_FLAG_SEQUENTIAL_SCAN	134217728
#define FILE_FLAG_DELETE_ON_CLOSE	67108864
#define FILE_FLAG_BACKUP_SEMANTICS	33554432
#define FILE_FLAG_POSIX_SEMANTICS	16777216
#define FILE_FLAG_OPEN_REPARSE_POINT	2097152
#define FILE_FLAG_OPEN_NO_RECALL	1048576
#if (_WIN32_WINNT >= 0x0500)
#define FILE_FLAG_FIRST_PIPE_INSTANCE	524288
#endif
#define CLRDTR 6
#define CLRRTS 4
#define SETDTR 5
#define SETRTS 3
#define SETXOFF 1
#define SETXON 2
#define SETBREAK 8
#define CLRBREAK 9
#define STILL_ACTIVE 0x103
#define FIND_FIRST_EX_CASE_SENSITIVE 1
#define SCS_32BIT_BINARY 0
#define SCS_DOS_BINARY 1
#define SCS_OS216_BINARY 5
#define SCS_PIF_BINARY 3
#define SCS_POSIX_BINARY 4
#define SCS_WOW_BINARY 2
#define MAX_COMPUTERNAME_LENGTH 15
#define HW_PROFILE_GUIDLEN	39
#define MAX_PROFILE_LEN	80
#define DOCKINFO_UNDOCKED	1
#define DOCKINFO_DOCKED	2
#define DOCKINFO_USER_SUPPLIED	4
#define DOCKINFO_USER_UNDOCKED	(DOCKINFO_USER_SUPPLIED|DOCKINFO_UNDOCKED)
#define DOCKINFO_USER_DOCKED	(DOCKINFO_USER_SUPPLIED|DOCKINFO_DOCKED)
#define DRIVE_REMOVABLE 2
#define DRIVE_FIXED 3
#define DRIVE_REMOTE 4
#define DRIVE_CDROM 5
#define DRIVE_RAMDISK 6
#define DRIVE_UNKNOWN 0
#define DRIVE_NO_ROOT_DIR 1
#define FILE_TYPE_UNKNOWN 0
#define FILE_TYPE_DISK 1
#define FILE_TYPE_CHAR 2
#define FILE_TYPE_PIPE 3
#define FILE_TYPE_REMOTE 0x8000
/* also in ddk/ntapi.h */
#define HANDLE_FLAG_INHERIT		0x01
#define HANDLE_FLAG_PROTECT_FROM_CLOSE	0x02
/* end ntapi.h */
#define STD_INPUT_HANDLE (DWORD)(0xfffffff6)
#define STD_OUTPUT_HANDLE (DWORD)(0xfffffff5)
#define STD_ERROR_HANDLE (DWORD)(0xfffffff4)
#define INVALID_HANDLE_VALUE (HANDLE)(-1)
#define GET_TAPE_MEDIA_INFORMATION 0
#define GET_TAPE_DRIVE_INFORMATION 1
#define SET_TAPE_MEDIA_INFORMATION 0
#define SET_TAPE_DRIVE_INFORMATION 1
#define THREAD_PRIORITY_ABOVE_NORMAL 1
#define THREAD_PRIORITY_BELOW_NORMAL (-1)
#define THREAD_PRIORITY_HIGHEST 2
#define THREAD_PRIORITY_IDLE (-15)
#define THREAD_PRIORITY_LOWEST (-2)
#define THREAD_PRIORITY_NORMAL 0
#define THREAD_PRIORITY_TIME_CRITICAL 15
#define THREAD_PRIORITY_ERROR_RETURN 2147483647
#define TIME_ZONE_ID_UNKNOWN 0
#define TIME_ZONE_ID_STANDARD 1
#define TIME_ZONE_ID_DAYLIGHT 2
#define TIME_ZONE_ID_INVALID 0xFFFFFFFF
#define FS_CASE_IS_PRESERVED 2
#define FS_CASE_SENSITIVE 1
#define FS_UNICODE_STORED_ON_DISK 4
#define FS_PERSISTENT_ACLS 8
#define FS_FILE_COMPRESSION 16
#define FS_VOL_IS_COMPRESSED 32768
#define GMEM_FIXED 0
#define GMEM_MOVEABLE 2
#define GMEM_MODIFY 128
#define GPTR 64
#define GHND 66
#define GMEM_DDESHARE 8192
#define GMEM_DISCARDABLE 256
#define GMEM_LOWER 4096
#define GMEM_NOCOMPACT 16
#define GMEM_NODISCARD 32
#define GMEM_NOT_BANKED 4096
#define GMEM_NOTIFY 16384
#define GMEM_SHARE 8192
#define GMEM_ZEROINIT 64
#define GMEM_DISCARDED 16384
#define GMEM_INVALID_HANDLE 32768
#define GMEM_LOCKCOUNT 255
#define GMEM_VALID_FLAGS 32626
#define STATUS_WAIT_0 0
#define STATUS_ABANDONED_WAIT_0 0x80
#define STATUS_USER_APC 0xC0
#define STATUS_TIMEOUT 0x102
#define STATUS_PENDING 0x103
#define STATUS_SEGMENT_NOTIFICATION 0x40000005
#define STATUS_GUARD_PAGE_VIOLATION 0x80000001
#define STATUS_DATATYPE_MISALIGNMENT 0x80000002
#define STATUS_BREAKPOINT 0x80000003
#define STATUS_SINGLE_STEP 0x80000004
#define STATUS_ACCESS_VIOLATION 0xC0000005
#define STATUS_IN_PAGE_ERROR 0xC0000006
#define STATUS_INVALID_HANDLE 0xC0000008L
#define STATUS_NO_MEMORY 0xC0000017
#define STATUS_ILLEGAL_INSTRUCTION 0xC000001D
#define STATUS_NONCONTINUABLE_EXCEPTION 0xC0000025
#define STATUS_INVALID_DISPOSITION 0xC0000026
#define STATUS_ARRAY_BOUNDS_EXCEEDED 0xC000008C
#define STATUS_FLOAT_DENORMAL_OPERAND 0xC000008D
#define STATUS_FLOAT_DIVIDE_BY_ZERO 0xC000008E
#define STATUS_FLOAT_INEXACT_RESULT 0xC000008F
#define STATUS_FLOAT_INVALID_OPERATION 0xC0000090
#define STATUS_FLOAT_OVERFLOW 0xC0000091
#define STATUS_FLOAT_STACK_CHECK 0xC0000092
#define STATUS_FLOAT_UNDERFLOW 0xC0000093
#define STATUS_INTEGER_DIVIDE_BY_ZERO 0xC0000094
#define STATUS_INTEGER_OVERFLOW 0xC0000095
#define STATUS_PRIVILEGED_INSTRUCTION 0xC0000096
#define STATUS_STACK_OVERFLOW 0xC00000FD
#define STATUS_CONTROL_C_EXIT 0xC000013A
#define STATUS_DLL_INIT_FAILED 0xC0000142
#define STATUS_DLL_INIT_FAILED_LOGOFF 0xC000026B
#define EXCEPTION_ACCESS_VIOLATION	STATUS_ACCESS_VIOLATION
#define EXCEPTION_DATATYPE_MISALIGNMENT	STATUS_DATATYPE_MISALIGNMENT
#define EXCEPTION_BREAKPOINT	STATUS_BREAKPOINT
#define EXCEPTION_SINGLE_STEP	STATUS_SINGLE_STEP
#define EXCEPTION_ARRAY_BOUNDS_EXCEEDED	STATUS_ARRAY_BOUNDS_EXCEEDED
#define EXCEPTION_FLT_DENORMAL_OPERAND	STATUS_FLOAT_DENORMAL_OPERAND
#define EXCEPTION_FLT_DIVIDE_BY_ZERO	STATUS_FLOAT_DIVIDE_BY_ZERO
#define EXCEPTION_FLT_INEXACT_RESULT	STATUS_FLOAT_INEXACT_RESULT
#define EXCEPTION_FLT_INVALID_OPERATION	STATUS_FLOAT_INVALID_OPERATION
#define EXCEPTION_FLT_OVERFLOW	STATUS_FLOAT_OVERFLOW
#define EXCEPTION_FLT_STACK_CHECK	STATUS_FLOAT_STACK_CHECK
#define EXCEPTION_FLT_UNDERFLOW	STATUS_FLOAT_UNDERFLOW
#define EXCEPTION_INT_DIVIDE_BY_ZERO	STATUS_INTEGER_DIVIDE_BY_ZERO
#define EXCEPTION_INT_OVERFLOW	STATUS_INTEGER_OVERFLOW
#define EXCEPTION_PRIV_INSTRUCTION	STATUS_PRIVILEGED_INSTRUCTION
#define EXCEPTION_IN_PAGE_ERROR	STATUS_IN_PAGE_ERROR
#define EXCEPTION_ILLEGAL_INSTRUCTION	STATUS_ILLEGAL_INSTRUCTION
#define EXCEPTION_NONCONTINUABLE_EXCEPTION	STATUS_NONCONTINUABLE_EXCEPTION
#define EXCEPTION_STACK_OVERFLOW	STATUS_STACK_OVERFLOW
#define EXCEPTION_INVALID_DISPOSITION	STATUS_INVALID_DISPOSITION
#define EXCEPTION_GUARD_PAGE	STATUS_GUARD_PAGE_VIOLATION
#define EXCEPTION_INVALID_HANDLE	STATUS_INVALID_HANDLE
#define CONTROL_C_EXIT	STATUS_CONTROL_C_EXIT
#define PROCESS_HEAP_REGION 1
#define PROCESS_HEAP_UNCOMMITTED_RANGE 2
#define PROCESS_HEAP_ENTRY_BUSY 4
#define PROCESS_HEAP_ENTRY_MOVEABLE 16
#define PROCESS_HEAP_ENTRY_DDESHARE 32
#define DONT_RESOLVE_DLL_REFERENCES 1
#define LOAD_LIBRARY_AS_DATAFILE 2
#define LOAD_WITH_ALTERED_SEARCH_PATH 8
#define LMEM_FIXED 0
#define LMEM_MOVEABLE 2
#define LMEM_NONZEROLHND 2
#define LMEM_NONZEROLPTR 0
#define LMEM_DISCARDABLE 3840
#define LMEM_NOCOMPACT 16
#define LMEM_NODISCARD 32
#define LMEM_ZEROINIT 64
#define LMEM_DISCARDED 16384
#define LMEM_MODIFY 128
#define LMEM_INVALID_HANDLE 32768
#define LMEM_LOCKCOUNT 255
#define LPTR 64
#define LHND 66
#define NONZEROLHND 2
#define NONZEROLPTR 0
#define LOCKFILE_FAIL_IMMEDIATELY 1
#define LOCKFILE_EXCLUSIVE_LOCK 2
#define LOGON32_PROVIDER_DEFAULT	0
#define LOGON32_PROVIDER_WINNT35	1
#if (_WIN32_WINNT >= 0x0400)
#define LOGON32_PROVIDER_WINNT40	2
#endif
#if (_WIN32_WINNT >= 0x0500)
#define LOGON32_PROVIDER_WINNT50	3
#endif
#define LOGON32_LOGON_INTERACTIVE	2
#define LOGON32_LOGON_NETWORK	3
#define LOGON32_LOGON_BATCH	4
#define LOGON32_LOGON_SERVICE	5
#define LOGON32_LOGON_UNLOCK	7
#if (_WIN32_WINNT >= 0x0500)
#define LOGON32_LOGON_NETWORK_CLEARTEXT	8
#define LOGON32_LOGON_NEW_CREDENTIALS	9
#endif
#define MOVEFILE_REPLACE_EXISTING 1
#define MOVEFILE_COPY_ALLOWED 2
#define MOVEFILE_DELAY_UNTIL_REBOOT 4
#define MOVEFILE_WRITE_THROUGH 8
#define MAXIMUM_WAIT_OBJECTS 64
#define MAXIMUM_SUSPEND_COUNT 0x7F
#define WAIT_OBJECT_0 0
#define WAIT_ABANDONED_0 128
#ifndef WAIT_TIMEOUT /* also in winerror.h */
#define WAIT_TIMEOUT 258
#endif
#define WAIT_IO_COMPLETION 0xC0
#define WAIT_ABANDONED 128
#define WAIT_FAILED ((DWORD)0xFFFFFFFF)
#define PURGE_TXABORT 1
#define PURGE_RXABORT 2
#define PURGE_TXCLEAR 4
#define PURGE_RXCLEAR 8
#define EVENTLOG_SUCCESS 0
#define EVENTLOG_FORWARDS_READ 4
#define EVENTLOG_BACKWARDS_READ 8
#define EVENTLOG_SEEK_READ 2
#define EVENTLOG_SEQUENTIAL_READ 1
#define EVENTLOG_ERROR_TYPE 1
#define EVENTLOG_WARNING_TYPE 2
#define EVENTLOG_INFORMATION_TYPE 4
#define EVENTLOG_AUDIT_SUCCESS 8
#define EVENTLOG_AUDIT_FAILURE 16
#define FORMAT_MESSAGE_ALLOCATE_BUFFER 256
#define FORMAT_MESSAGE_IGNORE_INSERTS 512
#define FORMAT_MESSAGE_FROM_STRING 1024
#define FORMAT_MESSAGE_FROM_HMODULE 2048
#define FORMAT_MESSAGE_FROM_SYSTEM 4096
#define FORMAT_MESSAGE_ARGUMENT_ARRAY 8192
#define FORMAT_MESSAGE_MAX_WIDTH_MASK 255
#define EV_BREAK 64
#define EV_CTS 8
#define EV_DSR 16
#define EV_ERR 128
#define EV_EVENT1 2048
#define EV_EVENT2 4096
#define EV_PERR 512
#define EV_RING 256
#define EV_RLSD 32
#define EV_RX80FULL 1024
#define EV_RXCHAR 1
#define EV_RXFLAG 2
#define EV_TXEMPTY 4
/* also in ddk/ntapi.h */
/* To restore default error mode, call SetErrorMode (0).  */ 
#define SEM_FAILCRITICALERRORS		0x0001
#define SEM_NOGPFAULTERRORBOX		0x0002
#define SEM_NOALIGNMENTFAULTEXCEPT	0x0004
#define SEM_NOOPENFILEERRORBOX		0x8000
/* end ntapi.h */
#define SLE_ERROR 1
#define SLE_MINORERROR 2
#define SLE_WARNING 3
#define SHUTDOWN_NORETRY 1
#define EXCEPTION_EXECUTE_HANDLER 1
#define EXCEPTION_CONTINUE_EXECUTION (-1)
#define EXCEPTION_CONTINUE_SEARCH 0
#define MAXINTATOM 0xC000
#define INVALID_ATOM ((ATOM)0)
#define IGNORE	0
#define INFINITE	0xFFFFFFFF
#define NOPARITY	0
#define ODDPARITY	1
#define EVENPARITY	2
#define MARKPARITY	3
#define SPACEPARITY	4
#define ONESTOPBIT	0
#define ONE5STOPBITS	1
#define TWOSTOPBITS	2
#define CBR_110	110
#define CBR_300	300
#define CBR_600	600
#define CBR_1200	1200
#define CBR_2400	2400
#define CBR_4800	4800
#define CBR_9600	9600
#define CBR_14400	14400
#define CBR_19200	19200
#define CBR_38400	38400
#define CBR_56000	56000
#define CBR_57600	57600
#define CBR_115200	115200
#define CBR_128000	128000
#define CBR_256000	256000
#define BACKUP_INVALID	0
#define BACKUP_DATA 1
#define BACKUP_EA_DATA 2
#define BACKUP_SECURITY_DATA 3
#define BACKUP_ALTERNATE_DATA 4
#define BACKUP_LINK 5
#define BACKUP_PROPERTY_DATA 6
#define BACKUP_OBJECT_ID 7
#define BACKUP_REPARSE_DATA 8
#define BACKUP_SPARSE_BLOCK 9
#define STREAM_NORMAL_ATTRIBUTE 0
#define STREAM_MODIFIED_WHEN_READ 1
#define STREAM_CONTAINS_SECURITY 2
#define STREAM_CONTAINS_PROPERTIES 4
#define STARTF_USESHOWWINDOW 1
#define STARTF_USESIZE 2
#define STARTF_USEPOSITION 4
#define STARTF_USECOUNTCHARS 8
#define STARTF_USEFILLATTRIBUTE 16
#define STARTF_RUNFULLSCREEN 32
#define STARTF_FORCEONFEEDBACK 64
#define STARTF_FORCEOFFFEEDBACK 128
#define STARTF_USESTDHANDLES 256
#define STARTF_USEHOTKEY 512
#define TC_NORMAL 0
#define TC_HARDERR 1
#define TC_GP_TRAP 2
#define TC_SIGNAL 3
#define AC_LINE_OFFLINE 0
#define AC_LINE_ONLINE 1
#define AC_LINE_BACKUP_POWER 2
#define AC_LINE_UNKNOWN 255
#define BATTERY_FLAG_HIGH 1
#define BATTERY_FLAG_LOW 2
#define BATTERY_FLAG_CRITICAL 4
#define BATTERY_FLAG_CHARGING 8
#define BATTERY_FLAG_NO_BATTERY 128
#define BATTERY_FLAG_UNKNOWN 255
#define BATTERY_PERCENTAGE_UNKNOWN 255
#define BATTERY_LIFE_UNKNOWN 0xFFFFFFFF
#define DDD_RAW_TARGET_PATH 1
#define DDD_REMOVE_DEFINITION 2
#define DDD_EXACT_MATCH_ON_REMOVE 4
#define HINSTANCE_ERROR 32
#define MS_CTS_ON 16
#define MS_DSR_ON 32
#define MS_RING_ON 64
#define MS_RLSD_ON 128
#define DTR_CONTROL_DISABLE 0
#define DTR_CONTROL_ENABLE 1
#define DTR_CONTROL_HANDSHAKE 2
#define RTS_CONTROL_DISABLE 0
#define RTS_CONTROL_ENABLE 1
#define RTS_CONTROL_HANDSHAKE 2
#define RTS_CONTROL_TOGGLE 3
#define SECURITY_ANONYMOUS (SecurityAnonymous<<16)
#define SECURITY_IDENTIFICATION (SecurityIdentification<<16)
#define SECURITY_IMPERSONATION (SecurityImpersonation<<16)
#define SECURITY_DELEGATION (SecurityDelegation<<16)
#define SECURITY_CONTEXT_TRACKING 0x40000
#define SECURITY_EFFECTIVE_ONLY 0x80000
#define SECURITY_SQOS_PRESENT 0x100000
#define SECURITY_VALID_SQOS_FLAGS 0x1F0000
#define INVALID_FILE_SIZE 0xFFFFFFFF
#define TLS_OUT_OF_INDEXES (DWORD)0xFFFFFFFF
#define GET_MODULE_HANDLE_EX_FLAG_FROM_ADDRESS 0x00000004
#define GET_MODULE_HANDLE_EX_FLAG_PIN 0x00000001
#define GET_MODULE_HANDLE_EX_FLAG_UNCHANGED_REFCOUNT 0x00000002
#if (_WIN32_WINNT >= 0x0501)
#define ACTCTX_FLAG_PROCESSOR_ARCHITECTURE_VALID 0x00000001
#define ACTCTX_FLAG_LANGID_VALID 0x00000002
#define ACTCTX_FLAG_ASSEMBLY_DIRECTORY_VALID 0x00000004
#define ACTCTX_FLAG_RESOURCE_NAME_VALID 0x00000008
#define ACTCTX_FLAG_SET_PROCESS_DEFAULT 0x00000010
#define ACTCTX_FLAG_APPLICATION_NAME_VALID 0x00000020
#define ACTCTX_FLAG_HMODULE_VALID 0x00000080
#define DEACTIVATE_ACTCTX_FLAG_FORCE_EARLY_DEACTIVATION 0x00000001
#define FIND_ACTCTX_SECTION_KEY_RETURN_HACTCTX 0x00000001
#define QUERY_ACTCTX_FLAG_USE_ACTIVE_ACTCTX 0x00000004
#define QUERY_ACTCTX_FLAG_ACTCTX_IS_HMODULE 0x00000008
#define QUERY_ACTCTX_FLAG_ACTCTX_IS_ADDRESS 0x00000010
#endif /* (_WIN32_WINNT >= 0x0501) */
#if (_WIN32_WINNT >= 0x0500)
#define REPLACEFILE_WRITE_THROUGH 0x00000001
#define REPLACEFILE_IGNORE_MERGE_ERRORS 0x00000002
#endif /* (_WIN32_WINNT >= 0x0500) */
#define WRITE_WATCH_FLAG_RESET 1
#if (_WIN32_WINNT >= 0x0601)
#define PROCESS_DEP_ENABLE 1
#define PROCESS_DEP_DISABLE_ATL_THUNK_EMULATION 2
#endif

#ifndef RC_INVOKED
typedef struct _FILETIME {
	DWORD dwLowDateTime;
	DWORD dwHighDateTime;
} FILETIME,*PFILETIME,*LPFILETIME;
typedef struct _BY_HANDLE_FILE_INFORMATION {
	DWORD	dwFileAttributes;
	FILETIME	ftCreationTime;
	FILETIME	ftLastAccessTime;
	FILETIME	ftLastWriteTime;
	DWORD	dwVolumeSerialNumber;
	DWORD	nFileSizeHigh;
	DWORD	nFileSizeLow;
	DWORD	nNumberOfLinks;
	DWORD	nFileIndexHigh;
	DWORD	nFileIndexLow;
} BY_HANDLE_FILE_INFORMATION,*LPBY_HANDLE_FILE_INFORMATION;
typedef struct _DCB {
	DWORD DCBlength;
	DWORD BaudRate;
	DWORD fBinary:1;
	DWORD fParity:1;
	DWORD fOutxCtsFlow:1;
	DWORD fOutxDsrFlow:1;
	DWORD fDtrControl:2;
	DWORD fDsrSensitivity:1;
	DWORD fTXContinueOnXoff:1;
	DWORD fOutX:1;
	DWORD fInX:1;
	DWORD fErrorChar:1;
	DWORD fNull:1;
	DWORD fRtsControl:2;
	DWORD fAbortOnError:1;
	DWORD fDummy2:17;
	WORD wReserved;
	WORD XonLim;
	WORD XoffLim;
	BYTE ByteSize;
	BYTE Parity;
	BYTE StopBits;
	char XonChar;
	char XoffChar;
	char ErrorChar;
	char EofChar;
	char EvtChar;
	WORD wReserved1;
} DCB,*LPDCB;
typedef struct _COMM_CONFIG {
	DWORD dwSize;
	WORD  wVersion;
	WORD  wReserved;
	DCB   dcb;
	DWORD dwProviderSubType;
	DWORD dwProviderOffset;
	DWORD dwProviderSize;
	WCHAR wcProviderData[1];
} COMMCONFIG,*LPCOMMCONFIG;
typedef struct _COMMPROP {
	WORD	wPacketLength;
	WORD	wPacketVersion;
	DWORD	dwServiceMask;
	DWORD	dwReserved1;
	DWORD	dwMaxTxQueue;
	DWORD	dwMaxRxQueue;
	DWORD	dwMaxBaud;
	DWORD	dwProvSubType;
	DWORD	dwProvCapabilities;
	DWORD	dwSettableParams;
	DWORD	dwSettableBaud;
	WORD	wSettableData;
	WORD	wSettableStopParity;
	DWORD	dwCurrentTxQueue;
	DWORD	dwCurrentRxQueue;
	DWORD	dwProvSpec1;
	DWORD	dwProvSpec2;
	WCHAR	wcProvChar[1];
} COMMPROP,*LPCOMMPROP;
typedef struct _COMMTIMEOUTS {
	DWORD ReadIntervalTimeout;
	DWORD ReadTotalTimeoutMultiplier;
	DWORD ReadTotalTimeoutConstant;
	DWORD WriteTotalTimeoutMultiplier;
	DWORD WriteTotalTimeoutConstant;
} COMMTIMEOUTS,*LPCOMMTIMEOUTS;
typedef struct _COMSTAT {
	DWORD fCtsHold:1;
	DWORD fDsrHold:1;
	DWORD fRlsdHold:1;
	DWORD fXoffHold:1;
	DWORD fXoffSent:1;
	DWORD fEof:1;
	DWORD fTxim:1;
	DWORD fReserved:25;
	DWORD cbInQue;
	DWORD cbOutQue;
} COMSTAT,*LPCOMSTAT;
typedef DWORD (WINAPI *LPTHREAD_START_ROUTINE)(LPVOID);
typedef struct _CREATE_PROCESS_DEBUG_INFO {
	HANDLE hFile;
	HANDLE hProcess;
	HANDLE hThread;
	LPVOID lpBaseOfImage;
	DWORD dwDebugInfoFileOffset;
	DWORD nDebugInfoSize;
	LPVOID lpThreadLocalBase;
	LPTHREAD_START_ROUTINE lpStartAddress;
	LPVOID lpImageName;
	WORD fUnicode;
} CREATE_PROCESS_DEBUG_INFO,*LPCREATE_PROCESS_DEBUG_INFO;
typedef struct _CREATE_THREAD_DEBUG_INFO {
	HANDLE hThread;
	LPVOID lpThreadLocalBase;
	LPTHREAD_START_ROUTINE lpStartAddress;
} CREATE_THREAD_DEBUG_INFO,*LPCREATE_THREAD_DEBUG_INFO;
typedef struct _EXCEPTION_DEBUG_INFO {
	EXCEPTION_RECORD ExceptionRecord;
	DWORD dwFirstChance;
} EXCEPTION_DEBUG_INFO,*LPEXCEPTION_DEBUG_INFO;
typedef struct _EXIT_THREAD_DEBUG_INFO {
	DWORD dwExitCode;
} EXIT_THREAD_DEBUG_INFO,*LPEXIT_THREAD_DEBUG_INFO;
typedef struct _EXIT_PROCESS_DEBUG_INFO {
	DWORD dwExitCode;
} EXIT_PROCESS_DEBUG_INFO,*LPEXIT_PROCESS_DEBUG_INFO;
typedef struct _LOAD_DLL_DEBUG_INFO {
	HANDLE hFile;
	LPVOID lpBaseOfDll;
	DWORD dwDebugInfoFileOffset;
	DWORD nDebugInfoSize;
	LPVOID lpImageName;
	WORD fUnicode;
} LOAD_DLL_DEBUG_INFO,*LPLOAD_DLL_DEBUG_INFO;
typedef struct _UNLOAD_DLL_DEBUG_INFO {
	LPVOID lpBaseOfDll;
} UNLOAD_DLL_DEBUG_INFO,*LPUNLOAD_DLL_DEBUG_INFO;
typedef struct _OUTPUT_DEBUG_STRING_INFO {
	LPSTR lpDebugStringData;
	WORD fUnicode;
	WORD nDebugStringLength;
} OUTPUT_DEBUG_STRING_INFO,*LPOUTPUT_DEBUG_STRING_INFO;
typedef struct _RIP_INFO {
	DWORD dwError;
	DWORD dwType;
} RIP_INFO,*LPRIP_INFO;
typedef struct _DEBUG_EVENT {
	DWORD dwDebugEventCode;
	DWORD dwProcessId;
	DWORD dwThreadId;
	union {
		EXCEPTION_DEBUG_INFO Exception;
		CREATE_THREAD_DEBUG_INFO CreateThread;
		CREATE_PROCESS_DEBUG_INFO CreateProcessInfo;
		EXIT_THREAD_DEBUG_INFO ExitThread;
		EXIT_PROCESS_DEBUG_INFO ExitProcess;
		LOAD_DLL_DEBUG_INFO LoadDll;
		UNLOAD_DLL_DEBUG_INFO UnloadDll;
		OUTPUT_DEBUG_STRING_INFO DebugString;
		RIP_INFO RipInfo;
	} u;
} DEBUG_EVENT,*LPDEBUG_EVENT;
typedef struct _OVERLAPPED {
	ULONG_PTR Internal;
	ULONG_PTR InternalHigh;
	DWORD Offset;
	DWORD OffsetHigh;
	HANDLE hEvent;
} OVERLAPPED,*POVERLAPPED,*LPOVERLAPPED;
typedef struct _STARTUPINFOA {
	DWORD	cb;
	LPSTR	lpReserved;
	LPSTR	lpDesktop;
	LPSTR	lpTitle;
	DWORD	dwX;
	DWORD	dwY;
	DWORD	dwXSize;
	DWORD	dwYSize;
	DWORD	dwXCountChars;
	DWORD	dwYCountChars;
	DWORD	dwFillAttribute;
	DWORD	dwFlags;
	WORD	wShowWindow;
	WORD	cbReserved2;
	PBYTE	lpReserved2;
	HANDLE	hStdInput;
	HANDLE	hStdOutput;
	HANDLE	hStdError;
} STARTUPINFOA,*LPSTARTUPINFOA;
typedef struct _STARTUPINFOW {
	DWORD	cb;
	LPWSTR	lpReserved;
	LPWSTR	lpDesktop;
	LPWSTR	lpTitle;
	DWORD	dwX;
	DWORD	dwY;
	DWORD	dwXSize;
	DWORD	dwYSize;
	DWORD	dwXCountChars;
	DWORD	dwYCountChars;
	DWORD	dwFillAttribute;
	DWORD	dwFlags;
	WORD	wShowWindow;
	WORD	cbReserved2;
	PBYTE	lpReserved2;
	HANDLE	hStdInput;
	HANDLE	hStdOutput;
	HANDLE	hStdError;
} STARTUPINFOW,*LPSTARTUPINFOW;
typedef struct _PROCESS_INFORMATION {
	HANDLE hProcess;
	HANDLE hThread;
	DWORD dwProcessId;
	DWORD dwThreadId;
} PROCESS_INFORMATION,*PPROCESS_INFORMATION,*LPPROCESS_INFORMATION;
typedef struct _CRITICAL_SECTION_DEBUG {
	WORD Type;
	WORD CreatorBackTraceIndex;
	struct _CRITICAL_SECTION *CriticalSection;
	LIST_ENTRY ProcessLocksList;
	DWORD EntryCount;
	DWORD ContentionCount;
	DWORD Spare [2];
} CRITICAL_SECTION_DEBUG,*PCRITICAL_SECTION_DEBUG;
typedef struct _CRITICAL_SECTION {
	PCRITICAL_SECTION_DEBUG DebugInfo;
	LONG LockCount;
	LONG RecursionCount;
	HANDLE OwningThread;
	HANDLE LockSemaphore;
	DWORD SpinCount;
} CRITICAL_SECTION,*PCRITICAL_SECTION,*LPCRITICAL_SECTION;
typedef struct _SYSTEMTIME {
	WORD wYear;
	WORD wMonth;
	WORD wDayOfWeek;
	WORD wDay;
	WORD wHour;
	WORD wMinute;
	WORD wSecond;
	WORD wMilliseconds;
} SYSTEMTIME,*LPSYSTEMTIME;
typedef struct _WIN32_FILE_ATTRIBUTE_DATA {
	DWORD	dwFileAttributes;
	FILETIME	ftCreationTime;
	FILETIME	ftLastAccessTime;
	FILETIME	ftLastWriteTime;
	DWORD	nFileSizeHigh;
	DWORD	nFileSizeLow;
} WIN32_FILE_ATTRIBUTE_DATA,*LPWIN32_FILE_ATTRIBUTE_DATA;
typedef struct _WIN32_FIND_DATAA {
	DWORD dwFileAttributes;
	FILETIME ftCreationTime;
	FILETIME ftLastAccessTime;
	FILETIME ftLastWriteTime;
	DWORD nFileSizeHigh;
	DWORD nFileSizeLow;
#ifdef _WIN32_WCE
    DWORD dwOID; 
#else
	DWORD dwReserved0;
	DWORD dwReserved1;
#endif
	CHAR cFileName[MAX_PATH];
#ifndef _WIN32_WCE
	CHAR cAlternateFileName[14];
#endif
} WIN32_FIND_DATAA,*PWIN32_FIND_DATAA,*LPWIN32_FIND_DATAA;
typedef struct _WIN32_FIND_DATAW {
	DWORD dwFileAttributes;
	FILETIME ftCreationTime;
	FILETIME ftLastAccessTime;
	FILETIME ftLastWriteTime;
	DWORD nFileSizeHigh;
	DWORD nFileSizeLow;
#ifdef _WIN32_WCE
    DWORD dwOID; 
#else
	DWORD dwReserved0;
	DWORD dwReserved1;
#endif
	WCHAR cFileName[MAX_PATH];
#ifndef _WIN32_WCE
	WCHAR cAlternateFileName[14];
#endif
} WIN32_FIND_DATAW,*PWIN32_FIND_DATAW,*LPWIN32_FIND_DATAW;
typedef struct _WIN32_STREAM_ID {
	DWORD dwStreamId;
	DWORD dwStreamAttributes;
	LARGE_INTEGER Size;
	DWORD dwStreamNameSize;
	WCHAR cStreamName[ANYSIZE_ARRAY];
} WIN32_STREAM_ID, *LPWIN32_STREAM_ID;
typedef enum _FINDEX_INFO_LEVELS {
	FindExInfoStandard,
	FindExInfoMaxInfoLevel
} FINDEX_INFO_LEVELS;
typedef enum _FINDEX_SEARCH_OPS {
	FindExSearchNameMatch,
	FindExSearchLimitToDirectories,
	FindExSearchLimitToDevices,
	FindExSearchMaxSearchOp
} FINDEX_SEARCH_OPS;
typedef enum _ACL_INFORMATION_CLASS {
	AclRevisionInformation=1,
	AclSizeInformation
} ACL_INFORMATION_CLASS;
typedef struct tagHW_PROFILE_INFOA {
	DWORD dwDockInfo;
	CHAR szHwProfileGuid[HW_PROFILE_GUIDLEN];
	CHAR szHwProfileName[MAX_PROFILE_LEN];
} HW_PROFILE_INFOA,*LPHW_PROFILE_INFOA;
typedef struct tagHW_PROFILE_INFOW {
	DWORD dwDockInfo;
	WCHAR szHwProfileGuid[HW_PROFILE_GUIDLEN];
	WCHAR szHwProfileName[MAX_PROFILE_LEN];
} HW_PROFILE_INFOW,*LPHW_PROFILE_INFOW;
typedef enum _GET_FILEEX_INFO_LEVELS {
	GetFileExInfoStandard,
	GetFileExMaxInfoLevel
} GET_FILEEX_INFO_LEVELS;
typedef struct _SYSTEM_INFO {
	_ANONYMOUS_UNION union {
		DWORD dwOemId;
		_ANONYMOUS_STRUCT struct {
			WORD wProcessorArchitecture;
			WORD wReserved;
		} DUMMYSTRUCTNAME;
	} DUMMYUNIONNAME;
	DWORD dwPageSize;
	PVOID lpMinimumApplicationAddress;
	PVOID lpMaximumApplicationAddress;
	DWORD dwActiveProcessorMask;
	DWORD dwNumberOfProcessors;
	DWORD dwProcessorType;
	DWORD dwAllocationGranularity;
	WORD wProcessorLevel;
	WORD wProcessorRevision;
} SYSTEM_INFO,*LPSYSTEM_INFO;
typedef struct _SYSTEM_POWER_STATUS {
	BYTE ACLineStatus;
	BYTE BatteryFlag;
	BYTE BatteryLifePercent;
	BYTE Reserved1;
	DWORD BatteryLifeTime;
	DWORD BatteryFullLifeTime;
} SYSTEM_POWER_STATUS,*LPSYSTEM_POWER_STATUS;
typedef struct _TIME_ZONE_INFORMATION {
	LONG Bias;
	WCHAR StandardName[32];
	SYSTEMTIME StandardDate;
	LONG StandardBias;
	WCHAR DaylightName[32];
	SYSTEMTIME DaylightDate;
	LONG DaylightBias;
} TIME_ZONE_INFORMATION,*LPTIME_ZONE_INFORMATION;
typedef struct _MEMORYSTATUS {
	DWORD dwLength;
	DWORD dwMemoryLoad;
	DWORD dwTotalPhys;
	DWORD dwAvailPhys;
	DWORD dwTotalPageFile;
	DWORD dwAvailPageFile;
	DWORD dwTotalVirtual;
	DWORD dwAvailVirtual;
} MEMORYSTATUS,*LPMEMORYSTATUS;
#if (_WIN32_WINNT >= 0x0500)
typedef struct _MEMORYSTATUSEX {
	DWORD dwLength;
	DWORD dwMemoryLoad;
	DWORDLONG ullTotalPhys;
	DWORDLONG ullAvailPhys;
	DWORDLONG ullTotalPageFile;
	DWORDLONG ullAvailPageFile;
	DWORDLONG ullTotalVirtual;
	DWORDLONG ullAvailVirtual;
	DWORDLONG ullAvailExtendedVirtual;
} MEMORYSTATUSEX,*LPMEMORYSTATUSEX;
#endif
typedef struct _LDT_ENTRY {
	WORD LimitLow;
	WORD BaseLow;
	union {
		struct {
			BYTE BaseMid;
			BYTE Flags1;
			BYTE Flags2;
			BYTE BaseHi;
		} Bytes;
		struct {
			DWORD BaseMid:8;
			DWORD Type:5;
			DWORD Dpl:2;
			DWORD Pres:1;
			DWORD LimitHi:4;
			DWORD Sys:1;
			DWORD Reserved_0:1;
			DWORD Default_Big:1;
			DWORD Granularity:1;
			DWORD BaseHi:8;
		} Bits;
	} HighWord;
} LDT_ENTRY,*PLDT_ENTRY,*LPLDT_ENTRY;
typedef struct _PROCESS_HEAP_ENTRY {
	PVOID lpData;
	DWORD cbData;
	BYTE cbOverhead;
	BYTE iRegionIndex;
	WORD wFlags;
	_ANONYMOUS_UNION union {
		struct {
			HANDLE hMem;
			DWORD dwReserved[3];
		} Block;
		struct {
			DWORD dwCommittedSize;
			DWORD dwUnCommittedSize;
			LPVOID lpFirstBlock;
			LPVOID lpLastBlock;
		} Region;
	} DUMMYUNIONNAME;
} PROCESS_HEAP_ENTRY,*LPPROCESS_HEAP_ENTRY;
typedef struct _OFSTRUCT {
	BYTE cBytes;
	BYTE fFixedDisk;
	WORD nErrCode;
	WORD Reserved1;
	WORD Reserved2;
	CHAR szPathName[OFS_MAXPATHNAME];
} OFSTRUCT,*LPOFSTRUCT,*POFSTRUCT;
typedef struct _WIN_CERTIFICATE {
      DWORD dwLength;
      WORD wRevision;
      WORD wCertificateType;
      BYTE bCertificate[1];
} WIN_CERTIFICATE, *LPWIN_CERTIFICATE;
#if (_WIN32_WINNT >= 0x0501)
typedef struct tagACTCTXA {
	ULONG cbSize;
	DWORD dwFlags;
	LPCSTR lpSource;
	USHORT wProcessorArchitecture;
	LANGID wLangId;
	LPCSTR lpAssemblyDirectory;
	LPCSTR lpResourceName;
	LPCSTR lpApplicationName;
	HMODULE hModule;
} ACTCTXA,*PACTCTXA;
typedef const ACTCTXA *PCACTCTXA;
typedef struct tagACTCTXW {
	ULONG cbSize;
	DWORD dwFlags;
	LPCWSTR lpSource;
	USHORT wProcessorArchitecture;
	LANGID wLangId;
	LPCWSTR lpAssemblyDirectory;
	LPCWSTR lpResourceName;
	LPCWSTR lpApplicationName;
	HMODULE hModule;
} ACTCTXW,*PACTCTXW;
typedef const ACTCTXW *PCACTCTXW;
typedef struct tagACTCTX_SECTION_KEYED_DATA {
	ULONG cbSize;
	ULONG ulDataFormatVersion;
	PVOID lpData;
	ULONG ulLength;
	PVOID lpSectionGlobalData;
	ULONG ulSectionGlobalDataLength;
	PVOID lpSectionBase;
	ULONG ulSectionTotalLength;
	HANDLE hActCtx;
	HANDLE ulAssemblyRosterIndex;
} ACTCTX_SECTION_KEYED_DATA,*PACTCTX_SECTION_KEYED_DATA;
typedef const ACTCTX_SECTION_KEYED_DATA *PCACTCTX_SECTION_KEYED_DATA;
typedef enum {
	LowMemoryResourceNotification ,
	HighMemoryResourceNotification
} MEMORY_RESOURCE_NOTIFICATION_TYPE;
#endif
#if (_WIN32_WINNT >= 0x0500)
typedef enum _COMPUTER_NAME_FORMAT {
	ComputerNameNetBIOS, 
	ComputerNameDnsHostname, 
	ComputerNameDnsDomain, 
	ComputerNameDnsFullyQualified, 
	ComputerNamePhysicalNetBIOS, 
	ComputerNamePhysicalDnsHostname, 
	ComputerNamePhysicalDnsDomain, 
	ComputerNamePhysicalDnsFullyQualified, 
	ComputerNameMax
} COMPUTER_NAME_FORMAT;
#endif
#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0410)
typedef DWORD EXECUTION_STATE;
#endif
#if (_WIN32_WINNT >= 0x0601)
typedef enum _DEP_SYSTEM_POLICY_TYPE {
	AlwaysOn,
	AlwaysOff,
	OptIn,
	OptOut 
} DEP_SYSTEM_POLICY_TYPE;
#endif

typedef DWORD(WINAPI *LPPROGRESS_ROUTINE)(LARGE_INTEGER,LARGE_INTEGER,LARGE_INTEGER,LARGE_INTEGER,DWORD,DWORD,HANDLE,HANDLE,LPVOID);
typedef void(WINAPI *LPFIBER_START_ROUTINE)(PVOID);
typedef BOOL(CALLBACK *ENUMRESLANGPROCA)(HMODULE,LPCSTR,LPCSTR,WORD,LONG);
typedef BOOL(CALLBACK *ENUMRESLANGPROCW)(HMODULE,LPCWSTR,LPCWSTR,WORD,LONG);
#ifdef UNICODE
#define ENUMRESLANGPROC ENUMRESLANGPROCW
#else
#define ENUMRESLANGPROC ENUMRESLANGPROCA
#endif
typedef BOOL(CALLBACK *ENUMRESNAMEPROCA)(HMODULE,LPCSTR,LPSTR,LONG);
typedef BOOL(CALLBACK *ENUMRESNAMEPROCW)(HMODULE,LPCWSTR,LPWSTR,LONG);
#ifdef UNICODE
#define ENUMRESNAMEPROC ENUMRESNAMEPROCW
#else
#define ENUMRESNAMEPROC ENUMRESNAMEPROCA
#endif
typedef BOOL(CALLBACK *ENUMRESTYPEPROCA)(HMODULE,LPSTR,LONG);
typedef BOOL(CALLBACK *ENUMRESTYPEPROCW)(HMODULE,LPWSTR,LONG);
#ifdef UNICODE
#define ENUMRESTYPEPROC ENUMRESTYPEPROCW
#else
#define ENUMRESTYPEPROC ENUMRESTYPEPROCA
#endif
typedef void(CALLBACK *LPOVERLAPPED_COMPLETION_ROUTINE)(DWORD,DWORD,LPOVERLAPPED);
typedef LONG(CALLBACK *PTOP_LEVEL_EXCEPTION_FILTER)(LPEXCEPTION_POINTERS);
typedef PTOP_LEVEL_EXCEPTION_FILTER LPTOP_LEVEL_EXCEPTION_FILTER;
typedef void(APIENTRY *PAPCFUNC)(ULONG_PTR);
typedef void(CALLBACK *PTIMERAPCROUTINE)(PVOID,DWORD,DWORD);
#if (_WIN32_WINNT >= 0x0500)
typedef void(CALLBACK *WAITORTIMERCALLBACK)(PVOID,BOOLEAN);   
#endif
#define MAKEINTATOM(i) (LPTSTR)((DWORD)((WORD)(i)))
/* Functions */
#ifndef UNDER_CE
int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hInstance1,LPSTR args,int n);
#else
int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hInstance1,LPWSTR args,int n);
#endif
int APIENTRY wWinMain(HINSTANCE hInst,HINSTANCE hInst1,LPWSTR args,int n);
WINBASEAPI long WINAPI _hread(HFILE a,LPVOID b,long c){}
WINBASEAPI long WINAPI _hwrite(HFILE a,LPCSTR b,long c){}
WINBASEAPI HFILE WINAPI _lclose(HFILE a){}
WINBASEAPI HFILE WINAPI _lcreat(LPCSTR a,int b){}
WINBASEAPI LONG WINAPI _llseek(HFILE a,LONG b,int c){}
WINBASEAPI HFILE WINAPI _lopen(LPCSTR a,int b){}
WINBASEAPI UINT WINAPI _lread(HFILE a,LPVOID b,UINT c){}
WINBASEAPI UINT WINAPI _lwrite(HFILE a,LPCSTR b,UINT c){}
#define AbnormalTermination() FALSE
WINBASEAPI BOOL WINAPI AccessCheck(PSECURITY_DESCRIPTOR a,HANDLE b,DWORD c,PGENERIC_MAPPING d,PPRIVILEGE_SET e,PDWORD f,PDWORD g,PBOOL h){}
WINBASEAPI BOOL WINAPI AccessCheckAndAuditAlarmA(LPCSTR a,LPVOID b,LPSTR c,LPSTR d,PSECURITY_DESCRIPTOR e,DWORD f,PGENERIC_MAPPING g,BOOL h,PDWORD i,PBOOL j,PBOOL k){}
WINBASEAPI BOOL WINAPI AccessCheckAndAuditAlarmW(LPCWSTR a,LPVOID b,LPWSTR c,LPWSTR d,PSECURITY_DESCRIPTOR e,DWORD f,PGENERIC_MAPPING g,BOOL h,PDWORD i,PBOOL j,PBOOL k){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI ActivateActCtx(HANDLE a,ULONG_PTR* b){}
#endif
WINBASEAPI BOOL WINAPI AddAccessAllowedAce(PACL a,DWORD b,DWORD c,PSID d){}
WINBASEAPI BOOL WINAPI AddAccessDeniedAce(PACL a,DWORD b,DWORD c,PSID d){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI AddAccessAllowedAceEx(PACL a,DWORD b,DWORD c,DWORD d,PSID e){}
WINBASEAPI BOOL WINAPI AddAccessDeniedAceEx(PACL a,DWORD b,DWORD c,DWORD d,PSID e){}
#endif
WINBASEAPI BOOL WINAPI AddAce(PACL a,DWORD b,DWORD c,PVOID d,DWORD e){}
WINBASEAPI ATOM WINAPI AddAtomA(LPCSTR a){}
WINBASEAPI ATOM WINAPI AddAtomW(LPCWSTR a){}
WINBASEAPI BOOL WINAPI AddAuditAccessAce(PACL a,DWORD b,DWORD c,PSID d,BOOL e,BOOL f){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI void WINAPI AddRefActCtx(HANDLE a){}
#endif
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI PVOID WINAPI AddVectoredExceptionHandler(ULONG a,PVECTORED_EXCEPTION_HANDLER b){}
#endif
WINBASEAPI BOOL WINAPI AdjustTokenGroups(HANDLE a,BOOL b,PTOKEN_GROUPS c,DWORD d,PTOKEN_GROUPS e,PDWORD f){}
WINBASEAPI BOOL WINAPI AdjustTokenPrivileges(HANDLE a,BOOL b,PTOKEN_PRIVILEGES c,DWORD d,PTOKEN_PRIVILEGES e,PDWORD f){}
WINBASEAPI BOOL WINAPI AllocateAndInitializeSid(PSID_IDENTIFIER_AUTHORITY a,BYTE b,DWORD c,DWORD d,DWORD e,DWORD f,DWORD g,DWORD h,DWORD i,DWORD j,PSID* k){}
WINBASEAPI BOOL WINAPI AllocateLocallyUniqueId(PLUID a){}
WINBASEAPI BOOL WINAPI AreAllAccessesGranted(DWORD a,DWORD b){}
WINBASEAPI BOOL WINAPI AreAnyAccessesGranted(DWORD a,DWORD b){}
WINBASEAPI BOOL WINAPI AreFileApisANSI(void){}
WINBASEAPI BOOL WINAPI BackupEventLogA(HANDLE a,LPCSTR b){}
WINBASEAPI BOOL WINAPI BackupEventLogW(HANDLE a,LPCWSTR b){}
WINBASEAPI BOOL WINAPI BackupRead(HANDLE a,LPBYTE b,DWORD c,LPDWORD d,BOOL e,BOOL f,LPVOID* g){}
WINBASEAPI BOOL WINAPI BackupSeek(HANDLE a,DWORD b,DWORD c,LPDWORD d,LPDWORD e,LPVOID* f){}
WINBASEAPI BOOL WINAPI BackupWrite(HANDLE a,LPBYTE b,DWORD c,LPDWORD d,BOOL e,BOOL f,LPVOID* g){}
WINBASEAPI BOOL WINAPI Beep(DWORD a,DWORD b){}
WINBASEAPI HANDLE WINAPI BeginUpdateResourceA(LPCSTR a,BOOL b){}
WINBASEAPI HANDLE WINAPI BeginUpdateResourceW(LPCWSTR a,BOOL b){}
WINBASEAPI BOOL WINAPI BuildCommDCBA(LPCSTR a,LPDCB b){}
WINBASEAPI BOOL WINAPI BuildCommDCBW(LPCWSTR a,LPDCB b){}
WINBASEAPI BOOL WINAPI BuildCommDCBAndTimeoutsA(LPCSTR a,LPDCB b,LPCOMMTIMEOUTS c){}
WINBASEAPI BOOL WINAPI BuildCommDCBAndTimeoutsW(LPCWSTR a,LPDCB b,LPCOMMTIMEOUTS c){}
WINBASEAPI BOOL WINAPI CallNamedPipeA(LPCSTR a,PVOID b,DWORD c,PVOID d,DWORD e,PDWORD f,DWORD g){}
WINBASEAPI BOOL WINAPI CallNamedPipeW(LPCWSTR a,PVOID b,DWORD c,PVOID d,DWORD e,PDWORD f,DWORD g){}
WINBASEAPI BOOL WINAPI CancelDeviceWakeupRequest(HANDLE a){}
WINBASEAPI BOOL WINAPI CancelIo(HANDLE a){}
WINBASEAPI BOOL WINAPI CancelWaitableTimer(HANDLE a){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI ChangeTimerQueueTimer(HANDLE a,HANDLE b,ULONG c,ULONG d){}
#endif
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI CheckNameLegalDOS8Dot3A(LPCSTR a,LPSTR b,DWORD c,PBOOL d,PBOOL e){}
WINBASEAPI BOOL WINAPI CheckNameLegalDOS8Dot3W(LPCWSTR a,LPSTR b,DWORD c,PBOOL d,PBOOL e){}
WINBASEAPI BOOL WINAPI CheckRemoteDebuggerPresent(HANDLE a,PBOOL b){}
#endif
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI CheckTokenMembership(HANDLE a,PSID b,PBOOL c){}
#endif
WINBASEAPI BOOL WINAPI ClearCommBreak(HANDLE a){}
WINBASEAPI BOOL WINAPI ClearCommError(HANDLE a,PDWORD b,LPCOMSTAT c){}
WINBASEAPI BOOL WINAPI ClearEventLogA(HANDLE a,LPCSTR b){}
WINBASEAPI BOOL WINAPI ClearEventLogW(HANDLE a,LPCWSTR b){}
WINBASEAPI BOOL WINAPI CloseEventLog(HANDLE a){}
WINBASEAPI BOOL WINAPI CloseHandle(HANDLE a){}
WINBASEAPI BOOL WINAPI CommConfigDialogA(LPCSTR a,HWND b,LPCOMMCONFIG c){}
WINBASEAPI BOOL WINAPI CommConfigDialogW(LPCWSTR a,HWND b,LPCOMMCONFIG c){}
WINBASEAPI LONG WINAPI CompareFileTime(CONST FILETIME* a,CONST FILETIME* b){}
WINBASEAPI BOOL WINAPI ConnectNamedPipe(HANDLE a,LPOVERLAPPED b){}
WINBASEAPI BOOL WINAPI ContinueDebugEvent(DWORD a,DWORD b,DWORD c){}
#if (_WIN32_WINNT >= 0x0400)
WINBASEAPI BOOL WINAPI ConvertFiberToThread(void){}
#endif
WINBASEAPI PVOID WINAPI ConvertThreadToFiber(PVOID a){}
WINBASEAPI BOOL WINAPI CopyFileA(LPCSTR a,LPCSTR b,BOOL c){}
WINBASEAPI BOOL WINAPI CopyFileW(LPCWSTR a,LPCWSTR b,BOOL c){}
WINBASEAPI BOOL WINAPI CopyFileExA(LPCSTR a,LPCSTR b,LPPROGRESS_ROUTINE c,LPVOID d,LPBOOL e,DWORD f){}
WINBASEAPI BOOL WINAPI CopyFileExW(LPCWSTR a,LPCWSTR b,LPPROGRESS_ROUTINE c,LPVOID d,LPBOOL e,DWORD f){}
#define RtlMoveMemory memmove
#define RtlCopyMemory memcpy
#define RtlFillMemory(d,l,f) memset((d), (f), (l))
#define RtlZeroMemory(d,l) RtlFillMemory((d),(l),0)
#define MoveMemory RtlMoveMemory
#define CopyMemory RtlCopyMemory
#define FillMemory RtlFillMemory
#define ZeroMemory RtlZeroMemory
WINBASEAPI BOOL WINAPI CopySid(DWORD a,PSID b,PSID c){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI HANDLE WINAPI CreateActCtxA(PCACTCTXA a){}
WINBASEAPI HANDLE WINAPI CreateActCtxW(PCACTCTXW a){}
#endif
WINBASEAPI BOOL WINAPI CreateDirectoryA(LPCSTR a,LPSECURITY_ATTRIBUTES b){}
WINBASEAPI BOOL WINAPI CreateDirectoryW(LPCWSTR a,LPSECURITY_ATTRIBUTES b){}
WINBASEAPI BOOL WINAPI CreateDirectoryExA(LPCSTR a,LPCSTR b,LPSECURITY_ATTRIBUTES c){}
WINBASEAPI BOOL WINAPI CreateDirectoryExW(LPCWSTR a,LPCWSTR b,LPSECURITY_ATTRIBUTES c){}
WINBASEAPI HANDLE WINAPI CreateEventA(LPSECURITY_ATTRIBUTES a,BOOL b,BOOL c,LPCSTR d){}
WINBASEAPI HANDLE WINAPI CreateEventW(LPSECURITY_ATTRIBUTES a,BOOL b,BOOL c,LPCWSTR d){}
WINBASEAPI LPVOID WINAPI CreateFiber(SIZE_T a,LPFIBER_START_ROUTINE b,LPVOID c){}
#if (_WIN32_WINNT >= 0x0400)
WINBASEAPI LPVOID WINAPI CreateFiberEx(SIZE_T a,SIZE_T b,DWORD c,LPFIBER_START_ROUTINE d,LPVOID e){}
#endif
WINBASEAPI HANDLE WINAPI CreateFileA(LPCSTR a,DWORD b,DWORD c,LPSECURITY_ATTRIBUTES d,DWORD e,DWORD f,HANDLE g){}
WINBASEAPI HANDLE WINAPI CreateFileW(LPCWSTR a,DWORD b,DWORD c,LPSECURITY_ATTRIBUTES d,DWORD e,DWORD f,HANDLE g){}
WINBASEAPI HANDLE WINAPI CreateFileMappingA(HANDLE a,LPSECURITY_ATTRIBUTES b,DWORD c,DWORD d,DWORD e,LPCSTR f){}
WINBASEAPI HANDLE WINAPI CreateFileMappingW(HANDLE a,LPSECURITY_ATTRIBUTES b,DWORD c,DWORD d,DWORD e,LPCWSTR f){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI CreateHardLinkA(LPCSTR a,LPCSTR b,LPSECURITY_ATTRIBUTES c){}
WINBASEAPI BOOL WINAPI CreateHardLinkW(LPCWSTR a,LPCWSTR b,LPSECURITY_ATTRIBUTES c){}
#endif
WINBASEAPI HANDLE WINAPI CreateIoCompletionPort(HANDLE a,HANDLE b,ULONG_PTR c,DWORD d){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI HANDLE WINAPI CreateJobObjectA(LPSECURITY_ATTRIBUTES a,LPCSTR b){}
WINBASEAPI HANDLE WINAPI CreateJobObjectW(LPSECURITY_ATTRIBUTES a,LPCWSTR b){}
WINBASEAPI BOOL WINAPI TerminateJobObject(HANDLE a,UINT b){}
WINBASEAPI BOOL WINAPI AssignProcessToJobObject(HANDLE a,HANDLE b){}
WINBASEAPI BOOL WINAPI SetInformationJobObject(HANDLE a, JOBOBJECTINFOCLASS b, LPVOID c, DWORD d){}
WINBASEAPI BOOL WINAPI QueryInformationJobObject(HANDLE a, JOBOBJECTINFOCLASS b, LPVOID c, DWORD d, LPDWORD e){}
#endif
WINBASEAPI HANDLE WINAPI CreateMailslotA(LPCSTR a,DWORD b,DWORD c,LPSECURITY_ATTRIBUTES d){}
WINBASEAPI HANDLE WINAPI CreateMailslotW(LPCWSTR a,DWORD b,DWORD c,LPSECURITY_ATTRIBUTES d){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI HANDLE WINAPI CreateMemoryResourceNotification(MEMORY_RESOURCE_NOTIFICATION_TYPE a){}
#endif
WINBASEAPI HANDLE WINAPI CreateMutexA(LPSECURITY_ATTRIBUTES a,BOOL b,LPCSTR c){}
WINBASEAPI HANDLE WINAPI CreateMutexW(LPSECURITY_ATTRIBUTES a,BOOL b,LPCWSTR c){}
WINBASEAPI HANDLE WINAPI CreateNamedPipeA(LPCSTR a,DWORD b,DWORD c,DWORD d,DWORD e,DWORD f,DWORD g,LPSECURITY_ATTRIBUTES h){}
WINBASEAPI HANDLE WINAPI CreateNamedPipeW(LPCWSTR a,DWORD b,DWORD c,DWORD d,DWORD e,DWORD f,DWORD g,LPSECURITY_ATTRIBUTES h){}
WINBASEAPI BOOL WINAPI CreatePipe(PHANDLE a,PHANDLE b,LPSECURITY_ATTRIBUTES c,DWORD d){}
WINBASEAPI BOOL WINAPI CreatePrivateObjectSecurity(PSECURITY_DESCRIPTOR a,PSECURITY_DESCRIPTOR b,PSECURITY_DESCRIPTOR* c,BOOL d,HANDLE e,PGENERIC_MAPPING f){}
WINBASEAPI BOOL WINAPI CreateProcessA(LPCSTR a,LPSTR b,LPSECURITY_ATTRIBUTES c,LPSECURITY_ATTRIBUTES d,BOOL e,DWORD f,PVOID g,LPCSTR h,LPSTARTUPINFOA i,LPPROCESS_INFORMATION j){}
WINBASEAPI BOOL WINAPI CreateProcessW(LPCWSTR a,LPWSTR b,LPSECURITY_ATTRIBUTES c,LPSECURITY_ATTRIBUTES d,BOOL e,DWORD f,PVOID g,LPCWSTR h,LPSTARTUPINFOW i,LPPROCESS_INFORMATION j){}
WINBASEAPI BOOL WINAPI CreateProcessAsUserA(HANDLE a,LPCSTR b,LPSTR c,LPSECURITY_ATTRIBUTES d,LPSECURITY_ATTRIBUTES e,BOOL f,DWORD g,PVOID h,LPCSTR i,LPSTARTUPINFOA j,LPPROCESS_INFORMATION k){}
WINBASEAPI BOOL WINAPI CreateProcessAsUserW(HANDLE a,LPCWSTR b,LPWSTR c,LPSECURITY_ATTRIBUTES d,LPSECURITY_ATTRIBUTES e,BOOL f,DWORD g,PVOID h,LPCWSTR i,LPSTARTUPINFOW j,LPPROCESS_INFORMATION k){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI CreateProcessWithLogonW (LPCWSTR a,LPCWSTR b,LPCWSTR c,DWORD d, e
						LPCWSTR,LPWSTR,DWORD,LPVOID,
						LPCWSTR,LPSTARTUPINFOW,
						LPPROCESS_INFORMATION);
#define LOGON_WITH_PROFILE 0x00000001
#define LOGON_NETCREDENTIALS_ONLY 0x00000002
#endif
WINBASEAPI HANDLE WINAPI CreateRemoteThread(HANDLE a,LPSECURITY_ATTRIBUTES b,DWORD c,LPTHREAD_START_ROUTINE d,LPVOID e,DWORD f,LPDWORD g){}
WINBASEAPI HANDLE WINAPI CreateSemaphoreA(LPSECURITY_ATTRIBUTES a,LONG b,LONG c,LPCSTR d){}
WINBASEAPI HANDLE WINAPI CreateSemaphoreW(LPSECURITY_ATTRIBUTES a,LONG b,LONG c,LPCWSTR d){}
WINBASEAPI DWORD WINAPI CreateTapePartition(HANDLE a,DWORD b,DWORD c,DWORD d){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI HANDLE WINAPI CreateTimerQueue(void){}
WINBASEAPI BOOL WINAPI CreateTimerQueueTimer(PHANDLE a,HANDLE b,WAITORTIMERCALLBACK c,PVOID d,DWORD e,DWORD f,ULONG g){}
#endif
WINBASEAPI HANDLE WINAPI CreateThread(LPSECURITY_ATTRIBUTES a,DWORD b,LPTHREAD_START_ROUTINE c,PVOID d,DWORD e,PDWORD f){}
WINBASEAPI HANDLE WINAPI CreateWaitableTimerA(LPSECURITY_ATTRIBUTES a,BOOL b,LPCSTR c){}
WINBASEAPI HANDLE WINAPI CreateWaitableTimerW(LPSECURITY_ATTRIBUTES a,BOOL b,LPCWSTR c){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI DeactivateActCtx(DWORD a,ULONG_PTR b){}
#endif
WINBASEAPI BOOL WINAPI DebugActiveProcess(DWORD a){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI DebugActiveProcessStop(DWORD a){}
#endif
WINBASEAPI void WINAPI DebugBreak(void){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI DebugBreakProcess(HANDLE a){}
WINBASEAPI BOOL WINAPI DebugSetProcessKillOnExit(BOOL a){}
#endif
WINBASEAPI BOOL WINAPI DefineDosDeviceA(DWORD a,LPCSTR b,LPCSTR c){}
WINBASEAPI BOOL WINAPI DefineDosDeviceW(DWORD a,LPCWSTR b,LPCWSTR c){}
#define DefineHandleTable(w) ((w),TRUE)
WINBASEAPI BOOL WINAPI DeleteAce(PACL a,DWORD b){}
WINBASEAPI ATOM WINAPI DeleteAtom(ATOM a){}
WINBASEAPI void WINAPI DeleteCriticalSection(PCRITICAL_SECTION a){}
WINBASEAPI void WINAPI DeleteFiber(PVOID a){}
WINBASEAPI BOOL WINAPI DeleteFileA(LPCSTR a){}
WINBASEAPI BOOL WINAPI DeleteFileW(LPCWSTR a){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI DeleteTimerQueue(HANDLE a){}
WINBASEAPI BOOL WINAPI DeleteTimerQueueEx(HANDLE a,HANDLE b){}
WINBASEAPI BOOL WINAPI DeleteTimerQueueTimer(HANDLE a,HANDLE b,HANDLE c){}
WINBASEAPI BOOL WINAPI DeleteVolumeMountPointA(LPCSTR a){}
WINBASEAPI BOOL WINAPI DeleteVolumeMountPointW(LPCWSTR a){}
#endif
WINBASEAPI BOOL WINAPI DeregisterEventSource(HANDLE a){}
WINBASEAPI BOOL WINAPI DestroyPrivateObjectSecurity(PSECURITY_DESCRIPTOR* a){}
WINBASEAPI BOOL WINAPI DeviceIoControl(HANDLE a,DWORD b,PVOID c,DWORD d,PVOID e,DWORD f,PDWORD g,POVERLAPPED h){}
WINBASEAPI BOOL WINAPI DisableThreadLibraryCalls(HMODULE a){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI DnsHostnameToComputerNameA(LPCSTR a,LPSTR b,LPDWORD c){}
WINBASEAPI BOOL WINAPI DnsHostnameToComputerNameW(LPCWSTR a,LPWSTR b,LPDWORD c){}
#endif
WINBASEAPI BOOL WINAPI DisconnectNamedPipe(HANDLE a){}
WINBASEAPI BOOL WINAPI DosDateTimeToFileTime(WORD a,WORD b,LPFILETIME c){}
WINBASEAPI BOOL WINAPI DuplicateHandle(HANDLE a,HANDLE b,HANDLE c,PHANDLE d,DWORD e,BOOL f,DWORD g){}
WINBASEAPI BOOL WINAPI DuplicateToken(HANDLE a,SECURITY_IMPERSONATION_LEVEL b,PHANDLE c){}
WINBASEAPI BOOL WINAPI DuplicateTokenEx(HANDLE a,DWORD b,LPSECURITY_ATTRIBUTES c,SECURITY_IMPERSONATION_LEVEL d,TOKEN_TYPE e,PHANDLE f){}
WINBASEAPI BOOL WINAPI EncryptFileA(LPCSTR a){}
WINBASEAPI BOOL WINAPI EncryptFileW(LPCWSTR a){}
WINBASEAPI BOOL WINAPI EndUpdateResourceA(HANDLE a,BOOL b){}
WINBASEAPI BOOL WINAPI EndUpdateResourceW(HANDLE a,BOOL b){}
WINBASEAPI void WINAPI EnterCriticalSection(LPCRITICAL_SECTION a){}
WINBASEAPI BOOL WINAPI EnumResourceLanguagesA(HMODULE a,LPCSTR b,LPCSTR c,ENUMRESLANGPROC d,LONG_PTR e){}
WINBASEAPI BOOL WINAPI EnumResourceLanguagesW(HMODULE a,LPCWSTR b,LPCWSTR c,ENUMRESLANGPROC d,LONG_PTR e){}
WINBASEAPI BOOL WINAPI EnumResourceNamesA(HMODULE a,LPCSTR b,ENUMRESNAMEPROC c,LONG_PTR d){}
WINBASEAPI BOOL WINAPI EnumResourceNamesW(HMODULE a,LPCWSTR b,ENUMRESNAMEPROC c,LONG_PTR d){}
WINBASEAPI BOOL WINAPI EnumResourceTypesA(HMODULE a,ENUMRESTYPEPROC b,LONG_PTR c){}
WINBASEAPI BOOL WINAPI EnumResourceTypesW(HMODULE a,ENUMRESTYPEPROC b,LONG_PTR c){}
WINBASEAPI BOOL WINAPI EqualPrefixSid(PSID a,PSID b){}
WINBASEAPI BOOL WINAPI EqualSid(PSID a,PSID b){}
WINBASEAPI DWORD WINAPI EraseTape(HANDLE a,DWORD b,BOOL c){}
WINBASEAPI BOOL WINAPI EscapeCommFunction(HANDLE a,DWORD b){}
DECLSPEC_NORETURN WINBASEAPI void WINAPI ExitProcess(UINT a){}
DECLSPEC_NORETURN WINBASEAPI void WINAPI ExitThread(DWORD a){}
WINBASEAPI DWORD WINAPI ExpandEnvironmentStringsA(LPCSTR a,LPSTR b,DWORD c){}
WINBASEAPI DWORD WINAPI ExpandEnvironmentStringsW(LPCWSTR a,LPWSTR b,DWORD c){}
WINBASEAPI void WINAPI FatalAppExitA(UINT a,LPCSTR b){}
WINBASEAPI void WINAPI FatalAppExitW(UINT a,LPCWSTR b){}
WINBASEAPI void WINAPI FatalExit(int a){}
WINBASEAPI BOOL WINAPI FileEncryptionStatusA(LPCSTR a,LPDWORD b){}
WINBASEAPI BOOL WINAPI FileEncryptionStatusW(LPCWSTR a,LPDWORD b){}
WINBASEAPI BOOL WINAPI FileTimeToDosDateTime(CONST FILETIME * a,LPWORD b,LPWORD c){}
WINBASEAPI BOOL WINAPI FileTimeToLocalFileTime(CONST FILETIME * a,LPFILETIME b){}
WINBASEAPI BOOL WINAPI FileTimeToSystemTime(CONST FILETIME * a,LPSYSTEMTIME b){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI FindActCtxSectionGuid(DWORD a,const GUID* b,ULONG c,const GUID* d,PACTCTX_SECTION_KEYED_DATA e){}
WINBASEAPI BOOL WINAPI FindActCtxSectionStringA(DWORD a,const GUID* b,ULONG c,LPCSTR d,PACTCTX_SECTION_KEYED_DATA e){}
WINBASEAPI BOOL WINAPI FindActCtxSectionStringW(DWORD a,const GUID* b,ULONG c,LPCWSTR d,PACTCTX_SECTION_KEYED_DATA e){}
#endif
WINBASEAPI ATOM WINAPI FindAtomA(LPCSTR a){}
WINBASEAPI ATOM WINAPI FindAtomW(LPCWSTR a){}
WINBASEAPI BOOL WINAPI FindClose(HANDLE a){}
WINBASEAPI BOOL WINAPI FindCloseChangeNotification(HANDLE a){}
WINBASEAPI HANDLE WINAPI FindFirstChangeNotificationA(LPCSTR a,BOOL b,DWORD c){}
WINBASEAPI HANDLE WINAPI FindFirstChangeNotificationW(LPCWSTR a,BOOL b,DWORD c){}
WINBASEAPI HANDLE WINAPI FindFirstFileA(LPCSTR a,LPWIN32_FIND_DATAA b){}
WINBASEAPI HANDLE WINAPI FindFirstFileW(LPCWSTR a,LPWIN32_FIND_DATAW b){}
WINBASEAPI HANDLE WINAPI FindFirstFileExA(LPCSTR a,FINDEX_INFO_LEVELS b,PVOID c,FINDEX_SEARCH_OPS d,PVOID e,DWORD f){}
WINBASEAPI HANDLE WINAPI FindFirstFileExW(LPCWSTR a,FINDEX_INFO_LEVELS b,PVOID c,FINDEX_SEARCH_OPS d,PVOID e,DWORD f){}
WINBASEAPI BOOL WINAPI FindFirstFreeAce(PACL a,PVOID* b){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI HANDLE WINAPI FindFirstVolumeA(LPCSTR a,DWORD b){}
WINBASEAPI HANDLE WINAPI FindFirstVolumeW(LPCWSTR a,DWORD b){}
WINBASEAPI HANDLE WINAPI FindFirstVolumeMountPointA(LPSTR a,LPSTR b,DWORD c){}
WINBASEAPI HANDLE WINAPI FindFirstVolumeMountPointW(LPWSTR a,LPWSTR b,DWORD c){}
#endif
WINBASEAPI BOOL WINAPI FindNextChangeNotification(HANDLE a){}
WINBASEAPI BOOL WINAPI FindNextFileA(HANDLE a,LPWIN32_FIND_DATAA b){}
WINBASEAPI BOOL WINAPI FindNextFileW(HANDLE a,LPWIN32_FIND_DATAW b){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI FindNextVolumeA(HANDLE a,LPCSTR b,DWORD c){}
WINBASEAPI BOOL WINAPI FindNextVolumeW(HANDLE a,LPWSTR b,DWORD c){}
WINBASEAPI BOOL WINAPI FindNextVolumeMountPointA(HANDLE a,LPSTR b,DWORD c){}
WINBASEAPI BOOL WINAPI FindNextVolumeMountPointW(HANDLE a,LPWSTR b,DWORD c){}
WINBASEAPI BOOL WINAPI FindVolumeClose(HANDLE a){}
WINBASEAPI BOOL WINAPI FindVolumeMountPointClose(HANDLE a){}
#endif
WINBASEAPI HRSRC WINAPI FindResourceA(HMODULE a,LPCSTR b,LPCSTR c){}
WINBASEAPI HRSRC WINAPI FindResourceW(HINSTANCE a,LPCWSTR b,LPCWSTR c){}
WINBASEAPI HRSRC WINAPI FindResourceExA(HINSTANCE a,LPCSTR b,LPCSTR c,WORD d){}
WINBASEAPI HRSRC WINAPI FindResourceExW(HINSTANCE a,LPCWSTR b,LPCWSTR c,WORD d){}
#if (_WIN32_WINNT >= 0x0502)
WINBASEAPI DWORD WINAPI GetFirmwareEnvironmentVariableA(LPCSTR a,LPCSTR b,PVOID c,DWORD d){}
WINBASEAPI DWORD WINAPI GetFirmwareEnvironmentVariableW(LPCWSTR a,LPCWSTR b,PVOID c,DWORD d){}
#endif
WINBASEAPI BOOL WINAPI FlushFileBuffers(HANDLE a){}
WINBASEAPI BOOL WINAPI FlushInstructionCache(HANDLE a,PCVOID b,DWORD c){}
WINBASEAPI BOOL WINAPI FlushViewOfFile(PCVOID a,DWORD b){}
WINBASEAPI DWORD WINAPI FormatMessageA(DWORD a,PCVOID b,DWORD c,DWORD d,LPSTR e,DWORD f,va_list* g){}
WINBASEAPI DWORD WINAPI FormatMessageW(DWORD a,PCVOID b,DWORD c,DWORD d,LPWSTR e,DWORD f,va_list* g){}
WINBASEAPI BOOL WINAPI FreeEnvironmentStringsA(LPSTR a){}
WINBASEAPI BOOL WINAPI FreeEnvironmentStringsW(LPWSTR a){}
WINBASEAPI BOOL WINAPI FreeLibrary(HMODULE a){}
DECLSPEC_NORETURN WINBASEAPI void WINAPI FreeLibraryAndExitThread(HMODULE a,DWORD b){}
#define FreeModule(m) FreeLibrary(m)
#define FreeProcInstance(p) (void)(p)
#ifndef XFree86Server
WINBASEAPI BOOL WINAPI FreeResource(HGLOBAL a){}
#endif /* ndef XFree86Server */
WINBASEAPI PVOID WINAPI FreeSid(PSID a){}
WINBASEAPI BOOL WINAPI GetAce(PACL a,DWORD b,LPVOID* c){}
WINBASEAPI BOOL WINAPI GetAclInformation(PACL a,PVOID b,DWORD c,ACL_INFORMATION_CLASS d){}
WINBASEAPI UINT WINAPI GetAtomNameA(ATOM a,LPSTR b,int c){}
WINBASEAPI UINT WINAPI GetAtomNameW(ATOM a,LPWSTR b,int c){}
WINBASEAPI BOOL WINAPI GetBinaryTypeA(LPCSTR a,PDWORD b){}
WINBASEAPI BOOL WINAPI GetBinaryTypeW(LPCWSTR a,PDWORD b){}
WINBASEAPI LPSTR WINAPI GetCommandLineA(VOID){}
WINBASEAPI LPWSTR WINAPI GetCommandLineW(VOID){}
WINBASEAPI BOOL WINAPI GetCommConfig(HANDLE a,LPCOMMCONFIG b,PDWORD c){}
WINBASEAPI BOOL WINAPI GetCommMask(HANDLE a,PDWORD b){}
WINBASEAPI BOOL WINAPI GetCommModemStatus(HANDLE a,PDWORD b){}
WINBASEAPI BOOL WINAPI GetCommProperties(HANDLE a,LPCOMMPROP b){}
WINBASEAPI BOOL WINAPI GetCommState(HANDLE a,LPDCB b){}
WINBASEAPI BOOL WINAPI GetCommTimeouts(HANDLE a,LPCOMMTIMEOUTS b){}
WINBASEAPI DWORD WINAPI GetCompressedFileSizeA(LPCSTR a,PDWORD b){}
WINBASEAPI DWORD WINAPI GetCompressedFileSizeW(LPCWSTR a,PDWORD b){}
WINBASEAPI BOOL WINAPI GetComputerNameA(LPSTR a,PDWORD b){}
WINBASEAPI BOOL WINAPI GetComputerNameW(LPWSTR a,PDWORD b){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI GetComputerNameExA(COMPUTER_NAME_FORMAT a,LPSTR b,LPDWORD c){}
WINBASEAPI BOOL WINAPI GetComputerNameExW(COMPUTER_NAME_FORMAT a,LPWSTR b,LPDWORD c){}
#endif
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI GetCurrentActCtx(HANDLE* a){}
#endif
WINBASEAPI DWORD WINAPI GetCurrentDirectoryA(DWORD a,LPSTR b){}
WINBASEAPI DWORD WINAPI GetCurrentDirectoryW(DWORD a,LPWSTR b){}
WINBASEAPI BOOL WINAPI GetCurrentHwProfileA(LPHW_PROFILE_INFOA a){}
WINBASEAPI BOOL WINAPI GetCurrentHwProfileW(LPHW_PROFILE_INFOW a){}
WINBASEAPI HANDLE WINAPI GetCurrentProcess(void){}
WINBASEAPI DWORD WINAPI GetCurrentProcessId(void){}
WINBASEAPI HANDLE WINAPI GetCurrentThread(void){}
#ifdef _WIN32_WCE
extern DWORD GetCurrentThreadId(void);
#else
WINBASEAPI DWORD WINAPI GetCurrentThreadId(void){}
#endif
#define GetCurrentTime GetTickCount
WINBASEAPI BOOL WINAPI GetDefaultCommConfigA(LPCSTR a,LPCOMMCONFIG b,PDWORD c){}
WINBASEAPI BOOL WINAPI GetDefaultCommConfigW(LPCWSTR a,LPCOMMCONFIG b,PDWORD c){}
WINBASEAPI BOOL WINAPI GetDevicePowerState(HANDLE a, BOOL* b){}
WINBASEAPI BOOL WINAPI GetDiskFreeSpaceA(LPCSTR a,PDWORD b,PDWORD c,PDWORD d,PDWORD e){}
WINBASEAPI BOOL WINAPI GetDiskFreeSpaceW(LPCWSTR a,PDWORD b,PDWORD c,PDWORD d,PDWORD e){}
WINBASEAPI BOOL WINAPI GetDiskFreeSpaceExA(LPCSTR a,PULARGE_INTEGER b,PULARGE_INTEGER c,PULARGE_INTEGER d){}
WINBASEAPI BOOL WINAPI GetDiskFreeSpaceExW(LPCWSTR a,PULARGE_INTEGER b,PULARGE_INTEGER c,PULARGE_INTEGER d){}
#if (_WIN32_WINNT >= 0x0502)
WINBASEAPI DWORD WINAPI GetDllDirectoryA(DWORD a,LPSTR b){}
WINBASEAPI DWORD WINAPI GetDllDirectoryW(DWORD a,LPWSTR b){}
#endif
WINBASEAPI UINT WINAPI GetDriveTypeA(LPCSTR a){}
WINBASEAPI UINT WINAPI GetDriveTypeW(LPCWSTR a){}
WINBASEAPI LPSTR WINAPI GetEnvironmentStrings(void){}
WINBASEAPI LPSTR WINAPI GetEnvironmentStringsA(void){}
WINBASEAPI LPWSTR WINAPI GetEnvironmentStringsW(void){}
WINBASEAPI DWORD WINAPI GetEnvironmentVariableA(LPCSTR a,LPSTR b,DWORD c){}
WINBASEAPI DWORD WINAPI GetEnvironmentVariableW(LPCWSTR a,LPWSTR b,DWORD c){}
WINBASEAPI BOOL WINAPI GetExitCodeProcess(HANDLE a,PDWORD b){}
WINBASEAPI BOOL WINAPI GetExitCodeThread(HANDLE a,PDWORD b){}
WINBASEAPI DWORD WINAPI GetFileAttributesA(LPCSTR a){}
WINBASEAPI DWORD WINAPI GetFileAttributesW(LPCWSTR a){}
WINBASEAPI BOOL WINAPI GetFileAttributesExA(LPCSTR a,GET_FILEEX_INFO_LEVELS b,PVOID c){}
WINBASEAPI BOOL WINAPI GetFileAttributesExW(LPCWSTR a,GET_FILEEX_INFO_LEVELS b,PVOID c){}
WINBASEAPI BOOL WINAPI GetFileInformationByHandle(HANDLE a,LPBY_HANDLE_FILE_INFORMATION b){}
WINBASEAPI BOOL WINAPI GetFileSecurityA(LPCSTR a,SECURITY_INFORMATION b,PSECURITY_DESCRIPTOR c,DWORD d,PDWORD e){}
WINBASEAPI BOOL WINAPI GetFileSecurityW(LPCWSTR a,SECURITY_INFORMATION b,PSECURITY_DESCRIPTOR c,DWORD d,PDWORD e){}
WINBASEAPI DWORD WINAPI GetFileSize(HANDLE a,PDWORD b){}
#if (_WIN32_WINNT >= 0x0500) 
WINBASEAPI BOOL WINAPI GetFileSizeEx(HANDLE a,PLARGE_INTEGER b){}
#endif
WINBASEAPI BOOL WINAPI GetFileTime(HANDLE a,LPFILETIME b,LPFILETIME c,LPFILETIME d){}
WINBASEAPI DWORD WINAPI GetFileType(HANDLE a){}
#define GetFreeSpace(w) (0x100000L)
WINBASEAPI DWORD WINAPI GetFullPathNameA(LPCSTR a,DWORD b,LPSTR c,LPSTR* d){}
WINBASEAPI DWORD WINAPI GetFullPathNameW(LPCWSTR a,DWORD b,LPWSTR c,LPWSTR* d){}
WINBASEAPI BOOL WINAPI GetHandleInformation(HANDLE a,PDWORD b){}
WINBASEAPI BOOL WINAPI GetKernelObjectSecurity(HANDLE a,SECURITY_INFORMATION b,PSECURITY_DESCRIPTOR c,DWORD d,PDWORD e){}
WINBASEAPI DWORD WINAPI GetLastError(void){}
WINBASEAPI DWORD WINAPI GetLengthSid(PSID a){}
WINBASEAPI void WINAPI GetLocalTime(LPSYSTEMTIME a){}
WINBASEAPI DWORD WINAPI GetLogicalDrives(void){}
WINBASEAPI DWORD WINAPI GetLogicalDriveStringsA(DWORD a,LPSTR b){}
WINBASEAPI DWORD WINAPI GetLogicalDriveStringsW(DWORD a,LPWSTR b){}
#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0410)
WINBASEAPI DWORD WINAPI GetLongPathNameA(LPCSTR a,LPSTR b,DWORD c){}
WINBASEAPI DWORD WINAPI GetLongPathNameW(LPCWSTR a,LPWSTR b,DWORD c){}
#endif
WINBASEAPI BOOL WINAPI GetMailslotInfo(HANDLE a,PDWORD b,PDWORD c,PDWORD d,PDWORD e){}
WINBASEAPI DWORD WINAPI GetModuleFileNameA(HINSTANCE a,LPSTR b,DWORD c){}
WINBASEAPI DWORD WINAPI GetModuleFileNameW(HINSTANCE a,LPWSTR b,DWORD c){}
WINBASEAPI HMODULE WINAPI GetModuleHandleA(LPCSTR a){}
WINBASEAPI HMODULE WINAPI GetModuleHandleW(LPCWSTR a){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI GetModuleHandleExA(DWORD a,LPCSTR b,HMODULE* c){}
WINBASEAPI BOOL WINAPI GetModuleHandleExW(DWORD a,LPCWSTR b,HMODULE* c){}
#endif
WINBASEAPI BOOL WINAPI GetNamedPipeHandleStateA(HANDLE a,PDWORD b,PDWORD c,PDWORD d,PDWORD e,LPSTR f,DWORD g){}
WINBASEAPI BOOL WINAPI GetNamedPipeHandleStateW(HANDLE a,PDWORD b,PDWORD c,PDWORD d,PDWORD e,LPWSTR f,DWORD g){}
WINBASEAPI BOOL WINAPI GetNamedPipeInfo(HANDLE a,PDWORD b,PDWORD c,PDWORD d,PDWORD e){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI VOID WINAPI GetNativeSystemInfo(LPSYSTEM_INFO a){}
#endif
WINBASEAPI BOOL WINAPI GetNumberOfEventLogRecords(HANDLE a,PDWORD b){}
WINBASEAPI BOOL WINAPI GetOldestEventLogRecord(HANDLE a,PDWORD b){}
WINBASEAPI BOOL WINAPI GetOverlappedResult(HANDLE a,LPOVERLAPPED b,PDWORD c,BOOL d){}
WINBASEAPI DWORD WINAPI GetPriorityClass(HANDLE a){}
WINBASEAPI BOOL WINAPI GetPrivateObjectSecurity(PSECURITY_DESCRIPTOR a,SECURITY_INFORMATION b,PSECURITY_DESCRIPTOR c,DWORD d,PDWORD e){}
WINBASEAPI UINT WINAPI GetPrivateProfileIntA(LPCSTR a,LPCSTR b,INT c,LPCSTR d){}
WINBASEAPI UINT WINAPI GetPrivateProfileIntW(LPCWSTR a,LPCWSTR b,INT c,LPCWSTR d){}
WINBASEAPI DWORD WINAPI GetPrivateProfileSectionA(LPCSTR a,LPSTR b,DWORD c,LPCSTR d){}
WINBASEAPI DWORD WINAPI GetPrivateProfileSectionW(LPCWSTR a,LPWSTR b,DWORD c,LPCWSTR d){}
WINBASEAPI DWORD WINAPI GetPrivateProfileSectionNamesA(LPSTR a,DWORD b,LPCSTR c){}
WINBASEAPI DWORD WINAPI GetPrivateProfileSectionNamesW(LPWSTR a,DWORD b,LPCWSTR c){}
WINBASEAPI DWORD WINAPI GetPrivateProfileStringA(LPCSTR a,LPCSTR b,LPCSTR c,LPSTR d,DWORD e,LPCSTR f){}
WINBASEAPI DWORD WINAPI GetPrivateProfileStringW(LPCWSTR a,LPCWSTR b,LPCWSTR c,LPWSTR d,DWORD e,LPCWSTR f){}
WINBASEAPI BOOL WINAPI GetPrivateProfileStructA(LPCSTR a,LPCSTR b,LPVOID c,UINT d,LPCSTR e){}
WINBASEAPI BOOL WINAPI GetPrivateProfileStructW(LPCWSTR a,LPCWSTR b,LPVOID c,UINT d,LPCWSTR e){}
WINBASEAPI FARPROC WINAPI GetProcAddress(HINSTANCE a,LPCSTR b){}
WINBASEAPI BOOL WINAPI GetProcessAffinityMask(HANDLE a,PDWORD b,PDWORD c){}
#if (_WIN32_WINNT >= 0x0601)
WINBASEAPI BOOL WINAPI GetProcessDEPPolicy (HANDLE a, LPDWORD b, PBOOL c){}
#endif
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI GetProcessHandleCount(HANDLE a,PDWORD b){}
#endif
WINBASEAPI HANDLE WINAPI GetProcessHeap(VOID){}
WINBASEAPI DWORD WINAPI GetProcessHeaps(DWORD a,PHANDLE b){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI DWORD WINAPI GetProcessId(HANDLE a){}
#endif
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI GetProcessIoCounters(HANDLE a,PIO_COUNTERS b){}
#endif
WINBASEAPI BOOL WINAPI GetProcessPriorityBoost(HANDLE a,PBOOL b){}
WINBASEAPI BOOL WINAPI GetProcessShutdownParameters(PDWORD a,PDWORD b){}
WINBASEAPI BOOL WINAPI GetProcessTimes(HANDLE a,LPFILETIME b,LPFILETIME c,LPFILETIME d,LPFILETIME e){}
WINBASEAPI DWORD WINAPI GetProcessVersion(DWORD a){}
WINBASEAPI HWINSTA WINAPI GetProcessWindowStation(void){}
WINBASEAPI BOOL WINAPI GetProcessWorkingSetSize(HANDLE a,PSIZE_T b,PSIZE_T c){}
WINBASEAPI UINT WINAPI GetProfileIntA(LPCSTR a,LPCSTR b,INT c){}
WINBASEAPI UINT WINAPI GetProfileIntW(LPCWSTR a,LPCWSTR b,INT c){}
WINBASEAPI DWORD WINAPI GetProfileSectionA(LPCSTR a,LPSTR b,DWORD c){}
WINBASEAPI DWORD WINAPI GetProfileSectionW(LPCWSTR a,LPWSTR b,DWORD c){}
WINBASEAPI DWORD WINAPI GetProfileStringA(LPCSTR a,LPCSTR b,LPCSTR c,LPSTR d,DWORD e){}
WINBASEAPI DWORD WINAPI GetProfileStringW(LPCWSTR a,LPCWSTR b,LPCWSTR c,LPWSTR d,DWORD e){}
WINBASEAPI BOOL WINAPI GetQueuedCompletionStatus(HANDLE a,PDWORD b,PULONG_PTR c,LPOVERLAPPED* d,DWORD e){}
WINBASEAPI BOOL WINAPI GetSecurityDescriptorControl(PSECURITY_DESCRIPTOR a,PSECURITY_DESCRIPTOR_CONTROL b,PDWORD c){}
WINBASEAPI BOOL WINAPI GetSecurityDescriptorDacl(PSECURITY_DESCRIPTOR a,LPBOOL b,PACL* c,LPBOOL d){}
WINBASEAPI BOOL WINAPI GetSecurityDescriptorGroup(PSECURITY_DESCRIPTOR a,PSID* b,LPBOOL c){}
WINBASEAPI DWORD WINAPI GetSecurityDescriptorLength(PSECURITY_DESCRIPTOR a){}
WINBASEAPI BOOL WINAPI GetSecurityDescriptorOwner(PSECURITY_DESCRIPTOR a,PSID* b,LPBOOL c){}
WINBASEAPI BOOL WINAPI GetSecurityDescriptorSacl(PSECURITY_DESCRIPTOR a,LPBOOL b,PACL* c,LPBOOL d){}
WINBASEAPI DWORD WINAPI GetShortPathNameA(LPCSTR a,LPSTR b,DWORD c){}
WINBASEAPI DWORD WINAPI GetShortPathNameW(LPCWSTR a,LPWSTR b,DWORD c){}
WINBASEAPI PSID_IDENTIFIER_AUTHORITY WINAPI GetSidIdentifierAuthority(PSID a){}
WINBASEAPI DWORD WINAPI GetSidLengthRequired(UCHAR a){}
WINBASEAPI PDWORD WINAPI GetSidSubAuthority(PSID a,DWORD b){}
WINBASEAPI PUCHAR WINAPI GetSidSubAuthorityCount(PSID a){}
WINBASEAPI VOID WINAPI GetStartupInfoA(LPSTARTUPINFOA a){}
WINBASEAPI VOID WINAPI GetStartupInfoW(LPSTARTUPINFOW a){}
WINBASEAPI HANDLE WINAPI GetStdHandle(DWORD a){}
#if (_WIN32_WINNT >= 0x0601)
WINBASEAPI DEP_SYSTEM_POLICY_TYPE WINAPI GetSystemDEPPolicy (void){}
#endif
WINBASEAPI UINT WINAPI GetSystemDirectoryA(LPSTR a,UINT b){}
WINBASEAPI UINT WINAPI GetSystemDirectoryW(LPWSTR a,UINT b){}
WINBASEAPI VOID WINAPI GetSystemInfo(LPSYSTEM_INFO a){}
WINBASEAPI BOOL WINAPI GetSystemPowerStatus(LPSYSTEM_POWER_STATUS a){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI GetSystemRegistryQuota(PDWORD a,PDWORD b){}
#endif
WINBASEAPI VOID WINAPI GetSystemTime(LPSYSTEMTIME a){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI GetSystemTimes(LPFILETIME a,LPFILETIME b,LPFILETIME c){}
#endif
WINBASEAPI BOOL WINAPI GetSystemTimeAdjustment(PDWORD a,PDWORD b,PBOOL c){}
WINBASEAPI void WINAPI GetSystemTimeAsFileTime(LPFILETIME a){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI UINT WINAPI GetSystemWindowsDirectoryA(LPSTR a,UINT b){}
WINBASEAPI UINT WINAPI GetSystemWindowsDirectoryW(LPWSTR a,UINT b){}
#endif
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI UINT WINAPI GetSystemWow64DirectoryA(LPSTR a,UINT b){}
WINBASEAPI UINT WINAPI GetSystemWow64DirectoryW(LPWSTR a,UINT b){}
#endif
WINBASEAPI DWORD WINAPI GetTapeParameters(HANDLE a,DWORD b,PDWORD c,PVOID d){}
WINBASEAPI DWORD WINAPI GetTapePosition(HANDLE a,DWORD b,PDWORD c,PDWORD d,PDWORD e){}
WINBASEAPI DWORD WINAPI GetTapeStatus(HANDLE a){}
WINBASEAPI UINT WINAPI GetTempFileNameA(LPCSTR a,LPCSTR b,UINT c,LPSTR d){}
WINBASEAPI UINT WINAPI GetTempFileNameW(LPCWSTR a,LPCWSTR b,UINT c,LPWSTR d){}
WINBASEAPI DWORD WINAPI GetTempPathA(DWORD a,LPSTR b){}
WINBASEAPI DWORD WINAPI GetTempPathW(DWORD a,LPWSTR b){}
WINBASEAPI BOOL WINAPI GetThreadContext(HANDLE a,LPCONTEXT b){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI GetThreadIOPendingFlag(HANDLE a,PBOOL b){}
#endif
WINBASEAPI int WINAPI GetThreadPriority(HANDLE a){}
WINBASEAPI BOOL WINAPI GetThreadPriorityBoost(HANDLE a,PBOOL b){}
WINBASEAPI BOOL WINAPI GetThreadSelectorEntry(HANDLE a,DWORD b,LPLDT_ENTRY c){}
WINBASEAPI BOOL WINAPI GetThreadTimes(HANDLE a,LPFILETIME b,LPFILETIME c,LPFILETIME d,LPFILETIME e){}
WINBASEAPI DWORD WINAPI GetTickCount(VOID){}
WINBASEAPI DWORD WINAPI GetTimeZoneInformation(LPTIME_ZONE_INFORMATION a){}
WINBASEAPI BOOL WINAPI GetTokenInformation(HANDLE a,TOKEN_INFORMATION_CLASS b,PVOID c,DWORD d,PDWORD e){}
WINBASEAPI BOOL WINAPI GetUserNameA (LPSTR a,PDWORD b){}
WINBASEAPI BOOL WINAPI GetUserNameW(LPWSTR a,PDWORD b){}
WINBASEAPI DWORD WINAPI GetVersion(void){}
WINBASEAPI BOOL WINAPI GetVersionExA(LPOSVERSIONINFOA a){}
WINBASEAPI BOOL WINAPI GetVersionExW(LPOSVERSIONINFOW a){}
WINBASEAPI BOOL WINAPI GetVolumeInformationA(LPCSTR a,LPSTR b,DWORD c,PDWORD d,PDWORD e,PDWORD f,LPSTR g,DWORD h){}
WINBASEAPI BOOL WINAPI GetVolumeInformationW(LPCWSTR a,LPWSTR b,DWORD c,PDWORD d,PDWORD e,PDWORD f,LPWSTR g,DWORD h){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI GetVolumeNameForVolumeMountPointA(LPCSTR a,LPSTR b,DWORD c){}
WINBASEAPI BOOL WINAPI GetVolumeNameForVolumeMountPointW(LPCWSTR a,LPWSTR b,DWORD c){}
WINBASEAPI BOOL WINAPI GetVolumePathNameA(LPCSTR a,LPSTR b,DWORD c){}
WINBASEAPI BOOL WINAPI GetVolumePathNameW(LPCWSTR a,LPWSTR b,DWORD c){}
#endif
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI GetVolumePathNamesForVolumeNameA(LPCSTR a,LPSTR b,DWORD c,PDWORD d){}
WINBASEAPI BOOL WINAPI GetVolumePathNamesForVolumeNameW(LPCWSTR a,LPWSTR b,DWORD c,PDWORD d){}
#endif
WINBASEAPI UINT WINAPI GetWindowsDirectoryA(LPSTR a,UINT b){}
WINBASEAPI UINT WINAPI GetWindowsDirectoryW(LPWSTR a,UINT b){}
WINBASEAPI DWORD WINAPI GetWindowThreadProcessId(HWND a,PDWORD b){}
WINBASEAPI UINT WINAPI GetWriteWatch(DWORD a,PVOID b,SIZE_T c,PVOID* d,PULONG_PTR e,PULONG f){}
WINBASEAPI ATOM WINAPI GlobalAddAtomA(LPCSTR a){}
WINBASEAPI ATOM WINAPI GlobalAddAtomW( LPCWSTR a){}
WINBASEAPI HGLOBAL WINAPI GlobalAlloc(UINT a,DWORD b){}
WINBASEAPI SIZE_T WINAPI GlobalCompact(DWORD a){} /* Obsolete: Has no effect. */
WINBASEAPI ATOM WINAPI GlobalDeleteAtom(ATOM a){}
#define GlobalDiscard(hMem) GlobalReAlloc((hMem), 0, GMEM_MOVEABLE)
WINBASEAPI ATOM WINAPI GlobalFindAtomA(LPCSTR a){}
WINBASEAPI ATOM WINAPI GlobalFindAtomW(LPCWSTR a){}
WINBASEAPI VOID WINAPI GlobalFix(HGLOBAL a){} /* Obsolete: Has no effect. */
WINBASEAPI UINT WINAPI GlobalFlags(HGLOBAL a){} /* Obsolete: Has no effect. */
WINBASEAPI HGLOBAL WINAPI GlobalFree(HGLOBAL a){}
WINBASEAPI UINT WINAPI GlobalGetAtomNameA(ATOM a,LPSTR b,int c){}
WINBASEAPI UINT WINAPI GlobalGetAtomNameW(ATOM a,LPWSTR b,int c){}
WINBASEAPI HGLOBAL WINAPI GlobalHandle(PCVOID a){}
WINBASEAPI LPVOID WINAPI GlobalLock(HGLOBAL a){}
WINBASEAPI VOID WINAPI GlobalMemoryStatus(LPMEMORYSTATUS a){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI GlobalMemoryStatusEx(LPMEMORYSTATUSEX a){}
#endif
WINBASEAPI HGLOBAL WINAPI GlobalReAlloc(HGLOBAL a,DWORD b,UINT c){}
WINBASEAPI DWORD WINAPI GlobalSize(HGLOBAL a){}
WINBASEAPI VOID WINAPI GlobalUnfix(HGLOBAL a){} /* Obsolete: Has no effect. */
WINBASEAPI BOOL WINAPI GlobalUnlock(HGLOBAL a){} 
WINBASEAPI BOOL WINAPI GlobalUnWire(HGLOBAL a){} /* Obsolete: Has no effect. */
WINBASEAPI PVOID WINAPI GlobalWire(HGLOBAL a){} /* Obsolete: Has no effect. */
#define HasOverlappedIoCompleted(lpOverlapped)  ((lpOverlapped)->Internal != STATUS_PENDING)
WINBASEAPI PVOID WINAPI HeapAlloc(HANDLE a,DWORD b,DWORD c){}
SIZE_T WINAPI HeapCompact(HANDLE a,DWORD b){}
WINBASEAPI HANDLE WINAPI HeapCreate(DWORD a,DWORD b,DWORD c){}
WINBASEAPI BOOL WINAPI HeapDestroy(HANDLE a){}
WINBASEAPI BOOL WINAPI HeapFree(HANDLE a,DWORD b,PVOID c){}
WINBASEAPI BOOL WINAPI HeapLock(HANDLE a){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI HeapQueryInformation(HANDLE a,HEAP_INFORMATION_CLASS b,PVOID c,SIZE_T d,PSIZE_T e){}
#endif
WINBASEAPI PVOID WINAPI HeapReAlloc(HANDLE a,DWORD b,PVOID c,DWORD d){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI HeapSetInformation(HANDLE a,HEAP_INFORMATION_CLASS b,PVOID c,SIZE_T d){}
#endif
WINBASEAPI DWORD WINAPI HeapSize(HANDLE a,DWORD b,PCVOID c){}
WINBASEAPI BOOL WINAPI HeapUnlock(HANDLE a){}
WINBASEAPI BOOL WINAPI HeapValidate(HANDLE a,DWORD b,PCVOID c){}
WINBASEAPI BOOL WINAPI HeapWalk(HANDLE a,LPPROCESS_HEAP_ENTRY b){}
WINBASEAPI BOOL WINAPI ImpersonateLoggedOnUser(HANDLE a){}
WINBASEAPI BOOL WINAPI ImpersonateNamedPipeClient(HANDLE a){}
WINBASEAPI BOOL WINAPI ImpersonateSelf(SECURITY_IMPERSONATION_LEVEL a){}
WINBASEAPI BOOL WINAPI InitAtomTable(DWORD a){}
WINBASEAPI BOOL WINAPI InitializeAcl(PACL a,DWORD b,DWORD c){}
WINBASEAPI VOID WINAPI InitializeCriticalSection(LPCRITICAL_SECTION a){}
WINBASEAPI BOOL WINAPI InitializeCriticalSectionAndSpinCount(LPCRITICAL_SECTION a,DWORD b){}
WINBASEAPI DWORD WINAPI SetCriticalSectionSpinCount(LPCRITICAL_SECTION a,DWORD b){}
WINBASEAPI BOOL WINAPI InitializeSecurityDescriptor(PSECURITY_DESCRIPTOR a,DWORD b){}
WINBASEAPI BOOL WINAPI InitializeSid (PSID a,PSID_IDENTIFIER_AUTHORITY b,BYTE c){}

#if !(__USE_NTOSKRNL__)
/* CAREFUL: These are exported from ntoskrnl.exe and declared in winddk.h
   as __fastcall functions, but are  exported from kernel32.dll as __stdcall */
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI VOID WINAPI InitializeSListHead(PSLIST_HEADER a){}
#endif
#ifndef __INTERLOCKED_DECLARED
#define __INTERLOCKED_DECLARED
LONG WINAPI InterlockedCompareExchange(LONG volatile * a,LONG b,LONG c){}
/* PVOID WINAPI InterlockedCompareExchangePointer(PVOID* a,PVOID b,PVOID c){} */
#define InterlockedCompareExchangePointer(d,e,c) \
    (PVOID)InterlockedCompareExchange((LONG volatile *)(d),(LONG)(e),(LONG)(c))
LONG WINAPI InterlockedDecrement(LONG volatile * a){}
LONG WINAPI InterlockedExchange(LONG volatile * a,LONG b){}
/* PVOID WINAPI InterlockedExchangePointer(PVOID* a,PVOID b){} */
#define InterlockedExchangePointer(t,v) \
    (PVOID)InterlockedExchange((LONG volatile *)(t),(LONG)(v))
LONG WINAPI InterlockedExchangeAdd(LONG volatile * a,LONG b){}
#if (_WIN32_WINNT >= 0x0501)
PSLIST_ENTRY WINAPI InterlockedFlushSList(PSLIST_HEADER a){}
#endif
LONG WINAPI InterlockedIncrement(LONG volatile * a){}
#if (_WIN32_WINNT >= 0x0501)
PSLIST_ENTRY WINAPI InterlockedPopEntrySList(PSLIST_HEADER a){}
PSLIST_ENTRY WINAPI InterlockedPushEntrySList(PSLIST_HEADER a,PSLIST_ENTRY b){}
#endif
#endif /* __INTERLOCKED_DECLARED */
#endif /*  __USE_NTOSKRNL__ */

WINBASEAPI BOOL WINAPI IsBadCodePtr(FARPROC a){}
WINBASEAPI BOOL WINAPI IsBadHugeReadPtr(PCVOID a,UINT b){}
WINBASEAPI BOOL WINAPI IsBadHugeWritePtr(PVOID a,UINT b){}
WINBASEAPI BOOL WINAPI IsBadReadPtr(PCVOID a,UINT b){}
WINBASEAPI BOOL WINAPI IsBadStringPtrA(LPCSTR a,UINT b){}
WINBASEAPI BOOL WINAPI IsBadStringPtrW(LPCWSTR a,UINT b){}
WINBASEAPI BOOL WINAPI IsBadWritePtr(PVOID a,UINT b){}
WINBASEAPI BOOL WINAPI IsDebuggerPresent(void){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL IsProcessInJob(HANDLE,HANDLE,PBOOL);
#endif
WINBASEAPI BOOL WINAPI IsProcessorFeaturePresent(DWORD a){}
WINBASEAPI BOOL WINAPI IsSystemResumeAutomatic(void){}
WINBASEAPI BOOL WINAPI IsTextUnicode(PCVOID a,int b,LPINT c){}
WINBASEAPI BOOL WINAPI IsValidAcl(PACL a){}
WINBASEAPI BOOL WINAPI IsValidSecurityDescriptor(PSECURITY_DESCRIPTOR a){}
WINBASEAPI BOOL WINAPI IsValidSid(PSID a){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI IsWow64Process(HANDLE a,PBOOL b){}
#endif
WINBASEAPI void WINAPI LeaveCriticalSection(LPCRITICAL_SECTION a){}
#define LimitEmsPages(n)
WINBASEAPI HINSTANCE WINAPI LoadLibraryA(LPCSTR a){}
WINBASEAPI HINSTANCE WINAPI LoadLibraryExA(LPCSTR a,HANDLE b,DWORD c){}
WINBASEAPI HINSTANCE WINAPI LoadLibraryExW(LPCWSTR a,HANDLE b,DWORD c){}
WINBASEAPI HINSTANCE WINAPI LoadLibraryW(LPCWSTR a){}
WINBASEAPI DWORD WINAPI LoadModule(LPCSTR a,PVOID b){}
WINBASEAPI HGLOBAL WINAPI LoadResource(HINSTANCE a,HRSRC b){}
WINBASEAPI HLOCAL WINAPI LocalAlloc(UINT a,SIZE_T b){}
WINBASEAPI SIZE_T WINAPI LocalCompact(UINT a){} /* Obsolete: Has no effect. */
WINBASEAPI HLOCAL LocalDiscard(HLOCAL);
WINBASEAPI BOOL WINAPI LocalFileTimeToFileTime(CONST FILETIME * a,LPFILETIME b){}
WINBASEAPI UINT WINAPI LocalFlags(HLOCAL a){} /* Obsolete: Has no effect. */
WINBASEAPI HLOCAL WINAPI LocalFree(HLOCAL a){}
WINBASEAPI HLOCAL WINAPI LocalHandle(LPCVOID a){}
WINBASEAPI PVOID WINAPI LocalLock(HLOCAL a){}
WINBASEAPI HLOCAL WINAPI LocalReAlloc(HLOCAL a,SIZE_T b,UINT c){}
WINBASEAPI SIZE_T WINAPI LocalShrink(HLOCAL a,UINT b){}  /* Obsolete: Has no effect. */
WINBASEAPI UINT WINAPI LocalSize(HLOCAL a){}
WINBASEAPI BOOL WINAPI LocalUnlock(HLOCAL a){}
WINBASEAPI BOOL WINAPI LockFile(HANDLE a,DWORD b,DWORD c,DWORD d,DWORD e){}
WINBASEAPI BOOL WINAPI LockFileEx(HANDLE a,DWORD b,DWORD c,DWORD d,DWORD e,LPOVERLAPPED f){}
WINBASEAPI PVOID WINAPI LockResource(HGLOBAL a){}
#define LockSegment(w) GlobalFix((HANDLE)(w)) /* Obsolete: Has no effect. */
WINBASEAPI BOOL WINAPI LogonUserA(LPSTR a,LPSTR b,LPSTR c,DWORD d,DWORD e,PHANDLE f){}
WINBASEAPI BOOL WINAPI LogonUserW(LPWSTR a,LPWSTR b,LPWSTR c,DWORD d,DWORD e,PHANDLE f){}
WINBASEAPI BOOL WINAPI LookupAccountNameA(LPCSTR a,LPCSTR b,PSID c,PDWORD d,LPSTR e,PDWORD f,PSID_NAME_USE g){}
WINBASEAPI BOOL WINAPI LookupAccountNameW(LPCWSTR a,LPCWSTR b,PSID c,PDWORD d,LPWSTR e,PDWORD f,PSID_NAME_USE g){}
WINBASEAPI BOOL WINAPI LookupAccountSidA(LPCSTR a,PSID b,LPSTR c,PDWORD d,LPSTR e,PDWORD f,PSID_NAME_USE g){}
WINBASEAPI BOOL WINAPI LookupAccountSidW(LPCWSTR a,PSID b,LPWSTR c,PDWORD d,LPWSTR e,PDWORD f,PSID_NAME_USE g){}
WINBASEAPI BOOL WINAPI LookupPrivilegeDisplayNameA(LPCSTR a,LPCSTR b,LPSTR c,PDWORD d,PDWORD e){}
WINBASEAPI BOOL WINAPI LookupPrivilegeDisplayNameW(LPCWSTR a,LPCWSTR b,LPWSTR c,PDWORD d,PDWORD e){}
WINBASEAPI BOOL WINAPI LookupPrivilegeNameA(LPCSTR a,PLUID b,LPSTR c,PDWORD d){}
WINBASEAPI BOOL WINAPI LookupPrivilegeNameW(LPCWSTR a,PLUID b,LPWSTR c,PDWORD d){}
WINBASEAPI BOOL WINAPI LookupPrivilegeValueA(LPCSTR a,LPCSTR b,PLUID c){}
WINBASEAPI BOOL WINAPI LookupPrivilegeValueW(LPCWSTR a,LPCWSTR b,PLUID c){}
WINBASEAPI LPSTR WINAPI lstrcatA(LPSTR a,LPCSTR b){}
WINBASEAPI LPWSTR WINAPI lstrcatW(LPWSTR a,LPCWSTR b){}
WINBASEAPI int WINAPI lstrcmpA(LPCSTR a,LPCSTR b){}
WINBASEAPI int WINAPI lstrcmpiA(LPCSTR a,LPCSTR b){}
WINBASEAPI int WINAPI lstrcmpiW( LPCWSTR a,LPCWSTR b){}
WINBASEAPI int WINAPI lstrcmpW(LPCWSTR a,LPCWSTR b){}
WINBASEAPI LPSTR WINAPI lstrcpyA(LPSTR a,LPCSTR b){}
WINBASEAPI LPSTR WINAPI lstrcpynA(LPSTR a,LPCSTR b,int c){}
WINBASEAPI LPWSTR WINAPI lstrcpynW(LPWSTR a,LPCWSTR b,int c){}
WINBASEAPI LPWSTR WINAPI lstrcpyW(LPWSTR a,LPCWSTR b){}
WINBASEAPI int WINAPI lstrlenA(LPCSTR a){}
WINBASEAPI int WINAPI lstrlenW(LPCWSTR a){}
WINBASEAPI BOOL WINAPI MakeAbsoluteSD(PSECURITY_DESCRIPTOR a,PSECURITY_DESCRIPTOR b,PDWORD c,PACL d,PDWORD e,PACL f,PDWORD g,PSID h,PDWORD i,PSID j,PDWORD k){}
#define MakeProcInstance(p,i) (p)
WINBASEAPI BOOL WINAPI MakeSelfRelativeSD(PSECURITY_DESCRIPTOR a,PSECURITY_DESCRIPTOR b,PDWORD c){}
WINBASEAPI VOID WINAPI MapGenericMask(PDWORD a,PGENERIC_MAPPING b){}
WINBASEAPI PVOID WINAPI MapViewOfFile(HANDLE a,DWORD b,DWORD c,DWORD d,DWORD e){}
WINBASEAPI PVOID WINAPI MapViewOfFileEx(HANDLE a,DWORD b,DWORD c,DWORD d,DWORD e,PVOID f){}
WINBASEAPI BOOL WINAPI MoveFileA(LPCSTR a,LPCSTR b){}
WINBASEAPI BOOL WINAPI MoveFileExA(LPCSTR a,LPCSTR b,DWORD c){}
WINBASEAPI BOOL WINAPI MoveFileExW(LPCWSTR a,LPCWSTR b,DWORD c){}
WINBASEAPI BOOL WINAPI MoveFileW(LPCWSTR a,LPCWSTR b){}
WINBASEAPI int WINAPI MulDiv(int a,int b,int c){}
WINBASEAPI BOOL WINAPI NotifyChangeEventLog(HANDLE a,HANDLE b){}
WINBASEAPI BOOL WINAPI ObjectCloseAuditAlarmA(LPCSTR a,PVOID b,BOOL c){}
WINBASEAPI BOOL WINAPI ObjectCloseAuditAlarmW(LPCWSTR a,PVOID b,BOOL c){}
WINBASEAPI BOOL WINAPI ObjectDeleteAuditAlarmA(LPCSTR a,PVOID b,BOOL c){}
WINBASEAPI BOOL WINAPI ObjectDeleteAuditAlarmW(LPCWSTR a,PVOID b,BOOL c){}
WINBASEAPI BOOL WINAPI ObjectOpenAuditAlarmA(LPCSTR a,PVOID b,LPSTR c,LPSTR d,PSECURITY_DESCRIPTOR e,HANDLE f,DWORD g,DWORD h,PPRIVILEGE_SET i,BOOL j,BOOL k,PBOOL l){}
WINBASEAPI BOOL WINAPI ObjectOpenAuditAlarmW(LPCWSTR a,PVOID b,LPWSTR c,LPWSTR d,PSECURITY_DESCRIPTOR e,HANDLE f,DWORD g,DWORD h,PPRIVILEGE_SET i,BOOL j,BOOL k,PBOOL l){}
WINBASEAPI BOOL WINAPI ObjectPrivilegeAuditAlarmA(LPCSTR a,PVOID b,HANDLE c,DWORD d,PPRIVILEGE_SET e,BOOL f){}
WINBASEAPI BOOL WINAPI ObjectPrivilegeAuditAlarmW(LPCWSTR a,PVOID b,HANDLE c,DWORD d,PPRIVILEGE_SET e,BOOL f){}
WINBASEAPI HANDLE WINAPI OpenBackupEventLogA(LPCSTR a,LPCSTR b){}
WINBASEAPI HANDLE WINAPI OpenBackupEventLogW(LPCWSTR a,LPCWSTR b){}
WINBASEAPI HANDLE WINAPI OpenEventA(DWORD a,BOOL b,LPCSTR c){}
WINBASEAPI HANDLE WINAPI OpenEventLogA (LPCSTR a,LPCSTR b){}
WINBASEAPI HANDLE WINAPI OpenEventLogW(LPCWSTR a,LPCWSTR b){}
WINBASEAPI HANDLE WINAPI OpenEventW(DWORD a,BOOL b,LPCWSTR c){}
WINBASEAPI HFILE WINAPI OpenFile(LPCSTR a,LPOFSTRUCT b,UINT c){}
WINBASEAPI HANDLE WINAPI OpenFileMappingA(DWORD a,BOOL b,LPCSTR c){}
WINBASEAPI HANDLE WINAPI OpenFileMappingW(DWORD a,BOOL b,LPCWSTR c){}
WINBASEAPI HANDLE WINAPI OpenMutexA(DWORD a,BOOL b,LPCSTR c){}
WINBASEAPI HANDLE WINAPI OpenMutexW(DWORD a,BOOL b,LPCWSTR c){}
WINBASEAPI HANDLE WINAPI OpenProcess(DWORD a,BOOL b,DWORD c){}
WINBASEAPI BOOL WINAPI OpenProcessToken(HANDLE a,DWORD b,PHANDLE c){}
WINBASEAPI HANDLE WINAPI OpenSemaphoreA(DWORD a,BOOL b,LPCSTR c){}
WINBASEAPI HANDLE WINAPI OpenSemaphoreW(DWORD a,BOOL b,LPCWSTR c){}
#if (_WIN32_WINNT >= 0x0500) || (_WIN32_WINDOWS >= 0x0490)
WINBASEAPI HANDLE WINAPI OpenThread(DWORD a,BOOL b,DWORD c){}
#endif
WINBASEAPI BOOL WINAPI OpenThreadToken(HANDLE a,DWORD b,BOOL c,PHANDLE d){}
WINBASEAPI HANDLE WINAPI OpenWaitableTimerA(DWORD a,BOOL b,LPCSTR c){}
WINBASEAPI HANDLE WINAPI OpenWaitableTimerW(DWORD a,BOOL b,LPCWSTR c){}
WINBASEAPI void WINAPI OutputDebugStringA(LPCSTR a){}
WINBASEAPI void WINAPI OutputDebugStringW(LPCWSTR a){}
WINBASEAPI BOOL WINAPI PeekNamedPipe(HANDLE a,PVOID b,DWORD c,PDWORD d,PDWORD e,PDWORD f){}
WINBASEAPI BOOL WINAPI PostQueuedCompletionStatus(HANDLE a,DWORD b,ULONG_PTR c,LPOVERLAPPED d){}
WINBASEAPI DWORD WINAPI PrepareTape(HANDLE a,DWORD b,BOOL c){}
WINBASEAPI BOOL WINAPI PrivilegeCheck (HANDLE a,PPRIVILEGE_SET b,PBOOL c){}
WINBASEAPI BOOL WINAPI PrivilegedServiceAuditAlarmA(LPCSTR a,LPCSTR b,HANDLE c,PPRIVILEGE_SET d,BOOL e){}
WINBASEAPI BOOL WINAPI PrivilegedServiceAuditAlarmW(LPCWSTR a,LPCWSTR b,HANDLE c,PPRIVILEGE_SET d,BOOL e){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI ProcessIdToSessionId(DWORD a,DWORD* b){}
#endif
WINBASEAPI BOOL WINAPI PulseEvent(HANDLE a){}
WINBASEAPI BOOL WINAPI PurgeComm(HANDLE a,DWORD b){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI QueryActCtxW(DWORD a,HANDLE b,PVOID c,ULONG d,PVOID e,SIZE_T f,SIZE_T* g){}
#endif
WINBASEAPI DWORD WINAPI QueryDosDeviceA(LPCSTR a,LPSTR b,DWORD c){}
WINBASEAPI DWORD WINAPI QueryDosDeviceW(LPCWSTR a,LPWSTR b,DWORD c){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI QueryMemoryResourceNotification(HANDLE a,PBOOL b){}
#endif
WINBASEAPI BOOL WINAPI QueryPerformanceCounter(PLARGE_INTEGER a){}
WINBASEAPI BOOL WINAPI QueryPerformanceFrequency(PLARGE_INTEGER a){}
WINBASEAPI DWORD WINAPI QueueUserAPC(PAPCFUNC a,HANDLE b,ULONG_PTR c){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI QueueUserWorkItem(LPTHREAD_START_ROUTINE a,PVOID b,ULONG c){}
#endif
WINBASEAPI void WINAPI RaiseException(DWORD a,DWORD b,DWORD c,const DWORD* d){}
WINBASEAPI BOOL WINAPI ReadDirectoryChangesW(HANDLE a,PVOID b,DWORD c,BOOL d,DWORD e,PDWORD f,LPOVERLAPPED g,LPOVERLAPPED_COMPLETION_ROUTINE h){}
WINBASEAPI BOOL WINAPI ReadEventLogA(HANDLE a,DWORD b,DWORD c,PVOID d,DWORD e,DWORD * f,DWORD * g){}
WINBASEAPI BOOL WINAPI ReadEventLogW(HANDLE a,DWORD b,DWORD c,PVOID d,DWORD e,DWORD * f,DWORD * g){}
WINBASEAPI BOOL WINAPI ReadFile(HANDLE a,PVOID b,DWORD c,PDWORD d,LPOVERLAPPED e){}
WINBASEAPI BOOL WINAPI ReadFileEx(HANDLE a,PVOID b,DWORD c,LPOVERLAPPED d,LPOVERLAPPED_COMPLETION_ROUTINE e){}
WINBASEAPI BOOL WINAPI ReadFileScatter(HANDLE a,FILE_SEGMENT_ELEMENT* b,DWORD c,LPDWORD d,LPOVERLAPPED e){}
WINBASEAPI BOOL WINAPI ReadProcessMemory(HANDLE a,PCVOID b,PVOID c,DWORD d,PDWORD e){}
WINBASEAPI HANDLE WINAPI RegisterEventSourceA (LPCSTR a,LPCSTR b){}
WINBASEAPI HANDLE WINAPI RegisterEventSourceW(LPCWSTR a,LPCWSTR b){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI RegisterWaitForSingleObject(PHANDLE a,HANDLE b,WAITORTIMERCALLBACK c,PVOID d,ULONG e,ULONG f){}
WINBASEAPI HANDLE WINAPI RegisterWaitForSingleObjectEx(HANDLE a,WAITORTIMERCALLBACK b,PVOID c,ULONG d,ULONG e){}
#endif
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI void WINAPI ReleaseActCtx(HANDLE a){}
#endif
WINBASEAPI BOOL WINAPI ReleaseMutex(HANDLE a){}
WINBASEAPI BOOL WINAPI ReleaseSemaphore(HANDLE a,LONG b,LPLONG c){}
WINBASEAPI BOOL WINAPI RemoveDirectoryA(LPCSTR a){}
WINBASEAPI BOOL WINAPI RemoveDirectoryW(LPCWSTR a){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI ULONG WINAPI RemoveVectoredExceptionHandler(PVOID a){}
#endif
#if (_WIN32_WINNT >= 0x0502)
WINBASEAPI HANDLE WINAPI ReOpenFile(HANDLE a,DWORD b,DWORD c,DWORD d){}
#endif
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI ReplaceFileA(LPCSTR a,LPCSTR b,LPCSTR c,DWORD d,LPVOID e,LPVOID f){}
WINBASEAPI BOOL WINAPI ReplaceFileW(LPCWSTR a,LPCWSTR b,LPCWSTR c,DWORD d,LPVOID e,LPVOID f){}
#endif
WINBASEAPI BOOL WINAPI ReportEventA(HANDLE a,WORD b,WORD c,DWORD d,PSID e,WORD f,DWORD g,LPCSTR* h,PVOID i){}
WINBASEAPI BOOL WINAPI ReportEventW(HANDLE a,WORD b,WORD c,DWORD d,PSID e,WORD f,DWORD g,LPCWSTR* h,PVOID i){}
#ifdef _WIN32_WCE
extern BOOL ResetEvent(HANDLE);
#else
WINBASEAPI BOOL WINAPI ResetEvent(HANDLE a){}
#endif
WINBASEAPI UINT WINAPI ResetWriteWatch(LPVOID a,SIZE_T b){}
#if (_WIN32_WINNT >= 0x0510)
WINBASEAPI VOID WINAPI RestoreLastError(DWORD a){}
#endif
WINBASEAPI DWORD WINAPI ResumeThread(HANDLE a){}
WINBASEAPI BOOL WINAPI RevertToSelf(void){}
WINBASEAPI DWORD WINAPI SearchPathA(LPCSTR a,LPCSTR b,LPCSTR c,DWORD d,LPSTR e,LPSTR* f){}
WINBASEAPI DWORD WINAPI SearchPathW(LPCWSTR a,LPCWSTR b,LPCWSTR c,DWORD d,LPWSTR e,LPWSTR* f){}
WINBASEAPI BOOL WINAPI SetAclInformation(PACL a,PVOID b,DWORD c,ACL_INFORMATION_CLASS d){}
WINBASEAPI BOOL WINAPI SetCommBreak(HANDLE a){}
WINBASEAPI BOOL WINAPI SetCommConfig(HANDLE a,LPCOMMCONFIG b,DWORD c){}
WINBASEAPI BOOL WINAPI SetCommMask(HANDLE a,DWORD b){}
WINBASEAPI BOOL WINAPI SetCommState(HANDLE a,LPDCB b){}
WINBASEAPI BOOL WINAPI SetCommTimeouts(HANDLE a,LPCOMMTIMEOUTS b){}
WINBASEAPI BOOL WINAPI SetComputerNameA(LPCSTR a){}
WINBASEAPI BOOL WINAPI SetComputerNameW(LPCWSTR a){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI SetComputerNameExA(COMPUTER_NAME_FORMAT a,LPCSTR b){}
WINBASEAPI BOOL WINAPI SetComputerNameExW(COMPUTER_NAME_FORMAT a,LPCWSTR b){}
#endif
WINBASEAPI BOOL WINAPI SetCurrentDirectoryA(LPCSTR a){}
WINBASEAPI BOOL WINAPI SetCurrentDirectoryW(LPCWSTR a){}
WINBASEAPI BOOL WINAPI SetDefaultCommConfigA(LPCSTR a,LPCOMMCONFIG b,DWORD c){}
WINBASEAPI BOOL WINAPI SetDefaultCommConfigW(LPCWSTR a,LPCOMMCONFIG b,DWORD c){}
#if (_WIN32_WINNT >= 0x0502)
WINBASEAPI BOOL WINAPI SetDllDirectoryA(LPCSTR a){}
WINBASEAPI BOOL WINAPI SetDllDirectoryW(LPCWSTR a){}
#endif
WINBASEAPI BOOL WINAPI SetEndOfFile(HANDLE a){}
WINBASEAPI BOOL WINAPI SetEnvironmentVariableA(LPCSTR a,LPCSTR b){}
WINBASEAPI BOOL WINAPI SetEnvironmentVariableW(LPCWSTR a,LPCWSTR b){}
WINBASEAPI UINT WINAPI SetErrorMode(UINT a){}
#ifdef _WIN32_WCE
extern BOOL SetEvent(HANDLE);
#else
WINBASEAPI BOOL WINAPI SetEvent(HANDLE a){}
#endif
WINBASEAPI VOID WINAPI SetFileApisToANSI(void){}
WINBASEAPI VOID WINAPI SetFileApisToOEM(void){}
WINBASEAPI BOOL WINAPI SetFileAttributesA(LPCSTR a,DWORD b){}
WINBASEAPI BOOL WINAPI SetFileAttributesW(LPCWSTR a,DWORD b){}
WINBASEAPI DWORD WINAPI SetFilePointer(HANDLE a,LONG b,PLONG c,DWORD d){}
WINBASEAPI BOOL WINAPI SetFilePointerEx(HANDLE a,LARGE_INTEGER b,PLARGE_INTEGER c,DWORD d){}
WINBASEAPI BOOL WINAPI SetFileSecurityA(LPCSTR a,SECURITY_INFORMATION b,PSECURITY_DESCRIPTOR c){}
WINBASEAPI BOOL WINAPI SetFileSecurityW(LPCWSTR a,SECURITY_INFORMATION b,PSECURITY_DESCRIPTOR c){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI SetFileShortNameA(HANDLE a,LPCSTR b){}
WINBASEAPI BOOL WINAPI SetFileShortNameW(HANDLE a,LPCWSTR b){}
#endif
WINBASEAPI BOOL WINAPI SetFileTime(HANDLE a,const FILETIME* b,const FILETIME* c,const FILETIME* d){}
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI SetFileValidData(HANDLE a,LONGLONG b){}
#endif
#if (_WIN32_WINNT >= 0x0502)
WINBASEAPI BOOL WINAPI SetFirmwareEnvironmentVariableA(LPCSTR a,LPCSTR b,PVOID c,DWORD d){}
WINBASEAPI BOOL WINAPI SetFirmwareEnvironmentVariableW(LPCWSTR a,LPCWSTR b,PVOID c,DWORD d){}
#endif
WINBASEAPI UINT WINAPI SetHandleCount(UINT a){}
WINBASEAPI BOOL WINAPI SetHandleInformation(HANDLE a,DWORD b,DWORD c){}
WINBASEAPI BOOL WINAPI SetKernelObjectSecurity(HANDLE a,SECURITY_INFORMATION b,PSECURITY_DESCRIPTOR c){}
WINBASEAPI void WINAPI SetLastError(DWORD a){}
WINBASEAPI void WINAPI SetLastErrorEx(DWORD a,DWORD b){}
WINBASEAPI BOOL WINAPI SetLocalTime(const SYSTEMTIME* a){}
WINBASEAPI BOOL WINAPI SetMailslotInfo(HANDLE a,DWORD b){}
WINBASEAPI BOOL WINAPI SetNamedPipeHandleState(HANDLE a,PDWORD b,PDWORD c,PDWORD d){}
WINBASEAPI BOOL WINAPI SetPriorityClass(HANDLE a,DWORD b){}
WINBASEAPI BOOL WINAPI SetPrivateObjectSecurity(SECURITY_INFORMATION a,PSECURITY_DESCRIPTOR b,PSECURITY_DESCRIPTOR * c,PGENERIC_MAPPING d,HANDLE e){}
WINBASEAPI BOOL WINAPI SetProcessAffinityMask(HANDLE a,DWORD b){}
#if (_WIN32_WINNT >= 0x0601)
WINBASEAPI BOOL WINAPI SetProcessDEPPolicy (DWORD a){}
#endif
WINBASEAPI BOOL WINAPI SetProcessPriorityBoost(HANDLE a,BOOL b){}
WINBASEAPI BOOL WINAPI SetProcessShutdownParameters(DWORD a,DWORD b){}
WINBASEAPI BOOL WINAPI SetProcessWorkingSetSize(HANDLE a,SIZE_T b,SIZE_T c){}
WINBASEAPI BOOL WINAPI SetSecurityDescriptorControl(PSECURITY_DESCRIPTOR a,SECURITY_DESCRIPTOR_CONTROL b,SECURITY_DESCRIPTOR_CONTROL c){}
WINBASEAPI BOOL WINAPI SetSecurityDescriptorDacl(PSECURITY_DESCRIPTOR a,BOOL b,PACL c,BOOL d){}
WINBASEAPI BOOL WINAPI SetSecurityDescriptorGroup(PSECURITY_DESCRIPTOR a,PSID b,BOOL c){}
WINBASEAPI BOOL WINAPI SetSecurityDescriptorOwner(PSECURITY_DESCRIPTOR a,PSID b,BOOL c){}
WINBASEAPI BOOL WINAPI SetSecurityDescriptorSacl(PSECURITY_DESCRIPTOR a,BOOL b,PACL c,BOOL d){}
WINBASEAPI BOOL WINAPI SetStdHandle(DWORD a,HANDLE b){}
#define SetSwapAreaSize(w) (w)
WINBASEAPI BOOL WINAPI SetSystemPowerState(BOOL a,BOOL b){}
WINBASEAPI BOOL WINAPI SetSystemTime(const SYSTEMTIME* a){}
WINBASEAPI BOOL WINAPI SetSystemTimeAdjustment(DWORD a,BOOL b){}
WINBASEAPI DWORD WINAPI SetTapeParameters(HANDLE a,DWORD b,PVOID c){}
WINBASEAPI DWORD WINAPI SetTapePosition(HANDLE a,DWORD b,DWORD c,DWORD d,DWORD e,BOOL f){}
WINBASEAPI DWORD WINAPI SetThreadAffinityMask(HANDLE a,DWORD b){}
WINBASEAPI BOOL WINAPI SetThreadContext(HANDLE a,const CONTEXT* b){}
#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0410)
WINBASEAPI EXECUTION_STATE WINAPI SetThreadExecutionState(EXECUTION_STATE a){}
#endif
WINBASEAPI DWORD WINAPI SetThreadIdealProcessor(HANDLE a,DWORD b){}
WINBASEAPI BOOL WINAPI SetThreadPriority(HANDLE a,int b){}
WINBASEAPI BOOL WINAPI SetThreadPriorityBoost(HANDLE a,BOOL b){}
WINBASEAPI BOOL WINAPI SetThreadToken (PHANDLE a,HANDLE b){}
WINBASEAPI BOOL WINAPI SetTimeZoneInformation(const TIME_ZONE_INFORMATION * a){}
WINBASEAPI BOOL WINAPI SetTokenInformation(HANDLE a,TOKEN_INFORMATION_CLASS b,PVOID c,DWORD d){}
WINBASEAPI LPTOP_LEVEL_EXCEPTION_FILTER WINAPI SetUnhandledExceptionFilter(LPTOP_LEVEL_EXCEPTION_FILTER a){}
WINBASEAPI BOOL WINAPI SetupComm(HANDLE a,DWORD b,DWORD c){}
WINBASEAPI BOOL WINAPI SetVolumeLabelA(LPCSTR a,LPCSTR b){}
WINBASEAPI BOOL WINAPI SetVolumeLabelW(LPCWSTR a,LPCWSTR b){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI SetVolumeMountPointA(LPCSTR a,LPCSTR b){}
WINBASEAPI BOOL WINAPI SetVolumeMountPointW(LPCWSTR a,LPCWSTR b){}
#endif
WINBASEAPI BOOL WINAPI SetWaitableTimer(HANDLE a,const LARGE_INTEGER* b,LONG c,PTIMERAPCROUTINE d,PVOID e,BOOL f){}
WINBASEAPI DWORD WINAPI SignalObjectAndWait(HANDLE a,HANDLE b,DWORD c,BOOL d){}
WINBASEAPI DWORD WINAPI SizeofResource(HINSTANCE a,HRSRC b){}
WINBASEAPI void WINAPI Sleep(DWORD a){}
WINBASEAPI DWORD WINAPI SleepEx(DWORD a,BOOL b){}
WINBASEAPI DWORD WINAPI SuspendThread(HANDLE a){}
WINBASEAPI void WINAPI SwitchToFiber(PVOID a){}
WINBASEAPI BOOL WINAPI SwitchToThread(void){}
WINBASEAPI BOOL WINAPI SystemTimeToFileTime(const SYSTEMTIME* a,LPFILETIME b){}
WINBASEAPI BOOL WINAPI SystemTimeToTzSpecificLocalTime(LPTIME_ZONE_INFORMATION a,LPSYSTEMTIME b,LPSYSTEMTIME c){}
WINBASEAPI BOOL WINAPI TerminateProcess(HANDLE a,UINT b){}
WINBASEAPI BOOL WINAPI TerminateThread(HANDLE a,DWORD b){}
WINBASEAPI DWORD WINAPI TlsAlloc(VOID){}
WINBASEAPI BOOL WINAPI TlsFree(DWORD a){}
WINBASEAPI PVOID WINAPI TlsGetValue(DWORD a){}
WINBASEAPI BOOL WINAPI TlsSetValue(DWORD a,PVOID b){}
WINBASEAPI BOOL WINAPI TransactNamedPipe(HANDLE a,PVOID b,DWORD c,PVOID d,DWORD e,PDWORD f,LPOVERLAPPED g){}
WINBASEAPI BOOL WINAPI TransmitCommChar(HANDLE a,char b){}
WINBASEAPI BOOL WINAPI TryEnterCriticalSection(LPCRITICAL_SECTION a){}
WINBASEAPI LONG WINAPI UnhandledExceptionFilter(LPEXCEPTION_POINTERS a){}
WINBASEAPI BOOL WINAPI UnlockFile(HANDLE a,DWORD b,DWORD c,DWORD d,DWORD e){}
WINBASEAPI BOOL WINAPI UnlockFileEx(HANDLE a,DWORD b,DWORD c,DWORD d,LPOVERLAPPED e){}
#define UnlockResource(h) (h)
#define UnlockSegment(w) GlobalUnfix((HANDLE)(w)) /* Obsolete: Has no effect. */
WINBASEAPI BOOL WINAPI UnmapViewOfFile(PVOID a){}
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI UnregisterWait(HANDLE a){}
WINBASEAPI BOOL WINAPI UnregisterWaitEx(HANDLE a,HANDLE b){}
#endif
WINBASEAPI BOOL WINAPI UpdateResourceA(HANDLE a,LPCSTR b,LPCSTR c,WORD d,PVOID e,DWORD f){}
WINBASEAPI BOOL WINAPI UpdateResourceW(HANDLE a,LPCWSTR b,LPCWSTR c,WORD d,PVOID e,DWORD f){}
WINBASEAPI BOOL WINAPI VerifyVersionInfoA(LPOSVERSIONINFOEXA a,DWORD b,DWORDLONG c){}
WINBASEAPI BOOL WINAPI VerifyVersionInfoW(LPOSVERSIONINFOEXW a,DWORD b,DWORDLONG c){}
WINBASEAPI PVOID WINAPI VirtualAlloc(PVOID a,DWORD b,DWORD c,DWORD d){}
WINBASEAPI PVOID WINAPI VirtualAllocEx(HANDLE a,PVOID b,DWORD c,DWORD d,DWORD e){}
WINBASEAPI BOOL WINAPI VirtualFree(PVOID a,DWORD b,DWORD c){}
WINBASEAPI BOOL WINAPI VirtualFreeEx(HANDLE a,PVOID b,DWORD c,DWORD d){}
WINBASEAPI BOOL WINAPI VirtualLock(PVOID a,DWORD b){}
WINBASEAPI BOOL WINAPI VirtualProtect(PVOID a,DWORD b,DWORD c,PDWORD d){}
WINBASEAPI BOOL WINAPI VirtualProtectEx(HANDLE a,PVOID b,DWORD c,DWORD d,PDWORD e){}
WINBASEAPI DWORD WINAPI VirtualQuery(LPCVOID a,PMEMORY_BASIC_INFORMATION b,DWORD c){}
WINBASEAPI DWORD WINAPI VirtualQueryEx(HANDLE a,LPCVOID b,PMEMORY_BASIC_INFORMATION c,DWORD d){}
WINBASEAPI BOOL WINAPI VirtualUnlock(PVOID a,DWORD b){}
WINBASEAPI BOOL WINAPI WaitCommEvent(HANDLE a,PDWORD b,LPOVERLAPPED c){}
WINBASEAPI BOOL WINAPI WaitForDebugEvent(LPDEBUG_EVENT a,DWORD b){}
WINBASEAPI DWORD WINAPI WaitForMultipleObjects(DWORD a,const HANDLE* b,BOOL c,DWORD d){}
WINBASEAPI DWORD WINAPI WaitForMultipleObjectsEx(DWORD a,const HANDLE* b,BOOL c,DWORD d,BOOL e){}
WINBASEAPI DWORD WINAPI WaitForSingleObject(HANDLE a,DWORD b){}
WINBASEAPI DWORD WINAPI WaitForSingleObjectEx(HANDLE a,DWORD b,BOOL c){}
WINBASEAPI BOOL WINAPI WaitNamedPipeA(LPCSTR a,DWORD b){}
WINBASEAPI BOOL WINAPI WaitNamedPipeW(LPCWSTR a,DWORD b){}
WINBASEAPI BOOL WINAPI WinLoadTrustProvider(GUID* a){}
WINBASEAPI BOOL WINAPI WriteFile(HANDLE a,PCVOID b,DWORD c,PDWORD d,LPOVERLAPPED e){}
WINBASEAPI BOOL WINAPI WriteFileEx(HANDLE a,PCVOID b,DWORD c,LPOVERLAPPED d,LPOVERLAPPED_COMPLETION_ROUTINE e){}
WINBASEAPI BOOL WINAPI WriteFileGather(HANDLE a,FILE_SEGMENT_ELEMENT* b,DWORD c,LPDWORD d,LPOVERLAPPED e){}
WINBASEAPI BOOL WINAPI WritePrivateProfileSectionA(LPCSTR a,LPCSTR b,LPCSTR c){}
WINBASEAPI BOOL WINAPI WritePrivateProfileSectionW(LPCWSTR a,LPCWSTR b,LPCWSTR c){}
WINBASEAPI BOOL WINAPI WritePrivateProfileStringA(LPCSTR a,LPCSTR b,LPCSTR c,LPCSTR d){}
WINBASEAPI BOOL WINAPI WritePrivateProfileStringW(LPCWSTR a,LPCWSTR b,LPCWSTR c,LPCWSTR d){}
WINBASEAPI BOOL WINAPI WritePrivateProfileStructA(LPCSTR a,LPCSTR b,LPVOID c,UINT d,LPCSTR e){}
WINBASEAPI BOOL WINAPI WritePrivateProfileStructW(LPCWSTR a,LPCWSTR b,LPVOID c,UINT d,LPCWSTR e){}
WINBASEAPI BOOL WINAPI WriteProcessMemory(HANDLE a,LPVOID b,LPCVOID c,SIZE_T d,SIZE_T* e){}
WINBASEAPI BOOL WINAPI WriteProfileSectionA(LPCSTR a,LPCSTR b){}
WINBASEAPI BOOL WINAPI WriteProfileSectionW(LPCWSTR a,LPCWSTR b){}
WINBASEAPI BOOL WINAPI WriteProfileStringA(LPCSTR a,LPCSTR b,LPCSTR c){}
WINBASEAPI BOOL WINAPI WriteProfileStringW(LPCWSTR a,LPCWSTR b,LPCWSTR c){}
WINBASEAPI DWORD WINAPI WriteTapemark(HANDLE a,DWORD b,DWORD c,BOOL d){}
#define Yield()
#if (_WIN32_WINNT >= 0x0501)
WINBASEAPI BOOL WINAPI ZombifyActCtx(HANDLE a){}
#endif
#if (_WIN32_WINNT >= 0x0500)
WINBASEAPI BOOL WINAPI AllocateUserPhysicalPages(HANDLE a,PULONG_PTR b,PULONG_PTR c){}
WINBASEAPI BOOL WINAPI FreeUserPhysicalPages(HANDLE a,PULONG_PTR b,PULONG_PTR c){}
WINBASEAPI BOOL WINAPI MapUserPhysicalPages(PVOID a,ULONG_PTR b,PULONG_PTR c){}
WINBASEAPI BOOL WINAPI MapUserPhysicalPagesScatter(PVOID* a,ULONG_PTR b,PULONG_PTR c){}
#endif

#ifdef UNICODE
typedef STARTUPINFOW STARTUPINFO,*LPSTARTUPINFO;
typedef WIN32_FIND_DATAW WIN32_FIND_DATA,*PWIN32_FIND_DATA,*LPWIN32_FIND_DATA;
typedef HW_PROFILE_INFOW HW_PROFILE_INFO,*LPHW_PROFILE_INFO;
#if (_WIN32_WINNT >= 0x0501)
typedef ACTCTXW ACTCTX,*PACTCTX;
typedef PCACTCTXW PCACTCTX;
#endif
#define AccessCheckAndAuditAlarm AccessCheckAndAuditAlarmW
#define AddAtom AddAtomW
#define BackupEventLog BackupEventLogW
#define BeginUpdateResource BeginUpdateResourceW
#define BuildCommDCB BuildCommDCBW
#define BuildCommDCBAndTimeouts BuildCommDCBAndTimeoutsW
#define CallNamedPipe CallNamedPipeW
#if (_WIN32_WINNT >= 0x0501)
#define CheckNameLegalDOS8Dot3 CheckNameLegalDOS8Dot3W
#endif
#define ClearEventLog ClearEventLogW
#define CommConfigDialog CommConfigDialogW
#define CopyFile CopyFileW
#define CopyFileEx CopyFileExW
#if (_WIN32_WINNT >= 0x0501)
#define CreateActCtx CreateActCtxW
#endif
#define CreateDirectory CreateDirectoryW
#define CreateDirectoryEx CreateDirectoryExW
#define CreateEvent CreateEventW
#define CreateFile CreateFileW
#define CreateFileMapping CreateFileMappingW
#if (_WIN32_WINNT >= 0x0500)
#define CreateHardLink CreateHardLinkW
#define CreateJobObject CreateJobObjectW
#endif
#define CreateMailslot CreateMailslotW
#define CreateMutex CreateMutexW
#define CreateNamedPipe CreateNamedPipeW
#define CreateProcess CreateProcessW
#define CreateProcessAsUser CreateProcessAsUserW
#define CreateSemaphore CreateSemaphoreW
#define CreateWaitableTimer CreateWaitableTimerW
#define DefineDosDevice DefineDosDeviceW
#define DeleteFile DeleteFileW
#if (_WIN32_WINNT >= 0x0500)
#define DeleteVolumeMountPoint DeleteVolumeMountPointW
#define DnsHostnameToComputerName DnsHostnameToComputerNameW
#endif
#define EncryptFile EncryptFileW
#define EndUpdateResource EndUpdateResourceW
#define EnumResourceLanguages EnumResourceLanguagesW
#define EnumResourceNames EnumResourceNamesW
#define EnumResourceTypes EnumResourceTypesW
#define ExpandEnvironmentStrings ExpandEnvironmentStringsW
#define FatalAppExit FatalAppExitW
#define FileEncryptionStatus FileEncryptionStatusW
#if (_WIN32_WINNT >= 0x0501)
#define FindActCtxSectionString FindActCtxSectionStringW
#endif
#define FindAtom FindAtomW
#define FindFirstChangeNotification FindFirstChangeNotificationW
#define FindFirstFile FindFirstFileW
#define FindFirstFileEx FindFirstFileExW
#if (_WIN32_WINNT >= 0x0500)
#define FindFirstVolume FindFirstVolumeW
#define FindFirstVolumeMountPoint FindFirstVolumeMountPointW
#endif
#define FindNextFile FindNextFileW
#if (_WIN32_WINNT >= 0x0500)
#define FindNextVolume FindNextVolumeW
#define FindNextVolumeMountPoint  FindNextVolumeMountPointW
#endif
#define FindResource FindResourceW
#define FindResourceEx FindResourceExW
#define FormatMessage FormatMessageW
#define FreeEnvironmentStrings FreeEnvironmentStringsW
#define GetAtomName GetAtomNameW
#define GetBinaryType GetBinaryTypeW
#define GetCommandLine GetCommandLineW
#define GetCompressedFileSize GetCompressedFileSizeW
#define GetComputerName GetComputerNameW
#define GetCurrentDirectory GetCurrentDirectoryW
#define GetDefaultCommConfig GetDefaultCommConfigW
#define GetDiskFreeSpace GetDiskFreeSpaceW
#define GetDiskFreeSpaceEx GetDiskFreeSpaceExW
#if (_WIN32_WINNT >= 0x0502)
#define GetDllDirectory GetDllDirectoryW
#endif
#define GetDriveType GetDriveTypeW
#define GetEnvironmentStrings GetEnvironmentStringsW
#define GetEnvironmentVariable GetEnvironmentVariableW
#define GetFileAttributes GetFileAttributesW
#define GetFileSecurity GetFileSecurityW
#define GetFileAttributesEx GetFileAttributesExW
#define GetFullPathName GetFullPathNameW
#define GetLogicalDriveStrings GetLogicalDriveStringsW
#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0410)
#define GetLongPathName GetLongPathNameW
#endif
#define GetModuleFileName GetModuleFileNameW
#define GetModuleHandle GetModuleHandleW
#if (_WIN32_WINNT >= 0x0500)
#define GetModuleHandleEx GetModuleHandleExW
#endif
#define GetNamedPipeHandleState GetNamedPipeHandleStateW
#define GetPrivateProfileInt GetPrivateProfileIntW
#define GetPrivateProfileSection GetPrivateProfileSectionW
#define GetPrivateProfileSectionNames GetPrivateProfileSectionNamesW
#define GetPrivateProfileString GetPrivateProfileStringW
#define GetPrivateProfileStruct GetPrivateProfileStructW
#define GetProfileInt GetProfileIntW
#define GetProfileSection GetProfileSectionW
#define GetProfileString GetProfileStringW
#define GetShortPathName GetShortPathNameW
#define GetStartupInfo GetStartupInfoW
#define GetSystemDirectory GetSystemDirectoryW
#if (_WIN32_WINNT >= 0x0500)
#define GetSystemWindowsDirectory GetSystemWindowsDirectoryW
#endif
#if (_WIN32_WINNT >= 0x0501)
#define GetSystemWow64Directory GetSystemWow64DirectoryW
#endif
#define GetTempFileName GetTempFileNameW
#define GetTempPath GetTempPathW
#define GetUserName GetUserNameW
#define GetVersionEx GetVersionExW
#define GetVolumeInformation GetVolumeInformationW
#define GetVolumeNameForVolumeMountPoint GetVolumeNameForVolumeMountPointW
#define GetVolumePathName GetVolumePathNameW
#define GetVolumePathNamesForVolumeName GetVolumePathNamesForVolumeNameW
#define GetWindowsDirectory GetWindowsDirectoryW
#define GlobalAddAtom GlobalAddAtomW
#define GlobalFindAtom GlobalFindAtomW
#define GlobalGetAtomName GlobalGetAtomNameW
#define IsBadStringPtr IsBadStringPtrW
#define LoadLibrary LoadLibraryW
#define LoadLibraryEx LoadLibraryExW
#define LogonUser LogonUserW
#define LookupAccountName LookupAccountNameW
#define LookupAccountSid LookupAccountSidW
#define LookupPrivilegeDisplayName LookupPrivilegeDisplayNameW
#define LookupPrivilegeName LookupPrivilegeNameW
#define LookupPrivilegeValue LookupPrivilegeValueW
#define lstrcat lstrcatW
#define lstrcmp lstrcmpW
#define lstrcmpi lstrcmpiW
#define lstrcpy lstrcpyW
#define lstrcpyn lstrcpynW
#define lstrlen lstrlenW
#define MoveFile MoveFileW
#define MoveFileEx MoveFileExW
#define ObjectCloseAuditAlarm ObjectCloseAuditAlarmW
#define ObjectDeleteAuditAlarm ObjectDeleteAuditAlarmW
#define ObjectOpenAuditAlarm ObjectOpenAuditAlarmW
#define ObjectPrivilegeAuditAlarm ObjectPrivilegeAuditAlarmW
#define OpenBackupEventLog OpenBackupEventLogW
#define OpenEvent OpenEventW
#define OpenEventLog OpenEventLogW
#define OpenFileMapping OpenFileMappingW
#define OpenMutex OpenMutexW
#define OpenSemaphore OpenSemaphoreW
#define OutputDebugString OutputDebugStringW
#define PrivilegedServiceAuditAlarm PrivilegedServiceAuditAlarmW
#define QueryDosDevice QueryDosDeviceW
#define ReadEventLog ReadEventLogW
#define RegisterEventSource RegisterEventSourceW
#define RemoveDirectory RemoveDirectoryW
#if (_WIN32_WINNT >= 0x0500)
#define ReplaceFile ReplaceFileW
#endif
#define ReportEvent ReportEventW
#define SearchPath SearchPathW
#define SetComputerName SetComputerNameW
#define SetCurrentDirectory SetCurrentDirectoryW
#define SetDefaultCommConfig SetDefaultCommConfigW
#if (_WIN32_WINNT >= 0x0502)
#define SetDllDirectory SetDllDirectoryW
#endif
#define SetEnvironmentVariable SetEnvironmentVariableW
#define SetFileAttributes SetFileAttributesW
#define SetFileSecurity SetFileSecurityW
#if (_WIN32_WINNT >= 0x0501)
#define SetFileShortName SetFileShortNameW
#endif
#if (_WIN32_WINNT >= 0x0502)
#define SetFirmwareEnvironmentVariable SetFirmwareEnvironmentVariableW
#endif
#define SetVolumeLabel SetVolumeLabelW
#define SetVolumeMountPoint SetVolumeMountPointW
#define UpdateResource UpdateResourceW
#define VerifyVersionInfo VerifyVersionInfoW
#define WaitNamedPipe WaitNamedPipeW
#define WritePrivateProfileSection WritePrivateProfileSectionW
#define WritePrivateProfileString WritePrivateProfileStringW
#define WritePrivateProfileStruct WritePrivateProfileStructW
#define WriteProfileSection WriteProfileSectionW
#define WriteProfileString WriteProfileStringW
#else
typedef STARTUPINFOA STARTUPINFO,*LPSTARTUPINFO;
typedef WIN32_FIND_DATAA WIN32_FIND_DATA,*PWIN32_FIND_DATA,*LPWIN32_FIND_DATA;
typedef HW_PROFILE_INFOA HW_PROFILE_INFO,*LPHW_PROFILE_INFO;
#if (_WIN32_WINNT >= 0x0501)
typedef ACTCTXA ACTCTX,*PACTCTX;
typedef PCACTCTXA PCACTCTX;
#endif
#define AccessCheckAndAuditAlarm AccessCheckAndAuditAlarmA
#define AddAtom AddAtomA
#define BackupEventLog BackupEventLogA
#define BeginUpdateResource BeginUpdateResourceA
#define BuildCommDCB BuildCommDCBA
#define BuildCommDCBAndTimeouts BuildCommDCBAndTimeoutsA
#define CallNamedPipe CallNamedPipeA
#if (_WIN32_WINNT >= 0x0501)
#define CheckNameLegalDOS8Dot3 CheckNameLegalDOS8Dot3A
#endif
#define ClearEventLog ClearEventLogA
#define CommConfigDialog CommConfigDialogA
#define CopyFile CopyFileA
#define CopyFileEx CopyFileExA
#if (_WIN32_WINNT >= 0x0501)
#define CreateActCtx CreateActCtxA
#endif
#define CreateDirectory CreateDirectoryA
#define CreateDirectoryEx CreateDirectoryExA
#define CreateEvent CreateEventA
#define CreateFile CreateFileA
#define CreateFileMapping CreateFileMappingA
#if (_WIN32_WINNT >= 0x0500)
#define CreateHardLink CreateHardLinkA
#define CreateJobObject CreateJobObjectA
#endif
#define CreateMailslot CreateMailslotA
#define CreateMutex CreateMutexA
#define CreateNamedPipe CreateNamedPipeA
#define CreateProcess CreateProcessA
#define CreateProcessAsUser CreateProcessAsUserA
#define CreateSemaphore CreateSemaphoreA
#define CreateWaitableTimer CreateWaitableTimerA
#define DefineDosDevice DefineDosDeviceA
#define DeleteFile DeleteFileA
#if (_WIN32_WINNT >= 0x0500)
#define DeleteVolumeMountPoint DeleteVolumeMountPointA
#define DnsHostnameToComputerName DnsHostnameToComputerNameA
#endif
#define EncryptFile EncryptFileA
#define EndUpdateResource EndUpdateResourceA
#define EnumResourceLanguages EnumResourceLanguagesA
#define EnumResourceNames EnumResourceNamesA
#define EnumResourceTypes EnumResourceTypesA
#define ExpandEnvironmentStrings ExpandEnvironmentStringsA
#define FatalAppExit FatalAppExitA
#define FileEncryptionStatus FileEncryptionStatusA
#if (_WIN32_WINNT >= 0x0501)
#define FindActCtxSectionString FindActCtxSectionStringA
#endif
#define FindAtom FindAtomA
#define FindFirstChangeNotification FindFirstChangeNotificationA
#define FindFirstFile FindFirstFileA
#define FindFirstFileEx FindFirstFileExA
#if (_WIN32_WINNT >= 0x0500)
#define FindFirstVolume FindFirstVolumeA
#define FindFirstVolumeMountPoint FindFirstVolumeMountPointA
#endif
#define FindNextFile FindNextFileA
#if (_WIN32_WINNT >= 0x0500)
#define FindNextVolume FindNextVolumeA
#define FindNextVolumeMountPoint FindNextVolumeMountPointA
#endif
#define FindResource FindResourceA
#define FindResourceEx FindResourceExA
#define FormatMessage FormatMessageA
#define FreeEnvironmentStrings FreeEnvironmentStringsA
#define GetAtomName GetAtomNameA
#define GetBinaryType GetBinaryTypeA
#define GetCommandLine GetCommandLineA
#define GetComputerName GetComputerNameA
#define GetCompressedFileSize GetCompressedFileSizeA
#define GetCurrentDirectory GetCurrentDirectoryA
#define GetDefaultCommConfig GetDefaultCommConfigA
#define GetDiskFreeSpace GetDiskFreeSpaceA
#define GetDiskFreeSpaceEx GetDiskFreeSpaceExA
#if (_WIN32_WINNT >= 0x0502)
#define GetDllDirectory GetDllDirectoryA
#endif
#define GetDriveType GetDriveTypeA
#define GetEnvironmentVariable GetEnvironmentVariableA
#define GetFileAttributes GetFileAttributesA
#define GetFileSecurity GetFileSecurityA
#define GetFileAttributesEx GetFileAttributesExA
#define GetFullPathName GetFullPathNameA
#define GetLogicalDriveStrings GetLogicalDriveStringsA
#if (_WIN32_WINNT >= 0x0500 || _WIN32_WINDOWS >= 0x0410)
#define GetLongPathName GetLongPathNameA
#endif
#define GetNamedPipeHandleState GetNamedPipeHandleStateA
#define GetModuleHandle GetModuleHandleA
#if (_WIN32_WINNT >= 0x0500)
#define GetModuleHandleEx GetModuleHandleExA
#endif
#define GetModuleFileName GetModuleFileNameA
#define GetPrivateProfileInt GetPrivateProfileIntA
#define GetPrivateProfileSection GetPrivateProfileSectionA
#define GetPrivateProfileSectionNames GetPrivateProfileSectionNamesA
#define GetPrivateProfileString GetPrivateProfileStringA
#define GetPrivateProfileStruct GetPrivateProfileStructA
#define GetProfileInt GetProfileIntA
#define GetProfileSection GetProfileSectionA
#define GetProfileString GetProfileStringA
#define GetShortPathName GetShortPathNameA
#define GetStartupInfo GetStartupInfoA
#define GetSystemDirectory GetSystemDirectoryA
#if (_WIN32_WINNT >= 0x0500)
#define GetSystemWindowsDirectory GetSystemWindowsDirectoryA
#endif
#if (_WIN32_WINNT >= 0x0501)
#define GetSystemWow64Directory GetSystemWow64DirectoryA
#endif
#define GetTempFileName GetTempFileNameA
#define GetTempPath GetTempPathA
#define GetUserName GetUserNameA
#define GetVersionEx GetVersionExA
#define GetVolumeInformation GetVolumeInformationA
#define GetVolumeNameForVolumeMountPoint GetVolumeNameForVolumeMountPointA
#define GetVolumePathName GetVolumePathNameA
#define GetVolumePathNamesForVolumeName GetVolumePathNamesForVolumeNameA
#define GetWindowsDirectory GetWindowsDirectoryA
#define GlobalAddAtom GlobalAddAtomA
#define GlobalFindAtom GlobalFindAtomA
#define GlobalGetAtomName GlobalGetAtomNameA
#define IsBadStringPtr IsBadStringPtrA
#define LoadLibrary LoadLibraryA
#define LoadLibraryEx LoadLibraryExA
#define LogonUser LogonUserA
#define LookupAccountName LookupAccountNameA
#define LookupAccountSid LookupAccountSidA
#define LookupPrivilegeDisplayName LookupPrivilegeDisplayNameA
#define LookupPrivilegeName LookupPrivilegeNameA
#define LookupPrivilegeValue LookupPrivilegeValueA
#define lstrcat lstrcatA
#define lstrcmp lstrcmpA
#define lstrcmpi lstrcmpiA
#define lstrcpy lstrcpyA
#define lstrcpyn lstrcpynA
#define lstrlen lstrlenA
#define MoveFile MoveFileA
#define MoveFileEx MoveFileExA
#define ObjectCloseAuditAlarm ObjectCloseAuditAlarmA
#define ObjectDeleteAuditAlarm ObjectDeleteAuditAlarmA
#define ObjectOpenAuditAlarm ObjectOpenAuditAlarmA
#define ObjectPrivilegeAuditAlarm ObjectPrivilegeAuditAlarmA
#define OpenBackupEventLog OpenBackupEventLogA
#define OpenEvent OpenEventA
#define OpenEventLog OpenEventLogA
#define OpenFileMapping OpenFileMappingA
#define OpenMutex OpenMutexA
#define OpenSemaphore OpenSemaphoreA
#define OutputDebugString OutputDebugStringA
#define PrivilegedServiceAuditAlarm PrivilegedServiceAuditAlarmA
#define QueryDosDevice QueryDosDeviceA
#define ReadEventLog ReadEventLogA
#define RegisterEventSource RegisterEventSourceA
#define RemoveDirectory RemoveDirectoryA
#if (_WIN32_WINNT >= 0x0500)
#define ReplaceFile ReplaceFileA
#endif
#define ReportEvent ReportEventA
#define SearchPath SearchPathA
#define SetComputerName SetComputerNameA
#define SetCurrentDirectory SetCurrentDirectoryA
#define SetDefaultCommConfig SetDefaultCommConfigA
#if (_WIN32_WINNT >= 0x0502)
#define SetDllDirectory SetDllDirectoryA
#endif
#define SetEnvironmentVariable SetEnvironmentVariableA
#define SetFileAttributes SetFileAttributesA
#define SetFileSecurity SetFileSecurityA
#if (_WIN32_WINNT >= 0x0501)
#define SetFileShortName SetFileShortNameA
#endif
#if (_WIN32_WINNT >= 0x0502)
#define SetFirmwareEnvironmentVariable SetFirmwareEnvironmentVariableA
#endif
#define SetVolumeLabel SetVolumeLabelA
#define SetVolumeMountPoint SetVolumeMountPointA
#define UpdateResource UpdateResourceA
#define VerifyVersionInfo VerifyVersionInfoA
#define WaitNamedPipe WaitNamedPipeA
#define WritePrivateProfileSection WritePrivateProfileSectionA
#define WritePrivateProfileString WritePrivateProfileStringA
#define WritePrivateProfileStruct WritePrivateProfileStructA
#define WriteProfileSection WriteProfileSectionA
#define WriteProfileString WriteProfileStringA
#endif
#endif

#ifdef __cplusplus
}
#endif
#endif /* _WINBASE_H */
