# Contributing to SlimToolkit

If you want to contribute submit a GitHub pull request or open an issue. Thank you!

## TL;DR

Any contribution is better than no contribution :-) Submit a [pull request](https://help.github.com/articles/using-pull-requests) or open an issue even if you are not sure or if you feel the contribution is not significant enough. If you want to accelerate the process you can follow the guidelines below.

There's a number of already open issues with the `good first issue` tag. Start there if you are new to the project. Explore the issues with the `help wanted` tag too. Help with any open issue is highly appreciated, of course.

You can also take a look at the [`ROADMAP`](ROADMAP.md) to get ideas for your contribution. Also take a look at the [`WISHLIST`](WISHLIST.md) doc, which includes even more potential improvements (that are not a part of the roadmap yet, but they are still valuable).

## Code

To learn more about the code take a look at the `SlimToolkit Code` videos on ['YouTube'](https://www.youtube.com/channel/UCy7RHjJlaBhpCCbChrd8POA?sub_confirmation=1)

## Guidelines

### Reporting Issues

Open an issue and provide enough cotext information to repro the condition. Don't worry if it's not possible to reproduce (reliably). Submit an issue anyways including the information you do have. The version information should be provided in all bug reports.

### Environment Setup

See the `BUILD PROCESS` section in the `README.md` file.

### Enhancements

Take a look at the open issues or feel free to create a new issue if what you'd like to do doesn't have an issue already. This includes documentation enhancements and design proposals too. When you submit your [pull request](https://help.github.com/articles/using-pull-requests) make sure to reference the issue.

### Coding Standards

The coding standards are based on the [Golang community standards](https://github.com/golang/go/wiki/CodeReviewComments). Make sure to leverage the `scripts/src.fmt.sh` and `scripts/src.inspect.sh` helper scripts or their equivalent.

### Dependencies

TBD - information about adding dependencies

### Testing

Yes :-)

### Documentation

Yes :-)

### Pull Requests

Standard guidelines for [pull requests](https://help.github.com/articles/using-pull-requests)

### Sign Your Code

Please certify your [Developer Certificate of Origin (DCO)](https://developercertificate.org/), by signing off your commit with `git commit -s` (use your real name).
