package creds

// List of all available hash-types, for completions.
// Unfortunately this list has to be maintained manually,
// until someone devises a way to do so automatically.
var hashTypes = map[string]string{
	"MD5": "MD5", // Enum 0 in proto file.

	"MD4":                   "MD4",
	"SHA1":                  "SHA1",
	"SHA2_224":              "SHA2-224",
	"SHA2_256":              "SHA2-256",
	"SHA2_384":              "SHA2-384",
	"SHA2_512":              "SHA2-512",
	"SHA3_224":              "SHA3-224",
	"SHA3_256":              "SHA3-256",
	"SHA3_384":              "SHA3-384",
	"SHA3_512":              "SHA3-512",
	"RIPEMD_160":            "RIPEMD-160",
	"BLAKE2B_256":           "BLAKE2b-512",
	"GOST_R_32_11_2012_256": "GOST R 34.11-2012 (Streebog) 256-bit, big-endian",
	"GOST_R_32_11_2012_512": "GOST R 34.11-2012 (Streebog) 512-bit, big-endian",
	"GOST_R_34_11_94":       "GOST R 34.11-94",
	"GPG":                   "GPG (AES-128/AES-256 (SHA-1($pass)))",
	"HALF_MD5":              "Half MD5",
	"KECCAK_224":            "Keccak-224",
	"KECCAK_256":            "Keccak-256",
	"KECCAK_384":            "Keccak-384",
	"KECCAK_512":            "Keccak-512",
	"WHIRLPOOL":             "Whirlpool",
	"SIPHASH":               "SipHash",
	"MD5_UTF16LE":           "md5(utf16le($pass))",
	"SHA1_UTF16LE":          "sha1(utf16le($pass))",
	"SHA256_UTF16LE":        "sha256(utf16le($pass))",
	"SHA384_UTF16LE":        "sha384(utf16le($pass))",
	"SHA512_UTF16LE":        "sha512(utf16le($pass))",
	"BLAKE2B_512_PW_SALT":   "BLAKE2b-512($pass.$salt)",
	"BLAKE2B_512_SALT_PW":   "BLAKE2b-512($salt.$pass)",
	"MD5_PW_SALT":           "md5($pass.$salt)",
	"MD5_SALT_PW":           "md5($salt.$pass)",
	"MD5_SALT_PW_SALT":      "md5($salt.$pass.$salt)",
	"MD5_SALT_MD5_PW":       "md5($salt.md5($pass))",

	// ... TODO fill in the rest ...,

	"CRC32":                        "CRC32",
	"CRC32C":                       "CRC32B",
	"CRC64Jones":                   "CRC64-Jones",
	"JAVA_OBJECT":                  "Java object",
	"MURMUR":                       "MurmurHash",
	"MURMUR3":                      "MurmurHash3",
	"THREE_DES":                    "3DES (PT = $salt, key = $pass)",
	"DES":                          "DES (PT = $salt, key = $pass)",
	"AES_128_ECB":                  "AES-128-ECB NOKDF (PT = $salt, key = $pass)",
	"AES_192_ECB":                  "AES-192-ECB NOKDF (PT = $salt, key = $pass)",
	"AES_256_ECB":                  "AES-256-ECB NOKDF (PT = $salt, key = $pass)",
	"CHA_CHA_20":                   "ChaCha20",
	"LINUX_KERNEL_CRYPTO_API_24":   "Linux Kernel Crypto API (2.4)",
	"SKIP_32":                      "Skip32 (PT = $salt, key = $pass)",
	"PBKDF2_HMAC_MD5":              "PBKDF2-HMAC-MD5",
	"PBKDF2_HMAC_SHA1":             "PBKDF2-HMAC-SHA1",
	"PBKDF2_HMAC_SHA256":           "PBKDF2-HMAC-SHA256",
	"PBKDF2_HMAC_SHA512":           "PBKDF2-HMAC-SHA512",
	"SCRYPT":                       "scrypt",
	"PHPASS":                       "phpass",
	"TACACS_PLUS":                  "TACACS+",
	"SIP_DIGEST":                   "SIP digest authentication (MD5)",
	"IKE_MD5":                      "IKE-PSK MD5",
	"IKE_SHA1":                     "IKE-PSK SHA1",
	"SNMP_V3_HMAC_MD5_96":          "SNMPv3 HMAC-MD5-96",
	"SNMP_V3_HMAC_MD5_96__SHA1_96": "SNMPv3 HMAC-MD5-96 / HMAC-SHA1-96",
	"SNMP_V3_HMAC_SHA1_96":         "SNMPv3 HMAC-SHA1-96",
	"SNMP_V3_HMAC_SHA224_128":      "SNMPv3 HMAC-SHA224-128",
	"SNMP_V3_HMAC_SHA256_192":      "SNMPv3 HMAC-SHA256-192",
	"SNMP_V3_HMAC_SHA384_256":      "SNMPv3 HMAC-SHA384-256",
	"SNMP_V3_HMAC_SHA512_384":      "SNMPv3 HMAC-SHA512-384",
	"WPA_EAPOL_PBKDF2":             "WPA-EAPOL-PBKDF2",
	"WPA_EAPOL_PMK":                "WPA-EAPOL-PMK",
	"WPA_PBKDF2_PMKID_EAPOL":       "WPA-PBKDF2-PMKID+EAPOL",
	"WPA_PMK_PMKID_EAPOL":          "WPA-PMK-PMKID+EAPOL",
	"WPA_PMKID_PBKDF2":             "WPA-PMKID-PBKDF2",
	"WPA_PMKID_PMK":                "WPA-PMKID-PMK",
	"IPMI2_PAKP_HMAC_SHA1":         "IPMI2 RAKP HMAC-SHA1",
	"CRAM_MD5":                     "CRAM-MD5",
	"JWT":                          "JWT (JSON Web Token)",
	"RADMIN_3":                     "Radmin3",
	"KERBEROS_17_TGS_REP":          "Kerberos 5, etype 17, TGS-REP",
	"KERBEROS_17_PREAUTH":          "Kerberos 5, etype 17, Pre-Auth",
	"KERBEROS_17_DB":               "Kerberos 5, etype 17, DB",
	"KERBEROS_18_TGS_REP":          "Kerberos 5, etype 18, TGS-REP",
	"KERBEROS_18_PREAUTH":          "Kerberos 5, etype 18, Pre-Auth",
	"KERBEROS_18_DB":               "Kerberos 5, etype 18, DB",
	"KERBEROS_23_SA_REQ_PREAUTH":   "Kerberos 5, etype 23, AS-REQ Pre-Auth",
	"KERBEROS_23_TGS_REP":          "Kerberos 5, etype 23, TGS-REP",
	"KERBEROS_23_AS_REP":           "Kerberos 5, etype 23, AS-REP",
	"NET_NTLM_V1":                  "NetNTLMv1 / NetNTLMv1+ESS",
	"NET_NTLM_V1_NT":               "NetNTLMv1 / NetNTLMv1+ESS (NT)",
	"NET_NTLM_V2":                  "NetNTLMv2",
	"NET_NTLM_V2_NT":               "NetNTLMv2 (NT)",
	"FLASK":                        "Flask Session Cookie ($salt.$salt.$pass)",
	"ISCSI_CHAP":                   "iSCSI CHAP authentication, MD5(CHAP)",
	"RACF":                         "Resource Access Control Facility",
	"AIX_SMD5":                     "AIX MD5",
	"AIX_SSHA1":                    "AIX SHA-1",
	"AIX_SSHA256":                  "AIX SHA-256",
	"AIX_SSHA512":                  "AIX SHA-512",
	"LM":                           "LM",
	"QNX_MD5":                      "QNX /etc/shadow (MD5)",
	"QNX_SHA256":                   "QNX /etc/shadow (SHA256)",
	"QNX_SHA512":                   "QNX /etc/shadow (SHA512)",
	"DPAPI_V1_CTX_1_AND_2":         "DPAPI masterkey file v1 (context 1 and 2)",
	"DPAPI_V1_CTX_3":               "DPAPI masterkey file v1 (context 3)",
	"DPAPI_V2_CTX_1_AND_2":         "DPAPI masterkey file v2 (context 1)",
	"DPAPI_V2_CTX_3":               "DPAPI masterkey file v2 (context 3)",
	"GRUB_2":                       "GRUB 2",
	"MS_AZURE_SYNC":                "MS-AzureSync PBKDF2-HMAC-SHA256",
	"BSDI_CRYPT":                   "BSDi Crypt, Extended DES",
	"NTLM":                         "NTLM",
	"RADMIN2":                      "Radmin2",
	"SAMSUNG_ANDROID":              "Samsung Android Password/PIN",
	"WINDOWS_HELLO_PIN":            "Windows Hello PIN/Password",
	"WINDOWS_PHONE":                "Windows Phone 8+ PIN/Password",
	"CISCO_ASA_MD5":                "Cisco-ASA MD5",
	"CISCO_IOS_PBKDF2_SHA256":      "Cisco-IOS $8$ (PBKDF2-SHA256)",
	"CISCO_IOS_SCRYPT":             "Cisco-IOS $9$ (scrypt)",
	"CISCO_PIX_MD5":                "Cisco-Pix MD5",
	"CITRIX_NETSCALER_SHA1":        "Citrix NetScaler (SHA1)",
	"CITRIX_NETSCALER_SHA512":      "Citrix NetScaler (SHA512)",
	"DCC":                          "Domain Cached Credentials (DCC), MS Cache",
	"DCC2":                         "Domain Cached Credentials 2 (DCC2), MS Cache 2",

	// ...

	"MACOS_10_8": "macOS v10.8+ (PBKDF2-SHA512)",

	// ...

	// INVALID = 9999; // Invalid hash type

	// Out of order
	"BCRYPT_UNIX":       "bcrypt",
	"SHA512_CRYPT_UNIX": "sha512crypt $6$, SHA512 (Unix)",
}
