/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"bytes"
	"fmt"
)

// checks if the Contact type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &Contact{}

// Contact struct for Contact
type Contact struct {
	// Contact ID.
	Id int32 `json:"id"`
	// Is the Contact favorite? [Favorite list](https://docs.textmagic.com/#operation/getFavorites).
	Favorited bool `json:"favorited"`
	// Is the Contact blocked? [Blocked contacts](https://docs.textmagic.com/#operation/getBlockedContacts).
	Blocked bool `json:"blocked"`
	// Contact first name.
	FirstName NullableString `json:"firstName"`
	// Contact last name.
	LastName NullableString `json:"lastName"`
	// Company name.
	CompanyName NullableString `json:"companyName"`
	// Phone number in [E.164 format](https://en.wikipedia.org/wiki/E.164).
	Phone NullableString `json:"phone"`
	// Contact email address.
	Email NullableString `json:"email"`
	Country NullableCountry `json:"country"`
	CustomFields []CustomFieldListItem `json:"customFields"`
	User NullableUser `json:"user"`
	Lists []List `json:"lists"`
	Owner NullableUser `json:"owner,omitempty"`
	Tags []Tag `json:"tags,omitempty"`
	// Phone number type: * **0** if it is fixed-line; * **1** if it is mobile; * **2** if it is mobile or fixed-line (in case we cannot distingush between fixed-line or mobile); * **3** if it is toll-free; * **4** if it is a premium rate phone; * **5** if it is a shared cost phone; * **6** if it is a VoIP; * **7** if it is a [Personal Number](); * **8** if it is a pager; * **9** if it is a Universal Access Number; * **10** if the phone type is unknown; * **-1** if the phone type is not yet processed or cannot be determined. 
	PhoneType NullableString `json:"phoneType"`
	Avatar NullableContactImage `json:"avatar"`
	Notes []ContactNote `json:"notes"`
	// Whatsapp phone number in [E.164 format](https://en.wikipedia.org/wiki/E.164).
	WhatsappPhone NullableString `json:"whatsappPhone,omitempty"`
}

type _Contact Contact

// NewContact instantiates a new Contact object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewContact(id int32, favorited bool, blocked bool, firstName NullableString, lastName NullableString, companyName NullableString, phone NullableString, email NullableString, country NullableCountry, customFields []CustomFieldListItem, user NullableUser, lists []List, phoneType NullableString, avatar NullableContactImage, notes []ContactNote) *Contact {
	this := Contact{}
	this.Id = id
	this.Favorited = favorited
	this.Blocked = blocked
	this.FirstName = firstName
	this.LastName = lastName
	this.CompanyName = companyName
	this.Phone = phone
	this.Email = email
	this.Country = country
	this.CustomFields = customFields
	this.User = user
	this.Lists = lists
	this.PhoneType = phoneType
	this.Avatar = avatar
	this.Notes = notes
	return &this
}

// NewContactWithDefaults instantiates a new Contact object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewContactWithDefaults() *Contact {
	this := Contact{}
	return &this
}

// GetId returns the Id field value
func (o *Contact) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *Contact) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *Contact) SetId(v int32) {
	o.Id = v
}

// GetFavorited returns the Favorited field value
func (o *Contact) GetFavorited() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.Favorited
}

// GetFavoritedOk returns a tuple with the Favorited field value
// and a boolean to check if the value has been set.
func (o *Contact) GetFavoritedOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Favorited, true
}

// SetFavorited sets field value
func (o *Contact) SetFavorited(v bool) {
	o.Favorited = v
}

// GetBlocked returns the Blocked field value
func (o *Contact) GetBlocked() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.Blocked
}

// GetBlockedOk returns a tuple with the Blocked field value
// and a boolean to check if the value has been set.
func (o *Contact) GetBlockedOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Blocked, true
}

// SetBlocked sets field value
func (o *Contact) SetBlocked(v bool) {
	o.Blocked = v
}

// GetFirstName returns the FirstName field value
// If the value is explicit nil, the zero value for string will be returned
func (o *Contact) GetFirstName() string {
	if o == nil || o.FirstName.Get() == nil {
		var ret string
		return ret
	}

	return *o.FirstName.Get()
}

// GetFirstNameOk returns a tuple with the FirstName field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Contact) GetFirstNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.FirstName.Get(), o.FirstName.IsSet()
}

// SetFirstName sets field value
func (o *Contact) SetFirstName(v string) {
	o.FirstName.Set(&v)
}

// GetLastName returns the LastName field value
// If the value is explicit nil, the zero value for string will be returned
func (o *Contact) GetLastName() string {
	if o == nil || o.LastName.Get() == nil {
		var ret string
		return ret
	}

	return *o.LastName.Get()
}

// GetLastNameOk returns a tuple with the LastName field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Contact) GetLastNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.LastName.Get(), o.LastName.IsSet()
}

// SetLastName sets field value
func (o *Contact) SetLastName(v string) {
	o.LastName.Set(&v)
}

// GetCompanyName returns the CompanyName field value
// If the value is explicit nil, the zero value for string will be returned
func (o *Contact) GetCompanyName() string {
	if o == nil || o.CompanyName.Get() == nil {
		var ret string
		return ret
	}

	return *o.CompanyName.Get()
}

// GetCompanyNameOk returns a tuple with the CompanyName field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Contact) GetCompanyNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.CompanyName.Get(), o.CompanyName.IsSet()
}

// SetCompanyName sets field value
func (o *Contact) SetCompanyName(v string) {
	o.CompanyName.Set(&v)
}

// GetPhone returns the Phone field value
// If the value is explicit nil, the zero value for string will be returned
func (o *Contact) GetPhone() string {
	if o == nil || o.Phone.Get() == nil {
		var ret string
		return ret
	}

	return *o.Phone.Get()
}

// GetPhoneOk returns a tuple with the Phone field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Contact) GetPhoneOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Phone.Get(), o.Phone.IsSet()
}

// SetPhone sets field value
func (o *Contact) SetPhone(v string) {
	o.Phone.Set(&v)
}

// GetEmail returns the Email field value
// If the value is explicit nil, the zero value for string will be returned
func (o *Contact) GetEmail() string {
	if o == nil || o.Email.Get() == nil {
		var ret string
		return ret
	}

	return *o.Email.Get()
}

// GetEmailOk returns a tuple with the Email field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Contact) GetEmailOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Email.Get(), o.Email.IsSet()
}

// SetEmail sets field value
func (o *Contact) SetEmail(v string) {
	o.Email.Set(&v)
}

// GetCountry returns the Country field value
// If the value is explicit nil, the zero value for Country will be returned
func (o *Contact) GetCountry() Country {
	if o == nil || o.Country.Get() == nil {
		var ret Country
		return ret
	}

	return *o.Country.Get()
}

// GetCountryOk returns a tuple with the Country field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Contact) GetCountryOk() (*Country, bool) {
	if o == nil {
		return nil, false
	}
	return o.Country.Get(), o.Country.IsSet()
}

// SetCountry sets field value
func (o *Contact) SetCountry(v Country) {
	o.Country.Set(&v)
}

// GetCustomFields returns the CustomFields field value
func (o *Contact) GetCustomFields() []CustomFieldListItem {
	if o == nil {
		var ret []CustomFieldListItem
		return ret
	}

	return o.CustomFields
}

// GetCustomFieldsOk returns a tuple with the CustomFields field value
// and a boolean to check if the value has been set.
func (o *Contact) GetCustomFieldsOk() ([]CustomFieldListItem, bool) {
	if o == nil {
		return nil, false
	}
	return o.CustomFields, true
}

// SetCustomFields sets field value
func (o *Contact) SetCustomFields(v []CustomFieldListItem) {
	o.CustomFields = v
}

// GetUser returns the User field value
// If the value is explicit nil, the zero value for User will be returned
func (o *Contact) GetUser() User {
	if o == nil || o.User.Get() == nil {
		var ret User
		return ret
	}

	return *o.User.Get()
}

// GetUserOk returns a tuple with the User field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Contact) GetUserOk() (*User, bool) {
	if o == nil {
		return nil, false
	}
	return o.User.Get(), o.User.IsSet()
}

// SetUser sets field value
func (o *Contact) SetUser(v User) {
	o.User.Set(&v)
}

// GetLists returns the Lists field value
func (o *Contact) GetLists() []List {
	if o == nil {
		var ret []List
		return ret
	}

	return o.Lists
}

// GetListsOk returns a tuple with the Lists field value
// and a boolean to check if the value has been set.
func (o *Contact) GetListsOk() ([]List, bool) {
	if o == nil {
		return nil, false
	}
	return o.Lists, true
}

// SetLists sets field value
func (o *Contact) SetLists(v []List) {
	o.Lists = v
}

// GetOwner returns the Owner field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *Contact) GetOwner() User {
	if o == nil || IsNil(o.Owner.Get()) {
		var ret User
		return ret
	}
	return *o.Owner.Get()
}

// GetOwnerOk returns a tuple with the Owner field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Contact) GetOwnerOk() (*User, bool) {
	if o == nil {
		return nil, false
	}
	return o.Owner.Get(), o.Owner.IsSet()
}

// HasOwner returns a boolean if a field has been set.
func (o *Contact) HasOwner() bool {
	if o != nil && o.Owner.IsSet() {
		return true
	}

	return false
}

// SetOwner gets a reference to the given NullableUser and assigns it to the Owner field.
func (o *Contact) SetOwner(v User) {
	o.Owner.Set(&v)
}
// SetOwnerNil sets the value for Owner to be an explicit nil
func (o *Contact) SetOwnerNil() {
	o.Owner.Set(nil)
}

// UnsetOwner ensures that no value is present for Owner, not even an explicit nil
func (o *Contact) UnsetOwner() {
	o.Owner.Unset()
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *Contact) GetTags() []Tag {
	if o == nil || IsNil(o.Tags) {
		var ret []Tag
		return ret
	}
	return o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Contact) GetTagsOk() ([]Tag, bool) {
	if o == nil || IsNil(o.Tags) {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *Contact) HasTags() bool {
	if o != nil && !IsNil(o.Tags) {
		return true
	}

	return false
}

// SetTags gets a reference to the given []Tag and assigns it to the Tags field.
func (o *Contact) SetTags(v []Tag) {
	o.Tags = v
}

// GetPhoneType returns the PhoneType field value
// If the value is explicit nil, the zero value for string will be returned
func (o *Contact) GetPhoneType() string {
	if o == nil || o.PhoneType.Get() == nil {
		var ret string
		return ret
	}

	return *o.PhoneType.Get()
}

// GetPhoneTypeOk returns a tuple with the PhoneType field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Contact) GetPhoneTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.PhoneType.Get(), o.PhoneType.IsSet()
}

// SetPhoneType sets field value
func (o *Contact) SetPhoneType(v string) {
	o.PhoneType.Set(&v)
}

// GetAvatar returns the Avatar field value
// If the value is explicit nil, the zero value for ContactImage will be returned
func (o *Contact) GetAvatar() ContactImage {
	if o == nil || o.Avatar.Get() == nil {
		var ret ContactImage
		return ret
	}

	return *o.Avatar.Get()
}

// GetAvatarOk returns a tuple with the Avatar field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Contact) GetAvatarOk() (*ContactImage, bool) {
	if o == nil {
		return nil, false
	}
	return o.Avatar.Get(), o.Avatar.IsSet()
}

// SetAvatar sets field value
func (o *Contact) SetAvatar(v ContactImage) {
	o.Avatar.Set(&v)
}

// GetNotes returns the Notes field value
func (o *Contact) GetNotes() []ContactNote {
	if o == nil {
		var ret []ContactNote
		return ret
	}

	return o.Notes
}

// GetNotesOk returns a tuple with the Notes field value
// and a boolean to check if the value has been set.
func (o *Contact) GetNotesOk() ([]ContactNote, bool) {
	if o == nil {
		return nil, false
	}
	return o.Notes, true
}

// SetNotes sets field value
func (o *Contact) SetNotes(v []ContactNote) {
	o.Notes = v
}

// GetWhatsappPhone returns the WhatsappPhone field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *Contact) GetWhatsappPhone() string {
	if o == nil || IsNil(o.WhatsappPhone.Get()) {
		var ret string
		return ret
	}
	return *o.WhatsappPhone.Get()
}

// GetWhatsappPhoneOk returns a tuple with the WhatsappPhone field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Contact) GetWhatsappPhoneOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.WhatsappPhone.Get(), o.WhatsappPhone.IsSet()
}

// HasWhatsappPhone returns a boolean if a field has been set.
func (o *Contact) HasWhatsappPhone() bool {
	if o != nil && o.WhatsappPhone.IsSet() {
		return true
	}

	return false
}

// SetWhatsappPhone gets a reference to the given NullableString and assigns it to the WhatsappPhone field.
func (o *Contact) SetWhatsappPhone(v string) {
	o.WhatsappPhone.Set(&v)
}
// SetWhatsappPhoneNil sets the value for WhatsappPhone to be an explicit nil
func (o *Contact) SetWhatsappPhoneNil() {
	o.WhatsappPhone.Set(nil)
}

// UnsetWhatsappPhone ensures that no value is present for WhatsappPhone, not even an explicit nil
func (o *Contact) UnsetWhatsappPhone() {
	o.WhatsappPhone.Unset()
}

func (o Contact) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o Contact) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["favorited"] = o.Favorited
	toSerialize["blocked"] = o.Blocked
	toSerialize["firstName"] = o.FirstName.Get()
	toSerialize["lastName"] = o.LastName.Get()
	toSerialize["companyName"] = o.CompanyName.Get()
	toSerialize["phone"] = o.Phone.Get()
	toSerialize["email"] = o.Email.Get()
	toSerialize["country"] = o.Country.Get()
	toSerialize["customFields"] = o.CustomFields
	toSerialize["user"] = o.User.Get()
	toSerialize["lists"] = o.Lists
	if o.Owner.IsSet() {
		toSerialize["owner"] = o.Owner.Get()
	}
	if !IsNil(o.Tags) {
		toSerialize["tags"] = o.Tags
	}
	toSerialize["phoneType"] = o.PhoneType.Get()
	toSerialize["avatar"] = o.Avatar.Get()
	toSerialize["notes"] = o.Notes
	if o.WhatsappPhone.IsSet() {
		toSerialize["whatsappPhone"] = o.WhatsappPhone.Get()
	}
	return toSerialize, nil
}

func (o *Contact) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"favorited",
		"blocked",
		"firstName",
		"lastName",
		"companyName",
		"phone",
		"email",
		"country",
		"customFields",
		"user",
		"lists",
		"phoneType",
		"avatar",
		"notes",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varContact := _Contact{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varContact)

	if err != nil {
		return err
	}

	*o = Contact(varContact)

	return err
}

type NullableContact struct {
	value *Contact
	isSet bool
}

func (v NullableContact) Get() *Contact {
	return v.value
}

func (v *NullableContact) Set(val *Contact) {
	v.value = val
	v.isSet = true
}

func (v NullableContact) IsSet() bool {
	return v.isSet
}

func (v *NullableContact) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableContact(val *Contact) *NullableContact {
	return &NullableContact{value: val, isSet: true}
}

func (v NullableContact) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableContact) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


