/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"time"
	"bytes"
	"fmt"
)

// checks if the Conversation type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &Conversation{}

// Conversation struct for Conversation
type Conversation struct {
	Id int32 `json:"id"`
	// Message type: inbound or outbound. 
	Direction string `json:"direction"`
	// Sender phone number.
	Sender NullableString `json:"sender"`
	// Time when  the message arrived at Textmagic.
	MessageTime time.Time `json:"messageTime"`
	// Message text.
	Text string `json:"text"`
	// Receiver's phone number.
	Receiver string `json:"receiver"`
	// Message status (for chats outbound only). See [message delivery statuses](https://docs.textmagic.com/#section/Delivery-status-codes) for details.
	Status string `json:"status"`
	// Contact first name.
	FirstName string `json:"firstName"`
	// Contact last name.
	LastName string `json:"lastName"`
	// Session ID of a message. See [message sessions](https://docs.textmagic.com/#tag/Outbound-Message-Sessions) for details.
	SessionId NullableInt32 `json:"sessionId"`
	// Initiator ID of a message. See [message sessions](https://docs.textmagic.com/#tag/Outbound-Message-Sessions) for details.
	InitiatorId NullableInt32 `json:"initiatorId,omitempty"`
	// Message file id.
	MessageFileId NullableInt32 `json:"messageFileId,omitempty"`
	// Message type.
	Type *string `json:"type,omitempty"`
	// Chat type.
	ChatType *string `json:"chatType,omitempty"`
	// Chat id.
	ChatId *int32 `json:"chatId,omitempty"`
	IsEdited *bool `json:"isEdited,omitempty"`
	// Error code.
	ErrorCode NullableString `json:"errorCode,omitempty"`
	Files []File `json:"files,omitempty"`
	Payload NullableMessagePayload `json:"payload,omitempty"`
	Avatar NullableString `json:"avatar,omitempty"`
}

type _Conversation Conversation

// NewConversation instantiates a new Conversation object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewConversation(id int32, direction string, sender NullableString, messageTime time.Time, text string, receiver string, status string, firstName string, lastName string, sessionId NullableInt32) *Conversation {
	this := Conversation{}
	this.Id = id
	this.Direction = direction
	this.Sender = sender
	this.MessageTime = messageTime
	this.Text = text
	this.Receiver = receiver
	this.Status = status
	this.FirstName = firstName
	this.LastName = lastName
	this.SessionId = sessionId
	return &this
}

// NewConversationWithDefaults instantiates a new Conversation object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewConversationWithDefaults() *Conversation {
	this := Conversation{}
	return &this
}

// GetId returns the Id field value
func (o *Conversation) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *Conversation) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *Conversation) SetId(v int32) {
	o.Id = v
}

// GetDirection returns the Direction field value
func (o *Conversation) GetDirection() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Direction
}

// GetDirectionOk returns a tuple with the Direction field value
// and a boolean to check if the value has been set.
func (o *Conversation) GetDirectionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Direction, true
}

// SetDirection sets field value
func (o *Conversation) SetDirection(v string) {
	o.Direction = v
}

// GetSender returns the Sender field value
// If the value is explicit nil, the zero value for string will be returned
func (o *Conversation) GetSender() string {
	if o == nil || o.Sender.Get() == nil {
		var ret string
		return ret
	}

	return *o.Sender.Get()
}

// GetSenderOk returns a tuple with the Sender field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Conversation) GetSenderOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Sender.Get(), o.Sender.IsSet()
}

// SetSender sets field value
func (o *Conversation) SetSender(v string) {
	o.Sender.Set(&v)
}

// GetMessageTime returns the MessageTime field value
func (o *Conversation) GetMessageTime() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.MessageTime
}

// GetMessageTimeOk returns a tuple with the MessageTime field value
// and a boolean to check if the value has been set.
func (o *Conversation) GetMessageTimeOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.MessageTime, true
}

// SetMessageTime sets field value
func (o *Conversation) SetMessageTime(v time.Time) {
	o.MessageTime = v
}

// GetText returns the Text field value
func (o *Conversation) GetText() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Text
}

// GetTextOk returns a tuple with the Text field value
// and a boolean to check if the value has been set.
func (o *Conversation) GetTextOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Text, true
}

// SetText sets field value
func (o *Conversation) SetText(v string) {
	o.Text = v
}

// GetReceiver returns the Receiver field value
func (o *Conversation) GetReceiver() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Receiver
}

// GetReceiverOk returns a tuple with the Receiver field value
// and a boolean to check if the value has been set.
func (o *Conversation) GetReceiverOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Receiver, true
}

// SetReceiver sets field value
func (o *Conversation) SetReceiver(v string) {
	o.Receiver = v
}

// GetStatus returns the Status field value
func (o *Conversation) GetStatus() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Status
}

// GetStatusOk returns a tuple with the Status field value
// and a boolean to check if the value has been set.
func (o *Conversation) GetStatusOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Status, true
}

// SetStatus sets field value
func (o *Conversation) SetStatus(v string) {
	o.Status = v
}

// GetFirstName returns the FirstName field value
func (o *Conversation) GetFirstName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.FirstName
}

// GetFirstNameOk returns a tuple with the FirstName field value
// and a boolean to check if the value has been set.
func (o *Conversation) GetFirstNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.FirstName, true
}

// SetFirstName sets field value
func (o *Conversation) SetFirstName(v string) {
	o.FirstName = v
}

// GetLastName returns the LastName field value
func (o *Conversation) GetLastName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.LastName
}

// GetLastNameOk returns a tuple with the LastName field value
// and a boolean to check if the value has been set.
func (o *Conversation) GetLastNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.LastName, true
}

// SetLastName sets field value
func (o *Conversation) SetLastName(v string) {
	o.LastName = v
}

// GetSessionId returns the SessionId field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *Conversation) GetSessionId() int32 {
	if o == nil || o.SessionId.Get() == nil {
		var ret int32
		return ret
	}

	return *o.SessionId.Get()
}

// GetSessionIdOk returns a tuple with the SessionId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Conversation) GetSessionIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.SessionId.Get(), o.SessionId.IsSet()
}

// SetSessionId sets field value
func (o *Conversation) SetSessionId(v int32) {
	o.SessionId.Set(&v)
}

// GetInitiatorId returns the InitiatorId field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *Conversation) GetInitiatorId() int32 {
	if o == nil || IsNil(o.InitiatorId.Get()) {
		var ret int32
		return ret
	}
	return *o.InitiatorId.Get()
}

// GetInitiatorIdOk returns a tuple with the InitiatorId field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Conversation) GetInitiatorIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.InitiatorId.Get(), o.InitiatorId.IsSet()
}

// HasInitiatorId returns a boolean if a field has been set.
func (o *Conversation) HasInitiatorId() bool {
	if o != nil && o.InitiatorId.IsSet() {
		return true
	}

	return false
}

// SetInitiatorId gets a reference to the given NullableInt32 and assigns it to the InitiatorId field.
func (o *Conversation) SetInitiatorId(v int32) {
	o.InitiatorId.Set(&v)
}
// SetInitiatorIdNil sets the value for InitiatorId to be an explicit nil
func (o *Conversation) SetInitiatorIdNil() {
	o.InitiatorId.Set(nil)
}

// UnsetInitiatorId ensures that no value is present for InitiatorId, not even an explicit nil
func (o *Conversation) UnsetInitiatorId() {
	o.InitiatorId.Unset()
}

// GetMessageFileId returns the MessageFileId field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *Conversation) GetMessageFileId() int32 {
	if o == nil || IsNil(o.MessageFileId.Get()) {
		var ret int32
		return ret
	}
	return *o.MessageFileId.Get()
}

// GetMessageFileIdOk returns a tuple with the MessageFileId field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Conversation) GetMessageFileIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.MessageFileId.Get(), o.MessageFileId.IsSet()
}

// HasMessageFileId returns a boolean if a field has been set.
func (o *Conversation) HasMessageFileId() bool {
	if o != nil && o.MessageFileId.IsSet() {
		return true
	}

	return false
}

// SetMessageFileId gets a reference to the given NullableInt32 and assigns it to the MessageFileId field.
func (o *Conversation) SetMessageFileId(v int32) {
	o.MessageFileId.Set(&v)
}
// SetMessageFileIdNil sets the value for MessageFileId to be an explicit nil
func (o *Conversation) SetMessageFileIdNil() {
	o.MessageFileId.Set(nil)
}

// UnsetMessageFileId ensures that no value is present for MessageFileId, not even an explicit nil
func (o *Conversation) UnsetMessageFileId() {
	o.MessageFileId.Unset()
}

// GetType returns the Type field value if set, zero value otherwise.
func (o *Conversation) GetType() string {
	if o == nil || IsNil(o.Type) {
		var ret string
		return ret
	}
	return *o.Type
}

// GetTypeOk returns a tuple with the Type field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Conversation) GetTypeOk() (*string, bool) {
	if o == nil || IsNil(o.Type) {
		return nil, false
	}
	return o.Type, true
}

// HasType returns a boolean if a field has been set.
func (o *Conversation) HasType() bool {
	if o != nil && !IsNil(o.Type) {
		return true
	}

	return false
}

// SetType gets a reference to the given string and assigns it to the Type field.
func (o *Conversation) SetType(v string) {
	o.Type = &v
}

// GetChatType returns the ChatType field value if set, zero value otherwise.
func (o *Conversation) GetChatType() string {
	if o == nil || IsNil(o.ChatType) {
		var ret string
		return ret
	}
	return *o.ChatType
}

// GetChatTypeOk returns a tuple with the ChatType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Conversation) GetChatTypeOk() (*string, bool) {
	if o == nil || IsNil(o.ChatType) {
		return nil, false
	}
	return o.ChatType, true
}

// HasChatType returns a boolean if a field has been set.
func (o *Conversation) HasChatType() bool {
	if o != nil && !IsNil(o.ChatType) {
		return true
	}

	return false
}

// SetChatType gets a reference to the given string and assigns it to the ChatType field.
func (o *Conversation) SetChatType(v string) {
	o.ChatType = &v
}

// GetChatId returns the ChatId field value if set, zero value otherwise.
func (o *Conversation) GetChatId() int32 {
	if o == nil || IsNil(o.ChatId) {
		var ret int32
		return ret
	}
	return *o.ChatId
}

// GetChatIdOk returns a tuple with the ChatId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Conversation) GetChatIdOk() (*int32, bool) {
	if o == nil || IsNil(o.ChatId) {
		return nil, false
	}
	return o.ChatId, true
}

// HasChatId returns a boolean if a field has been set.
func (o *Conversation) HasChatId() bool {
	if o != nil && !IsNil(o.ChatId) {
		return true
	}

	return false
}

// SetChatId gets a reference to the given int32 and assigns it to the ChatId field.
func (o *Conversation) SetChatId(v int32) {
	o.ChatId = &v
}

// GetIsEdited returns the IsEdited field value if set, zero value otherwise.
func (o *Conversation) GetIsEdited() bool {
	if o == nil || IsNil(o.IsEdited) {
		var ret bool
		return ret
	}
	return *o.IsEdited
}

// GetIsEditedOk returns a tuple with the IsEdited field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Conversation) GetIsEditedOk() (*bool, bool) {
	if o == nil || IsNil(o.IsEdited) {
		return nil, false
	}
	return o.IsEdited, true
}

// HasIsEdited returns a boolean if a field has been set.
func (o *Conversation) HasIsEdited() bool {
	if o != nil && !IsNil(o.IsEdited) {
		return true
	}

	return false
}

// SetIsEdited gets a reference to the given bool and assigns it to the IsEdited field.
func (o *Conversation) SetIsEdited(v bool) {
	o.IsEdited = &v
}

// GetErrorCode returns the ErrorCode field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *Conversation) GetErrorCode() string {
	if o == nil || IsNil(o.ErrorCode.Get()) {
		var ret string
		return ret
	}
	return *o.ErrorCode.Get()
}

// GetErrorCodeOk returns a tuple with the ErrorCode field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Conversation) GetErrorCodeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ErrorCode.Get(), o.ErrorCode.IsSet()
}

// HasErrorCode returns a boolean if a field has been set.
func (o *Conversation) HasErrorCode() bool {
	if o != nil && o.ErrorCode.IsSet() {
		return true
	}

	return false
}

// SetErrorCode gets a reference to the given NullableString and assigns it to the ErrorCode field.
func (o *Conversation) SetErrorCode(v string) {
	o.ErrorCode.Set(&v)
}
// SetErrorCodeNil sets the value for ErrorCode to be an explicit nil
func (o *Conversation) SetErrorCodeNil() {
	o.ErrorCode.Set(nil)
}

// UnsetErrorCode ensures that no value is present for ErrorCode, not even an explicit nil
func (o *Conversation) UnsetErrorCode() {
	o.ErrorCode.Unset()
}

// GetFiles returns the Files field value if set, zero value otherwise.
func (o *Conversation) GetFiles() []File {
	if o == nil || IsNil(o.Files) {
		var ret []File
		return ret
	}
	return o.Files
}

// GetFilesOk returns a tuple with the Files field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Conversation) GetFilesOk() ([]File, bool) {
	if o == nil || IsNil(o.Files) {
		return nil, false
	}
	return o.Files, true
}

// HasFiles returns a boolean if a field has been set.
func (o *Conversation) HasFiles() bool {
	if o != nil && !IsNil(o.Files) {
		return true
	}

	return false
}

// SetFiles gets a reference to the given []File and assigns it to the Files field.
func (o *Conversation) SetFiles(v []File) {
	o.Files = v
}

// GetPayload returns the Payload field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *Conversation) GetPayload() MessagePayload {
	if o == nil || IsNil(o.Payload.Get()) {
		var ret MessagePayload
		return ret
	}
	return *o.Payload.Get()
}

// GetPayloadOk returns a tuple with the Payload field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Conversation) GetPayloadOk() (*MessagePayload, bool) {
	if o == nil {
		return nil, false
	}
	return o.Payload.Get(), o.Payload.IsSet()
}

// HasPayload returns a boolean if a field has been set.
func (o *Conversation) HasPayload() bool {
	if o != nil && o.Payload.IsSet() {
		return true
	}

	return false
}

// SetPayload gets a reference to the given NullableMessagePayload and assigns it to the Payload field.
func (o *Conversation) SetPayload(v MessagePayload) {
	o.Payload.Set(&v)
}
// SetPayloadNil sets the value for Payload to be an explicit nil
func (o *Conversation) SetPayloadNil() {
	o.Payload.Set(nil)
}

// UnsetPayload ensures that no value is present for Payload, not even an explicit nil
func (o *Conversation) UnsetPayload() {
	o.Payload.Unset()
}

// GetAvatar returns the Avatar field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *Conversation) GetAvatar() string {
	if o == nil || IsNil(o.Avatar.Get()) {
		var ret string
		return ret
	}
	return *o.Avatar.Get()
}

// GetAvatarOk returns a tuple with the Avatar field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Conversation) GetAvatarOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Avatar.Get(), o.Avatar.IsSet()
}

// HasAvatar returns a boolean if a field has been set.
func (o *Conversation) HasAvatar() bool {
	if o != nil && o.Avatar.IsSet() {
		return true
	}

	return false
}

// SetAvatar gets a reference to the given NullableString and assigns it to the Avatar field.
func (o *Conversation) SetAvatar(v string) {
	o.Avatar.Set(&v)
}
// SetAvatarNil sets the value for Avatar to be an explicit nil
func (o *Conversation) SetAvatarNil() {
	o.Avatar.Set(nil)
}

// UnsetAvatar ensures that no value is present for Avatar, not even an explicit nil
func (o *Conversation) UnsetAvatar() {
	o.Avatar.Unset()
}

func (o Conversation) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o Conversation) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["direction"] = o.Direction
	toSerialize["sender"] = o.Sender.Get()
	toSerialize["messageTime"] = o.MessageTime
	toSerialize["text"] = o.Text
	toSerialize["receiver"] = o.Receiver
	toSerialize["status"] = o.Status
	toSerialize["firstName"] = o.FirstName
	toSerialize["lastName"] = o.LastName
	toSerialize["sessionId"] = o.SessionId.Get()
	if o.InitiatorId.IsSet() {
		toSerialize["initiatorId"] = o.InitiatorId.Get()
	}
	if o.MessageFileId.IsSet() {
		toSerialize["messageFileId"] = o.MessageFileId.Get()
	}
	if !IsNil(o.Type) {
		toSerialize["type"] = o.Type
	}
	if !IsNil(o.ChatType) {
		toSerialize["chatType"] = o.ChatType
	}
	if !IsNil(o.ChatId) {
		toSerialize["chatId"] = o.ChatId
	}
	if !IsNil(o.IsEdited) {
		toSerialize["isEdited"] = o.IsEdited
	}
	if o.ErrorCode.IsSet() {
		toSerialize["errorCode"] = o.ErrorCode.Get()
	}
	if !IsNil(o.Files) {
		toSerialize["files"] = o.Files
	}
	if o.Payload.IsSet() {
		toSerialize["payload"] = o.Payload.Get()
	}
	if o.Avatar.IsSet() {
		toSerialize["avatar"] = o.Avatar.Get()
	}
	return toSerialize, nil
}

func (o *Conversation) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"direction",
		"sender",
		"messageTime",
		"text",
		"receiver",
		"status",
		"firstName",
		"lastName",
		"sessionId",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varConversation := _Conversation{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varConversation)

	if err != nil {
		return err
	}

	*o = Conversation(varConversation)

	return err
}

type NullableConversation struct {
	value *Conversation
	isSet bool
}

func (v NullableConversation) Get() *Conversation {
	return v.value
}

func (v *NullableConversation) Set(val *Conversation) {
	v.value = val
	v.isSet = true
}

func (v NullableConversation) IsSet() bool {
	return v.isSet
}

func (v *NullableConversation) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableConversation(val *Conversation) *NullableConversation {
	return &NullableConversation{value: val, isSet: true}
}

func (v NullableConversation) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableConversation) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


