/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"time"
	"bytes"
	"fmt"
)

// checks if the MessagesIcs type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &MessagesIcs{}

// MessagesIcs struct for MessagesIcs
type MessagesIcs struct {
	// Schedule ID.
	Id int32 `json:"id"`
	// The next send date in [ISO 8601](https://en.wikipedia.org/?title=ISO_8601) format. 
	NextSend time.Time `json:"nextSend"`
	// [iCal RRULE](http://www.kanzaki.com/docs/ical/rrule.html) string. 
	Rrule NullableString `json:"rrule"`
	Session NullableMessageSession `json:"session"`
	// The date and time when the last message was sent.
	LastSent NullableTime `json:"lastSent"`
	// Aggregated contact information. If the message was scheduled to be sent to a single contact, a full name will be returned here. Otherwise, a total amount of contacts will be returned.
	ContactName string `json:"contactName"`
	Parameters MessagesIcsParameters `json:"parameters"`
	Type string `json:"type"`
	// A human-readable summary of the sending schedule.
	Summary string `json:"summary"`
	TextParameters MessagesIcsTextParameters `json:"textParameters"`
	// First occurence date.
	FirstOccurrence NullableTime `json:"firstOccurrence"`
	// Last occurence date (could be `null` if the schedule is endless).
	LastOccurrence NullableTime `json:"lastOccurrence"`
	// Amount of actual recipients.
	RecipientsCount NullableInt32 `json:"recipientsCount"`
	// User-friendly timezone name (with spaces replaced by underscores).
	Timezone string `json:"timezone"`
	// Indicates that scheduling has been completed.
	Completed bool `json:"completed"`
	// A relative link to the contact avatar.
	Avatar NullableString `json:"avatar"`
	// Scheduling creation time.
	CreatedAt time.Time `json:"createdAt"`
}

type _MessagesIcs MessagesIcs

// NewMessagesIcs instantiates a new MessagesIcs object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewMessagesIcs(id int32, nextSend time.Time, rrule NullableString, session NullableMessageSession, lastSent NullableTime, contactName string, parameters MessagesIcsParameters, type_ string, summary string, textParameters MessagesIcsTextParameters, firstOccurrence NullableTime, lastOccurrence NullableTime, recipientsCount NullableInt32, timezone string, completed bool, avatar NullableString, createdAt time.Time) *MessagesIcs {
	this := MessagesIcs{}
	this.Id = id
	this.NextSend = nextSend
	this.Rrule = rrule
	this.Session = session
	this.LastSent = lastSent
	this.ContactName = contactName
	this.Parameters = parameters
	this.Type = type_
	this.Summary = summary
	this.TextParameters = textParameters
	this.FirstOccurrence = firstOccurrence
	this.LastOccurrence = lastOccurrence
	this.RecipientsCount = recipientsCount
	this.Timezone = timezone
	this.Completed = completed
	this.Avatar = avatar
	this.CreatedAt = createdAt
	return &this
}

// NewMessagesIcsWithDefaults instantiates a new MessagesIcs object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewMessagesIcsWithDefaults() *MessagesIcs {
	this := MessagesIcs{}
	return &this
}

// GetId returns the Id field value
func (o *MessagesIcs) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *MessagesIcs) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *MessagesIcs) SetId(v int32) {
	o.Id = v
}

// GetNextSend returns the NextSend field value
func (o *MessagesIcs) GetNextSend() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.NextSend
}

// GetNextSendOk returns a tuple with the NextSend field value
// and a boolean to check if the value has been set.
func (o *MessagesIcs) GetNextSendOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.NextSend, true
}

// SetNextSend sets field value
func (o *MessagesIcs) SetNextSend(v time.Time) {
	o.NextSend = v
}

// GetRrule returns the Rrule field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessagesIcs) GetRrule() string {
	if o == nil || o.Rrule.Get() == nil {
		var ret string
		return ret
	}

	return *o.Rrule.Get()
}

// GetRruleOk returns a tuple with the Rrule field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessagesIcs) GetRruleOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Rrule.Get(), o.Rrule.IsSet()
}

// SetRrule sets field value
func (o *MessagesIcs) SetRrule(v string) {
	o.Rrule.Set(&v)
}

// GetSession returns the Session field value
// If the value is explicit nil, the zero value for MessageSession will be returned
func (o *MessagesIcs) GetSession() MessageSession {
	if o == nil || o.Session.Get() == nil {
		var ret MessageSession
		return ret
	}

	return *o.Session.Get()
}

// GetSessionOk returns a tuple with the Session field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessagesIcs) GetSessionOk() (*MessageSession, bool) {
	if o == nil {
		return nil, false
	}
	return o.Session.Get(), o.Session.IsSet()
}

// SetSession sets field value
func (o *MessagesIcs) SetSession(v MessageSession) {
	o.Session.Set(&v)
}

// GetLastSent returns the LastSent field value
// If the value is explicit nil, the zero value for time.Time will be returned
func (o *MessagesIcs) GetLastSent() time.Time {
	if o == nil || o.LastSent.Get() == nil {
		var ret time.Time
		return ret
	}

	return *o.LastSent.Get()
}

// GetLastSentOk returns a tuple with the LastSent field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessagesIcs) GetLastSentOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return o.LastSent.Get(), o.LastSent.IsSet()
}

// SetLastSent sets field value
func (o *MessagesIcs) SetLastSent(v time.Time) {
	o.LastSent.Set(&v)
}

// GetContactName returns the ContactName field value
func (o *MessagesIcs) GetContactName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.ContactName
}

// GetContactNameOk returns a tuple with the ContactName field value
// and a boolean to check if the value has been set.
func (o *MessagesIcs) GetContactNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.ContactName, true
}

// SetContactName sets field value
func (o *MessagesIcs) SetContactName(v string) {
	o.ContactName = v
}

// GetParameters returns the Parameters field value
func (o *MessagesIcs) GetParameters() MessagesIcsParameters {
	if o == nil {
		var ret MessagesIcsParameters
		return ret
	}

	return o.Parameters
}

// GetParametersOk returns a tuple with the Parameters field value
// and a boolean to check if the value has been set.
func (o *MessagesIcs) GetParametersOk() (*MessagesIcsParameters, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Parameters, true
}

// SetParameters sets field value
func (o *MessagesIcs) SetParameters(v MessagesIcsParameters) {
	o.Parameters = v
}

// GetType returns the Type field value
func (o *MessagesIcs) GetType() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Type
}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
func (o *MessagesIcs) GetTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Type, true
}

// SetType sets field value
func (o *MessagesIcs) SetType(v string) {
	o.Type = v
}

// GetSummary returns the Summary field value
func (o *MessagesIcs) GetSummary() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Summary
}

// GetSummaryOk returns a tuple with the Summary field value
// and a boolean to check if the value has been set.
func (o *MessagesIcs) GetSummaryOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Summary, true
}

// SetSummary sets field value
func (o *MessagesIcs) SetSummary(v string) {
	o.Summary = v
}

// GetTextParameters returns the TextParameters field value
func (o *MessagesIcs) GetTextParameters() MessagesIcsTextParameters {
	if o == nil {
		var ret MessagesIcsTextParameters
		return ret
	}

	return o.TextParameters
}

// GetTextParametersOk returns a tuple with the TextParameters field value
// and a boolean to check if the value has been set.
func (o *MessagesIcs) GetTextParametersOk() (*MessagesIcsTextParameters, bool) {
	if o == nil {
		return nil, false
	}
	return &o.TextParameters, true
}

// SetTextParameters sets field value
func (o *MessagesIcs) SetTextParameters(v MessagesIcsTextParameters) {
	o.TextParameters = v
}

// GetFirstOccurrence returns the FirstOccurrence field value
// If the value is explicit nil, the zero value for time.Time will be returned
func (o *MessagesIcs) GetFirstOccurrence() time.Time {
	if o == nil || o.FirstOccurrence.Get() == nil {
		var ret time.Time
		return ret
	}

	return *o.FirstOccurrence.Get()
}

// GetFirstOccurrenceOk returns a tuple with the FirstOccurrence field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessagesIcs) GetFirstOccurrenceOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return o.FirstOccurrence.Get(), o.FirstOccurrence.IsSet()
}

// SetFirstOccurrence sets field value
func (o *MessagesIcs) SetFirstOccurrence(v time.Time) {
	o.FirstOccurrence.Set(&v)
}

// GetLastOccurrence returns the LastOccurrence field value
// If the value is explicit nil, the zero value for time.Time will be returned
func (o *MessagesIcs) GetLastOccurrence() time.Time {
	if o == nil || o.LastOccurrence.Get() == nil {
		var ret time.Time
		return ret
	}

	return *o.LastOccurrence.Get()
}

// GetLastOccurrenceOk returns a tuple with the LastOccurrence field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessagesIcs) GetLastOccurrenceOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return o.LastOccurrence.Get(), o.LastOccurrence.IsSet()
}

// SetLastOccurrence sets field value
func (o *MessagesIcs) SetLastOccurrence(v time.Time) {
	o.LastOccurrence.Set(&v)
}

// GetRecipientsCount returns the RecipientsCount field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *MessagesIcs) GetRecipientsCount() int32 {
	if o == nil || o.RecipientsCount.Get() == nil {
		var ret int32
		return ret
	}

	return *o.RecipientsCount.Get()
}

// GetRecipientsCountOk returns a tuple with the RecipientsCount field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessagesIcs) GetRecipientsCountOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.RecipientsCount.Get(), o.RecipientsCount.IsSet()
}

// SetRecipientsCount sets field value
func (o *MessagesIcs) SetRecipientsCount(v int32) {
	o.RecipientsCount.Set(&v)
}

// GetTimezone returns the Timezone field value
func (o *MessagesIcs) GetTimezone() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Timezone
}

// GetTimezoneOk returns a tuple with the Timezone field value
// and a boolean to check if the value has been set.
func (o *MessagesIcs) GetTimezoneOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Timezone, true
}

// SetTimezone sets field value
func (o *MessagesIcs) SetTimezone(v string) {
	o.Timezone = v
}

// GetCompleted returns the Completed field value
func (o *MessagesIcs) GetCompleted() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.Completed
}

// GetCompletedOk returns a tuple with the Completed field value
// and a boolean to check if the value has been set.
func (o *MessagesIcs) GetCompletedOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Completed, true
}

// SetCompleted sets field value
func (o *MessagesIcs) SetCompleted(v bool) {
	o.Completed = v
}

// GetAvatar returns the Avatar field value
// If the value is explicit nil, the zero value for string will be returned
func (o *MessagesIcs) GetAvatar() string {
	if o == nil || o.Avatar.Get() == nil {
		var ret string
		return ret
	}

	return *o.Avatar.Get()
}

// GetAvatarOk returns a tuple with the Avatar field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *MessagesIcs) GetAvatarOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Avatar.Get(), o.Avatar.IsSet()
}

// SetAvatar sets field value
func (o *MessagesIcs) SetAvatar(v string) {
	o.Avatar.Set(&v)
}

// GetCreatedAt returns the CreatedAt field value
func (o *MessagesIcs) GetCreatedAt() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.CreatedAt
}

// GetCreatedAtOk returns a tuple with the CreatedAt field value
// and a boolean to check if the value has been set.
func (o *MessagesIcs) GetCreatedAtOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.CreatedAt, true
}

// SetCreatedAt sets field value
func (o *MessagesIcs) SetCreatedAt(v time.Time) {
	o.CreatedAt = v
}

func (o MessagesIcs) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o MessagesIcs) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["nextSend"] = o.NextSend
	toSerialize["rrule"] = o.Rrule.Get()
	toSerialize["session"] = o.Session.Get()
	toSerialize["lastSent"] = o.LastSent.Get()
	toSerialize["contactName"] = o.ContactName
	toSerialize["parameters"] = o.Parameters
	toSerialize["type"] = o.Type
	toSerialize["summary"] = o.Summary
	toSerialize["textParameters"] = o.TextParameters
	toSerialize["firstOccurrence"] = o.FirstOccurrence.Get()
	toSerialize["lastOccurrence"] = o.LastOccurrence.Get()
	toSerialize["recipientsCount"] = o.RecipientsCount.Get()
	toSerialize["timezone"] = o.Timezone
	toSerialize["completed"] = o.Completed
	toSerialize["avatar"] = o.Avatar.Get()
	toSerialize["createdAt"] = o.CreatedAt
	return toSerialize, nil
}

func (o *MessagesIcs) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"nextSend",
		"rrule",
		"session",
		"lastSent",
		"contactName",
		"parameters",
		"type",
		"summary",
		"textParameters",
		"firstOccurrence",
		"lastOccurrence",
		"recipientsCount",
		"timezone",
		"completed",
		"avatar",
		"createdAt",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varMessagesIcs := _MessagesIcs{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varMessagesIcs)

	if err != nil {
		return err
	}

	*o = MessagesIcs(varMessagesIcs)

	return err
}

type NullableMessagesIcs struct {
	value *MessagesIcs
	isSet bool
}

func (v NullableMessagesIcs) Get() *MessagesIcs {
	return v.value
}

func (v *NullableMessagesIcs) Set(val *MessagesIcs) {
	v.value = val
	v.isSet = true
}

func (v NullableMessagesIcs) IsSet() bool {
	return v.isSet
}

func (v *NullableMessagesIcs) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableMessagesIcs(val *MessagesIcs) *NullableMessagesIcs {
	return &NullableMessagesIcs{value: val, isSet: true}
}

func (v NullableMessagesIcs) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableMessagesIcs) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


