/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"bytes"
	"fmt"
)

// checks if the SendMessageResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &SendMessageResponse{}

// SendMessageResponse struct for SendMessageResponse
type SendMessageResponse struct {
	// Message ID.
	Id int32 `json:"id"`
	// URI of the message session.
	Href string `json:"href"`
	// Message response type: * **message** – when the message is sent to a single recipient. * **session** – when the message is sent is to multiple recipients. * **schedule** - when the message is scheduled for sending. * **bulk** - when the message is sent to multiple recipients and the number of recipients requires asynchronous processing See [Sending more than 1,000 messages in one session](https://docs.textmagic.com/#section/Tutorials/Sending-more-than-1000-messages-in-one-session). 
	Type string `json:"type"`
	// Message session ID.
	SessionId NullableInt32 `json:"sessionId"`
	// Bulk Session ID. See [Sending more than 1,000 messages in one session](https://docs.textmagic.com/#section/Tutorials/Sending-more-than-1000-messages-in-one-session).
	BulkId NullableInt32 `json:"bulkId"`
	// Message ID.
	MessageId NullableInt32 `json:"messageId"`
	// Message Schedule ID.
	ScheduleId NullableInt32 `json:"scheduleId"`
	// Message Chat ID.
	ChatId NullableInt32 `json:"chatId"`
}

type _SendMessageResponse SendMessageResponse

// NewSendMessageResponse instantiates a new SendMessageResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSendMessageResponse(id int32, href string, type_ string, sessionId NullableInt32, bulkId NullableInt32, messageId NullableInt32, scheduleId NullableInt32, chatId NullableInt32) *SendMessageResponse {
	this := SendMessageResponse{}
	this.Id = id
	this.Href = href
	this.Type = type_
	this.SessionId = sessionId
	this.BulkId = bulkId
	this.MessageId = messageId
	this.ScheduleId = scheduleId
	this.ChatId = chatId
	return &this
}

// NewSendMessageResponseWithDefaults instantiates a new SendMessageResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSendMessageResponseWithDefaults() *SendMessageResponse {
	this := SendMessageResponse{}
	return &this
}

// GetId returns the Id field value
func (o *SendMessageResponse) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *SendMessageResponse) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *SendMessageResponse) SetId(v int32) {
	o.Id = v
}

// GetHref returns the Href field value
func (o *SendMessageResponse) GetHref() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Href
}

// GetHrefOk returns a tuple with the Href field value
// and a boolean to check if the value has been set.
func (o *SendMessageResponse) GetHrefOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Href, true
}

// SetHref sets field value
func (o *SendMessageResponse) SetHref(v string) {
	o.Href = v
}

// GetType returns the Type field value
func (o *SendMessageResponse) GetType() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Type
}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
func (o *SendMessageResponse) GetTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Type, true
}

// SetType sets field value
func (o *SendMessageResponse) SetType(v string) {
	o.Type = v
}

// GetSessionId returns the SessionId field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *SendMessageResponse) GetSessionId() int32 {
	if o == nil || o.SessionId.Get() == nil {
		var ret int32
		return ret
	}

	return *o.SessionId.Get()
}

// GetSessionIdOk returns a tuple with the SessionId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *SendMessageResponse) GetSessionIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.SessionId.Get(), o.SessionId.IsSet()
}

// SetSessionId sets field value
func (o *SendMessageResponse) SetSessionId(v int32) {
	o.SessionId.Set(&v)
}

// GetBulkId returns the BulkId field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *SendMessageResponse) GetBulkId() int32 {
	if o == nil || o.BulkId.Get() == nil {
		var ret int32
		return ret
	}

	return *o.BulkId.Get()
}

// GetBulkIdOk returns a tuple with the BulkId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *SendMessageResponse) GetBulkIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.BulkId.Get(), o.BulkId.IsSet()
}

// SetBulkId sets field value
func (o *SendMessageResponse) SetBulkId(v int32) {
	o.BulkId.Set(&v)
}

// GetMessageId returns the MessageId field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *SendMessageResponse) GetMessageId() int32 {
	if o == nil || o.MessageId.Get() == nil {
		var ret int32
		return ret
	}

	return *o.MessageId.Get()
}

// GetMessageIdOk returns a tuple with the MessageId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *SendMessageResponse) GetMessageIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.MessageId.Get(), o.MessageId.IsSet()
}

// SetMessageId sets field value
func (o *SendMessageResponse) SetMessageId(v int32) {
	o.MessageId.Set(&v)
}

// GetScheduleId returns the ScheduleId field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *SendMessageResponse) GetScheduleId() int32 {
	if o == nil || o.ScheduleId.Get() == nil {
		var ret int32
		return ret
	}

	return *o.ScheduleId.Get()
}

// GetScheduleIdOk returns a tuple with the ScheduleId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *SendMessageResponse) GetScheduleIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.ScheduleId.Get(), o.ScheduleId.IsSet()
}

// SetScheduleId sets field value
func (o *SendMessageResponse) SetScheduleId(v int32) {
	o.ScheduleId.Set(&v)
}

// GetChatId returns the ChatId field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *SendMessageResponse) GetChatId() int32 {
	if o == nil || o.ChatId.Get() == nil {
		var ret int32
		return ret
	}

	return *o.ChatId.Get()
}

// GetChatIdOk returns a tuple with the ChatId field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *SendMessageResponse) GetChatIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.ChatId.Get(), o.ChatId.IsSet()
}

// SetChatId sets field value
func (o *SendMessageResponse) SetChatId(v int32) {
	o.ChatId.Set(&v)
}

func (o SendMessageResponse) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o SendMessageResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["href"] = o.Href
	toSerialize["type"] = o.Type
	toSerialize["sessionId"] = o.SessionId.Get()
	toSerialize["bulkId"] = o.BulkId.Get()
	toSerialize["messageId"] = o.MessageId.Get()
	toSerialize["scheduleId"] = o.ScheduleId.Get()
	toSerialize["chatId"] = o.ChatId.Get()
	return toSerialize, nil
}

func (o *SendMessageResponse) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"href",
		"type",
		"sessionId",
		"bulkId",
		"messageId",
		"scheduleId",
		"chatId",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varSendMessageResponse := _SendMessageResponse{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varSendMessageResponse)

	if err != nil {
		return err
	}

	*o = SendMessageResponse(varSendMessageResponse)

	return err
}

type NullableSendMessageResponse struct {
	value *SendMessageResponse
	isSet bool
}

func (v NullableSendMessageResponse) Get() *SendMessageResponse {
	return v.value
}

func (v *NullableSendMessageResponse) Set(val *SendMessageResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableSendMessageResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableSendMessageResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSendMessageResponse(val *SendMessageResponse) *NullableSendMessageResponse {
	return &NullableSendMessageResponse{value: val, isSet: true}
}

func (v NullableSendMessageResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSendMessageResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


