/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"bytes"
	"fmt"
)

// checks if the SenderId type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &SenderId{}

// SenderId struct for SenderId
type SenderId struct {
	// Numeric sender ID.
	Id int32 `json:"id"`
	// Format for representation of time.
	DisplayTimeFormat *string `json:"displayTimeFormat,omitempty"`
	// Alphanumeric ID.
	SenderId string `json:"senderId"`
	User NullableUser `json:"user"`
	// *   **P** for Pending - this Sender ID is being reviewed by our support team; *   **R** for Rejected - our support team rejected your application for this Sender ID; *   **A** for Active. 
	Status string `json:"status"`
}

type _SenderId SenderId

// NewSenderId instantiates a new SenderId object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewSenderId(id int32, senderId string, user NullableUser, status string) *SenderId {
	this := SenderId{}
	this.Id = id
	this.SenderId = senderId
	this.User = user
	this.Status = status
	return &this
}

// NewSenderIdWithDefaults instantiates a new SenderId object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewSenderIdWithDefaults() *SenderId {
	this := SenderId{}
	return &this
}

// GetId returns the Id field value
func (o *SenderId) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *SenderId) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *SenderId) SetId(v int32) {
	o.Id = v
}

// GetDisplayTimeFormat returns the DisplayTimeFormat field value if set, zero value otherwise.
func (o *SenderId) GetDisplayTimeFormat() string {
	if o == nil || IsNil(o.DisplayTimeFormat) {
		var ret string
		return ret
	}
	return *o.DisplayTimeFormat
}

// GetDisplayTimeFormatOk returns a tuple with the DisplayTimeFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *SenderId) GetDisplayTimeFormatOk() (*string, bool) {
	if o == nil || IsNil(o.DisplayTimeFormat) {
		return nil, false
	}
	return o.DisplayTimeFormat, true
}

// HasDisplayTimeFormat returns a boolean if a field has been set.
func (o *SenderId) HasDisplayTimeFormat() bool {
	if o != nil && !IsNil(o.DisplayTimeFormat) {
		return true
	}

	return false
}

// SetDisplayTimeFormat gets a reference to the given string and assigns it to the DisplayTimeFormat field.
func (o *SenderId) SetDisplayTimeFormat(v string) {
	o.DisplayTimeFormat = &v
}

// GetSenderId returns the SenderId field value
func (o *SenderId) GetSenderId() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.SenderId
}

// GetSenderIdOk returns a tuple with the SenderId field value
// and a boolean to check if the value has been set.
func (o *SenderId) GetSenderIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.SenderId, true
}

// SetSenderId sets field value
func (o *SenderId) SetSenderId(v string) {
	o.SenderId = v
}

// GetUser returns the User field value
// If the value is explicit nil, the zero value for User will be returned
func (o *SenderId) GetUser() User {
	if o == nil || o.User.Get() == nil {
		var ret User
		return ret
	}

	return *o.User.Get()
}

// GetUserOk returns a tuple with the User field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *SenderId) GetUserOk() (*User, bool) {
	if o == nil {
		return nil, false
	}
	return o.User.Get(), o.User.IsSet()
}

// SetUser sets field value
func (o *SenderId) SetUser(v User) {
	o.User.Set(&v)
}

// GetStatus returns the Status field value
func (o *SenderId) GetStatus() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Status
}

// GetStatusOk returns a tuple with the Status field value
// and a boolean to check if the value has been set.
func (o *SenderId) GetStatusOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Status, true
}

// SetStatus sets field value
func (o *SenderId) SetStatus(v string) {
	o.Status = v
}

func (o SenderId) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o SenderId) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	if !IsNil(o.DisplayTimeFormat) {
		toSerialize["displayTimeFormat"] = o.DisplayTimeFormat
	}
	toSerialize["senderId"] = o.SenderId
	toSerialize["user"] = o.User.Get()
	toSerialize["status"] = o.Status
	return toSerialize, nil
}

func (o *SenderId) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"senderId",
		"user",
		"status",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varSenderId := _SenderId{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varSenderId)

	if err != nil {
		return err
	}

	*o = SenderId(varSenderId)

	return err
}

type NullableSenderId struct {
	value *SenderId
	isSet bool
}

func (v NullableSenderId) Get() *SenderId {
	return v.value
}

func (v *NullableSenderId) Set(val *SenderId) {
	v.value = val
	v.isSet = true
}

func (v NullableSenderId) IsSet() bool {
	return v.isSet
}

func (v *NullableSenderId) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableSenderId(val *SenderId) *NullableSenderId {
	return &NullableSenderId{value: val, isSet: true}
}

func (v NullableSenderId) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableSenderId) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


