/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"time"
	"bytes"
	"fmt"
)

// checks if the UnsubscribedContact type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &UnsubscribedContact{}

// UnsubscribedContact struct for UnsubscribedContact
type UnsubscribedContact struct {
	// Unsubscribed contact ID.
	Id int32 `json:"id"`
	// Phone number in [E.164 format](https://en.wikipedia.org/wiki/E.164).
	Phone string `json:"phone"`
	// Time when contact was opted-out.
	UnsubscribeTime time.Time `json:"unsubscribeTime"`
	// Unsubscribed contact first name.
	FirstName NullableString `json:"firstName"`
	// Unsubscribed contact last name.
	LastName NullableString `json:"lastName"`
}

type _UnsubscribedContact UnsubscribedContact

// NewUnsubscribedContact instantiates a new UnsubscribedContact object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUnsubscribedContact(id int32, phone string, unsubscribeTime time.Time, firstName NullableString, lastName NullableString) *UnsubscribedContact {
	this := UnsubscribedContact{}
	this.Id = id
	this.Phone = phone
	this.UnsubscribeTime = unsubscribeTime
	this.FirstName = firstName
	this.LastName = lastName
	return &this
}

// NewUnsubscribedContactWithDefaults instantiates a new UnsubscribedContact object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUnsubscribedContactWithDefaults() *UnsubscribedContact {
	this := UnsubscribedContact{}
	return &this
}

// GetId returns the Id field value
func (o *UnsubscribedContact) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *UnsubscribedContact) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *UnsubscribedContact) SetId(v int32) {
	o.Id = v
}

// GetPhone returns the Phone field value
func (o *UnsubscribedContact) GetPhone() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Phone
}

// GetPhoneOk returns a tuple with the Phone field value
// and a boolean to check if the value has been set.
func (o *UnsubscribedContact) GetPhoneOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Phone, true
}

// SetPhone sets field value
func (o *UnsubscribedContact) SetPhone(v string) {
	o.Phone = v
}

// GetUnsubscribeTime returns the UnsubscribeTime field value
func (o *UnsubscribedContact) GetUnsubscribeTime() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.UnsubscribeTime
}

// GetUnsubscribeTimeOk returns a tuple with the UnsubscribeTime field value
// and a boolean to check if the value has been set.
func (o *UnsubscribedContact) GetUnsubscribeTimeOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.UnsubscribeTime, true
}

// SetUnsubscribeTime sets field value
func (o *UnsubscribedContact) SetUnsubscribeTime(v time.Time) {
	o.UnsubscribeTime = v
}

// GetFirstName returns the FirstName field value
// If the value is explicit nil, the zero value for string will be returned
func (o *UnsubscribedContact) GetFirstName() string {
	if o == nil || o.FirstName.Get() == nil {
		var ret string
		return ret
	}

	return *o.FirstName.Get()
}

// GetFirstNameOk returns a tuple with the FirstName field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UnsubscribedContact) GetFirstNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.FirstName.Get(), o.FirstName.IsSet()
}

// SetFirstName sets field value
func (o *UnsubscribedContact) SetFirstName(v string) {
	o.FirstName.Set(&v)
}

// GetLastName returns the LastName field value
// If the value is explicit nil, the zero value for string will be returned
func (o *UnsubscribedContact) GetLastName() string {
	if o == nil || o.LastName.Get() == nil {
		var ret string
		return ret
	}

	return *o.LastName.Get()
}

// GetLastNameOk returns a tuple with the LastName field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *UnsubscribedContact) GetLastNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.LastName.Get(), o.LastName.IsSet()
}

// SetLastName sets field value
func (o *UnsubscribedContact) SetLastName(v string) {
	o.LastName.Set(&v)
}

func (o UnsubscribedContact) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o UnsubscribedContact) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["phone"] = o.Phone
	toSerialize["unsubscribeTime"] = o.UnsubscribeTime
	toSerialize["firstName"] = o.FirstName.Get()
	toSerialize["lastName"] = o.LastName.Get()
	return toSerialize, nil
}

func (o *UnsubscribedContact) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"phone",
		"unsubscribeTime",
		"firstName",
		"lastName",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varUnsubscribedContact := _UnsubscribedContact{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varUnsubscribedContact)

	if err != nil {
		return err
	}

	*o = UnsubscribedContact(varUnsubscribedContact)

	return err
}

type NullableUnsubscribedContact struct {
	value *UnsubscribedContact
	isSet bool
}

func (v NullableUnsubscribedContact) Get() *UnsubscribedContact {
	return v.value
}

func (v *NullableUnsubscribedContact) Set(val *UnsubscribedContact) {
	v.value = val
	v.isSet = true
}

func (v NullableUnsubscribedContact) IsSet() bool {
	return v.isSet
}

func (v *NullableUnsubscribedContact) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUnsubscribedContact(val *UnsubscribedContact) *NullableUnsubscribedContact {
	return &NullableUnsubscribedContact{value: val, isSet: true}
}

func (v NullableUnsubscribedContact) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUnsubscribedContact) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


