#! /bin/sh -e
# tup - A file-based build system
#
# Copyright (C) 2014-2024  Mike Shal <marfey@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

# If we create a .gitignore file manually, it will be TUP_NODE_FILE, so if we
# later add a .gitignore directive to the Tupfile, we need to convert it to
# TUP_NODE_GENERATED, otherwise the generated files won't be appended to the
# user-created version. Similarly, if we then remove the .gitignore directive,
# we need to convert it back to TUP_NODE_FILE if there is still user-created
# content leftover in the file after we remove all the autogenerated ignores.

. ./tup.sh

cat > Tupfile << HERE
: |> touch foo |> foo
HERE
cat > .gitignore << HERE
ok.txt
HERE
cp .gitignore backup
touch ok.txt
update

gitignore_good ok.txt .gitignore
gitignore_bad foo .gitignore
gitignore_bad .gitignore .gitignore

cat > Tupfile << HERE
.gitignore
: |> touch foo |> foo
HERE
update

gitignore_good ok.txt .gitignore
gitignore_good foo .gitignore
gitignore_bad .gitignore .gitignore

# Go back to the way things were, which should leave us with our original
# .gitignore file.
cat > Tupfile << HERE
: |> touch foo |> foo
HERE
update

gitignore_good ok.txt .gitignore
gitignore_bad foo .gitignore
gitignore_bad .gitignore .gitignore

diff backup .gitignore

eotup
