/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: xracer-mode.h,v 1.9 2000/03/12 12:58:54 rich Exp $
 */

#ifndef __xracer_mode_h__
#define __xracer_mode_h__

struct xrMode
{
  const char *name;

  void (*start_mode) (const void *args);
  void (*end_mode) (void);

  void (*display) (void);
  void (*reshape) (int width, int height);
  int (*keyboard) (unsigned char key, int x, int y);
  void (*mouse) (int button, int state, int x, int y);
  void (*motion) (int x, int y);
  void (*passive_motion) (int x, int y);
  void (*idle) (void);
  int (*special) (int key, int x, int y);
  int (*keyboard_up) (unsigned char key, int x, int y);
  int (*special_up) (int key, int x, int y);
};

extern void xrModeInit (void);
extern void xrEnterMode (const struct xrMode *mode, const void *args);

/* Global mode structures defined. */
extern struct xrMode xrKeyboardConfigurationMenuMode;
extern struct xrMode xrLoadTrackMode;
extern struct xrMode xrIntroMode;

#endif /* __xracer_mode_h__ */
