// Automatically generated

package zonedb

func init() {
	initZones() // Separate function to report allocs in initialization
}

func initZones() {
	z = y
	ZoneMap = make(map[string]*Zone, len(z))
	for i := range z {
		ZoneMap[z[i].Domain] = &z[i]
	}
}

// Type w is an alias for []string to generate smaller source code
type w []string

// Constants to generate smaller source code
const (
	t = true
	f = false
	e = ""
)

// Nil variables to generate smaller source code
var (
	n []string // == nil
	x []Zone   // nil (no subdomains)
	r *Zone    // nil (root zone for TLDs)
)

// Tags are stored in a single integer as a bit field.
type Tags uint32

// Tag values corresponding to bit shifts (1 << iota)
const (
	TagAdult          = 1
	TagBrand          = 2
	TagCity           = 4
	TagClosed         = 8
	TagCommunity      = 16
	TagCountry        = 32
	TagGeneric        = 64
	TagGeo            = 128
	TagInfrastructure = 256
	TagPrivate        = 512
	TagRegion         = 1024
	TagRetired        = 2048
	TagSponsored      = 4096
	TagWithdrawn      = 8192
	numTags           = 14
)

// TagStrings maps integer tag values to strings.
var TagStrings = map[Tags]string{
	TagAdult:          "adult",
	TagBrand:          "brand",
	TagCity:           "city",
	TagClosed:         "closed",
	TagCommunity:      "community",
	TagCountry:        "country",
	TagGeneric:        "generic",
	TagGeo:            "geo",
	TagInfrastructure: "infrastructure",
	TagPrivate:        "private",
	TagRegion:         "region",
	TagRetired:        "retired",
	TagSponsored:      "sponsored",
	TagWithdrawn:      "withdrawn",
}

// TagValues maps tag names to integer values.
var TagValues = map[string]Tags{
	"adult":          TagAdult,
	"brand":          TagBrand,
	"city":           TagCity,
	"closed":         TagClosed,
	"community":      TagCommunity,
	"country":        TagCountry,
	"generic":        TagGeneric,
	"geo":            TagGeo,
	"infrastructure": TagInfrastructure,
	"private":        TagPrivate,
	"region":         TagRegion,
	"retired":        TagRetired,
	"sponsored":      TagSponsored,
	"withdrawn":      TagWithdrawn,
}

// ZoneMap maps domain names to Zones.
var ZoneMap map[string]*Zone

// Zones is a slice of all Zones in the database.
var Zones = z[:]

// TLDs is a slice of all top-level domain Zones.
var TLDs = z[:1754]

// z is a static array of Zones.
// Other global variables have pointers into this array.
var z [5192]Zone

// y and z are separated to fix circular references.
var y = [5192]Zone{
	{"aaa", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.aaa", "ns2.dns.nic.aaa", "ns3.dns.nic.aaa", "ns4.dns.nic.aaa", "ns5.dns.nic.aaa", "ns6.dns.nic.aaa"}, n, n, n, "whois.nic.aaa", e, t},
	{"aarp", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.aarp", e, t},
	{"abarth", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.abarth", "a2.nic.abarth", "b0.nic.abarth", "c0.nic.abarth"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"abb", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, f},
	{"abbott", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.abbott", "a2.nic.abbott", "b0.nic.abbott", "c0.nic.abbott"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"abbvie", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.abbvie", "a2.nic.abbvie", "b0.nic.abbvie", "c0.nic.abbvie"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"abc", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.abc", e, f},
	{"able", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.able", "ns2.dns.nic.able", "ns3.dns.nic.able", "ns4.dns.nic.able", "ns5.dns.nic.able", "ns6.dns.nic.able"}, n, n, n, "whois.nic.able", e, t},
	{"abogado", r, x, 0x40, "http://nic.abogado/", w{"dns1.nic.abogado", "dns2.nic.abogado", "dns3.nic.abogado", "dns4.nic.abogado", "dnsa.nic.abogado", "dnsb.nic.abogado", "dnsc.nic.abogado", "dnsd.nic.abogado"}, n, n, n, "whois.nic.abogado", e, t},
	{"abudhabi", r, x, 0xc4, "https://newgtlds.icann.org/", w{"gtld.alpha.aridns.net.au", "gtld.beta.aridns.net.au", "gtld.delta.aridns.net.au", "gtld.gamma.aridns.net.au"}, n, w{"Abu Dhabi", "AE-AZ"}, n, "whois.nic.abudhabi", e, f},
	{"ac", r, z[1754:1759], 0xa0, "https://www.icb.co.uk/", w{"a0.nic.ac", "a2.nic.ac", "b0.nic.ac", "c0.nic.ac"}, n, n, n, "whois.nic.ac", e, t},
	{"academy", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.academy", e, t},
	{"accenture", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, t},
	{"accountant", r, x, 0x40, "https://www.famousfourmedia.com/", w{"ns1.dns.nic.accountant", "ns2.dns.nic.accountant", "ns3.dns.nic.accountant", "ns4.dns.nic.accountant", "ns5.dns.nic.accountant", "ns6.dns.nic.accountant"}, n, n, n, "whois.nic.accountant", e, t},
	{"accountants", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.accountants", e, t},
	{"acer", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"aco", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.dns.nic.aco", "m.dns.nic.aco", "n.dns.nic.aco"}, n, n, n, "whois.nic.aco", e, t},
	{"active", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.afilias-srs.net", e, f},
	{"actor", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.actor", e, t},
	{"ad", r, z[1759:1760], 0xe0, "http://www.nic.ad/", w{"ad.cctld.authdns.ripe.net", "ad.ns.nic.es", "dnsc.ad", "dnsm.ad", "ns3.nic.fr"}, n, n, n, e, e, t},
	{"adac", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.adac", "b.nic.adac", "c.nic.adac", "d.nic.adac"}, n, n, n, "whois.nic.adac", e, t},
	{"ads", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"adult", r, x, 0x41, "https://newgtlds.icann.org/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns5.uniregistry.net", "ns6.uniregistry.info"}, n, n, n, "whois.registrar.adult", e, t},
	{"ae", r, z[1760:1769], 0xa0, "https://www.nic.ae/", w{"ns1.aedns.ae", "ns2.aedns.ae", "ns4.apnic.net", "nsext-pch.aedns.ae"}, n, n, n, "whois.aeda.net.ae", e, t},
	{"aeg", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.aeg", e, t},
	{"aero", r, z[1769:1772], 0x1040, "https://information.aero/", w{"a0.nic.aero", "a2.nic.aero", "b0.nic.aero", "b2.nic.aero", "c0.nic.aero"}, n, n, n, "whois.aero", e, f},
	{"aetna", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.aetna", "ns2.dns.nic.aetna", "ns3.dns.nic.aetna", "ns4.dns.nic.aetna", "ns5.dns.nic.aetna", "ns6.dns.nic.aetna"}, n, n, n, "whois.nic.aetna", e, t},
	{"af", r, z[1772:1782], 0xa0, "http://www.nic.af/", w{"ns.anycast.nic.af", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, "whois.nic.af", e, f},
	{"afamilycompany", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.afamilycompany", e, f},
	{"afl", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.afl", "b.nic.afl", "c.nic.afl", "d.nic.afl"}, n, n, n, "whois.nic.afl", e, f},
	{"africa", r, x, 0xc0, "https://newgtlds.icann.org/", w{"coza1.dnsnode.net", "ns.coza.net.za", "ns2us.dns.business"}, n, w{"Africa"}, n, "africa-whois.registry.net.za", e, f},
	{"africamagic", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"ag", r, z[1782:1788], 0xa0, "http://www.nic.ag/", w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, "whois.nic.ag", e, f},
	{"agakhan", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.agakhan", "a2.nic.agakhan", "b0.nic.agakhan", "c0.nic.agakhan"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"agency", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.agency", e, t},
	{"ai", r, z[1788:1792], 0xa0, "http://nic.com.ai/", w{"a.lactld.org", "anycastdns1-cz.nic.ai", "anycastdns2-cz.nic.ai", "pch.whois.ai"}, n, n, n, "whois.nic.ai", e, f},
	{"aig", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.aig", "ns2.dns.nic.aig", "ns3.dns.nic.aig", "ns4.dns.nic.aig", "ns5.dns.nic.aig", "ns6.dns.nic.aig"}, n, n, n, "whois.nic.aig", e, t},
	{"aigo", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.afilias-srs.net", e, f},
	{"airbus", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.airbus", e, t},
	{"airforce", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.airforce", e, t},
	{"airtel", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.airtel", e, f},
	{"akdn", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.akdn", "a2.nic.akdn", "b0.nic.akdn", "c0.nic.akdn"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"al", r, z[1792:1802], 0xa0, "http://www.ert.gov.al/ert_eng/domain.html", w{"munnari.oz.au", "ns1.nic.al", "nsx.nic.al", "rip.psg.com"}, n, n, n, e, "http://www.akep.al/sq/kerkoni-domain", f},
	{"alcon", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"alfaromeo", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.alfaromeo", "a2.nic.alfaromeo", "b0.nic.alfaromeo", "c0.nic.alfaromeo"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"alibaba", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.alibaba", "a2.nic.alibaba", "b0.nic.alibaba", "c0.nic.alibaba"}, n, n, n, "whois.nic.alibaba", e, f},
	{"alipay", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.alipay", "a2.nic.alipay", "b0.nic.alipay", "c0.nic.alipay"}, n, n, n, "whois.nic.alipay", e, f},
	{"allfinanz", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.allfinanz", "b.nic.allfinanz", "c.nic.allfinanz", "d.nic.allfinanz"}, n, n, n, "whois.nic.allfinanz", e, f},
	{"allfinanzberater", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"allfinanzberatung", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"allstate", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.allstate", "a2.nic.allstate", "b0.nic.allstate", "c0.nic.allstate"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"ally", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.ally", "b.nic.ally", "c.nic.ally", "d.nic.ally"}, n, n, n, "whois.nic.ally", e, f},
	{"alsace", r, x, 0x4c0, "https://newgtlds.icann.org/", w{"d.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, w{"FR-A"}, n, "whois-alsace.nic.fr", e, t},
	{"alstom", r, x, 0x42, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.alstom", e, f},
	{"am", r, z[1802:1809], 0xa0, "https://www.amnic.net/", w{"fork.sth.dnsnode.net", "ns-cdn.amnic.net", "ns-pch.amnic.net", "ns-pri.nic.am"}, n, n, n, "whois.amnic.net", e, t},
	{"amazon", r, x, 0x42, "http://nic.amazon/", w{"dns1.nic.amazon", "dns2.nic.amazon", "dns3.nic.amazon", "dns4.nic.amazon", "dnsa.nic.amazon", "dnsb.nic.amazon", "dnsc.nic.amazon", "dnsd.nic.amazon"}, n, n, n, "whois.nic.amazon", e, t},
	{"americanexpress", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.americanexpress", "ns2.dns.nic.americanexpress", "ns3.dns.nic.americanexpress", "ns4.dns.nic.americanexpress", "ns5.dns.nic.americanexpress", "ns6.dns.nic.americanexpress"}, n, n, n, "whois.nic.americanexpress", e, t},
	{"americanfamily", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.americanfamily", e, t},
	{"amex", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.amex", "ns2.dns.nic.amex", "ns3.dns.nic.amex", "ns4.dns.nic.amex", "ns5.dns.nic.amex", "ns6.dns.nic.amex"}, n, n, n, "whois.nic.amex", e, t},
	{"amfam", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.amfam", e, t},
	{"amica", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.amica", "ns2.dns.nic.amica", "ns3.dns.nic.amica", "ns4.dns.nic.amica", "ns5.dns.nic.amica", "ns6.dns.nic.amica"}, n, n, n, "whois.nic.amica", e, f},
	{"amp", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"amsterdam", r, x, 0xc4, "https://nic.amsterdam/", w{"ns1.nic.amsterdam", "ns2.nic.amsterdam", "ns3.nic.amsterdam"}, n, w{"Amsterdam", "NL-NH"}, n, "whois.nic.amsterdam", e, f},
	{"an", r, z[1809:1813], 0x8a8, "http://www.una.an/an_domreg/", n, n, n, n, e, e, f},
	{"analytics", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.analytics", "ns2.dns.nic.analytics", "ns3.dns.nic.analytics", "ns4.dns.nic.analytics", "ns5.dns.nic.analytics", "ns6.dns.nic.analytics"}, n, n, n, "whois.nic.analytics", e, t},
	{"android", r, x, 0x42, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"anquan", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.teleinfo.cn", "ns2.teleinfoo.com", "ns3.teleinfo.cn", "ns4.teleinfoo.com"}, n, n, n, "whois.teleinfo.cn", e, f},
	{"ansons", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"anthem", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"antivirus", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"anz", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.anz", "b.nic.anz", "c.nic.anz", "d.nic.anz"}, n, n, n, "whois.nic.anz", e, f},
	{"ao", r, z[1813:1819], 0xa0, "https://www.dns.ao/ao/", w{"ao01.dns.pt", "ao03.dns.pt", "h.dns.pt"}, n, n, n, e, e, f},
	{"aol", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.aol", e, f},
	{"apartments", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.apartments", e, t},
	{"app", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"apple", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.apple", "a2.nic.apple", "b0.nic.apple", "c0.nic.apple"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"aq", r, z[1819:1820], 0xa0, "http://www.gobin.info/domainname/aq.txt", w{"fork.sth.dnsnode.net", "ns1.anycast.dns.aq", "ns99.dns.net.nz"}, n, n, n, e, e, f},
	{"aquarelle", r, x, 0x42, "https://newgtlds.icann.org/", w{"d.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, n, n, "whois.nic.aquarelle", e, t},
	{"aquitaine", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"ar", r, z[1820:1829], 0xa0, "https://nic.ar/", w{"a.dns.ar", "ar.cctld.authdns.ripe.net", "b.dns.ar", "c.dns.ar", "d.dns.ar", "e.dns.ar", "f.dns.ar"}, n, n, n, "whois.nic.ar", e, t},
	{"arab", r, x, 0x40, "https://newgtlds.icann.org/", w{"gtld.alpha.aridns.net.au", "gtld.beta.aridns.net.au", "gtld.delta.aridns.net.au", "gtld.gamma.aridns.net.au"}, n, n, n, "whois.nic.arab", e, f},
	{"aramco", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.aramco", "ns2.dns.nic.aramco", "ns3.dns.nic.aramco", "ns4.dns.nic.aramco", "ns5.dns.nic.aramco", "ns6.dns.nic.aramco"}, n, n, n, "whois.nic.aramco", e, t},
	{"archi", r, x, 0x40, "https://domains.archi/", w{"a0.nic.archi", "a2.nic.archi", "b0.nic.archi", "c0.nic.archi"}, n, n, n, "whois.afilias.net", e, f},
	{"architect", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"army", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.army", e, t},
	{"arpa", r, z[1829:1835], 0x148, "https://www.iana.org/domains/arpa", w{"a.root-servers.net", "b.root-servers.net", "c.root-servers.net", "d.root-servers.net", "e.root-servers.net", "f.root-servers.net", "g.root-servers.net", "h.root-servers.net", "i.root-servers.net", "k.root-servers.net", "l.root-servers.net", "m.root-servers.net"}, n, n, n, "whois.iana.org", e, f},
	{"art", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.art", "b.nic.art", "c.nic.art", "d.nic.art"}, n, n, n, "whois.nic.art", e, t},
	{"arte", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.arte", e, t},
	{"as", r, x, 0xe0, "https://nic.as/", w{"ns1.asnic.biz", "ns2.asnic.info", "ns3.asnic.org", "ns4.asnic.uk", "ns5.asnic.us", "pch.nic.as"}, n, n, n, "whois.nic.as", e, t},
	{"asda", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.asda", e, f},
	{"asia", r, x, 0x1040, "https://www.dot.asia/", w{"a0.asia.afilias-nst.info", "a2.asia.afilias-nst.info", "b0.asia.afilias-nst.asia", "b2.asia.afilias-nst.org", "c0.asia.afilias-nst.info", "d0.asia.afilias-nst.asia"}, n, n, n, "whois.nic.asia", e, t},
	{"associates", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.associates", e, t},
	{"astrium", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"at", r, z[1835:1840], 0xa0, "https://www.nic.at/de", w{"d.ns.at", "j.ns.at", "n.ns.at", "ns1.univie.ac.at", "ns2.univie.ac.at", "ns9.univie.ac.at", "r.ns.at", "u.ns.at"}, n, n, n, "whois.nic.at", e, t},
	{"athleta", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.athleta", "ns2.dns.nic.athleta", "ns3.dns.nic.athleta", "ns4.dns.nic.athleta", "ns5.dns.nic.athleta", "ns6.dns.nic.athleta"}, n, n, n, "whois.nic.athleta", e, t},
	{"attorney", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.attorney", e, t},
	{"au", r, z[1840:1860], 0xa8, "https://www.auda.org.au/", w{"a.au", "c.au", "d.au", "m.au", "n.au", "q.au", "r.au", "s.au", "t.au"}, n, n, n, "whois.auda.org.au", e, f},
	{"auction", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.auction", e, t},
	{"audi", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.audi", "a2.nic.audi", "b0.nic.audi", "c0.nic.audi"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"audible", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.audible", "dns2.nic.audible", "dns3.nic.audible", "dns4.nic.audible", "dnsa.nic.audible", "dnsb.nic.audible", "dnsc.nic.audible", "dnsd.nic.audible"}, n, n, n, "whois.nic.audible", e, t},
	{"audio", r, x, 0x40, "https://nic.audio/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"auspost", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.auspost", "b.nic.auspost", "c.nic.auspost", "d.nic.auspost"}, n, n, n, "whois.nic.auspost", e, f},
	{"author", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.author", "dns2.nic.author", "dns3.nic.author", "dns4.nic.author", "dnsa.nic.author", "dnsb.nic.author", "dnsc.nic.author", "dnsd.nic.author"}, n, n, n, "whois.nic.author", e, t},
	{"auto", r, x, 0x40, "https://nic.auto/", w{"a.nic.auto", "b.nic.auto", "c.nic.auto", "d.nic.auto"}, n, n, n, "whois.nic.auto", e, t},
	{"autoinsurance", r, x, 0x2040, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"autos", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.autos", "b.nic.autos", "c.nic.autos", "d.nic.autos"}, n, n, n, "whois.nic.autos", e, f},
	{"avery", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"avianca", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.avianca", "a2.nic.avianca", "b0.nic.avianca", "c0.nic.avianca"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"aw", r, z[1860:1861], 0xa0, "http://www.setarnet.aw/", w{"aw01.setarnet.aw", "aw02.setarnet.aw", "ns1.dns.aw", "ns2.dns.aw", "ns3.dns.aw"}, n, n, n, "whois.nic.aw", e, f},
	{"aws", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.aws", "dns2.nic.aws", "dns3.nic.aws", "dns4.nic.aws", "dnsa.nic.aws", "dnsb.nic.aws", "dnsc.nic.aws", "dnsd.nic.aws"}, n, n, n, "whois.nic.aws", e, t},
	{"ax", r, x, 0xa0, "https://www.regeringen.ax/naringsliv-foretagande/ansok-om-ax-domannamn", w{"ns1.aland.net", "ns2.aland.net", "ns3.alcom.fi", "ns4.alcom.fi"}, n, n, n, "whois.ax", e, f},
	{"axa", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.axa", "ns2.dns.nic.axa", "ns3.dns.nic.axa", "ns4.dns.nic.axa", "ns5.dns.nic.axa", "ns6.dns.nic.axa"}, n, n, n, "whois.nic.axa", e, t},
	{"axis", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"az", r, z[1861:1882], 0xa0, "https://www.nic.az/", w{"az.hostmaster.ua", "rip.psg.com"}, n, n, n, e, e, f},
	{"azure", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, t},
	{"ba", r, z[1882:1895], 0xa0, "https://www.nic.ba/", w{"ns.ba", "sava.utic.net.ba", "una.utic.net.ba"}, n, n, n, e, "http://nic.ba/lat/menu/view/13", f},
	{"baby", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.baby", "b.nic.baby", "c.nic.baby", "d.nic.baby"}, n, n, n, "whois.nic.baby", e, f},
	{"baidu", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.gtld.knet.cn", e, t},
	{"banamex", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.banamex", "ns2.dns.nic.banamex", "ns3.dns.nic.banamex", "ns4.dns.nic.banamex", "ns5.dns.nic.banamex", "ns6.dns.nic.banamex"}, n, n, n, "whois.nic.banamex", e, t},
	{"bananarepublic", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.bananarepublic", "ns2.dns.nic.bananarepublic", "ns3.dns.nic.bananarepublic", "ns4.dns.nic.bananarepublic", "ns5.dns.nic.bananarepublic", "ns6.dns.nic.bananarepublic"}, n, n, n, "whois.nic.bananarepublic", e, t},
	{"band", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.band", e, t},
	{"bank", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.bank", "b.nic.bank", "c.nic.bank", "d.nic.bank", "e.nic.bank", "f.nic.bank"}, n, n, n, "whois.nic.bank", e, f},
	{"banque", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"bar", r, x, 0x40, e, w{"a.nic.bar", "b.nic.bar", "c.nic.bar", "d.nic.bar"}, n, n, n, "whois.nic.bar", e, t},
	{"barcelona", r, x, 0x40, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.barcelona", e, f},
	{"barclaycard", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.barclaycard", "b.nic.barclaycard", "c.nic.barclaycard", "d.nic.barclaycard"}, n, n, n, "whois.nic.barclaycard", e, f},
	{"barclays", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.barclays", "b.nic.barclays", "c.nic.barclays", "d.nic.barclays"}, n, n, n, "whois.nic.barclays", e, f},
	{"barefoot", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.barefoot", e, f},
	{"bargains", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.bargains", e, t},
	{"baseball", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.baseball", "ns2.dns.nic.baseball", "ns3.dns.nic.baseball", "ns4.dns.nic.baseball", "ns5.dns.nic.baseball", "ns6.dns.nic.baseball"}, n, n, n, "whois.nic.baseball", e, t},
	{"basketball", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.basketball", "b.nic.basketball", "c.nic.basketball", "d.nic.basketball"}, n, n, n, "whois.nic.basketball", e, f},
	{"bauhaus", r, x, 0x42, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.bauhaus", e, f},
	{"bayern", r, x, 0x4c0, "https://nic.bayern/", w{"dns1.nic.bayern", "dns2.nic.bayern", "dns3.nic.bayern", "dns4.nic.bayern", "dnsa.nic.bayern", "dnsb.nic.bayern", "dnsc.nic.bayern", "dnsd.nic.bayern"}, n, w{"DE-BY"}, n, "whois.nic.bayern", e, t},
	{"bb", r, z[1895:1904], 0xa0, "http://www.barbadosdomains.net/", w{"ns1.nic.bb", "ns2.nic.bb", "ns3.nic.bb", "ns4.nic.bb", "ns5.nic.bb"}, n, n, n, e, "http://whois.telecoms.gov.bb/search_domain.php", f},
	{"bbb", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"bbc", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.bbc", "dns2.nic.bbc", "dns3.nic.bbc", "dns4.nic.bbc", "dnsa.nic.bbc", "dnsb.nic.bbc", "dnsc.nic.bbc", "dnsd.nic.bbc"}, n, n, n, "whois.nic.bbc", e, f},
	{"bbt", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.bbt", e, f},
	{"bbva", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.bbva", e, t},
	{"bcg", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.bcg", "a2.nic.bcg", "b0.nic.bcg", "c0.nic.bcg"}, n, n, n, "whois.nic.bcg", e, f},
	{"bcn", r, x, 0x40, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.bcn", e, f},
	{"bd", r, z[1904:1911], 0xa8, "http://www.bttb.net.bd/", w{"bd-ns.anycast.pch.net", "dns.bd", "jamuna.btcl.net.bd", "surma.btcl.net.bd"}, n, n, n, e, "http://whois.btcl.net.bd/", t},
	{"be", r, x, 0xa0, e, w{"a.nsset.be", "b.nsset.be", "c.nsset.be", "d.nsset.be", "y.nsset.be", "z.nsset.be"}, n, n, n, "whois.dns.be", e, t},
	{"beats", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.beats", "a2.nic.beats", "b0.nic.beats", "c0.nic.beats"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"beauty", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.beauty", "b.nic.beauty", "c.nic.beauty", "d.nic.beauty"}, n, n, n, "whois.nic.beauty", e, t},
	{"beer", r, x, 0x40, "http://nic.beer/", w{"dns1.nic.beer", "dns2.nic.beer", "dns3.nic.beer", "dns4.nic.beer", "dnsa.nic.beer", "dnsb.nic.beer", "dnsc.nic.beer", "dnsd.nic.beer"}, n, n, n, "whois.nic.beer", e, t},
	{"beknown", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"bentley", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.bentley", "dns2.nic.bentley", "dns3.nic.bentley", "dns4.nic.bentley", "dnsa.nic.bentley", "dnsb.nic.bentley", "dnsc.nic.bentley", "dnsd.nic.bentley"}, n, n, n, "whois.nic.bentley", e, t},
	{"berlin", r, x, 0xc4, e, w{"a.dns.nic.berlin", "m.dns.nic.berlin", "n.dns.nic.berlin"}, n, w{"Berlin", "DE-BE"}, n, "whois.nic.berlin", e, t},
	{"best", r, x, 0x40, "https://nic.best/", w{"a.nic.best", "b.nic.best", "c.nic.best", "d.nic.best"}, n, n, n, "whois.nic.best", e, t},
	{"bestbuy", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.bestbuy", "a2.nic.bestbuy", "b0.nic.bestbuy", "c0.nic.bestbuy"}, n, n, n, "whois.nic.bestbuy", e, f},
	{"bet", r, x, 0x40, "https://get.bet/", w{"a0.nic.bet", "a2.nic.bet", "b0.nic.bet", "c0.nic.bet"}, n, n, n, "whois.afilias.net", e, t},
	{"bf", r, z[1911:1912], 0xa0, e, w{"a.registre.bf", "censvrns0001.ird.fr"}, n, n, n, e, e, t},
	{"bg", r, z[1912:1948], 0xa0, "https://www.register.bg/user/", w{"a.nic.bg", "b.nic.bg", "c.nic.bg", "d.nic.bg", "e.nic.bg", "p.nic.bg"}, n, n, n, "whois.register.bg", e, t},
	{"bh", r, z[1948:1956], 0xa0, e, w{"a.bh.centralnic-dns.com", "b.bh.centralnic-dns.com", "c.bh.centralnic-dns.com", "d.bh.centralnic-dns.com"}, n, n, n, e, e, f},
	{"bharti", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, f},
	{"bi", r, z[1956:1966], 0xa0, e, w{"anyns.nic.bi", "bi.cctld.authdns.ripe.net", "ns-bi.afrinic.net", "ns.nic.bi", "ns1.nic.bi"}, n, n, n, "whois1.nic.bi", e, f},
	{"bible", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.bible", "ns2.dns.nic.bible", "ns3.dns.nic.bible", "ns4.dns.nic.bible", "ns5.dns.nic.bible", "ns6.dns.nic.bible"}, n, n, n, "whois.nic.bible", e, t},
	{"bid", r, x, 0x40, "https://www.famousfourmedia.com/", w{"ns1.dns.nic.bid", "ns2.dns.nic.bid", "ns3.dns.nic.bid", "ns4.dns.nic.bid", "ns5.dns.nic.bid", "ns6.dns.nic.bid"}, n, n, n, "whois.nic.bid", e, t},
	{"bike", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.bike", e, t},
	{"bing", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, t},
	{"bingo", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.bingo", e, t},
	{"bio", r, x, 0x40, "https://domains.bio/", w{"a0.nic.bio", "a2.nic.bio", "b0.nic.bio", "c0.nic.bio"}, n, n, n, "whois.afilias.net", e, t},
	{"biz", r, z[1966:1968], 0x40, e, w{"a.gtld.biz", "b.gtld.biz", "c.gtld.biz", "e.gtld.biz", "f.gtld.biz", "k.gtld.biz"}, n, n, n, "whois.nic.biz", e, t},
	{"bj", r, z[1968:1975], 0xa0, e, w{"anycastdns1.nic.bj", "anycastdns2.nic.bj", "ns-bj.afrinic.net", "ns-bj.nic.fr", "ns1.nic.bj", "ns2.nic.bj", "pch.nic.bj"}, n, n, n, "whois.nic.bj", e, f},
	{"black", r, x, 0x40, "https://get.black/", w{"a0.nic.black", "a2.nic.black", "b0.nic.black", "c0.nic.black"}, n, n, n, "whois.afilias.net", e, t},
	{"blackfriday", r, x, 0x40, "https://nic.blackfriday/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"blanco", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.blanco", e, t},
	{"blockbuster", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.blockbuster", "a2.nic.blockbuster", "b0.nic.blockbuster", "c0.nic.blockbuster"}, n, n, n, "whois.nic.blockbuster", e, f},
	{"blog", r, z[1975:2001], 0x40, "https://my.blog/", w{"a.nic.blog", "b.nic.blog", "c.nic.blog", "d.nic.blog"}, n, n, n, "whois.nic.blog", e, f},
	{"bloomberg", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, f},
	{"bloomingdales", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"blue", r, x, 0x40, "https://dotblue.blue/", w{"a0.nic.blue", "a2.nic.blue", "b0.nic.blue", "b2.nic.blue", "c0.nic.blue"}, n, n, n, "whois.afilias.net", e, t},
	{"bm", r, z[2001:2006], 0xa0, "https://www.bermudanic.bm/", w{"a0.bm.afilias-nst.info", "a2.bm.afilias-nst.info", "b0.bm.afilias-nst.org", "b2.bm.afilias-nst.org", "c0.bm.afilias-nst.info", "d0.bm.afilias-nst.org"}, n, n, n, e, "https://www.bermudanic.bm/whois.htm", f},
	{"bms", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.bms", e, f},
	{"bmw", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.bmw", "b.nic.bmw", "c.nic.bmw", "d.nic.bmw"}, n, n, n, "whois.nic.bmw", e, f},
	{"bn", r, z[2006:2011], 0xa0, "http://www.brunet.bn/products_webrelated_domain_main.htm", w{"bn-ns.anycast.pch.net", "ns1.bnnic.bn", "ns2.bnnic.bn", "ns4.apnic.net"}, n, n, n, "whois.bnnic.bn", e, f},
	{"bnl", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.bnl", e, f},
	{"bnpparibas", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.bnpparibas", "a2.nic.bnpparibas", "b0.nic.bnpparibas", "c0.nic.bnpparibas"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"bo", r, z[2011:2020], 0xa0, e, w{"anycast.ns.nic.bo", "ns.dns.br", "ns.nic.bo", "ns2.nic.fr"}, n, n, n, "whois.nic.bo", e, t},
	{"boats", r, x, 0x40, "https://nic.boats/", w{"a.nic.boats", "b.nic.boats", "c.nic.boats", "d.nic.boats"}, n, n, n, "whois.nic.boats", e, f},
	{"boehringer", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.boehringer", "a2.nic.boehringer", "b0.nic.boehringer", "c0.nic.boehringer"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"bofa", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.bofa", e, f},
	{"bom", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, "whois.gtlds.nic.br", e, t},
	{"bond", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.bond", "b.nic.bond", "c.nic.bond", "d.nic.bond"}, n, n, n, "whois.nic.bond", e, f},
	{"boo", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"book", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.book", "dns2.nic.book", "dns3.nic.book", "dns4.nic.book", "dnsa.nic.book", "dnsb.nic.book", "dnsc.nic.book", "dnsd.nic.book"}, n, n, n, "whois.nic.book", e, t},
	{"booking", r, x, 0x48, "https://newgtlds.icann.org/", w{"ns1.dns.nic.booking", "ns2.dns.nic.booking", "ns3.dns.nic.booking", "ns4.dns.nic.booking", "ns5.dns.nic.booking", "ns6.dns.nic.booking"}, n, n, n, "whois.nic.booking", e, t},
	{"boots", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.boots", e, f},
	{"bosch", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.bosch", e, f},
	{"bostik", r, x, 0x42, "https://newgtlds.icann.org/", w{"d.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, n, n, "whois.nic.bostik", e, t},
	{"boston", r, x, 0xc4, "http://nic.boston/", w{"dns1.nic.boston", "dns2.nic.boston", "dns3.nic.boston", "dns4.nic.boston", "dnsa.nic.boston", "dnsb.nic.boston", "dnsc.nic.boston", "dnsd.nic.boston"}, n, w{"Boston"}, n, "whois.nic.boston", e, f},
	{"bot", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.bot", "dns2.nic.bot", "dns3.nic.bot", "dns4.nic.bot", "dnsa.nic.bot", "dnsb.nic.bot", "dnsc.nic.bot", "dnsd.nic.bot"}, n, n, n, "whois.nic.bot", e, t},
	{"boutique", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.boutique", e, t},
	{"box", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.box", "b.nic.box", "c.nic.box", "d.nic.box"}, n, n, n, "whois.nic.box", e, t},
	{"br", r, z[2020:2126], 0xa0, "https://nic.br/", w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, "whois.registro.br", e, t},
	{"bradesco", r, x, 0x42, "http://nic.bradesco/", w{"dns1.nic.bradesco", "dns2.nic.bradesco", "dns3.nic.bradesco", "dns4.nic.bradesco", "dnsa.nic.bradesco", "dnsb.nic.bradesco", "dnsc.nic.bradesco", "dnsd.nic.bradesco"}, n, n, n, "whois.nic.bradesco", e, f},
	{"bridgestone", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.bridgestone", e, t},
	{"broadway", r, x, 0x40, "https://discover.broadway/", w{"dns1.nic.broadway", "dns2.nic.broadway", "dns3.nic.broadway", "dns4.nic.broadway", "dnsa.nic.broadway", "dnsb.nic.broadway", "dnsc.nic.broadway", "dnsd.nic.broadway"}, n, n, n, "whois.nic.broadway", e, f},
	{"broker", r, x, 0x40, "https://bostonivy.co/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.broker", e, f},
	{"brother", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.brother", e, t},
	{"brussels", r, x, 0xc4, "https://newgtlds.icann.org/", w{"a.nsset.brussels", "b.nsset.brussels", "c.nsset.brussels", "d.nsset.brussels", "y.nsset.brussels", "z.nsset.brussels"}, n, w{"Brussels", "BE-BRU"}, n, "whois.nic.brussels", e, t},
	{"bs", r, z[2126:2132], 0xa0, e, w{"anyns.dns.bs", "anyns.pch.net", "ns36.cdns.net"}, n, n, n, e, "http://www.nic.bs/cgi-bin/search.pl", t},
	{"bt", r, z[2132:2137], 0xa0, e, w{"auth00.ns.uu.net", "auth61.ns.uu.net", "ns.itu.ch", "ns1.druknet.bt", "ns2.druknet.bt", "ns3.druknet.bt", "phloem.uoregon.edu"}, n, n, n, e, "http://www.nic.bt/", f},
	{"budapest", r, x, 0xc4, "http://nic.budapest/", w{"dns1.nic.budapest", "dns2.nic.budapest", "dns3.nic.budapest", "dns4.nic.budapest", "dnsa.nic.budapest", "dnsb.nic.budapest", "dnsc.nic.budapest", "dnsd.nic.budapest"}, n, w{"Budapest", "HU-BU"}, n, "whois.nic.budapest", e, t},
	{"bugatti", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.bugatti", "a2.nic.bugatti", "b0.nic.bugatti", "c0.nic.bugatti"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"buick", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"build", r, x, 0x40, "https://about.build/", w{"a.nic.build", "b.nic.build", "c.nic.build", "d.nic.build"}, n, n, n, "whois.nic.build", e, f},
	{"builders", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.builders", e, t},
	{"business", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.business", e, t},
	{"buy", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.buy", "dns2.nic.buy", "dns3.nic.buy", "dns4.nic.buy", "dnsa.nic.buy", "dnsb.nic.buy", "dnsc.nic.buy", "dnsd.nic.buy"}, n, n, n, "whois.nic.buy", e, t},
	{"buzz", r, x, 0x40, e, w{"ns1.dns.nic.buzz", "ns2.dns.nic.buzz", "ns3.dns.nic.buzz", "ns4.dns.nic.buzz", "ns5.dns.nic.buzz", "ns6.dns.nic.buzz"}, n, n, n, "whois.nic.buzz", e, t},
	{"bv", r, x, 0xa8, e, w{"nac.no", "nn.uninett.no", "server.nordu.net"}, n, n, n, "whois.norid.no", e, f},
	{"bw", r, z[2137:2141], 0xa0, e, w{"dns1.nic.net.bw", "master.btc.net.bw", "ns-bw.afrinic.net", "pch.nic.net.bw"}, n, n, n, "whois.nic.net.bw", e, f},
	{"bway", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"by", r, z[2141:2146], 0xa0, "https://domain.by/", w{"dns1.tld.hosterby.com", "dns2.tld.hosterby.com", "dns3.tld.hosterby.com", "dns4.tld.hosterby.com", "dns5.tld.hosterby.com", "dns6.tld.hosterby.com"}, n, n, n, "whois.cctld.by", e, f},
	{"bz", r, z[2146:2153], 0xe0, "https://www.belizenic.bz/", w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, "whois.afilias-grs.info", e, f},
	{"bzh", r, x, 0x4c0, "https://newgtlds.icann.org/", w{"d.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, w{"FR-E"}, n, "whois.nic.bzh", e, t},
	{"ca", r, z[2153:2169], 0xa0, e, w{"any.ca-servers.ca", "c.ca-servers.ca", "j.ca-servers.ca", "x.ca-servers.ca"}, n, n, n, "whois.cira.ca", e, t},
	{"cab", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.cab", e, t},
	{"cadillac", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"cafe", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.cafe", e, t},
	{"cal", r, x, 0x42, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"call", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.call", "dns2.nic.call", "dns3.nic.call", "dns4.nic.call", "dnsa.nic.call", "dnsb.nic.call", "dnsc.nic.call", "dnsd.nic.call"}, n, n, n, "whois.nic.call", e, t},
	{"calvinklein", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.calvinklein", "ns2.dns.nic.calvinklein", "ns3.dns.nic.calvinklein", "ns4.dns.nic.calvinklein", "ns5.dns.nic.calvinklein", "ns6.dns.nic.calvinklein"}, n, n, n, "whois.nic.calvinklein", e, t},
	{"cam", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.cam", "b.nic.cam", "c.nic.cam", "d.nic.cam"}, n, n, n, "whois.nic.cam", e, t},
	{"camera", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.camera", e, t},
	{"camp", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.camp", e, t},
	{"canalplus", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"cancerresearch", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.cancerresearch", "b.nic.cancerresearch", "c.nic.cancerresearch", "d.nic.cancerresearch"}, n, n, n, "whois.nic.cancerresearch", e, f},
	{"canon", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.canon", e, t},
	{"capetown", r, x, 0xc4, e, w{"coza1.dnsnode.net", "ns.coza.net.za", "ns2us.dns.business"}, n, w{"Cape Town"}, n, "capetown-whois.registry.net.za", e, t},
	{"capital", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.capital", e, t},
	{"capitalone", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.capitalone", e, f},
	{"car", r, x, 0x40, "https://nic.car/", w{"a.nic.car", "b.nic.car", "c.nic.car", "d.nic.car"}, n, n, n, "whois.nic.car", e, t},
	{"caravan", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.caravan", "ns2.dns.nic.caravan", "ns3.dns.nic.caravan", "ns4.dns.nic.caravan", "ns5.dns.nic.caravan", "ns6.dns.nic.caravan"}, n, n, n, "whois.nic.caravan", e, t},
	{"cards", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.cards", e, t},
	{"care", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.care", e, t},
	{"career", r, x, 0x40, e, w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.career", e, t},
	{"careers", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.careers", e, t},
	{"carinsurance", r, x, 0x2040, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"cars", r, x, 0x40, "https://nic.cars/", w{"a.nic.cars", "b.nic.cars", "c.nic.cars", "d.nic.cars"}, n, n, n, "whois.nic.cars", e, t},
	{"cartier", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.cartier", e, t},
	{"casa", r, x, 0x40, "http://nic.casa/", w{"dns1.nic.casa", "dns2.nic.casa", "dns3.nic.casa", "dns4.nic.casa", "dnsa.nic.casa", "dnsb.nic.casa", "dnsc.nic.casa", "dnsd.nic.casa"}, n, n, n, "whois.nic.casa", e, t},
	{"case", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.case", "a2.nic.case", "b0.nic.case", "c0.nic.case"}, n, n, n, "whois.nic.case", e, f},
	{"caseih", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.caseih", e, f},
	{"cash", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.cash", e, t},
	{"cashbackbonus", r, x, 0x48, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"casino", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.casino", e, t},
	{"cat", r, x, 0x1440, "https://domini.cat/", w{"anyc1.irondns.net", "cat.pch.net", "ns.nic.cat", "ns1.nic.es", "nsc.nic.de", "switch.nic.cat"}, n, w{"ES-CT"}, n, "whois.nic.cat", e, t},
	{"catalonia", r, x, 0x2040, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"catering", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.catering", e, t},
	{"catholic", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.catholic", "b.nic.catholic", "c.nic.catholic", "d.nic.catholic"}, n, n, n, "whois.nic.catholic", e, f},
	{"cba", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.cba", "b.nic.cba", "c.nic.cba", "d.nic.cba"}, n, n, n, "whois.nic.cba", e, f},
	{"cbn", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.cbn", "ns2.dns.nic.cbn", "ns3.dns.nic.cbn", "ns4.dns.nic.cbn", "ns5.dns.nic.cbn", "ns6.dns.nic.cbn"}, n, n, n, "whois.nic.cbn", e, t},
	{"cbre", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.cbre", "ns2.dns.nic.cbre", "ns3.dns.nic.cbre", "ns4.dns.nic.cbre", "ns5.dns.nic.cbre", "ns6.dns.nic.cbre"}, n, n, n, "whois.nic.cbre", e, t},
	{"cbs", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.cbs", "a2.nic.cbs", "b0.nic.cbs", "c0.nic.cbs"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"cc", r, z[2169:2173], 0xe0, e, w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "ccwhois.verisign-grs.com", e, t},
	{"cd", r, z[2173:2179], 0xe0, "https://www.nic.cd/nic.cd/", w{"ns-root-21.scpt-network.net", "ns-root-22.scpt-network.net", "ns-root-23.scpt-network.net"}, n, n, n, "whois.cd", e, f},
	{"ceb", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.afilias-srs.net", e, f},
	{"center", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.center", e, t},
	{"ceo", r, x, 0x40, e, w{"a.nic.ceo", "b.nic.ceo", "c.nic.ceo", "d.nic.ceo"}, n, n, n, "whois.nic.ceo", e, t},
	{"cern", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.cern", "a2.nic.cern", "b0.nic.cern", "c0.nic.cern"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"cf", r, x, 0xa0, e, w{"a.ns.cf", "b.ns.cf", "c.ns.cf", "d.ns.cf"}, n, n, n, "whois.dot.cf", e, t},
	{"cfa", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.cfa", e, f},
	{"cfd", r, x, 0x40, "https://bostonivy.co/", w{"a.nic.cfd", "b.nic.cfd", "c.nic.cfd", "d.nic.cfd"}, n, n, n, "whois.nic.cfd", e, f},
	{"cg", r, x, 0xa0, e, w{"dns-fr.dnsafrica.net", "dns-za.dnsafrica.net", "sunic.sunet.se"}, n, n, n, e, "http://www.nic.cg/cgi-bin/whois.pl", f},
	{"ch", r, x, 0xa0, e, w{"a.nic.ch", "b.nic.ch", "c.nic.ch", "e.nic.ch", "f.nic.ch", "g.nic.ch"}, n, n, n, "whois.nic.ch", e, t},
	{"chanel", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.chanel", e, f},
	{"changiairport", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"channel", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"charity", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.charity", e, t},
	{"chartis", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"chase", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.chase", "ns2.dns.nic.chase", "ns3.dns.nic.chase", "ns4.dns.nic.chase", "ns5.dns.nic.chase", "ns6.dns.nic.chase"}, n, n, n, "whois.nic.chase", e, t},
	{"chat", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.chat", e, t},
	{"cheap", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.cheap", e, t},
	{"chesapeake", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"chevrolet", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"chevy", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"chintai", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.chintai", "ns2.dns.nic.chintai", "ns3.dns.nic.chintai", "ns4.dns.nic.chintai", "ns5.dns.nic.chintai", "ns6.dns.nic.chintai"}, n, n, n, "whois.nic.chintai", e, t},
	{"chk", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"chloe", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.chloe", e, f},
	{"christmas", r, x, 0x40, "https://nic.christmas/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"chrome", r, x, 0x42, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"chrysler", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.afilias-srs.net", e, f},
	{"church", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.church", e, t},
	{"ci", r, z[2179:2196], 0xa0, e, w{"any.nic.ci", "censvrns0001.ird.fr", "ci.hosting.nic.fr", "ns-ci.afrinic.net", "ns.nic.ci", "phloem.uoregon.edu"}, n, n, n, "whois.nic.ci", e, f},
	{"cimb", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"cipriani", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.cipriani", "a2.nic.cipriani", "b0.nic.cipriani", "c0.nic.cipriani"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"circle", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.circle", "dns2.nic.circle", "dns3.nic.circle", "dns4.nic.circle", "dnsa.nic.circle", "dnsb.nic.circle", "dnsc.nic.circle", "dnsd.nic.circle"}, n, n, n, "whois.nic.circle", e, t},
	{"cisco", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.cisco", "ns2.dns.nic.cisco", "ns3.dns.nic.cisco", "ns4.dns.nic.cisco", "ns5.dns.nic.cisco", "ns6.dns.nic.cisco"}, n, n, n, "whois.nic.cisco", e, f},
	{"citadel", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.citadel", "ns2.dns.nic.citadel", "ns3.dns.nic.citadel", "ns4.dns.nic.citadel", "ns5.dns.nic.citadel", "ns6.dns.nic.citadel"}, n, n, n, "whois.nic.citadel", e, f},
	{"citi", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.citi", "ns2.dns.nic.citi", "ns3.dns.nic.citi", "ns4.dns.nic.citi", "ns5.dns.nic.citi", "ns6.dns.nic.citi"}, n, n, n, "whois.nic.citi", e, t},
	{"citic", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.nic.citic", e, t},
	{"city", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.city", e, t},
	{"cityeats", r, x, 0x48, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.cityeats", e, f},
	{"ck", r, z[2196:2204], 0xa8, "http://www.oyster.net.ck/about/index.php?about=domain", w{"circa.mcs.vuw.ac.nz", "downstage.mcs.vuw.ac.nz", "parau.oyster.net.ck", "poiparau.oyster.net.ck"}, n, n, n, "whois.ck-nic.org.ck", e, f},
	{"cl", r, x, 0xa0, e, w{"a.nic.cl", "b.nic.cl", "c.nic.cl", "cl-ns.anycast.pch.net", "cl1-tld.d-zone.ca", "cl1.dnsnode.net", "cl2-tld.d-zone.ca"}, n, n, n, "whois.nic.cl", e, t},
	{"claims", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.claims", e, t},
	{"cleaning", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.cleaning", e, t},
	{"click", r, x, 0x40, "https://nic.click/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"clinic", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.clinic", e, t},
	{"clinique", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.clinique", "a2.nic.clinique", "b0.nic.clinique", "c0.nic.clinique"}, n, n, n, "whois.nic.clinique", e, f},
	{"clothing", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.clothing", e, t},
	{"cloud", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.cloud", "b.nic.cloud", "c.nic.cloud", "d.nic.cloud"}, n, n, n, "whois.nic.cloud", e, f},
	{"club", r, x, 0x40, e, w{"ns1.dns.nic.club", "ns2.dns.nic.club", "ns3.dns.nic.club", "ns4.dns.nic.club", "ns5.dns.nic.club", "ns6.dns.nic.club"}, n, n, n, "whois.nic.club", e, t},
	{"clubmed", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.clubmed", e, t},
	{"cm", r, z[2204:2208], 0xa0, "https://antic.cm/", w{"auth02.ns.uu.net", "kim.camnet.cm", "lom.camnet.cm", "ns.itu.ch", "sanaga.camnet.cm"}, n, n, n, "whois.netcom.cm", e, f},
	{"cn", r, z[2208:2250], 0xa0, "http://cnnic.cn/", w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn", "ns.cernet.net"}, n, n, n, "whois.cnnic.cn", e, t},
	{"co", r, z[2250:2257], 0xe0, "https://www.go.co/", w{"ns1.cctld.co", "ns2.cctld.co", "ns3.cctld.co", "ns4.cctld.co", "ns5.cctld.co", "ns6.cctld.co"}, n, n, n, "whois.nic.co", e, t},
	{"coach", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.coach", e, t},
	{"codes", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.codes", e, t},
	{"coffee", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.coffee", e, t},
	{"college", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.college", "b.nic.college", "c.nic.college", "d.nic.college"}, n, n, n, "whois.nic.college", e, t},
	{"cologne", r, x, 0xc4, e, w{"dns.ryce-rsp.com", "ns1.dns.business", "ns1.ryce-rsp.com"}, n, w{"Cologne", "Koeln"}, n, "whois.ryce-rsp.com", e, t},
	{"com", r, z[2257:2288], 0x40, "https://www.verisign.com/en_US/domain-names/com-domain-names/index.xhtml", w{"a.gtld-servers.net", "b.gtld-servers.net", "c.gtld-servers.net", "d.gtld-servers.net", "e.gtld-servers.net", "f.gtld-servers.net", "g.gtld-servers.net", "h.gtld-servers.net", "i.gtld-servers.net", "j.gtld-servers.net", "k.gtld-servers.net", "l.gtld-servers.net", "m.gtld-servers.net"}, n, n, n, "whois.verisign-grs.com", e, t},
	{"comcast", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.comcast", "dns2.nic.comcast", "dns3.nic.comcast", "dns4.nic.comcast", "dnsa.nic.comcast", "dnsb.nic.comcast", "dnsc.nic.comcast", "dnsd.nic.comcast"}, n, n, n, "whois.nic.comcast", e, f},
	{"commbank", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.commbank", "b.nic.commbank", "c.nic.commbank", "d.nic.commbank"}, n, n, n, "whois.nic.commbank", e, f},
	{"community", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.community", e, t},
	{"company", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.company", e, t},
	{"compare", r, x, 0x40, "https://www.go.compare/", w{"a.nic.compare", "b.nic.compare", "c.nic.compare", "d.nic.compare"}, n, n, n, "whois.nic.compare", e, f},
	{"computer", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.computer", e, t},
	{"comsec", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.comsec", e, t},
	{"condos", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.condos", e, t},
	{"connectors", r, x, 0x2040, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"construction", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.construction", e, t},
	{"consulting", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.consulting", e, t},
	{"contact", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.contact", e, t},
	{"contractors", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.contractors", e, t},
	{"cooking", r, x, 0x40, "http://nic.cooking/", w{"dns1.nic.cooking", "dns2.nic.cooking", "dns3.nic.cooking", "dns4.nic.cooking", "dnsa.nic.cooking", "dnsb.nic.cooking", "dnsc.nic.cooking", "dnsd.nic.cooking"}, n, n, n, "whois.nic.cooking", e, t},
	{"cookingchannel", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.cookingchannel", e, f},
	{"cool", r, z[2288:2289], 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.cool", e, t},
	{"coop", r, x, 0x1040, "https://identity.coop/", w{"a.nic.coop", "b.nic.coop", "c.nic.coop", "d.nic.coop"}, n, n, n, "whois.nic.coop", e, f},
	{"corp", r, x, 0x2140, "https://features.icann.org/addressing-new-gtld-program-applications-corp-home-and-mail", n, n, n, n, e, e, t},
	{"corsica", r, x, 0x4c0, "https://newgtlds.icann.org/", w{"d.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, w{"FR-H"}, n, "whois-corsica.nic.fr", e, t},
	{"country", r, x, 0x40, "https://nic.country/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"coupon", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.coupon", "ns2.dns.nic.coupon", "ns3.dns.nic.coupon", "ns4.dns.nic.coupon", "ns5.dns.nic.coupon", "ns6.dns.nic.coupon"}, n, n, n, "whois.nic.coupon", e, t},
	{"coupons", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.coupons", e, t},
	{"courses", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.courses", "b.nic.courses", "c.nic.courses", "d.nic.courses"}, n, n, n, "whois.nic.courses", e, f},
	{"cpa", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.cpa", "b.nic.cpa", "c.nic.cpa", "d.nic.cpa"}, n, n, n, "whois.nic.cpa", e, t},
	{"cr", r, z[2289:2297], 0xa0, "https://www.nic.cr/", w{"a.lactld.org", "ca1.nic.cr", "ca2.nic.cr", "de.nic.cr", "dns.nic.cr", "p.nic.cr"}, n, n, n, "whois.nic.cr", e, f},
	{"credit", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.credit", e, t},
	{"creditcard", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.creditcard", e, t},
	{"creditunion", r, x, 0x40, "https://nic.creditunion/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns5.uniregistry.net", "ns6.uniregistry.info"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"cricket", r, x, 0x40, "https://www.famousfourmedia.com/", w{"ns1.dns.nic.cricket", "ns2.dns.nic.cricket", "ns3.dns.nic.cricket", "ns4.dns.nic.cricket", "ns5.dns.nic.cricket", "ns6.dns.nic.cricket"}, n, n, n, "whois.nic.cricket", e, t},
	{"crown", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, f},
	{"crs", r, x, 0x42, "http://nic.crs/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.crs", e, f},
	{"cruise", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.cruise", "a2.nic.cruise", "b0.nic.cruise", "c0.nic.cruise"}, n, n, n, "whois.nic.cruise", e, f},
	{"cruises", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.cruises", e, t},
	{"csc", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.csc", e, f},
	{"cu", r, z[2297:2308], 0xa0, e, w{"cu.cctld.authdns.ripe.net", "ns.ceniai.net.cu", "ns.dns.br", "ns2.ceniai.net.cu", "ns2.gip.net", "rip.psg.com"}, n, n, n, e, "http://www.nic.cu/", f},
	{"cuisinella", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.cuisinella", "b.nic.cuisinella", "c.nic.cuisinella", "d.nic.cuisinella"}, n, n, n, "whois.nic.cuisinella", e, f},
	{"cv", r, z[2308:2316], 0xa0, e, w{"c.dns.pt", "cv01.dns.pt", "ns-ext.isc.org", "ns.dns.cv"}, n, n, n, e, "http://www.dns.cv/", f},
	{"cw", r, z[2316:2318], 0xa0, "https://en.wikipedia.org/wiki/.cw", w{"cw.cctld.authdns.ripe.net", "kadushi.curinfo.cw", "ns0.ja.net", "ns01-server.curinfo.cw", "ns1.uoc.cw", "ns2.uoc.cw", "ns3.uoc.cw"}, n, n, n, e, e, f},
	{"cx", r, z[2318:2323], 0xa0, e, w{"ns.anycast.nic.cx", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, "whois.nic.cx", e, f},
	{"cy", r, z[2323:2336], 0xa8, e, w{"cy-ns.anycast.pch.net", "cynic.dns.cy", "cynic4.dns.cy", "cynic6.dns.cy", "estia.ics.forth.gr", "ns02.savvis.net", "ns31.rcode0.net", "ns4.apnic.net"}, n, n, n, e, "http://www.nic.cy/nslookup/online_database.php", f},
	{"cymru", r, x, 0x440, "https://eincartrefarlein.cymru/", w{"dns1.nic.cymru", "dns2.nic.cymru", "dns3.nic.cymru", "dns4.nic.cymru", "dnsa.nic.cymru", "dnsb.nic.cymru", "dnsc.nic.cymru", "dnsd.nic.cymru"}, n, w{"GB-WLS"}, n, "whois.nic.cymru", e, t},
	{"cyou", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.cyou", "b.nic.cyou", "c.nic.cyou", "d.nic.cyou"}, n, n, n, "whois.nic.cyou", e, f},
	{"cz", r, z[2336:2337], 0xa0, "https://www.nic.cz/", w{"a.ns.nic.cz", "b.ns.nic.cz", "c.ns.nic.cz", "d.ns.nic.cz"}, n, n, n, "whois.nic.cz", e, t},
	{"dabur", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.dabur", "a2.nic.dabur", "b0.nic.dabur", "c0.nic.dabur"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"dad", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"dance", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.dance", e, t},
	{"data", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.data", "a2.nic.data", "b0.nic.data", "c0.nic.data"}, n, n, n, "whois.nic.data", e, f},
	{"date", r, x, 0x40, "https://www.famousfourmedia.com/", w{"ns1.dns.nic.date", "ns2.dns.nic.date", "ns3.dns.nic.date", "ns4.dns.nic.date", "ns5.dns.nic.date", "ns6.dns.nic.date"}, n, n, n, "whois.nic.date", e, t},
	{"dating", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.dating", e, t},
	{"datsun", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.gmo", e, t},
	{"day", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"dclk", r, x, 0x42, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"dds", r, x, 0x40, "http://nic.dds/", w{"dns1.nic.dds", "dns2.nic.dds", "dns3.nic.dds", "dns4.nic.dds", "dnsa.nic.dds", "dnsb.nic.dds", "dnsc.nic.dds", "dnsd.nic.dds"}, n, n, n, "whois.nic.dds", e, t},
	{"de", r, z[2337:2340], 0xa0, "https://www.denic.de/", w{"a.nic.de", "f.nic.de", "l.de.net", "n.de.net", "s.de.net", "z.nic.de"}, n, n, n, "whois.denic.de", e, t},
	{"deal", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.deal", "dns2.nic.deal", "dns3.nic.deal", "dns4.nic.deal", "dnsa.nic.deal", "dnsb.nic.deal", "dnsc.nic.deal", "dnsd.nic.deal"}, n, n, n, "whois.nic.deal", e, t},
	{"dealer", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.nic.dealer", e, t},
	{"deals", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.deals", e, t},
	{"degree", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.degree", e, t},
	{"delivery", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.delivery", e, t},
	{"dell", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.dell", "ns2.dns.nic.dell", "ns3.dns.nic.dell", "ns4.dns.nic.dell", "ns5.dns.nic.dell", "ns6.dns.nic.dell"}, n, n, n, "whois.nic.dell", e, t},
	{"delmonte", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"deloitte", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.deloitte", "b.nic.deloitte", "c.nic.deloitte", "d.nic.deloitte"}, n, n, n, "whois.nic.deloitte", e, t},
	{"delta", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.delta", "a2.nic.delta", "b0.nic.delta", "c0.nic.delta"}, n, n, n, "whois.nic.delta", e, f},
	{"democrat", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.democrat", e, t},
	{"dental", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.dental", e, t},
	{"dentist", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.dentist", e, t},
	{"desi", r, x, 0x40, e, w{"a.nic.desi", "b.nic.desi", "c.nic.desi", "d.nic.desi"}, n, n, n, "whois.nic.desi", e, t},
	{"design", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.design", "b.nic.design", "c.nic.design", "d.nic.design"}, n, n, n, "whois.nic.design", e, t},
	{"deutschepost", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"dev", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"dhl", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.dhl", "b.nic.dhl", "c.nic.dhl", "d.nic.dhl"}, n, n, n, e, e, t},
	{"diamonds", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.diamonds", e, t},
	{"diet", r, x, 0x40, "https://nic.diet/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"digikey", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"digital", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.digital", e, t},
	{"direct", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.direct", e, t},
	{"directory", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.directory", e, t},
	{"discount", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.discount", e, t},
	{"discover", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.discover", "ns2.dns.nic.discover", "ns3.dns.nic.discover", "ns4.dns.nic.discover", "ns5.dns.nic.discover", "ns6.dns.nic.discover"}, n, n, n, "whois.nic.discover", e, f},
	{"dish", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.dish", "a2.nic.dish", "b0.nic.dish", "c0.nic.dish"}, n, n, n, "whois.nic.dish", e, f},
	{"diy", r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.diy", e, f},
	{"dj", r, x, 0xe0, e, w{"bow1.intnet.dj", "bow5.intnet.dj", "vps443605.ovh.net"}, n, n, n, e, "http://www.nic.dj/whois.php", f},
	{"dk", r, z[2340:2342], 0xa0, "https://www.dk-hostmaster.dk/", w{"a.nic.dk", "b.nic.dk", "c.nic.dk", "d.nic.dk", "l.nic.dk", "p.nic.dk", "s.nic.dk"}, n, n, n, "whois.dk-hostmaster.dk", e, t},
	{"dm", r, z[2342:2348], 0xa0, e, w{"ns.blacknightsolutions.com", "ns2.blacknightsolutions.com", "ns2.nic.dm", "ns34.cdns.net"}, n, n, n, "whois.nic.dm", e, t},
	{"dnb", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"dnp", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.dnp", e, t},
	{"do", r, z[2348:2359], 0xa0, "https://www.nic.do/", w{"a.lactld.org", "ns.nic.do", "ns1.nic.do", "ns2.nic.do", "ns3.nic.mx", "ns4.nic.do", "ns5.nic.do", "phloem.uoregon.edu"}, n, n, n, "whois.nic.do", e, f},
	{"docomo", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"docs", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"doctor", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.doctor", e, t},
	{"dodge", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.afilias-srs.net", e, f},
	{"dog", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.dog", e, t},
	{"doha", r, x, 0xc4, "https://newgtlds.icann.org/", n, n, w{"Doha", "QA-DA"}, n, "whois.nic.doha", e, f},
	{"domains", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.domains", e, t},
	{"doosan", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.xn--cg4bki", e, f},
	{"dot", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.dot", "a2.nic.dot", "b0.nic.dot", "c0.nic.dot"}, n, n, n, "whois.nic.dot", e, f},
	{"dotafrica", r, x, 0x2040, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"download", r, x, 0x40, "https://www.famousfourmedia.com/", w{"ns1.dns.nic.download", "ns2.dns.nic.download", "ns3.dns.nic.download", "ns4.dns.nic.download", "ns5.dns.nic.download", "ns6.dns.nic.download"}, n, n, n, "whois.nic.download", e, t},
	{"drive", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"dstv", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"dtv", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.dtv", "a2.nic.dtv", "b0.nic.dtv", "c0.nic.dtv"}, n, n, n, "whois.nic.dtv", e, f},
	{"dubai", r, x, 0xc4, "https://newgtlds.icann.org/", w{"gtld.alpha.aridns.net.au", "gtld.beta.aridns.net.au", "gtld.delta.aridns.net.au", "gtld.gamma.aridns.net.au"}, n, w{"AE-DU", "Dubai"}, n, "whois.nic.dubai", e, f},
	{"duck", r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.duck", e, f},
	{"dunlop", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.dunlop", "a2.nic.dunlop", "b0.nic.dunlop", "c0.nic.dunlop"}, n, n, n, "whois.nic.dunlop", e, f},
	{"duns", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.duns", e, f},
	{"dupont", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.dupont", "ns2.dns.nic.dupont", "ns3.dns.nic.dupont", "ns4.dns.nic.dupont", "ns5.dns.nic.dupont", "ns6.dns.nic.dupont"}, n, n, n, "whois.nic.dupont", e, t},
	{"durban", r, x, 0xc4, e, w{"coza1.dnsnode.net", "ns.coza.net.za", "ns2us.dns.business"}, n, w{"Durban"}, n, "durban-whois.registry.net.za", e, t},
	{"dvag", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.dvag", "b.nic.dvag", "c.nic.dvag", "d.nic.dvag"}, n, n, n, "whois.nic.dvag", e, f},
	{"dvr", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.dvr", "a2.nic.dvr", "b0.nic.dvr", "c0.nic.dvr"}, n, n, n, "whois.nic.dvr", e, f},
	{"dwg", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"dz", r, z[2359:2367], 0xa0, e, w{"ns-dz.afrinic.net", "ns1.nic.dz", "ns2.nic.dz", "ns3.nic.fr", "ns4.nic.dz", "ns5.nic.dz"}, n, n, n, "whois.nic.dz", e, f},
	{"earth", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.earth", "ns2.dns.nic.earth", "ns3.dns.nic.earth", "ns4.dns.nic.earth", "ns5.dns.nic.earth", "ns6.dns.nic.earth"}, n, n, n, "whois.nic.earth", e, t},
	{"eat", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"ec", r, z[2367:2378], 0xa0, e, w{"a.lactld.org", "n2.nic.ec", "n3.dns.ec"}, n, n, n, "whois.nic.ec", e, f},
	{"eco", r, x, 0x40, "https://bigroom.eco/", w{"a0.nic.eco", "a2.nic.eco", "b0.nic.eco", "c0.nic.eco"}, n, n, n, "whois.nic.eco", e, f},
	{"ecom", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"edeka", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.edeka", "a2.nic.edeka", "b0.nic.edeka", "c0.nic.edeka"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"edu", r, x, 0x1040, e, w{"a.edu-servers.net", "b.edu-servers.net", "c.edu-servers.net", "d.edu-servers.net", "e.edu-servers.net", "f.edu-servers.net", "g.edu-servers.net", "h.edu-servers.net", "i.edu-servers.net", "j.edu-servers.net", "k.edu-servers.net", "l.edu-servers.net", "m.edu-servers.net"}, n, n, n, "whois.educause.edu", e, f},
	{"education", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.education", e, t},
	{"ee", r, z[2378:2392], 0xa0, e, w{"b.tld.ee", "e.tld.ee", "ee.aso.ee", "ee.eenet.ee", "ns.tld.ee"}, n, n, n, "whois.tld.ee", e, f},
	{"eg", r, z[2392:2404], 0xa0, e, w{"frcu.eun.eg", "ns5.univie.ac.at", "rip.psg.com"}, n, n, n, e, "http://lookup.egregistry.eg/english.aspx", f},
	{"email", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.email", e, t},
	{"emerck", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.emerck", "a2.nic.emerck", "b0.nic.emerck", "c0.nic.emerck"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"emerson", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"energy", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.energy", e, t},
	{"engineer", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.engineer", e, t},
	{"engineering", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.engineering", e, t},
	{"enterprises", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.enterprises", e, t},
	{"epost", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, t},
	{"epson", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.epson", e, t},
	{"equipment", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.equipment", e, t},
	{"er", r, z[2404:2411], 0xa8, e, w{"er.cctld.authdns.ripe.net", "sawanew.noc.net.er", "zaranew.noc.net.er"}, n, n, n, e, e, f},
	{"ericsson", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.ericsson", e, f},
	{"erni", r, x, 0x42, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.erni", e, f},
	{"es", r, z[2411:2416], 0xa0, e, w{"a.nic.es", "c.nic.es", "f.nic.es", "g.nic.es", "h.nic.es", "ns-es.nic.fr", "ns1.cesca.es", "ssdns-tld.nic.cl"}, n, n, n, "whois.nic.es", e, t},
	{"esq", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"estate", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.estate", e, t},
	{"esurance", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.afilias-srs.net", e, f},
	{"et", r, z[2416:2424], 0xa0, "http://www.ethionet.et/?q=ipservicedomainname", w{"a.nic.et", "b.nic.et"}, n, n, n, e, e, f},
	{"etisalat", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.etisalat", "b.nic.etisalat", "c.nic.etisalat", "d.nic.etisalat"}, n, n, n, "whois.centralnic.com", e, f},
	{"eu", r, z[2424:2427], 0xa0, e, w{"nl.dns.eu", "si.dns.eu", "w.dns.eu", "x.dns.eu", "y.dns.eu"}, n, n, n, "whois.eu", e, t},
	{"eurovision", r, x, 0x42, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.eurovision", e, f},
	{"eus", r, x, 0x440, e, w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.eus", e, t},
	{"events", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.events", e, t},
	{"everbank", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.everbank", e, f},
	{"exchange", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.exchange", e, t},
	{"expert", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.expert", e, t},
	{"exposed", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.exposed", e, t},
	{"express", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.express", e, t},
	{"extraspace", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.extraspace", "a2.nic.extraspace", "b0.nic.extraspace", "c0.nic.extraspace"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"fage", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.fage", "a2.nic.fage", "b0.nic.fage", "c0.nic.fage"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"fail", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.fail", e, t},
	{"fairwinds", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.fairwinds", e, t},
	{"faith", r, x, 0x40, "https://www.famousfourmedia.com/", w{"ns1.dns.nic.faith", "ns2.dns.nic.faith", "ns3.dns.nic.faith", "ns4.dns.nic.faith", "ns5.dns.nic.faith", "ns6.dns.nic.faith"}, n, n, n, "whois.nic.faith", e, t},
	{"family", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.family", e, t},
	{"fan", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.fan", e, t},
	{"fans", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.fans", "b.nic.fans", "c.nic.fans", "d.nic.fans"}, n, n, n, "whois.nic.fans", e, f},
	{"farm", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.farm", e, t},
	{"farmers", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.farmers", "ns2.dns.nic.farmers", "ns3.dns.nic.farmers", "ns4.dns.nic.farmers", "ns5.dns.nic.farmers", "ns6.dns.nic.farmers"}, n, n, n, "whois.nic.farmers", e, t},
	{"fashion", r, x, 0x40, "http://nic.fashion/", w{"dns1.nic.fashion", "dns2.nic.fashion", "dns3.nic.fashion", "dns4.nic.fashion", "dnsa.nic.fashion", "dnsb.nic.fashion", "dnsc.nic.fashion", "dnsd.nic.fashion"}, n, n, n, "whois.nic.fashion", e, t},
	{"fast", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.fast", "dns2.nic.fast", "dns3.nic.fast", "dns4.nic.fast", "dnsa.nic.fast", "dnsb.nic.fast", "dnsc.nic.fast", "dnsd.nic.fast"}, n, n, n, "whois.nic.fast", e, t},
	{"fedex", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.fedex", "a2.nic.fedex", "b0.nic.fedex", "c0.nic.fedex"}, n, n, n, "whois.nic.fedex", e, f},
	{"feedback", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.feedback", "b.nic.feedback", "c.nic.feedback", "d.nic.feedback"}, n, n, n, "whois.nic.feedback", e, t},
	{"ferrari", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.ferrari", "a2.nic.ferrari", "b0.nic.ferrari", "c0.nic.ferrari"}, n, n, n, "whois.nic.ferrari", e, f},
	{"ferrero", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.ferrero", "ns2.dns.nic.ferrero", "ns3.dns.nic.ferrero", "ns4.dns.nic.ferrero", "ns5.dns.nic.ferrero", "ns6.dns.nic.ferrero"}, n, n, n, "whois.nic.ferrero", e, t},
	{"fi", r, x, 0xa0, e, w{"a.fi", "b.fi", "c.fi", "d.fi", "e.fi", "f.fi", "g.fi", "h.fi", "i.fi"}, n, n, n, "whois.fi", e, t},
	{"fiat", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.fiat", "a2.nic.fiat", "b0.nic.fiat", "c0.nic.fiat"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"fidelity", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.fidelity", e, f},
	{"fido", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.fido", "a2.nic.fido", "b0.nic.fido", "c0.nic.fido"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"film", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.film", "b.nic.film", "c.nic.film", "d.nic.film"}, n, n, n, "whois.nic.film", e, t},
	{"final", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, "whois.gtlds.nic.br", e, t},
	{"finance", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.finance", e, t},
	{"financial", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.financial", e, t},
	{"financialaid", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"finish", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"fire", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.fire", "dns2.nic.fire", "dns3.nic.fire", "dns4.nic.fire", "dnsa.nic.fire", "dnsb.nic.fire", "dnsc.nic.fire", "dnsd.nic.fire"}, n, n, n, "whois.nic.fire", e, t},
	{"firestone", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.firestone", e, t},
	{"firmdale", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.nic.firmdale", "ns2.nic.firmdale"}, n, n, n, "whois.nic.firmdale", e, f},
	{"fish", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.fish", e, t},
	{"fishing", r, x, 0x40, "http://nic.fishing/", w{"dns1.nic.fishing", "dns2.nic.fishing", "dns3.nic.fishing", "dns4.nic.fishing", "dnsa.nic.fishing", "dnsb.nic.fishing", "dnsc.nic.fishing", "dnsd.nic.fishing"}, n, n, n, "whois.nic.fishing", e, t},
	{"fit", r, x, 0x40, "http://nic.fit/", w{"dns1.nic.fit", "dns2.nic.fit", "dns3.nic.fit", "dns4.nic.fit", "dnsa.nic.fit", "dnsb.nic.fit", "dnsc.nic.fit", "dnsd.nic.fit"}, n, n, n, "whois.nic.fit", e, t},
	{"fitness", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.fitness", e, t},
	{"fj", r, z[2427:2438], 0xa0, "http://domains.fj/", w{"ns1.fj", "ns2.fj", "ns3.fj", "ns4.fj", "ns5.fj"}, n, n, n, "whois.usp.ac.fj", e, f},
	{"fk", r, z[2438:2444], 0xa8, e, w{"ns1.horizon.net.fk", "ns2.horizon.net.fk", "ns3.horizon.net.fk"}, n, n, n, e, "http://whois.marcaria.com/", f},
	{"flickr", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.flickr", "ns2.dns.nic.flickr", "ns3.dns.nic.flickr", "ns4.dns.nic.flickr", "ns5.dns.nic.flickr", "ns6.dns.nic.flickr"}, n, n, n, "whois.nic.flickr", e, t},
	{"flights", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.flights", e, t},
	{"flir", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.flir", "ns2.dns.nic.flir", "ns3.dns.nic.flir", "ns4.dns.nic.flir", "ns5.dns.nic.flir", "ns6.dns.nic.flir"}, n, n, n, "whois.nic.flir", e, f},
	{"florist", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.florist", e, t},
	{"flowers", r, x, 0x40, "https://nic.flowers/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"fls", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"flsmidth", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, "whois.ksregistry.net", e, f},
	{"fly", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"fm", r, z[2444:2450], 0xe0, "https://dot.fm/", w{"a.nic.fm", "b.nic.fm", "c.nic.fm", "d.nic.fm", "e.nic.fm", "f.nic.fm"}, n, n, n, "whois.nic.fm", e, t},
	{"fo", r, z[2450:2472], 0xa0, e, w{"a.nic.fo", "b.nic.fo", "c.nic.fo", "d.nic.fo"}, n, n, n, "whois.nic.fo", e, f},
	{"foo", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"food", r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.food", e, f},
	{"foodnetwork", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.foodnetwork", e, f},
	{"football", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.football", e, t},
	{"ford", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.ford", "ns2.dns.nic.ford", "ns3.dns.nic.ford", "ns4.dns.nic.ford", "ns5.dns.nic.ford", "ns6.dns.nic.ford"}, n, n, n, "whois.nic.ford", e, t},
	{"forex", r, x, 0x40, "https://bostonivy.co/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.forex", e, f},
	{"forsale", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.forsale", e, t},
	{"forum", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.forum", "b.nic.forum", "c.nic.forum", "d.nic.forum"}, n, n, n, "whois.nic.forum", e, t},
	{"foundation", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.foundation", e, t},
	{"fox", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.fox", "ns2.dns.nic.fox", "ns3.dns.nic.fox", "ns4.dns.nic.fox", "ns5.dns.nic.fox", "ns6.dns.nic.fox"}, n, n, n, "whois.nic.fox", e, t},
	{"fr", r, z[2472:2490], 0xa0, e, w{"d.nic.fr", "e.ext.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, n, n, "whois.nic.fr", e, t},
	{"free", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.free", "dns2.nic.free", "dns3.nic.free", "dns4.nic.free", "dnsa.nic.free", "dnsb.nic.free", "dnsc.nic.free", "dnsd.nic.free"}, n, n, n, "whois.nic.free", e, t},
	{"fresenius", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.fresenius", "b.nic.fresenius", "c.nic.fresenius", "d.nic.fresenius"}, n, n, n, "whois.nic.fresenius", e, f},
	{"frl", r, x, 0x440, "https://newgtlds.icann.org/", w{"a.nic.frl", "b.nic.frl", "c.nic.frl", "d.nic.frl"}, n, w{"NL-FY"}, n, "whois.nic.frl", e, t},
	{"frogans", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.frogans", "a2.nic.frogans", "b0.nic.frogans", "c0.nic.frogans"}, n, n, n, "whois.nic.frogans", e, t},
	{"frontdoor", r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.frontdoor", e, f},
	{"frontier", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.frontier", "ns2.dns.nic.frontier", "ns3.dns.nic.frontier", "ns4.dns.nic.frontier", "ns5.dns.nic.frontier", "ns6.dns.nic.frontier"}, n, n, n, "whois.nic.frontier", e, f},
	{"ftr", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.ftr", "ns2.dns.nic.ftr", "ns3.dns.nic.ftr", "ns4.dns.nic.ftr", "ns5.dns.nic.ftr", "ns6.dns.nic.ftr"}, n, n, n, "whois.nic.ftr", e, f},
	{"fujitsu", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.gmo", e, t},
	{"fujixerox", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.fujixerox", e, t},
	{"fun", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.fun", "b.nic.fun", "e.nic.fun", "f.nic.fun"}, n, n, n, "whois.nic.fun", e, t},
	{"fund", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.fund", e, t},
	{"furniture", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.furniture", e, t},
	{"futbol", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.futbol", e, t},
	{"fyi", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.fyi", e, t},
	{"ga", r, z[2490:2503], 0xa0, e, w{"a.ns.ga", "b.ns.ga", "c.ns.ga", "d.ns.ga"}, n, n, n, "whois.dot.ga", e, t},
	{"gal", r, x, 0x4c0, e, w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, w{"ES-GA"}, n, "whois.nic.gal", e, t},
	{"gallery", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.gallery", e, t},
	{"gallo", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.gallo", e, f},
	{"gallup", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.gallup", "a2.nic.gallup", "b0.nic.gallup", "c0.nic.gallup"}, n, n, n, "whois.nic.gallup", e, f},
	{"game", r, x, 0x40, "https://nic.game/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"games", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.games", e, t},
	{"gap", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.gap", "ns2.dns.nic.gap", "ns3.dns.nic.gap", "ns4.dns.nic.gap", "ns5.dns.nic.gap", "ns6.dns.nic.gap"}, n, n, n, "whois.nic.gap", e, t},
	{"garden", r, x, 0x40, "http://nic.garden/", w{"dns1.nic.garden", "dns2.nic.garden", "dns3.nic.garden", "dns4.nic.garden", "dnsa.nic.garden", "dnsb.nic.garden", "dnsc.nic.garden", "dnsd.nic.garden"}, n, n, n, "whois.nic.garden", e, t},
	{"garnier", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"gay", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.gay", "b.nic.gay", "c.nic.gay", "d.nic.gay"}, n, n, n, "whois.nic.gay", e, f},
	{"gb", r, z[2503:2504], 0xa8, e, w{"ns.uu.net", "ns0.ja.net", "ns4.ja.net"}, n, n, n, e, e, f},
	{"gbiz", r, x, 0x42, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"gcc", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"gd", r, z[2504:2511], 0xa0, e, w{"a.nic.gd", "b.nic.gd", "c.nic.gd", "d.nic.gd"}, n, n, n, "whois.nic.gd", e, f},
	{"gdn", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.nic.gdn", "ns3.nic.gdn", "ns4.nic.gdn"}, n, n, n, "whois.nic.gdn", e, f},
	{"ge", r, z[2511:2519], 0xa0, "https://nic.ge/", w{"ge.hostmaster.ua", "ns.nic.ge", "ns.uu.net", "ns2.nic.fr", "ns2.nic.ge"}, n, n, n, "whois.nic.ge", e, f},
	{"gea", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.dns.nic.gea", "m.dns.nic.gea", "n.dns.nic.gea"}, n, n, n, "whois.nic.gea", e, t},
	{"gecompany", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"ged", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"gent", r, x, 0xc4, e, w{"a.nic.gent", "b.nic.gent", "c.nic.gent", "d.nic.gent"}, n, w{"Gent", "Ghent"}, n, "whois.nic.gent", e, t},
	{"genting", r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.genting", e, t},
	{"george", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.george", e, f},
	{"gf", r, x, 0xa0, "https://www.dom-enic.com/", w{"ns1-gp.mediaserv.net", "ns1-mq.mediaserv.net"}, n, n, n, "whois.mediaserv.net", e, f},
	{"gg", r, z[2519:2530], 0xa0, e, w{"c.ci-servers.org", "dns1.nominetdns.uk", "dns2.nominetdns.uk", "dns3.nominetdns.uk", "dns4.nominetdns.uk", "e.ci-servers.net"}, n, n, n, "whois.gg", e, f},
	{"ggee", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.ggee", e, t},
	{"gh", r, z[2530:2536], 0xa8, e, w{"ns.dns.br", "ns1.nic.gh", "ns2.nic.gh"}, n, n, n, e, "http://www.nic.gh/customer/search_c.htm", f},
	{"gi", r, z[2536:2542], 0xa0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, "whois2.afilias-grs.net", e, f},
	{"gift", r, x, 0x40, "https://nic.gift/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"gifts", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.gifts", e, t},
	{"gives", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.gives", e, t},
	{"giving", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.giving", "b.nic.giving", "c.nic.giving", "d.nic.giving"}, n, n, n, "whois.nic.giving", e, f},
	{"gl", r, z[2542:2547], 0xa0, e, w{"a.nuuk.nic.gl", "d.nic.gl", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, "whois.nic.gl", e, t},
	{"glade", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.glade", e, f},
	{"glass", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.glass", e, t},
	{"gle", r, x, 0x42, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"global", r, x, 0x40, e, w{"a0.nic.global", "a2.nic.global", "b0.nic.global", "c0.nic.global"}, n, n, n, "whois.nic.global", e, t},
	{"globalx", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"globo", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, "whois.gtlds.nic.br", e, t},
	{"gm", r, x, 0xa0, e, w{"ns-gm.afrinic.net", "ns1.nic.gm", "ns2.nic.gm"}, n, n, n, e, "http://www.nic.gm/htmlpages/whois.htm", f},
	{"gmail", r, x, 0x42, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"gmbh", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.gmbh", e, t},
	{"gmc", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"gmo", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.gmo", e, t},
	{"gmx", r, x, 0x42, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.gmx", e, t},
	{"gn", r, z[2547:2553], 0xa8, e, w{"fork.sth.dnsnode.net", "ns-gn.afrinic.net", "rip.psg.com"}, n, n, n, e, e, f},
	{"godaddy", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.godaddy", "a2.nic.godaddy", "b0.nic.godaddy", "c0.nic.godaddy"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"gold", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.gold", e, t},
	{"goldpoint", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.goldpoint", e, t},
	{"golf", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.golf", e, t},
	{"goo", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.gmo", e, t},
	{"goodhands", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.afilias-srs.net", e, f},
	{"goodyear", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.goodyear", "a2.nic.goodyear", "b0.nic.goodyear", "c0.nic.goodyear"}, n, n, n, "whois.nic.goodyear", e, f},
	{"goog", r, x, 0x42, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"google", r, x, 0x42, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"gop", r, x, 0x40, "https://www.join.gop/", w{"dns1.nic.gop", "dns2.nic.gop", "dns3.nic.gop", "dns4.nic.gop", "dnsa.nic.gop", "dnsb.nic.gop", "dnsc.nic.gop", "dnsd.nic.gop"}, n, n, n, "whois.nic.gop", e, f},
	{"got", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.got", "dns2.nic.got", "dns3.nic.got", "dns4.nic.got", "dnsa.nic.got", "dnsb.nic.got", "dnsc.nic.got", "dnsd.nic.got"}, n, n, n, "whois.nic.got", e, t},
	{"gotv", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"gov", r, x, 0x1040, e, w{"a.gov-servers.net", "b.gov-servers.net", "c.gov-servers.net", "d.gov-servers.net"}, n, n, n, "whois.dotgov.gov", e, f},
	{"gp", r, z[2553:2564], 0xa0, "https://www.nic.gp/", w{"a.lactld.org", "gp.cctld.authdns.ripe.net", "ns-gp.nic.fr", "ns1.nic.gp", "ns2.nic.gp"}, n, n, n, "whois.nic.gp", e, f},
	{"gq", r, x, 0xa0, e, w{"a.ns.gq", "b.ns.gq", "c.ns.gq", "d.ns.gq"}, n, n, n, "whois.dominio.gq", e, t},
	{"gr", r, z[2564:2569], 0xa0, e, w{"estia.ics.forth.gr", "gr-at.ics.forth.gr", "gr-c.ics.forth.gr", "gr-d.ics.forth.gr", "gr-m.ics.forth.gr", "grdns.ics.forth.gr"}, n, n, n, e, "https://grweb.ics.forth.gr/Whois?lang=en", t},
	{"grainger", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.grainger", "ns2.dns.nic.grainger", "ns3.dns.nic.grainger", "ns4.dns.nic.grainger", "ns5.dns.nic.grainger", "ns6.dns.nic.grainger"}, n, n, n, "whois.nic.grainger", e, t},
	{"graphics", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.graphics", e, t},
	{"gratis", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.gratis", e, t},
	{"gree", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"green", r, x, 0x40, "https://get.green/", w{"a0.nic.green", "a2.nic.green", "b0.nic.green", "c0.nic.green"}, n, n, n, "whois.afilias.net", e, t},
	{"gripe", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.gripe", e, t},
	{"grocery", r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, f},
	{"group", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.group", e, t},
	{"gs", r, x, 0xa0, e, w{"ns.anycast.nic.gs", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, "whois.nic.gs", e, f},
	{"gt", r, z[2569:2576], 0xa0, e, w{"a.lactld.org", "gt.anycastdns.cz", "ns-cz.gt", "ns.dns.br", "pch.gt", "ssdns-tld.nic.cl"}, n, n, n, e, "http://www.gt/", f},
	{"gu", r, z[2576:2583], 0xa0, "http://gadao.gov.gu/", w{"gold.uog.edu", "green.uog.edu", "gu.cctld.authdns.ripe.net", "phloem.uoregon.edu"}, n, n, n, e, "http://gadao.gov.gu/domainsearch.htm", f},
	{"guardian", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, f},
	{"guardianlife", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"guardianmedia", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"gucci", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.gucci", "dns2.nic.gucci", "dns3.nic.gucci", "dns4.nic.gucci", "dnsa.nic.gucci", "dnsb.nic.gucci", "dnsc.nic.gucci", "dnsd.nic.gucci"}, n, n, n, "whois.nic.gucci", e, t},
	{"guge", r, x, 0x42, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"guide", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.guide", e, t},
	{"guitars", r, x, 0x40, "https://nic.guitars/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"guru", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.guru", e, t},
	{"gw", r, x, 0xa0, e, w{"gw01.dns.pt", "gw03.dns.pt", "h.dns.pt"}, n, n, n, e, "http://nic.gw/en/whois/", f},
	{"gy", r, z[2583:2587], 0xa0, e, w{"a.lactld.org", "gy-ns.anycast.pch.net"}, n, n, n, "whois.registry.gy", e, f},
	{"hair", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.hair", "b.nic.hair", "c.nic.hair", "d.nic.hair"}, n, n, n, "whois.nic.hair", e, t},
	{"halal", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"hamburg", r, x, 0xc4, e, w{"a.dns.nic.hamburg", "m.dns.nic.hamburg", "n.dns.nic.hamburg"}, n, w{"Hamburg", "DE-HH"}, n, "whois.nic.hamburg", e, t},
	{"hangout", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"haus", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.haus", e, t},
	{"hbo", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.hbo", "ns2.dns.nic.hbo", "ns3.dns.nic.hbo", "ns4.dns.nic.hbo", "ns5.dns.nic.hbo", "ns6.dns.nic.hbo"}, n, n, n, "whois.nic.hbo", e, t},
	{"hdfc", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.hdfc", "a2.nic.hdfc", "b0.nic.hdfc", "c0.nic.hdfc"}, n, n, n, "whois.nic.hdfc", e, f},
	{"hdfcbank", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.hdfcbank", "a2.nic.hdfcbank", "b0.nic.hdfcbank", "c0.nic.hdfcbank"}, n, n, n, "whois.nic.hdfcbank", e, f},
	{"health", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.health", "ns2.dns.nic.health", "ns3.dns.nic.health", "ns4.dns.nic.health", "ns5.dns.nic.health", "ns6.dns.nic.health"}, n, n, n, "whois.nic.health", e, t},
	{"healthcare", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.healthcare", e, t},
	{"heart", r, x, 0x2040, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"heinz", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"help", r, x, 0x40, "https://nic.help/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"helsinki", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.helsinki", "a2.nic.helsinki", "b0.nic.helsinki", "c0.nic.helsinki"}, n, n, n, "whois.nic.helsinki", e, t},
	{"here", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"hermes", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.hermes", "a2.nic.hermes", "b0.nic.hermes", "c0.nic.hermes"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"hgtv", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.hgtv", e, f},
	{"hilton", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"hiphop", r, x, 0x40, "https://nic.hiphop/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"hisamitsu", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.gmo", e, t},
	{"hitachi", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.gmo", e, t},
	{"hiv", r, x, 0x40, "https://nic.hiv/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"hk", r, z[2587:2596], 0xa0, e, w{"c.hkirc.net.hk", "d.hkirc.net.hk", "t.hkirc.net.hk", "u.hkirc.net.hk", "v.hkirc.net.hk", "x.hkirc.net.hk", "y.hkirc.net.hk", "z.hkirc.net.hk"}, n, n, n, "whois.hkirc.hk", e, t},
	{"hkt", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.hkt", "a2.nic.hkt", "b0.nic.hkt", "c0.nic.hkt"}, n, n, n, "whois.nic.hkt", e, t},
	{"hm", r, x, 0xa0, "http://www.registry.hm/", w{"ns1.registry.hm", "ns2.registry.hm", "ns3.registry.hm"}, n, n, n, "whois.registry.hm", e, f},
	{"hn", r, z[2596:2602], 0xa0, e, w{"a.lactld.org", "nicmx-anycast.rds.org.hn", "pch-anycast.rds.org.hn"}, n, n, n, "whois.nic.hn", e, f},
	{"hockey", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.hockey", e, t},
	{"holdings", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.holdings", e, t},
	{"holiday", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.holiday", e, t},
	{"home", r, x, 0x2140, "https://features.icann.org/addressing-new-gtld-program-applications-corp-home-and-mail", n, n, n, n, e, e, t},
	{"homedepot", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.homedepot", "a2.nic.homedepot", "b0.nic.homedepot", "c0.nic.homedepot"}, n, n, n, "whois.nic.homedepot", e, f},
	{"homegoods", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.homegoods", "ns2.dns.nic.homegoods", "ns3.dns.nic.homegoods", "ns4.dns.nic.homegoods", "ns5.dns.nic.homegoods", "ns6.dns.nic.homegoods"}, n, n, n, "whois.nic.homegoods", e, f},
	{"homes", r, x, 0x40, "https://nic.homes/", w{"a.nic.homes", "b.nic.homes", "c.nic.homes", "d.nic.homes"}, n, n, n, "whois.nic.homes", e, f},
	{"homesense", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.homesense", "ns2.dns.nic.homesense", "ns3.dns.nic.homesense", "ns4.dns.nic.homesense", "ns5.dns.nic.homesense", "ns6.dns.nic.homesense"}, n, n, n, "whois.nic.homesense", e, f},
	{"honda", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.honda", e, t},
	{"honeywell", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.honeywell", e, f},
	{"horse", r, x, 0x40, "http://nic.horse/", w{"dns1.nic.horse", "dns2.nic.horse", "dns3.nic.horse", "dns4.nic.horse", "dnsa.nic.horse", "dnsb.nic.horse", "dnsc.nic.horse", "dnsd.nic.horse"}, n, n, n, "whois.nic.horse", e, t},
	{"hospital", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.hospital", e, t},
	{"host", r, x, 0x40, e, w{"a.nic.host", "b.nic.host", "e.nic.host", "f.nic.host"}, n, n, n, "whois.nic.host", e, t},
	{"hosting", r, x, 0x40, "https://nic.hosting/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"hot", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.hot", "dns2.nic.hot", "dns3.nic.hot", "dns4.nic.hot", "dnsa.nic.hot", "dnsb.nic.hot", "dnsc.nic.hot", "dnsd.nic.hot"}, n, n, n, "whois.nic.hot", e, t},
	{"hoteis", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"hotel", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"hoteles", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.hoteles", "ns2.dns.nic.hoteles", "ns3.dns.nic.hoteles", "ns4.dns.nic.hoteles", "ns5.dns.nic.hoteles", "ns6.dns.nic.hoteles"}, n, n, n, "whois.nic.hoteles", e, t},
	{"hotels", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.hotels", "ns2.dns.nic.hotels", "ns3.dns.nic.hotels", "ns4.dns.nic.hotels", "ns5.dns.nic.hotels", "ns6.dns.nic.hotels"}, n, n, n, "whois.nic.hotels", e, t},
	{"hotmail", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, t},
	{"house", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.house", e, t},
	{"how", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"hr", r, z[2602:2606], 0xa0, e, w{"hr-ns-1.carnet.hr", "n.dns.hr", "pch.carnet.hr"}, n, n, n, "whois.dns.hr", e, f},
	{"hsbc", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.hsbc", "ns2.dns.nic.hsbc", "ns3.dns.nic.hsbc", "ns4.dns.nic.hsbc", "ns5.dns.nic.hsbc", "ns6.dns.nic.hsbc"}, n, n, n, "whois.nic.hsbc", e, t},
	{"ht", r, z[2606:2623], 0xa0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, "whois.nic.ht", e, f},
	{"htc", r, x, 0x2842, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"hu", r, z[2623:2657], 0xa0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "e.hu", "ns-com.nic.hu", "ns2.nic.fr"}, n, n, n, "whois.nic.hu", e, t},
	{"hughes", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.hughes", "a2.nic.hughes", "b0.nic.hughes", "c0.nic.hughes"}, n, n, n, "whois.nic.hughes", e, f},
	{"hyatt", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.hyatt", "ns2.dns.nic.hyatt", "ns3.dns.nic.hyatt", "ns4.dns.nic.hyatt", "ns5.dns.nic.hyatt", "ns6.dns.nic.hyatt"}, n, n, n, "whois.nic.hyatt", e, t},
	{"hyundai", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.hyundai", e, t},
	{"ibm", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.ibm", "b.nic.ibm", "c.nic.ibm", "d.nic.ibm"}, n, n, n, "whois.nic.ibm", e, f},
	{"icbc", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.icbc", "a2.nic.icbc", "b0.nic.icbc", "c0.nic.icbc"}, n, n, n, "whois.nic.icbc", e, f},
	{"ice", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.ice", e, f},
	{"icu", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.icu", "b.nic.icu", "c.nic.icu", "d.nic.icu"}, n, n, n, "whois.nic.icu", e, t},
	{"id", r, z[2657:2669], 0xa0, "https://pandi.id/", w{"b.dns.id", "c.dns.id", "d.dns.id", "e.dns.id", "ns4.apnic.net"}, n, n, n, "whois.id", e, t},
	{"idn", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"ie", r, z[2669:2674], 0xa0, "https://www.iedr.ie/", w{"b.ns.ie", "c.ns.ie", "d.ns.ie", "g.ns.ie", "h.ns.ie", "i.ns.ie"}, n, n, n, "whois.weare.ie", e, t},
	{"ieee", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.ieee", "ns2.dns.nic.ieee", "ns3.dns.nic.ieee", "ns4.dns.nic.ieee", "ns5.dns.nic.ieee", "ns6.dns.nic.ieee"}, n, n, n, "whois.nic.ieee", e, t},
	{"ifm", r, x, 0x42, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.ifm", e, t},
	{"iinet", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, "whois.aridnrs.net.au", e, f},
	{"ikano", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.dns.nic.ikano", "m.dns.nic.ikano", "n.dns.nic.ikano"}, n, n, n, "whois.nic.ikano", e, t},
	{"il", r, z[2674:2682], 0xa8, "https://www.isoc.org.il/domain-name-registry", w{"ilns.ilan.net.il", "lookup.iucc.ac.il", "ns1.ns.il", "ns3.ns.il", "ns4.ns.il", "nsa.ns.il", "nsb.ns.il", "nse.ns.il"}, n, n, n, "whois.isoc.org.il", e, t},
	{"im", r, z[2682:2688], 0xa0, e, w{"barney.advsys.co.uk", "hoppy.iom.com", "ns4.ja.net", "pebbles.iom.com"}, n, n, n, "whois.nic.im", e, f},
	{"imamat", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.imamat", "a2.nic.imamat", "b0.nic.imamat", "c0.nic.imamat"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"imdb", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.imdb", "dns2.nic.imdb", "dns3.nic.imdb", "dns4.nic.imdb", "dnsa.nic.imdb", "dnsb.nic.imdb", "dnsc.nic.imdb", "dnsd.nic.imdb"}, n, n, n, "whois.nic.imdb", e, t},
	{"immo", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.immo", e, t},
	{"immobilien", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.immobilien", e, t},
	{"in", r, z[2688:2700], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, n, "whois.registry.in", e, f},
	{"inc", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.nic.inc", e, t},
	{"indians", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"industries", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.industries", e, t},
	{"infiniti", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.gmo", e, t},
	{"info", r, z[2700:2701], 0x40, "https://info.info/", w{"a0.info.afilias-nst.info", "a2.info.afilias-nst.info", "b0.info.afilias-nst.org", "b2.info.afilias-nst.org", "c0.info.afilias-nst.info", "d0.info.afilias-nst.org"}, n, n, n, "whois.afilias.net", e, t},
	{"infosys", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"infy", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"ing", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"ink", r, x, 0x40, e, w{"a.nic.ink", "b.nic.ink", "c.nic.ink", "d.nic.ink"}, n, n, n, "whois.nic.ink", e, t},
	{"institute", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.institute", e, t},
	{"insurance", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.insurance", "b.nic.insurance", "c.nic.insurance", "d.nic.insurance", "e.nic.insurance", "f.nic.insurance"}, n, n, n, "whois.nic.insurance", e, f},
	{"insure", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.insure", e, t},
	{"int", r, z[2701:2702], 0x1040, e, w{"ns.uu.net", "ns0.ja.net", "sec2.authdns.ripe.net", "x.iana-servers.net", "y.iana-servers.net", "z.iana-servers.net"}, n, n, n, "whois.iana.org", e, f},
	{"intel", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.intel", e, f},
	{"international", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.international", e, t},
	{"intuit", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.intuit", "ns2.dns.nic.intuit", "ns3.dns.nic.intuit", "ns4.dns.nic.intuit", "ns5.dns.nic.intuit", "ns6.dns.nic.intuit"}, n, n, n, "whois.nic.intuit", e, t},
	{"investments", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.investments", e, t},
	{"io", r, z[2702:2704], 0xe0, "https://www.nic.io/", w{"a0.nic.io", "a2.nic.io", "b0.nic.io", "c0.nic.io"}, n, n, n, "whois.nic.io", e, t},
	{"ipiranga", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.ipiranga", "ns2.dns.nic.ipiranga", "ns3.dns.nic.ipiranga", "ns4.dns.nic.ipiranga", "ns5.dns.nic.ipiranga", "ns6.dns.nic.ipiranga"}, n, n, n, "whois.nic.ipiranga", e, t},
	{"iq", r, z[2704:2714], 0xa0, e, w{"iq.cctld.authdns.ripe.net", "ns.cocca.fr", "ns1.cmc.iq", "nsp-anycast.cmc.iq"}, n, n, n, "whois.cmc.iq", e, f},
	{"ir", r, z[2714:2721], 0xa0, e, w{"a.nic.ir", "b.nic.ir", "ir.cctld.authdns.ripe.net", "ns5.univie.ac.at"}, n, n, n, "whois.nic.ir", e, t},
	{"ira", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"irish", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.irish", e, t},
	{"is", r, x, 0xa0, e, w{"bes.isnic.is", "durinn.rhnet.is", "isgate.is", "sab.isnic.is", "sunic.sunet.se"}, n, n, n, "whois.isnic.is", e, t},
	{"iselect", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.iselect", e, f},
	{"islam", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"ismaili", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.ismaili", "a2.nic.ismaili", "b0.nic.ismaili", "c0.nic.ismaili"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"ist", r, x, 0xc4, "http://nic.ist/", w{"a0.nic.ist", "a2.nic.ist", "b0.nic.ist", "c0.nic.ist"}, n, w{"Istanbul", "TR-34"}, n, "whois.afilias-srs.net", e, t},
	{"istanbul", r, x, 0xc4, "https://nic.istanbul/", w{"a0.nic.istanbul", "a2.nic.istanbul", "b0.nic.istanbul", "c0.nic.istanbul"}, n, w{"Istanbul", "TR-34"}, n, "whois.afilias-srs.net", e, t},
	{"it", r, z[2721:3082], 0xa0, "https://www.nic.it/it", w{"a.dns.it", "dns.nic.it", "m.dns.it", "nameserver.cnr.it", "r.dns.it", "s.dns.it"}, n, n, n, "whois.nic.it", e, t},
	{"itau", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.itau", "ns2.dns.nic.itau", "ns3.dns.nic.itau", "ns4.dns.nic.itau", "ns5.dns.nic.itau", "ns6.dns.nic.itau"}, n, n, n, "whois.nic.itau", e, t},
	{"itv", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.itv", "a2.nic.itv", "b0.nic.itv", "c0.nic.itv"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"iveco", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.iveco", "a2.nic.iveco", "b0.nic.iveco", "c0.nic.iveco"}, n, n, n, "whois.nic.iveco", e, f},
	{"iwc", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.iwc", e, f},
	{"jaguar", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.jaguar", e, f},
	{"java", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.java", e, f},
	{"jcb", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.gmo", e, t},
	{"jcp", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.afilias-srs.net", e, f},
	{"je", r, z[3082:3088], 0xa0, e, w{"c.ci-servers.org", "dns1.nominetdns.uk", "dns2.nominetdns.uk", "dns3.nominetdns.uk", "dns4.nominetdns.uk", "e.ci-servers.net"}, n, n, n, "whois.je", e, f},
	{"jeep", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.jeep", "a2.nic.jeep", "b0.nic.jeep", "c0.nic.jeep"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"jetzt", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.jetzt", e, t},
	{"jewelry", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.jewelry", e, t},
	{"jio", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.jio", "a2.nic.jio", "b0.nic.jio", "c0.nic.jio"}, n, n, n, "whois.nic.jio", e, f},
	{"jlc", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.jlc", e, f},
	{"jll", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.jll", "a2.nic.jll", "b0.nic.jll", "c0.nic.jll"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"jm", r, z[3088:3094], 0xa8, e, w{"jm.cctld.authdns.ripe.net", "ns.jm", "ns.utechjamaica.edu.jm", "ns3-jm.fsl.org.jm", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"jmp", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.jmp", "ns2.dns.nic.jmp", "ns3.dns.nic.jmp", "ns4.dns.nic.jmp", "ns5.dns.nic.jmp", "ns6.dns.nic.jmp"}, n, n, n, "whois.nic.jmp", e, t},
	{"jnj", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.jnj", "ns2.dns.nic.jnj", "ns3.dns.nic.jnj", "ns4.dns.nic.jnj", "ns5.dns.nic.jnj", "ns6.dns.nic.jnj"}, n, n, n, "whois.nic.jnj", e, t},
	{"jo", r, z[3094:3102], 0xa0, e, w{"amra.nic.gov.jo", "jo.cctld.authdns.ripe.net", "jordan1st.nic.gov.jo", "petra.nic.gov.jo", "rip.psg.com"}, n, n, n, e, "http://www.dns.jo/Whois.aspx", f},
	{"jobs", r, x, 0x1040, e, w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.jobs", e, f},
	{"joburg", r, x, 0xc4, e, w{"coza1.dnsnode.net", "ns.coza.net.za", "ns2us.dns.business"}, n, w{"Johannesburg"}, n, "joburg-whois.registry.net.za", e, t},
	{"jot", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.jot", "dns2.nic.jot", "dns3.nic.jot", "dns4.nic.jot", "dnsa.nic.jot", "dnsb.nic.jot", "dnsc.nic.jot", "dnsd.nic.jot"}, n, n, n, "whois.nic.jot", e, t},
	{"joy", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.joy", "dns2.nic.joy", "dns3.nic.joy", "dns4.nic.joy", "dnsa.nic.joy", "dnsb.nic.joy", "dnsc.nic.joy", "dnsd.nic.joy"}, n, n, n, "whois.nic.joy", e, t},
	{"jp", r, z[3102:3205], 0xa0, e, w{"a.dns.jp", "b.dns.jp", "c.dns.jp", "d.dns.jp", "e.dns.jp", "f.dns.jp", "g.dns.jp", "h.dns.jp"}, n, n, n, "whois.jprs.jp", e, t},
	{"jpmorgan", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.jpmorgan", "ns2.dns.nic.jpmorgan", "ns3.dns.nic.jpmorgan", "ns4.dns.nic.jpmorgan", "ns5.dns.nic.jpmorgan", "ns6.dns.nic.jpmorgan"}, n, n, n, "whois.nic.jpmorgan", e, t},
	{"jpmorganchase", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"jprs", r, x, 0x42, "https://newgtlds.icann.org/", w{"tld1.nic.jprs", "tld2.nic.jprs", "tld3.nic.jprs", "tld4.nic.jprs", "tld5.nic.jprs"}, n, n, n, e, e, t},
	{"juegos", r, x, 0x40, "https://nic.juegos/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"juniper", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.juniper", e, f},
	{"justforu", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"kaufen", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.kaufen", e, t},
	{"kddi", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.kddi", e, t},
	{"ke", r, z[3205:3214], 0xa8, "https://kenic.or.ke/", w{"kenic.anycastdns.cz", "mzizi.kenic.or.ke", "ns-ke.afrinic.net", "ns.anycast.kenic.or.ke", "ns2ke.dns.business"}, n, n, n, "whois.kenic.or.ke", e, f},
	{"kerastase", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"kerryhotels", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.kerryhotels", e, f},
	{"kerrylogisitics", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"kerrylogistics", r, x, 0, e, w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.kerrylogistics", e, t},
	{"kerryproperties", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.kerryproperties", e, f},
	{"ketchup", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"kfh", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.kfh", "b.nic.kfh", "c.nic.kfh", "d.nic.kfh"}, n, n, n, "whois.nic.kfh", e, f},
	{"kg", r, z[3214:3220], 0xa0, e, w{"kg.cctld.authdns.ripe.net", "ns.kg"}, n, n, n, "whois.kg", e, f},
	{"kh", r, z[3220:3227], 0xa0, e, w{"dns1.online.com.kh", "ns.camnet.com.kh", "ns1.dns.net.kh", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"ki", r, z[3227:3239], 0xa0, e, w{"ns.cocca.fr", "pch.nic.ki"}, n, n, n, "whois.nic.ki", e, f},
	{"kia", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.kia", e, t},
	{"kid", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"kids", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"kiehls", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"kim", r, x, 0x40, "https://get.kim/", w{"a0.nic.kim", "a2.nic.kim", "b0.nic.kim", "c0.nic.kim"}, n, n, n, "whois.afilias.net", e, t},
	{"kinder", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.kinder", "ns2.dns.nic.kinder", "ns3.dns.nic.kinder", "ns4.dns.nic.kinder", "ns5.dns.nic.kinder", "ns6.dns.nic.kinder"}, n, n, n, "whois.nic.kinder", e, t},
	{"kindle", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.kindle", "dns2.nic.kindle", "dns3.nic.kindle", "dns4.nic.kindle", "dnsa.nic.kindle", "dnsb.nic.kindle", "dnsc.nic.kindle", "dnsd.nic.kindle"}, n, n, n, "whois.nic.kindle", e, t},
	{"kitchen", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.kitchen", e, t},
	{"kiwi", r, x, 0x40, e, w{"a.ns.nic.kiwi", "b.ns.nic.kiwi"}, n, n, n, "whois.nic.kiwi", e, t},
	{"km", r, z[3239:3253], 0xa0, e, w{"dns1.nic.km", "dns2.nic.km", "ns-km.afrinic.net"}, n, n, n, e, e, f},
	{"kn", r, z[3253:3259], 0xa0, "https://www.nic.kn/", w{"ns1.anycastdns.cz", "ns2.anycastdns.cz", "pch.nic.kn"}, n, n, n, "whois.nic.kn", e, f},
	{"koeln", r, x, 0xc4, e, w{"dns.ryce-rsp.com", "ns1.dns.business", "ns1.ryce-rsp.com"}, n, w{"Cologne", "Koeln"}, n, "whois.ryce-rsp.com", e, t},
	{"komatsu", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.komatsu", e, t},
	{"konami", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"kone", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"kosher", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.kosher", "a2.nic.kosher", "b0.nic.kosher", "c0.nic.kosher"}, n, n, n, "whois.nic.kosher", e, f},
	{"kp", r, z[3259:3263], 0xa0, e, w{"ns1.kptc.kp", "ns2.kptc.kp"}, n, n, n, e, e, f},
	{"kpmg", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.kpmg", "ns2.dns.nic.kpmg", "ns3.dns.nic.kpmg", "ns4.dns.nic.kpmg", "ns5.dns.nic.kpmg", "ns6.dns.nic.kpmg"}, n, n, n, "whois.nic.kpmg", e, t},
	{"kpn", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.kpn", "b.nic.kpn", "c.nic.kpn", "d.nic.kpn"}, n, n, n, e, e, f},
	{"kr", r, z[3263:3292], 0xa0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, "whois.kr", e, t},
	{"krd", r, x, 0x440, "https://newgtlds.icann.org/", w{"a.nic.krd", "b.nic.krd", "c.nic.krd", "d.nic.krd"}, n, n, n, "whois.nic.krd", e, f},
	{"kred", r, x, 0x50, "https://newgtlds.icann.org/", w{"a.nic.kred", "b.nic.kred", "c.nic.kred", "d.nic.kred"}, n, n, n, "whois.nic.kred", e, t},
	{"kuokgroup", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.kuokgroup", e, f},
	{"kw", r, z[3292:3297], 0xa0, e, w{"a.nic.kw", "b.nic.kw", "c.nic.kw", "d.nic.kw", "e.nic.kw", "pch.nic.kw"}, n, n, n, e, "http://www.kw/", f},
	{"ky", r, z[3297:3302], 0xa0, "https://kyregistry.ky/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.kyregistry.ky", e, f},
	{"kyknet", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"kyoto", r, x, 0xc4, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, w{"Kyoto", "JP-26"}, n, "whois.nic.kyoto", e, t},
	{"kz", r, z[3302:3308], 0xa0, e, w{"ns.nic.kz", "ns1.nic.kz"}, n, n, n, "whois.nic.kz", e, f},
	{"la", r, x, 0xa4, e, w{"ns1.nic.la", "ns2.nic.la", "ns3.nic.la", "ns4.nic.la"}, n, w{"Los Angeles"}, n, "whois.nic.la", e, t},
	{"lacaixa", r, x, 0x42, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.lacaixa", e, f},
	{"ladbrokes", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.ladbrokes", e, t},
	{"lamborghini", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.lamborghini", "a2.nic.lamborghini", "b0.nic.lamborghini", "c0.nic.lamborghini"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"lamer", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.lamer", "a2.nic.lamer", "b0.nic.lamer", "c0.nic.lamer"}, n, n, n, "whois.nic.lamer", e, f},
	{"lancaster", r, x, 0x42, "https://newgtlds.icann.org/", w{"d.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, n, n, "whois.nic.lancaster", e, t},
	{"lancia", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.lancia", "a2.nic.lancia", "b0.nic.lancia", "c0.nic.lancia"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"lancome", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.lancome", e, f},
	{"land", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.land", e, t},
	{"landrover", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.landrover", e, f},
	{"lanxess", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.lanxess", "ns2.dns.nic.lanxess", "ns3.dns.nic.lanxess", "ns4.dns.nic.lanxess", "ns5.dns.nic.lanxess", "ns6.dns.nic.lanxess"}, n, n, n, "whois.nic.lanxess", e, t},
	{"lasalle", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.lasalle", "a2.nic.lasalle", "b0.nic.lasalle", "c0.nic.lasalle"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"lat", r, x, 0x40, "https://www.nic.lat/en/", w{"c.mx-ns.mx", "e.mx-ns.mx", "i.mx-ns.mx", "m.mx-ns.mx", "o.mx-ns.mx", "x.mx-ns.mx"}, n, n, n, "whois.nic.lat", e, t},
	{"latino", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.latino", "a2.nic.latino", "b0.nic.latino", "c0.nic.latino"}, n, n, n, "whois.nic.latino", e, f},
	{"latrobe", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.latrobe", "b.nic.latrobe", "c.nic.latrobe", "d.nic.latrobe"}, n, n, n, "whois.nic.latrobe", e, f},
	{"law", r, x, 0x40, "https://nic.law/", w{"dns1.nic.law", "dns2.nic.law", "dns3.nic.law", "dns4.nic.law", "dnsa.nic.law", "dnsb.nic.law", "dnsc.nic.law", "dnsd.nic.law"}, n, n, n, "whois.nic.law", e, t},
	{"lawyer", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.lawyer", e, t},
	{"lb", r, z[3308:3313], 0xa8, e, w{"fork.sth.dnsnode.net", "rip.psg.com", "zeina.aub.edu.lb"}, n, n, n, e, "http://www.aub.edu.lb/lbdr/", f},
	{"lc", r, z[3313:3322], 0xa0, "http://www.nic.lc/", w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, "whois.afilias-grs.info", e, f},
	{"lds", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.lds", "a2.nic.lds", "b0.nic.lds", "c0.nic.lds"}, n, n, n, "whois.nic.lds", e, f},
	{"lease", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.lease", e, t},
	{"leclerc", r, x, 0x42, "https://newgtlds.icann.org/", w{"d.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, n, n, "whois-leclerc.nic.fr", e, t},
	{"lefrak", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.lefrak", e, f},
	{"legal", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.legal", e, t},
	{"lego", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.lego", e, t},
	{"lexus", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.lexus", e, t},
	{"lgbt", r, x, 0x40, "https://get.lgbt/", w{"a0.nic.lgbt", "a2.nic.lgbt", "b0.nic.lgbt", "c0.nic.lgbt"}, n, n, n, "whois.afilias.net", e, t},
	{"li", r, x, 0xa0, e, w{"a.nic.li", "b.nic.li", "c.nic.li", "e.nic.li", "f.nic.li", "g.nic.li"}, n, n, n, "whois.nic.li", e, t},
	{"liaison", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.liaison", e, f},
	{"lidl", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.lidl", "b.nic.lidl", "c.nic.lidl", "d.nic.lidl"}, n, n, n, "whois.nic.lidl", e, t},
	{"life", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.life", e, t},
	{"lifeinsurance", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.lifeinsurance", "ns2.dns.nic.lifeinsurance", "ns3.dns.nic.lifeinsurance", "ns4.dns.nic.lifeinsurance", "ns5.dns.nic.lifeinsurance", "ns6.dns.nic.lifeinsurance"}, n, n, n, "whois.nic.lifeinsurance", e, t},
	{"lifestyle", r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.lifestyle", e, f},
	{"lighting", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.lighting", e, t},
	{"like", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.like", "dns2.nic.like", "dns3.nic.like", "dns4.nic.like", "dnsa.nic.like", "dnsb.nic.like", "dnsc.nic.like", "dnsd.nic.like"}, n, n, n, "whois.nic.like", e, t},
	{"lilly", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.lilly", "ns2.dns.nic.lilly", "ns3.dns.nic.lilly", "ns4.dns.nic.lilly", "ns5.dns.nic.lilly", "ns6.dns.nic.lilly"}, n, n, n, "whois.nic.lilly", e, t},
	{"limited", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.limited", e, t},
	{"limo", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.limo", e, t},
	{"lincoln", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.lincoln", "ns2.dns.nic.lincoln", "ns3.dns.nic.lincoln", "ns4.dns.nic.lincoln", "ns5.dns.nic.lincoln", "ns6.dns.nic.lincoln"}, n, n, n, "whois.nic.lincoln", e, t},
	{"linde", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.linde", e, t},
	{"link", r, x, 0x40, "https://nic.link/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"lipsy", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.lipsy", e, f},
	{"live", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.live", e, t},
	{"livestrong", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"living", r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, f},
	{"lixil", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.lixil", e, t},
	{"lk", r, z[3322:3336], 0xa0, e, w{"c.nic.lk", "d.nic.lk", "l.nic.lk", "m.nic.lk", "ns1.ac.lk", "p.nic.lk", "pendragon.cs.purdue.edu", "t.nic.lk"}, n, n, n, "whois.nic.lk", e, f},
	{"llc", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.llc", "a2.nic.llc", "b0.nic.llc", "c0.nic.llc"}, n, n, n, "whois.afilias.net", e, f},
	{"llp", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"loan", r, x, 0x40, "https://www.famousfourmedia.com/", w{"ns1.dns.nic.loan", "ns2.dns.nic.loan", "ns3.dns.nic.loan", "ns4.dns.nic.loan", "ns5.dns.nic.loan", "ns6.dns.nic.loan"}, n, n, n, "whois.nic.loan", e, t},
	{"loans", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.loans", e, t},
	{"locker", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.locker", "a2.nic.locker", "b0.nic.locker", "c0.nic.locker"}, n, n, n, "whois.nic.locker", e, f},
	{"locus", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.locus", "dns2.nic.locus", "dns3.nic.locus", "dns4.nic.locus", "dnsa.nic.locus", "dnsb.nic.locus", "dnsc.nic.locus", "dnsd.nic.locus"}, n, n, n, "whois.nic.locus", e, f},
	{"loft", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.loft", "ns2.dns.nic.loft", "ns3.dns.nic.loft", "ns4.dns.nic.loft", "ns5.dns.nic.loft", "ns6.dns.nic.loft"}, n, n, n, "whois.nic.loft", e, f},
	{"lol", r, x, 0x40, "https://nic.lol/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"london", r, x, 0xc4, "http://nic.london/", w{"dns1.nic.london", "dns2.nic.london", "dns3.nic.london", "dns4.nic.london", "dnsa.nic.london", "dnsb.nic.london", "dnsc.nic.london", "dnsd.nic.london"}, n, w{"London", "GB-LND", "GB-BDG", "GB-BNE", "GB-BEX", "GB-BEN", "GB-BRY", "GB-CMD", "GB-CRY", "GB-EAL", "GB-ENF", "GB-GRE", "GB-HCK", "GB-HMF", "GB-HRY", "GB-HRW", "GB-HAV", "GB-HIL", "GB-HNS", "GB-ISL", "GB-KEC", "GB-KTT", "GB-LBH", "GB-LEW", "GB-MRT", "GB-NWM", "GB-RDB", "GB-RIC", "GB-SWK", "GB-STN", "GB-TWH", "GB-WFT", "GB-WND", "GB-WSM"}, n, "whois.nic.london", e, t},
	{"loreal", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"lotte", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.lotte", e, t},
	{"lotto", r, x, 0x40, "https://nic.lotto/", w{"a0.nic.lotto", "a2.nic.lotto", "b0.nic.lotto", "c0.nic.lotto"}, n, n, n, "whois.afilias.net", e, t},
	{"love", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.love", "b.nic.love", "c.nic.love", "d.nic.love"}, n, n, n, "whois.nic.love", e, t},
	{"lpl", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.lpl", "b.nic.lpl", "c.nic.lpl", "d.nic.lpl"}, n, n, n, "whois.nic.lpl", e, t},
	{"lplfinancial", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.lplfinancial", "b.nic.lplfinancial", "c.nic.lplfinancial", "d.nic.lplfinancial"}, n, n, n, "whois.nic.lplfinancial", e, t},
	{"lr", r, z[3336:3342], 0xa8, e, w{"fork.sth.dnsnode.net", "ns-lr.afrinic.net", "rip.psg.com"}, n, n, n, e, e, f},
	{"ls", r, z[3342:3348], 0xa0, "http://www.nic.ls/", w{"ls-ns.anycast.pch.net", "ns-ls.afrinic.net", "ns1.nic.ls", "ns2.nic.ls"}, n, n, n, "whois.nic.ls", e, f},
	{"lt", r, z[3348:3349], 0xa0, e, w{"a.tld.lt", "b.tld.lt", "c.tld.lt", "d.tld.lt", "e.tld.lt", "f.tld.lt"}, n, n, n, "whois.domreg.lt", e, t},
	{"ltd", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.ltd", e, t},
	{"ltda", r, x, 0x40, "https://nic.ltda/", w{"a0.nic.ltda", "a2.nic.ltda", "b0.nic.ltda", "c0.nic.ltda"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"lu", r, x, 0xa0, e, w{"g.dns.lu", "i.dns.lu", "j.dns.lu", "k.dns.lu", "ns1.dns.lu", "p.dns.lu"}, n, n, n, "whois.dns.lu", e, t},
	{"lundbeck", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.lundbeck", e, f},
	{"lupin", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"luxe", r, x, 0x40, "http://nix.luxe/", w{"dns1.nic.luxe", "dns2.nic.luxe", "dns3.nic.luxe", "dns4.nic.luxe", "dnsa.nic.luxe", "dnsb.nic.luxe", "dnsc.nic.luxe", "dnsd.nic.luxe"}, n, n, n, "whois.nic.luxe", e, t},
	{"luxury", r, x, 0x40, "https://nic.luxury/", w{"a.nic.luxury", "b.nic.luxury", "c.nic.luxury", "d.nic.luxury"}, n, n, n, "whois.nic.luxury", e, f},
	{"lv", r, z[3349:3358], 0xa0, e, w{"a.nic.lv", "b.nic.lv", "c.nic.lv", "d.nic.lv", "sunic.sunet.se"}, n, n, n, "whois.nic.lv", e, t},
	{"ly", r, z[3358:3367], 0xa0, "https://nic.ly/", w{"dns.lttnet.net", "dns1.lttnet.net", "ns-ly.afrinic.net", "pch.ltt.ly", "phloem.uoregon.edu"}, n, n, n, "whois.nic.ly", e, f},
	{"ma", r, z[3367:3373], 0xa0, e, w{"a.tld.ma", "b.tld.ma", "c.tld.ma", "d.tld.ma", "dns.inria.fr", "e.tld.ma", "f.tld.ma", "ns-ma.nic.fr"}, n, n, n, "whois.registre.ma", e, f},
	{"macys", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.macys", e, f},
	{"madrid", r, x, 0xc4, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, w{"Madrid", "ES-MD"}, n, "whois.nic.madrid", e, f},
	{"maif", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, t},
	{"mail", r, x, 0x2140, "https://features.icann.org/addressing-new-gtld-program-applications-corp-home-and-mail", n, n, n, n, e, e, t},
	{"maison", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.maison", e, t},
	{"makeup", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.makeup", "b.nic.makeup", "c.nic.makeup", "d.nic.makeup"}, n, n, n, "whois.nic.makeup", e, f},
	{"man", r, x, 0x42, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.man", e, t},
	{"management", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.management", e, t},
	{"mango", r, x, 0x42, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.mango", e, t},
	{"map", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"market", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.market", e, t},
	{"marketing", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.marketing", e, t},
	{"markets", r, x, 0x40, "https://bostonivy.co/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.markets", e, f},
	{"marriott", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.marriott", "a2.nic.marriott", "b0.nic.marriott", "c0.nic.marriott"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"marshalls", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.marshalls", "ns2.dns.nic.marshalls", "ns3.dns.nic.marshalls", "ns4.dns.nic.marshalls", "ns5.dns.nic.marshalls", "ns6.dns.nic.marshalls"}, n, n, n, "whois.nic.marshalls", e, f},
	{"maserati", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.maserati", "a2.nic.maserati", "b0.nic.maserati", "c0.nic.maserati"}, n, n, n, "whois.nic.maserati", e, f},
	{"matrix", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"mattel", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.mattel", "ns2.dns.nic.mattel", "ns3.dns.nic.mattel", "ns4.dns.nic.mattel", "ns5.dns.nic.mattel", "ns6.dns.nic.mattel"}, n, n, n, "whois.nic.mattel", e, t},
	{"maybelline", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"mba", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.mba", e, t},
	{"mc", r, z[3373:3375], 0xa0, "https://www.nic.mc/", w{"mc.cctld.authdns.ripe.net", "ns1.nic.mc", "ns2.nic.mc"}, n, n, n, e, e, f},
	{"mcd", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"mcdonalds", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"mckinsey", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.mckinsey", "a2.nic.mckinsey", "b0.nic.mckinsey", "c0.nic.mckinsey"}, n, n, n, "whois.nic.mckinsey", e, f},
	{"md", r, x, 0xa0, e, w{"nsa.tld.md", "nsb.tld.md", "nsc.dns.md", "nsf.dns.md", "nsr.dns.md"}, n, n, n, "whois.nic.md", e, f},
	{"me", r, z[3375:3383], 0xe0, "https://domain.me/", w{"a0.nic.me", "a2.nic.me", "b0.nic.me", "b2.nic.me", "c0.nic.me"}, n, n, n, "whois.nic.me", e, f},
	{"med", r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.med", e, f},
	{"media", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.media", e, t},
	{"medical", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"meet", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"melbourne", r, x, 0xc4, "https://www.live.melbourne/", w{"a.nic.melbourne", "b.nic.melbourne", "c.nic.melbourne", "d.nic.melbourne"}, n, w{"Melbourne"}, n, "whois.nic.melbourne", e, f},
	{"meme", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"memorial", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.memorial", e, t},
	{"men", r, x, 0x40, "https://www.famousfourmedia.com/", w{"a.nic.men", "b.nic.men", "c.nic.men", "d.nic.men"}, n, n, n, "whois.nic.men", e, t},
	{"menu", r, x, 0x40, e, w{"a.nic.menu", "b.nic.menu", "c.nic.menu", "d.nic.menu"}, n, n, n, "whois.nic.menu", e, f},
	{"meo", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"merck", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"merckmsd", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, f},
	{"metlife", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.metlife", e, f},
	{"mf", r, x, 0x8a0, "https://en.wikipedia.org/wiki/.mf", n, n, n, n, e, e, f},
	{"mg", r, z[3383:3394], 0xa0, e, w{"censvrns0001.ird.fr", "ns-mg.malagasy.com", "ns.dts.mg", "ns.nic.mg", "pch.nic.mg"}, n, n, n, "whois.nic.mg", e, f},
	{"mh", r, x, 0xa8, e, w{"ns.amarshallinc.com", "ns.ntamar.net"}, n, n, n, e, e, f},
	{"miami", r, x, 0xc4, "http://nic.miami/", w{"dns1.nic.miami", "dns2.nic.miami", "dns3.nic.miami", "dns4.nic.miami", "dnsa.nic.miami", "dnsb.nic.miami", "dnsc.nic.miami", "dnsd.nic.miami"}, n, w{"Miami"}, n, "whois.nic.miami", e, t},
	{"microsoft", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, t},
	{"mih", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"mii", r, x, 0x2040, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"mil", r, x, 0x1040, e, w{"con1.nipr.mil", "con2.nipr.mil", "eur1.nipr.mil", "eur2.nipr.mil", "pac1.nipr.mil", "pac2.nipr.mil"}, n, n, n, "is-1.nic.mil", e, f},
	{"mini", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.mini", "b.nic.mini", "c.nic.mini", "d.nic.mini"}, n, n, n, "whois.nic.mini", e, f},
	{"mint", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.mint", "ns2.dns.nic.mint", "ns3.dns.nic.mint", "ns4.dns.nic.mint", "ns5.dns.nic.mint", "ns6.dns.nic.mint"}, n, n, n, "whois.nic.mint", e, t},
	{"mit", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.mit", "a2.nic.mit", "b0.nic.mit", "c0.nic.mit"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"mitek", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"mitsubishi", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.gmo", e, t},
	{"mk", r, z[3394:3402], 0xa0, e, w{"d.ext.nic.cz", "dns-mk.univie.ac.at", "ns2.arnes.si", "tld1.marnet.mk"}, n, n, n, "whois.marnet.mk", e, f},
	{"ml", r, z[3402:3408], 0xa0, e, w{"a.ns.ml", "b.ns.ml", "c.ns.ml", "d.ns.ml"}, n, n, n, "whois.dot.ml", e, t},
	{"mlb", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.mlb", "ns2.dns.nic.mlb", "ns3.dns.nic.mlb", "ns4.dns.nic.mlb", "ns5.dns.nic.mlb", "ns6.dns.nic.mlb"}, n, n, n, "whois.nic.mlb", e, t},
	{"mls", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.ns.nic.mls", "b.ns.nic.mls"}, n, n, n, "whois.nic.mls", e, t},
	{"mm", r, z[3408:3416], 0xa8, e, w{"a.nic.net.mm", "b.nic.net.mm", "c.nic.net.mm", "d.nic.net.mm"}, n, n, n, "whois.registry.gov.mm", e, f},
	{"mma", r, x, 0x42, "https://newgtlds.icann.org/", w{"d.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, n, n, "whois.nic.mma", e, t},
	{"mn", r, z[3416:3419], 0xa0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org", "ns1.magic.mn", "ns2.magic.mn", "ns3.magic.mn", "ns4.magic.mn"}, n, n, n, "whois.nic.mn", e, f},
	{"mnet", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"mo", r, z[3419:3425], 0xa0, e, w{"a.monic.mo", "b.monic.mo", "c.monic.mo", "d.monic.mo", "e.monic.mo", "ns17.cdns.net", "ns2.cuhk.edu.hk"}, n, n, n, "whois.monic.mo", e, f},
	{"mobi", r, x, 0x1040, "https://dotmobi.mobi/", w{"a0.mobi.afilias-nst.info", "a2.mobi.afilias-nst.info", "b0.mobi.afilias-nst.org", "b2.mobi.afilias-nst.org", "c0.mobi.afilias-nst.info", "d0.mobi.afilias-nst.org"}, n, n, n, "whois.nic.mobi", e, t},
	{"mobile", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.mobile", "a2.nic.mobile", "b0.nic.mobile", "c0.nic.mobile"}, n, n, n, "whois.nic.mobile", e, f},
	{"mobily", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.mobily", e, f},
	{"moda", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.moda", e, t},
	{"moe", r, x, 0x40, e, w{"ns1.dns.nic.moe", "ns2.dns.nic.moe", "ns3.dns.nic.moe", "ns4.dns.nic.moe", "ns5.dns.nic.moe", "ns6.dns.nic.moe"}, n, n, n, "whois.nic.moe", e, t},
	{"moi", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.moi", "dns2.nic.moi", "dns3.nic.moi", "dns4.nic.moi", "dnsa.nic.moi", "dnsb.nic.moi", "dnsc.nic.moi", "dnsd.nic.moi"}, n, n, n, "whois.nic.moi", e, t},
	{"mom", r, x, 0x40, "https://nic.mom/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"monash", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.monash", "b.nic.monash", "c.nic.monash", "d.nic.monash"}, n, n, n, "whois.nic.monash", e, f},
	{"money", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.money", e, t},
	{"monster", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.monster", "b.nic.monster", "c.nic.monster", "d.nic.monster"}, n, n, n, "whois.nic.monster", e, f},
	{"montblanc", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"mopar", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.afilias-srs.net", e, f},
	{"mormon", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.mormon", "a2.nic.mormon", "b0.nic.mormon", "c0.nic.mormon"}, n, n, n, "whois.nic.mormon", e, f},
	{"mortgage", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.mortgage", e, t},
	{"moscow", r, x, 0xc4, "https://newgtlds.icann.org/", w{"a.dns.flexireg.ru", "b.dns.flexireg.net", "c.dns.flexireg.org", "d.dns.flexireg.domains"}, n, w{"Moscow", "RU-MOW"}, n, "whois.nic.moscow", e, f},
	{"moto", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.moto", "ns2.dns.nic.moto", "ns3.dns.nic.moto", "ns4.dns.nic.moto", "ns5.dns.nic.moto", "ns6.dns.nic.moto"}, n, n, n, "whois.nic.moto", e, t},
	{"motorcycles", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.motorcycles", "b.nic.motorcycles", "c.nic.motorcycles", "d.nic.motorcycles"}, n, n, n, "whois.nic.motorcycles", e, f},
	{"mov", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"movie", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.movie", e, t},
	{"movistar", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois-fe.movistar.tango.knipp.de", e, f},
	{"mozaic", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"mp", r, z[3425:3429], 0xa0, "https://get.mp/", w{"ns1.nic.mp", "ns2.nic.mp", "ns3.nic.mp", "ns4.nic.mp"}, n, n, n, "whois.nic.mp", e, f},
	{"mq", r, x, 0xa0, "https://www.dom-enic.com/", w{"ns1-gp.mediaserv.net", "ns1-mq.mediaserv.net"}, n, n, n, "whois.mediaserv.net", e, f},
	{"mr", r, z[3429:3433], 0xa0, e, w{"ns-mr.afrinic.net", "ns-mr.nic.fr", "ns-mr.nic.tn", "ns1.nic.mr", "ns2.nic.mr", "ns3.nic.mr"}, n, n, n, "whois.nic.mr", e, f},
	{"mrmuscle", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"mrporter", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"ms", r, z[3433:3437], 0xe0, e, w{"ms-ns.anycast.pch.net", "ns.cocca.fr"}, n, n, n, "whois.nic.ms", e, f},
	{"msd", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, f},
	{"mt", r, z[3437:3442], 0xa0, e, w{"a.ns.mt", "b.ns.mt", "f.ns.mt", "p.ns.mt"}, n, n, n, e, "https://www.nic.org.mt/dotmt/", f},
	{"mtn", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.mtn", "dns2.nic.mtn", "dns3.nic.mtn", "dns4.nic.mtn", "dnsa.nic.mtn", "dnsb.nic.mtn", "dnsc.nic.mtn", "dnsd.nic.mtn"}, n, n, n, "whois.nic.mtn", e, f},
	{"mtpc", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.mtpc", e, f},
	{"mtr", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.nic.mtr", "ns2.nic.mtr", "ns3.nic.mtr", "ns4.nic.mtr"}, n, n, n, "whois.nic.mtr", e, f},
	{"mu", r, z[3442:3451], 0xa0, e, w{"anycast1.irondns.net", "fork.sth.dnsnode.net", "udns1.tld.mu", "udns2.tld.mu"}, n, n, n, "whois.nic.mu", e, f},
	{"multichoice", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"museum", r, x, 0x1040, "https://welcome.museum/", w{"d.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, n, n, "whois.nic.museum", e, t},
	{"music", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"mutual", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.mutual", "ns2.dns.nic.mutual", "ns3.dns.nic.mutual", "ns4.dns.nic.mutual", "ns5.dns.nic.mutual", "ns6.dns.nic.mutual"}, n, n, n, "whois.nic.mutual", e, t},
	{"mutualfunds", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"mutuelle", r, x, 0x840, "https://newgtlds.icann.org/", n, n, n, n, "whois-mutuelle.nic.fr", e, f},
	{"mv", r, z[3451:3465], 0xa0, e, w{"mv-ns.anycast.pch.net", "ns.dhivehinet.net.mv", "ns2.dhivehinet.net.mv"}, n, n, n, e, e, f},
	{"mw", r, z[3465:3475], 0xa0, "http://nic.mw/", w{"chambo.sdnp.org.mw", "d.ext.nic.cz", "domwe.sdn.mw", "mw.cctld.authdns.ripe.net", "ns4.apnic.net", "pch1.nic.mw", "rip.psg.com"}, n, n, n, "whois.nic.mw", e, f},
	{"mx", r, z[3475:3480], 0xa0, e, w{"c.mx-ns.mx", "e.mx-ns.mx", "i.mx-ns.mx", "m.mx-ns.mx", "o.mx-ns.mx", "x.mx-ns.mx"}, n, n, n, "whois.mx", e, f},
	{"my", r, z[3480:3488], 0xa0, "https://mynic.my/", w{"a.mynic.centralnic-dns.com", "a.nic.my", "a1.nic.my", "b.mynic.centralnic-dns.com", "c.mynic.centralnic-dns.com", "d.mynic.centralnic-dns.com"}, n, n, n, "whois.mynic.my", e, t},
	{"mz", r, z[3488:3495], 0xa8, "https://www.domains.co.mz/", w{"anyns.uem.mz", "dzowo.uem.mz", "ns-mz.afrinic.net", "oceano.uem.mz", "phloem.uoregon.edu", "zebra.uem.mz"}, n, n, n, "whois.nic.mz", e, f},
	{"mzansimagic", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"na", r, z[3495:3513], 0xa0, e, w{"anyc2.irondns.net", "etld-1.anycast.net", "na-ns.anycast.pch.net", "na.anycastdns.cz"}, n, n, n, "whois.na-nic.com.na", e, f},
	{"nab", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.nab", e, f},
	{"nadex", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.nadex", e, f},
	{"nagoya", r, x, 0xc4, e, w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, w{"Nagoya-shi"}, n, "whois.nic.nagoya", e, t},
	{"name", r, z[3513:3516], 0x40, e, w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.name", e, t},
	{"naspers", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"nationwide", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.nationwide", e, f},
	{"natura", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, "whois.gtlds.nic.br", e, t},
	{"navy", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.navy", e, t},
	{"nba", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.nba", "ns2.dns.nic.nba", "ns3.dns.nic.nba", "ns4.dns.nic.nba", "ns5.dns.nic.nba", "ns6.dns.nic.nba"}, n, n, n, "whois.nic.nba", e, t},
	{"nc", r, z[3516:3519], 0xa0, e, w{"any-ns1.nc", "nc.cctld.authdns.ripe.net", "ns1.nc", "ns2.nc"}, n, n, n, "whois.nc", e, f},
	{"ne", r, z[3519:3524], 0xa0, e, w{"bow.rain.fr", "ne.cctld.authdns.ripe.net", "ns-ne.afrinic.net", "ns.intnet.ne"}, n, n, n, e, e, f},
	{"nec", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.nec", e, t},
	{"net", r, z[3524:3534], 0x40, "https://www.verisign.com/en_US/domain-names/net-domain-names/index.xhtml", w{"a.gtld-servers.net", "b.gtld-servers.net", "c.gtld-servers.net", "d.gtld-servers.net", "e.gtld-servers.net", "f.gtld-servers.net", "g.gtld-servers.net", "h.gtld-servers.net", "i.gtld-servers.net", "j.gtld-servers.net", "k.gtld-servers.net", "l.gtld-servers.net", "m.gtld-servers.net"}, n, n, n, "whois.verisign-grs.com", e, t},
	{"netaporter", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"netbank", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.netbank", "b.nic.netbank", "c.nic.netbank", "d.nic.netbank"}, n, n, n, "whois.nic.netbank", e, f},
	{"netflix", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.netflix", "ns2.dns.nic.netflix", "ns3.dns.nic.netflix", "ns4.dns.nic.netflix", "ns5.dns.nic.netflix", "ns6.dns.nic.netflix"}, n, n, n, "whois.nic.netflix", e, f},
	{"network", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.network", e, t},
	{"neustar", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.neustar", "ns2.dns.nic.neustar", "ns3.dns.nic.neustar", "ns4.dns.nic.neustar", "ns5.dns.nic.neustar", "ns6.dns.nic.neustar"}, n, n, n, "whois.nic.neustar", e, t},
	{"new", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"newholland", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.newholland", e, f},
	{"news", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.news", e, t},
	{"next", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.next", e, f},
	{"nextdirect", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.nextdirect", e, f},
	{"nexus", r, x, 0x42, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"nf", r, z[3534:3546], 0xa0, e, w{"ns.anycast.nic.nf", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, "whois.nic.nf", e, f},
	{"nfl", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.nfl", "ns2.dns.nic.nfl", "ns3.dns.nic.nfl", "ns4.dns.nic.nfl", "ns5.dns.nic.nfl", "ns6.dns.nic.nfl"}, n, n, n, "whois.nic.nfl", e, t},
	{"ng", r, z[3546:3556], 0xa0, "https://web4africa.ng/ng-domains/", w{"ns1.nic.net.ng", "ns2.nic.net.ng", "ns5.nic.net.ng", "nsa.nic.net.ng"}, n, n, n, "whois.nic.net.ng", e, f},
	{"ngo", r, x, 0x40, "https://pir.org/products/ngo-ong-domain/", w{"a0.nic.ngo", "a2.nic.ngo", "b0.nic.ngo", "b2.nic.ngo", "c0.nic.ngo", "d0.nic.ngo"}, n, n, n, "whois.publicinterestregistry.net", e, t},
	{"nhk", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.nhk", e, t},
	{"ni", r, z[3556:3571], 0xa8, "https://www.nic.ni/", w{"dns-ext.nic.cr", "ns.ideay.net.ni", "ns.ni", "ns.uu.net", "ns2.ni", "ns3.ni"}, n, n, n, e, "http://www.nic.ni/", f},
	{"nico", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.nico", e, t},
	{"nike", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.nike", "ns2.dns.nic.nike", "ns3.dns.nic.nike", "ns4.dns.nic.nike", "ns5.dns.nic.nike", "ns6.dns.nic.nike"}, n, n, n, "whois.nic.nike", e, t},
	{"nikon", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.nikon", e, f},
	{"ninja", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.ninja", e, t},
	{"nissan", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.gmo", e, t},
	{"nissay", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.nissay", e, t},
	{"nl", r, z[3571:3577], 0xa0, e, w{"ns1.dns.nl", "ns2.dns.nl", "ns3.dns.nl"}, n, n, n, "whois.domain-registry.nl", e, f},
	{"no", r, z[3577:3587], 0xa0, e, w{"i.nic.no", "njet.norid.no", "not.norid.no", "x.nic.no", "y.nic.no", "z.nic.no"}, n, n, n, "whois.norid.no", e, t},
	{"nokia", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.nokia", "a2.nic.nokia", "b0.nic.nokia", "c0.nic.nokia"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"northlandinsurance", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"northwesternmutual", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.northwesternmutual", "ns2.dns.nic.northwesternmutual", "ns3.dns.nic.northwesternmutual", "ns4.dns.nic.northwesternmutual", "ns5.dns.nic.northwesternmutual", "ns6.dns.nic.northwesternmutual"}, n, n, n, "whois.nic.northwesternmutual", e, t},
	{"norton", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.norton", e, t},
	{"now", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.now", "dns2.nic.now", "dns3.nic.now", "dns4.nic.now", "dnsa.nic.now", "dnsb.nic.now", "dnsc.nic.now", "dnsd.nic.now"}, n, n, n, "whois.nic.now", e, t},
	{"nowruz", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.ns.nic.nowruz", "b.ns.nic.nowruz", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, w{"Iran"}, n, "whois.nic.nowruz", e, f},
	{"nowtv", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.nowtv", "a2.nic.nowtv", "b0.nic.nowtv", "c0.nic.nowtv"}, n, n, n, "whois.nic.nowtv", e, t},
	{"np", r, z[3587:3733], 0xa8, e, w{"np-ns.npix.net.np", "np.cctld.authdns.ripe.net", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, "http://register.mos.com.np/np-whois-lookup", f},
	{"nr", r, z[3733:3740], 0xa0, e, w{"ns0.cenpac.net.nr", "ns1.cenpac.net.nr", "ns2.cenpac.net.nr", "phloem.uoregon.edu"}, n, n, n, e, "http://www.cenpac.net.nr/dns/whois.html", f},
	{"nra", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.nra", "a2.nic.nra", "b0.nic.nra", "c0.nic.nra"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"nrw", r, x, 0x440, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, w{"DE-NW"}, n, "whois.nic.nrw", e, t},
	{"ntt", r, x, 0x42, "https://newgtlds.icann.org/", w{"tld1.nic.ntt", "tld2.nic.ntt", "tld3.nic.ntt", "tld5.nic.ntt"}, n, n, n, e, e, t},
	{"nu", r, z[3740:3745], 0xe0, "https://www.nic.nu/", w{"a.ns.nu", "c.ns.nu", "d.ns.nu", "m.ns.nu", "y.ns.nu", "z.ns.nu"}, n, n, n, "whois.iis.nu", e, t},
	{"nyc", r, x, 0xc4, e, w{"ns1.dns.nic.nyc", "ns2.dns.nic.nyc", "ns3.dns.nic.nyc", "ns4.dns.nic.nyc", "ns5.dns.nic.nyc", "ns6.dns.nic.nyc"}, n, w{"New York City"}, n, "whois.nic.nyc", e, t},
	{"nz", r, z[3745:3760], 0xa0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, "whois.srs.net.nz", e, t},
	{"obi", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.obi", e, f},
	{"observer", r, x, 0x42, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.observer", e, f},
	{"off", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.off", e, f},
	{"office", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.office", "ns2.dns.nic.office", "ns3.dns.nic.office", "ns4.dns.nic.office", "ns5.dns.nic.office", "ns6.dns.nic.office"}, n, n, n, "whois.nic.office", e, t},
	{"okinawa", r, x, 0xc4, e, w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, w{"Okinawa", "JP-47"}, n, "whois.nic.okinawa", e, t},
	{"olayan", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.olayan", "b.nic.olayan", "c.nic.olayan", "d.nic.olayan"}, n, n, n, "whois.nic.olayan", e, t},
	{"olayangroup", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.olayangroup", "b.nic.olayangroup", "c.nic.olayangroup", "d.nic.olayangroup"}, n, n, n, "whois.nic.olayangroup", e, t},
	{"oldnavy", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.oldnavy", "ns2.dns.nic.oldnavy", "ns3.dns.nic.oldnavy", "ns4.dns.nic.oldnavy", "ns5.dns.nic.oldnavy", "ns6.dns.nic.oldnavy"}, n, n, n, "whois.nic.oldnavy", e, t},
	{"ollo", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.ollo", "a2.nic.ollo", "b0.nic.ollo", "c0.nic.ollo"}, n, n, n, "whois.nic.ollo", e, f},
	{"olympus", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"om", r, z[3760:3773], 0xa0, "http://www.registry.om/", w{"cctld.alpha.aridns.net.au", "cctld.beta.aridns.net.au", "cctld.delta.aridns.net.au", "cctld.gamma.aridns.net.au", "ns1.registry.om", "ns2.registry.om"}, n, n, n, "whois.registry.om", e, f},
	{"omega", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.omega", e, t},
	{"one", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.one", "b.nic.one", "c.nic.one", "d.nic.one"}, n, n, n, "whois.nic.one", e, f},
	{"ong", r, x, 0x40, "https://pir.org/products/ngo-ong-domain/", w{"a0.nic.ong", "a2.nic.ong", "b0.nic.ong", "b2.nic.ong", "c0.nic.ong", "d0.nic.ong"}, n, n, n, "whois.publicinterestregistry.net", e, f},
	{"onl", r, x, 0x40, "https://nic.onl/", w{"a0.nic.onl", "a2.nic.onl", "b0.nic.onl", "c0.nic.onl"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"online", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.online", "b.nic.online", "e.nic.online", "f.nic.online"}, n, n, n, "whois.nic.online", e, t},
	{"onyourside", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.onyourside", e, f},
	{"ooo", r, x, 0x40, e, w{"a.nic.ooo", "b.nic.ooo", "c.nic.ooo", "d.nic.ooo"}, n, n, n, "whois.nic.ooo", e, t},
	{"open", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.open", "ns2.dns.nic.open", "ns3.dns.nic.open", "ns4.dns.nic.open", "ns5.dns.nic.open", "ns6.dns.nic.open"}, n, n, n, "whois.nic.open", e, t},
	{"oracle", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.oracle", e, f},
	{"orange", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.orange", e, t},
	{"org", r, z[3773:3779], 0x40, "https://pir.org/products/org-domain/", w{"a0.org.afilias-nst.info", "a2.org.afilias-nst.info", "b0.org.afilias-nst.org", "b2.org.afilias-nst.org", "c0.org.afilias-nst.info", "d0.org.afilias-nst.org"}, n, n, n, "whois.pir.org", e, t},
	{"organic", r, x, 0x40, "https://get.organic/", w{"a0.nic.organic", "a2.nic.organic", "b0.nic.organic", "c0.nic.organic"}, n, n, n, "whois.afilias.net", e, t},
	{"orientexpress", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, "whois.afilias-srs.net", e, f},
	{"origin", r, x, 0, e, n, n, n, n, "whois.afilias-srs.net", e, t},
	{"origins", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.origins", "a2.nic.origins", "b0.nic.origins", "c0.nic.origins"}, n, n, n, "whois.nic.origins", e, f},
	{"osaka", r, x, 0xc4, "https://newgtlds.icann.org/", w{"ns1.dns.nic.osaka", "ns2.dns.nic.osaka", "ns3.dns.nic.osaka", "ns4.dns.nic.osaka", "ns5.dns.nic.osaka", "ns6.dns.nic.osaka"}, n, w{"Osaka", "JP-27"}, n, "whois.nic.osaka", e, t},
	{"otsuka", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.otsuka", e, t},
	{"ott", r, x, 0x48, "https://newgtlds.icann.org/", w{"a0.nic.ott", "a2.nic.ott", "b0.nic.ott", "c0.nic.ott"}, n, n, n, "whois.nic.ott", e, f},
	{"overheidnl", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"ovh", r, x, 0x40, e, w{"d.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, n, n, "whois-ovh.nic.fr", e, t},
	{"pa", r, z[3779:3790], 0xa0, "http://www.nic.pa/", w{"dns-ext.nic.cr", "ns.dns.br", "ns.nic.pa", "ns.pa", "ns2.pa", "ssdns-tld.nic.cl"}, n, n, n, e, "http://www.nic.pa/", f},
	{"page", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"pamperedchef", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"panasonic", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.gmo", e, t},
	{"panerai", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.panerai", e, f},
	{"paris", r, x, 0xc4, e, w{"d.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr", "h.ext.nic.fr"}, n, w{"Paris", "FR-J"}, n, "whois-paris.nic.fr", e, t},
	{"pars", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.ns.nic.pars", "b.ns.nic.pars", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, w{"Iran"}, n, "whois.nic.pars", e, f},
	{"partners", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.partners", e, t},
	{"parts", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.parts", e, t},
	{"party", r, x, 0x40, "https://www.famousfourmedia.com/", w{"ns1.dns.nic.party", "ns2.dns.nic.party", "ns3.dns.nic.party", "ns4.dns.nic.party", "ns5.dns.nic.party", "ns6.dns.nic.party"}, n, n, n, "whois.nic.party", e, t},
	{"passagens", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.passagens", "ns2.dns.nic.passagens", "ns3.dns.nic.passagens", "ns4.dns.nic.passagens", "ns5.dns.nic.passagens", "ns6.dns.nic.passagens"}, n, n, n, "whois.nic.passagens", e, t},
	{"patagonia", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"patch", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"pay", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.pay", "dns2.nic.pay", "dns3.nic.pay", "dns4.nic.pay", "dnsa.nic.pay", "dnsb.nic.pay", "dnsc.nic.pay", "dnsd.nic.pay"}, n, n, n, "whois.nic.pay", e, t},
	{"payu", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"pccw", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.pccw", "a2.nic.pccw", "b0.nic.pccw", "c0.nic.pccw"}, n, n, n, "whois.nic.pccw", e, t},
	{"pe", r, z[3790:3799], 0xa0, "https://punto.pe/", w{"a.lactld.org", "pch.rcp.pe", "pe1.dnsnode.net", "quipu.rcp.net.pe"}, n, n, n, "kero.yachay.pe", e, t},
	{"persiangulf", r, x, 0xc0, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"pet", r, x, 0x40, "https://get.pet/", w{"a0.nic.pet", "a2.nic.pet", "b0.nic.pet", "c0.nic.pet"}, n, n, n, "whois.afilias.net", e, t},
	{"pets", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"pf", r, z[3799:3804], 0xa0, e, w{"ns1.mana.pf", "ns2.mana.pf"}, n, n, n, "whois.registry.pf", e, f},
	{"pfizer", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.pfizer", "ns2.dns.nic.pfizer", "ns3.dns.nic.pfizer", "ns4.dns.nic.pfizer", "ns5.dns.nic.pfizer", "ns6.dns.nic.pfizer"}, n, n, n, "whois.nic.pfizer", e, t},
	{"pg", r, z[3804:3810], 0xa0, e, w{"munnari.oz.au", "ns.uu.net", "ns1.tiare.net.pg", "ns1.unitech.ac.pg", "ns2.tiare.net.pg"}, n, n, n, e, e, f},
	{"ph", r, z[3810:3819], 0xa0, e, w{"1.ns.ph", "ns2.cuhk.edu.hk", "ns4.apnic.net", "ph.communitydns.net"}, w{"45.79.222.138"}, n, n, e, "http://www.dot.ph/whois", f},
	{"pharmacy", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.pharmacy", "dns2.nic.pharmacy", "dns3.nic.pharmacy", "dns4.nic.pharmacy", "dnsa.nic.pharmacy", "dnsb.nic.pharmacy", "dnsc.nic.pharmacy", "dnsd.nic.pharmacy"}, n, n, n, "whois.nic.pharmacy", e, t},
	{"phd", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"philips", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.philips", "b.nic.philips", "c.nic.philips", "d.nic.philips"}, n, n, n, "whois.nic.philips", e, f},
	{"phone", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.phone", "a2.nic.phone", "b0.nic.phone", "c0.nic.phone"}, n, n, n, "whois.nic.phone", e, f},
	{"photo", r, x, 0x40, "https://nic.photo/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"photography", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.photography", e, t},
	{"photos", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.photos", e, t},
	{"physio", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.physio", "b.nic.physio", "c.nic.physio", "d.nic.physio"}, n, n, n, "whois.nic.physio", e, f},
	{"piaget", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.piaget", e, f},
	{"pics", r, x, 0x40, "https://nic.pics/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"pictet", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, f},
	{"pictures", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.pictures", e, t},
	{"pid", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.pid", "b.nic.pid", "c.nic.pid", "d.nic.pid"}, n, n, n, "whois.nic.pid", e, t},
	{"pin", r, x, 0x48, "https://newgtlds.icann.org/", w{"dns1.nic.pin", "dns2.nic.pin", "dns3.nic.pin", "dns4.nic.pin", "dnsa.nic.pin", "dnsb.nic.pin", "dnsc.nic.pin", "dnsd.nic.pin"}, n, n, n, "whois.nic.pin", e, t},
	{"ping", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.ping", "ns2.dns.nic.ping", "ns3.dns.nic.ping", "ns4.dns.nic.ping", "ns5.dns.nic.ping", "ns6.dns.nic.ping"}, n, n, n, "whois.nic.ping", e, f},
	{"pink", r, x, 0x40, "https://get.pink/", w{"a0.nic.pink", "a2.nic.pink", "b0.nic.pink", "b2.nic.pink", "c0.nic.pink"}, n, n, n, "whois.afilias.net", e, t},
	{"pioneer", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.gmo", e, t},
	{"piperlime", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"pitney", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"pizza", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.pizza", e, t},
	{"pk", r, z[3819:3834], 0xa0, e, w{"root-c1.pknic.pk", "root-c2.pknic.pk", "root-e.pknic.pk", "root-s.pknic.pk"}, n, n, n, e, "http://www.pknic.net.pk/", f},
	{"pl", r, z[3834:4002], 0xa0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, "whois.dns.pl", e, t},
	{"place", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.place", e, t},
	{"play", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"playstation", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.playstation", e, t},
	{"plumbing", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.plumbing", e, t},
	{"plus", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.plus", e, t},
	{"pm", r, x, 0xa0, e, w{"d.nic.fr", "e.ext.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, n, n, "whois.nic.pm", e, t},
	{"pn", r, z[4002:4021], 0xa0, "https://www.nic.pn/", w{"dns1.nominetdns.uk", "dns4.nominetdns.uk", "fork.sth.dnsnode.net", "ns0.pitcairn.net.pn", "ns1.pitcairn.net.pn"}, n, n, n, e, "http://www.pitcairn.pn/PnRegistry/", f},
	{"pnc", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.pnc", "a2.nic.pnc", "b0.nic.pnc", "c0.nic.pnc"}, n, n, n, "whois.nic.pnc", e, f},
	{"pohl", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.pohl", "b.nic.pohl", "c.nic.pohl", "d.nic.pohl"}, n, n, n, "whois.nic.pohl", e, f},
	{"poker", r, x, 0x40, "https://get.poker/", w{"a0.nic.poker", "a2.nic.poker", "b0.nic.poker", "c0.nic.poker"}, n, n, n, "whois.afilias.net", e, t},
	{"politie", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.nic.politie", "ns2.nic.politie", "ns3.nic.politie"}, n, n, n, "whois.nic.politie", e, f},
	{"polo", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"porn", r, x, 0x41, "https://nic.porn/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns5.uniregistry.net", "ns6.uniregistry.info"}, n, n, n, "whois.registrar.adult", e, t},
	{"post", r, x, 0x1040, "https://en.wikipedia.org/wiki/.post", w{"a0.post.afilias-nst.info", "a2.post.afilias-nst.info", "b0.post.afilias-nst.org", "b2.post.afilias-nst.org", "c0.post.afilias-nst.info", "d0.post.afilias-nst.org"}, n, n, n, "whois.dotpostregistry.net", e, f},
	{"pr", r, z[4021:4073], 0xa0, "https://domains.pr/", w{"a.lactld.org", "a0.pr.afilias-nst.info", "a2.pr.afilias-nst.info", "b0.pr.afilias-nst.org", "b2.pr.afilias-nst.org", "c0.pr.afilias-nst.info", "d0.pr.afilias-nst.org", "pr-dns.denic.de"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"pramerica", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.pramerica", "ns2.dns.nic.pramerica", "ns3.dns.nic.pramerica", "ns4.dns.nic.pramerica", "ns5.dns.nic.pramerica", "ns6.dns.nic.pramerica"}, n, n, n, "whois.nic.pramerica", e, t},
	{"praxi", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.praxi", "ns2.dns.nic.praxi", "ns3.dns.nic.praxi", "ns4.dns.nic.praxi", "ns5.dns.nic.praxi", "ns6.dns.nic.praxi"}, n, n, n, "whois.nic.praxi", e, f},
	{"press", r, x, 0x40, e, w{"a.nic.press", "b.nic.press", "e.nic.press", "f.nic.press"}, n, n, n, "whois.nic.press", e, t},
	{"prime", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.prime", "dns2.nic.prime", "dns3.nic.prime", "dns4.nic.prime", "dnsa.nic.prime", "dnsb.nic.prime", "dnsc.nic.prime", "dnsd.nic.prime"}, n, n, n, "whois.nic.prime", e, t},
	{"pro", r, z[4073:4109], 0x40, "https://registry.pro/", w{"a0.pro.afilias-nst.info", "a2.pro.afilias-nst.info", "b0.pro.afilias-nst.org", "b2.pro.afilias-nst.org", "c0.pro.afilias-nst.info", "d0.pro.afilias-nst.org"}, n, n, n, "whois.afilias.net", e, t},
	{"prod", r, x, 0x42, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"productions", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.productions", e, t},
	{"prof", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"progressive", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.progressive", "a2.nic.progressive", "b0.nic.progressive", "c0.nic.progressive"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"promo", r, x, 0x40, "https://get.promo/", w{"a0.nic.promo", "a2.nic.promo", "b0.nic.promo", "c0.nic.promo"}, n, n, n, "whois.afilias.net", e, t},
	{"properties", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.properties", e, t},
	{"property", r, x, 0x40, "https://nic.property/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"protection", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.protection", "b.nic.protection", "e.nic.protection", "f.nic.protection"}, n, n, n, "whois.nic.protection", e, t},
	{"pru", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.pru", "ns2.dns.nic.pru", "ns3.dns.nic.pru", "ns4.dns.nic.pru", "ns5.dns.nic.pru", "ns6.dns.nic.pru"}, n, n, n, "whois.nic.pru", e, t},
	{"prudential", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.prudential", "ns2.dns.nic.prudential", "ns3.dns.nic.prudential", "ns4.dns.nic.prudential", "ns5.dns.nic.prudential", "ns6.dns.nic.prudential"}, n, n, n, "whois.nic.prudential", e, t},
	{"ps", r, z[4109:4118], 0xa0, e, w{"dns1.gov.ps", "fork.sth.dnsnode.net", "ns1.pnina.ps", "ps-ns.anycast.pch.net", "ps.cctld.authdns.ripe.net", "rip.psg.com"}, n, n, n, "whois.pnina.ps", e, f},
	{"pt", r, z[4118:4127], 0xa0, e, w{"a.dns.pt", "b.dns.pt", "c.dns.pt", "d.dns.pt", "e.dns.pt", "g.dns.pt", "h.dns.pt", "ns.dns.br", "ns2.nic.fr"}, n, n, n, "whois.dns.pt", e, t},
	{"pub", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.pub", e, t},
	{"pw", r, z[4127:4138], 0xa0, e, w{"ns1.nic.pw", "ns2.nic.pw", "ns5.nic.pw", "ns6.nic.pw"}, n, n, n, "whois.nic.pw", e, t},
	{"pwc", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.pwc", "a2.nic.pwc", "b0.nic.pwc", "c0.nic.pwc"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"py", r, z[4138:4146], 0xa8, e, w{"b.dns.py", "c.dns.py", "l.dns.py", "m.dns.py", "p.dns.py", "u.dns.py"}, n, n, n, e, "http://www.nic.py/consulta-datos.php", f},
	{"qa", r, z[4146:4154], 0xa0, e, w{"a.registry.qa", "b.registry.qa", "c.registry.qa", "d.registry.qa", "e.registry.qa", "f.registry.qa", "g.registry.qa", "h.registry.qa", "i.registry.qa"}, n, n, n, "whois.registry.qa", e, f},
	{"qpon", r, x, 0x40, e, w{"a.nic.qpon", "b.nic.qpon", "c.nic.qpon", "d.nic.qpon"}, n, n, n, "whois.nic.qpon", e, t},
	{"qtel", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"quebec", r, x, 0xc4, e, w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, w{"Quebec", "CA-QC"}, n, "whois.nic.quebec", e, t},
	{"quest", r, x, 0x42, "https://newgtlds.icann.org/", w{"a-cnic.nic.quest", "b-cnic.nic.quest", "c-cnic.nic.quest", "d-cnic.nic.quest"}, n, n, n, "whois.nic.quest", e, f},
	{"qvc", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.qvc", "ns2.dns.nic.qvc", "ns3.dns.nic.qvc", "ns4.dns.nic.qvc", "ns5.dns.nic.qvc", "ns6.dns.nic.qvc"}, n, n, n, "whois.nic.qvc", e, f},
	{"racing", r, x, 0x40, "https://www.famousfourmedia.com/", w{"ns1.dns.nic.racing", "ns2.dns.nic.racing", "ns3.dns.nic.racing", "ns4.dns.nic.racing", "ns5.dns.nic.racing", "ns6.dns.nic.racing"}, n, n, n, "whois.nic.racing", e, t},
	{"radio", r, x, 0x40, "https://www.nic.radio/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.radio", e, f},
	{"raid", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.raid", e, f},
	{"ram", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"re", r, z[4154:4157], 0xa0, e, w{"d.nic.fr", "e.ext.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, n, n, "whois.nic.re", e, t},
	{"read", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.read", "dns2.nic.read", "dns3.nic.read", "dns4.nic.read", "dnsa.nic.read", "dnsb.nic.read", "dnsc.nic.read", "dnsd.nic.read"}, n, n, n, "whois.nic.read", e, t},
	{"realestate", r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.realestate", e, t},
	{"realtor", r, x, 0x40, "https://www.claim.realtor/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, f},
	{"realty", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.realty", e, t},
	{"recipes", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.recipes", e, t},
	{"red", r, x, 0x40, "https://get.red/", w{"a0.nic.red", "a2.nic.red", "b0.nic.red", "c0.nic.red"}, n, n, n, "whois.afilias.net", e, t},
	{"redken", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"redstone", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.redstone", "a2.nic.redstone", "b0.nic.redstone", "c0.nic.redstone"}, n, n, n, "whois.nic.redstone", e, f},
	{"redumbrella", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.redumbrella", "a2.nic.redumbrella", "b0.nic.redumbrella", "c0.nic.redumbrella"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"rehab", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.rehab", e, t},
	{"reise", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.reise", e, t},
	{"reisen", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.reisen", e, t},
	{"reit", r, x, 0x50, "https://newgtlds.icann.org/", w{"a.nic.reit", "b.nic.reit", "c.nic.reit", "d.nic.reit"}, n, n, n, "whois.nic.reit", e, f},
	{"reliance", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.reliance", "a2.nic.reliance", "b0.nic.reliance", "c0.nic.reliance"}, n, n, n, "whois.nic.reliance", e, f},
	{"ren", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.nic.ren", e, f},
	{"rent", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.rent", "b.nic.rent", "c.nic.rent", "d.nic.rent"}, n, n, n, "whois.nic.rent", e, t},
	{"rentals", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.rentals", e, t},
	{"repair", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.repair", e, t},
	{"report", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.report", e, t},
	{"republican", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.republican", e, t},
	{"rest", r, x, 0x40, e, w{"a.nic.rest", "b.nic.rest", "c.nic.rest", "d.nic.rest"}, n, n, n, "whois.nic.rest", e, t},
	{"restaurant", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.restaurant", e, t},
	{"retirement", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"review", r, x, 0x40, "https://www.famousfourmedia.com/", w{"ns1.dns.nic.review", "ns2.dns.nic.review", "ns3.dns.nic.review", "ns4.dns.nic.review", "ns5.dns.nic.review", "ns6.dns.nic.review"}, n, n, n, "whois.nic.review", e, t},
	{"reviews", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.reviews", e, t},
	{"rexroth", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.rexroth", e, f},
	{"rich", r, x, 0x40, "https://nic.rich/", w{"a0.nic.rich", "a2.nic.rich", "b0.nic.rich", "c0.nic.rich"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"richardli", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.richardli", "a2.nic.richardli", "b0.nic.richardli", "c0.nic.richardli"}, n, n, n, "whois.nic.richardli", e, t},
	{"ricoh", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.ricoh", e, t},
	{"rightathome", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.rightathome", e, f},
	{"ril", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.ril", "a2.nic.ril", "b0.nic.ril", "c0.nic.ril"}, n, n, n, "whois.nic.ril", e, f},
	{"rio", r, x, 0xc4, "https://newgtlds.icann.org/", w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, w{"Rio de Janeiro", "BR-RJ"}, n, "whois.gtlds.nic.br", e, t},
	{"rip", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.rip", e, t},
	{"rmit", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.rmit", "b.nic.rmit", "c.nic.rmit", "d.nic.rmit"}, n, n, n, "whois.nic.rmit", e, f},
	{"ro", r, z[4157:4174], 0xa0, e, w{"dns-at.rotld.ro", "dns-c.rotld.ro", "dns-ro.denic.de", "primary.rotld.ro", "sec-dns-a.rotld.ro", "sec-dns-b.rotld.ro"}, n, n, n, "whois.rotld.ro", e, f},
	{"rocher", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.rocher", "ns2.dns.nic.rocher", "ns3.dns.nic.rocher", "ns4.dns.nic.rocher", "ns5.dns.nic.rocher", "ns6.dns.nic.rocher"}, n, n, n, "whois.nic.rocher", e, t},
	{"rocks", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.rocks", e, t},
	{"rockwool", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"rodeo", r, x, 0x40, "http://nic.rodeo/", w{"dns1.nic.rodeo", "dns2.nic.rodeo", "dns3.nic.rodeo", "dns4.nic.rodeo", "dnsa.nic.rodeo", "dnsb.nic.rodeo", "dnsc.nic.rodeo", "dnsd.nic.rodeo"}, n, n, n, "whois.nic.rodeo", e, t},
	{"rogers", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.rogers", "a2.nic.rogers", "b0.nic.rogers", "c0.nic.rogers"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"roma", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"room", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.room", "dns2.nic.room", "dns3.nic.room", "dns4.nic.room", "dnsa.nic.room", "dnsb.nic.room", "dnsc.nic.room", "dnsd.nic.room"}, n, n, n, "whois.nic.room", e, t},
	{"root", r, x, 0x40, e, n, n, n, n, e, e, f},
	{"rs", r, z[4174:4180], 0xa0, e, w{"a.nic.rs", "b.nic.rs", "f.nic.rs", "g.nic.rs", "h.nic.rs", "l.nic.rs"}, n, n, n, "whois.rnids.rs", e, t},
	{"rsvp", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"ru", r, z[4180:4208], 0xa0, e, w{"a.dns.ripn.net", "b.dns.ripn.net", "d.dns.ripn.net", "e.dns.ripn.net", "f.dns.ripn.net"}, n, n, n, "whois.tcinet.ru", e, t},
	{"rugby", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.rugby", "b.nic.rugby", "c.nic.rugby", "d.nic.rugby"}, n, n, n, "whois.nic.rugby", e, f},
	{"ruhr", r, x, 0x440, e, w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, w{"DE-NW"}, n, "whois.nic.ruhr", e, t},
	{"run", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.run", e, t},
	{"rw", r, z[4208:4218], 0xa0, "https://ricta.org.rw/", w{"fork.sth.dnsnode.net", "ns-rw.afrinic.net", "ns1.ricta.org.rw", "ns3.ricta.org.rw", "pch.ricta.org.rw"}, n, n, n, "whois.ricta.org.rw", e, f},
	{"rwe", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.rwe", e, t},
	{"ryukyu", r, x, 0x440, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, w{"JP-46", "JP-47"}, n, "whois.nic.ryukyu", e, t},
	{"sa", r, z[4218:4226], 0xa0, e, w{"c1.dns.sa", "c2.dns.sa", "i1.dns.sa", "n1.dns.sa", "p1.dns.sa", "s1.dns.sa", "s2.dns.sa"}, n, n, n, "whois.nic.net.sa", e, f},
	{"saarland", r, x, 0x4c0, e, w{"a.nic.saarland", "b.nic.saarland", "c.nic.saarland", "d.nic.saarland"}, n, w{"DE-SL"}, n, "whois.nic.saarland", e, t},
	{"safe", r, x, 0x48, "https://newgtlds.icann.org/", w{"dns1.nic.safe", "dns2.nic.safe", "dns3.nic.safe", "dns4.nic.safe", "dnsa.nic.safe", "dnsb.nic.safe", "dnsc.nic.safe", "dnsd.nic.safe"}, n, n, n, "whois.nic.safe", e, t},
	{"safety", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.safety", "ns2.dns.nic.safety", "ns3.dns.nic.safety", "ns4.dns.nic.safety", "ns5.dns.nic.safety", "ns6.dns.nic.safety"}, n, n, n, "whois.nic.safety", e, t},
	{"safeway", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"sakura", r, x, 0x42, "https://newgtlds.icann.org/", w{"tld1.nic.sakura", "tld2.nic.sakura", "tld3.nic.sakura", "tld5.nic.sakura"}, n, n, n, e, e, t},
	{"sale", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.sale", e, t},
	{"salon", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.salon", e, t},
	{"samsclub", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.samsclub", e, f},
	{"samsung", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.samsung.centralnic-dns.com", "ns2.samsung.centralnic-dns.com", "ns3.samsung.centralnic-dns.com", "ns4.samsung.centralnic-dns.com"}, n, n, n, "whois.nic.samsung", e, t},
	{"sandvik", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.sandvik", "b.nic.sandvik", "c.nic.sandvik", "d.nic.sandvik"}, n, n, n, "whois.nic.sandvik", e, t},
	{"sandvikcoromant", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.sandvikcoromant", "b.nic.sandvikcoromant", "c.nic.sandvikcoromant", "d.nic.sandvikcoromant"}, n, n, n, "whois.nic.sandvikcoromant", e, t},
	{"sanofi", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.sanofi", e, f},
	{"sap", r, x, 0x42, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.sap", e, t},
	{"sapo", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"sapphire", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"sarl", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.sarl", e, t},
	{"sas", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.sas", "ns2.dns.nic.sas", "ns3.dns.nic.sas", "ns4.dns.nic.sas", "ns5.dns.nic.sas", "ns6.dns.nic.sas"}, n, n, n, "whois.nic.sas", e, t},
	{"save", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.save", "dns2.nic.save", "dns3.nic.save", "dns4.nic.save", "dnsa.nic.save", "dnsb.nic.save", "dnsc.nic.save", "dnsd.nic.save"}, n, n, n, "whois.nic.save", e, t},
	{"saxo", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.saxo", "b.nic.saxo", "c.nic.saxo", "d.nic.saxo"}, n, n, n, "whois.nic.saxo", e, f},
	{"sb", r, z[4226:4231], 0xa0, e, w{"ns1.anycastdns.cz", "ns2.anycastdns.cz", "pch.nic.sb"}, n, n, n, "whois.nic.net.sb", e, f},
	{"sbi", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.sbi", "a2.nic.sbi", "b0.nic.sbi", "c0.nic.sbi"}, n, n, n, "whois.nic.sbi", e, f},
	{"sbs", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.sbs", "b.nic.sbs", "c.nic.sbs", "d.nic.sbs"}, n, n, n, "whois.nic.sbs", e, t},
	{"sc", r, z[4231:4236], 0xe0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org", "ns1.nic.sc"}, n, n, n, "whois2.afilias-grs.net", e, t},
	{"sca", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.sca", e, t},
	{"scb", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.scb", "b.nic.scb", "c.nic.scb", "d.nic.scb"}, n, n, n, "whois.nic.scb", e, t},
	{"schaeffler", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.dns.nic.schaeffler", "m.dns.nic.schaeffler", "n.dns.nic.schaeffler"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"schmidt", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.schmidt", "b.nic.schmidt", "c.nic.schmidt", "d.nic.schmidt"}, n, n, n, "whois.nic.schmidt", e, f},
	{"scholarships", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.scholarships", "a2.nic.scholarships", "b0.nic.scholarships", "c0.nic.scholarships"}, n, n, n, "whois.nic.scholarships", e, f},
	{"school", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.school", e, t},
	{"schule", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.schule", e, t},
	{"schwarz", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.schwarz", "b.nic.schwarz", "c.nic.schwarz", "d.nic.schwarz"}, n, n, n, "whois.nic.schwarz", e, t},
	{"schwarzgroup", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"science", r, x, 0x40, "https://www.famousfourmedia.com/", w{"ns1.dns.nic.science", "ns2.dns.nic.science", "ns3.dns.nic.science", "ns4.dns.nic.science", "ns5.dns.nic.science", "ns6.dns.nic.science"}, n, n, n, "whois.nic.science", e, t},
	{"scjohnson", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.scjohnson", e, f},
	{"scor", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.scor", e, f},
	{"scot", r, x, 0x440, e, w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, w{"GB-SCT"}, n, "whois.nic.scot", e, t},
	{"sd", r, z[4236:4244], 0xa0, e, w{"ans1.canar.sd", "ans1.sis.sd", "ans2.canar.sd", "ns-sd.afrinic.net", "pch.sis.sd", "sd.cctld.authdns.ripe.net"}, n, n, n, e, e, f},
	{"se", r, z[4244:4276], 0xa0, e, w{"a.ns.se", "b.ns.se", "c.ns.se", "f.ns.se", "g.ns.se", "i.ns.se", "m.ns.se", "x.ns.se", "y.ns.se", "z.ns.se"}, n, n, n, "whois.iis.se", e, t},
	{"search", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"seat", r, x, 0x42, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.seat", e, f},
	{"secure", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.secure", "dns2.nic.secure", "dns3.nic.secure", "dns4.nic.secure", "dnsa.nic.secure", "dnsb.nic.secure", "dnsc.nic.secure", "dnsd.nic.secure"}, n, n, n, "whois.nic.secure", e, t},
	{"security", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.security", "b.nic.security", "e.nic.security", "f.nic.security"}, n, n, n, "whois.nic.security", e, t},
	{"seek", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.seek", "b.nic.seek", "c.nic.seek", "d.nic.seek"}, n, n, n, "whois.nic.seek", e, f},
	{"select", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.select", "b.nic.select", "c.nic.select", "d.nic.select"}, n, n, n, "whois.nic.select", e, f},
	{"sener", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, t},
	{"services", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.services", e, t},
	{"ses", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.ses", e, f},
	{"seven", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.seven", "b.nic.seven", "c.nic.seven", "d.nic.seven"}, n, n, n, "whois.nic.seven", e, f},
	{"sew", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.sew", "a2.nic.sew", "b0.nic.sew", "c0.nic.sew"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"sex", r, x, 0x41, "https://nic.sex/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns5.uniregistry.net", "ns6.uniregistry.info"}, n, n, n, "whois.registrar.adult", e, t},
	{"sexy", r, x, 0x41, "https://nic.sexy/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"sfr", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.sfr", "b.nic.sfr", "c.nic.sfr", "d.nic.sfr"}, n, n, n, "whois.nic.sfr", e, t},
	{"sg", r, z[4276:4282], 0xa0, e, w{"dsany.sgnic.sg", "dsany2.sgnic.sg", "dsany3.sgnic.sg", "ns4.apnic.net", "pch.sgzones.sg"}, n, n, n, "whois.sgnic.sg", e, t},
	{"sh", r, z[4282:4289], 0xa0, "https://www.nic.sh/", w{"a0.nic.sh", "a2.nic.sh", "b0.nic.sh", "c0.nic.sh"}, n, n, n, "whois.nic.sh", e, t},
	{"shangrila", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.shangrila", e, f},
	{"sharp", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.gmo", e, t},
	{"shaw", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.shaw", "a2.nic.shaw", "b0.nic.shaw", "c0.nic.shaw"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"shell", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.shell", e, t},
	{"shia", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.ns.nic.shia", "b.ns.nic.shia", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, w{"Iran"}, n, "whois.nic.shia", e, f},
	{"shiksha", r, x, 0x40, "https://get.shiksha/", w{"a0.nic.shiksha", "a2.nic.shiksha", "b0.nic.shiksha", "c0.nic.shiksha"}, n, n, n, "whois.afilias.net", e, f},
	{"shoes", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.shoes", e, t},
	{"shop", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.shop", e, t},
	{"shopping", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.shopping", e, t},
	{"shopyourway", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"shouji", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.teleinfo.cn", "ns2.teleinfoo.com", "ns3.teleinfo.cn", "ns4.teleinfoo.com"}, n, n, n, "whois.teleinfo.cn", e, f},
	{"show", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.show", e, t},
	{"showtime", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.showtime", "a2.nic.showtime", "b0.nic.showtime", "c0.nic.showtime"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"shriram", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.afilias-srs.net", e, f},
	{"si", r, z[4289:4296], 0xa0, e, w{"b.dns.si", "f.dns.si", "g.dns.si", "h.dns.si", "i.dns.si", "k.dns.si", "l.dns.si"}, n, n, n, "whois.register.si", e, t},
	{"silk", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.silk", "dns2.nic.silk", "dns3.nic.silk", "dns4.nic.silk", "dnsa.nic.silk", "dnsb.nic.silk", "dnsc.nic.silk", "dnsd.nic.silk"}, n, n, n, "whois.nic.silk", e, t},
	{"sina", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.sina", "a2.nic.sina", "b0.nic.sina", "c0.nic.sina"}, n, n, n, "whois.nic.sina", e, t},
	{"singles", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.singles", e, t},
	{"site", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.site", "b.nic.site", "e.nic.site", "f.nic.site"}, n, n, n, "whois.nic.site", e, t},
	{"sj", r, x, 0xa8, e, w{"nac.no", "nn.uninett.no", "server.nordu.net"}, n, n, n, e, e, f},
	{"sk", r, x, 0xa0, e, w{"a.tld.sk", "b.tld.sk", "c.tld.sk", "e.tld.sk", "f.tld.sk", "g.tld.sk", "h.tld.sk"}, n, n, n, "whois.sk-nic.sk", e, f},
	{"ski", r, x, 0x40, "https://domains.ski/", w{"a0.nic.ski", "a2.nic.ski", "b0.nic.ski", "c0.nic.ski"}, n, n, n, "whois.afilias.net", e, t},
	{"skin", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.skin", "b.nic.skin", "c.nic.skin", "d.nic.skin"}, n, n, n, "whois.nic.skin", e, f},
	{"skolkovo", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"sky", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.sky", e, t},
	{"skydrive", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"skype", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.skype", "ns2.dns.nic.skype", "ns3.dns.nic.skype", "ns4.dns.nic.skype", "ns5.dns.nic.skype", "ns6.dns.nic.skype"}, n, n, n, "whois.nic.skype", e, t},
	{"sl", r, z[4296:4301], 0xa0, "https://www.nic.sl/", w{"ns1.neoip.com", "ns2.neoip.com"}, n, n, n, "whois.nic.sl", e, f},
	{"sling", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.sling", "a2.nic.sling", "b0.nic.sling", "c0.nic.sling"}, n, n, n, "whois.nic.sling", e, f},
	{"sm", r, x, 0xa0, e, w{"dns.intelcom.sm", "dns.omniway.sm", "ns3.telecomitalia.sm", "sm.cctld.authdns.ripe.net"}, n, n, n, "whois.nic.sm", e, f},
	{"smart", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.smart", "b.nic.smart", "c.nic.smart", "d.nic.smart"}, n, n, n, "whois.nic.smart", e, f},
	{"smile", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.smile", "dns2.nic.smile", "dns3.nic.smile", "dns4.nic.smile", "dnsa.nic.smile", "dnsb.nic.smile", "dnsc.nic.smile", "dnsd.nic.smile"}, n, n, n, "whois.nic.smile", e, t},
	{"sn", r, z[4301:4308], 0xa8, e, w{"censvrns0001.ird.fr", "ns-sn.nic.fr", "ns.ucad.sn", "ns1.sonatel.sn", "sn.cctld.authdns.ripe.net"}, n, n, n, "whois.nic.sn", e, f},
	{"sncf", r, x, 0x42, "https://newgtlds.icann.org/", w{"d.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, n, n, "whois.nic.sncf", e, t},
	{"so", r, z[4308:4312], 0xa0, e, w{"d.nic.so", "e.nic.so"}, n, n, n, "whois.nic.so", e, f},
	{"soccer", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.soccer", e, t},
	{"social", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.social", e, t},
	{"softbank", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.softbank", e, t},
	{"software", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.software", e, t},
	{"sohu", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.nic.sohu", e, t},
	{"solar", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.solar", e, t},
	{"solutions", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.solutions", e, t},
	{"song", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.song", "ns2.dns.nic.song", "ns3.dns.nic.song", "ns4.dns.nic.song", "ns5.dns.nic.song", "ns6.dns.nic.song"}, n, n, n, "whois.nic.song", e, t},
	{"sony", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.sony", e, t},
	{"soy", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"spa", r, x, 0x50, "http://www.nic.spa/", w{"a0.nic.spa", "a2.nic.spa", "b0.nic.spa", "c0.nic.spa"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"space", r, z[4312:4313], 0x40, "https://newgtlds.icann.org/", w{"a.nic.space", "b.nic.space", "e.nic.space", "f.nic.space"}, n, n, n, "whois.nic.space", e, t},
	{"spiegel", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.ksregistry.net", e, f},
	{"sport", r, x, 0x40, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.sport", e, f},
	{"sports", r, x, 0x2040, "https://gtldresult.icann.org/applicationstatus/applicationdetails/604", n, n, n, n, e, e, t},
	{"spot", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.spot", "dns2.nic.spot", "dns3.nic.spot", "dns4.nic.spot", "dnsa.nic.spot", "dnsb.nic.spot", "dnsc.nic.spot", "dnsd.nic.spot"}, n, n, n, "whois.nic.spot", e, t},
	{"spreadbetting", r, x, 0x40, "https://bostonivy.co/", w{"a.nic.spreadbetting", "b.nic.spreadbetting", "c.nic.spreadbetting", "d.nic.spreadbetting"}, n, n, n, "whois.nic.spreadbetting", e, f},
	{"sr", r, x, 0xe0, e, w{"ns1.sr.net", "ns2.sr.net"}, n, n, n, e, "http://www.register.sr/", f},
	{"srl", r, x, 0x40, "https://www.internetx.info/en/", w{"a0.nic.srl", "a2.nic.srl", "b0.nic.srl", "c0.nic.srl"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"srt", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.afilias-srs.net", e, f},
	{"ss", r, z[4313:4320], 0, e, w{"b.ns.tznic.or.tz", "ns-ss.afrinic.net", "pch.nic.ss", "root.nic.ss", "ssnic.anycastdns.cz"}, n, n, n, "whois.nic.ss", e, t},
	{"st", r, z[4320:4333], 0xa0, e, w{"dns-au.st", "dns-st.bahnhof.net", "dns-us.st", "ns1.bahnhof.net"}, n, n, n, "whois.nic.st", e, f},
	{"stada", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.stada", "a2.nic.stada", "b0.nic.stada", "c0.nic.stada"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"staples", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.staples", "ns2.dns.nic.staples", "ns3.dns.nic.staples", "ns4.dns.nic.staples", "ns5.dns.nic.staples", "ns6.dns.nic.staples"}, n, n, n, "whois.nic.staples", e, t},
	{"star", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.star", "a2.nic.star", "b0.nic.star", "c0.nic.star"}, n, n, n, "whois.nic.star", e, t},
	{"starhub", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.starhub", e, f},
	{"statebank", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.statebank", "a2.nic.statebank", "b0.nic.statebank", "c0.nic.statebank"}, n, n, n, "whois.nic.statebank", e, f},
	{"statefarm", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.statefarm", "ns2.dns.nic.statefarm", "ns3.dns.nic.statefarm", "ns4.dns.nic.statefarm", "ns5.dns.nic.statefarm", "ns6.dns.nic.statefarm"}, n, n, n, "whois.nic.statefarm", e, t},
	{"statoil", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.statoil", e, f},
	{"stc", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.stc", "b.nic.stc", "c.nic.stc", "d.nic.stc"}, n, n, n, "whois.nic.stc", e, f},
	{"stcgroup", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.stcgroup", "b.nic.stcgroup", "c.nic.stcgroup", "d.nic.stcgroup"}, n, n, n, "whois.nic.stcgroup", e, f},
	{"stockholm", r, x, 0xc4, "https://newgtlds.icann.org/", w{"a0.nic.stockholm", "a2.nic.stockholm", "b0.nic.stockholm", "c0.nic.stockholm"}, n, w{"Stockholm", "SE-AB"}, n, "whois.afilias-srs.net", e, t},
	{"storage", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.storage", "b.nic.storage", "c.nic.storage", "d.nic.storage"}, n, n, n, "whois.nic.storage", e, t},
	{"store", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.store", "b.nic.store", "e.nic.store", "f.nic.store"}, n, n, n, "whois.nic.store", e, t},
	{"stream", r, x, 0x40, "https://www.famousfourmedia.com/", w{"ns1.dns.nic.stream", "ns2.dns.nic.stream", "ns3.dns.nic.stream", "ns4.dns.nic.stream", "ns5.dns.nic.stream", "ns6.dns.nic.stream"}, n, n, n, "whois.nic.stream", e, t},
	{"stroke", r, x, 0x2040, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"studio", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.studio", e, t},
	{"study", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.study", "b.nic.study", "c.nic.study", "d.nic.study"}, n, n, n, "whois.nic.study", e, f},
	{"style", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.style", e, t},
	{"su", r, z[4333:4385], 0xe0, e, w{"a.dns.ripn.net", "b.dns.ripn.net", "d.dns.ripn.net", "e.dns.ripn.net", "f.dns.ripn.net"}, n, n, n, "whois.tcinet.ru", e, t},
	{"sucks", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.sucks", "b.nic.sucks", "c.nic.sucks", "d.nic.sucks"}, n, n, n, "whois.nic.sucks", e, f},
	{"supersport", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"supplies", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.supplies", e, t},
	{"supply", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.supply", e, t},
	{"support", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.support", e, t},
	{"surf", r, x, 0x40, "http://nic.surf/", w{"dns1.nic.surf", "dns2.nic.surf", "dns3.nic.surf", "dns4.nic.surf", "dnsa.nic.surf", "dnsb.nic.surf", "dnsc.nic.surf", "dnsd.nic.surf"}, n, n, n, "whois.nic.surf", e, t},
	{"surgery", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.surgery", e, t},
	{"suzuki", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.suzuki", e, t},
	{"sv", r, z[4385:4390], 0xa0, e, w{"a.lactld.org", "auth02.ns.uu.net", "cir.red.sv", "dns-ext.nic.cr", "ns.dns.br", "ns.uu.net", "sir.red.sv", "sv.cctld.authdns.ripe.net"}, n, n, n, e, "http://www.svnet.org.sv/", f},
	{"svr", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"swatch", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.swatch", e, t},
	{"swiftcover", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.swiftcover", "ns2.dns.nic.swiftcover", "ns3.dns.nic.swiftcover", "ns4.dns.nic.swiftcover", "ns5.dns.nic.swiftcover", "ns6.dns.nic.swiftcover"}, n, n, n, "whois.nic.swiftcover", e, t},
	{"swiss", r, x, 0x50, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net", "g.nic.swiss", "ns15.rcode0.net", "u.nic.swiss"}, n, n, n, "whois.nic.swiss", e, t},
	{"sx", r, x, 0xa0, "https://en.wikipedia.org/wiki/.sx", w{"ns1.ns.sx", "ns2.ns.sx"}, n, n, n, "whois.sx", e, f},
	{"sy", r, z[4390:4396], 0xa0, "http://www.ste.gov.sy/", w{"ns1.tld.sy", "pch.anycast.tld.sy", "sy.cctld.authdns.ripe.net"}, n, n, n, "whois.tld.sy", e, f},
	{"sydney", r, x, 0xc4, "https://www.iconic.sydney/", w{"a.nic.sydney", "b.nic.sydney", "c.nic.sydney", "d.nic.sydney"}, n, w{"Sydney"}, n, "whois.nic.sydney", e, f},
	{"symantec", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.symantec", e, t},
	{"systems", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.systems", e, t},
	{"sz", r, z[4396:4399], 0xa0, e, w{"ns1.sispa.org.sz", "rip.psg.com", "sz.cctld.authdns.ripe.net"}, n, n, n, e, e, f},
	{"tab", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.tab", "b.nic.tab", "c.nic.tab", "d.nic.tab"}, n, n, n, "whois.nic.tab", e, f},
	{"taipei", r, x, 0xc4, "https://newgtlds.icann.org/", w{"ns1.dns.nic.taipei", "ns2.dns.nic.taipei", "ns3.dns.nic.taipei", "ns4.dns.nic.taipei", "ns5.dns.nic.taipei", "ns6.dns.nic.taipei"}, n, w{"Taipei", "TW-TPQ"}, n, "whois.nic.taipei", e, t},
	{"talk", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.talk", "dns2.nic.talk", "dns3.nic.talk", "dns4.nic.talk", "dnsa.nic.talk", "dnsb.nic.talk", "dnsc.nic.talk", "dnsd.nic.talk"}, n, n, n, "whois.nic.talk", e, t},
	{"taobao", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.taobao", "ns2.dns.nic.taobao", "ns3.dns.nic.taobao", "ns4.dns.nic.taobao", "ns5.dns.nic.taobao", "ns6.dns.nic.taobao"}, n, n, n, "whois.nic.taobao", e, t},
	{"target", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.target", "ns2.dns.nic.target", "ns3.dns.nic.target", "ns4.dns.nic.target", "ns5.dns.nic.target", "ns6.dns.nic.target"}, n, n, n, "whois.nic.target", e, t},
	{"tata", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"tatamotors", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.tatamotors", e, f},
	{"tatar", r, x, 0x440, "https://newgtlds.icann.org/", w{"a.dns.ripn.net", "b.dns.ripn.net", "d.dns.ripn.net", "e.dns.ripn.net", "f.dns.ripn.net"}, n, w{"RU-TA"}, n, "whois.nic.tatar", e, f},
	{"tattoo", r, x, 0x40, "https://nic.tattoo/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.uniregistry.net", e, t},
	{"tax", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.tax", e, t},
	{"taxi", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.taxi", e, t},
	{"tc", r, z[4399:4432], 0xa0, e, w{"root1.zone.tc", "root2.zone.tc", "root3.zone.tc", "root4.zone.tc", "root5.zone.tc", "root6.zone.tc", "root7.zone.tc", "root8.zone.tc"}, n, n, n, "whois.nic.tc", e, f},
	{"tci", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.ns.nic.tci", "b.ns.nic.tci", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, "whois.nic.tci", e, f},
	{"td", r, z[4432:4436], 0xa0, "http://nic.td/", w{"anycastdns1.nic.td", "anycastdns2.nic.td", "ns-td.afrinic.net", "pch.nic.td"}, n, n, n, "whois.nic.td", e, f},
	{"tdk", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.tdk", "ns2.dns.nic.tdk", "ns3.dns.nic.tdk", "ns4.dns.nic.tdk", "ns5.dns.nic.tdk", "ns6.dns.nic.tdk"}, n, n, n, "whois.nic.tdk", e, t},
	{"team", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.team", e, t},
	{"tech", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.tech", "b.nic.tech", "e.nic.tech", "f.nic.tech"}, n, n, n, "whois.nic.tech", e, t},
	{"technology", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.technology", e, t},
	{"tel", r, x, 0x1040, e, w{"ns1.dns.nic.tel", "ns2.dns.nic.tel", "ns3.dns.nic.tel", "ns4.dns.nic.tel", "ns5.dns.nic.tel", "ns6.dns.nic.tel", "ns7.dns.nic.tel", "ns8.dns.nic.tel"}, n, n, n, "whois.nic.tel", e, t},
	{"telecity", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.telecity", e, f},
	{"telefonica", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois-fe.telefonica.tango.knipp.de", e, f},
	{"temasek", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.temasek", "a2.nic.temasek", "b0.nic.temasek", "c0.nic.temasek"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"tennis", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.tennis", e, t},
	{"terra", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"teva", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.teva", "ns2.dns.nic.teva", "ns3.dns.nic.teva", "ns4.dns.nic.teva", "ns5.dns.nic.teva", "ns6.dns.nic.teva"}, n, n, n, "whois.nic.teva", e, t},
	{"tf", r, z[4436:4450], 0xa0, e, w{"d.nic.fr", "e.ext.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, n, n, "whois.nic.tf", e, t},
	{"tg", r, x, 0xa0, "http://www.nic.tg/", w{"ns1.admin.net", "ns1.nic.tg", "ns2.admin.net", "ns2.nic.tg", "ns3.admin.net", "ns4.admin.net", "ns5.admin.net", "tld.cafe.tg"}, n, n, n, "whois.nic.tg", e, f},
	{"th", r, z[4450:4457], 0xa8, "https://www.thnic.co.th/", w{"a.thains.co.th", "b.thains.co.th", "c.thains.co.th", "ns.thnic.net", "p.thains.co.th"}, n, n, n, "whois.thnic.co.th", e, t},
	{"thai", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"thd", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.thd", "a2.nic.thd", "b0.nic.thd", "c0.nic.thd"}, n, n, n, "whois.nic.thd", e, f},
	{"theater", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.theater", e, t},
	{"theatre", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.theatre", "b.nic.theatre", "c.nic.theatre", "d.nic.theatre"}, n, n, n, "whois.nic.theatre", e, t},
	{"theguardian", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"thehartford", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"tiaa", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.tiaa", e, f},
	{"tickets", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.tickets", "b.nic.tickets", "c.nic.tickets", "d.nic.tickets"}, n, n, n, "whois.nic.tickets", e, t},
	{"tienda", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.tienda", e, t},
	{"tiffany", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.tiffany", e, t},
	{"tiffay", r, x, 0, e, n, n, n, n, "whois.nic.tiffany", e, t},
	{"tiia", r, x, 0, e, n, n, n, n, e, e, t},
	{"tips", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.tips", e, t},
	{"tires", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.tires", e, t},
	{"tirol", r, x, 0x440, "https://newgtlds.icann.org/", w{"dns.ryce-rsp.com", "ns1.dns.business", "ns1.ryce-rsp.com"}, n, w{"AT-7"}, n, "whois.nic.tirol", e, t},
	{"tj", r, z[4457:4478], 0xa0, e, w{"ns1.nic.tj", "ns2.tojikiston.com", "phloem.uoregon.edu", "tj.cctld.authdns.ripe.net"}, n, n, n, e, "http://www.nic.tj/whois.html", f},
	{"tjmaxx", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.tjmaxx", "ns2.dns.nic.tjmaxx", "ns3.dns.nic.tjmaxx", "ns4.dns.nic.tjmaxx", "ns5.dns.nic.tjmaxx", "ns6.dns.nic.tjmaxx"}, n, n, n, "whois.nic.tjmaxx", e, f},
	{"tjx", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.tjx", "ns2.dns.nic.tjx", "ns3.dns.nic.tjx", "ns4.dns.nic.tjx", "ns5.dns.nic.tjx", "ns6.dns.nic.tjx"}, n, n, n, "whois.nic.tjx", e, f},
	{"tk", r, x, 0xa0, e, w{"a.ns.tk", "b.ns.tk", "c.ns.tk", "d.ns.tk"}, n, n, n, "whois.dot.tk", e, t},
	{"tkmaxx", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.tkmaxx", "ns2.dns.nic.tkmaxx", "ns3.dns.nic.tkmaxx", "ns4.dns.nic.tkmaxx", "ns5.dns.nic.tkmaxx", "ns6.dns.nic.tkmaxx"}, n, n, n, "whois.nic.tkmaxx", e, f},
	{"tl", r, z[4478:4485], 0xa0, e, w{"ns.anycast.nic.tl", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, "whois.nic.tl", e, f},
	{"tm", r, z[4485:4493], 0xa0, "http://nic.tm/", w{"ns-a1.tm", "ns-a2.tm", "ns-a3.tm", "ns-a4.tm", "ns-d1.tm", "ns-l1.tm", "ns-y1.tm"}, n, n, n, "whois.nic.tm", e, t},
	{"tmall", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.tmall", "ns2.dns.nic.tmall", "ns3.dns.nic.tmall", "ns4.dns.nic.tmall", "ns5.dns.nic.tmall", "ns6.dns.nic.tmall"}, n, n, n, "whois.nic.tmall", e, t},
	{"tn", r, z[4493:4512], 0xa0, e, w{"ns-tn.afrinic.net", "ns1.ati.tn", "ns2.ati.tn", "ns2.nic.fr", "pch.ati.tn", "rip.psg.com"}, n, n, n, "whois.ati.tn", e, f},
	{"to", r, x, 0xa0, "https://www.tonic.to/", w{"colo.tonic.to", "frankfurt.tonic.to", "helsinki.tonic.to", "newyork.tonic.to", "singapore.tonic.to", "sydney.tonic.to", "tonic.to"}, n, n, n, "whois.tonic.to", e, t},
	{"today", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.today", e, t},
	{"tokyo", r, x, 0xc4, e, w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, w{"Tokyo", "JP-13"}, n, "whois.nic.tokyo", e, t},
	{"tools", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.tools", e, t},
	{"top", r, x, 0x40, "http://www.nic.top/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.nic.top", e, t},
	{"toray", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.toray", e, t},
	{"toshiba", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.toshiba", e, t},
	{"total", r, x, 0x42, "https://newgtlds.icann.org/", w{"d.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, n, n, "whois.nic.total", e, t},
	{"tour", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"tours", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.tours", e, t},
	{"town", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.town", e, t},
	{"toyota", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.toyota", e, t},
	{"toys", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.toys", e, t},
	{"tp", r, z[4512:4515], 0x8a0, e, n, n, n, n, e, e, f},
	{"tr", r, z[4515:4536], 0xa8, "https://www.nic.tr/", w{"ns31.nic.tr", "ns34.nic.tr", "ns35.nic.tr", "ns41.nic.tr", "ns42.nic.tr", "ns61.nic.tr", "ns71.nic.tr"}, n, n, n, "whois.nic.tr", e, t},
	{"trade", r, x, 0x40, "https://www.famousfourmedia.com/", w{"ns1.dns.nic.trade", "ns2.dns.nic.trade", "ns3.dns.nic.trade", "ns4.dns.nic.trade", "ns5.dns.nic.trade", "ns6.dns.nic.trade"}, n, n, n, "whois.nic.trade", e, t},
	{"tradershotels", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"trading", r, x, 0x40, "https://bostonivy.co/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.trading", e, f},
	{"training", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.training", e, t},
	{"transformers", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"translations", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"transunion", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"travel", r, x, 0x1040, "https://www.travel.domains/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.travel", e, f},
	{"travelchannel", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.travelchannel", e, f},
	{"travelers", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.travelers", "a2.nic.travelers", "b0.nic.travelers", "c0.nic.travelers"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"travelersinsurance", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.travelersinsurance", "a2.nic.travelersinsurance", "b0.nic.travelersinsurance", "c0.nic.travelersinsurance"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"travelguard", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"trust", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.nic.trust", e, f},
	{"trv", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.trv", "a2.nic.trv", "b0.nic.trv", "c0.nic.trv"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"tt", r, z[4536:4568], 0xa0, e, w{"a.lactld.org", "ns3.nic.mx", "pch.nic.tt", "ripe.nic.tt"}, n, n, n, e, "http://www.nic.tt/cgi-bin/search.pl", f},
	{"tube", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.tube", "ns2.dns.nic.tube", "ns3.dns.nic.tube", "ns4.dns.nic.tube", "ns5.dns.nic.tube", "ns6.dns.nic.tube"}, n, n, n, "whois.nic.tube", e, f},
	{"tui", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.tui", "b.nic.tui", "c.nic.tui", "d.nic.tui"}, n, n, n, "whois.nic.tui", e, f},
	{"tunes", r, x, 0x48, "https://newgtlds.icann.org/", w{"dns1.nic.tunes", "dns2.nic.tunes", "dns3.nic.tunes", "dns4.nic.tunes", "dnsa.nic.tunes", "dnsb.nic.tunes", "dnsc.nic.tunes", "dnsd.nic.tunes"}, n, n, n, "whois.nic.tunes", e, t},
	{"tushu", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.tushu", "dns2.nic.tushu", "dns3.nic.tushu", "dns4.nic.tushu", "dnsa.nic.tushu", "dnsb.nic.tushu", "dnsc.nic.tushu", "dnsd.nic.tushu"}, n, n, n, "whois.nic.tushu", e, t},
	{"tv", r, x, 0xe0, e, w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "tvwhois.verisign-grs.com", e, t},
	{"tvs", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.tvs", "a2.nic.tvs", "b0.nic.tvs", "c0.nic.tvs"}, n, n, n, "whois.nic.tvs", e, f},
	{"tw", r, z[4568:4581], 0xa0, e, w{"a.dns.tw", "anytld.apnic.net", "b.dns.tw", "c.dns.tw", "d.dns.tw", "e.dns.tw", "f.dns.tw", "g.dns.tw", "h.dns.tw", "ns.twnic.net"}, n, n, n, "whois.twnic.net.tw", e, t},
	{"tz", r, z[4581:4593], 0xa8, e, w{"d.ext.nic.cz", "fork.sth.dnsnode.net", "ns-tz.afrinic.net", "ns.anycast.co.tz", "ns2.tznic.or.tz", "rip.psg.com"}, n, n, n, "whois.tznic.or.tz", e, f},
	{"ua", r, z[4593:4659], 0xa0, "http://www.nic.net.ua/", w{"cd1.ns.ua", "ho1.ns.ua", "in1.ns.ua", "pch.ns.ua"}, n, n, n, "whois.ua", e, t},
	{"ubank", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.ubank", e, f},
	{"ubs", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.ubs", e, f},
	{"uconnect", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.afilias-srs.net", e, f},
	{"ug", r, z[4659:4668], 0xa0, e, w{"anycast.eahd.or.ug", "ns-ug.afrinic.net", "ns.icann.org", "root.eahd.or.ug", "ug.cctld.authdns.ripe.net"}, n, n, n, "whois.co.ug", e, f},
	{"uk", r, z[4668:4678], 0xa0, "https://www.nominet.uk/", w{"dns1.nic.uk", "dns2.nic.uk", "dns3.nic.uk", "dns4.nic.uk", "nsa.nic.uk", "nsb.nic.uk", "nsc.nic.uk", "nsd.nic.uk"}, n, n, n, "whois.nic.uk", e, f},
	{"ultrabook", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"um", r, x, 0x8a0, e, n, n, n, n, e, e, f},
	{"ummah", r, x, 0x2042, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"unicom", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.nic.unicom", e, f},
	{"unicorn", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"university", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.university", e, t},
	{"uno", r, x, 0x40, e, w{"a.nic.uno", "b.nic.uno", "c.nic.uno", "d.nic.uno"}, n, n, n, "whois.nic.uno", e, f},
	{"uol", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, "whois.gtlds.nic.br", e, t},
	{"ups", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.ups", "a2.nic.ups", "b0.nic.ups", "c0.nic.ups"}, n, n, n, "whois.nic.ups", e, f},
	{"us", r, z[4678:4738], 0xa0, e, w{"a.cctld.us", "b.cctld.us", "c.cctld.us", "e.cctld.us", "f.cctld.us", "k.cctld.us"}, n, n, n, "whois.nic.us", e, f},
	{"uy", r, z[4738:4744], 0xa0, e, w{"a.lactld.org", "a.nic.uy", "b.nic.uy", "d.nic.uy", "ns.dns.br", "ns1.anteldata.com.uy", "ns2.anteldata.com.uy", "ns3.nic.mx"}, n, n, n, "whois.nic.org.uy", e, f},
	{"uz", r, z[4744:4758], 0xa0, e, w{"ns1.uz", "ns2.uz", "ns3.uz", "ns4.uz", "ns5.uz", "ns6.uz", "ns7.uz"}, n, n, n, "whois.cctld.uz", e, f},
	{"va", r, x, 0xa0, e, w{"dns.nic.it", "john.vatican.va", "michael.vatican.va", "osiris.namex.it", "seth.namex.it", "va.cctld.authdns.ripe.net"}, n, n, n, "whois.iana.org", e, f},
	{"vacations", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.vacations", e, t},
	{"vana", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.vana", e, f},
	{"vanguard", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.vanguard", e, f},
	{"vanish", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"vc", r, z[4758:4761], 0xe0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, "whois2.afilias-grs.net", e, f},
	{"ve", r, z[4761:4772], 0xa8, e, w{"ns3.nic.ve", "ns4.nic.ve", "ns5.nic.ve", "ns6.nic.ve", "ssdns-tld.nic.cl"}, n, n, n, "whois.nic.ve", e, t},
	{"vegas", r, x, 0xc4, "http://nic.vegas/", w{"a0.nic.vegas", "a2.nic.vegas", "b0.nic.vegas", "c0.nic.vegas"}, n, w{"Las Vegas"}, n, "whois.afilias-srs.net", e, f},
	{"ventures", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.ventures", e, t},
	{"verisign", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.verisign", e, t},
	{"xn--vermgensberater-ctb" /* vermögensberater */, r, x, 0x48, "https://newgtlds.icann.org/", w{"a.nic.xn--vermgensberater-ctb", "b.nic.xn--vermgensberater-ctb", "c.nic.xn--vermgensberater-ctb", "d.nic.xn--vermgensberater-ctb"}, n, n, n, "whois.nic.xn--vermgensberater-ctb", e, f},
	{"xn--vermgensberatung-pwb" /* vermögensberatung */, r, x, 0x48, "https://newgtlds.icann.org/", w{"a.nic.xn--vermgensberatung-pwb", "b.nic.xn--vermgensberatung-pwb", "c.nic.xn--vermgensberatung-pwb", "d.nic.xn--vermgensberatung-pwb"}, n, n, n, "whois.nic.xn--vermgensberatung-pwb", e, f},
	{"versicherung", r, x, 0x40, e, w{"a.dns.nic.versicherung", "m.dns.nic.versicherung", "n.dns.nic.versicherung"}, n, n, n, "whois.nic.versicherung", e, t},
	{"vet", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.vet", e, t},
	{"vg", r, z[4772:4773], 0xa0, e, w{"a.nic.vg", "b.nic.vg", "c.nic.vg", "d.nic.vg"}, w{"88.198.29.97"}, n, n, "whois.nic.vg", e, f},
	{"vi", r, z[4773:4779], 0xa8, "https://secure.nic.vi/", w{"auth100.ns.uu.net", "auth110.ns.uu.net", "ns3.nic.vi", "pch.nic.vi"}, n, n, n, e, "https://secure.nic.vi/whois-lookup/", f},
	{"viajes", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.viajes", e, t},
	{"video", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.video", e, t},
	{"vig", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.vig", "a2.nic.vig", "b0.nic.vig", "c0.nic.vig"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"viking", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.viking", "a2.nic.viking", "b0.nic.viking", "c0.nic.viking"}, n, n, n, "whois.afilias-srs.net", e, f},
	{"villas", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.villas", e, t},
	{"vin", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.vin", e, t},
	{"vip", r, x, 0x40, "http://nic.vip/", w{"dns1.nic.vip", "dns2.nic.vip", "dns3.nic.vip", "dns4.nic.vip", "dnsa.nic.vip", "dnsb.nic.vip", "dnsc.nic.vip", "dnsd.nic.vip"}, n, n, n, "whois.nic.vip", e, t},
	{"virgin", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.virgin", "dns2.nic.virgin", "dns3.nic.virgin", "dns4.nic.virgin", "dnsa.nic.virgin", "dnsb.nic.virgin", "dnsc.nic.virgin", "dnsd.nic.virgin"}, n, n, n, "whois.nic.virgin", e, f},
	{"visa", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.visa", e, t},
	{"vision", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.vision", e, t},
	{"vista", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.vista", e, f},
	{"vistaprint", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.vistaprint", e, f},
	{"viva", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.viva", "b.nic.viva", "c.nic.viva", "d.nic.viva"}, n, n, n, "whois.nic.viva", e, f},
	{"vivo", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.vivo", "ns2.dns.nic.vivo", "ns3.dns.nic.vivo", "ns4.dns.nic.vivo", "ns5.dns.nic.vivo", "ns6.dns.nic.vivo"}, n, n, n, "whois.nic.vivo", e, t},
	{"vlaanderen", r, x, 0x440, "https://newgtlds.icann.org/", w{"a.nsset.vlaanderen", "b.nsset.vlaanderen", "c.nsset.vlaanderen", "d.nsset.vlaanderen", "y.nsset.vlaanderen", "z.nsset.vlaanderen"}, n, w{"BE-VLG"}, n, "whois.nic.vlaanderen", e, t},
	{"vn", r, z[4779:4791], 0xa0, e, w{"a.dns-servers.vn", "b.dns-servers.vn", "c.dns-servers.vn", "d.dns-servers.vn", "e.dns-servers.vn", "f.dns-servers.vn", "g.dns-servers.vn"}, n, n, n, e, "http://www.vnnic.vn/en/domain", t},
	{"vodka", r, x, 0x40, "http://nic.vodka/", w{"dns1.nic.vodka", "dns2.nic.vodka", "dns3.nic.vodka", "dns4.nic.vodka", "dnsa.nic.vodka", "dnsb.nic.vodka", "dnsc.nic.vodka", "dnsd.nic.vodka"}, n, n, n, "whois.nic.vodka", e, t},
	{"volkswagen", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.volkswagen", "a2.nic.volkswagen", "b0.nic.volkswagen", "c0.nic.volkswagen"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"volvo", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.volvo", e, f},
	{"vons", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"vote", r, x, 0x40, "https://get.vote/", w{"a0.nic.vote", "a2.nic.vote", "b0.nic.vote", "c0.nic.vote"}, n, n, n, "whois.afilias.net", e, t},
	{"voting", r, x, 0x40, e, w{"a.nic.voting", "b.nic.voting", "c.nic.voting", "d.nic.voting"}, n, n, n, "whois.nic.voting", e, t},
	{"voto", r, x, 0x40, "https://get.voto/", w{"a0.nic.voto", "a2.nic.voto", "b0.nic.voto", "c0.nic.voto"}, n, n, n, "whois.afilias.net", e, t},
	{"voyage", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.voyage", e, t},
	{"vu", r, z[4791:4796], 0xa0, e, w{"ns1.neustar.vu", "ns2.neustar.vu", "ns3.neustar.vu", "ns4.neustar.vu"}, n, n, n, "whois.dnrs.neustar", e, f},
	{"vuelos", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.vuelos", "ns2.dns.nic.vuelos", "ns3.dns.nic.vuelos", "ns4.dns.nic.vuelos", "ns5.dns.nic.vuelos", "ns6.dns.nic.vuelos"}, n, n, n, "whois.nic.vuelos", e, t},
	{"wales", r, x, 0x4c0, "https://ourhomeonline.wales/", w{"dns1.nic.wales", "dns2.nic.wales", "dns3.nic.wales", "dns4.nic.wales", "dnsa.nic.wales", "dnsb.nic.wales", "dnsc.nic.wales", "dnsd.nic.wales"}, n, w{"GB-WLS"}, n, "whois.nic.wales", e, t},
	{"walmart", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.walmart", e, f},
	{"walter", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.walter", "b.nic.walter", "c.nic.walter", "d.nic.walter"}, n, n, n, "whois.nic.walter", e, t},
	{"wang", r, x, 0x40, e, w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.gtld.knet.cn", e, t},
	{"wanggou", r, x, 0x48, "https://newgtlds.icann.org/", w{"dns1.nic.wanggou", "dns2.nic.wanggou", "dns3.nic.wanggou", "dns4.nic.wanggou", "dnsa.nic.wanggou", "dnsb.nic.wanggou", "dnsc.nic.wanggou", "dnsd.nic.wanggou"}, n, n, n, "whois.nic.wanggou", e, t},
	{"warman", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.warman", e, f},
	{"watch", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.watch", e, t},
	{"watches", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.watches", "a2.nic.watches", "b0.nic.watches", "c0.nic.watches"}, n, n, n, "whois.nic.watches", e, t},
	{"weather", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.weather", "ns2.dns.nic.weather", "ns3.dns.nic.weather", "ns4.dns.nic.weather", "ns5.dns.nic.weather", "ns6.dns.nic.weather"}, n, n, n, "whois.nic.weather", e, t},
	{"weatherchannel", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.weatherchannel", "ns2.dns.nic.weatherchannel", "ns3.dns.nic.weatherchannel", "ns4.dns.nic.weatherchannel", "ns5.dns.nic.weatherchannel", "ns6.dns.nic.weatherchannel"}, n, n, n, "whois.nic.weatherchannel", e, f},
	{"web", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"webcam", r, x, 0x40, "https://www.famousfourmedia.com/", w{"ns1.dns.nic.webcam", "ns2.dns.nic.webcam", "ns3.dns.nic.webcam", "ns4.dns.nic.webcam", "ns5.dns.nic.webcam", "ns6.dns.nic.webcam"}, n, n, n, "whois.nic.webcam", e, t},
	{"weber", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.weber", e, t},
	{"webjet", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"webs", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"website", r, x, 0x40, e, w{"a.nic.website", "b.nic.website", "e.nic.website", "f.nic.website"}, n, n, n, "whois.nic.website", e, t},
	{"wed", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.emdns.uk", "dns2.emdns.uk", "dns3.emdns.uk", "dns4.emdns.uk", "dnsa.emdns.uk", "dnsb.emdns.uk", "dnsc.emdns.uk", "dnsd.emdns.uk"}, n, n, n, "whois.nic.wed", e, f},
	{"wedding", r, x, 0x40, "http://nic.wedding/", w{"dns1.nic.wedding", "dns2.nic.wedding", "dns3.nic.wedding", "dns4.nic.wedding", "dnsa.nic.wedding", "dnsb.nic.wedding", "dnsc.nic.wedding", "dnsd.nic.wedding"}, n, n, n, "whois.nic.wedding", e, t},
	{"weibo", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.weibo", "a2.nic.weibo", "b0.nic.weibo", "c0.nic.weibo"}, n, n, n, "whois.nic.weibo", e, t},
	{"weir", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, f},
	{"wf", r, x, 0xa0, e, w{"d.nic.fr", "e.ext.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, n, n, "whois.nic.wf", e, t},
	{"whoswho", r, x, 0x40, "https://newgtlds.icann.org/", w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.whoswho", e, t},
	{"wien", r, x, 0xc4, e, w{"dns.ryce-rsp.com", "ns1.dns.business", "ns1.ryce-rsp.com"}, n, w{"Vienna", "AT-9"}, n, "whois.nic.wien", e, t},
	{"wiki", r, x, 0x40, e, w{"a.nic.wiki", "b.nic.wiki", "c.nic.wiki", "d.nic.wiki"}, n, n, n, "whois.nic.wiki", e, t},
	{"williamhill", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.dns.nic.williamhill", "ns2.dns.nic.williamhill", "ns3.dns.nic.williamhill", "ns4.dns.nic.williamhill", "ns5.dns.nic.williamhill", "ns6.dns.nic.williamhill"}, n, n, n, "whois.nic.williamhill", e, f},
	{"wilmar", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"win", r, x, 0x40, "https://www.famousfourmedia.com/", w{"ns1.dns.nic.win", "ns2.dns.nic.win", "ns3.dns.nic.win", "ns4.dns.nic.win", "ns5.dns.nic.win", "ns6.dns.nic.win"}, n, n, n, "whois.nic.win", e, t},
	{"windows", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, t},
	{"wine", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.wine", e, t},
	{"winners", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.winners", "ns2.dns.nic.winners", "ns3.dns.nic.winners", "ns4.dns.nic.winners", "ns5.dns.nic.winners", "ns6.dns.nic.winners"}, n, n, n, "whois.nic.winners", e, f},
	{"wme", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.wme", "b.nic.wme", "c.nic.wme", "d.nic.wme"}, n, n, n, "whois.nic.wme", e, t},
	{"wolterskluwer", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.wolterskluwer", "a2.nic.wolterskluwer", "b0.nic.wolterskluwer", "c0.nic.wolterskluwer"}, n, n, n, "whois.nic.wolterskluwer", e, t},
	{"woodside", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.woodside", "b.nic.woodside", "c.nic.woodside", "d.nic.woodside"}, n, n, n, "whois.nic.woodside", e, f},
	{"work", r, x, 0x40, "http://nic.work/", w{"dns1.nic.work", "dns2.nic.work", "dns3.nic.work", "dns4.nic.work", "dnsa.nic.work", "dnsb.nic.work", "dnsc.nic.work", "dnsd.nic.work"}, n, n, n, "whois.nic.work", e, t},
	{"works", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.works", e, t},
	{"world", r, x, 0x40, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.world", e, t},
	{"wow", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.wow", "dns2.nic.wow", "dns3.nic.wow", "dns4.nic.wow", "dnsa.nic.wow", "dnsb.nic.wow", "dnsc.nic.wow", "dnsd.nic.wow"}, n, n, n, "whois.nic.wow", e, t},
	{"ws", r, z[4796:4801], 0xe0, "https://www.worldsite.ws/", w{"ns2.dns.ws", "ns3.dns.ws", "ns4.dns.ws", "ns5.dns.ws", "ns6.dns.ws", "ns7.dns.ws"}, w{"64.70.19.203"}, n, n, "whois.website.ws", e, t},
	{"wtc", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.nic.wtc", "b.nic.wtc", "c.nic.wtc", "d.nic.wtc"}, n, n, n, "whois.nic.wtc", e, f},
	{"wtf", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.wtf", e, t},
	{"xbox", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, e, e, t},
	{"xerox", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.xerox", e, f},
	{"xfinity", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.xfinity", "dns2.nic.xfinity", "dns3.nic.xfinity", "dns4.nic.xfinity", "dnsa.nic.xfinity", "dnsb.nic.xfinity", "dnsc.nic.xfinity", "dnsd.nic.xfinity"}, n, n, n, "whois.nic.xfinity", e, f},
	{"xihuan", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.teleinfo.cn", "ns2.teleinfoo.com", "ns3.teleinfo.cn", "ns4.teleinfoo.com"}, n, n, n, "whois.teleinfo.cn", e, f},
	{"xin", r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.xin", "a2.nic.xin", "b0.nic.xin", "c0.nic.xin"}, n, n, n, "whois.nic.xin", e, f},
	{"xperia", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.xperia", e, f},
	{"xxx", r, x, 0x41, "https://nic.xxx/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns5.uniregistry.net", "ns6.uniregistry.info"}, n, n, n, "whois.registrar.adult", e, t},
	{"xyz", r, x, 0x40, e, w{"generationxyz.nic.xyz", "x.nic.xyz", "y.nic.xyz", "z.nic.xyz"}, n, n, n, "whois.nic.xyz", e, t},
	{"yachts", r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.yachts", "b.nic.yachts", "c.nic.yachts", "d.nic.yachts"}, n, n, n, "whois.nic.yachts", e, f},
	{"yahoo", r, x, 0x42, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.yahoo", e, t},
	{"yamaxun", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.yamaxun", "dns2.nic.yamaxun", "dns3.nic.yamaxun", "dns4.nic.yamaxun", "dnsa.nic.yamaxun", "dnsb.nic.yamaxun", "dnsc.nic.yamaxun", "dnsd.nic.yamaxun"}, n, n, n, "whois.nic.yamaxun", e, t},
	{"yandex", r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, "whois.nic.yandex", e, f},
	{"ye", r, z[4801:4809], 0xa8, e, w{"ns1.yemen.net.ye", "ns2.yemen.net.ye", "sah1.ye", "sah2.ye"}, n, n, n, e, e, f},
	{"yellowpages", r, x, 0x48, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"yodobashi", r, x, 0x42, "https://newgtlds.icann.org/", w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, n, n, "whois.nic.gmo", e, t},
	{"yoga", r, x, 0x40, "http://nic.yoga/", w{"dns1.nic.yoga", "dns2.nic.yoga", "dns3.nic.yoga", "dns4.nic.yoga", "dnsa.nic.yoga", "dnsb.nic.yoga", "dnsc.nic.yoga", "dnsd.nic.yoga"}, n, n, n, "whois.nic.yoga", e, t},
	{"yokohama", r, x, 0xc4, e, w{"a.gmoregistry.net", "b.gmoregistry.net", "k.gmoregistry.net", "l.gmoregistry.net"}, n, w{"Yokohama"}, n, "whois.nic.yokohama", e, t},
	{"you", r, x, 0x40, "https://newgtlds.icann.org/", w{"dns1.nic.you", "dns2.nic.you", "dns3.nic.you", "dns4.nic.you", "dnsa.nic.you", "dnsb.nic.you", "dnsc.nic.you", "dnsd.nic.you"}, n, n, n, "whois.nic.you", e, t},
	{"youtube", r, x, 0x42, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"yt", r, x, 0xa0, e, w{"d.nic.fr", "e.ext.nic.fr", "f.ext.nic.fr", "g.ext.nic.fr"}, n, n, n, "whois.nic.yt", e, t},
	{"yu", r, z[4809:4815], 0x8a0, e, n, n, n, n, e, e, f},
	{"yun", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.teleinfo.cn", "ns2.teleinfoo.com", "ns3.teleinfo.cn", "ns4.teleinfoo.com"}, n, n, n, "whois.teleinfo.cn", e, f},
	{"za", r, z[4815:4842], 0xa8, e, w{"nsza.is.co.za", "za-ns.anycast.pch.net", "za1.dnsnode.net"}, n, n, n, "whois.nic.za", e, f},
	{"zappos", r, x, 0x42, "https://newgtlds.icann.org/", w{"dns1.nic.zappos", "dns2.nic.zappos", "dns3.nic.zappos", "dns4.nic.zappos", "dnsa.nic.zappos", "dnsb.nic.zappos", "dnsc.nic.zappos", "dnsd.nic.zappos"}, n, n, n, "whois.nic.zappos", e, t},
	{"zara", r, x, 0x42, "https://newgtlds.icann.org/", w{"a0.nic.zara", "a2.nic.zara", "b0.nic.zara", "c0.nic.zara"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"zero", r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.zero", "ns2.dns.nic.zero", "ns3.dns.nic.zero", "ns4.dns.nic.zero", "ns5.dns.nic.zero", "ns6.dns.nic.zero"}, n, n, n, "whois.nic.zero", e, t},
	{"zip", r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"zippo", r, x, 0x42, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.zippo", e, f},
	{"zm", r, z[4842:4850], 0xa0, e, w{"cocca.nic.zm", "gransy.nic.zm", "pch.nic.zm"}, n, n, n, "whois.zicta.zm", e, f},
	{"zone", r, x, 0x40, e, w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.zone", e, t},
	{"zuerich", r, x, 0xc4, "http://nic.zuerich/", w{"a.nic.zuerich", "b.nic.zuerich", "c.nic.zuerich", "d.nic.zuerich"}, n, w{"Zurich", "CH-ZH"}, w{"de-CH"}, "whois.nic.zuerich", e, t},
	{"zulu", r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, f},
	{"zw", r, z[4850:4854], 0xa0, e, w{"ns1.liquidtelecom.net", "ns1zim.telone.co.zw", "ns2.liquidtelecom.net", "ns2zim.telone.co.zw", "zw-ns.anycast.pch.net"}, n, n, n, e, "http://www.zispa.org.zw/", f},
	{"xn--jxalpdlp" /* δοκιμή */, r, x, 0x40, e, n, n, n, n, e, e, t},
	{"xn--qxam" /* ελ */, r, x, 0, e, w{"estia.ics.forth.gr", "gr-at.ics.forth.gr", "gr-c.ics.forth.gr", "gr-d.ics.forth.gr", "grdns.ics.forth.gr"}, n, n, n, e, "https://grweb.ics.forth.gr/public/whois.jsp?lang=en", t},
	{"xn--qxa6a" /* ευ */, r, x, 0, e, w{"nl.dns.eu", "si.dns.eu", "w.dns.eu", "x.dns.eu", "y.dns.eu"}, n, n, n, "whois.eu", e, t},
	{"xn--90ae" /* бг */, r, x, 0, e, w{"a.nic.bg", "b.nic.bg", "c.nic.bg", "d.nic.bg", "e.nic.bg", "p.nic.bg"}, n, n, n, "whois.imena.bg", e, t},
	{"xn--90ais" /* бел */, r, x, 0x40, e, w{"dns1.tld.hosterby.com", "dns2.tld.hosterby.com", "dns3.tld.hosterby.com", "dns4.tld.hosterby.com", "dns5.tld.hosterby.com", "dns6.tld.hosterby.com"}, n, n, n, "whois.cctld.by", e, t},
	{"xn--d1acj3b" /* дети */, r, x, 0x40, e, w{"a.dns.ripn.net", "b.dns.ripn.net", "d.dns.ripn.net", "e.dns.ripn.net", "f.dns.ripn.net"}, n, n, n, "whois.nic.xn--d1acj3b", e, t},
	{"xn--e1a4c" /* ею */, r, x, 0, e, w{"nl.dns.eu", "si.dns.eu", "w.dns.eu", "x.dns.eu", "y.dns.eu"}, n, n, n, "whois.eu", e, t},
	{"xn--80akhbyknj4f" /* испытание */, r, x, 0x40, e, n, n, n, n, e, e, t},
	{"xn--80aqecdr1a" /* католик */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.xn--80aqecdr1a", "b.nic.xn--80aqecdr1a", "c.nic.xn--80aqecdr1a", "d.nic.xn--80aqecdr1a"}, n, n, n, "whois.nic.xn--80aqecdr1a", e, t},
	{"xn--j1aef" /* ком */, r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.xn--j1aef", e, t},
	{"xn--d1alf" /* мкд */, r, x, 0x40, "https://newgtlds.icann.org/", w{"d.ext.nic.cz", "dns-mk.univie.ac.at", "ns2.arnes.si", "tld1.marnet.mk"}, n, n, n, "whois.marnet.mk", e, t},
	{"xn--l1acc" /* мон */, r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.idn.mn", "ns2.idn.mn", "ns3.idn.mn"}, n, n, n, e, e, t},
	{"xn--80adxhks" /* москва */, r, x, 0xc4, e, w{"a.dns.flexireg.ru", "b.dns.flexireg.net", "c.dns.flexireg.org", "d.dns.flexireg.domains"}, n, w{"Moscow"}, n, "whois.nic.xn--80adxhks", e, t},
	{"xn--80asehdb" /* онлайн */, r, x, 0x40, e, w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.xn--80asehdb", e, t},
	{"xn--c1avg" /* орг */, r, x, 0x40, "https://pir.org/products/opr-domain/", w{"a0.nic.xn--c1avg", "a2.nic.xn--c1avg", "b0.nic.xn--c1avg", "c0.nic.xn--c1avg"}, n, n, n, "whois.publicinterestregistry.net", e, t},
	{"xn--p1acf" /* рус */, r, z[4854:5054], 0x40, "https://newgtlds.icann.org/", w{"ns1.anycastdns.cz", "ns1.nic.xn--p1acf", "ns2.anycastdns.cz", "ns2.nic.xn--p1acf"}, n, n, n, "whois.nic.xn--p1acf", e, t},
	{"xn--p1ai" /* рф */, r, z[5054:5057], 0xa0, "https://cctld.ru/", w{"a.dns.ripn.net", "b.dns.ripn.net", "d.dns.ripn.net", "e.dns.ripn.net", "f.dns.ripn.net"}, n, n, w{"ru-RU"}, "whois.tcinet.ru", e, t},
	{"xn--80aswg" /* сайт */, r, x, 0x40, e, w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.xn--80aswg", e, t},
	{"xn--90a3ac" /* срб */, r, z[5057:5062], 0x40, e, w{"a.nic.rs", "b.nic.rs", "f.nic.rs", "g.nic.rs", "h.nic.rs", "l.nic.rs"}, n, n, n, "whois.rnids.rs", e, t},
	{"xn--j1amh" /* укр */, r, x, 0xe0, "http://uanic.net/", w{"dns1.u-registry.com", "dns2.u-registry.net", "dns3.dotukr.com", "nsi.uanic.net", "tier1.num.net.ua"}, n, n, w{"crh-UA", "mul-Cyrl-UA", "ru-UA", "uk-UA"}, "whois.dotukr.com", e, t},
	{"xn--80ao21a" /* қаз */, r, x, 0x40, e, w{"ns.nic.kz", "ns1.nic.kz"}, n, n, n, "whois.nic.kz", e, t},
	{"xn--y9a3aq" /* հայ */, r, x, 0x40, e, w{"fork.sth.dnsnode.net", "ns-cdn.amnic.net", "ns-pch.amnic.net", "ns-pri.nic.am"}, n, n, n, "whois.amnic.net", e, t},
	{"xn--deba0ad" /* טעסט */, r, x, 0x40, e, n, n, n, n, e, e, t},
	{"xn--4dbrk0ce" /* ישראל */, r, x, 0, e, w{"ilns.ilan.net.il", "lookup.iucc.ac.il", "ns1.ns.il", "ns4.ns.il", "nsa.ns.il", "nsb.ns.il", "nse.ns.il"}, n, n, n, "whois.isoc.org.il", e, t},
	{"xn--9dbq2a" /* קום */, r, x, 0, e, w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.xn--9dbq2a", e, t},
	{"xn--hgbk6aj7f53bba" /* آزمایشی */, r, x, 0x40, e, n, n, n, n, e, e, t},
	{"xn--kgbechtv" /* إختبار */, r, x, 0x40, e, n, n, n, n, e, e, t},
	{"xn--mgbca7dzdo" /* ابوظبي */, r, x, 0x40, "https://newgtlds.icann.org/", w{"gtld.alpha.aridns.net.au", "gtld.beta.aridns.net.au", "gtld.delta.aridns.net.au", "gtld.gamma.aridns.net.au"}, n, n, n, "whois.nic.xn--mgbca7dzdo", e, t},
	{"xn--mgbaakc7dvf" /* اتصالات */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.xn--mgbaakc7dvf", "b.nic.xn--mgbaakc7dvf", "c.nic.xn--mgbaakc7dvf", "d.nic.xn--mgbaakc7dvf"}, n, n, n, "whois.centralnic.com", e, t},
	{"xn--mgba3a3ejt" /* ارامكو */, r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.xn--mgba3a3ejt", "ns2.dns.nic.xn--mgba3a3ejt", "ns3.dns.nic.xn--mgba3a3ejt", "ns4.dns.nic.xn--mgba3a3ejt", "ns5.dns.nic.xn--mgba3a3ejt", "ns6.dns.nic.xn--mgba3a3ejt"}, n, n, n, "whois.nic.xn--mgba3a3ejt", e, t},
	{"xn--mgbayh7gpa" /* الاردن */, r, x, 0x40, e, w{"amra.nic.gov.jo", "jo.cctld.authdns.ripe.net", "jordan1st.nic.gov.jo", "petra.nic.gov.jo", "rip.psg.com"}, n, n, n, e, "http://idn.jo/whois_a.aspx", t},
	{"xn--mgbcpq6gpa1a" /* البحرين */, r, x, 0, e, w{"a.nic.xn--mgbcpq6gpa1a", "b.nic.xn--mgbcpq6gpa1a", "c.nic.xn--mgbcpq6gpa1a", "d.nic.xn--mgbcpq6gpa1a"}, n, n, n, e, e, t},
	{"xn--lgbbat1ad8j" /* الجزائر */, r, x, 0x40, "https://newgtlds.icann.org/", w{"idn1.nic.dz", "idn2.nic.dz"}, n, n, n, "whois.nic.dz", e, t},
	{"xn--mgberp4a5d4ar" /* السعودية */, r, x, 0xa0, e, w{"c1.dns.sa", "c2.dns.sa", "i1.dns.sa", "n1.dns.sa", "p1.dns.sa", "s1.dns.sa", "s2.dns.sa"}, n, n, w{"ar-SA"}, "whois.nic.net.sa", e, t},
	{"xn--mgba7c0bbn0a" /* العليان */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.xn--mgba7c0bbn0a", "b.nic.xn--mgba7c0bbn0a", "c.nic.xn--mgba7c0bbn0a", "d.nic.xn--mgba7c0bbn0a"}, n, n, n, "whois.nic.xn--mgba7c0bbn0a", e, t},
	{"xn--mgbc0a9azcg" /* المغرب */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a.tld.ma", "b.tld.ma", "c.tld.ma", "d.tld.ma", "e.tld.ma", "f.tld.ma", "ns-ma.nic.fr"}, n, n, n, "whois.iam.net.ma", e, t},
	{"xn--mgbaam7a8h" /* امارات */, r, x, 0xa0, e, w{"ns1.aedns.ae", "ns2.aedns.ae", "nsext-pch.aedns.ae"}, n, n, w{"ar-AE"}, "whois.aeda.net.ae", e, t},
	{"xn--mgba3a4f16a" /* ایران */, r, x, 0x40, e, w{"a.nic.ir", "ns.irnic.ir"}, n, n, n, "whois.nic.ir", e, t},
	{"xn--mgbbh1a" /* بارت */, r, z[5062:5063], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, w{"ks-IN"}, "whois.registry.in", e, t},
	{"xn--mgbab2bd" /* بازار */, r, x, 0x40, e, w{"anycast10.irondns.net", "anycast23.irondns.net", "anycast24.irondns.net", "anycast9.irondns.net"}, n, n, n, "whois.nic.xn--mgbab2bd", e, t},
	{"xn--ngbe9e0a" /* بيتك */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.xn--ngbe9e0a", "b.nic.xn--ngbe9e0a", "c.nic.xn--ngbe9e0a", "d.nic.xn--ngbe9e0a"}, n, n, n, "whois.nic.xn--ngbe9e0a", e, t},
	{"xn--mgbbh1a71e" /* بھارت */, r, z[5063:5064], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, w{"ur-IN"}, "whois.registry.in", e, t},
	{"xn--pgbs0dh" /* تونس */, r, x, 0x40, e, w{"ns-tn.afrinic.net", "ns1.ati.tn", "ns2.ati.tn", "ns2.nic.fr", "pch.ati.tn", "rip.psg.com"}, n, n, n, "whois.ati.tn", e, t},
	{"xn--mgbpl2fh" /* سودان */, r, x, 0x40, e, w{"ans1.sis.sd", "pch.sis.sd"}, n, n, n, e, e, t},
	{"xn--ogbpf8fl" /* سورية */, r, x, 0x40, e, w{"ns1.tld.sy", "pch.anycast.tld.sy", "sy.cctld.authdns.ripe.net"}, n, n, n, "whois.tld.sy", e, t},
	{"xn--ngbc5azd" /* شبكة */, r, x, 0x40, "https://www.dotshabaka.com/", w{"a.nic.xn--ngbc5azd", "b.nic.xn--ngbc5azd", "c.nic.xn--ngbc5azd", "d.nic.xn--ngbc5azd"}, n, n, n, "whois.nic.xn--ngbc5azd", e, t},
	{"xn--mgbtx2b" /* عراق */, r, x, 0, e, w{"dyn1.cmc.iq", "dyn2.cmc.iq", "ns1.cmc.iq", "nsp-anycast.cmc.iq"}, n, n, n, "whois.cmc.iq", e, t},
	{"xn--ngbrx" /* عرب */, r, x, 0x40, "https://newgtlds.icann.org/", w{"gtld.alpha.aridns.net.au", "gtld.beta.aridns.net.au", "gtld.delta.aridns.net.au", "gtld.gamma.aridns.net.au"}, n, n, n, "whois.nic.xn--ngbrx", e, t},
	{"xn--mgb9awbf" /* عمان */, r, x, 0x40, "https://newgtlds.icann.org/", w{"cctld.alpha.aridns.net.au", "cctld.beta.aridns.net.au", "cctld.delta.aridns.net.au", "cctld.gamma.aridns.net.au", "ns1.registry.om", "ns2.registry.om"}, n, n, n, "whois.registry.om", e, t},
	{"xn--ygbi2ammx" /* فلسطين */, r, x, 0x40, e, w{"dns1.gov.ps", "dns3.gov.ps", "idn.pnina.ps", "ns1.pnina.ps"}, n, n, n, "whois.pnina.ps", e, t},
	{"xn--wgbl6a" /* قطر */, r, x, 0x40, e, w{"a.registry.qa", "b.registry.qa", "c.registry.qa", "d.registry.qa", "e.registry.qa", "f.registry.qa", "g.registry.qa", "h.registry.qa", "i.registry.qa"}, n, n, n, "whois.registry.qa", e, t},
	{"xn--mgbi4ecexp" /* كاثوليك */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.xn--mgbi4ecexp", "b.nic.xn--mgbi4ecexp", "c.nic.xn--mgbi4ecexp", "d.nic.xn--mgbi4ecexp"}, n, n, n, "whois.nic.xn--mgbi4ecexp", e, t},
	{"xn--fhbei" /* كوم */, r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.xn--fhbei", e, t},
	{"xn--pgb3ceoj" /* كيوتل */, r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, t},
	{"xn--wgbh1c" /* مصر */, r, x, 0xa0, e, w{"ns1.dotmasr.eg", "ns2.dotmasr.eg", "ns3.dotmasr.eg"}, n, n, w{"ar-EG"}, "whois.dotmasr.eg", e, t},
	{"xn--mgbx4cd0ab" /* مليسيا */, r, x, 0x40, e, w{"a.mynic.centralnic-dns.com", "a.nic.my", "a1.nic.my", "b.mynic.centralnic-dns.com", "c.mynic.centralnic-dns.com", "d.mynic.centralnic-dns.com"}, n, n, n, "whois.mynic.my", e, t},
	{"xn--mgbb9fbpob" /* موبايلي */, r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.xn--mgbb9fbpob", e, t},
	{"xn--mgbah1a3hjkrd" /* موريتانيا */, r, x, 0, e, w{"ns-mr.afrinic.net", "ns-mr.nic.fr", "ns1.nic.mr", "ns2.nic.mr", "ns3.nic.mr"}, n, n, n, "whois.nic.mr", e, t},
	{"xn--mgbv6cfpo" /* موزايك */, r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, t},
	{"xn--4gbrim" /* موقع */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.xn--4gbrim", "a2.nic.xn--4gbrim", "b0.nic.xn--4gbrim", "c0.nic.xn--4gbrim"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"xn--mgbt3dhd" /* همراه */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a.ns.nic.xn--mgbt3dhd", "b.ns.nic.xn--mgbt3dhd", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, w{"Iran"}, n, "whois.nic.xn--mgbt3dhd", e, t},
	{"xn--mgbai9azgqp6j" /* پاکستان */, r, x, 0, e, w{"ns.ntc.net.pk", "ns1.ntc.net.pk", "ns2.ntc.net.pk"}, n, n, n, e, e, t},
	{"xn--mgbgu82a" /* ڀارت */, r, z[5064:5065], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, w{"sd-IN"}, "whois.registry.in", e, t},
	{"xn--11b4c3d" /* कॉम */, r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.xn--11b4c3d", e, t},
	{"xn--c2br7g" /* नेट */, r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.xn--c2br7g", e, t},
	{"xn--11b5bs3a9aj6g" /* परीक्षा */, r, x, 0x40, e, n, n, n, n, e, e, t},
	{"xn--h2brj9c" /* भारत */, r, z[5065:5066], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, w{"hi-IN"}, "whois.registry.in", e, t},
	{"xn--h2breg3eve" /* भारतम् */, r, z[5066:5067], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, w{"sa-IN"}, "whois.registry.in", e, t},
	{"xn--h2brj9c8c" /* भारोत */, r, z[5067:5068], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, w{"sat-Olck-IN"}, "whois.registry.in", e, t},
	{"xn--i1b6b1a6a2e" /* संगठन */, r, x, 0x40, "https://pir.org/products/hindi-domain/", w{"a0.nic.xn--i1b6b1a6a2e", "a2.nic.xn--i1b6b1a6a2e", "b0.nic.xn--i1b6b1a6a2e", "c0.nic.xn--i1b6b1a6a2e"}, n, n, n, "whois.publicinterestregistry.net", e, t},
	{"xn--54b7fta0cc" /* বাংলা */, r, x, 0, e, w{"bayanno.btcl.net.bd", "bd-ns.anycast.pch.net", "ekushey.btcl.net.bd"}, n, n, n, e, e, t},
	{"xn--45brj9c" /* ভারত */, r, z[5068:5070], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, w{"bn-IN"}, "whois.registry.in", e, t},
	{"xn--45br5cyl" /* ভাৰত */, r, z[5070:5071], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, w{"as-IN"}, "whois.registry.in", e, t},
	{"xn--s9brj9c" /* ਭਾਰਤ */, r, z[5071:5072], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, w{"pa-Guru-IN"}, "whois.registry.in", e, t},
	{"xn--gecrj9c" /* ભારત */, r, z[5072:5073], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, w{"gu-IN"}, "whois.registry.in", e, t},
	{"xn--3hcrj9c" /* ଭାରତ */, r, z[5073:5074], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, w{"or-IN"}, "whois.registry.in", e, t},
	{"xn--xkc2dl3a5ee0h" /* இந்தியா */, r, z[5074:5075], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, w{"ta-IN"}, "whois.registry.in", e, t},
	{"xn--xkc2al3hye2a" /* இலங்கை */, r, x, 0x40, "https://newgtlds.icann.org/", w{"lk.communitydns.net", "nic.lk-anycast.pch.net", "ns-c.nic.lk", "ns-d.nic.lk", "ns-l.nic.lk", "ns-t.nic.lk", "ns1.ac.lk", "ns3.ac.lk"}, n, n, n, "whois.nic.lk", e, t},
	{"xn--clchc0ea0b2g2a9gcd" /* சிங்கப்பூர் */, r, x, 0x40, e, w{"dsany.sgnic.sg", "dsany2.sgnic.sg", "dsany3.sgnic.sg", "ns4.apnic.net", "pch.sgzones.sg"}, n, n, n, "whois.sgnic.sg", e, t},
	{"xn--hlcj6aya9esc7a" /* பரிட்சை */, r, x, 0x40, e, n, n, n, n, e, e, t},
	{"xn--fpcrj9c3d" /* భారత్ */, r, z[5075:5076], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, w{"te-IN"}, "whois.registry.in", e, t},
	{"xn--2scrj9c" /* ಭಾರತ */, r, z[5076:5077], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, w{"kn-IN"}, "whois.registry.in", e, t},
	{"xn--rvc1e0am3e" /* ഭാരതം */, r, z[5077:5078], 0xa0, "https://www.registry.in/", w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, w{"ml-IN"}, "whois.registry.in", e, t},
	{"xn--fzc2c9e2c" /* ලංකා */, r, x, 0x40, e, w{"lk.communitydns.net", "nic.lk-anycast.pch.net", "ns-c.nic.lk", "ns-d.nic.lk", "ns-l.nic.lk", "ns-t.nic.lk", "ns1.ac.lk", "ns3.ac.lk"}, n, n, n, "whois.nic.lk", e, t},
	{"xn--42c2d9a" /* คอม */, r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.xn--42c2d9a", e, t},
	{"xn--o3cw4h" /* ไทย */, r, z[5078:5079], 0x40, e, w{"a.thains.co.th", "b.thains.co.th", "ns.thnic.net", "p.thains.co.th"}, n, n, n, "whois.thnic.co.th", e, t},
	{"xn--q7ce6a" /* ລາວ */, r, x, 0, e, w{"a.xn--q7ce6a.centralnic-dns.com", "b.xn--q7ce6a.centralnic-dns.com", "c.xn--q7ce6a.centralnic-dns.com", "d.xn--q7ce6a.centralnic-dns.com"}, n, n, n, "whois.nic.la", e, t},
	{"xn--node" /* გე */, r, x, 0, "https://newgtlds.icann.org/", w{"a.xn--node.globalanycastcloud.freenom.net", "b.xn--node.globalanycastcloud.freenom.net", "c.xn--node.globalanycastcloud.freenom.net", "d.xn--node.globalanycastcloud.freenom.net", "xn--node.ns.anycast.pch.net"}, w{"188.93.95.11"}, n, n, "whois.itdc.ge", e, t},
	{"xn--q9jyb4c" /* みんな */, r, x, 0x40, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"xn--cckwcxetd" /* アマゾン */, r, x, 0x42, "http://nic.xn--cckwcxetd/", w{"dns1.nic.xn--cckwcxetd", "dns2.nic.xn--cckwcxetd", "dns3.nic.xn--cckwcxetd", "dns4.nic.xn--cckwcxetd", "dnsa.nic.xn--cckwcxetd", "dnsb.nic.xn--cckwcxetd", "dnsc.nic.xn--cckwcxetd", "dnsd.nic.xn--cckwcxetd"}, n, n, n, "whois.nic.xn--cckwcxetd", e, t},
	{"xn--gckr3f0f" /* クラウド */, r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.xn--gckr3f0f", "ns2.dns.nic.xn--gckr3f0f", "ns3.dns.nic.xn--gckr3f0f", "ns4.dns.nic.xn--gckr3f0f", "ns5.dns.nic.xn--gckr3f0f", "ns6.dns.nic.xn--gckr3f0f"}, n, n, n, "whois.nic.xn--gckr3f0f", e, t},
	{"xn--qcka1pmc" /* グーグル */, r, x, 0x42, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"xn--tckwe" /* コム */, r, x, 0, e, w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.xn--tckwe", e, t},
	{"xn--cck2b3b" /* ストア */, r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.xn--cck2b3b", "ns2.dns.nic.xn--cck2b3b", "ns3.dns.nic.xn--cck2b3b", "ns4.dns.nic.xn--cck2b3b", "ns5.dns.nic.xn--cck2b3b", "ns6.dns.nic.xn--cck2b3b"}, n, n, n, "whois.nic.xn--cck2b3b", e, t},
	{"xn--1ck2e1b" /* セール */, r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.xn--1ck2e1b", "ns2.dns.nic.xn--1ck2e1b", "ns3.dns.nic.xn--1ck2e1b", "ns4.dns.nic.xn--1ck2e1b", "ns5.dns.nic.xn--1ck2e1b", "ns6.dns.nic.xn--1ck2e1b"}, n, n, n, "whois.nic.xn--1ck2e1b", e, t},
	{"xn--zckzah" /* テスト */, r, x, 0x40, e, n, n, n, n, e, e, t},
	{"xn--bck1b9a5dre4c" /* ファッション */, r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.xn--bck1b9a5dre4c", "ns2.dns.nic.xn--bck1b9a5dre4c", "ns3.dns.nic.xn--bck1b9a5dre4c", "ns4.dns.nic.xn--bck1b9a5dre4c", "ns5.dns.nic.xn--bck1b9a5dre4c", "ns6.dns.nic.xn--bck1b9a5dre4c"}, n, n, n, "whois.nic.xn--bck1b9a5dre4c", e, t},
	{"xn--eckvdtc9d" /* ポイント */, r, x, 0x40, "https://newgtlds.icann.org/", w{"ns1.dns.nic.xn--eckvdtc9d", "ns2.dns.nic.xn--eckvdtc9d", "ns3.dns.nic.xn--eckvdtc9d", "ns4.dns.nic.xn--eckvdtc9d", "ns5.dns.nic.xn--eckvdtc9d", "ns6.dns.nic.xn--eckvdtc9d"}, n, n, n, "whois.nic.xn--eckvdtc9d", e, t},
	{"xn--4gq48lf9j" /* 一号店 */, r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, t},
	{"xn--rhqv96g" /* 世界 */, r, x, 0, e, w{"ns1.teleinfo.cn", "ns2.teleinfoo.com", "ns3.teleinfo.cn", "ns4.teleinfoo.com"}, n, n, n, "whois.nic.xn--rhqv96g", e, t},
	{"xn--fiq64b" /* 中信 */, r, x, 0x42, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.gtld.knet.cn", e, t},
	{"xn--fiqs8s" /* 中国 */, r, x, 0, "http://cnnic.cn/", w{"h.dns.cn", "i.dns.cn", "j.dns.cn", "k.dns.cn", "l.dns.cn", "m.dns.cn", "n.dns.cn"}, w{"218.241.116.40"}, n, w{"zh-Hans-CN"}, "cwhois.cnnic.cn", e, t},
	{"xn--fiqz9s" /* 中國 */, r, x, 0x80, "http://cnnic.cn/", w{"h.dns.cn", "i.dns.cn", "j.dns.cn", "k.dns.cn", "l.dns.cn", "m.dns.cn", "n.dns.cn"}, w{"218.241.116.40"}, n, w{"zh-Hant-CN"}, "cwhois.cnnic.cn", e, t},
	{"xn--fiq228c5hs" /* 中文网 */, r, x, 0x40, e, w{"ns1.teleinfo.cn", "ns2.teleinfoo.com", "ns3.teleinfo.cn", "ns4.teleinfoo.com"}, n, n, n, "whois.teleinfo.cn", e, t},
	{"xn--jlq480n2rg" /* 亚马逊 */, r, x, 0x42, "http://nic.xn--jlq480n2rg/", w{"dns1.nic.xn--jlq480n2rg", "dns2.nic.xn--jlq480n2rg", "dns3.nic.xn--jlq480n2rg", "dns4.nic.xn--jlq480n2rg", "dnsa.nic.xn--jlq480n2rg", "dnsb.nic.xn--jlq480n2rg", "dnsc.nic.xn--jlq480n2rg", "dnsd.nic.xn--jlq480n2rg"}, n, n, n, "whois.nic.xn--jlq480n2rg", e, t},
	{"xn--vhquv" /* 企业 */, r, x, 0, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.xn--vhquv", e, t},
	{"xn--1qqw23a" /* 佛山 */, r, x, 0xc4, "https://newgtlds.icann.org/", w{"ta.ngtld.cn", "tb.ngtld.cn", "tc.ngtld.cn", "td.ngtld.cn", "te.ngtld.cn"}, n, w{"Foshan"}, n, "whois.ngtld.cn", e, t},
	{"xn--vuq861b" /* 信息 */, r, x, 0, "https://newgtlds.icann.org/", w{"ns1.teleinfo.cn", "ns2.teleinfoo.com", "ns3.teleinfo.cn", "ns4.teleinfoo.com"}, n, n, n, "whois.teleinfo.cn", e, t},
	{"xn--nyqy26a" /* 健康 */, r, x, 0, "https://newgtlds.icann.org/", w{"ns1.teleinfo.cn", "ns2.teleinfoo.com", "ns3.teleinfo.cn", "ns4.teleinfoo.com"}, n, n, n, "whois.nic.xn--nyqy26a", e, t},
	{"xn--45q11c" /* 八卦 */, r, x, 0, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.nic.xn--45q11c", e, t},
	{"xn--55qx5d" /* 公司 */, r, x, 0, e, w{"a.ngtld.cn", "b.ngtld.cn", "c.ngtld.cn", "d.ngtld.cn", "e.ngtld.cn"}, n, n, n, "whois.ngtld.cn", e, t},
	{"xn--55qw42g" /* 公益 */, r, x, 0, "https://newgtlds.icann.org/", w{"ns1.conac.cn", "ns2.conac.cn", "ns3.conac.cn", "ns4.conac.cn", "ns5.conac.cn"}, n, n, n, "whois.conac.cn", e, t},
	{"xn--kprw13d" /* 台湾 */, r, x, 0, e, w{"anytld.apnic.net", "d.dns.tw", "e.dns.tw", "f.dns.tw", "g.dns.tw", "h.dns.tw"}, n, n, w{"zh-Hans-TW"}, "whois.twnic.net.tw", e, t},
	{"xn--kpry57d" /* 台灣 */, r, x, 0, e, w{"anytld.apnic.net", "d.dns.tw", "e.dns.tw", "f.dns.tw", "g.dns.tw", "h.dns.tw"}, n, n, w{"zh-Hant-TW"}, "whois.twnic.net.tw", e, t},
	{"xn--czru2d" /* 商城 */, r, x, 0, e, w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.gtld.knet.cn", e, t},
	{"xn--czrs0t" /* 商店 */, r, x, 0, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.xn--czrs0t", e, t},
	{"xn--czr694b" /* 商标 */, r, x, 0, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, e, e, t},
	{"xn--w4rs40l" /* 嘉里 */, r, x, 0, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.xn--w4rs40l", e, t},
	{"xn--w4r85el8fhu5dnra" /* 嘉里大酒店 */, r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.xn--w4r85el8fhu5dnra", e, t},
	{"xn--3ds443g" /* 在线 */, r, x, 0, e, w{"ns1.teleinfo.cn", "ns2.teleinfoo.com", "ns3.teleinfo.cn", "ns4.teleinfoo.com"}, n, n, n, "whois.teleinfo.cn", e, t},
	{"xn--3oq18vl8pn36a" /* 大众汽车 */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.xn--3oq18vl8pn36a", "a2.nic.xn--3oq18vl8pn36a", "b0.nic.xn--3oq18vl8pn36a", "c0.nic.xn--3oq18vl8pn36a"}, n, n, n, "whois.nic.xn--3oq18vl8pn36a", e, t},
	{"xn--pssy2u" /* 大拿 */, r, x, 0, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.xn--pssy2u", e, t},
	{"xn--tiq49xqyj" /* 天主教 */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.xn--tiq49xqyj", "b.nic.xn--tiq49xqyj", "c.nic.xn--tiq49xqyj", "d.nic.xn--tiq49xqyj"}, n, n, n, "whois.nic.xn--tiq49xqyj", e, t},
	{"xn--fjq720a" /* 娱乐 */, r, x, 0, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.xn--fjq720a", e, t},
	{"xn--fct429k" /* 家電 */, r, x, 0, "https://newgtlds.icann.org/", w{"ns1.dns.nic.xn--fct429k", "ns2.dns.nic.xn--fct429k", "ns3.dns.nic.xn--fct429k", "ns4.dns.nic.xn--fct429k", "ns5.dns.nic.xn--fct429k", "ns6.dns.nic.xn--fct429k"}, n, n, n, "whois.nic.xn--fct429k", e, t},
	{"xn--estv75g" /* 工行 */, r, x, 0, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.xn--estv75g", e, t},
	{"xn--xhq521b" /* 广东 */, r, x, 0, "https://newgtlds.icann.org/", w{"ta.ngtld.cn", "tb.ngtld.cn", "tc.ngtld.cn", "td.ngtld.cn", "te.ngtld.cn"}, n, n, n, "whois.ngtld.cn", e, t},
	{"xn--6rtwn" /* 广州 */, r, x, 0x2000, "https://newgtlds.icann.org/", n, n, n, n, e, e, t},
	{"xn--9krt00a" /* 微博 */, r, x, 0, "https://newgtlds.icann.org/", w{"a0.nic.xn--9krt00a", "a2.nic.xn--9krt00a", "b0.nic.xn--9krt00a", "c0.nic.xn--9krt00a"}, n, n, n, "whois.nic.xn--9krt00a", e, t},
	{"xn--30rr7y" /* 慈善 */, r, x, 0, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.gtld.knet.cn", e, t},
	{"xn--6qq986b3xl" /* 我爱你 */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.gtld.knet.cn", e, t},
	{"xn--kput3i" /* 手机 */, r, x, 0, "https://newgtlds.icann.org/", w{"a0.nic.xn--kput3i", "a2.nic.xn--kput3i", "b0.nic.xn--kput3i", "c0.nic.xn--kput3i"}, n, n, n, "whois.nic.xn--kput3i", e, t},
	{"xn--kpu716f" /* 手表 */, r, x, 0, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.xn--kpu716f", e, t},
	{"xn--otu796d" /* 招聘 */, r, x, 0, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, e, e, t},
	{"xn--zfr164b" /* 政务 */, r, x, 0, "https://newgtlds.icann.org/", w{"ns1.conac.cn", "ns2.conac.cn", "ns3.conac.cn", "ns4.conac.cn", "ns5.conac.cn"}, n, n, n, "whois.conac.cn", e, t},
	{"xn--mxtq1m" /* 政府 */, r, x, 0, "https://newgtlds.icann.org/", w{"a.nic.xn--mxtq1m", "b.nic.xn--mxtq1m", "c.nic.xn--mxtq1m", "d.nic.xn--mxtq1m"}, n, n, n, "whois.nic.xn--mxtq1m", e, t},
	{"xn--yfro4i67o" /* 新加坡 */, r, x, 0x40, e, w{"dsany.sgnic.sg", "dsany2.sgnic.sg", "dsany3.sgnic.sg", "ns4.apnic.net", "pch.sgzones.sg"}, n, n, n, "whois.sgnic.sg", e, t},
	{"xn--efvy88h" /* 新闻 */, r, x, 0, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.nic.xn--efvy88h", e, t},
	{"xn--9et52u" /* 时尚 */, r, x, 0, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.gtld.knet.cn", e, t},
	{"xn--kcrx7bb75ajk3b" /* 普利司通 */, r, x, 0x2040, "https://newgtlds.icann.org/", n, n, n, n, e, e, t},
	{"xn--rovu88b" /* 書籍 */, r, x, 0, "https://newgtlds.icann.org/", w{"ns1.dns.nic.xn--rovu88b", "ns2.dns.nic.xn--rovu88b", "ns3.dns.nic.xn--rovu88b", "ns4.dns.nic.xn--rovu88b", "ns5.dns.nic.xn--rovu88b", "ns6.dns.nic.xn--rovu88b"}, n, n, n, "whois.nic.xn--rovu88b", e, t},
	{"xn--nqv7f" /* 机构 */, r, x, 0x40, "https://pir.org/products/chinese2char-domain/", w{"a0.nic.xn--nqv7f", "a2.nic.xn--nqv7f", "b0.nic.xn--nqv7f", "c0.nic.xn--nqv7f"}, n, n, n, "whois.publicinterestregistry.net", e, t},
	{"xn--tqq33ed31aqia" /* 机构体制 */, r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, t},
	{"xn--dkwm73cwpn" /* 欧莱雅 */, r, x, 0x2040, "https://newgtlds.icann.org/", n, n, n, n, e, e, t},
	{"xn--0zwm56d" /* 测试 */, r, x, 0, e, n, n, n, n, e, e, t},
	{"xn--b4w605ferd" /* 淡马锡 */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.xn--b4w605ferd", "a2.nic.xn--b4w605ferd", "b0.nic.xn--b4w605ferd", "c0.nic.xn--b4w605ferd"}, n, n, n, "whois.afilias-srs.net", e, t},
	{"xn--fes124c" /* 深圳 */, r, x, 0x2000, "https://newgtlds.icann.org/", n, n, n, n, e, e, t},
	{"xn--g6w251d" /* 測試 */, r, x, 0, e, n, n, n, n, e, e, t},
	{"xn--unup4y" /* 游戏 */, r, x, 0, "https://newgtlds.icann.org/", w{"demand.alpha.aridns.net.au", "demand.beta.aridns.net.au", "demand.delta.aridns.net.au", "demand.gamma.aridns.net.au"}, n, n, n, "whois.nic.xn--unup4y", e, t},
	{"xn--mix891f" /* 澳門 */, r, x, 0, e, w{"a.monic.mo", "b.monic.mo", "c.monic.mo", "d.monic.mo", "e.monic.mo", "ns17.cdns.net", "ns2.cuhk.edu.hk"}, n, n, n, "whois.monic.mo", e, t},
	{"xn--3pxu8k" /* 点看 */, r, x, 0, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.xn--3pxu8k", e, t},
	{"xn--pbt977c" /* 珠宝 */, r, x, 0, "https://newgtlds.icann.org/", n, n, n, n, "whois.nic.xn--pbt977c", e, t},
	{"xn--hxt035cmppuel" /* 盛貿飯店 */, r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, t},
	{"xn--6frz82g" /* 移动 */, r, x, 0, e, w{"a0.nic.xn--6frz82g", "a2.nic.xn--6frz82g", "b0.nic.xn--6frz82g", "c0.nic.xn--6frz82g"}, n, n, n, "whois.afilias.net", e, t},
	{"xn--nqv7fs00ema" /* 组织机构 */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.xn--nqv7fs00ema", "a2.nic.xn--nqv7fs00ema", "b0.nic.xn--nqv7fs00ema", "c0.nic.xn--nqv7fs00ema"}, n, n, n, "whois.nic.xn--nqv7fs00ema", e, t},
	{"xn--ses554g" /* 网址 */, r, x, 0, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.nic.xn--ses554g", e, t},
	{"xn--hxt814e" /* 网店 */, r, x, 0, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.nic.xn--hxt814e", e, t},
	{"xn--5tzm5g" /* 网站 */, r, x, 0, "https://nic.xn--5tzm5g/", w{"a0.nic.xn--5tzm5g", "a2.nic.xn--5tzm5g", "b0.nic.xn--5tzm5g", "c0.nic.xn--5tzm5g"}, n, n, n, "whois.nic.xn--5tzm5g", e, t},
	{"xn--io0a7i" /* 网络 */, r, x, 0, e, w{"a.ngtld.cn", "b.ngtld.cn", "c.ngtld.cn", "d.ngtld.cn", "e.ngtld.cn"}, n, n, n, "whois.ngtld.cn", e, t},
	{"xn--8y0a063a" /* 联通 */, r, x, 0, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.nic.xn--8y0a063a", e, t},
	{"xn--jlq61u9w7b" /* 诺基亚 */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.xn--jlq61u9w7b", "a2.nic.xn--jlq61u9w7b", "b0.nic.xn--jlq61u9w7b", "c0.nic.xn--jlq61u9w7b"}, n, n, n, "whois.nic.xn--jlq61u9w7b", e, t},
	{"xn--flw351e" /* 谷歌 */, r, x, 0x42, "https://www.registry.google/", w{"ns-tld1.charlestonroadregistry.com", "ns-tld2.charlestonroadregistry.com", "ns-tld3.charlestonroadregistry.com", "ns-tld4.charlestonroadregistry.com", "ns-tld5.charlestonroadregistry.com"}, n, n, n, "whois.nic.google", e, t},
	{"xn--g2xx48c" /* 购物 */, r, x, 0, "https://newgtlds.icann.org/", w{"ns1.dns.nic.xn--g2xx48c", "ns2.dns.nic.xn--g2xx48c", "ns3.dns.nic.xn--g2xx48c", "ns4.dns.nic.xn--g2xx48c", "ns5.dns.nic.xn--g2xx48c", "ns6.dns.nic.xn--g2xx48c"}, n, n, n, "whois.nic.xn--g2xx48c", e, t},
	{"xn--55qx5d8y0buji4b870u" /* 通用电气公司 */, r, x, 0x40, "https://newgtlds.icann.org/", n, n, n, n, e, e, t},
	{"xn--gk3at1e" /* 通販 */, r, x, 0, "https://newgtlds.icann.org/", w{"ns1.dns.nic.xn--gk3at1e", "ns2.dns.nic.xn--gk3at1e", "ns3.dns.nic.xn--gk3at1e", "ns4.dns.nic.xn--gk3at1e", "ns5.dns.nic.xn--gk3at1e", "ns6.dns.nic.xn--gk3at1e"}, n, n, n, "whois.nic.xn--gk3at1e", e, t},
	{"xn--3bst00m" /* 集团 */, r, x, 0, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, "whois.gtld.knet.cn", e, t},
	{"xn--fzys8d69uvgm" /* 電訊盈科 */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a0.nic.xn--fzys8d69uvgm", "a2.nic.xn--fzys8d69uvgm", "b0.nic.xn--fzys8d69uvgm", "c0.nic.xn--fzys8d69uvgm"}, n, n, n, "whois.nic.xn--fzys8d69uvgm", e, t},
	{"xn--kcrx77d1x4a" /* 飞利浦 */, r, x, 0x40, "https://newgtlds.icann.org/", w{"a.nic.xn--kcrx77d1x4a", "b.nic.xn--kcrx77d1x4a", "c.nic.xn--kcrx77d1x4a", "d.nic.xn--kcrx77d1x4a"}, n, n, n, "whois.nic.xn--kcrx77d1x4a", e, t},
	{"xn--jvr189m" /* 食品 */, r, x, 0, "https://newgtlds.icann.org/", w{"ns1.dns.nic.xn--jvr189m", "ns2.dns.nic.xn--jvr189m", "ns3.dns.nic.xn--jvr189m", "ns4.dns.nic.xn--jvr189m", "ns5.dns.nic.xn--jvr189m", "ns6.dns.nic.xn--jvr189m"}, n, n, n, "whois.nic.xn--jvr189m", e, t},
	{"xn--imr513n" /* 餐厅 */, r, x, 0, "https://newgtlds.icann.org/", w{"a.zdnscloud.com", "b.zdnscloud.com", "c.zdnscloud.com", "d.zdnscloud.com", "f.zdnscloud.com", "g.zdnscloud.com", "i.zdnscloud.com", "j.zdnscloud.com"}, n, n, n, e, e, t},
	{"xn--5su34j936bgsg" /* 香格里拉 */, r, x, 0x40, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.xn--5su34j936bgsg", e, t},
	{"xn--j6w193g" /* 香港 */, r, z[5079:5085], 0, e, w{"c.hkirc.net.hk", "d.hkirc.net.hk", "t.hkirc.net.hk", "u.hkirc.net.hk", "v.hkirc.net.hk", "x.hkirc.net.hk", "y.hkirc.net.hk", "z.hkirc.net.hk"}, n, n, w{"zh-Hans-HK"}, "whois.hkirc.hk", e, t},
	{"xn--j6w470d71issc" /* 香港電訊 */, r, x, 0x2040, "https://newgtlds.icann.org/", n, n, n, n, e, e, t},
	{"xn--c1yn36f" /* 點看 */, r, x, 0, "https://newgtlds.icann.org/", n, n, n, n, e, e, t},
	{"xn--t60b56a" /* 닷넷 */, r, x, 0, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.xn--t60b56a", e, t},
	{"xn--mk1bu44c" /* 닷컴 */, r, x, 0, "https://newgtlds.icann.org/", w{"ac1.nstld.com", "ac2.nstld.com", "ac3.nstld.com", "ac4.nstld.com"}, n, n, n, "whois.nic.xn--mk1bu44c", e, t},
	{"xn--cg4bki" /* 삼성 */, r, x, 0x42, "https://newgtlds.icann.org/", w{"ns1.xn--cg4bki.centralnic-dns.com", "ns2.xn--cg4bki.centralnic-dns.com", "ns3.xn--cg4bki.centralnic-dns.com", "ns4.xn--cg4bki.centralnic-dns.com"}, n, n, n, "whois.kr", e, t},
	{"xn--9t4b11yi5a" /* 테스트 */, r, x, 0x40, e, n, n, n, n, e, e, t},
	{"xn--3e0b707e" /* 한국 */, r, x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, "whois.kr", e, t},
	{"com.ac", &z[10], x, 0x800, e, n, n, n, n, e, e, f},
	{"gov.ac", &z[10], x, 0x800, e, n, n, n, n, e, e, f},
	{"mil.ac", &z[10], x, 0, e, n, n, n, n, e, e, f},
	{"net.ac", &z[10], x, 0x800, e, n, n, n, n, e, e, f},
	{"org.ac", &z[10], x, 0x800, e, n, n, n, n, e, e, f},
	{"nom.ad", &z[19], x, 0, e, w{"dnsc.ad", "dnsm.ad"}, n, n, n, e, e, f},
	{"ac.ae", &z[23], x, 0, e, w{"ns1.aedns.ae", "ns2.aedns.ae", "ns4.apnic.net", "nsext-pch.aedns.ae"}, n, n, n, e, e, f},
	{"co.ae", &z[23], x, 0, e, w{"ns1.aedns.ae", "ns2.aedns.ae", "ns4.apnic.net", "nsext-pch.aedns.ae"}, n, n, n, e, e, t},
	{"gov.ae", &z[23], x, 0, e, w{"ns1.aedns.ae", "ns2.aedns.ae", "ns4.apnic.net", "nsext-pch.aedns.ae"}, n, n, n, e, e, f},
	{"mil.ae", &z[23], x, 0, e, w{"ns1.aedns.ae", "ns2.aedns.ae", "ns4.apnic.net", "nsext-pch.aedns.ae"}, n, n, n, e, e, f},
	{"name.ae", &z[23], x, 0, e, n, n, n, n, e, e, f},
	{"net.ae", &z[23], x, 0, e, w{"ns1.aedns.ae", "ns2.aedns.ae", "ns4.apnic.net", "nsext-pch.aedns.ae"}, n, n, n, e, e, f},
	{"org.ae", &z[23], x, 0, e, w{"ns1.aedns.ae", "ns2.aedns.ae", "ns4.apnic.net", "nsext-pch.aedns.ae"}, n, n, n, e, e, f},
	{"pro.ae", &z[23], x, 0, e, n, n, n, n, e, e, f},
	{"sch.ae", &z[23], x, 0, e, w{"ns1.aedns.ae", "ns2.aedns.ae", "ns4.apnic.net", "nsext-pch.aedns.ae"}, n, n, n, e, e, f},
	{"airport.aero", &z[25], x, 0, e, n, n, n, n, e, e, t},
	{"cargo.aero", &z[25], x, 0, e, n, n, n, n, e, e, t},
	{"charter.aero", &z[25], x, 0, e, n, n, n, n, e, e, t},
	{"bank.af", &z[27], x, 0, e, w{"ns-us.1and1-dns.com", "ns-us.1and1-dns.us"}, n, n, n, e, e, f},
	{"com.af", &z[27], x, 0, e, w{"ns.anycast.nic.af", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"edu.af", &z[27], x, 0, e, w{"ns.anycast.nic.af", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"gov.af", &z[27], x, 0, e, w{"ns.anycast.nic.af", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"hotel.af", &z[27], x, 0, e, n, n, n, n, e, e, f},
	{"law.af", &z[27], x, 0, e, n, n, n, n, e, e, f},
	{"music.af", &z[27], x, 0, e, w{"josh.ns.cloudflare.com", "lady.ns.cloudflare.com"}, n, n, n, e, e, f},
	{"net.af", &z[27], x, 0, e, w{"ns.anycast.nic.af", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"org.af", &z[27], x, 0, e, w{"ns.anycast.nic.af", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"tv.af", &z[27], x, 0, e, w{"ns.anycast.nic.af", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"co.ag", &z[32], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org", "dns.server.ag"}, n, n, n, e, e, f},
	{"com.ag", &z[32], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org", "dns.server.ag"}, n, n, n, e, e, f},
	{"net.ag", &z[32], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org", "dns.server.ag"}, n, n, n, e, e, f},
	{"nom.ag", &z[32], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org", "dns.server.ag"}, n, n, n, e, e, f},
	{"ok.ag", &z[32], x, 0, e, w{"ns1.domainname.at", "ns3.domainname.at", "ns4.domainname.at"}, n, n, n, e, e, t},
	{"org.ag", &z[32], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org", "dns.server.ag"}, n, n, n, e, e, f},
	{"com.ai", &z[35], x, 0, e, w{"pch.whois.ai"}, n, n, n, e, e, f},
	{"net.ai", &z[35], x, 0, e, w{"pch.whois.ai"}, n, n, n, e, e, f},
	{"off.ai", &z[35], x, 0, e, w{"pch.whois.ai"}, n, n, n, e, e, f},
	{"org.ai", &z[35], x, 0, e, w{"pch.whois.ai"}, n, n, n, e, e, f},
	{"com.al", &z[42], x, 0, e, w{"al.cctld.authdns.ripe.net", "ns-al.isti.cnr.it", "ns1.nic.al", "ns2.nic.al", "nsx.nic.al", "rip.psg.com"}, n, n, n, e, e, f},
	{"edu.al", &z[42], x, 0, e, w{"al.cctld.authdns.ripe.net", "ns-al.isti.cnr.it", "ns1.nic.al", "ns2.nic.al", "nsx.nic.al", "rip.psg.com"}, n, n, n, e, e, f},
	{"gov.al", &z[42], x, 0, e, w{"al.cctld.authdns.ripe.net", "ns-al.isti.cnr.it", "ns1.nic.al", "ns2.nic.al", "nsx.nic.al", "rip.psg.com"}, n, n, n, e, e, f},
	{"inima.al", &z[42], x, 0, e, w{"ns1.he.net", "ns2.he.net", "ns3.he.net", "ns4.he.net", "ns5.he.net"}, n, n, n, e, e, f},
	{"net.al", &z[42], x, 0, e, w{"al.cctld.authdns.ripe.net", "ns-al.isti.cnr.it", "ns1.nic.al", "ns2.nic.al", "nsx.nic.al", "rip.psg.com"}, n, n, n, e, e, f},
	{"org.al", &z[42], x, 0, e, w{"al.cctld.authdns.ripe.net", "ns-al.isti.cnr.it", "ns1.nic.al", "ns2.nic.al", "nsx.nic.al", "rip.psg.com"}, n, n, n, e, e, f},
	{"soros.al", &z[42], x, 0, e, w{"ns1.hostmonster.com", "ns2.hostmonster.com"}, n, n, n, e, e, f},
	{"tirana.al", &z[42], x, 0, e, w{"ns3.albtelecom.net", "ns4.albtelecom.net"}, n, n, n, e, e, f},
	{"uniti.al", &z[42], x, 0, e, n, n, n, n, e, e, f},
	{"upt.al", &z[42], x, 0, e, w{"abcom.abcom.com.al", "smtphub.abcom.com.al"}, n, n, n, e, e, f},
	{"co.am", &z[54], x, 0, e, n, n, n, n, e, e, f},
	{"com.am", &z[54], x, 0, e, n, n, n, n, e, e, f},
	{"net.am", &z[54], x, 0, e, n, n, n, n, e, e, f},
	{"north.am", &z[54], x, 0, e, w{"ns1.instradns.com", "ns2.instradns.com"}, n, n, n, e, e, f},
	{"org.am", &z[54], x, 0, e, n, n, n, n, e, e, f},
	{"radio.am", &z[54], x, 0, e, w{"a.nic.fm", "b.nic.fm", "c.nic.fm", "d.nic.fm"}, n, n, n, e, e, t},
	{"south.am", &z[54], x, 0, e, w{"ns1.instradns.com", "ns2.instradns.com"}, n, n, n, e, e, f},
	{"com.an", &z[63], x, 0x800, e, n, n, n, n, e, e, f},
	{"edu.an", &z[63], x, 0x800, e, n, n, n, n, e, e, f},
	{"net.an", &z[63], x, 0x800, e, n, n, n, n, e, e, f},
	{"org.an", &z[63], x, 0x800, e, n, n, n, n, e, e, f},
	{"co.ao", &z[71], z[5085:5087], 0, e, w{"fred.nic.ao", "ns-ext.nic.cz", "ns0.nic.ao", "ns02.fccn.pt", "ns2.reg.it.ao"}, n, n, n, e, e, f},
	{"ed.ao", &z[71], x, 0, e, n, n, n, n, e, e, f},
	{"gv.ao", &z[71], x, 0, e, n, n, n, n, e, e, f},
	{"it.ao", &z[71], x, 0, e, w{"fred.nic.ao", "ns-ext.nic.cz", "ns0.nic.ao", "ns02.fccn.pt", "ns2.reg.it.ao"}, n, n, n, e, e, f},
	{"og.ao", &z[71], x, 0, e, n, n, n, n, e, e, f},
	{"pb.ao", &z[71], x, 0, e, n, n, n, n, e, e, f},
	{"com.aq", &z[76], x, 0, e, w{"ns1.internet.com.pe", "ns2.internet.com.pe"}, n, n, n, e, e, f},
	{"com.ar", &z[79], x, 0, e, w{"a.dns.ar", "b.dns.ar", "c.dns.ar", "e.dns.ar", "f.dns.ar"}, n, n, n, e, e, t},
	{"edu.ar", &z[79], z[5087:5088], 0, e, w{"a.riu.edu.ar", "b.riu.edu.ar", "noc.uncu.edu.ar", "ns1.uba.ar", "ns2.switch.ch", "unlp.unlp.edu.ar"}, n, n, n, e, e, f},
	{"gob.ar", &z[79], x, 0, e, w{"a.dns.ar", "ar.cctld.authdns.ripe.net", "b.dns.ar", "c.dns.ar", "e.dns.ar", "f.dns.ar"}, n, n, n, e, e, f},
	{"gov.ar", &z[79], x, 0, e, w{"a.dns.ar", "ar.cctld.authdns.ripe.net", "b.dns.ar", "c.dns.ar", "e.dns.ar", "f.dns.ar"}, n, n, n, e, e, f},
	{"int.ar", &z[79], x, 0, e, w{"a.dns.ar", "ar.cctld.authdns.ripe.net", "b.dns.ar", "c.dns.ar", "e.dns.ar", "f.dns.ar"}, n, n, n, e, e, t},
	{"mil.ar", &z[79], x, 0, e, w{"a.dns.ar", "ar.cctld.authdns.ripe.net", "b.dns.ar", "c.dns.ar", "e.dns.ar", "f.dns.ar"}, n, n, n, e, e, t},
	{"net.ar", &z[79], x, 0, e, w{"a.dns.ar", "ar.cctld.authdns.ripe.net", "b.dns.ar", "c.dns.ar", "e.dns.ar", "f.dns.ar"}, n, n, n, e, e, t},
	{"org.ar", &z[79], x, 0, e, w{"a.dns.ar", "ar.cctld.authdns.ripe.net", "b.dns.ar", "c.dns.ar", "e.dns.ar", "f.dns.ar"}, n, n, n, e, e, t},
	{"tur.ar", &z[79], x, 0, e, w{"a.dns.ar", "ar.cctld.authdns.ripe.net", "b.dns.ar", "c.dns.ar", "e.dns.ar", "f.dns.ar"}, n, n, n, e, e, t},
	{"e164.arpa", &z[85], x, 0x8, e, w{"ns3.afrinic.net", "ns3.lacnic.net", "ns4.apnic.net", "pri.authdns.ripe.net", "rirns.arin.net"}, n, n, n, "whois.ripe.net", e, f},
	{"in-addr.arpa", &z[85], x, 0x8, e, w{"a.in-addr-servers.arpa", "b.in-addr-servers.arpa", "c.in-addr-servers.arpa", "d.in-addr-servers.arpa", "e.in-addr-servers.arpa", "f.in-addr-servers.arpa"}, n, n, n, e, e, f},
	{"ip6.arpa", &z[85], x, 0x8, e, w{"a.ip6-servers.arpa", "b.ip6-servers.arpa", "c.ip6-servers.arpa", "d.ip6-servers.arpa", "e.ip6-servers.arpa", "f.ip6-servers.arpa"}, n, n, n, e, e, f},
	{"iris.arpa", &z[85], x, 0x8, e, w{"a.iana-servers.net", "b.iana-servers.net", "c.iana-servers.net", "ns3.lacnic.net", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"uri.arpa", &z[85], x, 0x8, e, w{"a.iana-servers.net", "b.iana-servers.net", "c.iana-servers.net", "ns3.lacnic.net", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"urn.arpa", &z[85], x, 0x8, e, w{"a.iana-servers.net", "b.iana-servers.net", "c.iana-servers.net", "ns3.lacnic.net", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"ac.at", &z[93], x, 0, e, w{"d.ns.at", "n.ns.at", "ns1.univie.ac.at", "ns2.univie.ac.at"}, n, n, n, e, e, f},
	{"co.at", &z[93], x, 0, e, n, n, n, n, e, e, f},
	{"gv.at", &z[93], x, 0, e, w{"dns1.statistik.gv.at", "ns12.govix.at", "ns3.wien.at", "ns4.wien.gv.at", "ns7.univie.ac.at", "ns8.univie.ac.at"}, n, n, n, e, e, f},
	{"or.at", &z[93], x, 0, e, n, n, n, n, e, e, f},
	{"priv.at", &z[93], x, 0, e, w{"adns3.utanet.at", "mosthamster.nic.priv.at", "ns2.inode.at", "ns2.nextlayer.at", "ns5.univie.ac.at", "priv-ns.sil.at", "sec1.rcode0.net"}, n, n, n, "whois.nic.priv.at", e, t},
	{"act.au", &z[96], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, f},
	{"asn.au", &z[96], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, t},
	{"com.au", &z[96], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, t},
	{"conf.au", &z[96], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, f},
	{"csiro.au", &z[96], x, 0, e, w{"ns1.aarnet.net.au", "ns1.csiro.au", "ns2.aarnet.net.au", "ns2.csiro.au", "ns3.aarnet.net.au", "ns3.csiro.au"}, n, n, n, e, e, f},
	{"edu.au", &z[96], z[5088:5096], 0, "https://www.domainname.edu.au/", w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, f},
	{"gov.au", &z[96], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, f},
	{"id.au", &z[96], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, f},
	{"info.au", &z[96], x, 0x800, "http://www.aunic.net/", n, n, n, n, e, e, f},
	{"net.au", &z[96], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, "eleanba.connect.com.au", e, t},
	{"nsw.au", &z[96], x, 0x80, e, w{"q.au", "r.au", "s.au", "t.au"}, n, w{"AU-NSW"}, n, e, e, f},
	{"nt.au", &z[96], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, f},
	{"org.au", &z[96], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, t},
	{"oz.au", &z[96], x, 0, e, w{"munnari.oz.au", "ns.sw.oz.au", "rip.psg.com"}, n, n, n, e, e, f},
	{"qld.au", &z[96], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, f},
	{"sa.au", &z[96], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, f},
	{"tas.au", &z[96], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, f},
	{"telememo.au", &z[96], x, 0x800, e, n, n, n, n, e, e, f},
	{"vic.au", &z[96], x, 0, "http://www.aucd.org.au/", w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, f},
	{"wa.au", &z[96], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, f},
	{"com.aw", &z[108], x, 0, e, w{"ns1.setarnet.aw", "ns2.setarnet.aw"}, n, n, n, e, e, f},
	{"bilesuvar.az", &z[113], x, 0, e, n, n, n, n, e, e, t},
	{"biz.az", &z[113], x, 0, e, n, n, n, n, e, e, f},
	{"co.az", &z[113], x, 0, e, n, n, n, n, e, e, f},
	{"com.az", &z[113], x, 0, e, n, n, n, n, e, e, f},
	{"edu.az", &z[113], x, 0, e, n, n, n, n, e, e, f},
	{"ganja.az", &z[113], x, 0, e, n, n, n, n, e, e, t},
	{"gov.az", &z[113], x, 0, e, w{"ns1.gov.az", "ns2.gov.az", "ns3.gov.az", "ns4.gov.az"}, n, n, n, e, e, f},
	{"imishli.az", &z[113], x, 0, e, n, n, n, n, e, e, t},
	{"info.az", &z[113], x, 0, e, n, n, n, n, e, e, f},
	{"int.az", &z[113], x, 0, e, n, n, n, n, e, e, f},
	{"mil.az", &z[113], x, 0, e, n, n, n, n, e, e, f},
	{"name.az", &z[113], x, 0, e, n, n, n, n, e, e, f},
	{"net.az", &z[113], x, 0, e, n, n, n, n, e, e, f},
	{"org.az", &z[113], x, 0, e, n, n, n, n, e, e, f},
	{"pp.az", &z[113], x, 0, e, n, n, n, n, e, e, f},
	{"pro.az", &z[113], x, 0, e, n, n, n, n, e, e, f},
	{"samux.az", &z[113], x, 0, e, n, n, n, n, e, e, t},
	{"shamaxi.az", &z[113], x, 0, e, n, n, n, n, e, e, t},
	{"shusha.az", &z[113], x, 0, e, w{"ns1.gov.az", "ns2.gov.az"}, n, n, n, e, e, t},
	{"sumgait.az", &z[113], x, 0, e, n, n, n, n, e, e, t},
	{"zaqatala.az", &z[113], x, 0, e, n, n, n, n, e, e, t},
	{"co.ba", &z[115], x, 0, e, w{"ns1.co.ba", "ns2.co.ba", "ns3.co.ba"}, w{"176.9.45.78"}, n, n, e, e, t},
	{"com.ba", &z[115], x, 0, e, w{"ns1.hosting.bhtelecom.ba", "ns2.hosting.bhtelecom.ba", "ns3.hosting.bhtelecom.ba"}, w{"195.222.33.180"}, n, n, e, e, f},
	{"edu.ba", &z[115], x, 0, e, w{"auth03.ns.uu.net", "ns.ba", "sava.utic.net.ba", "una.utic.net.ba"}, n, n, n, e, e, f},
	{"gov.ba", &z[115], x, 0, e, w{"auth03.ns.uu.net", "ns.ba", "sava.utic.net.ba", "una.utic.net.ba"}, n, n, n, e, e, f},
	{"mil.ba", &z[115], x, 0, e, w{"bosna.utic.net.ba", "sava.utic.net.ba"}, n, n, n, e, e, f},
	{"net.ba", &z[115], x, 0, e, w{"auth03.ns.uu.net", "ns.ba", "sava.utic.net.ba", "una.utic.net.ba"}, n, n, n, e, e, f},
	{"org.ba", &z[115], x, 0, e, w{"auth03.ns.uu.net", "ns.ba", "sava.utic.net.ba", "una.utic.net.ba"}, n, n, n, e, e, f},
	{"rs.ba", &z[115], x, 0, e, w{"a.ns.rs.ba", "b.ns.rs.ba", "c.ns.rs.ba"}, n, n, n, e, e, f},
	{"unbi.ba", &z[115], x, 0, e, w{"linhost01.utic.net.ba", "sava.utic.net.ba"}, n, n, n, e, e, f},
	{"unmo.ba", &z[115], x, 0, e, w{"dns2019.unmo.ba", "pdc2019.unmo.ba", "web2019.unmo.ba"}, n, n, n, e, e, f},
	{"unsa.ba", &z[115], x, 0, e, w{"bosna.utic.net.ba", "sava.utic.net.ba", "una.utic.net.ba"}, n, n, n, e, e, f},
	{"untz.ba", &z[115], x, 0, e, w{"gradina.untz.ba", "slatina.untz.ba"}, n, n, n, e, e, f},
	{"unze.ba", &z[115], x, 0, e, w{"ns1.first-ns.de", "pi.unze.ba", "robotns2.second-ns.de", "robotns3.second-ns.com"}, n, n, n, e, e, f},
	{"biz.bb", &z[133], x, 0, e, w{"bds-tlcm-ns-001.gov.bb", "bds-tlcm-ns-002.gov.bb", "ns1.nic.bb", "ns2.nic.bb", "ns3.nic.bb", "ns4.nic.bb", "ns5.nic.bb"}, n, n, n, e, e, f},
	{"co.bb", &z[133], x, 0, e, w{"bds-tlcm-ns-001.gov.bb", "bds-tlcm-ns-002.gov.bb", "ns1.nic.bb", "ns2.nic.bb", "ns3.nic.bb", "ns4.nic.bb", "ns5.nic.bb"}, n, n, n, e, e, f},
	{"com.bb", &z[133], x, 0, e, w{"bds-tlcm-ns-001.gov.bb", "bds-tlcm-ns-002.gov.bb", "ns1.nic.bb", "ns2.nic.bb", "ns3.nic.bb", "ns4.nic.bb", "ns5.nic.bb"}, n, n, n, e, e, f},
	{"gov.bb", &z[133], x, 0, e, w{"bds-tlcm-ns-001.gov.bb", "bds-tlcm-ns-002.gov.bb", "ns1.nic.bb", "ns2.nic.bb", "ns3.nic.bb", "ns4.nic.bb", "ns5.nic.bb"}, n, n, n, e, e, f},
	{"info.bb", &z[133], x, 0, e, w{"bds-tlcm-ns-001.gov.bb", "bds-tlcm-ns-002.gov.bb", "ns1.nic.bb", "ns2.nic.bb", "ns3.nic.bb", "ns4.nic.bb", "ns5.nic.bb"}, n, n, n, e, e, f},
	{"net.bb", &z[133], x, 0, e, w{"bds-tlcm-ns-001.gov.bb", "bds-tlcm-ns-002.gov.bb", "ns1.nic.bb", "ns2.nic.bb", "ns3.nic.bb", "ns4.nic.bb", "ns5.nic.bb"}, n, n, n, e, e, f},
	{"org.bb", &z[133], x, 0, e, w{"bds-tlcm-ns-001.gov.bb", "bds-tlcm-ns-002.gov.bb", "ns1.nic.bb", "ns2.nic.bb", "ns3.nic.bb", "ns4.nic.bb", "ns5.nic.bb"}, n, n, n, e, e, f},
	{"store.bb", &z[133], x, 0, e, n, n, n, n, e, e, f},
	{"tv.bb", &z[133], x, 0, e, n, n, n, n, e, e, f},
	{"ac.bd", &z[140], x, 0, e, w{"bd-ns.anycast.pch.net", "dns.bd", "jamuna.btcl.net.bd", "surma.btcl.net.bd"}, n, n, n, e, e, f},
	{"com.bd", &z[140], x, 0, e, w{"bd-ns.anycast.pch.net", "dns.bd", "jamuna.btcl.net.bd", "surma.btcl.net.bd"}, n, n, n, e, e, f},
	{"edu.bd", &z[140], x, 0, e, w{"bd-ns.anycast.pch.net", "dns.bd", "jamuna.btcl.net.bd", "surma.btcl.net.bd"}, n, n, n, e, e, f},
	{"gov.bd", &z[140], x, 0, e, w{"bd-ns.anycast.pch.net", "dns.bd", "jamuna.btcl.net.bd", "surma.btcl.net.bd"}, n, n, n, e, e, f},
	{"mil.bd", &z[140], x, 0, e, w{"bd-ns.anycast.pch.net", "dns.bd", "jamuna.btcl.net.bd", "surma.btcl.net.bd"}, n, n, n, e, e, f},
	{"net.bd", &z[140], x, 0, e, w{"bd-ns.anycast.pch.net", "dns.bd", "jamuna.btcl.net.bd", "surma.btcl.net.bd"}, n, n, n, e, e, f},
	{"org.bd", &z[140], x, 0, e, w{"bd-ns.anycast.pch.net", "dns.bd", "jamuna.btcl.net.bd", "surma.btcl.net.bd"}, n, n, n, e, e, f},
	{"gov.bf", &z[151], x, 0, e, w{"ntoo.gov.bf", "oubri.gov.bf"}, n, n, n, e, e, f},
	{"0.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"1.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"2.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"3.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"4.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"5.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"6.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"7.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"8.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"9.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"a.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"b.bg", &z[152], x, 0, "https://www.register.bg/user/", n, n, n, n, e, e, f},
	{"c.bg", &z[152], x, 0, "https://www.register.bg/user/", n, n, n, n, e, e, f},
	{"d.bg", &z[152], x, 0, "https://www.register.bg/user/", n, n, n, n, e, e, f},
	{"e.bg", &z[152], x, 0, "https://www.register.bg/user/", n, n, n, n, e, e, f},
	{"f.bg", &z[152], x, 0, "https://www.register.bg/user/", n, n, n, n, e, e, f},
	{"g.bg", &z[152], x, 0, "https://www.register.bg/user/", n, n, n, n, e, e, f},
	{"h.bg", &z[152], x, 0, "https://www.register.bg/user/", n, n, n, n, e, e, f},
	{"i.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"j.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"k.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"l.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"m.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"n.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"o.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"p.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"q.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"r.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"s.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"t.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"u.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"v.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"w.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"x.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"y.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"z.bg", &z[152], x, 0, e, n, n, n, n, e, e, f},
	{"biz.bh", &z[153], x, 0, e, w{"a.bh.centralnic-dns.com", "b.bh.centralnic-dns.com", "c.bh.centralnic-dns.com", "d.bh.centralnic-dns.com"}, n, n, n, e, e, f},
	{"cc.bh", &z[153], x, 0, e, w{"a.bh.centralnic-dns.com", "b.bh.centralnic-dns.com", "c.bh.centralnic-dns.com", "d.bh.centralnic-dns.com"}, n, n, n, e, e, f},
	{"com.bh", &z[153], x, 0, e, w{"a.bh.centralnic-dns.com", "b.bh.centralnic-dns.com", "c.bh.centralnic-dns.com", "d.bh.centralnic-dns.com"}, n, n, n, e, e, f},
	{"edu.bh", &z[153], x, 0, e, w{"a.bh.centralnic-dns.com", "b.bh.centralnic-dns.com", "c.bh.centralnic-dns.com", "d.bh.centralnic-dns.com"}, n, n, n, e, e, f},
	{"gov.bh", &z[153], x, 0, e, w{"ns1.gov.bh", "ns2.gov.bh"}, n, n, n, e, e, f},
	{"info.bh", &z[153], x, 0, e, w{"a.bh.centralnic-dns.com", "b.bh.centralnic-dns.com", "c.bh.centralnic-dns.com", "d.bh.centralnic-dns.com"}, n, n, n, e, e, f},
	{"net.bh", &z[153], x, 0, e, w{"a.bh.centralnic-dns.com", "b.bh.centralnic-dns.com", "c.bh.centralnic-dns.com", "d.bh.centralnic-dns.com"}, n, n, n, e, e, f},
	{"org.bh", &z[153], x, 0, e, w{"a.bh.centralnic-dns.com", "b.bh.centralnic-dns.com", "c.bh.centralnic-dns.com", "d.bh.centralnic-dns.com"}, n, n, n, e, e, f},
	{"co.bi", &z[155], x, 0, e, w{"anyns.nic.bi", "bi.cctld.authdns.ripe.net", "ns-bi.afrinic.net", "ns.nic.bi", "ns1.nic.bi"}, n, n, n, e, e, f},
	{"com.bi", &z[155], x, 0, e, w{"anyns.nic.bi", "bi.cctld.authdns.ripe.net", "ns-bi.afrinic.net", "ns.nic.bi", "ns1.nic.bi"}, n, n, n, e, e, f},
	{"edu.bi", &z[155], x, 0, e, w{"bi.cctld.authdns.ripe.net", "ns-bi.afrinic.net", "ns.nic.bi", "ns1.nic.bi"}, n, n, n, e, e, f},
	{"gov.bi", &z[155], x, 0, e, w{"anyns.nic.bi", "bi.cctld.authdns.ripe.net", "ns-bi.afrinic.net", "ns.nic.bi", "ns1.nic.bi"}, n, n, n, e, e, t},
	{"info.bi", &z[155], x, 0, e, w{"bi.cctld.authdns.ripe.net", "ns-bi.afrinic.net", "ns-bi.ripe.net", "ns.nic.bi", "ns1.nic.bi"}, n, n, n, e, e, t},
	{"mo.bi", &z[155], x, 0, e, w{"ns1.hostinger.com", "ns2.hostinger.com", "ns3.hostinger.com", "ns4.hostinger.com"}, n, n, n, e, e, t},
	{"net.bi", &z[155], x, 0, e, n, n, n, n, e, e, t},
	{"or.bi", &z[155], x, 0, e, w{"anyns.nic.bi", "bi.cctld.authdns.ripe.net", "ns-bi.afrinic.net", "ns.nic.bi", "ns1.nic.bi"}, n, n, n, e, e, f},
	{"org.bi", &z[155], x, 0, e, w{"anyns.nic.bi", "bi.cctld.authdns.ripe.net", "ns-bi.afrinic.net", "ns.nic.bi", "ns1.nic.bi"}, n, n, n, e, e, f},
	{"ote.bi", &z[155], x, 0, e, n, n, n, n, e, e, t},
	{"1x.biz", &z[162], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "1x.biz"}, n, n, e, e, t},
	{"auz.biz", &z[162], x, 0, e, w{"ns1.instradns.com", "ns2.instradns.com", "ns3.instradns.com"}, n, n, n, e, e, f},
	{"asso.bj", &z[163], x, 0, e, w{"a.dnspod.com", "b.dnspod.com", "c.dnspod.com"}, n, n, n, e, e, f},
	{"barreau.bj", &z[163], x, 0, e, w{"a.dnspod.com", "b.dnspod.com", "c.dnspod.com"}, n, n, n, e, e, f},
	{"com.bj", &z[163], x, 0, e, w{"ns.cocca.fr", "ns1.nic.bj", "ns2.nic.bj", "pch.nic.bj"}, n, n, n, e, e, f},
	{"edu.bj", &z[163], x, 0, e, w{"ns.cocca.fr", "ns1.nic.bj", "ns2.nic.bj", "pch.nic.bj", "pch.nic.fr"}, n, n, n, e, e, f},
	{"gouv.bj", &z[163], x, 0, e, w{"ns01.gouv.bj", "ns02.gouv.bj"}, n, n, n, e, e, f},
	{"gov.bj", &z[163], x, 0, e, w{"nakayo.leland.bj", "ns1.intnet.bj"}, n, n, n, e, e, f},
	{"mil.bj", &z[163], x, 0, e, w{"ns01.gouv.bj", "ns1.jenysas.bj"}, n, n, n, e, e, f},
	{"art.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "art.blog"}, n, n, e, e, t},
	{"business.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "business.blog"}, n, n, e, e, t},
	{"car.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "car.blog"}, n, n, e, e, t},
	{"code.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "code.blog"}, n, n, e, e, t},
	{"family.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "family.blog"}, n, n, e, e, t},
	{"fashion.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "fashion.blog"}, n, n, e, e, t},
	{"finance.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "finance.blog"}, n, n, e, e, t},
	{"fitness.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "fitness.blog"}, n, n, e, e, t},
	{"food.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "food.blog"}, n, n, e, e, t},
	{"game.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "game.blog"}, n, n, e, e, t},
	{"health.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "health.blog"}, n, n, e, e, t},
	{"home.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "home.blog"}, n, n, e, e, t},
	{"law.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "law.blog"}, n, n, e, e, t},
	{"movie.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "movie.blog"}, n, n, e, e, t},
	{"music.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "music.blog"}, n, n, e, e, t},
	{"news.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "news.blog"}, n, n, e, e, t},
	{"photo.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "photo.blog"}, n, n, e, e, t},
	{"poetry.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "poetry.blog"}, n, n, e, e, t},
	{"politics.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "politics.blog"}, n, n, e, e, t},
	{"school.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "school.blog"}, n, n, e, e, t},
	{"science.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "science.blog"}, n, n, e, e, t},
	{"sport.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "sport.blog"}, n, n, e, e, t},
	{"tech.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "tech.blog"}, n, n, e, e, t},
	{"travel.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "travel.blog"}, n, n, e, e, t},
	{"video.blog", &z[168], x, 0, e, w{"ns1.automattic.com", "ns2.automattic.com", "ns3.automattic.com", "ns4.automattic.com"}, w{"192.0.78.30", "192.0.78.31", "video.blog"}, n, n, e, e, t},
	{"water.blog", &z[168], x, 0, e, w{"ns1.wordpress.com", "ns2.wordpress.com", "ns3.wordpress.com"}, w{"192.0.78.24", "192.0.78.25", "water.blog"}, n, n, e, e, t},
	{"com.bm", &z[172], x, 0, e, n, n, n, n, e, e, f},
	{"edu.bm", &z[172], x, 0, e, n, n, n, n, e, e, f},
	{"gov.bm", &z[172], x, 0, e, w{"dns1.gov.bm", "dns2.gov.bm", "dns3.gov.bm"}, n, n, n, e, e, f},
	{"net.bm", &z[172], x, 0, e, n, n, n, n, e, e, f},
	{"org.bm", &z[172], x, 0, e, n, n, n, n, e, e, f},
	{"com.bn", &z[175], x, 0, e, w{"bn-ns.anycast.pch.net", "ns1.bnnic.bn", "ns2.bnnic.bn", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"edu.bn", &z[175], x, 0, e, w{"bn-ns.anycast.pch.net", "ns1.bnnic.bn", "ns2.bnnic.bn", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"gov.bn", &z[175], x, 0, e, w{"bn-ns.anycast.pch.net", "ns1.bnnic.bn", "ns2.bnnic.bn", "ns4.apnic.net"}, n, n, n, e, e, t},
	{"net.bn", &z[175], x, 0, e, w{"bn-ns.anycast.pch.net", "ns1.bnnic.bn", "ns2.bnnic.bn", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"org.bn", &z[175], x, 0, e, w{"bn-ns.anycast.pch.net", "ns1.bnnic.bn", "ns2.bnnic.bn", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"com.bo", &z[178], x, 0, e, n, n, n, n, e, e, f},
	{"edu.bo", &z[178], x, 0, e, n, n, n, n, e, e, f},
	{"gob.bo", &z[178], x, 0, e, n, n, n, n, e, e, f},
	{"gov.bo", &z[178], x, 0, e, n, n, n, n, e, e, f},
	{"int.bo", &z[178], x, 0, e, n, n, n, n, e, e, f},
	{"mil.bo", &z[178], x, 0, e, n, n, n, n, e, e, f},
	{"net.bo", &z[178], x, 0, e, n, n, n, n, e, e, f},
	{"org.bo", &z[178], x, 0, e, n, n, n, n, e, e, f},
	{"tv.bo", &z[178], x, 0, e, n, n, n, n, e, e, f},
	{"abc.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"adm.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"adv.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"agr.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"am.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"aparecida.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"app.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"arq.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"art.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"ato.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"b.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"belem.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"bhz.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"bib.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"bio.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"blog.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"bmd.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"boavista.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"bsb.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"campinas.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"caxias.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"cim.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"cng.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"cnt.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"com.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"coop.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"coz.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"curitiba.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"des.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"det.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"dev.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"ecn.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"eco.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"edu.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"emp.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"enf.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"eng.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"esp.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"etc.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"eti.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"far.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"flog.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"floripa.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"fm.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"fnd.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"fortal.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"fot.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"foz.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"fst.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"g12.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"geo.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"ggf.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"gov.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"gru.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"imb.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"ind.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"inf.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"jampa.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"jor.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"jus.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"lel.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"log.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"macapa.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"maceio.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"manaus.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"mat.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"med.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"mil.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"mus.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"natal.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"net.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"nom.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"not.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"ntr.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"odo.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"org.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"palmas.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"poa.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"ppg.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"pro.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"psc.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"psi.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"qsl.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"radio.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"rec.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"recife.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"rep.br", &z[194], z[5096:5097], 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"rio.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"salvador.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"sec3.br", &z[194], x, 0, e, n, n, n, n, e, e, t},
	{"seg.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"sjc.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"slg.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"srv.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"taxi.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"tec.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"teo.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"tmp.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"trd.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"tur.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"tv.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"vet.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"vix.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"vlog.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"wiki.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"zlg.br", &z[194], x, 0, e, w{"a.dns.br", "b.dns.br", "c.dns.br", "d.dns.br", "e.dns.br", "f.dns.br"}, n, n, n, e, e, t},
	{"com.bs", &z[201], x, 0, e, n, n, n, n, e, e, f},
	{"edu.bs", &z[201], x, 0, e, n, n, n, n, e, e, f},
	{"gov.bs", &z[201], x, 0, e, w{"ib-ext1.gov.bs", "ib-ext2.gov.bs", "ibgb-ext1.gov.bs", "ibgb-ext2.gov.bs"}, n, n, n, e, e, f},
	{"net.bs", &z[201], x, 0, e, n, n, n, n, e, e, f},
	{"org.bs", &z[201], x, 0, e, n, n, n, n, e, e, f},
	{"we.bs", &z[201], x, 0, e, w{"ns1.nic.we.bs", "ns2.nic.we.bs"}, n, n, n, e, e, t},
	{"com.bt", &z[202], x, 0, e, w{"ns1.druknet.bt", "ns2.druknet.bt", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"edu.bt", &z[202], x, 0, e, w{"ns1.druknet.bt", "ns2.druknet.bt", "phloem.uoregon.edu"}, n, n, n, e, e, t},
	{"gov.bt", &z[202], x, 0, e, w{"ns1.druknet.bt", "ns2.druknet.bt"}, n, n, n, e, e, t},
	{"net.bt", &z[202], x, 0, e, w{"ns1.druknet.bt", "ns2.druknet.bt"}, n, n, n, e, e, t},
	{"org.bt", &z[202], x, 0, e, w{"ns1.druknet.bt", "ns2.druknet.bt", "phloem.uoregon.edu"}, n, n, n, e, e, t},
	{"ac.bw", &z[212], x, 0, e, n, n, n, n, e, e, t},
	{"co.bw", &z[212], x, 0, e, n, n, n, n, e, e, f},
	{"net.bw", &z[212], x, 0, e, n, n, n, n, e, e, f},
	{"org.bw", &z[212], x, 0, e, n, n, n, n, e, e, f},
	{"com.by", &z[214], x, 0, e, w{"a1.domain.by", "a2.domain.by"}, n, n, n, e, e, f},
	{"gov.by", &z[214], x, 0, e, w{"u1.hoster.by", "u2.hoster.by"}, n, n, n, e, e, f},
	{"mil.by", &z[214], x, 0, e, w{"ns1.oac.gov.by", "u1.hoster.by", "u2.hoster.by"}, n, n, n, e, e, f},
	{"minsk.by", &z[214], x, 0, e, w{"a1.domain.by", "a2.domain.by"}, n, n, n, e, e, f},
	{"net.by", &z[214], x, 0, e, w{"a1.domain.by", "a2.domain.by"}, n, n, n, e, e, f},
	{"co.bz", &z[215], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"com.bz", &z[215], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"edu.bz", &z[215], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"gov.bz", &z[215], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"net.bz", &z[215], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"org.bz", &z[215], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"za.bz", &z[215], x, 0, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net", "ns5.centralnic.net"}, n, n, n, "whois.centralnic.com", e, t},
	{"ab.ca", &z[217], x, 0, e, n, n, n, n, e, e, f},
	{"bc.ca", &z[217], x, 0, e, n, n, n, n, e, e, f},
	{"co.ca", &z[217], x, 0x200, e, w{"primary.relay.co.ca", "quaternary.relay.co.ca", "quinary.relay.co.ca", "secondary.relay.co.ca", "senary.relay.co.ca", "tertiary.relay.co.ca"}, n, n, n, "whois.co.ca", e, t},
	{"gc.ca", &z[217], x, 0, e, w{"dns1.nrc.ca", "dns2.nrc.ca", "ns1.d-zone.ca", "ns2.d-zone.ca"}, n, n, n, e, e, f},
	{"mb.ca", &z[217], x, 0, e, n, n, n, n, e, e, f},
	{"nb.ca", &z[217], x, 0, e, n, n, n, n, e, e, f},
	{"nf.ca", &z[217], x, 0, e, n, n, n, n, e, e, f},
	{"nl.ca", &z[217], x, 0, e, n, n, n, n, e, e, f},
	{"ns.ca", &z[217], x, 0, e, n, n, n, n, e, e, f},
	{"nt.ca", &z[217], x, 0, e, n, n, n, n, e, e, f},
	{"nu.ca", &z[217], x, 0, e, n, n, n, n, e, e, f},
	{"on.ca", &z[217], x, 0, e, n, n, n, n, e, e, f},
	{"pe.ca", &z[217], x, 0, e, n, n, n, n, e, e, f},
	{"qc.ca", &z[217], x, 0, e, n, n, n, n, e, e, f},
	{"sk.ca", &z[217], x, 0, e, n, n, n, n, e, e, f},
	{"yk.ca", &z[217], x, 0, e, n, n, n, n, e, e, f},
	{"com.cc", &z[256], x, 0, e, w{"ns-1287.awsdns-32.org", "ns-1613.awsdns-09.co.uk", "ns-472.awsdns-59.com", "ns-680.awsdns-21.net"}, n, n, n, e, e, t},
	{"edu.cc", &z[256], x, 0, e, w{"ns1.netdns.co.nz", "ns2.netdns.co.nz"}, n, n, n, e, e, t},
	{"net.cc", &z[256], x, 0, e, w{"ns-1028.awsdns-00.org", "ns-1980.awsdns-55.co.uk", "ns-218.awsdns-27.com", "ns-779.awsdns-33.net"}, n, n, n, e, e, t},
	{"org.cc", &z[256], x, 0, e, w{"ns.cocca.fr", "ns.coccaregistry.org"}, n, n, n, e, e, t},
	{"ac.cd", &z[257], x, 0, e, n, n, n, n, e, e, t},
	{"com.cd", &z[257], x, 0, e, n, n, n, n, e, e, t},
	{"edu.cd", &z[257], x, 0, e, n, n, n, n, e, e, t},
	{"gouv.cd", &z[257], x, 0, e, n, n, n, n, e, e, t},
	{"net.cd", &z[257], x, 0, e, w{"ns-root-21.scpt-network.net", "ns-root-22.scpt-network.net"}, n, n, n, e, e, f},
	{"org.cd", &z[257], x, 0, e, n, n, n, n, e, e, f},
	{"ac.ci", &z[285], x, 0, e, w{"any.nic.ci", "censvrns0001.ird.fr", "ci.hosting.nic.fr", "ns-ci.afrinic.net", "ns.nic.ci", "ns1.nic.ci", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"aeroport.ci", &z[285], x, 0, e, n, n, n, n, e, e, f},
	{"asso.ci", &z[285], x, 0, "https://www.nic.ci/", w{"a.dnspod.com", "b.dnspod.com", "c.dnspod.com"}, n, n, n, e, e, t},
	{"assoc.ci", &z[285], x, 0, e, n, n, n, n, e, e, t},
	{"co.ci", &z[285], x, 0, e, w{"any.nic.ci", "censvrns0001.ird.fr", "ci.hosting.nic.fr", "ns-ci.afrinic.net", "ns.nic.ci", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"com.ci", &z[285], x, 0, e, w{"any.nic.ci", "censvrns0001.ird.fr", "ci.cctld.authdns.ripe.net", "ci.hosting.nic.fr", "ns-ci.afrinic.net", "ns.nic.ci", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"ed.ci", &z[285], x, 0, e, w{"any.nic.ci", "censvrns0001.ird.fr", "ci.cctld.authdns.ripe.net", "ci.hosting.nic.fr", "ns-ci.afrinic.net", "ns.nic.ci", "ns1.nic.ci", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"edu.ci", &z[285], x, 0, e, w{"any.nic.ci", "censvrns0001.ird.fr", "ci.hosting.nic.fr", "ns-ci.afrinic.net", "ns.nic.ci", "ns1.nic.ci", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"go.ci", &z[285], x, 0, e, w{"any.nic.ci", "censvrns0001.ird.fr", "ci.hosting.nic.fr", "ns-ci.afrinic.net", "ns.nic.ci", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"gov.ci", &z[285], x, 0, e, w{"any.nic.ci", "censvrns0001.ird.fr", "ci.hosting.nic.fr", "ns-ci.afrinic.net", "ns.nic.ci", "phloem.uoregon.edu"}, n, n, n, e, e, t},
	{"in.ci", &z[285], x, 0, e, w{"any.nic.ci", "censvrns0001.ird.fr", "ci.hosting.nic.fr", "ns-ci.afrinic.net", "ns.nic.ci", "ns1.nic.ci", "phloem.uoregon.edu"}, n, n, n, e, e, t},
	{"int.ci", &z[285], x, 0, e, w{"any.nic.ci", "censvrns0001.ird.fr", "ci.hosting.nic.fr", "ns-ci.afrinic.net", "ns.nic.ci", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"net.ci", &z[285], x, 0, e, w{"any.nic.ci", "censvrns0001.ird.fr", "ci.hosting.nic.fr", "ns-ci.afrinic.net", "ns.nic.ci", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"nom.ci", &z[285], x, 0, e, w{"any.nic.ci", "censvrns0001.ird.fr", "ci.cctld.authdns.ripe.net", "ci.hosting.nic.fr", "ns-ci.afrinic.net", "ns.nic.ci", "phloem.uoregon.edu"}, n, n, n, e, e, t},
	{"or.ci", &z[285], x, 0, e, w{"any.nic.ci", "censvrns0001.ird.fr", "ci.hosting.nic.fr", "ns-ci.afrinic.net", "ns.nic.ci", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"org.ci", &z[285], x, 0, e, w{"any.nic.ci", "censvrns0001.ird.fr", "ci.hosting.nic.fr", "ns-ci.afrinic.net", "ns.nic.ci", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"presse.ci", &z[285], x, 0, e, w{"a.dnspod.com", "b.dnspod.com", "c.dnspod.com"}, n, n, n, e, e, f},
	{"biz.ck", &z[295], x, 0, e, n, n, n, n, e, e, f},
	{"co.ck", &z[295], x, 0, e, n, n, n, n, e, e, f},
	{"edu.ck", &z[295], x, 0, e, n, n, n, n, e, e, f},
	{"gen.ck", &z[295], x, 0, e, n, n, n, n, e, e, f},
	{"gov.ck", &z[295], x, 0, e, n, n, n, n, e, e, f},
	{"info.ck", &z[295], x, 0, e, n, n, n, n, e, e, f},
	{"net.ck", &z[295], x, 0, e, n, n, n, n, e, e, f},
	{"org.ck", &z[295], x, 0, e, n, n, n, n, e, e, f},
	{"co.cm", &z[306], x, 0, e, w{"a.cm.dyntld.net", "b.cm.dyntld.net", "ns1.nic.cm", "ns2.nic.cm"}, n, n, n, e, e, f},
	{"com.cm", &z[306], x, 0, e, w{"a.cm.dyntld.net", "b.cm.dyntld.net", "ns1.nic.cm", "ns2.nic.cm"}, n, n, n, e, e, f},
	{"edu.cm", &z[306], x, 0, e, w{"ns1.nic.cm", "ns2.nic.cm"}, w{"85.25.140.105"}, n, n, e, e, t},
	{"net.cm", &z[306], x, 0, e, w{"a.cm.dyntld.net", "b.cm.dyntld.net", "ns1.nic.cm", "ns2.nic.cm"}, n, n, n, e, e, f},
	{"ac.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"ah.cn", &z[307], x, 0, "https://www.belizenic.bz/", w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"bj.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"com.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"cq.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"edu.cn", &z[307], x, 0, e, w{"deneb.dfn.de", "dns.edu.cn", "dns2.edu.cn", "ns2.cernet.net", "ns2.cuhk.hk"}, n, n, n, "whois.edu.cn", e, f},
	{"fj.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"gd.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"gov.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"gs.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"gx.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"gz.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"ha.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"hb.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"he.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"hi.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"hk.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"hl.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"hn.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"jl.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"js.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"jx.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"keyword.cn", &z[307], z[5097:5098], 0, e, w{"ns11.xincache.com", "ns12.xincache.com"}, n, n, n, e, e, t},
	{"ln.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"mil.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn", "ns3.mil.cn", "ns4.mil.cn"}, n, n, n, e, e, t},
	{"mo.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"net.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"nm.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"nx.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"org.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"qh.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"sc.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"sd.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"sh.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"sn.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"sx.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"tj.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"tw.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"xj.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"xz.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"yn.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"zj.cn", &z[307], x, 0, e, w{"a.dns.cn", "b.dns.cn", "c.dns.cn", "cns.cernet.net", "d.dns.cn", "e.dns.cn", "f.dns.cn", "g.dns.cn"}, n, n, n, e, e, f},
	{"com.co", &z[308], x, 0, e, n, n, n, n, e, e, f},
	{"edu.co", &z[308], x, 0, e, n, n, n, n, e, e, f},
	{"gov.co", &z[308], x, 0, e, n, n, n, n, e, e, f},
	{"mil.co", &z[308], x, 0, e, n, n, n, n, e, e, f},
	{"net.co", &z[308], x, 0, e, n, n, n, n, e, e, f},
	{"nom.co", &z[308], x, 0, e, n, n, n, n, e, e, f},
	{"org.co", &z[308], x, 0, e, n, n, n, n, e, e, f},
	{"4u.com", &z[314], x, 0x200, e, w{"ns1.registry-servers.4u.com", "ns2.registry-servers.4u.com", "ns3.registry-servers.4u.com", "ns4.registry-servers.4u.com", "ns5.registry-servers.4u.com", "ns6.registry-servers.4u.com"}, n, n, n, e, e, t},
	{"ae.com", &z[314], x, 0x200, e, w{"asia3.akam.net", "eur2.akam.net", "eur5.akam.net", "ns1-161.akam.net", "ns1-163.akam.net", "usc3.akam.net", "use4.akam.net", "usw1.akam.net"}, n, n, n, e, e, t},
	{"africa.com", &z[314], x, 0x200, e, w{"ns2.dns.business", "ns3.dns.business", "ns4.dns.business"}, n, n, n, "whois.centralnic.com", e, f},
	{"ar.com", &z[314], x, 0x200, e, w{"pdns07.domaincontrol.com", "pdns08.domaincontrol.com"}, n, n, n, "whois.centralnic.com", e, t},
	{"asia.com", &z[314], x, 0x200, e, w{"pdns1.ultradns.net", "pdns2.ultradns.net", "pdns3.ultradns.org", "pdns4.ultradns.org", "pdns5.ultradns.info", "pdns6.ultradns.co.uk"}, w{"72.55.150.59"}, n, n, e, e, f},
	{"au.com", &z[314], x, 0x200, e, w{"dns103.kddi.ne.jp", "dns104.kddi.ne.jp", "dnsa01.kddi.ne.jp", "dnsa02.kddi.ne.jp"}, n, n, n, e, e, f},
	{"br.com", &z[314], x, 0x200, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"54.153.56.183", "br.com"}, n, n, "whois.centralnic.com", e, t},
	{"cn.com", &z[314], x, 0x200, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"54.153.56.183", "cn.com"}, n, n, "whois.centralnic.com", e, t},
	{"co.com", &z[314], x, 0x200, "https://registry.co.com/", w{"ns1.nic.co.com", "ns2.nic.co.com", "ns3.nic.co.com", "ns4.nic.co.com"}, w{"173.192.115.17"}, n, n, "whois.centralnic.net", e, t},
	{"de.com", &z[314], x, 0x200, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"54.153.56.183", "de.com"}, n, n, "whois.centralnic.com", e, t},
	{"eu.com", &z[314], x, 0x200, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"54.153.56.183", "eu.com"}, n, n, "whois.centralnic.com", e, t},
	{"gb.com", &z[314], x, 0x200, e, w{"ns-cloud-a1.googledomains.com", "ns-cloud-a2.googledomains.com", "ns-cloud-a3.googledomains.com", "ns-cloud-a4.googledomains.com"}, n, n, n, "whois.centralnic.com", e, t},
	{"gr.com", &z[314], x, 0x200, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"72.34.38.11"}, n, n, "whois.centralnic.com", e, f},
	{"hk.com", &z[314], x, 0x200, e, w{"a.udrtld.net", "b.udrtld.net", "c.udrtld.net", "dns7.cloudns.net", "dns8.cloudns.net"}, n, n, n, "whois.registry.hk.com", e, f},
	{"hu.com", &z[314], x, 0x200, e, w{"ns3.dns.com", "ns4.dns.com"}, n, n, n, "whois.centralnic.com", e, t},
	{"jpn.com", &z[314], x, 0x200, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"54.153.56.183", "jpn.com"}, n, n, "whois.centralnic.com", e, t},
	{"kr.com", &z[314], x, 0x200, e, w{"jm1.dns.com", "jm2.dns.com"}, n, n, n, "whois.centralnic.com", e, t},
	{"mex.com", &z[314], x, 0x200, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"54.153.56.183", "mex.com"}, n, n, e, e, f},
	{"no.com", &z[314], x, 0x200, e, w{"pdns07.domaincontrol.com", "pdns08.domaincontrol.com"}, n, n, n, "whois.centralnic.com", e, t},
	{"nv.com", &z[314], x, 0x200, e, w{"a.root-servers.nv.com", "b.root-servers.nv.com", "c.root-servers.nv.com", "d.root-servers.nv.com", "e.root-servers.nv.com", "f.root-servers.nv.com", "g.root-servers.nv.com"}, w{"205.159.223.111", "hosting.gi.net"}, n, n, e, e, f},
	{"pty-ltd.com", &z[314], x, 0x200, e, w{"ns1.instradns.com", "ns2.instradns.com", "ns3.instradns.com"}, n, n, n, e, e, f},
	{"qb.com", &z[314], x, 0x200, e, w{"betty.ns.cloudflare.com", "scott.ns.cloudflare.com"}, n, n, n, e, e, f},
	{"qc.com", &z[314], x, 0x200, e, w{"pdns07.domaincontrol.com", "pdns08.domaincontrol.com"}, n, n, n, "whois.centralnic.com", e, t},
	{"ru.com", &z[314], x, 0x200, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"141.8.226.34"}, n, n, "whois.centralnic.com", e, t},
	{"sa.com", &z[314], x, 0x200, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"141.8.226.34"}, n, n, "whois.centralnic.com", e, t},
	{"se.com", &z[314], x, 0x200, e, w{"ns1.perf1.com", "ns2.perf1.fr", "ns3.perf1.eu", "ns4.perf1.de", "ns5.perf1.asia"}, n, n, n, "whois.centralnic.com", e, t},
	{"uk.com", &z[314], x, 0x200, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"54.153.56.183", "uk.com"}, n, n, "whois.centralnic.com", e, t},
	{"ukots.com", &z[314], x, 0, e, w{"ns43.domaincontrol.com", "ns44.domaincontrol.com"}, n, n, n, e, e, t},
	{"us.com", &z[314], x, 0x200, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"54.153.56.183", "us.com"}, n, n, "whois.centralnic.com", e, t},
	{"uy.com", &z[314], x, 0x200, e, w{"ns49.domaincontrol.com", "ns50.domaincontrol.com"}, n, n, n, "whois.centralnic.com", e, t},
	{"za.com", &z[314], x, 0x200, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"141.8.226.34"}, n, n, "whois.centralnic.com", e, t},
	{"de.cool", &z[330], x, 0, e, w{"jake.ns.cloudflare.com", "jill.ns.cloudflare.com"}, w{"2a00:f48:2000:affe::50", "91.216.248.20", "91.216.248.21", "91.216.248.22"}, n, n, e, e, t},
	{"ac.cr", &z[339], x, 0, e, w{"a.lactld.org", "ca1.nic.cr", "ca2.nic.cr", "de.nic.cr", "dns.nic.cr", "p.nic.cr"}, n, n, n, e, e, f},
	{"co.cr", &z[339], x, 0, e, w{"a.lactld.org", "ca1.nic.cr", "ca2.nic.cr", "de.nic.cr", "dns.nic.cr", "p.nic.cr"}, n, n, n, e, e, f},
	{"ed.cr", &z[339], x, 0, e, w{"a.lactld.org", "ca1.nic.cr", "ca2.nic.cr", "de.nic.cr", "dns.nic.cr", "p.nic.cr"}, n, n, n, e, e, t},
	{"eu.cr", &z[339], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "eu.cr"}, n, n, e, e, t},
	{"fi.cr", &z[339], x, 0, e, w{"a.lactld.org", "ca1.nic.cr", "ca2.nic.cr", "de.nic.cr", "dns.nic.cr", "p.nic.cr"}, n, n, n, e, e, f},
	{"go.cr", &z[339], x, 0, e, w{"a.lactld.org", "ca1.nic.cr", "ca2.nic.cr", "de.nic.cr", "dns.nic.cr", "p.nic.cr"}, n, n, n, e, e, f},
	{"or.cr", &z[339], x, 0, e, w{"a.lactld.org", "ca1.nic.cr", "ca2.nic.cr", "de.nic.cr", "dns.nic.cr", "p.nic.cr"}, n, n, n, e, e, f},
	{"sa.cr", &z[339], x, 0, e, w{"a.lactld.org", "ca1.nic.cr", "ca2.nic.cr", "de.nic.cr", "dns.nic.cr", "p.nic.cr"}, n, n, n, e, e, f},
	{"co.cu", &z[349], x, 0, e, w{"ns3.etecsa.net", "ns3.etecsa.net.cu", "ns4.etecsa.net", "ns4.etecsa.net.cu", "ns5.etecsa.net"}, n, n, n, e, e, f},
	{"com.cu", &z[349], x, 0, e, w{"canada.cuba.cu", "ns.ceniai.net.cu", "ns.citmatel.com.cu"}, n, n, n, e, e, f},
	{"cuba.cu", &z[349], x, 0, e, n, n, n, n, e, e, f},
	{"cyt.cu", &z[349], x, 0, e, w{"mail1.tur.cu", "mail2.tur.cu", "ns1.tur.cu"}, n, n, n, e, e, f},
	{"edu.cu", &z[349], x, 0, e, w{"canada.cuba.cu", "cu.cctld.authdns.ripe.net", "ns.ceniai.net.cu", "ns.citmatel.com.cu", "rip.psg.com"}, n, n, n, e, e, f},
	{"get.cu", &z[349], x, 0, e, w{"mail1.tur.cu", "mail2.tur.cu", "ns1.tur.cu"}, n, n, n, e, e, f},
	{"gov.cu", &z[349], x, 0, e, n, n, n, n, e, e, f},
	{"inf.cu", &z[349], x, 0, e, n, n, n, n, e, e, f},
	{"net.cu", &z[349], x, 0, e, n, n, n, n, e, e, f},
	{"org.cu", &z[349], x, 0, e, n, n, n, n, e, e, f},
	{"tur.cu", &z[349], x, 0, e, w{"ns.ceniai.net.cu", "ns1.g4its.com", "ns1.tur.cu", "ns2.g4its.com", "ns2.tur.cu", "ns3.tur.cu", "ns4.tur.cu", "ns5.tur.cu"}, n, n, n, e, e, f},
	{"com.cv", &z[351], x, 0, e, n, n, n, n, e, e, f},
	{"edu.cv", &z[351], x, 0, e, n, n, n, n, e, e, t},
	{"gov.cv", &z[351], x, 0, e, w{"ns1.gov.cv", "ns2.gov.cv"}, n, n, n, e, e, f},
	{"int.cv", &z[351], x, 0, e, n, n, n, n, e, e, f},
	{"net.cv", &z[351], x, 0, e, n, n, n, n, e, e, f},
	{"nome.cv", &z[351], x, 0, e, n, n, n, n, e, e, f},
	{"org.cv", &z[351], x, 0, e, n, n, n, n, e, e, f},
	{"publ.cv", &z[351], x, 0, e, n, n, n, n, e, e, f},
	{"com.cw", &z[352], x, 0, e, n, n, n, n, e, e, f},
	{"net.cw", &z[352], x, 0, e, n, n, n, n, e, e, f},
	{"com.cx", &z[353], x, 0, e, w{"ns.anycast.nic.cx", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, t},
	{"edu.cx", &z[353], x, 0, e, w{"ns.anycast.nic.cx", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, t},
	{"gov.cx", &z[353], x, 0, e, w{"ns.anycast.nic.cx", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"net.cx", &z[353], x, 0, e, w{"ns.anycast.nic.cx"}, n, n, n, e, e, t},
	{"org.cx", &z[353], x, 0, e, w{"ns.anycast.nic.cx"}, n, n, n, e, e, t},
	{"ac.cy", &z[354], x, 0, e, w{"cy-ns.anycast.pch.net", "cynic.dns.cy", "cynic4.dns.cy", "cynic6.dns.cy", "estia.ics.forth.gr", "ns02.savvis.net", "ns31.rcode0.net", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"biz.cy", &z[354], x, 0, e, w{"cy-ns.anycast.pch.net", "cynic.dns.cy", "cynic4.dns.cy", "cynic6.dns.cy", "estia.ics.forth.gr", "ns02.savvis.net", "ns31.rcode0.net", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"com.cy", &z[354], x, 0, e, w{"cy-ns.anycast.pch.net", "cynic.dns.cy", "cynic4.dns.cy", "cynic6.dns.cy", "estia.ics.forth.gr", "ns02.savvis.net", "ns31.rcode0.net", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"ekloges.cy", &z[354], x, 0, e, w{"cy-ns.anycast.pch.net", "cynic.dns.cy", "cynic4.dns.cy", "cynic6.dns.cy", "estia.ics.forth.gr", "ns02.savvis.net", "ns31.rcode0.net", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"gov.cy", &z[354], x, 0, e, w{"dns.cit.cornell.edu", "ns01.gov.cy", "ns02.gov.cy", "sns0.grnet.gr", "sns1.grnet.gr"}, n, n, n, e, e, f},
	{"ltd.cy", &z[354], x, 0, e, w{"cy-ns.anycast.pch.net", "cynic.dns.cy", "cynic4.dns.cy", "cynic6.dns.cy", "estia.ics.forth.gr", "ns02.savvis.net", "ns31.rcode0.net", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"name.cy", &z[354], x, 0, e, w{"cy-ns.anycast.pch.net", "cynic.dns.cy", "cynic4.dns.cy", "cynic6.dns.cy", "estia.ics.forth.gr", "ns02.savvis.net", "ns31.rcode0.net", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"net.cy", &z[354], x, 0, e, w{"cy-ns.anycast.pch.net", "cynic.dns.cy", "cynic4.dns.cy", "cynic6.dns.cy", "estia.ics.forth.gr", "ns02.savvis.net", "ns31.rcode0.net", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"org.cy", &z[354], x, 0, e, w{"cy-ns.anycast.pch.net", "cynic.dns.cy", "cynic4.dns.cy", "cynic6.dns.cy", "estia.ics.forth.gr", "ns02.savvis.net", "ns31.rcode0.net", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"parliament.cy", &z[354], x, 0, e, w{"ns01.gov.cy", "ns02.gov.cy"}, n, n, n, e, e, f},
	{"press.cy", &z[354], x, 0, e, w{"cy-ns.anycast.pch.net", "cynic.dns.cy", "cynic4.dns.cy", "cynic6.dns.cy", "estia.ics.forth.gr", "ns02.savvis.net", "ns31.rcode0.net", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"pro.cy", &z[354], x, 0, e, w{"cy-ns.anycast.pch.net", "cynic.dns.cy", "cynic4.dns.cy", "cynic6.dns.cy", "estia.ics.forth.gr", "ns02.savvis.net", "ns31.rcode0.net", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"tm.cy", &z[354], x, 0, e, w{"cy-ns.anycast.pch.net", "cynic.dns.cy", "cynic4.dns.cy", "cynic6.dns.cy", "estia.ics.forth.gr", "ns02.savvis.net", "ns31.rcode0.net", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"co.cz", &z[357], x, 0, e, w{"ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"1x.de", &z[368], x, 0x200, e, w{"ns1.dev.kv.de", "ns2.dev.kv.de"}, w{"1x.de", "95.217.58.108"}, n, n, e, e, t},
	{"co.de", &z[368], x, 0, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "co.de"}, n, n, "whois.co.de", e, t},
	{"com.de", &z[368], x, 0, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"54.153.56.183", "com.de"}, n, n, "whois.centralnic.com", e, f},
	{"biz.dk", &z[397], x, 0, e, w{"dns2000.euro-isp.net", "dns2001.euro-isp.net", "mail.digitalmarketing.net", "ns.digitalmarketing.net", "ns1.dk.org", "post.digitalmarketing.net", "root-dns.euro-isp.net"}, n, n, n, e, e, f},
	{"co.dk", &z[397], x, 0, e, w{"dns2000.euro-isp.net", "dns2001.euro-isp.net", "mail.digitalmarketing.net", "ns.digitalmarketing.net", "ns1.dk.org", "post.digitalmarketing.net", "root-dns.euro-isp.net"}, n, n, n, e, e, f},
	{"co.dm", &z[398], x, 0, e, w{"ns.blacknightsolutions.com", "ns1.uniregistry.net", "ns2.blacknightsolutions.com", "ns2.nic.dm", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns34.cdns.net", "ns4.uniregistry.info"}, n, n, n, e, e, f},
	{"com.dm", &z[398], x, 0, e, w{"ns.blacknightsolutions.com", "ns2.blacknightsolutions.com", "ns2.nic.dm", "ns34.cdns.net"}, n, n, n, e, e, f},
	{"edu.dm", &z[398], x, 0, e, w{"ns.blacknightsolutions.com", "ns1.uniregistry.net", "ns2.blacknightsolutions.com", "ns2.nic.dm", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns34.cdns.net", "ns4.uniregistry.info"}, n, n, n, e, e, f},
	{"gov.dm", &z[398], x, 0, e, w{"ns.blacknightsolutions.com", "ns1.uniregistry.net", "ns2.blacknightsolutions.com", "ns2.nic.dm", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns34.cdns.net", "ns4.uniregistry.info"}, n, n, n, e, e, f},
	{"net.dm", &z[398], x, 0, e, w{"ns.blacknightsolutions.com", "ns2.blacknightsolutions.com", "ns2.nic.dm", "ns34.cdns.net"}, n, n, n, e, e, f},
	{"org.dm", &z[398], x, 0, e, w{"ns.blacknightsolutions.com", "ns2.blacknightsolutions.com", "ns2.nic.dm", "ns34.cdns.net"}, n, n, n, e, e, f},
	{"art.do", &z[401], x, 0, e, w{"a.lactld.org", "ns.nic.do", "ns1.nic.do", "ns2.nic.do", "ns3.nic.mx", "ns4.nic.do", "ns5.nic.do", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"com.do", &z[401], x, 0, e, w{"a.lactld.org", "ns.nic.do", "ns1.nic.do", "ns2.nic.do", "ns3.nic.mx", "ns4.nic.do", "ns5.nic.do", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"edu.do", &z[401], x, 0, e, w{"a.lactld.org", "ns.nic.do", "ns1.nic.do", "ns2.nic.do", "ns3.nic.mx", "ns4.nic.do", "ns5.nic.do", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"gob.do", &z[401], x, 0, e, w{"a.lactld.org", "ns.nic.do", "ns1.nic.do", "ns2.nic.do", "ns3.nic.mx", "ns4.nic.do", "ns5.nic.do", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"gov.do", &z[401], x, 0, e, w{"a.lactld.org", "ns.nic.do", "ns1.nic.do", "ns2.nic.do", "ns3.nic.mx", "ns4.nic.do", "ns5.nic.do", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"mil.do", &z[401], x, 0, e, w{"a.lactld.org", "ns.nic.do", "ns1.nic.do", "ns2.nic.do", "ns3.nic.mx", "ns4.nic.do", "ns5.nic.do", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"net.do", &z[401], x, 0, e, w{"a.lactld.org", "ns.nic.do", "ns1.nic.do", "ns2.nic.do", "ns3.nic.mx", "ns4.nic.do", "ns5.nic.do", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"org.do", &z[401], x, 0, e, w{"a.lactld.org", "ns.nic.do", "ns1.nic.do", "ns2.nic.do", "ns3.nic.mx", "ns4.nic.do", "ns5.nic.do", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"sid.do", &z[401], x, 0, e, n, n, n, n, e, e, t},
	{"sld.do", &z[401], x, 0, e, w{"a.lactld.org", "ns.nic.do", "ns1.nic.do", "ns2.nic.do", "ns3.nic.mx", "ns4.nic.do", "ns5.nic.do", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"web.do", &z[401], x, 0, e, w{"a.lactld.org", "ns.nic.do", "ns1.nic.do", "ns2.nic.do", "ns3.nic.mx", "ns4.nic.do", "ns5.nic.do", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"art.dz", &z[425], x, 0, e, w{"ns1.nic.dz", "ns2.nic.dz"}, n, n, n, e, e, f},
	{"asso.dz", &z[425], x, 0, e, w{"ns1.nic.dz", "ns2.nic.dz"}, n, n, n, e, e, f},
	{"com.dz", &z[425], x, 0, e, w{"ns1.nic.dz", "ns2.nic.dz"}, n, n, n, e, e, f},
	{"edu.dz", &z[425], x, 0, e, w{"ns1.nic.dz", "ns2.nic.dz"}, n, n, n, e, e, f},
	{"gov.dz", &z[425], x, 0, e, w{"ns1.nic.dz", "ns2.nic.dz"}, n, n, n, e, e, f},
	{"net.dz", &z[425], x, 0, e, w{"ns1.nic.dz", "ns2.nic.dz"}, n, n, n, e, e, f},
	{"org.dz", &z[425], x, 0, e, w{"ns1.nic.dz", "ns2.nic.dz"}, n, n, n, e, e, f},
	{"pol.dz", &z[425], x, 0, e, w{"ns1.nic.dz", "ns2.nic.dz"}, n, n, n, e, e, f},
	{"com.ec", &z[428], x, 0, e, w{"a.lactld.org", "n2.nic.ec", "n3.dns.ec"}, n, n, n, e, e, f},
	{"edu.ec", &z[428], x, 0, e, w{"a.lactld.org", "n2.nic.ec", "n3.dns.ec"}, n, n, n, e, e, f},
	{"fin.ec", &z[428], x, 0, e, w{"a.lactld.org", "n2.nic.ec", "n3.dns.ec"}, n, n, n, e, e, f},
	{"gob.ec", &z[428], x, 0, e, w{"a.lactld.org", "n2.nic.ec", "n3.dns.ec"}, n, n, n, e, e, t},
	{"gov.ec", &z[428], x, 0, e, w{"a.lactld.org", "n2.nic.ec", "n3.dns.ec"}, n, n, n, e, e, f},
	{"info.ec", &z[428], x, 0, e, w{"a.lactld.org", "n2.nic.ec", "n3.dns.ec"}, n, n, n, e, e, f},
	{"med.ec", &z[428], x, 0, e, w{"a.lactld.org", "n2.nic.ec", "n3.dns.ec"}, n, n, n, e, e, f},
	{"mil.ec", &z[428], x, 0, e, w{"a.lactld.org", "n2.nic.ec", "n3.dns.ec"}, n, n, n, e, e, f},
	{"net.ec", &z[428], x, 0, e, w{"a.lactld.org", "n2.nic.ec", "n3.dns.ec"}, n, n, n, e, e, f},
	{"org.ec", &z[428], x, 0, e, w{"a.lactld.org", "n2.nic.ec", "n3.dns.ec"}, n, n, n, e, e, f},
	{"pro.ec", &z[428], x, 0, e, w{"a.lactld.org", "n2.nic.ec", "n3.dns.ec"}, n, n, n, e, e, f},
	{"co.ee", &z[434], x, 0, e, w{"ns.elkdata.ee", "ns2.elkdata.ee"}, n, n, n, e, e, f},
	{"com.ee", &z[434], x, 0, e, n, n, n, n, e, e, f},
	{"edu.ee", &z[434], x, 0, e, w{"ns.eenet.ee", "ns2.eenet.ee"}, n, n, n, e, e, f},
	{"fie.ee", &z[434], x, 0, e, n, n, n, n, e, e, f},
	{"gov.ee", &z[434], x, 0, e, w{"ans2.aso.ee", "company.e-resident.gov.ee", "ns.gov.ee"}, n, n, n, e, e, f},
	{"hiiumaa.ee", &z[434], x, 0, e, w{"ns.zone.eu", "ns2.zone.ee", "ns3.zonedata.net"}, w{"217.146.69.46"}, n, n, e, e, f},
	{"kul.ee", &z[434], x, 0, e, w{"ans2.aso.ee", "ns1.rmit.ee", "ns2.rmit.ee"}, n, n, n, e, e, f},
	{"med.ee", &z[434], x, 0, e, n, n, n, n, e, e, t},
	{"org.ee", &z[434], x, 0, e, w{"ns.eenet.ee", "ns2.eenet.ee"}, n, n, n, e, e, f},
	{"parnu.ee", &z[434], x, 0, e, w{"ns.eenet.ee", "ns2.eenet.ee"}, n, n, n, e, e, f},
	{"parnumaa.ee", &z[434], x, 0, e, w{"ns.elkdata.ee", "ns2.elkdata.ee", "ns3.elkdata.net"}, n, n, n, e, e, f},
	{"polvamaa.ee", &z[434], x, 0, e, w{"ns.zone.eu", "ns2.zone.ee", "ns3.zonedata.net"}, n, n, n, e, e, f},
	{"pri.ee", &z[434], x, 0, e, n, n, n, n, e, e, f},
	{"tartu.ee", &z[434], x, 0, e, w{"ns.eenet.ee", "ns2.eenet.ee"}, n, n, n, e, e, f},
	{"com.eg", &z[435], x, 0, e, w{"frcu.eun.eg", "ns.idsc.gov.eg", "rip.psg.com"}, n, n, n, e, e, f},
	{"edu.eg", &z[435], x, 0, e, w{"frcu.eun.eg", "ns.idsc.gov.eg", "rip.psg.com"}, n, n, n, e, e, f},
	{"eun.eg", &z[435], x, 0, e, w{"frcu.eun.eg", "ns.idsc.gov.eg", "rip.psg.com"}, n, n, n, e, e, f},
	{"gov.eg", &z[435], x, 0, e, w{"frcu.eun.eg", "ns.idsc.gov.eg", "rip.psg.com"}, n, n, n, e, e, f},
	{"info.eg", &z[435], x, 0, e, w{"frcu.eun.eg", "rip.psg.com"}, n, n, n, e, e, f},
	{"mil.eg", &z[435], x, 0, e, w{"frcu.eun.eg", "rip.psg.com"}, n, n, n, e, e, f},
	{"name.eg", &z[435], x, 0, e, w{"frcu.eun.eg", "ns.idsc.gov.eg", "rip.psg.com"}, n, n, n, e, e, f},
	{"net.eg", &z[435], x, 0, e, w{"frcu.eun.eg", "ns.idsc.gov.eg", "rip.psg.com"}, n, n, n, e, e, f},
	{"org.eg", &z[435], x, 0, e, w{"frcu.eun.eg", "ns.idsc.gov.eg", "rip.psg.com", "www.frcu.eun.eg"}, n, n, n, e, e, f},
	{"sci.eg", &z[435], x, 0, e, w{"frcu.eun.eg", "ns.idsc.gov.eg", "rip.psg.com"}, n, n, n, e, e, f},
	{"sport.eg", &z[435], x, 0, e, w{"frcu.eun.eg", "ns.idsc.gov.eg", "rip.psg.com"}, n, n, n, e, e, t},
	{"tv.eg", &z[435], x, 0, e, w{"frcu.eun.eg", "ns.idsc.gov.eg", "rip.psg.com"}, n, n, n, e, e, f},
	{"com.er", &z[446], x, 0, e, w{"er.cctld.authdns.ripe.net", "ns0.punchdown.org", "ns1.punchdown.net", "sawanew.noc.net.er", "zaranew.noc.net.er"}, n, n, n, e, e, t},
	{"edu.er", &z[446], x, 0, e, w{"er.cctld.authdns.ripe.net", "ns0.punchdown.org", "ns1.punchdown.net", "sawanew.noc.net.er", "zaranew.noc.net.er"}, n, n, n, e, e, f},
	{"gov.er", &z[446], x, 0, e, w{"er.cctld.authdns.ripe.net", "ns0.punchdown.org", "ns1.punchdown.net", "sawanew.noc.net.er", "zaranew.noc.net.er"}, n, n, n, e, e, f},
	{"ind.er", &z[446], x, 0, e, w{"er.cctld.authdns.ripe.net", "ns0.punchdown.org", "ns1.punchdown.net", "sawanew.noc.net.er", "sawaold.noc.net.er", "zaranew.noc.net.er", "zaraold.noc.net.er"}, n, n, n, e, e, f},
	{"mil.er", &z[446], x, 0, e, w{"er.cctld.authdns.ripe.net", "ns0.punchdown.org", "ns1.punchdown.net", "sawanew.noc.net.er", "sawaold.noc.net.er", "zaranew.noc.net.er", "zaraold.noc.net.er"}, n, n, n, e, e, f},
	{"net.er", &z[446], x, 0, e, w{"er.cctld.authdns.ripe.net", "ns0.punchdown.org", "ns1.punchdown.net", "sawanew.noc.net.er", "zaranew.noc.net.er"}, n, n, n, e, e, f},
	{"org.er", &z[446], x, 0, e, w{"er.cctld.authdns.ripe.net", "ns0.punchdown.org", "ns1.punchdown.net", "sawanew.noc.net.er", "zaranew.noc.net.er"}, n, n, n, e, e, f},
	{"com.es", &z[449], x, 0, e, w{"c.nic.es", "fnicdos.rediris.es", "g.nic.es", "h.nic.es", "n3ns.nic.es", "ns3.nic.mx"}, n, n, n, e, e, f},
	{"edu.es", &z[449], x, 0, e, w{"c.nic.es", "fnicdos.rediris.es", "g.nic.es", "h.nic.es", "n3ns.nic.es", "ns3.nic.mx"}, n, n, n, e, e, f},
	{"gob.es", &z[449], x, 0, e, w{"c.nic.es", "fnicdos.rediris.es", "g.nic.es", "h.nic.es", "n3ns.nic.es", "ns3.nic.mx"}, n, n, n, e, e, f},
	{"nom.es", &z[449], x, 0, e, w{"c.nic.es", "fnicdos.rediris.es", "g.nic.es", "h.nic.es", "n3ns.nic.es", "ns3.nic.mx"}, n, n, n, e, e, f},
	{"org.es", &z[449], x, 0, e, w{"c.nic.es", "fnicdos.rediris.es", "g.nic.es", "h.nic.es", "n3ns.nic.es", "ns3.nic.mx"}, n, n, n, e, e, f},
	{"biz.et", &z[453], x, 0, e, w{"a.nic.et", "b.nic.et"}, n, n, n, e, e, f},
	{"com.et", &z[453], x, 0, e, w{"a.nic.et", "b.nic.et"}, n, n, n, e, e, f},
	{"edu.et", &z[453], x, 0, e, w{"a.nic.et", "b.nic.et"}, n, n, n, e, e, f},
	{"gov.et", &z[453], x, 0, e, w{"a.nic.et", "b.nic.et"}, n, n, n, e, e, f},
	{"info.et", &z[453], x, 0, e, w{"a.nic.et", "b.nic.et"}, n, n, n, e, e, f},
	{"name.et", &z[453], x, 0, e, w{"a.nic.et", "b.nic.et"}, n, n, n, e, e, f},
	{"net.et", &z[453], x, 0, e, w{"a.nic.et", "b.nic.et"}, n, n, n, e, e, f},
	{"org.et", &z[453], x, 0, e, w{"a.nic.et", "b.nic.et"}, n, n, n, e, e, f},
	{"24.eu", &z[455], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, n, n, n, e, e, t},
	{"ecb.eu", &z[455], x, 0, e, w{"auth02.ns.de.uu.net", "auth52.ns.de.uu.net", "ns1.de.colt.net", "ns8.colt.net"}, n, n, n, e, e, f},
	{"europa.eu", &z[455], x, 0, e, w{"ns1.bt.net", "ns1bru.europa.eu", "ns1lux.europa.eu", "ns2bru.europa.eu", "ns2eu.bt.net", "ns2lux.europa.eu", "ns3bru.europa.eu", "ns3lux.europa.eu", "ns4az1.europa.eu"}, n, n, n, e, e, f},
	{"ac.fj", &z[497], x, 0, e, n, n, n, n, e, e, t},
	{"biz.fj", &z[497], x, 0, e, n, n, n, n, e, e, f},
	{"com.fj", &z[497], x, 0, e, n, n, n, n, e, e, f},
	{"gov.fj", &z[497], x, 0, e, w{"dnssecondary.auth-servers.net", "itcns1.gov.fj", "itcns2.gov.fj", "ns-ext.vix.com", "tabua.tfl.com.fj"}, n, n, n, e, e, t},
	{"info.fj", &z[497], x, 0, e, n, n, n, n, e, e, f},
	{"mil.fj", &z[497], x, 0, e, n, n, n, n, e, e, f},
	{"name.fj", &z[497], x, 0, e, n, n, n, n, e, e, f},
	{"net.fj", &z[497], x, 0, e, n, n, n, n, e, e, f},
	{"org.fj", &z[497], x, 0, e, n, n, n, n, e, e, f},
	{"pro.fj", &z[497], x, 0, e, n, n, n, n, e, e, f},
	{"school.fj", &z[497], x, 0, e, w{"drua.tfl.com.fj", "ns-ext.isc.org", "tabua.tfl.com.fj"}, n, n, n, e, e, t},
	{"ac.fk", &z[498], x, 0, e, n, n, n, n, e, e, f},
	{"co.fk", &z[498], x, 0, e, n, n, n, n, e, e, f},
	{"gov.fk", &z[498], x, 0, e, w{"ns1.horizon.net.fk", "ns2.horizon.net.fk"}, n, n, n, e, e, f},
	{"net.fk", &z[498], x, 0, e, n, n, n, n, e, e, f},
	{"nom.fk", &z[498], x, 0, e, n, n, n, n, e, e, f},
	{"org.fk", &z[498], x, 0, e, n, n, n, n, e, e, f},
	{"0.fm", &z[507], x, 0, e, w{"ns1.bb-online.net", "ns2.bb-online.net"}, w{"0.fm", "139.162.244.72"}, n, n, e, e, t},
	{"2.fm", &z[507], x, 0, e, w{"ns1.idnz.net", "ns2.idnz.net", "ns3.idnz.net"}, w{"93.190.235.135"}, n, n, e, e, t},
	{"4.fm", &z[507], x, 0, e, w{"ns1.bb-online.net", "ns2.bb-online.net"}, w{"139.162.244.72", "4.fm"}, n, n, e, e, t},
	{"6.fm", &z[507], x, 0, e, w{"ns1.bb-online.net", "ns2.bb-online.net"}, w{"139.162.244.72", "6.fm"}, n, n, e, e, t},
	{"8.fm", &z[507], x, 0, e, w{"ns1.bb-online.net", "ns2.bb-online.net"}, w{"139.162.244.72", "8.fm"}, n, n, e, e, t},
	{"radio.fm", &z[507], x, 0, e, w{"a.nic.fm", "b.nic.fm", "c.nic.fm", "d.nic.fm"}, n, n, n, e, e, t},
	{"aero.fo", &z[508], x, 0, e, n, n, n, n, e, e, f},
	{"biz.fo", &z[508], x, 0, e, n, n, n, n, e, e, f},
	{"co.fo", &z[508], x, 0, e, w{"ns1.cctld.com", "ns2.cctld.com"}, n, n, n, e, e, f},
	{"com.fo", &z[508], x, 0, e, w{"ns1.cctld.com", "ns2.cctld.com"}, n, n, n, e, e, f},
	{"coop.fo", &z[508], x, 0, e, n, n, n, n, e, e, f},
	{"edu.fo", &z[508], x, 0, e, w{"ns1.nic.fo", "ns2.nic.fo", "ns3.nic.fo"}, n, n, n, e, e, f},
	{"flp.fo", &z[508], x, 0, e, n, n, n, n, e, e, f},
	{"ftp.fo", &z[508], x, 0, e, n, n, n, n, e, e, f},
	{"gov.fo", &z[508], x, 0, e, w{"ns1.olivant.fo", "ns2.olivant.fo"}, n, n, n, e, e, f},
	{"info.fo", &z[508], x, 0, e, w{"ns1.voodoo.com", "ns2.voodoo.com"}, w{"192.64.147.231"}, n, n, e, e, f},
	{"int.fo", &z[508], x, 0, e, n, n, n, n, e, e, f},
	{"internet.fo", &z[508], x, 0, e, w{"ns1.olivant.fo", "ns2.olivant.fo"}, n, n, n, e, e, f},
	{"irc.fo", &z[508], x, 0, e, n, n, n, n, e, e, f},
	{"mail.fo", &z[508], x, 0, e, w{"ns1.olivant.fo", "ns2.olivant.fo"}, n, n, n, e, e, f},
	{"mil.fo", &z[508], x, 0, e, w{"ns1.afriregister.com", "ns3.afriregister.com"}, n, n, n, e, e, f},
	{"museum.fo", &z[508], x, 0, e, n, n, n, n, e, e, f},
	{"name.fo", &z[508], x, 0, e, w{"ns1.gratisdns.dk", "ns2.gratisdns.dk"}, n, n, n, e, e, f},
	{"org.fo", &z[508], x, 0, e, w{"ns1.nic.fo", "ns2.nic.fo", "ns3.nic.fo"}, n, n, n, e, e, f},
	{"telenet.fo", &z[508], x, 0, e, n, n, n, n, e, e, f},
	{"telnet.fo", &z[508], x, 0, e, n, n, n, n, e, e, f},
	{"web.fo", &z[508], x, 0, e, n, n, n, n, e, e, f},
	{"www.fo", &z[508], x, 0, e, w{"ns1.nic.fo", "ns2.nic.fo", "ns3.nic.fo"}, n, n, n, e, e, f},
	{"aeroport.fr", &z[519], x, 0, e, w{"ns1.smallregistry.net", "ns2.smallregistry.net", "ns3.smallregistry.net", "ns4.smallregistry.net"}, n, n, n, "whois.smallregistry.net", e, t},
	{"asso.fr", &z[519], x, 0x800, e, n, n, n, n, e, e, f},
	{"avocat.fr", &z[519], x, 0, e, w{"ns1.smallregistry.net", "ns2.smallregistry.net", "ns3.smallregistry.net", "ns4.smallregistry.net"}, n, n, n, "whois.smallregistry.net", e, t},
	{"chambagri.fr", &z[519], x, 0, e, w{"ns1.smallregistry.net", "ns2.smallregistry.net", "ns3.smallregistry.net", "ns4.smallregistry.net"}, n, n, n, "whois.smallregistry.net", e, t},
	{"chirurgiens-dentistes.fr", &z[519], x, 0, e, w{"ns1.smallregistry.net", "ns2.smallregistry.net", "ns3.smallregistry.net", "ns4.smallregistry.net"}, n, n, n, "whois.smallregistry.net", e, t},
	{"com.fr", &z[519], x, 0x800, e, n, n, n, n, e, e, f},
	{"experts-comptables.fr", &z[519], x, 0, e, w{"ns1.smallregistry.net", "ns2.smallregistry.net", "ns3.smallregistry.net", "ns4.smallregistry.net"}, n, n, n, "whois.smallregistry.net", e, t},
	{"geometre-expert.fr", &z[519], x, 0, e, w{"ns1.smallregistry.net", "ns2.smallregistry.net", "ns3.smallregistry.net", "ns4.smallregistry.net"}, n, n, n, "whois.smallregistry.net", e, t},
	{"gouv.fr", &z[519], x, 0, e, n, n, n, n, e, e, f},
	{"medecin.fr", &z[519], x, 0, e, w{"ns1.smallregistry.net", "ns2.smallregistry.net", "ns3.smallregistry.net", "ns4.smallregistry.net"}, n, n, n, "whois.smallregistry.net", e, t},
	{"nom.fr", &z[519], x, 0, e, n, n, n, n, e, e, f},
	{"notaires.fr", &z[519], x, 0, e, w{"ns1.smallregistry.net", "ns2.smallregistry.net", "ns3.smallregistry.net", "ns4.smallregistry.net"}, n, n, n, "whois.smallregistry.net", e, t},
	{"pharmacien.fr", &z[519], x, 0, e, w{"ns1.smallregistry.net", "ns2.smallregistry.net", "ns3.smallregistry.net", "ns4.smallregistry.net"}, n, n, n, "whois.smallregistry.net", e, t},
	{"port.fr", &z[519], x, 0, e, w{"ns1.smallregistry.net", "ns2.smallregistry.net", "ns3.smallregistry.net", "ns4.smallregistry.net"}, n, n, n, "whois.smallregistry.net", e, t},
	{"prd.fr", &z[519], x, 0, e, w{"ns1.renater.fr", "ns2.renater.fr", "ns4.cnrs.fr"}, n, n, n, e, e, f},
	{"presse.fr", &z[519], x, 0, e, n, n, n, n, e, e, f},
	{"tm.fr", &z[519], x, 0x800, e, n, n, n, n, e, e, f},
	{"veterinaire.fr", &z[519], x, 0, e, w{"ns1.smallregistry.net", "ns2.smallregistry.net", "ns3.smallregistry.net", "ns4.smallregistry.net"}, n, n, n, "whois.smallregistry.net", e, t},
	{"ac.ga", &z[534], x, 0, e, n, n, n, n, e, e, f},
	{"aeroport.ga", &z[534], x, 0, e, w{"ns81.rookdns.com", "ns82.rookdns.com"}, n, n, n, e, e, f},
	{"asso.ga", &z[534], x, 0, e, w{"ns1.aninf.ga", "ns2.aninf.ga", "ns3.aninf.ga"}, n, n, n, e, e, f},
	{"co.ga", &z[534], x, 0, e, w{"isp1.ib.ga", "isp2.ib.ga", "ns.ripe.net", "nsi1.inet.ga", "nsi2.inet.ga"}, n, n, n, e, e, f},
	{"com.ga", &z[534], x, 0, e, n, n, n, n, e, e, f},
	{"ed.ga", &z[534], x, 0, e, n, n, n, n, e, e, f},
	{"edu.ga", &z[534], x, 0, e, n, n, n, n, e, e, f},
	{"go.ga", &z[534], x, 0, e, w{"ns81.rookdns.com", "ns82.rookdns.com"}, w{"141.8.224.221"}, n, n, e, e, f},
	{"int.ga", &z[534], x, 0, e, n, n, n, n, e, e, f},
	{"net.ga", &z[534], x, 0, e, n, n, n, n, e, e, f},
	{"or.ga", &z[534], x, 0, e, n, n, n, n, e, e, f},
	{"org.ga", &z[534], x, 0, e, w{"isp1.ib.ga", "isp2.ib.ga", "nsi1.inet.ga", "nsi2.inet.ga"}, n, n, n, e, e, f},
	{"presse.ga", &z[534], x, 0, e, n, n, n, n, e, e, f},
	{"hmg.gb", &z[545], x, 0x800, e, n, n, n, n, e, e, f},
	{"com.gd", &z[548], x, 0, e, n, n, n, n, e, e, t},
	{"edu.gd", &z[548], x, 0, e, w{"a.nic.gd", "b.nic.gd", "c.nic.gd", "d.nic.gd"}, n, n, n, e, e, f},
	{"gov.gd", &z[548], x, 0, e, w{"a.nic.gd", "b.nic.gd", "c.nic.gd", "d.nic.gd"}, n, n, n, e, e, f},
	{"mlt.gd", &z[548], x, 0, e, n, n, n, n, e, e, f},
	{"net.gd", &z[548], x, 0, e, n, n, n, n, e, e, f},
	{"org.gd", &z[548], x, 0, e, n, n, n, n, e, e, f},
	{"sci.gd", &z[548], x, 0, e, n, n, n, n, e, e, f},
	{"com.ge", &z[550], x, 0, e, w{"auth02.ns.uu.net", "ns.nic.ge"}, n, n, n, e, e, f},
	{"edu.ge", &z[550], x, 0, e, w{"auth02.ns.uu.net", "ns.nic.ge"}, n, n, n, e, e, f},
	{"gov.ge", &z[550], x, 0, e, w{"ns1.gov.ge", "ns2.gov.ge", "ns3.gov.ge"}, n, n, n, e, e, f},
	{"mil.ge", &z[550], x, 0, e, n, n, n, n, e, e, f},
	{"net.ge", &z[550], x, 0, e, w{"auth02.ns.uu.net", "ns.nic.ge"}, n, n, n, e, e, f},
	{"org.ge", &z[550], x, 0, e, w{"auth02.ns.uu.net", "ns.nic.ge"}, n, n, n, e, e, f},
	{"pvt.ge", &z[550], x, 0, e, w{"auth02.ns.uu.net", "ns.nic.ge"}, n, n, n, e, e, f},
	{"school.ge", &z[550], x, 0, e, w{"ns.nic.ge", "ns2.nic.ge"}, n, n, n, e, e, t},
	{"24.gg", &z[558], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "24.gg"}, n, n, e, e, t},
	{"ac.gg", &z[558], x, 0, e, w{"dns0.mtgsy.com", "dns1.name-s.net", "dns2.name-s.net", "dns3.mtgsy.com", "dns4.mtgsy.com"}, n, n, n, e, e, f},
	{"co.gg", &z[558], x, 0, e, w{"c.ci-servers.org", "dns1.nominetdns.uk", "dns2.nominetdns.uk", "dns3.nominetdns.uk", "dns4.nominetdns.uk"}, n, n, n, e, e, f},
	{"eu.gg", &z[558], x, 0x200, e, w{"ns1.dan.com", "ns2.dan.com"}, n, n, n, e, e, t},
	{"gov.gg", &z[558], x, 0, e, w{"dns1.name-s.net", "dns2.name-s.net", "dns3.mtgsy.com", "dns4.mtgsy.com", "gsy1.ns.mtgsy.com"}, n, n, n, e, e, f},
	{"net.gg", &z[558], x, 0, e, w{"c.ci-servers.org", "dns1.nominetdns.uk", "dns2.nominetdns.uk", "dns3.nominetdns.uk", "dns4.nominetdns.uk"}, n, n, n, e, e, f},
	{"org.gg", &z[558], x, 0, e, w{"c.ci-servers.org", "dns1.nominetdns.uk", "dns2.nominetdns.uk", "dns3.nominetdns.uk", "dns4.nominetdns.uk"}, n, n, n, e, e, f},
	{"sch.gg", &z[558], x, 0, e, w{"dns1.name-s.net", "dns2.name-s.net", "dns3.mtgsy.com", "dns4.mtgsy.com", "gsy1.ns.mtgsy.com"}, n, n, n, e, e, f},
	{"tr.gg", &z[558], x, 0, e, w{"ns01.webme.com", "ns02.webme.com"}, w{"193.238.27.36"}, n, n, e, e, f},
	{"tv.gg", &z[558], x, 0x200, e, n, n, n, n, e, e, t},
	{"web.gg", &z[558], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "web.gg"}, n, n, e, e, t},
	{"com.gh", &z[560], x, 0, e, w{"ns.dns.br", "ns1.nic.gh", "ns2.nic.gh"}, n, n, n, e, e, f},
	{"edu.gh", &z[560], x, 0, e, w{"ns.dns.br", "ns1.nic.gh", "ns2.nic.gh"}, n, n, n, e, e, f},
	{"gov.gh", &z[560], x, 0, e, w{"ns.dns.br", "ns1.nic.gh", "ns2.nic.gh"}, n, n, n, e, e, f},
	{"mil.gh", &z[560], x, 0, e, w{"ns.dns.br", "ns1.nic.gh", "ns2.nic.gh"}, n, n, n, e, e, f},
	{"net.gh", &z[560], x, 0, e, w{"ns.dns.br", "ns1.nic.gh", "ns2.nic.gh"}, n, n, n, e, e, t},
	{"org.gh", &z[560], x, 0, e, w{"ns.dns.br", "ns1.nic.gh", "ns2.nic.gh"}, n, n, n, e, e, f},
	{"com.gi", &z[561], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"edu.gi", &z[561], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"gov.gi", &z[561], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"ltd.gi", &z[561], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"mod.gi", &z[561], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"org.gi", &z[561], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"co.gl", &z[566], x, 0, e, w{"a.nuuk.nic.gl", "d.nic.gl"}, n, n, n, e, e, f},
	{"com.gl", &z[566], x, 0, e, w{"a.nuuk.nic.gl", "d.nic.gl"}, n, n, n, e, e, f},
	{"edu.gl", &z[566], x, 0, e, w{"a.nuuk.nic.gl", "d.nic.gl"}, n, n, n, e, e, f},
	{"net.gl", &z[566], x, 0, e, w{"a.nuuk.nic.gl", "d.nic.gl"}, n, n, n, e, e, f},
	{"org.gl", &z[566], x, 0, e, w{"a.nuuk.nic.gl", "d.nic.gl"}, n, n, n, e, e, f},
	{"ac.gn", &z[579], x, 0, e, n, n, n, n, e, e, f},
	{"co.gn", &z[579], x, 0, e, n, n, n, n, e, e, f},
	{"com.gn", &z[579], x, 0, e, n, n, n, n, e, e, t},
	{"gov.gn", &z[579], x, 0, e, n, n, n, n, e, e, f},
	{"net.gn", &z[579], x, 0, e, n, n, n, n, e, e, f},
	{"org.gn", &z[579], x, 0, e, n, n, n, n, e, e, f},
	{"24.gp", &z[593], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "24.gp"}, n, n, e, e, t},
	{"asia.gp", &z[593], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "asia.gp"}, n, n, e, e, t},
	{"asso.gp", &z[593], x, 0, e, w{"ns-gp.nic.fr", "ns1.nic.gp", "ns2.nic.gp"}, n, n, n, e, e, f},
	{"co.gp", &z[593], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "co.gp"}, n, n, e, e, t},
	{"com.gp", &z[593], x, 0, e, w{"ns-gp.nic.fr", "ns1.nic.gp", "ns2.nic.gp"}, n, n, n, e, e, f},
	{"edu.gp", &z[593], x, 0, e, w{"ns-gp.nic.fr", "ns1.nic.gp", "ns2.nic.gp"}, n, n, n, e, e, t},
	{"eu.gp", &z[593], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "eu.gp"}, n, n, e, e, t},
	{"mobi.gp", &z[593], x, 0, e, w{"ns-gp.nic.fr", "ns1.nic.gp", "ns2.nic.gp"}, n, n, n, e, e, f},
	{"net.gp", &z[593], x, 0, e, w{"ns-gp.nic.fr", "ns1.nic.gp", "ns2.nic.gp"}, n, n, n, e, e, f},
	{"online.gp", &z[593], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "online.gp"}, n, n, e, e, t},
	{"org.gp", &z[593], x, 0, e, w{"ns-gp.nic.fr", "ns1.nic.gp", "ns2.nic.gp"}, n, n, n, e, e, f},
	{"com.gr", &z[595], x, 0, e, w{"estia.ics.forth.gr", "gr-at.ics.forth.gr", "gr-c.ics.forth.gr", "gr-d.ics.forth.gr", "grdns-m.ics.forth.gr", "grdns.ics.forth.gr"}, n, n, n, e, e, f},
	{"edu.gr", &z[595], x, 0, e, w{"estia.ics.forth.gr", "gr-at.ics.forth.gr", "gr-c.ics.forth.gr", "gr-d.ics.forth.gr", "grdns-m.ics.forth.gr", "grdns.ics.forth.gr"}, n, n, n, e, e, f},
	{"gov.gr", &z[595], x, 0, e, w{"estia.ics.forth.gr", "gr-at.ics.forth.gr", "gr-c.ics.forth.gr", "gr-d.ics.forth.gr", "grdns-m.ics.forth.gr", "grdns.ics.forth.gr"}, n, n, n, e, e, f},
	{"net.gr", &z[595], x, 0, e, w{"estia.ics.forth.gr", "gr-at.ics.forth.gr", "gr-c.ics.forth.gr", "gr-d.ics.forth.gr", "grdns-m.ics.forth.gr", "grdns.ics.forth.gr"}, n, n, n, e, e, f},
	{"org.gr", &z[595], x, 0, e, w{"estia.ics.forth.gr", "gr-at.ics.forth.gr", "gr-c.ics.forth.gr", "gr-d.ics.forth.gr", "grdns-m.ics.forth.gr", "grdns.ics.forth.gr"}, n, n, n, e, e, f},
	{"com.gt", &z[605], x, 0, e, w{"a.lactld.org", "gt.anycastdns.cz", "ns-cz.gt", "ns.dns.br", "pch.gt", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"edu.gt", &z[605], x, 0, e, w{"a.lactld.org", "gt.anycastdns.cz", "ns-cz.gt", "ns.dns.br", "pch.gt", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"gob.gt", &z[605], x, 0, e, w{"a.lactld.org", "gt.anycastdns.cz", "ns-cz.gt", "ns.dns.br", "pch.gt", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"ind.gt", &z[605], x, 0, e, w{"a.lactld.org", "gt.anycastdns.cz", "ns-cz.gt", "ns.dns.br", "pch.gt", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"mil.gt", &z[605], x, 0, e, w{"a.lactld.org", "gt.anycastdns.cz", "ns-cz.gt", "ns.dns.br", "pch.gt", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"net.gt", &z[605], x, 0, e, w{"a.lactld.org", "gt.anycastdns.cz", "ns-cz.gt", "ns.dns.br", "pch.gt", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"org.gt", &z[605], x, 0, e, w{"a.lactld.org", "gt.anycastdns.cz", "ns-cz.gt", "ns.dns.br", "pch.gt", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"com.gu", &z[606], x, 0, e, w{"gold.uog.edu", "green.uog.edu", "gu.cctld.authdns.ripe.net", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"edu.gu", &z[606], x, 0, e, w{"gold.uog.edu", "green.uog.edu", "gu.cctld.authdns.ripe.net", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"gov.gu", &z[606], x, 0, e, w{"gold.uog.edu", "green.uog.edu", "gu.cctld.authdns.ripe.net", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"guam.gu", &z[606], x, 0, e, w{"gold.uog.edu", "green.uog.edu", "gu.cctld.authdns.ripe.net", "phloem.uoregon.edu"}, n, n, n, e, e, t},
	{"net.gu", &z[606], x, 0, e, w{"gold.uog.edu", "green.uog.edu", "gu.cctld.authdns.ripe.net", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"org.gu", &z[606], x, 0, e, w{"gold.uog.edu", "green.uog.edu", "gu.cctld.authdns.ripe.net", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"web.gu", &z[606], x, 0, e, w{"gold.uog.edu", "green.uog.edu", "gu.cctld.authdns.ripe.net", "phloem.uoregon.edu"}, n, n, n, e, e, t},
	{"co.gy", &z[616], x, 0, e, w{"a.lactld.org", "gy-ns.anycast.pch.net"}, n, n, n, e, e, f},
	{"com.gy", &z[616], x, 0, e, w{"a.lactld.org", "gy-ns.anycast.pch.net"}, n, n, n, e, e, f},
	{"net.gy", &z[616], x, 0, e, w{"a.lactld.org", "gy-ns.anycast.pch.net"}, n, n, n, e, e, f},
	{"org.gy", &z[616], x, 0, e, w{"a.lactld.org", "gy-ns.anycast.pch.net"}, n, n, n, e, e, t},
	{"com.hk", &z[639], x, 0, e, w{"c.hkirc.net.hk", "d.hkirc.net.hk", "t.hkirc.net.hk", "u.hkirc.net.hk", "v.hkirc.net.hk", "x.hkirc.net.hk", "y.hkirc.net.hk", "z.hkirc.net.hk"}, n, n, n, e, e, f},
	{"edu.hk", &z[639], x, 0, e, w{"c.hkirc.net.hk", "d.hkirc.net.hk", "t.hkirc.net.hk", "u.hkirc.net.hk", "v.hkirc.net.hk", "x.hkirc.net.hk", "y.hkirc.net.hk", "z.hkirc.net.hk"}, n, n, n, e, e, f},
	{"gov.hk", &z[639], x, 0, e, w{"c.hkirc.net.hk", "d.hkirc.net.hk", "t.hkirc.net.hk", "u.hkirc.net.hk", "v.hkirc.net.hk", "x.hkirc.net.hk", "y.hkirc.net.hk", "z.hkirc.net.hk"}, n, n, n, e, e, f},
	{"idv.hk", &z[639], x, 0, e, w{"c.hkirc.net.hk", "d.hkirc.net.hk", "t.hkirc.net.hk", "u.hkirc.net.hk", "v.hkirc.net.hk", "x.hkirc.net.hk", "y.hkirc.net.hk", "z.hkirc.net.hk"}, n, n, n, e, e, f},
	{"inc.hk", &z[639], x, 0, e, w{"a.udrtld.net", "b.udrtld.net", "c.udrtld.net", "dns7.cloudns.net", "dns8.cloudns.net"}, n, n, n, "whois.registry.hk.com", e, f},
	{"ltd.hk", &z[639], x, 0, e, w{"a.udrtld.net", "b.udrtld.net", "c.udrtld.net", "dns7.cloudns.net", "dns8.cloudns.net"}, n, n, n, "whois.registry.hk.com", e, f},
	{"net.hk", &z[639], x, 0, e, w{"c.hkirc.net.hk", "d.hkirc.net.hk", "t.hkirc.net.hk", "u.hkirc.net.hk", "v.hkirc.net.hk", "x.hkirc.net.hk", "y.hkirc.net.hk", "z.hkirc.net.hk"}, n, n, n, e, e, f},
	{"org.hk", &z[639], x, 0, e, w{"c.hkirc.net.hk", "d.hkirc.net.hk", "t.hkirc.net.hk", "u.hkirc.net.hk", "v.hkirc.net.hk", "x.hkirc.net.hk", "y.hkirc.net.hk", "z.hkirc.net.hk"}, n, n, n, e, e, f},
	{"xn--55qx5d.hk" /* 公司.hk */, &z[639], x, 0, e, w{"c.hkirc.net.hk", "d.hkirc.net.hk", "t.hkirc.net.hk", "u.hkirc.net.hk", "v.hkirc.net.hk", "x.hkirc.net.hk", "y.hkirc.net.hk", "z.hkirc.net.hk"}, n, n, n, e, e, t},
	{"com.hn", &z[642], x, 0, e, w{"nicmx-anycast.rds.org.hn", "pch-anycast.rds.org.hn"}, n, n, n, e, e, f},
	{"edu.hn", &z[642], x, 0, e, w{"nicmx-anycast.rds.org.hn", "pch-anycast.rds.org.hn"}, n, n, n, e, e, t},
	{"gob.hn", &z[642], x, 0, e, w{"nicmx-anycast.rds.org.hn", "pch-anycast.rds.org.hn"}, n, n, n, e, e, t},
	{"mil.hn", &z[642], x, 0, e, w{"nicmx-anycast.rds.org.hn", "pch-anycast.rds.org.hn"}, n, n, n, e, e, t},
	{"net.hn", &z[642], x, 0, e, w{"nicmx-anycast.rds.org.hn", "pch-anycast.rds.org.hn"}, n, n, n, e, e, f},
	{"org.hn", &z[642], x, 0, e, w{"nicmx-anycast.rds.org.hn", "pch-anycast.rds.org.hn"}, n, n, n, e, e, f},
	{"com.hr", &z[665], x, 0, e, w{"dns-ez-1.carnet.hr", "dns1.com.hr", "dns2.com.hr"}, n, n, n, e, e, f},
	{"from.hr", &z[665], x, 0, e, w{"dns-ez-1.carnet.hr", "dns1.from.hr", "dns2.from.hr"}, n, n, n, e, e, f},
	{"iz.hr", &z[665], x, 0, e, w{"dns-ez-1.carnet.hr", "dns1.from.hr", "dns1.iz.hr", "dns2.from.hr", "dns2.iz.hr"}, n, n, n, e, e, f},
	{"name.hr", &z[665], x, 0, e, w{"dns-ez-1.carnet.hr", "dns1.from.hr", "dns1.name.hr", "dns2.from.hr", "dns2.name.hr"}, n, n, n, e, e, f},
	{"adult.ht", &z[667], x, 0x1, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"art.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"asso.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"com.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"coop.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"edu.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"firm.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"gouv.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"info.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"med.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"net.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"org.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"perso.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"pol.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"pro.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"rel.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"shop.ht", &z[667], x, 0, e, w{"ns1.nic.ht", "ns1.polymtl.ca", "ns3.nic.fr", "pch.nic.ht"}, n, n, n, e, e, f},
	{"2000.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"ac.hu", &z[669], x, 0, e, n, n, n, n, e, e, f},
	{"agrar.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"bolt.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"casino.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"city.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"co.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu", "ns12.communitydns.net"}, n, n, n, e, e, f},
	{"edu.hu", &z[669], x, 0, e, w{"kubiac.iif.hu", "ns2.iif.hu", "ns2.sztaki.hbone.hu"}, n, n, n, e, e, f},
	{"erotica.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"erotika.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"film.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"forum.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"games.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"gov.hu", &z[669], x, 0, e, w{"adns0.gov.hu", "adns1.gov.hu", "adns2.gov.hu"}, n, n, n, e, e, f},
	{"hotel.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"info.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"ingatlan.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"jogasz.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"konyvelo.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"lakas.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"media.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"news.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"org.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"priv.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"reklam.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"sex.hu", &z[669], x, 0x1, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"shop.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"sport.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"suli.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"szex.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"tm.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"tozsde.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"utazas.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"video.hu", &z[669], x, 0, e, w{"a.hu", "b.hu", "c.hu", "d.hu", "ns-s.nic.hu"}, n, n, n, e, e, f},
	{"ac.id", &z[677], x, 0, e, w{"b.dns.id", "c.dns.id", "d.dns.id", "e.dns.id"}, n, n, n, e, e, f},
	{"biz.id", &z[677], x, 0, e, w{"b.dns.id", "c.dns.id", "d.dns.id", "e.dns.id"}, n, n, n, e, e, f},
	{"co.id", &z[677], x, 0, e, w{"b.dns.id", "c.dns.id", "d.dns.id", "e.dns.id"}, n, n, n, e, e, f},
	{"desa.id", &z[677], x, 0, e, w{"b.dns.id", "c.dns.id", "d.dns.id", "e.dns.id"}, n, n, n, e, e, t},
	{"go.id", &z[677], x, 0, e, w{"b.dns.id", "c.dns.id", "d.dns.id", "e.dns.id"}, n, n, n, e, e, f},
	{"mi.id", &z[677], x, 0, e, n, n, n, n, e, e, t},
	{"mil.id", &z[677], x, 0, e, w{"b.dns.id", "c.dns.id", "d.dns.id", "e.dns.id"}, n, n, n, e, e, f},
	{"my.id", &z[677], x, 0, e, w{"b.dns.id", "c.dns.id", "d.dns.id", "e.dns.id"}, n, n, n, e, e, f},
	{"net.id", &z[677], x, 0, e, w{"b.dns.id", "c.dns.id", "d.dns.id", "e.dns.id"}, n, n, n, e, e, f},
	{"or.id", &z[677], x, 0, e, w{"b.dns.id", "c.dns.id", "d.dns.id", "e.dns.id"}, n, n, n, e, e, f},
	{"sch.id", &z[677], x, 0, e, w{"b.dns.id", "c.dns.id", "d.dns.id", "e.dns.id"}, n, n, n, e, e, f},
	{"web.id", &z[677], x, 0, e, w{"b.dns.id", "c.dns.id", "d.dns.id", "e.dns.id"}, n, n, n, e, e, f},
	{"com.ie", &z[679], x, 0x800, e, n, n, n, n, e, e, f},
	{"gov.ie", &z[679], x, 0, e, w{"cwext.gn.gov.ie", "ext3.gn.gov.ie", "gbext.gn.gov.ie"}, n, n, n, e, e, f},
	{"net.ie", &z[679], x, 0x800, e, n, n, n, n, e, e, f},
	{"nli.ie", &z[679], x, 0, e, w{"ns.heanet.ie", "vax1.baker.ie"}, n, n, n, e, e, f},
	{"org.ie", &z[679], x, 0x800, e, n, n, n, n, e, e, f},
	{"ac.il", &z[684], x, 0, e, w{"ilns.ilan.net.il", "lookup.iucc.ac.il", "ns1.ns.il", "ns3.ns.il", "ns4.ns.il", "nsa.ns.il", "nsb.ns.il", "nse.ns.il"}, n, n, n, e, e, f},
	{"co.il", &z[684], x, 0, "https://www.isoc.org.il/domain-name-registry", w{"ilns.ilan.net.il", "lookup.iucc.ac.il", "ns1.ns.il", "ns3.ns.il", "ns4.ns.il", "nsa.ns.il", "nsb.ns.il", "nse.ns.il"}, n, n, n, e, e, f},
	{"gov.il", &z[684], x, 0, e, w{"dns3.gov.il", "ilns.ilan.net.il", "lookup.iucc.ac.il", "ns1.ns.il", "ns3.ns.il", "ns4.ns.il", "nsa.ns.il", "nsb.ns.il", "nse.ns.il"}, n, n, n, e, e, f},
	{"idf.il", &z[684], x, 0, e, w{"asia3.akam.net", "asia4.akam.net", "dns3.gov.il", "eur2.akam.net", "eur6.akam.net", "ns1-111.akam.net", "ns1-69.akam.net", "use4.akam.net", "usw2.akam.net"}, n, n, n, e, e, f},
	{"k12.il", &z[684], x, 0, e, w{"ilns.ilan.net.il", "lookup.iucc.ac.il", "ns1.ns.il", "ns3.ns.il", "ns4.ns.il", "nsa.ns.il", "nsb.ns.il", "nse.ns.il"}, n, n, n, e, e, f},
	{"muni.il", &z[684], x, 0, e, w{"ilns.ilan.net.il", "lookup.iucc.ac.il", "ns1.ns.il", "ns3.ns.il", "ns4.ns.il", "nsa.ns.il", "nsb.ns.il", "nse.ns.il"}, n, n, n, e, e, f},
	{"net.il", &z[684], x, 0, "https://www.isoc.org.il/domain-name-registry", w{"ilns.ilan.net.il", "lookup.iucc.ac.il", "ns1.ns.il", "ns3.ns.il", "ns4.ns.il", "nsa.ns.il", "nsb.ns.il", "nse.ns.il"}, n, n, n, e, e, f},
	{"org.il", &z[684], x, 0, "https://www.isoc.org.il/domain-name-registry", w{"ilns.ilan.net.il", "lookup.iucc.ac.il", "ns1.ns.il", "ns3.ns.il", "ns4.ns.il", "nsa.ns.il", "nsb.ns.il", "nse.ns.il"}, n, n, n, e, e, f},
	{"ac.im", &z[685], x, 0, e, n, n, n, n, e, e, f},
	{"co.im", &z[685], z[5098:5100], 0, e, n, n, n, n, e, e, f},
	{"com.im", &z[685], x, 0, e, n, n, n, n, e, e, f},
	{"gov.im", &z[685], x, 0, e, w{"barney.advsys.co.uk", "hoppy.iom.com", "pebbles.iom.com"}, n, n, n, e, e, f},
	{"net.im", &z[685], x, 0, e, n, n, n, n, e, e, f},
	{"org.im", &z[685], x, 0, e, n, n, n, n, e, e, f},
	{"ac.in", &z[690], x, 0, e, w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, n, "whois.ncst.ernet.in", e, f},
	{"co.in", &z[690], x, 0, e, w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, n, "whois.inregistry.net", e, f},
	{"edu.in", &z[690], x, 0, e, w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, n, "whois.ncst.ernet.in", e, f},
	{"ernet.in", &z[690], x, 0, e, w{"dns.ernet.in", "dns1.ernet.in", "dns2.ernet.in", "dns3.ernet.in", "dns4.ernet.in", "e-eihq01.eis.ernet.in", "e-eihq02.eis.ernet.in"}, n, n, n, e, e, t},
	{"firm.in", &z[690], x, 0, e, w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, n, "whois.inregistry.net", e, f},
	{"gen.in", &z[690], x, 0, e, w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, n, "whois.inregistry.net", e, f},
	{"gov.in", &z[690], x, 0, e, w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, n, "whois.ncst.ernet.in", e, f},
	{"ind.in", &z[690], x, 0, e, w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, n, e, e, f},
	{"mil.in", &z[690], x, 0, e, w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, n, "whois.ncst.ernet.in", e, f},
	{"net.in", &z[690], x, 0, e, w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, n, "whois.inregistry.net", e, f},
	{"org.in", &z[690], x, 0, e, w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, n, "whois.inregistry.net", e, f},
	{"res.in", &z[690], x, 0, e, w{"ns1.registry.in", "ns2.registry.in", "ns3.registry.in", "ns4.registry.in", "ns5.registry.in", "ns6.registry.in"}, n, n, n, "whois.ncst.ernet.in", e, f},
	{"auz.info", &z[695], x, 0, e, w{"ns1.instradns.com", "ns2.instradns.com", "ns3.instradns.com"}, n, n, n, e, e, f},
	{"eu.int", &z[703], x, 0, e, w{"ns1.be.colt.net", "ns1.bt.net", "ns1bru.europa.eu", "ns1lux.europa.eu", "ns2bru.europa.eu", "ns2eu.bt.net", "ns2lux.europa.eu"}, n, n, n, e, e, f},
	{"com.io", &z[708], x, 0x800, e, n, n, n, n, e, e, t},
	{"org.io", &z[708], x, 0x800, e, n, n, n, n, e, e, t},
	{"biz.iq", &z[710], x, 0, e, w{"ns.cocca.fr", "ns1.cmc.iq", "nsp-anycast.cmc.iq"}, n, n, n, e, e, t},
	{"com.iq", &z[710], x, 0, e, w{"ns.cocca.fr", "ns1.cmc.iq", "nsp-anycast.cmc.iq", "sns-pb.isc.org"}, n, n, n, e, e, f},
	{"edu.iq", &z[710], x, 0, e, w{"ns.cocca.fr", "ns1.cmc.iq", "nsp-anycast.cmc.iq", "sns-pb.isc.org"}, n, n, n, e, e, f},
	{"gov.iq", &z[710], x, 0, e, w{"ns.cocca.fr", "ns1.cmc.iq", "nsp-anycast.cmc.iq", "sns-pb.isc.org"}, n, n, n, e, e, f},
	{"info.iq", &z[710], x, 0, e, w{"ns23.cmc.iq", "ns24.cmc.iq"}, n, n, n, e, e, t},
	{"mil.iq", &z[710], x, 0, e, w{"ns.cocca.fr", "ns1.cmc.iq", "nsp-anycast.cmc.iq", "sns-pb.isc.org"}, n, n, n, e, e, f},
	{"name.iq", &z[710], x, 0, e, w{"ns.cocca.fr", "ns1.cmc.iq", "nsp-anycast.cmc.iq"}, n, n, n, e, e, t},
	{"net.iq", &z[710], x, 0, e, w{"ns.cocca.fr", "ns1.cmc.iq", "nsp-anycast.cmc.iq"}, n, n, n, e, e, t},
	{"org.iq", &z[710], x, 0, e, w{"ns.cocca.fr", "ns1.cmc.iq", "nsp-anycast.cmc.iq"}, n, n, n, e, e, f},
	{"tv.iq", &z[710], x, 0, e, w{"ns.cocca.fr", "ns1.cmc.iq", "nsp-anycast.cmc.iq"}, n, n, n, e, e, t},
	{"ac.ir", &z[711], x, 0, e, w{"a.nic.ir", "b.nic.ir", "dns-ir.univie.ac.at", "ir.cctld.authdns.ripe.net", "ns5.univie.ac.at"}, n, n, n, e, e, f},
	{"co.ir", &z[711], x, 0, e, w{"a.nic.ir", "b.nic.ir", "dns-ir.univie.ac.at", "ir.cctld.authdns.ripe.net", "ns5.univie.ac.at"}, n, n, n, e, e, f},
	{"gov.ir", &z[711], x, 0, e, w{"a.nic.ir", "b.nic.ir", "dns-ir.univie.ac.at", "ir.cctld.authdns.ripe.net", "ns5.univie.ac.at"}, n, n, n, e, e, f},
	{"id.ir", &z[711], x, 0, e, w{"a.nic.ir", "b.nic.ir", "dns-ir.univie.ac.at", "ir.cctld.authdns.ripe.net", "ns5.univie.ac.at"}, n, n, n, e, e, f},
	{"net.ir", &z[711], x, 0, e, w{"a.nic.ir", "b.nic.ir", "dns-ir.univie.ac.at", "ir.cctld.authdns.ripe.net", "ns5.univie.ac.at"}, n, n, n, e, e, f},
	{"org.ir", &z[711], x, 0, e, w{"a.nic.ir", "b.nic.ir", "dns-ir.univie.ac.at", "ir.cctld.authdns.ripe.net", "ns5.univie.ac.at"}, n, n, n, e, e, f},
	{"sch.ir", &z[711], x, 0, e, w{"a.nic.ir", "b.nic.ir", "dns-ir.univie.ac.at", "ir.cctld.authdns.ripe.net", "ns5.univie.ac.at"}, n, n, n, e, e, f},
	{"abr.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"abruzzo.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ag.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"agrigento.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"al.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"alessandria.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"alto-adige.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"altoadige.it", &z[720], x, 0, e, w{"guy.ns.cloudflare.com", "rita.ns.cloudflare.com"}, n, n, n, e, e, t},
	{"an.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ancona.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"andria-barletta-trani.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"andria-trani-barletta.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"andriabarlettatrani.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"andriatranibarletta.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ao.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"aosta.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"aoste.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ap.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"aq.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"aquila.it", &z[720], x, 0, e, w{"ns1.parkingcrew.net", "ns2.parkingcrew.net"}, w{"104.247.82.54"}, n, n, e, e, t},
	{"ar.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"arezzo.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ascoli-piceno.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ascolipiceno.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"asti.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"at.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"av.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"avellino.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ba.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"balsan.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"bari.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"barletta-trani-andria.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"barlettatraniandria.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"bas.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"basilicata.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"belluno.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"benevento.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"bergamo.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"bg.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"bi.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"biella.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"bl.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"bn.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"bo.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"bologna.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"bolzano.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"bozen.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"br.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"brescia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"brindisi.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"bs.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"bt.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"bz.it", &z[720], x, 0, e, n, n, n, n, e, e, f},
	{"ca.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"cagliari.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"cal.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"calabria.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"caltanissetta.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"cam.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"campania.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"campidano-medio.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"campidanomedio.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"campobasso.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"carbonia-iglesias.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"carboniaiglesias.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"carrara-massa.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"carraramassa.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"caserta.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"catania.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"catanzaro.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"cb.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ce.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"cesena-forli.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"cesenaforli.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ch.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"chieti.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ci.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"cl.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"cn.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"co.it", &z[720], x, 0, e, n, n, n, n, e, e, f},
	{"como.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"cosenza.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"cr.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"cremona.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"crotone.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"cs.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ct.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"cuneo.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"cz.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"dell-ogliastra.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"dellogliastra.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"edu.it", &z[720], x, 0, e, w{"a.dns.it", "dns.edu.it", "m.dns.it", "r.dns.it"}, n, n, n, e, e, f},
	{"emilia-romagna.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"emiliaromagna.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"emr.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"en.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"enna.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"fc.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"fe.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"fermo.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ferrara.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"fg.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"fi.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"firenze.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"florence.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"fm.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"foggia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"forli-cesena.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"forlicesena.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"fr.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"friuli-v-giulia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"friuli-ve-giulia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"friuli-vegiulia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"friuli-venezia-giulia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"friuli-veneziagiulia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"friuli-vgiulia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"friuliv-giulia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"friulive-giulia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"friulivegiulia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"friulivenezia-giulia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"friuliveneziagiulia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"friulivgiulia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"frosinone.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"fvg.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ge.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"genoa.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"genova.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"go.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"gorizia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"gov.it", &z[720], x, 0, e, w{"dns1.fweds-spc.it", "dns2.fweds-spc.it"}, n, n, n, e, e, f},
	{"gr.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"grosseto.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"iglesias-carbonia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"iglesiascarbonia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"im.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"imperia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"is.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"isernia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"kr.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"la-spezia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"laquila.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"laspezia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"latina.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"laz.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"lazio.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"lc.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"le.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"lecce.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"lecco.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"li.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"lig.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"liguria.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"livorno.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"lo.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"lodi.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"lom.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"lombardia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"lombardy.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"lt.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"lu.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"lucania.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"lucca.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"macerata.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"mantova.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"mar.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"marche.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"massa-carrara.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"massacarrara.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"matera.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"mb.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"mc.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"me.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"medio-campidano.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"mediocampidano.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"messina.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"mi.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"milan.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"milano.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"mn.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"mo.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"modena.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"mol.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"molise.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"monza.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"monza-brianza.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"monza-e-della-brianza.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"monzabrianza.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"monzaebrianza.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"monzaedellabrianza.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ms.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"mt.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"na.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"naples.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"napoli.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"no.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"novara.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"nu.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"nuoro.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"og.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ogliastra.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"olbia-tempio.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"olbiatempio.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"or.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"oristano.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ot.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pa.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"padova.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"padua.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"palermo.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"parma.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pavia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pc.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pd.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pe.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"perugia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pesaro-urbino.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pesarourbino.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pescara.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pg.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pi.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"piacenza.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"piedmont.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"piemonte.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pisa.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pistoia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pmn.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pn.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"po.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pordenone.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"potenza.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pr.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"prato.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pt.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pu.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pug.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"puglia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pv.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"pz.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ra.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ragusa.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ravenna.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"rc.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"re.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"reggio-calabria.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"reggio-emilia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"reggiocalabria.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"reggioemilia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"rg.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ri.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"rieti.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"rimini.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"rm.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"rn.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ro.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"roma.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"rome.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"rovigo.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"sa.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"salerno.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"sar.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"sardegna.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"sardinia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"sassari.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"savona.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"si.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"sic.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"sicilia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"sicily.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"siena.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"siracusa.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"so.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"sondrio.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"sp.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"sr.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ss.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"suedtirol.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"sv.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ta.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"taa.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"taranto.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"te.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"tempio-olbia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"tempioolbia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"teramo.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"terni.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"tn.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"to.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"torino.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"tos.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"toscana.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"tp.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"tr.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trani-andria-barletta.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trani-barletta-andria.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"traniandriabarletta.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"tranibarlettaandria.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trapani.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentino.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentino-a-adige.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentino-aadige.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentino-alto-adige.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentino-altoadige.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentino-s-tirol.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentino-stirol.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentino-sud-tirol.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentino-sudtirol.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentino-sued-tirol.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentino-suedtirol.it", &z[720], x, 0, e, w{"dns3.aknet.it", "dns4.aknet.it"}, n, n, n, e, e, t},
	{"trentinoa-adige.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentinoaadige.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentinoalto-adige.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentinoaltoadige.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentinos-tirol.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentinosud-tirol.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentinosudtirol.it", &z[720], x, 0, e, w{"dns.widhost.net", "dns2.widhost.net"}, n, n, n, e, e, t},
	{"trentinosued-tirol.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trentinosuedtirol.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trento.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"treviso.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"trieste.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ts.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"turin.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"tuscany.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"tv.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ud.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"udine.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"umb.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"umbria.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"urbino-pesaro.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"urbinopesaro.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"va.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"val-d-aosta.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"val-daosta.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"vald-aosta.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"valdaosta.it", &z[720], x, 0, e, w{"dns2.alsitech.it", "dns4.alsitech.it"}, n, n, n, e, e, t},
	{"valle-d-aosta.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"valle-daosta.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"valled-aosta.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"valledaosta.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"vao.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"varese.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"vb.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"vc.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"vda.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ve.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"ven.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"veneto.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"venezia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"venice.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"verbania.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"vercelli.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"verona.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"vi.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"vibo-valentia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"vibovalentia.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"vicenza.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"viterbo.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"vr.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"vs.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"vt.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"vv.it", &z[720], x, 0, e, n, n, n, n, e, e, t},
	{"24.je", &z[729], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "24.je"}, n, n, e, e, t},
	{"co.je", &z[729], x, 0, e, w{"c.ci-servers.org", "dns1.nominetdns.uk", "dns2.nominetdns.uk", "dns3.nominetdns.uk", "dns4.nominetdns.uk"}, n, n, n, e, e, f},
	{"gov.je", &z[729], x, 0, e, w{"ns1.gov.je", "ns2.gov.je"}, n, n, n, e, e, f},
	{"net.je", &z[729], x, 0, e, w{"c.ci-servers.org", "dns1.nominetdns.uk", "dns2.nominetdns.uk", "dns3.nominetdns.uk", "dns4.nominetdns.uk"}, n, n, n, e, e, f},
	{"org.je", &z[729], x, 0, e, w{"c.ci-servers.org", "dns1.nominetdns.uk", "dns2.nominetdns.uk", "dns3.nominetdns.uk", "dns4.nominetdns.uk"}, n, n, n, e, e, f},
	{"sch.je", &z[729], x, 0, e, w{"ns1.gov.je", "ns2.gov.je"}, n, n, n, e, e, f},
	{"com.jm", &z[736], x, 0, e, n, n, n, n, e, e, f},
	{"edu.jm", &z[736], x, 0, e, n, n, n, n, e, e, f},
	{"gov.jm", &z[736], x, 0, e, n, n, n, n, e, e, f},
	{"mil.jm", &z[736], x, 0, e, n, n, n, n, e, e, f},
	{"net.jm", &z[736], x, 0, e, n, n, n, n, e, e, f},
	{"org.jm", &z[736], x, 0, e, n, n, n, n, e, e, f},
	{"com.jo", &z[739], x, 0, e, w{"amra.nic.gov.jo", "jo.cctld.authdns.ripe.net", "jordan1st.nic.gov.jo", "petra.nic.gov.jo", "rip.psg.com"}, n, n, n, e, e, f},
	{"edu.jo", &z[739], x, 0, e, w{"amra.nic.gov.jo", "jo.cctld.authdns.ripe.net", "jordan1st.nic.gov.jo", "petra.nic.gov.jo", "rip.psg.com"}, n, n, n, e, e, t},
	{"gov.jo", &z[739], x, 0, e, w{"amra.nic.gov.jo", "jo.cctld.authdns.ripe.net", "jordan1st.nic.gov.jo", "petra.nic.gov.jo", "rip.psg.com"}, n, n, n, e, e, f},
	{"mil.jo", &z[739], x, 0, e, w{"amra.nic.gov.jo", "jo.cctld.authdns.ripe.net", "jordan1st.nic.gov.jo", "petra.nic.gov.jo", "rip.psg.com"}, n, n, n, e, e, f},
	{"name.jo", &z[739], x, 0, e, n, n, n, n, e, e, f},
	{"net.jo", &z[739], x, 0, e, w{"amra.nic.gov.jo", "jo.cctld.authdns.ripe.net", "jordan1st.nic.gov.jo", "petra.nic.gov.jo", "rip.psg.com"}, n, n, n, e, e, f},
	{"org.jo", &z[739], x, 0, e, w{"amra.nic.gov.jo", "jo.cctld.authdns.ripe.net", "jordan1st.nic.gov.jo", "petra.nic.gov.jo", "rip.psg.com"}, n, n, n, e, e, f},
	{"sch.jo", &z[739], x, 0, e, w{"amra.nic.gov.jo", "jo.cctld.authdns.ripe.net", "jordan1st.nic.gov.jo", "petra.nic.gov.jo", "rip.psg.com"}, n, n, n, e, e, f},
	{"ac.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"ad.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"aichi.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"akita.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"aomori.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"chiba.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"co.jp", &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"ed.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"ehime.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"fukui.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"fukuoka.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"fukushima.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"gifu.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"go.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"gr.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"gunma.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"hiroshima.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"hokkaido.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"hyogo.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"ibaraki.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"ishikawa.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"iwate.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"kagawa.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"kagoshima.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"kanagawa.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"kochi.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"kumamoto.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"kyoto.jp", &z[744], x, 0x84, e, n, n, w{"Kyoto"}, n, e, e, f},
	{"lg.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"mie.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"miyagi.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"miyazaki.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"nagano.jp", &z[744], x, 0x84, e, n, n, w{"Nagano", "JP-20"}, n, e, e, f},
	{"nagasaki.jp", &z[744], x, 0x84, e, n, n, w{"Nagasaki"}, n, e, e, f},
	{"nara.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"ne.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"niigata.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"oita.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"okayama.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"okinawa.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"or.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"osaka.jp", &z[744], x, 0x84, e, n, n, w{"Osaka"}, n, e, e, f},
	{"saga.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"saitama.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"shiga.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"shimane.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"shizuoka.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"tochigi.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"tokushima.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"tokyo.jp", &z[744], x, 0x84, e, n, n, w{"Tokyo"}, n, e, e, f},
	{"tottori.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"toyama.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"wakayama.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"yamagata.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"yamaguchi.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"yamanashi.jp", &z[744], x, 0, e, n, n, n, n, e, e, f},
	{"xn--ehqz56n.jp" /* 三重.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--1lqs03n.jp" /* 京都.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--qqqt11m.jp" /* 佐賀.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--f6qx53a.jp" /* 兵庫.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--djrs72d6uy.jp" /* 北海道.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--mkru45i.jp" /* 千葉.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--0trq7p7nn.jp" /* 和歌山.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--5js045d.jp" /* 埼玉.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--kbrq7o.jp" /* 大分.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--pssu33l.jp" /* 大阪.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--ntsq17g.jp" /* 奈良.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--uisz3g.jp" /* 宮城.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--6btw5a.jp" /* 宮崎.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--1ctwo.jp" /* 富山.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--6orx2r.jp" /* 山口.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--rht61e.jp" /* 山形.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--rht27z.jp" /* 山梨.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--nit225k.jp" /* 岐阜.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--rht3d.jp" /* 岡山.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--djty4k.jp" /* 岩手.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--klty5x.jp" /* 島根.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--kltx9a.jp" /* 広島.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--kltp7d.jp" /* 徳島.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--c3s14m.jp" /* 愛媛.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--vgu402c.jp" /* 愛知.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--efvn9s.jp" /* 新潟.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--1lqs71d.jp" /* 東京.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--4pvxs.jp" /* 栃木.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--uuwu58a.jp" /* 沖縄.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--zbx025d.jp" /* 滋賀.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--8pvr4u.jp" /* 熊本.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--5rtp49c.jp" /* 石川.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--ntso0iqx3a.jp" /* 神奈川.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--elqq16h.jp" /* 福井.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--4it168d.jp" /* 福岡.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--klt787d.jp" /* 福島.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--rny31h.jp" /* 秋田.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--7t0a264c.jp" /* 群馬.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--uist22h.jp" /* 茨城.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--8ltr62k.jp" /* 長崎.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--2m4a15e.jp" /* 長野.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--32vp30h.jp" /* 青森.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--4it797k.jp" /* 静岡.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--5rtq34k.jp" /* 香川.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--k7yn95e.jp" /* 高知.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--tor131o.jp" /* 鳥取.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"xn--d5qv7z876c.jp" /* 鹿児島.jp */, &z[744], x, 0, e, n, n, n, n, e, e, t},
	{"ac.ke", &z[753], x, 0, e, w{"b.ns.tznic.or.tz", "kenic.anycastdns.cz", "mzizi.kenic.or.ke", "ns-ke.afrinic.net", "ns.anycast.kenic.or.ke", "ns2ke.dns.business"}, n, n, n, e, e, f},
	{"co.ke", &z[753], x, 0, e, w{"b.ns.tznic.or.tz", "kenic.anycastdns.cz", "mzizi.kenic.or.ke", "ns-ke.afrinic.net", "ns.anycast.kenic.or.ke", "ns2ke.dns.business"}, n, n, n, e, e, f},
	{"go.ke", &z[753], x, 0, e, w{"b.ns.tznic.or.tz", "kenic.anycastdns.cz", "mzizi.kenic.or.ke", "ns-ke.afrinic.net", "ns.anycast.kenic.or.ke", "ns2ke.dns.business"}, n, n, n, e, e, f},
	{"info.ke", &z[753], x, 0, e, w{"b.ns.tznic.or.tz", "kenic.anycastdns.cz", "mzizi.kenic.or.ke", "ns-ke.afrinic.net", "ns.anycast.kenic.or.ke", "ns2ke.dns.business"}, n, n, n, e, e, f},
	{"me.ke", &z[753], x, 0, e, w{"b.ns.tznic.or.tz", "kenic.anycastdns.cz", "mzizi.kenic.or.ke", "ns-ke.afrinic.net", "ns.anycast.kenic.or.ke", "ns2ke.dns.business"}, n, n, n, e, e, f},
	{"mobi.ke", &z[753], x, 0, e, w{"b.ns.tznic.or.tz", "kenic.anycastdns.cz", "mzizi.kenic.or.ke", "ns-ke.afrinic.net", "ns.anycast.kenic.or.ke", "ns2ke.dns.business"}, n, n, n, e, e, f},
	{"ne.ke", &z[753], x, 0, e, w{"b.ns.tznic.or.tz", "kenic.anycastdns.cz", "mzizi.kenic.or.ke", "ns-ke.afrinic.net", "ns.anycast.kenic.or.ke", "ns2ke.dns.business"}, n, n, n, e, e, f},
	{"or.ke", &z[753], x, 0, e, w{"b.ns.tznic.or.tz", "kenic.anycastdns.cz", "mzizi.kenic.or.ke", "ns-ke.afrinic.net", "ns.anycast.kenic.or.ke", "ns2ke.dns.business"}, n, n, n, e, e, f},
	{"sc.ke", &z[753], x, 0, e, w{"b.ns.tznic.or.tz", "kenic.anycastdns.cz", "mzizi.kenic.or.ke", "ns-ke.afrinic.net", "ns.anycast.kenic.or.ke", "ns2ke.dns.business"}, n, n, n, e, e, f},
	{"com.kg", &z[761], x, 0, e, w{"as.asiainfo.kg", "kg.cctld.authdns.ripe.net", "ns-kg.ripe.net", "ns.kg"}, n, n, n, e, e, f},
	{"edu.kg", &z[761], x, 0, e, w{"as.asiainfo.kg", "ns-kg.ripe.net", "ns.kg"}, n, n, n, e, e, t},
	{"gov.kg", &z[761], x, 0, e, w{"as.asiainfo.kg", "kg.cctld.authdns.ripe.net", "ns-kg.ripe.net", "ns.kg"}, n, n, n, e, e, f},
	{"mil.kg", &z[761], x, 0, e, w{"as.asiainfo.kg", "ns.kg", "ns.ripe.net"}, n, n, n, e, e, f},
	{"net.kg", &z[761], x, 0, e, w{"as.asiainfo.kg", "kg.cctld.authdns.ripe.net", "ns-kg.ripe.net", "ns.kg"}, n, n, n, e, e, f},
	{"org.kg", &z[761], x, 0, e, w{"as.asiainfo.kg", "ns-kg.ripe.net", "ns.kg"}, n, n, n, e, e, f},
	{"com.kh", &z[762], x, 0, e, w{"dns1.online.com.kh", "ns.camnet.com.kh", "ns1.dns.net.kh", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"edu.kh", &z[762], x, 0, e, w{"dns1.online.com.kh", "ns.camnet.com.kh", "ns1.dns.net.kh", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"gov.kh", &z[762], x, 0, e, w{"dns1.online.com.kh", "ns.camnet.com.kh", "ns1.dns.net.kh", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"mil.kh", &z[762], x, 0, e, w{"dns1.online.com.kh", "ns.camnet.com.kh", "ns1.dns.net.kh", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"net.kh", &z[762], x, 0, e, w{"dns1.online.com.kh", "ns.camnet.com.kh", "ns1.dns.net.kh", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"org.kh", &z[762], x, 0, e, w{"dns1.online.com.kh", "ns.camnet.com.kh", "ns1.dns.net.kh", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"per.kh", &z[762], x, 0, e, w{"dns1.online.com.kh", "ns.camnet.com.kh", "ns1.dns.net.kh", "ns4.apnic.net"}, n, n, n, e, e, f},
	{"biz.ki", &z[763], x, 0, e, w{"ns.cocca.fr", "pch.nic.ki"}, n, n, n, e, e, f},
	{"com.ki", &z[763], x, 0, e, w{"ns.cocca.fr", "pch.nic.ki"}, n, n, n, e, e, f},
	{"edu.ki", &z[763], x, 0, e, w{"ns.cocca.fr", "pch.nic.ki"}, n, n, n, e, e, f},
	{"eu.ki", &z[763], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "eu.ki"}, n, n, e, e, t},
	{"gov.ki", &z[763], x, 0, e, w{"ns.cocca.fr", "pch.nic.ki"}, n, n, n, e, e, f},
	{"info.ki", &z[763], x, 0, e, w{"ns.cocca.fr", "pch.nic.ki"}, n, n, n, e, e, f},
	{"mob.ki", &z[763], x, 0, e, n, n, n, n, e, e, f},
	{"mobi.ki", &z[763], x, 0, e, n, n, n, n, e, e, f},
	{"net.ki", &z[763], x, 0, e, w{"ns.cocca.fr", "pch.nic.ki"}, n, n, n, e, e, f},
	{"org.ki", &z[763], x, 0, e, w{"ns.cocca.fr", "pch.nic.ki"}, n, n, n, e, e, f},
	{"phone.ki", &z[763], x, 0, e, n, n, n, n, e, e, f},
	{"tel.ki", &z[763], x, 0, e, n, n, n, n, e, e, f},
	{"asso.km", &z[773], x, 0x800, e, n, n, n, n, e, e, f},
	{"com.km", &z[773], x, 0, e, n, n, n, n, e, e, f},
	{"coop.km", &z[773], x, 0, e, n, n, n, n, e, e, f},
	{"edu.km", &z[773], x, 0, e, w{"dns1.nic.km", "dns2.nic.km"}, n, n, n, e, e, f},
	{"gouv.km", &z[773], x, 0, e, w{"dns1.nic.km", "dns2.nic.km"}, n, n, n, e, e, f},
	{"medecin.km", &z[773], x, 0, e, n, n, n, n, e, e, f},
	{"mil.km", &z[773], x, 0, e, n, n, n, n, e, e, f},
	{"nom.km", &z[773], x, 0, e, n, n, n, n, e, e, f},
	{"notaires.km", &z[773], x, 0, e, n, n, n, n, e, e, f},
	{"org.km", &z[773], x, 0, e, w{"dns1.nic.km", "dns2.nic.km"}, n, n, n, e, e, t},
	{"pharmaciens.km", &z[773], x, 0, e, n, n, n, n, e, e, f},
	{"presse.km", &z[773], x, 0, e, n, n, n, n, e, e, f},
	{"tm.km", &z[773], x, 0, e, n, n, n, n, e, e, f},
	{"veterinaire.km", &z[773], x, 0, e, n, n, n, n, e, e, f},
	{"co.kn", &z[774], x, 0, e, w{"ns.cocca.fr", "pch.nic.kn"}, n, n, n, e, e, t},
	{"com.kn", &z[774], x, 0, e, w{"ns.cocca.fr", "pch.nic.kn"}, n, n, n, e, e, f},
	{"edu.kn", &z[774], x, 0, e, w{"ns.cocca.fr", "pch.nic.kn"}, n, n, n, e, e, f},
	{"gov.kn", &z[774], x, 0, e, w{"ns.cocca.fr", "pch.nic.kn"}, n, n, n, e, e, f},
	{"net.kn", &z[774], x, 0, e, w{"ns.cocca.fr", "ns.coccaregistry.org", "pch.nic.kn"}, n, n, n, e, e, f},
	{"org.kn", &z[774], x, 0, e, w{"ns.cocca.fr", "ns.coccaregistry.org", "pch.nic.kn"}, n, n, n, e, e, f},
	{"com.kp", &z[780], x, 0, e, w{"ns1.com.kp", "ns2.com.kp"}, n, n, n, e, e, f},
	{"net.kp", &z[780], x, 0, e, w{"ns1.net.kp", "ns2.net.kp"}, n, n, n, e, e, f},
	{"org.kp", &z[780], x, 0, e, w{"ns1.org.kp", "ns2.org.kp"}, n, n, n, e, e, f},
	{"rep.kp", &z[780], x, 0, e, w{"ns1.rep.kp", "ns2.rep.kp"}, n, n, n, e, e, f},
	{"ac.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"busan.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"chungbuk.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"chungnam.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"co.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"daegu.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"daejeon.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"es.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"gangwon.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"go.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"gwangju.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"gyeongbuk.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"gyeonggi.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"gyeongnam.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"hs.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"incheon.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"jeju.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"jeonbuk.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"jeonnam.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"kg.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"mil.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"ms.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"ne.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"or.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"pe.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"re.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"sc.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"seoul.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"ulsan.kr", &z[783], x, 0, e, w{"b.dns.kr", "c.dns.kr", "d.dns.kr", "e.dns.kr", "f.dns.kr", "g.dns.kr"}, n, n, n, e, e, f},
	{"com.kw", &z[787], x, 0, e, w{"a.nic.kw", "b.nic.kw", "c.nic.kw", "d.nic.kw", "e.nic.kw", "pch.nic.kw"}, n, n, n, e, e, f},
	{"edu.kw", &z[787], x, 0, e, w{"a.nic.kw", "b.nic.kw", "c.nic.kw", "d.nic.kw", "e.nic.kw", "pch.nic.kw"}, n, n, n, e, e, f},
	{"gov.kw", &z[787], x, 0, e, w{"a.nic.kw", "b.nic.kw", "c.nic.kw", "d.nic.kw", "e.nic.kw", "pch.nic.kw"}, n, n, n, e, e, f},
	{"net.kw", &z[787], x, 0, e, w{"a.nic.kw", "b.nic.kw", "c.nic.kw", "d.nic.kw", "e.nic.kw", "pch.nic.kw"}, n, n, n, e, e, f},
	{"org.kw", &z[787], x, 0, e, w{"a.nic.kw", "b.nic.kw", "c.nic.kw", "d.nic.kw", "e.nic.kw", "pch.nic.kw"}, n, n, n, e, e, f},
	{"com.ky", &z[788], x, 0, e, w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, e, e, f},
	{"edu.ky", &z[788], x, 0, e, w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, e, e, f},
	{"gov.ky", &z[788], x, 0, e, w{"ns.gov.ky", "ns2.gov.ky"}, n, n, n, e, e, f},
	{"net.ky", &z[788], x, 0, e, w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, e, e, f},
	{"org.ky", &z[788], x, 0, e, w{"ns1.uniregistry.net", "ns2.uniregistry.info", "ns3.uniregistry.net", "ns4.uniregistry.info"}, n, n, n, e, e, f},
	{"com.kz", &z[791], x, 0, e, w{"ns.nic.kz", "ns2.nic.kz"}, n, n, n, e, e, f},
	{"edu.kz", &z[791], x, 0, e, w{"ns.nic.kz", "ns2.nic.kz"}, n, n, n, e, e, f},
	{"gov.kz", &z[791], x, 0, e, w{"ns.nic.kz", "ns2.nic.kz"}, n, n, n, e, e, f},
	{"mil.kz", &z[791], x, 0, e, w{"ns.nic.kz", "ns2.nic.kz"}, n, n, n, e, e, f},
	{"net.kz", &z[791], x, 0, e, w{"ns.nic.kz", "ns2.nic.kz"}, n, n, n, e, e, f},
	{"org.kz", &z[791], x, 0, e, w{"ns.nic.kz", "ns2.nic.kz"}, n, n, n, e, e, f},
	{"com.lb", &z[809], x, 0, e, w{"nn.uninett.no", "ns3.seacomnet.com", "ns4.seacomnet.com", "rip.psg.com", "zeina.aub.edu.lb"}, n, n, n, e, e, f},
	{"edu.lb", &z[809], x, 0, e, w{"nn.uninett.no", "ns3.seacomnet.com", "ns4.seacomnet.com", "rip.psg.com", "zeina.aub.edu.lb"}, n, n, n, e, e, f},
	{"gov.lb", &z[809], x, 0, e, w{"nn.uninett.no", "ns3.seacomnet.com", "ns4.seacomnet.com", "rip.psg.com", "zeina.aub.edu.lb"}, n, n, n, e, e, f},
	{"net.lb", &z[809], x, 0, e, w{"nn.uninett.no", "ns3.seacomnet.com", "ns4.seacomnet.com", "rip.psg.com", "zeina.aub.edu.lb"}, n, n, n, e, e, f},
	{"org.lb", &z[809], x, 0, e, w{"nn.uninett.no", "ns3.seacomnet.com", "ns4.seacomnet.com", "rip.psg.com", "zeina.aub.edu.lb"}, n, n, n, e, e, f},
	{"24.lc", &z[810], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "24.lc"}, n, n, e, e, t},
	{"co.lc", &z[810], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org", "dns.server.ag"}, n, n, n, e, e, f},
	{"com.lc", &z[810], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org", "dns.server.ag"}, n, n, n, e, e, f},
	{"edu.lc", &z[810], x, 0, e, w{"dns2.server.ag", "ns2.dnsserver.ag"}, n, n, n, e, e, f},
	{"gov.lc", &z[810], x, 0, e, w{"dns2.server.ag", "ns2.dnsserver.ag"}, n, n, n, e, e, f},
	{"l.lc", &z[810], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org", "dns.server.ag"}, n, n, n, e, e, f},
	{"net.lc", &z[810], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org", "dns.server.ag"}, n, n, n, e, e, f},
	{"org.lc", &z[810], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org", "dns.server.ag"}, n, n, n, e, e, f},
	{"p.lc", &z[810], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org", "dns.server.ag"}, n, n, n, e, e, f},
	{"assn.lk", &z[838], x, 0, e, n, n, n, n, e, e, f},
	{"com.lk", &z[838], x, 0, e, n, n, n, n, e, e, f},
	{"edu.lk", &z[838], x, 0, e, n, n, n, n, e, e, f},
	{"gov.lk", &z[838], x, 0, e, w{"c.nic.lk", "d.nic.lk", "m.nic.lk", "ns1.gov.lk", "ns2.gov.lk"}, n, n, n, e, e, f},
	{"grp.lk", &z[838], x, 0, e, n, n, n, n, e, e, f},
	{"hotel.lk", &z[838], x, 0, e, n, n, n, n, e, e, f},
	{"int.lk", &z[838], x, 0, e, n, n, n, n, e, e, f},
	{"ltd.lk", &z[838], x, 0, e, n, n, n, n, e, e, f},
	{"net.lk", &z[838], x, 0, e, n, n, n, n, e, e, f},
	{"ngo.lk", &z[838], x, 0, e, n, n, n, n, e, e, f},
	{"org.lk", &z[838], x, 0, e, n, n, n, n, e, e, f},
	{"sch.lk", &z[838], x, 0, e, w{"ns1.sch.lk"}, n, n, n, e, e, f},
	{"soc.lk", &z[838], x, 0, e, n, n, n, n, e, e, f},
	{"web.lk", &z[838], x, 0, e, n, n, n, n, e, e, f},
	{"com.lr", &z[854], x, 0, e, n, n, n, n, e, e, f},
	{"edu.lr", &z[854], x, 0, e, n, n, n, n, e, e, f},
	{"gov.lr", &z[854], x, 0, e, n, n, n, n, e, e, f},
	{"net.lr", &z[854], x, 0, e, n, n, n, n, e, e, f},
	{"org.lr", &z[854], x, 0, e, n, n, n, n, e, e, f},
	{"vcom.lr", &z[854], x, 0, e, n, n, n, n, e, e, f},
	{"ac.ls", &z[855], x, 0, e, w{"ls-ns.anycast.pch.net", "ns-ls.afrinic.net", "ns1.nic.ls", "ns2.nic.ls", "thaba.nul.ls"}, n, n, n, e, e, t},
	{"co.ls", &z[855], x, 0, e, w{"ls-ns.anycast.pch.net", "ns-ls.afrinic.net", "ns1.nic.ls", "ns2.nic.ls"}, n, n, n, e, e, f},
	{"gov.ls", &z[855], x, 0, e, w{"acst23ns01.gov.ls", "afdp23ns01.gov.ls", "secdns1.posix.co.za", "thaba.nul.ls"}, n, n, n, e, e, t},
	{"net.ls", &z[855], x, 0, e, w{"ls-ns.anycast.pch.net", "ns-ls.afrinic.net", "ns1.leo.co.ls", "ns1.nic.ls", "sas.leo.co.ls"}, n, n, n, e, e, t},
	{"org.ls", &z[855], x, 0, e, w{"ls-ns.anycast.pch.net", "ns-ls.afrinic.net", "ns1.nic.ls", "ns2.nic.ls"}, n, n, n, e, e, f},
	{"sc.ls", &z[855], x, 0, e, w{"ns1.nic.ls", "ns1.telewebls.com", "ns2.nic.ls"}, n, n, n, e, e, f},
	{"gov.lt", &z[856], x, 0, e, w{"ns2.domreg.lt", "ns3.domreg.lt", "ns3.is.lt", "ns4.is.lt"}, n, n, n, e, e, f},
	{"asn.lv", &z[864], x, 0, e, n, n, n, n, e, e, f},
	{"com.lv", &z[864], x, 0, e, n, n, n, n, e, e, f},
	{"conf.lv", &z[864], x, 0, e, n, n, n, n, e, e, f},
	{"edu.lv", &z[864], x, 0, e, n, n, n, n, e, e, f},
	{"gov.lv", &z[864], x, 0, e, w{"a.gov.lv", "b.gov.lv"}, n, n, n, e, e, f},
	{"id.lv", &z[864], x, 0, e, n, n, n, n, e, e, f},
	{"mil.lv", &z[864], x, 0, e, w{"ns1.mil.lv", "ns2.mil.lv"}, n, n, n, e, e, f},
	{"net.lv", &z[864], x, 0, e, n, n, n, n, e, e, f},
	{"org.lv", &z[864], x, 0, e, n, n, n, n, e, e, f},
	{"com.ly", &z[865], x, 0, e, n, n, n, n, e, e, f},
	{"edu.ly", &z[865], x, 0, e, n, n, n, n, e, e, f},
	{"gov.ly", &z[865], x, 0, e, n, n, n, n, e, e, f},
	{"id.ly", &z[865], x, 0, e, n, n, n, n, e, e, f},
	{"med.ly", &z[865], x, 0, e, n, n, n, n, e, e, f},
	{"net.ly", &z[865], x, 0, e, n, n, n, n, e, e, f},
	{"org.ly", &z[865], x, 0, e, n, n, n, n, e, e, f},
	{"plc.ly", &z[865], x, 0, e, n, n, n, n, e, e, f},
	{"sch.ly", &z[865], x, 0, e, n, n, n, n, e, e, f},
	{"ac.ma", &z[866], x, 0, e, w{"a.tld.ma", "b.tld.ma", "c.tld.ma", "d.tld.ma", "dns.inria.fr", "e.tld.ma", "f.tld.ma", "ns-ma.nic.fr"}, n, n, n, e, e, f},
	{"co.ma", &z[866], x, 0, e, w{"a.tld.ma", "b.tld.ma", "c.tld.ma", "d.tld.ma", "dns.inria.fr", "e.tld.ma", "f.tld.ma", "ns-ma.nic.fr"}, n, n, n, e, e, f},
	{"gov.ma", &z[866], x, 0, e, w{"a.tld.ma", "b.tld.ma", "c.tld.ma", "d.tld.ma", "dns.inria.fr", "e.tld.ma", "f.tld.ma", "ns-ma.nic.fr"}, n, n, n, e, e, f},
	{"net.ma", &z[866], x, 0, e, w{"a.tld.ma", "b.tld.ma", "c.tld.ma", "d.tld.ma", "dns.inria.fr", "e.tld.ma", "f.tld.ma", "ns-ma.nic.fr"}, n, n, n, e, e, f},
	{"org.ma", &z[866], x, 0, e, w{"a.tld.ma", "b.tld.ma", "c.tld.ma", "d.tld.ma", "dns.inria.fr", "e.tld.ma", "f.tld.ma", "ns-ma.nic.fr"}, n, n, n, e, e, f},
	{"press.ma", &z[866], x, 0, e, w{"a.tld.ma", "b.tld.ma", "c.tld.ma", "d.tld.ma", "dns.inria.fr", "e.tld.ma", "f.tld.ma", "ns-ma.nic.fr"}, n, n, n, e, e, f},
	{"asso.mc", &z[887], x, 0, e, w{"mc.cctld.authdns.ripe.net", "ns1.nic.mc", "ns2.nic.mc"}, n, n, n, e, e, f},
	{"tm.mc", &z[887], x, 0, e, w{"mc.cctld.authdns.ripe.net", "ns1.nic.mc", "ns2.nic.mc"}, n, n, n, e, e, f},
	{"ac.me", &z[892], x, 0, e, w{"ns.ac.me", "ns2.ac.me"}, n, n, n, e, e, f},
	{"co.me", &z[892], x, 0, e, w{"a0.nic.me", "a2.nic.me", "b0.nic.me", "b2.nic.me", "c0.nic.me"}, n, n, n, e, e, f},
	{"edu.me", &z[892], x, 0, e, w{"ns.edu.me", "ns2.edu.me"}, n, n, n, e, e, f},
	{"gov.me", &z[892], x, 0, e, w{"ns.gov.me", "ns1.gov.me"}, n, n, n, e, e, f},
	{"its.me", &z[892], x, 0, e, w{"a0.nic.me", "a2.nic.me", "b0.nic.me", "b2.nic.me", "c0.nic.me"}, n, n, n, e, e, f},
	{"net.me", &z[892], x, 0, e, w{"a0.nic.me", "a2.nic.me", "b0.nic.me", "b2.nic.me", "c0.nic.me"}, n, n, n, e, e, f},
	{"org.me", &z[892], x, 0, e, w{"a0.nic.me", "a2.nic.me", "b0.nic.me", "b2.nic.me", "c0.nic.me"}, n, n, n, e, e, f},
	{"priv.me", &z[892], x, 0, e, w{"a0.nic.me", "a2.nic.me", "b0.nic.me", "b2.nic.me", "c0.nic.me"}, n, n, n, e, e, f},
	{"co.mg", &z[907], x, 0, e, w{"censvrns0001.ird.fr", "ns-mg.malagasy.com", "ns.dts.mg", "ns.nic.mg", "pch.nic.mg"}, n, n, n, e, e, f},
	{"com.mg", &z[907], x, 0, e, w{"censvrns0001.ird.fr", "ns-mg.malagasy.com", "ns.dts.mg", "ns.nic.mg", "pch.nic.mg"}, n, n, n, e, e, f},
	{"edu.mg", &z[907], x, 0, e, w{"censvrns0001.ird.fr", "ns.dts.mg", "ns.nic.mg", "pch.nic.mg"}, n, n, n, e, e, f},
	{"gov.mg", &z[907], x, 0, e, w{"ns.gov.mg", "ns1.gov.mg", "ns2.gov.mg"}, n, n, n, e, e, f},
	{"in.mg", &z[907], x, 0, e, w{"ns1.in.mg", "ns2.in.mg"}, n, n, n, e, e, t},
	{"mil.mg", &z[907], x, 0, e, w{"censvrns0001.ird.fr", "ns.dts.mg", "ns.nic.mg", "pch.nic.mg"}, n, n, n, e, e, f},
	{"net.mg", &z[907], x, 0, e, w{"censvrns0001.ird.fr", "ns-mg.malagasy.com", "ns.dts.mg", "ns.nic.mg", "pch.nic.mg"}, n, n, n, e, e, f},
	{"nom.mg", &z[907], x, 0, e, w{"censvrns0001.ird.fr", "ns-mg.malagasy.com", "ns.dts.mg", "ns.nic.mg", "pch.nic.mg"}, n, n, n, e, e, f},
	{"org.mg", &z[907], x, 0, e, w{"censvrns0001.ird.fr", "ns-mg.malagasy.com", "ns.dts.mg", "ns.nic.mg", "pch.nic.mg"}, n, n, n, e, e, f},
	{"prd.mg", &z[907], x, 0, e, w{"censvrns0001.ird.fr", "ns-mg.malagasy.com", "ns.dts.mg", "ns.nic.mg", "pch.nic.mg"}, n, n, n, e, e, f},
	{"tm.mg", &z[907], x, 0, e, n, n, n, n, e, e, f},
	{"com.mk", &z[919], x, 0, e, w{"d.ext.nic.cz", "dns-mk.univie.ac.at", "ns2.arnes.si", "tld1.marnet.mk"}, n, n, n, e, e, f},
	{"edu.mk", &z[919], x, 0, e, w{"d.ext.nic.cz", "dns-mk.univie.ac.at", "ns2.arnes.si", "tld1.marnet.mk"}, n, n, n, e, e, f},
	{"gov.mk", &z[919], x, 0, e, w{"d.ext.nic.cz", "dns-mk.univie.ac.at", "ns2.arnes.si", "tld1.marnet.mk"}, n, n, n, e, e, f},
	{"inf.mk", &z[919], x, 0, e, w{"d.ext.nic.cz", "dns-mk.univie.ac.at", "ns2.arnes.si", "tld1.marnet.mk"}, n, n, n, e, e, f},
	{"name.mk", &z[919], x, 0, e, w{"d.ext.nic.cz", "dns-mk.univie.ac.at", "ns2.arnes.si", "tld1.marnet.mk"}, n, n, n, e, e, f},
	{"net.mk", &z[919], x, 0, e, w{"d.ext.nic.cz", "dns-mk.univie.ac.at", "ns2.arnes.si", "tld1.marnet.mk"}, n, n, n, e, e, f},
	{"org.mk", &z[919], x, 0, e, w{"d.ext.nic.cz", "dns-mk.univie.ac.at", "ns2.arnes.si", "tld1.marnet.mk"}, n, n, n, e, e, f},
	{"pro.mk", &z[919], x, 0, e, w{"ns1.pro.mk", "ns2.pro.mk", "ns3.pro.mk", "ns4.pro.mk"}, w{"162.218.232.95"}, n, n, e, e, t},
	{"com.ml", &z[920], x, 0, e, w{"djamako.nic.ml", "dns.gouv.ml"}, n, n, n, e, e, f},
	{"edu.ml", &z[920], x, 0, e, w{"dns01.gouv.ml", "dns02.gouv.ml"}, n, n, n, e, e, t},
	{"gov.ml", &z[920], x, 0, e, w{"dns01.gouv.ml", "dns02.gouv.ml"}, n, n, n, e, e, f},
	{"net.ml", &z[920], x, 0, e, w{"dns01.gouv.ml", "dns02.gouv.ml"}, n, n, n, e, e, f},
	{"org.ml", &z[920], x, 0, e, w{"dns01.gouv.ml", "dns02.gouv.ml"}, n, n, n, e, e, f},
	{"presse.ml", &z[920], x, 0, e, w{"ns01.freenom.com", "ns02.freenom.com", "ns03.freenom.com", "ns04.freenom.com"}, n, n, n, e, e, f},
	{"biz.mm", &z[923], x, 0, e, w{"a.nic.net.mm", "b.nic.net.mm", "c.nic.net.mm", "d.nic.net.mm"}, n, n, n, e, e, f},
	{"com.mm", &z[923], x, 0, e, w{"a.nic.net.mm", "b.nic.net.mm", "c.nic.net.mm", "d.nic.net.mm"}, n, n, n, e, e, f},
	{"edu.mm", &z[923], x, 0, e, w{"a.nic.net.mm", "b.nic.net.mm", "c.nic.net.mm", "d.nic.net.mm"}, n, n, n, e, e, f},
	{"gov.mm", &z[923], x, 0, e, w{"a.nic.net.mm", "b.nic.net.mm", "c.nic.net.mm", "d.nic.net.mm"}, n, n, n, e, e, f},
	{"mil.mm", &z[923], x, 0, e, w{"master.mil.mm", "ns1.mil.mm", "ns2.mil.mm"}, n, n, n, e, e, t},
	{"net.mm", &z[923], x, 0, e, w{"a.nic.net.mm", "b.nic.net.mm", "c.nic.net.mm", "d.nic.net.mm"}, n, n, n, e, e, f},
	{"org.mm", &z[923], x, 0, e, w{"a.nic.net.mm", "b.nic.net.mm", "c.nic.net.mm", "d.nic.net.mm"}, n, n, n, e, e, f},
	{"per.mm", &z[923], x, 0, e, n, n, n, n, e, e, f},
	{"edu.mn", &z[925], x, 0, e, w{"ns.erdemnet.mn", "ns2.erdemnet.mn"}, n, n, n, e, e, f},
	{"gov.mn", &z[925], x, 0, e, w{"ns.gov.mn", "ns1.gov.mn", "ns3.gov.mn", "ns4.gov.mn"}, n, n, n, e, e, f},
	{"org.mn", &z[925], x, 0, e, w{"ns1.magic.mn", "ns3.magic.mn"}, n, n, n, e, e, f},
	{"co.mo", &z[927], x, 0, e, n, n, n, n, e, e, t},
	{"com.mo", &z[927], x, 0, e, w{"a.monic.mo", "b.monic.mo", "c.monic.mo", "d.monic.mo", "e.monic.mo", "ns17.cdns.net", "ns2.cuhk.edu.hk"}, n, n, n, e, e, f},
	{"edu.mo", &z[927], x, 0, e, w{"a.monic.mo", "b.monic.mo", "c.monic.mo", "d.monic.mo", "e.monic.mo", "ns17.cdns.net", "ns2.cuhk.edu.hk"}, n, n, n, e, e, f},
	{"gov.mo", &z[927], x, 0, e, w{"ns1.gov.mo", "ns2.gov.mo", "ns3.gov.mo", "ns4.gov.mo", "ns5.gov.mo"}, n, n, n, e, e, f},
	{"net.mo", &z[927], x, 0, e, w{"a.monic.mo", "b.monic.mo", "c.monic.mo", "d.monic.mo", "e.monic.mo", "ns17.cdns.net", "ns2.cuhk.edu.hk"}, n, n, n, e, e, f},
	{"org.mo", &z[927], x, 0, e, w{"a.monic.mo", "b.monic.mo", "c.monic.mo", "d.monic.mo", "e.monic.mo", "ns17.cdns.net", "ns2.cuhk.edu.hk"}, n, n, n, e, e, f},
	{"co.mp", &z[949], x, 0, e, w{"ns1.nic.net.mp", "ns2.nic.net.mp"}, n, n, n, e, e, t},
	{"com.mp", &z[949], x, 0, e, n, n, n, n, e, e, f},
	{"gov.mp", &z[949], x, 0, e, w{"ns1.nic.net.mp", "ns2.nic.net.mp"}, n, n, n, e, e, f},
	{"org.mp", &z[949], x, 0, e, w{"ns1.nic.net.mp", "ns2.nic.net.mp"}, n, n, n, e, e, f},
	{"edu.mr", &z[951], x, 0, e, w{"ns-mr.afrinic.net", "ns-mr.nic.fr", "ns-mr.nic.tn", "ns1.nic.mr", "ns2.nic.mr", "ns3.nic.mr"}, n, n, n, e, e, t},
	{"gov.mr", &z[951], x, 0, e, w{"dns.mauritania.mr", "dns2.mauritania.mr"}, n, n, n, e, e, f},
	{"org.mr", &z[951], x, 0, e, w{"ns-mr.afrinic.net", "ns-mr.nic.fr", "ns-mr.nic.tn", "ns1.nic.mr", "ns2.nic.mr", "ns3.nic.mr"}, n, n, n, e, e, t},
	{"perso.mr", &z[951], x, 0, e, w{"ns-mr.afrinic.net", "ns-mr.nic.fr", "ns-mr.nic.tn", "ns1.nic.mr", "ns2.nic.mr", "ns3.nic.mr"}, n, n, n, e, e, t},
	{"co.ms", &z[954], x, 0, e, w{"ns.cocca.fr"}, n, n, n, e, e, f},
	{"com.ms", &z[954], x, 0, e, w{"ns.cocca.fr"}, n, n, n, e, e, f},
	{"net.ms", &z[954], x, 0, e, w{"ns1.idnscan.net", "ns6.idnscan.net"}, n, n, n, e, e, t},
	{"org.ms", &z[954], x, 0, e, w{"ns.cocca.fr"}, n, n, n, e, e, f},
	{"com.mt", &z[956], x, 0, e, w{"a.ns.mt", "b.ns.mt", "f.ns.mt", "p.ns.mt"}, n, n, n, e, e, f},
	{"edu.mt", &z[956], x, 0, e, w{"a.ns.mt", "b.ns.mt", "f.ns.mt", "p.ns.mt"}, n, n, n, e, e, f},
	{"gov.mt", &z[956], x, 0, e, w{"ns1-09.azure-dns.com", "ns2-09.azure-dns.net", "ns3-09.azure-dns.org", "ns4-09.azure-dns.info"}, n, n, n, e, e, f},
	{"net.mt", &z[956], x, 0, e, w{"a.ns.mt", "b.ns.mt", "f.ns.mt", "p.ns.mt"}, n, n, n, e, e, f},
	{"org.mt", &z[956], x, 0, e, w{"a.ns.mt", "b.ns.mt", "f.ns.mt", "p.ns.mt"}, n, n, n, e, e, f},
	{"24.mu", &z[960], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "24.mu"}, n, n, e, e, t},
	{"ac.mu", &z[960], x, 0, e, w{"anycast1.irondns.net", "fork.sth.dnsnode.net", "mu1.dyntld.net", "mu2.dyntld.net", "mu3.dyntld.net", "mu4.dyntld.net", "udns1.tld.mu", "udns2.tld.mu"}, n, n, n, e, e, f},
	{"co.mu", &z[960], x, 0, e, w{"anycast1.irondns.net", "fork.sth.dnsnode.net", "mu1.dyntld.net", "mu2.dyntld.net", "mu3.dyntld.net", "mu4.dyntld.net", "udns1.tld.mu", "udns2.tld.mu"}, n, n, n, e, e, t},
	{"com.mu", &z[960], x, 0, e, w{"anycast1.irondns.net", "fork.sth.dnsnode.net", "mu1.dyntld.net", "mu2.dyntld.net", "mu3.dyntld.net", "mu4.dyntld.net", "udns1.tld.mu", "udns2.tld.mu"}, n, n, n, e, e, f},
	{"gov.mu", &z[960], x, 0, e, w{"ns0.gov.mu", "ns1.gov.mu", "ns2.gov.mu", "ns3.gov.mu", "ns4.gov.mu"}, n, n, n, e, e, f},
	{"net.mu", &z[960], x, 0, e, w{"anycast1.irondns.net", "fork.sth.dnsnode.net", "mu1.dyntld.net", "mu2.dyntld.net", "mu3.dyntld.net", "mu4.dyntld.net", "udns1.tld.mu", "udns2.tld.mu"}, n, n, n, e, e, f},
	{"nom.mu", &z[960], x, 0, e, w{"ns1.mu-dns.net", "ns2.mu-dns.net"}, w{"185.243.56.15"}, n, n, e, e, f},
	{"or.mu", &z[960], x, 0, e, w{"anycast1.irondns.net", "fork.sth.dnsnode.net", "mu1.dyntld.net", "mu2.dyntld.net", "mu3.dyntld.net", "mu4.dyntld.net", "udns1.tld.mu", "udns2.tld.mu"}, n, n, n, e, e, f},
	{"org.mu", &z[960], x, 0, e, w{"anycast1.irondns.net", "fork.sth.dnsnode.net", "mu1.dyntld.net", "mu2.dyntld.net", "mu3.dyntld.net", "mu4.dyntld.net", "udns1.tld.mu", "udns2.tld.mu"}, n, n, n, e, e, f},
	{"aero.mv", &z[967], x, 0, "http://www.brunet.bn/products_webrelated_domain_main.htm", w{"mv-ns.anycast.pch.net", "ns-cache01.dhivehinet.net.mv", "ns.aero.mv", "ns2.dhivehinet.net.mv"}, n, n, n, e, e, f},
	{"biz.mv", &z[967], x, 0, e, w{"webns.mv"}, n, n, n, e, e, f},
	{"com.mv", &z[967], x, 0, e, w{"mv-ns.anycast.pch.net", "ns.com.mv", "ns.dhivehinet.net.mv", "ns2.dhivehinet.net.mv"}, n, n, n, e, e, f},
	{"coop.mv", &z[967], x, 0, e, n, n, n, n, e, e, f},
	{"edu.mv", &z[967], x, 0, e, w{"mv-ns.anycast.pch.net", "ns.edu.mv", "ns1.edu.mv", "ns2.edu.mv"}, n, n, n, e, e, f},
	{"gov.mv", &z[967], x, 0, e, w{"mv-ns.anycast.pch.net", "ns.dhivehinet.net.mv", "ns.gov.mv", "ns2.dhivehinet.net.mv"}, n, n, n, e, e, f},
	{"info.mv", &z[967], x, 0, e, n, n, n, n, e, e, f},
	{"int.mv", &z[967], x, 0, e, n, n, n, n, e, e, f},
	{"mil.mv", &z[967], x, 0, e, n, n, n, n, e, e, f},
	{"museum.mv", &z[967], x, 0, e, n, n, n, n, e, e, f},
	{"name.mv", &z[967], x, 0, e, n, n, n, n, e, e, f},
	{"net.mv", &z[967], x, 0, e, w{"mv-ns.anycast.pch.net", "ns.net.mv", "ns2.dhivehinet.net.mv"}, n, n, n, e, e, f},
	{"org.mv", &z[967], x, 0, e, w{"mv-ns.anycast.pch.net", "ns.org.mv", "ns2.dhivehinet.net.mv"}, n, n, n, e, e, f},
	{"pro.mv", &z[967], x, 0, e, w{"host13.dhivehinet.net.mv"}, n, n, n, e, e, f},
	{"ac.mw", &z[968], x, 0, e, w{"chambo.sdnp.org.mw", "d.ext.nic.cz", "domwe.sdn.mw", "mw.cctld.authdns.ripe.net", "ns4.apnic.net", "pch1.nic.mw", "rip.psg.com"}, n, n, n, e, e, f},
	{"co.mw", &z[968], x, 0, e, w{"chambo.sdnp.org.mw", "d.ext.nic.cz", "domwe.sdn.mw", "ns4.apnic.net", "pch1.nic.mw", "rip.psg.com"}, n, n, n, e, e, f},
	{"com.mw", &z[968], x, 0, e, w{"chambo.sdnp.org.mw", "d.ext.nic.cz", "domwe.sdn.mw", "ns4.apnic.net", "pch1.nic.mw", "rip.psg.com"}, n, n, n, e, e, f},
	{"coop.mw", &z[968], x, 0, e, w{"chambo.sdnp.org.mw", "d.ext.nic.cz", "domwe.sdn.mw", "pch1.nic.mw", "rip.psg.com", "rip.psg.mw"}, n, n, n, e, e, f},
	{"edu.mw", &z[968], x, 0, e, w{"chambo.sdnp.org.mw", "d.ext.nic.cz", "domwe.sdn.mw", "mw.cctld.authdns.ripe.net", "ns4.apnic.net", "pch1.nic.mw", "rip.psg.com"}, n, n, n, e, e, f},
	{"gov.mw", &z[968], x, 0, e, w{"chambo.sdnp.org.mw", "d.ext.nic.cz", "domwe.sdn.mw", "mw.cctld.authdns.ripe.net", "ns4.apnic.net", "pch1.nic.mw", "rip.psg.com"}, n, n, n, e, e, f},
	{"int.mw", &z[968], x, 0, e, w{"chambo.sdnp.org.mw", "d.ext.nic.cz", "domwe.sdn.mw", "pch1.nic.mw", "rip.psg.com", "rip.psg.mw"}, n, n, n, e, e, f},
	{"museum.mw", &z[968], x, 0, e, w{"a.dnspod.com", "b.dnspod.com", "c.dnspod.com"}, n, n, n, e, e, f},
	{"net.mw", &z[968], x, 0, e, w{"chambo.sdnp.org.mw", "d.ext.nic.cz", "domwe.sdn.mw", "ns4.apnic.net", "pch1.nic.mw", "rip.psg.com"}, n, n, n, e, e, f},
	{"org.mw", &z[968], x, 0, e, w{"chambo.sdnp.org.mw", "d.ext.nic.cz", "domwe.sdn.mw", "mw.cctld.authdns.ripe.net", "ns4.apnic.net", "pch1.nic.mw", "rip.psg.com"}, n, n, n, e, e, f},
	{"com.mx", &z[969], x, 0, e, w{"c.mx-ns.mx", "e.mx-ns.mx", "i.mx-ns.mx", "m.mx-ns.mx", "o.mx-ns.mx", "x.mx-ns.mx"}, n, n, n, e, e, f},
	{"edu.mx", &z[969], x, 0, e, w{"c.mx-ns.mx", "e.mx-ns.mx", "i.mx-ns.mx", "m.mx-ns.mx", "o.mx-ns.mx", "x.mx-ns.mx"}, n, n, n, e, e, f},
	{"gob.mx", &z[969], x, 0, e, w{"c.mx-ns.mx", "e.mx-ns.mx", "i.mx-ns.mx", "m.mx-ns.mx", "o.mx-ns.mx", "x.mx-ns.mx"}, n, n, n, e, e, f},
	{"net.mx", &z[969], x, 0, e, w{"c.mx-ns.mx", "e.mx-ns.mx", "i.mx-ns.mx", "m.mx-ns.mx", "o.mx-ns.mx", "x.mx-ns.mx"}, n, n, n, e, e, f},
	{"org.mx", &z[969], x, 0, e, w{"c.mx-ns.mx", "e.mx-ns.mx", "i.mx-ns.mx", "m.mx-ns.mx", "o.mx-ns.mx", "x.mx-ns.mx"}, n, n, n, e, e, f},
	{"com.my", &z[970], x, 0, "https://mynic.my/", w{"a.mynic.centralnic-dns.com", "b.mynic.centralnic-dns.com", "b.nic.my", "b1.nic.my", "c.mynic.centralnic-dns.com", "d.mynic.centralnic-dns.com"}, n, n, n, e, e, t},
	{"edi.my", &z[970], x, 0x800, e, n, n, n, n, e, e, t},
	{"edu.my", &z[970], x, 0, e, w{"a.mynic.centralnic-dns.com", "b.mynic.centralnic-dns.com", "b.nic.my", "b1.nic.my", "c.mynic.centralnic-dns.com", "d.mynic.centralnic-dns.com"}, n, n, n, e, e, f},
	{"gov.my", &z[970], x, 0, e, w{"a.mynic.centralnic-dns.com", "b.mynic.centralnic-dns.com", "b.nic.my", "b1.nic.my", "c.mynic.centralnic-dns.com", "d.mynic.centralnic-dns.com"}, n, n, n, e, e, f},
	{"mil.my", &z[970], x, 0, e, w{"a.mynic.centralnic-dns.com", "b.mynic.centralnic-dns.com", "b.nic.my", "b1.nic.my", "c.mynic.centralnic-dns.com", "d.mynic.centralnic-dns.com"}, n, n, n, e, e, f},
	{"name.my", &z[970], x, 0, "https://mynic.my/", w{"a.mynic.centralnic-dns.com", "b.mynic.centralnic-dns.com", "b.nic.my", "b1.nic.my", "c.mynic.centralnic-dns.com", "d.mynic.centralnic-dns.com"}, n, n, n, e, e, f},
	{"net.my", &z[970], x, 0, "https://mynic.my/", w{"a.mynic.centralnic-dns.com", "b.mynic.centralnic-dns.com", "b.nic.my", "b1.nic.my", "c.mynic.centralnic-dns.com", "d.mynic.centralnic-dns.com"}, n, n, n, e, e, f},
	{"org.my", &z[970], x, 0, e, w{"a.mynic.centralnic-dns.com", "b.mynic.centralnic-dns.com", "b.nic.my", "b1.nic.my", "c.mynic.centralnic-dns.com", "d.mynic.centralnic-dns.com"}, n, n, n, e, e, f},
	{"ac.mz", &z[971], x, 0, e, w{"anyns.uem.mz", "dzowo.uem.mz", "ns-mz.afrinic.net", "oceano.uem.mz", "phloem.uoregon.edu", "zebra.uem.mz"}, n, n, n, e, e, f},
	{"adv.mz", &z[971], x, 0, e, w{"anyns.uem.mz", "dzowo.uem.mz", "ns-mz.afrinic.net", "oceano.uem.mz", "phloem.uoregon.edu", "zebra.uem.mz"}, n, n, n, e, e, f},
	{"co.mz", &z[971], x, 0, e, w{"anyns.uem.mz", "dzowo.uem.mz", "ns-mz.afrinic.net", "oceano.uem.mz", "phloem.uoregon.edu", "zebra.uem.mz"}, n, n, n, e, e, f},
	{"edu.mz", &z[971], x, 0, e, w{"anyns.uem.mz", "dzowo.uem.mz", "ns-mz.afrinic.net", "oceano.uem.mz", "phloem.uoregon.edu", "zebra.uem.mz"}, n, n, n, e, e, f},
	{"gov.mz", &z[971], x, 0, e, w{"anyns.uem.mz", "dzowo.uem.mz", "ns-mz.afrinic.net", "oceano.uem.mz", "phloem.uoregon.edu", "zebra.uem.mz"}, n, n, n, e, e, f},
	{"net.mz", &z[971], x, 0, e, w{"anyns.uem.mz", "dzowo.uem.mz", "ns-mz.afrinic.net", "oceano.uem.mz", "phloem.uoregon.edu", "zebra.uem.mz"}, n, n, n, e, e, t},
	{"org.mz", &z[971], x, 0, e, w{"anyns.uem.mz", "dzowo.uem.mz", "ns-mz.afrinic.net", "oceano.uem.mz", "phloem.uoregon.edu", "zebra.uem.mz"}, n, n, n, e, e, f},
	{"alt.na", &z[973], x, 0, e, w{"katima.omadhina.net", "na-ns.anycast.pch.net", "ns-na.afrinic.net", "oneu.omadhina.co.na"}, n, n, n, e, e, f},
	{"cc.na", &z[973], x, 0, e, w{"beau.ns.cloudflare.com", "reza.ns.cloudflare.com"}, n, n, n, e, e, f},
	{"co.na", &z[973], x, 0, e, w{"katima.omadhina.net", "na-ns.anycast.pch.net", "ns-na.afrinic.net", "oneu.omadhina.net", "secdns1.posix.co.za"}, n, n, n, e, e, f},
	{"com.na", &z[973], x, 0, e, w{"katima.omadhina.net", "na-ns.anycast.pch.net", "ns-na.afrinic.net"}, n, n, n, e, e, f},
	{"dr.na", &z[973], x, 0, e, w{"ns1.click.na", "ns2.click.na"}, n, n, n, e, e, f},
	{"edu.na", &z[973], x, 0, e, w{"katima.omadhina.net", "na-ns.anycast.pch.net", "ns-na.afrinic.net", "oneu.omadhina.co.na"}, n, n, n, e, e, f},
	{"in.na", &z[973], x, 0, e, w{"ns21.cloudns.net", "ns22.cloudns.net", "ns23.cloudns.net", "ns24.cloudns.net"}, n, n, n, e, e, f},
	{"info.na", &z[973], x, 0, e, w{"clint.ns.cloudflare.com", "jocelyn.ns.cloudflare.com"}, n, n, n, e, e, f},
	{"mobi.na", &z[973], x, 0, e, n, n, n, n, e, e, f},
	{"name.na", &z[973], x, 0, e, n, n, n, n, e, e, f},
	{"net.na", &z[973], x, 0, e, w{"katima.omadhina.net", "na-ns.anycast.pch.net", "ns-na.afrinic.net", "oneu.omadhina.co.na"}, n, n, n, e, e, f},
	{"of.na", &z[973], x, 0, e, n, n, n, n, e, e, f},
	{"or.na", &z[973], x, 0, e, n, n, n, n, e, e, f},
	{"org.na", &z[973], x, 0, e, w{"katima.omadhina.net", "na-ns.anycast.pch.net", "ns-na.afrinic.net", "oneu.omadhina.co.na"}, n, n, n, e, e, f},
	{"pro.na", &z[973], x, 0x800, e, n, n, n, n, e, e, f},
	{"school.na", &z[973], x, 0, e, w{"beau.ns.cloudflare.com", "reza.ns.cloudflare.com"}, n, n, n, e, e, f},
	{"tv.na", &z[973], x, 0, e, n, n, n, n, e, e, f},
	{"ws.na", &z[973], x, 0, e, n, n, n, n, e, e, f},
	{"kyrylkov.name", &z[977], x, 0, e, n, n, n, n, e, e, t},
	{"puig.name", &z[977], x, 0, e, n, n, n, n, e, e, t},
	{"santos.name", &z[977], x, 0, e, n, n, n, n, e, e, t},
	{"asso.nc", &z[983], x, 0, e, w{"any-ns1.nc", "ns1.nc", "ns2.nc"}, n, n, n, e, e, f},
	{"com.nc", &z[983], x, 0, e, n, n, n, n, e, e, t},
	{"nom.nc", &z[983], x, 0, e, w{"any-ns1.nc", "ns1.nc", "ns2.nc"}, n, n, n, e, e, f},
	{"com.ne", &z[984], x, 0, e, n, n, n, n, e, e, f},
	{"info.ne", &z[984], x, 0, e, n, n, n, n, e, e, f},
	{"int.ne", &z[984], x, 0, e, n, n, n, n, e, e, f},
	{"org.ne", &z[984], x, 0, e, n, n, n, n, e, e, f},
	{"perso.ne", &z[984], x, 0, e, n, n, n, n, e, e, f},
	{"1x.net", &z[986], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "1x.net"}, n, n, e, e, t},
	{"auz.net", &z[986], x, 0, e, w{"ns1.instradns.com", "ns2.instradns.com", "ns3.instradns.com"}, n, n, n, e, e, f},
	{"gb.net", &z[986], x, 0, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"54.153.56.183", "gb.net"}, n, n, "whois.centralnic.com", e, t},
	{"hu.net", &z[986], x, 0, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"54.153.56.183", "hu.net"}, n, n, "whois.centralnic.com", e, f},
	{"in.net", &z[986], x, 0, e, w{"ns1.nic.in.net", "ns2.nic.in.net", "ns3.nic.in.net", "ns4.nic.in.net"}, n, n, n, "whois.centralnic.com", e, f},
	{"jp.net", &z[986], x, 0, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"205.164.14.88"}, n, n, "whois.centralnic.com", e, f},
	{"ru.net", &z[986], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"se.net", &z[986], x, 0, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"54.153.56.183", "se.net"}, n, n, "whois.centralnic.com", e, t},
	{"uk.net", &z[986], x, 0, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"54.153.56.183", "uk.net"}, n, n, "whois.centralnic.com", e, t},
	{"za.net", &z[986], x, 0, e, w{"igubu.saix.net", "ns0.is.co.za", "ns0.plig.net", "ns1.plig.net", "ns2.plig.net", "ns3.iafrica.com"}, n, n, n, "whois.za.net", e, t},
	{"arts.nf", &z[998], x, 0, e, w{"ns.anycast.nic.nf", "ns.cocca.fr", "ns.coccaregistry.org"}, n, n, n, e, e, f},
	{"com.nf", &z[998], x, 0, e, w{"ns.anycast.nic.nf", "ns.cocca.fr", "ns.coccaregistry.org"}, n, n, n, e, e, f},
	{"firm.nf", &z[998], x, 0, e, w{"ns.anycast.nic.nf", "ns.cocca.fr", "ns.coccaregistry.org"}, n, n, n, e, e, f},
	{"info.nf", &z[998], x, 0, e, w{"ns.anycast.nic.nf", "ns.cocca.fr", "ns.coccaregistry.org"}, n, n, n, e, e, f},
	{"net.nf", &z[998], x, 0, e, w{"ns.anycast.nic.nf", "ns.cocca.fr", "ns.coccaregistry.org"}, n, n, n, e, e, f},
	{"org.nf", &z[998], x, 0, e, w{"ns.anycast.nic.nf", "ns.cocca.fr", "ns.coccaregistry.org"}, n, n, n, e, e, f},
	{"other.nf", &z[998], x, 0, e, w{"ns.anycast.nic.nf", "ns.cocca.fr"}, n, n, n, e, e, f},
	{"per.nf", &z[998], x, 0, e, w{"ns.anycast.nic.nf", "ns.cocca.fr", "ns.coccaregistry.org"}, n, n, n, e, e, f},
	{"rec.nf", &z[998], x, 0, e, w{"ns.anycast.nic.nf", "ns.cocca.fr", "ns.coccaregistry.org"}, n, n, n, e, e, f},
	{"store.nf", &z[998], x, 0, e, w{"ns.anycast.nic.nf", "ns.cocca.fr", "ns.coccaregistry.org"}, n, n, n, e, e, f},
	{"us.nf", &z[998], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "us.nf"}, n, n, e, e, t},
	{"web.nf", &z[998], x, 0, e, w{"ns.anycast.nic.nf", "ns.cocca.fr", "ns.coccaregistry.org"}, n, n, n, e, e, f},
	{"com.ng", &z[1000], x, 0, e, w{"ns1.nic.net.ng", "ns2.nic.net.ng", "ns5.nic.net.ng", "nsa.nic.net.ng"}, n, n, n, e, e, f},
	{"edu.ng", &z[1000], x, 0, e, w{"ns1.nic.net.ng", "ns2.nic.net.ng", "ns5.nic.net.ng", "nsa.nic.net.ng"}, n, n, n, e, e, f},
	{"gov.ng", &z[1000], z[5100:5101], 0, e, w{"ns1.nic.net.ng", "ns2.nic.net.ng", "ns5.nic.net.ng", "nsa.nic.net.ng"}, n, n, n, e, e, f},
	{"i.ng", &z[1000], x, 0, e, w{"ns1.nic.net.ng", "ns2.nic.net.ng", "ns5.nic.net.ng", "nsa.nic.net.ng"}, n, n, n, e, e, t},
	{"mil.ng", &z[1000], x, 0, e, w{"ns1.nic.net.ng", "ns2.nic.net.ng", "ns5.nic.net.ng", "nsa.nic.net.ng"}, n, n, n, e, e, t},
	{"mobi.ng", &z[1000], x, 0, e, w{"ns1.nic.net.ng", "ns2.nic.net.ng", "ns5.nic.net.ng", "nsa.nic.net.ng"}, n, n, n, e, e, f},
	{"name.ng", &z[1000], x, 0, e, w{"ns1.nic.net.ng", "ns2.nic.net.ng", "ns5.nic.net.ng", "nsa.nic.net.ng"}, n, n, n, e, e, f},
	{"net.ng", &z[1000], x, 0, e, w{"ns1.nic.net.ng", "ns2.nic.net.ng", "ns5.nic.net.ng", "nsa.nic.net.ng"}, n, n, n, e, e, f},
	{"org.ng", &z[1000], x, 0, e, w{"ns1.nic.net.ng", "ns2.nic.net.ng", "ns5.nic.net.ng", "nsa.nic.net.ng"}, n, n, n, e, e, f},
	{"sch.ng", &z[1000], x, 0, e, w{"ns1.nic.net.ng", "ns2.nic.net.ng", "ns5.nic.net.ng", "nsa.nic.net.ng"}, n, n, n, e, e, f},
	{"ac.ni", &z[1003], x, 0, e, w{"auth01.ns.uu.net", "dns-ext.nic.cr", "ns.ideay.net.ni", "ns.ni", "ns.uu.net", "ns2.ni", "ns3.ni"}, n, n, n, e, e, f},
	{"biz.ni", &z[1003], x, 0, e, w{"auth01.ns.uu.net", "dns-ext.nic.cr", "dns.nic.cr", "ns.ibw.com.ni", "ns.ideay.net.ni", "ns.ni", "ns.tmx.com.ni", "ns.uu.net", "ns1.bb-online.net", "ns2.ni", "ns3.ni"}, n, n, n, e, e, f},
	{"co.ni", &z[1003], x, 0, e, w{"dns-ext.nic.cr", "ns.ideay.net.ni", "ns.ni", "ns.uu.net", "ns2.ni", "ns3.ni"}, n, n, n, e, e, f},
	{"com.ni", &z[1003], x, 0, e, w{"dns-ext.nic.cr", "ns.ideay.net.ni", "ns.ni", "ns.uu.net", "ns2.ni", "ns3.ni"}, n, n, n, e, e, f},
	{"edu.ni", &z[1003], x, 0, e, w{"auth01.ns.uu.net", "dns-ext.nic.cr", "ns.ideay.net.ni", "ns.ni", "ns.uu.net", "ns2.ni", "ns3.ni"}, n, n, n, e, e, f},
	{"gob.ni", &z[1003], x, 0, e, w{"dns-ext.nic.cr", "ns.ideay.net.ni", "ns.ni", "ns.uu.net", "ns2.ni", "ns3.ni"}, n, n, n, e, e, f},
	{"gov.ni", &z[1003], x, 0, e, n, n, n, n, e, e, t},
	{"in.ni", &z[1003], x, 0, e, w{"dns-ext.nic.cr", "ns.ideay.net.ni", "ns.ni", "ns.uu.net", "ns2.ni", "ns3.ni"}, n, n, n, e, e, f},
	{"info.ni", &z[1003], x, 0, e, w{"dns-ext.nic.cr", "ns.ideay.net.ni", "ns.ni", "ns.uu.net", "ns2.ni", "ns3.ni"}, n, n, n, e, e, f},
	{"int.ni", &z[1003], x, 0, e, w{"dns-ext.nic.cr", "ns.ideay.net.ni", "ns.ni", "ns.uu.net", "ns1.bb-online.net", "ns2.ni", "ns3.ni"}, n, n, n, e, e, f},
	{"mil.ni", &z[1003], x, 0, e, w{"dns-ext.nic.cr", "ns.ideay.net.ni", "ns.ni", "ns.uu.net", "ns2.ni", "ns3.ni"}, n, n, n, e, e, f},
	{"net.ni", &z[1003], x, 0, e, w{"dns-ext.nic.cr", "ns.ideay.net.ni", "ns.ni", "ns.uu.net", "ns2.ni", "ns3.ni"}, n, n, n, e, e, f},
	{"nom.ni", &z[1003], x, 0, e, w{"dns-ext.nic.cr", "dns.nic.cr", "ns.ideay.net.ni", "ns.ni", "ns.uu.net", "ns2.ni", "ns3.ni"}, n, n, n, e, e, f},
	{"org.ni", &z[1003], x, 0, e, w{"dns-ext.nic.cr", "ns.ideay.net.ni", "ns.ni", "ns.uu.net", "ns2.ni", "ns3.ni"}, n, n, n, e, e, f},
	{"web.ni", &z[1003], x, 0, e, w{"dns-ext.nic.cr", "ns.ideay.net.ni", "ns.ni", "ns.uu.net", "ns2.ni", "ns3.ni"}, n, n, n, e, e, f},
	{"24.nl", &z[1010], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "24.nl"}, n, n, e, e, t},
	{"co.nl", &z[1010], x, 0x200, e, w{"a.nic.co.nl", "b.nic.co.nl", "c.nic.co.nl", "d.nic.co.nl"}, n, n, n, e, e, f},
	{"com.nl", &z[1010], x, 0x200, e, w{"ns1.com.nl", "ns2.com.nl"}, w{"185.85.211.136"}, n, n, e, e, f},
	{"net.nl", &z[1010], x, 0x200, e, w{"ns1.com.nl", "ns2.com.nl"}, w{"185.85.211.136"}, n, n, e, e, f},
	{"nom.nl", &z[1010], x, 0, e, w{"ns1.hostnet.nl", "ns2.hostnetbv.com", "ns3.hostnetbv.nl"}, n, n, n, e, e, f},
	{"punt.nl", &z[1010], x, 0x200, "http://www.punt.nl/", w{"nsn1.mijndomein.nl", "nsn2.mijndomein.nl", "nsn3.mijndomein.nl"}, w{"2a05:d018:964:c0a:a58f:6b32:e401:3d8a", "34.240.216.169", "hosting-1a.mijndomein-ws.nl"}, n, n, e, e, f},
	{"co.no", &z[1011], x, 0, "https://www.norid.no/index.en.html", w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, n, n, n, e, e, t},
	{"fhs.no", &z[1011], x, 0, e, w{"x.nic.no", "y.nic.no", "z.nic.no"}, n, n, n, e, e, f},
	{"folkebibl.no", &z[1011], x, 0, e, w{"x.nic.no", "y.nic.no", "z.nic.no"}, n, n, n, e, e, f},
	{"fylkesbibl.no", &z[1011], x, 0, e, w{"x.nic.no", "y.nic.no", "z.nic.no"}, n, n, n, e, e, f},
	{"gs.no", &z[1011], x, 0, e, w{"ns1.hyp.net", "ns2.hyp.net", "ns3.hyp.net"}, n, n, n, e, e, f},
	{"idrett.no", &z[1011], x, 0, e, w{"x.nic.no", "y.nic.no", "z.nic.no"}, n, n, n, e, e, f},
	{"museum.no", &z[1011], x, 0, e, w{"x.nic.no", "y.nic.no", "z.nic.no"}, n, n, n, e, e, f},
	{"priv.no", &z[1011], x, 0, e, w{"x.nic.no", "y.nic.no", "z.nic.no"}, n, n, n, e, e, f},
	{"uenorge.no", &z[1011], x, 0, e, w{"x.nic.no", "y.nic.no", "z.nic.no"}, n, n, n, e, e, f},
	{"vgs.no", &z[1011], x, 0, e, w{"x.nic.no", "y.nic.no", "z.nic.no"}, n, n, n, e, e, f},
	{"academy.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"accountants.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"actor.np", &z[1019], x, 0, "https://register.com.np/", w{"manaslu.mos.com.np", "np-ns.npix.net.np", "np.cctld.authdns.ripe.net", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np", "sungava.mos.com.np"}, n, n, n, e, e, f},
	{"aero.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"agency.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "np.cctld.authdns.ripe.net", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"asia.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"associates.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "np.cctld.authdns.ripe.net", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"audio.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"bar.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"bargains.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"beer.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"bid.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"bike.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"bio.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "np.cctld.authdns.ripe.net", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"biz.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"black.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"blue.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "pch.nnic.np", "sec2.apnic.net"}, n, n, n, e, e, f},
	{"boutique.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "np.cctld.authdns.ripe.net", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"build.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"builders.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"buzz.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"cab.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"camera.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"camp.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"capital.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"cards.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"care.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"careers.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"cash.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"catering.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"center.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"ceo.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"christmas.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"clinic.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"clothing.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"club.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"codes.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"coffee.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"college.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"com.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "np.cctld.authdns.ripe.net", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"community.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"company.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"computer.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"cool.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"coop.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np", "sungava.mos.com.np"}, n, n, n, e, e, f},
	{"country.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"credit.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"creditcard.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"dental.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"diamonds.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "np.cctld.authdns.ripe.net", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"edu.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "np.cctld.authdns.ripe.net", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"email.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"engineering.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"estate.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"events.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"expert.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"finance.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"financial.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"fish.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"fishing.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"fitness.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"flights.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"florist.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"fund.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"furniture.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"futbol.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"gallery.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"gov.np", &z[1019], x, 0, "https://nitc.gov.np/", w{"koshi.nitc.gov.np", "mechi.nitc.gov.np", "np-ns.npix.net.np", "np.cctld.authdns.ripe.net", "ns-ext.vix.com", "ns-np.ripe.net", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"guitars.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"guru.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"hiphop.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"hiv.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"house.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"industries.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"info.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"ink.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"jobs.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"limited.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"link.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"management.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"marketing.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"media.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"menu.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"mil.np", &z[1019], x, 0, "https://register.com.np/", w{"np.cctld.authdns.ripe.net", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"mobi.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"museum.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"name.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"net.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "np.cctld.authdns.ripe.net", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"ninja.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"onl.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"org.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "np.cctld.authdns.ripe.net", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"partners.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"parts.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"photo.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "np.cctld.authdns.ripe.net", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"photos.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"pics.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"pink.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"pro.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"productions.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"products.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"properties.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"pub.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"red.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"rentals.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"repair.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"rest.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"rocks.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"services.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"shiksha.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"shoes.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"social.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"solar.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"solutions.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"space.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"supplies.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"supply.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"support.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"surf.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"surgery.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"systems.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"tattoo.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"tax.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"technology.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"tel.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"tips.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"today.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net"}, n, n, n, e, e, f},
	{"tools.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"town.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"trade.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"training.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"travel.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"university.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"vacations.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"ventures.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"villas.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"vision.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"vodka.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"voting.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"voyage.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"watch.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"webcam.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"wiki.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"works.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"wtf.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"xyz.np", &z[1019], x, 0, "https://register.com.np/", w{"np-ns.npix.net.np", "ns-ext.vix.com", "ns4.apnic.net", "pch.nnic.np", "sec2.apnic.net", "shikhar.mos.com.np"}, n, n, n, e, e, f},
	{"zone.np", &z[1019], x, 0, "https://register.com.np/", n, n, n, n, e, e, f},
	{"biz.nr", &z[1020], x, 0, e, w{"ns0.cenpac.net.nr", "ns1.cenpac.net.nr", "ns2.cenpac.net.nr"}, n, n, n, e, e, f},
	{"com.nr", &z[1020], x, 0, e, w{"ns0.cenpac.net.nr", "ns1.cenpac.net.nr", "ns2.cenpac.net.nr", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"edu.nr", &z[1020], x, 0, e, w{"ns0.cenpac.net.nr", "ns1.cenpac.net.nr", "ns2.cenpac.net.nr"}, n, n, n, e, e, f},
	{"gov.nr", &z[1020], x, 0, e, w{"ns0.cenpac.net.nr", "ns1.cenpac.net.nr", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"info.nr", &z[1020], x, 0, e, w{"ns0.cenpac.net.nr", "ns1.cenpac.net.nr", "ns2.cenpac.net.nr"}, n, n, n, e, e, f},
	{"net.nr", &z[1020], x, 0, e, w{"ns0.cenpac.net.nr", "ns1.cenpac.net.nr", "ns2.cenpac.net.nr", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"org.nr", &z[1020], x, 0, e, w{"ns0.cenpac.net.nr", "ns1.cenpac.net.nr", "ns2.cenpac.net.nr", "phloem.uoregon.edu"}, n, n, n, e, e, f},
	{"co.nu", &z[1024], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "co.nu"}, n, n, e, e, t},
	{"com.nu", &z[1024], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "com.nu"}, n, n, e, e, t},
	{"eu.nu", &z[1024], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "eu.nu"}, n, n, e, e, t},
	{"ie.nu", &z[1024], x, 0, e, w{"brain.bb-online.co.uk", "ns1.bb-online.net", "ns2.bb-online.net", "ns5.bb-online.net"}, n, n, n, e, e, t},
	{"info.nu", &z[1024], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "info.nu"}, n, n, e, e, t},
	{"ac.nz", &z[1026], x, 0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, e, e, f},
	{"co.nz", &z[1026], x, 0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, e, e, f},
	{"cri.nz", &z[1026], x, 0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, e, e, f},
	{"geek.nz", &z[1026], x, 0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, e, e, f},
	{"gen.nz", &z[1026], x, 0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, e, e, f},
	{"govt.nz", &z[1026], x, 0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, e, e, f},
	{"health.nz", &z[1026], x, 0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, e, e, t},
	{"iwi.nz", &z[1026], x, 0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, e, e, f},
	{"kiwi.nz", &z[1026], x, 0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, e, e, f},
	{"maori.nz", &z[1026], x, 0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, e, e, f},
	{"mil.nz", &z[1026], x, 0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, e, e, f},
	{"net.nz", &z[1026], z[5101:5102], 0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, e, e, f},
	{"org.nz", &z[1026], x, 0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, e, e, f},
	{"parliament.nz", &z[1026], x, 0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, e, e, f},
	{"school.nz", &z[1026], x, 0, e, w{"ns1.dns.net.nz", "ns2.dns.net.nz", "ns3.dns.net.nz", "ns4.dns.net.nz", "ns5.dns.net.nz", "ns6.dns.net.nz", "ns7.dns.net.nz"}, n, n, n, e, e, f},
	{"ac.om", &z[1037], x, 0, e, n, n, n, n, e, e, f},
	{"biz.om", &z[1037], x, 0, e, n, n, n, n, e, e, f},
	{"co.om", &z[1037], x, 0, e, w{"cctld.alpha.aridns.net.au", "cctld.beta.aridns.net.au", "cctld.delta.aridns.net.au", "cctld.gamma.aridns.net.au", "ns1.registry.om", "ns2.registry.om"}, n, n, n, e, e, f},
	{"com.om", &z[1037], x, 0, e, w{"cctld.alpha.aridns.net.au", "cctld.beta.aridns.net.au", "cctld.delta.aridns.net.au", "cctld.gamma.aridns.net.au", "ns1.registry.om", "ns2.registry.om"}, n, n, n, e, e, f},
	{"edu.om", &z[1037], x, 0, e, w{"cctld.alpha.aridns.net.au", "cctld.beta.aridns.net.au", "cctld.delta.aridns.net.au", "cctld.gamma.aridns.net.au", "ns1.registry.om", "ns2.registry.om"}, n, n, n, e, e, f},
	{"gov.om", &z[1037], x, 0, e, w{"cctld.alpha.aridns.net.au", "cctld.beta.aridns.net.au", "cctld.delta.aridns.net.au", "cctld.gamma.aridns.net.au", "ns1.registry.om", "ns2.registry.om"}, n, n, n, e, e, f},
	{"med.om", &z[1037], x, 0, e, w{"cctld.alpha.aridns.net.au", "cctld.beta.aridns.net.au", "cctld.delta.aridns.net.au", "cctld.gamma.aridns.net.au", "ns1.registry.om", "ns2.registry.om"}, n, n, n, e, e, f},
	{"mil.om", &z[1037], x, 0, e, w{"cctld.alpha.aridns.net.au", "cctld.beta.aridns.net.au", "cctld.delta.aridns.net.au", "cctld.gamma.aridns.net.au", "ns1.registry.om", "ns2.registry.om"}, n, n, n, e, e, f},
	{"museum.om", &z[1037], x, 0, e, w{"cctld.alpha.aridns.net.au", "cctld.beta.aridns.net.au", "cctld.delta.aridns.net.au", "cctld.gamma.aridns.net.au", "ns1.registry.om", "ns2.registry.om"}, n, n, n, e, e, f},
	{"net.om", &z[1037], x, 0, e, w{"cctld.alpha.aridns.net.au", "cctld.beta.aridns.net.au", "cctld.delta.aridns.net.au", "cctld.gamma.aridns.net.au", "ns1.registry.om", "ns2.registry.om"}, n, n, n, e, e, f},
	{"org.om", &z[1037], x, 0, e, w{"cctld.alpha.aridns.net.au", "cctld.beta.aridns.net.au", "cctld.delta.aridns.net.au", "cctld.gamma.aridns.net.au", "ns1.registry.om", "ns2.registry.om"}, n, n, n, e, e, f},
	{"pro.om", &z[1037], x, 0, e, w{"cctld.alpha.aridns.net.au", "cctld.beta.aridns.net.au", "cctld.delta.aridns.net.au", "cctld.gamma.aridns.net.au", "ns1.registry.om", "ns2.registry.om"}, n, n, n, e, e, f},
	{"sch.om", &z[1037], x, 0, e, n, n, n, n, e, e, f},
	{"ae.org", &z[1048], x, 0, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"54.153.56.183", "ae.org"}, n, n, "whois.centralnic.com", e, t},
	{"eu.org", &z[1048], z[5102:5154], 0, e, w{"auth1.dns.elm.net", "dns4.gandi.net", "gra.wolfhugel.eu", "hobbes.bsd-dk.dk", "ns.bortzmeyer.eu.org", "ns1.eriomem.net", "ns1.eu.org", "ns3.keltia.net", "wombat.billaud.eu.org"}, n, n, n, "whois.eu.org", e, t},
	{"hk.org", &z[1048], x, 0, e, w{"a.udrtld.net", "b.udrtld.net", "c.udrtld.net", "dns7.cloudns.net", "dns8.cloudns.net"}, n, n, n, "whois.registry.hk.com", e, f},
	{"js.org", &z[1048], x, 0, e, w{"miles.ns.cloudflare.com", "pam.ns.cloudflare.com"}, w{"89.41.169.49"}, n, n, e, e, t},
	{"us.org", &z[1048], x, 0, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, w{"54.153.56.183", "us.org"}, n, n, "whois.centralnic.com", e, f},
	{"za.org", &z[1048], x, 0, e, w{"igubu.saix.net", "ns0.is.co.za", "ns0.plig.net", "ns1.plig.net", "ns2.plig.net", "ns3.iafrica.com", "ns4.iafrica.com"}, n, n, n, "whois.za.org", e, t},
	{"abo.pa", &z[1058], x, 0, e, w{"dns-ext.nic.cr", "ns.dns.br", "ns.nic.pa", "ns.pa", "ns2.pa", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"ac.pa", &z[1058], x, 0, e, w{"dns-ext.nic.cr", "ns.dns.br", "ns.nic.pa", "ns.pa", "ns2.pa", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"com.pa", &z[1058], x, 0, e, w{"dns-ext.nic.cr", "ns.dns.br", "ns.nic.pa", "ns.pa", "ns2.pa", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"edu.pa", &z[1058], x, 0, e, w{"dns-ext.nic.cr", "ns.dns.br", "ns.nic.pa", "ns.pa", "ns2.pa", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"gob.pa", &z[1058], x, 0, e, w{"dns-ext.nic.cr", "ns.dns.br", "ns.nic.pa", "ns.pa", "ns2.pa", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"ing.pa", &z[1058], x, 0, e, w{"dns-ext.nic.cr", "ns.dns.br", "ns.nic.pa", "ns.pa", "ns2.pa", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"med.pa", &z[1058], x, 0, e, w{"dns-ext.nic.cr", "ns.dns.br", "ns.nic.pa", "ns.pa", "ns2.pa", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"net.pa", &z[1058], x, 0, e, w{"dns-ext.nic.cr", "ns.dns.br", "ns.nic.pa", "ns.pa", "ns2.pa", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"nom.pa", &z[1058], x, 0, e, w{"dns-ext.nic.cr", "ns.dns.br", "ns.nic.pa", "ns.pa", "ns2.pa", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"org.pa", &z[1058], x, 0, e, w{"dns-ext.nic.cr", "ns.dns.br", "ns.nic.pa", "ns.pa", "ns2.pa", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"sld.pa", &z[1058], x, 0, e, w{"dns-ext.nic.cr", "ns.dns.br", "ns.nic.pa", "ns.pa", "ns2.pa", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"com.pe", &z[1074], x, 0, e, w{"a.lactld.org", "pch.rcp.pe", "pe1.dnsnode.net", "quipu.rcp.net.pe"}, n, n, n, e, e, f},
	{"edu.pe", &z[1074], x, 0, e, w{"a.lactld.org", "pch.rcp.pe", "pe1.dnsnode.net", "quipu.rcp.net.pe"}, n, n, n, e, e, f},
	{"gob.pe", &z[1074], x, 0, e, w{"a.lactld.org", "pch.rcp.pe", "pe1.dnsnode.net", "quipu.rcp.net.pe"}, n, n, n, e, e, f},
	{"gov.pe", &z[1074], x, 0, e, n, n, n, n, e, e, t},
	{"mil.pe", &z[1074], x, 0, e, w{"a.lactld.org", "pch.rcp.pe", "pe1.dnsnode.net", "quipu.rcp.net.pe"}, n, n, n, e, e, f},
	{"net.pe", &z[1074], x, 0, e, w{"a.lactld.org", "pch.rcp.pe", "pe1.dnsnode.net", "quipu.rcp.net.pe"}, n, n, n, e, e, f},
	{"nom.pe", &z[1074], x, 0, e, w{"a.lactld.org", "pch.rcp.pe", "pe1.dnsnode.net", "quipu.rcp.net.pe"}, n, n, n, e, e, f},
	{"org.pe", &z[1074], x, 0, e, w{"a.lactld.org", "pch.rcp.pe", "pe1.dnsnode.net", "quipu.rcp.net.pe"}, n, n, n, e, e, f},
	{"sld.pe", &z[1074], x, 0, e, w{"a.lactld.org", "pch.rcp.pe", "pe1.dnsnode.net", "quipu.rcp.net.pe"}, n, n, n, e, e, t},
	{"asso.pf", &z[1078], x, 0, e, n, n, n, n, e, e, f},
	{"com.pf", &z[1078], x, 0, e, n, n, n, n, e, e, f},
	{"edu.pf", &z[1078], x, 0, e, n, n, n, n, e, e, f},
	{"gov.pf", &z[1078], x, 0, e, w{"ns1.gov.pf", "ns1.mana.pf", "ns2.gov.pf", "ns2.mana.pf", "reverse.gov.pf"}, n, n, n, e, e, f},
	{"org.pf", &z[1078], x, 0, e, n, n, n, n, e, e, f},
	{"ac.pg", &z[1080], x, 0, e, n, n, n, n, e, e, f},
	{"com.pg", &z[1080], x, 0, e, n, n, n, n, e, e, f},
	{"gov.pg", &z[1080], x, 0, e, n, n, n, n, e, e, f},
	{"mil.pg", &z[1080], x, 0, e, n, n, n, n, e, e, f},
	{"net.pg", &z[1080], x, 0, e, n, n, n, n, e, e, f},
	{"org.pg", &z[1080], x, 0, e, n, n, n, n, e, e, f},
	{"com.ph", &z[1081], x, 0, e, n, w{"45.79.222.138"}, n, n, e, e, f},
	{"edi.ph", &z[1081], x, 0, e, w{"ns1.dp47.parklogic.com", "ns2.dp47.parklogic.com", "ns3.dp47.parklogic.com", "ns4.dp47.parklogic.com", "ns5.dp47.parklogic.com"}, w{"2600:3c02:1::2d4f:f40e", "72.52.179.175", "edi.ph"}, n, n, e, e, t},
	{"edu.ph", &z[1081], x, 0, e, w{"evans.gov.ph", "gabriela.ph.net", "gomez.ph.net", "ph.wegen-energy.com"}, n, n, n, e, e, f},
	{"gov.ph", &z[1081], x, 0, e, w{"gabriela.ph.net", "gomez.ph.net", "ns1.gov.ph", "ns2.gov.ph"}, n, n, n, e, e, f},
	{"i.ph", &z[1081], x, 0, e, w{"nsi1.domains.ph", "nsi2.domains.ph"}, n, n, n, e, e, f},
	{"mil.ph", &z[1081], x, 0, e, n, w{"45.79.222.138"}, n, n, e, e, f},
	{"net.ph", &z[1081], x, 0, e, n, w{"45.79.222.138"}, n, n, e, e, f},
	{"ngo.ph", &z[1081], x, 0, e, n, w{"45.79.222.138"}, n, n, e, e, f},
	{"org.ph", &z[1081], x, 0, e, n, w{"45.79.222.138"}, n, n, e, e, f},
	{"biz.pk", &z[1102], x, 0, e, n, n, n, n, e, e, f},
	{"com.pk", &z[1102], x, 0, e, n, n, n, n, e, e, f},
	{"edu.pk", &z[1102], x, 0, e, n, n, n, n, e, e, t},
	{"fam.pk", &z[1102], x, 0, e, n, n, n, n, e, e, f},
	{"gkp.pk", &z[1102], x, 0, e, n, n, n, n, e, e, t},
	{"gob.pk", &z[1102], x, 0, e, n, n, n, n, e, e, f},
	{"gog.pk", &z[1102], x, 0, e, n, n, n, n, e, e, t},
	{"gok.pk", &z[1102], x, 0, e, n, n, n, n, e, e, f},
	{"gon.pk", &z[1102], x, 0, e, n, n, n, n, e, e, f},
	{"gop.pk", &z[1102], x, 0, e, n, n, n, n, e, e, f},
	{"gos.pk", &z[1102], x, 0, e, n, n, n, n, e, e, f},
	{"gov.pk", &z[1102], x, 0, e, n, n, n, n, e, e, f},
	{"net.pk", &z[1102], x, 0, e, n, n, n, n, e, e, f},
	{"org.pk", &z[1102], x, 0, e, n, n, n, n, e, e, f},
	{"web.pk", &z[1102], x, 0, e, n, n, n, n, e, e, f},
	{"agro.pl", &z[1103], x, 0, "https://domain.by/", w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"aid.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"art.pl", &z[1103], x, 0, e, w{"bilbo.nask.org.pl", "hermes.sgh.waw.pl", "ns.tpnet.pl", "ns1.agh.edu.pl", "ns1.net.icm.edu.pl", "ns2.net.icm.edu.pl"}, n, n, n, e, e, f},
	{"atm.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"augustow.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"auto.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"babia-gora.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"bedzin.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"beskidy.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"bialowieza.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, t},
	{"bialystok.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"bielawa.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"bieszczady.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"biz.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"boleslawiec.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"bydgoszcz.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"bytom.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"ciesyn.pl", &z[1103], x, 0, e, n, n, n, n, e, e, t},
	{"cieszyn.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"co.pl", &z[1103], x, 0, e, w{"ns1.co.pl", "ns2.co.pl"}, n, n, n, "whois.co.pl", e, t},
	{"com.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"czeladz.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"czest.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"dlugoleka.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"edu.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"elblag.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"elk.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"gda.pl", &z[1103], x, 0, e, w{"bilbo.nask.org.pl", "ns.tpnet.pl", "ns1.task.gda.pl", "ns2.task.gda.pl"}, n, n, n, e, e, f},
	{"gdansk.pl", &z[1103], x, 0, e, w{"bilbo.nask.org.pl", "ns.tpnet.pl", "ns1.task.gda.pl", "ns2.task.gda.pl"}, n, n, n, e, e, f},
	{"glogow.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"gmina.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"gniezno.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"gniezon.pl", &z[1103], x, 0, e, n, n, n, n, e, e, t},
	{"gorlice.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"gov.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"grajewo.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"gsm.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"ilawa.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"info.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"jaworzno.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"jaworzono.pl", &z[1103], x, 0, e, n, n, n, n, e, e, t},
	{"jelenia-gora.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"jgora.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"kalisz.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"karpacz.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"kartuzy.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"kaszuby.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"katowice.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"kazimierz-dolny.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"kepno.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"ketrzyn.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"klodzko.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"kobierzyce.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"kolobrzeg.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"konin.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"konskowola.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"krakow.pl", &z[1103], x, 0, e, w{"bilbo.nask.org.pl", "dns.fuw.edu.pl", "info.cyf-kr.edu.pl", "nms.cyf-kr.edu.pl"}, n, n, n, e, e, f},
	{"ksazuby.pl", &z[1103], x, 0, e, n, n, n, n, e, e, t},
	{"kutno.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"lapy.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"lebork.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"legnica.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"lezajsk.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"limanowa.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"lodz.pl", &z[1103], x, 0, e, w{"dns.man.lodz.pl", "dns2.man.lodz.pl", "dns4.man.lodz.pl", "ns1.tpnet.pl"}, n, n, n, e, e, f},
	{"lomza.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"lowicz.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"lubin.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"lublin.pl", &z[1103], x, 0, e, w{"bilbo.nask.org.pl", "ns1.lublin.pl", "ns2.lublin.pl"}, n, n, n, e, e, f},
	{"lukow.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"mail.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"malbork.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"malopolska.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"mazowsze.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"mazury.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"media.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"miasta.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"mielec.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"mielno.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"mil.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"mragowo.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"naklo.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"net.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"ngo.pl", &z[1103], x, 0, e, w{"ns1.ngo.pl", "ns2.ngo.pl"}, n, n, n, e, e, f},
	{"nieruchomosci.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"nom.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"nowaruda.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"nysa.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"olawa.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"olecko.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"olkusz.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"olsztyn.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"opoczno.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"opole.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"org.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"ostroda.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"ostroleka.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"ostrowiec.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"ostrowwlkp.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"pc.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"pila.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"pisz.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"podhale.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"podlasie.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"polkowice.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"pomorskie.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"pomorze.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"powiat.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"poznan.pl", &z[1103], x, 0, e, w{"bilbo.nask.org.pl", "dns.amu.edu.pl", "dns3.amu.edu.pl", "kirdan.nask.net.pl"}, n, n, n, e, e, f},
	{"priv.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"prochowice.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"pruszkow.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"przeworsk.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"pulawy.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"radom.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"rawa-maz.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"realestate.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"rel.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"rybnik.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"rzeszow.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"sanok.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"sejny.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"sex.pl", &z[1103], x, 0x1, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"shop.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"sklep.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"skoczow.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"slask.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"slupsk.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"sos.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"sosnowiec.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"stalowa-wola.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"starachowice.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"stargard.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"suwalki.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"swidnica.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"swiebodzin.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"swinoujscie.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"szczecin.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"szczytno.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"szkola.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"targi.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"tarnobrzeg.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"tgory.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"tm.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"torun.pl", &z[1103], x, 0, e, w{"bilbo.nask.org.pl", "blackbox.uci.uni.torun.pl", "flis.man.torun.pl", "koala.uci.uni.torun.pl"}, n, n, n, e, e, f},
	{"tourism.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"travel.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"turek.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"turystyka.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "d-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"tychy.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"ustka.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"walbrzych.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"warmia.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"warszawa.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"waw.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"wegrow.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"wielun.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"wlocl.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"wloclawek.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"wodzislaw.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"wolomin.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"wroc.pl", &z[1103], x, 0, e, w{"bilbo.nask.org.pl", "kirdan.nask.net.pl", "ldhpux.immt.pwr.wroc.pl", "ns1.net.icm.edu.pl", "sun2.pwr.wroc.pl", "wask.wask.wroc.pl"}, n, n, n, e, e, f},
	{"wroclaw.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"zachpomor.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"zagan.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"zarow.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"zgora.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"zgorzelec.pl", &z[1103], x, 0, e, w{"a-dns.pl", "b-dns.pl", "c-dns.pl", "e-dns.pl", "f-dns.pl", "g-dns.pl", "h-dns.pl", "i-dns.pl"}, n, n, n, e, e, f},
	{"at.pn", &z[1110], z[5154:5155], 0, e, n, n, n, n, e, e, f},
	{"au.pn", &z[1110], z[5155:5156], 0, e, n, n, n, n, e, e, f},
	{"ca.pn", &z[1110], x, 0, e, n, n, n, n, e, e, f},
	{"ch.pn", &z[1110], x, 0, e, n, n, n, n, e, e, f},
	{"cn.pn", &z[1110], x, 0, e, n, n, n, n, e, e, f},
	{"co.pn", &z[1110], x, 0, e, w{"dns1.nominetdns.uk", "dns4.nominetdns.uk", "ns0.pitcairn.net.pn", "ns1.pitcairn.net.pn"}, n, n, n, e, e, f},
	{"de.pn", &z[1110], x, 0, e, n, n, n, n, e, e, f},
	{"edu.pn", &z[1110], x, 0, e, w{"dns1.nominetdns.uk", "dns4.nominetdns.uk", "ns0.pitcairn.net.pn", "ns1.pitcairn.net.pn"}, n, n, n, e, e, f},
	{"es.pn", &z[1110], x, 0, e, w{"ns-1377.awsdns-44.org", "ns-1574.awsdns-04.co.uk", "ns-29.awsdns-03.com", "ns-723.awsdns-26.net"}, n, n, n, e, e, f},
	{"eu.pn", &z[1110], x, 0x800, e, n, n, n, n, e, e, f},
	{"fr.pn", &z[1110], x, 0x800, e, n, n, n, n, e, e, f},
	{"gov.pn", &z[1110], x, 0, e, w{"dns1.nominetdns.uk", "dns4.nominetdns.uk", "ns0.pitcairn.net.pn", "ns1.pitcairn.net.pn"}, n, n, n, e, e, f},
	{"in.pn", &z[1110], x, 0, e, w{"ns-1425.awsdns-50.org", "ns-1677.awsdns-17.co.uk", "ns-441.awsdns-55.com", "ns-906.awsdns-49.net"}, n, n, n, e, e, t},
	{"it.pn", &z[1110], x, 0, e, w{"ns1.speedydns.net", "ns2.speedydns.net"}, n, n, n, e, e, f},
	{"jp.pn", &z[1110], x, 0x800, e, n, n, n, n, e, e, f},
	{"net.pn", &z[1110], x, 0, e, w{"dns1.nominetdns.uk", "dns4.nominetdns.uk", "ns0.pitcairn.net.pn", "ns1.pitcairn.net.pn"}, n, n, n, e, e, f},
	{"org.pn", &z[1110], x, 0, e, w{"dns1.nominetdns.uk", "dns4.nominetdns.uk", "ns0.pitcairn.net.pn", "ns1.pitcairn.net.pn"}, n, n, n, e, e, f},
	{"uk.pn", &z[1110], z[5156:5157], 0x800, e, n, n, n, n, e, e, f},
	{"us.pn", &z[1110], x, 0, e, n, n, n, n, e, e, f},
	{"ac.pr", &z[1118], x, 0, e, w{"a0.pr.afilias-nst.info", "a2.pr.afilias-nst.info", "b0.pr.afilias-nst.org", "b2.pr.afilias-nst.org", "c0.pr.afilias-nst.info", "d0.pr.afilias-nst.org"}, n, n, n, e, e, f},
	{"ag.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"ai.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"alumni.pr", &z[1118], x, 0, e, w{"descartes.nic.pr", "golomb.nic.pr", "pascal.nic.pr", "pr-dns.denic.de", "pr-ns.anycast.pch.net"}, n, n, n, e, e, t},
	{"at.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"au.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"aw.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"bb.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"biz.pr", &z[1118], x, 0, e, w{"a0.pr.afilias-nst.info", "a2.pr.afilias-nst.info", "b0.pr.afilias-nst.org", "b2.pr.afilias-nst.org", "c0.pr.afilias-nst.info", "d0.pr.afilias-nst.org"}, n, n, n, e, e, f},
	{"bm.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"br.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"bs.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"ch.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"cl.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"cn.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"com.pr", &z[1118], x, 0, e, w{"a0.pr.afilias-nst.info", "a2.pr.afilias-nst.info", "b0.pr.afilias-nst.org", "b2.pr.afilias-nst.org", "c0.pr.afilias-nst.info", "d0.pr.afilias-nst.org"}, n, n, n, e, e, f},
	{"de.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"dm.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"do.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"edu.pr", &z[1118], x, 0, e, w{"a0.pr.afilias-nst.info", "a2.pr.afilias-nst.info", "b0.pr.afilias-nst.org", "b2.pr.afilias-nst.org", "c0.pr.afilias-nst.info", "d0.pr.afilias-nst.org"}, n, n, n, e, e, f},
	{"en.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"es.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"est.pr", &z[1118], x, 0, e, w{"a0.pr.afilias-nst.info", "a2.pr.afilias-nst.info", "b0.pr.afilias-nst.org", "b2.pr.afilias-nst.org", "c0.pr.afilias-nst.info", "d0.pr.afilias-nst.org"}, n, n, n, e, e, f},
	{"eu.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"exalumnos.pr", &z[1118], x, 0, e, w{"descartes.nic.pr", "golomb.nic.pr", "pascal.nic.pr", "pr-dns.denic.de", "pr-ns.anycast.pch.net"}, n, n, n, e, e, t},
	{"fr.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"gd.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"gov.pr", &z[1118], x, 0, e, w{"a0.pr.afilias-nst.info", "a2.pr.afilias-nst.info", "b0.pr.afilias-nst.org", "b2.pr.afilias-nst.org", "c0.pr.afilias-nst.info", "d0.pr.afilias-nst.org"}, n, n, n, e, e, f},
	{"gp.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"ht.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"info.pr", &z[1118], x, 0, e, w{"a0.pr.afilias-nst.info", "a2.pr.afilias-nst.info", "b0.pr.afilias-nst.org", "b2.pr.afilias-nst.org", "c0.pr.afilias-nst.info", "d0.pr.afilias-nst.org"}, n, n, n, e, e, f},
	{"isla.pr", &z[1118], x, 0, e, w{"a0.pr.afilias-nst.info", "a2.pr.afilias-nst.info", "b0.pr.afilias-nst.org", "b2.pr.afilias-nst.org", "c0.pr.afilias-nst.info", "d0.pr.afilias-nst.org"}, n, n, n, e, e, f},
	{"it.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"jm.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"jp.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"ky.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"lc.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"ms.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"mx.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"name.pr", &z[1118], x, 0, e, w{"a0.pr.afilias-nst.info", "a2.pr.afilias-nst.info", "b0.pr.afilias-nst.org", "b2.pr.afilias-nst.org", "c0.pr.afilias-nst.info", "d0.pr.afilias-nst.org"}, n, n, n, e, e, f},
	{"net.pr", &z[1118], x, 0, e, w{"a0.pr.afilias-nst.info", "a2.pr.afilias-nst.info", "b0.pr.afilias-nst.org", "b2.pr.afilias-nst.org", "c0.pr.afilias-nst.info", "d0.pr.afilias-nst.org"}, n, n, n, e, e, f},
	{"nl.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"nom.pr", &z[1118], x, 0, e, n, n, n, n, e, e, f},
	{"org.pr", &z[1118], x, 0, e, w{"a0.pr.afilias-nst.info", "a2.pr.afilias-nst.info", "b0.pr.afilias-nst.org", "b2.pr.afilias-nst.org", "c0.pr.afilias-nst.info", "d0.pr.afilias-nst.org"}, n, n, n, e, e, f},
	{"pro.pr", &z[1118], x, 0, e, w{"a0.pr.afilias-nst.info", "a2.pr.afilias-nst.info", "b0.pr.afilias-nst.org", "b2.pr.afilias-nst.org", "c0.pr.afilias-nst.info", "d0.pr.afilias-nst.org"}, n, n, n, e, e, f},
	{"prof.pr", &z[1118], x, 0, e, w{"a0.pr.afilias-nst.info", "a2.pr.afilias-nst.info", "b0.pr.afilias-nst.org", "b2.pr.afilias-nst.org", "c0.pr.afilias-nst.info", "d0.pr.afilias-nst.org"}, n, n, n, e, e, f},
	{"tc.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"tt.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"uk.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"us.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"vg.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"vi.pr", &z[1118], x, 0x800, e, n, n, n, n, e, e, f},
	{"aaa.pro", &z[1123], x, 0, e, w{"a0.pro.afilias-nst.info", "a2.pro.afilias-nst.info", "b0.pro.afilias-nst.org", "b2.pro.afilias-nst.org", "c0.pro.afilias-nst.info", "d0.pro.afilias-nst.org"}, n, n, n, e, e, f},
	{"aca.pro", &z[1123], x, 0, e, w{"a0.pro.afilias-nst.info", "a2.pro.afilias-nst.info", "b0.pro.afilias-nst.org", "b2.pro.afilias-nst.org", "c0.pro.afilias-nst.info", "d0.pro.afilias-nst.org"}, n, n, n, e, e, f},
	{"acct.pro", &z[1123], x, 0, e, w{"a0.pro.afilias-nst.info", "a2.pro.afilias-nst.info", "b0.pro.afilias-nst.org", "b2.pro.afilias-nst.org", "c0.pro.afilias-nst.info", "d0.pro.afilias-nst.org"}, n, n, n, e, e, f},
	{"arc.pro", &z[1123], x, 0, e, n, n, n, n, e, e, f},
	{"avocat.pro", &z[1123], x, 0, e, w{"a0.pro.afilias-nst.info", "a2.pro.afilias-nst.info", "b0.pro.afilias-nst.org", "b2.pro.afilias-nst.org", "c0.pro.afilias-nst.info", "d0.pro.afilias-nst.org"}, n, n, n, e, e, f},
	{"bar.pro", &z[1123], x, 0, e, w{"a0.pro.afilias-nst.info", "a2.pro.afilias-nst.info", "b0.pro.afilias-nst.org", "b2.pro.afilias-nst.org", "c0.pro.afilias-nst.info", "d0.pro.afilias-nst.org"}, n, n, n, e, e, f},
	{"bus.pro", &z[1123], x, 0, e, n, n, n, n, e, e, f},
	{"cfp.pro", &z[1123], x, 0, e, n, n, n, n, e, e, t},
	{"chi.pro", &z[1123], x, 0, e, n, n, n, n, e, e, f},
	{"chiro.pro", &z[1123], x, 0, e, w{"dns111.ovh.net", "ns111.ovh.net"}, n, n, n, e, e, f},
	{"cpa.pro", &z[1123], x, 0, e, w{"a0.pro.afilias-nst.info", "a2.pro.afilias-nst.info", "b0.pro.afilias-nst.org", "b2.pro.afilias-nst.org", "c0.pro.afilias-nst.info", "d0.pro.afilias-nst.org"}, n, n, n, e, e, f},
	{"dds.pro", &z[1123], x, 0, e, n, n, n, n, e, e, t},
	{"den.pro", &z[1123], x, 0, e, n, n, n, n, e, e, f},
	{"dent.pro", &z[1123], x, 0, e, n, n, n, n, e, e, f},
	{"ed.pro", &z[1123], x, 0, e, n, n, n, n, e, e, t},
	{"eng.pro", &z[1123], x, 0, e, w{"a0.pro.afilias-nst.info", "a2.pro.afilias-nst.info", "b0.pro.afilias-nst.org", "b2.pro.afilias-nst.org", "c0.pro.afilias-nst.info", "d0.pro.afilias-nst.org"}, n, n, n, e, e, f},
	{"jur.pro", &z[1123], x, 0, e, w{"a0.pro.afilias-nst.info", "a2.pro.afilias-nst.info", "b0.pro.afilias-nst.org", "b2.pro.afilias-nst.org", "c0.pro.afilias-nst.info", "d0.pro.afilias-nst.org"}, n, n, n, e, e, f},
	{"law.pro", &z[1123], x, 0, e, w{"a0.pro.afilias-nst.info", "a2.pro.afilias-nst.info", "b0.pro.afilias-nst.org", "b2.pro.afilias-nst.org", "c0.pro.afilias-nst.info", "d0.pro.afilias-nst.org"}, n, n, n, e, e, f},
	{"med.pro", &z[1123], x, 0, e, w{"a0.pro.afilias-nst.info", "a2.pro.afilias-nst.info", "b0.pro.afilias-nst.org", "b2.pro.afilias-nst.org", "c0.pro.afilias-nst.info", "d0.pro.afilias-nst.org"}, n, n, n, e, e, f},
	{"min.pro", &z[1123], x, 0, e, n, n, n, n, e, e, f},
	{"nitr.pro", &z[1123], x, 0, e, n, n, n, n, e, e, t},
	{"nur.pro", &z[1123], x, 0, e, n, n, n, n, e, e, f},
	{"nurse.pro", &z[1123], x, 0, e, w{"park1.encirca.net", "park2.encirca.net"}, w{"3.209.180.95"}, n, n, e, e, f},
	{"opt.pro", &z[1123], x, 0, e, n, n, n, n, e, e, t},
	{"pa.pro", &z[1123], x, 0, e, n, n, n, n, e, e, t},
	{"pha.pro", &z[1123], x, 0, e, n, n, n, n, e, e, t},
	{"pharma.pro", &z[1123], x, 0, e, w{"ns1.sedoparking.com", "ns2.sedoparking.com"}, w{"64.190.62.111"}, n, n, e, e, f},
	{"pod.pro", &z[1123], x, 0, e, n, n, n, n, e, e, t},
	{"pr.pro", &z[1123], x, 0, e, n, n, n, n, e, e, t},
	{"prof.pro", &z[1123], x, 0, e, w{"dns1.encirca.net", "dns2.encirca.net"}, n, n, n, e, e, f},
	{"prx.pro", &z[1123], x, 0, e, n, n, n, n, e, e, f},
	{"pt.pro", &z[1123], x, 0, e, n, n, n, n, e, e, t},
	{"recht.pro", &z[1123], x, 0, e, w{"a0.pro.afilias-nst.info", "a2.pro.afilias-nst.info", "b0.pro.afilias-nst.org", "b2.pro.afilias-nst.org", "c0.pro.afilias-nst.info", "d0.pro.afilias-nst.org"}, n, n, n, e, e, f},
	{"rel.pro", &z[1123], x, 0, e, n, n, n, n, e, e, f},
	{"teach.pro", &z[1123], x, 0, e, w{"curitiba.porkbun.com", "fortaleza.porkbun.com", "maceio.porkbun.com", "salvador.porkbun.com"}, w{"44.230.85.241", "uixie.porkbun.com"}, n, n, e, e, f},
	{"vet.pro", &z[1123], x, 0, e, n, n, n, n, e, e, f},
	{"com.ps", &z[1134], x, 0, "https://www.pnina.ps/registration-policy/", w{"ns1.pnina.ps", "ns2.pnina.ps", "ote.pnina.ps", "ps-ns.anycast.pch.net", "ps.cctld.authdns.ripe.net", "rip.psg.com"}, n, n, n, e, e, f},
	{"edu.ps", &z[1134], x, 0, "https://www.tonic.to/", w{"dns1.gov.ps", "dns3.gov.ps", "dns4.pna.ps", "ns1.gov.ps", "ns1.pnina.ps", "ns2.pnina.ps", "ote.pnina.ps"}, n, n, n, e, e, f},
	{"gov.ps", &z[1134], x, 0, e, w{"dns1.gov.ps", "ns1.gov.ps", "ns1.palgov.net"}, n, n, n, e, e, f},
	{"mobi.ps", &z[1134], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "mobi.ps"}, n, n, e, e, t},
	{"mun.ps", &z[1134], x, 0, e, w{"dns1.gov.ps", "dns2.gov.ps", "ns1.gov.ps", "ns2.pnina.ps"}, n, n, n, e, e, f},
	{"net.ps", &z[1134], x, 0, e, w{"ns1.pnina.ps", "ns2.pnina.ps", "ote.pnina.ps", "ps-ns.anycast.pch.net", "ps.cctld.authdns.ripe.net", "rip.psg.com"}, n, n, n, e, e, f},
	{"org.ps", &z[1134], x, 0, e, w{"ns1.pnina.ps", "ns2.pnina.ps", "ote.pnina.ps", "ps-ns.anycast.pch.net", "ps.cctld.authdns.ripe.net", "rip.psg.com"}, n, n, n, e, e, f},
	{"plo.ps", &z[1134], x, 0, e, w{"dns3.gov.ps", "dns4.pna.ps"}, n, n, n, e, e, t},
	{"sch.ps", &z[1134], x, 0, e, w{"dns1.gov.ps", "dns3.gov.ps", "ns1.gov.ps", "ns1.pnina.ps", "ns2.pnina.ps"}, n, n, n, e, e, f},
	{"co.pt", &z[1135], x, 0, e, w{"ns61.plako.net", "ns62.plako.net"}, w{"195.22.20.163"}, n, n, e, e, t},
	{"com.pt", &z[1135], x, 0, e, n, n, n, n, e, e, t},
	{"edu.pt", &z[1135], x, 0, e, n, n, n, n, e, e, f},
	{"gov.pt", &z[1135], x, 0, e, w{"a.dns.pt", "dns1.gov.pt", "europe1.dnsnode.net", "ns02.fccn.pt", "nsp.dnsnode.net"}, n, n, n, e, e, f},
	{"int.pt", &z[1135], x, 0, e, n, n, n, n, e, e, f},
	{"net.pt", &z[1135], x, 0, e, n, n, n, n, e, e, f},
	{"nome.pt", &z[1135], x, 0, e, n, n, n, n, e, e, f},
	{"org.pt", &z[1135], x, 0, e, n, n, n, n, e, e, f},
	{"publ.pt", &z[1135], x, 0, e, n, n, n, n, e, e, f},
	{"belau.pw", &z[1137], x, 0, e, w{"ns1390.ztomy.com", "ns2390.ztomy.com"}, w{"141.8.226.59"}, n, n, e, e, f},
	{"co.pw", &z[1137], x, 0, e, w{"ns1390.ztomy.com", "ns2390.ztomy.com"}, n, n, n, e, e, t},
	{"com.pw", &z[1137], x, 0, e, w{"ns13.xincache.com", "ns14.xincache.com"}, n, n, n, e, e, f},
	{"ed.pw", &z[1137], x, 0, e, w{"ns1390.ztomy.com", "ns2390.ztomy.com"}, w{"141.8.226.59"}, n, n, e, e, t},
	{"edu.pw", &z[1137], x, 0, e, w{"ns1390.ztomy.com", "ns2390.ztomy.com"}, w{"141.8.226.59"}, n, n, e, e, t},
	{"go.pw", &z[1137], x, 0, e, w{"ns1390.ztomy.com", "ns2390.ztomy.com"}, w{"141.8.226.59"}, n, n, e, e, t},
	{"gov.pw", &z[1137], x, 0, e, w{"ns1390.ztomy.com", "ns2390.ztomy.com"}, w{"141.8.226.59"}, n, n, e, e, f},
	{"ne.pw", &z[1137], x, 0, e, w{"a.dnspod.com", "b.dnspod.com", "c.dnspod.com"}, n, n, n, e, e, t},
	{"net.pw", &z[1137], x, 0, e, w{"ns1390.ztomy.com", "ns2390.ztomy.com"}, w{"141.8.226.59"}, n, n, e, e, f},
	{"or.pw", &z[1137], x, 0, e, w{"ns1390.ztomy.com", "ns2390.ztomy.com"}, n, n, n, e, e, t},
	{"org.pw", &z[1137], x, 0, e, w{"ns1390.ztomy.com", "ns2390.ztomy.com"}, w{"141.8.226.59"}, n, n, e, e, f},
	{"com.py", &z[1139], x, 0, e, w{"b.dns.py", "c.dns.py", "l.dns.py", "p.dns.py", "u.dns.py"}, n, n, n, e, e, f},
	{"coop.py", &z[1139], x, 0, e, w{"b.dns.py", "c.dns.py", "l.dns.py", "p.dns.py", "u.dns.py"}, n, n, n, e, e, f},
	{"edu.py", &z[1139], x, 0, e, w{"b.dns.py", "c.dns.py", "l.dns.py", "p.dns.py", "u.dns.py"}, n, n, n, e, e, f},
	{"gov.py", &z[1139], x, 0, e, w{"b.dns.py", "c.dns.py", "l.dns.py", "p.dns.py", "u.dns.py"}, n, n, n, e, e, f},
	{"mil.py", &z[1139], x, 0, e, w{"b.dns.py", "c.dns.py", "l.dns.py", "p.dns.py", "u.dns.py"}, n, n, n, e, e, f},
	{"net.py", &z[1139], x, 0, e, w{"b.dns.py", "c.dns.py", "l.dns.py", "p.dns.py", "u.dns.py"}, n, n, n, e, e, f},
	{"org.py", &z[1139], x, 0, e, w{"b.dns.py", "c.dns.py", "l.dns.py", "p.dns.py", "u.dns.py"}, n, n, n, e, e, f},
	{"una.py", &z[1139], x, 0, e, w{"b.dns.py", "c.dns.py", "p.dns.py", "u.dns.py"}, n, n, n, e, e, f},
	{"com.qa", &z[1140], x, 0, e, w{"a.registry.qa", "b.registry.qa", "c.registry.qa", "d.registry.qa", "e.registry.qa", "f.registry.qa", "g.registry.qa", "h.registry.qa", "i.registry.qa"}, n, n, n, e, e, f},
	{"edu.qa", &z[1140], x, 0, e, w{"a.registry.qa", "b.registry.qa", "c.registry.qa", "d.registry.qa", "e.registry.qa", "f.registry.qa", "g.registry.qa", "h.registry.qa", "i.registry.qa"}, n, n, n, e, e, t},
	{"gov.qa", &z[1140], x, 0, e, w{"a.registry.qa", "b.registry.qa", "c.registry.qa", "d.registry.qa", "e.registry.qa", "f.registry.qa", "g.registry.qa", "h.registry.qa", "i.registry.qa"}, n, n, n, e, e, t},
	{"mil.qa", &z[1140], x, 0, e, w{"a.registry.qa", "b.registry.qa", "c.registry.qa", "d.registry.qa", "e.registry.qa", "f.registry.qa", "g.registry.qa", "h.registry.qa", "i.registry.qa"}, n, n, n, e, e, t},
	{"name.qa", &z[1140], x, 0, e, w{"a.registry.qa", "b.registry.qa", "c.registry.qa", "d.registry.qa", "e.registry.qa", "f.registry.qa", "g.registry.qa", "h.registry.qa", "i.registry.qa"}, n, n, n, e, e, f},
	{"net.qa", &z[1140], x, 0, e, w{"a.registry.qa", "b.registry.qa", "c.registry.qa", "d.registry.qa", "e.registry.qa", "f.registry.qa", "g.registry.qa", "h.registry.qa", "i.registry.qa"}, n, n, n, e, e, f},
	{"org.qa", &z[1140], x, 0, e, w{"a.registry.qa", "b.registry.qa", "c.registry.qa", "d.registry.qa", "e.registry.qa", "f.registry.qa", "g.registry.qa", "h.registry.qa", "i.registry.qa"}, n, n, n, e, e, t},
	{"sch.qa", &z[1140], x, 0, e, w{"a.registry.qa", "b.registry.qa", "c.registry.qa", "d.registry.qa", "e.registry.qa", "f.registry.qa", "g.registry.qa", "h.registry.qa", "i.registry.qa"}, n, n, n, e, e, t},
	{"asso.re", &z[1150], x, 0, e, n, n, n, n, e, e, f},
	{"com.re", &z[1150], x, 0, e, n, n, n, n, e, e, f},
	{"nom.re", &z[1150], x, 0, e, n, n, n, n, e, e, f},
	{"arts.ro", &z[1185], x, 0, e, n, n, n, n, e, e, f},
	{"co.ro", &z[1185], x, 0, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, n, n, n, e, e, f},
	{"com.ro", &z[1185], x, 0, e, n, n, n, n, e, e, f},
	{"firm.ro", &z[1185], x, 0, e, n, n, n, n, e, e, f},
	{"info.ro", &z[1185], x, 0, e, n, n, n, n, e, e, f},
	{"ne.ro", &z[1185], x, 0, e, w{"ns1.eunoc.net", "ns2.eunoc.net", "ns3.eunoc.net"}, w{"185.27.255.9", "now.co.ro"}, n, n, e, e, f},
	{"nom.ro", &z[1185], x, 0, e, n, n, n, n, e, e, f},
	{"nt.ro", &z[1185], x, 0, e, n, n, n, n, e, e, f},
	{"or.ro", &z[1185], x, 0, e, w{"ns1.eunoc.net", "ns2.eunoc.net", "ns3.eunoc.net"}, w{"185.27.255.9", "now.co.ro"}, n, n, e, e, f},
	{"org.ro", &z[1185], x, 0, e, n, n, n, n, e, e, f},
	{"rec.ro", &z[1185], x, 0, e, n, n, n, n, e, e, f},
	{"ro.ro", &z[1185], x, 0, e, n, n, n, n, e, e, f},
	{"sa.ro", &z[1185], x, 0, e, w{"ns1.eunoc.net", "ns2.eunoc.net", "ns3.eunoc.net"}, w{"185.27.255.9", "now.co.ro"}, n, n, e, e, f},
	{"srl.ro", &z[1185], x, 0, e, w{"ns1.eunoc.net", "ns2.eunoc.net", "ns3.eunoc.net"}, w{"185.27.255.9", "now.co.ro"}, n, n, e, e, f},
	{"store.ro", &z[1185], x, 0, e, n, n, n, n, e, e, f},
	{"tm.ro", &z[1185], x, 0, e, n, n, n, n, e, e, f},
	{"www.ro", &z[1185], x, 0, e, n, n, n, n, e, e, f},
	{"ac.rs", &z[1194], x, 0, e, w{"ban.junis.ni.ac.rs", "gaea.rcub.bg.ac.rs", "ns.etf.bg.ac.rs", "ns.rcub.bg.ac.rs", "ns.unic.kg.ac.rs", "ns1.uns.ac.rs", "ns2.iif.hu", "odisej.telekom.rs"}, n, n, n, e, e, t},
	{"co.rs", &z[1194], x, 0, e, w{"a.nic.rs", "b.nic.rs", "g.nic.rs", "h.nic.rs", "l.nic.rs"}, n, n, n, e, e, f},
	{"edu.rs", &z[1194], x, 0, e, w{"a.nic.rs", "b.nic.rs", "g.nic.rs", "h.nic.rs", "l.nic.rs"}, n, n, n, e, e, f},
	{"gov.rs", &z[1194], x, 0, e, w{"dagda1.isp.telekom.rs", "ns1.gov.rs", "ns1.nic.rs", "ns2.gov.rs"}, n, n, n, e, e, f},
	{"in.rs", &z[1194], x, 0, e, w{"a.nic.rs", "b.nic.rs", "g.nic.rs", "h.nic.rs", "l.nic.rs"}, n, n, n, e, e, f},
	{"org.rs", &z[1194], x, 0, e, w{"a.nic.rs", "b.nic.rs", "g.nic.rs", "h.nic.rs", "l.nic.rs"}, n, n, n, e, e, f},
	{"ac.ru", &z[1196], x, 0, e, w{"ns-soa.darenet.dk", "ns1.free.net", "ns2.free.net"}, n, n, n, e, e, f},
	{"adygeya.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"bashkiria.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"bir.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"cbg.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"com.ru", &z[1196], x, 0, e, w{"ns3-com.nic.ru", "ns4-com.nic.ru", "ns8-com.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, f},
	{"dagestan.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"edu.ru", &z[1196], x, 0, e, w{"ns.informika.ru", "ns.msu.ru", "ns.runnet.ru", "ns2.free.net", "ns2.informika.ru"}, n, n, n, "whois.informika.ru", e, f},
	{"gov.ru", &z[1196], x, 0, e, w{"acl.dns.ripn.net", "bcl.dns.ripn.net", "ccl.dns.ripn.net", "ns.gov.ru", "ns2.gov.ru"}, n, n, n, e, e, f},
	{"grozny.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"int.ru", &z[1196], x, 0, e, w{"ns.macomnet.ru", "ns2.macomnet.ru", "ns3.macomnet.ru"}, n, n, n, e, e, f},
	{"kalmykia.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"kustanai.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"marine.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"mil.ru", &z[1196], x, 0, e, w{"ns1.mil.ru", "ns2.mil.ru", "ns4.mil.ru"}, n, n, n, e, e, f},
	{"mordovia.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"msk.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"185.76.145.93"}, n, n, e, e, f},
	{"mytis.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, n, n, n, e, e, t},
	{"nalchik.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, n, n, n, e, e, t},
	{"net.ru", &z[1196], x, 0, e, w{"a.dns-servers.net.ru", "b.dns-servers.net.ru", "d.dns-servers.net.ru", "e.dns-servers.net.ru", "f.dns-servers.net.ru"}, n, n, n, e, e, f},
	{"nov.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"org.ru", &z[1196], x, 0, e, w{"a.dns-servers.net.ru", "b.dns-servers.net.ru", "d.dns-servers.net.ru", "e.dns-servers.net.ru", "f.dns-servers.net.ru"}, n, n, n, e, e, f},
	{"pp.ru", &z[1196], x, 0, e, w{"a.dns-servers.net.ru", "b.dns-servers.net.ru", "d.dns-servers.net.ru", "e.dns-servers.net.ru", "f.dns-servers.net.ru"}, n, n, n, e, e, f},
	{"pyatigorsk.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"relarn.ru", &z[1196], x, 0, e, w{"int2.dns.ripn.net", "int3.dns.ripn.net", "ns.relarn.ru"}, n, n, n, e, e, f},
	{"spb.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, f},
	{"vladikavkaz.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"vladimir.ru", &z[1196], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, n, n, n, e, e, t},
	{"ac.rw", &z[1200], x, 0, e, w{"fork.sth.dnsnode.net", "ns-rw.afrinic.net", "ns1.ricta.org.rw", "ns3.ricta.org.rw", "pch.ricta.org.rw"}, n, n, n, e, e, f},
	{"co.rw", &z[1200], x, 0, e, w{"fork.sth.dnsnode.net", "ns-rw.afrinic.net", "ns1.ricta.org.rw", "ns3.ricta.org.rw", "pch.ricta.org.rw"}, n, n, n, e, e, f},
	{"com.rw", &z[1200], x, 0, e, n, n, n, n, e, e, f},
	{"edu.rw", &z[1200], x, 0, e, w{"fork.sth.dnsnode.net", "ns-rw.afrinic.net", "ns1.ricta.org.rw", "pch.ricta.org.rw"}, n, n, n, e, e, f},
	{"gouv.rw", &z[1200], x, 0, e, n, n, n, n, e, e, f},
	{"gov.rw", &z[1200], x, 0, e, w{"ns1.rdb.rw", "ns2.aos.rw", "ns3.aos.rw"}, n, n, n, e, e, f},
	{"int.rw", &z[1200], x, 0, e, n, n, n, n, e, e, f},
	{"mil.rw", &z[1200], x, 0, e, w{"fork.sth.dnsnode.net", "ns-rw.afrinic.net", "ns1.ricta.org.rw", "ns3.ricta.org.rw", "pch.ricta.org.rw"}, n, n, n, e, e, f},
	{"net.rw", &z[1200], x, 0, e, w{"fork.sth.dnsnode.net", "ns-rw.afrinic.net", "ns1.ricta.org.rw", "ns3.ricta.org.rw", "pch.ricta.org.rw"}, n, n, n, e, e, f},
	{"org.rw", &z[1200], x, 0, e, w{"fork.sth.dnsnode.net", "ns-rw.afrinic.net", "ns1.ricta.org.rw", "ns3.ricta.org.rw", "pch.ricta.org.rw"}, n, n, n, e, e, f},
	{"com.sa", &z[1203], x, 0, e, w{"c1.dns.sa", "c2.dns.sa", "i1.dns.sa", "n1.dns.sa", "p1.dns.sa", "s1.dns.sa", "s2.dns.sa"}, n, n, n, e, e, f},
	{"edu.sa", &z[1203], x, 0, e, w{"c1.dns.sa", "c2.dns.sa", "i1.dns.sa", "n1.dns.sa", "p1.dns.sa", "s1.dns.sa", "s2.dns.sa"}, n, n, n, e, e, f},
	{"gov.sa", &z[1203], x, 0, e, w{"c1.dns.sa", "c2.dns.sa", "i1.dns.sa", "n1.dns.sa", "p1.dns.sa", "s1.dns.sa", "s2.dns.sa"}, n, n, n, e, e, f},
	{"med.sa", &z[1203], x, 0, e, w{"c1.dns.sa", "c2.dns.sa", "i1.dns.sa", "n1.dns.sa", "p1.dns.sa", "s1.dns.sa", "s2.dns.sa"}, n, n, n, e, e, f},
	{"net.sa", &z[1203], x, 0, e, w{"c1.dns.sa", "c2.dns.sa", "i1.dns.sa", "n1.dns.sa", "p1.dns.sa", "s1.dns.sa", "s2.dns.sa"}, n, n, n, e, e, f},
	{"org.sa", &z[1203], x, 0, e, w{"c1.dns.sa", "c2.dns.sa", "i1.dns.sa", "n1.dns.sa", "p1.dns.sa", "s1.dns.sa", "s2.dns.sa"}, n, n, n, e, e, f},
	{"pub.sa", &z[1203], x, 0, e, w{"c1.dns.sa", "c2.dns.sa", "i1.dns.sa", "n1.dns.sa", "p1.dns.sa", "s1.dns.sa", "s2.dns.sa"}, n, n, n, e, e, f},
	{"sch.sa", &z[1203], x, 0, e, w{"c1.dns.sa", "c2.dns.sa", "i1.dns.sa", "n1.dns.sa", "p1.dns.sa", "s1.dns.sa", "s2.dns.sa"}, n, n, n, e, e, f},
	{"com.sb", &z[1223], x, 0, e, w{"ns1.anycastdns.cz", "ns2.anycastdns.cz", "pch.nic.sb"}, n, n, n, e, e, f},
	{"edu.sb", &z[1223], x, 0, e, w{"ns1.anycastdns.cz", "ns2.anycastdns.cz", "pch.nic.sb"}, n, n, n, e, e, f},
	{"gov.sb", &z[1223], x, 0, e, w{"ns1.anycastdns.cz", "ns2.anycastdns.cz", "pch.nic.sb"}, n, n, n, e, e, f},
	{"net.sb", &z[1223], x, 0, e, w{"ns1.anycastdns.cz", "ns2.anycastdns.cz", "pch.nic.sb"}, n, n, n, e, e, f},
	{"org.sb", &z[1223], x, 0, e, w{"ns1.anycastdns.cz", "ns2.anycastdns.cz", "pch.nic.sb"}, n, n, n, e, e, f},
	{"com.sc", &z[1226], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"edu.sc", &z[1226], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"gov.sc", &z[1226], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"net.sc", &z[1226], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"org.sc", &z[1226], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"com.sd", &z[1240], x, 0, e, w{"ans1.canar.sd", "ans1.sis.sd", "ans2.canar.sd", "ns-sd.afrinic.net", "ns.cocca.fr", "ns1.uaenic.ae", "ns2.uaenic.ae", "pch.sis.sd", "sd.cctld.authdns.ripe.net"}, n, n, n, e, e, f},
	{"edu.sd", &z[1240], x, 0, e, w{"ans1.canar.sd", "ans1.sis.sd", "ans2.canar.sd", "ns-sd.afrinic.net", "ns.cocca.fr", "pch.sis.sd", "sd.cctld.authdns.ripe.net"}, n, n, n, e, e, f},
	{"gov.sd", &z[1240], x, 0, e, w{"ans1.canar.sd", "ans1.sis.sd", "ans2.canar.sd", "ns-sd.afrinic.net", "ns.cocca.fr", "ns1.uaenic.ae", "ns2.uaenic.ae", "pch.sis.sd", "sd.cctld.authdns.ripe.net"}, n, n, n, e, e, f},
	{"info.sd", &z[1240], x, 0, e, w{"ans1.canar.sd", "ans1.sis.sd", "ans2.canar.sd", "ns-sd.afrinic.net", "ns.cocca.fr", "pch.sis.sd", "sd.cctld.authdns.ripe.net"}, n, n, n, e, e, f},
	{"med.sd", &z[1240], x, 0, e, w{"ans1.canar.sd", "ans1.sis.sd", "ans2.canar.sd", "ns-sd.afrinic.net", "ns.cocca.fr", "sd.cctld.authdns.ripe.net"}, n, n, n, e, e, f},
	{"net.sd", &z[1240], x, 0, e, w{"ans1.canar.sd", "ans1.sis.sd", "ans2.canar.sd", "ns-sd.afrinic.net", "ns.cocca.fr", "pch.sis.sd", "sd.cctld.authdns.ripe.net"}, n, n, n, e, e, f},
	{"org.sd", &z[1240], x, 0, e, w{"ans1.canar.sd", "ans1.sis.sd", "ans2.canar.sd", "ns-sd.afrinic.net", "ns.cocca.fr", "pch.sis.sd", "sd.cctld.authdns.ripe.net"}, n, n, n, e, e, f},
	{"tv.sd", &z[1240], x, 0, e, w{"ns1.domains.sd", "ns2.domains.sd"}, n, n, n, e, e, f},
	{"a.se", &z[1241], x, 0, e, n, n, n, n, e, e, t},
	{"ac.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"b.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"bd.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"c.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"com.se", &z[1241], x, 0, e, w{"ns1.centralnic.net", "ns2.centralnic.net", "ns3.centralnic.net", "ns4.centralnic.net"}, n, n, n, "whois.centralnic.com", e, f},
	{"d.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"e.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"f.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"g.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"h.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"i.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"k.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"l.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"m.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"mil.se", &z[1241], x, 0, e, w{"dns6.telia.com", "ns.defence.se", "ns.mil.se", "ns2.mil.se", "ns3.mil.se", "pitea.dns.swip.net"}, n, n, n, e, e, f},
	{"n.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"o.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"org.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"p.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"parti.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"pp.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"press.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"r.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"s.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"t.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"tm.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"u.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"w.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"x.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"y.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"z.se", &z[1241], x, 0, e, n, n, n, n, e, e, f},
	{"com.sg", &z[1256], x, 0, e, w{"dsany.sgnic.sg", "dsany2.sgnic.sg", "dsany3.sgnic.sg", "pch.sgzones.sg"}, n, n, n, e, e, t},
	{"edu.sg", &z[1256], x, 0, e, w{"dsany.sgnic.sg", "dsany2.sgnic.sg", "dsany3.sgnic.sg", "pch.sgzones.sg"}, n, n, n, e, e, f},
	{"gov.sg", &z[1256], x, 0, e, w{"dsany.sgnic.sg", "dsany2.sgnic.sg", "dsany3.sgnic.sg", "pch.sgzones.sg"}, n, n, n, e, e, f},
	{"net.sg", &z[1256], x, 0, e, w{"dsany.sgnic.sg", "dsany2.sgnic.sg", "dsany3.sgnic.sg", "pch.sgzones.sg"}, n, n, n, e, e, f},
	{"org.sg", &z[1256], x, 0, e, w{"dsany.sgnic.sg", "dsany2.sgnic.sg", "dsany3.sgnic.sg", "pch.sgzones.sg"}, n, n, n, e, e, f},
	{"per.sg", &z[1256], x, 0, e, w{"dsany.sgnic.sg", "dsany2.sgnic.sg", "dsany3.sgnic.sg", "pch.sgzones.sg"}, n, n, n, e, e, f},
	{"co.sh", &z[1257], x, 0x800, e, n, n, n, n, e, e, t},
	{"com.sh", &z[1257], x, 0x800, e, n, n, n, n, e, e, t},
	{"edu.sh", &z[1257], x, 0x800, e, n, n, n, n, e, e, t},
	{"gov.sh", &z[1257], x, 0x800, e, n, n, n, n, e, e, t},
	{"net.sh", &z[1257], x, 0x800, e, n, n, n, n, e, e, t},
	{"nom.sh", &z[1257], x, 0x800, e, n, n, n, n, e, e, t},
	{"org.sh", &z[1257], x, 0x800, e, n, n, n, n, e, e, t},
	{"ae.si", &z[1272], x, 0, e, w{"ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"at.si", &z[1272], x, 0, e, w{"ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"cn.si", &z[1272], x, 0, e, w{"ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"co.si", &z[1272], x, 0, e, w{"b.ns14.net", "c.ns14.net", "d.ns14.net", "ns.2020.si"}, n, n, n, e, e, f},
	{"de.si", &z[1272], x, 0, e, w{"ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"uk.si", &z[1272], x, 0, e, w{"ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"us.si", &z[1272], x, 0, e, w{"ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"com.sl", &z[1285], x, 0, e, w{"ns1.neoip.com", "ns2.neoip.com"}, n, n, n, e, e, f},
	{"edu.sl", &z[1285], x, 0, e, w{"ns1.neoip.com"}, n, n, n, e, e, t},
	{"gov.sl", &z[1285], x, 0, e, w{"ns1.neoip.com", "ns2.neoip.com"}, n, n, n, e, e, f},
	{"net.sl", &z[1285], x, 0, e, w{"ns1.neoip.com", "ns2.neoip.com"}, n, n, n, e, e, f},
	{"org.sl", &z[1285], x, 0, e, w{"ns1.neoip.com", "ns2.neoip.com"}, n, n, n, e, e, f},
	{"art.sn", &z[1290], x, 0, e, w{"dns.ucad.sn", "ns.nic.sn", "ns.ucad.sn"}, n, n, n, e, e, f},
	{"com.sn", &z[1290], x, 0, e, w{"ns.nic.sn", "ns.ucad.sn", "ns3.cctld.sn"}, n, n, n, e, e, f},
	{"edu.sn", &z[1290], x, 0, e, w{"ns.nic.sn", "ns.ucad.sn", "ns3.cctld.sn"}, n, n, n, e, e, f},
	{"gouv.sn", &z[1290], x, 0, e, w{"ns.gouv.sn", "ns.ucad.sn", "ns2.gouv.sn", "ns3.gouv.sn"}, n, n, n, e, e, t},
	{"org.sn", &z[1290], x, 0, e, w{"ns.nic.sn", "ns.ucad.sn", "ns3.cctld.sn"}, n, n, n, e, e, f},
	{"perso.sn", &z[1290], x, 0, e, w{"ns1.dns.com", "ns2.dns.com"}, n, n, n, e, e, f},
	{"univ.sn", &z[1290], x, 0, e, w{"dns.ucad.sn", "ns.nic.sn", "ns.ucad.sn"}, n, n, n, e, e, t},
	{"com.so", &z[1292], x, 0, e, w{"d.nic.so", "e.nic.so", "ns.cocca.fr"}, n, n, n, e, e, f},
	{"edu.so", &z[1292], x, 0, e, w{"d.nic.so", "e.nic.so", "ns.cocca.fr"}, n, n, n, e, e, t},
	{"net.so", &z[1292], x, 0, e, w{"d.nic.so", "e.nic.so", "ns.cocca.fr"}, n, n, n, e, e, f},
	{"org.so", &z[1292], x, 0, e, w{"d.nic.so", "e.nic.so", "ns.cocca.fr"}, n, n, n, e, e, f},
	{"uber.space", &z[1304], x, 0, e, w{"ns1.jonaspasche.com", "ns2.jonaspasche.com", "ns3.jonaspasche.com"}, n, n, n, e, e, t},
	{"biz.ss", &z[1313], x, 0, e, n, n, n, n, e, e, t},
	{"com.ss", &z[1313], x, 0, e, n, n, n, n, e, e, t},
	{"edu.ss", &z[1313], x, 0, e, n, n, n, n, e, e, t},
	{"me.ss", &z[1313], x, 0, e, n, n, n, n, e, e, t},
	{"net.ss", &z[1313], x, 0, e, n, n, n, n, e, e, t},
	{"org.ss", &z[1313], x, 0, e, n, n, n, n, e, e, t},
	{"sch.ss", &z[1313], x, 0, e, n, n, n, n, e, e, t},
	{"co.st", &z[1314], x, 0, e, w{"ns1-se.ns.gov.st", "ns1-us.ns.gov.st", "ns2-se.ns.gov.st"}, n, n, n, e, e, f},
	{"com.st", &z[1314], x, 0, e, w{"ns1-se.ns.gov.st", "ns1-us.ns.gov.st", "ns2-se.ns.gov.st"}, n, n, n, e, e, f},
	{"consulado.st", &z[1314], x, 0, e, w{"ns1.bahnhof.net", "ns2.bahnhof.net"}, n, n, n, e, e, f},
	{"edu.st", &z[1314], x, 0, e, w{"ns1.nic.st", "ns2.nic.st", "ns3.nic.st"}, n, n, n, e, e, f},
	{"embaixada.st", &z[1314], x, 0, e, w{"ns1.bahnhof.net", "ns2.bahnhof.net"}, n, n, n, e, e, t},
	{"embaizada.st", &z[1314], x, 0, e, n, n, n, n, e, e, f},
	{"gov.st", &z[1314], x, 0, e, w{"ns1.gov.st", "ns2.gov.st"}, n, n, n, e, e, f},
	{"mil.st", &z[1314], x, 0, e, w{"ns.bahnhof.se", "ns2.bahnhof.net"}, n, n, n, e, e, f},
	{"net.st", &z[1314], x, 0, e, w{"ns1.nic.st", "ns2.nic.st", "ns3.nic.st"}, n, n, n, e, e, f},
	{"org.st", &z[1314], x, 0, e, w{"ns1.webhosting.st", "ns2.webhosting.st"}, n, n, n, e, e, f},
	{"principe.st", &z[1314], x, 0, e, w{"ns1.govhost.st", "ns2.govhost.st", "ns3.govhost.st"}, n, n, n, e, e, f},
	{"saotome.st", &z[1314], x, 0, e, w{"ns1.govhost.st", "ns2.govhost.st"}, n, n, n, e, e, f},
	{"store.st", &z[1314], x, 0, e, w{"ns.bahnhof.se", "ns2.bahnhof.net"}, n, n, n, e, e, f},
	{"abkhazia.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"adygeya.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"aktyubinsk.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"arkhangelsk.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"armenia.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"ashgabad.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"azerbaijan.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"balashov.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"bashkiria.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"bryansk.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"bukhara.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"chimkent.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"dagestan.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"east-kazakhstan.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"exnet.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"georgia.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"grozny.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"ivanovo.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, n, n, n, e, e, t},
	{"jambyl.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"kalmykia.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"kaluga.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"karacol.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"karaganda.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"karelia.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"khakassia.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"krasnodar.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"kurgan.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, n, n, n, e, e, t},
	{"kustanai.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"lenug.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, n, n, n, e, e, t},
	{"mangyshlak.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"mordovia.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, n, n, n, e, e, t},
	{"msk.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"murmansk.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"nalchik.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"navoi.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"north-kazakhstan.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"nov.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"obninsk.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"penza.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"pokrovsk.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"sochi.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"spb.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"tashkent.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"termez.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"togliatti.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"troitsk.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"tselinograd.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"tula.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"tuva.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"vladikavkaz.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"vladimir.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"vologda.su", &z[1332], x, 0, e, w{"ns3-geo.nic.ru", "ns4-geo.nic.ru", "ns8-geo.nic.ru"}, w{"178.210.89.119"}, n, n, e, e, t},
	{"com.sv", &z[1341], x, 0, e, n, n, n, n, e, e, f},
	{"edu.sv", &z[1341], x, 0, e, n, n, n, n, e, e, f},
	{"gob.sv", &z[1341], x, 0, e, n, n, n, n, e, e, f},
	{"org.sv", &z[1341], x, 0, e, n, n, n, n, e, e, f},
	{"red.sv", &z[1341], x, 0, e, n, n, n, n, e, e, f},
	{"com.sy", &z[1347], x, 0, e, w{"ns1.tld.sy", "pch.anycast.tld.sy", "sy.cctld.authdns.ripe.net"}, n, n, n, e, e, f},
	{"edu.sy", &z[1347], x, 0, e, w{"ns1.tld.sy", "pch.anycast.tld.sy", "sy.cctld.authdns.ripe.net"}, n, n, n, e, e, f},
	{"gov.sy", &z[1347], x, 0, e, w{"ns1.tld.sy", "pch.anycast.tld.sy", "sy.cctld.authdns.ripe.net"}, n, n, n, e, e, f},
	{"mil.sy", &z[1347], x, 0, e, w{"ns31.cloudns.net", "ns32.cloudns.net", "ns33.cloudns.net", "ns34.cloudns.net"}, n, n, n, e, e, f},
	{"net.sy", &z[1347], x, 0, e, w{"ns1.tld.sy", "pch.anycast.tld.sy", "sy.cctld.authdns.ripe.net"}, n, n, n, e, e, f},
	{"org.sy", &z[1347], x, 0, e, w{"ns1.tld.sy", "pch.anycast.tld.sy", "sy.cctld.authdns.ripe.net"}, n, n, n, e, e, f},
	{"ac.sz", &z[1351], x, 0, e, n, n, n, n, e, e, f},
	{"co.sz", &z[1351], x, 0, e, n, n, n, n, e, e, f},
	{"org.sz", &z[1351], x, 0, e, n, n, n, n, e, e, f},
	{"at.tc", &z[1363], z[5157:5158], 0, e, w{"ns1.123k-elazz.com", "ns2.123k-elazz.com"}, n, n, n, e, e, f},
	{"au.tc", &z[1363], z[5158:5159], 0, e, n, n, n, n, e, e, f},
	{"be.tc", &z[1363], x, 0, e, w{"ns1.be.tc", "ns2.be.tc"}, w{"213.136.89.177"}, n, n, e, e, f},
	{"biz.tc", &z[1363], x, 0, "https://www.biz.tc/", w{"ns1.nudrv.com", "ns2.nudrv.com"}, w{"64.136.20.39"}, n, n, e, e, f},
	{"br.tc", &z[1363], x, 0, e, n, n, n, n, e, e, f},
	{"ch.tc", &z[1363], x, 0, e, w{"ns1.swisscenter.com", "ns2.swisscenter.com"}, n, n, n, e, e, f},
	{"com.tc", &z[1363], x, 0, e, w{"root1.zone.tc", "root2.zone.tc", "root3.zone.tc", "root4.zone.tc", "root5.zone.tc", "root6.zone.tc", "root7.zone.tc", "root8.zone.tc"}, n, n, n, e, e, t},
	{"cz.tc", &z[1363], x, 0, e, w{"ns1.ispapi.net", "ns2.ispapi.net", "ns3.ispapi.net"}, n, n, n, e, e, f},
	{"de.tc", &z[1363], x, 0, e, n, n, n, n, e, e, f},
	{"dk.tc", &z[1363], x, 0, e, n, n, n, n, e, e, f},
	{"edu.tc", &z[1363], x, 0, e, w{"root1.zone.tc", "root2.zone.tc", "root3.zone.tc", "root4.zone.tc", "root5.zone.tc", "root6.zone.tc", "root7.zone.tc", "root8.zone.tc"}, n, n, n, e, e, f},
	{"es.tc", &z[1363], x, 0, e, w{"ns1.es.tc", "ns2.es.tc"}, n, n, n, e, e, t},
	{"eu.tc", &z[1363], x, 0, e, n, n, n, n, e, e, f},
	{"hk.tc", &z[1363], x, 0, e, w{"drew.ns.cloudflare.com", "kia.ns.cloudflare.com"}, n, n, n, e, e, f},
	{"hu.tc", &z[1363], x, 0x800, e, n, n, n, n, e, e, f},
	{"ie.tc", &z[1363], x, 0, e, n, n, n, n, e, e, f},
	{"int.tc", &z[1363], x, 0, e, w{"ns1.int.tc", "ns2.int.tc"}, n, n, n, e, e, f},
	{"it.tc", &z[1363], x, 0, e, w{"ns0.dnsmadeeasy.com", "ns1.dnsmadeeasy.com", "ns3.dnsmadeeasy.com", "ns4.dnsmadeeasy.com"}, n, n, n, e, e, f},
	{"kr.tc", &z[1363], x, 0, e, w{"ns.udag.de", "ns.udag.net", "ns.udag.org"}, w{"89.31.143.1"}, n, n, e, e, f},
	{"mx.tc", &z[1363], x, 0, e, w{"leah.ns.cloudflare.com", "noah.ns.cloudflare.com"}, w{"104.21.75.127", "172.67.175.218", "2606:4700:3036::6815:4b7f", "2606:4700:3036::ac43:afda"}, n, n, e, e, f},
	{"net.tc", &z[1363], x, 0, e, w{"root1.zone.tc", "root2.zone.tc", "root3.zone.tc", "root4.zone.tc", "root5.zone.tc", "root6.zone.tc", "root7.zone.tc"}, n, n, n, e, e, f},
	{"no.tc", &z[1363], x, 0, e, w{"betty.ns.cloudflare.com", "kai.ns.cloudflare.com"}, w{"77.79.104.210"}, n, n, e, e, f},
	{"org.tc", &z[1363], x, 0, e, w{"root1.zone.tc", "root2.zone.tc", "root3.zone.tc", "root4.zone.tc", "root5.zone.tc", "root6.zone.tc", "root7.zone.tc", "root8.zone.tc"}, n, n, n, e, e, t},
	{"ph.tc", &z[1363], x, 0, e, w{"ns1.openprovider.nl", "ns2.openprovider.be", "ns3.openprovider.eu"}, n, n, n, e, e, f},
	{"pl.tc", &z[1363], x, 0, e, n, n, n, n, e, e, f},
	{"pro.tc", &z[1363], x, 0, e, w{"root1.zone.tc", "root2.zone.tc", "root3.zone.tc", "root4.zone.tc", "root5.zone.tc", "root6.zone.tc", "root7.zone.tc", "root8.zone.tc"}, n, n, n, e, e, f},
	{"ru.tc", &z[1363], x, 0, e, w{"ns1.bodis.com", "ns2.bodis.com"}, w{"199.59.242.153"}, n, n, e, e, f},
	{"se.tc", &z[1363], x, 0, e, w{"gabriel.ns.cloudflare.com", "jamie.ns.cloudflare.com"}, n, n, n, e, e, f},
	{"shop.tc", &z[1363], x, 0, e, w{"ns.onshore.net", "ns2.onshore.net"}, n, n, n, e, e, f},
	{"th.tc", &z[1363], x, 0, e, w{"ns-cloud-b1.googledomains.com", "ns-cloud-b2.googledomains.com", "ns-cloud-b3.googledomains.com", "ns-cloud-b4.googledomains.com"}, n, n, n, e, e, f},
	{"ua.tc", &z[1363], x, 0, e, n, n, n, n, e, e, f},
	{"uk.tc", &z[1363], z[5159:5162], 0, e, w{"ns1.uk.tc", "ns2.uk.tc"}, n, n, n, e, e, f},
	{"us.tc", &z[1363], x, 0, e, n, n, n, n, e, e, f},
	{"com.td", &z[1365], x, 0, e, n, n, n, n, e, e, f},
	{"net.td", &z[1365], x, 0, e, n, n, n, n, e, e, f},
	{"org.td", &z[1365], x, 0, e, n, n, n, n, e, e, f},
	{"tourism.td", &z[1365], x, 0, e, n, n, n, n, e, e, f},
	{"at.tf", &z[1377], x, 0, e, w{"ns1.idnscan.net", "ns2.idnscan.net"}, n, n, n, e, e, f},
	{"bg.tf", &z[1377], x, 0, e, w{"ns1.idnscan.net", "ns2.idnscan.net"}, n, n, n, e, e, f},
	{"ca.tf", &z[1377], x, 0, e, w{"ns1.idnscan.net", "ns2.idnscan.net"}, n, n, n, e, e, f},
	{"ch.tf", &z[1377], x, 0, e, w{"ns1.idnscan.net", "ns2.idnscan.net"}, n, n, n, e, e, f},
	{"cz.tf", &z[1377], x, 0, e, w{"ns1.idnscan.net", "ns2.idnscan.net"}, n, n, n, e, e, f},
	{"de.tf", &z[1377], x, 0, e, w{"ns1.idnscan.net", "ns2.idnscan.net"}, n, n, n, e, e, f},
	{"edu.tf", &z[1377], x, 0, e, w{"ns1.idnscan.net", "ns2.idnscan.net"}, n, n, n, e, e, f},
	{"eu.tf", &z[1377], x, 0, e, w{"ns1.idnscan.net", "ns2.idnscan.net"}, n, n, n, e, e, f},
	{"int.tf", &z[1377], x, 0, e, w{"ns1.idnscan.net", "ns2.idnscan.net"}, n, n, n, e, e, f},
	{"net.tf", &z[1377], x, 0, e, w{"ns1.idnscan.net", "ns2.idnscan.net"}, n, n, n, e, e, f},
	{"pl.tf", &z[1377], x, 0, e, w{"ns1.idnscan.net", "ns2.idnscan.net"}, n, n, n, e, e, f},
	{"ru.tf", &z[1377], x, 0, e, w{"ns1.idnscan.net", "ns2.idnscan.net"}, n, n, n, e, e, f},
	{"sg.tf", &z[1377], x, 0, e, w{"ns1.idnscan.net", "ns2.idnscan.net"}, n, n, n, e, e, f},
	{"us.tf", &z[1377], x, 0, e, w{"ns1.idnscan.net", "ns2.idnscan.net"}, n, n, n, e, e, f},
	{"ac.th", &z[1379], x, 0, e, w{"a.thains.co.th", "b.thains.co.th", "c.thains.co.th", "ns.thnic.net", "p.thains.co.th"}, n, n, n, e, e, f},
	{"co.th", &z[1379], x, 0, e, w{"a.thains.co.th", "b.thains.co.th", "c.thains.co.th", "ns.thnic.net", "p.thains.co.th"}, n, n, n, e, e, f},
	{"go.th", &z[1379], x, 0, e, w{"a.thains.co.th", "b.thains.co.th", "c.thains.co.th", "ns.thnic.net", "p.thains.co.th"}, n, n, n, e, e, f},
	{"in.th", &z[1379], x, 0, e, w{"a.thains.co.th", "b.thains.co.th", "c.thains.co.th", "ns.thnic.net", "p.thains.co.th"}, n, n, n, e, e, f},
	{"mi.th", &z[1379], x, 0, e, w{"a.thains.co.th", "b.thains.co.th", "c.thains.co.th", "ns.thnic.net", "p.thains.co.th"}, n, n, n, e, e, f},
	{"net.th", &z[1379], x, 0, e, w{"a.thains.co.th", "b.thains.co.th", "c.thains.co.th", "ns.thnic.net", "p.thains.co.th"}, n, n, n, e, e, f},
	{"or.th", &z[1379], x, 0, e, w{"a.thains.co.th", "b.thains.co.th", "c.thains.co.th", "ns.thnic.net", "p.thains.co.th"}, n, n, n, e, e, f},
	{"ac.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"aero.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"biz.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"co.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"com.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"coop.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"dyn.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"edu.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"go.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"gov.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"info.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"int.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"mil.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"museum.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"my.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"name.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"net.tj", &z[1395], x, 0x800, e, n, n, n, n, e, e, f},
	{"org.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"per.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"pro.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"web.tj", &z[1395], x, 0, e, n, n, n, n, e, e, f},
	{"24.tl", &z[1400], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "24.tl"}, n, n, e, e, t},
	{"com.tl", &z[1400], x, 0, e, w{"ns.anycast.nic.tl", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"gov.tl", &z[1400], x, 0, e, w{"ns.anycast.nic.tl", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"in.tl", &z[1400], x, 0x800, e, n, n, n, n, e, e, f},
	{"na.tl", &z[1400], x, 0, e, w{"ns1.afraid.org", "ns2.afraid.org", "ns3.afraid.org", "ns4.afraid.org"}, n, n, n, e, e, t},
	{"net.tl", &z[1400], x, 0, e, w{"ns.anycast.nic.tl", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"org.tl", &z[1400], x, 0, e, w{"ns.anycast.nic.tl", "ns1.anycastdns.cz", "ns2.anycastdns.cz"}, n, n, n, e, e, f},
	{"co.tm", &z[1401], x, 0, e, w{"webns1.telecom.tm", "webns2.telecom.tm"}, n, n, n, e, e, t},
	{"com.tm", &z[1401], x, 0, e, w{"webns1.telecom.tm", "webns2.telecom.tm"}, n, n, n, e, e, f},
	{"edu.tm", &z[1401], x, 0, e, w{"webns1.telecom.tm", "webns2.telecom.tm"}, n, n, n, e, e, f},
	{"gov.tm", &z[1401], x, 0, e, w{"webns1.telecom.tm", "webns2.telecom.tm"}, n, n, n, e, e, f},
	{"mil.tm", &z[1401], x, 0, e, w{"webns1.telecom.tm", "webns2.telecom.tm"}, n, n, n, e, e, t},
	{"net.tm", &z[1401], x, 0, e, w{"ns05.telecom.tm", "ns06.telecom.tm", "webns1.telecom.tm", "webns2.telecom.tm"}, n, n, n, e, e, f},
	{"nom.tm", &z[1401], x, 0x800, e, n, n, n, n, e, e, t},
	{"org.tm", &z[1401], x, 0, e, w{"dns01.nic.tm", "dns1.nic.tm", "dns2.nic.tm", "dns3.nic.tm", "dns4.nic.tm", "dns5.nic.tm", "dns6.nic.tm", "dns7.nic.tm"}, n, n, n, e, e, f},
	{"agrinet.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"com.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"defense.tn", &z[1403], x, 0, e, w{"ns1.defense.tn", "ns2.defense.tn"}, n, n, n, e, e, f},
	{"edunet.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"ens.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"fin.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"gov.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"ind.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"info.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"intl.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"mincom.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"nat.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"net.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"org.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"perso.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"rnrt.tn", &z[1403], x, 0, e, w{"ns1.cck.rnu.tn", "ns2.cck.rnu.tn", "ns3.cck.rnu.tn"}, n, n, n, e, e, f},
	{"rns.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"rnu.tn", &z[1403], x, 0, e, w{"ns1.cck.rnu.tn", "ns2.cck.rnu.tn", "ns3.cck.rnu.tn"}, n, n, n, e, e, f},
	{"tourism.tn", &z[1403], x, 0, e, w{"ns1.ati.tn", "ns2.ati.tn"}, n, n, n, e, e, f},
	{"com.tp", &z[1417], x, 0x800, e, n, n, n, n, e, e, f},
	{"or.tp", &z[1417], x, 0x800, e, n, n, n, n, e, e, f},
	{"org.tp", &z[1417], x, 0x800, e, n, n, n, n, e, e, f},
	{"av.tr", &z[1418], x, 0, e, w{"lns31.nic.tr", "lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns61.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"bbs.tr", &z[1418], x, 0, e, w{"lns31.nic.tr", "lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns61.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"bel.tr", &z[1418], x, 0, e, w{"lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"biz.tr", &z[1418], x, 0, e, w{"lns31.nic.tr", "lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns61.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"com.tr", &z[1418], x, 0, e, w{"lns31.nic.tr", "lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns61.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"dr.tr", &z[1418], x, 0, e, w{"lns31.nic.tr", "lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns61.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"edu.tr", &z[1418], x, 0, e, w{"lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"gen.tr", &z[1418], x, 0, e, w{"lns31.nic.tr", "lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns61.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"gov.tr", &z[1418], x, 0, e, w{"lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"info.tr", &z[1418], x, 0, e, w{"lns31.nic.tr", "lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns61.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"k12.tr", &z[1418], x, 0, e, w{"lns31.nic.tr", "lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns61.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"mil.tr", &z[1418], x, 0, e, n, n, n, n, e, e, t},
	{"name.tr", &z[1418], x, 0, e, w{"lns31.nic.tr", "lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns61.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"nc.tr", &z[1418], x, 0, e, w{"ns1.nc.tr", "ns2.nc.tr"}, n, n, n, e, e, t},
	{"net.tr", &z[1418], x, 0, e, w{"lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"org.tr", &z[1418], x, 0, e, w{"lns31.nic.tr", "lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns61.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"pol.tr", &z[1418], x, 0, e, w{"lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"tel.tr", &z[1418], x, 0, e, w{"lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"tsk.tr", &z[1418], x, 0, e, w{"lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"tv.tr", &z[1418], x, 0, e, w{"lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"web.tr", &z[1418], x, 0, e, w{"lns31.nic.tr", "lns34.nic.tr", "lns35.nic.tr", "lns41.nic.tr", "lns42.nic.tr", "lns5.nic.tr", "lns61.nic.tr", "lns71.nic.tr"}, n, n, n, e, e, t},
	{"aero.tt", &z[1433], x, 0, e, n, n, n, n, e, e, t},
	{"at.tt", &z[1433], z[5162:5163], 0, e, w{"a.ns.viennaweb.at", "b.ns.viennaweb.at"}, n, n, n, e, e, f},
	{"au.tt", &z[1433], z[5163:5164], 0, e, n, n, n, n, e, e, f},
	{"be.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"biz.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"ca.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"cat.tt", &z[1433], x, 0, e, w{"ns-1084.awsdns-07.org", "ns-1826.awsdns-36.co.uk", "ns-455.awsdns-56.com", "ns-732.awsdns-27.net"}, n, n, n, e, e, t},
	{"ch.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"co.tt", &z[1433], x, 0, e, n, n, n, n, e, e, t},
	{"com.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"coop.tt", &z[1433], x, 0, e, n, n, n, n, e, e, t},
	{"de.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"edu.tt", &z[1433], x, 0, e, w{"ns1.edu.tt", "ns2.edu.tt"}, n, n, n, e, e, f},
	{"es.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"eu.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"fr.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"gov.tt", &z[1433], x, 0, e, w{"dns5.gov.tt", "dns6.gov.tt", "dns7.gov.tt", "dns8.gov.tt"}, n, n, n, e, e, f},
	{"info.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"int.tt", &z[1433], x, 0, e, w{"ns1.dnsdun.com", "ns1.dnsdun.net"}, n, n, n, e, e, t},
	{"it.tt", &z[1433], x, 0, e, w{"ns1.dnsv2.com", "ns2.dnsv2.com"}, n, n, n, e, e, f},
	{"jobs.tt", &z[1433], x, 0, e, n, n, n, n, e, e, t},
	{"mobi.tt", &z[1433], x, 0, e, n, n, n, n, e, e, t},
	{"museum.tt", &z[1433], x, 0, e, n, n, n, n, e, e, t},
	{"name.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"net.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"nl.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"org.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"pro.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"tel.tt", &z[1433], x, 0, e, n, n, n, n, e, e, t},
	{"travel.tt", &z[1433], x, 0x800, e, n, n, n, n, e, e, t},
	{"uk.tt", &z[1433], z[5164:5167], 0, e, n, n, n, n, e, e, f},
	{"us.tt", &z[1433], x, 0, e, n, n, n, n, e, e, f},
	{"club.tw", &z[1440], x, 0, e, w{"a.twnic.net.tw", "b.twnic.net.tw", "c.twnic.net.tw", "d.twnic.net.tw", "e.twnic.net.tw", "f.twnic.net.tw", "g.twnic.net.tw", "h.dns.tw", "h.twnic.net.tw"}, n, n, n, e, e, t},
	{"com.tw", &z[1440], x, 0, e, w{"a.twnic.net.tw", "anytld.apnic.net", "b.twnic.net.tw", "c.twnic.net.tw", "d.twnic.net.tw", "e.twnic.net.tw", "f.twnic.net.tw", "g.twnic.net.tw", "h.dns.tw", "h.twnic.net.tw"}, n, n, n, e, e, t},
	{"ebiz.tw", &z[1440], x, 0, e, w{"a.twnic.net.tw", "b.twnic.net.tw", "c.twnic.net.tw", "d.twnic.net.tw", "e.twnic.net.tw", "f.twnic.net.tw", "g.twnic.net.tw", "h.dns.tw", "h.twnic.net.tw"}, n, n, n, e, e, t},
	{"edu.tw", &z[1440], x, 0, e, w{"a.twnic.net.tw", "b.twnic.net.tw", "c.twnic.net.tw", "d.twnic.net.tw", "edudns-a1.edu.tw", "edudns-a2.edu.tw", "edudns-a3.edu.tw", "moemoon.edu.tw", "moestar.edu.tw"}, n, n, n, e, e, t},
	{"game.tw", &z[1440], x, 0, e, w{"a.twnic.net.tw", "b.twnic.net.tw", "c.twnic.net.tw", "d.twnic.net.tw", "e.twnic.net.tw", "f.twnic.net.tw", "g.twnic.net.tw", "h.dns.tw", "h.twnic.net.tw"}, n, n, n, e, e, t},
	{"gov.tw", &z[1440], x, 0, e, w{"a.twnic.net.tw", "b.twnic.net.tw", "c.twnic.net.tw", "d.twnic.net.tw", "e.twnic.net.tw", "f.twnic.net.tw", "g.twnic.net.tw", "h.twnic.net.tw"}, n, n, n, e, e, t},
	{"idv.tw", &z[1440], x, 0, e, w{"a.twnic.net.tw", "anytld.apnic.net", "b.twnic.net.tw", "c.twnic.net.tw", "d.twnic.net.tw", "e.twnic.net.tw", "f.twnic.net.tw", "g.twnic.net.tw", "h.dns.tw", "h.twnic.net.tw"}, n, n, n, e, e, t},
	{"mil.tw", &z[1440], x, 0, e, w{"dns1.mil.tw", "dns2.mil.tw"}, n, n, n, e, e, t},
	{"net.tw", &z[1440], x, 0, e, w{"a.twnic.net.tw", "anytld.apnic.net", "b.twnic.net.tw", "c.twnic.net.tw", "d.twnic.net.tw", "e.twnic.net.tw", "f.twnic.net.tw", "g.twnic.net.tw", "h.dns.tw", "h.twnic.net.tw"}, n, n, n, e, e, t},
	{"org.tw", &z[1440], x, 0, e, w{"a.twnic.net.tw", "anytld.apnic.net", "b.twnic.net.tw", "c.twnic.net.tw", "d.twnic.net.tw", "e.twnic.net.tw", "f.twnic.net.tw", "g.twnic.net.tw", "h.dns.tw", "h.twnic.net.tw"}, n, n, n, e, e, t},
	{"xn--czrw28b.tw" /* 商業.tw */, &z[1440], x, 0, "https://www.twnic.tw/", n, n, n, n, e, e, t},
	{"xn--uc0atv.tw" /* 組織.tw */, &z[1440], x, 0, "https://www.twnic.tw/", n, n, n, n, e, e, t},
	{"xn--zf0ao64a.tw" /* 網路.tw */, &z[1440], x, 0, "https://www.twnic.tw/", n, n, n, n, e, e, t},
	{"ac.tz", &z[1441], x, 0, e, w{"d.ext.nic.cz", "fork.sth.dnsnode.net", "ns.anycast.co.tz", "ns2.tznic.or.tz", "rip.psg.com"}, n, n, n, e, e, f},
	{"co.tz", &z[1441], x, 0, e, w{"d.ext.nic.cz", "fork.sth.dnsnode.net", "ns.anycast.co.tz", "ns2.tznic.or.tz", "rip.psg.com"}, n, n, n, e, e, f},
	{"go.tz", &z[1441], x, 0, e, w{"d.ext.nic.cz", "fork.sth.dnsnode.net", "ns.anycast.co.tz", "ns2.tznic.or.tz", "rip.psg.com"}, n, n, n, e, e, f},
	{"hotel.tz", &z[1441], x, 0, e, w{"fork.sth.dnsnode.net", "ns.anycast.co.tz", "ns2.tznic.or.tz"}, n, n, n, e, e, f},
	{"info.tz", &z[1441], x, 0, e, w{"fork.sth.dnsnode.net", "ns.anycast.co.tz", "ns2.tznic.or.tz"}, n, n, n, e, e, f},
	{"me.tz", &z[1441], x, 0, e, w{"fork.sth.dnsnode.net", "ns.anycast.co.tz", "ns2.tznic.or.tz"}, n, n, n, e, e, f},
	{"mil.tz", &z[1441], x, 0, e, w{"fork.sth.dnsnode.net", "ns.anycast.co.tz", "ns2.tznic.or.tz"}, n, n, n, e, e, f},
	{"mobi.tz", &z[1441], x, 0, e, w{"fork.sth.dnsnode.net", "ns.anycast.co.tz", "ns2.tznic.or.tz"}, n, n, n, e, e, f},
	{"ne.tz", &z[1441], x, 0, e, w{"d.ext.nic.cz", "fork.sth.dnsnode.net", "ns.anycast.co.tz", "ns2.tznic.or.tz", "rip.psg.com"}, n, n, n, e, e, f},
	{"or.tz", &z[1441], x, 0, e, w{"d.ext.nic.cz", "fork.sth.dnsnode.net", "ns.anycast.co.tz", "ns2.tznic.or.tz", "rip.psg.com"}, n, n, n, e, e, f},
	{"sc.tz", &z[1441], x, 0, e, w{"fork.sth.dnsnode.net", "ns.anycast.co.tz", "ns2.tznic.or.tz"}, n, n, n, e, e, f},
	{"tv.tz", &z[1441], x, 0, e, w{"fork.sth.dnsnode.net", "ns.anycast.co.tz", "ns2.tznic.or.tz"}, n, n, n, e, e, f},
	{"biz.ua", &z[1442], x, 0, e, w{"ns1.uadns.com", "ns2.uadns.com", "ns3.uadns.com"}, n, n, n, e, e, f},
	{"cherkassy.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "nix.ns.ua", "ns2.km.ua"}, n, n, n, e, e, f},
	{"cherkasy.ua", &z[1442], x, 0, e, w{"ba1.ns.ua", "nix.ns.ua", "ns2.km.ua"}, n, n, n, e, e, t},
	{"chernigov.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"nix.ns.ua", "ns.dn.ua", "ns3.cn.ua"}, n, n, n, e, e, f},
	{"chernivtsi.ua", &z[1442], x, 0, e, w{"nix.ns.ua", "ns.cv.ua", "ns.kharkov.ua", "ns2.km.ua"}, n, n, n, e, e, t},
	{"chernovtsy.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "nix.ns.ua", "ns.cv.ua", "ns2.km.ua"}, n, n, n, e, e, f},
	{"ck.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "nix.ns.ua", "ns2.km.ua"}, n, n, n, e, e, f},
	{"cn.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"nix.ns.ua", "ns.dn.ua", "ns3.cn.ua"}, n, n, n, e, e, f},
	{"co.ua", &z[1442], x, 0, e, w{"ns1.uadns.com", "ns2.uadns.com", "ns3.uadns.com"}, n, n, n, "whois.co.ua", e, f},
	{"com.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "ho1.ns.com.ua", "k.ns.com.ua", "nix.ns.ua"}, n, n, n, e, e, f},
	{"crimea.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "ho1.ns.crimea.ua", "nix.ns.ua", "ns.crimea.ua"}, n, n, n, "whois.crimea.ua", e, f},
	{"cv.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "nix.ns.ua", "ns.cv.ua", "ns2.km.ua"}, n, n, n, e, e, f},
	{"dn.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ho1.eunic.net.ua", "ns.dn.ua", "ns.kh.ua", "ns.sm.ua", "ns.zp.ua"}, n, n, n, e, e, f},
	{"dnepropetrovsk.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ns.dp.ua", "s1.ns.dp.ua", "s2.ns.dp.ua", "s3.ns.dp.ua"}, n, n, n, e, e, f},
	{"dnipropetrovsk.ua", &z[1442], x, 0, e, w{"ns.dp.ua", "s1.ns.dp.ua", "s2.ns.dp.ua", "s3.ns.dp.ua"}, n, n, n, e, e, t},
	{"donetsk.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ho1.eunic.net.ua", "ns.dn.ua", "ns.kh.ua", "ns.sm.ua", "ns.zp.ua"}, n, n, n, e, e, f},
	{"dp.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ns.dp.ua", "s1.ns.dp.ua", "s2.ns.dp.ua", "s3.ns.dp.ua"}, n, n, n, e, e, f},
	{"edu.ua", &z[1442], x, 0, e, w{"ba1.ns.ua", "deneb.dfn.de", "ho1.ns.edu.ua", "nix.ns.ua"}, n, n, n, e, e, f},
	{"gov.ua", &z[1442], x, 0, e, w{"ba1.ns.ua", "ho1.ns.gov.ua", "nix.ns.ua"}, n, n, n, e, e, f},
	{"if.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "ho1.ns.if.ua", "nix.ns.ua", "ns.dn.ua", "ns.zp.ua"}, n, n, n, e, e, f},
	{"in.ua", &z[1442], x, 0, e, w{"ho1.ns.od.ua", "ns.in.ua", "nss.ukr.net"}, n, n, n, "whois.in.ua", e, f},
	{"ivano-frankivsk.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "ho1.ns.if.ua", "nix.ns.ua", "ns.dn.ua", "ns.zp.ua"}, n, n, n, e, e, f},
	{"kh.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ho1.eunic.net.ua", "ns.dn.ua", "ns.kh.ua", "ns.sm.ua", "ns.zp.ua"}, n, n, n, e, e, f},
	{"kharkiv.ua", &z[1442], x, 0, e, w{"ho1.eunic.net.ua", "ns.dn.ua", "ns.kh.ua", "ns.sm.ua", "ns.zp.ua"}, n, n, n, e, e, t},
	{"kharkov.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ho1.eunic.net.ua", "ns.dn.ua", "ns.kh.ua", "ns.sm.ua", "ns.zp.ua"}, n, n, n, e, e, f},
	{"kherson.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ho1.ns.ks.ua", "nix.ns.ua", "ns.dn.ua", "ns.kharkov.ua", "ns.ks-host.com"}, n, n, n, e, e, f},
	{"khmelnitskiy.ua", &z[1442], x, 0, e, w{"ba1.ns.ua", "nix.ns.ua", "ns.km.ua", "ns2.km.ua", "ns3.km.ua"}, n, n, n, e, e, f},
	{"kiev.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "ho1.ns.kiev.ua", "k.ns.com.ua", "nix.ns.ua"}, n, n, n, e, e, f},
	{"kirovograd.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "nix.ns.ua", "ns.host.kr.ua", "ns.infocom.kr.ua"}, n, n, n, e, e, f},
	{"km.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "nix.ns.ua", "ns.km.ua", "ns2.km.ua", "ns3.km.ua"}, n, n, n, e, e, f},
	{"kr.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "nix.ns.ua", "ns.host.kr.ua", "ns.infocom.kr.ua"}, n, n, n, e, e, f},
	{"ks.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ho1.ns.ks.ua", "nix.ns.ua", "ns.dn.ua", "ns.kharkov.ua", "ns.ks-host.com"}, n, n, n, e, e, f},
	{"kyiv.ua", &z[1442], x, 0, e, w{"ba1.ns.ua", "ho1.ns.kiev.ua", "k.ns.com.ua", "nix.ns.ua"}, n, n, n, e, e, t},
	{"lg.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ho1.eunic.net.ua", "ns.dn.ua", "ns.kh.ua", "ns.sm.ua", "ns.zp.ua"}, n, n, n, e, e, f},
	{"lt.ua", &z[1442], x, 0, e, w{"ho1.ns.lutsk.ua", "nix.ns.ua", "ns.cv.ua"}, n, n, n, e, e, f},
	{"lugansk.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ho1.eunic.net.ua", "ns.dn.ua", "ns.kh.ua", "ns.sm.ua", "ns.zp.ua"}, n, n, n, e, e, f},
	{"lutsk.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ho1.ns.lutsk.ua", "nix.ns.ua", "ns.zp.ua"}, n, n, n, e, e, f},
	{"lviv.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"eta.uar.net", "iota.uar.net", "kappa.uar.net", "ns.lviv.ua", "theta.uar.net", "zeta.uar.net"}, n, n, n, "whois.lviv.ua", e, f},
	{"mk.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "epp.ns.od.ua", "ho1.ns.od.ua", "nix.ns.ua"}, n, n, n, e, e, f},
	{"net.ua", &z[1442], x, 0, e, w{"ba1.ns.ua", "ho1.net.ua", "nix.ns.ua", "ns.dn.ua", "ns.kh.ua", "ns.net.ua", "ns.sm.ua", "ns.zp.ua"}, n, n, n, "whois.net.ua", e, f},
	{"nikolaev.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "epp.ns.od.ua", "ho1.ns.od.ua", "nix.ns.ua"}, n, n, n, e, e, f},
	{"od.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ho1.ns.od.ua", "nix.ns.ua", "ns.od.ua"}, n, n, n, e, e, f},
	{"odesa.ua", &z[1442], x, 0, e, w{"ho1.ns.od.ua", "nix.ns.ua", "ns.od.ua"}, n, n, n, e, e, f},
	{"odessa.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ho1.ns.od.ua", "nix.ns.ua", "ns.od.ua"}, n, n, n, e, e, f},
	{"org.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "ho1.ns.org.ua", "nix.ns.ua", "ns.dn.ua"}, n, n, n, e, e, f},
	{"pl.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "ho1.ns.pl.ua", "nix.ns.ua"}, n, n, n, e, e, f},
	{"poltava.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "ho1.ns.pl.ua", "nix.ns.ua"}, n, n, n, e, e, f},
	{"pp.ua", &z[1442], x, 0, e, w{"ns1.uadns.com", "ns2.uadns.com", "ns3.uadns.com"}, n, n, n, "whois.pp.ua", e, f},
	{"rivne.ua", &z[1442], x, 0, e, w{"ba1.ns.ua", "ns5.dnsmadeeasy.com", "ns6.dnsmadeeasy.com", "ns7.dnsmadeeasy.com"}, n, n, n, e, e, t},
	{"rovno.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "ns5.dnsmadeeasy.com", "ns6.dnsmadeeasy.com", "ns7.dnsmadeeasy.com"}, n, n, n, e, e, f},
	{"rv.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "ns5.dnsmadeeasy.com", "ns6.dnsmadeeasy.com", "ns7.dnsmadeeasy.com"}, n, n, n, e, e, f},
	{"sebastopol.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "ho1.ns.crimea.ua", "nix.ns.ua", "ns.crimea.ua"}, n, n, n, "whois.sebastopol.ua", e, f},
	{"sm.ua", &z[1442], x, 0, e, w{"ho1.eunic.net.ua", "ns.dn.ua", "ns.kh.ua", "ns.sm.ua", "ns.zp.ua"}, n, n, n, e, e, f},
	{"sumy.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ho1.eunic.net.ua", "ns.dn.ua", "ns.kh.ua", "ns.sm.ua", "ns.zp.ua"}, n, n, n, e, e, f},
	{"te.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"nix.ns.ua", "ns.dn.ua", "ns.te.ua", "ns2.km.ua", "ns2.uar.net"}, n, n, n, e, e, f},
	{"ternopil.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"nix.ns.ua", "ns.dn.ua", "ns.te.ua", "ns2.km.ua", "ns2.uar.net"}, n, n, n, e, e, f},
	{"uz.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "ho1.ns.uz.ua", "nix.ns.ua", "ns.dn.ua"}, n, n, n, e, e, f},
	{"uzhgorod.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "ho1.ns.uz.ua", "nix.ns.ua", "ns.dn.ua"}, n, n, n, e, e, f},
	{"vinnica.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "nix.ns.ua", "ns1.vn.ua", "ns1.vsmu.vinnica.ua", "ns4.nest.vn.ua"}, n, n, n, e, e, f},
	{"vn.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "nix.ns.ua", "ns1.vn.ua", "ns1.vsmu.vinnica.ua", "ns4.nest.vn.ua"}, n, n, n, e, e, f},
	{"volyn.ua", &z[1442], x, 0, e, w{"ho1.ns.lutsk.ua", "nix.ns.ua", "ns.zp.ua"}, n, n, n, e, e, f},
	{"yalta.ua", &z[1442], x, 0, e, w{"ho1.ns.crimea.ua", "nix.ns.ua", "ns.crimea.ua"}, n, n, n, "whois.yalta.ua", e, f},
	{"zaporizhzhe.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ho1.eunic.net.ua", "ns.dn.ua", "ns.kh.ua", "ns.sm.ua", "ns.zp.ua"}, n, n, n, e, e, f},
	{"zhitomir.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "impuls.zhitomir.ua", "nix.ns.ua"}, n, n, n, e, e, f},
	{"zp.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ho1.eunic.net.ua", "ns.dn.ua", "ns.kh.ua", "ns.sm.ua", "ns.zp.ua"}, n, n, n, e, e, f},
	{"zt.ua", &z[1442], x, 0, "http://www.nic.net.ua/", w{"ba1.ns.ua", "impuls.zhitomir.ua", "nix.ns.ua"}, n, n, n, e, e, f},
	{"ac.ug", &z[1446], x, 0, e, n, n, n, n, e, e, f},
	{"co.ug", &z[1446], x, 0, e, n, n, n, n, e, e, f},
	{"com.ug", &z[1446], x, 0, e, n, n, n, n, e, e, f},
	{"go.ug", &z[1446], x, 0, e, n, n, n, n, e, e, f},
	{"mil.ug", &z[1446], x, 0, e, n, n, n, n, e, e, f},
	{"ne.ug", &z[1446], x, 0, e, n, n, n, n, e, e, f},
	{"or.ug", &z[1446], x, 0, e, n, n, n, n, e, e, f},
	{"org.ug", &z[1446], x, 0, e, n, n, n, n, e, e, f},
	{"sc.ug", &z[1446], x, 0, e, n, n, n, n, e, e, f},
	{"ac.uk", &z[1447], x, 0, e, w{"auth03.ns.uu.net", "dns-3.dfn.de", "ns0.ja.net", "ns1.surfnet.nl", "ns2.ja.net", "ns3.ja.net", "ns4.ja.net"}, n, n, n, "whois.ja.net", e, f},
	{"co.uk", &z[1447], x, 0, e, w{"dns1.nic.uk", "dns2.nic.uk", "dns3.nic.uk", "dns4.nic.uk", "nsa.nic.uk", "nsb.nic.uk", "nsc.nic.uk", "nsd.nic.uk"}, n, n, n, "whois.nic.uk", e, f},
	{"gov.uk", &z[1447], x, 0, e, w{"auth00.ns.de.uu.net", "auth50.ns.de.uu.net", "ns0.ja.net", "ns1.surfnet.nl", "ns2.ja.net", "ns3.ja.net", "ns4.ja.net"}, n, n, n, "whois.ja.net", e, f},
	{"ltd.uk", &z[1447], x, 0, e, w{"dns1.nic.uk", "dns2.nic.uk", "dns3.nic.uk", "dns4.nic.uk", "nsa.nic.uk", "nsb.nic.uk", "nsc.nic.uk", "nsd.nic.uk"}, n, n, n, e, e, f},
	{"me.uk", &z[1447], x, 0, e, w{"dns1.nic.uk", "dns2.nic.uk", "dns3.nic.uk", "dns4.nic.uk", "nsa.nic.uk", "nsb.nic.uk", "nsc.nic.uk", "nsd.nic.uk"}, n, n, n, e, e, f},
	{"mod.uk", &z[1447], x, 0, e, w{"ns1.cs.ucl.ac.uk", "ns1.mod.uk", "ns2.mod.uk"}, n, n, n, e, e, f},
	{"net.uk", &z[1447], x, 0, e, w{"dns1.nic.uk", "dns2.nic.uk", "dns3.nic.uk", "dns4.nic.uk", "nsa.nic.uk", "nsb.nic.uk", "nsc.nic.uk", "nsd.nic.uk"}, n, n, n, e, e, f},
	{"org.uk", &z[1447], x, 0, e, w{"dns1.nic.uk", "dns2.nic.uk", "dns3.nic.uk", "dns4.nic.uk", "nsa.nic.uk", "nsb.nic.uk", "nsc.nic.uk", "nsd.nic.uk"}, n, n, n, e, e, f},
	{"plc.uk", &z[1447], x, 0, e, w{"dns1.nic.uk", "dns2.nic.uk", "dns3.nic.uk", "dns4.nic.uk", "nsa.nic.uk", "nsb.nic.uk", "nsc.nic.uk", "nsd.nic.uk"}, n, n, n, e, e, f},
	{"sch.uk", &z[1447], z[5167:5182], 0, e, w{"dns1.nic.uk", "dns2.nic.uk", "dns3.nic.uk", "dns4.nic.uk", "nsa.nic.uk", "nsb.nic.uk", "nsc.nic.uk", "nsd.nic.uk"}, n, n, n, e, e, f},
	{"ak.us", &z[1457], x, 0, "https://doa.alaska.gov/ets/eash/DNSrequestform.html", n, n, n, n, e, e, t},
	{"al.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"ar.us", &z[1457], x, 0, e, n, n, n, n, e, e, t},
	{"as.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"az.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"ca.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"co.us", &z[1457], x, 0x800, e, n, n, n, n, e, e, f},
	{"ct.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"dc.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"de.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"dni.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"fed.us", &z[1457], x, 0, e, w{"a.gov-servers.net", "b.gov-servers.net", "c.gov-servers.net", "d.gov-servers.net"}, n, n, n, "whois.dotgov.gov", e, f},
	{"fl.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"ga.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"gu.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"hi.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"ia.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"id.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"il.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"in.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"isa.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"kids.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"ks.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"ky.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"la.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"ma.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"md.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"me.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"mi.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"mn.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"mo.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"ms.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"mt.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"nc.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"nd.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"ne.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"nh.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"nj.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"nm.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"nsn.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"nv.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"ny.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"oh.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"ok.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"or.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"pa.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"pr.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"ri.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"sc.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"sd.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"tn.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"tx.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"ut.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"va.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"vi.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"vt.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"wa.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"wi.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"wv.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"wy.us", &z[1457], x, 0, e, n, n, n, n, e, e, f},
	{"com.uy", &z[1458], x, 0, e, w{"ns1.anteldata.com.uy", "ns2.anteldata.com.uy", "seciu.edu.uy"}, n, n, n, e, e, f},
	{"edu.uy", &z[1458], x, 0, e, w{"a.lactld.org", "ns.dns.br", "ns1.anteldata.com.uy", "ns2.anteldata.com.uy", "ns3.nic.mx", "seciu.edu.uy", "ultra.edu.uy"}, n, n, n, e, e, f},
	{"gub.uy", &z[1458], x, 0, e, w{"a.lactld.org", "ns.dns.br", "ns1.anteldata.com.uy", "ns2.anteldata.com.uy", "ns3.nic.mx", "seciu.edu.uy", "ultra.edu.uy"}, n, n, n, e, e, f},
	{"mil.uy", &z[1458], x, 0, e, w{"a.lactld.org", "ns.dns.br", "ns1.anteldata.com.uy", "ns2.anteldata.com.uy", "ns3.nic.mx", "seciu.edu.uy", "ultra.edu.uy"}, n, n, n, e, e, f},
	{"net.uy", &z[1458], x, 0, e, w{"a.lactld.org", "ns.dns.br", "ns1.anteldata.com.uy", "ns2.anteldata.com.uy", "ns3.nic.mx", "seciu.edu.uy", "ultra.edu.uy"}, n, n, n, e, e, f},
	{"org.uy", &z[1458], x, 0, e, w{"a.lactld.org", "ns.dns.br", "ns1.anteldata.com.uy", "ns2.anteldata.com.uy", "ns3.nic.mx", "seciu.edu.uy", "ultra.edu.uy"}, n, n, n, e, e, f},
	{"ac.uz", &z[1459], x, 0, e, w{"ns1.sarkor.uz", "ns2.sarkor.uz"}, n, n, n, e, e, f},
	{"aero.uz", &z[1459], x, 0, e, w{"ns3.uzinfocom.uz", "rdns3.uzinfocom.uz"}, n, n, n, e, e, f},
	{"biz.uz", &z[1459], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, n, n, n, e, e, f},
	{"co.uz", &z[1459], x, 0, e, w{"ns1.reg.uz", "ns2.reg.uz"}, n, n, n, e, e, f},
	{"com.uz", &z[1459], x, 0, e, w{"ns1.reg.uz", "ns2.reg.uz"}, n, n, n, e, e, f},
	{"coop.uz", &z[1459], x, 0, e, w{"ns3.uzinfocom.uz", "rdns3.uzinfocom.uz"}, n, n, n, e, e, f},
	{"edu.uz", &z[1459], x, 0, e, w{"dns1.webspace.uz", "dns2.webspace.uz"}, n, n, n, e, e, f},
	{"info.uz", &z[1459], x, 0, e, w{"ns.ol.uz", "ns.tshtt.uz"}, n, n, n, e, e, f},
	{"int.uz", &z[1459], x, 0, e, w{"ns3.uzinfocom.uz", "rdns3.uzinfocom.uz"}, n, n, n, e, e, f},
	{"museum.uz", &z[1459], x, 0, e, n, n, n, n, e, e, f},
	{"name.uz", &z[1459], x, 0, e, w{"ns1.billur.com", "ns2.billur.com"}, n, n, n, e, e, f},
	{"net.uz", &z[1459], x, 0, e, w{"ns1.reg.uz", "ns2.reg.uz"}, n, n, n, e, e, f},
	{"org.uz", &z[1459], x, 0, e, w{"ns1.reg.uz", "ns2.reg.uz"}, n, n, n, e, e, f},
	{"pro.uz", &z[1459], x, 0x8, e, w{"ns3.uzinfocom.uz", "rdns3.uzinfocom.uz"}, n, n, n, e, e, f},
	{"com.vc", &z[1465], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"net.vc", &z[1465], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"org.vc", &z[1465], x, 0, e, w{"a0.cctld.afilias-nst.info", "a2.cctld.afilias-nst.info", "b0.cctld.afilias-nst.org", "b2.cctld.afilias-nst.org", "c0.cctld.afilias-nst.info", "d0.cctld.afilias-nst.org"}, n, n, n, e, e, f},
	{"co.ve", &z[1466], x, 0, e, w{"ns3.nic.ve", "ns4.nic.ve", "ns5.nic.ve", "ns6.nic.ve", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"com.ve", &z[1466], x, 0, e, w{"ns3.nic.ve", "ns4.nic.ve", "ns5.nic.ve", "ns6.nic.ve", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"edu.ve", &z[1466], x, 0, e, w{"ns3.nic.ve", "ns4.nic.ve", "ns5.nic.ve", "ns6.nic.ve", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"gob.ve", &z[1466], x, 0, e, w{"ns3.nic.ve", "ns4.nic.ve", "ns5.nic.ve", "ns6.nic.ve", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"info.ve", &z[1466], x, 0, e, w{"ns3.nic.ve", "ns4.nic.ve", "ns5.nic.ve", "ns6.nic.ve", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"int.ve", &z[1466], x, 0, e, w{"ns3.nic.ve", "ns4.nic.ve", "ns5.nic.ve", "ns6.nic.ve", "ssdns-tld.nic.cl"}, n, n, n, e, e, t},
	{"mil.ve", &z[1466], x, 0, e, w{"ns3.nic.ve", "ns4.nic.ve", "ns5.nic.ve", "ns6.nic.ve", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"net.ve", &z[1466], x, 0, e, w{"ns3.nic.ve", "ns4.nic.ve", "ns5.nic.ve", "ns6.nic.ve", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"org.ve", &z[1466], x, 0, e, w{"ns3.nic.ve", "ns4.nic.ve", "ns5.nic.ve", "ns6.nic.ve", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"tec.ve", &z[1466], x, 0, e, w{"ns3.nic.ve", "ns4.nic.ve", "ns5.nic.ve", "ns6.nic.ve", "ssdns-tld.nic.cl"}, n, n, n, e, e, t},
	{"web.ve", &z[1466], x, 0, e, w{"ns3.nic.ve", "ns4.nic.ve", "ns5.nic.ve", "ns6.nic.ve", "ssdns-tld.nic.cl"}, n, n, n, e, e, f},
	{"pro.vg", &z[1474], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, w{"144.76.162.245", "pro.vg"}, n, n, e, e, t},
	{"biz.vi", &z[1475], x, 0, e, n, n, n, n, e, e, f},
	{"co.vi", &z[1475], x, 0, e, w{"ns3.nic.vi", "pch.nic.vi"}, n, n, n, e, e, f},
	{"com.vi", &z[1475], x, 0, e, w{"ns3.nic.vi", "pch.nic.vi"}, n, n, n, e, e, t},
	{"k12.vi", &z[1475], x, 0, e, w{"ns3.nic.vi", "pch.nic.vi"}, n, n, n, e, e, f},
	{"net.vi", &z[1475], x, 0, e, w{"ns3.nic.vi", "pch.nic.vi"}, n, n, n, e, e, f},
	{"org.vi", &z[1475], x, 0, e, w{"ns3.nic.vi", "pch.nic.vi"}, n, n, n, e, e, f},
	{"ac.vn", &z[1491], x, 0, e, w{"a.dns-servers.vn", "b.dns-servers.vn", "c.dns-servers.vn", "d.dns-servers.vn", "e.dns-servers.vn", "f.dns-servers.vn", "g.dns-servers.vn"}, n, n, n, e, e, f},
	{"biz.vn", &z[1491], x, 0, e, w{"a.dns-servers.vn", "b.dns-servers.vn", "c.dns-servers.vn", "d.dns-servers.vn", "e.dns-servers.vn", "f.dns-servers.vn", "g.dns-servers.vn"}, n, n, n, e, e, f},
	{"com.vn", &z[1491], x, 0, e, w{"a.dns-servers.vn", "b.dns-servers.vn", "c.dns-servers.vn", "d.dns-servers.vn", "e.dns-servers.vn", "f.dns-servers.vn", "g.dns-servers.vn"}, n, n, n, e, e, f},
	{"edu.vn", &z[1491], x, 0, e, w{"a.dns-servers.vn", "b.dns-servers.vn", "c.dns-servers.vn", "d.dns-servers.vn", "e.dns-servers.vn", "f.dns-servers.vn", "g.dns-servers.vn"}, n, n, n, e, e, f},
	{"gov.vn", &z[1491], x, 0, e, w{"a.dns-servers.vn", "b.dns-servers.vn", "c.dns-servers.vn", "d.dns-servers.vn", "e.dns-servers.vn", "f.dns-servers.vn", "g.dns-servers.vn"}, n, n, n, e, e, f},
	{"health.vn", &z[1491], x, 0, e, w{"a.dns-servers.vn", "b.dns-servers.vn", "c.dns-servers.vn", "d.dns-servers.vn", "e.dns-servers.vn", "f.dns-servers.vn", "g.dns-servers.vn"}, n, n, n, e, e, f},
	{"info.vn", &z[1491], x, 0, e, w{"a.dns-servers.vn", "b.dns-servers.vn", "c.dns-servers.vn", "d.dns-servers.vn", "e.dns-servers.vn", "f.dns-servers.vn", "g.dns-servers.vn"}, n, n, n, e, e, f},
	{"int.vn", &z[1491], x, 0, e, w{"a.dns-servers.vn", "b.dns-servers.vn", "c.dns-servers.vn", "d.dns-servers.vn", "e.dns-servers.vn", "f.dns-servers.vn", "g.dns-servers.vn"}, n, n, n, e, e, f},
	{"name.vn", &z[1491], x, 0, e, w{"a.dns-servers.vn", "b.dns-servers.vn", "c.dns-servers.vn", "d.dns-servers.vn", "e.dns-servers.vn", "f.dns-servers.vn", "g.dns-servers.vn"}, n, n, n, e, e, f},
	{"net.vn", &z[1491], x, 0, e, w{"a.dns-servers.vn", "b.dns-servers.vn", "c.dns-servers.vn", "d.dns-servers.vn", "e.dns-servers.vn", "f.dns-servers.vn", "g.dns-servers.vn"}, n, n, n, e, e, f},
	{"org.vn", &z[1491], x, 0, e, w{"a.dns-servers.vn", "b.dns-servers.vn", "c.dns-servers.vn", "d.dns-servers.vn", "e.dns-servers.vn", "f.dns-servers.vn", "g.dns-servers.vn"}, n, n, n, e, e, f},
	{"pro.vn", &z[1491], x, 0, e, w{"a.dns-servers.vn", "b.dns-servers.vn", "c.dns-servers.vn", "d.dns-servers.vn", "e.dns-servers.vn", "f.dns-servers.vn", "g.dns-servers.vn"}, n, n, n, e, e, f},
	{"co.vu", &z[1500], x, 0, "https://codotvu.co/", w{"ns1.codotvu.com", "ns2.codotvu.com", "ns3.codotvu.com", "ns4.codotvu.com"}, n, n, n, e, e, t},
	{"com.vu", &z[1500], x, 0, e, w{"ns1.neustar.vu", "ns2.neustar.vu", "ns3.neustar.vu", "ns4.neustar.vu"}, n, n, n, e, e, f},
	{"name.vu", &z[1500], x, 0x200, e, w{"ns1.subdomain.com", "ns2.subdomain.com"}, n, n, n, e, e, t},
	{"net.vu", &z[1500], x, 0, e, w{"ns1.neustar.vu", "ns2.neustar.vu", "ns3.neustar.vu", "ns4.neustar.vu"}, n, n, n, e, e, f},
	{"org.vu", &z[1500], x, 0, e, w{"ns1.neustar.vu", "ns2.neustar.vu", "ns3.neustar.vu", "ns4.neustar.vu"}, n, n, n, e, e, f},
	{"com.ws", &z[1539], x, 0, e, w{"ns2.dns.ws", "ns3.dns.ws", "ns4.dns.ws", "ns5.dns.ws", "ns6.dns.ws", "ns7.dns.ws"}, w{"202.4.48.211"}, n, n, e, e, f},
	{"edu.ws", &z[1539], x, 0, e, w{"ns2.dns.ws", "ns3.dns.ws", "ns4.dns.ws", "ns5.dns.ws", "ns6.dns.ws", "ns7.dns.ws"}, w{"202.4.48.211"}, n, n, e, e, f},
	{"gov.ws", &z[1539], x, 0, e, w{"ns2.dns.ws", "ns3.dns.ws", "ns4.dns.ws", "ns5.dns.ws", "ns6.dns.ws", "ns7.dns.ws"}, n, n, n, e, e, f},
	{"net.ws", &z[1539], x, 0, e, w{"ns2.dns.ws", "ns3.dns.ws", "ns4.dns.ws", "ns5.dns.ws", "ns6.dns.ws", "ns7.dns.ws"}, w{"202.4.48.211"}, n, n, e, e, f},
	{"org.ws", &z[1539], x, 0, e, w{"ns2.dns.ws", "ns3.dns.ws", "ns4.dns.ws", "ns5.dns.ws", "ns6.dns.ws", "ns7.dns.ws"}, w{"202.4.48.211"}, n, n, e, e, f},
	{"co.ye", &z[1554], x, 0, e, n, n, n, n, e, e, f},
	{"com.ye", &z[1554], x, 0, e, w{"ns1.yemen.net.ye", "ns2.yemen.net.ye", "pch.nic.ye", "sah1.ye", "sah2.ye"}, n, n, n, e, e, f},
	{"gov.ye", &z[1554], x, 0, e, w{"ns1.yemen.net.ye", "ns2.yemen.net.ye", "pch.nic.ye", "sah1.ye", "sah2.ye"}, n, n, n, e, e, t},
	{"ltd.ye", &z[1554], x, 0, e, n, n, n, n, e, e, f},
	{"me.ye", &z[1554], x, 0, e, w{"ns1.yemen.net.ye", "ns2.yemen.net.ye", "pch.nic.ye", "sah1.ye", "sah2.ye"}, n, n, n, e, e, f},
	{"net.ye", &z[1554], x, 0, e, w{"ns1.yemen.net.ye", "ns2.yemen.net.ye", "pch.nic.ye", "sah1.ye", "sah2.ye"}, n, n, n, e, e, f},
	{"org.ye", &z[1554], x, 0, e, w{"ns1.yemen.net.ye", "ns2.yemen.net.ye", "pch.nic.ye", "sah1.ye", "sah2.ye"}, n, n, n, e, e, f},
	{"plc.ye", &z[1554], x, 0, e, n, n, n, n, e, e, f},
	{"ac.yu", &z[1562], z[5182:5183], 0x800, e, n, n, n, n, e, e, f},
	{"cg.yu", &z[1562], x, 0x800, e, n, n, n, n, e, e, f},
	{"co.yu", &z[1562], x, 0x800, e, n, n, n, n, e, e, t},
	{"edu.yu", &z[1562], x, 0x800, e, n, n, n, n, e, e, f},
	{"gov.yu", &z[1562], x, 0x800, e, n, n, n, n, e, e, f},
	{"org.yu", &z[1562], x, 0x800, e, n, n, n, n, e, e, f},
	{"ac.za", &z[1564], x, 0, e, w{"disa.tenet.ac.za", "ns2us.dns.business", "ns3.dns.business", "ns4.dns.business", "za-ns.anycast.pch.net"}, n, n, n, "whois.ac.za", e, f},
	{"agric.za", &z[1564], x, 0, e, w{"demeter.is.co.za", "jupiter.is.co.za", "titan.is.co.za"}, n, n, n, e, e, f},
	{"alt.za", &z[1564], x, 0, e, w{"mumble.proxima.alt.za", "ns1.iafrica.com", "ns2.iafrica.com", "psg.com", "za-ns.anycast.pch.net"}, n, n, n, e, e, f},
	{"bourse.za", &z[1564], x, 0x800, e, n, n, n, n, e, e, f},
	{"city.za", &z[1564], x, 0, e, n, n, n, n, e, e, f},
	{"co.za", &z[1564], x, 0, e, w{"coza1.dnsnode.net", "ns.coza.net.za", "ns0.is.co.za", "ns2us.dns.business", "ns3.iafrica.com"}, n, n, n, "coza-whois.registry.net.za", e, f},
	{"cybernet.za", &z[1564], x, 0, e, n, n, n, n, e, e, f},
	{"db.za", &z[1564], x, 0x800, e, n, n, n, n, e, e, f},
	{"edu.za", &z[1564], x, 0, e, w{"ns-za.afrinic.net", "ns1.iafrica.com", "ns2.iafrica.com", "za-ns.anycast.pch.net"}, n, n, n, e, e, f},
	{"gov.za", &z[1564], x, 0, e, w{"ns1.gov.za", "ns1.inx.net.za", "ns2.gov.za", "ns2.inx.net.za", "ns3.gov.za", "ns3.inx.net.za"}, n, n, n, "whois.gov.za", e, f},
	{"grondar.za", &z[1564], x, 0, e, w{"grandfather.grondar.org", "ns1.iafrica.com", "ns2.iafrica.com", "rip.psg.com"}, n, n, n, e, e, f},
	{"iaccess.za", &z[1564], x, 0x800, e, n, n, n, n, e, e, f},
	{"imt.za", &z[1564], x, 0x800, e, n, n, n, n, e, e, f},
	{"inca.za", &z[1564], x, 0x800, e, n, n, n, n, e, e, f},
	{"landesign.za", &z[1564], x, 0x800, e, n, n, n, n, e, e, f},
	{"law.za", &z[1564], x, 0, e, w{"ns0.is.co.za", "ns1.dns.net.za", "ns2us.dns.business"}, n, n, n, e, e, f},
	{"mil.za", &z[1564], x, 0, e, w{"ns1.gov.za", "ns2.gov.za", "ns3.gov.za"}, n, n, n, e, e, f},
	{"net.za", &z[1564], x, 0, e, w{"ns0.is.co.za", "za-ns.anycast.pch.net"}, n, n, n, "net-whois.registry.net.za", e, f},
	{"ngo.za", &z[1564], x, 0, e, w{"antares.wisenet.co.za", "ns1.sn.apc.org", "ns2.sn.apc.org"}, n, n, n, e, e, f},
	{"nis.za", &z[1564], x, 0, e, w{"ns1.mywebserver.co.za", "ns2.mywebserver.co.za", "ns3.mywebserver.co.za"}, n, n, n, e, e, f},
	{"nom.za", &z[1564], x, 0, e, w{"ins1.c6dns.com", "ns0.plig.net", "secdns1.posix.co.za", "za-ns.anycast.pch.net"}, n, n, n, e, e, f},
	{"olivetti.za", &z[1564], x, 0x800, e, n, n, n, n, e, e, f},
	{"org.za", &z[1564], x, 0, e, w{"ns0.is.co.za", "ns0.plig.net", "ns3.iafrica.com", "ns4.iafrica.com", "za-ns.anycast.pch.net"}, n, n, n, "org-whois.registry.net.za", e, f},
	{"pix.za", &z[1564], x, 0x800, e, n, n, n, n, e, e, f},
	{"school.za", &z[1564], z[5183:5192], 0, e, w{"ns0.serendipity.org.za", "ochre.school.za", "ucthpx.uct.ac.za"}, n, n, n, e, e, f},
	{"tm.za", &z[1564], x, 0, e, w{"ns0.is.co.za", "ns1.dnsza.co.za", "ns1.iafrica.com", "ns1.lolo.co.za", "ns2.iafrica.com", "ns2.lolo.co.za", "ns3.lolo.co.za", "reaper.org", "sticky.spider.web.za", "za-ns.anycast.pch.net"}, n, n, n, e, e, f},
	{"web.za", &z[1564], x, 0, e, w{"disa.tenet.ac.za", "ns0.is.co.za", "za-ns.anycast.pch.net"}, n, n, n, "web-whois.registry.net.za", e, f},
	{"ac.zm", &z[1570], x, 0, e, w{"cocca.nic.zm", "gransy.nic.zm", "pch.nic.zm"}, n, n, n, e, e, f},
	{"co.zm", &z[1570], x, 0, e, w{"cocca.nic.zm", "gransy.nic.zm", "pch.nic.zm"}, n, n, n, e, e, t},
	{"com.zm", &z[1570], x, 0, e, w{"cocca.nic.zm", "gransy.nic.zm", "pch.nic.zm"}, n, n, n, e, e, f},
	{"edu.zm", &z[1570], x, 0, e, w{"cocca.nic.zm", "gransy.nic.zm", "pch.nic.zm"}, n, n, n, e, e, t},
	{"gov.zm", &z[1570], x, 0, e, w{"cocca.nic.zm", "gransy.nic.zm", "pch.nic.zm"}, n, n, n, e, e, t},
	{"net.zm", &z[1570], x, 0, e, w{"cocca.nic.zm", "pch.nic.zm"}, n, n, n, e, e, t},
	{"org.zm", &z[1570], x, 0, e, w{"cocca.nic.zm", "gransy.nic.zm", "pch.nic.zm"}, n, n, n, e, e, f},
	{"sch.zm", &z[1570], x, 0, e, w{"cocca.nic.zm", "gransy.nic.zm", "pch.nic.zm"}, n, n, n, e, e, t},
	{"ac.zw", &z[1574], x, 0, e, w{"ns1.liquidtelecom.net", "ns2.liquidtelecom.net", "uofzns01.uz.ac.zw", "uofzns02.uz.ac.zw"}, n, n, n, e, e, f},
	{"co.zw", &z[1574], x, 0, e, w{"ns1.liquidtelecom.net", "ns1.zispa.org.zw", "ns2.liquidtelecom.net", "ns3.zispa.org.zw"}, n, n, n, e, e, t},
	{"com.zw", &z[1574], x, 0, e, n, n, n, n, e, e, t},
	{"org.zw", &z[1574], x, 0, e, w{"ns1.liquidtelecom.net", "ns1zim.telone.co.zw", "ns2.liquidtelecom.net", "ns2zim.telone.co.zw", "zw-ns.anycast.pch.net"}, n, n, n, e, e, f},
	{"001.xn--p1acf" /* 001.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"002.xn--p1acf" /* 002.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"003.xn--p1acf" /* 003.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"004.xn--p1acf" /* 004.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"005.xn--p1acf" /* 005.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"006.xn--p1acf" /* 006.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"007.xn--p1acf" /* 007.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"008.xn--p1acf" /* 008.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"009.xn--p1acf" /* 009.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"010.xn--p1acf" /* 010.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"011.xn--p1acf" /* 011.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"012.xn--p1acf" /* 012.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"013.xn--p1acf" /* 013.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"014.xn--p1acf" /* 014.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"015.xn--p1acf" /* 015.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"016.xn--p1acf" /* 016.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"017.xn--p1acf" /* 017.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"018.xn--p1acf" /* 018.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"019.xn--p1acf" /* 019.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"021.xn--p1acf" /* 021.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"022.xn--p1acf" /* 022.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"023.xn--p1acf" /* 023.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"024.xn--p1acf" /* 024.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"025.xn--p1acf" /* 025.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"026.xn--p1acf" /* 026.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"027.xn--p1acf" /* 027.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"028.xn--p1acf" /* 028.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"029.xn--p1acf" /* 029.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"030.xn--p1acf" /* 030.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"031.xn--p1acf" /* 031.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"032.xn--p1acf" /* 032.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"033.xn--p1acf" /* 033.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"034.xn--p1acf" /* 034.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"035.xn--p1acf" /* 035.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"036.xn--p1acf" /* 036.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"037.xn--p1acf" /* 037.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"038.xn--p1acf" /* 038.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"039.xn--p1acf" /* 039.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"040.xn--p1acf" /* 040.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"041.xn--p1acf" /* 041.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"042.xn--p1acf" /* 042.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"043.xn--p1acf" /* 043.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"044.xn--p1acf" /* 044.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"045.xn--p1acf" /* 045.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"046.xn--p1acf" /* 046.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"047.xn--p1acf" /* 047.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"048.xn--p1acf" /* 048.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"049.xn--p1acf" /* 049.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"050.xn--p1acf" /* 050.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"051.xn--p1acf" /* 051.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"052.xn--p1acf" /* 052.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"053.xn--p1acf" /* 053.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"054.xn--p1acf" /* 054.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"055.xn--p1acf" /* 055.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"056.xn--p1acf" /* 056.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"057.xn--p1acf" /* 057.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"058.xn--p1acf" /* 058.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"059.xn--p1acf" /* 059.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"060.xn--p1acf" /* 060.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"061.xn--p1acf" /* 061.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"062.xn--p1acf" /* 062.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"063.xn--p1acf" /* 063.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"064.xn--p1acf" /* 064.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"065.xn--p1acf" /* 065.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"066.xn--p1acf" /* 066.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"067.xn--p1acf" /* 067.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"068.xn--p1acf" /* 068.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"069.xn--p1acf" /* 069.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"070.xn--p1acf" /* 070.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"071.xn--p1acf" /* 071.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"072.xn--p1acf" /* 072.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"073.xn--p1acf" /* 073.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"074.xn--p1acf" /* 074.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"075.xn--p1acf" /* 075.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"076.xn--p1acf" /* 076.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"077.xn--p1acf" /* 077.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"078.xn--p1acf" /* 078.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"079.xn--p1acf" /* 079.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"083.xn--p1acf" /* 083.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"086.xn--p1acf" /* 086.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"087.xn--p1acf" /* 087.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"089.xn--p1acf" /* 089.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"094.xn--p1acf" /* 094.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"095.xn--p1acf" /* 095.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aaac0ct.xn--p1acf" /* абакан.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80ae0bp.xn--p1acf" /* авто.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80awd.xn--p1acf" /* алм.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aa1ag9a.xn--p1acf" /* алтай.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aam8ar9di.xn--p1acf" /* анадырь.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aaa5csg.xn--p1acf" /* астана.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aaa6cmfh0a9d.xn--p1acf" /* астрахань.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80ag7c.xn--p1acf" /* ахг.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80ab2azb.xn--p1acf" /* баку.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aab6birx.xn--p1acf" /* барнаул.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--90ais.xn--p1acf" /* бел.рус */, &z[1590], x, 0x200, e, w{"ns1.gohost.ru", "ns2.gohost.ru"}, n, n, n, e, e, t},
	{"xn--90aedc4atap.xn--p1acf" /* белгород.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--90amc.xn--p1acf" /* биз.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, w{"77.221.159.235"}, n, n, e, e, t},
	{"xn--80abamkjb7bdt.xn--p1acf" /* биробиджан.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--90aiiib5f.xn--p1acf" /* бишкек.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80abedla9acxg1b7f.xn--p1acf" /* благовещенск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--90aayernio.xn--p1acf" /* бобруйск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--90ai6aff.xn--p1acf" /* брест.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--90asilg6f.xn--p1acf" /* брянск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--90aoxid7ec.xn--p1acf" /* бурятия.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--b1aadecsaihi0amca3a.xn--p1acf" /* великийновгород.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--b1amjiu8dp.xn--p1acf" /* вильнюс.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--90abjlm5be.xn--p1acf" /* витебск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80adbhunc2aa3al.xn--p1acf" /* владивосток.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aaafckyesce.xn--p1acf" /* владикавказ.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80adhqaok7a.xn--p1acf" /* владимир.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80add5ao.xn--p1acf" /* волга.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80addag2buct.xn--p1acf" /* волгоград.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80adde7arb.xn--p1acf" /* вологда.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--b1agd0aean.xn--p1acf" /* воронеж.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--c1aescj1g.xn--p1acf" /* гомель.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--c1ac1acci.xn--p1acf" /* гродно.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--c1aigpdl4f.xn--p1acf" /* грозный.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--e1aky.xn--p1acf" /* ект.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80adia6bo.xn--p1acf" /* ереван.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80adbv1agb.xn--p1acf" /* иваново.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--b1afchn5b.xn--p1acf" /* ижевск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--h1aeawgfg.xn--p1acf" /* иркутск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aauks4g.xn--p1acf" /* казань.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aaifraljtb8a.xn--p1acf" /* калининград.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aai0ag2c.xn--p1acf" /* калуга.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--b1afaslnbn.xn--p1acf" /* кемерово.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--b1afih.xn--p1acf" /* киев.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--b1alfrj.xn--p1acf" /* киров.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--b1afiaiu9e.xn--p1acf" /* кишинев.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--j1aef.xn--p1acf" /* ком.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--h1adgh.xn--p1acf" /* коми.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80atghalgi.xn--p1acf" /* кострома.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aalwqglfe.xn--p1acf" /* краснодар.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80atblfjdfd2l.xn--p1acf" /* красноярск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--j1ael8b.xn--p1acf" /* крым.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80afuomr.xn--p1acf" /* курган.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--j1aarei.xn--p1acf" /* курск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--g1afe6db.xn--p1acf" /* кызыл.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--e1afhbv7b.xn--p1acf" /* липецк.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aaakg8bm.xn--p1acf" /* магадан.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aai8a2a.xn--p1acf" /* магас.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80asdfng.xn--p1acf" /* майкоп.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aqdibz7g.xn--p1acf" /* марийэл.рус */, &z[1590], x, 0x200, e, w{"ns1.nameself.com", "ns2.nameself.com"}, n, n, n, e, e, t},
	{"xn--80aqjbv3f.xn--p1acf" /* мариэл.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aaaa2chc7eta.xn--p1acf" /* махачкала.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--d1abu.xn--p1acf" /* мед.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--h1aeefu.xn--p1acf" /* минск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--h1ahn.xn--p1acf" /* мир.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--b1abpmcm0l.xn--p1acf" /* могилёв.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--j1adp.xn--p1acf" /* мск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aueagpkl.xn--p1acf" /* мурманск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aqgci6d8a.xn--p1acf" /* нальчик.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn----7sbb1ccbue7h4a.xn--p1acf" /* нарьян-мар.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--b1avn.xn--p1acf" /* нвс.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--m1aa.xn--p1acf" /* нн.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--90absbknhbvge.xn--p1acf" /* новосибирск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--j1adfn.xn--p1acf" /* омск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--c1avg.xn--p1acf" /* орг.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--90aee6admdx.xn--p1acf" /* оренбург.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--k1afg2e.xn--p1acf" /* орёл.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80ajgxi.xn--p1acf" /* пенза.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--e1aohf5d.xn--p1acf" /* пермь.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aegbkvxddlre.xn--p1acf" /* петрозаводск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--b1apmck.xn--p1acf" /* псков.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--c1ajhpcjhd0j.xn--p1acf" /* пятигорск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80afo5a.xn--p1acf" /* рига.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn-----7kcgn5cdbagnnnx.xn--p1acf" /* ростов-на-дону.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--b1a1ade.xn--p1acf" /* рств.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80antj7do.xn--p1acf" /* рязань.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aamc3a6ac9a.xn--p1acf" /* салехард.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aaa0cvac.xn--p1acf" /* самара.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aa4alnee.xn--p1acf" /* саранск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aag1ciek.xn--p1acf" /* саратов.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80adi0aoagldk8i.xn--p1acf" /* севастополь.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--90anb6ab4e.xn--p1acf" /* сибирь.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--e1afkclaggf6a2g.xn--p1acf" /* симферополь.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--e1akbdhdtf.xn--p1acf" /* смоленск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--h1aliz.xn--p1acf" /* сочи.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--90a1af.xn--p1acf" /* спб.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80ae1alafffj1i.xn--p1acf" /* ставрополь.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aqialz.xn--p1acf" /* таллин.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80acd2blu.xn--p1acf" /* тамбов.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80akonve2b.xn--p1acf" /* ташкент.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--b1ag7af7c.xn--p1acf" /* тверь.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--j1adfnc.xn--p1acf" /* томск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80avue.xn--p1acf" /* тула.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--p1add.xn--p1acf" /* тур.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--e1aner7ci.xn--p1acf" /* тюмень.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--b1aqbiftj7e1a.xn--p1acf" /* ульяновск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80a1bd.xn--p1acf" /* уфа.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aacf4bwnk3a.xn--p1acf" /* хабаровск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80ablvtof7b4b.xn--p1acf" /* чебоксары.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--90ahkico2a6b9d.xn--p1acf" /* челябинск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--e1aaob1aia6b.xn--p1acf" /* черкесск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80ap4as.xn--p1acf" /* чита.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80apizf6d.xn--p1acf" /* элиста.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80af3b0c.xn--p1acf" /* югра.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--41a.xn--p1acf" /* я.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--j1aaude4e.xn--p1acf" /* якутск.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--80aezclli6gta.xn--p1acf" /* ярославль.рус */, &z[1590], x, 0x200, e, w{"ns1.rlnic.ru", "ns2.rlnic.ru"}, n, n, n, e, e, t},
	{"xn--j1aef.xn--p1ai" /* ком.рф */, &z[1591], x, 0x200, e, w{"ns1.nameself.com", "ns2.nameself.com"}, n, n, n, e, e, t},
	{"xn--e1apq.xn--p1ai" /* нет.рф */, &z[1591], x, 0x200, e, w{"ns1.nameself.com", "ns2.nameself.com"}, n, n, n, e, e, t},
	{"xn--c1avg.xn--p1ai" /* орг.рф */, &z[1591], x, 0x200, e, w{"ns1.nameself.com", "ns2.nameself.com"}, n, n, n, e, e, t},
	{"xn--o-btb9b.xn--90a3ac" /* oбр.срб */, &z[1593], x, 0, e, n, n, n, n, e, e, t},
	{"xn--o-htb.xn--90a3ac" /* oд.срб */, &z[1593], x, 0, e, n, n, n, n, e, e, t},
	{"xn--80au.xn--90a3ac" /* ак.срб */, &z[1593], x, 0, e, w{"ban.junis.ni.ac.rs", "gaea.rcub.bg.ac.rs", "ns.etf.bg.ac.rs", "ns.rcub.bg.ac.rs", "ns.unic.kg.ac.rs", "ns1.uns.ac.rs", "ns2.iif.hu", "odisej.telekom.rs"}, n, n, n, e, e, t},
	{"xn--o1ac.xn--90a3ac" /* пр.срб */, &z[1593], x, 0, e, w{"a.nic.rs", "g.nic.rs", "h.nic.rs", "l.nic.rs"}, n, n, n, e, e, t},
	{"xn--o1ach.xn--90a3ac" /* упр.срб */, &z[1593], x, 0, e, w{"dagda1.isp.telekom.rs", "ns1.gov.rs", "ns1.nic.rs", "ns2.gov.rs", "ns3.gov.orion.rs"}, n, n, n, e, e, t},
	{"xn--hhbc1oogwg.xn--mgbbh1a" /* کمپنی.بارت */, &z[1613], x, 0, e, n, n, n, n, e, e, t},
	{"xn--fhbed7t1n.xn--mgbbh1a71e" /* كمپنی.بھارت */, &z[1616], x, 0, e, n, n, n, n, e, e, t},
	{"xn--hhbcm0s3h.xn--mgbgu82a" /* ڪمپني.ڀارت */, &z[1637], x, 0, e, n, n, n, n, e, e, t},
	{"xn--i1b1b4ch5i.xn--h2brj9c" /* कंपनी.भारत */, &z[1641], x, 0, e, n, n, n, n, e, e, t},
	{"xn--i1b4e9bb5a7f.xn--h2breg3eve" /* संस्था.भारतम् */, &z[1642], x, 0, e, n, n, n, n, e, e, t},
	{"xn--11b2bfp5fn6er.xn--h2brj9c8c" /* कोम्पानी.भारोत */, &z[1643], x, 0, e, n, n, n, n, e, e, t},
	{"xn--p5b2bfp1g0b0b.xn--45brj9c" /* কম্পেনি.ভারত */, &z[1646], x, 0, e, n, n, n, n, e, e, t},
	{"xn--p5b2bfp5fh3fra.xn--45brj9c" /* কোম্পানি.ভারত */, &z[1646], x, 0, e, n, n, n, n, e, e, t},
	{"xn--p5b2bfp5fn6er.xn--45br5cyl" /* কোম্পানী.ভাৰত */, &z[1647], x, 0, e, n, n, n, n, e, e, t},
	{"xn--d9b2bf3g1k.xn--s9brj9c" /* ਕੰਪਨੀ.ਭਾਰਤ */, &z[1648], x, 0, e, n, n, n, n, e, e, t},
	{"xn--hdc1b4ch5i.xn--gecrj9c" /* કંપની.ભારત */, &z[1649], x, 0, e, n, n, n, n, e, e, t},
	{"xn--ohc2bfp5fn1g.xn--3hcrj9c" /* କମ୍ପାନୀ.ଭାରତ */, &z[1650], x, 0, e, n, n, n, n, e, e, t},
	{"xn--vlccpku2dp3h.xn--xkc2dl3a5ee0h" /* நிறுவனம்.இந்தியா */, &z[1651], x, 0, e, n, n, n, n, e, e, t},
	{"xn--goc1b4ch5i8a.xn--fpcrj9c3d" /* కంపెనీ.భారత్ */, &z[1655], x, 0, e, n, n, n, n, e, e, t},
	{"xn--3rc1b4ch0i.xn--2scrj9c" /* ಕಂಪನಿ.ಭಾರತ */, &z[1656], x, 0, e, n, n, n, n, e, e, t},
	{"xn--bwc2bah0ipd.xn--rvc1e0am3e" /* കന്പനി.ഭാരതം */, &z[1657], x, 0, e, n, n, n, n, e, e, t},
	{"xn--12co0c3b4eva.xn--o3cw4h" /* ธุรกิจ.ไทย */, &z[1660], x, 0, e, w{"a.thains.co.th", "b.thains.co.th", "p.thains.co.th"}, n, n, n, e, e, t},
	{"xn--gmqw5a.xn--j6w193g" /* 個人.香港 */, &z[1746], x, 0, e, w{"c.hkirc.net.hk", "d.hkirc.net.hk", "t.hkirc.net.hk", "u.hkirc.net.hk", "v.hkirc.net.hk", "x.hkirc.net.hk", "y.hkirc.net.hk", "z.hkirc.net.hk"}, n, n, n, e, e, t},
	{"xn--55qx5d.xn--j6w193g" /* 公司.香港 */, &z[1746], x, 0, e, w{"c.hkirc.net.hk", "d.hkirc.net.hk", "t.hkirc.net.hk", "u.hkirc.net.hk", "v.hkirc.net.hk", "x.hkirc.net.hk", "y.hkirc.net.hk", "z.hkirc.net.hk"}, n, n, n, e, e, t},
	{"xn--mxtq1m.xn--j6w193g" /* 政府.香港 */, &z[1746], x, 0, e, w{"c.hkirc.net.hk", "d.hkirc.net.hk", "t.hkirc.net.hk", "u.hkirc.net.hk", "v.hkirc.net.hk", "x.hkirc.net.hk", "y.hkirc.net.hk", "z.hkirc.net.hk"}, n, n, n, e, e, t},
	{"xn--wcvs22d.xn--j6w193g" /* 教育.香港 */, &z[1746], x, 0, e, w{"c.hkirc.net.hk", "d.hkirc.net.hk", "t.hkirc.net.hk", "u.hkirc.net.hk", "v.hkirc.net.hk", "x.hkirc.net.hk", "y.hkirc.net.hk", "z.hkirc.net.hk"}, n, n, n, e, e, t},
	{"xn--uc0atv.xn--j6w193g" /* 組織.香港 */, &z[1746], x, 0, e, w{"c.hkirc.net.hk", "d.hkirc.net.hk", "t.hkirc.net.hk", "u.hkirc.net.hk", "v.hkirc.net.hk", "x.hkirc.net.hk", "y.hkirc.net.hk", "z.hkirc.net.hk"}, n, n, n, e, e, t},
	{"xn--od0alg.xn--j6w193g" /* 網絡.香港 */, &z[1746], x, 0, e, w{"c.hkirc.net.hk", "d.hkirc.net.hk", "t.hkirc.net.hk", "u.hkirc.net.hk", "v.hkirc.net.hk", "x.hkirc.net.hk", "y.hkirc.net.hk", "z.hkirc.net.hk"}, n, n, n, e, e, t},
	{"lda.co.ao", &z[1813], x, 0, e, w{"ns.inventadomains.com", "ns2.inventadomains.com"}, n, n, n, e, e, t},
	{"sa.co.ao", &z[1813], x, 0, e, n, n, n, n, e, e, t},
	{"esc.edu.ar", &z[1821], x, 0, e, w{"ns1.innova-red.net", "ns2.innova-red.net"}, n, n, n, e, e, t},
	{"act.edu.au", &z[1845], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, t},
	{"nsw.edu.au", &z[1845], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, t},
	{"nt.edu.au", &z[1845], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, t},
	{"qld.edu.au", &z[1845], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, t},
	{"sa.edu.au", &z[1845], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, t},
	{"tas.edu.au", &z[1845], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, t},
	{"vic.edu.au", &z[1845], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, t},
	{"wa.edu.au", &z[1845], x, 0, e, w{"q.au", "r.au", "s.au", "t.au"}, n, n, n, e, e, t},
	{"fed.rep.br", &z[2106], x, 0, e, w{"cdns1.main-hosting.eu", "cdns2.main-hosting.eu"}, n, n, n, e, e, t},
	{"wireless.keyword.cn", &z[2230], x, 0, e, n, n, n, n, e, e, t},
	{"ltd.co.im", &z[2683], x, 0, e, n, n, n, n, e, e, t},
	{"plc.co.im", &z[2683], x, 0, e, n, n, n, n, e, e, t},
	{"lg.gov.ng", &z[3548], x, 0, e, w{"ns1.nic.net.ng", "ns2.nic.net.ng", "ns5.nic.net.ng", "nsa.nic.net.ng"}, n, n, n, e, e, t},
	{"co.net.nz", &z[3756], x, 0, e, w{"ns1.instradns.com", "ns2.instradns.com", "ns3.instradns.com"}, n, n, n, e, e, t},
	{"al.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eu.org"}, n, n, n, e, e, t},
	{"asso.eu.org", &z[3774], x, 0, e, w{"ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"at.eu.org", &z[3774], x, 0, e, w{"ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"au.eu.org", &z[3774], x, 0, e, w{"ns1.eriomem.net", "ns1.eu.org", "ns3.keltia.net"}, n, n, n, e, e, t},
	{"be.eu.org", &z[3774], x, 0, e, w{"ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"bg.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"ca.eu.org", &z[3774], x, 0, e, w{"ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"cd.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"ch.eu.org", &z[3774], x, 0, e, w{"ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org", "ns1.imp.ch", "ns2.imp.ch"}, n, n, n, e, e, t},
	{"cn.eu.org", &z[3774], x, 0, e, w{"ns1.eu.org", "ns3.keltia.net"}, n, n, n, e, e, t},
	{"cy.eu.org", &z[3774], x, 0, e, w{"ns.eu.org", "ns1.absolight.net", "ns1.tee.gr", "ns2.absolight.net", "ns2.tee.gr", "ns3.absolight.net", "ns4.absolight.net"}, n, n, n, e, e, t},
	{"cz.eu.org", &z[3774], x, 0, e, w{"ns1.eriomem.net", "ns1.eu.org", "ns3.keltia.net"}, n, n, n, e, e, t},
	{"de.eu.org", &z[3774], x, 0, e, w{"ns.oberon.net", "ns1.absolight.net", "ns2.absolight.net", "ns2.lf.net", "ns3.absolight.net", "ns4.absolight.net"}, n, n, n, e, e, t},
	{"dk.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"edu.eu.org", &z[3774], x, 0, e, w{"auth1.dns.elm.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"ee.eu.org", &z[3774], x, 0, e, w{"ns1.eriomem.net", "ns1.eu.org", "ns3.keltia.net"}, n, n, n, e, e, t},
	{"es.eu.org", &z[3774], x, 0, e, w{"ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"fi.eu.org", &z[3774], x, 0, e, w{"ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"fr.eu.org", &z[3774], x, 0, e, w{"auth1.dns.elm.net", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"gr.eu.org", &z[3774], x, 0, e, w{"ns.ankh.fr.eu.org", "ns.eu.org", "ns1.absolight.net", "ns1.tee.gr", "ns2.absolight.net", "ns2.tee.gr", "ns3.absolight.net", "ns4.absolight.net"}, n, n, n, e, e, t},
	{"hr.eu.org", &z[3774], x, 0, e, w{"ns1.eriomem.net", "ns1.eu.org", "ns3.keltia.net"}, n, n, n, e, e, t},
	{"hu.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"ie.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"il.eu.org", &z[3774], x, 0, e, w{"ns.eu.org", "ns1.eu.org"}, n, n, n, e, e, t},
	{"in.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"int.eu.org", &z[3774], x, 0, e, w{"ns1.eriomem.net", "ns1.eu.org", "ns3.keltia.net"}, n, n, n, e, e, t},
	{"is.eu.org", &z[3774], x, 0, e, w{"ns1.eriomem.net", "ns1.eu.org", "ns3.keltia.net"}, n, n, n, e, e, t},
	{"it.eu.org", &z[3774], x, 0, e, w{"ns.ankh.fr.eu.org", "ns1.eu.org", "ns3.keltia.net"}, n, n, n, e, e, t},
	{"jp.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"kr.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"lt.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"lu.eu.org", &z[3774], x, 0, e, w{"ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"lv.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"me.eu.org", &z[3774], x, 0, e, w{"ns1.eriomem.net", "ns1.eu.org", "ns3.keltia.net"}, n, n, n, e, e, t},
	{"mk.eu.org", &z[3774], x, 0, e, w{"ns1.eriomem.net", "ns1.eu.org", "ns3.keltia.net"}, n, n, n, e, e, t},
	{"mt.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"my.eu.org", &z[3774], x, 0, e, w{"ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"net.eu.org", &z[3774], x, 0, e, w{"ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"ng.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"nl.eu.org", &z[3774], x, 0, e, w{"auth.dns.suryo.com", "auth1.dns.elm.net", "ns.eu.org", "ns.lf.net", "ns1.elm-consultancy.nl", "ns4.coloclue.net"}, n, n, n, e, e, t},
	{"no.eu.org", &z[3774], x, 0, e, w{"ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"nz.eu.org", &z[3774], x, 0, e, w{"ns1.eriomem.net", "ns1.eu.org", "ns3.keltia.net"}, n, n, n, e, e, t},
	{"pl.eu.org", &z[3774], x, 0, e, w{"ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"pt.eu.org", &z[3774], x, 0, e, w{"ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"ro.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"ru.eu.org", &z[3774], x, 0, e, w{"ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org", "ns3.keltia.net"}, n, n, n, e, e, t},
	{"se.eu.org", &z[3774], x, 0, e, w{"ns1.eriomem.net", "ns1.eu.org", "ns3.keltia.net"}, n, n, n, e, e, t},
	{"si.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"sk.eu.org", &z[3774], x, 0, e, w{"hobbes.bsd-dk.dk", "ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"tr.eu.org", &z[3774], x, 0, e, w{"ns1.eriomem.net", "ns1.eu.org", "ns3.keltia.net"}, n, n, n, e, e, t},
	{"uk.eu.org", &z[3774], x, 0, e, w{"ns1.eriomem.net", "ns1.eu.org", "ns3.keltia.net"}, n, n, n, e, e, t},
	{"us.eu.org", &z[3774], x, 0, e, w{"ns.ankh.fr.eu.org", "ns1.eriomem.net", "ns1.eu.org"}, n, n, n, e, e, t},
	{"co.at.pn", &z[4002], x, 0, e, n, n, n, n, e, e, t},
	{"com.au.pn", &z[4003], x, 0, e, n, n, n, n, e, e, t},
	{"co.uk.pn", &z[4019], x, 0, e, n, n, n, n, e, e, t},
	{"co.at.tc", &z[4399], x, 0, e, n, n, n, n, e, e, t},
	{"com.au.tc", &z[4400], x, 0x800, e, n, n, n, n, e, e, t},
	{"co.uk.tc", &z[4430], x, 0, e, n, n, n, n, e, e, t},
	{"me.uk.tc", &z[4430], x, 0, e, n, n, n, n, e, e, t},
	{"org.uk.tc", &z[4430], x, 0, e, n, n, n, n, e, e, t},
	{"co.at.tt", &z[4537], x, 0, e, n, w{"195.225.236.206"}, n, n, e, e, t},
	{"com.au.tt", &z[4538], x, 0, e, n, n, n, n, e, e, t},
	{"co.uk.tt", &z[4566], x, 0, e, n, n, n, n, e, e, t},
	{"me.uk.tt", &z[4566], x, 0, e, n, n, n, n, e, e, t},
	{"org.uk.tt", &z[4566], x, 0, e, n, n, n, n, e, e, t},
	{"barking-dagenham.sch.uk", &z[4677], x, 0, e, n, n, n, n, e, e, t},
	{"barnet.sch.uk", &z[4677], x, 0, e, n, n, n, n, e, e, t},
	{"barnsley.sch.uk", &z[4677], x, 0, e, n, n, n, n, e, e, t},
	{"bathnes.sch.uk", &z[4677], x, 0, e, n, n, n, n, e, e, t},
	{"beds.sch.uk", &z[4677], x, 0, e, n, n, n, n, e, e, t},
	{"bexley.sch.uk", &z[4677], x, 0, e, n, n, n, n, e, e, t},
	{"bham.sch.uk", &z[4677], x, 0, e, n, n, n, n, e, e, t},
	{"blackburn.sch.uk", &z[4677], x, 0, e, n, n, n, n, e, e, t},
	{"blackpool.sch.uk", &z[4677], x, 0, e, n, n, n, n, e, e, t},
	{"bolton.sch.uk", &z[4677], x, 0, e, n, n, n, n, e, e, t},
	{"bournemouth.sch.uk", &z[4677], x, 0, e, n, n, n, n, e, e, t},
	{"bracknell-forest.sch.uk", &z[4677], x, 0, e, n, n, n, n, e, e, t},
	{"bradford.sch.uk", &z[4677], x, 0, e, n, n, n, n, e, e, t},
	{"brent.sch.uk", &z[4677], x, 0, e, n, n, n, n, e, e, t},
	{"doncaster.sch.uk", &z[4677], x, 0, e, n, n, n, n, e, e, t},
	{"bg.ac.yu", &z[4809], x, 0x800, e, n, n, n, n, e, e, t},
	{"ecape.school.za", &z[4839], x, 0, e, w{"mopani.school.za", "ns0.serendipity.org.za", "ochre.school.za"}, n, n, n, e, e, t},
	{"fs.school.za", &z[4839], x, 0, e, w{"mopani.school.za", "ns0.serendipity.org.za", "nyx.marques.co.za", "ochre.school.za", "ucthpx.uct.ac.za"}, n, n, n, e, e, t},
	{"gp.school.za", &z[4839], x, 0, e, w{"lava.obsidian.co.za", "mopani.school.za", "ns0.serendipity.org.za", "ns2.obsidian.co.za", "ochre.school.za"}, n, n, n, e, e, t},
	{"kzn.school.za", &z[4839], x, 0, e, w{"mopani.school.za", "ns0.serendipity.org.za", "ochre.school.za", "sec.zadns.net", "ucthpx.uct.ac.za"}, n, n, n, e, e, t},
	{"lp.school.za", &z[4839], x, 0, e, w{"lava.obsidian.co.za", "mopani.school.za", "ns0.serendipity.org.za", "ochre.school.za"}, n, n, n, e, e, t},
	{"mpm.school.za", &z[4839], x, 0, e, w{"lava.obsidian.co.za", "mopani.school.za", "ns0.serendipity.org.za", "ochre.school.za"}, n, n, n, e, e, t},
	{"ncape.school.za", &z[4839], x, 0, e, w{"mopani.school.za", "ns0.serendipity.org.za", "ochre.school.za", "ucthpx.uct.ac.za"}, n, n, n, e, e, t},
	{"nw.school.za", &z[4839], x, 0, e, w{"lava.obsidian.co.za", "mopani.school.za", "ns0.serendipity.org.za", "ochre.school.za"}, n, n, n, e, e, t},
	{"wcape.school.za", &z[4839], x, 0, e, w{"mopani.school.za", "ns0.serendipity.org.za", "ochre.school.za", "ucthpx.uct.ac.za"}, n, n, n, e, e, t},
}
