/* Generated automatically by the program 'build/genpreds'
   from the machine description file '/home/arnd/git/gcc/gcc/config/tilegx/tilegx.md'.  */

#ifndef GCC_TM_PREDS_H
#define GCC_TM_PREDS_H

#ifdef HAVE_MACHINE_MODES
extern int general_operand (rtx, machine_mode);
extern int address_operand (rtx, machine_mode);
extern int register_operand (rtx, machine_mode);
extern int pmode_register_operand (rtx, machine_mode);
extern int scratch_operand (rtx, machine_mode);
extern int immediate_operand (rtx, machine_mode);
extern int const_int_operand (rtx, machine_mode);
extern int const_double_operand (rtx, machine_mode);
extern int nonimmediate_operand (rtx, machine_mode);
extern int nonmemory_operand (rtx, machine_mode);
extern int push_operand (rtx, machine_mode);
extern int pop_operand (rtx, machine_mode);
extern int memory_operand (rtx, machine_mode);
extern int indirect_operand (rtx, machine_mode);
extern int ordered_comparison_operator (rtx, machine_mode);
extern int comparison_operator (rtx, machine_mode);
extern int const_zero_operand (rtx, machine_mode);
extern int reg_or_0_operand (rtx, machine_mode);
extern int pointer_operand (rtx, machine_mode);
extern int netreg_operand (rtx, machine_mode);
extern int u6bit_cint_operand (rtx, machine_mode);
extern int u16bit_cint_operand (rtx, machine_mode);
extern int s8bit_cint_operand (rtx, machine_mode);
extern int s16bit_cint_operand (rtx, machine_mode);
extern int u14bit_cint_operand (rtx, machine_mode);
extern int reg_or_cint_operand (rtx, machine_mode);
extern int const_last_symbolic_operand (rtx, machine_mode);
extern int const_symbolic_operand (rtx, machine_mode);
extern int reg_or_v8s8bit_operand (rtx, machine_mode);
extern int reg_or_v4s8bit_operand (rtx, machine_mode);
extern int add_operand (rtx, machine_mode);
extern int reg_or_s8bit_operand (rtx, machine_mode);
extern int reg_or_u5bit_operand (rtx, machine_mode);
extern int reg_or_u6bit_operand (rtx, machine_mode);
extern int and_operand (rtx, machine_mode);
extern int cint_248_operand (rtx, machine_mode);
extern int tls_symbolic_operand (rtx, machine_mode);
extern int tls_gd_symbolic_operand (rtx, machine_mode);
extern int tls_ld_symbolic_operand (rtx, machine_mode);
extern int tls_ie_symbolic_operand (rtx, machine_mode);
extern int tls_le_symbolic_operand (rtx, machine_mode);
extern int nonautoinc_operand (rtx, machine_mode);
extern int nonautoincmem_operand (rtx, machine_mode);
extern int nonautoincmem_general_operand (rtx, machine_mode);
extern int nonautoincmem_nonimmediate_operand (rtx, machine_mode);
extern int move_operand (rtx, machine_mode);
extern int symbolic_operand (rtx, machine_mode);
extern int u16bit_or_const_symbolic_operand (rtx, machine_mode);
extern int call_address_operand (rtx, machine_mode);
extern int call_operand (rtx, machine_mode);
extern int signed_comparison_operator (rtx, machine_mode);
extern int eqne_operator (rtx, machine_mode);
#endif /* HAVE_MACHINE_MODES */

#define CONSTRAINT_NUM_DEFINED_P 1
enum constraint_num
{
  CONSTRAINT__UNKNOWN = 0,
  CONSTRAINT_r,
  CONSTRAINT_R00,
  CONSTRAINT_R01,
  CONSTRAINT_R02,
  CONSTRAINT_R03,
  CONSTRAINT_R04,
  CONSTRAINT_R05,
  CONSTRAINT_R06,
  CONSTRAINT_R07,
  CONSTRAINT_R08,
  CONSTRAINT_R09,
  CONSTRAINT_R10,
  CONSTRAINT_I,
  CONSTRAINT_J,
  CONSTRAINT_K,
  CONSTRAINT_L,
  CONSTRAINT_M,
  CONSTRAINT_N,
  CONSTRAINT_O,
  CONSTRAINT_P,
  CONSTRAINT_m,
  CONSTRAINT_o,
  CONSTRAINT_U,
  CONSTRAINT_p,
  CONSTRAINT_Q,
  CONSTRAINT_S,
  CONSTRAINT_W,
  CONSTRAINT_Y,
  CONSTRAINT_Z0,
  CONSTRAINT_Z1,
  CONSTRAINT_V,
  CONSTRAINT__l,
  CONSTRAINT__g,
  CONSTRAINT_i,
  CONSTRAINT_s,
  CONSTRAINT_n,
  CONSTRAINT_E,
  CONSTRAINT_F,
  CONSTRAINT_X,
  CONSTRAINT_T,
  CONSTRAINT__LIMIT
};

extern enum constraint_num lookup_constraint_1 (const char *);
extern const unsigned char lookup_constraint_array[];

/* Return the constraint at the beginning of P, or CONSTRAINT__UNKNOWN if it
   isn't recognized.  */

static inline enum constraint_num
lookup_constraint (const char *p)
{
  unsigned int index = lookup_constraint_array[(unsigned char) *p];
  return (index == UCHAR_MAX
          ? lookup_constraint_1 (p)
          : (enum constraint_num) index);
}

extern bool (*constraint_satisfied_p_array[]) (rtx);

/* Return true if X satisfies constraint C.  */

static inline bool
constraint_satisfied_p (rtx x, enum constraint_num c)
{
  int i = (int) c - (int) CONSTRAINT_I;
  return i >= 0 && constraint_satisfied_p_array[i] (x);
}

static inline bool
insn_extra_register_constraint (enum constraint_num c)
{
  return c >= CONSTRAINT_r && c <= CONSTRAINT_R10;
}

static inline bool
insn_extra_memory_constraint (enum constraint_num c)
{
  return c >= CONSTRAINT_m && c <= CONSTRAINT_U;
}

static inline bool
insn_extra_address_constraint (enum constraint_num c)
{
  return c >= CONSTRAINT_p && c <= CONSTRAINT_p;
}

static inline void
insn_extra_constraint_allows_reg_mem (enum constraint_num c,
				      bool *allows_reg, bool *allows_mem)
{
  if (c >= CONSTRAINT_Q && c <= CONSTRAINT_Z1)
    return;
  if (c >= CONSTRAINT_V && c <= CONSTRAINT__g)
    {
      *allows_mem = true;
      return;
    }
  (void) c;
  *allows_reg = true;
  *allows_mem = true;
}

static inline size_t
insn_constraint_len (char fc, const char *str ATTRIBUTE_UNUSED)
{
  switch (fc)
    {
    case 'R': return 3;
    case 'Z': return 2;
    default: break;
    }
  return 1;
}

#define CONSTRAINT_LEN(c_,s_) insn_constraint_len (c_,s_)

extern enum reg_class reg_class_for_constraint_1 (enum constraint_num);

static inline enum reg_class
reg_class_for_constraint (enum constraint_num c)
{
  if (insn_extra_register_constraint (c))
    return reg_class_for_constraint_1 (c);
  return NO_REGS;
}

extern bool insn_const_int_ok_for_constraint (HOST_WIDE_INT, enum constraint_num);
#define CONST_OK_FOR_CONSTRAINT_P(v_,c_,s_) \
    insn_const_int_ok_for_constraint (v_, lookup_constraint (s_))

enum constraint_type
{
  CT_REGISTER,
  CT_CONST_INT,
  CT_MEMORY,
  CT_ADDRESS,
  CT_FIXED_FORM
};

static inline enum constraint_type
get_constraint_type (enum constraint_num c)
{
  if (c >= CONSTRAINT_p)
    {
      if (c >= CONSTRAINT_Q)
        return CT_FIXED_FORM;
      return CT_ADDRESS;
    }
  if (c >= CONSTRAINT_m)
    return CT_MEMORY;
  if (c >= CONSTRAINT_I)
    return CT_CONST_INT;
  return CT_REGISTER;
}
#endif /* tm-preds.h */
