/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tools;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.HandlesEvent;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.tools.ActionBeanInfo;
import net.sourceforge.stripes.tools.EventInfo;
import net.sourceforge.stripes.util.Literal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteStructureTool
implements AnnotationProcessor,
AnnotationProcessorFactory {
    public static final String FORMAT_PARAM = "-Astripes.output.format";
    public static final String FILE_PARAM = "-Astripes.output.file";
    protected static final Pattern RETURN_PATTERN = Pattern.compile("return\\s+(new\\s+)?([^;]+);");
    private Set<AnnotationTypeDeclaration> typeDeclarations;
    private AnnotationProcessorEnvironment environment;
    private Map<String, ActionBeanInfo> infos = new TreeMap<String, ActionBeanInfo>();

    public Collection<String> supportedOptions() {
        return Literal.set(FORMAT_PARAM, FILE_PARAM);
    }

    public Collection<String> supportedAnnotationTypes() {
        return Literal.set(DefaultHandler.class.getName(), HandlesEvent.class.getName(), UrlBinding.class.getName());
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> set, AnnotationProcessorEnvironment env) {
        this.typeDeclarations = set;
        this.environment = env;
        return this;
    }

    public void process() {
        AnnotationTypeDeclaration typeDec = this.getTypeDeclaration(UrlBinding.class);
        HashSet<Declaration> declarations = this.environment.getDeclarationsAnnotatedWith(typeDec);
        this.processUrlBindings((Collection<Declaration>)declarations);
        typeDec = this.getTypeDeclaration(DefaultHandler.class);
        declarations = new HashSet<Declaration>();
        declarations.addAll(this.environment.getDeclarationsAnnotatedWith(typeDec));
        typeDec = this.getTypeDeclaration(HandlesEvent.class);
        declarations.addAll(this.environment.getDeclarationsAnnotatedWith(typeDec));
        this.processHandlerAnnotations(declarations);
        PrintStream out = null;
        String filename = this.getOption(FILE_PARAM);
        if (filename == null) {
            out = System.out;
        } else {
            try {
                out = new PrintStream(filename);
            }
            catch (FileNotFoundException fnfe) {
                throw new StripesRuntimeException("Could not open the requested output file for writing. Please check that file '" + filename + "' can be created " + "and/or written to.", fnfe);
            }
        }
        String format = this.getOption(FORMAT_PARAM);
        if (format == null) {
            format = filename != null && filename.endsWith("xml") ? "xml" : "text";
        }
        if ("text".equals(format)) {
            this.printTextFormat(out);
        } else if ("xml".equals(format)) {
            this.printXmlFormat(out);
        } else {
            throw new StripesRuntimeException("Unknown format requested: " + format + ". " + "Supported formats are 'text' and 'xml'.");
        }
    }

    protected String getOption(String name) {
        for (String option : this.environment.getOptions().keySet()) {
            if (!option.startsWith(name)) continue;
            return option.split("=")[1];
        }
        return null;
    }

    protected void processUrlBindings(Collection<Declaration> declarations) {
        for (Declaration declaration : declarations) {
            ClassDeclaration classDec = (ClassDeclaration)declaration;
            ActionBeanInfo info = new ActionBeanInfo();
            info.setClassName(classDec.getQualifiedName());
            info.setUrlBinding((UrlBinding)classDec.getAnnotation(UrlBinding.class));
            this.infos.put(info.getClassName(), info);
        }
    }

    protected void processHandlerAnnotations(Collection<Declaration> declarations) {
        for (Declaration declaration : declarations) {
            HandlesEvent handlesEvent;
            MethodDeclaration methodDec = (MethodDeclaration)declaration;
            ClassDeclaration classDec = (ClassDeclaration)methodDec.getDeclaringType();
            EventInfo event = new EventInfo();
            event.setMethodName(methodDec.getSimpleName());
            DefaultHandler defaultHandler = (DefaultHandler)methodDec.getAnnotation(DefaultHandler.class);
            if (defaultHandler != null) {
                event.setDefaultEvent(true);
            }
            if ((handlesEvent = (HandlesEvent)methodDec.getAnnotation(HandlesEvent.class)) != null) {
                event.setName(handlesEvent.value());
            }
            SortedSet<String> resolutions = this.getResolutions((Declaration)methodDec);
            event.setResolutions(resolutions);
            ActionBeanInfo info = this.infos.get(classDec.getQualifiedName());
            info.addEvent(event);
        }
    }

    protected void printTextFormat(PrintStream out) {
        for (ActionBeanInfo info : this.infos.values()) {
            out.println("URL: " + info.getUrlBinding().value());
            out.println("    ActionBean: " + info.getClassName());
            this.printTextEvent(out, info.getDefaultEvent());
            for (EventInfo event : info.getEvents().values()) {
                this.printTextEvent(out, event);
            }
            out.println("--------------------------------------------------------------");
        }
    }

    protected void printTextEvent(PrintStream out, EventInfo event) {
        if (event != null) {
            out.print("    Event: ");
            out.print(event.getName() == null ? "<no name>" : event.getName());
            out.println(event.isDefaultEvent() ? " (Default)" : "");
            for (String resolution : event.getResolutions()) {
                out.println("        Resolution: " + resolution);
            }
        }
    }

    protected void printXmlFormat(PrintStream out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println();
        out.println("<stripes-application>");
        for (ActionBeanInfo info : this.infos.values()) {
            out.print("    <action-bean class=\"");
            out.print(info.getClassName());
            out.print("\" url-binding=\"");
            out.print(info.getUrlBinding().value());
            out.println("\">");
            this.printXmlEvent(out, info.getDefaultEvent());
            for (EventInfo event : info.getEvents().values()) {
                this.printXmlEvent(out, event);
            }
            out.println("    </action-bean>");
        }
        out.println("</stripes-application>");
    }

    protected void printXmlEvent(PrintStream out, EventInfo event) {
        if (event != null) {
            out.print("        <event name=\"");
            out.print(event.getName() == null ? "" : event.getName());
            out.print("\" default=\"");
            out.print(event.isDefaultEvent());
            out.println("\">");
            for (String resolution : event.getResolutions()) {
                out.print("            <resolution>");
                out.print(resolution);
                out.println("</resolution>");
            }
            out.println("        </event>");
        }
    }

    AnnotationTypeDeclaration getTypeDeclaration(Class<? extends Annotation> type) {
        for (AnnotationTypeDeclaration declaration : this.typeDeclarations) {
            if (!declaration.getQualifiedName().equals(type.getName())) continue;
            return declaration;
        }
        return null;
    }

    private String getCodeFragment(Declaration declaration) {
        try {
            int ch;
            BufferedReader br = new BufferedReader(new FileReader(declaration.getPosition().file()));
            StringBuilder sb = new StringBuilder(512);
            int start = declaration.getPosition().line();
            for (int i = 1; i < start; ++i) {
                br.readLine();
            }
            int braceCount = 0;
            boolean done = false;
            while (!done && (ch = br.read()) != -1) {
                sb.appendCodePoint(ch);
                if (ch == 123) {
                    ++braceCount;
                    continue;
                }
                if (ch != 125) continue;
                done = --braceCount == 0;
            }
            return sb.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Ecountered an IOException while trying to read a fragment of source file: " + declaration.getPosition().file(), ioe);
        }
    }

    SortedSet<String> getResolutions(Declaration declaration) {
        String codeFragment = this.getCodeFragment(declaration);
        Matcher matcher = RETURN_PATTERN.matcher(codeFragment);
        TreeSet<String> resolutions = new TreeSet<String>();
        while (!matcher.hitEnd()) {
            if (!matcher.find()) continue;
            resolutions.add(matcher.group(2));
        }
        return resolutions;
    }
}

