/*
 * Decompiled with CFR 0.152.
 */
package org.freshcookies.security.policy;

import java.io.FilePermission;
import java.net.SocketPermission;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.freshcookies.security.policy.Canonicalizer;

public class CanonicalizerTest
extends TestCase {
    public void testPropertizeCodeSource() throws Exception {
        System.setProperty("foo.home", "/usr/share/java");
        Canonicalizer canonicalizer = new Canonicalizer();
        Certificate[] certs = null;
        Properties props = Canonicalizer.getPathSubstitutions();
        CodeSource cs1 = new CodeSource(new URL("file:/usr/share/java/foo/myjar.jar"), certs);
        CodeSource cs2 = new CodeSource(new URL("file:${foo.home}/foo/myjar.jar"), certs);
        CanonicalizerTest.assertEquals((String)"Codesource matching property", (Object)cs2, (Object)canonicalizer.propertize(cs1, props));
        cs1 = new CodeSource(new URL("file:/usr/local/java/bar/myjar.jar"), certs);
        CanonicalizerTest.assertEquals((String)"Non-matching codesource", (Object)cs1, (Object)canonicalizer.propertize(cs1, props));
    }

    public void testCanonicalizeSocketPermission() {
        Canonicalizer canonicalizer = new Canonicalizer();
        SocketPermission p1 = new SocketPermission("puffin.eng.sun.com:7777", "connect,accept");
        CanonicalizerTest.assertEquals((Object)p1, (Object)canonicalizer.canonicalize(p1));
        p1 = new SocketPermission("127.0.0.1:1024-", "accept,listen");
        SocketPermission p2 = new SocketPermission("localhost:1024-", "accept,listen");
        CanonicalizerTest.assertEquals((Object)p2, (Object)canonicalizer.canonicalize(p1));
        p1 = new SocketPermission("127.0.0.1", "accept,listen");
        p2 = new SocketPermission("localhost", "accept,listen");
        CanonicalizerTest.assertEquals((Object)p2, (Object)canonicalizer.canonicalize(p1));
    }

    public void testCanonicalizeFilePermission() {
        System.setProperty("foo.home", "/usr/share/java");
        Canonicalizer canonicalizer = new Canonicalizer();
        FilePermission p1 = new FilePermission("/Users/arj/test", "read,write");
        CanonicalizerTest.assertEquals((Object)p1, (Object)canonicalizer.canonicalize(p1));
        p1 = new FilePermission("/testDir/../test/foo.txt", "read,write");
        FilePermission p2 = new FilePermission("/test/foo.txt", "read,write");
        CanonicalizerTest.assertEquals((Object)p2, (Object)canonicalizer.canonicalize(p1));
    }

    public void testPropertizeFilePermission() {
        System.setProperty("foo.home", "/usr/share/java");
        Canonicalizer canonicalizer = new Canonicalizer();
        Properties props = Canonicalizer.getPathSubstitutions();
        FilePermission p1 = new FilePermission("/usr/share/java/foo/my.policy", "read");
        FilePermission p2 = new FilePermission("${foo.home}/foo/my.policy", "read");
        CanonicalizerTest.assertEquals((String)"Good prop", (Object)p2, (Object)canonicalizer.propertize(p1, props));
        p1 = new FilePermission("/usr/local/java/bar/my.policy", "read");
        CanonicalizerTest.assertEquals((String)"Bad prop", (Object)p1, (Object)canonicalizer.propertize(p1, props));
    }

    public void testRegex() {
        String file;
        Pattern WEB_INF = Pattern.compile("^(.+/WEB-INF/classes/)(.*)");
        Matcher m = WEB_INF.matcher(file = "/Users/arj/webapps/stripes-examples/WEB-INF/classes/net/sourceforge/stripes/examples/ajax/*");
        if (m.find()) {
            file = String.valueOf(m.group(1)) + "-";
        }
        CanonicalizerTest.assertEquals((String)"/Users/arj/webapps/stripes-examples/WEB-INF/classes/-", (String)file);
        Pattern CLASSES = Pattern.compile("^(.+/.*/classes/)(.*)");
        file = "/Users/arj/server/classes/org/apache/tomcat/util/threads/*";
        m = CLASSES.matcher(file);
        if (m.find()) {
            file = String.valueOf(m.group(1)) + "-";
        }
        CanonicalizerTest.assertEquals((String)"/Users/arj/server/classes/-", (String)file);
    }
}

