/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-indicable.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-indicable
 * @title: IAnjutaIndicable
 * @short_description: Implemented by indicate that indicate a range
 * @see_also:
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-indicable.h
 *
 */

#include "ianjuta-indicable.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_indicable_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-indicable-quark");
	}
	
	return quark;
}

 /**
* ianjuta_indicable_clear:
* @obj: Self
* @err: Error propagation and reporting
*
* Clear all indicators
*
*/
void
ianjuta_indicable_clear (IAnjutaIndicable *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_INDICABLE(obj));
	IANJUTA_INDICABLE_GET_IFACE (obj)->clear (obj, err);
}

/* Default implementation */
static void
ianjuta_indicable_clear_default (IAnjutaIndicable *obj, GError **err)
{
	g_return_if_reached ();
}

 /**
* ianjuta_indicable_set:
* @obj: Self
* @begin_location: Location where the indication should start
* @end_location: Location where the indication should end
* @indicator: the indicator to use
* @err: Error propagation and reporting
*
* Set an indicator
*
*/
void
ianjuta_indicable_set (IAnjutaIndicable *obj, IAnjutaIterable *begin_location,   IAnjutaIterable *end_location,   IAnjutaIndicableIndicator indicator, GError **err)
{
	g_return_if_fail (IANJUTA_IS_INDICABLE(obj));
	g_return_if_fail ((begin_location == NULL) ||IANJUTA_IS_ITERABLE(begin_location));
	g_return_if_fail ((end_location == NULL) ||IANJUTA_IS_ITERABLE(end_location));
	IANJUTA_INDICABLE_GET_IFACE (obj)->set (obj, begin_location, end_location, indicator, err);
}

/* Default implementation */
static void
ianjuta_indicable_set_default (IAnjutaIndicable *obj, IAnjutaIterable *begin_location,   IAnjutaIterable *end_location,   IAnjutaIndicableIndicator indicator, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_indicable_base_init (IAnjutaIndicableIface* klass)
{
	static gboolean initialized = FALSE;

	klass->clear = ianjuta_indicable_clear_default;
	klass->set = ianjuta_indicable_set_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_indicable_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaIndicableIface),
			(GBaseInitFunc) ianjuta_indicable_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaIndicable", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_indicable_indicator_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_INDICABLE_NONE, "IANJUTA_INDICABLE_NONE", "none" }, 
		{ IANJUTA_INDICABLE_IMPORTANT, "IANJUTA_INDICABLE_IMPORTANT", "important" }, 
		{ IANJUTA_INDICABLE_WARNING, "IANJUTA_INDICABLE_WARNING", "warning" }, 
		{ IANJUTA_INDICABLE_CRITICAL, "IANJUTA_INDICABLE_CRITICAL", "critical" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaIndicableIndicator", values);
	}

	return type;
}
