/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc.pict;

import com.kreative.rsrc.pict.PICTInstruction;
import com.kreative.rsrc.pict.PICTUtilities;
import com.kreative.rsrc.pict.Point;
import com.kreative.rsrc.pict.Polygon;
import com.kreative.rsrc.pict.Rect;
import com.kreative.rsrc.pict.Region;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;

public class PICTGraphics {
    public Graphics2D graphics = null;
    public Area clip = null;
    public int fgColor = -16777216;
    public int bgColor = -1;
    public boolean hiliteMode = false;
    public int hiliteColor = -3355393;
    public int opColor = -16777216;
    public long bgPat = 0L;
    public Paint bgPPat = null;
    public int penX = 0;
    public int penY = 0;
    public int penW = 1;
    public int penH = 1;
    public int penMode = 0;
    public long penPat = -1L;
    public Paint penPPat = null;
    public long fillPat = -1L;
    public Paint fillPPat = null;
    public int cornerRadiusW = 16;
    public int cornerRadiusH = 16;
    public String fontName = "Geneva";
    public int fontStyle = 0;
    public int fontSize = 12;
    public int fontMode = 0;
    public float spExtra = 0.0f;
    public int chExtra = 0;
    public float txRatioX = 1.0f;
    public float txRatioY = 1.0f;
    public float penHFrac = 0.5f;
    public float chSpacing = 0.0f;
    public float jsSpace = 0.0f;
    public boolean outlinePreferred = false;
    public boolean preserveGlyph = false;
    public boolean fractionalWidths = false;
    public boolean scalingDisabled = false;
    public Rect lastRect = null;
    public Polygon lastPoly = null;
    public Region lastRgn = null;

    public PICTGraphics() {
        this.graphics = null;
    }

    public PICTGraphics(Graphics2D g) {
        this.graphics = g;
    }

    public Paint getBackgroundPaint() {
        if (this.hiliteMode) {
            return new Color(this.hiliteColor);
        }
        if (this.bgPPat != null) {
            return this.bgPPat;
        }
        if (this.bgPat == 0L) {
            return new Color(this.bgColor);
        }
        if (this.bgPat == -1L) {
            return new Color(this.fgColor);
        }
        BufferedImage bi = new BufferedImage(8, 8, 1);
        long m = Long.MIN_VALUE;
        int y = 0;
        while (y < 8) {
            int x = 0;
            while (x < 8) {
                bi.setRGB(x, y, (this.bgPat & m) == 0L ? this.bgColor : this.fgColor);
                m >>>= 1;
                ++x;
            }
            ++y;
        }
        return new TexturePaint(bi, new Rectangle(0, 0, 8, 8));
    }

    public Paint getPenPaint() {
        if (this.hiliteMode) {
            return new Color(this.hiliteColor);
        }
        if (this.penPPat != null) {
            return this.penPPat;
        }
        if (this.penPat == 0L) {
            return new Color(this.bgColor);
        }
        if (this.penPat == -1L) {
            return new Color(this.fgColor);
        }
        BufferedImage bi = new BufferedImage(8, 8, 1);
        long m = Long.MIN_VALUE;
        int y = 0;
        while (y < 8) {
            int x = 0;
            while (x < 8) {
                bi.setRGB(x, y, (this.penPat & m) == 0L ? this.bgColor : this.fgColor);
                m >>>= 1;
                ++x;
            }
            ++y;
        }
        return new TexturePaint(bi, new Rectangle(0, 0, 8, 8));
    }

    public Paint getFillPaint() {
        if (this.hiliteMode) {
            return new Color(this.hiliteColor);
        }
        if (this.fillPPat != null) {
            return this.fillPPat;
        }
        if (this.fillPat == 0L) {
            return new Color(this.bgColor);
        }
        if (this.fillPat == -1L) {
            return new Color(this.fgColor);
        }
        BufferedImage bi = new BufferedImage(8, 8, 1);
        long m = Long.MIN_VALUE;
        int y = 0;
        while (y < 8) {
            int x = 0;
            while (x < 8) {
                bi.setRGB(x, y, (this.fillPat & m) == 0L ? this.bgColor : this.fgColor);
                m >>>= 1;
                ++x;
            }
            ++y;
        }
        return new TexturePaint(bi, new Rectangle(0, 0, 8, 8));
    }

    public Stroke getStroke() {
        return new BasicStroke((float)(this.penW + this.penH) / 2.0f);
    }

    public Font getFont() {
        switch (this.fontStyle & 3) {
            case 0: {
                return new Font(this.fontName, 0, this.fontSize);
            }
            case 1: {
                return new Font(this.fontName, 1, this.fontSize);
            }
            case 2: {
                return new Font(this.fontName, 2, this.fontSize);
            }
            case 3: {
                return new Font(this.fontName, 3, this.fontSize);
            }
        }
        return new Font(this.fontName, 0, this.fontSize);
    }

    public void setBackgroundPaint(Graphics2D graphics, boolean fillMode) {
        if (graphics != null) {
            graphics.setClip(this.clip);
            graphics.setPaintMode();
            graphics.setPaint(this.getBackgroundPaint());
            graphics.setStroke(fillMode ? new BasicStroke(0.0f) : this.getStroke());
            graphics.setFont(this.getFont());
        }
    }

    public void setPenPaint(Graphics2D graphics, boolean fillMode) {
        if (graphics != null) {
            graphics.setClip(this.clip);
            graphics.setPaintMode();
            graphics.setPaint(this.getPenPaint());
            graphics.setStroke(fillMode ? new BasicStroke(0.0f) : this.getStroke());
            graphics.setFont(this.getFont());
        }
    }

    public void setFillPaint(Graphics2D graphics, boolean fillMode) {
        if (graphics != null) {
            graphics.setClip(this.clip);
            graphics.setPaintMode();
            graphics.setPaint(this.getFillPaint());
            graphics.setStroke(fillMode ? new BasicStroke(0.0f) : this.getStroke());
            graphics.setFont(this.getFont());
        }
    }

    public void setInvertPaint(Graphics2D graphics, boolean fillMode) {
        if (graphics != null) {
            graphics.setClip(this.clip);
            graphics.setPaint(Color.white);
            graphics.setXORMode(Color.black);
            graphics.setStroke(fillMode ? new BasicStroke(0.0f) : this.getStroke());
            graphics.setFont(this.getFont());
        }
    }

    public void executeInstruction(PICTInstruction inst) {
        switch (inst.opcode) {
            case 1: {
                this.clip = ((PICTInstruction.Clip)inst).rgn.toArea();
                break;
            }
            case 2: {
                this.bgPat = ((PICTInstruction.BkPat)inst).pat;
                this.bgPPat = null;
                break;
            }
            case 3: {
                this.fontName = ((PICTInstruction.TxFont)inst).toFontName();
                break;
            }
            case 4: {
                this.fontStyle = ((PICTInstruction.TxFace)inst).style;
                break;
            }
            case 5: {
                this.fontMode = ((PICTInstruction.TxMode)inst).mode;
                break;
            }
            case 6: {
                this.spExtra = ((PICTInstruction.SpExtra)inst).spExtra;
                break;
            }
            case 7: {
                this.penW = ((PICTInstruction.PnSize)inst).penWidth;
                this.penH = ((PICTInstruction.PnSize)inst).penHeight;
                break;
            }
            case 8: {
                this.penMode = ((PICTInstruction.PnMode)inst).mode;
                break;
            }
            case 9: {
                this.penPat = ((PICTInstruction.PnPat)inst).pat;
                this.penPPat = null;
                break;
            }
            case 10: {
                this.fillPat = ((PICTInstruction.FillPat)inst).pat;
                this.fillPPat = null;
                break;
            }
            case 11: {
                this.cornerRadiusW = ((PICTInstruction.OvSize)inst).ovalWidth;
                this.cornerRadiusH = ((PICTInstruction.OvSize)inst).ovalHeight;
                break;
            }
            case 12: {
                this.penX += ((PICTInstruction.Origin)inst).dh;
                this.penY += ((PICTInstruction.Origin)inst).dv;
                break;
            }
            case 13: {
                this.fontSize = ((PICTInstruction.TxSize)inst).size;
                break;
            }
            case 14: {
                this.fgColor = ((PICTInstruction.FgColor)inst).toRGB();
                break;
            }
            case 15: {
                this.bgColor = ((PICTInstruction.BkColor)inst).toRGB();
                break;
            }
            case 16: {
                this.txRatioX = ((PICTInstruction.TxRatio)inst).hnum;
                this.txRatioY = ((PICTInstruction.TxRatio)inst).vnum;
                this.txRatioX /= (float)((PICTInstruction.TxRatio)inst).hdenom;
                this.txRatioY /= (float)((PICTInstruction.TxRatio)inst).vdenom;
                break;
            }
            case 18: {
                PICTInstruction.BkPixPat bkpp = (PICTInstruction.BkPixPat)inst;
                this.bgPat = bkpp.pat1Data;
                if (bkpp.pixMap != null) {
                    BufferedImage bi = PICTUtilities.pixmapToImage(bkpp.pixMap, bkpp.colorTable, bkpp.pixData, this.bgColor, this.fgColor, true, false);
                    this.bgPPat = new TexturePaint(bi, new Rectangle(0, 0, bi.getWidth(), bi.getHeight()));
                    break;
                }
                if (bkpp.rgb != null) {
                    this.bgPPat = bkpp.rgb.toColor();
                    break;
                }
                this.bgPPat = null;
                break;
            }
            case 19: {
                PICTInstruction.PnPixPat pnpp = (PICTInstruction.PnPixPat)inst;
                this.penPat = pnpp.pat1Data;
                if (pnpp.pixMap != null) {
                    BufferedImage bi = PICTUtilities.pixmapToImage(pnpp.pixMap, pnpp.colorTable, pnpp.pixData, this.bgColor, this.fgColor, true, false);
                    this.penPPat = new TexturePaint(bi, new Rectangle(0, 0, bi.getWidth(), bi.getHeight()));
                    break;
                }
                if (pnpp.rgb != null) {
                    this.penPPat = pnpp.rgb.toColor();
                    break;
                }
                this.penPPat = null;
                break;
            }
            case 20: {
                PICTInstruction.FillPixPat fillpp = (PICTInstruction.FillPixPat)inst;
                this.fillPat = fillpp.pat1Data;
                if (fillpp.pixMap != null) {
                    BufferedImage bi = PICTUtilities.pixmapToImage(fillpp.pixMap, fillpp.colorTable, fillpp.pixData, this.bgColor, this.fgColor, true, false);
                    this.fillPPat = new TexturePaint(bi, new Rectangle(0, 0, bi.getWidth(), bi.getHeight()));
                    break;
                }
                if (fillpp.rgb != null) {
                    this.fillPPat = fillpp.rgb.toColor();
                    break;
                }
                this.fillPPat = null;
                break;
            }
            case 21: {
                this.penHFrac = ((PICTInstruction.PnLocHFrac)inst).hfrac;
                break;
            }
            case 22: {
                this.chExtra = ((PICTInstruction.ChExtra)inst).chExtra;
                break;
            }
            case 26: {
                this.fgColor = ((PICTInstruction.RGBFgCol)inst).color.toRGB();
                break;
            }
            case 27: {
                this.bgColor = ((PICTInstruction.RGBBkCol)inst).color.toRGB();
                break;
            }
            case 28: {
                this.hiliteMode = true;
                break;
            }
            case 29: {
                this.hiliteColor = ((PICTInstruction.HiliteColor)inst).color.toRGB();
                break;
            }
            case 30: {
                this.hiliteColor = -3355393;
                break;
            }
            case 31: {
                this.opColor = ((PICTInstruction.OpColor)inst).color.toRGB();
                break;
            }
            case 32: {
                if (this.graphics != null) {
                    this.setPenPaint(this.graphics, false);
                    Point pnLoc = ((PICTInstruction.Line)inst).pnLoc;
                    Point newPt = ((PICTInstruction.Line)inst).newPt;
                    this.graphics.drawLine(pnLoc.x, pnLoc.y, newPt.x, newPt.y);
                }
                this.penX = ((PICTInstruction.Line)inst).newPt.x;
                this.penY = ((PICTInstruction.Line)inst).newPt.y;
                break;
            }
            case 33: {
                if (this.graphics != null) {
                    this.setPenPaint(this.graphics, false);
                    Point newPt = ((PICTInstruction.LineFrom)inst).newPt;
                    this.graphics.drawLine(this.penX, this.penY, newPt.x, newPt.y);
                }
                this.penX = ((PICTInstruction.LineFrom)inst).newPt.x;
                this.penY = ((PICTInstruction.LineFrom)inst).newPt.y;
                break;
            }
            case 34: {
                if (this.graphics != null) {
                    this.setPenPaint(this.graphics, false);
                    Point pnLoc = ((PICTInstruction.ShortLine)inst).pnLoc;
                    int dx = ((PICTInstruction.ShortLine)inst).dh;
                    int dy = ((PICTInstruction.ShortLine)inst).dv;
                    this.graphics.drawLine(pnLoc.x, pnLoc.y, pnLoc.x + dx, pnLoc.y + dy);
                }
                this.penX = ((PICTInstruction.ShortLine)inst).pnLoc.x + ((PICTInstruction.ShortLine)inst).dh;
                this.penY = ((PICTInstruction.ShortLine)inst).pnLoc.y + ((PICTInstruction.ShortLine)inst).dv;
                break;
            }
            case 35: {
                if (this.graphics != null) {
                    this.setPenPaint(this.graphics, false);
                    int dx = ((PICTInstruction.ShortLineFrom)inst).dh;
                    int dy = ((PICTInstruction.ShortLineFrom)inst).dv;
                    this.graphics.drawLine(this.penX, this.penY, this.penX + dx, this.penY + dy);
                }
                this.penX += ((PICTInstruction.ShortLineFrom)inst).dh;
                this.penY += ((PICTInstruction.ShortLineFrom)inst).dv;
                break;
            }
            case 40: {
                if (this.graphics != null) {
                    this.setPenPaint(this.graphics, false);
                    this.graphics.drawString(((PICTInstruction.LongText)inst).text, ((PICTInstruction.LongText)inst).txLoc.x, ((PICTInstruction.LongText)inst).txLoc.y);
                }
                this.penX = ((PICTInstruction.LongText)inst).txLoc.x;
                this.penY = ((PICTInstruction.LongText)inst).txLoc.y;
                break;
            }
            case 41: {
                if (this.graphics != null) {
                    this.setPenPaint(this.graphics, false);
                    this.graphics.drawString(((PICTInstruction.DHText)inst).text, this.penX + ((PICTInstruction.DHText)inst).dh, this.penY);
                }
                this.penX += ((PICTInstruction.DHText)inst).dh;
                break;
            }
            case 42: {
                if (this.graphics != null) {
                    this.setPenPaint(this.graphics, false);
                    this.graphics.drawString(((PICTInstruction.DVText)inst).text, this.penX, this.penY + ((PICTInstruction.DVText)inst).dv);
                }
                this.penY += ((PICTInstruction.DVText)inst).dv;
                break;
            }
            case 43: {
                if (this.graphics != null) {
                    this.setPenPaint(this.graphics, false);
                    this.graphics.drawString(((PICTInstruction.DHDVText)inst).text, this.penX + ((PICTInstruction.DHDVText)inst).dh, this.penY + ((PICTInstruction.DHDVText)inst).dv);
                }
                this.penX += ((PICTInstruction.DHDVText)inst).dh;
                this.penY += ((PICTInstruction.DHDVText)inst).dv;
                break;
            }
            case 44: {
                this.fontName = ((PICTInstruction.FontName)inst).fontName;
                break;
            }
            case 45: {
                this.chSpacing = ((PICTInstruction.LineJustify)inst).spacing;
                this.jsSpace = ((PICTInstruction.LineJustify)inst).spExtra;
                break;
            }
            case 46: {
                this.outlinePreferred = ((PICTInstruction.GlyphState)inst).outlinePreferred;
                this.preserveGlyph = ((PICTInstruction.GlyphState)inst).preserveGlyph;
                this.fractionalWidths = ((PICTInstruction.GlyphState)inst).fractionalWidths;
                this.scalingDisabled = ((PICTInstruction.GlyphState)inst).scalingDisabled;
                break;
            }
            case 48: {
                this.lastRect = ((PICTInstruction.FrameRect)inst).rect;
            }
            case 56: {
                if (this.graphics == null) break;
                this.setPenPaint(this.graphics, false);
                this.graphics.drawRect(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top);
                break;
            }
            case 49: {
                this.lastRect = ((PICTInstruction.PaintRect)inst).rect;
            }
            case 57: {
                if (this.graphics == null) break;
                this.setPenPaint(this.graphics, true);
                this.graphics.fillRect(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top);
                break;
            }
            case 50: {
                this.lastRect = ((PICTInstruction.EraseRect)inst).rect;
            }
            case 58: {
                if (this.graphics == null) break;
                this.setBackgroundPaint(this.graphics, true);
                this.graphics.fillRect(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top);
                break;
            }
            case 51: {
                this.lastRect = ((PICTInstruction.InvertRect)inst).rect;
            }
            case 59: {
                if (this.graphics == null) break;
                this.setInvertPaint(this.graphics, true);
                this.graphics.fillRect(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top);
                break;
            }
            case 52: {
                this.lastRect = ((PICTInstruction.FillRect)inst).rect;
            }
            case 60: {
                if (this.graphics == null) break;
                this.setFillPaint(this.graphics, true);
                this.graphics.fillRect(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top);
                break;
            }
            case 64: {
                this.lastRect = ((PICTInstruction.FrameRRect)inst).rect;
            }
            case 72: {
                if (this.graphics == null) break;
                this.setPenPaint(this.graphics, false);
                this.graphics.drawRoundRect(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top, this.cornerRadiusW, this.cornerRadiusH);
                break;
            }
            case 65: {
                this.lastRect = ((PICTInstruction.PaintRRect)inst).rect;
            }
            case 73: {
                if (this.graphics == null) break;
                this.setPenPaint(this.graphics, true);
                this.graphics.fillRoundRect(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top, this.cornerRadiusW, this.cornerRadiusH);
                break;
            }
            case 66: {
                this.lastRect = ((PICTInstruction.EraseRRect)inst).rect;
            }
            case 74: {
                if (this.graphics == null) break;
                this.setBackgroundPaint(this.graphics, true);
                this.graphics.fillRoundRect(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top, this.cornerRadiusW, this.cornerRadiusH);
                break;
            }
            case 67: {
                this.lastRect = ((PICTInstruction.InvertRRect)inst).rect;
            }
            case 75: {
                if (this.graphics == null) break;
                this.setInvertPaint(this.graphics, true);
                this.graphics.fillRoundRect(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top, this.cornerRadiusW, this.cornerRadiusH);
                break;
            }
            case 68: {
                this.lastRect = ((PICTInstruction.FillRRect)inst).rect;
            }
            case 76: {
                if (this.graphics == null) break;
                this.setFillPaint(this.graphics, true);
                this.graphics.fillRoundRect(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top, this.cornerRadiusW, this.cornerRadiusH);
                break;
            }
            case 80: {
                this.lastRect = ((PICTInstruction.FrameOval)inst).rect;
            }
            case 88: {
                if (this.graphics == null) break;
                this.setPenPaint(this.graphics, false);
                this.graphics.drawOval(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top);
                break;
            }
            case 81: {
                this.lastRect = ((PICTInstruction.PaintOval)inst).rect;
            }
            case 89: {
                if (this.graphics == null) break;
                this.setPenPaint(this.graphics, true);
                this.graphics.fillOval(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top);
                break;
            }
            case 82: {
                this.lastRect = ((PICTInstruction.EraseOval)inst).rect;
            }
            case 90: {
                if (this.graphics == null) break;
                this.setBackgroundPaint(this.graphics, true);
                this.graphics.fillOval(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top);
                break;
            }
            case 83: {
                this.lastRect = ((PICTInstruction.InvertOval)inst).rect;
            }
            case 91: {
                if (this.graphics == null) break;
                this.setInvertPaint(this.graphics, true);
                this.graphics.fillOval(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top);
                break;
            }
            case 84: {
                this.lastRect = ((PICTInstruction.FillOval)inst).rect;
            }
            case 92: {
                if (this.graphics == null) break;
                this.setFillPaint(this.graphics, true);
                this.graphics.fillOval(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top);
                break;
            }
            case 96: {
                this.lastRect = ((PICTInstruction.FrameArc)inst).rect;
            }
            case 104: {
                if (this.graphics == null) break;
                this.setPenPaint(this.graphics, false);
                int startAngle = inst instanceof PICTInstruction.FrameSameArc ? ((PICTInstruction.FrameSameArc)inst).startAngle : ((PICTInstruction.FrameArc)inst).startAngle;
                int arcAngle = inst instanceof PICTInstruction.FrameSameArc ? ((PICTInstruction.FrameSameArc)inst).arcAngle : ((PICTInstruction.FrameArc)inst).arcAngle;
                this.graphics.drawArc(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top, startAngle, arcAngle);
                break;
            }
            case 97: {
                this.lastRect = ((PICTInstruction.PaintArc)inst).rect;
            }
            case 105: {
                if (this.graphics == null) break;
                this.setPenPaint(this.graphics, true);
                int startAngle = inst instanceof PICTInstruction.FrameSameArc ? ((PICTInstruction.FrameSameArc)inst).startAngle : ((PICTInstruction.FrameArc)inst).startAngle;
                int arcAngle = inst instanceof PICTInstruction.FrameSameArc ? ((PICTInstruction.FrameSameArc)inst).arcAngle : ((PICTInstruction.FrameArc)inst).arcAngle;
                this.graphics.fillArc(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top, startAngle, arcAngle);
                break;
            }
            case 98: {
                this.lastRect = ((PICTInstruction.EraseArc)inst).rect;
            }
            case 106: {
                if (this.graphics == null) break;
                this.setBackgroundPaint(this.graphics, true);
                int startAngle = inst instanceof PICTInstruction.FrameSameArc ? ((PICTInstruction.FrameSameArc)inst).startAngle : ((PICTInstruction.FrameArc)inst).startAngle;
                int arcAngle = inst instanceof PICTInstruction.FrameSameArc ? ((PICTInstruction.FrameSameArc)inst).arcAngle : ((PICTInstruction.FrameArc)inst).arcAngle;
                this.graphics.fillArc(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top, startAngle, arcAngle);
                break;
            }
            case 99: {
                this.lastRect = ((PICTInstruction.InvertArc)inst).rect;
            }
            case 107: {
                if (this.graphics == null) break;
                this.setInvertPaint(this.graphics, true);
                int startAngle = inst instanceof PICTInstruction.FrameSameArc ? ((PICTInstruction.FrameSameArc)inst).startAngle : ((PICTInstruction.FrameArc)inst).startAngle;
                int arcAngle = inst instanceof PICTInstruction.FrameSameArc ? ((PICTInstruction.FrameSameArc)inst).arcAngle : ((PICTInstruction.FrameArc)inst).arcAngle;
                this.graphics.fillArc(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top, startAngle, arcAngle);
                break;
            }
            case 100: {
                this.lastRect = ((PICTInstruction.FillArc)inst).rect;
            }
            case 108: {
                if (this.graphics == null) break;
                this.setFillPaint(this.graphics, true);
                int startAngle = inst instanceof PICTInstruction.FrameSameArc ? ((PICTInstruction.FrameSameArc)inst).startAngle : ((PICTInstruction.FrameArc)inst).startAngle;
                int arcAngle = inst instanceof PICTInstruction.FrameSameArc ? ((PICTInstruction.FrameSameArc)inst).arcAngle : ((PICTInstruction.FrameArc)inst).arcAngle;
                this.graphics.fillArc(this.lastRect.left, this.lastRect.top, this.lastRect.right - this.lastRect.left, this.lastRect.bottom - this.lastRect.top, startAngle, arcAngle);
                break;
            }
            case 112: {
                this.lastPoly = ((PICTInstruction.FramePoly)inst).poly;
            }
            case 120: {
                if (this.graphics == null) break;
                this.setPenPaint(this.graphics, false);
                this.graphics.drawPolygon(this.lastPoly.toPolygon());
                break;
            }
            case 113: {
                this.lastPoly = ((PICTInstruction.PaintPoly)inst).poly;
            }
            case 121: {
                if (this.graphics == null) break;
                this.setPenPaint(this.graphics, true);
                this.graphics.fillPolygon(this.lastPoly.toPolygon());
                break;
            }
            case 114: {
                this.lastPoly = ((PICTInstruction.ErasePoly)inst).poly;
            }
            case 122: {
                if (this.graphics == null) break;
                this.setBackgroundPaint(this.graphics, true);
                this.graphics.fillPolygon(this.lastPoly.toPolygon());
                break;
            }
            case 115: {
                this.lastPoly = ((PICTInstruction.InvertPoly)inst).poly;
            }
            case 123: {
                if (this.graphics == null) break;
                this.setInvertPaint(this.graphics, true);
                this.graphics.fillPolygon(this.lastPoly.toPolygon());
                break;
            }
            case 116: {
                this.lastPoly = ((PICTInstruction.FillPoly)inst).poly;
            }
            case 124: {
                if (this.graphics == null) break;
                this.setFillPaint(this.graphics, true);
                this.graphics.fillPolygon(this.lastPoly.toPolygon());
                break;
            }
            case 128: {
                this.lastRgn = ((PICTInstruction.FrameRgn)inst).rgn;
            }
            case 136: {
                if (this.graphics == null) break;
                this.setPenPaint(this.graphics, false);
                this.graphics.draw(this.lastRgn.toArea());
                break;
            }
            case 129: {
                this.lastRgn = ((PICTInstruction.PaintRgn)inst).rgn;
            }
            case 137: {
                if (this.graphics == null) break;
                this.setPenPaint(this.graphics, true);
                this.graphics.fill(this.lastRgn.toArea());
                break;
            }
            case 130: {
                this.lastRgn = ((PICTInstruction.EraseRgn)inst).rgn;
            }
            case 138: {
                if (this.graphics == null) break;
                this.setBackgroundPaint(this.graphics, true);
                this.graphics.fill(this.lastRgn.toArea());
                break;
            }
            case 131: {
                this.lastRgn = ((PICTInstruction.InvertRgn)inst).rgn;
            }
            case 139: {
                if (this.graphics == null) break;
                this.setInvertPaint(this.graphics, true);
                this.graphics.fill(this.lastRgn.toArea());
                break;
            }
            case 132: {
                this.lastRgn = ((PICTInstruction.FillRgn)inst).rgn;
            }
            case 140: {
                if (this.graphics == null) break;
                this.setFillPaint(this.graphics, true);
                this.graphics.fill(this.lastRgn.toArea());
                break;
            }
            case 144: {
                if (this.graphics == null) break;
                this.setFillPaint(this.graphics, true);
                PICTInstruction.BitsRect binst = (PICTInstruction.BitsRect)inst;
                int bx = binst.pixMap.bounds.left;
                int by = binst.pixMap.bounds.top;
                BufferedImage bimg = PICTUtilities.pixmapToImage(binst.pixMap, binst.colorTable, binst.pixData, this.bgColor, this.fgColor, false, true);
                this.graphics.drawImage(bimg, binst.dstRect.left, binst.dstRect.top, binst.dstRect.right, binst.dstRect.bottom, binst.srcRect.left - bx, binst.srcRect.top - by, binst.srcRect.right - bx, binst.srcRect.bottom - by, null);
                break;
            }
            case 145: {
                if (this.graphics == null) break;
                this.setFillPaint(this.graphics, true);
                PICTInstruction.BitsRgn binst = (PICTInstruction.BitsRgn)inst;
                this.graphics.clip(binst.maskRgn.toArea());
                int bx = binst.pixMap.bounds.left;
                int by = binst.pixMap.bounds.top;
                BufferedImage bimg = PICTUtilities.pixmapToImage(binst.pixMap, binst.colorTable, binst.pixData, this.bgColor, this.fgColor, false, true);
                this.graphics.drawImage(bimg, binst.dstRect.left, binst.dstRect.top, binst.dstRect.right, binst.dstRect.bottom, binst.srcRect.left - bx, binst.srcRect.top - by, binst.srcRect.right - bx, binst.srcRect.bottom - by, null);
                break;
            }
            case 152: {
                if (this.graphics == null) break;
                this.setFillPaint(this.graphics, true);
                PICTInstruction.PackBitsRect binst = (PICTInstruction.PackBitsRect)inst;
                int bx = binst.pixMap.bounds.left;
                int by = binst.pixMap.bounds.top;
                BufferedImage bimg = PICTUtilities.pixmapToImage(binst.pixMap, binst.colorTable, binst.pixData, this.bgColor, this.fgColor, false, true);
                this.graphics.drawImage(bimg, binst.dstRect.left, binst.dstRect.top, binst.dstRect.right, binst.dstRect.bottom, binst.srcRect.left - bx, binst.srcRect.top - by, binst.srcRect.right - bx, binst.srcRect.bottom - by, null);
                break;
            }
            case 153: {
                if (this.graphics == null) break;
                this.setFillPaint(this.graphics, true);
                PICTInstruction.PackBitsRgn binst = (PICTInstruction.PackBitsRgn)inst;
                this.graphics.clip(binst.maskRgn.toArea());
                int bx = binst.pixMap.bounds.left;
                int by = binst.pixMap.bounds.top;
                BufferedImage bimg = PICTUtilities.pixmapToImage(binst.pixMap, binst.colorTable, binst.pixData, this.bgColor, this.fgColor, false, true);
                this.graphics.drawImage(bimg, binst.dstRect.left, binst.dstRect.top, binst.dstRect.right, binst.dstRect.bottom, binst.srcRect.left - bx, binst.srcRect.top - by, binst.srcRect.right - bx, binst.srcRect.bottom - by, null);
                break;
            }
            case 154: {
                if (this.graphics == null) break;
                this.setFillPaint(this.graphics, true);
                PICTInstruction.DirectBitsRect binst = (PICTInstruction.DirectBitsRect)inst;
                int bx = binst.pixMap.bounds.left;
                int by = binst.pixMap.bounds.top;
                BufferedImage bimg = PICTUtilities.pixmapToImage(binst.pixMap, null, binst.pixData, this.bgColor, this.fgColor, false, true);
                this.graphics.drawImage(bimg, binst.dstRect.left, binst.dstRect.top, binst.dstRect.right, binst.dstRect.bottom, binst.srcRect.left - bx, binst.srcRect.top - by, binst.srcRect.right - bx, binst.srcRect.bottom - by, null);
                break;
            }
            case 155: {
                if (this.graphics == null) break;
                this.setFillPaint(this.graphics, true);
                PICTInstruction.DirectBitsRgn binst = (PICTInstruction.DirectBitsRgn)inst;
                this.graphics.clip(binst.maskRgn.toArea());
                int bx = binst.pixMap.bounds.left;
                int by = binst.pixMap.bounds.top;
                BufferedImage bimg = PICTUtilities.pixmapToImage(binst.pixMap, null, binst.pixData, this.bgColor, this.fgColor, false, true);
                this.graphics.drawImage(bimg, binst.dstRect.left, binst.dstRect.top, binst.dstRect.right, binst.dstRect.bottom, binst.srcRect.left - bx, binst.srcRect.top - by, binst.srcRect.right - bx, binst.srcRect.bottom - by, null);
            }
        }
    }
}

