#!/usr/bin/env python2.7
#
# Doomsday Build Configuration Script
#
# Usage:
#   configure.py
#
# This will generate versions.pri based on various header files.

import sys, os, time

sys.path.append(os.path.join(os.path.dirname(__file__), '../distrib'))
import build_version

out = file('versions.pri', 'wt')
print >> out, "# Generated by configure.py on", time.asctime()

# Check primary version info.
primary = build_version.version_summary('api/dd_version.h').split(' ')

base = primary[0]
buildNum = primary[1]
relType = primary[2]

print >> out, """
defineReplace(dengReleaseType) {
    return(%s)
}""" % relType

print >> out, """
defineTest(isStableRelease) {
    relType = $$dengReleaseType()
    contains(relType, Stable): return(true)
    else: return(false)
}
"""

print >> out, 'DENG_VERSION =', base
print >> out, 'JDOOM_VERSION =', base
print >> out, 'JHERETIC_VERSION =', base
print >> out, 'JHEXEN_VERSION =', base
print >> out, 'JDOOM64_VERSION =', base

def find_version(fn):
    return build_version.version_summary(fn).split(' ')[0]

def print_version(out, id, fn):
    print >> out, '%s_VERSION = %s' % (id, find_version(fn))

print_version(out, 'DEHREAD',           'plugins/dehread/include/version.h')
print_version(out, 'SAVEGAMECONVERTER', 'plugins/savegameconverter/include/version.h')
print_version(out, 'WADMAPCONVERTER',   'plugins/wadmapconverter/include/version.h')
print_version(out, 'DIRECTSOUND',       'plugins/directsound/include/version.h')
print_version(out, 'OPENAL',            'plugins/openal/include/version.h')
print_version(out, 'FMOD',              'plugins/fmod/include/version.h')
print_version(out, 'WINMM',             'plugins/winmm/include/version.h')
print_version(out, 'EXAMPLE',           'plugins/example/include/version.h')
