# Contributing to Eclipse XSD

Thanks for your interest in this project.

## Project description

Eclipse XSD is a library that provides an API for manipulating the components of
an XML Schema as described by the W3C XML Schema specifications, as well as an
API for manipulating the DOM-accessible representation of XML.

* https://www.eclipse.org/modeling/mdt/?project=xsd
* https://projects.eclipse.org/projects/modeling.mdt.xsd

## Developer resources

Information regarding source code management, builds, coding standards, and
more.

* https://projects.eclipse.org/projects/modeling.mdt.xsd/developer

The project maintains the following source code repositories

* http://git.eclipse.org/c/xsd/org.eclipse.xsd.git

This project uses Bugzilla to track ongoing development and issues.

* Search for issues: https://eclipse.org/bugs/buglist.cgi?product=MDT
* Create a new report: https://eclipse.org/bugs/enter_bug.cgi?product=MDT

Be sure to search for existing bugs before you create another one. Remember that
contributions are always welcome!

This project is built, along with EMF, using Maven/Tycho. Instructions for setting 
up a development environment and for replicating the build locally are provided here:

* https://ci.eclipse.org/emf/

## Eclipse Contributor Agreement

Before your contribution can be accepted by the project team contributors must
electronically sign the Eclipse Contributor Agreement (ECA).

* http://www.eclipse.org/legal/ECA.php

Commits that are provided by non-committers must have a Signed-off-by field in
the footer indicating that the author is aware of the terms by which the
contribution has been provided to the project. The non-committer must
additionally have an Eclipse Foundation account and must have a signed Eclipse
Contributor Agreement (ECA) on file.

For more information, please see the Eclipse Committer Handbook:
https://www.eclipse.org/projects/handbook/#resources-commit

## Contact

Ask questions via the project's forum:

* https://www.eclipse.org/forums/index.php/f/119/

Contact the project developers via the project's "dev" list.

*  https://dev.eclipse.org/mailman/listinfo/xsd-dev