# -*- coding: utf-8 -*-
#
# Graphical interface for the eSpeak speech synthesizer
#
# Copyright © 2009-2012 Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
# Copyright © 2009 Joe Burmeister <joe.a.burmeister@googlemail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import gtk

from resources import version

_gnulicense = \
"This program is free software: you can redistribute it and/or modify\n\
it under the terms of the GNU General Public License as published by\n\
the Free Software Foundation, either version 3 of the License, or\n\
(at your option) any later version.\n\
\n\
This program is distributed in the hope that it will be useful,\n\
but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
GNU General Public License for more details.\n\
\n\
You should have received a copy of the GNU General Public License\n\
along with this program.  If not, see <http://www.gnu.org/licenses/>."

def create_about_dialog(parent_window):
    dialog = gtk.AboutDialog()
    dialog.set_version(version)
    dialog.set_program_name('espeak-gui')
    dialog.set_icon(parent_window.get_icon())
    dialog.set_license(_gnulicense)
    dialog.set_copyright(
        'Copyright © 2009-2010 Siegfried-Angel Gevatter Pujals\n' \
        'Copyright © 2009 Joe Burmeister')
    dialog.set_authors([
        'Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>',
        'Joe Burmeister <joe.a.burmeister@googlemail.com>'])
    dialog.set_logo(dialog.get_icon())
    
    def close(w, res=None):
        w.hide()
    
    dialog.connect('response', close)
    dialog.connect('destroy', close)
    
    return dialog
