/*
 * FCML - Free Code Manipulation Library.
 * Copyright (C) 2010-2020 Slawomir Wojtasiak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/** @file fcml_intel_mnemonics.cpp
 * Definitions of Intel mnemonics for C++.
 *
 * @copyright Copyright (C) 2010-2020 Slawomir Wojtasiak. All rights reserved.
 * This project is released under the GNU Lesser General Public License.
 */

#include "fcml_intel_mnemonics.hpp"

namespace fcml {
namespace intel {

extern const fcml_cstring M_AAA = _FT("aaa");
extern const fcml_cstring M_AAD = _FT("aad");
extern const fcml_cstring M_AAM = _FT("aam");
extern const fcml_cstring M_AAS = _FT("aas");
extern const fcml_cstring M_ADC = _FT("adc");
extern const fcml_cstring M_ADCX = _FT("adcx");
extern const fcml_cstring M_ADD = _FT("add");
extern const fcml_cstring M_ADDPD = _FT("addpd");
extern const fcml_cstring M_ADDPS = _FT("addps");
extern const fcml_cstring M_ADDSD = _FT("addsd");
extern const fcml_cstring M_ADDSS = _FT("addss");
extern const fcml_cstring M_ADDSUBPD = _FT("addsubpd");
extern const fcml_cstring M_ADDSUBPS = _FT("addsubps");
extern const fcml_cstring M_ADOX = _FT("adox");
extern const fcml_cstring M_AESDEC = _FT("aesdec");
extern const fcml_cstring M_AESDECLAST = _FT("aesdeclast");
extern const fcml_cstring M_AESENC = _FT("aesenc");
extern const fcml_cstring M_AESENCLAST = _FT("aesenclast");
extern const fcml_cstring M_AESIMC = _FT("aesimc");
extern const fcml_cstring M_AESKEYGENASSIST = _FT("aeskeygenassist");
extern const fcml_cstring M_AND = _FT("and");
extern const fcml_cstring M_ANDN = _FT("andn");
extern const fcml_cstring M_ANDNPD = _FT("andnpd");
extern const fcml_cstring M_ANDNPS = _FT("andnps");
extern const fcml_cstring M_ANDPD = _FT("andpd");
extern const fcml_cstring M_ANDPS = _FT("andps");
extern const fcml_cstring M_ARPL = _FT("arpl");
extern const fcml_cstring M_BEXR = _FT("bexr");
extern const fcml_cstring M_BEXTR = _FT("bextr");
extern const fcml_cstring M_BLCFILL = _FT("blcfill");
extern const fcml_cstring M_BLCI = _FT("blci");
extern const fcml_cstring M_BLCIC = _FT("blcic");
extern const fcml_cstring M_BLCMSK = _FT("blcmsk");
extern const fcml_cstring M_BLCS = _FT("blcs");
extern const fcml_cstring M_BLENDPD = _FT("blendpd");
extern const fcml_cstring M_BLENDPS = _FT("blendps");
extern const fcml_cstring M_BLENDVPD = _FT("blendvpd");
extern const fcml_cstring M_BLENDVPS = _FT("blendvps");
extern const fcml_cstring M_BLSFILL = _FT("blsfill");
extern const fcml_cstring M_BLSI = _FT("blsi");
extern const fcml_cstring M_BLSIC = _FT("blsic");
extern const fcml_cstring M_BLSMSK = _FT("blsmsk");
extern const fcml_cstring M_BLSR = _FT("blsr");
extern const fcml_cstring M_BOUND = _FT("bound");
extern const fcml_cstring M_BSF = _FT("bsf");
extern const fcml_cstring M_BSR = _FT("bsr");
extern const fcml_cstring M_BSWAP = _FT("bswap");
extern const fcml_cstring M_BT = _FT("bt");
extern const fcml_cstring M_BTC = _FT("btc");
extern const fcml_cstring M_BTR = _FT("btr");
extern const fcml_cstring M_BTS = _FT("bts");
extern const fcml_cstring M_BZHI = _FT("bzhi");
extern const fcml_cstring M_CALL = _FT("call");
extern const fcml_cstring M_CBW = _FT("cbw");
extern const fcml_cstring M_CDQ = _FT("cdq");
extern const fcml_cstring M_CDQE = _FT("cdqe");
extern const fcml_cstring M_CLAC = _FT("clac");
extern const fcml_cstring M_CLC = _FT("clc");
extern const fcml_cstring M_CLD = _FT("cld");
extern const fcml_cstring M_CLFLUSH = _FT("clflush");
extern const fcml_cstring M_CLGI = _FT("clgi");
extern const fcml_cstring M_CLI = _FT("cli");
extern const fcml_cstring M_CLTS = _FT("clts");
extern const fcml_cstring M_CMC = _FT("cmc");
extern const fcml_cstring M_CMOVA = _FT("cmova");
extern const fcml_cstring M_CMOVAE = _FT("cmovae");
extern const fcml_cstring M_CMOVB = _FT("cmovb");
extern const fcml_cstring M_CMOVBE = _FT("cmovbe");
extern const fcml_cstring M_CMOVC = _FT("cmovc");
extern const fcml_cstring M_CMOVENE = _FT("cmovene");
extern const fcml_cstring M_CMOVG = _FT("cmovg");
extern const fcml_cstring M_CMOVGE = _FT("cmovge");
extern const fcml_cstring M_CMOVL = _FT("cmovl");
extern const fcml_cstring M_CMOVLE = _FT("cmovle");
extern const fcml_cstring M_CMOVNA = _FT("cmovna");
extern const fcml_cstring M_CMOVNAE = _FT("cmovnae");
extern const fcml_cstring M_CMOVNB = _FT("cmovnb");
extern const fcml_cstring M_CMOVNBE = _FT("cmovnbe");
extern const fcml_cstring M_CMOVNC = _FT("cmovnc");
extern const fcml_cstring M_CMOVNG = _FT("cmovng");
extern const fcml_cstring M_CMOVNGE = _FT("cmovnge");
extern const fcml_cstring M_CMOVNL = _FT("cmovnl");
extern const fcml_cstring M_CMOVNLE = _FT("cmovnle");
extern const fcml_cstring M_CMOVNO = _FT("cmovno");
extern const fcml_cstring M_CMOVNP = _FT("cmovnp");
extern const fcml_cstring M_CMOVNS = _FT("cmovns");
extern const fcml_cstring M_CMOVNZ = _FT("cmovnz");
extern const fcml_cstring M_CMOVO = _FT("cmovo");
extern const fcml_cstring M_CMOVP = _FT("cmovp");
extern const fcml_cstring M_CMOVPE = _FT("cmovpe");
extern const fcml_cstring M_CMOVPO = _FT("cmovpo");
extern const fcml_cstring M_CMOVS = _FT("cmovs");
extern const fcml_cstring M_CMOVZ = _FT("cmovz");
extern const fcml_cstring M_CMP = _FT("cmp");
extern const fcml_cstring M_CMPEQPD = _FT("cmpeqpd");
extern const fcml_cstring M_CMPEQPS = _FT("cmpeqps");
extern const fcml_cstring M_CMPEQSD = _FT("cmpeqsd");
extern const fcml_cstring M_CMPEQSS = _FT("cmpeqss");
extern const fcml_cstring M_CMPLEPD = _FT("cmplepd");
extern const fcml_cstring M_CMPLEPS = _FT("cmpleps");
extern const fcml_cstring M_CMPLESD = _FT("cmplesd");
extern const fcml_cstring M_CMPLESS = _FT("cmpless");
extern const fcml_cstring M_CMPLTPD = _FT("cmpltpd");
extern const fcml_cstring M_CMPLTPS = _FT("cmpltps");
extern const fcml_cstring M_CMPLTSD = _FT("cmpltsd");
extern const fcml_cstring M_CMPLTSS = _FT("cmpltss");
extern const fcml_cstring M_CMPNEQPD = _FT("cmpneqpd");
extern const fcml_cstring M_CMPNEQPS = _FT("cmpneqps");
extern const fcml_cstring M_CMPNEQSD = _FT("cmpneqsd");
extern const fcml_cstring M_CMPNEQSS = _FT("cmpneqss");
extern const fcml_cstring M_CMPNLEPD = _FT("cmpnlepd");
extern const fcml_cstring M_CMPNLEPS = _FT("cmpnleps");
extern const fcml_cstring M_CMPNLESD = _FT("cmpnlesd");
extern const fcml_cstring M_CMPNLESS = _FT("cmpnless");
extern const fcml_cstring M_CMPNLTPD = _FT("cmpnltpd");
extern const fcml_cstring M_CMPNLTPS = _FT("cmpnltps");
extern const fcml_cstring M_CMPNLTSD = _FT("cmpnltsd");
extern const fcml_cstring M_CMPNLTSS = _FT("cmpnltss");
extern const fcml_cstring M_CMPORDPD = _FT("cmpordpd");
extern const fcml_cstring M_CMPORDPS = _FT("cmpordps");
extern const fcml_cstring M_CMPORDSD = _FT("cmpordsd");
extern const fcml_cstring M_CMPORDSS = _FT("cmpordss");
extern const fcml_cstring M_CMPPD = _FT("cmppd");
extern const fcml_cstring M_CMPPS = _FT("cmpps");
extern const fcml_cstring M_CMPS = _FT("cmps");
extern const fcml_cstring M_CMPSB = _FT("cmpsb");
extern const fcml_cstring M_CMPSD = _FT("cmpsd");
extern const fcml_cstring M_CMPSQ = _FT("cmpsq");
extern const fcml_cstring M_CMPSS = _FT("cmpss");
extern const fcml_cstring M_CMPSW = _FT("cmpsw");
extern const fcml_cstring M_CMPUNORDPD = _FT("cmpunordpd");
extern const fcml_cstring M_CMPUNORDPS = _FT("cmpunordps");
extern const fcml_cstring M_CMPUNORDSD = _FT("cmpunordsd");
extern const fcml_cstring M_CMPUNORDSS = _FT("cmpunordss");
extern const fcml_cstring M_CMPXCHG = _FT("cmpxchg");
extern const fcml_cstring M_CMPXCHG16B = _FT("cmpxchg16b");
extern const fcml_cstring M_CMPXCHG8B = _FT("cmpxchg8b");
extern const fcml_cstring M_COMISD = _FT("comisd");
extern const fcml_cstring M_COMISS = _FT("comiss");
extern const fcml_cstring M_CPUID = _FT("cpuid");
extern const fcml_cstring M_CQO = _FT("cqo");
extern const fcml_cstring M_CRC32 = _FT("crc32");
extern const fcml_cstring M_CVTDQ2PD = _FT("cvtdq2pd");
extern const fcml_cstring M_CVTDQ2PS = _FT("cvtdq2ps");
extern const fcml_cstring M_CVTPD2DQ = _FT("cvtpd2dq");
extern const fcml_cstring M_CVTPD2PI = _FT("cvtpd2pi");
extern const fcml_cstring M_CVTPD2PS = _FT("cvtpd2ps");
extern const fcml_cstring M_CVTPI2PD = _FT("cvtpi2pd");
extern const fcml_cstring M_CVTPI2PS = _FT("cvtpi2ps");
extern const fcml_cstring M_CVTPS2DQ = _FT("cvtps2dq");
extern const fcml_cstring M_CVTPS2PD = _FT("cvtps2pd");
extern const fcml_cstring M_CVTPS2PI = _FT("cvtps2pi");
extern const fcml_cstring M_CVTSD2SI = _FT("cvtsd2si");
extern const fcml_cstring M_CVTSD2SS = _FT("cvtsd2ss");
extern const fcml_cstring M_CVTSI2SD = _FT("cvtsi2sd");
extern const fcml_cstring M_CVTSI2SS = _FT("cvtsi2ss");
extern const fcml_cstring M_CVTSS2SD = _FT("cvtss2sd");
extern const fcml_cstring M_CVTSS2SI = _FT("cvtss2si");
extern const fcml_cstring M_CVTTPD2DQ = _FT("cvttpd2dq");
extern const fcml_cstring M_CVTTPD2PI = _FT("cvttpd2pi");
extern const fcml_cstring M_CVTTPS2DQ = _FT("cvttps2dq");
extern const fcml_cstring M_CVTTPS2PI = _FT("cvttps2pi");
extern const fcml_cstring M_CVTTSD2SI = _FT("cvttsd2si");
extern const fcml_cstring M_CVTTSS2SI = _FT("cvttss2si");
extern const fcml_cstring M_CWD = _FT("cwd");
extern const fcml_cstring M_CWDE = _FT("cwde");
extern const fcml_cstring M_DAA = _FT("daa");
extern const fcml_cstring M_DAS = _FT("das");
extern const fcml_cstring M_DEC = _FT("dec");
extern const fcml_cstring M_DIV = _FT("div");
extern const fcml_cstring M_DIVPD = _FT("divpd");
extern const fcml_cstring M_DIVPS = _FT("divps");
extern const fcml_cstring M_DIVSD = _FT("divsd");
extern const fcml_cstring M_DIVSS = _FT("divss");
extern const fcml_cstring M_DPPD = _FT("dppd");
extern const fcml_cstring M_DPPS = _FT("dpps");
extern const fcml_cstring M_EMMS = _FT("emms");
extern const fcml_cstring M_ENTER = _FT("enter");
extern const fcml_cstring M_EXTRACTPS = _FT("extractps");
extern const fcml_cstring M_EXTRQ = _FT("extrq");
extern const fcml_cstring M_F2XM1 = _FT("f2xm1");
extern const fcml_cstring M_FABS = _FT("fabs");
extern const fcml_cstring M_FADD = _FT("fadd");
extern const fcml_cstring M_FADDP = _FT("faddp");
extern const fcml_cstring M_FBLD = _FT("fbld");
extern const fcml_cstring M_FBSTP = _FT("fbstp");
extern const fcml_cstring M_FCHS = _FT("fchs");
extern const fcml_cstring M_FCLEX = _FT("fclex");
extern const fcml_cstring M_FCMOVB = _FT("fcmovb");
extern const fcml_cstring M_FCMOVBE = _FT("fcmovbe");
extern const fcml_cstring M_FCMOVE = _FT("fcmove");
extern const fcml_cstring M_FCMOVNB = _FT("fcmovnb");
extern const fcml_cstring M_FCMOVNBE = _FT("fcmovnbe");
extern const fcml_cstring M_FCMOVNE = _FT("fcmovne");
extern const fcml_cstring M_FCMOVNU = _FT("fcmovnu");
extern const fcml_cstring M_FCMOVU = _FT("fcmovu");
extern const fcml_cstring M_FCOM = _FT("fcom");
extern const fcml_cstring M_FCOMI = _FT("fcomi");
extern const fcml_cstring M_FCOMIP = _FT("fcomip");
extern const fcml_cstring M_FCOMP = _FT("fcomp");
extern const fcml_cstring M_FCOMPP = _FT("fcompp");
extern const fcml_cstring M_FCOS = _FT("fcos");
extern const fcml_cstring M_FDECSTP = _FT("fdecstp");
extern const fcml_cstring M_FDIV = _FT("fdiv");
extern const fcml_cstring M_FDIVP = _FT("fdivp");
extern const fcml_cstring M_FDIVR = _FT("fdivr");
extern const fcml_cstring M_FDIVRP = _FT("fdivrp");
extern const fcml_cstring M_FEMMS = _FT("femms");
extern const fcml_cstring M_FFREE = _FT("ffree");
extern const fcml_cstring M_FIADD = _FT("fiadd");
extern const fcml_cstring M_FICOM = _FT("ficom");
extern const fcml_cstring M_FICOMP = _FT("ficomp");
extern const fcml_cstring M_FIDIV = _FT("fidiv");
extern const fcml_cstring M_FIDIVR = _FT("fidivr");
extern const fcml_cstring M_FILD = _FT("fild");
extern const fcml_cstring M_FIMUL = _FT("fimul");
extern const fcml_cstring M_FINCSTP = _FT("fincstp");
extern const fcml_cstring M_FINIT = _FT("finit");
extern const fcml_cstring M_FIST = _FT("fist");
extern const fcml_cstring M_FISTP = _FT("fistp");
extern const fcml_cstring M_FISTTP = _FT("fisttp");
extern const fcml_cstring M_FISUB = _FT("fisub");
extern const fcml_cstring M_FISUBR = _FT("fisubr");
extern const fcml_cstring M_FLD = _FT("fld");
extern const fcml_cstring M_FLD1 = _FT("fld1");
extern const fcml_cstring M_FLDCW = _FT("fldcw");
extern const fcml_cstring M_FLDENV = _FT("fldenv");
extern const fcml_cstring M_FLDL2E = _FT("fldl2e");
extern const fcml_cstring M_FLDL2T = _FT("fldl2t");
extern const fcml_cstring M_FLDLG2 = _FT("fldlg2");
extern const fcml_cstring M_FLDLN2 = _FT("fldln2");
extern const fcml_cstring M_FLDPI = _FT("fldpi");
extern const fcml_cstring M_FLDZ = _FT("fldz");
extern const fcml_cstring M_FMUL = _FT("fmul");
extern const fcml_cstring M_FMULP = _FT("fmulp");
extern const fcml_cstring M_FNCLEX = _FT("fnclex");
extern const fcml_cstring M_FNINIT = _FT("fninit");
extern const fcml_cstring M_FNOP = _FT("fnop");
extern const fcml_cstring M_FNSAVE = _FT("fnsave");
extern const fcml_cstring M_FNSTCW = _FT("fnstcw");
extern const fcml_cstring M_FNSTENV = _FT("fnstenv");
extern const fcml_cstring M_FNSTSW = _FT("fnstsw");
extern const fcml_cstring M_FPATAN = _FT("fpatan");
extern const fcml_cstring M_FPREM = _FT("fprem");
extern const fcml_cstring M_FPREM1 = _FT("fprem1");
extern const fcml_cstring M_FPTAN = _FT("fptan");
extern const fcml_cstring M_FRNDINT = _FT("frndint");
extern const fcml_cstring M_FRSTOR = _FT("frstor");
extern const fcml_cstring M_FSAVE = _FT("fsave");
extern const fcml_cstring M_FSCALE = _FT("fscale");
extern const fcml_cstring M_FSIN = _FT("fsin");
extern const fcml_cstring M_FSINCOS = _FT("fsincos");
extern const fcml_cstring M_FSQRT = _FT("fsqrt");
extern const fcml_cstring M_FST = _FT("fst");
extern const fcml_cstring M_FSTCW = _FT("fstcw");
extern const fcml_cstring M_FSTENV = _FT("fstenv");
extern const fcml_cstring M_FSTP = _FT("fstp");
extern const fcml_cstring M_FSTSW = _FT("fstsw");
extern const fcml_cstring M_FSUB = _FT("fsub");
extern const fcml_cstring M_FSUBP = _FT("fsubp");
extern const fcml_cstring M_FSUBR = _FT("fsubr");
extern const fcml_cstring M_FSUBRP = _FT("fsubrp");
extern const fcml_cstring M_FTST = _FT("ftst");
extern const fcml_cstring M_FUCOM = _FT("fucom");
extern const fcml_cstring M_FUCOMI = _FT("fucomi");
extern const fcml_cstring M_FUCOMIP = _FT("fucomip");
extern const fcml_cstring M_FUCOMP = _FT("fucomp");
extern const fcml_cstring M_FUCOMPP = _FT("fucompp");
extern const fcml_cstring M_FWAIT = _FT("fwait");
extern const fcml_cstring M_FXAM = _FT("fxam");
extern const fcml_cstring M_FXCH = _FT("fxch");
extern const fcml_cstring M_FXRSTOR = _FT("fxrstor");
extern const fcml_cstring M_FXRSTOR64 = _FT("fxrstor64");
extern const fcml_cstring M_FXSAVE = _FT("fxsave");
extern const fcml_cstring M_FXSAVE64 = _FT("fxsave64");
extern const fcml_cstring M_FXTRACT = _FT("fxtract");
extern const fcml_cstring M_FYL2X = _FT("fyl2x");
extern const fcml_cstring M_FYL2XP1 = _FT("fyl2xp1");
extern const fcml_cstring M_GETSEC = _FT("getsec");
extern const fcml_cstring M_HADDPD = _FT("haddpd");
extern const fcml_cstring M_HADDPS = _FT("haddps");
extern const fcml_cstring M_HLT = _FT("hlt");
extern const fcml_cstring M_HSUBPD = _FT("hsubpd");
extern const fcml_cstring M_HSUBPS = _FT("hsubps");
extern const fcml_cstring M_IDIV = _FT("idiv");
extern const fcml_cstring M_IMUL = _FT("imul");
extern const fcml_cstring M_IN = _FT("in");
extern const fcml_cstring M_INC = _FT("inc");
extern const fcml_cstring M_INS = _FT("ins");
extern const fcml_cstring M_INSB = _FT("insb");
extern const fcml_cstring M_INSD = _FT("insd");
extern const fcml_cstring M_INSERTPS = _FT("insertps");
extern const fcml_cstring M_INSERTQ = _FT("insertq");
extern const fcml_cstring M_INSW = _FT("insw");
extern const fcml_cstring M_INT = _FT("int");
extern const fcml_cstring M_INT3 = _FT("int3");
extern const fcml_cstring M_INTO = _FT("into");
extern const fcml_cstring M_INVD = _FT("invd");
extern const fcml_cstring M_INVEPT = _FT("invept");
extern const fcml_cstring M_INVLPG = _FT("invlpg");
extern const fcml_cstring M_INVLPGA = _FT("invlpga");
extern const fcml_cstring M_INVPCID = _FT("invpcid");
extern const fcml_cstring M_INVVPID = _FT("invvpid");
extern const fcml_cstring M_IRET = _FT("iret");
extern const fcml_cstring M_IRETD = _FT("iretd");
extern const fcml_cstring M_IRETQ = _FT("iretq");
extern const fcml_cstring M_JA = _FT("ja");
extern const fcml_cstring M_JAE = _FT("jae");
extern const fcml_cstring M_JB = _FT("jb");
extern const fcml_cstring M_JBE = _FT("jbe");
extern const fcml_cstring M_JC = _FT("jc");
extern const fcml_cstring M_JCXZ = _FT("jcxz");
extern const fcml_cstring M_JECXZ = _FT("jecxz");
extern const fcml_cstring M_JENE = _FT("jene");
extern const fcml_cstring M_JG = _FT("jg");
extern const fcml_cstring M_JGE = _FT("jge");
extern const fcml_cstring M_JL = _FT("jl");
extern const fcml_cstring M_JLE = _FT("jle");
extern const fcml_cstring M_JMP = _FT("jmp");
extern const fcml_cstring M_JNA = _FT("jna");
extern const fcml_cstring M_JNAE = _FT("jnae");
extern const fcml_cstring M_JNB = _FT("jnb");
extern const fcml_cstring M_JNBE = _FT("jnbe");
extern const fcml_cstring M_JNC = _FT("jnc");
extern const fcml_cstring M_JNG = _FT("jng");
extern const fcml_cstring M_JNGE = _FT("jnge");
extern const fcml_cstring M_JNL = _FT("jnl");
extern const fcml_cstring M_JNLE = _FT("jnle");
extern const fcml_cstring M_JNO = _FT("jno");
extern const fcml_cstring M_JNP = _FT("jnp");
extern const fcml_cstring M_JNS = _FT("jns");
extern const fcml_cstring M_JNZ = _FT("jnz");
extern const fcml_cstring M_JO = _FT("jo");
extern const fcml_cstring M_JP = _FT("jp");
extern const fcml_cstring M_JPE = _FT("jpe");
extern const fcml_cstring M_JPO = _FT("jpo");
extern const fcml_cstring M_JRCXZ = _FT("jrcxz");
extern const fcml_cstring M_JS = _FT("js");
extern const fcml_cstring M_JZ = _FT("jz");
extern const fcml_cstring M_KADDB = _FT("kaddb");
extern const fcml_cstring M_KADDD = _FT("kaddd");
extern const fcml_cstring M_KADDQ = _FT("kaddq");
extern const fcml_cstring M_KADDW = _FT("kaddw");
extern const fcml_cstring M_KANDB = _FT("kandb");
extern const fcml_cstring M_KANDD = _FT("kandd");
extern const fcml_cstring M_KANDNB = _FT("kandnb");
extern const fcml_cstring M_KANDND = _FT("kandnd");
extern const fcml_cstring M_KANDNQ = _FT("kandnq");
extern const fcml_cstring M_KANDNW = _FT("kandnw");
extern const fcml_cstring M_KANDQ = _FT("kandq");
extern const fcml_cstring M_KANDW = _FT("kandw");
extern const fcml_cstring M_KMOVB = _FT("kmovb");
extern const fcml_cstring M_KMOVD = _FT("kmovd");
extern const fcml_cstring M_KMOVQ = _FT("kmovq");
extern const fcml_cstring M_KMOVW = _FT("kmovw");
extern const fcml_cstring M_KNOTB = _FT("knotb");
extern const fcml_cstring M_KNOTD = _FT("knotd");
extern const fcml_cstring M_KNOTQ = _FT("knotq");
extern const fcml_cstring M_KNOTW = _FT("knotw");
extern const fcml_cstring M_KORB = _FT("korb");
extern const fcml_cstring M_KORD = _FT("kord");
extern const fcml_cstring M_KORQ = _FT("korq");
extern const fcml_cstring M_KORTESTB = _FT("kortestb");
extern const fcml_cstring M_KORTESTD = _FT("kortestd");
extern const fcml_cstring M_KORTESTQ = _FT("kortestq");
extern const fcml_cstring M_KORTESTW = _FT("kortestw");
extern const fcml_cstring M_KORW = _FT("korw");
extern const fcml_cstring M_KSHIFTLB = _FT("kshiftlb");
extern const fcml_cstring M_KSHIFTLD = _FT("kshiftld");
extern const fcml_cstring M_KSHIFTLQ = _FT("kshiftlq");
extern const fcml_cstring M_KSHIFTLW = _FT("kshiftlw");
extern const fcml_cstring M_KSHIFTRB = _FT("kshiftrb");
extern const fcml_cstring M_KSHIFTRD = _FT("kshiftrd");
extern const fcml_cstring M_KSHIFTRQ = _FT("kshiftrq");
extern const fcml_cstring M_KSHIFTRW = _FT("kshiftrw");
extern const fcml_cstring M_KTESTB = _FT("ktestb");
extern const fcml_cstring M_KTESTD = _FT("ktestd");
extern const fcml_cstring M_KTESTQ = _FT("ktestq");
extern const fcml_cstring M_KTESTW = _FT("ktestw");
extern const fcml_cstring M_KXNORB = _FT("kxnorb");
extern const fcml_cstring M_KXNORD = _FT("kxnord");
extern const fcml_cstring M_KXNORQ = _FT("kxnorq");
extern const fcml_cstring M_KXNORW = _FT("kxnorw");
extern const fcml_cstring M_KXORB = _FT("kxorb");
extern const fcml_cstring M_KXORD = _FT("kxord");
extern const fcml_cstring M_KXORQ = _FT("kxorq");
extern const fcml_cstring M_KXORW = _FT("kxorw");
extern const fcml_cstring M_LAHF = _FT("lahf");
extern const fcml_cstring M_LAR = _FT("lar");
extern const fcml_cstring M_LDDQU = _FT("lddqu");
extern const fcml_cstring M_LDMXCSR = _FT("ldmxcsr");
extern const fcml_cstring M_LDS = _FT("lds");
extern const fcml_cstring M_LEA = _FT("lea");
extern const fcml_cstring M_LEAVE = _FT("leave");
extern const fcml_cstring M_LES = _FT("les");
extern const fcml_cstring M_LFENCE = _FT("lfence");
extern const fcml_cstring M_LFS = _FT("lfs");
extern const fcml_cstring M_LGDT = _FT("lgdt");
extern const fcml_cstring M_LGS = _FT("lgs");
extern const fcml_cstring M_LIDT = _FT("lidt");
extern const fcml_cstring M_LLDT = _FT("lldt");
extern const fcml_cstring M_LLWPCB = _FT("llwpcb");
extern const fcml_cstring M_LMSW = _FT("lmsw");
extern const fcml_cstring M_LODS = _FT("lods");
extern const fcml_cstring M_LODSB = _FT("lodsb");
extern const fcml_cstring M_LODSD = _FT("lodsd");
extern const fcml_cstring M_LODSQ = _FT("lodsq");
extern const fcml_cstring M_LODSW = _FT("lodsw");
extern const fcml_cstring M_LOOP = _FT("loop");
extern const fcml_cstring M_LOOPE = _FT("loope");
extern const fcml_cstring M_LOOPNE = _FT("loopne");
extern const fcml_cstring M_LOOPNZ = _FT("loopnz");
extern const fcml_cstring M_LOOPZ = _FT("loopz");
extern const fcml_cstring M_LSL = _FT("lsl");
extern const fcml_cstring M_LSS = _FT("lss");
extern const fcml_cstring M_LTR = _FT("ltr");
extern const fcml_cstring M_LWPINS = _FT("lwpins");
extern const fcml_cstring M_LWPVAL = _FT("lwpval");
extern const fcml_cstring M_LZCNT = _FT("lzcnt");
extern const fcml_cstring M_MASKMOVDQU = _FT("maskmovdqu");
extern const fcml_cstring M_MASKMOVQ = _FT("maskmovq");
extern const fcml_cstring M_MAXPD = _FT("maxpd");
extern const fcml_cstring M_MAXPS = _FT("maxps");
extern const fcml_cstring M_MAXSD = _FT("maxsd");
extern const fcml_cstring M_MAXSS = _FT("maxss");
extern const fcml_cstring M_MFENCE = _FT("mfence");
extern const fcml_cstring M_MINPD = _FT("minpd");
extern const fcml_cstring M_MINPS = _FT("minps");
extern const fcml_cstring M_MINSD = _FT("minsd");
extern const fcml_cstring M_MINSS = _FT("minss");
extern const fcml_cstring M_MONITOR = _FT("monitor");
extern const fcml_cstring M_MOV = _FT("mov");
extern const fcml_cstring M_MOVAPD = _FT("movapd");
extern const fcml_cstring M_MOVAPS = _FT("movaps");
extern const fcml_cstring M_MOVBE = _FT("movbe");
extern const fcml_cstring M_MOVD = _FT("movd");
extern const fcml_cstring M_MOVDDUP = _FT("movddup");
extern const fcml_cstring M_MOVDQ2Q = _FT("movdq2q");
extern const fcml_cstring M_MOVDQA = _FT("movdqa");
extern const fcml_cstring M_MOVDQU = _FT("movdqu");
extern const fcml_cstring M_MOVHLPS = _FT("movhlps");
extern const fcml_cstring M_MOVHPD = _FT("movhpd");
extern const fcml_cstring M_MOVHPS = _FT("movhps");
extern const fcml_cstring M_MOVLHPS = _FT("movlhps");
extern const fcml_cstring M_MOVLPD = _FT("movlpd");
extern const fcml_cstring M_MOVLPS = _FT("movlps");
extern const fcml_cstring M_MOVMSKPD = _FT("movmskpd");
extern const fcml_cstring M_MOVMSKPS = _FT("movmskps");
extern const fcml_cstring M_MOVNTDQ = _FT("movntdq");
extern const fcml_cstring M_MOVNTDQA = _FT("movntdqa");
extern const fcml_cstring M_MOVNTI = _FT("movnti");
extern const fcml_cstring M_MOVNTPD = _FT("movntpd");
extern const fcml_cstring M_MOVNTPS = _FT("movntps");
extern const fcml_cstring M_MOVNTQ = _FT("movntq");
extern const fcml_cstring M_MOVNTSD = _FT("movntsd");
extern const fcml_cstring M_MOVNTSS = _FT("movntss");
extern const fcml_cstring M_MOVQ = _FT("movq");
extern const fcml_cstring M_MOVQ2DQ = _FT("movq2dq");
extern const fcml_cstring M_MOVS = _FT("movs");
extern const fcml_cstring M_MOVSB = _FT("movsb");
extern const fcml_cstring M_MOVSD = _FT("movsd");
extern const fcml_cstring M_MOVSHDUP = _FT("movshdup");
extern const fcml_cstring M_MOVSLDUP = _FT("movsldup");
extern const fcml_cstring M_MOVSQ = _FT("movsq");
extern const fcml_cstring M_MOVSS = _FT("movss");
extern const fcml_cstring M_MOVSW = _FT("movsw");
extern const fcml_cstring M_MOVSX = _FT("movsx");
extern const fcml_cstring M_MOVSXD = _FT("movsxd");
extern const fcml_cstring M_MOVUPD = _FT("movupd");
extern const fcml_cstring M_MOVUPS = _FT("movups");
extern const fcml_cstring M_MOVZX = _FT("movzx");
extern const fcml_cstring M_MPSADBW = _FT("mpsadbw");
extern const fcml_cstring M_MUL = _FT("mul");
extern const fcml_cstring M_MULPD = _FT("mulpd");
extern const fcml_cstring M_MULPS = _FT("mulps");
extern const fcml_cstring M_MULSD = _FT("mulsd");
extern const fcml_cstring M_MULSS = _FT("mulss");
extern const fcml_cstring M_MULX = _FT("mulx");
extern const fcml_cstring M_MWAIT = _FT("mwait");
extern const fcml_cstring M_NEG = _FT("neg");
extern const fcml_cstring M_NOP = _FT("nop");
extern const fcml_cstring M_NOT = _FT("not");
extern const fcml_cstring M_OR = _FT("or");
extern const fcml_cstring M_ORPD = _FT("orpd");
extern const fcml_cstring M_ORPS = _FT("orps");
extern const fcml_cstring M_OUT = _FT("out");
extern const fcml_cstring M_OUTS = _FT("outs");
extern const fcml_cstring M_OUTSB = _FT("outsb");
extern const fcml_cstring M_OUTSD = _FT("outsd");
extern const fcml_cstring M_OUTSW = _FT("outsw");
extern const fcml_cstring M_PABSB = _FT("pabsb");
extern const fcml_cstring M_PABSD = _FT("pabsd");
extern const fcml_cstring M_PABSW = _FT("pabsw");
extern const fcml_cstring M_PACKSSDW = _FT("packssdw");
extern const fcml_cstring M_PACKSSWB = _FT("packsswb");
extern const fcml_cstring M_PACKUSDW = _FT("packusdw");
extern const fcml_cstring M_PACKUSWB = _FT("packuswb");
extern const fcml_cstring M_PADDB = _FT("paddb");
extern const fcml_cstring M_PADDD = _FT("paddd");
extern const fcml_cstring M_PADDQ = _FT("paddq");
extern const fcml_cstring M_PADDSB = _FT("paddsb");
extern const fcml_cstring M_PADDSW = _FT("paddsw");
extern const fcml_cstring M_PADDUSB = _FT("paddusb");
extern const fcml_cstring M_PADDUSW = _FT("paddusw");
extern const fcml_cstring M_PADDW = _FT("paddw");
extern const fcml_cstring M_PALIGNR = _FT("palignr");
extern const fcml_cstring M_PAND = _FT("pand");
extern const fcml_cstring M_PANDN = _FT("pandn");
extern const fcml_cstring M_PAUSE = _FT("pause");
extern const fcml_cstring M_PAVGB = _FT("pavgb");
extern const fcml_cstring M_PAVGUSB = _FT("pavgusb");
extern const fcml_cstring M_PAVGW = _FT("pavgw");
extern const fcml_cstring M_PBLENDVB = _FT("pblendvb");
extern const fcml_cstring M_PBLENDW = _FT("pblendw");
extern const fcml_cstring M_PCLMULQDQ = _FT("pclmulqdq");
extern const fcml_cstring M_PCMPEQB = _FT("pcmpeqb");
extern const fcml_cstring M_PCMPEQD = _FT("pcmpeqd");
extern const fcml_cstring M_PCMPEQQ = _FT("pcmpeqq");
extern const fcml_cstring M_PCMPEQW = _FT("pcmpeqw");
extern const fcml_cstring M_PCMPESTRI = _FT("pcmpestri");
extern const fcml_cstring M_PCMPESTRM = _FT("pcmpestrm");
extern const fcml_cstring M_PCMPGTB = _FT("pcmpgtb");
extern const fcml_cstring M_PCMPGTD = _FT("pcmpgtd");
extern const fcml_cstring M_PCMPGTQ = _FT("pcmpgtq");
extern const fcml_cstring M_PCMPGTW = _FT("pcmpgtw");
extern const fcml_cstring M_PCMPISTRI = _FT("pcmpistri");
extern const fcml_cstring M_PCMPISTRM = _FT("pcmpistrm");
extern const fcml_cstring M_PDEP = _FT("pdep");
extern const fcml_cstring M_PEXT = _FT("pext");
extern const fcml_cstring M_PEXTRB = _FT("pextrb");
extern const fcml_cstring M_PEXTRD = _FT("pextrd");
extern const fcml_cstring M_PEXTRQ = _FT("pextrq");
extern const fcml_cstring M_PEXTRW = _FT("pextrw");
extern const fcml_cstring M_PF2ID = _FT("pf2id");
extern const fcml_cstring M_PF2IW = _FT("pf2iw");
extern const fcml_cstring M_PFACC = _FT("pfacc");
extern const fcml_cstring M_PFADD = _FT("pfadd");
extern const fcml_cstring M_PFCMPEQ = _FT("pfcmpeq");
extern const fcml_cstring M_PFCMPGE = _FT("pfcmpge");
extern const fcml_cstring M_PFCMPGT = _FT("pfcmpgt");
extern const fcml_cstring M_PFMAX = _FT("pfmax");
extern const fcml_cstring M_PFMIN = _FT("pfmin");
extern const fcml_cstring M_PFMUL = _FT("pfmul");
extern const fcml_cstring M_PFNACC = _FT("pfnacc");
extern const fcml_cstring M_PFPNACC = _FT("pfpnacc");
extern const fcml_cstring M_PFRCP = _FT("pfrcp");
extern const fcml_cstring M_PFRCPIT1 = _FT("pfrcpit1");
extern const fcml_cstring M_PFRCPIT2 = _FT("pfrcpit2");
extern const fcml_cstring M_PFRSQIT1 = _FT("pfrsqit1");
extern const fcml_cstring M_PFRSQRT = _FT("pfrsqrt");
extern const fcml_cstring M_PFSUB = _FT("pfsub");
extern const fcml_cstring M_PFSUBR = _FT("pfsubr");
extern const fcml_cstring M_PHADDD = _FT("phaddd");
extern const fcml_cstring M_PHADDSW = _FT("phaddsw");
extern const fcml_cstring M_PHADDW = _FT("phaddw");
extern const fcml_cstring M_PHMINPOSUW = _FT("phminposuw");
extern const fcml_cstring M_PHSUBD = _FT("phsubd");
extern const fcml_cstring M_PHSUBSW = _FT("phsubsw");
extern const fcml_cstring M_PHSUBW = _FT("phsubw");
extern const fcml_cstring M_PI2FD = _FT("pi2fd");
extern const fcml_cstring M_PI2FW = _FT("pi2fw");
extern const fcml_cstring M_PINSRB = _FT("pinsrb");
extern const fcml_cstring M_PINSRD = _FT("pinsrd");
extern const fcml_cstring M_PINSRQ = _FT("pinsrq");
extern const fcml_cstring M_PINSRW = _FT("pinsrw");
extern const fcml_cstring M_PMADDUBSW = _FT("pmaddubsw");
extern const fcml_cstring M_PMADDWD = _FT("pmaddwd");
extern const fcml_cstring M_PMAXSB = _FT("pmaxsb");
extern const fcml_cstring M_PMAXSD = _FT("pmaxsd");
extern const fcml_cstring M_PMAXSW = _FT("pmaxsw");
extern const fcml_cstring M_PMAXUB = _FT("pmaxub");
extern const fcml_cstring M_PMAXUD = _FT("pmaxud");
extern const fcml_cstring M_PMAXUW = _FT("pmaxuw");
extern const fcml_cstring M_PMINSB = _FT("pminsb");
extern const fcml_cstring M_PMINSD = _FT("pminsd");
extern const fcml_cstring M_PMINSW = _FT("pminsw");
extern const fcml_cstring M_PMINUB = _FT("pminub");
extern const fcml_cstring M_PMINUD = _FT("pminud");
extern const fcml_cstring M_PMINUW = _FT("pminuw");
extern const fcml_cstring M_PMOVMSKB = _FT("pmovmskb");
extern const fcml_cstring M_PMOVSXBD = _FT("pmovsxbd");
extern const fcml_cstring M_PMOVSXBQ = _FT("pmovsxbq");
extern const fcml_cstring M_PMOVSXBW = _FT("pmovsxbw");
extern const fcml_cstring M_PMOVSXDQ = _FT("pmovsxdq");
extern const fcml_cstring M_PMOVSXWD = _FT("pmovsxwd");
extern const fcml_cstring M_PMOVSXWQ = _FT("pmovsxwq");
extern const fcml_cstring M_PMOVZXBD = _FT("pmovzxbd");
extern const fcml_cstring M_PMOVZXBQ = _FT("pmovzxbq");
extern const fcml_cstring M_PMOVZXBW = _FT("pmovzxbw");
extern const fcml_cstring M_PMOVZXDQ = _FT("pmovzxdq");
extern const fcml_cstring M_PMOVZXWD = _FT("pmovzxwd");
extern const fcml_cstring M_PMOVZXWQ = _FT("pmovzxwq");
extern const fcml_cstring M_PMULDQ = _FT("pmuldq");
extern const fcml_cstring M_PMULHRSW = _FT("pmulhrsw");
extern const fcml_cstring M_PMULHRW = _FT("pmulhrw");
extern const fcml_cstring M_PMULHUW = _FT("pmulhuw");
extern const fcml_cstring M_PMULHW = _FT("pmulhw");
extern const fcml_cstring M_PMULLD = _FT("pmulld");
extern const fcml_cstring M_PMULLW = _FT("pmullw");
extern const fcml_cstring M_PMULUDQ = _FT("pmuludq");
extern const fcml_cstring M_POP = _FT("pop");
extern const fcml_cstring M_POPA = _FT("popa");
extern const fcml_cstring M_POPAD = _FT("popad");
extern const fcml_cstring M_POPCNT = _FT("popcnt");
extern const fcml_cstring M_POPF = _FT("popf");
extern const fcml_cstring M_POPFD = _FT("popfd");
extern const fcml_cstring M_POPFQ = _FT("popfq");
extern const fcml_cstring M_POR = _FT("por");
extern const fcml_cstring M_PREFETCH = _FT("prefetch");
extern const fcml_cstring M_PREFETCHNTA = _FT("prefetchnta");
extern const fcml_cstring M_PREFETCHT0 = _FT("prefetcht0");
extern const fcml_cstring M_PREFETCHT1 = _FT("prefetcht1");
extern const fcml_cstring M_PREFETCHT2 = _FT("prefetcht2");
extern const fcml_cstring M_PREFETCHW = _FT("prefetchw");
extern const fcml_cstring M_PREFETCHWT1 = _FT("prefetchwt1");
extern const fcml_cstring M_PSADBW = _FT("psadbw");
extern const fcml_cstring M_PSHUFB = _FT("pshufb");
extern const fcml_cstring M_PSHUFD = _FT("pshufd");
extern const fcml_cstring M_PSHUFHW = _FT("pshufhw");
extern const fcml_cstring M_PSHUFLW = _FT("pshuflw");
extern const fcml_cstring M_PSHUFW = _FT("pshufw");
extern const fcml_cstring M_PSIGNB = _FT("psignb");
extern const fcml_cstring M_PSIGND = _FT("psignd");
extern const fcml_cstring M_PSIGNW = _FT("psignw");
extern const fcml_cstring M_PSLLD = _FT("pslld");
extern const fcml_cstring M_PSLLDQ = _FT("pslldq");
extern const fcml_cstring M_PSLLQ = _FT("psllq");
extern const fcml_cstring M_PSLLW = _FT("psllw");
extern const fcml_cstring M_PSRAD = _FT("psrad");
extern const fcml_cstring M_PSRAW = _FT("psraw");
extern const fcml_cstring M_PSRLD = _FT("psrld");
extern const fcml_cstring M_PSRLDQ = _FT("psrldq");
extern const fcml_cstring M_PSRLQ = _FT("psrlq");
extern const fcml_cstring M_PSRLW = _FT("psrlw");
extern const fcml_cstring M_PSUBB = _FT("psubb");
extern const fcml_cstring M_PSUBD = _FT("psubd");
extern const fcml_cstring M_PSUBQ = _FT("psubq");
extern const fcml_cstring M_PSUBSB = _FT("psubsb");
extern const fcml_cstring M_PSUBSW = _FT("psubsw");
extern const fcml_cstring M_PSUBUSB = _FT("psubusb");
extern const fcml_cstring M_PSUBUSW = _FT("psubusw");
extern const fcml_cstring M_PSUBW = _FT("psubw");
extern const fcml_cstring M_PSWAPD = _FT("pswapd");
extern const fcml_cstring M_PTEST = _FT("ptest");
extern const fcml_cstring M_PUNPCKHBW = _FT("punpckhbw");
extern const fcml_cstring M_PUNPCKHDQ = _FT("punpckhdq");
extern const fcml_cstring M_PUNPCKHQDQ = _FT("punpckhqdq");
extern const fcml_cstring M_PUNPCKHWD = _FT("punpckhwd");
extern const fcml_cstring M_PUNPCKLBW = _FT("punpcklbw");
extern const fcml_cstring M_PUNPCKLDQ = _FT("punpckldq");
extern const fcml_cstring M_PUNPCKLQDQ = _FT("punpcklqdq");
extern const fcml_cstring M_PUNPCKLWD = _FT("punpcklwd");
extern const fcml_cstring M_PUSH = _FT("push");
extern const fcml_cstring M_PUSHA = _FT("pusha");
extern const fcml_cstring M_PUSHAD = _FT("pushad");
extern const fcml_cstring M_PUSHF = _FT("pushf");
extern const fcml_cstring M_PUSHFD = _FT("pushfd");
extern const fcml_cstring M_PUSHFQ = _FT("pushfq");
extern const fcml_cstring M_PXOR = _FT("pxor");
extern const fcml_cstring M_RCL = _FT("rcl");
extern const fcml_cstring M_RCPPS = _FT("rcpps");
extern const fcml_cstring M_RCPSS = _FT("rcpss");
extern const fcml_cstring M_RCR = _FT("rcr");
extern const fcml_cstring M_RDFSBASE = _FT("rdfsbase");
extern const fcml_cstring M_RDGSBASE = _FT("rdgsbase");
extern const fcml_cstring M_RDMSR = _FT("rdmsr");
extern const fcml_cstring M_RDPMC = _FT("rdpmc");
extern const fcml_cstring M_RDRAND = _FT("rdrand");
extern const fcml_cstring M_RDSEED = _FT("rdseed");
extern const fcml_cstring M_RDTSC = _FT("rdtsc");
extern const fcml_cstring M_RDTSCP = _FT("rdtscp");
extern const fcml_cstring M_RET = _FT("ret");
extern const fcml_cstring M_RETF = _FT("retf");
extern const fcml_cstring M_ROL = _FT("rol");
extern const fcml_cstring M_ROR = _FT("ror");
extern const fcml_cstring M_RORX = _FT("rorx");
extern const fcml_cstring M_ROUNDPD = _FT("roundpd");
extern const fcml_cstring M_ROUNDPS = _FT("roundps");
extern const fcml_cstring M_ROUNDSD = _FT("roundsd");
extern const fcml_cstring M_ROUNDSS = _FT("roundss");
extern const fcml_cstring M_RSM = _FT("rsm");
extern const fcml_cstring M_RSQRTPS = _FT("rsqrtps");
extern const fcml_cstring M_RSQRTSS = _FT("rsqrtss");
extern const fcml_cstring M_SAHF = _FT("sahf");
extern const fcml_cstring M_SAL = _FT("sal");
extern const fcml_cstring M_SAR = _FT("sar");
extern const fcml_cstring M_SARX = _FT("sarx");
extern const fcml_cstring M_SBB = _FT("sbb");
extern const fcml_cstring M_SCAS = _FT("scas");
extern const fcml_cstring M_SCASB = _FT("scasb");
extern const fcml_cstring M_SCASD = _FT("scasd");
extern const fcml_cstring M_SCASQ = _FT("scasq");
extern const fcml_cstring M_SCASW = _FT("scasw");
extern const fcml_cstring M_SETA = _FT("seta");
extern const fcml_cstring M_SETAE = _FT("setae");
extern const fcml_cstring M_SETB = _FT("setb");
extern const fcml_cstring M_SETBE = _FT("setbe");
extern const fcml_cstring M_SETC = _FT("setc");
extern const fcml_cstring M_SETENE = _FT("setene");
extern const fcml_cstring M_SETG = _FT("setg");
extern const fcml_cstring M_SETGE = _FT("setge");
extern const fcml_cstring M_SETL = _FT("setl");
extern const fcml_cstring M_SETLE = _FT("setle");
extern const fcml_cstring M_SETNA = _FT("setna");
extern const fcml_cstring M_SETNAE = _FT("setnae");
extern const fcml_cstring M_SETNB = _FT("setnb");
extern const fcml_cstring M_SETNBE = _FT("setnbe");
extern const fcml_cstring M_SETNC = _FT("setnc");
extern const fcml_cstring M_SETNG = _FT("setng");
extern const fcml_cstring M_SETNGE = _FT("setnge");
extern const fcml_cstring M_SETNL = _FT("setnl");
extern const fcml_cstring M_SETNLE = _FT("setnle");
extern const fcml_cstring M_SETNO = _FT("setno");
extern const fcml_cstring M_SETNP = _FT("setnp");
extern const fcml_cstring M_SETNS = _FT("setns");
extern const fcml_cstring M_SETNZ = _FT("setnz");
extern const fcml_cstring M_SETO = _FT("seto");
extern const fcml_cstring M_SETP = _FT("setp");
extern const fcml_cstring M_SETPE = _FT("setpe");
extern const fcml_cstring M_SETPO = _FT("setpo");
extern const fcml_cstring M_SETS = _FT("sets");
extern const fcml_cstring M_SETZ = _FT("setz");
extern const fcml_cstring M_SFENCE = _FT("sfence");
extern const fcml_cstring M_SGDT = _FT("sgdt");
extern const fcml_cstring M_SHL = _FT("shl");
extern const fcml_cstring M_SHLD = _FT("shld");
extern const fcml_cstring M_SHLX = _FT("shlx");
extern const fcml_cstring M_SHR = _FT("shr");
extern const fcml_cstring M_SHRD = _FT("shrd");
extern const fcml_cstring M_SHRX = _FT("shrx");
extern const fcml_cstring M_SHUFPD = _FT("shufpd");
extern const fcml_cstring M_SHUFPS = _FT("shufps");
extern const fcml_cstring M_SIDT = _FT("sidt");
extern const fcml_cstring M_SKINIT = _FT("skinit");
extern const fcml_cstring M_SLDT = _FT("sldt");
extern const fcml_cstring M_SLWPCB = _FT("slwpcb");
extern const fcml_cstring M_SMSW = _FT("smsw");
extern const fcml_cstring M_SQRTPD = _FT("sqrtpd");
extern const fcml_cstring M_SQRTPS = _FT("sqrtps");
extern const fcml_cstring M_SQRTSD = _FT("sqrtsd");
extern const fcml_cstring M_SQRTSS = _FT("sqrtss");
extern const fcml_cstring M_STAC = _FT("stac");
extern const fcml_cstring M_STC = _FT("stc");
extern const fcml_cstring M_STD = _FT("std");
extern const fcml_cstring M_STGI = _FT("stgi");
extern const fcml_cstring M_STI = _FT("sti");
extern const fcml_cstring M_STMXCSR = _FT("stmxcsr");
extern const fcml_cstring M_STOS = _FT("stos");
extern const fcml_cstring M_STOSB = _FT("stosb");
extern const fcml_cstring M_STOSD = _FT("stosd");
extern const fcml_cstring M_STOSQ = _FT("stosq");
extern const fcml_cstring M_STOSW = _FT("stosw");
extern const fcml_cstring M_STR = _FT("str");
extern const fcml_cstring M_SUB = _FT("sub");
extern const fcml_cstring M_SUBPD = _FT("subpd");
extern const fcml_cstring M_SUBPS = _FT("subps");
extern const fcml_cstring M_SUBSD = _FT("subsd");
extern const fcml_cstring M_SUBSS = _FT("subss");
extern const fcml_cstring M_SWAPGS = _FT("swapgs");
extern const fcml_cstring M_SYSCALL = _FT("syscall");
extern const fcml_cstring M_SYSENTER = _FT("sysenter");
extern const fcml_cstring M_SYSEXIT = _FT("sysexit");
extern const fcml_cstring M_SYSRET = _FT("sysret");
extern const fcml_cstring M_T1MSKC = _FT("t1mskc");
extern const fcml_cstring M_TEST = _FT("test");
extern const fcml_cstring M_TZCNT = _FT("tzcnt");
extern const fcml_cstring M_TZMSK = _FT("tzmsk");
extern const fcml_cstring M_UCOMISD = _FT("ucomisd");
extern const fcml_cstring M_UCOMISS = _FT("ucomiss");
extern const fcml_cstring M_UD2 = _FT("ud2");
extern const fcml_cstring M_UNPCKHPD = _FT("unpckhpd");
extern const fcml_cstring M_UNPCKHPS = _FT("unpckhps");
extern const fcml_cstring M_UNPCKLPD = _FT("unpcklpd");
extern const fcml_cstring M_UNPCKLPS = _FT("unpcklps");
extern const fcml_cstring M_V4FMADDPS = _FT("v4fmaddps");
extern const fcml_cstring M_V4FMADDSS = _FT("v4fmaddss");
extern const fcml_cstring M_V4FNMADDPS = _FT("v4fnmaddps");
extern const fcml_cstring M_V4FNMADDSS = _FT("v4fnmaddss");
extern const fcml_cstring M_VADDPD = _FT("vaddpd");
extern const fcml_cstring M_VADDPS = _FT("vaddps");
extern const fcml_cstring M_VADDSD = _FT("vaddsd");
extern const fcml_cstring M_VADDSS = _FT("vaddss");
extern const fcml_cstring M_VADDSUBPD = _FT("vaddsubpd");
extern const fcml_cstring M_VADDSUBPS = _FT("vaddsubps");
extern const fcml_cstring M_VAESDEC = _FT("vaesdec");
extern const fcml_cstring M_VAESDECLAST = _FT("vaesdeclast");
extern const fcml_cstring M_VAESENC = _FT("vaesenc");
extern const fcml_cstring M_VAESENCLAST = _FT("vaesenclast");
extern const fcml_cstring M_VAESIMC = _FT("vaesimc");
extern const fcml_cstring M_VAESKEYGENASSIST = _FT("vaeskeygenassist");
extern const fcml_cstring M_VALIGND = _FT("valignd");
extern const fcml_cstring M_VALIGNQ = _FT("valignq");
extern const fcml_cstring M_VANDNPD = _FT("vandnpd");
extern const fcml_cstring M_VANDNPS = _FT("vandnps");
extern const fcml_cstring M_VANDPD = _FT("vandpd");
extern const fcml_cstring M_VANDPS = _FT("vandps");
extern const fcml_cstring M_VBLENDMPD = _FT("vblendmpd");
extern const fcml_cstring M_VBLENDMPS = _FT("vblendmps");
extern const fcml_cstring M_VBLENDPD = _FT("vblendpd");
extern const fcml_cstring M_VBLENDPS = _FT("vblendps");
extern const fcml_cstring M_VBLENDVPD = _FT("vblendvpd");
extern const fcml_cstring M_VBLENDVPS = _FT("vblendvps");
extern const fcml_cstring M_VBROADCASTF128 = _FT("vbroadcastf128");
extern const fcml_cstring M_VBROADCASTF32X2 = _FT("vbroadcastf32x2");
extern const fcml_cstring M_VBROADCASTF32X4 = _FT("vbroadcastf32x4");
extern const fcml_cstring M_VBROADCASTF32X8 = _FT("vbroadcastf32x8");
extern const fcml_cstring M_VBROADCASTF64X2 = _FT("vbroadcastf64x2");
extern const fcml_cstring M_VBROADCASTF64X4 = _FT("vbroadcastf64x4");
extern const fcml_cstring M_VBROADCASTI128 = _FT("vbroadcasti128");
extern const fcml_cstring M_VBROADCASTI32X2 = _FT("vbroadcasti32x2");
extern const fcml_cstring M_VBROADCASTI32X4 = _FT("vbroadcasti32x4");
extern const fcml_cstring M_VBROADCASTI32X8 = _FT("vbroadcasti32x8");
extern const fcml_cstring M_VBROADCASTI64X2 = _FT("vbroadcasti64x2");
extern const fcml_cstring M_VBROADCASTI64X4 = _FT("vbroadcasti64x4");
extern const fcml_cstring M_VBROADCASTSD = _FT("vbroadcastsd");
extern const fcml_cstring M_VBROADCASTSS = _FT("vbroadcastss");
extern const fcml_cstring M_VCMPEQ_OSPD = _FT("vcmpeq_ospd");
extern const fcml_cstring M_VCMPEQ_OSPS = _FT("vcmpeq_osps");
extern const fcml_cstring M_VCMPEQ_OSSD = _FT("vcmpeq_ossd");
extern const fcml_cstring M_VCMPEQ_OSSS = _FT("vcmpeq_osss");
extern const fcml_cstring M_VCMPEQ_UQPD = _FT("vcmpeq_uqpd");
extern const fcml_cstring M_VCMPEQ_UQPS = _FT("vcmpeq_uqps");
extern const fcml_cstring M_VCMPEQ_UQSD = _FT("vcmpeq_uqsd");
extern const fcml_cstring M_VCMPEQ_UQSS = _FT("vcmpeq_uqss");
extern const fcml_cstring M_VCMPEQ_USPD = _FT("vcmpeq_uspd");
extern const fcml_cstring M_VCMPEQ_USPS = _FT("vcmpeq_usps");
extern const fcml_cstring M_VCMPEQ_USSD = _FT("vcmpeq_ussd");
extern const fcml_cstring M_VCMPEQ_USSS = _FT("vcmpeq_usss");
extern const fcml_cstring M_VCMPEQPD = _FT("vcmpeqpd");
extern const fcml_cstring M_VCMPEQPS = _FT("vcmpeqps");
extern const fcml_cstring M_VCMPEQSD = _FT("vcmpeqsd");
extern const fcml_cstring M_VCMPEQSS = _FT("vcmpeqss");
extern const fcml_cstring M_VCMPFALSE_OSPD = _FT("vcmpfalse_ospd");
extern const fcml_cstring M_VCMPFALSE_OSPS = _FT("vcmpfalse_osps");
extern const fcml_cstring M_VCMPFALSE_OSSD = _FT("vcmpfalse_ossd");
extern const fcml_cstring M_VCMPFALSE_OSSS = _FT("vcmpfalse_osss");
extern const fcml_cstring M_VCMPFALSEPD = _FT("vcmpfalsepd");
extern const fcml_cstring M_VCMPFALSEPS = _FT("vcmpfalseps");
extern const fcml_cstring M_VCMPFALSESD = _FT("vcmpfalsesd");
extern const fcml_cstring M_VCMPFALSESS = _FT("vcmpfalsess");
extern const fcml_cstring M_VCMPGE_OQPD = _FT("vcmpge_oqpd");
extern const fcml_cstring M_VCMPGE_OQPS = _FT("vcmpge_oqps");
extern const fcml_cstring M_VCMPGE_OQSD = _FT("vcmpge_oqsd");
extern const fcml_cstring M_VCMPGE_OQSS = _FT("vcmpge_oqss");
extern const fcml_cstring M_VCMPGEPD = _FT("vcmpgepd");
extern const fcml_cstring M_VCMPGEPS = _FT("vcmpgeps");
extern const fcml_cstring M_VCMPGESD = _FT("vcmpgesd");
extern const fcml_cstring M_VCMPGESS = _FT("vcmpgess");
extern const fcml_cstring M_VCMPGT_OQPD = _FT("vcmpgt_oqpd");
extern const fcml_cstring M_VCMPGT_OQPS = _FT("vcmpgt_oqps");
extern const fcml_cstring M_VCMPGT_OQSD = _FT("vcmpgt_oqsd");
extern const fcml_cstring M_VCMPGT_OQSS = _FT("vcmpgt_oqss");
extern const fcml_cstring M_VCMPGTPD = _FT("vcmpgtpd");
extern const fcml_cstring M_VCMPGTPS = _FT("vcmpgtps");
extern const fcml_cstring M_VCMPGTSD = _FT("vcmpgtsd");
extern const fcml_cstring M_VCMPGTSS = _FT("vcmpgtss");
extern const fcml_cstring M_VCMPLE_OQPD = _FT("vcmple_oqpd");
extern const fcml_cstring M_VCMPLE_OQPS = _FT("vcmple_oqps");
extern const fcml_cstring M_VCMPLE_OQSD = _FT("vcmple_oqsd");
extern const fcml_cstring M_VCMPLE_OQSS = _FT("vcmple_oqss");
extern const fcml_cstring M_VCMPLEPD = _FT("vcmplepd");
extern const fcml_cstring M_VCMPLEPS = _FT("vcmpleps");
extern const fcml_cstring M_VCMPLESD = _FT("vcmplesd");
extern const fcml_cstring M_VCMPLESS = _FT("vcmpless");
extern const fcml_cstring M_VCMPLT_OQPD = _FT("vcmplt_oqpd");
extern const fcml_cstring M_VCMPLT_OQPS = _FT("vcmplt_oqps");
extern const fcml_cstring M_VCMPLT_OQSD = _FT("vcmplt_oqsd");
extern const fcml_cstring M_VCMPLT_OQSS = _FT("vcmplt_oqss");
extern const fcml_cstring M_VCMPLTPD = _FT("vcmpltpd");
extern const fcml_cstring M_VCMPLTPS = _FT("vcmpltps");
extern const fcml_cstring M_VCMPLTSD = _FT("vcmpltsd");
extern const fcml_cstring M_VCMPLTSS = _FT("vcmpltss");
extern const fcml_cstring M_VCMPNEQ_OQPD = _FT("vcmpneq_oqpd");
extern const fcml_cstring M_VCMPNEQ_OQPS = _FT("vcmpneq_oqps");
extern const fcml_cstring M_VCMPNEQ_OQSD = _FT("vcmpneq_oqsd");
extern const fcml_cstring M_VCMPNEQ_OQSS = _FT("vcmpneq_oqss");
extern const fcml_cstring M_VCMPNEQ_OSPD = _FT("vcmpneq_ospd");
extern const fcml_cstring M_VCMPNEQ_OSPS = _FT("vcmpneq_osps");
extern const fcml_cstring M_VCMPNEQ_OSSD = _FT("vcmpneq_ossd");
extern const fcml_cstring M_VCMPNEQ_OSSS = _FT("vcmpneq_osss");
extern const fcml_cstring M_VCMPNEQ_USPD = _FT("vcmpneq_uspd");
extern const fcml_cstring M_VCMPNEQ_USPS = _FT("vcmpneq_usps");
extern const fcml_cstring M_VCMPNEQ_USSD = _FT("vcmpneq_ussd");
extern const fcml_cstring M_VCMPNEQ_USSS = _FT("vcmpneq_usss");
extern const fcml_cstring M_VCMPNEQPD = _FT("vcmpneqpd");
extern const fcml_cstring M_VCMPNEQPS = _FT("vcmpneqps");
extern const fcml_cstring M_VCMPNEQSD = _FT("vcmpneqsd");
extern const fcml_cstring M_VCMPNEQSS = _FT("vcmpneqss");
extern const fcml_cstring M_VCMPNGE_UQPD = _FT("vcmpnge_uqpd");
extern const fcml_cstring M_VCMPNGE_UQPS = _FT("vcmpnge_uqps");
extern const fcml_cstring M_VCMPNGE_UQSD = _FT("vcmpnge_uqsd");
extern const fcml_cstring M_VCMPNGE_UQSS = _FT("vcmpnge_uqss");
extern const fcml_cstring M_VCMPNGEPD = _FT("vcmpngepd");
extern const fcml_cstring M_VCMPNGEPS = _FT("vcmpngeps");
extern const fcml_cstring M_VCMPNGESD = _FT("vcmpngesd");
extern const fcml_cstring M_VCMPNGESS = _FT("vcmpngess");
extern const fcml_cstring M_VCMPNGT_UQPD = _FT("vcmpngt_uqpd");
extern const fcml_cstring M_VCMPNGT_UQPS = _FT("vcmpngt_uqps");
extern const fcml_cstring M_VCMPNGT_UQSD = _FT("vcmpngt_uqsd");
extern const fcml_cstring M_VCMPNGT_UQSS = _FT("vcmpngt_uqss");
extern const fcml_cstring M_VCMPNGTPD = _FT("vcmpngtpd");
extern const fcml_cstring M_VCMPNGTPS = _FT("vcmpngtps");
extern const fcml_cstring M_VCMPNGTSD = _FT("vcmpngtsd");
extern const fcml_cstring M_VCMPNGTSS = _FT("vcmpngtss");
extern const fcml_cstring M_VCMPNLE_UQPD = _FT("vcmpnle_uqpd");
extern const fcml_cstring M_VCMPNLE_UQPS = _FT("vcmpnle_uqps");
extern const fcml_cstring M_VCMPNLE_UQSD = _FT("vcmpnle_uqsd");
extern const fcml_cstring M_VCMPNLE_UQSS = _FT("vcmpnle_uqss");
extern const fcml_cstring M_VCMPNLEPD = _FT("vcmpnlepd");
extern const fcml_cstring M_VCMPNLEPS = _FT("vcmpnleps");
extern const fcml_cstring M_VCMPNLESD = _FT("vcmpnlesd");
extern const fcml_cstring M_VCMPNLESS = _FT("vcmpnless");
extern const fcml_cstring M_VCMPNLT_UQPD = _FT("vcmpnlt_uqpd");
extern const fcml_cstring M_VCMPNLT_UQPS = _FT("vcmpnlt_uqps");
extern const fcml_cstring M_VCMPNLT_UQSD = _FT("vcmpnlt_uqsd");
extern const fcml_cstring M_VCMPNLT_UQSS = _FT("vcmpnlt_uqss");
extern const fcml_cstring M_VCMPNLTPD = _FT("vcmpnltpd");
extern const fcml_cstring M_VCMPNLTPS = _FT("vcmpnltps");
extern const fcml_cstring M_VCMPNLTSD = _FT("vcmpnltsd");
extern const fcml_cstring M_VCMPNLTSS = _FT("vcmpnltss");
extern const fcml_cstring M_VCMPORD_SPD = _FT("vcmpord_spd");
extern const fcml_cstring M_VCMPORD_SPS = _FT("vcmpord_sps");
extern const fcml_cstring M_VCMPORD_SSD = _FT("vcmpord_ssd");
extern const fcml_cstring M_VCMPORD_SSS = _FT("vcmpord_sss");
extern const fcml_cstring M_VCMPORDPD = _FT("vcmpordpd");
extern const fcml_cstring M_VCMPORDPS = _FT("vcmpordps");
extern const fcml_cstring M_VCMPORDSD = _FT("vcmpordsd");
extern const fcml_cstring M_VCMPORDSS = _FT("vcmpordss");
extern const fcml_cstring M_VCMPPD = _FT("vcmppd");
extern const fcml_cstring M_VCMPPS = _FT("vcmpps");
extern const fcml_cstring M_VCMPSD = _FT("vcmpsd");
extern const fcml_cstring M_VCMPSS = _FT("vcmpss");
extern const fcml_cstring M_VCMPTRUE_USPD = _FT("vcmptrue_uspd");
extern const fcml_cstring M_VCMPTRUE_USPS = _FT("vcmptrue_usps");
extern const fcml_cstring M_VCMPTRUE_USSD = _FT("vcmptrue_ussd");
extern const fcml_cstring M_VCMPTRUE_USSS = _FT("vcmptrue_usss");
extern const fcml_cstring M_VCMPTRUEPD = _FT("vcmptruepd");
extern const fcml_cstring M_VCMPTRUEPS = _FT("vcmptrueps");
extern const fcml_cstring M_VCMPTRUESD = _FT("vcmptruesd");
extern const fcml_cstring M_VCMPTRUESS = _FT("vcmptruess");
extern const fcml_cstring M_VCMPUNORD_SPD = _FT("vcmpunord_spd");
extern const fcml_cstring M_VCMPUNORD_SPS = _FT("vcmpunord_sps");
extern const fcml_cstring M_VCMPUNORD_SSD = _FT("vcmpunord_ssd");
extern const fcml_cstring M_VCMPUNORD_SSS = _FT("vcmpunord_sss");
extern const fcml_cstring M_VCMPUNORDPD = _FT("vcmpunordpd");
extern const fcml_cstring M_VCMPUNORDPS = _FT("vcmpunordps");
extern const fcml_cstring M_VCMPUNORDSD = _FT("vcmpunordsd");
extern const fcml_cstring M_VCMPUNORDSS = _FT("vcmpunordss");
extern const fcml_cstring M_VCOMISD = _FT("vcomisd");
extern const fcml_cstring M_VCOMISS = _FT("vcomiss");
extern const fcml_cstring M_VCOMPRESSPD = _FT("vcompresspd");
extern const fcml_cstring M_VCOMPRESSPS = _FT("vcompressps");
extern const fcml_cstring M_VCVTDQ2PD = _FT("vcvtdq2pd");
extern const fcml_cstring M_VCVTDQ2PS = _FT("vcvtdq2ps");
extern const fcml_cstring M_VCVTPD2DQ = _FT("vcvtpd2dq");
extern const fcml_cstring M_VCVTPD2PS = _FT("vcvtpd2ps");
extern const fcml_cstring M_VCVTPD2QQ = _FT("vcvtpd2qq");
extern const fcml_cstring M_VCVTPD2UDQ = _FT("vcvtpd2udq");
extern const fcml_cstring M_VCVTPD2UQQ = _FT("vcvtpd2uqq");
extern const fcml_cstring M_VCVTPH2PS = _FT("vcvtph2ps");
extern const fcml_cstring M_VCVTPS2DQ = _FT("vcvtps2dq");
extern const fcml_cstring M_VCVTPS2PD = _FT("vcvtps2pd");
extern const fcml_cstring M_VCVTPS2PH = _FT("vcvtps2ph");
extern const fcml_cstring M_VCVTPS2QQ = _FT("vcvtps2qq");
extern const fcml_cstring M_VCVTPS2UDQ = _FT("vcvtps2udq");
extern const fcml_cstring M_VCVTPS2UQQ = _FT("vcvtps2uqq");
extern const fcml_cstring M_VCVTQQ2PD = _FT("vcvtqq2pd");
extern const fcml_cstring M_VCVTQQ2PS = _FT("vcvtqq2ps");
extern const fcml_cstring M_VCVTSD2SI = _FT("vcvtsd2si");
extern const fcml_cstring M_VCVTSD2SS = _FT("vcvtsd2ss");
extern const fcml_cstring M_VCVTSD2USI = _FT("vcvtsd2usi");
extern const fcml_cstring M_VCVTSI2SD = _FT("vcvtsi2sd");
extern const fcml_cstring M_VCVTSI2SS = _FT("vcvtsi2ss");
extern const fcml_cstring M_VCVTSS2SD = _FT("vcvtss2sd");
extern const fcml_cstring M_VCVTSS2SI = _FT("vcvtss2si");
extern const fcml_cstring M_VCVTSS2USI = _FT("vcvtss2usi");
extern const fcml_cstring M_VCVTTPD2DQ = _FT("vcvttpd2dq");
extern const fcml_cstring M_VCVTTPD2QQ = _FT("vcvttpd2qq");
extern const fcml_cstring M_VCVTTPD2UDQ = _FT("vcvttpd2udq");
extern const fcml_cstring M_VCVTTPD2UQQ = _FT("vcvttpd2uqq");
extern const fcml_cstring M_VCVTTPS2DQ = _FT("vcvttps2dq");
extern const fcml_cstring M_VCVTTPS2QQ = _FT("vcvttps2qq");
extern const fcml_cstring M_VCVTTPS2UDQ = _FT("vcvttps2udq");
extern const fcml_cstring M_VCVTTPS2UQQ = _FT("vcvttps2uqq");
extern const fcml_cstring M_VCVTTSD2SI = _FT("vcvttsd2si");
extern const fcml_cstring M_VCVTTSD2USI = _FT("vcvttsd2usi");
extern const fcml_cstring M_VCVTTSS2SI = _FT("vcvttss2si");
extern const fcml_cstring M_VCVTTSS2USI = _FT("vcvttss2usi");
extern const fcml_cstring M_VCVTUDQ2PD = _FT("vcvtudq2pd");
extern const fcml_cstring M_VCVTUDQ2PS = _FT("vcvtudq2ps");
extern const fcml_cstring M_VCVTUQQ2PD = _FT("vcvtuqq2pd");
extern const fcml_cstring M_VCVTUQQ2PS = _FT("vcvtuqq2ps");
extern const fcml_cstring M_VCVTUSI2SD = _FT("vcvtusi2sd");
extern const fcml_cstring M_VCVTUSI2SS = _FT("vcvtusi2ss");
extern const fcml_cstring M_VDBPSADBW = _FT("vdbpsadbw");
extern const fcml_cstring M_VDIVPD = _FT("vdivpd");
extern const fcml_cstring M_VDIVPS = _FT("vdivps");
extern const fcml_cstring M_VDIVSD = _FT("vdivsd");
extern const fcml_cstring M_VDIVSS = _FT("vdivss");
extern const fcml_cstring M_VDPPD = _FT("vdppd");
extern const fcml_cstring M_VDPPS = _FT("vdpps");
extern const fcml_cstring M_VERR = _FT("verr");
extern const fcml_cstring M_VERW = _FT("verw");
extern const fcml_cstring M_VEXP2PD = _FT("vexp2pd");
extern const fcml_cstring M_VEXP2PS = _FT("vexp2ps");
extern const fcml_cstring M_VEXPANDPD = _FT("vexpandpd");
extern const fcml_cstring M_VEXPANDPS = _FT("vexpandps");
extern const fcml_cstring M_VEXTRACTF128 = _FT("vextractf128");
extern const fcml_cstring M_VEXTRACTF32X4 = _FT("vextractf32x4");
extern const fcml_cstring M_VEXTRACTF32X8 = _FT("vextractf32x8");
extern const fcml_cstring M_VEXTRACTF64X2 = _FT("vextractf64x2");
extern const fcml_cstring M_VEXTRACTF64X4 = _FT("vextractf64x4");
extern const fcml_cstring M_VEXTRACTI128 = _FT("vextracti128");
extern const fcml_cstring M_VEXTRACTI32X4 = _FT("vextracti32x4");
extern const fcml_cstring M_VEXTRACTI32X8 = _FT("vextracti32x8");
extern const fcml_cstring M_VEXTRACTI64X2 = _FT("vextracti64x2");
extern const fcml_cstring M_VEXTRACTI64X4 = _FT("vextracti64x4");
extern const fcml_cstring M_VEXTRACTPS = _FT("vextractps");
extern const fcml_cstring M_VFIXUPIMMPD = _FT("vfixupimmpd");
extern const fcml_cstring M_VFIXUPIMMPS = _FT("vfixupimmps");
extern const fcml_cstring M_VFIXUPIMMSD = _FT("vfixupimmsd");
extern const fcml_cstring M_VFIXUPIMMSS = _FT("vfixupimmss");
extern const fcml_cstring M_VFMADD132PD = _FT("vfmadd132pd");
extern const fcml_cstring M_VFMADD132PS = _FT("vfmadd132ps");
extern const fcml_cstring M_VFMADD132SD = _FT("vfmadd132sd");
extern const fcml_cstring M_VFMADD132SS = _FT("vfmadd132ss");
extern const fcml_cstring M_VFMADD213PD = _FT("vfmadd213pd");
extern const fcml_cstring M_VFMADD213PS = _FT("vfmadd213ps");
extern const fcml_cstring M_VFMADD213SD = _FT("vfmadd213sd");
extern const fcml_cstring M_VFMADD213SS = _FT("vfmadd213ss");
extern const fcml_cstring M_VFMADD231PD = _FT("vfmadd231pd");
extern const fcml_cstring M_VFMADD231PS = _FT("vfmadd231ps");
extern const fcml_cstring M_VFMADD231SD = _FT("vfmadd231sd");
extern const fcml_cstring M_VFMADD231SS = _FT("vfmadd231ss");
extern const fcml_cstring M_VFMADDPD = _FT("vfmaddpd");
extern const fcml_cstring M_VFMADDPS = _FT("vfmaddps");
extern const fcml_cstring M_VFMADDSD = _FT("vfmaddsd");
extern const fcml_cstring M_VFMADDSS = _FT("vfmaddss");
extern const fcml_cstring M_VFMADDSUB132PD = _FT("vfmaddsub132pd");
extern const fcml_cstring M_VFMADDSUB132PS = _FT("vfmaddsub132ps");
extern const fcml_cstring M_VFMADDSUB213PD = _FT("vfmaddsub213pd");
extern const fcml_cstring M_VFMADDSUB213PS = _FT("vfmaddsub213ps");
extern const fcml_cstring M_VFMADDSUB231PD = _FT("vfmaddsub231pd");
extern const fcml_cstring M_VFMADDSUB231PS = _FT("vfmaddsub231ps");
extern const fcml_cstring M_VFMADDSUBPD = _FT("vfmaddsubpd");
extern const fcml_cstring M_VFMADDSUBPS = _FT("vfmaddsubps");
extern const fcml_cstring M_VFMSUB132PD = _FT("vfmsub132pd");
extern const fcml_cstring M_VFMSUB132PS = _FT("vfmsub132ps");
extern const fcml_cstring M_VFMSUB132SD = _FT("vfmsub132sd");
extern const fcml_cstring M_VFMSUB132SS = _FT("vfmsub132ss");
extern const fcml_cstring M_VFMSUB213PD = _FT("vfmsub213pd");
extern const fcml_cstring M_VFMSUB213PS = _FT("vfmsub213ps");
extern const fcml_cstring M_VFMSUB213SD = _FT("vfmsub213sd");
extern const fcml_cstring M_VFMSUB213SS = _FT("vfmsub213ss");
extern const fcml_cstring M_VFMSUB231PD = _FT("vfmsub231pd");
extern const fcml_cstring M_VFMSUB231PS = _FT("vfmsub231ps");
extern const fcml_cstring M_VFMSUB231SD = _FT("vfmsub231sd");
extern const fcml_cstring M_VFMSUB231SS = _FT("vfmsub231ss");
extern const fcml_cstring M_VFMSUBADD132PD = _FT("vfmsubadd132pd");
extern const fcml_cstring M_VFMSUBADD132PS = _FT("vfmsubadd132ps");
extern const fcml_cstring M_VFMSUBADD213PD = _FT("vfmsubadd213pd");
extern const fcml_cstring M_VFMSUBADD213PS = _FT("vfmsubadd213ps");
extern const fcml_cstring M_VFMSUBADD231PD = _FT("vfmsubadd231pd");
extern const fcml_cstring M_VFMSUBADD231PS = _FT("vfmsubadd231ps");
extern const fcml_cstring M_VFMSUBADDPD = _FT("vfmsubaddpd");
extern const fcml_cstring M_VFMSUBADDPS = _FT("vfmsubaddps");
extern const fcml_cstring M_VFMSUBPD = _FT("vfmsubpd");
extern const fcml_cstring M_VFMSUBPS = _FT("vfmsubps");
extern const fcml_cstring M_VFMSUBSD = _FT("vfmsubsd");
extern const fcml_cstring M_VFMSUBSS = _FT("vfmsubss");
extern const fcml_cstring M_VFNMADD132PD = _FT("vfnmadd132pd");
extern const fcml_cstring M_VFNMADD132PS = _FT("vfnmadd132ps");
extern const fcml_cstring M_VFNMADD132SD = _FT("vfnmadd132sd");
extern const fcml_cstring M_VFNMADD132SS = _FT("vfnmadd132ss");
extern const fcml_cstring M_VFNMADD213PD = _FT("vfnmadd213pd");
extern const fcml_cstring M_VFNMADD213PS = _FT("vfnmadd213ps");
extern const fcml_cstring M_VFNMADD213SD = _FT("vfnmadd213sd");
extern const fcml_cstring M_VFNMADD213SS = _FT("vfnmadd213ss");
extern const fcml_cstring M_VFNMADD231PD = _FT("vfnmadd231pd");
extern const fcml_cstring M_VFNMADD231PS = _FT("vfnmadd231ps");
extern const fcml_cstring M_VFNMADD231SD = _FT("vfnmadd231sd");
extern const fcml_cstring M_VFNMADD231SS = _FT("vfnmadd231ss");
extern const fcml_cstring M_VFNMADDPD = _FT("vfnmaddpd");
extern const fcml_cstring M_VFNMADDPS = _FT("vfnmaddps");
extern const fcml_cstring M_VFNMADDSD = _FT("vfnmaddsd");
extern const fcml_cstring M_VFNMADDSS = _FT("vfnmaddss");
extern const fcml_cstring M_VFNMSUB132PD = _FT("vfnmsub132pd");
extern const fcml_cstring M_VFNMSUB132PS = _FT("vfnmsub132ps");
extern const fcml_cstring M_VFNMSUB132SD = _FT("vfnmsub132sd");
extern const fcml_cstring M_VFNMSUB132SS = _FT("vfnmsub132ss");
extern const fcml_cstring M_VFNMSUB213PD = _FT("vfnmsub213pd");
extern const fcml_cstring M_VFNMSUB213PS = _FT("vfnmsub213ps");
extern const fcml_cstring M_VFNMSUB213SD = _FT("vfnmsub213sd");
extern const fcml_cstring M_VFNMSUB213SS = _FT("vfnmsub213ss");
extern const fcml_cstring M_VFNMSUB231PD = _FT("vfnmsub231pd");
extern const fcml_cstring M_VFNMSUB231PS = _FT("vfnmsub231ps");
extern const fcml_cstring M_VFNMSUB231SD = _FT("vfnmsub231sd");
extern const fcml_cstring M_VFNMSUB231SS = _FT("vfnmsub231ss");
extern const fcml_cstring M_VFNMSUBPD = _FT("vfnmsubpd");
extern const fcml_cstring M_VFNMSUBPS = _FT("vfnmsubps");
extern const fcml_cstring M_VFNMSUBSD = _FT("vfnmsubsd");
extern const fcml_cstring M_VFNMSUBSS = _FT("vfnmsubss");
extern const fcml_cstring M_VFPCLASSPD = _FT("vfpclasspd");
extern const fcml_cstring M_VFPCLASSPS = _FT("vfpclassps");
extern const fcml_cstring M_VFPCLASSSD = _FT("vfpclasssd");
extern const fcml_cstring M_VFPCLASSSS = _FT("vfpclassss");
extern const fcml_cstring M_VFRCZPD = _FT("vfrczpd");
extern const fcml_cstring M_VFRCZPS = _FT("vfrczps");
extern const fcml_cstring M_VFRCZSD = _FT("vfrczsd");
extern const fcml_cstring M_VFRCZSS = _FT("vfrczss");
extern const fcml_cstring M_VGATHERDPD = _FT("vgatherdpd");
extern const fcml_cstring M_VGATHERDPS = _FT("vgatherdps");
extern const fcml_cstring M_VGATHERPF0DPD = _FT("vgatherpf0dpd");
extern const fcml_cstring M_VGATHERPF0DPS = _FT("vgatherpf0dps");
extern const fcml_cstring M_VGATHERPF0QPD = _FT("vgatherpf0qpd");
extern const fcml_cstring M_VGATHERPF0QPS = _FT("vgatherpf0qps");
extern const fcml_cstring M_VGATHERPF1DPD = _FT("vgatherpf1dpd");
extern const fcml_cstring M_VGATHERPF1DPS = _FT("vgatherpf1dps");
extern const fcml_cstring M_VGATHERPF1QPD = _FT("vgatherpf1qpd");
extern const fcml_cstring M_VGATHERPF1QPS = _FT("vgatherpf1qps");
extern const fcml_cstring M_VGATHERQPD = _FT("vgatherqpd");
extern const fcml_cstring M_VGATHERQPS = _FT("vgatherqps");
extern const fcml_cstring M_VGETEXPPD = _FT("vgetexppd");
extern const fcml_cstring M_VGETEXPPS = _FT("vgetexpps");
extern const fcml_cstring M_VGETEXPSD = _FT("vgetexpsd");
extern const fcml_cstring M_VGETEXPSS = _FT("vgetexpss");
extern const fcml_cstring M_VGETMANTPD = _FT("vgetmantpd");
extern const fcml_cstring M_VGETMANTPS = _FT("vgetmantps");
extern const fcml_cstring M_VGETMANTSD = _FT("vgetmantsd");
extern const fcml_cstring M_VGETMANTSS = _FT("vgetmantss");
extern const fcml_cstring M_VHADDPD = _FT("vhaddpd");
extern const fcml_cstring M_VHADDPS = _FT("vhaddps");
extern const fcml_cstring M_VHSUBPD = _FT("vhsubpd");
extern const fcml_cstring M_VHSUBPS = _FT("vhsubps");
extern const fcml_cstring M_VINSERTF128 = _FT("vinsertf128");
extern const fcml_cstring M_VINSERTF32X4 = _FT("vinsertf32x4");
extern const fcml_cstring M_VINSERTF32X8 = _FT("vinsertf32x8");
extern const fcml_cstring M_VINSERTF64X2 = _FT("vinsertf64x2");
extern const fcml_cstring M_VINSERTF64X4 = _FT("vinsertf64x4");
extern const fcml_cstring M_VINSERTI128 = _FT("vinserti128");
extern const fcml_cstring M_VINSERTI32X4 = _FT("vinserti32x4");
extern const fcml_cstring M_VINSERTI32X8 = _FT("vinserti32x8");
extern const fcml_cstring M_VINSERTI64X2 = _FT("vinserti64x2");
extern const fcml_cstring M_VINSERTI64X4 = _FT("vinserti64x4");
extern const fcml_cstring M_VINSERTPS = _FT("vinsertps");
extern const fcml_cstring M_VLDDQU = _FT("vlddqu");
extern const fcml_cstring M_VLDMXCSR = _FT("vldmxcsr");
extern const fcml_cstring M_VMASKMOVDQU = _FT("vmaskmovdqu");
extern const fcml_cstring M_VMASKMOVPD = _FT("vmaskmovpd");
extern const fcml_cstring M_VMASKMOVPS = _FT("vmaskmovps");
extern const fcml_cstring M_VMAXPD = _FT("vmaxpd");
extern const fcml_cstring M_VMAXPS = _FT("vmaxps");
extern const fcml_cstring M_VMAXSD = _FT("vmaxsd");
extern const fcml_cstring M_VMAXSS = _FT("vmaxss");
extern const fcml_cstring M_VMCALL = _FT("vmcall");
extern const fcml_cstring M_VMCLEAR = _FT("vmclear");
extern const fcml_cstring M_VMFUNC = _FT("vmfunc");
extern const fcml_cstring M_VMINPD = _FT("vminpd");
extern const fcml_cstring M_VMINPS = _FT("vminps");
extern const fcml_cstring M_VMINSD = _FT("vminsd");
extern const fcml_cstring M_VMINSS = _FT("vminss");
extern const fcml_cstring M_VMLAUNCH = _FT("vmlaunch");
extern const fcml_cstring M_VMLOAD = _FT("vmload");
extern const fcml_cstring M_VMMCALL = _FT("vmmcall");
extern const fcml_cstring M_VMOVAPD = _FT("vmovapd");
extern const fcml_cstring M_VMOVAPS = _FT("vmovaps");
extern const fcml_cstring M_VMOVD = _FT("vmovd");
extern const fcml_cstring M_VMOVDDUP = _FT("vmovddup");
extern const fcml_cstring M_VMOVDQA = _FT("vmovdqa");
extern const fcml_cstring M_VMOVDQA32 = _FT("vmovdqa32");
extern const fcml_cstring M_VMOVDQA64 = _FT("vmovdqa64");
extern const fcml_cstring M_VMOVDQU = _FT("vmovdqu");
extern const fcml_cstring M_VMOVDQU16 = _FT("vmovdqu16");
extern const fcml_cstring M_VMOVDQU32 = _FT("vmovdqu32");
extern const fcml_cstring M_VMOVDQU64 = _FT("vmovdqu64");
extern const fcml_cstring M_VMOVDQU8 = _FT("vmovdqu8");
extern const fcml_cstring M_VMOVHLPS = _FT("vmovhlps");
extern const fcml_cstring M_VMOVHPD = _FT("vmovhpd");
extern const fcml_cstring M_VMOVHPS = _FT("vmovhps");
extern const fcml_cstring M_VMOVLHPS = _FT("vmovlhps");
extern const fcml_cstring M_VMOVLPD = _FT("vmovlpd");
extern const fcml_cstring M_VMOVLPS = _FT("vmovlps");
extern const fcml_cstring M_VMOVMSKPD = _FT("vmovmskpd");
extern const fcml_cstring M_VMOVMSKPS = _FT("vmovmskps");
extern const fcml_cstring M_VMOVNTDQ = _FT("vmovntdq");
extern const fcml_cstring M_VMOVNTDQA = _FT("vmovntdqa");
extern const fcml_cstring M_VMOVNTPD = _FT("vmovntpd");
extern const fcml_cstring M_VMOVNTPS = _FT("vmovntps");
extern const fcml_cstring M_VMOVQ = _FT("vmovq");
extern const fcml_cstring M_VMOVSD = _FT("vmovsd");
extern const fcml_cstring M_VMOVSHDUP = _FT("vmovshdup");
extern const fcml_cstring M_VMOVSLDUP = _FT("vmovsldup");
extern const fcml_cstring M_VMOVSS = _FT("vmovss");
extern const fcml_cstring M_VMOVUPD = _FT("vmovupd");
extern const fcml_cstring M_VMOVUPS = _FT("vmovups");
extern const fcml_cstring M_VMPSADBW = _FT("vmpsadbw");
extern const fcml_cstring M_VMPTRLD = _FT("vmptrld");
extern const fcml_cstring M_VMPTRST = _FT("vmptrst");
extern const fcml_cstring M_VMREAD = _FT("vmread");
extern const fcml_cstring M_VMRESUME = _FT("vmresume");
extern const fcml_cstring M_VMRUN = _FT("vmrun");
extern const fcml_cstring M_VMSAVE = _FT("vmsave");
extern const fcml_cstring M_VMULPD = _FT("vmulpd");
extern const fcml_cstring M_VMULPS = _FT("vmulps");
extern const fcml_cstring M_VMULSD = _FT("vmulsd");
extern const fcml_cstring M_VMULSS = _FT("vmulss");
extern const fcml_cstring M_VMWRITE = _FT("vmwrite");
extern const fcml_cstring M_VMXOFF = _FT("vmxoff");
extern const fcml_cstring M_VMXON = _FT("vmxon");
extern const fcml_cstring M_VORPD = _FT("vorpd");
extern const fcml_cstring M_VORPS = _FT("vorps");
extern const fcml_cstring M_VP4DPWSSD = _FT("vp4dpwssd");
extern const fcml_cstring M_VP4DPWSSDS = _FT("vp4dpwssds");
extern const fcml_cstring M_VPABSB = _FT("vpabsb");
extern const fcml_cstring M_VPABSD = _FT("vpabsd");
extern const fcml_cstring M_VPABSQ = _FT("vpabsq");
extern const fcml_cstring M_VPABSW = _FT("vpabsw");
extern const fcml_cstring M_VPACKSSDW = _FT("vpackssdw");
extern const fcml_cstring M_VPACKSSWB = _FT("vpacksswb");
extern const fcml_cstring M_VPACKUSDW = _FT("vpackusdw");
extern const fcml_cstring M_VPACKUSWB = _FT("vpackuswb");
extern const fcml_cstring M_VPADDB = _FT("vpaddb");
extern const fcml_cstring M_VPADDD = _FT("vpaddd");
extern const fcml_cstring M_VPADDQ = _FT("vpaddq");
extern const fcml_cstring M_VPADDSB = _FT("vpaddsb");
extern const fcml_cstring M_VPADDSW = _FT("vpaddsw");
extern const fcml_cstring M_VPADDUSB = _FT("vpaddusb");
extern const fcml_cstring M_VPADDUSW = _FT("vpaddusw");
extern const fcml_cstring M_VPADDW = _FT("vpaddw");
extern const fcml_cstring M_VPALIGNR = _FT("vpalignr");
extern const fcml_cstring M_VPAND = _FT("vpand");
extern const fcml_cstring M_VPANDD = _FT("vpandd");
extern const fcml_cstring M_VPANDN = _FT("vpandn");
extern const fcml_cstring M_VPANDND = _FT("vpandnd");
extern const fcml_cstring M_VPANDNQ = _FT("vpandnq");
extern const fcml_cstring M_VPANDQ = _FT("vpandq");
extern const fcml_cstring M_VPAVGB = _FT("vpavgb");
extern const fcml_cstring M_VPAVGW = _FT("vpavgw");
extern const fcml_cstring M_VPBLENDD = _FT("vpblendd");
extern const fcml_cstring M_VPBLENDMB = _FT("vpblendmb");
extern const fcml_cstring M_VPBLENDMD = _FT("vpblendmd");
extern const fcml_cstring M_VPBLENDMQ = _FT("vpblendmq");
extern const fcml_cstring M_VPBLENDMW = _FT("vpblendmw");
extern const fcml_cstring M_VPBLENDVB = _FT("vpblendvb");
extern const fcml_cstring M_VPBLENDW = _FT("vpblendw");
extern const fcml_cstring M_VPBROADCASTB = _FT("vpbroadcastb");
extern const fcml_cstring M_VPBROADCASTD = _FT("vpbroadcastd");
extern const fcml_cstring M_VPBROADCASTMB2Q = _FT("vpbroadcastmb2q");
extern const fcml_cstring M_VPBROADCASTMW2D = _FT("vpbroadcastmw2d");
extern const fcml_cstring M_VPBROADCASTQ = _FT("vpbroadcastq");
extern const fcml_cstring M_VPBROADCASTW = _FT("vpbroadcastw");
extern const fcml_cstring M_VPCLMULQDQ = _FT("vpclmulqdq");
extern const fcml_cstring M_VPCMOV = _FT("vpcmov");
extern const fcml_cstring M_VPCMPB = _FT("vpcmpb");
extern const fcml_cstring M_VPCMPD = _FT("vpcmpd");
extern const fcml_cstring M_VPCMPEQB = _FT("vpcmpeqb");
extern const fcml_cstring M_VPCMPEQD = _FT("vpcmpeqd");
extern const fcml_cstring M_VPCMPEQQ = _FT("vpcmpeqq");
extern const fcml_cstring M_VPCMPEQW = _FT("vpcmpeqw");
extern const fcml_cstring M_VPCMPESTRI = _FT("vpcmpestri");
extern const fcml_cstring M_VPCMPESTRM = _FT("vpcmpestrm");
extern const fcml_cstring M_VPCMPGTB = _FT("vpcmpgtb");
extern const fcml_cstring M_VPCMPGTD = _FT("vpcmpgtd");
extern const fcml_cstring M_VPCMPGTQ = _FT("vpcmpgtq");
extern const fcml_cstring M_VPCMPGTW = _FT("vpcmpgtw");
extern const fcml_cstring M_VPCMPISTRI = _FT("vpcmpistri");
extern const fcml_cstring M_VPCMPISTRM = _FT("vpcmpistrm");
extern const fcml_cstring M_VPCMPQ = _FT("vpcmpq");
extern const fcml_cstring M_VPCMPUB = _FT("vpcmpub");
extern const fcml_cstring M_VPCMPUD = _FT("vpcmpud");
extern const fcml_cstring M_VPCMPUQ = _FT("vpcmpuq");
extern const fcml_cstring M_VPCMPUW = _FT("vpcmpuw");
extern const fcml_cstring M_VPCMPW = _FT("vpcmpw");
extern const fcml_cstring M_VPCOMB = _FT("vpcomb");
extern const fcml_cstring M_VPCOMD = _FT("vpcomd");
extern const fcml_cstring M_VPCOMEQB = _FT("vpcomeqb");
extern const fcml_cstring M_VPCOMEQD = _FT("vpcomeqd");
extern const fcml_cstring M_VPCOMEQQ = _FT("vpcomeqq");
extern const fcml_cstring M_VPCOMEQUB = _FT("vpcomequb");
extern const fcml_cstring M_VPCOMEQUD = _FT("vpcomequd");
extern const fcml_cstring M_VPCOMEQUQ = _FT("vpcomequq");
extern const fcml_cstring M_VPCOMEQUW = _FT("vpcomequw");
extern const fcml_cstring M_VPCOMEQW = _FT("vpcomeqw");
extern const fcml_cstring M_VPCOMFALSEB = _FT("vpcomfalseb");
extern const fcml_cstring M_VPCOMFALSED = _FT("vpcomfalsed");
extern const fcml_cstring M_VPCOMFALSEQ = _FT("vpcomfalseq");
extern const fcml_cstring M_VPCOMFALSEUB = _FT("vpcomfalseub");
extern const fcml_cstring M_VPCOMFALSEUD = _FT("vpcomfalseud");
extern const fcml_cstring M_VPCOMFALSEUQ = _FT("vpcomfalseuq");
extern const fcml_cstring M_VPCOMFALSEUW = _FT("vpcomfalseuw");
extern const fcml_cstring M_VPCOMFALSEW = _FT("vpcomfalsew");
extern const fcml_cstring M_VPCOMGEB = _FT("vpcomgeb");
extern const fcml_cstring M_VPCOMGED = _FT("vpcomged");
extern const fcml_cstring M_VPCOMGEQ = _FT("vpcomgeq");
extern const fcml_cstring M_VPCOMGEUB = _FT("vpcomgeub");
extern const fcml_cstring M_VPCOMGEUD = _FT("vpcomgeud");
extern const fcml_cstring M_VPCOMGEUQ = _FT("vpcomgeuq");
extern const fcml_cstring M_VPCOMGEUW = _FT("vpcomgeuw");
extern const fcml_cstring M_VPCOMGEW = _FT("vpcomgew");
extern const fcml_cstring M_VPCOMGTB = _FT("vpcomgtb");
extern const fcml_cstring M_VPCOMGTD = _FT("vpcomgtd");
extern const fcml_cstring M_VPCOMGTQ = _FT("vpcomgtq");
extern const fcml_cstring M_VPCOMGTUB = _FT("vpcomgtub");
extern const fcml_cstring M_VPCOMGTUD = _FT("vpcomgtud");
extern const fcml_cstring M_VPCOMGTUQ = _FT("vpcomgtuq");
extern const fcml_cstring M_VPCOMGTUW = _FT("vpcomgtuw");
extern const fcml_cstring M_VPCOMGTW = _FT("vpcomgtw");
extern const fcml_cstring M_VPCOMLEB = _FT("vpcomleb");
extern const fcml_cstring M_VPCOMLED = _FT("vpcomled");
extern const fcml_cstring M_VPCOMLEQ = _FT("vpcomleq");
extern const fcml_cstring M_VPCOMLEUB = _FT("vpcomleub");
extern const fcml_cstring M_VPCOMLEUD = _FT("vpcomleud");
extern const fcml_cstring M_VPCOMLEUQ = _FT("vpcomleuq");
extern const fcml_cstring M_VPCOMLEUW = _FT("vpcomleuw");
extern const fcml_cstring M_VPCOMLEW = _FT("vpcomlew");
extern const fcml_cstring M_VPCOMLTB = _FT("vpcomltb");
extern const fcml_cstring M_VPCOMLTD = _FT("vpcomltd");
extern const fcml_cstring M_VPCOMLTQ = _FT("vpcomltq");
extern const fcml_cstring M_VPCOMLTUB = _FT("vpcomltub");
extern const fcml_cstring M_VPCOMLTUD = _FT("vpcomltud");
extern const fcml_cstring M_VPCOMLTUQ = _FT("vpcomltuq");
extern const fcml_cstring M_VPCOMLTUW = _FT("vpcomltuw");
extern const fcml_cstring M_VPCOMLTW = _FT("vpcomltw");
extern const fcml_cstring M_VPCOMNEQB = _FT("vpcomneqb");
extern const fcml_cstring M_VPCOMNEQD = _FT("vpcomneqd");
extern const fcml_cstring M_VPCOMNEQQ = _FT("vpcomneqq");
extern const fcml_cstring M_VPCOMNEQUB = _FT("vpcomnequb");
extern const fcml_cstring M_VPCOMNEQUD = _FT("vpcomnequd");
extern const fcml_cstring M_VPCOMNEQUQ = _FT("vpcomnequq");
extern const fcml_cstring M_VPCOMNEQUW = _FT("vpcomnequw");
extern const fcml_cstring M_VPCOMNEQW = _FT("vpcomneqw");
extern const fcml_cstring M_VPCOMPRESSD = _FT("vpcompressd");
extern const fcml_cstring M_VPCOMPRESSQ = _FT("vpcompressq");
extern const fcml_cstring M_VPCOMQ = _FT("vpcomq");
extern const fcml_cstring M_VPCOMTRUEB = _FT("vpcomtrueb");
extern const fcml_cstring M_VPCOMTRUED = _FT("vpcomtrued");
extern const fcml_cstring M_VPCOMTRUEQ = _FT("vpcomtrueq");
extern const fcml_cstring M_VPCOMTRUEUB = _FT("vpcomtrueub");
extern const fcml_cstring M_VPCOMTRUEUD = _FT("vpcomtrueud");
extern const fcml_cstring M_VPCOMTRUEUQ = _FT("vpcomtrueuq");
extern const fcml_cstring M_VPCOMTRUEUW = _FT("vpcomtrueuw");
extern const fcml_cstring M_VPCOMTRUEW = _FT("vpcomtruew");
extern const fcml_cstring M_VPCOMUB = _FT("vpcomub");
extern const fcml_cstring M_VPCOMUD = _FT("vpcomud");
extern const fcml_cstring M_VPCOMUQ = _FT("vpcomuq");
extern const fcml_cstring M_VPCOMUW = _FT("vpcomuw");
extern const fcml_cstring M_VPCOMW = _FT("vpcomw");
extern const fcml_cstring M_VPERM2F128 = _FT("vperm2f128");
extern const fcml_cstring M_VPERM2I128 = _FT("vperm2i128");
extern const fcml_cstring M_VPERMB = _FT("vpermb");
extern const fcml_cstring M_VPERMD = _FT("vpermd");
extern const fcml_cstring M_VPERMI2B = _FT("vpermi2b");
extern const fcml_cstring M_VPERMI2D = _FT("vpermi2d");
extern const fcml_cstring M_VPERMI2PD = _FT("vpermi2pd");
extern const fcml_cstring M_VPERMI2PS = _FT("vpermi2ps");
extern const fcml_cstring M_VPERMI2Q = _FT("vpermi2q");
extern const fcml_cstring M_VPERMI2W = _FT("vpermi2w");
extern const fcml_cstring M_VPERMIL2PD = _FT("vpermil2pd");
extern const fcml_cstring M_VPERMIL2PS = _FT("vpermil2ps");
extern const fcml_cstring M_VPERMILPD = _FT("vpermilpd");
extern const fcml_cstring M_VPERMILPS = _FT("vpermilps");
extern const fcml_cstring M_VPERMPD = _FT("vpermpd");
extern const fcml_cstring M_VPERMPS = _FT("vpermps");
extern const fcml_cstring M_VPERMQ = _FT("vpermq");
extern const fcml_cstring M_VPERMT2B = _FT("vpermt2b");
extern const fcml_cstring M_VPERMT2D = _FT("vpermt2d");
extern const fcml_cstring M_VPERMT2PD = _FT("vpermt2pd");
extern const fcml_cstring M_VPERMT2PS = _FT("vpermt2ps");
extern const fcml_cstring M_VPERMT2Q = _FT("vpermt2q");
extern const fcml_cstring M_VPERMT2W = _FT("vpermt2w");
extern const fcml_cstring M_VPERMW = _FT("vpermw");
extern const fcml_cstring M_VPEXPANDD = _FT("vpexpandd");
extern const fcml_cstring M_VPEXPANDQ = _FT("vpexpandq");
extern const fcml_cstring M_VPEXTRB = _FT("vpextrb");
extern const fcml_cstring M_VPEXTRD = _FT("vpextrd");
extern const fcml_cstring M_VPEXTRQ = _FT("vpextrq");
extern const fcml_cstring M_VPEXTRW = _FT("vpextrw");
extern const fcml_cstring M_VPGATHERDD = _FT("vpgatherdd");
extern const fcml_cstring M_VPGATHERDQ = _FT("vpgatherdq");
extern const fcml_cstring M_VPGATHERQD = _FT("vpgatherqd");
extern const fcml_cstring M_VPGATHERQQ = _FT("vpgatherqq");
extern const fcml_cstring M_VPHADDBD = _FT("vphaddbd");
extern const fcml_cstring M_VPHADDBQ = _FT("vphaddbq");
extern const fcml_cstring M_VPHADDBW = _FT("vphaddbw");
extern const fcml_cstring M_VPHADDD = _FT("vphaddd");
extern const fcml_cstring M_VPHADDDQ = _FT("vphadddq");
extern const fcml_cstring M_VPHADDSW = _FT("vphaddsw");
extern const fcml_cstring M_VPHADDUBD = _FT("vphaddubd");
extern const fcml_cstring M_VPHADDUBQ = _FT("vphaddubq");
extern const fcml_cstring M_VPHADDUBW = _FT("vphaddubw");
extern const fcml_cstring M_VPHADDUDQ = _FT("vphaddudq");
extern const fcml_cstring M_VPHADDUWD = _FT("vphadduwd");
extern const fcml_cstring M_VPHADDUWQ = _FT("vphadduwq");
extern const fcml_cstring M_VPHADDW = _FT("vphaddw");
extern const fcml_cstring M_VPHADDWD = _FT("vphaddwd");
extern const fcml_cstring M_VPHADDWQ = _FT("vphaddwq");
extern const fcml_cstring M_VPHMINPOSUW = _FT("vphminposuw");
extern const fcml_cstring M_VPHSUBBW = _FT("vphsubbw");
extern const fcml_cstring M_VPHSUBD = _FT("vphsubd");
extern const fcml_cstring M_VPHSUBDQ = _FT("vphsubdq");
extern const fcml_cstring M_VPHSUBSW = _FT("vphsubsw");
extern const fcml_cstring M_VPHSUBW = _FT("vphsubw");
extern const fcml_cstring M_VPHSUBWD = _FT("vphsubwd");
extern const fcml_cstring M_VPINSRB = _FT("vpinsrb");
extern const fcml_cstring M_VPINSRD = _FT("vpinsrd");
extern const fcml_cstring M_VPINSRQ = _FT("vpinsrq");
extern const fcml_cstring M_VPINSRW = _FT("vpinsrw");
extern const fcml_cstring M_VPLZCNTD = _FT("vplzcntd");
extern const fcml_cstring M_VPLZCNTQ = _FT("vplzcntq");
extern const fcml_cstring M_VPMACSDD = _FT("vpmacsdd");
extern const fcml_cstring M_VPMACSDQH = _FT("vpmacsdqh");
extern const fcml_cstring M_VPMACSDQL = _FT("vpmacsdql");
extern const fcml_cstring M_VPMACSSDD = _FT("vpmacssdd");
extern const fcml_cstring M_VPMACSSDQH = _FT("vpmacssdqh");
extern const fcml_cstring M_VPMACSSDQL = _FT("vpmacssdql");
extern const fcml_cstring M_VPMACSSWD = _FT("vpmacsswd");
extern const fcml_cstring M_VPMACSSWW = _FT("vpmacssww");
extern const fcml_cstring M_VPMACSWD = _FT("vpmacswd");
extern const fcml_cstring M_VPMACSWW = _FT("vpmacsww");
extern const fcml_cstring M_VPMADCSSWD = _FT("vpmadcsswd");
extern const fcml_cstring M_VPMADCSWD = _FT("vpmadcswd");
extern const fcml_cstring M_VPMADD52HUQ = _FT("vpmadd52huq");
extern const fcml_cstring M_VPMADD52LUQ = _FT("vpmadd52luq");
extern const fcml_cstring M_VPMADDUBSW = _FT("vpmaddubsw");
extern const fcml_cstring M_VPMADDWD = _FT("vpmaddwd");
extern const fcml_cstring M_VPMASKMOV = _FT("vpmaskmov");
extern const fcml_cstring M_VPMASKMOVD = _FT("vpmaskmovd");
extern const fcml_cstring M_VPMASKMOVQ = _FT("vpmaskmovq");
extern const fcml_cstring M_VPMAXSB = _FT("vpmaxsb");
extern const fcml_cstring M_VPMAXSD = _FT("vpmaxsd");
extern const fcml_cstring M_VPMAXSQ = _FT("vpmaxsq");
extern const fcml_cstring M_VPMAXSW = _FT("vpmaxsw");
extern const fcml_cstring M_VPMAXUB = _FT("vpmaxub");
extern const fcml_cstring M_VPMAXUD = _FT("vpmaxud");
extern const fcml_cstring M_VPMAXUQ = _FT("vpmaxuq");
extern const fcml_cstring M_VPMAXUW = _FT("vpmaxuw");
extern const fcml_cstring M_VPMINSB = _FT("vpminsb");
extern const fcml_cstring M_VPMINSD = _FT("vpminsd");
extern const fcml_cstring M_VPMINSQ = _FT("vpminsq");
extern const fcml_cstring M_VPMINSW = _FT("vpminsw");
extern const fcml_cstring M_VPMINUB = _FT("vpminub");
extern const fcml_cstring M_VPMINUD = _FT("vpminud");
extern const fcml_cstring M_VPMINUQ = _FT("vpminuq");
extern const fcml_cstring M_VPMINUW = _FT("vpminuw");
extern const fcml_cstring M_VPMOVB2M = _FT("vpmovb2m");
extern const fcml_cstring M_VPMOVD2M = _FT("vpmovd2m");
extern const fcml_cstring M_VPMOVDB = _FT("vpmovdb");
extern const fcml_cstring M_VPMOVDW = _FT("vpmovdw");
extern const fcml_cstring M_VPMOVM2B = _FT("vpmovm2b");
extern const fcml_cstring M_VPMOVM2D = _FT("vpmovm2d");
extern const fcml_cstring M_VPMOVM2Q = _FT("vpmovm2q");
extern const fcml_cstring M_VPMOVM2W = _FT("vpmovm2w");
extern const fcml_cstring M_VPMOVMSKB = _FT("vpmovmskb");
extern const fcml_cstring M_VPMOVQ2M = _FT("vpmovq2m");
extern const fcml_cstring M_VPMOVQB = _FT("vpmovqb");
extern const fcml_cstring M_VPMOVQD = _FT("vpmovqd");
extern const fcml_cstring M_VPMOVQW = _FT("vpmovqw");
extern const fcml_cstring M_VPMOVSDB = _FT("vpmovsdb");
extern const fcml_cstring M_VPMOVSDW = _FT("vpmovsdw");
extern const fcml_cstring M_VPMOVSQB = _FT("vpmovsqb");
extern const fcml_cstring M_VPMOVSQD = _FT("vpmovsqd");
extern const fcml_cstring M_VPMOVSQW = _FT("vpmovsqw");
extern const fcml_cstring M_VPMOVSWB = _FT("vpmovswb");
extern const fcml_cstring M_VPMOVSXBD = _FT("vpmovsxbd");
extern const fcml_cstring M_VPMOVSXBQ = _FT("vpmovsxbq");
extern const fcml_cstring M_VPMOVSXBW = _FT("vpmovsxbw");
extern const fcml_cstring M_VPMOVSXDQ = _FT("vpmovsxdq");
extern const fcml_cstring M_VPMOVSXWD = _FT("vpmovsxwd");
extern const fcml_cstring M_VPMOVSXWQ = _FT("vpmovsxwq");
extern const fcml_cstring M_VPMOVUSDB = _FT("vpmovusdb");
extern const fcml_cstring M_VPMOVUSDW = _FT("vpmovusdw");
extern const fcml_cstring M_VPMOVUSQB = _FT("vpmovusqb");
extern const fcml_cstring M_VPMOVUSQD = _FT("vpmovusqd");
extern const fcml_cstring M_VPMOVUSQW = _FT("vpmovusqw");
extern const fcml_cstring M_VPMOVUSWB = _FT("vpmovuswb");
extern const fcml_cstring M_VPMOVW2M = _FT("vpmovw2m");
extern const fcml_cstring M_VPMOVWB = _FT("vpmovwb");
extern const fcml_cstring M_VPMOVZXBD = _FT("vpmovzxbd");
extern const fcml_cstring M_VPMOVZXBQ = _FT("vpmovzxbq");
extern const fcml_cstring M_VPMOVZXBW = _FT("vpmovzxbw");
extern const fcml_cstring M_VPMOVZXDQ = _FT("vpmovzxdq");
extern const fcml_cstring M_VPMOVZXWD = _FT("vpmovzxwd");
extern const fcml_cstring M_VPMOVZXWQ = _FT("vpmovzxwq");
extern const fcml_cstring M_VPMULDQ = _FT("vpmuldq");
extern const fcml_cstring M_VPMULHRSW = _FT("vpmulhrsw");
extern const fcml_cstring M_VPMULHUW = _FT("vpmulhuw");
extern const fcml_cstring M_VPMULHW = _FT("vpmulhw");
extern const fcml_cstring M_VPMULLD = _FT("vpmulld");
extern const fcml_cstring M_VPMULLQ = _FT("vpmullq");
extern const fcml_cstring M_VPMULLW = _FT("vpmullw");
extern const fcml_cstring M_VPMULTISHIFTQB = _FT("vpmultishiftqb");
extern const fcml_cstring M_VPMULUDQ = _FT("vpmuludq");
extern const fcml_cstring M_VPOR = _FT("vpor");
extern const fcml_cstring M_VPORD = _FT("vpord");
extern const fcml_cstring M_VPORQ = _FT("vporq");
extern const fcml_cstring M_VPPERM = _FT("vpperm");
extern const fcml_cstring M_VPROLD = _FT("vprold");
extern const fcml_cstring M_VPROLQ = _FT("vprolq");
extern const fcml_cstring M_VPROLVD = _FT("vprolvd");
extern const fcml_cstring M_VPROLVQ = _FT("vprolvq");
extern const fcml_cstring M_VPRORD = _FT("vprord");
extern const fcml_cstring M_VPRORQ = _FT("vprorq");
extern const fcml_cstring M_VPRORVD = _FT("vprorvd");
extern const fcml_cstring M_VPRORVQ = _FT("vprorvq");
extern const fcml_cstring M_VPROTB = _FT("vprotb");
extern const fcml_cstring M_VPROTD = _FT("vprotd");
extern const fcml_cstring M_VPROTQ = _FT("vprotq");
extern const fcml_cstring M_VPROTW = _FT("vprotw");
extern const fcml_cstring M_VPSADBW = _FT("vpsadbw");
extern const fcml_cstring M_VPSCATTERDD = _FT("vpscatterdd");
extern const fcml_cstring M_VPSCATTERDQ = _FT("vpscatterdq");
extern const fcml_cstring M_VPSCATTERQD = _FT("vpscatterqd");
extern const fcml_cstring M_VPSCATTERQQ = _FT("vpscatterqq");
extern const fcml_cstring M_VPSHAB = _FT("vpshab");
extern const fcml_cstring M_VPSHAD = _FT("vpshad");
extern const fcml_cstring M_VPSHAQ = _FT("vpshaq");
extern const fcml_cstring M_VPSHAW = _FT("vpshaw");
extern const fcml_cstring M_VPSHLB = _FT("vpshlb");
extern const fcml_cstring M_VPSHLD = _FT("vpshld");
extern const fcml_cstring M_VPSHLQ = _FT("vpshlq");
extern const fcml_cstring M_VPSHLW = _FT("vpshlw");
extern const fcml_cstring M_VPSHUFB = _FT("vpshufb");
extern const fcml_cstring M_VPSHUFD = _FT("vpshufd");
extern const fcml_cstring M_VPSHUFHW = _FT("vpshufhw");
extern const fcml_cstring M_VPSHUFLW = _FT("vpshuflw");
extern const fcml_cstring M_VPSIGNB = _FT("vpsignb");
extern const fcml_cstring M_VPSIGND = _FT("vpsignd");
extern const fcml_cstring M_VPSIGNW = _FT("vpsignw");
extern const fcml_cstring M_VPSLLD = _FT("vpslld");
extern const fcml_cstring M_VPSLLDQ = _FT("vpslldq");
extern const fcml_cstring M_VPSLLQ = _FT("vpsllq");
extern const fcml_cstring M_VPSLLVD = _FT("vpsllvd");
extern const fcml_cstring M_VPSLLVQ = _FT("vpsllvq");
extern const fcml_cstring M_VPSLLVW = _FT("vpsllvw");
extern const fcml_cstring M_VPSLLW = _FT("vpsllw");
extern const fcml_cstring M_VPSRAD = _FT("vpsrad");
extern const fcml_cstring M_VPSRAQ = _FT("vpsraq");
extern const fcml_cstring M_VPSRAVD = _FT("vpsravd");
extern const fcml_cstring M_VPSRAVQ = _FT("vpsravq");
extern const fcml_cstring M_VPSRAVW = _FT("vpsravw");
extern const fcml_cstring M_VPSRAW = _FT("vpsraw");
extern const fcml_cstring M_VPSRLD = _FT("vpsrld");
extern const fcml_cstring M_VPSRLDQ = _FT("vpsrldq");
extern const fcml_cstring M_VPSRLQ = _FT("vpsrlq");
extern const fcml_cstring M_VPSRLVD = _FT("vpsrlvd");
extern const fcml_cstring M_VPSRLVQ = _FT("vpsrlvq");
extern const fcml_cstring M_VPSRLVW = _FT("vpsrlvw");
extern const fcml_cstring M_VPSRLW = _FT("vpsrlw");
extern const fcml_cstring M_VPSUBB = _FT("vpsubb");
extern const fcml_cstring M_VPSUBD = _FT("vpsubd");
extern const fcml_cstring M_VPSUBQ = _FT("vpsubq");
extern const fcml_cstring M_VPSUBSB = _FT("vpsubsb");
extern const fcml_cstring M_VPSUBSW = _FT("vpsubsw");
extern const fcml_cstring M_VPSUBUSB = _FT("vpsubusb");
extern const fcml_cstring M_VPSUBUSW = _FT("vpsubusw");
extern const fcml_cstring M_VPSUBW = _FT("vpsubw");
extern const fcml_cstring M_VPTERNLOGD = _FT("vpternlogd");
extern const fcml_cstring M_VPTERNLOGQ = _FT("vpternlogq");
extern const fcml_cstring M_VPTEST = _FT("vptest");
extern const fcml_cstring M_VPTESTMB = _FT("vptestmb");
extern const fcml_cstring M_VPTESTMD = _FT("vptestmd");
extern const fcml_cstring M_VPTESTMQ = _FT("vptestmq");
extern const fcml_cstring M_VPTESTMW = _FT("vptestmw");
extern const fcml_cstring M_VPTESTNMB = _FT("vptestnmb");
extern const fcml_cstring M_VPTESTNMD = _FT("vptestnmd");
extern const fcml_cstring M_VPTESTNMQ = _FT("vptestnmq");
extern const fcml_cstring M_VPTESTNMW = _FT("vptestnmw");
extern const fcml_cstring M_VPUNPCKHBW = _FT("vpunpckhbw");
extern const fcml_cstring M_VPUNPCKHDQ = _FT("vpunpckhdq");
extern const fcml_cstring M_VPUNPCKHQDQ = _FT("vpunpckhqdq");
extern const fcml_cstring M_VPUNPCKHWD = _FT("vpunpckhwd");
extern const fcml_cstring M_VPUNPCKLBW = _FT("vpunpcklbw");
extern const fcml_cstring M_VPUNPCKLDQ = _FT("vpunpckldq");
extern const fcml_cstring M_VPUNPCKLQDQ = _FT("vpunpcklqdq");
extern const fcml_cstring M_VPUNPCKLWD = _FT("vpunpcklwd");
extern const fcml_cstring M_VPXOR = _FT("vpxor");
extern const fcml_cstring M_VPXORD = _FT("vpxord");
extern const fcml_cstring M_VPXORQ = _FT("vpxorq");
extern const fcml_cstring M_VRANGEPD = _FT("vrangepd");
extern const fcml_cstring M_VRANGEPS = _FT("vrangeps");
extern const fcml_cstring M_VRANGESD = _FT("vrangesd");
extern const fcml_cstring M_VRANGESS = _FT("vrangess");
extern const fcml_cstring M_VRCP14PD = _FT("vrcp14pd");
extern const fcml_cstring M_VRCP14PS = _FT("vrcp14ps");
extern const fcml_cstring M_VRCP14SD = _FT("vrcp14sd");
extern const fcml_cstring M_VRCP14SS = _FT("vrcp14ss");
extern const fcml_cstring M_VRCP28PD = _FT("vrcp28pd");
extern const fcml_cstring M_VRCP28PS = _FT("vrcp28ps");
extern const fcml_cstring M_VRCP28SD = _FT("vrcp28sd");
extern const fcml_cstring M_VRCP28SS = _FT("vrcp28ss");
extern const fcml_cstring M_VRCPPS = _FT("vrcpps");
extern const fcml_cstring M_VRCPSS = _FT("vrcpss");
extern const fcml_cstring M_VREDUCEPD = _FT("vreducepd");
extern const fcml_cstring M_VREDUCEPS = _FT("vreduceps");
extern const fcml_cstring M_VREDUCESD = _FT("vreducesd");
extern const fcml_cstring M_VREDUCESS = _FT("vreducess");
extern const fcml_cstring M_VRNDSCALEPD = _FT("vrndscalepd");
extern const fcml_cstring M_VRNDSCALEPS = _FT("vrndscaleps");
extern const fcml_cstring M_VRNDSCALESD = _FT("vrndscalesd");
extern const fcml_cstring M_VRNDSCALESS = _FT("vrndscaless");
extern const fcml_cstring M_VROUNDPD = _FT("vroundpd");
extern const fcml_cstring M_VROUNDPS = _FT("vroundps");
extern const fcml_cstring M_VROUNDSD = _FT("vroundsd");
extern const fcml_cstring M_VROUNDSS = _FT("vroundss");
extern const fcml_cstring M_VRSQRT14PD = _FT("vrsqrt14pd");
extern const fcml_cstring M_VRSQRT14PS = _FT("vrsqrt14ps");
extern const fcml_cstring M_VRSQRT14SD = _FT("vrsqrt14sd");
extern const fcml_cstring M_VRSQRT14SS = _FT("vrsqrt14ss");
extern const fcml_cstring M_VRSQRT28PD = _FT("vrsqrt28pd");
extern const fcml_cstring M_VRSQRT28PS = _FT("vrsqrt28ps");
extern const fcml_cstring M_VRSQRT28SD = _FT("vrsqrt28sd");
extern const fcml_cstring M_VRSQRT28SS = _FT("vrsqrt28ss");
extern const fcml_cstring M_VRSQRTPS = _FT("vrsqrtps");
extern const fcml_cstring M_VRSQRTSS = _FT("vrsqrtss");
extern const fcml_cstring M_VSCALEFPD = _FT("vscalefpd");
extern const fcml_cstring M_VSCALEFPS = _FT("vscalefps");
extern const fcml_cstring M_VSCALEFSD = _FT("vscalefsd");
extern const fcml_cstring M_VSCALEFSS = _FT("vscalefss");
extern const fcml_cstring M_VSCATTERDPD = _FT("vscatterdpd");
extern const fcml_cstring M_VSCATTERDPS = _FT("vscatterdps");
extern const fcml_cstring M_VSCATTERPF0DPD = _FT("vscatterpf0dpd");
extern const fcml_cstring M_VSCATTERPF0DPS = _FT("vscatterpf0dps");
extern const fcml_cstring M_VSCATTERPF0QPD = _FT("vscatterpf0qpd");
extern const fcml_cstring M_VSCATTERPF0QPS = _FT("vscatterpf0qps");
extern const fcml_cstring M_VSCATTERPF1DPD = _FT("vscatterpf1dpd");
extern const fcml_cstring M_VSCATTERPF1DPS = _FT("vscatterpf1dps");
extern const fcml_cstring M_VSCATTERPF1QPD = _FT("vscatterpf1qpd");
extern const fcml_cstring M_VSCATTERPF1QPS = _FT("vscatterpf1qps");
extern const fcml_cstring M_VSCATTERQPD = _FT("vscatterqpd");
extern const fcml_cstring M_VSCATTERQPS = _FT("vscatterqps");
extern const fcml_cstring M_VSHUFF32X4 = _FT("vshuff32x4");
extern const fcml_cstring M_VSHUFF64X2 = _FT("vshuff64x2");
extern const fcml_cstring M_VSHUFI32X4 = _FT("vshufi32x4");
extern const fcml_cstring M_VSHUFI64X2 = _FT("vshufi64x2");
extern const fcml_cstring M_VSHUFPD = _FT("vshufpd");
extern const fcml_cstring M_VSHUFPS = _FT("vshufps");
extern const fcml_cstring M_VSQRTPD = _FT("vsqrtpd");
extern const fcml_cstring M_VSQRTPS = _FT("vsqrtps");
extern const fcml_cstring M_VSQRTSD = _FT("vsqrtsd");
extern const fcml_cstring M_VSQRTSS = _FT("vsqrtss");
extern const fcml_cstring M_VSTMXCSR = _FT("vstmxcsr");
extern const fcml_cstring M_VSUBPD = _FT("vsubpd");
extern const fcml_cstring M_VSUBPS = _FT("vsubps");
extern const fcml_cstring M_VSUBSD = _FT("vsubsd");
extern const fcml_cstring M_VSUBSS = _FT("vsubss");
extern const fcml_cstring M_VTESTPD = _FT("vtestpd");
extern const fcml_cstring M_VTESTPS = _FT("vtestps");
extern const fcml_cstring M_VUCOMISD = _FT("vucomisd");
extern const fcml_cstring M_VUCOMISS = _FT("vucomiss");
extern const fcml_cstring M_VUNPCKHPD = _FT("vunpckhpd");
extern const fcml_cstring M_VUNPCKHPS = _FT("vunpckhps");
extern const fcml_cstring M_VUNPCKLPD = _FT("vunpcklpd");
extern const fcml_cstring M_VUNPCKLPS = _FT("vunpcklps");
extern const fcml_cstring M_VXORPD = _FT("vxorpd");
extern const fcml_cstring M_VXORPS = _FT("vxorps");
extern const fcml_cstring M_VZEROALL = _FT("vzeroall");
extern const fcml_cstring M_VZEROUPPER = _FT("vzeroupper");
extern const fcml_cstring M_WAIT = _FT("wait");
extern const fcml_cstring M_WBINVD = _FT("wbinvd");
extern const fcml_cstring M_WRFSBASE = _FT("wrfsbase");
extern const fcml_cstring M_WRGSBASE = _FT("wrgsbase");
extern const fcml_cstring M_WRMSR = _FT("wrmsr");
extern const fcml_cstring M_XABORT = _FT("xabort");
extern const fcml_cstring M_XADD = _FT("xadd");
extern const fcml_cstring M_XBEGIN = _FT("xbegin");
extern const fcml_cstring M_XCHG = _FT("xchg");
extern const fcml_cstring M_XEND = _FT("xend");
extern const fcml_cstring M_XGETBV = _FT("xgetbv");
extern const fcml_cstring M_XLAT = _FT("xlat");
extern const fcml_cstring M_XLATB = _FT("xlatb");
extern const fcml_cstring M_XOR = _FT("xor");
extern const fcml_cstring M_XORPD = _FT("xorpd");
extern const fcml_cstring M_XORPS = _FT("xorps");
extern const fcml_cstring M_XRSTOR = _FT("xrstor");
extern const fcml_cstring M_XRSTOR64 = _FT("xrstor64");
extern const fcml_cstring M_XSAVE = _FT("xsave");
extern const fcml_cstring M_XSAVE64 = _FT("xsave64");
extern const fcml_cstring M_XSAVEOPT = _FT("xsaveopt");
extern const fcml_cstring M_XSAVEOPT64 = _FT("xsaveopt64");
extern const fcml_cstring M_XSETBV = _FT("xsetbv");
extern const fcml_cstring M_XTEST = _FT("xtest");

}
}

