/* $Id: sprite.h,v 1.26 2003/06/13 09:49:52 sjoerd Exp $ */
#ifndef FFRENZY_SPRITE_H
#define FFRENZY_SPRITE_H

#include <stdio.h>
#include <SDL.h>

#include "list.h"
#include "vector.h"
#include "svg.h"

typedef enum {
  SS_PLAYER_DEAD = 0,
	SS_PLAYER_UNCONSCIOUS,
	SS_PLAYER_HIT,
	SS_PLAYER_LTHROW,
	SS_PLAYER_RTHROW,
	SS_PLAYER_LJUMP,
	SS_PLAYER_RJUMP,
	SS_PLAYER_LWALK,
	SS_PLAYER_RWALK,
	SS_PLAYER_LSTAND,
	SS_PLAYER_RSTAND,
	SS_FOOD_NORMAL,
	SS_FOOD_UPGRADE,
  SS_SCENERY_NORMAL,
  SS_NRSTATES
} Sprite_state;

typedef struct {
	Vector *p0; /**< Beginpoint */
	Vector *p1; /**< Control point for beginpoint */
	Vector *p2; /**< Control point for endpoint */
	Vector *p3; /**< Endpoint */
} Bezier_Vectors;

/******************************************************************************
 * Graphics Sprite Source 
 *****************************************************************************/

/** Data structures **/

typedef struct {
	int red;
	int green;
	int blue;
	int alpha;
} Graphics_sprite_rgba;

typedef struct {
  List *states; /**< List of Graphics_sprite_state */
} Graphics_sprite_source;

typedef struct {
  Sprite_state state; /**< State for which the graphic(s) is/are meant for */
  int fpp; /**< Frames per pixmap */
  List *pics; /**< List of Graphics_sprite_pic */
} Graphics_sprite_state;

typedef struct {
  List *paths; /**< List of Graphics_sprite_path */
} Graphics_sprite_pic;

typedef struct {
	Graphics_sprite_rgba *linecolor;
	Graphics_sprite_rgba *fillcolor;
  List *elems; /**< List of Graphics_sprite_path_elem */
} Graphics_sprite_path;

typedef enum {
  ET_LINE = 0,
  ET_BEZIER,
  ET_RECT,
  ET_NRTYPES
} Graphics_sprite_path_elem_type;

typedef struct {
  Graphics_sprite_path_elem_type type; /**< Type of path element */
  Bezier_Vectors *bvecs; /**< Bezier_Vectors */
} Graphics_sprite_path_elem;

typedef struct {
	int numframes;
	int fpp;
	SDL_Surface **anim; /**< Array of SDL_Surface[frameno] */
} Graphics_sprite_anim;

/** Function **/

Graphics_sprite_source *new_sprite_source(void);
int del_sprite_source(Graphics_sprite_source *gsp_source);
void sprite_source_add_state(Graphics_sprite_source *gsp_source, Graphics_sprite_state *gsp_state);

Graphics_sprite_state *new_sprite_state(void);
int del_sprite_state(Graphics_sprite_state *gsp_state);
void sprite_state_set_state(Graphics_sprite_state *gsp_state, char *state);
void sprite_state_set_fpp(Graphics_sprite_state *gsp_state, int fpp);
void sprite_state_add_pic(Graphics_sprite_state *gsp_state, Graphics_sprite_pic *gsp_pic);

Graphics_sprite_pic *new_sprite_pic(void);
int del_sprite_pic(Graphics_sprite_pic *gsp_pic);
void sprite_pic_add_path(Graphics_sprite_pic *gsp_pic, Graphics_sprite_path *gsp_path);

Graphics_sprite_path *new_sprite_path(void);
int del_sprite_path(Graphics_sprite_path *gsp_path);
void sprite_path_set_linecolor(Graphics_sprite_path *gsp_path, Graphics_sprite_rgba *linecolor);
void sprite_path_set_fillcolor(Graphics_sprite_path *gsp_path, Graphics_sprite_rgba *fillcolor);
void sprite_path_add_elem(Graphics_sprite_path *gsp_path, Graphics_sprite_path_elem *gsp_path_elem);

Graphics_sprite_path_elem *new_sprite_path_elem(void);
int del_sprite_path_elem(Graphics_sprite_path_elem *gsp_pelem);
void sprite_path_elem_set_type(Graphics_sprite_path_elem *gsp_pelem, Graphics_sprite_path_elem_type type);
void sprite_path_elem_set_vector(Graphics_sprite_path_elem *gsp_pelem, Bezier_Vectors *v);

Graphics_sprite_source *gss_to_sprite_source(Graphics_svg_series *gss);

/******************************************************************************
 * Sprite drawing
 *****************************************************************************/

/** Data structure **/

/** Functions **/

Bezier_Vectors *new_bezier_vectors(Vector *p0, Vector *p1, Vector *p2, Vector *p3); 
int del_bezier_vectors(Bezier_Vectors *bvectors);


Graphics_sprite_anim *draw_sprite_anim(SDL_Surface *g, Vector *size, 
                                       Sprite_state state, 
                                       Graphics_sprite_source *gss);
SDL_Surface * sprite_anim_getsurface(Graphics_sprite_anim *gsa,
                                     Sprite_state state, int *framenr);
void del_graphics_sprite_anim(Graphics_sprite_anim *gsa);
#endif
