//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybriddatamanager

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type DataManager.
func (d DataManager) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DataManagerUpdateParameter.
func (d DataManagerUpdateParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DataServiceProperties.
func (d DataServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "state", d.State)
	populate(objectMap, "supportedDataSinkTypes", d.SupportedDataSinkTypes)
	populate(objectMap, "supportedDataSourceTypes", d.SupportedDataSourceTypes)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DataStoreProperties.
func (d DataStoreProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customerSecrets", d.CustomerSecrets)
	populate(objectMap, "dataStoreTypeId", d.DataStoreTypeID)
	populate(objectMap, "extendedProperties", &d.ExtendedProperties)
	populate(objectMap, "repositoryId", d.RepositoryID)
	populate(objectMap, "state", d.State)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type DataStoreTypeProperties.
func (d DataStoreTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "repositoryType", d.RepositoryType)
	populate(objectMap, "state", d.State)
	populate(objectMap, "supportedDataServicesAsSink", d.SupportedDataServicesAsSink)
	populate(objectMap, "supportedDataServicesAsSource", d.SupportedDataServicesAsSource)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Job.
func (j Job) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "endTime", j.EndTime)
	populate(objectMap, "error", j.Error)
	populate(objectMap, "id", j.ID)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populateTimeRFC3339(objectMap, "startTime", j.StartTime)
	populate(objectMap, "status", j.Status)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Job.
func (j *Job) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulateTimeRFC3339(val, "EndTime", &j.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &j.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobDefinitionFilter.
func (j *JobDefinitionFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataSource":
			err = unpopulate(val, "DataSource", &j.DataSource)
			delete(rawMsg, key)
		case "lastModified":
			err = unpopulateTimeRFC3339(val, "LastModified", &j.LastModified)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &j.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobDefinitionProperties.
func (j JobDefinitionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customerSecrets", j.CustomerSecrets)
	populate(objectMap, "dataServiceInput", &j.DataServiceInput)
	populate(objectMap, "dataSinkId", j.DataSinkID)
	populate(objectMap, "dataSourceId", j.DataSourceID)
	populateTimeRFC3339(objectMap, "lastModifiedTime", j.LastModifiedTime)
	populate(objectMap, "runLocation", j.RunLocation)
	populate(objectMap, "schedules", j.Schedules)
	populate(objectMap, "state", j.State)
	populate(objectMap, "userConfirmation", j.UserConfirmation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobDefinitionProperties.
func (j *JobDefinitionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customerSecrets":
			err = unpopulate(val, "CustomerSecrets", &j.CustomerSecrets)
			delete(rawMsg, key)
		case "dataServiceInput":
			err = unpopulate(val, "DataServiceInput", &j.DataServiceInput)
			delete(rawMsg, key)
		case "dataSinkId":
			err = unpopulate(val, "DataSinkID", &j.DataSinkID)
			delete(rawMsg, key)
		case "dataSourceId":
			err = unpopulate(val, "DataSourceID", &j.DataSourceID)
			delete(rawMsg, key)
		case "lastModifiedTime":
			err = unpopulateTimeRFC3339(val, "LastModifiedTime", &j.LastModifiedTime)
			delete(rawMsg, key)
		case "runLocation":
			err = unpopulate(val, "RunLocation", &j.RunLocation)
			delete(rawMsg, key)
		case "schedules":
			err = unpopulate(val, "Schedules", &j.Schedules)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &j.State)
			delete(rawMsg, key)
		case "userConfirmation":
			err = unpopulate(val, "UserConfirmation", &j.UserConfirmation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobDetails.
func (j JobDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorDetails", j.ErrorDetails)
	populate(objectMap, "itemDetailsLink", j.ItemDetailsLink)
	populate(objectMap, "jobDefinition", j.JobDefinition)
	populate(objectMap, "jobStages", j.JobStages)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobFilter.
func (j *JobFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "startTime":
			err = unpopulateTimeRFC3339(val, "StartTime", &j.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobStages.
func (j JobStages) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "errorDetails", j.ErrorDetails)
	populate(objectMap, "jobStageDetails", &j.JobStageDetails)
	populate(objectMap, "stageName", j.StageName)
	populate(objectMap, "stageStatus", j.StageStatus)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type RunParameters.
func (r RunParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "customerSecrets", r.CustomerSecrets)
	populate(objectMap, "dataServiceInput", &r.DataServiceInput)
	populate(objectMap, "userConfirmation", r.UserConfirmation)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type Schedule.
func (s Schedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", s.Name)
	populate(objectMap, "policyList", s.PolicyList)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
