static char rcsid[] = "$Id: oligoindex_hr.c 223527 2020-11-15 02:34:16Z twu $";
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#ifndef HAVE_MEMCPY
# define memcpy(d,s,n) bcopy((s),(d),(n))
#endif
#ifndef HAVE_MEMMOVE
# define memmove(d,s,n) bcopy((s),(d),(n))
#endif

#include "oligoindex_hr.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>		/* For memcpy and memset */
#include "assert.h"
#include "mem.h"
#include "orderstat.h"
#include "cmet.h"
#include "atoi.h"

#ifndef USE_DIAGPOOL
#include "diag.h"
#endif



#ifdef HAVE_AVX512
/* AVX512 */
#define EXTRACT(x,i) _mm_extract_epi32(x,i)
#define EXTRACT256(x,i) _mm256_extract_epi32(x,i)

#elif defined(HAVE_AVX2)
/* AVX2 */
#define EXTRACT(x,i) _mm_extract_epi32(x,i)
#define EXTRACT256(x,i) _mm256_extract_epi32(x,i)

#elif defined(HAVE_SSE4_2)
/* SSE4.2 */
#define USE_UNORDERED_9 1
#define USE_UNORDERED_8 1
#define USE_UNORDERED_7 1
#define USE_UNORDERED_6 1
#define USE_UNORDERED_5 1

#define EXTRACT(x,i) _mm_extract_epi32(x,i)

#elif defined(HAVE_SSE4_1)
/* SSE4.1 */
#define USE_UNORDERED_9 1
#define USE_UNORDERED_8 1
#define USE_UNORDERED_7 1
#define USE_UNORDERED_6 1
#define USE_UNORDERED_5 1

#define EXTRACT(x,i) _mm_extract_epi32(x,i)

#elif defined(HAVE_SSSE3)
/* SSSE3 */
#define USE_UNORDERED_9 1
#define USE_UNORDERED_8 1
#define USE_UNORDERED_7 1
#define USE_UNORDERED_6 1
#define USE_UNORDERED_5 1

#define SIMD_MASK_THEN_STORE
#define EXTRACT(x,i) x[i]

#elif defined(HAVE_SSE2)
/* SSE2 */
#define USE_UNORDERED_9 1
#define USE_UNORDERED_8 1
#define USE_UNORDERED_7 1
#define USE_UNORDERED_6 1
#define USE_UNORDERED_5 1

#define SIMD_MASK_THEN_STORE
#define EXTRACT(x,i) x[i]

#else
/* non-SIMD */
#define USE_UNORDERED_9 1
#define USE_UNORDERED_8 1
#define USE_UNORDERED_7 1
#define USE_UNORDERED_6 1
#define USE_UNORDERED_5 1

#define INDIVIDUAL_SHIFTS 1
#endif


#if defined(USE_UNORDERED_9) || defined(USE_UNORDERED_8) || defined(USE_UNORDERED_7) || defined(USE_UNORDERED_6) || defined(USE_UNORDERED_5)
#define USE_UNORDERED 1
#endif


#define THETADIFF1 20.0
#define THETADIFF2 20.0
#define REPOLIGOCOUNT 8

/* For PMAP, use oligoindex_pmap.c */
/* #define NT_PER_MATCH 1 */


struct Genomicdiag_T {
  int i;
  int querypos;
  int best_nconsecutive;
  int nconsecutive;
  int best_consecutive_start;
  int consecutive_start;
  int best_consecutive_end;
};
typedef struct Genomicdiag_T *Genomicdiag_T;

#define T Oligoindex_T


struct Oligoindex_array_T {
  T *array;
  int length;

  /* Permanent storage space to avoid allocating/deallocating memory in Oligoindex_get_mappings */
  int max_querylength;
  int max_genomiclength;
  bool *genomicdiag_init_p;
  struct Genomicdiag_T *genomicdiag;
  int *cum_nohits_allocated;
};


#ifdef DEBUG
#define debug(x) x
#else
#define debug(x)
#endif

#ifdef DEBUG0
#define debug0(x) x
#else
#define debug0(x)
#endif

#ifdef DEBUG1
#define debug1(x) x
#else
#define debug1(x)
#endif

/* Diagonals */
#ifdef DEBUG3
#define debug3(x) x
#else
#define debug3(x)
#endif

/* dump_positions */
#ifdef DEBUG9
#define debug9(x) x
#else
#define debug9(x)
#endif


#if 0
#ifdef HAVE_SSE2
/* For debugging of SIMD procedures*/
static void
print_vector (__m128i x, char *label) {
  unsigned int s[4];

  _mm_store_si128((__m128i *) s,x);
  _mm_mfence();
  printf("%s: %08X %08X %08X %08X\n",label,s[0],s[1],s[2],s[3]);
  return;
}

/* For debugging of SIMD procedures*/
static void
print_counts (__m128i x, char *label) {
  Count_T s[16];

  _mm_store_si128((__m128i *) s,x);
  _mm_mfence();
  printf("%s:",label);
  printf(" %hhu",s[0]);
  printf(" %hhu",s[1]);
  printf(" %hhu",s[2]);
  printf(" %hhu",s[3]);
  printf(" %hhu",s[4]);
  printf(" %hhu",s[5]);
  printf(" %hhu",s[6]);
  printf(" %hhu",s[7]);
  printf(" %hhu",s[8]);
  printf(" %hhu",s[9]);
  printf(" %hhu",s[10]);
  printf(" %hhu",s[11]);
  printf(" %hhu",s[12]);
  printf(" %hhu",s[13]);
  printf(" %hhu",s[14]);
  printf(" %hhu",s[15]);
  printf("\n");
  return;
}
#endif

#ifdef HAVE_AVX2
static void
print_counts_256 (__m256i x, char *label) {
  Count_T s[32];

  _mm256_store_si256((__m256i *) s,x);
  _mm_mfence();
  printf("%s:",label);
  printf(" %hhu",s[0]);
  printf(" %hhu",s[1]);
  printf(" %hhu",s[2]);
  printf(" %hhu",s[3]);
  printf(" %hhu",s[4]);
  printf(" %hhu",s[5]);
  printf(" %hhu",s[6]);
  printf(" %hhu",s[7]);
  printf(" %hhu",s[8]);
  printf(" %hhu",s[9]);
  printf(" %hhu",s[10]);
  printf(" %hhu",s[11]);
  printf(" %hhu",s[12]);
  printf(" %hhu",s[13]);
  printf(" %hhu",s[14]);
  printf(" %hhu",s[15]);
  printf(" %hhu",s[16]);
  printf(" %hhu",s[17]);
  printf(" %hhu",s[18]);
  printf(" %hhu",s[19]);
  printf(" %hhu",s[20]);
  printf(" %hhu",s[21]);
  printf(" %hhu",s[22]);
  printf(" %hhu",s[23]);
  printf(" %hhu",s[24]);
  printf(" %hhu",s[25]);
  printf(" %hhu",s[26]);
  printf(" %hhu",s[27]);
  printf(" %hhu",s[28]);
  printf(" %hhu",s[29]);
  printf(" %hhu",s[30]);
  printf(" %hhu",s[31]);
  printf("\n");
  return;
}

/* For debugging of SIMD procedures*/
static void
print_vector_256 (__m256i x, char *label) {
  unsigned int s[8];

  _mm256_store_si256((__m256i *) s,x);
  _mm_mfence();
#if 0
  printf("%s: %08X %u\n",label,s[0],s[0]);
  printf("%s: %08X %u\n",label,s[1],s[1]);
  printf("%s: %08X %u\n",label,s[2],s[2]);
  printf("%s: %08X %u\n",label,s[3],s[3]);
  printf("%s: %08X %u\n",label,s[4],s[4]);
  printf("%s: %08X %u\n",label,s[5],s[5]);
  printf("%s: %08X %u\n",label,s[6],s[6]);
  printf("%s: %08X %u\n",label,s[7],s[7]);
#else
  printf("%s: %08X %08X %08X %08X %08X %08X %08X %08X\n",
	 label,s[0],s[1],s[2],s[3],s[4],s[5],s[6],s[7]);
#endif
  return;
}
#endif

#ifdef HAVE_AVX512
static void
print_counts_512 (__m512i x, char *label) {
  Count_T s[64];

  _mm512_store_si512((__m512i *) s,x);
  _mm_mfence();
#if 0
  printf("%s:",label);
  printf(" %u",s[0]);
  printf(" %u",s[1]);
  printf(" %u",s[2]);
  printf(" %u",s[3]);
  printf(" %u",s[4]);
  printf(" %u",s[5]);
  printf(" %u",s[6]);
  printf(" %u",s[7]);
  printf(" %u",s[8]);
  printf(" %u",s[9]);
  printf(" %u",s[10]);
  printf(" %u",s[11]);
  printf(" %u",s[12]);
  printf(" %u",s[13]);
  printf(" %u",s[14]);
  printf(" %u",s[15]);
  printf("\n");
#else
  printf("%s: %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X\n",
    label,s[0],s[1],s[2],s[3],s[4],s[5],s[6],s[7],s[8],s[9],s[10],s[11],s[12],s[13],s[14],s[15]);
#endif
  return;
}

/* For debugging of SIMD procedures*/
static void
print_vector_512 (__m512i x, char *label) {
  unsigned int s[16];

  _mm512_store_si512((__m512i *) s,x);
  _mm_mfence();
#if 0
  printf("%s: %08X %u\n",label,s[0],s[0]);
  printf("%s: %08X %u\n",label,s[1],s[1]);
  printf("%s: %08X %u\n",label,s[2],s[2]);
  printf("%s: %08X %u\n",label,s[3],s[3]);
  printf("%s: %08X %u\n",label,s[4],s[4]);
  printf("%s: %08X %u\n",label,s[5],s[5]);
  printf("%s: %08X %u\n",label,s[6],s[6]);
  printf("%s: %08X %u\n",label,s[7],s[7]);
  printf("%s: %08X %u\n",label,s[8],s[8]);
  printf("%s: %08X %u\n",label,s[9],s[9]);
  printf("%s: %08X %u\n",label,s[10],s[10]);
  printf("%s: %08X %u\n",label,s[11],s[11]);
  printf("%s: %08X %u\n",label,s[12],s[12]);
  printf("%s: %08X %u\n",label,s[13],s[13]);
  printf("%s: %08X %u\n",label,s[14],s[14]);
  printf("%s: %08X %u\n",label,s[15],s[15]);
#else
  printf("%s: %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X\n",
    label,s[0],s[1],s[2],s[3],s[4],s[5],s[6],s[7],s[8],s[9],s[10],s[11],s[12],s[13],s[14],s[15]);
#endif
  return;
}
#endif

#endif


#if !defined(HAVE_SSE2) || !defined(HAVE_SSE4_1) || defined(CHECK_ASSERTIONS)
static const Genomecomp_T reverse_nt[] = 
{0x0000,0x4000,0x8000,0xC000,0x1000,0x5000,0x9000,0xD000,
 0x2000,0x6000,0xA000,0xE000,0x3000,0x7000,0xB000,0xF000,
 0x0400,0x4400,0x8400,0xC400,0x1400,0x5400,0x9400,0xD400,
 0x2400,0x6400,0xA400,0xE400,0x3400,0x7400,0xB400,0xF400,
 0x0800,0x4800,0x8800,0xC800,0x1800,0x5800,0x9800,0xD800,
 0x2800,0x6800,0xA800,0xE800,0x3800,0x7800,0xB800,0xF800,
 0x0C00,0x4C00,0x8C00,0xCC00,0x1C00,0x5C00,0x9C00,0xDC00,
 0x2C00,0x6C00,0xAC00,0xEC00,0x3C00,0x7C00,0xBC00,0xFC00,
 0x0100,0x4100,0x8100,0xC100,0x1100,0x5100,0x9100,0xD100,
 0x2100,0x6100,0xA100,0xE100,0x3100,0x7100,0xB100,0xF100,
 0x0500,0x4500,0x8500,0xC500,0x1500,0x5500,0x9500,0xD500,
 0x2500,0x6500,0xA500,0xE500,0x3500,0x7500,0xB500,0xF500,
 0x0900,0x4900,0x8900,0xC900,0x1900,0x5900,0x9900,0xD900,
 0x2900,0x6900,0xA900,0xE900,0x3900,0x7900,0xB900,0xF900,
 0x0D00,0x4D00,0x8D00,0xCD00,0x1D00,0x5D00,0x9D00,0xDD00,
 0x2D00,0x6D00,0xAD00,0xED00,0x3D00,0x7D00,0xBD00,0xFD00,
 0x0200,0x4200,0x8200,0xC200,0x1200,0x5200,0x9200,0xD200,
 0x2200,0x6200,0xA200,0xE200,0x3200,0x7200,0xB200,0xF200,
 0x0600,0x4600,0x8600,0xC600,0x1600,0x5600,0x9600,0xD600,
 0x2600,0x6600,0xA600,0xE600,0x3600,0x7600,0xB600,0xF600,
 0x0A00,0x4A00,0x8A00,0xCA00,0x1A00,0x5A00,0x9A00,0xDA00,
 0x2A00,0x6A00,0xAA00,0xEA00,0x3A00,0x7A00,0xBA00,0xFA00,
 0x0E00,0x4E00,0x8E00,0xCE00,0x1E00,0x5E00,0x9E00,0xDE00,
 0x2E00,0x6E00,0xAE00,0xEE00,0x3E00,0x7E00,0xBE00,0xFE00,
 0x0300,0x4300,0x8300,0xC300,0x1300,0x5300,0x9300,0xD300,
 0x2300,0x6300,0xA300,0xE300,0x3300,0x7300,0xB300,0xF300,
 0x0700,0x4700,0x8700,0xC700,0x1700,0x5700,0x9700,0xD700,
 0x2700,0x6700,0xA700,0xE700,0x3700,0x7700,0xB700,0xF700,
 0x0B00,0x4B00,0x8B00,0xCB00,0x1B00,0x5B00,0x9B00,0xDB00,
 0x2B00,0x6B00,0xAB00,0xEB00,0x3B00,0x7B00,0xBB00,0xFB00,
 0x0F00,0x4F00,0x8F00,0xCF00,0x1F00,0x5F00,0x9F00,0xDF00,
 0x2F00,0x6F00,0xAF00,0xEF00,0x3F00,0x7F00,0xBF00,0xFF00,
 0x0040,0x4040,0x8040,0xC040,0x1040,0x5040,0x9040,0xD040,
 0x2040,0x6040,0xA040,0xE040,0x3040,0x7040,0xB040,0xF040,
 0x0440,0x4440,0x8440,0xC440,0x1440,0x5440,0x9440,0xD440,
 0x2440,0x6440,0xA440,0xE440,0x3440,0x7440,0xB440,0xF440,
 0x0840,0x4840,0x8840,0xC840,0x1840,0x5840,0x9840,0xD840,
 0x2840,0x6840,0xA840,0xE840,0x3840,0x7840,0xB840,0xF840,
 0x0C40,0x4C40,0x8C40,0xCC40,0x1C40,0x5C40,0x9C40,0xDC40,
 0x2C40,0x6C40,0xAC40,0xEC40,0x3C40,0x7C40,0xBC40,0xFC40,
 0x0140,0x4140,0x8140,0xC140,0x1140,0x5140,0x9140,0xD140,
 0x2140,0x6140,0xA140,0xE140,0x3140,0x7140,0xB140,0xF140,
 0x0540,0x4540,0x8540,0xC540,0x1540,0x5540,0x9540,0xD540,
 0x2540,0x6540,0xA540,0xE540,0x3540,0x7540,0xB540,0xF540,
 0x0940,0x4940,0x8940,0xC940,0x1940,0x5940,0x9940,0xD940,
 0x2940,0x6940,0xA940,0xE940,0x3940,0x7940,0xB940,0xF940,
 0x0D40,0x4D40,0x8D40,0xCD40,0x1D40,0x5D40,0x9D40,0xDD40,
 0x2D40,0x6D40,0xAD40,0xED40,0x3D40,0x7D40,0xBD40,0xFD40,
 0x0240,0x4240,0x8240,0xC240,0x1240,0x5240,0x9240,0xD240,
 0x2240,0x6240,0xA240,0xE240,0x3240,0x7240,0xB240,0xF240,
 0x0640,0x4640,0x8640,0xC640,0x1640,0x5640,0x9640,0xD640,
 0x2640,0x6640,0xA640,0xE640,0x3640,0x7640,0xB640,0xF640,
 0x0A40,0x4A40,0x8A40,0xCA40,0x1A40,0x5A40,0x9A40,0xDA40,
 0x2A40,0x6A40,0xAA40,0xEA40,0x3A40,0x7A40,0xBA40,0xFA40,
 0x0E40,0x4E40,0x8E40,0xCE40,0x1E40,0x5E40,0x9E40,0xDE40,
 0x2E40,0x6E40,0xAE40,0xEE40,0x3E40,0x7E40,0xBE40,0xFE40,
 0x0340,0x4340,0x8340,0xC340,0x1340,0x5340,0x9340,0xD340,
 0x2340,0x6340,0xA340,0xE340,0x3340,0x7340,0xB340,0xF340,
 0x0740,0x4740,0x8740,0xC740,0x1740,0x5740,0x9740,0xD740,
 0x2740,0x6740,0xA740,0xE740,0x3740,0x7740,0xB740,0xF740,
 0x0B40,0x4B40,0x8B40,0xCB40,0x1B40,0x5B40,0x9B40,0xDB40,
 0x2B40,0x6B40,0xAB40,0xEB40,0x3B40,0x7B40,0xBB40,0xFB40,
 0x0F40,0x4F40,0x8F40,0xCF40,0x1F40,0x5F40,0x9F40,0xDF40,
 0x2F40,0x6F40,0xAF40,0xEF40,0x3F40,0x7F40,0xBF40,0xFF40,
 0x0080,0x4080,0x8080,0xC080,0x1080,0x5080,0x9080,0xD080,
 0x2080,0x6080,0xA080,0xE080,0x3080,0x7080,0xB080,0xF080,
 0x0480,0x4480,0x8480,0xC480,0x1480,0x5480,0x9480,0xD480,
 0x2480,0x6480,0xA480,0xE480,0x3480,0x7480,0xB480,0xF480,
 0x0880,0x4880,0x8880,0xC880,0x1880,0x5880,0x9880,0xD880,
 0x2880,0x6880,0xA880,0xE880,0x3880,0x7880,0xB880,0xF880,
 0x0C80,0x4C80,0x8C80,0xCC80,0x1C80,0x5C80,0x9C80,0xDC80,
 0x2C80,0x6C80,0xAC80,0xEC80,0x3C80,0x7C80,0xBC80,0xFC80,
 0x0180,0x4180,0x8180,0xC180,0x1180,0x5180,0x9180,0xD180,
 0x2180,0x6180,0xA180,0xE180,0x3180,0x7180,0xB180,0xF180,
 0x0580,0x4580,0x8580,0xC580,0x1580,0x5580,0x9580,0xD580,
 0x2580,0x6580,0xA580,0xE580,0x3580,0x7580,0xB580,0xF580,
 0x0980,0x4980,0x8980,0xC980,0x1980,0x5980,0x9980,0xD980,
 0x2980,0x6980,0xA980,0xE980,0x3980,0x7980,0xB980,0xF980,
 0x0D80,0x4D80,0x8D80,0xCD80,0x1D80,0x5D80,0x9D80,0xDD80,
 0x2D80,0x6D80,0xAD80,0xED80,0x3D80,0x7D80,0xBD80,0xFD80,
 0x0280,0x4280,0x8280,0xC280,0x1280,0x5280,0x9280,0xD280,
 0x2280,0x6280,0xA280,0xE280,0x3280,0x7280,0xB280,0xF280,
 0x0680,0x4680,0x8680,0xC680,0x1680,0x5680,0x9680,0xD680,
 0x2680,0x6680,0xA680,0xE680,0x3680,0x7680,0xB680,0xF680,
 0x0A80,0x4A80,0x8A80,0xCA80,0x1A80,0x5A80,0x9A80,0xDA80,
 0x2A80,0x6A80,0xAA80,0xEA80,0x3A80,0x7A80,0xBA80,0xFA80,
 0x0E80,0x4E80,0x8E80,0xCE80,0x1E80,0x5E80,0x9E80,0xDE80,
 0x2E80,0x6E80,0xAE80,0xEE80,0x3E80,0x7E80,0xBE80,0xFE80,
 0x0380,0x4380,0x8380,0xC380,0x1380,0x5380,0x9380,0xD380,
 0x2380,0x6380,0xA380,0xE380,0x3380,0x7380,0xB380,0xF380,
 0x0780,0x4780,0x8780,0xC780,0x1780,0x5780,0x9780,0xD780,
 0x2780,0x6780,0xA780,0xE780,0x3780,0x7780,0xB780,0xF780,
 0x0B80,0x4B80,0x8B80,0xCB80,0x1B80,0x5B80,0x9B80,0xDB80,
 0x2B80,0x6B80,0xAB80,0xEB80,0x3B80,0x7B80,0xBB80,0xFB80,
 0x0F80,0x4F80,0x8F80,0xCF80,0x1F80,0x5F80,0x9F80,0xDF80,
 0x2F80,0x6F80,0xAF80,0xEF80,0x3F80,0x7F80,0xBF80,0xFF80,
 0x00C0,0x40C0,0x80C0,0xC0C0,0x10C0,0x50C0,0x90C0,0xD0C0,
 0x20C0,0x60C0,0xA0C0,0xE0C0,0x30C0,0x70C0,0xB0C0,0xF0C0,
 0x04C0,0x44C0,0x84C0,0xC4C0,0x14C0,0x54C0,0x94C0,0xD4C0,
 0x24C0,0x64C0,0xA4C0,0xE4C0,0x34C0,0x74C0,0xB4C0,0xF4C0,
 0x08C0,0x48C0,0x88C0,0xC8C0,0x18C0,0x58C0,0x98C0,0xD8C0,
 0x28C0,0x68C0,0xA8C0,0xE8C0,0x38C0,0x78C0,0xB8C0,0xF8C0,
 0x0CC0,0x4CC0,0x8CC0,0xCCC0,0x1CC0,0x5CC0,0x9CC0,0xDCC0,
 0x2CC0,0x6CC0,0xACC0,0xECC0,0x3CC0,0x7CC0,0xBCC0,0xFCC0,
 0x01C0,0x41C0,0x81C0,0xC1C0,0x11C0,0x51C0,0x91C0,0xD1C0,
 0x21C0,0x61C0,0xA1C0,0xE1C0,0x31C0,0x71C0,0xB1C0,0xF1C0,
 0x05C0,0x45C0,0x85C0,0xC5C0,0x15C0,0x55C0,0x95C0,0xD5C0,
 0x25C0,0x65C0,0xA5C0,0xE5C0,0x35C0,0x75C0,0xB5C0,0xF5C0,
 0x09C0,0x49C0,0x89C0,0xC9C0,0x19C0,0x59C0,0x99C0,0xD9C0,
 0x29C0,0x69C0,0xA9C0,0xE9C0,0x39C0,0x79C0,0xB9C0,0xF9C0,
 0x0DC0,0x4DC0,0x8DC0,0xCDC0,0x1DC0,0x5DC0,0x9DC0,0xDDC0,
 0x2DC0,0x6DC0,0xADC0,0xEDC0,0x3DC0,0x7DC0,0xBDC0,0xFDC0,
 0x02C0,0x42C0,0x82C0,0xC2C0,0x12C0,0x52C0,0x92C0,0xD2C0,
 0x22C0,0x62C0,0xA2C0,0xE2C0,0x32C0,0x72C0,0xB2C0,0xF2C0,
 0x06C0,0x46C0,0x86C0,0xC6C0,0x16C0,0x56C0,0x96C0,0xD6C0,
 0x26C0,0x66C0,0xA6C0,0xE6C0,0x36C0,0x76C0,0xB6C0,0xF6C0,
 0x0AC0,0x4AC0,0x8AC0,0xCAC0,0x1AC0,0x5AC0,0x9AC0,0xDAC0,
 0x2AC0,0x6AC0,0xAAC0,0xEAC0,0x3AC0,0x7AC0,0xBAC0,0xFAC0,
 0x0EC0,0x4EC0,0x8EC0,0xCEC0,0x1EC0,0x5EC0,0x9EC0,0xDEC0,
 0x2EC0,0x6EC0,0xAEC0,0xEEC0,0x3EC0,0x7EC0,0xBEC0,0xFEC0,
 0x03C0,0x43C0,0x83C0,0xC3C0,0x13C0,0x53C0,0x93C0,0xD3C0,
 0x23C0,0x63C0,0xA3C0,0xE3C0,0x33C0,0x73C0,0xB3C0,0xF3C0,
 0x07C0,0x47C0,0x87C0,0xC7C0,0x17C0,0x57C0,0x97C0,0xD7C0,
 0x27C0,0x67C0,0xA7C0,0xE7C0,0x37C0,0x77C0,0xB7C0,0xF7C0,
 0x0BC0,0x4BC0,0x8BC0,0xCBC0,0x1BC0,0x5BC0,0x9BC0,0xDBC0,
 0x2BC0,0x6BC0,0xABC0,0xEBC0,0x3BC0,0x7BC0,0xBBC0,0xFBC0,
 0x0FC0,0x4FC0,0x8FC0,0xCFC0,0x1FC0,0x5FC0,0x9FC0,0xDFC0,
 0x2FC0,0x6FC0,0xAFC0,0xEFC0,0x3FC0,0x7FC0,0xBFC0,0xFFC0,
 0x0010,0x4010,0x8010,0xC010,0x1010,0x5010,0x9010,0xD010,
 0x2010,0x6010,0xA010,0xE010,0x3010,0x7010,0xB010,0xF010,
 0x0410,0x4410,0x8410,0xC410,0x1410,0x5410,0x9410,0xD410,
 0x2410,0x6410,0xA410,0xE410,0x3410,0x7410,0xB410,0xF410,
 0x0810,0x4810,0x8810,0xC810,0x1810,0x5810,0x9810,0xD810,
 0x2810,0x6810,0xA810,0xE810,0x3810,0x7810,0xB810,0xF810,
 0x0C10,0x4C10,0x8C10,0xCC10,0x1C10,0x5C10,0x9C10,0xDC10,
 0x2C10,0x6C10,0xAC10,0xEC10,0x3C10,0x7C10,0xBC10,0xFC10,
 0x0110,0x4110,0x8110,0xC110,0x1110,0x5110,0x9110,0xD110,
 0x2110,0x6110,0xA110,0xE110,0x3110,0x7110,0xB110,0xF110,
 0x0510,0x4510,0x8510,0xC510,0x1510,0x5510,0x9510,0xD510,
 0x2510,0x6510,0xA510,0xE510,0x3510,0x7510,0xB510,0xF510,
 0x0910,0x4910,0x8910,0xC910,0x1910,0x5910,0x9910,0xD910,
 0x2910,0x6910,0xA910,0xE910,0x3910,0x7910,0xB910,0xF910,
 0x0D10,0x4D10,0x8D10,0xCD10,0x1D10,0x5D10,0x9D10,0xDD10,
 0x2D10,0x6D10,0xAD10,0xED10,0x3D10,0x7D10,0xBD10,0xFD10,
 0x0210,0x4210,0x8210,0xC210,0x1210,0x5210,0x9210,0xD210,
 0x2210,0x6210,0xA210,0xE210,0x3210,0x7210,0xB210,0xF210,
 0x0610,0x4610,0x8610,0xC610,0x1610,0x5610,0x9610,0xD610,
 0x2610,0x6610,0xA610,0xE610,0x3610,0x7610,0xB610,0xF610,
 0x0A10,0x4A10,0x8A10,0xCA10,0x1A10,0x5A10,0x9A10,0xDA10,
 0x2A10,0x6A10,0xAA10,0xEA10,0x3A10,0x7A10,0xBA10,0xFA10,
 0x0E10,0x4E10,0x8E10,0xCE10,0x1E10,0x5E10,0x9E10,0xDE10,
 0x2E10,0x6E10,0xAE10,0xEE10,0x3E10,0x7E10,0xBE10,0xFE10,
 0x0310,0x4310,0x8310,0xC310,0x1310,0x5310,0x9310,0xD310,
 0x2310,0x6310,0xA310,0xE310,0x3310,0x7310,0xB310,0xF310,
 0x0710,0x4710,0x8710,0xC710,0x1710,0x5710,0x9710,0xD710,
 0x2710,0x6710,0xA710,0xE710,0x3710,0x7710,0xB710,0xF710,
 0x0B10,0x4B10,0x8B10,0xCB10,0x1B10,0x5B10,0x9B10,0xDB10,
 0x2B10,0x6B10,0xAB10,0xEB10,0x3B10,0x7B10,0xBB10,0xFB10,
 0x0F10,0x4F10,0x8F10,0xCF10,0x1F10,0x5F10,0x9F10,0xDF10,
 0x2F10,0x6F10,0xAF10,0xEF10,0x3F10,0x7F10,0xBF10,0xFF10,
 0x0050,0x4050,0x8050,0xC050,0x1050,0x5050,0x9050,0xD050,
 0x2050,0x6050,0xA050,0xE050,0x3050,0x7050,0xB050,0xF050,
 0x0450,0x4450,0x8450,0xC450,0x1450,0x5450,0x9450,0xD450,
 0x2450,0x6450,0xA450,0xE450,0x3450,0x7450,0xB450,0xF450,
 0x0850,0x4850,0x8850,0xC850,0x1850,0x5850,0x9850,0xD850,
 0x2850,0x6850,0xA850,0xE850,0x3850,0x7850,0xB850,0xF850,
 0x0C50,0x4C50,0x8C50,0xCC50,0x1C50,0x5C50,0x9C50,0xDC50,
 0x2C50,0x6C50,0xAC50,0xEC50,0x3C50,0x7C50,0xBC50,0xFC50,
 0x0150,0x4150,0x8150,0xC150,0x1150,0x5150,0x9150,0xD150,
 0x2150,0x6150,0xA150,0xE150,0x3150,0x7150,0xB150,0xF150,
 0x0550,0x4550,0x8550,0xC550,0x1550,0x5550,0x9550,0xD550,
 0x2550,0x6550,0xA550,0xE550,0x3550,0x7550,0xB550,0xF550,
 0x0950,0x4950,0x8950,0xC950,0x1950,0x5950,0x9950,0xD950,
 0x2950,0x6950,0xA950,0xE950,0x3950,0x7950,0xB950,0xF950,
 0x0D50,0x4D50,0x8D50,0xCD50,0x1D50,0x5D50,0x9D50,0xDD50,
 0x2D50,0x6D50,0xAD50,0xED50,0x3D50,0x7D50,0xBD50,0xFD50,
 0x0250,0x4250,0x8250,0xC250,0x1250,0x5250,0x9250,0xD250,
 0x2250,0x6250,0xA250,0xE250,0x3250,0x7250,0xB250,0xF250,
 0x0650,0x4650,0x8650,0xC650,0x1650,0x5650,0x9650,0xD650,
 0x2650,0x6650,0xA650,0xE650,0x3650,0x7650,0xB650,0xF650,
 0x0A50,0x4A50,0x8A50,0xCA50,0x1A50,0x5A50,0x9A50,0xDA50,
 0x2A50,0x6A50,0xAA50,0xEA50,0x3A50,0x7A50,0xBA50,0xFA50,
 0x0E50,0x4E50,0x8E50,0xCE50,0x1E50,0x5E50,0x9E50,0xDE50,
 0x2E50,0x6E50,0xAE50,0xEE50,0x3E50,0x7E50,0xBE50,0xFE50,
 0x0350,0x4350,0x8350,0xC350,0x1350,0x5350,0x9350,0xD350,
 0x2350,0x6350,0xA350,0xE350,0x3350,0x7350,0xB350,0xF350,
 0x0750,0x4750,0x8750,0xC750,0x1750,0x5750,0x9750,0xD750,
 0x2750,0x6750,0xA750,0xE750,0x3750,0x7750,0xB750,0xF750,
 0x0B50,0x4B50,0x8B50,0xCB50,0x1B50,0x5B50,0x9B50,0xDB50,
 0x2B50,0x6B50,0xAB50,0xEB50,0x3B50,0x7B50,0xBB50,0xFB50,
 0x0F50,0x4F50,0x8F50,0xCF50,0x1F50,0x5F50,0x9F50,0xDF50,
 0x2F50,0x6F50,0xAF50,0xEF50,0x3F50,0x7F50,0xBF50,0xFF50,
 0x0090,0x4090,0x8090,0xC090,0x1090,0x5090,0x9090,0xD090,
 0x2090,0x6090,0xA090,0xE090,0x3090,0x7090,0xB090,0xF090,
 0x0490,0x4490,0x8490,0xC490,0x1490,0x5490,0x9490,0xD490,
 0x2490,0x6490,0xA490,0xE490,0x3490,0x7490,0xB490,0xF490,
 0x0890,0x4890,0x8890,0xC890,0x1890,0x5890,0x9890,0xD890,
 0x2890,0x6890,0xA890,0xE890,0x3890,0x7890,0xB890,0xF890,
 0x0C90,0x4C90,0x8C90,0xCC90,0x1C90,0x5C90,0x9C90,0xDC90,
 0x2C90,0x6C90,0xAC90,0xEC90,0x3C90,0x7C90,0xBC90,0xFC90,
 0x0190,0x4190,0x8190,0xC190,0x1190,0x5190,0x9190,0xD190,
 0x2190,0x6190,0xA190,0xE190,0x3190,0x7190,0xB190,0xF190,
 0x0590,0x4590,0x8590,0xC590,0x1590,0x5590,0x9590,0xD590,
 0x2590,0x6590,0xA590,0xE590,0x3590,0x7590,0xB590,0xF590,
 0x0990,0x4990,0x8990,0xC990,0x1990,0x5990,0x9990,0xD990,
 0x2990,0x6990,0xA990,0xE990,0x3990,0x7990,0xB990,0xF990,
 0x0D90,0x4D90,0x8D90,0xCD90,0x1D90,0x5D90,0x9D90,0xDD90,
 0x2D90,0x6D90,0xAD90,0xED90,0x3D90,0x7D90,0xBD90,0xFD90,
 0x0290,0x4290,0x8290,0xC290,0x1290,0x5290,0x9290,0xD290,
 0x2290,0x6290,0xA290,0xE290,0x3290,0x7290,0xB290,0xF290,
 0x0690,0x4690,0x8690,0xC690,0x1690,0x5690,0x9690,0xD690,
 0x2690,0x6690,0xA690,0xE690,0x3690,0x7690,0xB690,0xF690,
 0x0A90,0x4A90,0x8A90,0xCA90,0x1A90,0x5A90,0x9A90,0xDA90,
 0x2A90,0x6A90,0xAA90,0xEA90,0x3A90,0x7A90,0xBA90,0xFA90,
 0x0E90,0x4E90,0x8E90,0xCE90,0x1E90,0x5E90,0x9E90,0xDE90,
 0x2E90,0x6E90,0xAE90,0xEE90,0x3E90,0x7E90,0xBE90,0xFE90,
 0x0390,0x4390,0x8390,0xC390,0x1390,0x5390,0x9390,0xD390,
 0x2390,0x6390,0xA390,0xE390,0x3390,0x7390,0xB390,0xF390,
 0x0790,0x4790,0x8790,0xC790,0x1790,0x5790,0x9790,0xD790,
 0x2790,0x6790,0xA790,0xE790,0x3790,0x7790,0xB790,0xF790,
 0x0B90,0x4B90,0x8B90,0xCB90,0x1B90,0x5B90,0x9B90,0xDB90,
 0x2B90,0x6B90,0xAB90,0xEB90,0x3B90,0x7B90,0xBB90,0xFB90,
 0x0F90,0x4F90,0x8F90,0xCF90,0x1F90,0x5F90,0x9F90,0xDF90,
 0x2F90,0x6F90,0xAF90,0xEF90,0x3F90,0x7F90,0xBF90,0xFF90,
 0x00D0,0x40D0,0x80D0,0xC0D0,0x10D0,0x50D0,0x90D0,0xD0D0,
 0x20D0,0x60D0,0xA0D0,0xE0D0,0x30D0,0x70D0,0xB0D0,0xF0D0,
 0x04D0,0x44D0,0x84D0,0xC4D0,0x14D0,0x54D0,0x94D0,0xD4D0,
 0x24D0,0x64D0,0xA4D0,0xE4D0,0x34D0,0x74D0,0xB4D0,0xF4D0,
 0x08D0,0x48D0,0x88D0,0xC8D0,0x18D0,0x58D0,0x98D0,0xD8D0,
 0x28D0,0x68D0,0xA8D0,0xE8D0,0x38D0,0x78D0,0xB8D0,0xF8D0,
 0x0CD0,0x4CD0,0x8CD0,0xCCD0,0x1CD0,0x5CD0,0x9CD0,0xDCD0,
 0x2CD0,0x6CD0,0xACD0,0xECD0,0x3CD0,0x7CD0,0xBCD0,0xFCD0,
 0x01D0,0x41D0,0x81D0,0xC1D0,0x11D0,0x51D0,0x91D0,0xD1D0,
 0x21D0,0x61D0,0xA1D0,0xE1D0,0x31D0,0x71D0,0xB1D0,0xF1D0,
 0x05D0,0x45D0,0x85D0,0xC5D0,0x15D0,0x55D0,0x95D0,0xD5D0,
 0x25D0,0x65D0,0xA5D0,0xE5D0,0x35D0,0x75D0,0xB5D0,0xF5D0,
 0x09D0,0x49D0,0x89D0,0xC9D0,0x19D0,0x59D0,0x99D0,0xD9D0,
 0x29D0,0x69D0,0xA9D0,0xE9D0,0x39D0,0x79D0,0xB9D0,0xF9D0,
 0x0DD0,0x4DD0,0x8DD0,0xCDD0,0x1DD0,0x5DD0,0x9DD0,0xDDD0,
 0x2DD0,0x6DD0,0xADD0,0xEDD0,0x3DD0,0x7DD0,0xBDD0,0xFDD0,
 0x02D0,0x42D0,0x82D0,0xC2D0,0x12D0,0x52D0,0x92D0,0xD2D0,
 0x22D0,0x62D0,0xA2D0,0xE2D0,0x32D0,0x72D0,0xB2D0,0xF2D0,
 0x06D0,0x46D0,0x86D0,0xC6D0,0x16D0,0x56D0,0x96D0,0xD6D0,
 0x26D0,0x66D0,0xA6D0,0xE6D0,0x36D0,0x76D0,0xB6D0,0xF6D0,
 0x0AD0,0x4AD0,0x8AD0,0xCAD0,0x1AD0,0x5AD0,0x9AD0,0xDAD0,
 0x2AD0,0x6AD0,0xAAD0,0xEAD0,0x3AD0,0x7AD0,0xBAD0,0xFAD0,
 0x0ED0,0x4ED0,0x8ED0,0xCED0,0x1ED0,0x5ED0,0x9ED0,0xDED0,
 0x2ED0,0x6ED0,0xAED0,0xEED0,0x3ED0,0x7ED0,0xBED0,0xFED0,
 0x03D0,0x43D0,0x83D0,0xC3D0,0x13D0,0x53D0,0x93D0,0xD3D0,
 0x23D0,0x63D0,0xA3D0,0xE3D0,0x33D0,0x73D0,0xB3D0,0xF3D0,
 0x07D0,0x47D0,0x87D0,0xC7D0,0x17D0,0x57D0,0x97D0,0xD7D0,
 0x27D0,0x67D0,0xA7D0,0xE7D0,0x37D0,0x77D0,0xB7D0,0xF7D0,
 0x0BD0,0x4BD0,0x8BD0,0xCBD0,0x1BD0,0x5BD0,0x9BD0,0xDBD0,
 0x2BD0,0x6BD0,0xABD0,0xEBD0,0x3BD0,0x7BD0,0xBBD0,0xFBD0,
 0x0FD0,0x4FD0,0x8FD0,0xCFD0,0x1FD0,0x5FD0,0x9FD0,0xDFD0,
 0x2FD0,0x6FD0,0xAFD0,0xEFD0,0x3FD0,0x7FD0,0xBFD0,0xFFD0,
 0x0020,0x4020,0x8020,0xC020,0x1020,0x5020,0x9020,0xD020,
 0x2020,0x6020,0xA020,0xE020,0x3020,0x7020,0xB020,0xF020,
 0x0420,0x4420,0x8420,0xC420,0x1420,0x5420,0x9420,0xD420,
 0x2420,0x6420,0xA420,0xE420,0x3420,0x7420,0xB420,0xF420,
 0x0820,0x4820,0x8820,0xC820,0x1820,0x5820,0x9820,0xD820,
 0x2820,0x6820,0xA820,0xE820,0x3820,0x7820,0xB820,0xF820,
 0x0C20,0x4C20,0x8C20,0xCC20,0x1C20,0x5C20,0x9C20,0xDC20,
 0x2C20,0x6C20,0xAC20,0xEC20,0x3C20,0x7C20,0xBC20,0xFC20,
 0x0120,0x4120,0x8120,0xC120,0x1120,0x5120,0x9120,0xD120,
 0x2120,0x6120,0xA120,0xE120,0x3120,0x7120,0xB120,0xF120,
 0x0520,0x4520,0x8520,0xC520,0x1520,0x5520,0x9520,0xD520,
 0x2520,0x6520,0xA520,0xE520,0x3520,0x7520,0xB520,0xF520,
 0x0920,0x4920,0x8920,0xC920,0x1920,0x5920,0x9920,0xD920,
 0x2920,0x6920,0xA920,0xE920,0x3920,0x7920,0xB920,0xF920,
 0x0D20,0x4D20,0x8D20,0xCD20,0x1D20,0x5D20,0x9D20,0xDD20,
 0x2D20,0x6D20,0xAD20,0xED20,0x3D20,0x7D20,0xBD20,0xFD20,
 0x0220,0x4220,0x8220,0xC220,0x1220,0x5220,0x9220,0xD220,
 0x2220,0x6220,0xA220,0xE220,0x3220,0x7220,0xB220,0xF220,
 0x0620,0x4620,0x8620,0xC620,0x1620,0x5620,0x9620,0xD620,
 0x2620,0x6620,0xA620,0xE620,0x3620,0x7620,0xB620,0xF620,
 0x0A20,0x4A20,0x8A20,0xCA20,0x1A20,0x5A20,0x9A20,0xDA20,
 0x2A20,0x6A20,0xAA20,0xEA20,0x3A20,0x7A20,0xBA20,0xFA20,
 0x0E20,0x4E20,0x8E20,0xCE20,0x1E20,0x5E20,0x9E20,0xDE20,
 0x2E20,0x6E20,0xAE20,0xEE20,0x3E20,0x7E20,0xBE20,0xFE20,
 0x0320,0x4320,0x8320,0xC320,0x1320,0x5320,0x9320,0xD320,
 0x2320,0x6320,0xA320,0xE320,0x3320,0x7320,0xB320,0xF320,
 0x0720,0x4720,0x8720,0xC720,0x1720,0x5720,0x9720,0xD720,
 0x2720,0x6720,0xA720,0xE720,0x3720,0x7720,0xB720,0xF720,
 0x0B20,0x4B20,0x8B20,0xCB20,0x1B20,0x5B20,0x9B20,0xDB20,
 0x2B20,0x6B20,0xAB20,0xEB20,0x3B20,0x7B20,0xBB20,0xFB20,
 0x0F20,0x4F20,0x8F20,0xCF20,0x1F20,0x5F20,0x9F20,0xDF20,
 0x2F20,0x6F20,0xAF20,0xEF20,0x3F20,0x7F20,0xBF20,0xFF20,
 0x0060,0x4060,0x8060,0xC060,0x1060,0x5060,0x9060,0xD060,
 0x2060,0x6060,0xA060,0xE060,0x3060,0x7060,0xB060,0xF060,
 0x0460,0x4460,0x8460,0xC460,0x1460,0x5460,0x9460,0xD460,
 0x2460,0x6460,0xA460,0xE460,0x3460,0x7460,0xB460,0xF460,
 0x0860,0x4860,0x8860,0xC860,0x1860,0x5860,0x9860,0xD860,
 0x2860,0x6860,0xA860,0xE860,0x3860,0x7860,0xB860,0xF860,
 0x0C60,0x4C60,0x8C60,0xCC60,0x1C60,0x5C60,0x9C60,0xDC60,
 0x2C60,0x6C60,0xAC60,0xEC60,0x3C60,0x7C60,0xBC60,0xFC60,
 0x0160,0x4160,0x8160,0xC160,0x1160,0x5160,0x9160,0xD160,
 0x2160,0x6160,0xA160,0xE160,0x3160,0x7160,0xB160,0xF160,
 0x0560,0x4560,0x8560,0xC560,0x1560,0x5560,0x9560,0xD560,
 0x2560,0x6560,0xA560,0xE560,0x3560,0x7560,0xB560,0xF560,
 0x0960,0x4960,0x8960,0xC960,0x1960,0x5960,0x9960,0xD960,
 0x2960,0x6960,0xA960,0xE960,0x3960,0x7960,0xB960,0xF960,
 0x0D60,0x4D60,0x8D60,0xCD60,0x1D60,0x5D60,0x9D60,0xDD60,
 0x2D60,0x6D60,0xAD60,0xED60,0x3D60,0x7D60,0xBD60,0xFD60,
 0x0260,0x4260,0x8260,0xC260,0x1260,0x5260,0x9260,0xD260,
 0x2260,0x6260,0xA260,0xE260,0x3260,0x7260,0xB260,0xF260,
 0x0660,0x4660,0x8660,0xC660,0x1660,0x5660,0x9660,0xD660,
 0x2660,0x6660,0xA660,0xE660,0x3660,0x7660,0xB660,0xF660,
 0x0A60,0x4A60,0x8A60,0xCA60,0x1A60,0x5A60,0x9A60,0xDA60,
 0x2A60,0x6A60,0xAA60,0xEA60,0x3A60,0x7A60,0xBA60,0xFA60,
 0x0E60,0x4E60,0x8E60,0xCE60,0x1E60,0x5E60,0x9E60,0xDE60,
 0x2E60,0x6E60,0xAE60,0xEE60,0x3E60,0x7E60,0xBE60,0xFE60,
 0x0360,0x4360,0x8360,0xC360,0x1360,0x5360,0x9360,0xD360,
 0x2360,0x6360,0xA360,0xE360,0x3360,0x7360,0xB360,0xF360,
 0x0760,0x4760,0x8760,0xC760,0x1760,0x5760,0x9760,0xD760,
 0x2760,0x6760,0xA760,0xE760,0x3760,0x7760,0xB760,0xF760,
 0x0B60,0x4B60,0x8B60,0xCB60,0x1B60,0x5B60,0x9B60,0xDB60,
 0x2B60,0x6B60,0xAB60,0xEB60,0x3B60,0x7B60,0xBB60,0xFB60,
 0x0F60,0x4F60,0x8F60,0xCF60,0x1F60,0x5F60,0x9F60,0xDF60,
 0x2F60,0x6F60,0xAF60,0xEF60,0x3F60,0x7F60,0xBF60,0xFF60,
 0x00A0,0x40A0,0x80A0,0xC0A0,0x10A0,0x50A0,0x90A0,0xD0A0,
 0x20A0,0x60A0,0xA0A0,0xE0A0,0x30A0,0x70A0,0xB0A0,0xF0A0,
 0x04A0,0x44A0,0x84A0,0xC4A0,0x14A0,0x54A0,0x94A0,0xD4A0,
 0x24A0,0x64A0,0xA4A0,0xE4A0,0x34A0,0x74A0,0xB4A0,0xF4A0,
 0x08A0,0x48A0,0x88A0,0xC8A0,0x18A0,0x58A0,0x98A0,0xD8A0,
 0x28A0,0x68A0,0xA8A0,0xE8A0,0x38A0,0x78A0,0xB8A0,0xF8A0,
 0x0CA0,0x4CA0,0x8CA0,0xCCA0,0x1CA0,0x5CA0,0x9CA0,0xDCA0,
 0x2CA0,0x6CA0,0xACA0,0xECA0,0x3CA0,0x7CA0,0xBCA0,0xFCA0,
 0x01A0,0x41A0,0x81A0,0xC1A0,0x11A0,0x51A0,0x91A0,0xD1A0,
 0x21A0,0x61A0,0xA1A0,0xE1A0,0x31A0,0x71A0,0xB1A0,0xF1A0,
 0x05A0,0x45A0,0x85A0,0xC5A0,0x15A0,0x55A0,0x95A0,0xD5A0,
 0x25A0,0x65A0,0xA5A0,0xE5A0,0x35A0,0x75A0,0xB5A0,0xF5A0,
 0x09A0,0x49A0,0x89A0,0xC9A0,0x19A0,0x59A0,0x99A0,0xD9A0,
 0x29A0,0x69A0,0xA9A0,0xE9A0,0x39A0,0x79A0,0xB9A0,0xF9A0,
 0x0DA0,0x4DA0,0x8DA0,0xCDA0,0x1DA0,0x5DA0,0x9DA0,0xDDA0,
 0x2DA0,0x6DA0,0xADA0,0xEDA0,0x3DA0,0x7DA0,0xBDA0,0xFDA0,
 0x02A0,0x42A0,0x82A0,0xC2A0,0x12A0,0x52A0,0x92A0,0xD2A0,
 0x22A0,0x62A0,0xA2A0,0xE2A0,0x32A0,0x72A0,0xB2A0,0xF2A0,
 0x06A0,0x46A0,0x86A0,0xC6A0,0x16A0,0x56A0,0x96A0,0xD6A0,
 0x26A0,0x66A0,0xA6A0,0xE6A0,0x36A0,0x76A0,0xB6A0,0xF6A0,
 0x0AA0,0x4AA0,0x8AA0,0xCAA0,0x1AA0,0x5AA0,0x9AA0,0xDAA0,
 0x2AA0,0x6AA0,0xAAA0,0xEAA0,0x3AA0,0x7AA0,0xBAA0,0xFAA0,
 0x0EA0,0x4EA0,0x8EA0,0xCEA0,0x1EA0,0x5EA0,0x9EA0,0xDEA0,
 0x2EA0,0x6EA0,0xAEA0,0xEEA0,0x3EA0,0x7EA0,0xBEA0,0xFEA0,
 0x03A0,0x43A0,0x83A0,0xC3A0,0x13A0,0x53A0,0x93A0,0xD3A0,
 0x23A0,0x63A0,0xA3A0,0xE3A0,0x33A0,0x73A0,0xB3A0,0xF3A0,
 0x07A0,0x47A0,0x87A0,0xC7A0,0x17A0,0x57A0,0x97A0,0xD7A0,
 0x27A0,0x67A0,0xA7A0,0xE7A0,0x37A0,0x77A0,0xB7A0,0xF7A0,
 0x0BA0,0x4BA0,0x8BA0,0xCBA0,0x1BA0,0x5BA0,0x9BA0,0xDBA0,
 0x2BA0,0x6BA0,0xABA0,0xEBA0,0x3BA0,0x7BA0,0xBBA0,0xFBA0,
 0x0FA0,0x4FA0,0x8FA0,0xCFA0,0x1FA0,0x5FA0,0x9FA0,0xDFA0,
 0x2FA0,0x6FA0,0xAFA0,0xEFA0,0x3FA0,0x7FA0,0xBFA0,0xFFA0,
 0x00E0,0x40E0,0x80E0,0xC0E0,0x10E0,0x50E0,0x90E0,0xD0E0,
 0x20E0,0x60E0,0xA0E0,0xE0E0,0x30E0,0x70E0,0xB0E0,0xF0E0,
 0x04E0,0x44E0,0x84E0,0xC4E0,0x14E0,0x54E0,0x94E0,0xD4E0,
 0x24E0,0x64E0,0xA4E0,0xE4E0,0x34E0,0x74E0,0xB4E0,0xF4E0,
 0x08E0,0x48E0,0x88E0,0xC8E0,0x18E0,0x58E0,0x98E0,0xD8E0,
 0x28E0,0x68E0,0xA8E0,0xE8E0,0x38E0,0x78E0,0xB8E0,0xF8E0,
 0x0CE0,0x4CE0,0x8CE0,0xCCE0,0x1CE0,0x5CE0,0x9CE0,0xDCE0,
 0x2CE0,0x6CE0,0xACE0,0xECE0,0x3CE0,0x7CE0,0xBCE0,0xFCE0,
 0x01E0,0x41E0,0x81E0,0xC1E0,0x11E0,0x51E0,0x91E0,0xD1E0,
 0x21E0,0x61E0,0xA1E0,0xE1E0,0x31E0,0x71E0,0xB1E0,0xF1E0,
 0x05E0,0x45E0,0x85E0,0xC5E0,0x15E0,0x55E0,0x95E0,0xD5E0,
 0x25E0,0x65E0,0xA5E0,0xE5E0,0x35E0,0x75E0,0xB5E0,0xF5E0,
 0x09E0,0x49E0,0x89E0,0xC9E0,0x19E0,0x59E0,0x99E0,0xD9E0,
 0x29E0,0x69E0,0xA9E0,0xE9E0,0x39E0,0x79E0,0xB9E0,0xF9E0,
 0x0DE0,0x4DE0,0x8DE0,0xCDE0,0x1DE0,0x5DE0,0x9DE0,0xDDE0,
 0x2DE0,0x6DE0,0xADE0,0xEDE0,0x3DE0,0x7DE0,0xBDE0,0xFDE0,
 0x02E0,0x42E0,0x82E0,0xC2E0,0x12E0,0x52E0,0x92E0,0xD2E0,
 0x22E0,0x62E0,0xA2E0,0xE2E0,0x32E0,0x72E0,0xB2E0,0xF2E0,
 0x06E0,0x46E0,0x86E0,0xC6E0,0x16E0,0x56E0,0x96E0,0xD6E0,
 0x26E0,0x66E0,0xA6E0,0xE6E0,0x36E0,0x76E0,0xB6E0,0xF6E0,
 0x0AE0,0x4AE0,0x8AE0,0xCAE0,0x1AE0,0x5AE0,0x9AE0,0xDAE0,
 0x2AE0,0x6AE0,0xAAE0,0xEAE0,0x3AE0,0x7AE0,0xBAE0,0xFAE0,
 0x0EE0,0x4EE0,0x8EE0,0xCEE0,0x1EE0,0x5EE0,0x9EE0,0xDEE0,
 0x2EE0,0x6EE0,0xAEE0,0xEEE0,0x3EE0,0x7EE0,0xBEE0,0xFEE0,
 0x03E0,0x43E0,0x83E0,0xC3E0,0x13E0,0x53E0,0x93E0,0xD3E0,
 0x23E0,0x63E0,0xA3E0,0xE3E0,0x33E0,0x73E0,0xB3E0,0xF3E0,
 0x07E0,0x47E0,0x87E0,0xC7E0,0x17E0,0x57E0,0x97E0,0xD7E0,
 0x27E0,0x67E0,0xA7E0,0xE7E0,0x37E0,0x77E0,0xB7E0,0xF7E0,
 0x0BE0,0x4BE0,0x8BE0,0xCBE0,0x1BE0,0x5BE0,0x9BE0,0xDBE0,
 0x2BE0,0x6BE0,0xABE0,0xEBE0,0x3BE0,0x7BE0,0xBBE0,0xFBE0,
 0x0FE0,0x4FE0,0x8FE0,0xCFE0,0x1FE0,0x5FE0,0x9FE0,0xDFE0,
 0x2FE0,0x6FE0,0xAFE0,0xEFE0,0x3FE0,0x7FE0,0xBFE0,0xFFE0,
 0x0030,0x4030,0x8030,0xC030,0x1030,0x5030,0x9030,0xD030,
 0x2030,0x6030,0xA030,0xE030,0x3030,0x7030,0xB030,0xF030,
 0x0430,0x4430,0x8430,0xC430,0x1430,0x5430,0x9430,0xD430,
 0x2430,0x6430,0xA430,0xE430,0x3430,0x7430,0xB430,0xF430,
 0x0830,0x4830,0x8830,0xC830,0x1830,0x5830,0x9830,0xD830,
 0x2830,0x6830,0xA830,0xE830,0x3830,0x7830,0xB830,0xF830,
 0x0C30,0x4C30,0x8C30,0xCC30,0x1C30,0x5C30,0x9C30,0xDC30,
 0x2C30,0x6C30,0xAC30,0xEC30,0x3C30,0x7C30,0xBC30,0xFC30,
 0x0130,0x4130,0x8130,0xC130,0x1130,0x5130,0x9130,0xD130,
 0x2130,0x6130,0xA130,0xE130,0x3130,0x7130,0xB130,0xF130,
 0x0530,0x4530,0x8530,0xC530,0x1530,0x5530,0x9530,0xD530,
 0x2530,0x6530,0xA530,0xE530,0x3530,0x7530,0xB530,0xF530,
 0x0930,0x4930,0x8930,0xC930,0x1930,0x5930,0x9930,0xD930,
 0x2930,0x6930,0xA930,0xE930,0x3930,0x7930,0xB930,0xF930,
 0x0D30,0x4D30,0x8D30,0xCD30,0x1D30,0x5D30,0x9D30,0xDD30,
 0x2D30,0x6D30,0xAD30,0xED30,0x3D30,0x7D30,0xBD30,0xFD30,
 0x0230,0x4230,0x8230,0xC230,0x1230,0x5230,0x9230,0xD230,
 0x2230,0x6230,0xA230,0xE230,0x3230,0x7230,0xB230,0xF230,
 0x0630,0x4630,0x8630,0xC630,0x1630,0x5630,0x9630,0xD630,
 0x2630,0x6630,0xA630,0xE630,0x3630,0x7630,0xB630,0xF630,
 0x0A30,0x4A30,0x8A30,0xCA30,0x1A30,0x5A30,0x9A30,0xDA30,
 0x2A30,0x6A30,0xAA30,0xEA30,0x3A30,0x7A30,0xBA30,0xFA30,
 0x0E30,0x4E30,0x8E30,0xCE30,0x1E30,0x5E30,0x9E30,0xDE30,
 0x2E30,0x6E30,0xAE30,0xEE30,0x3E30,0x7E30,0xBE30,0xFE30,
 0x0330,0x4330,0x8330,0xC330,0x1330,0x5330,0x9330,0xD330,
 0x2330,0x6330,0xA330,0xE330,0x3330,0x7330,0xB330,0xF330,
 0x0730,0x4730,0x8730,0xC730,0x1730,0x5730,0x9730,0xD730,
 0x2730,0x6730,0xA730,0xE730,0x3730,0x7730,0xB730,0xF730,
 0x0B30,0x4B30,0x8B30,0xCB30,0x1B30,0x5B30,0x9B30,0xDB30,
 0x2B30,0x6B30,0xAB30,0xEB30,0x3B30,0x7B30,0xBB30,0xFB30,
 0x0F30,0x4F30,0x8F30,0xCF30,0x1F30,0x5F30,0x9F30,0xDF30,
 0x2F30,0x6F30,0xAF30,0xEF30,0x3F30,0x7F30,0xBF30,0xFF30,
 0x0070,0x4070,0x8070,0xC070,0x1070,0x5070,0x9070,0xD070,
 0x2070,0x6070,0xA070,0xE070,0x3070,0x7070,0xB070,0xF070,
 0x0470,0x4470,0x8470,0xC470,0x1470,0x5470,0x9470,0xD470,
 0x2470,0x6470,0xA470,0xE470,0x3470,0x7470,0xB470,0xF470,
 0x0870,0x4870,0x8870,0xC870,0x1870,0x5870,0x9870,0xD870,
 0x2870,0x6870,0xA870,0xE870,0x3870,0x7870,0xB870,0xF870,
 0x0C70,0x4C70,0x8C70,0xCC70,0x1C70,0x5C70,0x9C70,0xDC70,
 0x2C70,0x6C70,0xAC70,0xEC70,0x3C70,0x7C70,0xBC70,0xFC70,
 0x0170,0x4170,0x8170,0xC170,0x1170,0x5170,0x9170,0xD170,
 0x2170,0x6170,0xA170,0xE170,0x3170,0x7170,0xB170,0xF170,
 0x0570,0x4570,0x8570,0xC570,0x1570,0x5570,0x9570,0xD570,
 0x2570,0x6570,0xA570,0xE570,0x3570,0x7570,0xB570,0xF570,
 0x0970,0x4970,0x8970,0xC970,0x1970,0x5970,0x9970,0xD970,
 0x2970,0x6970,0xA970,0xE970,0x3970,0x7970,0xB970,0xF970,
 0x0D70,0x4D70,0x8D70,0xCD70,0x1D70,0x5D70,0x9D70,0xDD70,
 0x2D70,0x6D70,0xAD70,0xED70,0x3D70,0x7D70,0xBD70,0xFD70,
 0x0270,0x4270,0x8270,0xC270,0x1270,0x5270,0x9270,0xD270,
 0x2270,0x6270,0xA270,0xE270,0x3270,0x7270,0xB270,0xF270,
 0x0670,0x4670,0x8670,0xC670,0x1670,0x5670,0x9670,0xD670,
 0x2670,0x6670,0xA670,0xE670,0x3670,0x7670,0xB670,0xF670,
 0x0A70,0x4A70,0x8A70,0xCA70,0x1A70,0x5A70,0x9A70,0xDA70,
 0x2A70,0x6A70,0xAA70,0xEA70,0x3A70,0x7A70,0xBA70,0xFA70,
 0x0E70,0x4E70,0x8E70,0xCE70,0x1E70,0x5E70,0x9E70,0xDE70,
 0x2E70,0x6E70,0xAE70,0xEE70,0x3E70,0x7E70,0xBE70,0xFE70,
 0x0370,0x4370,0x8370,0xC370,0x1370,0x5370,0x9370,0xD370,
 0x2370,0x6370,0xA370,0xE370,0x3370,0x7370,0xB370,0xF370,
 0x0770,0x4770,0x8770,0xC770,0x1770,0x5770,0x9770,0xD770,
 0x2770,0x6770,0xA770,0xE770,0x3770,0x7770,0xB770,0xF770,
 0x0B70,0x4B70,0x8B70,0xCB70,0x1B70,0x5B70,0x9B70,0xDB70,
 0x2B70,0x6B70,0xAB70,0xEB70,0x3B70,0x7B70,0xBB70,0xFB70,
 0x0F70,0x4F70,0x8F70,0xCF70,0x1F70,0x5F70,0x9F70,0xDF70,
 0x2F70,0x6F70,0xAF70,0xEF70,0x3F70,0x7F70,0xBF70,0xFF70,
 0x00B0,0x40B0,0x80B0,0xC0B0,0x10B0,0x50B0,0x90B0,0xD0B0,
 0x20B0,0x60B0,0xA0B0,0xE0B0,0x30B0,0x70B0,0xB0B0,0xF0B0,
 0x04B0,0x44B0,0x84B0,0xC4B0,0x14B0,0x54B0,0x94B0,0xD4B0,
 0x24B0,0x64B0,0xA4B0,0xE4B0,0x34B0,0x74B0,0xB4B0,0xF4B0,
 0x08B0,0x48B0,0x88B0,0xC8B0,0x18B0,0x58B0,0x98B0,0xD8B0,
 0x28B0,0x68B0,0xA8B0,0xE8B0,0x38B0,0x78B0,0xB8B0,0xF8B0,
 0x0CB0,0x4CB0,0x8CB0,0xCCB0,0x1CB0,0x5CB0,0x9CB0,0xDCB0,
 0x2CB0,0x6CB0,0xACB0,0xECB0,0x3CB0,0x7CB0,0xBCB0,0xFCB0,
 0x01B0,0x41B0,0x81B0,0xC1B0,0x11B0,0x51B0,0x91B0,0xD1B0,
 0x21B0,0x61B0,0xA1B0,0xE1B0,0x31B0,0x71B0,0xB1B0,0xF1B0,
 0x05B0,0x45B0,0x85B0,0xC5B0,0x15B0,0x55B0,0x95B0,0xD5B0,
 0x25B0,0x65B0,0xA5B0,0xE5B0,0x35B0,0x75B0,0xB5B0,0xF5B0,
 0x09B0,0x49B0,0x89B0,0xC9B0,0x19B0,0x59B0,0x99B0,0xD9B0,
 0x29B0,0x69B0,0xA9B0,0xE9B0,0x39B0,0x79B0,0xB9B0,0xF9B0,
 0x0DB0,0x4DB0,0x8DB0,0xCDB0,0x1DB0,0x5DB0,0x9DB0,0xDDB0,
 0x2DB0,0x6DB0,0xADB0,0xEDB0,0x3DB0,0x7DB0,0xBDB0,0xFDB0,
 0x02B0,0x42B0,0x82B0,0xC2B0,0x12B0,0x52B0,0x92B0,0xD2B0,
 0x22B0,0x62B0,0xA2B0,0xE2B0,0x32B0,0x72B0,0xB2B0,0xF2B0,
 0x06B0,0x46B0,0x86B0,0xC6B0,0x16B0,0x56B0,0x96B0,0xD6B0,
 0x26B0,0x66B0,0xA6B0,0xE6B0,0x36B0,0x76B0,0xB6B0,0xF6B0,
 0x0AB0,0x4AB0,0x8AB0,0xCAB0,0x1AB0,0x5AB0,0x9AB0,0xDAB0,
 0x2AB0,0x6AB0,0xAAB0,0xEAB0,0x3AB0,0x7AB0,0xBAB0,0xFAB0,
 0x0EB0,0x4EB0,0x8EB0,0xCEB0,0x1EB0,0x5EB0,0x9EB0,0xDEB0,
 0x2EB0,0x6EB0,0xAEB0,0xEEB0,0x3EB0,0x7EB0,0xBEB0,0xFEB0,
 0x03B0,0x43B0,0x83B0,0xC3B0,0x13B0,0x53B0,0x93B0,0xD3B0,
 0x23B0,0x63B0,0xA3B0,0xE3B0,0x33B0,0x73B0,0xB3B0,0xF3B0,
 0x07B0,0x47B0,0x87B0,0xC7B0,0x17B0,0x57B0,0x97B0,0xD7B0,
 0x27B0,0x67B0,0xA7B0,0xE7B0,0x37B0,0x77B0,0xB7B0,0xF7B0,
 0x0BB0,0x4BB0,0x8BB0,0xCBB0,0x1BB0,0x5BB0,0x9BB0,0xDBB0,
 0x2BB0,0x6BB0,0xABB0,0xEBB0,0x3BB0,0x7BB0,0xBBB0,0xFBB0,
 0x0FB0,0x4FB0,0x8FB0,0xCFB0,0x1FB0,0x5FB0,0x9FB0,0xDFB0,
 0x2FB0,0x6FB0,0xAFB0,0xEFB0,0x3FB0,0x7FB0,0xBFB0,0xFFB0,
 0x00F0,0x40F0,0x80F0,0xC0F0,0x10F0,0x50F0,0x90F0,0xD0F0,
 0x20F0,0x60F0,0xA0F0,0xE0F0,0x30F0,0x70F0,0xB0F0,0xF0F0,
 0x04F0,0x44F0,0x84F0,0xC4F0,0x14F0,0x54F0,0x94F0,0xD4F0,
 0x24F0,0x64F0,0xA4F0,0xE4F0,0x34F0,0x74F0,0xB4F0,0xF4F0,
 0x08F0,0x48F0,0x88F0,0xC8F0,0x18F0,0x58F0,0x98F0,0xD8F0,
 0x28F0,0x68F0,0xA8F0,0xE8F0,0x38F0,0x78F0,0xB8F0,0xF8F0,
 0x0CF0,0x4CF0,0x8CF0,0xCCF0,0x1CF0,0x5CF0,0x9CF0,0xDCF0,
 0x2CF0,0x6CF0,0xACF0,0xECF0,0x3CF0,0x7CF0,0xBCF0,0xFCF0,
 0x01F0,0x41F0,0x81F0,0xC1F0,0x11F0,0x51F0,0x91F0,0xD1F0,
 0x21F0,0x61F0,0xA1F0,0xE1F0,0x31F0,0x71F0,0xB1F0,0xF1F0,
 0x05F0,0x45F0,0x85F0,0xC5F0,0x15F0,0x55F0,0x95F0,0xD5F0,
 0x25F0,0x65F0,0xA5F0,0xE5F0,0x35F0,0x75F0,0xB5F0,0xF5F0,
 0x09F0,0x49F0,0x89F0,0xC9F0,0x19F0,0x59F0,0x99F0,0xD9F0,
 0x29F0,0x69F0,0xA9F0,0xE9F0,0x39F0,0x79F0,0xB9F0,0xF9F0,
 0x0DF0,0x4DF0,0x8DF0,0xCDF0,0x1DF0,0x5DF0,0x9DF0,0xDDF0,
 0x2DF0,0x6DF0,0xADF0,0xEDF0,0x3DF0,0x7DF0,0xBDF0,0xFDF0,
 0x02F0,0x42F0,0x82F0,0xC2F0,0x12F0,0x52F0,0x92F0,0xD2F0,
 0x22F0,0x62F0,0xA2F0,0xE2F0,0x32F0,0x72F0,0xB2F0,0xF2F0,
 0x06F0,0x46F0,0x86F0,0xC6F0,0x16F0,0x56F0,0x96F0,0xD6F0,
 0x26F0,0x66F0,0xA6F0,0xE6F0,0x36F0,0x76F0,0xB6F0,0xF6F0,
 0x0AF0,0x4AF0,0x8AF0,0xCAF0,0x1AF0,0x5AF0,0x9AF0,0xDAF0,
 0x2AF0,0x6AF0,0xAAF0,0xEAF0,0x3AF0,0x7AF0,0xBAF0,0xFAF0,
 0x0EF0,0x4EF0,0x8EF0,0xCEF0,0x1EF0,0x5EF0,0x9EF0,0xDEF0,
 0x2EF0,0x6EF0,0xAEF0,0xEEF0,0x3EF0,0x7EF0,0xBEF0,0xFEF0,
 0x03F0,0x43F0,0x83F0,0xC3F0,0x13F0,0x53F0,0x93F0,0xD3F0,
 0x23F0,0x63F0,0xA3F0,0xE3F0,0x33F0,0x73F0,0xB3F0,0xF3F0,
 0x07F0,0x47F0,0x87F0,0xC7F0,0x17F0,0x57F0,0x97F0,0xD7F0,
 0x27F0,0x67F0,0xA7F0,0xE7F0,0x37F0,0x77F0,0xB7F0,0xF7F0,
 0x0BF0,0x4BF0,0x8BF0,0xCBF0,0x1BF0,0x5BF0,0x9BF0,0xDBF0,
 0x2BF0,0x6BF0,0xABF0,0xEBF0,0x3BF0,0x7BF0,0xBBF0,0xFBF0,
 0x0FF0,0x4FF0,0x8FF0,0xCFF0,0x1FF0,0x5FF0,0x9FF0,0xDFF0,
 0x2FF0,0x6FF0,0xAFF0,0xEFF0,0x3FF0,0x7FF0,0xBFF0,0xFFF0,
 0x0004,0x4004,0x8004,0xC004,0x1004,0x5004,0x9004,0xD004,
 0x2004,0x6004,0xA004,0xE004,0x3004,0x7004,0xB004,0xF004,
 0x0404,0x4404,0x8404,0xC404,0x1404,0x5404,0x9404,0xD404,
 0x2404,0x6404,0xA404,0xE404,0x3404,0x7404,0xB404,0xF404,
 0x0804,0x4804,0x8804,0xC804,0x1804,0x5804,0x9804,0xD804,
 0x2804,0x6804,0xA804,0xE804,0x3804,0x7804,0xB804,0xF804,
 0x0C04,0x4C04,0x8C04,0xCC04,0x1C04,0x5C04,0x9C04,0xDC04,
 0x2C04,0x6C04,0xAC04,0xEC04,0x3C04,0x7C04,0xBC04,0xFC04,
 0x0104,0x4104,0x8104,0xC104,0x1104,0x5104,0x9104,0xD104,
 0x2104,0x6104,0xA104,0xE104,0x3104,0x7104,0xB104,0xF104,
 0x0504,0x4504,0x8504,0xC504,0x1504,0x5504,0x9504,0xD504,
 0x2504,0x6504,0xA504,0xE504,0x3504,0x7504,0xB504,0xF504,
 0x0904,0x4904,0x8904,0xC904,0x1904,0x5904,0x9904,0xD904,
 0x2904,0x6904,0xA904,0xE904,0x3904,0x7904,0xB904,0xF904,
 0x0D04,0x4D04,0x8D04,0xCD04,0x1D04,0x5D04,0x9D04,0xDD04,
 0x2D04,0x6D04,0xAD04,0xED04,0x3D04,0x7D04,0xBD04,0xFD04,
 0x0204,0x4204,0x8204,0xC204,0x1204,0x5204,0x9204,0xD204,
 0x2204,0x6204,0xA204,0xE204,0x3204,0x7204,0xB204,0xF204,
 0x0604,0x4604,0x8604,0xC604,0x1604,0x5604,0x9604,0xD604,
 0x2604,0x6604,0xA604,0xE604,0x3604,0x7604,0xB604,0xF604,
 0x0A04,0x4A04,0x8A04,0xCA04,0x1A04,0x5A04,0x9A04,0xDA04,
 0x2A04,0x6A04,0xAA04,0xEA04,0x3A04,0x7A04,0xBA04,0xFA04,
 0x0E04,0x4E04,0x8E04,0xCE04,0x1E04,0x5E04,0x9E04,0xDE04,
 0x2E04,0x6E04,0xAE04,0xEE04,0x3E04,0x7E04,0xBE04,0xFE04,
 0x0304,0x4304,0x8304,0xC304,0x1304,0x5304,0x9304,0xD304,
 0x2304,0x6304,0xA304,0xE304,0x3304,0x7304,0xB304,0xF304,
 0x0704,0x4704,0x8704,0xC704,0x1704,0x5704,0x9704,0xD704,
 0x2704,0x6704,0xA704,0xE704,0x3704,0x7704,0xB704,0xF704,
 0x0B04,0x4B04,0x8B04,0xCB04,0x1B04,0x5B04,0x9B04,0xDB04,
 0x2B04,0x6B04,0xAB04,0xEB04,0x3B04,0x7B04,0xBB04,0xFB04,
 0x0F04,0x4F04,0x8F04,0xCF04,0x1F04,0x5F04,0x9F04,0xDF04,
 0x2F04,0x6F04,0xAF04,0xEF04,0x3F04,0x7F04,0xBF04,0xFF04,
 0x0044,0x4044,0x8044,0xC044,0x1044,0x5044,0x9044,0xD044,
 0x2044,0x6044,0xA044,0xE044,0x3044,0x7044,0xB044,0xF044,
 0x0444,0x4444,0x8444,0xC444,0x1444,0x5444,0x9444,0xD444,
 0x2444,0x6444,0xA444,0xE444,0x3444,0x7444,0xB444,0xF444,
 0x0844,0x4844,0x8844,0xC844,0x1844,0x5844,0x9844,0xD844,
 0x2844,0x6844,0xA844,0xE844,0x3844,0x7844,0xB844,0xF844,
 0x0C44,0x4C44,0x8C44,0xCC44,0x1C44,0x5C44,0x9C44,0xDC44,
 0x2C44,0x6C44,0xAC44,0xEC44,0x3C44,0x7C44,0xBC44,0xFC44,
 0x0144,0x4144,0x8144,0xC144,0x1144,0x5144,0x9144,0xD144,
 0x2144,0x6144,0xA144,0xE144,0x3144,0x7144,0xB144,0xF144,
 0x0544,0x4544,0x8544,0xC544,0x1544,0x5544,0x9544,0xD544,
 0x2544,0x6544,0xA544,0xE544,0x3544,0x7544,0xB544,0xF544,
 0x0944,0x4944,0x8944,0xC944,0x1944,0x5944,0x9944,0xD944,
 0x2944,0x6944,0xA944,0xE944,0x3944,0x7944,0xB944,0xF944,
 0x0D44,0x4D44,0x8D44,0xCD44,0x1D44,0x5D44,0x9D44,0xDD44,
 0x2D44,0x6D44,0xAD44,0xED44,0x3D44,0x7D44,0xBD44,0xFD44,
 0x0244,0x4244,0x8244,0xC244,0x1244,0x5244,0x9244,0xD244,
 0x2244,0x6244,0xA244,0xE244,0x3244,0x7244,0xB244,0xF244,
 0x0644,0x4644,0x8644,0xC644,0x1644,0x5644,0x9644,0xD644,
 0x2644,0x6644,0xA644,0xE644,0x3644,0x7644,0xB644,0xF644,
 0x0A44,0x4A44,0x8A44,0xCA44,0x1A44,0x5A44,0x9A44,0xDA44,
 0x2A44,0x6A44,0xAA44,0xEA44,0x3A44,0x7A44,0xBA44,0xFA44,
 0x0E44,0x4E44,0x8E44,0xCE44,0x1E44,0x5E44,0x9E44,0xDE44,
 0x2E44,0x6E44,0xAE44,0xEE44,0x3E44,0x7E44,0xBE44,0xFE44,
 0x0344,0x4344,0x8344,0xC344,0x1344,0x5344,0x9344,0xD344,
 0x2344,0x6344,0xA344,0xE344,0x3344,0x7344,0xB344,0xF344,
 0x0744,0x4744,0x8744,0xC744,0x1744,0x5744,0x9744,0xD744,
 0x2744,0x6744,0xA744,0xE744,0x3744,0x7744,0xB744,0xF744,
 0x0B44,0x4B44,0x8B44,0xCB44,0x1B44,0x5B44,0x9B44,0xDB44,
 0x2B44,0x6B44,0xAB44,0xEB44,0x3B44,0x7B44,0xBB44,0xFB44,
 0x0F44,0x4F44,0x8F44,0xCF44,0x1F44,0x5F44,0x9F44,0xDF44,
 0x2F44,0x6F44,0xAF44,0xEF44,0x3F44,0x7F44,0xBF44,0xFF44,
 0x0084,0x4084,0x8084,0xC084,0x1084,0x5084,0x9084,0xD084,
 0x2084,0x6084,0xA084,0xE084,0x3084,0x7084,0xB084,0xF084,
 0x0484,0x4484,0x8484,0xC484,0x1484,0x5484,0x9484,0xD484,
 0x2484,0x6484,0xA484,0xE484,0x3484,0x7484,0xB484,0xF484,
 0x0884,0x4884,0x8884,0xC884,0x1884,0x5884,0x9884,0xD884,
 0x2884,0x6884,0xA884,0xE884,0x3884,0x7884,0xB884,0xF884,
 0x0C84,0x4C84,0x8C84,0xCC84,0x1C84,0x5C84,0x9C84,0xDC84,
 0x2C84,0x6C84,0xAC84,0xEC84,0x3C84,0x7C84,0xBC84,0xFC84,
 0x0184,0x4184,0x8184,0xC184,0x1184,0x5184,0x9184,0xD184,
 0x2184,0x6184,0xA184,0xE184,0x3184,0x7184,0xB184,0xF184,
 0x0584,0x4584,0x8584,0xC584,0x1584,0x5584,0x9584,0xD584,
 0x2584,0x6584,0xA584,0xE584,0x3584,0x7584,0xB584,0xF584,
 0x0984,0x4984,0x8984,0xC984,0x1984,0x5984,0x9984,0xD984,
 0x2984,0x6984,0xA984,0xE984,0x3984,0x7984,0xB984,0xF984,
 0x0D84,0x4D84,0x8D84,0xCD84,0x1D84,0x5D84,0x9D84,0xDD84,
 0x2D84,0x6D84,0xAD84,0xED84,0x3D84,0x7D84,0xBD84,0xFD84,
 0x0284,0x4284,0x8284,0xC284,0x1284,0x5284,0x9284,0xD284,
 0x2284,0x6284,0xA284,0xE284,0x3284,0x7284,0xB284,0xF284,
 0x0684,0x4684,0x8684,0xC684,0x1684,0x5684,0x9684,0xD684,
 0x2684,0x6684,0xA684,0xE684,0x3684,0x7684,0xB684,0xF684,
 0x0A84,0x4A84,0x8A84,0xCA84,0x1A84,0x5A84,0x9A84,0xDA84,
 0x2A84,0x6A84,0xAA84,0xEA84,0x3A84,0x7A84,0xBA84,0xFA84,
 0x0E84,0x4E84,0x8E84,0xCE84,0x1E84,0x5E84,0x9E84,0xDE84,
 0x2E84,0x6E84,0xAE84,0xEE84,0x3E84,0x7E84,0xBE84,0xFE84,
 0x0384,0x4384,0x8384,0xC384,0x1384,0x5384,0x9384,0xD384,
 0x2384,0x6384,0xA384,0xE384,0x3384,0x7384,0xB384,0xF384,
 0x0784,0x4784,0x8784,0xC784,0x1784,0x5784,0x9784,0xD784,
 0x2784,0x6784,0xA784,0xE784,0x3784,0x7784,0xB784,0xF784,
 0x0B84,0x4B84,0x8B84,0xCB84,0x1B84,0x5B84,0x9B84,0xDB84,
 0x2B84,0x6B84,0xAB84,0xEB84,0x3B84,0x7B84,0xBB84,0xFB84,
 0x0F84,0x4F84,0x8F84,0xCF84,0x1F84,0x5F84,0x9F84,0xDF84,
 0x2F84,0x6F84,0xAF84,0xEF84,0x3F84,0x7F84,0xBF84,0xFF84,
 0x00C4,0x40C4,0x80C4,0xC0C4,0x10C4,0x50C4,0x90C4,0xD0C4,
 0x20C4,0x60C4,0xA0C4,0xE0C4,0x30C4,0x70C4,0xB0C4,0xF0C4,
 0x04C4,0x44C4,0x84C4,0xC4C4,0x14C4,0x54C4,0x94C4,0xD4C4,
 0x24C4,0x64C4,0xA4C4,0xE4C4,0x34C4,0x74C4,0xB4C4,0xF4C4,
 0x08C4,0x48C4,0x88C4,0xC8C4,0x18C4,0x58C4,0x98C4,0xD8C4,
 0x28C4,0x68C4,0xA8C4,0xE8C4,0x38C4,0x78C4,0xB8C4,0xF8C4,
 0x0CC4,0x4CC4,0x8CC4,0xCCC4,0x1CC4,0x5CC4,0x9CC4,0xDCC4,
 0x2CC4,0x6CC4,0xACC4,0xECC4,0x3CC4,0x7CC4,0xBCC4,0xFCC4,
 0x01C4,0x41C4,0x81C4,0xC1C4,0x11C4,0x51C4,0x91C4,0xD1C4,
 0x21C4,0x61C4,0xA1C4,0xE1C4,0x31C4,0x71C4,0xB1C4,0xF1C4,
 0x05C4,0x45C4,0x85C4,0xC5C4,0x15C4,0x55C4,0x95C4,0xD5C4,
 0x25C4,0x65C4,0xA5C4,0xE5C4,0x35C4,0x75C4,0xB5C4,0xF5C4,
 0x09C4,0x49C4,0x89C4,0xC9C4,0x19C4,0x59C4,0x99C4,0xD9C4,
 0x29C4,0x69C4,0xA9C4,0xE9C4,0x39C4,0x79C4,0xB9C4,0xF9C4,
 0x0DC4,0x4DC4,0x8DC4,0xCDC4,0x1DC4,0x5DC4,0x9DC4,0xDDC4,
 0x2DC4,0x6DC4,0xADC4,0xEDC4,0x3DC4,0x7DC4,0xBDC4,0xFDC4,
 0x02C4,0x42C4,0x82C4,0xC2C4,0x12C4,0x52C4,0x92C4,0xD2C4,
 0x22C4,0x62C4,0xA2C4,0xE2C4,0x32C4,0x72C4,0xB2C4,0xF2C4,
 0x06C4,0x46C4,0x86C4,0xC6C4,0x16C4,0x56C4,0x96C4,0xD6C4,
 0x26C4,0x66C4,0xA6C4,0xE6C4,0x36C4,0x76C4,0xB6C4,0xF6C4,
 0x0AC4,0x4AC4,0x8AC4,0xCAC4,0x1AC4,0x5AC4,0x9AC4,0xDAC4,
 0x2AC4,0x6AC4,0xAAC4,0xEAC4,0x3AC4,0x7AC4,0xBAC4,0xFAC4,
 0x0EC4,0x4EC4,0x8EC4,0xCEC4,0x1EC4,0x5EC4,0x9EC4,0xDEC4,
 0x2EC4,0x6EC4,0xAEC4,0xEEC4,0x3EC4,0x7EC4,0xBEC4,0xFEC4,
 0x03C4,0x43C4,0x83C4,0xC3C4,0x13C4,0x53C4,0x93C4,0xD3C4,
 0x23C4,0x63C4,0xA3C4,0xE3C4,0x33C4,0x73C4,0xB3C4,0xF3C4,
 0x07C4,0x47C4,0x87C4,0xC7C4,0x17C4,0x57C4,0x97C4,0xD7C4,
 0x27C4,0x67C4,0xA7C4,0xE7C4,0x37C4,0x77C4,0xB7C4,0xF7C4,
 0x0BC4,0x4BC4,0x8BC4,0xCBC4,0x1BC4,0x5BC4,0x9BC4,0xDBC4,
 0x2BC4,0x6BC4,0xABC4,0xEBC4,0x3BC4,0x7BC4,0xBBC4,0xFBC4,
 0x0FC4,0x4FC4,0x8FC4,0xCFC4,0x1FC4,0x5FC4,0x9FC4,0xDFC4,
 0x2FC4,0x6FC4,0xAFC4,0xEFC4,0x3FC4,0x7FC4,0xBFC4,0xFFC4,
 0x0014,0x4014,0x8014,0xC014,0x1014,0x5014,0x9014,0xD014,
 0x2014,0x6014,0xA014,0xE014,0x3014,0x7014,0xB014,0xF014,
 0x0414,0x4414,0x8414,0xC414,0x1414,0x5414,0x9414,0xD414,
 0x2414,0x6414,0xA414,0xE414,0x3414,0x7414,0xB414,0xF414,
 0x0814,0x4814,0x8814,0xC814,0x1814,0x5814,0x9814,0xD814,
 0x2814,0x6814,0xA814,0xE814,0x3814,0x7814,0xB814,0xF814,
 0x0C14,0x4C14,0x8C14,0xCC14,0x1C14,0x5C14,0x9C14,0xDC14,
 0x2C14,0x6C14,0xAC14,0xEC14,0x3C14,0x7C14,0xBC14,0xFC14,
 0x0114,0x4114,0x8114,0xC114,0x1114,0x5114,0x9114,0xD114,
 0x2114,0x6114,0xA114,0xE114,0x3114,0x7114,0xB114,0xF114,
 0x0514,0x4514,0x8514,0xC514,0x1514,0x5514,0x9514,0xD514,
 0x2514,0x6514,0xA514,0xE514,0x3514,0x7514,0xB514,0xF514,
 0x0914,0x4914,0x8914,0xC914,0x1914,0x5914,0x9914,0xD914,
 0x2914,0x6914,0xA914,0xE914,0x3914,0x7914,0xB914,0xF914,
 0x0D14,0x4D14,0x8D14,0xCD14,0x1D14,0x5D14,0x9D14,0xDD14,
 0x2D14,0x6D14,0xAD14,0xED14,0x3D14,0x7D14,0xBD14,0xFD14,
 0x0214,0x4214,0x8214,0xC214,0x1214,0x5214,0x9214,0xD214,
 0x2214,0x6214,0xA214,0xE214,0x3214,0x7214,0xB214,0xF214,
 0x0614,0x4614,0x8614,0xC614,0x1614,0x5614,0x9614,0xD614,
 0x2614,0x6614,0xA614,0xE614,0x3614,0x7614,0xB614,0xF614,
 0x0A14,0x4A14,0x8A14,0xCA14,0x1A14,0x5A14,0x9A14,0xDA14,
 0x2A14,0x6A14,0xAA14,0xEA14,0x3A14,0x7A14,0xBA14,0xFA14,
 0x0E14,0x4E14,0x8E14,0xCE14,0x1E14,0x5E14,0x9E14,0xDE14,
 0x2E14,0x6E14,0xAE14,0xEE14,0x3E14,0x7E14,0xBE14,0xFE14,
 0x0314,0x4314,0x8314,0xC314,0x1314,0x5314,0x9314,0xD314,
 0x2314,0x6314,0xA314,0xE314,0x3314,0x7314,0xB314,0xF314,
 0x0714,0x4714,0x8714,0xC714,0x1714,0x5714,0x9714,0xD714,
 0x2714,0x6714,0xA714,0xE714,0x3714,0x7714,0xB714,0xF714,
 0x0B14,0x4B14,0x8B14,0xCB14,0x1B14,0x5B14,0x9B14,0xDB14,
 0x2B14,0x6B14,0xAB14,0xEB14,0x3B14,0x7B14,0xBB14,0xFB14,
 0x0F14,0x4F14,0x8F14,0xCF14,0x1F14,0x5F14,0x9F14,0xDF14,
 0x2F14,0x6F14,0xAF14,0xEF14,0x3F14,0x7F14,0xBF14,0xFF14,
 0x0054,0x4054,0x8054,0xC054,0x1054,0x5054,0x9054,0xD054,
 0x2054,0x6054,0xA054,0xE054,0x3054,0x7054,0xB054,0xF054,
 0x0454,0x4454,0x8454,0xC454,0x1454,0x5454,0x9454,0xD454,
 0x2454,0x6454,0xA454,0xE454,0x3454,0x7454,0xB454,0xF454,
 0x0854,0x4854,0x8854,0xC854,0x1854,0x5854,0x9854,0xD854,
 0x2854,0x6854,0xA854,0xE854,0x3854,0x7854,0xB854,0xF854,
 0x0C54,0x4C54,0x8C54,0xCC54,0x1C54,0x5C54,0x9C54,0xDC54,
 0x2C54,0x6C54,0xAC54,0xEC54,0x3C54,0x7C54,0xBC54,0xFC54,
 0x0154,0x4154,0x8154,0xC154,0x1154,0x5154,0x9154,0xD154,
 0x2154,0x6154,0xA154,0xE154,0x3154,0x7154,0xB154,0xF154,
 0x0554,0x4554,0x8554,0xC554,0x1554,0x5554,0x9554,0xD554,
 0x2554,0x6554,0xA554,0xE554,0x3554,0x7554,0xB554,0xF554,
 0x0954,0x4954,0x8954,0xC954,0x1954,0x5954,0x9954,0xD954,
 0x2954,0x6954,0xA954,0xE954,0x3954,0x7954,0xB954,0xF954,
 0x0D54,0x4D54,0x8D54,0xCD54,0x1D54,0x5D54,0x9D54,0xDD54,
 0x2D54,0x6D54,0xAD54,0xED54,0x3D54,0x7D54,0xBD54,0xFD54,
 0x0254,0x4254,0x8254,0xC254,0x1254,0x5254,0x9254,0xD254,
 0x2254,0x6254,0xA254,0xE254,0x3254,0x7254,0xB254,0xF254,
 0x0654,0x4654,0x8654,0xC654,0x1654,0x5654,0x9654,0xD654,
 0x2654,0x6654,0xA654,0xE654,0x3654,0x7654,0xB654,0xF654,
 0x0A54,0x4A54,0x8A54,0xCA54,0x1A54,0x5A54,0x9A54,0xDA54,
 0x2A54,0x6A54,0xAA54,0xEA54,0x3A54,0x7A54,0xBA54,0xFA54,
 0x0E54,0x4E54,0x8E54,0xCE54,0x1E54,0x5E54,0x9E54,0xDE54,
 0x2E54,0x6E54,0xAE54,0xEE54,0x3E54,0x7E54,0xBE54,0xFE54,
 0x0354,0x4354,0x8354,0xC354,0x1354,0x5354,0x9354,0xD354,
 0x2354,0x6354,0xA354,0xE354,0x3354,0x7354,0xB354,0xF354,
 0x0754,0x4754,0x8754,0xC754,0x1754,0x5754,0x9754,0xD754,
 0x2754,0x6754,0xA754,0xE754,0x3754,0x7754,0xB754,0xF754,
 0x0B54,0x4B54,0x8B54,0xCB54,0x1B54,0x5B54,0x9B54,0xDB54,
 0x2B54,0x6B54,0xAB54,0xEB54,0x3B54,0x7B54,0xBB54,0xFB54,
 0x0F54,0x4F54,0x8F54,0xCF54,0x1F54,0x5F54,0x9F54,0xDF54,
 0x2F54,0x6F54,0xAF54,0xEF54,0x3F54,0x7F54,0xBF54,0xFF54,
 0x0094,0x4094,0x8094,0xC094,0x1094,0x5094,0x9094,0xD094,
 0x2094,0x6094,0xA094,0xE094,0x3094,0x7094,0xB094,0xF094,
 0x0494,0x4494,0x8494,0xC494,0x1494,0x5494,0x9494,0xD494,
 0x2494,0x6494,0xA494,0xE494,0x3494,0x7494,0xB494,0xF494,
 0x0894,0x4894,0x8894,0xC894,0x1894,0x5894,0x9894,0xD894,
 0x2894,0x6894,0xA894,0xE894,0x3894,0x7894,0xB894,0xF894,
 0x0C94,0x4C94,0x8C94,0xCC94,0x1C94,0x5C94,0x9C94,0xDC94,
 0x2C94,0x6C94,0xAC94,0xEC94,0x3C94,0x7C94,0xBC94,0xFC94,
 0x0194,0x4194,0x8194,0xC194,0x1194,0x5194,0x9194,0xD194,
 0x2194,0x6194,0xA194,0xE194,0x3194,0x7194,0xB194,0xF194,
 0x0594,0x4594,0x8594,0xC594,0x1594,0x5594,0x9594,0xD594,
 0x2594,0x6594,0xA594,0xE594,0x3594,0x7594,0xB594,0xF594,
 0x0994,0x4994,0x8994,0xC994,0x1994,0x5994,0x9994,0xD994,
 0x2994,0x6994,0xA994,0xE994,0x3994,0x7994,0xB994,0xF994,
 0x0D94,0x4D94,0x8D94,0xCD94,0x1D94,0x5D94,0x9D94,0xDD94,
 0x2D94,0x6D94,0xAD94,0xED94,0x3D94,0x7D94,0xBD94,0xFD94,
 0x0294,0x4294,0x8294,0xC294,0x1294,0x5294,0x9294,0xD294,
 0x2294,0x6294,0xA294,0xE294,0x3294,0x7294,0xB294,0xF294,
 0x0694,0x4694,0x8694,0xC694,0x1694,0x5694,0x9694,0xD694,
 0x2694,0x6694,0xA694,0xE694,0x3694,0x7694,0xB694,0xF694,
 0x0A94,0x4A94,0x8A94,0xCA94,0x1A94,0x5A94,0x9A94,0xDA94,
 0x2A94,0x6A94,0xAA94,0xEA94,0x3A94,0x7A94,0xBA94,0xFA94,
 0x0E94,0x4E94,0x8E94,0xCE94,0x1E94,0x5E94,0x9E94,0xDE94,
 0x2E94,0x6E94,0xAE94,0xEE94,0x3E94,0x7E94,0xBE94,0xFE94,
 0x0394,0x4394,0x8394,0xC394,0x1394,0x5394,0x9394,0xD394,
 0x2394,0x6394,0xA394,0xE394,0x3394,0x7394,0xB394,0xF394,
 0x0794,0x4794,0x8794,0xC794,0x1794,0x5794,0x9794,0xD794,
 0x2794,0x6794,0xA794,0xE794,0x3794,0x7794,0xB794,0xF794,
 0x0B94,0x4B94,0x8B94,0xCB94,0x1B94,0x5B94,0x9B94,0xDB94,
 0x2B94,0x6B94,0xAB94,0xEB94,0x3B94,0x7B94,0xBB94,0xFB94,
 0x0F94,0x4F94,0x8F94,0xCF94,0x1F94,0x5F94,0x9F94,0xDF94,
 0x2F94,0x6F94,0xAF94,0xEF94,0x3F94,0x7F94,0xBF94,0xFF94,
 0x00D4,0x40D4,0x80D4,0xC0D4,0x10D4,0x50D4,0x90D4,0xD0D4,
 0x20D4,0x60D4,0xA0D4,0xE0D4,0x30D4,0x70D4,0xB0D4,0xF0D4,
 0x04D4,0x44D4,0x84D4,0xC4D4,0x14D4,0x54D4,0x94D4,0xD4D4,
 0x24D4,0x64D4,0xA4D4,0xE4D4,0x34D4,0x74D4,0xB4D4,0xF4D4,
 0x08D4,0x48D4,0x88D4,0xC8D4,0x18D4,0x58D4,0x98D4,0xD8D4,
 0x28D4,0x68D4,0xA8D4,0xE8D4,0x38D4,0x78D4,0xB8D4,0xF8D4,
 0x0CD4,0x4CD4,0x8CD4,0xCCD4,0x1CD4,0x5CD4,0x9CD4,0xDCD4,
 0x2CD4,0x6CD4,0xACD4,0xECD4,0x3CD4,0x7CD4,0xBCD4,0xFCD4,
 0x01D4,0x41D4,0x81D4,0xC1D4,0x11D4,0x51D4,0x91D4,0xD1D4,
 0x21D4,0x61D4,0xA1D4,0xE1D4,0x31D4,0x71D4,0xB1D4,0xF1D4,
 0x05D4,0x45D4,0x85D4,0xC5D4,0x15D4,0x55D4,0x95D4,0xD5D4,
 0x25D4,0x65D4,0xA5D4,0xE5D4,0x35D4,0x75D4,0xB5D4,0xF5D4,
 0x09D4,0x49D4,0x89D4,0xC9D4,0x19D4,0x59D4,0x99D4,0xD9D4,
 0x29D4,0x69D4,0xA9D4,0xE9D4,0x39D4,0x79D4,0xB9D4,0xF9D4,
 0x0DD4,0x4DD4,0x8DD4,0xCDD4,0x1DD4,0x5DD4,0x9DD4,0xDDD4,
 0x2DD4,0x6DD4,0xADD4,0xEDD4,0x3DD4,0x7DD4,0xBDD4,0xFDD4,
 0x02D4,0x42D4,0x82D4,0xC2D4,0x12D4,0x52D4,0x92D4,0xD2D4,
 0x22D4,0x62D4,0xA2D4,0xE2D4,0x32D4,0x72D4,0xB2D4,0xF2D4,
 0x06D4,0x46D4,0x86D4,0xC6D4,0x16D4,0x56D4,0x96D4,0xD6D4,
 0x26D4,0x66D4,0xA6D4,0xE6D4,0x36D4,0x76D4,0xB6D4,0xF6D4,
 0x0AD4,0x4AD4,0x8AD4,0xCAD4,0x1AD4,0x5AD4,0x9AD4,0xDAD4,
 0x2AD4,0x6AD4,0xAAD4,0xEAD4,0x3AD4,0x7AD4,0xBAD4,0xFAD4,
 0x0ED4,0x4ED4,0x8ED4,0xCED4,0x1ED4,0x5ED4,0x9ED4,0xDED4,
 0x2ED4,0x6ED4,0xAED4,0xEED4,0x3ED4,0x7ED4,0xBED4,0xFED4,
 0x03D4,0x43D4,0x83D4,0xC3D4,0x13D4,0x53D4,0x93D4,0xD3D4,
 0x23D4,0x63D4,0xA3D4,0xE3D4,0x33D4,0x73D4,0xB3D4,0xF3D4,
 0x07D4,0x47D4,0x87D4,0xC7D4,0x17D4,0x57D4,0x97D4,0xD7D4,
 0x27D4,0x67D4,0xA7D4,0xE7D4,0x37D4,0x77D4,0xB7D4,0xF7D4,
 0x0BD4,0x4BD4,0x8BD4,0xCBD4,0x1BD4,0x5BD4,0x9BD4,0xDBD4,
 0x2BD4,0x6BD4,0xABD4,0xEBD4,0x3BD4,0x7BD4,0xBBD4,0xFBD4,
 0x0FD4,0x4FD4,0x8FD4,0xCFD4,0x1FD4,0x5FD4,0x9FD4,0xDFD4,
 0x2FD4,0x6FD4,0xAFD4,0xEFD4,0x3FD4,0x7FD4,0xBFD4,0xFFD4,
 0x0024,0x4024,0x8024,0xC024,0x1024,0x5024,0x9024,0xD024,
 0x2024,0x6024,0xA024,0xE024,0x3024,0x7024,0xB024,0xF024,
 0x0424,0x4424,0x8424,0xC424,0x1424,0x5424,0x9424,0xD424,
 0x2424,0x6424,0xA424,0xE424,0x3424,0x7424,0xB424,0xF424,
 0x0824,0x4824,0x8824,0xC824,0x1824,0x5824,0x9824,0xD824,
 0x2824,0x6824,0xA824,0xE824,0x3824,0x7824,0xB824,0xF824,
 0x0C24,0x4C24,0x8C24,0xCC24,0x1C24,0x5C24,0x9C24,0xDC24,
 0x2C24,0x6C24,0xAC24,0xEC24,0x3C24,0x7C24,0xBC24,0xFC24,
 0x0124,0x4124,0x8124,0xC124,0x1124,0x5124,0x9124,0xD124,
 0x2124,0x6124,0xA124,0xE124,0x3124,0x7124,0xB124,0xF124,
 0x0524,0x4524,0x8524,0xC524,0x1524,0x5524,0x9524,0xD524,
 0x2524,0x6524,0xA524,0xE524,0x3524,0x7524,0xB524,0xF524,
 0x0924,0x4924,0x8924,0xC924,0x1924,0x5924,0x9924,0xD924,
 0x2924,0x6924,0xA924,0xE924,0x3924,0x7924,0xB924,0xF924,
 0x0D24,0x4D24,0x8D24,0xCD24,0x1D24,0x5D24,0x9D24,0xDD24,
 0x2D24,0x6D24,0xAD24,0xED24,0x3D24,0x7D24,0xBD24,0xFD24,
 0x0224,0x4224,0x8224,0xC224,0x1224,0x5224,0x9224,0xD224,
 0x2224,0x6224,0xA224,0xE224,0x3224,0x7224,0xB224,0xF224,
 0x0624,0x4624,0x8624,0xC624,0x1624,0x5624,0x9624,0xD624,
 0x2624,0x6624,0xA624,0xE624,0x3624,0x7624,0xB624,0xF624,
 0x0A24,0x4A24,0x8A24,0xCA24,0x1A24,0x5A24,0x9A24,0xDA24,
 0x2A24,0x6A24,0xAA24,0xEA24,0x3A24,0x7A24,0xBA24,0xFA24,
 0x0E24,0x4E24,0x8E24,0xCE24,0x1E24,0x5E24,0x9E24,0xDE24,
 0x2E24,0x6E24,0xAE24,0xEE24,0x3E24,0x7E24,0xBE24,0xFE24,
 0x0324,0x4324,0x8324,0xC324,0x1324,0x5324,0x9324,0xD324,
 0x2324,0x6324,0xA324,0xE324,0x3324,0x7324,0xB324,0xF324,
 0x0724,0x4724,0x8724,0xC724,0x1724,0x5724,0x9724,0xD724,
 0x2724,0x6724,0xA724,0xE724,0x3724,0x7724,0xB724,0xF724,
 0x0B24,0x4B24,0x8B24,0xCB24,0x1B24,0x5B24,0x9B24,0xDB24,
 0x2B24,0x6B24,0xAB24,0xEB24,0x3B24,0x7B24,0xBB24,0xFB24,
 0x0F24,0x4F24,0x8F24,0xCF24,0x1F24,0x5F24,0x9F24,0xDF24,
 0x2F24,0x6F24,0xAF24,0xEF24,0x3F24,0x7F24,0xBF24,0xFF24,
 0x0064,0x4064,0x8064,0xC064,0x1064,0x5064,0x9064,0xD064,
 0x2064,0x6064,0xA064,0xE064,0x3064,0x7064,0xB064,0xF064,
 0x0464,0x4464,0x8464,0xC464,0x1464,0x5464,0x9464,0xD464,
 0x2464,0x6464,0xA464,0xE464,0x3464,0x7464,0xB464,0xF464,
 0x0864,0x4864,0x8864,0xC864,0x1864,0x5864,0x9864,0xD864,
 0x2864,0x6864,0xA864,0xE864,0x3864,0x7864,0xB864,0xF864,
 0x0C64,0x4C64,0x8C64,0xCC64,0x1C64,0x5C64,0x9C64,0xDC64,
 0x2C64,0x6C64,0xAC64,0xEC64,0x3C64,0x7C64,0xBC64,0xFC64,
 0x0164,0x4164,0x8164,0xC164,0x1164,0x5164,0x9164,0xD164,
 0x2164,0x6164,0xA164,0xE164,0x3164,0x7164,0xB164,0xF164,
 0x0564,0x4564,0x8564,0xC564,0x1564,0x5564,0x9564,0xD564,
 0x2564,0x6564,0xA564,0xE564,0x3564,0x7564,0xB564,0xF564,
 0x0964,0x4964,0x8964,0xC964,0x1964,0x5964,0x9964,0xD964,
 0x2964,0x6964,0xA964,0xE964,0x3964,0x7964,0xB964,0xF964,
 0x0D64,0x4D64,0x8D64,0xCD64,0x1D64,0x5D64,0x9D64,0xDD64,
 0x2D64,0x6D64,0xAD64,0xED64,0x3D64,0x7D64,0xBD64,0xFD64,
 0x0264,0x4264,0x8264,0xC264,0x1264,0x5264,0x9264,0xD264,
 0x2264,0x6264,0xA264,0xE264,0x3264,0x7264,0xB264,0xF264,
 0x0664,0x4664,0x8664,0xC664,0x1664,0x5664,0x9664,0xD664,
 0x2664,0x6664,0xA664,0xE664,0x3664,0x7664,0xB664,0xF664,
 0x0A64,0x4A64,0x8A64,0xCA64,0x1A64,0x5A64,0x9A64,0xDA64,
 0x2A64,0x6A64,0xAA64,0xEA64,0x3A64,0x7A64,0xBA64,0xFA64,
 0x0E64,0x4E64,0x8E64,0xCE64,0x1E64,0x5E64,0x9E64,0xDE64,
 0x2E64,0x6E64,0xAE64,0xEE64,0x3E64,0x7E64,0xBE64,0xFE64,
 0x0364,0x4364,0x8364,0xC364,0x1364,0x5364,0x9364,0xD364,
 0x2364,0x6364,0xA364,0xE364,0x3364,0x7364,0xB364,0xF364,
 0x0764,0x4764,0x8764,0xC764,0x1764,0x5764,0x9764,0xD764,
 0x2764,0x6764,0xA764,0xE764,0x3764,0x7764,0xB764,0xF764,
 0x0B64,0x4B64,0x8B64,0xCB64,0x1B64,0x5B64,0x9B64,0xDB64,
 0x2B64,0x6B64,0xAB64,0xEB64,0x3B64,0x7B64,0xBB64,0xFB64,
 0x0F64,0x4F64,0x8F64,0xCF64,0x1F64,0x5F64,0x9F64,0xDF64,
 0x2F64,0x6F64,0xAF64,0xEF64,0x3F64,0x7F64,0xBF64,0xFF64,
 0x00A4,0x40A4,0x80A4,0xC0A4,0x10A4,0x50A4,0x90A4,0xD0A4,
 0x20A4,0x60A4,0xA0A4,0xE0A4,0x30A4,0x70A4,0xB0A4,0xF0A4,
 0x04A4,0x44A4,0x84A4,0xC4A4,0x14A4,0x54A4,0x94A4,0xD4A4,
 0x24A4,0x64A4,0xA4A4,0xE4A4,0x34A4,0x74A4,0xB4A4,0xF4A4,
 0x08A4,0x48A4,0x88A4,0xC8A4,0x18A4,0x58A4,0x98A4,0xD8A4,
 0x28A4,0x68A4,0xA8A4,0xE8A4,0x38A4,0x78A4,0xB8A4,0xF8A4,
 0x0CA4,0x4CA4,0x8CA4,0xCCA4,0x1CA4,0x5CA4,0x9CA4,0xDCA4,
 0x2CA4,0x6CA4,0xACA4,0xECA4,0x3CA4,0x7CA4,0xBCA4,0xFCA4,
 0x01A4,0x41A4,0x81A4,0xC1A4,0x11A4,0x51A4,0x91A4,0xD1A4,
 0x21A4,0x61A4,0xA1A4,0xE1A4,0x31A4,0x71A4,0xB1A4,0xF1A4,
 0x05A4,0x45A4,0x85A4,0xC5A4,0x15A4,0x55A4,0x95A4,0xD5A4,
 0x25A4,0x65A4,0xA5A4,0xE5A4,0x35A4,0x75A4,0xB5A4,0xF5A4,
 0x09A4,0x49A4,0x89A4,0xC9A4,0x19A4,0x59A4,0x99A4,0xD9A4,
 0x29A4,0x69A4,0xA9A4,0xE9A4,0x39A4,0x79A4,0xB9A4,0xF9A4,
 0x0DA4,0x4DA4,0x8DA4,0xCDA4,0x1DA4,0x5DA4,0x9DA4,0xDDA4,
 0x2DA4,0x6DA4,0xADA4,0xEDA4,0x3DA4,0x7DA4,0xBDA4,0xFDA4,
 0x02A4,0x42A4,0x82A4,0xC2A4,0x12A4,0x52A4,0x92A4,0xD2A4,
 0x22A4,0x62A4,0xA2A4,0xE2A4,0x32A4,0x72A4,0xB2A4,0xF2A4,
 0x06A4,0x46A4,0x86A4,0xC6A4,0x16A4,0x56A4,0x96A4,0xD6A4,
 0x26A4,0x66A4,0xA6A4,0xE6A4,0x36A4,0x76A4,0xB6A4,0xF6A4,
 0x0AA4,0x4AA4,0x8AA4,0xCAA4,0x1AA4,0x5AA4,0x9AA4,0xDAA4,
 0x2AA4,0x6AA4,0xAAA4,0xEAA4,0x3AA4,0x7AA4,0xBAA4,0xFAA4,
 0x0EA4,0x4EA4,0x8EA4,0xCEA4,0x1EA4,0x5EA4,0x9EA4,0xDEA4,
 0x2EA4,0x6EA4,0xAEA4,0xEEA4,0x3EA4,0x7EA4,0xBEA4,0xFEA4,
 0x03A4,0x43A4,0x83A4,0xC3A4,0x13A4,0x53A4,0x93A4,0xD3A4,
 0x23A4,0x63A4,0xA3A4,0xE3A4,0x33A4,0x73A4,0xB3A4,0xF3A4,
 0x07A4,0x47A4,0x87A4,0xC7A4,0x17A4,0x57A4,0x97A4,0xD7A4,
 0x27A4,0x67A4,0xA7A4,0xE7A4,0x37A4,0x77A4,0xB7A4,0xF7A4,
 0x0BA4,0x4BA4,0x8BA4,0xCBA4,0x1BA4,0x5BA4,0x9BA4,0xDBA4,
 0x2BA4,0x6BA4,0xABA4,0xEBA4,0x3BA4,0x7BA4,0xBBA4,0xFBA4,
 0x0FA4,0x4FA4,0x8FA4,0xCFA4,0x1FA4,0x5FA4,0x9FA4,0xDFA4,
 0x2FA4,0x6FA4,0xAFA4,0xEFA4,0x3FA4,0x7FA4,0xBFA4,0xFFA4,
 0x00E4,0x40E4,0x80E4,0xC0E4,0x10E4,0x50E4,0x90E4,0xD0E4,
 0x20E4,0x60E4,0xA0E4,0xE0E4,0x30E4,0x70E4,0xB0E4,0xF0E4,
 0x04E4,0x44E4,0x84E4,0xC4E4,0x14E4,0x54E4,0x94E4,0xD4E4,
 0x24E4,0x64E4,0xA4E4,0xE4E4,0x34E4,0x74E4,0xB4E4,0xF4E4,
 0x08E4,0x48E4,0x88E4,0xC8E4,0x18E4,0x58E4,0x98E4,0xD8E4,
 0x28E4,0x68E4,0xA8E4,0xE8E4,0x38E4,0x78E4,0xB8E4,0xF8E4,
 0x0CE4,0x4CE4,0x8CE4,0xCCE4,0x1CE4,0x5CE4,0x9CE4,0xDCE4,
 0x2CE4,0x6CE4,0xACE4,0xECE4,0x3CE4,0x7CE4,0xBCE4,0xFCE4,
 0x01E4,0x41E4,0x81E4,0xC1E4,0x11E4,0x51E4,0x91E4,0xD1E4,
 0x21E4,0x61E4,0xA1E4,0xE1E4,0x31E4,0x71E4,0xB1E4,0xF1E4,
 0x05E4,0x45E4,0x85E4,0xC5E4,0x15E4,0x55E4,0x95E4,0xD5E4,
 0x25E4,0x65E4,0xA5E4,0xE5E4,0x35E4,0x75E4,0xB5E4,0xF5E4,
 0x09E4,0x49E4,0x89E4,0xC9E4,0x19E4,0x59E4,0x99E4,0xD9E4,
 0x29E4,0x69E4,0xA9E4,0xE9E4,0x39E4,0x79E4,0xB9E4,0xF9E4,
 0x0DE4,0x4DE4,0x8DE4,0xCDE4,0x1DE4,0x5DE4,0x9DE4,0xDDE4,
 0x2DE4,0x6DE4,0xADE4,0xEDE4,0x3DE4,0x7DE4,0xBDE4,0xFDE4,
 0x02E4,0x42E4,0x82E4,0xC2E4,0x12E4,0x52E4,0x92E4,0xD2E4,
 0x22E4,0x62E4,0xA2E4,0xE2E4,0x32E4,0x72E4,0xB2E4,0xF2E4,
 0x06E4,0x46E4,0x86E4,0xC6E4,0x16E4,0x56E4,0x96E4,0xD6E4,
 0x26E4,0x66E4,0xA6E4,0xE6E4,0x36E4,0x76E4,0xB6E4,0xF6E4,
 0x0AE4,0x4AE4,0x8AE4,0xCAE4,0x1AE4,0x5AE4,0x9AE4,0xDAE4,
 0x2AE4,0x6AE4,0xAAE4,0xEAE4,0x3AE4,0x7AE4,0xBAE4,0xFAE4,
 0x0EE4,0x4EE4,0x8EE4,0xCEE4,0x1EE4,0x5EE4,0x9EE4,0xDEE4,
 0x2EE4,0x6EE4,0xAEE4,0xEEE4,0x3EE4,0x7EE4,0xBEE4,0xFEE4,
 0x03E4,0x43E4,0x83E4,0xC3E4,0x13E4,0x53E4,0x93E4,0xD3E4,
 0x23E4,0x63E4,0xA3E4,0xE3E4,0x33E4,0x73E4,0xB3E4,0xF3E4,
 0x07E4,0x47E4,0x87E4,0xC7E4,0x17E4,0x57E4,0x97E4,0xD7E4,
 0x27E4,0x67E4,0xA7E4,0xE7E4,0x37E4,0x77E4,0xB7E4,0xF7E4,
 0x0BE4,0x4BE4,0x8BE4,0xCBE4,0x1BE4,0x5BE4,0x9BE4,0xDBE4,
 0x2BE4,0x6BE4,0xABE4,0xEBE4,0x3BE4,0x7BE4,0xBBE4,0xFBE4,
 0x0FE4,0x4FE4,0x8FE4,0xCFE4,0x1FE4,0x5FE4,0x9FE4,0xDFE4,
 0x2FE4,0x6FE4,0xAFE4,0xEFE4,0x3FE4,0x7FE4,0xBFE4,0xFFE4,
 0x0034,0x4034,0x8034,0xC034,0x1034,0x5034,0x9034,0xD034,
 0x2034,0x6034,0xA034,0xE034,0x3034,0x7034,0xB034,0xF034,
 0x0434,0x4434,0x8434,0xC434,0x1434,0x5434,0x9434,0xD434,
 0x2434,0x6434,0xA434,0xE434,0x3434,0x7434,0xB434,0xF434,
 0x0834,0x4834,0x8834,0xC834,0x1834,0x5834,0x9834,0xD834,
 0x2834,0x6834,0xA834,0xE834,0x3834,0x7834,0xB834,0xF834,
 0x0C34,0x4C34,0x8C34,0xCC34,0x1C34,0x5C34,0x9C34,0xDC34,
 0x2C34,0x6C34,0xAC34,0xEC34,0x3C34,0x7C34,0xBC34,0xFC34,
 0x0134,0x4134,0x8134,0xC134,0x1134,0x5134,0x9134,0xD134,
 0x2134,0x6134,0xA134,0xE134,0x3134,0x7134,0xB134,0xF134,
 0x0534,0x4534,0x8534,0xC534,0x1534,0x5534,0x9534,0xD534,
 0x2534,0x6534,0xA534,0xE534,0x3534,0x7534,0xB534,0xF534,
 0x0934,0x4934,0x8934,0xC934,0x1934,0x5934,0x9934,0xD934,
 0x2934,0x6934,0xA934,0xE934,0x3934,0x7934,0xB934,0xF934,
 0x0D34,0x4D34,0x8D34,0xCD34,0x1D34,0x5D34,0x9D34,0xDD34,
 0x2D34,0x6D34,0xAD34,0xED34,0x3D34,0x7D34,0xBD34,0xFD34,
 0x0234,0x4234,0x8234,0xC234,0x1234,0x5234,0x9234,0xD234,
 0x2234,0x6234,0xA234,0xE234,0x3234,0x7234,0xB234,0xF234,
 0x0634,0x4634,0x8634,0xC634,0x1634,0x5634,0x9634,0xD634,
 0x2634,0x6634,0xA634,0xE634,0x3634,0x7634,0xB634,0xF634,
 0x0A34,0x4A34,0x8A34,0xCA34,0x1A34,0x5A34,0x9A34,0xDA34,
 0x2A34,0x6A34,0xAA34,0xEA34,0x3A34,0x7A34,0xBA34,0xFA34,
 0x0E34,0x4E34,0x8E34,0xCE34,0x1E34,0x5E34,0x9E34,0xDE34,
 0x2E34,0x6E34,0xAE34,0xEE34,0x3E34,0x7E34,0xBE34,0xFE34,
 0x0334,0x4334,0x8334,0xC334,0x1334,0x5334,0x9334,0xD334,
 0x2334,0x6334,0xA334,0xE334,0x3334,0x7334,0xB334,0xF334,
 0x0734,0x4734,0x8734,0xC734,0x1734,0x5734,0x9734,0xD734,
 0x2734,0x6734,0xA734,0xE734,0x3734,0x7734,0xB734,0xF734,
 0x0B34,0x4B34,0x8B34,0xCB34,0x1B34,0x5B34,0x9B34,0xDB34,
 0x2B34,0x6B34,0xAB34,0xEB34,0x3B34,0x7B34,0xBB34,0xFB34,
 0x0F34,0x4F34,0x8F34,0xCF34,0x1F34,0x5F34,0x9F34,0xDF34,
 0x2F34,0x6F34,0xAF34,0xEF34,0x3F34,0x7F34,0xBF34,0xFF34,
 0x0074,0x4074,0x8074,0xC074,0x1074,0x5074,0x9074,0xD074,
 0x2074,0x6074,0xA074,0xE074,0x3074,0x7074,0xB074,0xF074,
 0x0474,0x4474,0x8474,0xC474,0x1474,0x5474,0x9474,0xD474,
 0x2474,0x6474,0xA474,0xE474,0x3474,0x7474,0xB474,0xF474,
 0x0874,0x4874,0x8874,0xC874,0x1874,0x5874,0x9874,0xD874,
 0x2874,0x6874,0xA874,0xE874,0x3874,0x7874,0xB874,0xF874,
 0x0C74,0x4C74,0x8C74,0xCC74,0x1C74,0x5C74,0x9C74,0xDC74,
 0x2C74,0x6C74,0xAC74,0xEC74,0x3C74,0x7C74,0xBC74,0xFC74,
 0x0174,0x4174,0x8174,0xC174,0x1174,0x5174,0x9174,0xD174,
 0x2174,0x6174,0xA174,0xE174,0x3174,0x7174,0xB174,0xF174,
 0x0574,0x4574,0x8574,0xC574,0x1574,0x5574,0x9574,0xD574,
 0x2574,0x6574,0xA574,0xE574,0x3574,0x7574,0xB574,0xF574,
 0x0974,0x4974,0x8974,0xC974,0x1974,0x5974,0x9974,0xD974,
 0x2974,0x6974,0xA974,0xE974,0x3974,0x7974,0xB974,0xF974,
 0x0D74,0x4D74,0x8D74,0xCD74,0x1D74,0x5D74,0x9D74,0xDD74,
 0x2D74,0x6D74,0xAD74,0xED74,0x3D74,0x7D74,0xBD74,0xFD74,
 0x0274,0x4274,0x8274,0xC274,0x1274,0x5274,0x9274,0xD274,
 0x2274,0x6274,0xA274,0xE274,0x3274,0x7274,0xB274,0xF274,
 0x0674,0x4674,0x8674,0xC674,0x1674,0x5674,0x9674,0xD674,
 0x2674,0x6674,0xA674,0xE674,0x3674,0x7674,0xB674,0xF674,
 0x0A74,0x4A74,0x8A74,0xCA74,0x1A74,0x5A74,0x9A74,0xDA74,
 0x2A74,0x6A74,0xAA74,0xEA74,0x3A74,0x7A74,0xBA74,0xFA74,
 0x0E74,0x4E74,0x8E74,0xCE74,0x1E74,0x5E74,0x9E74,0xDE74,
 0x2E74,0x6E74,0xAE74,0xEE74,0x3E74,0x7E74,0xBE74,0xFE74,
 0x0374,0x4374,0x8374,0xC374,0x1374,0x5374,0x9374,0xD374,
 0x2374,0x6374,0xA374,0xE374,0x3374,0x7374,0xB374,0xF374,
 0x0774,0x4774,0x8774,0xC774,0x1774,0x5774,0x9774,0xD774,
 0x2774,0x6774,0xA774,0xE774,0x3774,0x7774,0xB774,0xF774,
 0x0B74,0x4B74,0x8B74,0xCB74,0x1B74,0x5B74,0x9B74,0xDB74,
 0x2B74,0x6B74,0xAB74,0xEB74,0x3B74,0x7B74,0xBB74,0xFB74,
 0x0F74,0x4F74,0x8F74,0xCF74,0x1F74,0x5F74,0x9F74,0xDF74,
 0x2F74,0x6F74,0xAF74,0xEF74,0x3F74,0x7F74,0xBF74,0xFF74,
 0x00B4,0x40B4,0x80B4,0xC0B4,0x10B4,0x50B4,0x90B4,0xD0B4,
 0x20B4,0x60B4,0xA0B4,0xE0B4,0x30B4,0x70B4,0xB0B4,0xF0B4,
 0x04B4,0x44B4,0x84B4,0xC4B4,0x14B4,0x54B4,0x94B4,0xD4B4,
 0x24B4,0x64B4,0xA4B4,0xE4B4,0x34B4,0x74B4,0xB4B4,0xF4B4,
 0x08B4,0x48B4,0x88B4,0xC8B4,0x18B4,0x58B4,0x98B4,0xD8B4,
 0x28B4,0x68B4,0xA8B4,0xE8B4,0x38B4,0x78B4,0xB8B4,0xF8B4,
 0x0CB4,0x4CB4,0x8CB4,0xCCB4,0x1CB4,0x5CB4,0x9CB4,0xDCB4,
 0x2CB4,0x6CB4,0xACB4,0xECB4,0x3CB4,0x7CB4,0xBCB4,0xFCB4,
 0x01B4,0x41B4,0x81B4,0xC1B4,0x11B4,0x51B4,0x91B4,0xD1B4,
 0x21B4,0x61B4,0xA1B4,0xE1B4,0x31B4,0x71B4,0xB1B4,0xF1B4,
 0x05B4,0x45B4,0x85B4,0xC5B4,0x15B4,0x55B4,0x95B4,0xD5B4,
 0x25B4,0x65B4,0xA5B4,0xE5B4,0x35B4,0x75B4,0xB5B4,0xF5B4,
 0x09B4,0x49B4,0x89B4,0xC9B4,0x19B4,0x59B4,0x99B4,0xD9B4,
 0x29B4,0x69B4,0xA9B4,0xE9B4,0x39B4,0x79B4,0xB9B4,0xF9B4,
 0x0DB4,0x4DB4,0x8DB4,0xCDB4,0x1DB4,0x5DB4,0x9DB4,0xDDB4,
 0x2DB4,0x6DB4,0xADB4,0xEDB4,0x3DB4,0x7DB4,0xBDB4,0xFDB4,
 0x02B4,0x42B4,0x82B4,0xC2B4,0x12B4,0x52B4,0x92B4,0xD2B4,
 0x22B4,0x62B4,0xA2B4,0xE2B4,0x32B4,0x72B4,0xB2B4,0xF2B4,
 0x06B4,0x46B4,0x86B4,0xC6B4,0x16B4,0x56B4,0x96B4,0xD6B4,
 0x26B4,0x66B4,0xA6B4,0xE6B4,0x36B4,0x76B4,0xB6B4,0xF6B4,
 0x0AB4,0x4AB4,0x8AB4,0xCAB4,0x1AB4,0x5AB4,0x9AB4,0xDAB4,
 0x2AB4,0x6AB4,0xAAB4,0xEAB4,0x3AB4,0x7AB4,0xBAB4,0xFAB4,
 0x0EB4,0x4EB4,0x8EB4,0xCEB4,0x1EB4,0x5EB4,0x9EB4,0xDEB4,
 0x2EB4,0x6EB4,0xAEB4,0xEEB4,0x3EB4,0x7EB4,0xBEB4,0xFEB4,
 0x03B4,0x43B4,0x83B4,0xC3B4,0x13B4,0x53B4,0x93B4,0xD3B4,
 0x23B4,0x63B4,0xA3B4,0xE3B4,0x33B4,0x73B4,0xB3B4,0xF3B4,
 0x07B4,0x47B4,0x87B4,0xC7B4,0x17B4,0x57B4,0x97B4,0xD7B4,
 0x27B4,0x67B4,0xA7B4,0xE7B4,0x37B4,0x77B4,0xB7B4,0xF7B4,
 0x0BB4,0x4BB4,0x8BB4,0xCBB4,0x1BB4,0x5BB4,0x9BB4,0xDBB4,
 0x2BB4,0x6BB4,0xABB4,0xEBB4,0x3BB4,0x7BB4,0xBBB4,0xFBB4,
 0x0FB4,0x4FB4,0x8FB4,0xCFB4,0x1FB4,0x5FB4,0x9FB4,0xDFB4,
 0x2FB4,0x6FB4,0xAFB4,0xEFB4,0x3FB4,0x7FB4,0xBFB4,0xFFB4,
 0x00F4,0x40F4,0x80F4,0xC0F4,0x10F4,0x50F4,0x90F4,0xD0F4,
 0x20F4,0x60F4,0xA0F4,0xE0F4,0x30F4,0x70F4,0xB0F4,0xF0F4,
 0x04F4,0x44F4,0x84F4,0xC4F4,0x14F4,0x54F4,0x94F4,0xD4F4,
 0x24F4,0x64F4,0xA4F4,0xE4F4,0x34F4,0x74F4,0xB4F4,0xF4F4,
 0x08F4,0x48F4,0x88F4,0xC8F4,0x18F4,0x58F4,0x98F4,0xD8F4,
 0x28F4,0x68F4,0xA8F4,0xE8F4,0x38F4,0x78F4,0xB8F4,0xF8F4,
 0x0CF4,0x4CF4,0x8CF4,0xCCF4,0x1CF4,0x5CF4,0x9CF4,0xDCF4,
 0x2CF4,0x6CF4,0xACF4,0xECF4,0x3CF4,0x7CF4,0xBCF4,0xFCF4,
 0x01F4,0x41F4,0x81F4,0xC1F4,0x11F4,0x51F4,0x91F4,0xD1F4,
 0x21F4,0x61F4,0xA1F4,0xE1F4,0x31F4,0x71F4,0xB1F4,0xF1F4,
 0x05F4,0x45F4,0x85F4,0xC5F4,0x15F4,0x55F4,0x95F4,0xD5F4,
 0x25F4,0x65F4,0xA5F4,0xE5F4,0x35F4,0x75F4,0xB5F4,0xF5F4,
 0x09F4,0x49F4,0x89F4,0xC9F4,0x19F4,0x59F4,0x99F4,0xD9F4,
 0x29F4,0x69F4,0xA9F4,0xE9F4,0x39F4,0x79F4,0xB9F4,0xF9F4,
 0x0DF4,0x4DF4,0x8DF4,0xCDF4,0x1DF4,0x5DF4,0x9DF4,0xDDF4,
 0x2DF4,0x6DF4,0xADF4,0xEDF4,0x3DF4,0x7DF4,0xBDF4,0xFDF4,
 0x02F4,0x42F4,0x82F4,0xC2F4,0x12F4,0x52F4,0x92F4,0xD2F4,
 0x22F4,0x62F4,0xA2F4,0xE2F4,0x32F4,0x72F4,0xB2F4,0xF2F4,
 0x06F4,0x46F4,0x86F4,0xC6F4,0x16F4,0x56F4,0x96F4,0xD6F4,
 0x26F4,0x66F4,0xA6F4,0xE6F4,0x36F4,0x76F4,0xB6F4,0xF6F4,
 0x0AF4,0x4AF4,0x8AF4,0xCAF4,0x1AF4,0x5AF4,0x9AF4,0xDAF4,
 0x2AF4,0x6AF4,0xAAF4,0xEAF4,0x3AF4,0x7AF4,0xBAF4,0xFAF4,
 0x0EF4,0x4EF4,0x8EF4,0xCEF4,0x1EF4,0x5EF4,0x9EF4,0xDEF4,
 0x2EF4,0x6EF4,0xAEF4,0xEEF4,0x3EF4,0x7EF4,0xBEF4,0xFEF4,
 0x03F4,0x43F4,0x83F4,0xC3F4,0x13F4,0x53F4,0x93F4,0xD3F4,
 0x23F4,0x63F4,0xA3F4,0xE3F4,0x33F4,0x73F4,0xB3F4,0xF3F4,
 0x07F4,0x47F4,0x87F4,0xC7F4,0x17F4,0x57F4,0x97F4,0xD7F4,
 0x27F4,0x67F4,0xA7F4,0xE7F4,0x37F4,0x77F4,0xB7F4,0xF7F4,
 0x0BF4,0x4BF4,0x8BF4,0xCBF4,0x1BF4,0x5BF4,0x9BF4,0xDBF4,
 0x2BF4,0x6BF4,0xABF4,0xEBF4,0x3BF4,0x7BF4,0xBBF4,0xFBF4,
 0x0FF4,0x4FF4,0x8FF4,0xCFF4,0x1FF4,0x5FF4,0x9FF4,0xDFF4,
 0x2FF4,0x6FF4,0xAFF4,0xEFF4,0x3FF4,0x7FF4,0xBFF4,0xFFF4,
 0x0008,0x4008,0x8008,0xC008,0x1008,0x5008,0x9008,0xD008,
 0x2008,0x6008,0xA008,0xE008,0x3008,0x7008,0xB008,0xF008,
 0x0408,0x4408,0x8408,0xC408,0x1408,0x5408,0x9408,0xD408,
 0x2408,0x6408,0xA408,0xE408,0x3408,0x7408,0xB408,0xF408,
 0x0808,0x4808,0x8808,0xC808,0x1808,0x5808,0x9808,0xD808,
 0x2808,0x6808,0xA808,0xE808,0x3808,0x7808,0xB808,0xF808,
 0x0C08,0x4C08,0x8C08,0xCC08,0x1C08,0x5C08,0x9C08,0xDC08,
 0x2C08,0x6C08,0xAC08,0xEC08,0x3C08,0x7C08,0xBC08,0xFC08,
 0x0108,0x4108,0x8108,0xC108,0x1108,0x5108,0x9108,0xD108,
 0x2108,0x6108,0xA108,0xE108,0x3108,0x7108,0xB108,0xF108,
 0x0508,0x4508,0x8508,0xC508,0x1508,0x5508,0x9508,0xD508,
 0x2508,0x6508,0xA508,0xE508,0x3508,0x7508,0xB508,0xF508,
 0x0908,0x4908,0x8908,0xC908,0x1908,0x5908,0x9908,0xD908,
 0x2908,0x6908,0xA908,0xE908,0x3908,0x7908,0xB908,0xF908,
 0x0D08,0x4D08,0x8D08,0xCD08,0x1D08,0x5D08,0x9D08,0xDD08,
 0x2D08,0x6D08,0xAD08,0xED08,0x3D08,0x7D08,0xBD08,0xFD08,
 0x0208,0x4208,0x8208,0xC208,0x1208,0x5208,0x9208,0xD208,
 0x2208,0x6208,0xA208,0xE208,0x3208,0x7208,0xB208,0xF208,
 0x0608,0x4608,0x8608,0xC608,0x1608,0x5608,0x9608,0xD608,
 0x2608,0x6608,0xA608,0xE608,0x3608,0x7608,0xB608,0xF608,
 0x0A08,0x4A08,0x8A08,0xCA08,0x1A08,0x5A08,0x9A08,0xDA08,
 0x2A08,0x6A08,0xAA08,0xEA08,0x3A08,0x7A08,0xBA08,0xFA08,
 0x0E08,0x4E08,0x8E08,0xCE08,0x1E08,0x5E08,0x9E08,0xDE08,
 0x2E08,0x6E08,0xAE08,0xEE08,0x3E08,0x7E08,0xBE08,0xFE08,
 0x0308,0x4308,0x8308,0xC308,0x1308,0x5308,0x9308,0xD308,
 0x2308,0x6308,0xA308,0xE308,0x3308,0x7308,0xB308,0xF308,
 0x0708,0x4708,0x8708,0xC708,0x1708,0x5708,0x9708,0xD708,
 0x2708,0x6708,0xA708,0xE708,0x3708,0x7708,0xB708,0xF708,
 0x0B08,0x4B08,0x8B08,0xCB08,0x1B08,0x5B08,0x9B08,0xDB08,
 0x2B08,0x6B08,0xAB08,0xEB08,0x3B08,0x7B08,0xBB08,0xFB08,
 0x0F08,0x4F08,0x8F08,0xCF08,0x1F08,0x5F08,0x9F08,0xDF08,
 0x2F08,0x6F08,0xAF08,0xEF08,0x3F08,0x7F08,0xBF08,0xFF08,
 0x0048,0x4048,0x8048,0xC048,0x1048,0x5048,0x9048,0xD048,
 0x2048,0x6048,0xA048,0xE048,0x3048,0x7048,0xB048,0xF048,
 0x0448,0x4448,0x8448,0xC448,0x1448,0x5448,0x9448,0xD448,
 0x2448,0x6448,0xA448,0xE448,0x3448,0x7448,0xB448,0xF448,
 0x0848,0x4848,0x8848,0xC848,0x1848,0x5848,0x9848,0xD848,
 0x2848,0x6848,0xA848,0xE848,0x3848,0x7848,0xB848,0xF848,
 0x0C48,0x4C48,0x8C48,0xCC48,0x1C48,0x5C48,0x9C48,0xDC48,
 0x2C48,0x6C48,0xAC48,0xEC48,0x3C48,0x7C48,0xBC48,0xFC48,
 0x0148,0x4148,0x8148,0xC148,0x1148,0x5148,0x9148,0xD148,
 0x2148,0x6148,0xA148,0xE148,0x3148,0x7148,0xB148,0xF148,
 0x0548,0x4548,0x8548,0xC548,0x1548,0x5548,0x9548,0xD548,
 0x2548,0x6548,0xA548,0xE548,0x3548,0x7548,0xB548,0xF548,
 0x0948,0x4948,0x8948,0xC948,0x1948,0x5948,0x9948,0xD948,
 0x2948,0x6948,0xA948,0xE948,0x3948,0x7948,0xB948,0xF948,
 0x0D48,0x4D48,0x8D48,0xCD48,0x1D48,0x5D48,0x9D48,0xDD48,
 0x2D48,0x6D48,0xAD48,0xED48,0x3D48,0x7D48,0xBD48,0xFD48,
 0x0248,0x4248,0x8248,0xC248,0x1248,0x5248,0x9248,0xD248,
 0x2248,0x6248,0xA248,0xE248,0x3248,0x7248,0xB248,0xF248,
 0x0648,0x4648,0x8648,0xC648,0x1648,0x5648,0x9648,0xD648,
 0x2648,0x6648,0xA648,0xE648,0x3648,0x7648,0xB648,0xF648,
 0x0A48,0x4A48,0x8A48,0xCA48,0x1A48,0x5A48,0x9A48,0xDA48,
 0x2A48,0x6A48,0xAA48,0xEA48,0x3A48,0x7A48,0xBA48,0xFA48,
 0x0E48,0x4E48,0x8E48,0xCE48,0x1E48,0x5E48,0x9E48,0xDE48,
 0x2E48,0x6E48,0xAE48,0xEE48,0x3E48,0x7E48,0xBE48,0xFE48,
 0x0348,0x4348,0x8348,0xC348,0x1348,0x5348,0x9348,0xD348,
 0x2348,0x6348,0xA348,0xE348,0x3348,0x7348,0xB348,0xF348,
 0x0748,0x4748,0x8748,0xC748,0x1748,0x5748,0x9748,0xD748,
 0x2748,0x6748,0xA748,0xE748,0x3748,0x7748,0xB748,0xF748,
 0x0B48,0x4B48,0x8B48,0xCB48,0x1B48,0x5B48,0x9B48,0xDB48,
 0x2B48,0x6B48,0xAB48,0xEB48,0x3B48,0x7B48,0xBB48,0xFB48,
 0x0F48,0x4F48,0x8F48,0xCF48,0x1F48,0x5F48,0x9F48,0xDF48,
 0x2F48,0x6F48,0xAF48,0xEF48,0x3F48,0x7F48,0xBF48,0xFF48,
 0x0088,0x4088,0x8088,0xC088,0x1088,0x5088,0x9088,0xD088,
 0x2088,0x6088,0xA088,0xE088,0x3088,0x7088,0xB088,0xF088,
 0x0488,0x4488,0x8488,0xC488,0x1488,0x5488,0x9488,0xD488,
 0x2488,0x6488,0xA488,0xE488,0x3488,0x7488,0xB488,0xF488,
 0x0888,0x4888,0x8888,0xC888,0x1888,0x5888,0x9888,0xD888,
 0x2888,0x6888,0xA888,0xE888,0x3888,0x7888,0xB888,0xF888,
 0x0C88,0x4C88,0x8C88,0xCC88,0x1C88,0x5C88,0x9C88,0xDC88,
 0x2C88,0x6C88,0xAC88,0xEC88,0x3C88,0x7C88,0xBC88,0xFC88,
 0x0188,0x4188,0x8188,0xC188,0x1188,0x5188,0x9188,0xD188,
 0x2188,0x6188,0xA188,0xE188,0x3188,0x7188,0xB188,0xF188,
 0x0588,0x4588,0x8588,0xC588,0x1588,0x5588,0x9588,0xD588,
 0x2588,0x6588,0xA588,0xE588,0x3588,0x7588,0xB588,0xF588,
 0x0988,0x4988,0x8988,0xC988,0x1988,0x5988,0x9988,0xD988,
 0x2988,0x6988,0xA988,0xE988,0x3988,0x7988,0xB988,0xF988,
 0x0D88,0x4D88,0x8D88,0xCD88,0x1D88,0x5D88,0x9D88,0xDD88,
 0x2D88,0x6D88,0xAD88,0xED88,0x3D88,0x7D88,0xBD88,0xFD88,
 0x0288,0x4288,0x8288,0xC288,0x1288,0x5288,0x9288,0xD288,
 0x2288,0x6288,0xA288,0xE288,0x3288,0x7288,0xB288,0xF288,
 0x0688,0x4688,0x8688,0xC688,0x1688,0x5688,0x9688,0xD688,
 0x2688,0x6688,0xA688,0xE688,0x3688,0x7688,0xB688,0xF688,
 0x0A88,0x4A88,0x8A88,0xCA88,0x1A88,0x5A88,0x9A88,0xDA88,
 0x2A88,0x6A88,0xAA88,0xEA88,0x3A88,0x7A88,0xBA88,0xFA88,
 0x0E88,0x4E88,0x8E88,0xCE88,0x1E88,0x5E88,0x9E88,0xDE88,
 0x2E88,0x6E88,0xAE88,0xEE88,0x3E88,0x7E88,0xBE88,0xFE88,
 0x0388,0x4388,0x8388,0xC388,0x1388,0x5388,0x9388,0xD388,
 0x2388,0x6388,0xA388,0xE388,0x3388,0x7388,0xB388,0xF388,
 0x0788,0x4788,0x8788,0xC788,0x1788,0x5788,0x9788,0xD788,
 0x2788,0x6788,0xA788,0xE788,0x3788,0x7788,0xB788,0xF788,
 0x0B88,0x4B88,0x8B88,0xCB88,0x1B88,0x5B88,0x9B88,0xDB88,
 0x2B88,0x6B88,0xAB88,0xEB88,0x3B88,0x7B88,0xBB88,0xFB88,
 0x0F88,0x4F88,0x8F88,0xCF88,0x1F88,0x5F88,0x9F88,0xDF88,
 0x2F88,0x6F88,0xAF88,0xEF88,0x3F88,0x7F88,0xBF88,0xFF88,
 0x00C8,0x40C8,0x80C8,0xC0C8,0x10C8,0x50C8,0x90C8,0xD0C8,
 0x20C8,0x60C8,0xA0C8,0xE0C8,0x30C8,0x70C8,0xB0C8,0xF0C8,
 0x04C8,0x44C8,0x84C8,0xC4C8,0x14C8,0x54C8,0x94C8,0xD4C8,
 0x24C8,0x64C8,0xA4C8,0xE4C8,0x34C8,0x74C8,0xB4C8,0xF4C8,
 0x08C8,0x48C8,0x88C8,0xC8C8,0x18C8,0x58C8,0x98C8,0xD8C8,
 0x28C8,0x68C8,0xA8C8,0xE8C8,0x38C8,0x78C8,0xB8C8,0xF8C8,
 0x0CC8,0x4CC8,0x8CC8,0xCCC8,0x1CC8,0x5CC8,0x9CC8,0xDCC8,
 0x2CC8,0x6CC8,0xACC8,0xECC8,0x3CC8,0x7CC8,0xBCC8,0xFCC8,
 0x01C8,0x41C8,0x81C8,0xC1C8,0x11C8,0x51C8,0x91C8,0xD1C8,
 0x21C8,0x61C8,0xA1C8,0xE1C8,0x31C8,0x71C8,0xB1C8,0xF1C8,
 0x05C8,0x45C8,0x85C8,0xC5C8,0x15C8,0x55C8,0x95C8,0xD5C8,
 0x25C8,0x65C8,0xA5C8,0xE5C8,0x35C8,0x75C8,0xB5C8,0xF5C8,
 0x09C8,0x49C8,0x89C8,0xC9C8,0x19C8,0x59C8,0x99C8,0xD9C8,
 0x29C8,0x69C8,0xA9C8,0xE9C8,0x39C8,0x79C8,0xB9C8,0xF9C8,
 0x0DC8,0x4DC8,0x8DC8,0xCDC8,0x1DC8,0x5DC8,0x9DC8,0xDDC8,
 0x2DC8,0x6DC8,0xADC8,0xEDC8,0x3DC8,0x7DC8,0xBDC8,0xFDC8,
 0x02C8,0x42C8,0x82C8,0xC2C8,0x12C8,0x52C8,0x92C8,0xD2C8,
 0x22C8,0x62C8,0xA2C8,0xE2C8,0x32C8,0x72C8,0xB2C8,0xF2C8,
 0x06C8,0x46C8,0x86C8,0xC6C8,0x16C8,0x56C8,0x96C8,0xD6C8,
 0x26C8,0x66C8,0xA6C8,0xE6C8,0x36C8,0x76C8,0xB6C8,0xF6C8,
 0x0AC8,0x4AC8,0x8AC8,0xCAC8,0x1AC8,0x5AC8,0x9AC8,0xDAC8,
 0x2AC8,0x6AC8,0xAAC8,0xEAC8,0x3AC8,0x7AC8,0xBAC8,0xFAC8,
 0x0EC8,0x4EC8,0x8EC8,0xCEC8,0x1EC8,0x5EC8,0x9EC8,0xDEC8,
 0x2EC8,0x6EC8,0xAEC8,0xEEC8,0x3EC8,0x7EC8,0xBEC8,0xFEC8,
 0x03C8,0x43C8,0x83C8,0xC3C8,0x13C8,0x53C8,0x93C8,0xD3C8,
 0x23C8,0x63C8,0xA3C8,0xE3C8,0x33C8,0x73C8,0xB3C8,0xF3C8,
 0x07C8,0x47C8,0x87C8,0xC7C8,0x17C8,0x57C8,0x97C8,0xD7C8,
 0x27C8,0x67C8,0xA7C8,0xE7C8,0x37C8,0x77C8,0xB7C8,0xF7C8,
 0x0BC8,0x4BC8,0x8BC8,0xCBC8,0x1BC8,0x5BC8,0x9BC8,0xDBC8,
 0x2BC8,0x6BC8,0xABC8,0xEBC8,0x3BC8,0x7BC8,0xBBC8,0xFBC8,
 0x0FC8,0x4FC8,0x8FC8,0xCFC8,0x1FC8,0x5FC8,0x9FC8,0xDFC8,
 0x2FC8,0x6FC8,0xAFC8,0xEFC8,0x3FC8,0x7FC8,0xBFC8,0xFFC8,
 0x0018,0x4018,0x8018,0xC018,0x1018,0x5018,0x9018,0xD018,
 0x2018,0x6018,0xA018,0xE018,0x3018,0x7018,0xB018,0xF018,
 0x0418,0x4418,0x8418,0xC418,0x1418,0x5418,0x9418,0xD418,
 0x2418,0x6418,0xA418,0xE418,0x3418,0x7418,0xB418,0xF418,
 0x0818,0x4818,0x8818,0xC818,0x1818,0x5818,0x9818,0xD818,
 0x2818,0x6818,0xA818,0xE818,0x3818,0x7818,0xB818,0xF818,
 0x0C18,0x4C18,0x8C18,0xCC18,0x1C18,0x5C18,0x9C18,0xDC18,
 0x2C18,0x6C18,0xAC18,0xEC18,0x3C18,0x7C18,0xBC18,0xFC18,
 0x0118,0x4118,0x8118,0xC118,0x1118,0x5118,0x9118,0xD118,
 0x2118,0x6118,0xA118,0xE118,0x3118,0x7118,0xB118,0xF118,
 0x0518,0x4518,0x8518,0xC518,0x1518,0x5518,0x9518,0xD518,
 0x2518,0x6518,0xA518,0xE518,0x3518,0x7518,0xB518,0xF518,
 0x0918,0x4918,0x8918,0xC918,0x1918,0x5918,0x9918,0xD918,
 0x2918,0x6918,0xA918,0xE918,0x3918,0x7918,0xB918,0xF918,
 0x0D18,0x4D18,0x8D18,0xCD18,0x1D18,0x5D18,0x9D18,0xDD18,
 0x2D18,0x6D18,0xAD18,0xED18,0x3D18,0x7D18,0xBD18,0xFD18,
 0x0218,0x4218,0x8218,0xC218,0x1218,0x5218,0x9218,0xD218,
 0x2218,0x6218,0xA218,0xE218,0x3218,0x7218,0xB218,0xF218,
 0x0618,0x4618,0x8618,0xC618,0x1618,0x5618,0x9618,0xD618,
 0x2618,0x6618,0xA618,0xE618,0x3618,0x7618,0xB618,0xF618,
 0x0A18,0x4A18,0x8A18,0xCA18,0x1A18,0x5A18,0x9A18,0xDA18,
 0x2A18,0x6A18,0xAA18,0xEA18,0x3A18,0x7A18,0xBA18,0xFA18,
 0x0E18,0x4E18,0x8E18,0xCE18,0x1E18,0x5E18,0x9E18,0xDE18,
 0x2E18,0x6E18,0xAE18,0xEE18,0x3E18,0x7E18,0xBE18,0xFE18,
 0x0318,0x4318,0x8318,0xC318,0x1318,0x5318,0x9318,0xD318,
 0x2318,0x6318,0xA318,0xE318,0x3318,0x7318,0xB318,0xF318,
 0x0718,0x4718,0x8718,0xC718,0x1718,0x5718,0x9718,0xD718,
 0x2718,0x6718,0xA718,0xE718,0x3718,0x7718,0xB718,0xF718,
 0x0B18,0x4B18,0x8B18,0xCB18,0x1B18,0x5B18,0x9B18,0xDB18,
 0x2B18,0x6B18,0xAB18,0xEB18,0x3B18,0x7B18,0xBB18,0xFB18,
 0x0F18,0x4F18,0x8F18,0xCF18,0x1F18,0x5F18,0x9F18,0xDF18,
 0x2F18,0x6F18,0xAF18,0xEF18,0x3F18,0x7F18,0xBF18,0xFF18,
 0x0058,0x4058,0x8058,0xC058,0x1058,0x5058,0x9058,0xD058,
 0x2058,0x6058,0xA058,0xE058,0x3058,0x7058,0xB058,0xF058,
 0x0458,0x4458,0x8458,0xC458,0x1458,0x5458,0x9458,0xD458,
 0x2458,0x6458,0xA458,0xE458,0x3458,0x7458,0xB458,0xF458,
 0x0858,0x4858,0x8858,0xC858,0x1858,0x5858,0x9858,0xD858,
 0x2858,0x6858,0xA858,0xE858,0x3858,0x7858,0xB858,0xF858,
 0x0C58,0x4C58,0x8C58,0xCC58,0x1C58,0x5C58,0x9C58,0xDC58,
 0x2C58,0x6C58,0xAC58,0xEC58,0x3C58,0x7C58,0xBC58,0xFC58,
 0x0158,0x4158,0x8158,0xC158,0x1158,0x5158,0x9158,0xD158,
 0x2158,0x6158,0xA158,0xE158,0x3158,0x7158,0xB158,0xF158,
 0x0558,0x4558,0x8558,0xC558,0x1558,0x5558,0x9558,0xD558,
 0x2558,0x6558,0xA558,0xE558,0x3558,0x7558,0xB558,0xF558,
 0x0958,0x4958,0x8958,0xC958,0x1958,0x5958,0x9958,0xD958,
 0x2958,0x6958,0xA958,0xE958,0x3958,0x7958,0xB958,0xF958,
 0x0D58,0x4D58,0x8D58,0xCD58,0x1D58,0x5D58,0x9D58,0xDD58,
 0x2D58,0x6D58,0xAD58,0xED58,0x3D58,0x7D58,0xBD58,0xFD58,
 0x0258,0x4258,0x8258,0xC258,0x1258,0x5258,0x9258,0xD258,
 0x2258,0x6258,0xA258,0xE258,0x3258,0x7258,0xB258,0xF258,
 0x0658,0x4658,0x8658,0xC658,0x1658,0x5658,0x9658,0xD658,
 0x2658,0x6658,0xA658,0xE658,0x3658,0x7658,0xB658,0xF658,
 0x0A58,0x4A58,0x8A58,0xCA58,0x1A58,0x5A58,0x9A58,0xDA58,
 0x2A58,0x6A58,0xAA58,0xEA58,0x3A58,0x7A58,0xBA58,0xFA58,
 0x0E58,0x4E58,0x8E58,0xCE58,0x1E58,0x5E58,0x9E58,0xDE58,
 0x2E58,0x6E58,0xAE58,0xEE58,0x3E58,0x7E58,0xBE58,0xFE58,
 0x0358,0x4358,0x8358,0xC358,0x1358,0x5358,0x9358,0xD358,
 0x2358,0x6358,0xA358,0xE358,0x3358,0x7358,0xB358,0xF358,
 0x0758,0x4758,0x8758,0xC758,0x1758,0x5758,0x9758,0xD758,
 0x2758,0x6758,0xA758,0xE758,0x3758,0x7758,0xB758,0xF758,
 0x0B58,0x4B58,0x8B58,0xCB58,0x1B58,0x5B58,0x9B58,0xDB58,
 0x2B58,0x6B58,0xAB58,0xEB58,0x3B58,0x7B58,0xBB58,0xFB58,
 0x0F58,0x4F58,0x8F58,0xCF58,0x1F58,0x5F58,0x9F58,0xDF58,
 0x2F58,0x6F58,0xAF58,0xEF58,0x3F58,0x7F58,0xBF58,0xFF58,
 0x0098,0x4098,0x8098,0xC098,0x1098,0x5098,0x9098,0xD098,
 0x2098,0x6098,0xA098,0xE098,0x3098,0x7098,0xB098,0xF098,
 0x0498,0x4498,0x8498,0xC498,0x1498,0x5498,0x9498,0xD498,
 0x2498,0x6498,0xA498,0xE498,0x3498,0x7498,0xB498,0xF498,
 0x0898,0x4898,0x8898,0xC898,0x1898,0x5898,0x9898,0xD898,
 0x2898,0x6898,0xA898,0xE898,0x3898,0x7898,0xB898,0xF898,
 0x0C98,0x4C98,0x8C98,0xCC98,0x1C98,0x5C98,0x9C98,0xDC98,
 0x2C98,0x6C98,0xAC98,0xEC98,0x3C98,0x7C98,0xBC98,0xFC98,
 0x0198,0x4198,0x8198,0xC198,0x1198,0x5198,0x9198,0xD198,
 0x2198,0x6198,0xA198,0xE198,0x3198,0x7198,0xB198,0xF198,
 0x0598,0x4598,0x8598,0xC598,0x1598,0x5598,0x9598,0xD598,
 0x2598,0x6598,0xA598,0xE598,0x3598,0x7598,0xB598,0xF598,
 0x0998,0x4998,0x8998,0xC998,0x1998,0x5998,0x9998,0xD998,
 0x2998,0x6998,0xA998,0xE998,0x3998,0x7998,0xB998,0xF998,
 0x0D98,0x4D98,0x8D98,0xCD98,0x1D98,0x5D98,0x9D98,0xDD98,
 0x2D98,0x6D98,0xAD98,0xED98,0x3D98,0x7D98,0xBD98,0xFD98,
 0x0298,0x4298,0x8298,0xC298,0x1298,0x5298,0x9298,0xD298,
 0x2298,0x6298,0xA298,0xE298,0x3298,0x7298,0xB298,0xF298,
 0x0698,0x4698,0x8698,0xC698,0x1698,0x5698,0x9698,0xD698,
 0x2698,0x6698,0xA698,0xE698,0x3698,0x7698,0xB698,0xF698,
 0x0A98,0x4A98,0x8A98,0xCA98,0x1A98,0x5A98,0x9A98,0xDA98,
 0x2A98,0x6A98,0xAA98,0xEA98,0x3A98,0x7A98,0xBA98,0xFA98,
 0x0E98,0x4E98,0x8E98,0xCE98,0x1E98,0x5E98,0x9E98,0xDE98,
 0x2E98,0x6E98,0xAE98,0xEE98,0x3E98,0x7E98,0xBE98,0xFE98,
 0x0398,0x4398,0x8398,0xC398,0x1398,0x5398,0x9398,0xD398,
 0x2398,0x6398,0xA398,0xE398,0x3398,0x7398,0xB398,0xF398,
 0x0798,0x4798,0x8798,0xC798,0x1798,0x5798,0x9798,0xD798,
 0x2798,0x6798,0xA798,0xE798,0x3798,0x7798,0xB798,0xF798,
 0x0B98,0x4B98,0x8B98,0xCB98,0x1B98,0x5B98,0x9B98,0xDB98,
 0x2B98,0x6B98,0xAB98,0xEB98,0x3B98,0x7B98,0xBB98,0xFB98,
 0x0F98,0x4F98,0x8F98,0xCF98,0x1F98,0x5F98,0x9F98,0xDF98,
 0x2F98,0x6F98,0xAF98,0xEF98,0x3F98,0x7F98,0xBF98,0xFF98,
 0x00D8,0x40D8,0x80D8,0xC0D8,0x10D8,0x50D8,0x90D8,0xD0D8,
 0x20D8,0x60D8,0xA0D8,0xE0D8,0x30D8,0x70D8,0xB0D8,0xF0D8,
 0x04D8,0x44D8,0x84D8,0xC4D8,0x14D8,0x54D8,0x94D8,0xD4D8,
 0x24D8,0x64D8,0xA4D8,0xE4D8,0x34D8,0x74D8,0xB4D8,0xF4D8,
 0x08D8,0x48D8,0x88D8,0xC8D8,0x18D8,0x58D8,0x98D8,0xD8D8,
 0x28D8,0x68D8,0xA8D8,0xE8D8,0x38D8,0x78D8,0xB8D8,0xF8D8,
 0x0CD8,0x4CD8,0x8CD8,0xCCD8,0x1CD8,0x5CD8,0x9CD8,0xDCD8,
 0x2CD8,0x6CD8,0xACD8,0xECD8,0x3CD8,0x7CD8,0xBCD8,0xFCD8,
 0x01D8,0x41D8,0x81D8,0xC1D8,0x11D8,0x51D8,0x91D8,0xD1D8,
 0x21D8,0x61D8,0xA1D8,0xE1D8,0x31D8,0x71D8,0xB1D8,0xF1D8,
 0x05D8,0x45D8,0x85D8,0xC5D8,0x15D8,0x55D8,0x95D8,0xD5D8,
 0x25D8,0x65D8,0xA5D8,0xE5D8,0x35D8,0x75D8,0xB5D8,0xF5D8,
 0x09D8,0x49D8,0x89D8,0xC9D8,0x19D8,0x59D8,0x99D8,0xD9D8,
 0x29D8,0x69D8,0xA9D8,0xE9D8,0x39D8,0x79D8,0xB9D8,0xF9D8,
 0x0DD8,0x4DD8,0x8DD8,0xCDD8,0x1DD8,0x5DD8,0x9DD8,0xDDD8,
 0x2DD8,0x6DD8,0xADD8,0xEDD8,0x3DD8,0x7DD8,0xBDD8,0xFDD8,
 0x02D8,0x42D8,0x82D8,0xC2D8,0x12D8,0x52D8,0x92D8,0xD2D8,
 0x22D8,0x62D8,0xA2D8,0xE2D8,0x32D8,0x72D8,0xB2D8,0xF2D8,
 0x06D8,0x46D8,0x86D8,0xC6D8,0x16D8,0x56D8,0x96D8,0xD6D8,
 0x26D8,0x66D8,0xA6D8,0xE6D8,0x36D8,0x76D8,0xB6D8,0xF6D8,
 0x0AD8,0x4AD8,0x8AD8,0xCAD8,0x1AD8,0x5AD8,0x9AD8,0xDAD8,
 0x2AD8,0x6AD8,0xAAD8,0xEAD8,0x3AD8,0x7AD8,0xBAD8,0xFAD8,
 0x0ED8,0x4ED8,0x8ED8,0xCED8,0x1ED8,0x5ED8,0x9ED8,0xDED8,
 0x2ED8,0x6ED8,0xAED8,0xEED8,0x3ED8,0x7ED8,0xBED8,0xFED8,
 0x03D8,0x43D8,0x83D8,0xC3D8,0x13D8,0x53D8,0x93D8,0xD3D8,
 0x23D8,0x63D8,0xA3D8,0xE3D8,0x33D8,0x73D8,0xB3D8,0xF3D8,
 0x07D8,0x47D8,0x87D8,0xC7D8,0x17D8,0x57D8,0x97D8,0xD7D8,
 0x27D8,0x67D8,0xA7D8,0xE7D8,0x37D8,0x77D8,0xB7D8,0xF7D8,
 0x0BD8,0x4BD8,0x8BD8,0xCBD8,0x1BD8,0x5BD8,0x9BD8,0xDBD8,
 0x2BD8,0x6BD8,0xABD8,0xEBD8,0x3BD8,0x7BD8,0xBBD8,0xFBD8,
 0x0FD8,0x4FD8,0x8FD8,0xCFD8,0x1FD8,0x5FD8,0x9FD8,0xDFD8,
 0x2FD8,0x6FD8,0xAFD8,0xEFD8,0x3FD8,0x7FD8,0xBFD8,0xFFD8,
 0x0028,0x4028,0x8028,0xC028,0x1028,0x5028,0x9028,0xD028,
 0x2028,0x6028,0xA028,0xE028,0x3028,0x7028,0xB028,0xF028,
 0x0428,0x4428,0x8428,0xC428,0x1428,0x5428,0x9428,0xD428,
 0x2428,0x6428,0xA428,0xE428,0x3428,0x7428,0xB428,0xF428,
 0x0828,0x4828,0x8828,0xC828,0x1828,0x5828,0x9828,0xD828,
 0x2828,0x6828,0xA828,0xE828,0x3828,0x7828,0xB828,0xF828,
 0x0C28,0x4C28,0x8C28,0xCC28,0x1C28,0x5C28,0x9C28,0xDC28,
 0x2C28,0x6C28,0xAC28,0xEC28,0x3C28,0x7C28,0xBC28,0xFC28,
 0x0128,0x4128,0x8128,0xC128,0x1128,0x5128,0x9128,0xD128,
 0x2128,0x6128,0xA128,0xE128,0x3128,0x7128,0xB128,0xF128,
 0x0528,0x4528,0x8528,0xC528,0x1528,0x5528,0x9528,0xD528,
 0x2528,0x6528,0xA528,0xE528,0x3528,0x7528,0xB528,0xF528,
 0x0928,0x4928,0x8928,0xC928,0x1928,0x5928,0x9928,0xD928,
 0x2928,0x6928,0xA928,0xE928,0x3928,0x7928,0xB928,0xF928,
 0x0D28,0x4D28,0x8D28,0xCD28,0x1D28,0x5D28,0x9D28,0xDD28,
 0x2D28,0x6D28,0xAD28,0xED28,0x3D28,0x7D28,0xBD28,0xFD28,
 0x0228,0x4228,0x8228,0xC228,0x1228,0x5228,0x9228,0xD228,
 0x2228,0x6228,0xA228,0xE228,0x3228,0x7228,0xB228,0xF228,
 0x0628,0x4628,0x8628,0xC628,0x1628,0x5628,0x9628,0xD628,
 0x2628,0x6628,0xA628,0xE628,0x3628,0x7628,0xB628,0xF628,
 0x0A28,0x4A28,0x8A28,0xCA28,0x1A28,0x5A28,0x9A28,0xDA28,
 0x2A28,0x6A28,0xAA28,0xEA28,0x3A28,0x7A28,0xBA28,0xFA28,
 0x0E28,0x4E28,0x8E28,0xCE28,0x1E28,0x5E28,0x9E28,0xDE28,
 0x2E28,0x6E28,0xAE28,0xEE28,0x3E28,0x7E28,0xBE28,0xFE28,
 0x0328,0x4328,0x8328,0xC328,0x1328,0x5328,0x9328,0xD328,
 0x2328,0x6328,0xA328,0xE328,0x3328,0x7328,0xB328,0xF328,
 0x0728,0x4728,0x8728,0xC728,0x1728,0x5728,0x9728,0xD728,
 0x2728,0x6728,0xA728,0xE728,0x3728,0x7728,0xB728,0xF728,
 0x0B28,0x4B28,0x8B28,0xCB28,0x1B28,0x5B28,0x9B28,0xDB28,
 0x2B28,0x6B28,0xAB28,0xEB28,0x3B28,0x7B28,0xBB28,0xFB28,
 0x0F28,0x4F28,0x8F28,0xCF28,0x1F28,0x5F28,0x9F28,0xDF28,
 0x2F28,0x6F28,0xAF28,0xEF28,0x3F28,0x7F28,0xBF28,0xFF28,
 0x0068,0x4068,0x8068,0xC068,0x1068,0x5068,0x9068,0xD068,
 0x2068,0x6068,0xA068,0xE068,0x3068,0x7068,0xB068,0xF068,
 0x0468,0x4468,0x8468,0xC468,0x1468,0x5468,0x9468,0xD468,
 0x2468,0x6468,0xA468,0xE468,0x3468,0x7468,0xB468,0xF468,
 0x0868,0x4868,0x8868,0xC868,0x1868,0x5868,0x9868,0xD868,
 0x2868,0x6868,0xA868,0xE868,0x3868,0x7868,0xB868,0xF868,
 0x0C68,0x4C68,0x8C68,0xCC68,0x1C68,0x5C68,0x9C68,0xDC68,
 0x2C68,0x6C68,0xAC68,0xEC68,0x3C68,0x7C68,0xBC68,0xFC68,
 0x0168,0x4168,0x8168,0xC168,0x1168,0x5168,0x9168,0xD168,
 0x2168,0x6168,0xA168,0xE168,0x3168,0x7168,0xB168,0xF168,
 0x0568,0x4568,0x8568,0xC568,0x1568,0x5568,0x9568,0xD568,
 0x2568,0x6568,0xA568,0xE568,0x3568,0x7568,0xB568,0xF568,
 0x0968,0x4968,0x8968,0xC968,0x1968,0x5968,0x9968,0xD968,
 0x2968,0x6968,0xA968,0xE968,0x3968,0x7968,0xB968,0xF968,
 0x0D68,0x4D68,0x8D68,0xCD68,0x1D68,0x5D68,0x9D68,0xDD68,
 0x2D68,0x6D68,0xAD68,0xED68,0x3D68,0x7D68,0xBD68,0xFD68,
 0x0268,0x4268,0x8268,0xC268,0x1268,0x5268,0x9268,0xD268,
 0x2268,0x6268,0xA268,0xE268,0x3268,0x7268,0xB268,0xF268,
 0x0668,0x4668,0x8668,0xC668,0x1668,0x5668,0x9668,0xD668,
 0x2668,0x6668,0xA668,0xE668,0x3668,0x7668,0xB668,0xF668,
 0x0A68,0x4A68,0x8A68,0xCA68,0x1A68,0x5A68,0x9A68,0xDA68,
 0x2A68,0x6A68,0xAA68,0xEA68,0x3A68,0x7A68,0xBA68,0xFA68,
 0x0E68,0x4E68,0x8E68,0xCE68,0x1E68,0x5E68,0x9E68,0xDE68,
 0x2E68,0x6E68,0xAE68,0xEE68,0x3E68,0x7E68,0xBE68,0xFE68,
 0x0368,0x4368,0x8368,0xC368,0x1368,0x5368,0x9368,0xD368,
 0x2368,0x6368,0xA368,0xE368,0x3368,0x7368,0xB368,0xF368,
 0x0768,0x4768,0x8768,0xC768,0x1768,0x5768,0x9768,0xD768,
 0x2768,0x6768,0xA768,0xE768,0x3768,0x7768,0xB768,0xF768,
 0x0B68,0x4B68,0x8B68,0xCB68,0x1B68,0x5B68,0x9B68,0xDB68,
 0x2B68,0x6B68,0xAB68,0xEB68,0x3B68,0x7B68,0xBB68,0xFB68,
 0x0F68,0x4F68,0x8F68,0xCF68,0x1F68,0x5F68,0x9F68,0xDF68,
 0x2F68,0x6F68,0xAF68,0xEF68,0x3F68,0x7F68,0xBF68,0xFF68,
 0x00A8,0x40A8,0x80A8,0xC0A8,0x10A8,0x50A8,0x90A8,0xD0A8,
 0x20A8,0x60A8,0xA0A8,0xE0A8,0x30A8,0x70A8,0xB0A8,0xF0A8,
 0x04A8,0x44A8,0x84A8,0xC4A8,0x14A8,0x54A8,0x94A8,0xD4A8,
 0x24A8,0x64A8,0xA4A8,0xE4A8,0x34A8,0x74A8,0xB4A8,0xF4A8,
 0x08A8,0x48A8,0x88A8,0xC8A8,0x18A8,0x58A8,0x98A8,0xD8A8,
 0x28A8,0x68A8,0xA8A8,0xE8A8,0x38A8,0x78A8,0xB8A8,0xF8A8,
 0x0CA8,0x4CA8,0x8CA8,0xCCA8,0x1CA8,0x5CA8,0x9CA8,0xDCA8,
 0x2CA8,0x6CA8,0xACA8,0xECA8,0x3CA8,0x7CA8,0xBCA8,0xFCA8,
 0x01A8,0x41A8,0x81A8,0xC1A8,0x11A8,0x51A8,0x91A8,0xD1A8,
 0x21A8,0x61A8,0xA1A8,0xE1A8,0x31A8,0x71A8,0xB1A8,0xF1A8,
 0x05A8,0x45A8,0x85A8,0xC5A8,0x15A8,0x55A8,0x95A8,0xD5A8,
 0x25A8,0x65A8,0xA5A8,0xE5A8,0x35A8,0x75A8,0xB5A8,0xF5A8,
 0x09A8,0x49A8,0x89A8,0xC9A8,0x19A8,0x59A8,0x99A8,0xD9A8,
 0x29A8,0x69A8,0xA9A8,0xE9A8,0x39A8,0x79A8,0xB9A8,0xF9A8,
 0x0DA8,0x4DA8,0x8DA8,0xCDA8,0x1DA8,0x5DA8,0x9DA8,0xDDA8,
 0x2DA8,0x6DA8,0xADA8,0xEDA8,0x3DA8,0x7DA8,0xBDA8,0xFDA8,
 0x02A8,0x42A8,0x82A8,0xC2A8,0x12A8,0x52A8,0x92A8,0xD2A8,
 0x22A8,0x62A8,0xA2A8,0xE2A8,0x32A8,0x72A8,0xB2A8,0xF2A8,
 0x06A8,0x46A8,0x86A8,0xC6A8,0x16A8,0x56A8,0x96A8,0xD6A8,
 0x26A8,0x66A8,0xA6A8,0xE6A8,0x36A8,0x76A8,0xB6A8,0xF6A8,
 0x0AA8,0x4AA8,0x8AA8,0xCAA8,0x1AA8,0x5AA8,0x9AA8,0xDAA8,
 0x2AA8,0x6AA8,0xAAA8,0xEAA8,0x3AA8,0x7AA8,0xBAA8,0xFAA8,
 0x0EA8,0x4EA8,0x8EA8,0xCEA8,0x1EA8,0x5EA8,0x9EA8,0xDEA8,
 0x2EA8,0x6EA8,0xAEA8,0xEEA8,0x3EA8,0x7EA8,0xBEA8,0xFEA8,
 0x03A8,0x43A8,0x83A8,0xC3A8,0x13A8,0x53A8,0x93A8,0xD3A8,
 0x23A8,0x63A8,0xA3A8,0xE3A8,0x33A8,0x73A8,0xB3A8,0xF3A8,
 0x07A8,0x47A8,0x87A8,0xC7A8,0x17A8,0x57A8,0x97A8,0xD7A8,
 0x27A8,0x67A8,0xA7A8,0xE7A8,0x37A8,0x77A8,0xB7A8,0xF7A8,
 0x0BA8,0x4BA8,0x8BA8,0xCBA8,0x1BA8,0x5BA8,0x9BA8,0xDBA8,
 0x2BA8,0x6BA8,0xABA8,0xEBA8,0x3BA8,0x7BA8,0xBBA8,0xFBA8,
 0x0FA8,0x4FA8,0x8FA8,0xCFA8,0x1FA8,0x5FA8,0x9FA8,0xDFA8,
 0x2FA8,0x6FA8,0xAFA8,0xEFA8,0x3FA8,0x7FA8,0xBFA8,0xFFA8,
 0x00E8,0x40E8,0x80E8,0xC0E8,0x10E8,0x50E8,0x90E8,0xD0E8,
 0x20E8,0x60E8,0xA0E8,0xE0E8,0x30E8,0x70E8,0xB0E8,0xF0E8,
 0x04E8,0x44E8,0x84E8,0xC4E8,0x14E8,0x54E8,0x94E8,0xD4E8,
 0x24E8,0x64E8,0xA4E8,0xE4E8,0x34E8,0x74E8,0xB4E8,0xF4E8,
 0x08E8,0x48E8,0x88E8,0xC8E8,0x18E8,0x58E8,0x98E8,0xD8E8,
 0x28E8,0x68E8,0xA8E8,0xE8E8,0x38E8,0x78E8,0xB8E8,0xF8E8,
 0x0CE8,0x4CE8,0x8CE8,0xCCE8,0x1CE8,0x5CE8,0x9CE8,0xDCE8,
 0x2CE8,0x6CE8,0xACE8,0xECE8,0x3CE8,0x7CE8,0xBCE8,0xFCE8,
 0x01E8,0x41E8,0x81E8,0xC1E8,0x11E8,0x51E8,0x91E8,0xD1E8,
 0x21E8,0x61E8,0xA1E8,0xE1E8,0x31E8,0x71E8,0xB1E8,0xF1E8,
 0x05E8,0x45E8,0x85E8,0xC5E8,0x15E8,0x55E8,0x95E8,0xD5E8,
 0x25E8,0x65E8,0xA5E8,0xE5E8,0x35E8,0x75E8,0xB5E8,0xF5E8,
 0x09E8,0x49E8,0x89E8,0xC9E8,0x19E8,0x59E8,0x99E8,0xD9E8,
 0x29E8,0x69E8,0xA9E8,0xE9E8,0x39E8,0x79E8,0xB9E8,0xF9E8,
 0x0DE8,0x4DE8,0x8DE8,0xCDE8,0x1DE8,0x5DE8,0x9DE8,0xDDE8,
 0x2DE8,0x6DE8,0xADE8,0xEDE8,0x3DE8,0x7DE8,0xBDE8,0xFDE8,
 0x02E8,0x42E8,0x82E8,0xC2E8,0x12E8,0x52E8,0x92E8,0xD2E8,
 0x22E8,0x62E8,0xA2E8,0xE2E8,0x32E8,0x72E8,0xB2E8,0xF2E8,
 0x06E8,0x46E8,0x86E8,0xC6E8,0x16E8,0x56E8,0x96E8,0xD6E8,
 0x26E8,0x66E8,0xA6E8,0xE6E8,0x36E8,0x76E8,0xB6E8,0xF6E8,
 0x0AE8,0x4AE8,0x8AE8,0xCAE8,0x1AE8,0x5AE8,0x9AE8,0xDAE8,
 0x2AE8,0x6AE8,0xAAE8,0xEAE8,0x3AE8,0x7AE8,0xBAE8,0xFAE8,
 0x0EE8,0x4EE8,0x8EE8,0xCEE8,0x1EE8,0x5EE8,0x9EE8,0xDEE8,
 0x2EE8,0x6EE8,0xAEE8,0xEEE8,0x3EE8,0x7EE8,0xBEE8,0xFEE8,
 0x03E8,0x43E8,0x83E8,0xC3E8,0x13E8,0x53E8,0x93E8,0xD3E8,
 0x23E8,0x63E8,0xA3E8,0xE3E8,0x33E8,0x73E8,0xB3E8,0xF3E8,
 0x07E8,0x47E8,0x87E8,0xC7E8,0x17E8,0x57E8,0x97E8,0xD7E8,
 0x27E8,0x67E8,0xA7E8,0xE7E8,0x37E8,0x77E8,0xB7E8,0xF7E8,
 0x0BE8,0x4BE8,0x8BE8,0xCBE8,0x1BE8,0x5BE8,0x9BE8,0xDBE8,
 0x2BE8,0x6BE8,0xABE8,0xEBE8,0x3BE8,0x7BE8,0xBBE8,0xFBE8,
 0x0FE8,0x4FE8,0x8FE8,0xCFE8,0x1FE8,0x5FE8,0x9FE8,0xDFE8,
 0x2FE8,0x6FE8,0xAFE8,0xEFE8,0x3FE8,0x7FE8,0xBFE8,0xFFE8,
 0x0038,0x4038,0x8038,0xC038,0x1038,0x5038,0x9038,0xD038,
 0x2038,0x6038,0xA038,0xE038,0x3038,0x7038,0xB038,0xF038,
 0x0438,0x4438,0x8438,0xC438,0x1438,0x5438,0x9438,0xD438,
 0x2438,0x6438,0xA438,0xE438,0x3438,0x7438,0xB438,0xF438,
 0x0838,0x4838,0x8838,0xC838,0x1838,0x5838,0x9838,0xD838,
 0x2838,0x6838,0xA838,0xE838,0x3838,0x7838,0xB838,0xF838,
 0x0C38,0x4C38,0x8C38,0xCC38,0x1C38,0x5C38,0x9C38,0xDC38,
 0x2C38,0x6C38,0xAC38,0xEC38,0x3C38,0x7C38,0xBC38,0xFC38,
 0x0138,0x4138,0x8138,0xC138,0x1138,0x5138,0x9138,0xD138,
 0x2138,0x6138,0xA138,0xE138,0x3138,0x7138,0xB138,0xF138,
 0x0538,0x4538,0x8538,0xC538,0x1538,0x5538,0x9538,0xD538,
 0x2538,0x6538,0xA538,0xE538,0x3538,0x7538,0xB538,0xF538,
 0x0938,0x4938,0x8938,0xC938,0x1938,0x5938,0x9938,0xD938,
 0x2938,0x6938,0xA938,0xE938,0x3938,0x7938,0xB938,0xF938,
 0x0D38,0x4D38,0x8D38,0xCD38,0x1D38,0x5D38,0x9D38,0xDD38,
 0x2D38,0x6D38,0xAD38,0xED38,0x3D38,0x7D38,0xBD38,0xFD38,
 0x0238,0x4238,0x8238,0xC238,0x1238,0x5238,0x9238,0xD238,
 0x2238,0x6238,0xA238,0xE238,0x3238,0x7238,0xB238,0xF238,
 0x0638,0x4638,0x8638,0xC638,0x1638,0x5638,0x9638,0xD638,
 0x2638,0x6638,0xA638,0xE638,0x3638,0x7638,0xB638,0xF638,
 0x0A38,0x4A38,0x8A38,0xCA38,0x1A38,0x5A38,0x9A38,0xDA38,
 0x2A38,0x6A38,0xAA38,0xEA38,0x3A38,0x7A38,0xBA38,0xFA38,
 0x0E38,0x4E38,0x8E38,0xCE38,0x1E38,0x5E38,0x9E38,0xDE38,
 0x2E38,0x6E38,0xAE38,0xEE38,0x3E38,0x7E38,0xBE38,0xFE38,
 0x0338,0x4338,0x8338,0xC338,0x1338,0x5338,0x9338,0xD338,
 0x2338,0x6338,0xA338,0xE338,0x3338,0x7338,0xB338,0xF338,
 0x0738,0x4738,0x8738,0xC738,0x1738,0x5738,0x9738,0xD738,
 0x2738,0x6738,0xA738,0xE738,0x3738,0x7738,0xB738,0xF738,
 0x0B38,0x4B38,0x8B38,0xCB38,0x1B38,0x5B38,0x9B38,0xDB38,
 0x2B38,0x6B38,0xAB38,0xEB38,0x3B38,0x7B38,0xBB38,0xFB38,
 0x0F38,0x4F38,0x8F38,0xCF38,0x1F38,0x5F38,0x9F38,0xDF38,
 0x2F38,0x6F38,0xAF38,0xEF38,0x3F38,0x7F38,0xBF38,0xFF38,
 0x0078,0x4078,0x8078,0xC078,0x1078,0x5078,0x9078,0xD078,
 0x2078,0x6078,0xA078,0xE078,0x3078,0x7078,0xB078,0xF078,
 0x0478,0x4478,0x8478,0xC478,0x1478,0x5478,0x9478,0xD478,
 0x2478,0x6478,0xA478,0xE478,0x3478,0x7478,0xB478,0xF478,
 0x0878,0x4878,0x8878,0xC878,0x1878,0x5878,0x9878,0xD878,
 0x2878,0x6878,0xA878,0xE878,0x3878,0x7878,0xB878,0xF878,
 0x0C78,0x4C78,0x8C78,0xCC78,0x1C78,0x5C78,0x9C78,0xDC78,
 0x2C78,0x6C78,0xAC78,0xEC78,0x3C78,0x7C78,0xBC78,0xFC78,
 0x0178,0x4178,0x8178,0xC178,0x1178,0x5178,0x9178,0xD178,
 0x2178,0x6178,0xA178,0xE178,0x3178,0x7178,0xB178,0xF178,
 0x0578,0x4578,0x8578,0xC578,0x1578,0x5578,0x9578,0xD578,
 0x2578,0x6578,0xA578,0xE578,0x3578,0x7578,0xB578,0xF578,
 0x0978,0x4978,0x8978,0xC978,0x1978,0x5978,0x9978,0xD978,
 0x2978,0x6978,0xA978,0xE978,0x3978,0x7978,0xB978,0xF978,
 0x0D78,0x4D78,0x8D78,0xCD78,0x1D78,0x5D78,0x9D78,0xDD78,
 0x2D78,0x6D78,0xAD78,0xED78,0x3D78,0x7D78,0xBD78,0xFD78,
 0x0278,0x4278,0x8278,0xC278,0x1278,0x5278,0x9278,0xD278,
 0x2278,0x6278,0xA278,0xE278,0x3278,0x7278,0xB278,0xF278,
 0x0678,0x4678,0x8678,0xC678,0x1678,0x5678,0x9678,0xD678,
 0x2678,0x6678,0xA678,0xE678,0x3678,0x7678,0xB678,0xF678,
 0x0A78,0x4A78,0x8A78,0xCA78,0x1A78,0x5A78,0x9A78,0xDA78,
 0x2A78,0x6A78,0xAA78,0xEA78,0x3A78,0x7A78,0xBA78,0xFA78,
 0x0E78,0x4E78,0x8E78,0xCE78,0x1E78,0x5E78,0x9E78,0xDE78,
 0x2E78,0x6E78,0xAE78,0xEE78,0x3E78,0x7E78,0xBE78,0xFE78,
 0x0378,0x4378,0x8378,0xC378,0x1378,0x5378,0x9378,0xD378,
 0x2378,0x6378,0xA378,0xE378,0x3378,0x7378,0xB378,0xF378,
 0x0778,0x4778,0x8778,0xC778,0x1778,0x5778,0x9778,0xD778,
 0x2778,0x6778,0xA778,0xE778,0x3778,0x7778,0xB778,0xF778,
 0x0B78,0x4B78,0x8B78,0xCB78,0x1B78,0x5B78,0x9B78,0xDB78,
 0x2B78,0x6B78,0xAB78,0xEB78,0x3B78,0x7B78,0xBB78,0xFB78,
 0x0F78,0x4F78,0x8F78,0xCF78,0x1F78,0x5F78,0x9F78,0xDF78,
 0x2F78,0x6F78,0xAF78,0xEF78,0x3F78,0x7F78,0xBF78,0xFF78,
 0x00B8,0x40B8,0x80B8,0xC0B8,0x10B8,0x50B8,0x90B8,0xD0B8,
 0x20B8,0x60B8,0xA0B8,0xE0B8,0x30B8,0x70B8,0xB0B8,0xF0B8,
 0x04B8,0x44B8,0x84B8,0xC4B8,0x14B8,0x54B8,0x94B8,0xD4B8,
 0x24B8,0x64B8,0xA4B8,0xE4B8,0x34B8,0x74B8,0xB4B8,0xF4B8,
 0x08B8,0x48B8,0x88B8,0xC8B8,0x18B8,0x58B8,0x98B8,0xD8B8,
 0x28B8,0x68B8,0xA8B8,0xE8B8,0x38B8,0x78B8,0xB8B8,0xF8B8,
 0x0CB8,0x4CB8,0x8CB8,0xCCB8,0x1CB8,0x5CB8,0x9CB8,0xDCB8,
 0x2CB8,0x6CB8,0xACB8,0xECB8,0x3CB8,0x7CB8,0xBCB8,0xFCB8,
 0x01B8,0x41B8,0x81B8,0xC1B8,0x11B8,0x51B8,0x91B8,0xD1B8,
 0x21B8,0x61B8,0xA1B8,0xE1B8,0x31B8,0x71B8,0xB1B8,0xF1B8,
 0x05B8,0x45B8,0x85B8,0xC5B8,0x15B8,0x55B8,0x95B8,0xD5B8,
 0x25B8,0x65B8,0xA5B8,0xE5B8,0x35B8,0x75B8,0xB5B8,0xF5B8,
 0x09B8,0x49B8,0x89B8,0xC9B8,0x19B8,0x59B8,0x99B8,0xD9B8,
 0x29B8,0x69B8,0xA9B8,0xE9B8,0x39B8,0x79B8,0xB9B8,0xF9B8,
 0x0DB8,0x4DB8,0x8DB8,0xCDB8,0x1DB8,0x5DB8,0x9DB8,0xDDB8,
 0x2DB8,0x6DB8,0xADB8,0xEDB8,0x3DB8,0x7DB8,0xBDB8,0xFDB8,
 0x02B8,0x42B8,0x82B8,0xC2B8,0x12B8,0x52B8,0x92B8,0xD2B8,
 0x22B8,0x62B8,0xA2B8,0xE2B8,0x32B8,0x72B8,0xB2B8,0xF2B8,
 0x06B8,0x46B8,0x86B8,0xC6B8,0x16B8,0x56B8,0x96B8,0xD6B8,
 0x26B8,0x66B8,0xA6B8,0xE6B8,0x36B8,0x76B8,0xB6B8,0xF6B8,
 0x0AB8,0x4AB8,0x8AB8,0xCAB8,0x1AB8,0x5AB8,0x9AB8,0xDAB8,
 0x2AB8,0x6AB8,0xAAB8,0xEAB8,0x3AB8,0x7AB8,0xBAB8,0xFAB8,
 0x0EB8,0x4EB8,0x8EB8,0xCEB8,0x1EB8,0x5EB8,0x9EB8,0xDEB8,
 0x2EB8,0x6EB8,0xAEB8,0xEEB8,0x3EB8,0x7EB8,0xBEB8,0xFEB8,
 0x03B8,0x43B8,0x83B8,0xC3B8,0x13B8,0x53B8,0x93B8,0xD3B8,
 0x23B8,0x63B8,0xA3B8,0xE3B8,0x33B8,0x73B8,0xB3B8,0xF3B8,
 0x07B8,0x47B8,0x87B8,0xC7B8,0x17B8,0x57B8,0x97B8,0xD7B8,
 0x27B8,0x67B8,0xA7B8,0xE7B8,0x37B8,0x77B8,0xB7B8,0xF7B8,
 0x0BB8,0x4BB8,0x8BB8,0xCBB8,0x1BB8,0x5BB8,0x9BB8,0xDBB8,
 0x2BB8,0x6BB8,0xABB8,0xEBB8,0x3BB8,0x7BB8,0xBBB8,0xFBB8,
 0x0FB8,0x4FB8,0x8FB8,0xCFB8,0x1FB8,0x5FB8,0x9FB8,0xDFB8,
 0x2FB8,0x6FB8,0xAFB8,0xEFB8,0x3FB8,0x7FB8,0xBFB8,0xFFB8,
 0x00F8,0x40F8,0x80F8,0xC0F8,0x10F8,0x50F8,0x90F8,0xD0F8,
 0x20F8,0x60F8,0xA0F8,0xE0F8,0x30F8,0x70F8,0xB0F8,0xF0F8,
 0x04F8,0x44F8,0x84F8,0xC4F8,0x14F8,0x54F8,0x94F8,0xD4F8,
 0x24F8,0x64F8,0xA4F8,0xE4F8,0x34F8,0x74F8,0xB4F8,0xF4F8,
 0x08F8,0x48F8,0x88F8,0xC8F8,0x18F8,0x58F8,0x98F8,0xD8F8,
 0x28F8,0x68F8,0xA8F8,0xE8F8,0x38F8,0x78F8,0xB8F8,0xF8F8,
 0x0CF8,0x4CF8,0x8CF8,0xCCF8,0x1CF8,0x5CF8,0x9CF8,0xDCF8,
 0x2CF8,0x6CF8,0xACF8,0xECF8,0x3CF8,0x7CF8,0xBCF8,0xFCF8,
 0x01F8,0x41F8,0x81F8,0xC1F8,0x11F8,0x51F8,0x91F8,0xD1F8,
 0x21F8,0x61F8,0xA1F8,0xE1F8,0x31F8,0x71F8,0xB1F8,0xF1F8,
 0x05F8,0x45F8,0x85F8,0xC5F8,0x15F8,0x55F8,0x95F8,0xD5F8,
 0x25F8,0x65F8,0xA5F8,0xE5F8,0x35F8,0x75F8,0xB5F8,0xF5F8,
 0x09F8,0x49F8,0x89F8,0xC9F8,0x19F8,0x59F8,0x99F8,0xD9F8,
 0x29F8,0x69F8,0xA9F8,0xE9F8,0x39F8,0x79F8,0xB9F8,0xF9F8,
 0x0DF8,0x4DF8,0x8DF8,0xCDF8,0x1DF8,0x5DF8,0x9DF8,0xDDF8,
 0x2DF8,0x6DF8,0xADF8,0xEDF8,0x3DF8,0x7DF8,0xBDF8,0xFDF8,
 0x02F8,0x42F8,0x82F8,0xC2F8,0x12F8,0x52F8,0x92F8,0xD2F8,
 0x22F8,0x62F8,0xA2F8,0xE2F8,0x32F8,0x72F8,0xB2F8,0xF2F8,
 0x06F8,0x46F8,0x86F8,0xC6F8,0x16F8,0x56F8,0x96F8,0xD6F8,
 0x26F8,0x66F8,0xA6F8,0xE6F8,0x36F8,0x76F8,0xB6F8,0xF6F8,
 0x0AF8,0x4AF8,0x8AF8,0xCAF8,0x1AF8,0x5AF8,0x9AF8,0xDAF8,
 0x2AF8,0x6AF8,0xAAF8,0xEAF8,0x3AF8,0x7AF8,0xBAF8,0xFAF8,
 0x0EF8,0x4EF8,0x8EF8,0xCEF8,0x1EF8,0x5EF8,0x9EF8,0xDEF8,
 0x2EF8,0x6EF8,0xAEF8,0xEEF8,0x3EF8,0x7EF8,0xBEF8,0xFEF8,
 0x03F8,0x43F8,0x83F8,0xC3F8,0x13F8,0x53F8,0x93F8,0xD3F8,
 0x23F8,0x63F8,0xA3F8,0xE3F8,0x33F8,0x73F8,0xB3F8,0xF3F8,
 0x07F8,0x47F8,0x87F8,0xC7F8,0x17F8,0x57F8,0x97F8,0xD7F8,
 0x27F8,0x67F8,0xA7F8,0xE7F8,0x37F8,0x77F8,0xB7F8,0xF7F8,
 0x0BF8,0x4BF8,0x8BF8,0xCBF8,0x1BF8,0x5BF8,0x9BF8,0xDBF8,
 0x2BF8,0x6BF8,0xABF8,0xEBF8,0x3BF8,0x7BF8,0xBBF8,0xFBF8,
 0x0FF8,0x4FF8,0x8FF8,0xCFF8,0x1FF8,0x5FF8,0x9FF8,0xDFF8,
 0x2FF8,0x6FF8,0xAFF8,0xEFF8,0x3FF8,0x7FF8,0xBFF8,0xFFF8,
 0x000C,0x400C,0x800C,0xC00C,0x100C,0x500C,0x900C,0xD00C,
 0x200C,0x600C,0xA00C,0xE00C,0x300C,0x700C,0xB00C,0xF00C,
 0x040C,0x440C,0x840C,0xC40C,0x140C,0x540C,0x940C,0xD40C,
 0x240C,0x640C,0xA40C,0xE40C,0x340C,0x740C,0xB40C,0xF40C,
 0x080C,0x480C,0x880C,0xC80C,0x180C,0x580C,0x980C,0xD80C,
 0x280C,0x680C,0xA80C,0xE80C,0x380C,0x780C,0xB80C,0xF80C,
 0x0C0C,0x4C0C,0x8C0C,0xCC0C,0x1C0C,0x5C0C,0x9C0C,0xDC0C,
 0x2C0C,0x6C0C,0xAC0C,0xEC0C,0x3C0C,0x7C0C,0xBC0C,0xFC0C,
 0x010C,0x410C,0x810C,0xC10C,0x110C,0x510C,0x910C,0xD10C,
 0x210C,0x610C,0xA10C,0xE10C,0x310C,0x710C,0xB10C,0xF10C,
 0x050C,0x450C,0x850C,0xC50C,0x150C,0x550C,0x950C,0xD50C,
 0x250C,0x650C,0xA50C,0xE50C,0x350C,0x750C,0xB50C,0xF50C,
 0x090C,0x490C,0x890C,0xC90C,0x190C,0x590C,0x990C,0xD90C,
 0x290C,0x690C,0xA90C,0xE90C,0x390C,0x790C,0xB90C,0xF90C,
 0x0D0C,0x4D0C,0x8D0C,0xCD0C,0x1D0C,0x5D0C,0x9D0C,0xDD0C,
 0x2D0C,0x6D0C,0xAD0C,0xED0C,0x3D0C,0x7D0C,0xBD0C,0xFD0C,
 0x020C,0x420C,0x820C,0xC20C,0x120C,0x520C,0x920C,0xD20C,
 0x220C,0x620C,0xA20C,0xE20C,0x320C,0x720C,0xB20C,0xF20C,
 0x060C,0x460C,0x860C,0xC60C,0x160C,0x560C,0x960C,0xD60C,
 0x260C,0x660C,0xA60C,0xE60C,0x360C,0x760C,0xB60C,0xF60C,
 0x0A0C,0x4A0C,0x8A0C,0xCA0C,0x1A0C,0x5A0C,0x9A0C,0xDA0C,
 0x2A0C,0x6A0C,0xAA0C,0xEA0C,0x3A0C,0x7A0C,0xBA0C,0xFA0C,
 0x0E0C,0x4E0C,0x8E0C,0xCE0C,0x1E0C,0x5E0C,0x9E0C,0xDE0C,
 0x2E0C,0x6E0C,0xAE0C,0xEE0C,0x3E0C,0x7E0C,0xBE0C,0xFE0C,
 0x030C,0x430C,0x830C,0xC30C,0x130C,0x530C,0x930C,0xD30C,
 0x230C,0x630C,0xA30C,0xE30C,0x330C,0x730C,0xB30C,0xF30C,
 0x070C,0x470C,0x870C,0xC70C,0x170C,0x570C,0x970C,0xD70C,
 0x270C,0x670C,0xA70C,0xE70C,0x370C,0x770C,0xB70C,0xF70C,
 0x0B0C,0x4B0C,0x8B0C,0xCB0C,0x1B0C,0x5B0C,0x9B0C,0xDB0C,
 0x2B0C,0x6B0C,0xAB0C,0xEB0C,0x3B0C,0x7B0C,0xBB0C,0xFB0C,
 0x0F0C,0x4F0C,0x8F0C,0xCF0C,0x1F0C,0x5F0C,0x9F0C,0xDF0C,
 0x2F0C,0x6F0C,0xAF0C,0xEF0C,0x3F0C,0x7F0C,0xBF0C,0xFF0C,
 0x004C,0x404C,0x804C,0xC04C,0x104C,0x504C,0x904C,0xD04C,
 0x204C,0x604C,0xA04C,0xE04C,0x304C,0x704C,0xB04C,0xF04C,
 0x044C,0x444C,0x844C,0xC44C,0x144C,0x544C,0x944C,0xD44C,
 0x244C,0x644C,0xA44C,0xE44C,0x344C,0x744C,0xB44C,0xF44C,
 0x084C,0x484C,0x884C,0xC84C,0x184C,0x584C,0x984C,0xD84C,
 0x284C,0x684C,0xA84C,0xE84C,0x384C,0x784C,0xB84C,0xF84C,
 0x0C4C,0x4C4C,0x8C4C,0xCC4C,0x1C4C,0x5C4C,0x9C4C,0xDC4C,
 0x2C4C,0x6C4C,0xAC4C,0xEC4C,0x3C4C,0x7C4C,0xBC4C,0xFC4C,
 0x014C,0x414C,0x814C,0xC14C,0x114C,0x514C,0x914C,0xD14C,
 0x214C,0x614C,0xA14C,0xE14C,0x314C,0x714C,0xB14C,0xF14C,
 0x054C,0x454C,0x854C,0xC54C,0x154C,0x554C,0x954C,0xD54C,
 0x254C,0x654C,0xA54C,0xE54C,0x354C,0x754C,0xB54C,0xF54C,
 0x094C,0x494C,0x894C,0xC94C,0x194C,0x594C,0x994C,0xD94C,
 0x294C,0x694C,0xA94C,0xE94C,0x394C,0x794C,0xB94C,0xF94C,
 0x0D4C,0x4D4C,0x8D4C,0xCD4C,0x1D4C,0x5D4C,0x9D4C,0xDD4C,
 0x2D4C,0x6D4C,0xAD4C,0xED4C,0x3D4C,0x7D4C,0xBD4C,0xFD4C,
 0x024C,0x424C,0x824C,0xC24C,0x124C,0x524C,0x924C,0xD24C,
 0x224C,0x624C,0xA24C,0xE24C,0x324C,0x724C,0xB24C,0xF24C,
 0x064C,0x464C,0x864C,0xC64C,0x164C,0x564C,0x964C,0xD64C,
 0x264C,0x664C,0xA64C,0xE64C,0x364C,0x764C,0xB64C,0xF64C,
 0x0A4C,0x4A4C,0x8A4C,0xCA4C,0x1A4C,0x5A4C,0x9A4C,0xDA4C,
 0x2A4C,0x6A4C,0xAA4C,0xEA4C,0x3A4C,0x7A4C,0xBA4C,0xFA4C,
 0x0E4C,0x4E4C,0x8E4C,0xCE4C,0x1E4C,0x5E4C,0x9E4C,0xDE4C,
 0x2E4C,0x6E4C,0xAE4C,0xEE4C,0x3E4C,0x7E4C,0xBE4C,0xFE4C,
 0x034C,0x434C,0x834C,0xC34C,0x134C,0x534C,0x934C,0xD34C,
 0x234C,0x634C,0xA34C,0xE34C,0x334C,0x734C,0xB34C,0xF34C,
 0x074C,0x474C,0x874C,0xC74C,0x174C,0x574C,0x974C,0xD74C,
 0x274C,0x674C,0xA74C,0xE74C,0x374C,0x774C,0xB74C,0xF74C,
 0x0B4C,0x4B4C,0x8B4C,0xCB4C,0x1B4C,0x5B4C,0x9B4C,0xDB4C,
 0x2B4C,0x6B4C,0xAB4C,0xEB4C,0x3B4C,0x7B4C,0xBB4C,0xFB4C,
 0x0F4C,0x4F4C,0x8F4C,0xCF4C,0x1F4C,0x5F4C,0x9F4C,0xDF4C,
 0x2F4C,0x6F4C,0xAF4C,0xEF4C,0x3F4C,0x7F4C,0xBF4C,0xFF4C,
 0x008C,0x408C,0x808C,0xC08C,0x108C,0x508C,0x908C,0xD08C,
 0x208C,0x608C,0xA08C,0xE08C,0x308C,0x708C,0xB08C,0xF08C,
 0x048C,0x448C,0x848C,0xC48C,0x148C,0x548C,0x948C,0xD48C,
 0x248C,0x648C,0xA48C,0xE48C,0x348C,0x748C,0xB48C,0xF48C,
 0x088C,0x488C,0x888C,0xC88C,0x188C,0x588C,0x988C,0xD88C,
 0x288C,0x688C,0xA88C,0xE88C,0x388C,0x788C,0xB88C,0xF88C,
 0x0C8C,0x4C8C,0x8C8C,0xCC8C,0x1C8C,0x5C8C,0x9C8C,0xDC8C,
 0x2C8C,0x6C8C,0xAC8C,0xEC8C,0x3C8C,0x7C8C,0xBC8C,0xFC8C,
 0x018C,0x418C,0x818C,0xC18C,0x118C,0x518C,0x918C,0xD18C,
 0x218C,0x618C,0xA18C,0xE18C,0x318C,0x718C,0xB18C,0xF18C,
 0x058C,0x458C,0x858C,0xC58C,0x158C,0x558C,0x958C,0xD58C,
 0x258C,0x658C,0xA58C,0xE58C,0x358C,0x758C,0xB58C,0xF58C,
 0x098C,0x498C,0x898C,0xC98C,0x198C,0x598C,0x998C,0xD98C,
 0x298C,0x698C,0xA98C,0xE98C,0x398C,0x798C,0xB98C,0xF98C,
 0x0D8C,0x4D8C,0x8D8C,0xCD8C,0x1D8C,0x5D8C,0x9D8C,0xDD8C,
 0x2D8C,0x6D8C,0xAD8C,0xED8C,0x3D8C,0x7D8C,0xBD8C,0xFD8C,
 0x028C,0x428C,0x828C,0xC28C,0x128C,0x528C,0x928C,0xD28C,
 0x228C,0x628C,0xA28C,0xE28C,0x328C,0x728C,0xB28C,0xF28C,
 0x068C,0x468C,0x868C,0xC68C,0x168C,0x568C,0x968C,0xD68C,
 0x268C,0x668C,0xA68C,0xE68C,0x368C,0x768C,0xB68C,0xF68C,
 0x0A8C,0x4A8C,0x8A8C,0xCA8C,0x1A8C,0x5A8C,0x9A8C,0xDA8C,
 0x2A8C,0x6A8C,0xAA8C,0xEA8C,0x3A8C,0x7A8C,0xBA8C,0xFA8C,
 0x0E8C,0x4E8C,0x8E8C,0xCE8C,0x1E8C,0x5E8C,0x9E8C,0xDE8C,
 0x2E8C,0x6E8C,0xAE8C,0xEE8C,0x3E8C,0x7E8C,0xBE8C,0xFE8C,
 0x038C,0x438C,0x838C,0xC38C,0x138C,0x538C,0x938C,0xD38C,
 0x238C,0x638C,0xA38C,0xE38C,0x338C,0x738C,0xB38C,0xF38C,
 0x078C,0x478C,0x878C,0xC78C,0x178C,0x578C,0x978C,0xD78C,
 0x278C,0x678C,0xA78C,0xE78C,0x378C,0x778C,0xB78C,0xF78C,
 0x0B8C,0x4B8C,0x8B8C,0xCB8C,0x1B8C,0x5B8C,0x9B8C,0xDB8C,
 0x2B8C,0x6B8C,0xAB8C,0xEB8C,0x3B8C,0x7B8C,0xBB8C,0xFB8C,
 0x0F8C,0x4F8C,0x8F8C,0xCF8C,0x1F8C,0x5F8C,0x9F8C,0xDF8C,
 0x2F8C,0x6F8C,0xAF8C,0xEF8C,0x3F8C,0x7F8C,0xBF8C,0xFF8C,
 0x00CC,0x40CC,0x80CC,0xC0CC,0x10CC,0x50CC,0x90CC,0xD0CC,
 0x20CC,0x60CC,0xA0CC,0xE0CC,0x30CC,0x70CC,0xB0CC,0xF0CC,
 0x04CC,0x44CC,0x84CC,0xC4CC,0x14CC,0x54CC,0x94CC,0xD4CC,
 0x24CC,0x64CC,0xA4CC,0xE4CC,0x34CC,0x74CC,0xB4CC,0xF4CC,
 0x08CC,0x48CC,0x88CC,0xC8CC,0x18CC,0x58CC,0x98CC,0xD8CC,
 0x28CC,0x68CC,0xA8CC,0xE8CC,0x38CC,0x78CC,0xB8CC,0xF8CC,
 0x0CCC,0x4CCC,0x8CCC,0xCCCC,0x1CCC,0x5CCC,0x9CCC,0xDCCC,
 0x2CCC,0x6CCC,0xACCC,0xECCC,0x3CCC,0x7CCC,0xBCCC,0xFCCC,
 0x01CC,0x41CC,0x81CC,0xC1CC,0x11CC,0x51CC,0x91CC,0xD1CC,
 0x21CC,0x61CC,0xA1CC,0xE1CC,0x31CC,0x71CC,0xB1CC,0xF1CC,
 0x05CC,0x45CC,0x85CC,0xC5CC,0x15CC,0x55CC,0x95CC,0xD5CC,
 0x25CC,0x65CC,0xA5CC,0xE5CC,0x35CC,0x75CC,0xB5CC,0xF5CC,
 0x09CC,0x49CC,0x89CC,0xC9CC,0x19CC,0x59CC,0x99CC,0xD9CC,
 0x29CC,0x69CC,0xA9CC,0xE9CC,0x39CC,0x79CC,0xB9CC,0xF9CC,
 0x0DCC,0x4DCC,0x8DCC,0xCDCC,0x1DCC,0x5DCC,0x9DCC,0xDDCC,
 0x2DCC,0x6DCC,0xADCC,0xEDCC,0x3DCC,0x7DCC,0xBDCC,0xFDCC,
 0x02CC,0x42CC,0x82CC,0xC2CC,0x12CC,0x52CC,0x92CC,0xD2CC,
 0x22CC,0x62CC,0xA2CC,0xE2CC,0x32CC,0x72CC,0xB2CC,0xF2CC,
 0x06CC,0x46CC,0x86CC,0xC6CC,0x16CC,0x56CC,0x96CC,0xD6CC,
 0x26CC,0x66CC,0xA6CC,0xE6CC,0x36CC,0x76CC,0xB6CC,0xF6CC,
 0x0ACC,0x4ACC,0x8ACC,0xCACC,0x1ACC,0x5ACC,0x9ACC,0xDACC,
 0x2ACC,0x6ACC,0xAACC,0xEACC,0x3ACC,0x7ACC,0xBACC,0xFACC,
 0x0ECC,0x4ECC,0x8ECC,0xCECC,0x1ECC,0x5ECC,0x9ECC,0xDECC,
 0x2ECC,0x6ECC,0xAECC,0xEECC,0x3ECC,0x7ECC,0xBECC,0xFECC,
 0x03CC,0x43CC,0x83CC,0xC3CC,0x13CC,0x53CC,0x93CC,0xD3CC,
 0x23CC,0x63CC,0xA3CC,0xE3CC,0x33CC,0x73CC,0xB3CC,0xF3CC,
 0x07CC,0x47CC,0x87CC,0xC7CC,0x17CC,0x57CC,0x97CC,0xD7CC,
 0x27CC,0x67CC,0xA7CC,0xE7CC,0x37CC,0x77CC,0xB7CC,0xF7CC,
 0x0BCC,0x4BCC,0x8BCC,0xCBCC,0x1BCC,0x5BCC,0x9BCC,0xDBCC,
 0x2BCC,0x6BCC,0xABCC,0xEBCC,0x3BCC,0x7BCC,0xBBCC,0xFBCC,
 0x0FCC,0x4FCC,0x8FCC,0xCFCC,0x1FCC,0x5FCC,0x9FCC,0xDFCC,
 0x2FCC,0x6FCC,0xAFCC,0xEFCC,0x3FCC,0x7FCC,0xBFCC,0xFFCC,
 0x001C,0x401C,0x801C,0xC01C,0x101C,0x501C,0x901C,0xD01C,
 0x201C,0x601C,0xA01C,0xE01C,0x301C,0x701C,0xB01C,0xF01C,
 0x041C,0x441C,0x841C,0xC41C,0x141C,0x541C,0x941C,0xD41C,
 0x241C,0x641C,0xA41C,0xE41C,0x341C,0x741C,0xB41C,0xF41C,
 0x081C,0x481C,0x881C,0xC81C,0x181C,0x581C,0x981C,0xD81C,
 0x281C,0x681C,0xA81C,0xE81C,0x381C,0x781C,0xB81C,0xF81C,
 0x0C1C,0x4C1C,0x8C1C,0xCC1C,0x1C1C,0x5C1C,0x9C1C,0xDC1C,
 0x2C1C,0x6C1C,0xAC1C,0xEC1C,0x3C1C,0x7C1C,0xBC1C,0xFC1C,
 0x011C,0x411C,0x811C,0xC11C,0x111C,0x511C,0x911C,0xD11C,
 0x211C,0x611C,0xA11C,0xE11C,0x311C,0x711C,0xB11C,0xF11C,
 0x051C,0x451C,0x851C,0xC51C,0x151C,0x551C,0x951C,0xD51C,
 0x251C,0x651C,0xA51C,0xE51C,0x351C,0x751C,0xB51C,0xF51C,
 0x091C,0x491C,0x891C,0xC91C,0x191C,0x591C,0x991C,0xD91C,
 0x291C,0x691C,0xA91C,0xE91C,0x391C,0x791C,0xB91C,0xF91C,
 0x0D1C,0x4D1C,0x8D1C,0xCD1C,0x1D1C,0x5D1C,0x9D1C,0xDD1C,
 0x2D1C,0x6D1C,0xAD1C,0xED1C,0x3D1C,0x7D1C,0xBD1C,0xFD1C,
 0x021C,0x421C,0x821C,0xC21C,0x121C,0x521C,0x921C,0xD21C,
 0x221C,0x621C,0xA21C,0xE21C,0x321C,0x721C,0xB21C,0xF21C,
 0x061C,0x461C,0x861C,0xC61C,0x161C,0x561C,0x961C,0xD61C,
 0x261C,0x661C,0xA61C,0xE61C,0x361C,0x761C,0xB61C,0xF61C,
 0x0A1C,0x4A1C,0x8A1C,0xCA1C,0x1A1C,0x5A1C,0x9A1C,0xDA1C,
 0x2A1C,0x6A1C,0xAA1C,0xEA1C,0x3A1C,0x7A1C,0xBA1C,0xFA1C,
 0x0E1C,0x4E1C,0x8E1C,0xCE1C,0x1E1C,0x5E1C,0x9E1C,0xDE1C,
 0x2E1C,0x6E1C,0xAE1C,0xEE1C,0x3E1C,0x7E1C,0xBE1C,0xFE1C,
 0x031C,0x431C,0x831C,0xC31C,0x131C,0x531C,0x931C,0xD31C,
 0x231C,0x631C,0xA31C,0xE31C,0x331C,0x731C,0xB31C,0xF31C,
 0x071C,0x471C,0x871C,0xC71C,0x171C,0x571C,0x971C,0xD71C,
 0x271C,0x671C,0xA71C,0xE71C,0x371C,0x771C,0xB71C,0xF71C,
 0x0B1C,0x4B1C,0x8B1C,0xCB1C,0x1B1C,0x5B1C,0x9B1C,0xDB1C,
 0x2B1C,0x6B1C,0xAB1C,0xEB1C,0x3B1C,0x7B1C,0xBB1C,0xFB1C,
 0x0F1C,0x4F1C,0x8F1C,0xCF1C,0x1F1C,0x5F1C,0x9F1C,0xDF1C,
 0x2F1C,0x6F1C,0xAF1C,0xEF1C,0x3F1C,0x7F1C,0xBF1C,0xFF1C,
 0x005C,0x405C,0x805C,0xC05C,0x105C,0x505C,0x905C,0xD05C,
 0x205C,0x605C,0xA05C,0xE05C,0x305C,0x705C,0xB05C,0xF05C,
 0x045C,0x445C,0x845C,0xC45C,0x145C,0x545C,0x945C,0xD45C,
 0x245C,0x645C,0xA45C,0xE45C,0x345C,0x745C,0xB45C,0xF45C,
 0x085C,0x485C,0x885C,0xC85C,0x185C,0x585C,0x985C,0xD85C,
 0x285C,0x685C,0xA85C,0xE85C,0x385C,0x785C,0xB85C,0xF85C,
 0x0C5C,0x4C5C,0x8C5C,0xCC5C,0x1C5C,0x5C5C,0x9C5C,0xDC5C,
 0x2C5C,0x6C5C,0xAC5C,0xEC5C,0x3C5C,0x7C5C,0xBC5C,0xFC5C,
 0x015C,0x415C,0x815C,0xC15C,0x115C,0x515C,0x915C,0xD15C,
 0x215C,0x615C,0xA15C,0xE15C,0x315C,0x715C,0xB15C,0xF15C,
 0x055C,0x455C,0x855C,0xC55C,0x155C,0x555C,0x955C,0xD55C,
 0x255C,0x655C,0xA55C,0xE55C,0x355C,0x755C,0xB55C,0xF55C,
 0x095C,0x495C,0x895C,0xC95C,0x195C,0x595C,0x995C,0xD95C,
 0x295C,0x695C,0xA95C,0xE95C,0x395C,0x795C,0xB95C,0xF95C,
 0x0D5C,0x4D5C,0x8D5C,0xCD5C,0x1D5C,0x5D5C,0x9D5C,0xDD5C,
 0x2D5C,0x6D5C,0xAD5C,0xED5C,0x3D5C,0x7D5C,0xBD5C,0xFD5C,
 0x025C,0x425C,0x825C,0xC25C,0x125C,0x525C,0x925C,0xD25C,
 0x225C,0x625C,0xA25C,0xE25C,0x325C,0x725C,0xB25C,0xF25C,
 0x065C,0x465C,0x865C,0xC65C,0x165C,0x565C,0x965C,0xD65C,
 0x265C,0x665C,0xA65C,0xE65C,0x365C,0x765C,0xB65C,0xF65C,
 0x0A5C,0x4A5C,0x8A5C,0xCA5C,0x1A5C,0x5A5C,0x9A5C,0xDA5C,
 0x2A5C,0x6A5C,0xAA5C,0xEA5C,0x3A5C,0x7A5C,0xBA5C,0xFA5C,
 0x0E5C,0x4E5C,0x8E5C,0xCE5C,0x1E5C,0x5E5C,0x9E5C,0xDE5C,
 0x2E5C,0x6E5C,0xAE5C,0xEE5C,0x3E5C,0x7E5C,0xBE5C,0xFE5C,
 0x035C,0x435C,0x835C,0xC35C,0x135C,0x535C,0x935C,0xD35C,
 0x235C,0x635C,0xA35C,0xE35C,0x335C,0x735C,0xB35C,0xF35C,
 0x075C,0x475C,0x875C,0xC75C,0x175C,0x575C,0x975C,0xD75C,
 0x275C,0x675C,0xA75C,0xE75C,0x375C,0x775C,0xB75C,0xF75C,
 0x0B5C,0x4B5C,0x8B5C,0xCB5C,0x1B5C,0x5B5C,0x9B5C,0xDB5C,
 0x2B5C,0x6B5C,0xAB5C,0xEB5C,0x3B5C,0x7B5C,0xBB5C,0xFB5C,
 0x0F5C,0x4F5C,0x8F5C,0xCF5C,0x1F5C,0x5F5C,0x9F5C,0xDF5C,
 0x2F5C,0x6F5C,0xAF5C,0xEF5C,0x3F5C,0x7F5C,0xBF5C,0xFF5C,
 0x009C,0x409C,0x809C,0xC09C,0x109C,0x509C,0x909C,0xD09C,
 0x209C,0x609C,0xA09C,0xE09C,0x309C,0x709C,0xB09C,0xF09C,
 0x049C,0x449C,0x849C,0xC49C,0x149C,0x549C,0x949C,0xD49C,
 0x249C,0x649C,0xA49C,0xE49C,0x349C,0x749C,0xB49C,0xF49C,
 0x089C,0x489C,0x889C,0xC89C,0x189C,0x589C,0x989C,0xD89C,
 0x289C,0x689C,0xA89C,0xE89C,0x389C,0x789C,0xB89C,0xF89C,
 0x0C9C,0x4C9C,0x8C9C,0xCC9C,0x1C9C,0x5C9C,0x9C9C,0xDC9C,
 0x2C9C,0x6C9C,0xAC9C,0xEC9C,0x3C9C,0x7C9C,0xBC9C,0xFC9C,
 0x019C,0x419C,0x819C,0xC19C,0x119C,0x519C,0x919C,0xD19C,
 0x219C,0x619C,0xA19C,0xE19C,0x319C,0x719C,0xB19C,0xF19C,
 0x059C,0x459C,0x859C,0xC59C,0x159C,0x559C,0x959C,0xD59C,
 0x259C,0x659C,0xA59C,0xE59C,0x359C,0x759C,0xB59C,0xF59C,
 0x099C,0x499C,0x899C,0xC99C,0x199C,0x599C,0x999C,0xD99C,
 0x299C,0x699C,0xA99C,0xE99C,0x399C,0x799C,0xB99C,0xF99C,
 0x0D9C,0x4D9C,0x8D9C,0xCD9C,0x1D9C,0x5D9C,0x9D9C,0xDD9C,
 0x2D9C,0x6D9C,0xAD9C,0xED9C,0x3D9C,0x7D9C,0xBD9C,0xFD9C,
 0x029C,0x429C,0x829C,0xC29C,0x129C,0x529C,0x929C,0xD29C,
 0x229C,0x629C,0xA29C,0xE29C,0x329C,0x729C,0xB29C,0xF29C,
 0x069C,0x469C,0x869C,0xC69C,0x169C,0x569C,0x969C,0xD69C,
 0x269C,0x669C,0xA69C,0xE69C,0x369C,0x769C,0xB69C,0xF69C,
 0x0A9C,0x4A9C,0x8A9C,0xCA9C,0x1A9C,0x5A9C,0x9A9C,0xDA9C,
 0x2A9C,0x6A9C,0xAA9C,0xEA9C,0x3A9C,0x7A9C,0xBA9C,0xFA9C,
 0x0E9C,0x4E9C,0x8E9C,0xCE9C,0x1E9C,0x5E9C,0x9E9C,0xDE9C,
 0x2E9C,0x6E9C,0xAE9C,0xEE9C,0x3E9C,0x7E9C,0xBE9C,0xFE9C,
 0x039C,0x439C,0x839C,0xC39C,0x139C,0x539C,0x939C,0xD39C,
 0x239C,0x639C,0xA39C,0xE39C,0x339C,0x739C,0xB39C,0xF39C,
 0x079C,0x479C,0x879C,0xC79C,0x179C,0x579C,0x979C,0xD79C,
 0x279C,0x679C,0xA79C,0xE79C,0x379C,0x779C,0xB79C,0xF79C,
 0x0B9C,0x4B9C,0x8B9C,0xCB9C,0x1B9C,0x5B9C,0x9B9C,0xDB9C,
 0x2B9C,0x6B9C,0xAB9C,0xEB9C,0x3B9C,0x7B9C,0xBB9C,0xFB9C,
 0x0F9C,0x4F9C,0x8F9C,0xCF9C,0x1F9C,0x5F9C,0x9F9C,0xDF9C,
 0x2F9C,0x6F9C,0xAF9C,0xEF9C,0x3F9C,0x7F9C,0xBF9C,0xFF9C,
 0x00DC,0x40DC,0x80DC,0xC0DC,0x10DC,0x50DC,0x90DC,0xD0DC,
 0x20DC,0x60DC,0xA0DC,0xE0DC,0x30DC,0x70DC,0xB0DC,0xF0DC,
 0x04DC,0x44DC,0x84DC,0xC4DC,0x14DC,0x54DC,0x94DC,0xD4DC,
 0x24DC,0x64DC,0xA4DC,0xE4DC,0x34DC,0x74DC,0xB4DC,0xF4DC,
 0x08DC,0x48DC,0x88DC,0xC8DC,0x18DC,0x58DC,0x98DC,0xD8DC,
 0x28DC,0x68DC,0xA8DC,0xE8DC,0x38DC,0x78DC,0xB8DC,0xF8DC,
 0x0CDC,0x4CDC,0x8CDC,0xCCDC,0x1CDC,0x5CDC,0x9CDC,0xDCDC,
 0x2CDC,0x6CDC,0xACDC,0xECDC,0x3CDC,0x7CDC,0xBCDC,0xFCDC,
 0x01DC,0x41DC,0x81DC,0xC1DC,0x11DC,0x51DC,0x91DC,0xD1DC,
 0x21DC,0x61DC,0xA1DC,0xE1DC,0x31DC,0x71DC,0xB1DC,0xF1DC,
 0x05DC,0x45DC,0x85DC,0xC5DC,0x15DC,0x55DC,0x95DC,0xD5DC,
 0x25DC,0x65DC,0xA5DC,0xE5DC,0x35DC,0x75DC,0xB5DC,0xF5DC,
 0x09DC,0x49DC,0x89DC,0xC9DC,0x19DC,0x59DC,0x99DC,0xD9DC,
 0x29DC,0x69DC,0xA9DC,0xE9DC,0x39DC,0x79DC,0xB9DC,0xF9DC,
 0x0DDC,0x4DDC,0x8DDC,0xCDDC,0x1DDC,0x5DDC,0x9DDC,0xDDDC,
 0x2DDC,0x6DDC,0xADDC,0xEDDC,0x3DDC,0x7DDC,0xBDDC,0xFDDC,
 0x02DC,0x42DC,0x82DC,0xC2DC,0x12DC,0x52DC,0x92DC,0xD2DC,
 0x22DC,0x62DC,0xA2DC,0xE2DC,0x32DC,0x72DC,0xB2DC,0xF2DC,
 0x06DC,0x46DC,0x86DC,0xC6DC,0x16DC,0x56DC,0x96DC,0xD6DC,
 0x26DC,0x66DC,0xA6DC,0xE6DC,0x36DC,0x76DC,0xB6DC,0xF6DC,
 0x0ADC,0x4ADC,0x8ADC,0xCADC,0x1ADC,0x5ADC,0x9ADC,0xDADC,
 0x2ADC,0x6ADC,0xAADC,0xEADC,0x3ADC,0x7ADC,0xBADC,0xFADC,
 0x0EDC,0x4EDC,0x8EDC,0xCEDC,0x1EDC,0x5EDC,0x9EDC,0xDEDC,
 0x2EDC,0x6EDC,0xAEDC,0xEEDC,0x3EDC,0x7EDC,0xBEDC,0xFEDC,
 0x03DC,0x43DC,0x83DC,0xC3DC,0x13DC,0x53DC,0x93DC,0xD3DC,
 0x23DC,0x63DC,0xA3DC,0xE3DC,0x33DC,0x73DC,0xB3DC,0xF3DC,
 0x07DC,0x47DC,0x87DC,0xC7DC,0x17DC,0x57DC,0x97DC,0xD7DC,
 0x27DC,0x67DC,0xA7DC,0xE7DC,0x37DC,0x77DC,0xB7DC,0xF7DC,
 0x0BDC,0x4BDC,0x8BDC,0xCBDC,0x1BDC,0x5BDC,0x9BDC,0xDBDC,
 0x2BDC,0x6BDC,0xABDC,0xEBDC,0x3BDC,0x7BDC,0xBBDC,0xFBDC,
 0x0FDC,0x4FDC,0x8FDC,0xCFDC,0x1FDC,0x5FDC,0x9FDC,0xDFDC,
 0x2FDC,0x6FDC,0xAFDC,0xEFDC,0x3FDC,0x7FDC,0xBFDC,0xFFDC,
 0x002C,0x402C,0x802C,0xC02C,0x102C,0x502C,0x902C,0xD02C,
 0x202C,0x602C,0xA02C,0xE02C,0x302C,0x702C,0xB02C,0xF02C,
 0x042C,0x442C,0x842C,0xC42C,0x142C,0x542C,0x942C,0xD42C,
 0x242C,0x642C,0xA42C,0xE42C,0x342C,0x742C,0xB42C,0xF42C,
 0x082C,0x482C,0x882C,0xC82C,0x182C,0x582C,0x982C,0xD82C,
 0x282C,0x682C,0xA82C,0xE82C,0x382C,0x782C,0xB82C,0xF82C,
 0x0C2C,0x4C2C,0x8C2C,0xCC2C,0x1C2C,0x5C2C,0x9C2C,0xDC2C,
 0x2C2C,0x6C2C,0xAC2C,0xEC2C,0x3C2C,0x7C2C,0xBC2C,0xFC2C,
 0x012C,0x412C,0x812C,0xC12C,0x112C,0x512C,0x912C,0xD12C,
 0x212C,0x612C,0xA12C,0xE12C,0x312C,0x712C,0xB12C,0xF12C,
 0x052C,0x452C,0x852C,0xC52C,0x152C,0x552C,0x952C,0xD52C,
 0x252C,0x652C,0xA52C,0xE52C,0x352C,0x752C,0xB52C,0xF52C,
 0x092C,0x492C,0x892C,0xC92C,0x192C,0x592C,0x992C,0xD92C,
 0x292C,0x692C,0xA92C,0xE92C,0x392C,0x792C,0xB92C,0xF92C,
 0x0D2C,0x4D2C,0x8D2C,0xCD2C,0x1D2C,0x5D2C,0x9D2C,0xDD2C,
 0x2D2C,0x6D2C,0xAD2C,0xED2C,0x3D2C,0x7D2C,0xBD2C,0xFD2C,
 0x022C,0x422C,0x822C,0xC22C,0x122C,0x522C,0x922C,0xD22C,
 0x222C,0x622C,0xA22C,0xE22C,0x322C,0x722C,0xB22C,0xF22C,
 0x062C,0x462C,0x862C,0xC62C,0x162C,0x562C,0x962C,0xD62C,
 0x262C,0x662C,0xA62C,0xE62C,0x362C,0x762C,0xB62C,0xF62C,
 0x0A2C,0x4A2C,0x8A2C,0xCA2C,0x1A2C,0x5A2C,0x9A2C,0xDA2C,
 0x2A2C,0x6A2C,0xAA2C,0xEA2C,0x3A2C,0x7A2C,0xBA2C,0xFA2C,
 0x0E2C,0x4E2C,0x8E2C,0xCE2C,0x1E2C,0x5E2C,0x9E2C,0xDE2C,
 0x2E2C,0x6E2C,0xAE2C,0xEE2C,0x3E2C,0x7E2C,0xBE2C,0xFE2C,
 0x032C,0x432C,0x832C,0xC32C,0x132C,0x532C,0x932C,0xD32C,
 0x232C,0x632C,0xA32C,0xE32C,0x332C,0x732C,0xB32C,0xF32C,
 0x072C,0x472C,0x872C,0xC72C,0x172C,0x572C,0x972C,0xD72C,
 0x272C,0x672C,0xA72C,0xE72C,0x372C,0x772C,0xB72C,0xF72C,
 0x0B2C,0x4B2C,0x8B2C,0xCB2C,0x1B2C,0x5B2C,0x9B2C,0xDB2C,
 0x2B2C,0x6B2C,0xAB2C,0xEB2C,0x3B2C,0x7B2C,0xBB2C,0xFB2C,
 0x0F2C,0x4F2C,0x8F2C,0xCF2C,0x1F2C,0x5F2C,0x9F2C,0xDF2C,
 0x2F2C,0x6F2C,0xAF2C,0xEF2C,0x3F2C,0x7F2C,0xBF2C,0xFF2C,
 0x006C,0x406C,0x806C,0xC06C,0x106C,0x506C,0x906C,0xD06C,
 0x206C,0x606C,0xA06C,0xE06C,0x306C,0x706C,0xB06C,0xF06C,
 0x046C,0x446C,0x846C,0xC46C,0x146C,0x546C,0x946C,0xD46C,
 0x246C,0x646C,0xA46C,0xE46C,0x346C,0x746C,0xB46C,0xF46C,
 0x086C,0x486C,0x886C,0xC86C,0x186C,0x586C,0x986C,0xD86C,
 0x286C,0x686C,0xA86C,0xE86C,0x386C,0x786C,0xB86C,0xF86C,
 0x0C6C,0x4C6C,0x8C6C,0xCC6C,0x1C6C,0x5C6C,0x9C6C,0xDC6C,
 0x2C6C,0x6C6C,0xAC6C,0xEC6C,0x3C6C,0x7C6C,0xBC6C,0xFC6C,
 0x016C,0x416C,0x816C,0xC16C,0x116C,0x516C,0x916C,0xD16C,
 0x216C,0x616C,0xA16C,0xE16C,0x316C,0x716C,0xB16C,0xF16C,
 0x056C,0x456C,0x856C,0xC56C,0x156C,0x556C,0x956C,0xD56C,
 0x256C,0x656C,0xA56C,0xE56C,0x356C,0x756C,0xB56C,0xF56C,
 0x096C,0x496C,0x896C,0xC96C,0x196C,0x596C,0x996C,0xD96C,
 0x296C,0x696C,0xA96C,0xE96C,0x396C,0x796C,0xB96C,0xF96C,
 0x0D6C,0x4D6C,0x8D6C,0xCD6C,0x1D6C,0x5D6C,0x9D6C,0xDD6C,
 0x2D6C,0x6D6C,0xAD6C,0xED6C,0x3D6C,0x7D6C,0xBD6C,0xFD6C,
 0x026C,0x426C,0x826C,0xC26C,0x126C,0x526C,0x926C,0xD26C,
 0x226C,0x626C,0xA26C,0xE26C,0x326C,0x726C,0xB26C,0xF26C,
 0x066C,0x466C,0x866C,0xC66C,0x166C,0x566C,0x966C,0xD66C,
 0x266C,0x666C,0xA66C,0xE66C,0x366C,0x766C,0xB66C,0xF66C,
 0x0A6C,0x4A6C,0x8A6C,0xCA6C,0x1A6C,0x5A6C,0x9A6C,0xDA6C,
 0x2A6C,0x6A6C,0xAA6C,0xEA6C,0x3A6C,0x7A6C,0xBA6C,0xFA6C,
 0x0E6C,0x4E6C,0x8E6C,0xCE6C,0x1E6C,0x5E6C,0x9E6C,0xDE6C,
 0x2E6C,0x6E6C,0xAE6C,0xEE6C,0x3E6C,0x7E6C,0xBE6C,0xFE6C,
 0x036C,0x436C,0x836C,0xC36C,0x136C,0x536C,0x936C,0xD36C,
 0x236C,0x636C,0xA36C,0xE36C,0x336C,0x736C,0xB36C,0xF36C,
 0x076C,0x476C,0x876C,0xC76C,0x176C,0x576C,0x976C,0xD76C,
 0x276C,0x676C,0xA76C,0xE76C,0x376C,0x776C,0xB76C,0xF76C,
 0x0B6C,0x4B6C,0x8B6C,0xCB6C,0x1B6C,0x5B6C,0x9B6C,0xDB6C,
 0x2B6C,0x6B6C,0xAB6C,0xEB6C,0x3B6C,0x7B6C,0xBB6C,0xFB6C,
 0x0F6C,0x4F6C,0x8F6C,0xCF6C,0x1F6C,0x5F6C,0x9F6C,0xDF6C,
 0x2F6C,0x6F6C,0xAF6C,0xEF6C,0x3F6C,0x7F6C,0xBF6C,0xFF6C,
 0x00AC,0x40AC,0x80AC,0xC0AC,0x10AC,0x50AC,0x90AC,0xD0AC,
 0x20AC,0x60AC,0xA0AC,0xE0AC,0x30AC,0x70AC,0xB0AC,0xF0AC,
 0x04AC,0x44AC,0x84AC,0xC4AC,0x14AC,0x54AC,0x94AC,0xD4AC,
 0x24AC,0x64AC,0xA4AC,0xE4AC,0x34AC,0x74AC,0xB4AC,0xF4AC,
 0x08AC,0x48AC,0x88AC,0xC8AC,0x18AC,0x58AC,0x98AC,0xD8AC,
 0x28AC,0x68AC,0xA8AC,0xE8AC,0x38AC,0x78AC,0xB8AC,0xF8AC,
 0x0CAC,0x4CAC,0x8CAC,0xCCAC,0x1CAC,0x5CAC,0x9CAC,0xDCAC,
 0x2CAC,0x6CAC,0xACAC,0xECAC,0x3CAC,0x7CAC,0xBCAC,0xFCAC,
 0x01AC,0x41AC,0x81AC,0xC1AC,0x11AC,0x51AC,0x91AC,0xD1AC,
 0x21AC,0x61AC,0xA1AC,0xE1AC,0x31AC,0x71AC,0xB1AC,0xF1AC,
 0x05AC,0x45AC,0x85AC,0xC5AC,0x15AC,0x55AC,0x95AC,0xD5AC,
 0x25AC,0x65AC,0xA5AC,0xE5AC,0x35AC,0x75AC,0xB5AC,0xF5AC,
 0x09AC,0x49AC,0x89AC,0xC9AC,0x19AC,0x59AC,0x99AC,0xD9AC,
 0x29AC,0x69AC,0xA9AC,0xE9AC,0x39AC,0x79AC,0xB9AC,0xF9AC,
 0x0DAC,0x4DAC,0x8DAC,0xCDAC,0x1DAC,0x5DAC,0x9DAC,0xDDAC,
 0x2DAC,0x6DAC,0xADAC,0xEDAC,0x3DAC,0x7DAC,0xBDAC,0xFDAC,
 0x02AC,0x42AC,0x82AC,0xC2AC,0x12AC,0x52AC,0x92AC,0xD2AC,
 0x22AC,0x62AC,0xA2AC,0xE2AC,0x32AC,0x72AC,0xB2AC,0xF2AC,
 0x06AC,0x46AC,0x86AC,0xC6AC,0x16AC,0x56AC,0x96AC,0xD6AC,
 0x26AC,0x66AC,0xA6AC,0xE6AC,0x36AC,0x76AC,0xB6AC,0xF6AC,
 0x0AAC,0x4AAC,0x8AAC,0xCAAC,0x1AAC,0x5AAC,0x9AAC,0xDAAC,
 0x2AAC,0x6AAC,0xAAAC,0xEAAC,0x3AAC,0x7AAC,0xBAAC,0xFAAC,
 0x0EAC,0x4EAC,0x8EAC,0xCEAC,0x1EAC,0x5EAC,0x9EAC,0xDEAC,
 0x2EAC,0x6EAC,0xAEAC,0xEEAC,0x3EAC,0x7EAC,0xBEAC,0xFEAC,
 0x03AC,0x43AC,0x83AC,0xC3AC,0x13AC,0x53AC,0x93AC,0xD3AC,
 0x23AC,0x63AC,0xA3AC,0xE3AC,0x33AC,0x73AC,0xB3AC,0xF3AC,
 0x07AC,0x47AC,0x87AC,0xC7AC,0x17AC,0x57AC,0x97AC,0xD7AC,
 0x27AC,0x67AC,0xA7AC,0xE7AC,0x37AC,0x77AC,0xB7AC,0xF7AC,
 0x0BAC,0x4BAC,0x8BAC,0xCBAC,0x1BAC,0x5BAC,0x9BAC,0xDBAC,
 0x2BAC,0x6BAC,0xABAC,0xEBAC,0x3BAC,0x7BAC,0xBBAC,0xFBAC,
 0x0FAC,0x4FAC,0x8FAC,0xCFAC,0x1FAC,0x5FAC,0x9FAC,0xDFAC,
 0x2FAC,0x6FAC,0xAFAC,0xEFAC,0x3FAC,0x7FAC,0xBFAC,0xFFAC,
 0x00EC,0x40EC,0x80EC,0xC0EC,0x10EC,0x50EC,0x90EC,0xD0EC,
 0x20EC,0x60EC,0xA0EC,0xE0EC,0x30EC,0x70EC,0xB0EC,0xF0EC,
 0x04EC,0x44EC,0x84EC,0xC4EC,0x14EC,0x54EC,0x94EC,0xD4EC,
 0x24EC,0x64EC,0xA4EC,0xE4EC,0x34EC,0x74EC,0xB4EC,0xF4EC,
 0x08EC,0x48EC,0x88EC,0xC8EC,0x18EC,0x58EC,0x98EC,0xD8EC,
 0x28EC,0x68EC,0xA8EC,0xE8EC,0x38EC,0x78EC,0xB8EC,0xF8EC,
 0x0CEC,0x4CEC,0x8CEC,0xCCEC,0x1CEC,0x5CEC,0x9CEC,0xDCEC,
 0x2CEC,0x6CEC,0xACEC,0xECEC,0x3CEC,0x7CEC,0xBCEC,0xFCEC,
 0x01EC,0x41EC,0x81EC,0xC1EC,0x11EC,0x51EC,0x91EC,0xD1EC,
 0x21EC,0x61EC,0xA1EC,0xE1EC,0x31EC,0x71EC,0xB1EC,0xF1EC,
 0x05EC,0x45EC,0x85EC,0xC5EC,0x15EC,0x55EC,0x95EC,0xD5EC,
 0x25EC,0x65EC,0xA5EC,0xE5EC,0x35EC,0x75EC,0xB5EC,0xF5EC,
 0x09EC,0x49EC,0x89EC,0xC9EC,0x19EC,0x59EC,0x99EC,0xD9EC,
 0x29EC,0x69EC,0xA9EC,0xE9EC,0x39EC,0x79EC,0xB9EC,0xF9EC,
 0x0DEC,0x4DEC,0x8DEC,0xCDEC,0x1DEC,0x5DEC,0x9DEC,0xDDEC,
 0x2DEC,0x6DEC,0xADEC,0xEDEC,0x3DEC,0x7DEC,0xBDEC,0xFDEC,
 0x02EC,0x42EC,0x82EC,0xC2EC,0x12EC,0x52EC,0x92EC,0xD2EC,
 0x22EC,0x62EC,0xA2EC,0xE2EC,0x32EC,0x72EC,0xB2EC,0xF2EC,
 0x06EC,0x46EC,0x86EC,0xC6EC,0x16EC,0x56EC,0x96EC,0xD6EC,
 0x26EC,0x66EC,0xA6EC,0xE6EC,0x36EC,0x76EC,0xB6EC,0xF6EC,
 0x0AEC,0x4AEC,0x8AEC,0xCAEC,0x1AEC,0x5AEC,0x9AEC,0xDAEC,
 0x2AEC,0x6AEC,0xAAEC,0xEAEC,0x3AEC,0x7AEC,0xBAEC,0xFAEC,
 0x0EEC,0x4EEC,0x8EEC,0xCEEC,0x1EEC,0x5EEC,0x9EEC,0xDEEC,
 0x2EEC,0x6EEC,0xAEEC,0xEEEC,0x3EEC,0x7EEC,0xBEEC,0xFEEC,
 0x03EC,0x43EC,0x83EC,0xC3EC,0x13EC,0x53EC,0x93EC,0xD3EC,
 0x23EC,0x63EC,0xA3EC,0xE3EC,0x33EC,0x73EC,0xB3EC,0xF3EC,
 0x07EC,0x47EC,0x87EC,0xC7EC,0x17EC,0x57EC,0x97EC,0xD7EC,
 0x27EC,0x67EC,0xA7EC,0xE7EC,0x37EC,0x77EC,0xB7EC,0xF7EC,
 0x0BEC,0x4BEC,0x8BEC,0xCBEC,0x1BEC,0x5BEC,0x9BEC,0xDBEC,
 0x2BEC,0x6BEC,0xABEC,0xEBEC,0x3BEC,0x7BEC,0xBBEC,0xFBEC,
 0x0FEC,0x4FEC,0x8FEC,0xCFEC,0x1FEC,0x5FEC,0x9FEC,0xDFEC,
 0x2FEC,0x6FEC,0xAFEC,0xEFEC,0x3FEC,0x7FEC,0xBFEC,0xFFEC,
 0x003C,0x403C,0x803C,0xC03C,0x103C,0x503C,0x903C,0xD03C,
 0x203C,0x603C,0xA03C,0xE03C,0x303C,0x703C,0xB03C,0xF03C,
 0x043C,0x443C,0x843C,0xC43C,0x143C,0x543C,0x943C,0xD43C,
 0x243C,0x643C,0xA43C,0xE43C,0x343C,0x743C,0xB43C,0xF43C,
 0x083C,0x483C,0x883C,0xC83C,0x183C,0x583C,0x983C,0xD83C,
 0x283C,0x683C,0xA83C,0xE83C,0x383C,0x783C,0xB83C,0xF83C,
 0x0C3C,0x4C3C,0x8C3C,0xCC3C,0x1C3C,0x5C3C,0x9C3C,0xDC3C,
 0x2C3C,0x6C3C,0xAC3C,0xEC3C,0x3C3C,0x7C3C,0xBC3C,0xFC3C,
 0x013C,0x413C,0x813C,0xC13C,0x113C,0x513C,0x913C,0xD13C,
 0x213C,0x613C,0xA13C,0xE13C,0x313C,0x713C,0xB13C,0xF13C,
 0x053C,0x453C,0x853C,0xC53C,0x153C,0x553C,0x953C,0xD53C,
 0x253C,0x653C,0xA53C,0xE53C,0x353C,0x753C,0xB53C,0xF53C,
 0x093C,0x493C,0x893C,0xC93C,0x193C,0x593C,0x993C,0xD93C,
 0x293C,0x693C,0xA93C,0xE93C,0x393C,0x793C,0xB93C,0xF93C,
 0x0D3C,0x4D3C,0x8D3C,0xCD3C,0x1D3C,0x5D3C,0x9D3C,0xDD3C,
 0x2D3C,0x6D3C,0xAD3C,0xED3C,0x3D3C,0x7D3C,0xBD3C,0xFD3C,
 0x023C,0x423C,0x823C,0xC23C,0x123C,0x523C,0x923C,0xD23C,
 0x223C,0x623C,0xA23C,0xE23C,0x323C,0x723C,0xB23C,0xF23C,
 0x063C,0x463C,0x863C,0xC63C,0x163C,0x563C,0x963C,0xD63C,
 0x263C,0x663C,0xA63C,0xE63C,0x363C,0x763C,0xB63C,0xF63C,
 0x0A3C,0x4A3C,0x8A3C,0xCA3C,0x1A3C,0x5A3C,0x9A3C,0xDA3C,
 0x2A3C,0x6A3C,0xAA3C,0xEA3C,0x3A3C,0x7A3C,0xBA3C,0xFA3C,
 0x0E3C,0x4E3C,0x8E3C,0xCE3C,0x1E3C,0x5E3C,0x9E3C,0xDE3C,
 0x2E3C,0x6E3C,0xAE3C,0xEE3C,0x3E3C,0x7E3C,0xBE3C,0xFE3C,
 0x033C,0x433C,0x833C,0xC33C,0x133C,0x533C,0x933C,0xD33C,
 0x233C,0x633C,0xA33C,0xE33C,0x333C,0x733C,0xB33C,0xF33C,
 0x073C,0x473C,0x873C,0xC73C,0x173C,0x573C,0x973C,0xD73C,
 0x273C,0x673C,0xA73C,0xE73C,0x373C,0x773C,0xB73C,0xF73C,
 0x0B3C,0x4B3C,0x8B3C,0xCB3C,0x1B3C,0x5B3C,0x9B3C,0xDB3C,
 0x2B3C,0x6B3C,0xAB3C,0xEB3C,0x3B3C,0x7B3C,0xBB3C,0xFB3C,
 0x0F3C,0x4F3C,0x8F3C,0xCF3C,0x1F3C,0x5F3C,0x9F3C,0xDF3C,
 0x2F3C,0x6F3C,0xAF3C,0xEF3C,0x3F3C,0x7F3C,0xBF3C,0xFF3C,
 0x007C,0x407C,0x807C,0xC07C,0x107C,0x507C,0x907C,0xD07C,
 0x207C,0x607C,0xA07C,0xE07C,0x307C,0x707C,0xB07C,0xF07C,
 0x047C,0x447C,0x847C,0xC47C,0x147C,0x547C,0x947C,0xD47C,
 0x247C,0x647C,0xA47C,0xE47C,0x347C,0x747C,0xB47C,0xF47C,
 0x087C,0x487C,0x887C,0xC87C,0x187C,0x587C,0x987C,0xD87C,
 0x287C,0x687C,0xA87C,0xE87C,0x387C,0x787C,0xB87C,0xF87C,
 0x0C7C,0x4C7C,0x8C7C,0xCC7C,0x1C7C,0x5C7C,0x9C7C,0xDC7C,
 0x2C7C,0x6C7C,0xAC7C,0xEC7C,0x3C7C,0x7C7C,0xBC7C,0xFC7C,
 0x017C,0x417C,0x817C,0xC17C,0x117C,0x517C,0x917C,0xD17C,
 0x217C,0x617C,0xA17C,0xE17C,0x317C,0x717C,0xB17C,0xF17C,
 0x057C,0x457C,0x857C,0xC57C,0x157C,0x557C,0x957C,0xD57C,
 0x257C,0x657C,0xA57C,0xE57C,0x357C,0x757C,0xB57C,0xF57C,
 0x097C,0x497C,0x897C,0xC97C,0x197C,0x597C,0x997C,0xD97C,
 0x297C,0x697C,0xA97C,0xE97C,0x397C,0x797C,0xB97C,0xF97C,
 0x0D7C,0x4D7C,0x8D7C,0xCD7C,0x1D7C,0x5D7C,0x9D7C,0xDD7C,
 0x2D7C,0x6D7C,0xAD7C,0xED7C,0x3D7C,0x7D7C,0xBD7C,0xFD7C,
 0x027C,0x427C,0x827C,0xC27C,0x127C,0x527C,0x927C,0xD27C,
 0x227C,0x627C,0xA27C,0xE27C,0x327C,0x727C,0xB27C,0xF27C,
 0x067C,0x467C,0x867C,0xC67C,0x167C,0x567C,0x967C,0xD67C,
 0x267C,0x667C,0xA67C,0xE67C,0x367C,0x767C,0xB67C,0xF67C,
 0x0A7C,0x4A7C,0x8A7C,0xCA7C,0x1A7C,0x5A7C,0x9A7C,0xDA7C,
 0x2A7C,0x6A7C,0xAA7C,0xEA7C,0x3A7C,0x7A7C,0xBA7C,0xFA7C,
 0x0E7C,0x4E7C,0x8E7C,0xCE7C,0x1E7C,0x5E7C,0x9E7C,0xDE7C,
 0x2E7C,0x6E7C,0xAE7C,0xEE7C,0x3E7C,0x7E7C,0xBE7C,0xFE7C,
 0x037C,0x437C,0x837C,0xC37C,0x137C,0x537C,0x937C,0xD37C,
 0x237C,0x637C,0xA37C,0xE37C,0x337C,0x737C,0xB37C,0xF37C,
 0x077C,0x477C,0x877C,0xC77C,0x177C,0x577C,0x977C,0xD77C,
 0x277C,0x677C,0xA77C,0xE77C,0x377C,0x777C,0xB77C,0xF77C,
 0x0B7C,0x4B7C,0x8B7C,0xCB7C,0x1B7C,0x5B7C,0x9B7C,0xDB7C,
 0x2B7C,0x6B7C,0xAB7C,0xEB7C,0x3B7C,0x7B7C,0xBB7C,0xFB7C,
 0x0F7C,0x4F7C,0x8F7C,0xCF7C,0x1F7C,0x5F7C,0x9F7C,0xDF7C,
 0x2F7C,0x6F7C,0xAF7C,0xEF7C,0x3F7C,0x7F7C,0xBF7C,0xFF7C,
 0x00BC,0x40BC,0x80BC,0xC0BC,0x10BC,0x50BC,0x90BC,0xD0BC,
 0x20BC,0x60BC,0xA0BC,0xE0BC,0x30BC,0x70BC,0xB0BC,0xF0BC,
 0x04BC,0x44BC,0x84BC,0xC4BC,0x14BC,0x54BC,0x94BC,0xD4BC,
 0x24BC,0x64BC,0xA4BC,0xE4BC,0x34BC,0x74BC,0xB4BC,0xF4BC,
 0x08BC,0x48BC,0x88BC,0xC8BC,0x18BC,0x58BC,0x98BC,0xD8BC,
 0x28BC,0x68BC,0xA8BC,0xE8BC,0x38BC,0x78BC,0xB8BC,0xF8BC,
 0x0CBC,0x4CBC,0x8CBC,0xCCBC,0x1CBC,0x5CBC,0x9CBC,0xDCBC,
 0x2CBC,0x6CBC,0xACBC,0xECBC,0x3CBC,0x7CBC,0xBCBC,0xFCBC,
 0x01BC,0x41BC,0x81BC,0xC1BC,0x11BC,0x51BC,0x91BC,0xD1BC,
 0x21BC,0x61BC,0xA1BC,0xE1BC,0x31BC,0x71BC,0xB1BC,0xF1BC,
 0x05BC,0x45BC,0x85BC,0xC5BC,0x15BC,0x55BC,0x95BC,0xD5BC,
 0x25BC,0x65BC,0xA5BC,0xE5BC,0x35BC,0x75BC,0xB5BC,0xF5BC,
 0x09BC,0x49BC,0x89BC,0xC9BC,0x19BC,0x59BC,0x99BC,0xD9BC,
 0x29BC,0x69BC,0xA9BC,0xE9BC,0x39BC,0x79BC,0xB9BC,0xF9BC,
 0x0DBC,0x4DBC,0x8DBC,0xCDBC,0x1DBC,0x5DBC,0x9DBC,0xDDBC,
 0x2DBC,0x6DBC,0xADBC,0xEDBC,0x3DBC,0x7DBC,0xBDBC,0xFDBC,
 0x02BC,0x42BC,0x82BC,0xC2BC,0x12BC,0x52BC,0x92BC,0xD2BC,
 0x22BC,0x62BC,0xA2BC,0xE2BC,0x32BC,0x72BC,0xB2BC,0xF2BC,
 0x06BC,0x46BC,0x86BC,0xC6BC,0x16BC,0x56BC,0x96BC,0xD6BC,
 0x26BC,0x66BC,0xA6BC,0xE6BC,0x36BC,0x76BC,0xB6BC,0xF6BC,
 0x0ABC,0x4ABC,0x8ABC,0xCABC,0x1ABC,0x5ABC,0x9ABC,0xDABC,
 0x2ABC,0x6ABC,0xAABC,0xEABC,0x3ABC,0x7ABC,0xBABC,0xFABC,
 0x0EBC,0x4EBC,0x8EBC,0xCEBC,0x1EBC,0x5EBC,0x9EBC,0xDEBC,
 0x2EBC,0x6EBC,0xAEBC,0xEEBC,0x3EBC,0x7EBC,0xBEBC,0xFEBC,
 0x03BC,0x43BC,0x83BC,0xC3BC,0x13BC,0x53BC,0x93BC,0xD3BC,
 0x23BC,0x63BC,0xA3BC,0xE3BC,0x33BC,0x73BC,0xB3BC,0xF3BC,
 0x07BC,0x47BC,0x87BC,0xC7BC,0x17BC,0x57BC,0x97BC,0xD7BC,
 0x27BC,0x67BC,0xA7BC,0xE7BC,0x37BC,0x77BC,0xB7BC,0xF7BC,
 0x0BBC,0x4BBC,0x8BBC,0xCBBC,0x1BBC,0x5BBC,0x9BBC,0xDBBC,
 0x2BBC,0x6BBC,0xABBC,0xEBBC,0x3BBC,0x7BBC,0xBBBC,0xFBBC,
 0x0FBC,0x4FBC,0x8FBC,0xCFBC,0x1FBC,0x5FBC,0x9FBC,0xDFBC,
 0x2FBC,0x6FBC,0xAFBC,0xEFBC,0x3FBC,0x7FBC,0xBFBC,0xFFBC,
 0x00FC,0x40FC,0x80FC,0xC0FC,0x10FC,0x50FC,0x90FC,0xD0FC,
 0x20FC,0x60FC,0xA0FC,0xE0FC,0x30FC,0x70FC,0xB0FC,0xF0FC,
 0x04FC,0x44FC,0x84FC,0xC4FC,0x14FC,0x54FC,0x94FC,0xD4FC,
 0x24FC,0x64FC,0xA4FC,0xE4FC,0x34FC,0x74FC,0xB4FC,0xF4FC,
 0x08FC,0x48FC,0x88FC,0xC8FC,0x18FC,0x58FC,0x98FC,0xD8FC,
 0x28FC,0x68FC,0xA8FC,0xE8FC,0x38FC,0x78FC,0xB8FC,0xF8FC,
 0x0CFC,0x4CFC,0x8CFC,0xCCFC,0x1CFC,0x5CFC,0x9CFC,0xDCFC,
 0x2CFC,0x6CFC,0xACFC,0xECFC,0x3CFC,0x7CFC,0xBCFC,0xFCFC,
 0x01FC,0x41FC,0x81FC,0xC1FC,0x11FC,0x51FC,0x91FC,0xD1FC,
 0x21FC,0x61FC,0xA1FC,0xE1FC,0x31FC,0x71FC,0xB1FC,0xF1FC,
 0x05FC,0x45FC,0x85FC,0xC5FC,0x15FC,0x55FC,0x95FC,0xD5FC,
 0x25FC,0x65FC,0xA5FC,0xE5FC,0x35FC,0x75FC,0xB5FC,0xF5FC,
 0x09FC,0x49FC,0x89FC,0xC9FC,0x19FC,0x59FC,0x99FC,0xD9FC,
 0x29FC,0x69FC,0xA9FC,0xE9FC,0x39FC,0x79FC,0xB9FC,0xF9FC,
 0x0DFC,0x4DFC,0x8DFC,0xCDFC,0x1DFC,0x5DFC,0x9DFC,0xDDFC,
 0x2DFC,0x6DFC,0xADFC,0xEDFC,0x3DFC,0x7DFC,0xBDFC,0xFDFC,
 0x02FC,0x42FC,0x82FC,0xC2FC,0x12FC,0x52FC,0x92FC,0xD2FC,
 0x22FC,0x62FC,0xA2FC,0xE2FC,0x32FC,0x72FC,0xB2FC,0xF2FC,
 0x06FC,0x46FC,0x86FC,0xC6FC,0x16FC,0x56FC,0x96FC,0xD6FC,
 0x26FC,0x66FC,0xA6FC,0xE6FC,0x36FC,0x76FC,0xB6FC,0xF6FC,
 0x0AFC,0x4AFC,0x8AFC,0xCAFC,0x1AFC,0x5AFC,0x9AFC,0xDAFC,
 0x2AFC,0x6AFC,0xAAFC,0xEAFC,0x3AFC,0x7AFC,0xBAFC,0xFAFC,
 0x0EFC,0x4EFC,0x8EFC,0xCEFC,0x1EFC,0x5EFC,0x9EFC,0xDEFC,
 0x2EFC,0x6EFC,0xAEFC,0xEEFC,0x3EFC,0x7EFC,0xBEFC,0xFEFC,
 0x03FC,0x43FC,0x83FC,0xC3FC,0x13FC,0x53FC,0x93FC,0xD3FC,
 0x23FC,0x63FC,0xA3FC,0xE3FC,0x33FC,0x73FC,0xB3FC,0xF3FC,
 0x07FC,0x47FC,0x87FC,0xC7FC,0x17FC,0x57FC,0x97FC,0xD7FC,
 0x27FC,0x67FC,0xA7FC,0xE7FC,0x37FC,0x77FC,0xB7FC,0xF7FC,
 0x0BFC,0x4BFC,0x8BFC,0xCBFC,0x1BFC,0x5BFC,0x9BFC,0xDBFC,
 0x2BFC,0x6BFC,0xABFC,0xEBFC,0x3BFC,0x7BFC,0xBBFC,0xFBFC,
 0x0FFC,0x4FFC,0x8FFC,0xCFFC,0x1FFC,0x5FFC,0x9FFC,0xDFFC,
 0x2FFC,0x6FFC,0xAFFC,0xEFFC,0x3FFC,0x7FFC,0xBFFC,0xFFFC,
 0x0001,0x4001,0x8001,0xC001,0x1001,0x5001,0x9001,0xD001,
 0x2001,0x6001,0xA001,0xE001,0x3001,0x7001,0xB001,0xF001,
 0x0401,0x4401,0x8401,0xC401,0x1401,0x5401,0x9401,0xD401,
 0x2401,0x6401,0xA401,0xE401,0x3401,0x7401,0xB401,0xF401,
 0x0801,0x4801,0x8801,0xC801,0x1801,0x5801,0x9801,0xD801,
 0x2801,0x6801,0xA801,0xE801,0x3801,0x7801,0xB801,0xF801,
 0x0C01,0x4C01,0x8C01,0xCC01,0x1C01,0x5C01,0x9C01,0xDC01,
 0x2C01,0x6C01,0xAC01,0xEC01,0x3C01,0x7C01,0xBC01,0xFC01,
 0x0101,0x4101,0x8101,0xC101,0x1101,0x5101,0x9101,0xD101,
 0x2101,0x6101,0xA101,0xE101,0x3101,0x7101,0xB101,0xF101,
 0x0501,0x4501,0x8501,0xC501,0x1501,0x5501,0x9501,0xD501,
 0x2501,0x6501,0xA501,0xE501,0x3501,0x7501,0xB501,0xF501,
 0x0901,0x4901,0x8901,0xC901,0x1901,0x5901,0x9901,0xD901,
 0x2901,0x6901,0xA901,0xE901,0x3901,0x7901,0xB901,0xF901,
 0x0D01,0x4D01,0x8D01,0xCD01,0x1D01,0x5D01,0x9D01,0xDD01,
 0x2D01,0x6D01,0xAD01,0xED01,0x3D01,0x7D01,0xBD01,0xFD01,
 0x0201,0x4201,0x8201,0xC201,0x1201,0x5201,0x9201,0xD201,
 0x2201,0x6201,0xA201,0xE201,0x3201,0x7201,0xB201,0xF201,
 0x0601,0x4601,0x8601,0xC601,0x1601,0x5601,0x9601,0xD601,
 0x2601,0x6601,0xA601,0xE601,0x3601,0x7601,0xB601,0xF601,
 0x0A01,0x4A01,0x8A01,0xCA01,0x1A01,0x5A01,0x9A01,0xDA01,
 0x2A01,0x6A01,0xAA01,0xEA01,0x3A01,0x7A01,0xBA01,0xFA01,
 0x0E01,0x4E01,0x8E01,0xCE01,0x1E01,0x5E01,0x9E01,0xDE01,
 0x2E01,0x6E01,0xAE01,0xEE01,0x3E01,0x7E01,0xBE01,0xFE01,
 0x0301,0x4301,0x8301,0xC301,0x1301,0x5301,0x9301,0xD301,
 0x2301,0x6301,0xA301,0xE301,0x3301,0x7301,0xB301,0xF301,
 0x0701,0x4701,0x8701,0xC701,0x1701,0x5701,0x9701,0xD701,
 0x2701,0x6701,0xA701,0xE701,0x3701,0x7701,0xB701,0xF701,
 0x0B01,0x4B01,0x8B01,0xCB01,0x1B01,0x5B01,0x9B01,0xDB01,
 0x2B01,0x6B01,0xAB01,0xEB01,0x3B01,0x7B01,0xBB01,0xFB01,
 0x0F01,0x4F01,0x8F01,0xCF01,0x1F01,0x5F01,0x9F01,0xDF01,
 0x2F01,0x6F01,0xAF01,0xEF01,0x3F01,0x7F01,0xBF01,0xFF01,
 0x0041,0x4041,0x8041,0xC041,0x1041,0x5041,0x9041,0xD041,
 0x2041,0x6041,0xA041,0xE041,0x3041,0x7041,0xB041,0xF041,
 0x0441,0x4441,0x8441,0xC441,0x1441,0x5441,0x9441,0xD441,
 0x2441,0x6441,0xA441,0xE441,0x3441,0x7441,0xB441,0xF441,
 0x0841,0x4841,0x8841,0xC841,0x1841,0x5841,0x9841,0xD841,
 0x2841,0x6841,0xA841,0xE841,0x3841,0x7841,0xB841,0xF841,
 0x0C41,0x4C41,0x8C41,0xCC41,0x1C41,0x5C41,0x9C41,0xDC41,
 0x2C41,0x6C41,0xAC41,0xEC41,0x3C41,0x7C41,0xBC41,0xFC41,
 0x0141,0x4141,0x8141,0xC141,0x1141,0x5141,0x9141,0xD141,
 0x2141,0x6141,0xA141,0xE141,0x3141,0x7141,0xB141,0xF141,
 0x0541,0x4541,0x8541,0xC541,0x1541,0x5541,0x9541,0xD541,
 0x2541,0x6541,0xA541,0xE541,0x3541,0x7541,0xB541,0xF541,
 0x0941,0x4941,0x8941,0xC941,0x1941,0x5941,0x9941,0xD941,
 0x2941,0x6941,0xA941,0xE941,0x3941,0x7941,0xB941,0xF941,
 0x0D41,0x4D41,0x8D41,0xCD41,0x1D41,0x5D41,0x9D41,0xDD41,
 0x2D41,0x6D41,0xAD41,0xED41,0x3D41,0x7D41,0xBD41,0xFD41,
 0x0241,0x4241,0x8241,0xC241,0x1241,0x5241,0x9241,0xD241,
 0x2241,0x6241,0xA241,0xE241,0x3241,0x7241,0xB241,0xF241,
 0x0641,0x4641,0x8641,0xC641,0x1641,0x5641,0x9641,0xD641,
 0x2641,0x6641,0xA641,0xE641,0x3641,0x7641,0xB641,0xF641,
 0x0A41,0x4A41,0x8A41,0xCA41,0x1A41,0x5A41,0x9A41,0xDA41,
 0x2A41,0x6A41,0xAA41,0xEA41,0x3A41,0x7A41,0xBA41,0xFA41,
 0x0E41,0x4E41,0x8E41,0xCE41,0x1E41,0x5E41,0x9E41,0xDE41,
 0x2E41,0x6E41,0xAE41,0xEE41,0x3E41,0x7E41,0xBE41,0xFE41,
 0x0341,0x4341,0x8341,0xC341,0x1341,0x5341,0x9341,0xD341,
 0x2341,0x6341,0xA341,0xE341,0x3341,0x7341,0xB341,0xF341,
 0x0741,0x4741,0x8741,0xC741,0x1741,0x5741,0x9741,0xD741,
 0x2741,0x6741,0xA741,0xE741,0x3741,0x7741,0xB741,0xF741,
 0x0B41,0x4B41,0x8B41,0xCB41,0x1B41,0x5B41,0x9B41,0xDB41,
 0x2B41,0x6B41,0xAB41,0xEB41,0x3B41,0x7B41,0xBB41,0xFB41,
 0x0F41,0x4F41,0x8F41,0xCF41,0x1F41,0x5F41,0x9F41,0xDF41,
 0x2F41,0x6F41,0xAF41,0xEF41,0x3F41,0x7F41,0xBF41,0xFF41,
 0x0081,0x4081,0x8081,0xC081,0x1081,0x5081,0x9081,0xD081,
 0x2081,0x6081,0xA081,0xE081,0x3081,0x7081,0xB081,0xF081,
 0x0481,0x4481,0x8481,0xC481,0x1481,0x5481,0x9481,0xD481,
 0x2481,0x6481,0xA481,0xE481,0x3481,0x7481,0xB481,0xF481,
 0x0881,0x4881,0x8881,0xC881,0x1881,0x5881,0x9881,0xD881,
 0x2881,0x6881,0xA881,0xE881,0x3881,0x7881,0xB881,0xF881,
 0x0C81,0x4C81,0x8C81,0xCC81,0x1C81,0x5C81,0x9C81,0xDC81,
 0x2C81,0x6C81,0xAC81,0xEC81,0x3C81,0x7C81,0xBC81,0xFC81,
 0x0181,0x4181,0x8181,0xC181,0x1181,0x5181,0x9181,0xD181,
 0x2181,0x6181,0xA181,0xE181,0x3181,0x7181,0xB181,0xF181,
 0x0581,0x4581,0x8581,0xC581,0x1581,0x5581,0x9581,0xD581,
 0x2581,0x6581,0xA581,0xE581,0x3581,0x7581,0xB581,0xF581,
 0x0981,0x4981,0x8981,0xC981,0x1981,0x5981,0x9981,0xD981,
 0x2981,0x6981,0xA981,0xE981,0x3981,0x7981,0xB981,0xF981,
 0x0D81,0x4D81,0x8D81,0xCD81,0x1D81,0x5D81,0x9D81,0xDD81,
 0x2D81,0x6D81,0xAD81,0xED81,0x3D81,0x7D81,0xBD81,0xFD81,
 0x0281,0x4281,0x8281,0xC281,0x1281,0x5281,0x9281,0xD281,
 0x2281,0x6281,0xA281,0xE281,0x3281,0x7281,0xB281,0xF281,
 0x0681,0x4681,0x8681,0xC681,0x1681,0x5681,0x9681,0xD681,
 0x2681,0x6681,0xA681,0xE681,0x3681,0x7681,0xB681,0xF681,
 0x0A81,0x4A81,0x8A81,0xCA81,0x1A81,0x5A81,0x9A81,0xDA81,
 0x2A81,0x6A81,0xAA81,0xEA81,0x3A81,0x7A81,0xBA81,0xFA81,
 0x0E81,0x4E81,0x8E81,0xCE81,0x1E81,0x5E81,0x9E81,0xDE81,
 0x2E81,0x6E81,0xAE81,0xEE81,0x3E81,0x7E81,0xBE81,0xFE81,
 0x0381,0x4381,0x8381,0xC381,0x1381,0x5381,0x9381,0xD381,
 0x2381,0x6381,0xA381,0xE381,0x3381,0x7381,0xB381,0xF381,
 0x0781,0x4781,0x8781,0xC781,0x1781,0x5781,0x9781,0xD781,
 0x2781,0x6781,0xA781,0xE781,0x3781,0x7781,0xB781,0xF781,
 0x0B81,0x4B81,0x8B81,0xCB81,0x1B81,0x5B81,0x9B81,0xDB81,
 0x2B81,0x6B81,0xAB81,0xEB81,0x3B81,0x7B81,0xBB81,0xFB81,
 0x0F81,0x4F81,0x8F81,0xCF81,0x1F81,0x5F81,0x9F81,0xDF81,
 0x2F81,0x6F81,0xAF81,0xEF81,0x3F81,0x7F81,0xBF81,0xFF81,
 0x00C1,0x40C1,0x80C1,0xC0C1,0x10C1,0x50C1,0x90C1,0xD0C1,
 0x20C1,0x60C1,0xA0C1,0xE0C1,0x30C1,0x70C1,0xB0C1,0xF0C1,
 0x04C1,0x44C1,0x84C1,0xC4C1,0x14C1,0x54C1,0x94C1,0xD4C1,
 0x24C1,0x64C1,0xA4C1,0xE4C1,0x34C1,0x74C1,0xB4C1,0xF4C1,
 0x08C1,0x48C1,0x88C1,0xC8C1,0x18C1,0x58C1,0x98C1,0xD8C1,
 0x28C1,0x68C1,0xA8C1,0xE8C1,0x38C1,0x78C1,0xB8C1,0xF8C1,
 0x0CC1,0x4CC1,0x8CC1,0xCCC1,0x1CC1,0x5CC1,0x9CC1,0xDCC1,
 0x2CC1,0x6CC1,0xACC1,0xECC1,0x3CC1,0x7CC1,0xBCC1,0xFCC1,
 0x01C1,0x41C1,0x81C1,0xC1C1,0x11C1,0x51C1,0x91C1,0xD1C1,
 0x21C1,0x61C1,0xA1C1,0xE1C1,0x31C1,0x71C1,0xB1C1,0xF1C1,
 0x05C1,0x45C1,0x85C1,0xC5C1,0x15C1,0x55C1,0x95C1,0xD5C1,
 0x25C1,0x65C1,0xA5C1,0xE5C1,0x35C1,0x75C1,0xB5C1,0xF5C1,
 0x09C1,0x49C1,0x89C1,0xC9C1,0x19C1,0x59C1,0x99C1,0xD9C1,
 0x29C1,0x69C1,0xA9C1,0xE9C1,0x39C1,0x79C1,0xB9C1,0xF9C1,
 0x0DC1,0x4DC1,0x8DC1,0xCDC1,0x1DC1,0x5DC1,0x9DC1,0xDDC1,
 0x2DC1,0x6DC1,0xADC1,0xEDC1,0x3DC1,0x7DC1,0xBDC1,0xFDC1,
 0x02C1,0x42C1,0x82C1,0xC2C1,0x12C1,0x52C1,0x92C1,0xD2C1,
 0x22C1,0x62C1,0xA2C1,0xE2C1,0x32C1,0x72C1,0xB2C1,0xF2C1,
 0x06C1,0x46C1,0x86C1,0xC6C1,0x16C1,0x56C1,0x96C1,0xD6C1,
 0x26C1,0x66C1,0xA6C1,0xE6C1,0x36C1,0x76C1,0xB6C1,0xF6C1,
 0x0AC1,0x4AC1,0x8AC1,0xCAC1,0x1AC1,0x5AC1,0x9AC1,0xDAC1,
 0x2AC1,0x6AC1,0xAAC1,0xEAC1,0x3AC1,0x7AC1,0xBAC1,0xFAC1,
 0x0EC1,0x4EC1,0x8EC1,0xCEC1,0x1EC1,0x5EC1,0x9EC1,0xDEC1,
 0x2EC1,0x6EC1,0xAEC1,0xEEC1,0x3EC1,0x7EC1,0xBEC1,0xFEC1,
 0x03C1,0x43C1,0x83C1,0xC3C1,0x13C1,0x53C1,0x93C1,0xD3C1,
 0x23C1,0x63C1,0xA3C1,0xE3C1,0x33C1,0x73C1,0xB3C1,0xF3C1,
 0x07C1,0x47C1,0x87C1,0xC7C1,0x17C1,0x57C1,0x97C1,0xD7C1,
 0x27C1,0x67C1,0xA7C1,0xE7C1,0x37C1,0x77C1,0xB7C1,0xF7C1,
 0x0BC1,0x4BC1,0x8BC1,0xCBC1,0x1BC1,0x5BC1,0x9BC1,0xDBC1,
 0x2BC1,0x6BC1,0xABC1,0xEBC1,0x3BC1,0x7BC1,0xBBC1,0xFBC1,
 0x0FC1,0x4FC1,0x8FC1,0xCFC1,0x1FC1,0x5FC1,0x9FC1,0xDFC1,
 0x2FC1,0x6FC1,0xAFC1,0xEFC1,0x3FC1,0x7FC1,0xBFC1,0xFFC1,
 0x0011,0x4011,0x8011,0xC011,0x1011,0x5011,0x9011,0xD011,
 0x2011,0x6011,0xA011,0xE011,0x3011,0x7011,0xB011,0xF011,
 0x0411,0x4411,0x8411,0xC411,0x1411,0x5411,0x9411,0xD411,
 0x2411,0x6411,0xA411,0xE411,0x3411,0x7411,0xB411,0xF411,
 0x0811,0x4811,0x8811,0xC811,0x1811,0x5811,0x9811,0xD811,
 0x2811,0x6811,0xA811,0xE811,0x3811,0x7811,0xB811,0xF811,
 0x0C11,0x4C11,0x8C11,0xCC11,0x1C11,0x5C11,0x9C11,0xDC11,
 0x2C11,0x6C11,0xAC11,0xEC11,0x3C11,0x7C11,0xBC11,0xFC11,
 0x0111,0x4111,0x8111,0xC111,0x1111,0x5111,0x9111,0xD111,
 0x2111,0x6111,0xA111,0xE111,0x3111,0x7111,0xB111,0xF111,
 0x0511,0x4511,0x8511,0xC511,0x1511,0x5511,0x9511,0xD511,
 0x2511,0x6511,0xA511,0xE511,0x3511,0x7511,0xB511,0xF511,
 0x0911,0x4911,0x8911,0xC911,0x1911,0x5911,0x9911,0xD911,
 0x2911,0x6911,0xA911,0xE911,0x3911,0x7911,0xB911,0xF911,
 0x0D11,0x4D11,0x8D11,0xCD11,0x1D11,0x5D11,0x9D11,0xDD11,
 0x2D11,0x6D11,0xAD11,0xED11,0x3D11,0x7D11,0xBD11,0xFD11,
 0x0211,0x4211,0x8211,0xC211,0x1211,0x5211,0x9211,0xD211,
 0x2211,0x6211,0xA211,0xE211,0x3211,0x7211,0xB211,0xF211,
 0x0611,0x4611,0x8611,0xC611,0x1611,0x5611,0x9611,0xD611,
 0x2611,0x6611,0xA611,0xE611,0x3611,0x7611,0xB611,0xF611,
 0x0A11,0x4A11,0x8A11,0xCA11,0x1A11,0x5A11,0x9A11,0xDA11,
 0x2A11,0x6A11,0xAA11,0xEA11,0x3A11,0x7A11,0xBA11,0xFA11,
 0x0E11,0x4E11,0x8E11,0xCE11,0x1E11,0x5E11,0x9E11,0xDE11,
 0x2E11,0x6E11,0xAE11,0xEE11,0x3E11,0x7E11,0xBE11,0xFE11,
 0x0311,0x4311,0x8311,0xC311,0x1311,0x5311,0x9311,0xD311,
 0x2311,0x6311,0xA311,0xE311,0x3311,0x7311,0xB311,0xF311,
 0x0711,0x4711,0x8711,0xC711,0x1711,0x5711,0x9711,0xD711,
 0x2711,0x6711,0xA711,0xE711,0x3711,0x7711,0xB711,0xF711,
 0x0B11,0x4B11,0x8B11,0xCB11,0x1B11,0x5B11,0x9B11,0xDB11,
 0x2B11,0x6B11,0xAB11,0xEB11,0x3B11,0x7B11,0xBB11,0xFB11,
 0x0F11,0x4F11,0x8F11,0xCF11,0x1F11,0x5F11,0x9F11,0xDF11,
 0x2F11,0x6F11,0xAF11,0xEF11,0x3F11,0x7F11,0xBF11,0xFF11,
 0x0051,0x4051,0x8051,0xC051,0x1051,0x5051,0x9051,0xD051,
 0x2051,0x6051,0xA051,0xE051,0x3051,0x7051,0xB051,0xF051,
 0x0451,0x4451,0x8451,0xC451,0x1451,0x5451,0x9451,0xD451,
 0x2451,0x6451,0xA451,0xE451,0x3451,0x7451,0xB451,0xF451,
 0x0851,0x4851,0x8851,0xC851,0x1851,0x5851,0x9851,0xD851,
 0x2851,0x6851,0xA851,0xE851,0x3851,0x7851,0xB851,0xF851,
 0x0C51,0x4C51,0x8C51,0xCC51,0x1C51,0x5C51,0x9C51,0xDC51,
 0x2C51,0x6C51,0xAC51,0xEC51,0x3C51,0x7C51,0xBC51,0xFC51,
 0x0151,0x4151,0x8151,0xC151,0x1151,0x5151,0x9151,0xD151,
 0x2151,0x6151,0xA151,0xE151,0x3151,0x7151,0xB151,0xF151,
 0x0551,0x4551,0x8551,0xC551,0x1551,0x5551,0x9551,0xD551,
 0x2551,0x6551,0xA551,0xE551,0x3551,0x7551,0xB551,0xF551,
 0x0951,0x4951,0x8951,0xC951,0x1951,0x5951,0x9951,0xD951,
 0x2951,0x6951,0xA951,0xE951,0x3951,0x7951,0xB951,0xF951,
 0x0D51,0x4D51,0x8D51,0xCD51,0x1D51,0x5D51,0x9D51,0xDD51,
 0x2D51,0x6D51,0xAD51,0xED51,0x3D51,0x7D51,0xBD51,0xFD51,
 0x0251,0x4251,0x8251,0xC251,0x1251,0x5251,0x9251,0xD251,
 0x2251,0x6251,0xA251,0xE251,0x3251,0x7251,0xB251,0xF251,
 0x0651,0x4651,0x8651,0xC651,0x1651,0x5651,0x9651,0xD651,
 0x2651,0x6651,0xA651,0xE651,0x3651,0x7651,0xB651,0xF651,
 0x0A51,0x4A51,0x8A51,0xCA51,0x1A51,0x5A51,0x9A51,0xDA51,
 0x2A51,0x6A51,0xAA51,0xEA51,0x3A51,0x7A51,0xBA51,0xFA51,
 0x0E51,0x4E51,0x8E51,0xCE51,0x1E51,0x5E51,0x9E51,0xDE51,
 0x2E51,0x6E51,0xAE51,0xEE51,0x3E51,0x7E51,0xBE51,0xFE51,
 0x0351,0x4351,0x8351,0xC351,0x1351,0x5351,0x9351,0xD351,
 0x2351,0x6351,0xA351,0xE351,0x3351,0x7351,0xB351,0xF351,
 0x0751,0x4751,0x8751,0xC751,0x1751,0x5751,0x9751,0xD751,
 0x2751,0x6751,0xA751,0xE751,0x3751,0x7751,0xB751,0xF751,
 0x0B51,0x4B51,0x8B51,0xCB51,0x1B51,0x5B51,0x9B51,0xDB51,
 0x2B51,0x6B51,0xAB51,0xEB51,0x3B51,0x7B51,0xBB51,0xFB51,
 0x0F51,0x4F51,0x8F51,0xCF51,0x1F51,0x5F51,0x9F51,0xDF51,
 0x2F51,0x6F51,0xAF51,0xEF51,0x3F51,0x7F51,0xBF51,0xFF51,
 0x0091,0x4091,0x8091,0xC091,0x1091,0x5091,0x9091,0xD091,
 0x2091,0x6091,0xA091,0xE091,0x3091,0x7091,0xB091,0xF091,
 0x0491,0x4491,0x8491,0xC491,0x1491,0x5491,0x9491,0xD491,
 0x2491,0x6491,0xA491,0xE491,0x3491,0x7491,0xB491,0xF491,
 0x0891,0x4891,0x8891,0xC891,0x1891,0x5891,0x9891,0xD891,
 0x2891,0x6891,0xA891,0xE891,0x3891,0x7891,0xB891,0xF891,
 0x0C91,0x4C91,0x8C91,0xCC91,0x1C91,0x5C91,0x9C91,0xDC91,
 0x2C91,0x6C91,0xAC91,0xEC91,0x3C91,0x7C91,0xBC91,0xFC91,
 0x0191,0x4191,0x8191,0xC191,0x1191,0x5191,0x9191,0xD191,
 0x2191,0x6191,0xA191,0xE191,0x3191,0x7191,0xB191,0xF191,
 0x0591,0x4591,0x8591,0xC591,0x1591,0x5591,0x9591,0xD591,
 0x2591,0x6591,0xA591,0xE591,0x3591,0x7591,0xB591,0xF591,
 0x0991,0x4991,0x8991,0xC991,0x1991,0x5991,0x9991,0xD991,
 0x2991,0x6991,0xA991,0xE991,0x3991,0x7991,0xB991,0xF991,
 0x0D91,0x4D91,0x8D91,0xCD91,0x1D91,0x5D91,0x9D91,0xDD91,
 0x2D91,0x6D91,0xAD91,0xED91,0x3D91,0x7D91,0xBD91,0xFD91,
 0x0291,0x4291,0x8291,0xC291,0x1291,0x5291,0x9291,0xD291,
 0x2291,0x6291,0xA291,0xE291,0x3291,0x7291,0xB291,0xF291,
 0x0691,0x4691,0x8691,0xC691,0x1691,0x5691,0x9691,0xD691,
 0x2691,0x6691,0xA691,0xE691,0x3691,0x7691,0xB691,0xF691,
 0x0A91,0x4A91,0x8A91,0xCA91,0x1A91,0x5A91,0x9A91,0xDA91,
 0x2A91,0x6A91,0xAA91,0xEA91,0x3A91,0x7A91,0xBA91,0xFA91,
 0x0E91,0x4E91,0x8E91,0xCE91,0x1E91,0x5E91,0x9E91,0xDE91,
 0x2E91,0x6E91,0xAE91,0xEE91,0x3E91,0x7E91,0xBE91,0xFE91,
 0x0391,0x4391,0x8391,0xC391,0x1391,0x5391,0x9391,0xD391,
 0x2391,0x6391,0xA391,0xE391,0x3391,0x7391,0xB391,0xF391,
 0x0791,0x4791,0x8791,0xC791,0x1791,0x5791,0x9791,0xD791,
 0x2791,0x6791,0xA791,0xE791,0x3791,0x7791,0xB791,0xF791,
 0x0B91,0x4B91,0x8B91,0xCB91,0x1B91,0x5B91,0x9B91,0xDB91,
 0x2B91,0x6B91,0xAB91,0xEB91,0x3B91,0x7B91,0xBB91,0xFB91,
 0x0F91,0x4F91,0x8F91,0xCF91,0x1F91,0x5F91,0x9F91,0xDF91,
 0x2F91,0x6F91,0xAF91,0xEF91,0x3F91,0x7F91,0xBF91,0xFF91,
 0x00D1,0x40D1,0x80D1,0xC0D1,0x10D1,0x50D1,0x90D1,0xD0D1,
 0x20D1,0x60D1,0xA0D1,0xE0D1,0x30D1,0x70D1,0xB0D1,0xF0D1,
 0x04D1,0x44D1,0x84D1,0xC4D1,0x14D1,0x54D1,0x94D1,0xD4D1,
 0x24D1,0x64D1,0xA4D1,0xE4D1,0x34D1,0x74D1,0xB4D1,0xF4D1,
 0x08D1,0x48D1,0x88D1,0xC8D1,0x18D1,0x58D1,0x98D1,0xD8D1,
 0x28D1,0x68D1,0xA8D1,0xE8D1,0x38D1,0x78D1,0xB8D1,0xF8D1,
 0x0CD1,0x4CD1,0x8CD1,0xCCD1,0x1CD1,0x5CD1,0x9CD1,0xDCD1,
 0x2CD1,0x6CD1,0xACD1,0xECD1,0x3CD1,0x7CD1,0xBCD1,0xFCD1,
 0x01D1,0x41D1,0x81D1,0xC1D1,0x11D1,0x51D1,0x91D1,0xD1D1,
 0x21D1,0x61D1,0xA1D1,0xE1D1,0x31D1,0x71D1,0xB1D1,0xF1D1,
 0x05D1,0x45D1,0x85D1,0xC5D1,0x15D1,0x55D1,0x95D1,0xD5D1,
 0x25D1,0x65D1,0xA5D1,0xE5D1,0x35D1,0x75D1,0xB5D1,0xF5D1,
 0x09D1,0x49D1,0x89D1,0xC9D1,0x19D1,0x59D1,0x99D1,0xD9D1,
 0x29D1,0x69D1,0xA9D1,0xE9D1,0x39D1,0x79D1,0xB9D1,0xF9D1,
 0x0DD1,0x4DD1,0x8DD1,0xCDD1,0x1DD1,0x5DD1,0x9DD1,0xDDD1,
 0x2DD1,0x6DD1,0xADD1,0xEDD1,0x3DD1,0x7DD1,0xBDD1,0xFDD1,
 0x02D1,0x42D1,0x82D1,0xC2D1,0x12D1,0x52D1,0x92D1,0xD2D1,
 0x22D1,0x62D1,0xA2D1,0xE2D1,0x32D1,0x72D1,0xB2D1,0xF2D1,
 0x06D1,0x46D1,0x86D1,0xC6D1,0x16D1,0x56D1,0x96D1,0xD6D1,
 0x26D1,0x66D1,0xA6D1,0xE6D1,0x36D1,0x76D1,0xB6D1,0xF6D1,
 0x0AD1,0x4AD1,0x8AD1,0xCAD1,0x1AD1,0x5AD1,0x9AD1,0xDAD1,
 0x2AD1,0x6AD1,0xAAD1,0xEAD1,0x3AD1,0x7AD1,0xBAD1,0xFAD1,
 0x0ED1,0x4ED1,0x8ED1,0xCED1,0x1ED1,0x5ED1,0x9ED1,0xDED1,
 0x2ED1,0x6ED1,0xAED1,0xEED1,0x3ED1,0x7ED1,0xBED1,0xFED1,
 0x03D1,0x43D1,0x83D1,0xC3D1,0x13D1,0x53D1,0x93D1,0xD3D1,
 0x23D1,0x63D1,0xA3D1,0xE3D1,0x33D1,0x73D1,0xB3D1,0xF3D1,
 0x07D1,0x47D1,0x87D1,0xC7D1,0x17D1,0x57D1,0x97D1,0xD7D1,
 0x27D1,0x67D1,0xA7D1,0xE7D1,0x37D1,0x77D1,0xB7D1,0xF7D1,
 0x0BD1,0x4BD1,0x8BD1,0xCBD1,0x1BD1,0x5BD1,0x9BD1,0xDBD1,
 0x2BD1,0x6BD1,0xABD1,0xEBD1,0x3BD1,0x7BD1,0xBBD1,0xFBD1,
 0x0FD1,0x4FD1,0x8FD1,0xCFD1,0x1FD1,0x5FD1,0x9FD1,0xDFD1,
 0x2FD1,0x6FD1,0xAFD1,0xEFD1,0x3FD1,0x7FD1,0xBFD1,0xFFD1,
 0x0021,0x4021,0x8021,0xC021,0x1021,0x5021,0x9021,0xD021,
 0x2021,0x6021,0xA021,0xE021,0x3021,0x7021,0xB021,0xF021,
 0x0421,0x4421,0x8421,0xC421,0x1421,0x5421,0x9421,0xD421,
 0x2421,0x6421,0xA421,0xE421,0x3421,0x7421,0xB421,0xF421,
 0x0821,0x4821,0x8821,0xC821,0x1821,0x5821,0x9821,0xD821,
 0x2821,0x6821,0xA821,0xE821,0x3821,0x7821,0xB821,0xF821,
 0x0C21,0x4C21,0x8C21,0xCC21,0x1C21,0x5C21,0x9C21,0xDC21,
 0x2C21,0x6C21,0xAC21,0xEC21,0x3C21,0x7C21,0xBC21,0xFC21,
 0x0121,0x4121,0x8121,0xC121,0x1121,0x5121,0x9121,0xD121,
 0x2121,0x6121,0xA121,0xE121,0x3121,0x7121,0xB121,0xF121,
 0x0521,0x4521,0x8521,0xC521,0x1521,0x5521,0x9521,0xD521,
 0x2521,0x6521,0xA521,0xE521,0x3521,0x7521,0xB521,0xF521,
 0x0921,0x4921,0x8921,0xC921,0x1921,0x5921,0x9921,0xD921,
 0x2921,0x6921,0xA921,0xE921,0x3921,0x7921,0xB921,0xF921,
 0x0D21,0x4D21,0x8D21,0xCD21,0x1D21,0x5D21,0x9D21,0xDD21,
 0x2D21,0x6D21,0xAD21,0xED21,0x3D21,0x7D21,0xBD21,0xFD21,
 0x0221,0x4221,0x8221,0xC221,0x1221,0x5221,0x9221,0xD221,
 0x2221,0x6221,0xA221,0xE221,0x3221,0x7221,0xB221,0xF221,
 0x0621,0x4621,0x8621,0xC621,0x1621,0x5621,0x9621,0xD621,
 0x2621,0x6621,0xA621,0xE621,0x3621,0x7621,0xB621,0xF621,
 0x0A21,0x4A21,0x8A21,0xCA21,0x1A21,0x5A21,0x9A21,0xDA21,
 0x2A21,0x6A21,0xAA21,0xEA21,0x3A21,0x7A21,0xBA21,0xFA21,
 0x0E21,0x4E21,0x8E21,0xCE21,0x1E21,0x5E21,0x9E21,0xDE21,
 0x2E21,0x6E21,0xAE21,0xEE21,0x3E21,0x7E21,0xBE21,0xFE21,
 0x0321,0x4321,0x8321,0xC321,0x1321,0x5321,0x9321,0xD321,
 0x2321,0x6321,0xA321,0xE321,0x3321,0x7321,0xB321,0xF321,
 0x0721,0x4721,0x8721,0xC721,0x1721,0x5721,0x9721,0xD721,
 0x2721,0x6721,0xA721,0xE721,0x3721,0x7721,0xB721,0xF721,
 0x0B21,0x4B21,0x8B21,0xCB21,0x1B21,0x5B21,0x9B21,0xDB21,
 0x2B21,0x6B21,0xAB21,0xEB21,0x3B21,0x7B21,0xBB21,0xFB21,
 0x0F21,0x4F21,0x8F21,0xCF21,0x1F21,0x5F21,0x9F21,0xDF21,
 0x2F21,0x6F21,0xAF21,0xEF21,0x3F21,0x7F21,0xBF21,0xFF21,
 0x0061,0x4061,0x8061,0xC061,0x1061,0x5061,0x9061,0xD061,
 0x2061,0x6061,0xA061,0xE061,0x3061,0x7061,0xB061,0xF061,
 0x0461,0x4461,0x8461,0xC461,0x1461,0x5461,0x9461,0xD461,
 0x2461,0x6461,0xA461,0xE461,0x3461,0x7461,0xB461,0xF461,
 0x0861,0x4861,0x8861,0xC861,0x1861,0x5861,0x9861,0xD861,
 0x2861,0x6861,0xA861,0xE861,0x3861,0x7861,0xB861,0xF861,
 0x0C61,0x4C61,0x8C61,0xCC61,0x1C61,0x5C61,0x9C61,0xDC61,
 0x2C61,0x6C61,0xAC61,0xEC61,0x3C61,0x7C61,0xBC61,0xFC61,
 0x0161,0x4161,0x8161,0xC161,0x1161,0x5161,0x9161,0xD161,
 0x2161,0x6161,0xA161,0xE161,0x3161,0x7161,0xB161,0xF161,
 0x0561,0x4561,0x8561,0xC561,0x1561,0x5561,0x9561,0xD561,
 0x2561,0x6561,0xA561,0xE561,0x3561,0x7561,0xB561,0xF561,
 0x0961,0x4961,0x8961,0xC961,0x1961,0x5961,0x9961,0xD961,
 0x2961,0x6961,0xA961,0xE961,0x3961,0x7961,0xB961,0xF961,
 0x0D61,0x4D61,0x8D61,0xCD61,0x1D61,0x5D61,0x9D61,0xDD61,
 0x2D61,0x6D61,0xAD61,0xED61,0x3D61,0x7D61,0xBD61,0xFD61,
 0x0261,0x4261,0x8261,0xC261,0x1261,0x5261,0x9261,0xD261,
 0x2261,0x6261,0xA261,0xE261,0x3261,0x7261,0xB261,0xF261,
 0x0661,0x4661,0x8661,0xC661,0x1661,0x5661,0x9661,0xD661,
 0x2661,0x6661,0xA661,0xE661,0x3661,0x7661,0xB661,0xF661,
 0x0A61,0x4A61,0x8A61,0xCA61,0x1A61,0x5A61,0x9A61,0xDA61,
 0x2A61,0x6A61,0xAA61,0xEA61,0x3A61,0x7A61,0xBA61,0xFA61,
 0x0E61,0x4E61,0x8E61,0xCE61,0x1E61,0x5E61,0x9E61,0xDE61,
 0x2E61,0x6E61,0xAE61,0xEE61,0x3E61,0x7E61,0xBE61,0xFE61,
 0x0361,0x4361,0x8361,0xC361,0x1361,0x5361,0x9361,0xD361,
 0x2361,0x6361,0xA361,0xE361,0x3361,0x7361,0xB361,0xF361,
 0x0761,0x4761,0x8761,0xC761,0x1761,0x5761,0x9761,0xD761,
 0x2761,0x6761,0xA761,0xE761,0x3761,0x7761,0xB761,0xF761,
 0x0B61,0x4B61,0x8B61,0xCB61,0x1B61,0x5B61,0x9B61,0xDB61,
 0x2B61,0x6B61,0xAB61,0xEB61,0x3B61,0x7B61,0xBB61,0xFB61,
 0x0F61,0x4F61,0x8F61,0xCF61,0x1F61,0x5F61,0x9F61,0xDF61,
 0x2F61,0x6F61,0xAF61,0xEF61,0x3F61,0x7F61,0xBF61,0xFF61,
 0x00A1,0x40A1,0x80A1,0xC0A1,0x10A1,0x50A1,0x90A1,0xD0A1,
 0x20A1,0x60A1,0xA0A1,0xE0A1,0x30A1,0x70A1,0xB0A1,0xF0A1,
 0x04A1,0x44A1,0x84A1,0xC4A1,0x14A1,0x54A1,0x94A1,0xD4A1,
 0x24A1,0x64A1,0xA4A1,0xE4A1,0x34A1,0x74A1,0xB4A1,0xF4A1,
 0x08A1,0x48A1,0x88A1,0xC8A1,0x18A1,0x58A1,0x98A1,0xD8A1,
 0x28A1,0x68A1,0xA8A1,0xE8A1,0x38A1,0x78A1,0xB8A1,0xF8A1,
 0x0CA1,0x4CA1,0x8CA1,0xCCA1,0x1CA1,0x5CA1,0x9CA1,0xDCA1,
 0x2CA1,0x6CA1,0xACA1,0xECA1,0x3CA1,0x7CA1,0xBCA1,0xFCA1,
 0x01A1,0x41A1,0x81A1,0xC1A1,0x11A1,0x51A1,0x91A1,0xD1A1,
 0x21A1,0x61A1,0xA1A1,0xE1A1,0x31A1,0x71A1,0xB1A1,0xF1A1,
 0x05A1,0x45A1,0x85A1,0xC5A1,0x15A1,0x55A1,0x95A1,0xD5A1,
 0x25A1,0x65A1,0xA5A1,0xE5A1,0x35A1,0x75A1,0xB5A1,0xF5A1,
 0x09A1,0x49A1,0x89A1,0xC9A1,0x19A1,0x59A1,0x99A1,0xD9A1,
 0x29A1,0x69A1,0xA9A1,0xE9A1,0x39A1,0x79A1,0xB9A1,0xF9A1,
 0x0DA1,0x4DA1,0x8DA1,0xCDA1,0x1DA1,0x5DA1,0x9DA1,0xDDA1,
 0x2DA1,0x6DA1,0xADA1,0xEDA1,0x3DA1,0x7DA1,0xBDA1,0xFDA1,
 0x02A1,0x42A1,0x82A1,0xC2A1,0x12A1,0x52A1,0x92A1,0xD2A1,
 0x22A1,0x62A1,0xA2A1,0xE2A1,0x32A1,0x72A1,0xB2A1,0xF2A1,
 0x06A1,0x46A1,0x86A1,0xC6A1,0x16A1,0x56A1,0x96A1,0xD6A1,
 0x26A1,0x66A1,0xA6A1,0xE6A1,0x36A1,0x76A1,0xB6A1,0xF6A1,
 0x0AA1,0x4AA1,0x8AA1,0xCAA1,0x1AA1,0x5AA1,0x9AA1,0xDAA1,
 0x2AA1,0x6AA1,0xAAA1,0xEAA1,0x3AA1,0x7AA1,0xBAA1,0xFAA1,
 0x0EA1,0x4EA1,0x8EA1,0xCEA1,0x1EA1,0x5EA1,0x9EA1,0xDEA1,
 0x2EA1,0x6EA1,0xAEA1,0xEEA1,0x3EA1,0x7EA1,0xBEA1,0xFEA1,
 0x03A1,0x43A1,0x83A1,0xC3A1,0x13A1,0x53A1,0x93A1,0xD3A1,
 0x23A1,0x63A1,0xA3A1,0xE3A1,0x33A1,0x73A1,0xB3A1,0xF3A1,
 0x07A1,0x47A1,0x87A1,0xC7A1,0x17A1,0x57A1,0x97A1,0xD7A1,
 0x27A1,0x67A1,0xA7A1,0xE7A1,0x37A1,0x77A1,0xB7A1,0xF7A1,
 0x0BA1,0x4BA1,0x8BA1,0xCBA1,0x1BA1,0x5BA1,0x9BA1,0xDBA1,
 0x2BA1,0x6BA1,0xABA1,0xEBA1,0x3BA1,0x7BA1,0xBBA1,0xFBA1,
 0x0FA1,0x4FA1,0x8FA1,0xCFA1,0x1FA1,0x5FA1,0x9FA1,0xDFA1,
 0x2FA1,0x6FA1,0xAFA1,0xEFA1,0x3FA1,0x7FA1,0xBFA1,0xFFA1,
 0x00E1,0x40E1,0x80E1,0xC0E1,0x10E1,0x50E1,0x90E1,0xD0E1,
 0x20E1,0x60E1,0xA0E1,0xE0E1,0x30E1,0x70E1,0xB0E1,0xF0E1,
 0x04E1,0x44E1,0x84E1,0xC4E1,0x14E1,0x54E1,0x94E1,0xD4E1,
 0x24E1,0x64E1,0xA4E1,0xE4E1,0x34E1,0x74E1,0xB4E1,0xF4E1,
 0x08E1,0x48E1,0x88E1,0xC8E1,0x18E1,0x58E1,0x98E1,0xD8E1,
 0x28E1,0x68E1,0xA8E1,0xE8E1,0x38E1,0x78E1,0xB8E1,0xF8E1,
 0x0CE1,0x4CE1,0x8CE1,0xCCE1,0x1CE1,0x5CE1,0x9CE1,0xDCE1,
 0x2CE1,0x6CE1,0xACE1,0xECE1,0x3CE1,0x7CE1,0xBCE1,0xFCE1,
 0x01E1,0x41E1,0x81E1,0xC1E1,0x11E1,0x51E1,0x91E1,0xD1E1,
 0x21E1,0x61E1,0xA1E1,0xE1E1,0x31E1,0x71E1,0xB1E1,0xF1E1,
 0x05E1,0x45E1,0x85E1,0xC5E1,0x15E1,0x55E1,0x95E1,0xD5E1,
 0x25E1,0x65E1,0xA5E1,0xE5E1,0x35E1,0x75E1,0xB5E1,0xF5E1,
 0x09E1,0x49E1,0x89E1,0xC9E1,0x19E1,0x59E1,0x99E1,0xD9E1,
 0x29E1,0x69E1,0xA9E1,0xE9E1,0x39E1,0x79E1,0xB9E1,0xF9E1,
 0x0DE1,0x4DE1,0x8DE1,0xCDE1,0x1DE1,0x5DE1,0x9DE1,0xDDE1,
 0x2DE1,0x6DE1,0xADE1,0xEDE1,0x3DE1,0x7DE1,0xBDE1,0xFDE1,
 0x02E1,0x42E1,0x82E1,0xC2E1,0x12E1,0x52E1,0x92E1,0xD2E1,
 0x22E1,0x62E1,0xA2E1,0xE2E1,0x32E1,0x72E1,0xB2E1,0xF2E1,
 0x06E1,0x46E1,0x86E1,0xC6E1,0x16E1,0x56E1,0x96E1,0xD6E1,
 0x26E1,0x66E1,0xA6E1,0xE6E1,0x36E1,0x76E1,0xB6E1,0xF6E1,
 0x0AE1,0x4AE1,0x8AE1,0xCAE1,0x1AE1,0x5AE1,0x9AE1,0xDAE1,
 0x2AE1,0x6AE1,0xAAE1,0xEAE1,0x3AE1,0x7AE1,0xBAE1,0xFAE1,
 0x0EE1,0x4EE1,0x8EE1,0xCEE1,0x1EE1,0x5EE1,0x9EE1,0xDEE1,
 0x2EE1,0x6EE1,0xAEE1,0xEEE1,0x3EE1,0x7EE1,0xBEE1,0xFEE1,
 0x03E1,0x43E1,0x83E1,0xC3E1,0x13E1,0x53E1,0x93E1,0xD3E1,
 0x23E1,0x63E1,0xA3E1,0xE3E1,0x33E1,0x73E1,0xB3E1,0xF3E1,
 0x07E1,0x47E1,0x87E1,0xC7E1,0x17E1,0x57E1,0x97E1,0xD7E1,
 0x27E1,0x67E1,0xA7E1,0xE7E1,0x37E1,0x77E1,0xB7E1,0xF7E1,
 0x0BE1,0x4BE1,0x8BE1,0xCBE1,0x1BE1,0x5BE1,0x9BE1,0xDBE1,
 0x2BE1,0x6BE1,0xABE1,0xEBE1,0x3BE1,0x7BE1,0xBBE1,0xFBE1,
 0x0FE1,0x4FE1,0x8FE1,0xCFE1,0x1FE1,0x5FE1,0x9FE1,0xDFE1,
 0x2FE1,0x6FE1,0xAFE1,0xEFE1,0x3FE1,0x7FE1,0xBFE1,0xFFE1,
 0x0031,0x4031,0x8031,0xC031,0x1031,0x5031,0x9031,0xD031,
 0x2031,0x6031,0xA031,0xE031,0x3031,0x7031,0xB031,0xF031,
 0x0431,0x4431,0x8431,0xC431,0x1431,0x5431,0x9431,0xD431,
 0x2431,0x6431,0xA431,0xE431,0x3431,0x7431,0xB431,0xF431,
 0x0831,0x4831,0x8831,0xC831,0x1831,0x5831,0x9831,0xD831,
 0x2831,0x6831,0xA831,0xE831,0x3831,0x7831,0xB831,0xF831,
 0x0C31,0x4C31,0x8C31,0xCC31,0x1C31,0x5C31,0x9C31,0xDC31,
 0x2C31,0x6C31,0xAC31,0xEC31,0x3C31,0x7C31,0xBC31,0xFC31,
 0x0131,0x4131,0x8131,0xC131,0x1131,0x5131,0x9131,0xD131,
 0x2131,0x6131,0xA131,0xE131,0x3131,0x7131,0xB131,0xF131,
 0x0531,0x4531,0x8531,0xC531,0x1531,0x5531,0x9531,0xD531,
 0x2531,0x6531,0xA531,0xE531,0x3531,0x7531,0xB531,0xF531,
 0x0931,0x4931,0x8931,0xC931,0x1931,0x5931,0x9931,0xD931,
 0x2931,0x6931,0xA931,0xE931,0x3931,0x7931,0xB931,0xF931,
 0x0D31,0x4D31,0x8D31,0xCD31,0x1D31,0x5D31,0x9D31,0xDD31,
 0x2D31,0x6D31,0xAD31,0xED31,0x3D31,0x7D31,0xBD31,0xFD31,
 0x0231,0x4231,0x8231,0xC231,0x1231,0x5231,0x9231,0xD231,
 0x2231,0x6231,0xA231,0xE231,0x3231,0x7231,0xB231,0xF231,
 0x0631,0x4631,0x8631,0xC631,0x1631,0x5631,0x9631,0xD631,
 0x2631,0x6631,0xA631,0xE631,0x3631,0x7631,0xB631,0xF631,
 0x0A31,0x4A31,0x8A31,0xCA31,0x1A31,0x5A31,0x9A31,0xDA31,
 0x2A31,0x6A31,0xAA31,0xEA31,0x3A31,0x7A31,0xBA31,0xFA31,
 0x0E31,0x4E31,0x8E31,0xCE31,0x1E31,0x5E31,0x9E31,0xDE31,
 0x2E31,0x6E31,0xAE31,0xEE31,0x3E31,0x7E31,0xBE31,0xFE31,
 0x0331,0x4331,0x8331,0xC331,0x1331,0x5331,0x9331,0xD331,
 0x2331,0x6331,0xA331,0xE331,0x3331,0x7331,0xB331,0xF331,
 0x0731,0x4731,0x8731,0xC731,0x1731,0x5731,0x9731,0xD731,
 0x2731,0x6731,0xA731,0xE731,0x3731,0x7731,0xB731,0xF731,
 0x0B31,0x4B31,0x8B31,0xCB31,0x1B31,0x5B31,0x9B31,0xDB31,
 0x2B31,0x6B31,0xAB31,0xEB31,0x3B31,0x7B31,0xBB31,0xFB31,
 0x0F31,0x4F31,0x8F31,0xCF31,0x1F31,0x5F31,0x9F31,0xDF31,
 0x2F31,0x6F31,0xAF31,0xEF31,0x3F31,0x7F31,0xBF31,0xFF31,
 0x0071,0x4071,0x8071,0xC071,0x1071,0x5071,0x9071,0xD071,
 0x2071,0x6071,0xA071,0xE071,0x3071,0x7071,0xB071,0xF071,
 0x0471,0x4471,0x8471,0xC471,0x1471,0x5471,0x9471,0xD471,
 0x2471,0x6471,0xA471,0xE471,0x3471,0x7471,0xB471,0xF471,
 0x0871,0x4871,0x8871,0xC871,0x1871,0x5871,0x9871,0xD871,
 0x2871,0x6871,0xA871,0xE871,0x3871,0x7871,0xB871,0xF871,
 0x0C71,0x4C71,0x8C71,0xCC71,0x1C71,0x5C71,0x9C71,0xDC71,
 0x2C71,0x6C71,0xAC71,0xEC71,0x3C71,0x7C71,0xBC71,0xFC71,
 0x0171,0x4171,0x8171,0xC171,0x1171,0x5171,0x9171,0xD171,
 0x2171,0x6171,0xA171,0xE171,0x3171,0x7171,0xB171,0xF171,
 0x0571,0x4571,0x8571,0xC571,0x1571,0x5571,0x9571,0xD571,
 0x2571,0x6571,0xA571,0xE571,0x3571,0x7571,0xB571,0xF571,
 0x0971,0x4971,0x8971,0xC971,0x1971,0x5971,0x9971,0xD971,
 0x2971,0x6971,0xA971,0xE971,0x3971,0x7971,0xB971,0xF971,
 0x0D71,0x4D71,0x8D71,0xCD71,0x1D71,0x5D71,0x9D71,0xDD71,
 0x2D71,0x6D71,0xAD71,0xED71,0x3D71,0x7D71,0xBD71,0xFD71,
 0x0271,0x4271,0x8271,0xC271,0x1271,0x5271,0x9271,0xD271,
 0x2271,0x6271,0xA271,0xE271,0x3271,0x7271,0xB271,0xF271,
 0x0671,0x4671,0x8671,0xC671,0x1671,0x5671,0x9671,0xD671,
 0x2671,0x6671,0xA671,0xE671,0x3671,0x7671,0xB671,0xF671,
 0x0A71,0x4A71,0x8A71,0xCA71,0x1A71,0x5A71,0x9A71,0xDA71,
 0x2A71,0x6A71,0xAA71,0xEA71,0x3A71,0x7A71,0xBA71,0xFA71,
 0x0E71,0x4E71,0x8E71,0xCE71,0x1E71,0x5E71,0x9E71,0xDE71,
 0x2E71,0x6E71,0xAE71,0xEE71,0x3E71,0x7E71,0xBE71,0xFE71,
 0x0371,0x4371,0x8371,0xC371,0x1371,0x5371,0x9371,0xD371,
 0x2371,0x6371,0xA371,0xE371,0x3371,0x7371,0xB371,0xF371,
 0x0771,0x4771,0x8771,0xC771,0x1771,0x5771,0x9771,0xD771,
 0x2771,0x6771,0xA771,0xE771,0x3771,0x7771,0xB771,0xF771,
 0x0B71,0x4B71,0x8B71,0xCB71,0x1B71,0x5B71,0x9B71,0xDB71,
 0x2B71,0x6B71,0xAB71,0xEB71,0x3B71,0x7B71,0xBB71,0xFB71,
 0x0F71,0x4F71,0x8F71,0xCF71,0x1F71,0x5F71,0x9F71,0xDF71,
 0x2F71,0x6F71,0xAF71,0xEF71,0x3F71,0x7F71,0xBF71,0xFF71,
 0x00B1,0x40B1,0x80B1,0xC0B1,0x10B1,0x50B1,0x90B1,0xD0B1,
 0x20B1,0x60B1,0xA0B1,0xE0B1,0x30B1,0x70B1,0xB0B1,0xF0B1,
 0x04B1,0x44B1,0x84B1,0xC4B1,0x14B1,0x54B1,0x94B1,0xD4B1,
 0x24B1,0x64B1,0xA4B1,0xE4B1,0x34B1,0x74B1,0xB4B1,0xF4B1,
 0x08B1,0x48B1,0x88B1,0xC8B1,0x18B1,0x58B1,0x98B1,0xD8B1,
 0x28B1,0x68B1,0xA8B1,0xE8B1,0x38B1,0x78B1,0xB8B1,0xF8B1,
 0x0CB1,0x4CB1,0x8CB1,0xCCB1,0x1CB1,0x5CB1,0x9CB1,0xDCB1,
 0x2CB1,0x6CB1,0xACB1,0xECB1,0x3CB1,0x7CB1,0xBCB1,0xFCB1,
 0x01B1,0x41B1,0x81B1,0xC1B1,0x11B1,0x51B1,0x91B1,0xD1B1,
 0x21B1,0x61B1,0xA1B1,0xE1B1,0x31B1,0x71B1,0xB1B1,0xF1B1,
 0x05B1,0x45B1,0x85B1,0xC5B1,0x15B1,0x55B1,0x95B1,0xD5B1,
 0x25B1,0x65B1,0xA5B1,0xE5B1,0x35B1,0x75B1,0xB5B1,0xF5B1,
 0x09B1,0x49B1,0x89B1,0xC9B1,0x19B1,0x59B1,0x99B1,0xD9B1,
 0x29B1,0x69B1,0xA9B1,0xE9B1,0x39B1,0x79B1,0xB9B1,0xF9B1,
 0x0DB1,0x4DB1,0x8DB1,0xCDB1,0x1DB1,0x5DB1,0x9DB1,0xDDB1,
 0x2DB1,0x6DB1,0xADB1,0xEDB1,0x3DB1,0x7DB1,0xBDB1,0xFDB1,
 0x02B1,0x42B1,0x82B1,0xC2B1,0x12B1,0x52B1,0x92B1,0xD2B1,
 0x22B1,0x62B1,0xA2B1,0xE2B1,0x32B1,0x72B1,0xB2B1,0xF2B1,
 0x06B1,0x46B1,0x86B1,0xC6B1,0x16B1,0x56B1,0x96B1,0xD6B1,
 0x26B1,0x66B1,0xA6B1,0xE6B1,0x36B1,0x76B1,0xB6B1,0xF6B1,
 0x0AB1,0x4AB1,0x8AB1,0xCAB1,0x1AB1,0x5AB1,0x9AB1,0xDAB1,
 0x2AB1,0x6AB1,0xAAB1,0xEAB1,0x3AB1,0x7AB1,0xBAB1,0xFAB1,
 0x0EB1,0x4EB1,0x8EB1,0xCEB1,0x1EB1,0x5EB1,0x9EB1,0xDEB1,
 0x2EB1,0x6EB1,0xAEB1,0xEEB1,0x3EB1,0x7EB1,0xBEB1,0xFEB1,
 0x03B1,0x43B1,0x83B1,0xC3B1,0x13B1,0x53B1,0x93B1,0xD3B1,
 0x23B1,0x63B1,0xA3B1,0xE3B1,0x33B1,0x73B1,0xB3B1,0xF3B1,
 0x07B1,0x47B1,0x87B1,0xC7B1,0x17B1,0x57B1,0x97B1,0xD7B1,
 0x27B1,0x67B1,0xA7B1,0xE7B1,0x37B1,0x77B1,0xB7B1,0xF7B1,
 0x0BB1,0x4BB1,0x8BB1,0xCBB1,0x1BB1,0x5BB1,0x9BB1,0xDBB1,
 0x2BB1,0x6BB1,0xABB1,0xEBB1,0x3BB1,0x7BB1,0xBBB1,0xFBB1,
 0x0FB1,0x4FB1,0x8FB1,0xCFB1,0x1FB1,0x5FB1,0x9FB1,0xDFB1,
 0x2FB1,0x6FB1,0xAFB1,0xEFB1,0x3FB1,0x7FB1,0xBFB1,0xFFB1,
 0x00F1,0x40F1,0x80F1,0xC0F1,0x10F1,0x50F1,0x90F1,0xD0F1,
 0x20F1,0x60F1,0xA0F1,0xE0F1,0x30F1,0x70F1,0xB0F1,0xF0F1,
 0x04F1,0x44F1,0x84F1,0xC4F1,0x14F1,0x54F1,0x94F1,0xD4F1,
 0x24F1,0x64F1,0xA4F1,0xE4F1,0x34F1,0x74F1,0xB4F1,0xF4F1,
 0x08F1,0x48F1,0x88F1,0xC8F1,0x18F1,0x58F1,0x98F1,0xD8F1,
 0x28F1,0x68F1,0xA8F1,0xE8F1,0x38F1,0x78F1,0xB8F1,0xF8F1,
 0x0CF1,0x4CF1,0x8CF1,0xCCF1,0x1CF1,0x5CF1,0x9CF1,0xDCF1,
 0x2CF1,0x6CF1,0xACF1,0xECF1,0x3CF1,0x7CF1,0xBCF1,0xFCF1,
 0x01F1,0x41F1,0x81F1,0xC1F1,0x11F1,0x51F1,0x91F1,0xD1F1,
 0x21F1,0x61F1,0xA1F1,0xE1F1,0x31F1,0x71F1,0xB1F1,0xF1F1,
 0x05F1,0x45F1,0x85F1,0xC5F1,0x15F1,0x55F1,0x95F1,0xD5F1,
 0x25F1,0x65F1,0xA5F1,0xE5F1,0x35F1,0x75F1,0xB5F1,0xF5F1,
 0x09F1,0x49F1,0x89F1,0xC9F1,0x19F1,0x59F1,0x99F1,0xD9F1,
 0x29F1,0x69F1,0xA9F1,0xE9F1,0x39F1,0x79F1,0xB9F1,0xF9F1,
 0x0DF1,0x4DF1,0x8DF1,0xCDF1,0x1DF1,0x5DF1,0x9DF1,0xDDF1,
 0x2DF1,0x6DF1,0xADF1,0xEDF1,0x3DF1,0x7DF1,0xBDF1,0xFDF1,
 0x02F1,0x42F1,0x82F1,0xC2F1,0x12F1,0x52F1,0x92F1,0xD2F1,
 0x22F1,0x62F1,0xA2F1,0xE2F1,0x32F1,0x72F1,0xB2F1,0xF2F1,
 0x06F1,0x46F1,0x86F1,0xC6F1,0x16F1,0x56F1,0x96F1,0xD6F1,
 0x26F1,0x66F1,0xA6F1,0xE6F1,0x36F1,0x76F1,0xB6F1,0xF6F1,
 0x0AF1,0x4AF1,0x8AF1,0xCAF1,0x1AF1,0x5AF1,0x9AF1,0xDAF1,
 0x2AF1,0x6AF1,0xAAF1,0xEAF1,0x3AF1,0x7AF1,0xBAF1,0xFAF1,
 0x0EF1,0x4EF1,0x8EF1,0xCEF1,0x1EF1,0x5EF1,0x9EF1,0xDEF1,
 0x2EF1,0x6EF1,0xAEF1,0xEEF1,0x3EF1,0x7EF1,0xBEF1,0xFEF1,
 0x03F1,0x43F1,0x83F1,0xC3F1,0x13F1,0x53F1,0x93F1,0xD3F1,
 0x23F1,0x63F1,0xA3F1,0xE3F1,0x33F1,0x73F1,0xB3F1,0xF3F1,
 0x07F1,0x47F1,0x87F1,0xC7F1,0x17F1,0x57F1,0x97F1,0xD7F1,
 0x27F1,0x67F1,0xA7F1,0xE7F1,0x37F1,0x77F1,0xB7F1,0xF7F1,
 0x0BF1,0x4BF1,0x8BF1,0xCBF1,0x1BF1,0x5BF1,0x9BF1,0xDBF1,
 0x2BF1,0x6BF1,0xABF1,0xEBF1,0x3BF1,0x7BF1,0xBBF1,0xFBF1,
 0x0FF1,0x4FF1,0x8FF1,0xCFF1,0x1FF1,0x5FF1,0x9FF1,0xDFF1,
 0x2FF1,0x6FF1,0xAFF1,0xEFF1,0x3FF1,0x7FF1,0xBFF1,0xFFF1,
 0x0005,0x4005,0x8005,0xC005,0x1005,0x5005,0x9005,0xD005,
 0x2005,0x6005,0xA005,0xE005,0x3005,0x7005,0xB005,0xF005,
 0x0405,0x4405,0x8405,0xC405,0x1405,0x5405,0x9405,0xD405,
 0x2405,0x6405,0xA405,0xE405,0x3405,0x7405,0xB405,0xF405,
 0x0805,0x4805,0x8805,0xC805,0x1805,0x5805,0x9805,0xD805,
 0x2805,0x6805,0xA805,0xE805,0x3805,0x7805,0xB805,0xF805,
 0x0C05,0x4C05,0x8C05,0xCC05,0x1C05,0x5C05,0x9C05,0xDC05,
 0x2C05,0x6C05,0xAC05,0xEC05,0x3C05,0x7C05,0xBC05,0xFC05,
 0x0105,0x4105,0x8105,0xC105,0x1105,0x5105,0x9105,0xD105,
 0x2105,0x6105,0xA105,0xE105,0x3105,0x7105,0xB105,0xF105,
 0x0505,0x4505,0x8505,0xC505,0x1505,0x5505,0x9505,0xD505,
 0x2505,0x6505,0xA505,0xE505,0x3505,0x7505,0xB505,0xF505,
 0x0905,0x4905,0x8905,0xC905,0x1905,0x5905,0x9905,0xD905,
 0x2905,0x6905,0xA905,0xE905,0x3905,0x7905,0xB905,0xF905,
 0x0D05,0x4D05,0x8D05,0xCD05,0x1D05,0x5D05,0x9D05,0xDD05,
 0x2D05,0x6D05,0xAD05,0xED05,0x3D05,0x7D05,0xBD05,0xFD05,
 0x0205,0x4205,0x8205,0xC205,0x1205,0x5205,0x9205,0xD205,
 0x2205,0x6205,0xA205,0xE205,0x3205,0x7205,0xB205,0xF205,
 0x0605,0x4605,0x8605,0xC605,0x1605,0x5605,0x9605,0xD605,
 0x2605,0x6605,0xA605,0xE605,0x3605,0x7605,0xB605,0xF605,
 0x0A05,0x4A05,0x8A05,0xCA05,0x1A05,0x5A05,0x9A05,0xDA05,
 0x2A05,0x6A05,0xAA05,0xEA05,0x3A05,0x7A05,0xBA05,0xFA05,
 0x0E05,0x4E05,0x8E05,0xCE05,0x1E05,0x5E05,0x9E05,0xDE05,
 0x2E05,0x6E05,0xAE05,0xEE05,0x3E05,0x7E05,0xBE05,0xFE05,
 0x0305,0x4305,0x8305,0xC305,0x1305,0x5305,0x9305,0xD305,
 0x2305,0x6305,0xA305,0xE305,0x3305,0x7305,0xB305,0xF305,
 0x0705,0x4705,0x8705,0xC705,0x1705,0x5705,0x9705,0xD705,
 0x2705,0x6705,0xA705,0xE705,0x3705,0x7705,0xB705,0xF705,
 0x0B05,0x4B05,0x8B05,0xCB05,0x1B05,0x5B05,0x9B05,0xDB05,
 0x2B05,0x6B05,0xAB05,0xEB05,0x3B05,0x7B05,0xBB05,0xFB05,
 0x0F05,0x4F05,0x8F05,0xCF05,0x1F05,0x5F05,0x9F05,0xDF05,
 0x2F05,0x6F05,0xAF05,0xEF05,0x3F05,0x7F05,0xBF05,0xFF05,
 0x0045,0x4045,0x8045,0xC045,0x1045,0x5045,0x9045,0xD045,
 0x2045,0x6045,0xA045,0xE045,0x3045,0x7045,0xB045,0xF045,
 0x0445,0x4445,0x8445,0xC445,0x1445,0x5445,0x9445,0xD445,
 0x2445,0x6445,0xA445,0xE445,0x3445,0x7445,0xB445,0xF445,
 0x0845,0x4845,0x8845,0xC845,0x1845,0x5845,0x9845,0xD845,
 0x2845,0x6845,0xA845,0xE845,0x3845,0x7845,0xB845,0xF845,
 0x0C45,0x4C45,0x8C45,0xCC45,0x1C45,0x5C45,0x9C45,0xDC45,
 0x2C45,0x6C45,0xAC45,0xEC45,0x3C45,0x7C45,0xBC45,0xFC45,
 0x0145,0x4145,0x8145,0xC145,0x1145,0x5145,0x9145,0xD145,
 0x2145,0x6145,0xA145,0xE145,0x3145,0x7145,0xB145,0xF145,
 0x0545,0x4545,0x8545,0xC545,0x1545,0x5545,0x9545,0xD545,
 0x2545,0x6545,0xA545,0xE545,0x3545,0x7545,0xB545,0xF545,
 0x0945,0x4945,0x8945,0xC945,0x1945,0x5945,0x9945,0xD945,
 0x2945,0x6945,0xA945,0xE945,0x3945,0x7945,0xB945,0xF945,
 0x0D45,0x4D45,0x8D45,0xCD45,0x1D45,0x5D45,0x9D45,0xDD45,
 0x2D45,0x6D45,0xAD45,0xED45,0x3D45,0x7D45,0xBD45,0xFD45,
 0x0245,0x4245,0x8245,0xC245,0x1245,0x5245,0x9245,0xD245,
 0x2245,0x6245,0xA245,0xE245,0x3245,0x7245,0xB245,0xF245,
 0x0645,0x4645,0x8645,0xC645,0x1645,0x5645,0x9645,0xD645,
 0x2645,0x6645,0xA645,0xE645,0x3645,0x7645,0xB645,0xF645,
 0x0A45,0x4A45,0x8A45,0xCA45,0x1A45,0x5A45,0x9A45,0xDA45,
 0x2A45,0x6A45,0xAA45,0xEA45,0x3A45,0x7A45,0xBA45,0xFA45,
 0x0E45,0x4E45,0x8E45,0xCE45,0x1E45,0x5E45,0x9E45,0xDE45,
 0x2E45,0x6E45,0xAE45,0xEE45,0x3E45,0x7E45,0xBE45,0xFE45,
 0x0345,0x4345,0x8345,0xC345,0x1345,0x5345,0x9345,0xD345,
 0x2345,0x6345,0xA345,0xE345,0x3345,0x7345,0xB345,0xF345,
 0x0745,0x4745,0x8745,0xC745,0x1745,0x5745,0x9745,0xD745,
 0x2745,0x6745,0xA745,0xE745,0x3745,0x7745,0xB745,0xF745,
 0x0B45,0x4B45,0x8B45,0xCB45,0x1B45,0x5B45,0x9B45,0xDB45,
 0x2B45,0x6B45,0xAB45,0xEB45,0x3B45,0x7B45,0xBB45,0xFB45,
 0x0F45,0x4F45,0x8F45,0xCF45,0x1F45,0x5F45,0x9F45,0xDF45,
 0x2F45,0x6F45,0xAF45,0xEF45,0x3F45,0x7F45,0xBF45,0xFF45,
 0x0085,0x4085,0x8085,0xC085,0x1085,0x5085,0x9085,0xD085,
 0x2085,0x6085,0xA085,0xE085,0x3085,0x7085,0xB085,0xF085,
 0x0485,0x4485,0x8485,0xC485,0x1485,0x5485,0x9485,0xD485,
 0x2485,0x6485,0xA485,0xE485,0x3485,0x7485,0xB485,0xF485,
 0x0885,0x4885,0x8885,0xC885,0x1885,0x5885,0x9885,0xD885,
 0x2885,0x6885,0xA885,0xE885,0x3885,0x7885,0xB885,0xF885,
 0x0C85,0x4C85,0x8C85,0xCC85,0x1C85,0x5C85,0x9C85,0xDC85,
 0x2C85,0x6C85,0xAC85,0xEC85,0x3C85,0x7C85,0xBC85,0xFC85,
 0x0185,0x4185,0x8185,0xC185,0x1185,0x5185,0x9185,0xD185,
 0x2185,0x6185,0xA185,0xE185,0x3185,0x7185,0xB185,0xF185,
 0x0585,0x4585,0x8585,0xC585,0x1585,0x5585,0x9585,0xD585,
 0x2585,0x6585,0xA585,0xE585,0x3585,0x7585,0xB585,0xF585,
 0x0985,0x4985,0x8985,0xC985,0x1985,0x5985,0x9985,0xD985,
 0x2985,0x6985,0xA985,0xE985,0x3985,0x7985,0xB985,0xF985,
 0x0D85,0x4D85,0x8D85,0xCD85,0x1D85,0x5D85,0x9D85,0xDD85,
 0x2D85,0x6D85,0xAD85,0xED85,0x3D85,0x7D85,0xBD85,0xFD85,
 0x0285,0x4285,0x8285,0xC285,0x1285,0x5285,0x9285,0xD285,
 0x2285,0x6285,0xA285,0xE285,0x3285,0x7285,0xB285,0xF285,
 0x0685,0x4685,0x8685,0xC685,0x1685,0x5685,0x9685,0xD685,
 0x2685,0x6685,0xA685,0xE685,0x3685,0x7685,0xB685,0xF685,
 0x0A85,0x4A85,0x8A85,0xCA85,0x1A85,0x5A85,0x9A85,0xDA85,
 0x2A85,0x6A85,0xAA85,0xEA85,0x3A85,0x7A85,0xBA85,0xFA85,
 0x0E85,0x4E85,0x8E85,0xCE85,0x1E85,0x5E85,0x9E85,0xDE85,
 0x2E85,0x6E85,0xAE85,0xEE85,0x3E85,0x7E85,0xBE85,0xFE85,
 0x0385,0x4385,0x8385,0xC385,0x1385,0x5385,0x9385,0xD385,
 0x2385,0x6385,0xA385,0xE385,0x3385,0x7385,0xB385,0xF385,
 0x0785,0x4785,0x8785,0xC785,0x1785,0x5785,0x9785,0xD785,
 0x2785,0x6785,0xA785,0xE785,0x3785,0x7785,0xB785,0xF785,
 0x0B85,0x4B85,0x8B85,0xCB85,0x1B85,0x5B85,0x9B85,0xDB85,
 0x2B85,0x6B85,0xAB85,0xEB85,0x3B85,0x7B85,0xBB85,0xFB85,
 0x0F85,0x4F85,0x8F85,0xCF85,0x1F85,0x5F85,0x9F85,0xDF85,
 0x2F85,0x6F85,0xAF85,0xEF85,0x3F85,0x7F85,0xBF85,0xFF85,
 0x00C5,0x40C5,0x80C5,0xC0C5,0x10C5,0x50C5,0x90C5,0xD0C5,
 0x20C5,0x60C5,0xA0C5,0xE0C5,0x30C5,0x70C5,0xB0C5,0xF0C5,
 0x04C5,0x44C5,0x84C5,0xC4C5,0x14C5,0x54C5,0x94C5,0xD4C5,
 0x24C5,0x64C5,0xA4C5,0xE4C5,0x34C5,0x74C5,0xB4C5,0xF4C5,
 0x08C5,0x48C5,0x88C5,0xC8C5,0x18C5,0x58C5,0x98C5,0xD8C5,
 0x28C5,0x68C5,0xA8C5,0xE8C5,0x38C5,0x78C5,0xB8C5,0xF8C5,
 0x0CC5,0x4CC5,0x8CC5,0xCCC5,0x1CC5,0x5CC5,0x9CC5,0xDCC5,
 0x2CC5,0x6CC5,0xACC5,0xECC5,0x3CC5,0x7CC5,0xBCC5,0xFCC5,
 0x01C5,0x41C5,0x81C5,0xC1C5,0x11C5,0x51C5,0x91C5,0xD1C5,
 0x21C5,0x61C5,0xA1C5,0xE1C5,0x31C5,0x71C5,0xB1C5,0xF1C5,
 0x05C5,0x45C5,0x85C5,0xC5C5,0x15C5,0x55C5,0x95C5,0xD5C5,
 0x25C5,0x65C5,0xA5C5,0xE5C5,0x35C5,0x75C5,0xB5C5,0xF5C5,
 0x09C5,0x49C5,0x89C5,0xC9C5,0x19C5,0x59C5,0x99C5,0xD9C5,
 0x29C5,0x69C5,0xA9C5,0xE9C5,0x39C5,0x79C5,0xB9C5,0xF9C5,
 0x0DC5,0x4DC5,0x8DC5,0xCDC5,0x1DC5,0x5DC5,0x9DC5,0xDDC5,
 0x2DC5,0x6DC5,0xADC5,0xEDC5,0x3DC5,0x7DC5,0xBDC5,0xFDC5,
 0x02C5,0x42C5,0x82C5,0xC2C5,0x12C5,0x52C5,0x92C5,0xD2C5,
 0x22C5,0x62C5,0xA2C5,0xE2C5,0x32C5,0x72C5,0xB2C5,0xF2C5,
 0x06C5,0x46C5,0x86C5,0xC6C5,0x16C5,0x56C5,0x96C5,0xD6C5,
 0x26C5,0x66C5,0xA6C5,0xE6C5,0x36C5,0x76C5,0xB6C5,0xF6C5,
 0x0AC5,0x4AC5,0x8AC5,0xCAC5,0x1AC5,0x5AC5,0x9AC5,0xDAC5,
 0x2AC5,0x6AC5,0xAAC5,0xEAC5,0x3AC5,0x7AC5,0xBAC5,0xFAC5,
 0x0EC5,0x4EC5,0x8EC5,0xCEC5,0x1EC5,0x5EC5,0x9EC5,0xDEC5,
 0x2EC5,0x6EC5,0xAEC5,0xEEC5,0x3EC5,0x7EC5,0xBEC5,0xFEC5,
 0x03C5,0x43C5,0x83C5,0xC3C5,0x13C5,0x53C5,0x93C5,0xD3C5,
 0x23C5,0x63C5,0xA3C5,0xE3C5,0x33C5,0x73C5,0xB3C5,0xF3C5,
 0x07C5,0x47C5,0x87C5,0xC7C5,0x17C5,0x57C5,0x97C5,0xD7C5,
 0x27C5,0x67C5,0xA7C5,0xE7C5,0x37C5,0x77C5,0xB7C5,0xF7C5,
 0x0BC5,0x4BC5,0x8BC5,0xCBC5,0x1BC5,0x5BC5,0x9BC5,0xDBC5,
 0x2BC5,0x6BC5,0xABC5,0xEBC5,0x3BC5,0x7BC5,0xBBC5,0xFBC5,
 0x0FC5,0x4FC5,0x8FC5,0xCFC5,0x1FC5,0x5FC5,0x9FC5,0xDFC5,
 0x2FC5,0x6FC5,0xAFC5,0xEFC5,0x3FC5,0x7FC5,0xBFC5,0xFFC5,
 0x0015,0x4015,0x8015,0xC015,0x1015,0x5015,0x9015,0xD015,
 0x2015,0x6015,0xA015,0xE015,0x3015,0x7015,0xB015,0xF015,
 0x0415,0x4415,0x8415,0xC415,0x1415,0x5415,0x9415,0xD415,
 0x2415,0x6415,0xA415,0xE415,0x3415,0x7415,0xB415,0xF415,
 0x0815,0x4815,0x8815,0xC815,0x1815,0x5815,0x9815,0xD815,
 0x2815,0x6815,0xA815,0xE815,0x3815,0x7815,0xB815,0xF815,
 0x0C15,0x4C15,0x8C15,0xCC15,0x1C15,0x5C15,0x9C15,0xDC15,
 0x2C15,0x6C15,0xAC15,0xEC15,0x3C15,0x7C15,0xBC15,0xFC15,
 0x0115,0x4115,0x8115,0xC115,0x1115,0x5115,0x9115,0xD115,
 0x2115,0x6115,0xA115,0xE115,0x3115,0x7115,0xB115,0xF115,
 0x0515,0x4515,0x8515,0xC515,0x1515,0x5515,0x9515,0xD515,
 0x2515,0x6515,0xA515,0xE515,0x3515,0x7515,0xB515,0xF515,
 0x0915,0x4915,0x8915,0xC915,0x1915,0x5915,0x9915,0xD915,
 0x2915,0x6915,0xA915,0xE915,0x3915,0x7915,0xB915,0xF915,
 0x0D15,0x4D15,0x8D15,0xCD15,0x1D15,0x5D15,0x9D15,0xDD15,
 0x2D15,0x6D15,0xAD15,0xED15,0x3D15,0x7D15,0xBD15,0xFD15,
 0x0215,0x4215,0x8215,0xC215,0x1215,0x5215,0x9215,0xD215,
 0x2215,0x6215,0xA215,0xE215,0x3215,0x7215,0xB215,0xF215,
 0x0615,0x4615,0x8615,0xC615,0x1615,0x5615,0x9615,0xD615,
 0x2615,0x6615,0xA615,0xE615,0x3615,0x7615,0xB615,0xF615,
 0x0A15,0x4A15,0x8A15,0xCA15,0x1A15,0x5A15,0x9A15,0xDA15,
 0x2A15,0x6A15,0xAA15,0xEA15,0x3A15,0x7A15,0xBA15,0xFA15,
 0x0E15,0x4E15,0x8E15,0xCE15,0x1E15,0x5E15,0x9E15,0xDE15,
 0x2E15,0x6E15,0xAE15,0xEE15,0x3E15,0x7E15,0xBE15,0xFE15,
 0x0315,0x4315,0x8315,0xC315,0x1315,0x5315,0x9315,0xD315,
 0x2315,0x6315,0xA315,0xE315,0x3315,0x7315,0xB315,0xF315,
 0x0715,0x4715,0x8715,0xC715,0x1715,0x5715,0x9715,0xD715,
 0x2715,0x6715,0xA715,0xE715,0x3715,0x7715,0xB715,0xF715,
 0x0B15,0x4B15,0x8B15,0xCB15,0x1B15,0x5B15,0x9B15,0xDB15,
 0x2B15,0x6B15,0xAB15,0xEB15,0x3B15,0x7B15,0xBB15,0xFB15,
 0x0F15,0x4F15,0x8F15,0xCF15,0x1F15,0x5F15,0x9F15,0xDF15,
 0x2F15,0x6F15,0xAF15,0xEF15,0x3F15,0x7F15,0xBF15,0xFF15,
 0x0055,0x4055,0x8055,0xC055,0x1055,0x5055,0x9055,0xD055,
 0x2055,0x6055,0xA055,0xE055,0x3055,0x7055,0xB055,0xF055,
 0x0455,0x4455,0x8455,0xC455,0x1455,0x5455,0x9455,0xD455,
 0x2455,0x6455,0xA455,0xE455,0x3455,0x7455,0xB455,0xF455,
 0x0855,0x4855,0x8855,0xC855,0x1855,0x5855,0x9855,0xD855,
 0x2855,0x6855,0xA855,0xE855,0x3855,0x7855,0xB855,0xF855,
 0x0C55,0x4C55,0x8C55,0xCC55,0x1C55,0x5C55,0x9C55,0xDC55,
 0x2C55,0x6C55,0xAC55,0xEC55,0x3C55,0x7C55,0xBC55,0xFC55,
 0x0155,0x4155,0x8155,0xC155,0x1155,0x5155,0x9155,0xD155,
 0x2155,0x6155,0xA155,0xE155,0x3155,0x7155,0xB155,0xF155,
 0x0555,0x4555,0x8555,0xC555,0x1555,0x5555,0x9555,0xD555,
 0x2555,0x6555,0xA555,0xE555,0x3555,0x7555,0xB555,0xF555,
 0x0955,0x4955,0x8955,0xC955,0x1955,0x5955,0x9955,0xD955,
 0x2955,0x6955,0xA955,0xE955,0x3955,0x7955,0xB955,0xF955,
 0x0D55,0x4D55,0x8D55,0xCD55,0x1D55,0x5D55,0x9D55,0xDD55,
 0x2D55,0x6D55,0xAD55,0xED55,0x3D55,0x7D55,0xBD55,0xFD55,
 0x0255,0x4255,0x8255,0xC255,0x1255,0x5255,0x9255,0xD255,
 0x2255,0x6255,0xA255,0xE255,0x3255,0x7255,0xB255,0xF255,
 0x0655,0x4655,0x8655,0xC655,0x1655,0x5655,0x9655,0xD655,
 0x2655,0x6655,0xA655,0xE655,0x3655,0x7655,0xB655,0xF655,
 0x0A55,0x4A55,0x8A55,0xCA55,0x1A55,0x5A55,0x9A55,0xDA55,
 0x2A55,0x6A55,0xAA55,0xEA55,0x3A55,0x7A55,0xBA55,0xFA55,
 0x0E55,0x4E55,0x8E55,0xCE55,0x1E55,0x5E55,0x9E55,0xDE55,
 0x2E55,0x6E55,0xAE55,0xEE55,0x3E55,0x7E55,0xBE55,0xFE55,
 0x0355,0x4355,0x8355,0xC355,0x1355,0x5355,0x9355,0xD355,
 0x2355,0x6355,0xA355,0xE355,0x3355,0x7355,0xB355,0xF355,
 0x0755,0x4755,0x8755,0xC755,0x1755,0x5755,0x9755,0xD755,
 0x2755,0x6755,0xA755,0xE755,0x3755,0x7755,0xB755,0xF755,
 0x0B55,0x4B55,0x8B55,0xCB55,0x1B55,0x5B55,0x9B55,0xDB55,
 0x2B55,0x6B55,0xAB55,0xEB55,0x3B55,0x7B55,0xBB55,0xFB55,
 0x0F55,0x4F55,0x8F55,0xCF55,0x1F55,0x5F55,0x9F55,0xDF55,
 0x2F55,0x6F55,0xAF55,0xEF55,0x3F55,0x7F55,0xBF55,0xFF55,
 0x0095,0x4095,0x8095,0xC095,0x1095,0x5095,0x9095,0xD095,
 0x2095,0x6095,0xA095,0xE095,0x3095,0x7095,0xB095,0xF095,
 0x0495,0x4495,0x8495,0xC495,0x1495,0x5495,0x9495,0xD495,
 0x2495,0x6495,0xA495,0xE495,0x3495,0x7495,0xB495,0xF495,
 0x0895,0x4895,0x8895,0xC895,0x1895,0x5895,0x9895,0xD895,
 0x2895,0x6895,0xA895,0xE895,0x3895,0x7895,0xB895,0xF895,
 0x0C95,0x4C95,0x8C95,0xCC95,0x1C95,0x5C95,0x9C95,0xDC95,
 0x2C95,0x6C95,0xAC95,0xEC95,0x3C95,0x7C95,0xBC95,0xFC95,
 0x0195,0x4195,0x8195,0xC195,0x1195,0x5195,0x9195,0xD195,
 0x2195,0x6195,0xA195,0xE195,0x3195,0x7195,0xB195,0xF195,
 0x0595,0x4595,0x8595,0xC595,0x1595,0x5595,0x9595,0xD595,
 0x2595,0x6595,0xA595,0xE595,0x3595,0x7595,0xB595,0xF595,
 0x0995,0x4995,0x8995,0xC995,0x1995,0x5995,0x9995,0xD995,
 0x2995,0x6995,0xA995,0xE995,0x3995,0x7995,0xB995,0xF995,
 0x0D95,0x4D95,0x8D95,0xCD95,0x1D95,0x5D95,0x9D95,0xDD95,
 0x2D95,0x6D95,0xAD95,0xED95,0x3D95,0x7D95,0xBD95,0xFD95,
 0x0295,0x4295,0x8295,0xC295,0x1295,0x5295,0x9295,0xD295,
 0x2295,0x6295,0xA295,0xE295,0x3295,0x7295,0xB295,0xF295,
 0x0695,0x4695,0x8695,0xC695,0x1695,0x5695,0x9695,0xD695,
 0x2695,0x6695,0xA695,0xE695,0x3695,0x7695,0xB695,0xF695,
 0x0A95,0x4A95,0x8A95,0xCA95,0x1A95,0x5A95,0x9A95,0xDA95,
 0x2A95,0x6A95,0xAA95,0xEA95,0x3A95,0x7A95,0xBA95,0xFA95,
 0x0E95,0x4E95,0x8E95,0xCE95,0x1E95,0x5E95,0x9E95,0xDE95,
 0x2E95,0x6E95,0xAE95,0xEE95,0x3E95,0x7E95,0xBE95,0xFE95,
 0x0395,0x4395,0x8395,0xC395,0x1395,0x5395,0x9395,0xD395,
 0x2395,0x6395,0xA395,0xE395,0x3395,0x7395,0xB395,0xF395,
 0x0795,0x4795,0x8795,0xC795,0x1795,0x5795,0x9795,0xD795,
 0x2795,0x6795,0xA795,0xE795,0x3795,0x7795,0xB795,0xF795,
 0x0B95,0x4B95,0x8B95,0xCB95,0x1B95,0x5B95,0x9B95,0xDB95,
 0x2B95,0x6B95,0xAB95,0xEB95,0x3B95,0x7B95,0xBB95,0xFB95,
 0x0F95,0x4F95,0x8F95,0xCF95,0x1F95,0x5F95,0x9F95,0xDF95,
 0x2F95,0x6F95,0xAF95,0xEF95,0x3F95,0x7F95,0xBF95,0xFF95,
 0x00D5,0x40D5,0x80D5,0xC0D5,0x10D5,0x50D5,0x90D5,0xD0D5,
 0x20D5,0x60D5,0xA0D5,0xE0D5,0x30D5,0x70D5,0xB0D5,0xF0D5,
 0x04D5,0x44D5,0x84D5,0xC4D5,0x14D5,0x54D5,0x94D5,0xD4D5,
 0x24D5,0x64D5,0xA4D5,0xE4D5,0x34D5,0x74D5,0xB4D5,0xF4D5,
 0x08D5,0x48D5,0x88D5,0xC8D5,0x18D5,0x58D5,0x98D5,0xD8D5,
 0x28D5,0x68D5,0xA8D5,0xE8D5,0x38D5,0x78D5,0xB8D5,0xF8D5,
 0x0CD5,0x4CD5,0x8CD5,0xCCD5,0x1CD5,0x5CD5,0x9CD5,0xDCD5,
 0x2CD5,0x6CD5,0xACD5,0xECD5,0x3CD5,0x7CD5,0xBCD5,0xFCD5,
 0x01D5,0x41D5,0x81D5,0xC1D5,0x11D5,0x51D5,0x91D5,0xD1D5,
 0x21D5,0x61D5,0xA1D5,0xE1D5,0x31D5,0x71D5,0xB1D5,0xF1D5,
 0x05D5,0x45D5,0x85D5,0xC5D5,0x15D5,0x55D5,0x95D5,0xD5D5,
 0x25D5,0x65D5,0xA5D5,0xE5D5,0x35D5,0x75D5,0xB5D5,0xF5D5,
 0x09D5,0x49D5,0x89D5,0xC9D5,0x19D5,0x59D5,0x99D5,0xD9D5,
 0x29D5,0x69D5,0xA9D5,0xE9D5,0x39D5,0x79D5,0xB9D5,0xF9D5,
 0x0DD5,0x4DD5,0x8DD5,0xCDD5,0x1DD5,0x5DD5,0x9DD5,0xDDD5,
 0x2DD5,0x6DD5,0xADD5,0xEDD5,0x3DD5,0x7DD5,0xBDD5,0xFDD5,
 0x02D5,0x42D5,0x82D5,0xC2D5,0x12D5,0x52D5,0x92D5,0xD2D5,
 0x22D5,0x62D5,0xA2D5,0xE2D5,0x32D5,0x72D5,0xB2D5,0xF2D5,
 0x06D5,0x46D5,0x86D5,0xC6D5,0x16D5,0x56D5,0x96D5,0xD6D5,
 0x26D5,0x66D5,0xA6D5,0xE6D5,0x36D5,0x76D5,0xB6D5,0xF6D5,
 0x0AD5,0x4AD5,0x8AD5,0xCAD5,0x1AD5,0x5AD5,0x9AD5,0xDAD5,
 0x2AD5,0x6AD5,0xAAD5,0xEAD5,0x3AD5,0x7AD5,0xBAD5,0xFAD5,
 0x0ED5,0x4ED5,0x8ED5,0xCED5,0x1ED5,0x5ED5,0x9ED5,0xDED5,
 0x2ED5,0x6ED5,0xAED5,0xEED5,0x3ED5,0x7ED5,0xBED5,0xFED5,
 0x03D5,0x43D5,0x83D5,0xC3D5,0x13D5,0x53D5,0x93D5,0xD3D5,
 0x23D5,0x63D5,0xA3D5,0xE3D5,0x33D5,0x73D5,0xB3D5,0xF3D5,
 0x07D5,0x47D5,0x87D5,0xC7D5,0x17D5,0x57D5,0x97D5,0xD7D5,
 0x27D5,0x67D5,0xA7D5,0xE7D5,0x37D5,0x77D5,0xB7D5,0xF7D5,
 0x0BD5,0x4BD5,0x8BD5,0xCBD5,0x1BD5,0x5BD5,0x9BD5,0xDBD5,
 0x2BD5,0x6BD5,0xABD5,0xEBD5,0x3BD5,0x7BD5,0xBBD5,0xFBD5,
 0x0FD5,0x4FD5,0x8FD5,0xCFD5,0x1FD5,0x5FD5,0x9FD5,0xDFD5,
 0x2FD5,0x6FD5,0xAFD5,0xEFD5,0x3FD5,0x7FD5,0xBFD5,0xFFD5,
 0x0025,0x4025,0x8025,0xC025,0x1025,0x5025,0x9025,0xD025,
 0x2025,0x6025,0xA025,0xE025,0x3025,0x7025,0xB025,0xF025,
 0x0425,0x4425,0x8425,0xC425,0x1425,0x5425,0x9425,0xD425,
 0x2425,0x6425,0xA425,0xE425,0x3425,0x7425,0xB425,0xF425,
 0x0825,0x4825,0x8825,0xC825,0x1825,0x5825,0x9825,0xD825,
 0x2825,0x6825,0xA825,0xE825,0x3825,0x7825,0xB825,0xF825,
 0x0C25,0x4C25,0x8C25,0xCC25,0x1C25,0x5C25,0x9C25,0xDC25,
 0x2C25,0x6C25,0xAC25,0xEC25,0x3C25,0x7C25,0xBC25,0xFC25,
 0x0125,0x4125,0x8125,0xC125,0x1125,0x5125,0x9125,0xD125,
 0x2125,0x6125,0xA125,0xE125,0x3125,0x7125,0xB125,0xF125,
 0x0525,0x4525,0x8525,0xC525,0x1525,0x5525,0x9525,0xD525,
 0x2525,0x6525,0xA525,0xE525,0x3525,0x7525,0xB525,0xF525,
 0x0925,0x4925,0x8925,0xC925,0x1925,0x5925,0x9925,0xD925,
 0x2925,0x6925,0xA925,0xE925,0x3925,0x7925,0xB925,0xF925,
 0x0D25,0x4D25,0x8D25,0xCD25,0x1D25,0x5D25,0x9D25,0xDD25,
 0x2D25,0x6D25,0xAD25,0xED25,0x3D25,0x7D25,0xBD25,0xFD25,
 0x0225,0x4225,0x8225,0xC225,0x1225,0x5225,0x9225,0xD225,
 0x2225,0x6225,0xA225,0xE225,0x3225,0x7225,0xB225,0xF225,
 0x0625,0x4625,0x8625,0xC625,0x1625,0x5625,0x9625,0xD625,
 0x2625,0x6625,0xA625,0xE625,0x3625,0x7625,0xB625,0xF625,
 0x0A25,0x4A25,0x8A25,0xCA25,0x1A25,0x5A25,0x9A25,0xDA25,
 0x2A25,0x6A25,0xAA25,0xEA25,0x3A25,0x7A25,0xBA25,0xFA25,
 0x0E25,0x4E25,0x8E25,0xCE25,0x1E25,0x5E25,0x9E25,0xDE25,
 0x2E25,0x6E25,0xAE25,0xEE25,0x3E25,0x7E25,0xBE25,0xFE25,
 0x0325,0x4325,0x8325,0xC325,0x1325,0x5325,0x9325,0xD325,
 0x2325,0x6325,0xA325,0xE325,0x3325,0x7325,0xB325,0xF325,
 0x0725,0x4725,0x8725,0xC725,0x1725,0x5725,0x9725,0xD725,
 0x2725,0x6725,0xA725,0xE725,0x3725,0x7725,0xB725,0xF725,
 0x0B25,0x4B25,0x8B25,0xCB25,0x1B25,0x5B25,0x9B25,0xDB25,
 0x2B25,0x6B25,0xAB25,0xEB25,0x3B25,0x7B25,0xBB25,0xFB25,
 0x0F25,0x4F25,0x8F25,0xCF25,0x1F25,0x5F25,0x9F25,0xDF25,
 0x2F25,0x6F25,0xAF25,0xEF25,0x3F25,0x7F25,0xBF25,0xFF25,
 0x0065,0x4065,0x8065,0xC065,0x1065,0x5065,0x9065,0xD065,
 0x2065,0x6065,0xA065,0xE065,0x3065,0x7065,0xB065,0xF065,
 0x0465,0x4465,0x8465,0xC465,0x1465,0x5465,0x9465,0xD465,
 0x2465,0x6465,0xA465,0xE465,0x3465,0x7465,0xB465,0xF465,
 0x0865,0x4865,0x8865,0xC865,0x1865,0x5865,0x9865,0xD865,
 0x2865,0x6865,0xA865,0xE865,0x3865,0x7865,0xB865,0xF865,
 0x0C65,0x4C65,0x8C65,0xCC65,0x1C65,0x5C65,0x9C65,0xDC65,
 0x2C65,0x6C65,0xAC65,0xEC65,0x3C65,0x7C65,0xBC65,0xFC65,
 0x0165,0x4165,0x8165,0xC165,0x1165,0x5165,0x9165,0xD165,
 0x2165,0x6165,0xA165,0xE165,0x3165,0x7165,0xB165,0xF165,
 0x0565,0x4565,0x8565,0xC565,0x1565,0x5565,0x9565,0xD565,
 0x2565,0x6565,0xA565,0xE565,0x3565,0x7565,0xB565,0xF565,
 0x0965,0x4965,0x8965,0xC965,0x1965,0x5965,0x9965,0xD965,
 0x2965,0x6965,0xA965,0xE965,0x3965,0x7965,0xB965,0xF965,
 0x0D65,0x4D65,0x8D65,0xCD65,0x1D65,0x5D65,0x9D65,0xDD65,
 0x2D65,0x6D65,0xAD65,0xED65,0x3D65,0x7D65,0xBD65,0xFD65,
 0x0265,0x4265,0x8265,0xC265,0x1265,0x5265,0x9265,0xD265,
 0x2265,0x6265,0xA265,0xE265,0x3265,0x7265,0xB265,0xF265,
 0x0665,0x4665,0x8665,0xC665,0x1665,0x5665,0x9665,0xD665,
 0x2665,0x6665,0xA665,0xE665,0x3665,0x7665,0xB665,0xF665,
 0x0A65,0x4A65,0x8A65,0xCA65,0x1A65,0x5A65,0x9A65,0xDA65,
 0x2A65,0x6A65,0xAA65,0xEA65,0x3A65,0x7A65,0xBA65,0xFA65,
 0x0E65,0x4E65,0x8E65,0xCE65,0x1E65,0x5E65,0x9E65,0xDE65,
 0x2E65,0x6E65,0xAE65,0xEE65,0x3E65,0x7E65,0xBE65,0xFE65,
 0x0365,0x4365,0x8365,0xC365,0x1365,0x5365,0x9365,0xD365,
 0x2365,0x6365,0xA365,0xE365,0x3365,0x7365,0xB365,0xF365,
 0x0765,0x4765,0x8765,0xC765,0x1765,0x5765,0x9765,0xD765,
 0x2765,0x6765,0xA765,0xE765,0x3765,0x7765,0xB765,0xF765,
 0x0B65,0x4B65,0x8B65,0xCB65,0x1B65,0x5B65,0x9B65,0xDB65,
 0x2B65,0x6B65,0xAB65,0xEB65,0x3B65,0x7B65,0xBB65,0xFB65,
 0x0F65,0x4F65,0x8F65,0xCF65,0x1F65,0x5F65,0x9F65,0xDF65,
 0x2F65,0x6F65,0xAF65,0xEF65,0x3F65,0x7F65,0xBF65,0xFF65,
 0x00A5,0x40A5,0x80A5,0xC0A5,0x10A5,0x50A5,0x90A5,0xD0A5,
 0x20A5,0x60A5,0xA0A5,0xE0A5,0x30A5,0x70A5,0xB0A5,0xF0A5,
 0x04A5,0x44A5,0x84A5,0xC4A5,0x14A5,0x54A5,0x94A5,0xD4A5,
 0x24A5,0x64A5,0xA4A5,0xE4A5,0x34A5,0x74A5,0xB4A5,0xF4A5,
 0x08A5,0x48A5,0x88A5,0xC8A5,0x18A5,0x58A5,0x98A5,0xD8A5,
 0x28A5,0x68A5,0xA8A5,0xE8A5,0x38A5,0x78A5,0xB8A5,0xF8A5,
 0x0CA5,0x4CA5,0x8CA5,0xCCA5,0x1CA5,0x5CA5,0x9CA5,0xDCA5,
 0x2CA5,0x6CA5,0xACA5,0xECA5,0x3CA5,0x7CA5,0xBCA5,0xFCA5,
 0x01A5,0x41A5,0x81A5,0xC1A5,0x11A5,0x51A5,0x91A5,0xD1A5,
 0x21A5,0x61A5,0xA1A5,0xE1A5,0x31A5,0x71A5,0xB1A5,0xF1A5,
 0x05A5,0x45A5,0x85A5,0xC5A5,0x15A5,0x55A5,0x95A5,0xD5A5,
 0x25A5,0x65A5,0xA5A5,0xE5A5,0x35A5,0x75A5,0xB5A5,0xF5A5,
 0x09A5,0x49A5,0x89A5,0xC9A5,0x19A5,0x59A5,0x99A5,0xD9A5,
 0x29A5,0x69A5,0xA9A5,0xE9A5,0x39A5,0x79A5,0xB9A5,0xF9A5,
 0x0DA5,0x4DA5,0x8DA5,0xCDA5,0x1DA5,0x5DA5,0x9DA5,0xDDA5,
 0x2DA5,0x6DA5,0xADA5,0xEDA5,0x3DA5,0x7DA5,0xBDA5,0xFDA5,
 0x02A5,0x42A5,0x82A5,0xC2A5,0x12A5,0x52A5,0x92A5,0xD2A5,
 0x22A5,0x62A5,0xA2A5,0xE2A5,0x32A5,0x72A5,0xB2A5,0xF2A5,
 0x06A5,0x46A5,0x86A5,0xC6A5,0x16A5,0x56A5,0x96A5,0xD6A5,
 0x26A5,0x66A5,0xA6A5,0xE6A5,0x36A5,0x76A5,0xB6A5,0xF6A5,
 0x0AA5,0x4AA5,0x8AA5,0xCAA5,0x1AA5,0x5AA5,0x9AA5,0xDAA5,
 0x2AA5,0x6AA5,0xAAA5,0xEAA5,0x3AA5,0x7AA5,0xBAA5,0xFAA5,
 0x0EA5,0x4EA5,0x8EA5,0xCEA5,0x1EA5,0x5EA5,0x9EA5,0xDEA5,
 0x2EA5,0x6EA5,0xAEA5,0xEEA5,0x3EA5,0x7EA5,0xBEA5,0xFEA5,
 0x03A5,0x43A5,0x83A5,0xC3A5,0x13A5,0x53A5,0x93A5,0xD3A5,
 0x23A5,0x63A5,0xA3A5,0xE3A5,0x33A5,0x73A5,0xB3A5,0xF3A5,
 0x07A5,0x47A5,0x87A5,0xC7A5,0x17A5,0x57A5,0x97A5,0xD7A5,
 0x27A5,0x67A5,0xA7A5,0xE7A5,0x37A5,0x77A5,0xB7A5,0xF7A5,
 0x0BA5,0x4BA5,0x8BA5,0xCBA5,0x1BA5,0x5BA5,0x9BA5,0xDBA5,
 0x2BA5,0x6BA5,0xABA5,0xEBA5,0x3BA5,0x7BA5,0xBBA5,0xFBA5,
 0x0FA5,0x4FA5,0x8FA5,0xCFA5,0x1FA5,0x5FA5,0x9FA5,0xDFA5,
 0x2FA5,0x6FA5,0xAFA5,0xEFA5,0x3FA5,0x7FA5,0xBFA5,0xFFA5,
 0x00E5,0x40E5,0x80E5,0xC0E5,0x10E5,0x50E5,0x90E5,0xD0E5,
 0x20E5,0x60E5,0xA0E5,0xE0E5,0x30E5,0x70E5,0xB0E5,0xF0E5,
 0x04E5,0x44E5,0x84E5,0xC4E5,0x14E5,0x54E5,0x94E5,0xD4E5,
 0x24E5,0x64E5,0xA4E5,0xE4E5,0x34E5,0x74E5,0xB4E5,0xF4E5,
 0x08E5,0x48E5,0x88E5,0xC8E5,0x18E5,0x58E5,0x98E5,0xD8E5,
 0x28E5,0x68E5,0xA8E5,0xE8E5,0x38E5,0x78E5,0xB8E5,0xF8E5,
 0x0CE5,0x4CE5,0x8CE5,0xCCE5,0x1CE5,0x5CE5,0x9CE5,0xDCE5,
 0x2CE5,0x6CE5,0xACE5,0xECE5,0x3CE5,0x7CE5,0xBCE5,0xFCE5,
 0x01E5,0x41E5,0x81E5,0xC1E5,0x11E5,0x51E5,0x91E5,0xD1E5,
 0x21E5,0x61E5,0xA1E5,0xE1E5,0x31E5,0x71E5,0xB1E5,0xF1E5,
 0x05E5,0x45E5,0x85E5,0xC5E5,0x15E5,0x55E5,0x95E5,0xD5E5,
 0x25E5,0x65E5,0xA5E5,0xE5E5,0x35E5,0x75E5,0xB5E5,0xF5E5,
 0x09E5,0x49E5,0x89E5,0xC9E5,0x19E5,0x59E5,0x99E5,0xD9E5,
 0x29E5,0x69E5,0xA9E5,0xE9E5,0x39E5,0x79E5,0xB9E5,0xF9E5,
 0x0DE5,0x4DE5,0x8DE5,0xCDE5,0x1DE5,0x5DE5,0x9DE5,0xDDE5,
 0x2DE5,0x6DE5,0xADE5,0xEDE5,0x3DE5,0x7DE5,0xBDE5,0xFDE5,
 0x02E5,0x42E5,0x82E5,0xC2E5,0x12E5,0x52E5,0x92E5,0xD2E5,
 0x22E5,0x62E5,0xA2E5,0xE2E5,0x32E5,0x72E5,0xB2E5,0xF2E5,
 0x06E5,0x46E5,0x86E5,0xC6E5,0x16E5,0x56E5,0x96E5,0xD6E5,
 0x26E5,0x66E5,0xA6E5,0xE6E5,0x36E5,0x76E5,0xB6E5,0xF6E5,
 0x0AE5,0x4AE5,0x8AE5,0xCAE5,0x1AE5,0x5AE5,0x9AE5,0xDAE5,
 0x2AE5,0x6AE5,0xAAE5,0xEAE5,0x3AE5,0x7AE5,0xBAE5,0xFAE5,
 0x0EE5,0x4EE5,0x8EE5,0xCEE5,0x1EE5,0x5EE5,0x9EE5,0xDEE5,
 0x2EE5,0x6EE5,0xAEE5,0xEEE5,0x3EE5,0x7EE5,0xBEE5,0xFEE5,
 0x03E5,0x43E5,0x83E5,0xC3E5,0x13E5,0x53E5,0x93E5,0xD3E5,
 0x23E5,0x63E5,0xA3E5,0xE3E5,0x33E5,0x73E5,0xB3E5,0xF3E5,
 0x07E5,0x47E5,0x87E5,0xC7E5,0x17E5,0x57E5,0x97E5,0xD7E5,
 0x27E5,0x67E5,0xA7E5,0xE7E5,0x37E5,0x77E5,0xB7E5,0xF7E5,
 0x0BE5,0x4BE5,0x8BE5,0xCBE5,0x1BE5,0x5BE5,0x9BE5,0xDBE5,
 0x2BE5,0x6BE5,0xABE5,0xEBE5,0x3BE5,0x7BE5,0xBBE5,0xFBE5,
 0x0FE5,0x4FE5,0x8FE5,0xCFE5,0x1FE5,0x5FE5,0x9FE5,0xDFE5,
 0x2FE5,0x6FE5,0xAFE5,0xEFE5,0x3FE5,0x7FE5,0xBFE5,0xFFE5,
 0x0035,0x4035,0x8035,0xC035,0x1035,0x5035,0x9035,0xD035,
 0x2035,0x6035,0xA035,0xE035,0x3035,0x7035,0xB035,0xF035,
 0x0435,0x4435,0x8435,0xC435,0x1435,0x5435,0x9435,0xD435,
 0x2435,0x6435,0xA435,0xE435,0x3435,0x7435,0xB435,0xF435,
 0x0835,0x4835,0x8835,0xC835,0x1835,0x5835,0x9835,0xD835,
 0x2835,0x6835,0xA835,0xE835,0x3835,0x7835,0xB835,0xF835,
 0x0C35,0x4C35,0x8C35,0xCC35,0x1C35,0x5C35,0x9C35,0xDC35,
 0x2C35,0x6C35,0xAC35,0xEC35,0x3C35,0x7C35,0xBC35,0xFC35,
 0x0135,0x4135,0x8135,0xC135,0x1135,0x5135,0x9135,0xD135,
 0x2135,0x6135,0xA135,0xE135,0x3135,0x7135,0xB135,0xF135,
 0x0535,0x4535,0x8535,0xC535,0x1535,0x5535,0x9535,0xD535,
 0x2535,0x6535,0xA535,0xE535,0x3535,0x7535,0xB535,0xF535,
 0x0935,0x4935,0x8935,0xC935,0x1935,0x5935,0x9935,0xD935,
 0x2935,0x6935,0xA935,0xE935,0x3935,0x7935,0xB935,0xF935,
 0x0D35,0x4D35,0x8D35,0xCD35,0x1D35,0x5D35,0x9D35,0xDD35,
 0x2D35,0x6D35,0xAD35,0xED35,0x3D35,0x7D35,0xBD35,0xFD35,
 0x0235,0x4235,0x8235,0xC235,0x1235,0x5235,0x9235,0xD235,
 0x2235,0x6235,0xA235,0xE235,0x3235,0x7235,0xB235,0xF235,
 0x0635,0x4635,0x8635,0xC635,0x1635,0x5635,0x9635,0xD635,
 0x2635,0x6635,0xA635,0xE635,0x3635,0x7635,0xB635,0xF635,
 0x0A35,0x4A35,0x8A35,0xCA35,0x1A35,0x5A35,0x9A35,0xDA35,
 0x2A35,0x6A35,0xAA35,0xEA35,0x3A35,0x7A35,0xBA35,0xFA35,
 0x0E35,0x4E35,0x8E35,0xCE35,0x1E35,0x5E35,0x9E35,0xDE35,
 0x2E35,0x6E35,0xAE35,0xEE35,0x3E35,0x7E35,0xBE35,0xFE35,
 0x0335,0x4335,0x8335,0xC335,0x1335,0x5335,0x9335,0xD335,
 0x2335,0x6335,0xA335,0xE335,0x3335,0x7335,0xB335,0xF335,
 0x0735,0x4735,0x8735,0xC735,0x1735,0x5735,0x9735,0xD735,
 0x2735,0x6735,0xA735,0xE735,0x3735,0x7735,0xB735,0xF735,
 0x0B35,0x4B35,0x8B35,0xCB35,0x1B35,0x5B35,0x9B35,0xDB35,
 0x2B35,0x6B35,0xAB35,0xEB35,0x3B35,0x7B35,0xBB35,0xFB35,
 0x0F35,0x4F35,0x8F35,0xCF35,0x1F35,0x5F35,0x9F35,0xDF35,
 0x2F35,0x6F35,0xAF35,0xEF35,0x3F35,0x7F35,0xBF35,0xFF35,
 0x0075,0x4075,0x8075,0xC075,0x1075,0x5075,0x9075,0xD075,
 0x2075,0x6075,0xA075,0xE075,0x3075,0x7075,0xB075,0xF075,
 0x0475,0x4475,0x8475,0xC475,0x1475,0x5475,0x9475,0xD475,
 0x2475,0x6475,0xA475,0xE475,0x3475,0x7475,0xB475,0xF475,
 0x0875,0x4875,0x8875,0xC875,0x1875,0x5875,0x9875,0xD875,
 0x2875,0x6875,0xA875,0xE875,0x3875,0x7875,0xB875,0xF875,
 0x0C75,0x4C75,0x8C75,0xCC75,0x1C75,0x5C75,0x9C75,0xDC75,
 0x2C75,0x6C75,0xAC75,0xEC75,0x3C75,0x7C75,0xBC75,0xFC75,
 0x0175,0x4175,0x8175,0xC175,0x1175,0x5175,0x9175,0xD175,
 0x2175,0x6175,0xA175,0xE175,0x3175,0x7175,0xB175,0xF175,
 0x0575,0x4575,0x8575,0xC575,0x1575,0x5575,0x9575,0xD575,
 0x2575,0x6575,0xA575,0xE575,0x3575,0x7575,0xB575,0xF575,
 0x0975,0x4975,0x8975,0xC975,0x1975,0x5975,0x9975,0xD975,
 0x2975,0x6975,0xA975,0xE975,0x3975,0x7975,0xB975,0xF975,
 0x0D75,0x4D75,0x8D75,0xCD75,0x1D75,0x5D75,0x9D75,0xDD75,
 0x2D75,0x6D75,0xAD75,0xED75,0x3D75,0x7D75,0xBD75,0xFD75,
 0x0275,0x4275,0x8275,0xC275,0x1275,0x5275,0x9275,0xD275,
 0x2275,0x6275,0xA275,0xE275,0x3275,0x7275,0xB275,0xF275,
 0x0675,0x4675,0x8675,0xC675,0x1675,0x5675,0x9675,0xD675,
 0x2675,0x6675,0xA675,0xE675,0x3675,0x7675,0xB675,0xF675,
 0x0A75,0x4A75,0x8A75,0xCA75,0x1A75,0x5A75,0x9A75,0xDA75,
 0x2A75,0x6A75,0xAA75,0xEA75,0x3A75,0x7A75,0xBA75,0xFA75,
 0x0E75,0x4E75,0x8E75,0xCE75,0x1E75,0x5E75,0x9E75,0xDE75,
 0x2E75,0x6E75,0xAE75,0xEE75,0x3E75,0x7E75,0xBE75,0xFE75,
 0x0375,0x4375,0x8375,0xC375,0x1375,0x5375,0x9375,0xD375,
 0x2375,0x6375,0xA375,0xE375,0x3375,0x7375,0xB375,0xF375,
 0x0775,0x4775,0x8775,0xC775,0x1775,0x5775,0x9775,0xD775,
 0x2775,0x6775,0xA775,0xE775,0x3775,0x7775,0xB775,0xF775,
 0x0B75,0x4B75,0x8B75,0xCB75,0x1B75,0x5B75,0x9B75,0xDB75,
 0x2B75,0x6B75,0xAB75,0xEB75,0x3B75,0x7B75,0xBB75,0xFB75,
 0x0F75,0x4F75,0x8F75,0xCF75,0x1F75,0x5F75,0x9F75,0xDF75,
 0x2F75,0x6F75,0xAF75,0xEF75,0x3F75,0x7F75,0xBF75,0xFF75,
 0x00B5,0x40B5,0x80B5,0xC0B5,0x10B5,0x50B5,0x90B5,0xD0B5,
 0x20B5,0x60B5,0xA0B5,0xE0B5,0x30B5,0x70B5,0xB0B5,0xF0B5,
 0x04B5,0x44B5,0x84B5,0xC4B5,0x14B5,0x54B5,0x94B5,0xD4B5,
 0x24B5,0x64B5,0xA4B5,0xE4B5,0x34B5,0x74B5,0xB4B5,0xF4B5,
 0x08B5,0x48B5,0x88B5,0xC8B5,0x18B5,0x58B5,0x98B5,0xD8B5,
 0x28B5,0x68B5,0xA8B5,0xE8B5,0x38B5,0x78B5,0xB8B5,0xF8B5,
 0x0CB5,0x4CB5,0x8CB5,0xCCB5,0x1CB5,0x5CB5,0x9CB5,0xDCB5,
 0x2CB5,0x6CB5,0xACB5,0xECB5,0x3CB5,0x7CB5,0xBCB5,0xFCB5,
 0x01B5,0x41B5,0x81B5,0xC1B5,0x11B5,0x51B5,0x91B5,0xD1B5,
 0x21B5,0x61B5,0xA1B5,0xE1B5,0x31B5,0x71B5,0xB1B5,0xF1B5,
 0x05B5,0x45B5,0x85B5,0xC5B5,0x15B5,0x55B5,0x95B5,0xD5B5,
 0x25B5,0x65B5,0xA5B5,0xE5B5,0x35B5,0x75B5,0xB5B5,0xF5B5,
 0x09B5,0x49B5,0x89B5,0xC9B5,0x19B5,0x59B5,0x99B5,0xD9B5,
 0x29B5,0x69B5,0xA9B5,0xE9B5,0x39B5,0x79B5,0xB9B5,0xF9B5,
 0x0DB5,0x4DB5,0x8DB5,0xCDB5,0x1DB5,0x5DB5,0x9DB5,0xDDB5,
 0x2DB5,0x6DB5,0xADB5,0xEDB5,0x3DB5,0x7DB5,0xBDB5,0xFDB5,
 0x02B5,0x42B5,0x82B5,0xC2B5,0x12B5,0x52B5,0x92B5,0xD2B5,
 0x22B5,0x62B5,0xA2B5,0xE2B5,0x32B5,0x72B5,0xB2B5,0xF2B5,
 0x06B5,0x46B5,0x86B5,0xC6B5,0x16B5,0x56B5,0x96B5,0xD6B5,
 0x26B5,0x66B5,0xA6B5,0xE6B5,0x36B5,0x76B5,0xB6B5,0xF6B5,
 0x0AB5,0x4AB5,0x8AB5,0xCAB5,0x1AB5,0x5AB5,0x9AB5,0xDAB5,
 0x2AB5,0x6AB5,0xAAB5,0xEAB5,0x3AB5,0x7AB5,0xBAB5,0xFAB5,
 0x0EB5,0x4EB5,0x8EB5,0xCEB5,0x1EB5,0x5EB5,0x9EB5,0xDEB5,
 0x2EB5,0x6EB5,0xAEB5,0xEEB5,0x3EB5,0x7EB5,0xBEB5,0xFEB5,
 0x03B5,0x43B5,0x83B5,0xC3B5,0x13B5,0x53B5,0x93B5,0xD3B5,
 0x23B5,0x63B5,0xA3B5,0xE3B5,0x33B5,0x73B5,0xB3B5,0xF3B5,
 0x07B5,0x47B5,0x87B5,0xC7B5,0x17B5,0x57B5,0x97B5,0xD7B5,
 0x27B5,0x67B5,0xA7B5,0xE7B5,0x37B5,0x77B5,0xB7B5,0xF7B5,
 0x0BB5,0x4BB5,0x8BB5,0xCBB5,0x1BB5,0x5BB5,0x9BB5,0xDBB5,
 0x2BB5,0x6BB5,0xABB5,0xEBB5,0x3BB5,0x7BB5,0xBBB5,0xFBB5,
 0x0FB5,0x4FB5,0x8FB5,0xCFB5,0x1FB5,0x5FB5,0x9FB5,0xDFB5,
 0x2FB5,0x6FB5,0xAFB5,0xEFB5,0x3FB5,0x7FB5,0xBFB5,0xFFB5,
 0x00F5,0x40F5,0x80F5,0xC0F5,0x10F5,0x50F5,0x90F5,0xD0F5,
 0x20F5,0x60F5,0xA0F5,0xE0F5,0x30F5,0x70F5,0xB0F5,0xF0F5,
 0x04F5,0x44F5,0x84F5,0xC4F5,0x14F5,0x54F5,0x94F5,0xD4F5,
 0x24F5,0x64F5,0xA4F5,0xE4F5,0x34F5,0x74F5,0xB4F5,0xF4F5,
 0x08F5,0x48F5,0x88F5,0xC8F5,0x18F5,0x58F5,0x98F5,0xD8F5,
 0x28F5,0x68F5,0xA8F5,0xE8F5,0x38F5,0x78F5,0xB8F5,0xF8F5,
 0x0CF5,0x4CF5,0x8CF5,0xCCF5,0x1CF5,0x5CF5,0x9CF5,0xDCF5,
 0x2CF5,0x6CF5,0xACF5,0xECF5,0x3CF5,0x7CF5,0xBCF5,0xFCF5,
 0x01F5,0x41F5,0x81F5,0xC1F5,0x11F5,0x51F5,0x91F5,0xD1F5,
 0x21F5,0x61F5,0xA1F5,0xE1F5,0x31F5,0x71F5,0xB1F5,0xF1F5,
 0x05F5,0x45F5,0x85F5,0xC5F5,0x15F5,0x55F5,0x95F5,0xD5F5,
 0x25F5,0x65F5,0xA5F5,0xE5F5,0x35F5,0x75F5,0xB5F5,0xF5F5,
 0x09F5,0x49F5,0x89F5,0xC9F5,0x19F5,0x59F5,0x99F5,0xD9F5,
 0x29F5,0x69F5,0xA9F5,0xE9F5,0x39F5,0x79F5,0xB9F5,0xF9F5,
 0x0DF5,0x4DF5,0x8DF5,0xCDF5,0x1DF5,0x5DF5,0x9DF5,0xDDF5,
 0x2DF5,0x6DF5,0xADF5,0xEDF5,0x3DF5,0x7DF5,0xBDF5,0xFDF5,
 0x02F5,0x42F5,0x82F5,0xC2F5,0x12F5,0x52F5,0x92F5,0xD2F5,
 0x22F5,0x62F5,0xA2F5,0xE2F5,0x32F5,0x72F5,0xB2F5,0xF2F5,
 0x06F5,0x46F5,0x86F5,0xC6F5,0x16F5,0x56F5,0x96F5,0xD6F5,
 0x26F5,0x66F5,0xA6F5,0xE6F5,0x36F5,0x76F5,0xB6F5,0xF6F5,
 0x0AF5,0x4AF5,0x8AF5,0xCAF5,0x1AF5,0x5AF5,0x9AF5,0xDAF5,
 0x2AF5,0x6AF5,0xAAF5,0xEAF5,0x3AF5,0x7AF5,0xBAF5,0xFAF5,
 0x0EF5,0x4EF5,0x8EF5,0xCEF5,0x1EF5,0x5EF5,0x9EF5,0xDEF5,
 0x2EF5,0x6EF5,0xAEF5,0xEEF5,0x3EF5,0x7EF5,0xBEF5,0xFEF5,
 0x03F5,0x43F5,0x83F5,0xC3F5,0x13F5,0x53F5,0x93F5,0xD3F5,
 0x23F5,0x63F5,0xA3F5,0xE3F5,0x33F5,0x73F5,0xB3F5,0xF3F5,
 0x07F5,0x47F5,0x87F5,0xC7F5,0x17F5,0x57F5,0x97F5,0xD7F5,
 0x27F5,0x67F5,0xA7F5,0xE7F5,0x37F5,0x77F5,0xB7F5,0xF7F5,
 0x0BF5,0x4BF5,0x8BF5,0xCBF5,0x1BF5,0x5BF5,0x9BF5,0xDBF5,
 0x2BF5,0x6BF5,0xABF5,0xEBF5,0x3BF5,0x7BF5,0xBBF5,0xFBF5,
 0x0FF5,0x4FF5,0x8FF5,0xCFF5,0x1FF5,0x5FF5,0x9FF5,0xDFF5,
 0x2FF5,0x6FF5,0xAFF5,0xEFF5,0x3FF5,0x7FF5,0xBFF5,0xFFF5,
 0x0009,0x4009,0x8009,0xC009,0x1009,0x5009,0x9009,0xD009,
 0x2009,0x6009,0xA009,0xE009,0x3009,0x7009,0xB009,0xF009,
 0x0409,0x4409,0x8409,0xC409,0x1409,0x5409,0x9409,0xD409,
 0x2409,0x6409,0xA409,0xE409,0x3409,0x7409,0xB409,0xF409,
 0x0809,0x4809,0x8809,0xC809,0x1809,0x5809,0x9809,0xD809,
 0x2809,0x6809,0xA809,0xE809,0x3809,0x7809,0xB809,0xF809,
 0x0C09,0x4C09,0x8C09,0xCC09,0x1C09,0x5C09,0x9C09,0xDC09,
 0x2C09,0x6C09,0xAC09,0xEC09,0x3C09,0x7C09,0xBC09,0xFC09,
 0x0109,0x4109,0x8109,0xC109,0x1109,0x5109,0x9109,0xD109,
 0x2109,0x6109,0xA109,0xE109,0x3109,0x7109,0xB109,0xF109,
 0x0509,0x4509,0x8509,0xC509,0x1509,0x5509,0x9509,0xD509,
 0x2509,0x6509,0xA509,0xE509,0x3509,0x7509,0xB509,0xF509,
 0x0909,0x4909,0x8909,0xC909,0x1909,0x5909,0x9909,0xD909,
 0x2909,0x6909,0xA909,0xE909,0x3909,0x7909,0xB909,0xF909,
 0x0D09,0x4D09,0x8D09,0xCD09,0x1D09,0x5D09,0x9D09,0xDD09,
 0x2D09,0x6D09,0xAD09,0xED09,0x3D09,0x7D09,0xBD09,0xFD09,
 0x0209,0x4209,0x8209,0xC209,0x1209,0x5209,0x9209,0xD209,
 0x2209,0x6209,0xA209,0xE209,0x3209,0x7209,0xB209,0xF209,
 0x0609,0x4609,0x8609,0xC609,0x1609,0x5609,0x9609,0xD609,
 0x2609,0x6609,0xA609,0xE609,0x3609,0x7609,0xB609,0xF609,
 0x0A09,0x4A09,0x8A09,0xCA09,0x1A09,0x5A09,0x9A09,0xDA09,
 0x2A09,0x6A09,0xAA09,0xEA09,0x3A09,0x7A09,0xBA09,0xFA09,
 0x0E09,0x4E09,0x8E09,0xCE09,0x1E09,0x5E09,0x9E09,0xDE09,
 0x2E09,0x6E09,0xAE09,0xEE09,0x3E09,0x7E09,0xBE09,0xFE09,
 0x0309,0x4309,0x8309,0xC309,0x1309,0x5309,0x9309,0xD309,
 0x2309,0x6309,0xA309,0xE309,0x3309,0x7309,0xB309,0xF309,
 0x0709,0x4709,0x8709,0xC709,0x1709,0x5709,0x9709,0xD709,
 0x2709,0x6709,0xA709,0xE709,0x3709,0x7709,0xB709,0xF709,
 0x0B09,0x4B09,0x8B09,0xCB09,0x1B09,0x5B09,0x9B09,0xDB09,
 0x2B09,0x6B09,0xAB09,0xEB09,0x3B09,0x7B09,0xBB09,0xFB09,
 0x0F09,0x4F09,0x8F09,0xCF09,0x1F09,0x5F09,0x9F09,0xDF09,
 0x2F09,0x6F09,0xAF09,0xEF09,0x3F09,0x7F09,0xBF09,0xFF09,
 0x0049,0x4049,0x8049,0xC049,0x1049,0x5049,0x9049,0xD049,
 0x2049,0x6049,0xA049,0xE049,0x3049,0x7049,0xB049,0xF049,
 0x0449,0x4449,0x8449,0xC449,0x1449,0x5449,0x9449,0xD449,
 0x2449,0x6449,0xA449,0xE449,0x3449,0x7449,0xB449,0xF449,
 0x0849,0x4849,0x8849,0xC849,0x1849,0x5849,0x9849,0xD849,
 0x2849,0x6849,0xA849,0xE849,0x3849,0x7849,0xB849,0xF849,
 0x0C49,0x4C49,0x8C49,0xCC49,0x1C49,0x5C49,0x9C49,0xDC49,
 0x2C49,0x6C49,0xAC49,0xEC49,0x3C49,0x7C49,0xBC49,0xFC49,
 0x0149,0x4149,0x8149,0xC149,0x1149,0x5149,0x9149,0xD149,
 0x2149,0x6149,0xA149,0xE149,0x3149,0x7149,0xB149,0xF149,
 0x0549,0x4549,0x8549,0xC549,0x1549,0x5549,0x9549,0xD549,
 0x2549,0x6549,0xA549,0xE549,0x3549,0x7549,0xB549,0xF549,
 0x0949,0x4949,0x8949,0xC949,0x1949,0x5949,0x9949,0xD949,
 0x2949,0x6949,0xA949,0xE949,0x3949,0x7949,0xB949,0xF949,
 0x0D49,0x4D49,0x8D49,0xCD49,0x1D49,0x5D49,0x9D49,0xDD49,
 0x2D49,0x6D49,0xAD49,0xED49,0x3D49,0x7D49,0xBD49,0xFD49,
 0x0249,0x4249,0x8249,0xC249,0x1249,0x5249,0x9249,0xD249,
 0x2249,0x6249,0xA249,0xE249,0x3249,0x7249,0xB249,0xF249,
 0x0649,0x4649,0x8649,0xC649,0x1649,0x5649,0x9649,0xD649,
 0x2649,0x6649,0xA649,0xE649,0x3649,0x7649,0xB649,0xF649,
 0x0A49,0x4A49,0x8A49,0xCA49,0x1A49,0x5A49,0x9A49,0xDA49,
 0x2A49,0x6A49,0xAA49,0xEA49,0x3A49,0x7A49,0xBA49,0xFA49,
 0x0E49,0x4E49,0x8E49,0xCE49,0x1E49,0x5E49,0x9E49,0xDE49,
 0x2E49,0x6E49,0xAE49,0xEE49,0x3E49,0x7E49,0xBE49,0xFE49,
 0x0349,0x4349,0x8349,0xC349,0x1349,0x5349,0x9349,0xD349,
 0x2349,0x6349,0xA349,0xE349,0x3349,0x7349,0xB349,0xF349,
 0x0749,0x4749,0x8749,0xC749,0x1749,0x5749,0x9749,0xD749,
 0x2749,0x6749,0xA749,0xE749,0x3749,0x7749,0xB749,0xF749,
 0x0B49,0x4B49,0x8B49,0xCB49,0x1B49,0x5B49,0x9B49,0xDB49,
 0x2B49,0x6B49,0xAB49,0xEB49,0x3B49,0x7B49,0xBB49,0xFB49,
 0x0F49,0x4F49,0x8F49,0xCF49,0x1F49,0x5F49,0x9F49,0xDF49,
 0x2F49,0x6F49,0xAF49,0xEF49,0x3F49,0x7F49,0xBF49,0xFF49,
 0x0089,0x4089,0x8089,0xC089,0x1089,0x5089,0x9089,0xD089,
 0x2089,0x6089,0xA089,0xE089,0x3089,0x7089,0xB089,0xF089,
 0x0489,0x4489,0x8489,0xC489,0x1489,0x5489,0x9489,0xD489,
 0x2489,0x6489,0xA489,0xE489,0x3489,0x7489,0xB489,0xF489,
 0x0889,0x4889,0x8889,0xC889,0x1889,0x5889,0x9889,0xD889,
 0x2889,0x6889,0xA889,0xE889,0x3889,0x7889,0xB889,0xF889,
 0x0C89,0x4C89,0x8C89,0xCC89,0x1C89,0x5C89,0x9C89,0xDC89,
 0x2C89,0x6C89,0xAC89,0xEC89,0x3C89,0x7C89,0xBC89,0xFC89,
 0x0189,0x4189,0x8189,0xC189,0x1189,0x5189,0x9189,0xD189,
 0x2189,0x6189,0xA189,0xE189,0x3189,0x7189,0xB189,0xF189,
 0x0589,0x4589,0x8589,0xC589,0x1589,0x5589,0x9589,0xD589,
 0x2589,0x6589,0xA589,0xE589,0x3589,0x7589,0xB589,0xF589,
 0x0989,0x4989,0x8989,0xC989,0x1989,0x5989,0x9989,0xD989,
 0x2989,0x6989,0xA989,0xE989,0x3989,0x7989,0xB989,0xF989,
 0x0D89,0x4D89,0x8D89,0xCD89,0x1D89,0x5D89,0x9D89,0xDD89,
 0x2D89,0x6D89,0xAD89,0xED89,0x3D89,0x7D89,0xBD89,0xFD89,
 0x0289,0x4289,0x8289,0xC289,0x1289,0x5289,0x9289,0xD289,
 0x2289,0x6289,0xA289,0xE289,0x3289,0x7289,0xB289,0xF289,
 0x0689,0x4689,0x8689,0xC689,0x1689,0x5689,0x9689,0xD689,
 0x2689,0x6689,0xA689,0xE689,0x3689,0x7689,0xB689,0xF689,
 0x0A89,0x4A89,0x8A89,0xCA89,0x1A89,0x5A89,0x9A89,0xDA89,
 0x2A89,0x6A89,0xAA89,0xEA89,0x3A89,0x7A89,0xBA89,0xFA89,
 0x0E89,0x4E89,0x8E89,0xCE89,0x1E89,0x5E89,0x9E89,0xDE89,
 0x2E89,0x6E89,0xAE89,0xEE89,0x3E89,0x7E89,0xBE89,0xFE89,
 0x0389,0x4389,0x8389,0xC389,0x1389,0x5389,0x9389,0xD389,
 0x2389,0x6389,0xA389,0xE389,0x3389,0x7389,0xB389,0xF389,
 0x0789,0x4789,0x8789,0xC789,0x1789,0x5789,0x9789,0xD789,
 0x2789,0x6789,0xA789,0xE789,0x3789,0x7789,0xB789,0xF789,
 0x0B89,0x4B89,0x8B89,0xCB89,0x1B89,0x5B89,0x9B89,0xDB89,
 0x2B89,0x6B89,0xAB89,0xEB89,0x3B89,0x7B89,0xBB89,0xFB89,
 0x0F89,0x4F89,0x8F89,0xCF89,0x1F89,0x5F89,0x9F89,0xDF89,
 0x2F89,0x6F89,0xAF89,0xEF89,0x3F89,0x7F89,0xBF89,0xFF89,
 0x00C9,0x40C9,0x80C9,0xC0C9,0x10C9,0x50C9,0x90C9,0xD0C9,
 0x20C9,0x60C9,0xA0C9,0xE0C9,0x30C9,0x70C9,0xB0C9,0xF0C9,
 0x04C9,0x44C9,0x84C9,0xC4C9,0x14C9,0x54C9,0x94C9,0xD4C9,
 0x24C9,0x64C9,0xA4C9,0xE4C9,0x34C9,0x74C9,0xB4C9,0xF4C9,
 0x08C9,0x48C9,0x88C9,0xC8C9,0x18C9,0x58C9,0x98C9,0xD8C9,
 0x28C9,0x68C9,0xA8C9,0xE8C9,0x38C9,0x78C9,0xB8C9,0xF8C9,
 0x0CC9,0x4CC9,0x8CC9,0xCCC9,0x1CC9,0x5CC9,0x9CC9,0xDCC9,
 0x2CC9,0x6CC9,0xACC9,0xECC9,0x3CC9,0x7CC9,0xBCC9,0xFCC9,
 0x01C9,0x41C9,0x81C9,0xC1C9,0x11C9,0x51C9,0x91C9,0xD1C9,
 0x21C9,0x61C9,0xA1C9,0xE1C9,0x31C9,0x71C9,0xB1C9,0xF1C9,
 0x05C9,0x45C9,0x85C9,0xC5C9,0x15C9,0x55C9,0x95C9,0xD5C9,
 0x25C9,0x65C9,0xA5C9,0xE5C9,0x35C9,0x75C9,0xB5C9,0xF5C9,
 0x09C9,0x49C9,0x89C9,0xC9C9,0x19C9,0x59C9,0x99C9,0xD9C9,
 0x29C9,0x69C9,0xA9C9,0xE9C9,0x39C9,0x79C9,0xB9C9,0xF9C9,
 0x0DC9,0x4DC9,0x8DC9,0xCDC9,0x1DC9,0x5DC9,0x9DC9,0xDDC9,
 0x2DC9,0x6DC9,0xADC9,0xEDC9,0x3DC9,0x7DC9,0xBDC9,0xFDC9,
 0x02C9,0x42C9,0x82C9,0xC2C9,0x12C9,0x52C9,0x92C9,0xD2C9,
 0x22C9,0x62C9,0xA2C9,0xE2C9,0x32C9,0x72C9,0xB2C9,0xF2C9,
 0x06C9,0x46C9,0x86C9,0xC6C9,0x16C9,0x56C9,0x96C9,0xD6C9,
 0x26C9,0x66C9,0xA6C9,0xE6C9,0x36C9,0x76C9,0xB6C9,0xF6C9,
 0x0AC9,0x4AC9,0x8AC9,0xCAC9,0x1AC9,0x5AC9,0x9AC9,0xDAC9,
 0x2AC9,0x6AC9,0xAAC9,0xEAC9,0x3AC9,0x7AC9,0xBAC9,0xFAC9,
 0x0EC9,0x4EC9,0x8EC9,0xCEC9,0x1EC9,0x5EC9,0x9EC9,0xDEC9,
 0x2EC9,0x6EC9,0xAEC9,0xEEC9,0x3EC9,0x7EC9,0xBEC9,0xFEC9,
 0x03C9,0x43C9,0x83C9,0xC3C9,0x13C9,0x53C9,0x93C9,0xD3C9,
 0x23C9,0x63C9,0xA3C9,0xE3C9,0x33C9,0x73C9,0xB3C9,0xF3C9,
 0x07C9,0x47C9,0x87C9,0xC7C9,0x17C9,0x57C9,0x97C9,0xD7C9,
 0x27C9,0x67C9,0xA7C9,0xE7C9,0x37C9,0x77C9,0xB7C9,0xF7C9,
 0x0BC9,0x4BC9,0x8BC9,0xCBC9,0x1BC9,0x5BC9,0x9BC9,0xDBC9,
 0x2BC9,0x6BC9,0xABC9,0xEBC9,0x3BC9,0x7BC9,0xBBC9,0xFBC9,
 0x0FC9,0x4FC9,0x8FC9,0xCFC9,0x1FC9,0x5FC9,0x9FC9,0xDFC9,
 0x2FC9,0x6FC9,0xAFC9,0xEFC9,0x3FC9,0x7FC9,0xBFC9,0xFFC9,
 0x0019,0x4019,0x8019,0xC019,0x1019,0x5019,0x9019,0xD019,
 0x2019,0x6019,0xA019,0xE019,0x3019,0x7019,0xB019,0xF019,
 0x0419,0x4419,0x8419,0xC419,0x1419,0x5419,0x9419,0xD419,
 0x2419,0x6419,0xA419,0xE419,0x3419,0x7419,0xB419,0xF419,
 0x0819,0x4819,0x8819,0xC819,0x1819,0x5819,0x9819,0xD819,
 0x2819,0x6819,0xA819,0xE819,0x3819,0x7819,0xB819,0xF819,
 0x0C19,0x4C19,0x8C19,0xCC19,0x1C19,0x5C19,0x9C19,0xDC19,
 0x2C19,0x6C19,0xAC19,0xEC19,0x3C19,0x7C19,0xBC19,0xFC19,
 0x0119,0x4119,0x8119,0xC119,0x1119,0x5119,0x9119,0xD119,
 0x2119,0x6119,0xA119,0xE119,0x3119,0x7119,0xB119,0xF119,
 0x0519,0x4519,0x8519,0xC519,0x1519,0x5519,0x9519,0xD519,
 0x2519,0x6519,0xA519,0xE519,0x3519,0x7519,0xB519,0xF519,
 0x0919,0x4919,0x8919,0xC919,0x1919,0x5919,0x9919,0xD919,
 0x2919,0x6919,0xA919,0xE919,0x3919,0x7919,0xB919,0xF919,
 0x0D19,0x4D19,0x8D19,0xCD19,0x1D19,0x5D19,0x9D19,0xDD19,
 0x2D19,0x6D19,0xAD19,0xED19,0x3D19,0x7D19,0xBD19,0xFD19,
 0x0219,0x4219,0x8219,0xC219,0x1219,0x5219,0x9219,0xD219,
 0x2219,0x6219,0xA219,0xE219,0x3219,0x7219,0xB219,0xF219,
 0x0619,0x4619,0x8619,0xC619,0x1619,0x5619,0x9619,0xD619,
 0x2619,0x6619,0xA619,0xE619,0x3619,0x7619,0xB619,0xF619,
 0x0A19,0x4A19,0x8A19,0xCA19,0x1A19,0x5A19,0x9A19,0xDA19,
 0x2A19,0x6A19,0xAA19,0xEA19,0x3A19,0x7A19,0xBA19,0xFA19,
 0x0E19,0x4E19,0x8E19,0xCE19,0x1E19,0x5E19,0x9E19,0xDE19,
 0x2E19,0x6E19,0xAE19,0xEE19,0x3E19,0x7E19,0xBE19,0xFE19,
 0x0319,0x4319,0x8319,0xC319,0x1319,0x5319,0x9319,0xD319,
 0x2319,0x6319,0xA319,0xE319,0x3319,0x7319,0xB319,0xF319,
 0x0719,0x4719,0x8719,0xC719,0x1719,0x5719,0x9719,0xD719,
 0x2719,0x6719,0xA719,0xE719,0x3719,0x7719,0xB719,0xF719,
 0x0B19,0x4B19,0x8B19,0xCB19,0x1B19,0x5B19,0x9B19,0xDB19,
 0x2B19,0x6B19,0xAB19,0xEB19,0x3B19,0x7B19,0xBB19,0xFB19,
 0x0F19,0x4F19,0x8F19,0xCF19,0x1F19,0x5F19,0x9F19,0xDF19,
 0x2F19,0x6F19,0xAF19,0xEF19,0x3F19,0x7F19,0xBF19,0xFF19,
 0x0059,0x4059,0x8059,0xC059,0x1059,0x5059,0x9059,0xD059,
 0x2059,0x6059,0xA059,0xE059,0x3059,0x7059,0xB059,0xF059,
 0x0459,0x4459,0x8459,0xC459,0x1459,0x5459,0x9459,0xD459,
 0x2459,0x6459,0xA459,0xE459,0x3459,0x7459,0xB459,0xF459,
 0x0859,0x4859,0x8859,0xC859,0x1859,0x5859,0x9859,0xD859,
 0x2859,0x6859,0xA859,0xE859,0x3859,0x7859,0xB859,0xF859,
 0x0C59,0x4C59,0x8C59,0xCC59,0x1C59,0x5C59,0x9C59,0xDC59,
 0x2C59,0x6C59,0xAC59,0xEC59,0x3C59,0x7C59,0xBC59,0xFC59,
 0x0159,0x4159,0x8159,0xC159,0x1159,0x5159,0x9159,0xD159,
 0x2159,0x6159,0xA159,0xE159,0x3159,0x7159,0xB159,0xF159,
 0x0559,0x4559,0x8559,0xC559,0x1559,0x5559,0x9559,0xD559,
 0x2559,0x6559,0xA559,0xE559,0x3559,0x7559,0xB559,0xF559,
 0x0959,0x4959,0x8959,0xC959,0x1959,0x5959,0x9959,0xD959,
 0x2959,0x6959,0xA959,0xE959,0x3959,0x7959,0xB959,0xF959,
 0x0D59,0x4D59,0x8D59,0xCD59,0x1D59,0x5D59,0x9D59,0xDD59,
 0x2D59,0x6D59,0xAD59,0xED59,0x3D59,0x7D59,0xBD59,0xFD59,
 0x0259,0x4259,0x8259,0xC259,0x1259,0x5259,0x9259,0xD259,
 0x2259,0x6259,0xA259,0xE259,0x3259,0x7259,0xB259,0xF259,
 0x0659,0x4659,0x8659,0xC659,0x1659,0x5659,0x9659,0xD659,
 0x2659,0x6659,0xA659,0xE659,0x3659,0x7659,0xB659,0xF659,
 0x0A59,0x4A59,0x8A59,0xCA59,0x1A59,0x5A59,0x9A59,0xDA59,
 0x2A59,0x6A59,0xAA59,0xEA59,0x3A59,0x7A59,0xBA59,0xFA59,
 0x0E59,0x4E59,0x8E59,0xCE59,0x1E59,0x5E59,0x9E59,0xDE59,
 0x2E59,0x6E59,0xAE59,0xEE59,0x3E59,0x7E59,0xBE59,0xFE59,
 0x0359,0x4359,0x8359,0xC359,0x1359,0x5359,0x9359,0xD359,
 0x2359,0x6359,0xA359,0xE359,0x3359,0x7359,0xB359,0xF359,
 0x0759,0x4759,0x8759,0xC759,0x1759,0x5759,0x9759,0xD759,
 0x2759,0x6759,0xA759,0xE759,0x3759,0x7759,0xB759,0xF759,
 0x0B59,0x4B59,0x8B59,0xCB59,0x1B59,0x5B59,0x9B59,0xDB59,
 0x2B59,0x6B59,0xAB59,0xEB59,0x3B59,0x7B59,0xBB59,0xFB59,
 0x0F59,0x4F59,0x8F59,0xCF59,0x1F59,0x5F59,0x9F59,0xDF59,
 0x2F59,0x6F59,0xAF59,0xEF59,0x3F59,0x7F59,0xBF59,0xFF59,
 0x0099,0x4099,0x8099,0xC099,0x1099,0x5099,0x9099,0xD099,
 0x2099,0x6099,0xA099,0xE099,0x3099,0x7099,0xB099,0xF099,
 0x0499,0x4499,0x8499,0xC499,0x1499,0x5499,0x9499,0xD499,
 0x2499,0x6499,0xA499,0xE499,0x3499,0x7499,0xB499,0xF499,
 0x0899,0x4899,0x8899,0xC899,0x1899,0x5899,0x9899,0xD899,
 0x2899,0x6899,0xA899,0xE899,0x3899,0x7899,0xB899,0xF899,
 0x0C99,0x4C99,0x8C99,0xCC99,0x1C99,0x5C99,0x9C99,0xDC99,
 0x2C99,0x6C99,0xAC99,0xEC99,0x3C99,0x7C99,0xBC99,0xFC99,
 0x0199,0x4199,0x8199,0xC199,0x1199,0x5199,0x9199,0xD199,
 0x2199,0x6199,0xA199,0xE199,0x3199,0x7199,0xB199,0xF199,
 0x0599,0x4599,0x8599,0xC599,0x1599,0x5599,0x9599,0xD599,
 0x2599,0x6599,0xA599,0xE599,0x3599,0x7599,0xB599,0xF599,
 0x0999,0x4999,0x8999,0xC999,0x1999,0x5999,0x9999,0xD999,
 0x2999,0x6999,0xA999,0xE999,0x3999,0x7999,0xB999,0xF999,
 0x0D99,0x4D99,0x8D99,0xCD99,0x1D99,0x5D99,0x9D99,0xDD99,
 0x2D99,0x6D99,0xAD99,0xED99,0x3D99,0x7D99,0xBD99,0xFD99,
 0x0299,0x4299,0x8299,0xC299,0x1299,0x5299,0x9299,0xD299,
 0x2299,0x6299,0xA299,0xE299,0x3299,0x7299,0xB299,0xF299,
 0x0699,0x4699,0x8699,0xC699,0x1699,0x5699,0x9699,0xD699,
 0x2699,0x6699,0xA699,0xE699,0x3699,0x7699,0xB699,0xF699,
 0x0A99,0x4A99,0x8A99,0xCA99,0x1A99,0x5A99,0x9A99,0xDA99,
 0x2A99,0x6A99,0xAA99,0xEA99,0x3A99,0x7A99,0xBA99,0xFA99,
 0x0E99,0x4E99,0x8E99,0xCE99,0x1E99,0x5E99,0x9E99,0xDE99,
 0x2E99,0x6E99,0xAE99,0xEE99,0x3E99,0x7E99,0xBE99,0xFE99,
 0x0399,0x4399,0x8399,0xC399,0x1399,0x5399,0x9399,0xD399,
 0x2399,0x6399,0xA399,0xE399,0x3399,0x7399,0xB399,0xF399,
 0x0799,0x4799,0x8799,0xC799,0x1799,0x5799,0x9799,0xD799,
 0x2799,0x6799,0xA799,0xE799,0x3799,0x7799,0xB799,0xF799,
 0x0B99,0x4B99,0x8B99,0xCB99,0x1B99,0x5B99,0x9B99,0xDB99,
 0x2B99,0x6B99,0xAB99,0xEB99,0x3B99,0x7B99,0xBB99,0xFB99,
 0x0F99,0x4F99,0x8F99,0xCF99,0x1F99,0x5F99,0x9F99,0xDF99,
 0x2F99,0x6F99,0xAF99,0xEF99,0x3F99,0x7F99,0xBF99,0xFF99,
 0x00D9,0x40D9,0x80D9,0xC0D9,0x10D9,0x50D9,0x90D9,0xD0D9,
 0x20D9,0x60D9,0xA0D9,0xE0D9,0x30D9,0x70D9,0xB0D9,0xF0D9,
 0x04D9,0x44D9,0x84D9,0xC4D9,0x14D9,0x54D9,0x94D9,0xD4D9,
 0x24D9,0x64D9,0xA4D9,0xE4D9,0x34D9,0x74D9,0xB4D9,0xF4D9,
 0x08D9,0x48D9,0x88D9,0xC8D9,0x18D9,0x58D9,0x98D9,0xD8D9,
 0x28D9,0x68D9,0xA8D9,0xE8D9,0x38D9,0x78D9,0xB8D9,0xF8D9,
 0x0CD9,0x4CD9,0x8CD9,0xCCD9,0x1CD9,0x5CD9,0x9CD9,0xDCD9,
 0x2CD9,0x6CD9,0xACD9,0xECD9,0x3CD9,0x7CD9,0xBCD9,0xFCD9,
 0x01D9,0x41D9,0x81D9,0xC1D9,0x11D9,0x51D9,0x91D9,0xD1D9,
 0x21D9,0x61D9,0xA1D9,0xE1D9,0x31D9,0x71D9,0xB1D9,0xF1D9,
 0x05D9,0x45D9,0x85D9,0xC5D9,0x15D9,0x55D9,0x95D9,0xD5D9,
 0x25D9,0x65D9,0xA5D9,0xE5D9,0x35D9,0x75D9,0xB5D9,0xF5D9,
 0x09D9,0x49D9,0x89D9,0xC9D9,0x19D9,0x59D9,0x99D9,0xD9D9,
 0x29D9,0x69D9,0xA9D9,0xE9D9,0x39D9,0x79D9,0xB9D9,0xF9D9,
 0x0DD9,0x4DD9,0x8DD9,0xCDD9,0x1DD9,0x5DD9,0x9DD9,0xDDD9,
 0x2DD9,0x6DD9,0xADD9,0xEDD9,0x3DD9,0x7DD9,0xBDD9,0xFDD9,
 0x02D9,0x42D9,0x82D9,0xC2D9,0x12D9,0x52D9,0x92D9,0xD2D9,
 0x22D9,0x62D9,0xA2D9,0xE2D9,0x32D9,0x72D9,0xB2D9,0xF2D9,
 0x06D9,0x46D9,0x86D9,0xC6D9,0x16D9,0x56D9,0x96D9,0xD6D9,
 0x26D9,0x66D9,0xA6D9,0xE6D9,0x36D9,0x76D9,0xB6D9,0xF6D9,
 0x0AD9,0x4AD9,0x8AD9,0xCAD9,0x1AD9,0x5AD9,0x9AD9,0xDAD9,
 0x2AD9,0x6AD9,0xAAD9,0xEAD9,0x3AD9,0x7AD9,0xBAD9,0xFAD9,
 0x0ED9,0x4ED9,0x8ED9,0xCED9,0x1ED9,0x5ED9,0x9ED9,0xDED9,
 0x2ED9,0x6ED9,0xAED9,0xEED9,0x3ED9,0x7ED9,0xBED9,0xFED9,
 0x03D9,0x43D9,0x83D9,0xC3D9,0x13D9,0x53D9,0x93D9,0xD3D9,
 0x23D9,0x63D9,0xA3D9,0xE3D9,0x33D9,0x73D9,0xB3D9,0xF3D9,
 0x07D9,0x47D9,0x87D9,0xC7D9,0x17D9,0x57D9,0x97D9,0xD7D9,
 0x27D9,0x67D9,0xA7D9,0xE7D9,0x37D9,0x77D9,0xB7D9,0xF7D9,
 0x0BD9,0x4BD9,0x8BD9,0xCBD9,0x1BD9,0x5BD9,0x9BD9,0xDBD9,
 0x2BD9,0x6BD9,0xABD9,0xEBD9,0x3BD9,0x7BD9,0xBBD9,0xFBD9,
 0x0FD9,0x4FD9,0x8FD9,0xCFD9,0x1FD9,0x5FD9,0x9FD9,0xDFD9,
 0x2FD9,0x6FD9,0xAFD9,0xEFD9,0x3FD9,0x7FD9,0xBFD9,0xFFD9,
 0x0029,0x4029,0x8029,0xC029,0x1029,0x5029,0x9029,0xD029,
 0x2029,0x6029,0xA029,0xE029,0x3029,0x7029,0xB029,0xF029,
 0x0429,0x4429,0x8429,0xC429,0x1429,0x5429,0x9429,0xD429,
 0x2429,0x6429,0xA429,0xE429,0x3429,0x7429,0xB429,0xF429,
 0x0829,0x4829,0x8829,0xC829,0x1829,0x5829,0x9829,0xD829,
 0x2829,0x6829,0xA829,0xE829,0x3829,0x7829,0xB829,0xF829,
 0x0C29,0x4C29,0x8C29,0xCC29,0x1C29,0x5C29,0x9C29,0xDC29,
 0x2C29,0x6C29,0xAC29,0xEC29,0x3C29,0x7C29,0xBC29,0xFC29,
 0x0129,0x4129,0x8129,0xC129,0x1129,0x5129,0x9129,0xD129,
 0x2129,0x6129,0xA129,0xE129,0x3129,0x7129,0xB129,0xF129,
 0x0529,0x4529,0x8529,0xC529,0x1529,0x5529,0x9529,0xD529,
 0x2529,0x6529,0xA529,0xE529,0x3529,0x7529,0xB529,0xF529,
 0x0929,0x4929,0x8929,0xC929,0x1929,0x5929,0x9929,0xD929,
 0x2929,0x6929,0xA929,0xE929,0x3929,0x7929,0xB929,0xF929,
 0x0D29,0x4D29,0x8D29,0xCD29,0x1D29,0x5D29,0x9D29,0xDD29,
 0x2D29,0x6D29,0xAD29,0xED29,0x3D29,0x7D29,0xBD29,0xFD29,
 0x0229,0x4229,0x8229,0xC229,0x1229,0x5229,0x9229,0xD229,
 0x2229,0x6229,0xA229,0xE229,0x3229,0x7229,0xB229,0xF229,
 0x0629,0x4629,0x8629,0xC629,0x1629,0x5629,0x9629,0xD629,
 0x2629,0x6629,0xA629,0xE629,0x3629,0x7629,0xB629,0xF629,
 0x0A29,0x4A29,0x8A29,0xCA29,0x1A29,0x5A29,0x9A29,0xDA29,
 0x2A29,0x6A29,0xAA29,0xEA29,0x3A29,0x7A29,0xBA29,0xFA29,
 0x0E29,0x4E29,0x8E29,0xCE29,0x1E29,0x5E29,0x9E29,0xDE29,
 0x2E29,0x6E29,0xAE29,0xEE29,0x3E29,0x7E29,0xBE29,0xFE29,
 0x0329,0x4329,0x8329,0xC329,0x1329,0x5329,0x9329,0xD329,
 0x2329,0x6329,0xA329,0xE329,0x3329,0x7329,0xB329,0xF329,
 0x0729,0x4729,0x8729,0xC729,0x1729,0x5729,0x9729,0xD729,
 0x2729,0x6729,0xA729,0xE729,0x3729,0x7729,0xB729,0xF729,
 0x0B29,0x4B29,0x8B29,0xCB29,0x1B29,0x5B29,0x9B29,0xDB29,
 0x2B29,0x6B29,0xAB29,0xEB29,0x3B29,0x7B29,0xBB29,0xFB29,
 0x0F29,0x4F29,0x8F29,0xCF29,0x1F29,0x5F29,0x9F29,0xDF29,
 0x2F29,0x6F29,0xAF29,0xEF29,0x3F29,0x7F29,0xBF29,0xFF29,
 0x0069,0x4069,0x8069,0xC069,0x1069,0x5069,0x9069,0xD069,
 0x2069,0x6069,0xA069,0xE069,0x3069,0x7069,0xB069,0xF069,
 0x0469,0x4469,0x8469,0xC469,0x1469,0x5469,0x9469,0xD469,
 0x2469,0x6469,0xA469,0xE469,0x3469,0x7469,0xB469,0xF469,
 0x0869,0x4869,0x8869,0xC869,0x1869,0x5869,0x9869,0xD869,
 0x2869,0x6869,0xA869,0xE869,0x3869,0x7869,0xB869,0xF869,
 0x0C69,0x4C69,0x8C69,0xCC69,0x1C69,0x5C69,0x9C69,0xDC69,
 0x2C69,0x6C69,0xAC69,0xEC69,0x3C69,0x7C69,0xBC69,0xFC69,
 0x0169,0x4169,0x8169,0xC169,0x1169,0x5169,0x9169,0xD169,
 0x2169,0x6169,0xA169,0xE169,0x3169,0x7169,0xB169,0xF169,
 0x0569,0x4569,0x8569,0xC569,0x1569,0x5569,0x9569,0xD569,
 0x2569,0x6569,0xA569,0xE569,0x3569,0x7569,0xB569,0xF569,
 0x0969,0x4969,0x8969,0xC969,0x1969,0x5969,0x9969,0xD969,
 0x2969,0x6969,0xA969,0xE969,0x3969,0x7969,0xB969,0xF969,
 0x0D69,0x4D69,0x8D69,0xCD69,0x1D69,0x5D69,0x9D69,0xDD69,
 0x2D69,0x6D69,0xAD69,0xED69,0x3D69,0x7D69,0xBD69,0xFD69,
 0x0269,0x4269,0x8269,0xC269,0x1269,0x5269,0x9269,0xD269,
 0x2269,0x6269,0xA269,0xE269,0x3269,0x7269,0xB269,0xF269,
 0x0669,0x4669,0x8669,0xC669,0x1669,0x5669,0x9669,0xD669,
 0x2669,0x6669,0xA669,0xE669,0x3669,0x7669,0xB669,0xF669,
 0x0A69,0x4A69,0x8A69,0xCA69,0x1A69,0x5A69,0x9A69,0xDA69,
 0x2A69,0x6A69,0xAA69,0xEA69,0x3A69,0x7A69,0xBA69,0xFA69,
 0x0E69,0x4E69,0x8E69,0xCE69,0x1E69,0x5E69,0x9E69,0xDE69,
 0x2E69,0x6E69,0xAE69,0xEE69,0x3E69,0x7E69,0xBE69,0xFE69,
 0x0369,0x4369,0x8369,0xC369,0x1369,0x5369,0x9369,0xD369,
 0x2369,0x6369,0xA369,0xE369,0x3369,0x7369,0xB369,0xF369,
 0x0769,0x4769,0x8769,0xC769,0x1769,0x5769,0x9769,0xD769,
 0x2769,0x6769,0xA769,0xE769,0x3769,0x7769,0xB769,0xF769,
 0x0B69,0x4B69,0x8B69,0xCB69,0x1B69,0x5B69,0x9B69,0xDB69,
 0x2B69,0x6B69,0xAB69,0xEB69,0x3B69,0x7B69,0xBB69,0xFB69,
 0x0F69,0x4F69,0x8F69,0xCF69,0x1F69,0x5F69,0x9F69,0xDF69,
 0x2F69,0x6F69,0xAF69,0xEF69,0x3F69,0x7F69,0xBF69,0xFF69,
 0x00A9,0x40A9,0x80A9,0xC0A9,0x10A9,0x50A9,0x90A9,0xD0A9,
 0x20A9,0x60A9,0xA0A9,0xE0A9,0x30A9,0x70A9,0xB0A9,0xF0A9,
 0x04A9,0x44A9,0x84A9,0xC4A9,0x14A9,0x54A9,0x94A9,0xD4A9,
 0x24A9,0x64A9,0xA4A9,0xE4A9,0x34A9,0x74A9,0xB4A9,0xF4A9,
 0x08A9,0x48A9,0x88A9,0xC8A9,0x18A9,0x58A9,0x98A9,0xD8A9,
 0x28A9,0x68A9,0xA8A9,0xE8A9,0x38A9,0x78A9,0xB8A9,0xF8A9,
 0x0CA9,0x4CA9,0x8CA9,0xCCA9,0x1CA9,0x5CA9,0x9CA9,0xDCA9,
 0x2CA9,0x6CA9,0xACA9,0xECA9,0x3CA9,0x7CA9,0xBCA9,0xFCA9,
 0x01A9,0x41A9,0x81A9,0xC1A9,0x11A9,0x51A9,0x91A9,0xD1A9,
 0x21A9,0x61A9,0xA1A9,0xE1A9,0x31A9,0x71A9,0xB1A9,0xF1A9,
 0x05A9,0x45A9,0x85A9,0xC5A9,0x15A9,0x55A9,0x95A9,0xD5A9,
 0x25A9,0x65A9,0xA5A9,0xE5A9,0x35A9,0x75A9,0xB5A9,0xF5A9,
 0x09A9,0x49A9,0x89A9,0xC9A9,0x19A9,0x59A9,0x99A9,0xD9A9,
 0x29A9,0x69A9,0xA9A9,0xE9A9,0x39A9,0x79A9,0xB9A9,0xF9A9,
 0x0DA9,0x4DA9,0x8DA9,0xCDA9,0x1DA9,0x5DA9,0x9DA9,0xDDA9,
 0x2DA9,0x6DA9,0xADA9,0xEDA9,0x3DA9,0x7DA9,0xBDA9,0xFDA9,
 0x02A9,0x42A9,0x82A9,0xC2A9,0x12A9,0x52A9,0x92A9,0xD2A9,
 0x22A9,0x62A9,0xA2A9,0xE2A9,0x32A9,0x72A9,0xB2A9,0xF2A9,
 0x06A9,0x46A9,0x86A9,0xC6A9,0x16A9,0x56A9,0x96A9,0xD6A9,
 0x26A9,0x66A9,0xA6A9,0xE6A9,0x36A9,0x76A9,0xB6A9,0xF6A9,
 0x0AA9,0x4AA9,0x8AA9,0xCAA9,0x1AA9,0x5AA9,0x9AA9,0xDAA9,
 0x2AA9,0x6AA9,0xAAA9,0xEAA9,0x3AA9,0x7AA9,0xBAA9,0xFAA9,
 0x0EA9,0x4EA9,0x8EA9,0xCEA9,0x1EA9,0x5EA9,0x9EA9,0xDEA9,
 0x2EA9,0x6EA9,0xAEA9,0xEEA9,0x3EA9,0x7EA9,0xBEA9,0xFEA9,
 0x03A9,0x43A9,0x83A9,0xC3A9,0x13A9,0x53A9,0x93A9,0xD3A9,
 0x23A9,0x63A9,0xA3A9,0xE3A9,0x33A9,0x73A9,0xB3A9,0xF3A9,
 0x07A9,0x47A9,0x87A9,0xC7A9,0x17A9,0x57A9,0x97A9,0xD7A9,
 0x27A9,0x67A9,0xA7A9,0xE7A9,0x37A9,0x77A9,0xB7A9,0xF7A9,
 0x0BA9,0x4BA9,0x8BA9,0xCBA9,0x1BA9,0x5BA9,0x9BA9,0xDBA9,
 0x2BA9,0x6BA9,0xABA9,0xEBA9,0x3BA9,0x7BA9,0xBBA9,0xFBA9,
 0x0FA9,0x4FA9,0x8FA9,0xCFA9,0x1FA9,0x5FA9,0x9FA9,0xDFA9,
 0x2FA9,0x6FA9,0xAFA9,0xEFA9,0x3FA9,0x7FA9,0xBFA9,0xFFA9,
 0x00E9,0x40E9,0x80E9,0xC0E9,0x10E9,0x50E9,0x90E9,0xD0E9,
 0x20E9,0x60E9,0xA0E9,0xE0E9,0x30E9,0x70E9,0xB0E9,0xF0E9,
 0x04E9,0x44E9,0x84E9,0xC4E9,0x14E9,0x54E9,0x94E9,0xD4E9,
 0x24E9,0x64E9,0xA4E9,0xE4E9,0x34E9,0x74E9,0xB4E9,0xF4E9,
 0x08E9,0x48E9,0x88E9,0xC8E9,0x18E9,0x58E9,0x98E9,0xD8E9,
 0x28E9,0x68E9,0xA8E9,0xE8E9,0x38E9,0x78E9,0xB8E9,0xF8E9,
 0x0CE9,0x4CE9,0x8CE9,0xCCE9,0x1CE9,0x5CE9,0x9CE9,0xDCE9,
 0x2CE9,0x6CE9,0xACE9,0xECE9,0x3CE9,0x7CE9,0xBCE9,0xFCE9,
 0x01E9,0x41E9,0x81E9,0xC1E9,0x11E9,0x51E9,0x91E9,0xD1E9,
 0x21E9,0x61E9,0xA1E9,0xE1E9,0x31E9,0x71E9,0xB1E9,0xF1E9,
 0x05E9,0x45E9,0x85E9,0xC5E9,0x15E9,0x55E9,0x95E9,0xD5E9,
 0x25E9,0x65E9,0xA5E9,0xE5E9,0x35E9,0x75E9,0xB5E9,0xF5E9,
 0x09E9,0x49E9,0x89E9,0xC9E9,0x19E9,0x59E9,0x99E9,0xD9E9,
 0x29E9,0x69E9,0xA9E9,0xE9E9,0x39E9,0x79E9,0xB9E9,0xF9E9,
 0x0DE9,0x4DE9,0x8DE9,0xCDE9,0x1DE9,0x5DE9,0x9DE9,0xDDE9,
 0x2DE9,0x6DE9,0xADE9,0xEDE9,0x3DE9,0x7DE9,0xBDE9,0xFDE9,
 0x02E9,0x42E9,0x82E9,0xC2E9,0x12E9,0x52E9,0x92E9,0xD2E9,
 0x22E9,0x62E9,0xA2E9,0xE2E9,0x32E9,0x72E9,0xB2E9,0xF2E9,
 0x06E9,0x46E9,0x86E9,0xC6E9,0x16E9,0x56E9,0x96E9,0xD6E9,
 0x26E9,0x66E9,0xA6E9,0xE6E9,0x36E9,0x76E9,0xB6E9,0xF6E9,
 0x0AE9,0x4AE9,0x8AE9,0xCAE9,0x1AE9,0x5AE9,0x9AE9,0xDAE9,
 0x2AE9,0x6AE9,0xAAE9,0xEAE9,0x3AE9,0x7AE9,0xBAE9,0xFAE9,
 0x0EE9,0x4EE9,0x8EE9,0xCEE9,0x1EE9,0x5EE9,0x9EE9,0xDEE9,
 0x2EE9,0x6EE9,0xAEE9,0xEEE9,0x3EE9,0x7EE9,0xBEE9,0xFEE9,
 0x03E9,0x43E9,0x83E9,0xC3E9,0x13E9,0x53E9,0x93E9,0xD3E9,
 0x23E9,0x63E9,0xA3E9,0xE3E9,0x33E9,0x73E9,0xB3E9,0xF3E9,
 0x07E9,0x47E9,0x87E9,0xC7E9,0x17E9,0x57E9,0x97E9,0xD7E9,
 0x27E9,0x67E9,0xA7E9,0xE7E9,0x37E9,0x77E9,0xB7E9,0xF7E9,
 0x0BE9,0x4BE9,0x8BE9,0xCBE9,0x1BE9,0x5BE9,0x9BE9,0xDBE9,
 0x2BE9,0x6BE9,0xABE9,0xEBE9,0x3BE9,0x7BE9,0xBBE9,0xFBE9,
 0x0FE9,0x4FE9,0x8FE9,0xCFE9,0x1FE9,0x5FE9,0x9FE9,0xDFE9,
 0x2FE9,0x6FE9,0xAFE9,0xEFE9,0x3FE9,0x7FE9,0xBFE9,0xFFE9,
 0x0039,0x4039,0x8039,0xC039,0x1039,0x5039,0x9039,0xD039,
 0x2039,0x6039,0xA039,0xE039,0x3039,0x7039,0xB039,0xF039,
 0x0439,0x4439,0x8439,0xC439,0x1439,0x5439,0x9439,0xD439,
 0x2439,0x6439,0xA439,0xE439,0x3439,0x7439,0xB439,0xF439,
 0x0839,0x4839,0x8839,0xC839,0x1839,0x5839,0x9839,0xD839,
 0x2839,0x6839,0xA839,0xE839,0x3839,0x7839,0xB839,0xF839,
 0x0C39,0x4C39,0x8C39,0xCC39,0x1C39,0x5C39,0x9C39,0xDC39,
 0x2C39,0x6C39,0xAC39,0xEC39,0x3C39,0x7C39,0xBC39,0xFC39,
 0x0139,0x4139,0x8139,0xC139,0x1139,0x5139,0x9139,0xD139,
 0x2139,0x6139,0xA139,0xE139,0x3139,0x7139,0xB139,0xF139,
 0x0539,0x4539,0x8539,0xC539,0x1539,0x5539,0x9539,0xD539,
 0x2539,0x6539,0xA539,0xE539,0x3539,0x7539,0xB539,0xF539,
 0x0939,0x4939,0x8939,0xC939,0x1939,0x5939,0x9939,0xD939,
 0x2939,0x6939,0xA939,0xE939,0x3939,0x7939,0xB939,0xF939,
 0x0D39,0x4D39,0x8D39,0xCD39,0x1D39,0x5D39,0x9D39,0xDD39,
 0x2D39,0x6D39,0xAD39,0xED39,0x3D39,0x7D39,0xBD39,0xFD39,
 0x0239,0x4239,0x8239,0xC239,0x1239,0x5239,0x9239,0xD239,
 0x2239,0x6239,0xA239,0xE239,0x3239,0x7239,0xB239,0xF239,
 0x0639,0x4639,0x8639,0xC639,0x1639,0x5639,0x9639,0xD639,
 0x2639,0x6639,0xA639,0xE639,0x3639,0x7639,0xB639,0xF639,
 0x0A39,0x4A39,0x8A39,0xCA39,0x1A39,0x5A39,0x9A39,0xDA39,
 0x2A39,0x6A39,0xAA39,0xEA39,0x3A39,0x7A39,0xBA39,0xFA39,
 0x0E39,0x4E39,0x8E39,0xCE39,0x1E39,0x5E39,0x9E39,0xDE39,
 0x2E39,0x6E39,0xAE39,0xEE39,0x3E39,0x7E39,0xBE39,0xFE39,
 0x0339,0x4339,0x8339,0xC339,0x1339,0x5339,0x9339,0xD339,
 0x2339,0x6339,0xA339,0xE339,0x3339,0x7339,0xB339,0xF339,
 0x0739,0x4739,0x8739,0xC739,0x1739,0x5739,0x9739,0xD739,
 0x2739,0x6739,0xA739,0xE739,0x3739,0x7739,0xB739,0xF739,
 0x0B39,0x4B39,0x8B39,0xCB39,0x1B39,0x5B39,0x9B39,0xDB39,
 0x2B39,0x6B39,0xAB39,0xEB39,0x3B39,0x7B39,0xBB39,0xFB39,
 0x0F39,0x4F39,0x8F39,0xCF39,0x1F39,0x5F39,0x9F39,0xDF39,
 0x2F39,0x6F39,0xAF39,0xEF39,0x3F39,0x7F39,0xBF39,0xFF39,
 0x0079,0x4079,0x8079,0xC079,0x1079,0x5079,0x9079,0xD079,
 0x2079,0x6079,0xA079,0xE079,0x3079,0x7079,0xB079,0xF079,
 0x0479,0x4479,0x8479,0xC479,0x1479,0x5479,0x9479,0xD479,
 0x2479,0x6479,0xA479,0xE479,0x3479,0x7479,0xB479,0xF479,
 0x0879,0x4879,0x8879,0xC879,0x1879,0x5879,0x9879,0xD879,
 0x2879,0x6879,0xA879,0xE879,0x3879,0x7879,0xB879,0xF879,
 0x0C79,0x4C79,0x8C79,0xCC79,0x1C79,0x5C79,0x9C79,0xDC79,
 0x2C79,0x6C79,0xAC79,0xEC79,0x3C79,0x7C79,0xBC79,0xFC79,
 0x0179,0x4179,0x8179,0xC179,0x1179,0x5179,0x9179,0xD179,
 0x2179,0x6179,0xA179,0xE179,0x3179,0x7179,0xB179,0xF179,
 0x0579,0x4579,0x8579,0xC579,0x1579,0x5579,0x9579,0xD579,
 0x2579,0x6579,0xA579,0xE579,0x3579,0x7579,0xB579,0xF579,
 0x0979,0x4979,0x8979,0xC979,0x1979,0x5979,0x9979,0xD979,
 0x2979,0x6979,0xA979,0xE979,0x3979,0x7979,0xB979,0xF979,
 0x0D79,0x4D79,0x8D79,0xCD79,0x1D79,0x5D79,0x9D79,0xDD79,
 0x2D79,0x6D79,0xAD79,0xED79,0x3D79,0x7D79,0xBD79,0xFD79,
 0x0279,0x4279,0x8279,0xC279,0x1279,0x5279,0x9279,0xD279,
 0x2279,0x6279,0xA279,0xE279,0x3279,0x7279,0xB279,0xF279,
 0x0679,0x4679,0x8679,0xC679,0x1679,0x5679,0x9679,0xD679,
 0x2679,0x6679,0xA679,0xE679,0x3679,0x7679,0xB679,0xF679,
 0x0A79,0x4A79,0x8A79,0xCA79,0x1A79,0x5A79,0x9A79,0xDA79,
 0x2A79,0x6A79,0xAA79,0xEA79,0x3A79,0x7A79,0xBA79,0xFA79,
 0x0E79,0x4E79,0x8E79,0xCE79,0x1E79,0x5E79,0x9E79,0xDE79,
 0x2E79,0x6E79,0xAE79,0xEE79,0x3E79,0x7E79,0xBE79,0xFE79,
 0x0379,0x4379,0x8379,0xC379,0x1379,0x5379,0x9379,0xD379,
 0x2379,0x6379,0xA379,0xE379,0x3379,0x7379,0xB379,0xF379,
 0x0779,0x4779,0x8779,0xC779,0x1779,0x5779,0x9779,0xD779,
 0x2779,0x6779,0xA779,0xE779,0x3779,0x7779,0xB779,0xF779,
 0x0B79,0x4B79,0x8B79,0xCB79,0x1B79,0x5B79,0x9B79,0xDB79,
 0x2B79,0x6B79,0xAB79,0xEB79,0x3B79,0x7B79,0xBB79,0xFB79,
 0x0F79,0x4F79,0x8F79,0xCF79,0x1F79,0x5F79,0x9F79,0xDF79,
 0x2F79,0x6F79,0xAF79,0xEF79,0x3F79,0x7F79,0xBF79,0xFF79,
 0x00B9,0x40B9,0x80B9,0xC0B9,0x10B9,0x50B9,0x90B9,0xD0B9,
 0x20B9,0x60B9,0xA0B9,0xE0B9,0x30B9,0x70B9,0xB0B9,0xF0B9,
 0x04B9,0x44B9,0x84B9,0xC4B9,0x14B9,0x54B9,0x94B9,0xD4B9,
 0x24B9,0x64B9,0xA4B9,0xE4B9,0x34B9,0x74B9,0xB4B9,0xF4B9,
 0x08B9,0x48B9,0x88B9,0xC8B9,0x18B9,0x58B9,0x98B9,0xD8B9,
 0x28B9,0x68B9,0xA8B9,0xE8B9,0x38B9,0x78B9,0xB8B9,0xF8B9,
 0x0CB9,0x4CB9,0x8CB9,0xCCB9,0x1CB9,0x5CB9,0x9CB9,0xDCB9,
 0x2CB9,0x6CB9,0xACB9,0xECB9,0x3CB9,0x7CB9,0xBCB9,0xFCB9,
 0x01B9,0x41B9,0x81B9,0xC1B9,0x11B9,0x51B9,0x91B9,0xD1B9,
 0x21B9,0x61B9,0xA1B9,0xE1B9,0x31B9,0x71B9,0xB1B9,0xF1B9,
 0x05B9,0x45B9,0x85B9,0xC5B9,0x15B9,0x55B9,0x95B9,0xD5B9,
 0x25B9,0x65B9,0xA5B9,0xE5B9,0x35B9,0x75B9,0xB5B9,0xF5B9,
 0x09B9,0x49B9,0x89B9,0xC9B9,0x19B9,0x59B9,0x99B9,0xD9B9,
 0x29B9,0x69B9,0xA9B9,0xE9B9,0x39B9,0x79B9,0xB9B9,0xF9B9,
 0x0DB9,0x4DB9,0x8DB9,0xCDB9,0x1DB9,0x5DB9,0x9DB9,0xDDB9,
 0x2DB9,0x6DB9,0xADB9,0xEDB9,0x3DB9,0x7DB9,0xBDB9,0xFDB9,
 0x02B9,0x42B9,0x82B9,0xC2B9,0x12B9,0x52B9,0x92B9,0xD2B9,
 0x22B9,0x62B9,0xA2B9,0xE2B9,0x32B9,0x72B9,0xB2B9,0xF2B9,
 0x06B9,0x46B9,0x86B9,0xC6B9,0x16B9,0x56B9,0x96B9,0xD6B9,
 0x26B9,0x66B9,0xA6B9,0xE6B9,0x36B9,0x76B9,0xB6B9,0xF6B9,
 0x0AB9,0x4AB9,0x8AB9,0xCAB9,0x1AB9,0x5AB9,0x9AB9,0xDAB9,
 0x2AB9,0x6AB9,0xAAB9,0xEAB9,0x3AB9,0x7AB9,0xBAB9,0xFAB9,
 0x0EB9,0x4EB9,0x8EB9,0xCEB9,0x1EB9,0x5EB9,0x9EB9,0xDEB9,
 0x2EB9,0x6EB9,0xAEB9,0xEEB9,0x3EB9,0x7EB9,0xBEB9,0xFEB9,
 0x03B9,0x43B9,0x83B9,0xC3B9,0x13B9,0x53B9,0x93B9,0xD3B9,
 0x23B9,0x63B9,0xA3B9,0xE3B9,0x33B9,0x73B9,0xB3B9,0xF3B9,
 0x07B9,0x47B9,0x87B9,0xC7B9,0x17B9,0x57B9,0x97B9,0xD7B9,
 0x27B9,0x67B9,0xA7B9,0xE7B9,0x37B9,0x77B9,0xB7B9,0xF7B9,
 0x0BB9,0x4BB9,0x8BB9,0xCBB9,0x1BB9,0x5BB9,0x9BB9,0xDBB9,
 0x2BB9,0x6BB9,0xABB9,0xEBB9,0x3BB9,0x7BB9,0xBBB9,0xFBB9,
 0x0FB9,0x4FB9,0x8FB9,0xCFB9,0x1FB9,0x5FB9,0x9FB9,0xDFB9,
 0x2FB9,0x6FB9,0xAFB9,0xEFB9,0x3FB9,0x7FB9,0xBFB9,0xFFB9,
 0x00F9,0x40F9,0x80F9,0xC0F9,0x10F9,0x50F9,0x90F9,0xD0F9,
 0x20F9,0x60F9,0xA0F9,0xE0F9,0x30F9,0x70F9,0xB0F9,0xF0F9,
 0x04F9,0x44F9,0x84F9,0xC4F9,0x14F9,0x54F9,0x94F9,0xD4F9,
 0x24F9,0x64F9,0xA4F9,0xE4F9,0x34F9,0x74F9,0xB4F9,0xF4F9,
 0x08F9,0x48F9,0x88F9,0xC8F9,0x18F9,0x58F9,0x98F9,0xD8F9,
 0x28F9,0x68F9,0xA8F9,0xE8F9,0x38F9,0x78F9,0xB8F9,0xF8F9,
 0x0CF9,0x4CF9,0x8CF9,0xCCF9,0x1CF9,0x5CF9,0x9CF9,0xDCF9,
 0x2CF9,0x6CF9,0xACF9,0xECF9,0x3CF9,0x7CF9,0xBCF9,0xFCF9,
 0x01F9,0x41F9,0x81F9,0xC1F9,0x11F9,0x51F9,0x91F9,0xD1F9,
 0x21F9,0x61F9,0xA1F9,0xE1F9,0x31F9,0x71F9,0xB1F9,0xF1F9,
 0x05F9,0x45F9,0x85F9,0xC5F9,0x15F9,0x55F9,0x95F9,0xD5F9,
 0x25F9,0x65F9,0xA5F9,0xE5F9,0x35F9,0x75F9,0xB5F9,0xF5F9,
 0x09F9,0x49F9,0x89F9,0xC9F9,0x19F9,0x59F9,0x99F9,0xD9F9,
 0x29F9,0x69F9,0xA9F9,0xE9F9,0x39F9,0x79F9,0xB9F9,0xF9F9,
 0x0DF9,0x4DF9,0x8DF9,0xCDF9,0x1DF9,0x5DF9,0x9DF9,0xDDF9,
 0x2DF9,0x6DF9,0xADF9,0xEDF9,0x3DF9,0x7DF9,0xBDF9,0xFDF9,
 0x02F9,0x42F9,0x82F9,0xC2F9,0x12F9,0x52F9,0x92F9,0xD2F9,
 0x22F9,0x62F9,0xA2F9,0xE2F9,0x32F9,0x72F9,0xB2F9,0xF2F9,
 0x06F9,0x46F9,0x86F9,0xC6F9,0x16F9,0x56F9,0x96F9,0xD6F9,
 0x26F9,0x66F9,0xA6F9,0xE6F9,0x36F9,0x76F9,0xB6F9,0xF6F9,
 0x0AF9,0x4AF9,0x8AF9,0xCAF9,0x1AF9,0x5AF9,0x9AF9,0xDAF9,
 0x2AF9,0x6AF9,0xAAF9,0xEAF9,0x3AF9,0x7AF9,0xBAF9,0xFAF9,
 0x0EF9,0x4EF9,0x8EF9,0xCEF9,0x1EF9,0x5EF9,0x9EF9,0xDEF9,
 0x2EF9,0x6EF9,0xAEF9,0xEEF9,0x3EF9,0x7EF9,0xBEF9,0xFEF9,
 0x03F9,0x43F9,0x83F9,0xC3F9,0x13F9,0x53F9,0x93F9,0xD3F9,
 0x23F9,0x63F9,0xA3F9,0xE3F9,0x33F9,0x73F9,0xB3F9,0xF3F9,
 0x07F9,0x47F9,0x87F9,0xC7F9,0x17F9,0x57F9,0x97F9,0xD7F9,
 0x27F9,0x67F9,0xA7F9,0xE7F9,0x37F9,0x77F9,0xB7F9,0xF7F9,
 0x0BF9,0x4BF9,0x8BF9,0xCBF9,0x1BF9,0x5BF9,0x9BF9,0xDBF9,
 0x2BF9,0x6BF9,0xABF9,0xEBF9,0x3BF9,0x7BF9,0xBBF9,0xFBF9,
 0x0FF9,0x4FF9,0x8FF9,0xCFF9,0x1FF9,0x5FF9,0x9FF9,0xDFF9,
 0x2FF9,0x6FF9,0xAFF9,0xEFF9,0x3FF9,0x7FF9,0xBFF9,0xFFF9,
 0x000D,0x400D,0x800D,0xC00D,0x100D,0x500D,0x900D,0xD00D,
 0x200D,0x600D,0xA00D,0xE00D,0x300D,0x700D,0xB00D,0xF00D,
 0x040D,0x440D,0x840D,0xC40D,0x140D,0x540D,0x940D,0xD40D,
 0x240D,0x640D,0xA40D,0xE40D,0x340D,0x740D,0xB40D,0xF40D,
 0x080D,0x480D,0x880D,0xC80D,0x180D,0x580D,0x980D,0xD80D,
 0x280D,0x680D,0xA80D,0xE80D,0x380D,0x780D,0xB80D,0xF80D,
 0x0C0D,0x4C0D,0x8C0D,0xCC0D,0x1C0D,0x5C0D,0x9C0D,0xDC0D,
 0x2C0D,0x6C0D,0xAC0D,0xEC0D,0x3C0D,0x7C0D,0xBC0D,0xFC0D,
 0x010D,0x410D,0x810D,0xC10D,0x110D,0x510D,0x910D,0xD10D,
 0x210D,0x610D,0xA10D,0xE10D,0x310D,0x710D,0xB10D,0xF10D,
 0x050D,0x450D,0x850D,0xC50D,0x150D,0x550D,0x950D,0xD50D,
 0x250D,0x650D,0xA50D,0xE50D,0x350D,0x750D,0xB50D,0xF50D,
 0x090D,0x490D,0x890D,0xC90D,0x190D,0x590D,0x990D,0xD90D,
 0x290D,0x690D,0xA90D,0xE90D,0x390D,0x790D,0xB90D,0xF90D,
 0x0D0D,0x4D0D,0x8D0D,0xCD0D,0x1D0D,0x5D0D,0x9D0D,0xDD0D,
 0x2D0D,0x6D0D,0xAD0D,0xED0D,0x3D0D,0x7D0D,0xBD0D,0xFD0D,
 0x020D,0x420D,0x820D,0xC20D,0x120D,0x520D,0x920D,0xD20D,
 0x220D,0x620D,0xA20D,0xE20D,0x320D,0x720D,0xB20D,0xF20D,
 0x060D,0x460D,0x860D,0xC60D,0x160D,0x560D,0x960D,0xD60D,
 0x260D,0x660D,0xA60D,0xE60D,0x360D,0x760D,0xB60D,0xF60D,
 0x0A0D,0x4A0D,0x8A0D,0xCA0D,0x1A0D,0x5A0D,0x9A0D,0xDA0D,
 0x2A0D,0x6A0D,0xAA0D,0xEA0D,0x3A0D,0x7A0D,0xBA0D,0xFA0D,
 0x0E0D,0x4E0D,0x8E0D,0xCE0D,0x1E0D,0x5E0D,0x9E0D,0xDE0D,
 0x2E0D,0x6E0D,0xAE0D,0xEE0D,0x3E0D,0x7E0D,0xBE0D,0xFE0D,
 0x030D,0x430D,0x830D,0xC30D,0x130D,0x530D,0x930D,0xD30D,
 0x230D,0x630D,0xA30D,0xE30D,0x330D,0x730D,0xB30D,0xF30D,
 0x070D,0x470D,0x870D,0xC70D,0x170D,0x570D,0x970D,0xD70D,
 0x270D,0x670D,0xA70D,0xE70D,0x370D,0x770D,0xB70D,0xF70D,
 0x0B0D,0x4B0D,0x8B0D,0xCB0D,0x1B0D,0x5B0D,0x9B0D,0xDB0D,
 0x2B0D,0x6B0D,0xAB0D,0xEB0D,0x3B0D,0x7B0D,0xBB0D,0xFB0D,
 0x0F0D,0x4F0D,0x8F0D,0xCF0D,0x1F0D,0x5F0D,0x9F0D,0xDF0D,
 0x2F0D,0x6F0D,0xAF0D,0xEF0D,0x3F0D,0x7F0D,0xBF0D,0xFF0D,
 0x004D,0x404D,0x804D,0xC04D,0x104D,0x504D,0x904D,0xD04D,
 0x204D,0x604D,0xA04D,0xE04D,0x304D,0x704D,0xB04D,0xF04D,
 0x044D,0x444D,0x844D,0xC44D,0x144D,0x544D,0x944D,0xD44D,
 0x244D,0x644D,0xA44D,0xE44D,0x344D,0x744D,0xB44D,0xF44D,
 0x084D,0x484D,0x884D,0xC84D,0x184D,0x584D,0x984D,0xD84D,
 0x284D,0x684D,0xA84D,0xE84D,0x384D,0x784D,0xB84D,0xF84D,
 0x0C4D,0x4C4D,0x8C4D,0xCC4D,0x1C4D,0x5C4D,0x9C4D,0xDC4D,
 0x2C4D,0x6C4D,0xAC4D,0xEC4D,0x3C4D,0x7C4D,0xBC4D,0xFC4D,
 0x014D,0x414D,0x814D,0xC14D,0x114D,0x514D,0x914D,0xD14D,
 0x214D,0x614D,0xA14D,0xE14D,0x314D,0x714D,0xB14D,0xF14D,
 0x054D,0x454D,0x854D,0xC54D,0x154D,0x554D,0x954D,0xD54D,
 0x254D,0x654D,0xA54D,0xE54D,0x354D,0x754D,0xB54D,0xF54D,
 0x094D,0x494D,0x894D,0xC94D,0x194D,0x594D,0x994D,0xD94D,
 0x294D,0x694D,0xA94D,0xE94D,0x394D,0x794D,0xB94D,0xF94D,
 0x0D4D,0x4D4D,0x8D4D,0xCD4D,0x1D4D,0x5D4D,0x9D4D,0xDD4D,
 0x2D4D,0x6D4D,0xAD4D,0xED4D,0x3D4D,0x7D4D,0xBD4D,0xFD4D,
 0x024D,0x424D,0x824D,0xC24D,0x124D,0x524D,0x924D,0xD24D,
 0x224D,0x624D,0xA24D,0xE24D,0x324D,0x724D,0xB24D,0xF24D,
 0x064D,0x464D,0x864D,0xC64D,0x164D,0x564D,0x964D,0xD64D,
 0x264D,0x664D,0xA64D,0xE64D,0x364D,0x764D,0xB64D,0xF64D,
 0x0A4D,0x4A4D,0x8A4D,0xCA4D,0x1A4D,0x5A4D,0x9A4D,0xDA4D,
 0x2A4D,0x6A4D,0xAA4D,0xEA4D,0x3A4D,0x7A4D,0xBA4D,0xFA4D,
 0x0E4D,0x4E4D,0x8E4D,0xCE4D,0x1E4D,0x5E4D,0x9E4D,0xDE4D,
 0x2E4D,0x6E4D,0xAE4D,0xEE4D,0x3E4D,0x7E4D,0xBE4D,0xFE4D,
 0x034D,0x434D,0x834D,0xC34D,0x134D,0x534D,0x934D,0xD34D,
 0x234D,0x634D,0xA34D,0xE34D,0x334D,0x734D,0xB34D,0xF34D,
 0x074D,0x474D,0x874D,0xC74D,0x174D,0x574D,0x974D,0xD74D,
 0x274D,0x674D,0xA74D,0xE74D,0x374D,0x774D,0xB74D,0xF74D,
 0x0B4D,0x4B4D,0x8B4D,0xCB4D,0x1B4D,0x5B4D,0x9B4D,0xDB4D,
 0x2B4D,0x6B4D,0xAB4D,0xEB4D,0x3B4D,0x7B4D,0xBB4D,0xFB4D,
 0x0F4D,0x4F4D,0x8F4D,0xCF4D,0x1F4D,0x5F4D,0x9F4D,0xDF4D,
 0x2F4D,0x6F4D,0xAF4D,0xEF4D,0x3F4D,0x7F4D,0xBF4D,0xFF4D,
 0x008D,0x408D,0x808D,0xC08D,0x108D,0x508D,0x908D,0xD08D,
 0x208D,0x608D,0xA08D,0xE08D,0x308D,0x708D,0xB08D,0xF08D,
 0x048D,0x448D,0x848D,0xC48D,0x148D,0x548D,0x948D,0xD48D,
 0x248D,0x648D,0xA48D,0xE48D,0x348D,0x748D,0xB48D,0xF48D,
 0x088D,0x488D,0x888D,0xC88D,0x188D,0x588D,0x988D,0xD88D,
 0x288D,0x688D,0xA88D,0xE88D,0x388D,0x788D,0xB88D,0xF88D,
 0x0C8D,0x4C8D,0x8C8D,0xCC8D,0x1C8D,0x5C8D,0x9C8D,0xDC8D,
 0x2C8D,0x6C8D,0xAC8D,0xEC8D,0x3C8D,0x7C8D,0xBC8D,0xFC8D,
 0x018D,0x418D,0x818D,0xC18D,0x118D,0x518D,0x918D,0xD18D,
 0x218D,0x618D,0xA18D,0xE18D,0x318D,0x718D,0xB18D,0xF18D,
 0x058D,0x458D,0x858D,0xC58D,0x158D,0x558D,0x958D,0xD58D,
 0x258D,0x658D,0xA58D,0xE58D,0x358D,0x758D,0xB58D,0xF58D,
 0x098D,0x498D,0x898D,0xC98D,0x198D,0x598D,0x998D,0xD98D,
 0x298D,0x698D,0xA98D,0xE98D,0x398D,0x798D,0xB98D,0xF98D,
 0x0D8D,0x4D8D,0x8D8D,0xCD8D,0x1D8D,0x5D8D,0x9D8D,0xDD8D,
 0x2D8D,0x6D8D,0xAD8D,0xED8D,0x3D8D,0x7D8D,0xBD8D,0xFD8D,
 0x028D,0x428D,0x828D,0xC28D,0x128D,0x528D,0x928D,0xD28D,
 0x228D,0x628D,0xA28D,0xE28D,0x328D,0x728D,0xB28D,0xF28D,
 0x068D,0x468D,0x868D,0xC68D,0x168D,0x568D,0x968D,0xD68D,
 0x268D,0x668D,0xA68D,0xE68D,0x368D,0x768D,0xB68D,0xF68D,
 0x0A8D,0x4A8D,0x8A8D,0xCA8D,0x1A8D,0x5A8D,0x9A8D,0xDA8D,
 0x2A8D,0x6A8D,0xAA8D,0xEA8D,0x3A8D,0x7A8D,0xBA8D,0xFA8D,
 0x0E8D,0x4E8D,0x8E8D,0xCE8D,0x1E8D,0x5E8D,0x9E8D,0xDE8D,
 0x2E8D,0x6E8D,0xAE8D,0xEE8D,0x3E8D,0x7E8D,0xBE8D,0xFE8D,
 0x038D,0x438D,0x838D,0xC38D,0x138D,0x538D,0x938D,0xD38D,
 0x238D,0x638D,0xA38D,0xE38D,0x338D,0x738D,0xB38D,0xF38D,
 0x078D,0x478D,0x878D,0xC78D,0x178D,0x578D,0x978D,0xD78D,
 0x278D,0x678D,0xA78D,0xE78D,0x378D,0x778D,0xB78D,0xF78D,
 0x0B8D,0x4B8D,0x8B8D,0xCB8D,0x1B8D,0x5B8D,0x9B8D,0xDB8D,
 0x2B8D,0x6B8D,0xAB8D,0xEB8D,0x3B8D,0x7B8D,0xBB8D,0xFB8D,
 0x0F8D,0x4F8D,0x8F8D,0xCF8D,0x1F8D,0x5F8D,0x9F8D,0xDF8D,
 0x2F8D,0x6F8D,0xAF8D,0xEF8D,0x3F8D,0x7F8D,0xBF8D,0xFF8D,
 0x00CD,0x40CD,0x80CD,0xC0CD,0x10CD,0x50CD,0x90CD,0xD0CD,
 0x20CD,0x60CD,0xA0CD,0xE0CD,0x30CD,0x70CD,0xB0CD,0xF0CD,
 0x04CD,0x44CD,0x84CD,0xC4CD,0x14CD,0x54CD,0x94CD,0xD4CD,
 0x24CD,0x64CD,0xA4CD,0xE4CD,0x34CD,0x74CD,0xB4CD,0xF4CD,
 0x08CD,0x48CD,0x88CD,0xC8CD,0x18CD,0x58CD,0x98CD,0xD8CD,
 0x28CD,0x68CD,0xA8CD,0xE8CD,0x38CD,0x78CD,0xB8CD,0xF8CD,
 0x0CCD,0x4CCD,0x8CCD,0xCCCD,0x1CCD,0x5CCD,0x9CCD,0xDCCD,
 0x2CCD,0x6CCD,0xACCD,0xECCD,0x3CCD,0x7CCD,0xBCCD,0xFCCD,
 0x01CD,0x41CD,0x81CD,0xC1CD,0x11CD,0x51CD,0x91CD,0xD1CD,
 0x21CD,0x61CD,0xA1CD,0xE1CD,0x31CD,0x71CD,0xB1CD,0xF1CD,
 0x05CD,0x45CD,0x85CD,0xC5CD,0x15CD,0x55CD,0x95CD,0xD5CD,
 0x25CD,0x65CD,0xA5CD,0xE5CD,0x35CD,0x75CD,0xB5CD,0xF5CD,
 0x09CD,0x49CD,0x89CD,0xC9CD,0x19CD,0x59CD,0x99CD,0xD9CD,
 0x29CD,0x69CD,0xA9CD,0xE9CD,0x39CD,0x79CD,0xB9CD,0xF9CD,
 0x0DCD,0x4DCD,0x8DCD,0xCDCD,0x1DCD,0x5DCD,0x9DCD,0xDDCD,
 0x2DCD,0x6DCD,0xADCD,0xEDCD,0x3DCD,0x7DCD,0xBDCD,0xFDCD,
 0x02CD,0x42CD,0x82CD,0xC2CD,0x12CD,0x52CD,0x92CD,0xD2CD,
 0x22CD,0x62CD,0xA2CD,0xE2CD,0x32CD,0x72CD,0xB2CD,0xF2CD,
 0x06CD,0x46CD,0x86CD,0xC6CD,0x16CD,0x56CD,0x96CD,0xD6CD,
 0x26CD,0x66CD,0xA6CD,0xE6CD,0x36CD,0x76CD,0xB6CD,0xF6CD,
 0x0ACD,0x4ACD,0x8ACD,0xCACD,0x1ACD,0x5ACD,0x9ACD,0xDACD,
 0x2ACD,0x6ACD,0xAACD,0xEACD,0x3ACD,0x7ACD,0xBACD,0xFACD,
 0x0ECD,0x4ECD,0x8ECD,0xCECD,0x1ECD,0x5ECD,0x9ECD,0xDECD,
 0x2ECD,0x6ECD,0xAECD,0xEECD,0x3ECD,0x7ECD,0xBECD,0xFECD,
 0x03CD,0x43CD,0x83CD,0xC3CD,0x13CD,0x53CD,0x93CD,0xD3CD,
 0x23CD,0x63CD,0xA3CD,0xE3CD,0x33CD,0x73CD,0xB3CD,0xF3CD,
 0x07CD,0x47CD,0x87CD,0xC7CD,0x17CD,0x57CD,0x97CD,0xD7CD,
 0x27CD,0x67CD,0xA7CD,0xE7CD,0x37CD,0x77CD,0xB7CD,0xF7CD,
 0x0BCD,0x4BCD,0x8BCD,0xCBCD,0x1BCD,0x5BCD,0x9BCD,0xDBCD,
 0x2BCD,0x6BCD,0xABCD,0xEBCD,0x3BCD,0x7BCD,0xBBCD,0xFBCD,
 0x0FCD,0x4FCD,0x8FCD,0xCFCD,0x1FCD,0x5FCD,0x9FCD,0xDFCD,
 0x2FCD,0x6FCD,0xAFCD,0xEFCD,0x3FCD,0x7FCD,0xBFCD,0xFFCD,
 0x001D,0x401D,0x801D,0xC01D,0x101D,0x501D,0x901D,0xD01D,
 0x201D,0x601D,0xA01D,0xE01D,0x301D,0x701D,0xB01D,0xF01D,
 0x041D,0x441D,0x841D,0xC41D,0x141D,0x541D,0x941D,0xD41D,
 0x241D,0x641D,0xA41D,0xE41D,0x341D,0x741D,0xB41D,0xF41D,
 0x081D,0x481D,0x881D,0xC81D,0x181D,0x581D,0x981D,0xD81D,
 0x281D,0x681D,0xA81D,0xE81D,0x381D,0x781D,0xB81D,0xF81D,
 0x0C1D,0x4C1D,0x8C1D,0xCC1D,0x1C1D,0x5C1D,0x9C1D,0xDC1D,
 0x2C1D,0x6C1D,0xAC1D,0xEC1D,0x3C1D,0x7C1D,0xBC1D,0xFC1D,
 0x011D,0x411D,0x811D,0xC11D,0x111D,0x511D,0x911D,0xD11D,
 0x211D,0x611D,0xA11D,0xE11D,0x311D,0x711D,0xB11D,0xF11D,
 0x051D,0x451D,0x851D,0xC51D,0x151D,0x551D,0x951D,0xD51D,
 0x251D,0x651D,0xA51D,0xE51D,0x351D,0x751D,0xB51D,0xF51D,
 0x091D,0x491D,0x891D,0xC91D,0x191D,0x591D,0x991D,0xD91D,
 0x291D,0x691D,0xA91D,0xE91D,0x391D,0x791D,0xB91D,0xF91D,
 0x0D1D,0x4D1D,0x8D1D,0xCD1D,0x1D1D,0x5D1D,0x9D1D,0xDD1D,
 0x2D1D,0x6D1D,0xAD1D,0xED1D,0x3D1D,0x7D1D,0xBD1D,0xFD1D,
 0x021D,0x421D,0x821D,0xC21D,0x121D,0x521D,0x921D,0xD21D,
 0x221D,0x621D,0xA21D,0xE21D,0x321D,0x721D,0xB21D,0xF21D,
 0x061D,0x461D,0x861D,0xC61D,0x161D,0x561D,0x961D,0xD61D,
 0x261D,0x661D,0xA61D,0xE61D,0x361D,0x761D,0xB61D,0xF61D,
 0x0A1D,0x4A1D,0x8A1D,0xCA1D,0x1A1D,0x5A1D,0x9A1D,0xDA1D,
 0x2A1D,0x6A1D,0xAA1D,0xEA1D,0x3A1D,0x7A1D,0xBA1D,0xFA1D,
 0x0E1D,0x4E1D,0x8E1D,0xCE1D,0x1E1D,0x5E1D,0x9E1D,0xDE1D,
 0x2E1D,0x6E1D,0xAE1D,0xEE1D,0x3E1D,0x7E1D,0xBE1D,0xFE1D,
 0x031D,0x431D,0x831D,0xC31D,0x131D,0x531D,0x931D,0xD31D,
 0x231D,0x631D,0xA31D,0xE31D,0x331D,0x731D,0xB31D,0xF31D,
 0x071D,0x471D,0x871D,0xC71D,0x171D,0x571D,0x971D,0xD71D,
 0x271D,0x671D,0xA71D,0xE71D,0x371D,0x771D,0xB71D,0xF71D,
 0x0B1D,0x4B1D,0x8B1D,0xCB1D,0x1B1D,0x5B1D,0x9B1D,0xDB1D,
 0x2B1D,0x6B1D,0xAB1D,0xEB1D,0x3B1D,0x7B1D,0xBB1D,0xFB1D,
 0x0F1D,0x4F1D,0x8F1D,0xCF1D,0x1F1D,0x5F1D,0x9F1D,0xDF1D,
 0x2F1D,0x6F1D,0xAF1D,0xEF1D,0x3F1D,0x7F1D,0xBF1D,0xFF1D,
 0x005D,0x405D,0x805D,0xC05D,0x105D,0x505D,0x905D,0xD05D,
 0x205D,0x605D,0xA05D,0xE05D,0x305D,0x705D,0xB05D,0xF05D,
 0x045D,0x445D,0x845D,0xC45D,0x145D,0x545D,0x945D,0xD45D,
 0x245D,0x645D,0xA45D,0xE45D,0x345D,0x745D,0xB45D,0xF45D,
 0x085D,0x485D,0x885D,0xC85D,0x185D,0x585D,0x985D,0xD85D,
 0x285D,0x685D,0xA85D,0xE85D,0x385D,0x785D,0xB85D,0xF85D,
 0x0C5D,0x4C5D,0x8C5D,0xCC5D,0x1C5D,0x5C5D,0x9C5D,0xDC5D,
 0x2C5D,0x6C5D,0xAC5D,0xEC5D,0x3C5D,0x7C5D,0xBC5D,0xFC5D,
 0x015D,0x415D,0x815D,0xC15D,0x115D,0x515D,0x915D,0xD15D,
 0x215D,0x615D,0xA15D,0xE15D,0x315D,0x715D,0xB15D,0xF15D,
 0x055D,0x455D,0x855D,0xC55D,0x155D,0x555D,0x955D,0xD55D,
 0x255D,0x655D,0xA55D,0xE55D,0x355D,0x755D,0xB55D,0xF55D,
 0x095D,0x495D,0x895D,0xC95D,0x195D,0x595D,0x995D,0xD95D,
 0x295D,0x695D,0xA95D,0xE95D,0x395D,0x795D,0xB95D,0xF95D,
 0x0D5D,0x4D5D,0x8D5D,0xCD5D,0x1D5D,0x5D5D,0x9D5D,0xDD5D,
 0x2D5D,0x6D5D,0xAD5D,0xED5D,0x3D5D,0x7D5D,0xBD5D,0xFD5D,
 0x025D,0x425D,0x825D,0xC25D,0x125D,0x525D,0x925D,0xD25D,
 0x225D,0x625D,0xA25D,0xE25D,0x325D,0x725D,0xB25D,0xF25D,
 0x065D,0x465D,0x865D,0xC65D,0x165D,0x565D,0x965D,0xD65D,
 0x265D,0x665D,0xA65D,0xE65D,0x365D,0x765D,0xB65D,0xF65D,
 0x0A5D,0x4A5D,0x8A5D,0xCA5D,0x1A5D,0x5A5D,0x9A5D,0xDA5D,
 0x2A5D,0x6A5D,0xAA5D,0xEA5D,0x3A5D,0x7A5D,0xBA5D,0xFA5D,
 0x0E5D,0x4E5D,0x8E5D,0xCE5D,0x1E5D,0x5E5D,0x9E5D,0xDE5D,
 0x2E5D,0x6E5D,0xAE5D,0xEE5D,0x3E5D,0x7E5D,0xBE5D,0xFE5D,
 0x035D,0x435D,0x835D,0xC35D,0x135D,0x535D,0x935D,0xD35D,
 0x235D,0x635D,0xA35D,0xE35D,0x335D,0x735D,0xB35D,0xF35D,
 0x075D,0x475D,0x875D,0xC75D,0x175D,0x575D,0x975D,0xD75D,
 0x275D,0x675D,0xA75D,0xE75D,0x375D,0x775D,0xB75D,0xF75D,
 0x0B5D,0x4B5D,0x8B5D,0xCB5D,0x1B5D,0x5B5D,0x9B5D,0xDB5D,
 0x2B5D,0x6B5D,0xAB5D,0xEB5D,0x3B5D,0x7B5D,0xBB5D,0xFB5D,
 0x0F5D,0x4F5D,0x8F5D,0xCF5D,0x1F5D,0x5F5D,0x9F5D,0xDF5D,
 0x2F5D,0x6F5D,0xAF5D,0xEF5D,0x3F5D,0x7F5D,0xBF5D,0xFF5D,
 0x009D,0x409D,0x809D,0xC09D,0x109D,0x509D,0x909D,0xD09D,
 0x209D,0x609D,0xA09D,0xE09D,0x309D,0x709D,0xB09D,0xF09D,
 0x049D,0x449D,0x849D,0xC49D,0x149D,0x549D,0x949D,0xD49D,
 0x249D,0x649D,0xA49D,0xE49D,0x349D,0x749D,0xB49D,0xF49D,
 0x089D,0x489D,0x889D,0xC89D,0x189D,0x589D,0x989D,0xD89D,
 0x289D,0x689D,0xA89D,0xE89D,0x389D,0x789D,0xB89D,0xF89D,
 0x0C9D,0x4C9D,0x8C9D,0xCC9D,0x1C9D,0x5C9D,0x9C9D,0xDC9D,
 0x2C9D,0x6C9D,0xAC9D,0xEC9D,0x3C9D,0x7C9D,0xBC9D,0xFC9D,
 0x019D,0x419D,0x819D,0xC19D,0x119D,0x519D,0x919D,0xD19D,
 0x219D,0x619D,0xA19D,0xE19D,0x319D,0x719D,0xB19D,0xF19D,
 0x059D,0x459D,0x859D,0xC59D,0x159D,0x559D,0x959D,0xD59D,
 0x259D,0x659D,0xA59D,0xE59D,0x359D,0x759D,0xB59D,0xF59D,
 0x099D,0x499D,0x899D,0xC99D,0x199D,0x599D,0x999D,0xD99D,
 0x299D,0x699D,0xA99D,0xE99D,0x399D,0x799D,0xB99D,0xF99D,
 0x0D9D,0x4D9D,0x8D9D,0xCD9D,0x1D9D,0x5D9D,0x9D9D,0xDD9D,
 0x2D9D,0x6D9D,0xAD9D,0xED9D,0x3D9D,0x7D9D,0xBD9D,0xFD9D,
 0x029D,0x429D,0x829D,0xC29D,0x129D,0x529D,0x929D,0xD29D,
 0x229D,0x629D,0xA29D,0xE29D,0x329D,0x729D,0xB29D,0xF29D,
 0x069D,0x469D,0x869D,0xC69D,0x169D,0x569D,0x969D,0xD69D,
 0x269D,0x669D,0xA69D,0xE69D,0x369D,0x769D,0xB69D,0xF69D,
 0x0A9D,0x4A9D,0x8A9D,0xCA9D,0x1A9D,0x5A9D,0x9A9D,0xDA9D,
 0x2A9D,0x6A9D,0xAA9D,0xEA9D,0x3A9D,0x7A9D,0xBA9D,0xFA9D,
 0x0E9D,0x4E9D,0x8E9D,0xCE9D,0x1E9D,0x5E9D,0x9E9D,0xDE9D,
 0x2E9D,0x6E9D,0xAE9D,0xEE9D,0x3E9D,0x7E9D,0xBE9D,0xFE9D,
 0x039D,0x439D,0x839D,0xC39D,0x139D,0x539D,0x939D,0xD39D,
 0x239D,0x639D,0xA39D,0xE39D,0x339D,0x739D,0xB39D,0xF39D,
 0x079D,0x479D,0x879D,0xC79D,0x179D,0x579D,0x979D,0xD79D,
 0x279D,0x679D,0xA79D,0xE79D,0x379D,0x779D,0xB79D,0xF79D,
 0x0B9D,0x4B9D,0x8B9D,0xCB9D,0x1B9D,0x5B9D,0x9B9D,0xDB9D,
 0x2B9D,0x6B9D,0xAB9D,0xEB9D,0x3B9D,0x7B9D,0xBB9D,0xFB9D,
 0x0F9D,0x4F9D,0x8F9D,0xCF9D,0x1F9D,0x5F9D,0x9F9D,0xDF9D,
 0x2F9D,0x6F9D,0xAF9D,0xEF9D,0x3F9D,0x7F9D,0xBF9D,0xFF9D,
 0x00DD,0x40DD,0x80DD,0xC0DD,0x10DD,0x50DD,0x90DD,0xD0DD,
 0x20DD,0x60DD,0xA0DD,0xE0DD,0x30DD,0x70DD,0xB0DD,0xF0DD,
 0x04DD,0x44DD,0x84DD,0xC4DD,0x14DD,0x54DD,0x94DD,0xD4DD,
 0x24DD,0x64DD,0xA4DD,0xE4DD,0x34DD,0x74DD,0xB4DD,0xF4DD,
 0x08DD,0x48DD,0x88DD,0xC8DD,0x18DD,0x58DD,0x98DD,0xD8DD,
 0x28DD,0x68DD,0xA8DD,0xE8DD,0x38DD,0x78DD,0xB8DD,0xF8DD,
 0x0CDD,0x4CDD,0x8CDD,0xCCDD,0x1CDD,0x5CDD,0x9CDD,0xDCDD,
 0x2CDD,0x6CDD,0xACDD,0xECDD,0x3CDD,0x7CDD,0xBCDD,0xFCDD,
 0x01DD,0x41DD,0x81DD,0xC1DD,0x11DD,0x51DD,0x91DD,0xD1DD,
 0x21DD,0x61DD,0xA1DD,0xE1DD,0x31DD,0x71DD,0xB1DD,0xF1DD,
 0x05DD,0x45DD,0x85DD,0xC5DD,0x15DD,0x55DD,0x95DD,0xD5DD,
 0x25DD,0x65DD,0xA5DD,0xE5DD,0x35DD,0x75DD,0xB5DD,0xF5DD,
 0x09DD,0x49DD,0x89DD,0xC9DD,0x19DD,0x59DD,0x99DD,0xD9DD,
 0x29DD,0x69DD,0xA9DD,0xE9DD,0x39DD,0x79DD,0xB9DD,0xF9DD,
 0x0DDD,0x4DDD,0x8DDD,0xCDDD,0x1DDD,0x5DDD,0x9DDD,0xDDDD,
 0x2DDD,0x6DDD,0xADDD,0xEDDD,0x3DDD,0x7DDD,0xBDDD,0xFDDD,
 0x02DD,0x42DD,0x82DD,0xC2DD,0x12DD,0x52DD,0x92DD,0xD2DD,
 0x22DD,0x62DD,0xA2DD,0xE2DD,0x32DD,0x72DD,0xB2DD,0xF2DD,
 0x06DD,0x46DD,0x86DD,0xC6DD,0x16DD,0x56DD,0x96DD,0xD6DD,
 0x26DD,0x66DD,0xA6DD,0xE6DD,0x36DD,0x76DD,0xB6DD,0xF6DD,
 0x0ADD,0x4ADD,0x8ADD,0xCADD,0x1ADD,0x5ADD,0x9ADD,0xDADD,
 0x2ADD,0x6ADD,0xAADD,0xEADD,0x3ADD,0x7ADD,0xBADD,0xFADD,
 0x0EDD,0x4EDD,0x8EDD,0xCEDD,0x1EDD,0x5EDD,0x9EDD,0xDEDD,
 0x2EDD,0x6EDD,0xAEDD,0xEEDD,0x3EDD,0x7EDD,0xBEDD,0xFEDD,
 0x03DD,0x43DD,0x83DD,0xC3DD,0x13DD,0x53DD,0x93DD,0xD3DD,
 0x23DD,0x63DD,0xA3DD,0xE3DD,0x33DD,0x73DD,0xB3DD,0xF3DD,
 0x07DD,0x47DD,0x87DD,0xC7DD,0x17DD,0x57DD,0x97DD,0xD7DD,
 0x27DD,0x67DD,0xA7DD,0xE7DD,0x37DD,0x77DD,0xB7DD,0xF7DD,
 0x0BDD,0x4BDD,0x8BDD,0xCBDD,0x1BDD,0x5BDD,0x9BDD,0xDBDD,
 0x2BDD,0x6BDD,0xABDD,0xEBDD,0x3BDD,0x7BDD,0xBBDD,0xFBDD,
 0x0FDD,0x4FDD,0x8FDD,0xCFDD,0x1FDD,0x5FDD,0x9FDD,0xDFDD,
 0x2FDD,0x6FDD,0xAFDD,0xEFDD,0x3FDD,0x7FDD,0xBFDD,0xFFDD,
 0x002D,0x402D,0x802D,0xC02D,0x102D,0x502D,0x902D,0xD02D,
 0x202D,0x602D,0xA02D,0xE02D,0x302D,0x702D,0xB02D,0xF02D,
 0x042D,0x442D,0x842D,0xC42D,0x142D,0x542D,0x942D,0xD42D,
 0x242D,0x642D,0xA42D,0xE42D,0x342D,0x742D,0xB42D,0xF42D,
 0x082D,0x482D,0x882D,0xC82D,0x182D,0x582D,0x982D,0xD82D,
 0x282D,0x682D,0xA82D,0xE82D,0x382D,0x782D,0xB82D,0xF82D,
 0x0C2D,0x4C2D,0x8C2D,0xCC2D,0x1C2D,0x5C2D,0x9C2D,0xDC2D,
 0x2C2D,0x6C2D,0xAC2D,0xEC2D,0x3C2D,0x7C2D,0xBC2D,0xFC2D,
 0x012D,0x412D,0x812D,0xC12D,0x112D,0x512D,0x912D,0xD12D,
 0x212D,0x612D,0xA12D,0xE12D,0x312D,0x712D,0xB12D,0xF12D,
 0x052D,0x452D,0x852D,0xC52D,0x152D,0x552D,0x952D,0xD52D,
 0x252D,0x652D,0xA52D,0xE52D,0x352D,0x752D,0xB52D,0xF52D,
 0x092D,0x492D,0x892D,0xC92D,0x192D,0x592D,0x992D,0xD92D,
 0x292D,0x692D,0xA92D,0xE92D,0x392D,0x792D,0xB92D,0xF92D,
 0x0D2D,0x4D2D,0x8D2D,0xCD2D,0x1D2D,0x5D2D,0x9D2D,0xDD2D,
 0x2D2D,0x6D2D,0xAD2D,0xED2D,0x3D2D,0x7D2D,0xBD2D,0xFD2D,
 0x022D,0x422D,0x822D,0xC22D,0x122D,0x522D,0x922D,0xD22D,
 0x222D,0x622D,0xA22D,0xE22D,0x322D,0x722D,0xB22D,0xF22D,
 0x062D,0x462D,0x862D,0xC62D,0x162D,0x562D,0x962D,0xD62D,
 0x262D,0x662D,0xA62D,0xE62D,0x362D,0x762D,0xB62D,0xF62D,
 0x0A2D,0x4A2D,0x8A2D,0xCA2D,0x1A2D,0x5A2D,0x9A2D,0xDA2D,
 0x2A2D,0x6A2D,0xAA2D,0xEA2D,0x3A2D,0x7A2D,0xBA2D,0xFA2D,
 0x0E2D,0x4E2D,0x8E2D,0xCE2D,0x1E2D,0x5E2D,0x9E2D,0xDE2D,
 0x2E2D,0x6E2D,0xAE2D,0xEE2D,0x3E2D,0x7E2D,0xBE2D,0xFE2D,
 0x032D,0x432D,0x832D,0xC32D,0x132D,0x532D,0x932D,0xD32D,
 0x232D,0x632D,0xA32D,0xE32D,0x332D,0x732D,0xB32D,0xF32D,
 0x072D,0x472D,0x872D,0xC72D,0x172D,0x572D,0x972D,0xD72D,
 0x272D,0x672D,0xA72D,0xE72D,0x372D,0x772D,0xB72D,0xF72D,
 0x0B2D,0x4B2D,0x8B2D,0xCB2D,0x1B2D,0x5B2D,0x9B2D,0xDB2D,
 0x2B2D,0x6B2D,0xAB2D,0xEB2D,0x3B2D,0x7B2D,0xBB2D,0xFB2D,
 0x0F2D,0x4F2D,0x8F2D,0xCF2D,0x1F2D,0x5F2D,0x9F2D,0xDF2D,
 0x2F2D,0x6F2D,0xAF2D,0xEF2D,0x3F2D,0x7F2D,0xBF2D,0xFF2D,
 0x006D,0x406D,0x806D,0xC06D,0x106D,0x506D,0x906D,0xD06D,
 0x206D,0x606D,0xA06D,0xE06D,0x306D,0x706D,0xB06D,0xF06D,
 0x046D,0x446D,0x846D,0xC46D,0x146D,0x546D,0x946D,0xD46D,
 0x246D,0x646D,0xA46D,0xE46D,0x346D,0x746D,0xB46D,0xF46D,
 0x086D,0x486D,0x886D,0xC86D,0x186D,0x586D,0x986D,0xD86D,
 0x286D,0x686D,0xA86D,0xE86D,0x386D,0x786D,0xB86D,0xF86D,
 0x0C6D,0x4C6D,0x8C6D,0xCC6D,0x1C6D,0x5C6D,0x9C6D,0xDC6D,
 0x2C6D,0x6C6D,0xAC6D,0xEC6D,0x3C6D,0x7C6D,0xBC6D,0xFC6D,
 0x016D,0x416D,0x816D,0xC16D,0x116D,0x516D,0x916D,0xD16D,
 0x216D,0x616D,0xA16D,0xE16D,0x316D,0x716D,0xB16D,0xF16D,
 0x056D,0x456D,0x856D,0xC56D,0x156D,0x556D,0x956D,0xD56D,
 0x256D,0x656D,0xA56D,0xE56D,0x356D,0x756D,0xB56D,0xF56D,
 0x096D,0x496D,0x896D,0xC96D,0x196D,0x596D,0x996D,0xD96D,
 0x296D,0x696D,0xA96D,0xE96D,0x396D,0x796D,0xB96D,0xF96D,
 0x0D6D,0x4D6D,0x8D6D,0xCD6D,0x1D6D,0x5D6D,0x9D6D,0xDD6D,
 0x2D6D,0x6D6D,0xAD6D,0xED6D,0x3D6D,0x7D6D,0xBD6D,0xFD6D,
 0x026D,0x426D,0x826D,0xC26D,0x126D,0x526D,0x926D,0xD26D,
 0x226D,0x626D,0xA26D,0xE26D,0x326D,0x726D,0xB26D,0xF26D,
 0x066D,0x466D,0x866D,0xC66D,0x166D,0x566D,0x966D,0xD66D,
 0x266D,0x666D,0xA66D,0xE66D,0x366D,0x766D,0xB66D,0xF66D,
 0x0A6D,0x4A6D,0x8A6D,0xCA6D,0x1A6D,0x5A6D,0x9A6D,0xDA6D,
 0x2A6D,0x6A6D,0xAA6D,0xEA6D,0x3A6D,0x7A6D,0xBA6D,0xFA6D,
 0x0E6D,0x4E6D,0x8E6D,0xCE6D,0x1E6D,0x5E6D,0x9E6D,0xDE6D,
 0x2E6D,0x6E6D,0xAE6D,0xEE6D,0x3E6D,0x7E6D,0xBE6D,0xFE6D,
 0x036D,0x436D,0x836D,0xC36D,0x136D,0x536D,0x936D,0xD36D,
 0x236D,0x636D,0xA36D,0xE36D,0x336D,0x736D,0xB36D,0xF36D,
 0x076D,0x476D,0x876D,0xC76D,0x176D,0x576D,0x976D,0xD76D,
 0x276D,0x676D,0xA76D,0xE76D,0x376D,0x776D,0xB76D,0xF76D,
 0x0B6D,0x4B6D,0x8B6D,0xCB6D,0x1B6D,0x5B6D,0x9B6D,0xDB6D,
 0x2B6D,0x6B6D,0xAB6D,0xEB6D,0x3B6D,0x7B6D,0xBB6D,0xFB6D,
 0x0F6D,0x4F6D,0x8F6D,0xCF6D,0x1F6D,0x5F6D,0x9F6D,0xDF6D,
 0x2F6D,0x6F6D,0xAF6D,0xEF6D,0x3F6D,0x7F6D,0xBF6D,0xFF6D,
 0x00AD,0x40AD,0x80AD,0xC0AD,0x10AD,0x50AD,0x90AD,0xD0AD,
 0x20AD,0x60AD,0xA0AD,0xE0AD,0x30AD,0x70AD,0xB0AD,0xF0AD,
 0x04AD,0x44AD,0x84AD,0xC4AD,0x14AD,0x54AD,0x94AD,0xD4AD,
 0x24AD,0x64AD,0xA4AD,0xE4AD,0x34AD,0x74AD,0xB4AD,0xF4AD,
 0x08AD,0x48AD,0x88AD,0xC8AD,0x18AD,0x58AD,0x98AD,0xD8AD,
 0x28AD,0x68AD,0xA8AD,0xE8AD,0x38AD,0x78AD,0xB8AD,0xF8AD,
 0x0CAD,0x4CAD,0x8CAD,0xCCAD,0x1CAD,0x5CAD,0x9CAD,0xDCAD,
 0x2CAD,0x6CAD,0xACAD,0xECAD,0x3CAD,0x7CAD,0xBCAD,0xFCAD,
 0x01AD,0x41AD,0x81AD,0xC1AD,0x11AD,0x51AD,0x91AD,0xD1AD,
 0x21AD,0x61AD,0xA1AD,0xE1AD,0x31AD,0x71AD,0xB1AD,0xF1AD,
 0x05AD,0x45AD,0x85AD,0xC5AD,0x15AD,0x55AD,0x95AD,0xD5AD,
 0x25AD,0x65AD,0xA5AD,0xE5AD,0x35AD,0x75AD,0xB5AD,0xF5AD,
 0x09AD,0x49AD,0x89AD,0xC9AD,0x19AD,0x59AD,0x99AD,0xD9AD,
 0x29AD,0x69AD,0xA9AD,0xE9AD,0x39AD,0x79AD,0xB9AD,0xF9AD,
 0x0DAD,0x4DAD,0x8DAD,0xCDAD,0x1DAD,0x5DAD,0x9DAD,0xDDAD,
 0x2DAD,0x6DAD,0xADAD,0xEDAD,0x3DAD,0x7DAD,0xBDAD,0xFDAD,
 0x02AD,0x42AD,0x82AD,0xC2AD,0x12AD,0x52AD,0x92AD,0xD2AD,
 0x22AD,0x62AD,0xA2AD,0xE2AD,0x32AD,0x72AD,0xB2AD,0xF2AD,
 0x06AD,0x46AD,0x86AD,0xC6AD,0x16AD,0x56AD,0x96AD,0xD6AD,
 0x26AD,0x66AD,0xA6AD,0xE6AD,0x36AD,0x76AD,0xB6AD,0xF6AD,
 0x0AAD,0x4AAD,0x8AAD,0xCAAD,0x1AAD,0x5AAD,0x9AAD,0xDAAD,
 0x2AAD,0x6AAD,0xAAAD,0xEAAD,0x3AAD,0x7AAD,0xBAAD,0xFAAD,
 0x0EAD,0x4EAD,0x8EAD,0xCEAD,0x1EAD,0x5EAD,0x9EAD,0xDEAD,
 0x2EAD,0x6EAD,0xAEAD,0xEEAD,0x3EAD,0x7EAD,0xBEAD,0xFEAD,
 0x03AD,0x43AD,0x83AD,0xC3AD,0x13AD,0x53AD,0x93AD,0xD3AD,
 0x23AD,0x63AD,0xA3AD,0xE3AD,0x33AD,0x73AD,0xB3AD,0xF3AD,
 0x07AD,0x47AD,0x87AD,0xC7AD,0x17AD,0x57AD,0x97AD,0xD7AD,
 0x27AD,0x67AD,0xA7AD,0xE7AD,0x37AD,0x77AD,0xB7AD,0xF7AD,
 0x0BAD,0x4BAD,0x8BAD,0xCBAD,0x1BAD,0x5BAD,0x9BAD,0xDBAD,
 0x2BAD,0x6BAD,0xABAD,0xEBAD,0x3BAD,0x7BAD,0xBBAD,0xFBAD,
 0x0FAD,0x4FAD,0x8FAD,0xCFAD,0x1FAD,0x5FAD,0x9FAD,0xDFAD,
 0x2FAD,0x6FAD,0xAFAD,0xEFAD,0x3FAD,0x7FAD,0xBFAD,0xFFAD,
 0x00ED,0x40ED,0x80ED,0xC0ED,0x10ED,0x50ED,0x90ED,0xD0ED,
 0x20ED,0x60ED,0xA0ED,0xE0ED,0x30ED,0x70ED,0xB0ED,0xF0ED,
 0x04ED,0x44ED,0x84ED,0xC4ED,0x14ED,0x54ED,0x94ED,0xD4ED,
 0x24ED,0x64ED,0xA4ED,0xE4ED,0x34ED,0x74ED,0xB4ED,0xF4ED,
 0x08ED,0x48ED,0x88ED,0xC8ED,0x18ED,0x58ED,0x98ED,0xD8ED,
 0x28ED,0x68ED,0xA8ED,0xE8ED,0x38ED,0x78ED,0xB8ED,0xF8ED,
 0x0CED,0x4CED,0x8CED,0xCCED,0x1CED,0x5CED,0x9CED,0xDCED,
 0x2CED,0x6CED,0xACED,0xECED,0x3CED,0x7CED,0xBCED,0xFCED,
 0x01ED,0x41ED,0x81ED,0xC1ED,0x11ED,0x51ED,0x91ED,0xD1ED,
 0x21ED,0x61ED,0xA1ED,0xE1ED,0x31ED,0x71ED,0xB1ED,0xF1ED,
 0x05ED,0x45ED,0x85ED,0xC5ED,0x15ED,0x55ED,0x95ED,0xD5ED,
 0x25ED,0x65ED,0xA5ED,0xE5ED,0x35ED,0x75ED,0xB5ED,0xF5ED,
 0x09ED,0x49ED,0x89ED,0xC9ED,0x19ED,0x59ED,0x99ED,0xD9ED,
 0x29ED,0x69ED,0xA9ED,0xE9ED,0x39ED,0x79ED,0xB9ED,0xF9ED,
 0x0DED,0x4DED,0x8DED,0xCDED,0x1DED,0x5DED,0x9DED,0xDDED,
 0x2DED,0x6DED,0xADED,0xEDED,0x3DED,0x7DED,0xBDED,0xFDED,
 0x02ED,0x42ED,0x82ED,0xC2ED,0x12ED,0x52ED,0x92ED,0xD2ED,
 0x22ED,0x62ED,0xA2ED,0xE2ED,0x32ED,0x72ED,0xB2ED,0xF2ED,
 0x06ED,0x46ED,0x86ED,0xC6ED,0x16ED,0x56ED,0x96ED,0xD6ED,
 0x26ED,0x66ED,0xA6ED,0xE6ED,0x36ED,0x76ED,0xB6ED,0xF6ED,
 0x0AED,0x4AED,0x8AED,0xCAED,0x1AED,0x5AED,0x9AED,0xDAED,
 0x2AED,0x6AED,0xAAED,0xEAED,0x3AED,0x7AED,0xBAED,0xFAED,
 0x0EED,0x4EED,0x8EED,0xCEED,0x1EED,0x5EED,0x9EED,0xDEED,
 0x2EED,0x6EED,0xAEED,0xEEED,0x3EED,0x7EED,0xBEED,0xFEED,
 0x03ED,0x43ED,0x83ED,0xC3ED,0x13ED,0x53ED,0x93ED,0xD3ED,
 0x23ED,0x63ED,0xA3ED,0xE3ED,0x33ED,0x73ED,0xB3ED,0xF3ED,
 0x07ED,0x47ED,0x87ED,0xC7ED,0x17ED,0x57ED,0x97ED,0xD7ED,
 0x27ED,0x67ED,0xA7ED,0xE7ED,0x37ED,0x77ED,0xB7ED,0xF7ED,
 0x0BED,0x4BED,0x8BED,0xCBED,0x1BED,0x5BED,0x9BED,0xDBED,
 0x2BED,0x6BED,0xABED,0xEBED,0x3BED,0x7BED,0xBBED,0xFBED,
 0x0FED,0x4FED,0x8FED,0xCFED,0x1FED,0x5FED,0x9FED,0xDFED,
 0x2FED,0x6FED,0xAFED,0xEFED,0x3FED,0x7FED,0xBFED,0xFFED,
 0x003D,0x403D,0x803D,0xC03D,0x103D,0x503D,0x903D,0xD03D,
 0x203D,0x603D,0xA03D,0xE03D,0x303D,0x703D,0xB03D,0xF03D,
 0x043D,0x443D,0x843D,0xC43D,0x143D,0x543D,0x943D,0xD43D,
 0x243D,0x643D,0xA43D,0xE43D,0x343D,0x743D,0xB43D,0xF43D,
 0x083D,0x483D,0x883D,0xC83D,0x183D,0x583D,0x983D,0xD83D,
 0x283D,0x683D,0xA83D,0xE83D,0x383D,0x783D,0xB83D,0xF83D,
 0x0C3D,0x4C3D,0x8C3D,0xCC3D,0x1C3D,0x5C3D,0x9C3D,0xDC3D,
 0x2C3D,0x6C3D,0xAC3D,0xEC3D,0x3C3D,0x7C3D,0xBC3D,0xFC3D,
 0x013D,0x413D,0x813D,0xC13D,0x113D,0x513D,0x913D,0xD13D,
 0x213D,0x613D,0xA13D,0xE13D,0x313D,0x713D,0xB13D,0xF13D,
 0x053D,0x453D,0x853D,0xC53D,0x153D,0x553D,0x953D,0xD53D,
 0x253D,0x653D,0xA53D,0xE53D,0x353D,0x753D,0xB53D,0xF53D,
 0x093D,0x493D,0x893D,0xC93D,0x193D,0x593D,0x993D,0xD93D,
 0x293D,0x693D,0xA93D,0xE93D,0x393D,0x793D,0xB93D,0xF93D,
 0x0D3D,0x4D3D,0x8D3D,0xCD3D,0x1D3D,0x5D3D,0x9D3D,0xDD3D,
 0x2D3D,0x6D3D,0xAD3D,0xED3D,0x3D3D,0x7D3D,0xBD3D,0xFD3D,
 0x023D,0x423D,0x823D,0xC23D,0x123D,0x523D,0x923D,0xD23D,
 0x223D,0x623D,0xA23D,0xE23D,0x323D,0x723D,0xB23D,0xF23D,
 0x063D,0x463D,0x863D,0xC63D,0x163D,0x563D,0x963D,0xD63D,
 0x263D,0x663D,0xA63D,0xE63D,0x363D,0x763D,0xB63D,0xF63D,
 0x0A3D,0x4A3D,0x8A3D,0xCA3D,0x1A3D,0x5A3D,0x9A3D,0xDA3D,
 0x2A3D,0x6A3D,0xAA3D,0xEA3D,0x3A3D,0x7A3D,0xBA3D,0xFA3D,
 0x0E3D,0x4E3D,0x8E3D,0xCE3D,0x1E3D,0x5E3D,0x9E3D,0xDE3D,
 0x2E3D,0x6E3D,0xAE3D,0xEE3D,0x3E3D,0x7E3D,0xBE3D,0xFE3D,
 0x033D,0x433D,0x833D,0xC33D,0x133D,0x533D,0x933D,0xD33D,
 0x233D,0x633D,0xA33D,0xE33D,0x333D,0x733D,0xB33D,0xF33D,
 0x073D,0x473D,0x873D,0xC73D,0x173D,0x573D,0x973D,0xD73D,
 0x273D,0x673D,0xA73D,0xE73D,0x373D,0x773D,0xB73D,0xF73D,
 0x0B3D,0x4B3D,0x8B3D,0xCB3D,0x1B3D,0x5B3D,0x9B3D,0xDB3D,
 0x2B3D,0x6B3D,0xAB3D,0xEB3D,0x3B3D,0x7B3D,0xBB3D,0xFB3D,
 0x0F3D,0x4F3D,0x8F3D,0xCF3D,0x1F3D,0x5F3D,0x9F3D,0xDF3D,
 0x2F3D,0x6F3D,0xAF3D,0xEF3D,0x3F3D,0x7F3D,0xBF3D,0xFF3D,
 0x007D,0x407D,0x807D,0xC07D,0x107D,0x507D,0x907D,0xD07D,
 0x207D,0x607D,0xA07D,0xE07D,0x307D,0x707D,0xB07D,0xF07D,
 0x047D,0x447D,0x847D,0xC47D,0x147D,0x547D,0x947D,0xD47D,
 0x247D,0x647D,0xA47D,0xE47D,0x347D,0x747D,0xB47D,0xF47D,
 0x087D,0x487D,0x887D,0xC87D,0x187D,0x587D,0x987D,0xD87D,
 0x287D,0x687D,0xA87D,0xE87D,0x387D,0x787D,0xB87D,0xF87D,
 0x0C7D,0x4C7D,0x8C7D,0xCC7D,0x1C7D,0x5C7D,0x9C7D,0xDC7D,
 0x2C7D,0x6C7D,0xAC7D,0xEC7D,0x3C7D,0x7C7D,0xBC7D,0xFC7D,
 0x017D,0x417D,0x817D,0xC17D,0x117D,0x517D,0x917D,0xD17D,
 0x217D,0x617D,0xA17D,0xE17D,0x317D,0x717D,0xB17D,0xF17D,
 0x057D,0x457D,0x857D,0xC57D,0x157D,0x557D,0x957D,0xD57D,
 0x257D,0x657D,0xA57D,0xE57D,0x357D,0x757D,0xB57D,0xF57D,
 0x097D,0x497D,0x897D,0xC97D,0x197D,0x597D,0x997D,0xD97D,
 0x297D,0x697D,0xA97D,0xE97D,0x397D,0x797D,0xB97D,0xF97D,
 0x0D7D,0x4D7D,0x8D7D,0xCD7D,0x1D7D,0x5D7D,0x9D7D,0xDD7D,
 0x2D7D,0x6D7D,0xAD7D,0xED7D,0x3D7D,0x7D7D,0xBD7D,0xFD7D,
 0x027D,0x427D,0x827D,0xC27D,0x127D,0x527D,0x927D,0xD27D,
 0x227D,0x627D,0xA27D,0xE27D,0x327D,0x727D,0xB27D,0xF27D,
 0x067D,0x467D,0x867D,0xC67D,0x167D,0x567D,0x967D,0xD67D,
 0x267D,0x667D,0xA67D,0xE67D,0x367D,0x767D,0xB67D,0xF67D,
 0x0A7D,0x4A7D,0x8A7D,0xCA7D,0x1A7D,0x5A7D,0x9A7D,0xDA7D,
 0x2A7D,0x6A7D,0xAA7D,0xEA7D,0x3A7D,0x7A7D,0xBA7D,0xFA7D,
 0x0E7D,0x4E7D,0x8E7D,0xCE7D,0x1E7D,0x5E7D,0x9E7D,0xDE7D,
 0x2E7D,0x6E7D,0xAE7D,0xEE7D,0x3E7D,0x7E7D,0xBE7D,0xFE7D,
 0x037D,0x437D,0x837D,0xC37D,0x137D,0x537D,0x937D,0xD37D,
 0x237D,0x637D,0xA37D,0xE37D,0x337D,0x737D,0xB37D,0xF37D,
 0x077D,0x477D,0x877D,0xC77D,0x177D,0x577D,0x977D,0xD77D,
 0x277D,0x677D,0xA77D,0xE77D,0x377D,0x777D,0xB77D,0xF77D,
 0x0B7D,0x4B7D,0x8B7D,0xCB7D,0x1B7D,0x5B7D,0x9B7D,0xDB7D,
 0x2B7D,0x6B7D,0xAB7D,0xEB7D,0x3B7D,0x7B7D,0xBB7D,0xFB7D,
 0x0F7D,0x4F7D,0x8F7D,0xCF7D,0x1F7D,0x5F7D,0x9F7D,0xDF7D,
 0x2F7D,0x6F7D,0xAF7D,0xEF7D,0x3F7D,0x7F7D,0xBF7D,0xFF7D,
 0x00BD,0x40BD,0x80BD,0xC0BD,0x10BD,0x50BD,0x90BD,0xD0BD,
 0x20BD,0x60BD,0xA0BD,0xE0BD,0x30BD,0x70BD,0xB0BD,0xF0BD,
 0x04BD,0x44BD,0x84BD,0xC4BD,0x14BD,0x54BD,0x94BD,0xD4BD,
 0x24BD,0x64BD,0xA4BD,0xE4BD,0x34BD,0x74BD,0xB4BD,0xF4BD,
 0x08BD,0x48BD,0x88BD,0xC8BD,0x18BD,0x58BD,0x98BD,0xD8BD,
 0x28BD,0x68BD,0xA8BD,0xE8BD,0x38BD,0x78BD,0xB8BD,0xF8BD,
 0x0CBD,0x4CBD,0x8CBD,0xCCBD,0x1CBD,0x5CBD,0x9CBD,0xDCBD,
 0x2CBD,0x6CBD,0xACBD,0xECBD,0x3CBD,0x7CBD,0xBCBD,0xFCBD,
 0x01BD,0x41BD,0x81BD,0xC1BD,0x11BD,0x51BD,0x91BD,0xD1BD,
 0x21BD,0x61BD,0xA1BD,0xE1BD,0x31BD,0x71BD,0xB1BD,0xF1BD,
 0x05BD,0x45BD,0x85BD,0xC5BD,0x15BD,0x55BD,0x95BD,0xD5BD,
 0x25BD,0x65BD,0xA5BD,0xE5BD,0x35BD,0x75BD,0xB5BD,0xF5BD,
 0x09BD,0x49BD,0x89BD,0xC9BD,0x19BD,0x59BD,0x99BD,0xD9BD,
 0x29BD,0x69BD,0xA9BD,0xE9BD,0x39BD,0x79BD,0xB9BD,0xF9BD,
 0x0DBD,0x4DBD,0x8DBD,0xCDBD,0x1DBD,0x5DBD,0x9DBD,0xDDBD,
 0x2DBD,0x6DBD,0xADBD,0xEDBD,0x3DBD,0x7DBD,0xBDBD,0xFDBD,
 0x02BD,0x42BD,0x82BD,0xC2BD,0x12BD,0x52BD,0x92BD,0xD2BD,
 0x22BD,0x62BD,0xA2BD,0xE2BD,0x32BD,0x72BD,0xB2BD,0xF2BD,
 0x06BD,0x46BD,0x86BD,0xC6BD,0x16BD,0x56BD,0x96BD,0xD6BD,
 0x26BD,0x66BD,0xA6BD,0xE6BD,0x36BD,0x76BD,0xB6BD,0xF6BD,
 0x0ABD,0x4ABD,0x8ABD,0xCABD,0x1ABD,0x5ABD,0x9ABD,0xDABD,
 0x2ABD,0x6ABD,0xAABD,0xEABD,0x3ABD,0x7ABD,0xBABD,0xFABD,
 0x0EBD,0x4EBD,0x8EBD,0xCEBD,0x1EBD,0x5EBD,0x9EBD,0xDEBD,
 0x2EBD,0x6EBD,0xAEBD,0xEEBD,0x3EBD,0x7EBD,0xBEBD,0xFEBD,
 0x03BD,0x43BD,0x83BD,0xC3BD,0x13BD,0x53BD,0x93BD,0xD3BD,
 0x23BD,0x63BD,0xA3BD,0xE3BD,0x33BD,0x73BD,0xB3BD,0xF3BD,
 0x07BD,0x47BD,0x87BD,0xC7BD,0x17BD,0x57BD,0x97BD,0xD7BD,
 0x27BD,0x67BD,0xA7BD,0xE7BD,0x37BD,0x77BD,0xB7BD,0xF7BD,
 0x0BBD,0x4BBD,0x8BBD,0xCBBD,0x1BBD,0x5BBD,0x9BBD,0xDBBD,
 0x2BBD,0x6BBD,0xABBD,0xEBBD,0x3BBD,0x7BBD,0xBBBD,0xFBBD,
 0x0FBD,0x4FBD,0x8FBD,0xCFBD,0x1FBD,0x5FBD,0x9FBD,0xDFBD,
 0x2FBD,0x6FBD,0xAFBD,0xEFBD,0x3FBD,0x7FBD,0xBFBD,0xFFBD,
 0x00FD,0x40FD,0x80FD,0xC0FD,0x10FD,0x50FD,0x90FD,0xD0FD,
 0x20FD,0x60FD,0xA0FD,0xE0FD,0x30FD,0x70FD,0xB0FD,0xF0FD,
 0x04FD,0x44FD,0x84FD,0xC4FD,0x14FD,0x54FD,0x94FD,0xD4FD,
 0x24FD,0x64FD,0xA4FD,0xE4FD,0x34FD,0x74FD,0xB4FD,0xF4FD,
 0x08FD,0x48FD,0x88FD,0xC8FD,0x18FD,0x58FD,0x98FD,0xD8FD,
 0x28FD,0x68FD,0xA8FD,0xE8FD,0x38FD,0x78FD,0xB8FD,0xF8FD,
 0x0CFD,0x4CFD,0x8CFD,0xCCFD,0x1CFD,0x5CFD,0x9CFD,0xDCFD,
 0x2CFD,0x6CFD,0xACFD,0xECFD,0x3CFD,0x7CFD,0xBCFD,0xFCFD,
 0x01FD,0x41FD,0x81FD,0xC1FD,0x11FD,0x51FD,0x91FD,0xD1FD,
 0x21FD,0x61FD,0xA1FD,0xE1FD,0x31FD,0x71FD,0xB1FD,0xF1FD,
 0x05FD,0x45FD,0x85FD,0xC5FD,0x15FD,0x55FD,0x95FD,0xD5FD,
 0x25FD,0x65FD,0xA5FD,0xE5FD,0x35FD,0x75FD,0xB5FD,0xF5FD,
 0x09FD,0x49FD,0x89FD,0xC9FD,0x19FD,0x59FD,0x99FD,0xD9FD,
 0x29FD,0x69FD,0xA9FD,0xE9FD,0x39FD,0x79FD,0xB9FD,0xF9FD,
 0x0DFD,0x4DFD,0x8DFD,0xCDFD,0x1DFD,0x5DFD,0x9DFD,0xDDFD,
 0x2DFD,0x6DFD,0xADFD,0xEDFD,0x3DFD,0x7DFD,0xBDFD,0xFDFD,
 0x02FD,0x42FD,0x82FD,0xC2FD,0x12FD,0x52FD,0x92FD,0xD2FD,
 0x22FD,0x62FD,0xA2FD,0xE2FD,0x32FD,0x72FD,0xB2FD,0xF2FD,
 0x06FD,0x46FD,0x86FD,0xC6FD,0x16FD,0x56FD,0x96FD,0xD6FD,
 0x26FD,0x66FD,0xA6FD,0xE6FD,0x36FD,0x76FD,0xB6FD,0xF6FD,
 0x0AFD,0x4AFD,0x8AFD,0xCAFD,0x1AFD,0x5AFD,0x9AFD,0xDAFD,
 0x2AFD,0x6AFD,0xAAFD,0xEAFD,0x3AFD,0x7AFD,0xBAFD,0xFAFD,
 0x0EFD,0x4EFD,0x8EFD,0xCEFD,0x1EFD,0x5EFD,0x9EFD,0xDEFD,
 0x2EFD,0x6EFD,0xAEFD,0xEEFD,0x3EFD,0x7EFD,0xBEFD,0xFEFD,
 0x03FD,0x43FD,0x83FD,0xC3FD,0x13FD,0x53FD,0x93FD,0xD3FD,
 0x23FD,0x63FD,0xA3FD,0xE3FD,0x33FD,0x73FD,0xB3FD,0xF3FD,
 0x07FD,0x47FD,0x87FD,0xC7FD,0x17FD,0x57FD,0x97FD,0xD7FD,
 0x27FD,0x67FD,0xA7FD,0xE7FD,0x37FD,0x77FD,0xB7FD,0xF7FD,
 0x0BFD,0x4BFD,0x8BFD,0xCBFD,0x1BFD,0x5BFD,0x9BFD,0xDBFD,
 0x2BFD,0x6BFD,0xABFD,0xEBFD,0x3BFD,0x7BFD,0xBBFD,0xFBFD,
 0x0FFD,0x4FFD,0x8FFD,0xCFFD,0x1FFD,0x5FFD,0x9FFD,0xDFFD,
 0x2FFD,0x6FFD,0xAFFD,0xEFFD,0x3FFD,0x7FFD,0xBFFD,0xFFFD,
 0x0002,0x4002,0x8002,0xC002,0x1002,0x5002,0x9002,0xD002,
 0x2002,0x6002,0xA002,0xE002,0x3002,0x7002,0xB002,0xF002,
 0x0402,0x4402,0x8402,0xC402,0x1402,0x5402,0x9402,0xD402,
 0x2402,0x6402,0xA402,0xE402,0x3402,0x7402,0xB402,0xF402,
 0x0802,0x4802,0x8802,0xC802,0x1802,0x5802,0x9802,0xD802,
 0x2802,0x6802,0xA802,0xE802,0x3802,0x7802,0xB802,0xF802,
 0x0C02,0x4C02,0x8C02,0xCC02,0x1C02,0x5C02,0x9C02,0xDC02,
 0x2C02,0x6C02,0xAC02,0xEC02,0x3C02,0x7C02,0xBC02,0xFC02,
 0x0102,0x4102,0x8102,0xC102,0x1102,0x5102,0x9102,0xD102,
 0x2102,0x6102,0xA102,0xE102,0x3102,0x7102,0xB102,0xF102,
 0x0502,0x4502,0x8502,0xC502,0x1502,0x5502,0x9502,0xD502,
 0x2502,0x6502,0xA502,0xE502,0x3502,0x7502,0xB502,0xF502,
 0x0902,0x4902,0x8902,0xC902,0x1902,0x5902,0x9902,0xD902,
 0x2902,0x6902,0xA902,0xE902,0x3902,0x7902,0xB902,0xF902,
 0x0D02,0x4D02,0x8D02,0xCD02,0x1D02,0x5D02,0x9D02,0xDD02,
 0x2D02,0x6D02,0xAD02,0xED02,0x3D02,0x7D02,0xBD02,0xFD02,
 0x0202,0x4202,0x8202,0xC202,0x1202,0x5202,0x9202,0xD202,
 0x2202,0x6202,0xA202,0xE202,0x3202,0x7202,0xB202,0xF202,
 0x0602,0x4602,0x8602,0xC602,0x1602,0x5602,0x9602,0xD602,
 0x2602,0x6602,0xA602,0xE602,0x3602,0x7602,0xB602,0xF602,
 0x0A02,0x4A02,0x8A02,0xCA02,0x1A02,0x5A02,0x9A02,0xDA02,
 0x2A02,0x6A02,0xAA02,0xEA02,0x3A02,0x7A02,0xBA02,0xFA02,
 0x0E02,0x4E02,0x8E02,0xCE02,0x1E02,0x5E02,0x9E02,0xDE02,
 0x2E02,0x6E02,0xAE02,0xEE02,0x3E02,0x7E02,0xBE02,0xFE02,
 0x0302,0x4302,0x8302,0xC302,0x1302,0x5302,0x9302,0xD302,
 0x2302,0x6302,0xA302,0xE302,0x3302,0x7302,0xB302,0xF302,
 0x0702,0x4702,0x8702,0xC702,0x1702,0x5702,0x9702,0xD702,
 0x2702,0x6702,0xA702,0xE702,0x3702,0x7702,0xB702,0xF702,
 0x0B02,0x4B02,0x8B02,0xCB02,0x1B02,0x5B02,0x9B02,0xDB02,
 0x2B02,0x6B02,0xAB02,0xEB02,0x3B02,0x7B02,0xBB02,0xFB02,
 0x0F02,0x4F02,0x8F02,0xCF02,0x1F02,0x5F02,0x9F02,0xDF02,
 0x2F02,0x6F02,0xAF02,0xEF02,0x3F02,0x7F02,0xBF02,0xFF02,
 0x0042,0x4042,0x8042,0xC042,0x1042,0x5042,0x9042,0xD042,
 0x2042,0x6042,0xA042,0xE042,0x3042,0x7042,0xB042,0xF042,
 0x0442,0x4442,0x8442,0xC442,0x1442,0x5442,0x9442,0xD442,
 0x2442,0x6442,0xA442,0xE442,0x3442,0x7442,0xB442,0xF442,
 0x0842,0x4842,0x8842,0xC842,0x1842,0x5842,0x9842,0xD842,
 0x2842,0x6842,0xA842,0xE842,0x3842,0x7842,0xB842,0xF842,
 0x0C42,0x4C42,0x8C42,0xCC42,0x1C42,0x5C42,0x9C42,0xDC42,
 0x2C42,0x6C42,0xAC42,0xEC42,0x3C42,0x7C42,0xBC42,0xFC42,
 0x0142,0x4142,0x8142,0xC142,0x1142,0x5142,0x9142,0xD142,
 0x2142,0x6142,0xA142,0xE142,0x3142,0x7142,0xB142,0xF142,
 0x0542,0x4542,0x8542,0xC542,0x1542,0x5542,0x9542,0xD542,
 0x2542,0x6542,0xA542,0xE542,0x3542,0x7542,0xB542,0xF542,
 0x0942,0x4942,0x8942,0xC942,0x1942,0x5942,0x9942,0xD942,
 0x2942,0x6942,0xA942,0xE942,0x3942,0x7942,0xB942,0xF942,
 0x0D42,0x4D42,0x8D42,0xCD42,0x1D42,0x5D42,0x9D42,0xDD42,
 0x2D42,0x6D42,0xAD42,0xED42,0x3D42,0x7D42,0xBD42,0xFD42,
 0x0242,0x4242,0x8242,0xC242,0x1242,0x5242,0x9242,0xD242,
 0x2242,0x6242,0xA242,0xE242,0x3242,0x7242,0xB242,0xF242,
 0x0642,0x4642,0x8642,0xC642,0x1642,0x5642,0x9642,0xD642,
 0x2642,0x6642,0xA642,0xE642,0x3642,0x7642,0xB642,0xF642,
 0x0A42,0x4A42,0x8A42,0xCA42,0x1A42,0x5A42,0x9A42,0xDA42,
 0x2A42,0x6A42,0xAA42,0xEA42,0x3A42,0x7A42,0xBA42,0xFA42,
 0x0E42,0x4E42,0x8E42,0xCE42,0x1E42,0x5E42,0x9E42,0xDE42,
 0x2E42,0x6E42,0xAE42,0xEE42,0x3E42,0x7E42,0xBE42,0xFE42,
 0x0342,0x4342,0x8342,0xC342,0x1342,0x5342,0x9342,0xD342,
 0x2342,0x6342,0xA342,0xE342,0x3342,0x7342,0xB342,0xF342,
 0x0742,0x4742,0x8742,0xC742,0x1742,0x5742,0x9742,0xD742,
 0x2742,0x6742,0xA742,0xE742,0x3742,0x7742,0xB742,0xF742,
 0x0B42,0x4B42,0x8B42,0xCB42,0x1B42,0x5B42,0x9B42,0xDB42,
 0x2B42,0x6B42,0xAB42,0xEB42,0x3B42,0x7B42,0xBB42,0xFB42,
 0x0F42,0x4F42,0x8F42,0xCF42,0x1F42,0x5F42,0x9F42,0xDF42,
 0x2F42,0x6F42,0xAF42,0xEF42,0x3F42,0x7F42,0xBF42,0xFF42,
 0x0082,0x4082,0x8082,0xC082,0x1082,0x5082,0x9082,0xD082,
 0x2082,0x6082,0xA082,0xE082,0x3082,0x7082,0xB082,0xF082,
 0x0482,0x4482,0x8482,0xC482,0x1482,0x5482,0x9482,0xD482,
 0x2482,0x6482,0xA482,0xE482,0x3482,0x7482,0xB482,0xF482,
 0x0882,0x4882,0x8882,0xC882,0x1882,0x5882,0x9882,0xD882,
 0x2882,0x6882,0xA882,0xE882,0x3882,0x7882,0xB882,0xF882,
 0x0C82,0x4C82,0x8C82,0xCC82,0x1C82,0x5C82,0x9C82,0xDC82,
 0x2C82,0x6C82,0xAC82,0xEC82,0x3C82,0x7C82,0xBC82,0xFC82,
 0x0182,0x4182,0x8182,0xC182,0x1182,0x5182,0x9182,0xD182,
 0x2182,0x6182,0xA182,0xE182,0x3182,0x7182,0xB182,0xF182,
 0x0582,0x4582,0x8582,0xC582,0x1582,0x5582,0x9582,0xD582,
 0x2582,0x6582,0xA582,0xE582,0x3582,0x7582,0xB582,0xF582,
 0x0982,0x4982,0x8982,0xC982,0x1982,0x5982,0x9982,0xD982,
 0x2982,0x6982,0xA982,0xE982,0x3982,0x7982,0xB982,0xF982,
 0x0D82,0x4D82,0x8D82,0xCD82,0x1D82,0x5D82,0x9D82,0xDD82,
 0x2D82,0x6D82,0xAD82,0xED82,0x3D82,0x7D82,0xBD82,0xFD82,
 0x0282,0x4282,0x8282,0xC282,0x1282,0x5282,0x9282,0xD282,
 0x2282,0x6282,0xA282,0xE282,0x3282,0x7282,0xB282,0xF282,
 0x0682,0x4682,0x8682,0xC682,0x1682,0x5682,0x9682,0xD682,
 0x2682,0x6682,0xA682,0xE682,0x3682,0x7682,0xB682,0xF682,
 0x0A82,0x4A82,0x8A82,0xCA82,0x1A82,0x5A82,0x9A82,0xDA82,
 0x2A82,0x6A82,0xAA82,0xEA82,0x3A82,0x7A82,0xBA82,0xFA82,
 0x0E82,0x4E82,0x8E82,0xCE82,0x1E82,0x5E82,0x9E82,0xDE82,
 0x2E82,0x6E82,0xAE82,0xEE82,0x3E82,0x7E82,0xBE82,0xFE82,
 0x0382,0x4382,0x8382,0xC382,0x1382,0x5382,0x9382,0xD382,
 0x2382,0x6382,0xA382,0xE382,0x3382,0x7382,0xB382,0xF382,
 0x0782,0x4782,0x8782,0xC782,0x1782,0x5782,0x9782,0xD782,
 0x2782,0x6782,0xA782,0xE782,0x3782,0x7782,0xB782,0xF782,
 0x0B82,0x4B82,0x8B82,0xCB82,0x1B82,0x5B82,0x9B82,0xDB82,
 0x2B82,0x6B82,0xAB82,0xEB82,0x3B82,0x7B82,0xBB82,0xFB82,
 0x0F82,0x4F82,0x8F82,0xCF82,0x1F82,0x5F82,0x9F82,0xDF82,
 0x2F82,0x6F82,0xAF82,0xEF82,0x3F82,0x7F82,0xBF82,0xFF82,
 0x00C2,0x40C2,0x80C2,0xC0C2,0x10C2,0x50C2,0x90C2,0xD0C2,
 0x20C2,0x60C2,0xA0C2,0xE0C2,0x30C2,0x70C2,0xB0C2,0xF0C2,
 0x04C2,0x44C2,0x84C2,0xC4C2,0x14C2,0x54C2,0x94C2,0xD4C2,
 0x24C2,0x64C2,0xA4C2,0xE4C2,0x34C2,0x74C2,0xB4C2,0xF4C2,
 0x08C2,0x48C2,0x88C2,0xC8C2,0x18C2,0x58C2,0x98C2,0xD8C2,
 0x28C2,0x68C2,0xA8C2,0xE8C2,0x38C2,0x78C2,0xB8C2,0xF8C2,
 0x0CC2,0x4CC2,0x8CC2,0xCCC2,0x1CC2,0x5CC2,0x9CC2,0xDCC2,
 0x2CC2,0x6CC2,0xACC2,0xECC2,0x3CC2,0x7CC2,0xBCC2,0xFCC2,
 0x01C2,0x41C2,0x81C2,0xC1C2,0x11C2,0x51C2,0x91C2,0xD1C2,
 0x21C2,0x61C2,0xA1C2,0xE1C2,0x31C2,0x71C2,0xB1C2,0xF1C2,
 0x05C2,0x45C2,0x85C2,0xC5C2,0x15C2,0x55C2,0x95C2,0xD5C2,
 0x25C2,0x65C2,0xA5C2,0xE5C2,0x35C2,0x75C2,0xB5C2,0xF5C2,
 0x09C2,0x49C2,0x89C2,0xC9C2,0x19C2,0x59C2,0x99C2,0xD9C2,
 0x29C2,0x69C2,0xA9C2,0xE9C2,0x39C2,0x79C2,0xB9C2,0xF9C2,
 0x0DC2,0x4DC2,0x8DC2,0xCDC2,0x1DC2,0x5DC2,0x9DC2,0xDDC2,
 0x2DC2,0x6DC2,0xADC2,0xEDC2,0x3DC2,0x7DC2,0xBDC2,0xFDC2,
 0x02C2,0x42C2,0x82C2,0xC2C2,0x12C2,0x52C2,0x92C2,0xD2C2,
 0x22C2,0x62C2,0xA2C2,0xE2C2,0x32C2,0x72C2,0xB2C2,0xF2C2,
 0x06C2,0x46C2,0x86C2,0xC6C2,0x16C2,0x56C2,0x96C2,0xD6C2,
 0x26C2,0x66C2,0xA6C2,0xE6C2,0x36C2,0x76C2,0xB6C2,0xF6C2,
 0x0AC2,0x4AC2,0x8AC2,0xCAC2,0x1AC2,0x5AC2,0x9AC2,0xDAC2,
 0x2AC2,0x6AC2,0xAAC2,0xEAC2,0x3AC2,0x7AC2,0xBAC2,0xFAC2,
 0x0EC2,0x4EC2,0x8EC2,0xCEC2,0x1EC2,0x5EC2,0x9EC2,0xDEC2,
 0x2EC2,0x6EC2,0xAEC2,0xEEC2,0x3EC2,0x7EC2,0xBEC2,0xFEC2,
 0x03C2,0x43C2,0x83C2,0xC3C2,0x13C2,0x53C2,0x93C2,0xD3C2,
 0x23C2,0x63C2,0xA3C2,0xE3C2,0x33C2,0x73C2,0xB3C2,0xF3C2,
 0x07C2,0x47C2,0x87C2,0xC7C2,0x17C2,0x57C2,0x97C2,0xD7C2,
 0x27C2,0x67C2,0xA7C2,0xE7C2,0x37C2,0x77C2,0xB7C2,0xF7C2,
 0x0BC2,0x4BC2,0x8BC2,0xCBC2,0x1BC2,0x5BC2,0x9BC2,0xDBC2,
 0x2BC2,0x6BC2,0xABC2,0xEBC2,0x3BC2,0x7BC2,0xBBC2,0xFBC2,
 0x0FC2,0x4FC2,0x8FC2,0xCFC2,0x1FC2,0x5FC2,0x9FC2,0xDFC2,
 0x2FC2,0x6FC2,0xAFC2,0xEFC2,0x3FC2,0x7FC2,0xBFC2,0xFFC2,
 0x0012,0x4012,0x8012,0xC012,0x1012,0x5012,0x9012,0xD012,
 0x2012,0x6012,0xA012,0xE012,0x3012,0x7012,0xB012,0xF012,
 0x0412,0x4412,0x8412,0xC412,0x1412,0x5412,0x9412,0xD412,
 0x2412,0x6412,0xA412,0xE412,0x3412,0x7412,0xB412,0xF412,
 0x0812,0x4812,0x8812,0xC812,0x1812,0x5812,0x9812,0xD812,
 0x2812,0x6812,0xA812,0xE812,0x3812,0x7812,0xB812,0xF812,
 0x0C12,0x4C12,0x8C12,0xCC12,0x1C12,0x5C12,0x9C12,0xDC12,
 0x2C12,0x6C12,0xAC12,0xEC12,0x3C12,0x7C12,0xBC12,0xFC12,
 0x0112,0x4112,0x8112,0xC112,0x1112,0x5112,0x9112,0xD112,
 0x2112,0x6112,0xA112,0xE112,0x3112,0x7112,0xB112,0xF112,
 0x0512,0x4512,0x8512,0xC512,0x1512,0x5512,0x9512,0xD512,
 0x2512,0x6512,0xA512,0xE512,0x3512,0x7512,0xB512,0xF512,
 0x0912,0x4912,0x8912,0xC912,0x1912,0x5912,0x9912,0xD912,
 0x2912,0x6912,0xA912,0xE912,0x3912,0x7912,0xB912,0xF912,
 0x0D12,0x4D12,0x8D12,0xCD12,0x1D12,0x5D12,0x9D12,0xDD12,
 0x2D12,0x6D12,0xAD12,0xED12,0x3D12,0x7D12,0xBD12,0xFD12,
 0x0212,0x4212,0x8212,0xC212,0x1212,0x5212,0x9212,0xD212,
 0x2212,0x6212,0xA212,0xE212,0x3212,0x7212,0xB212,0xF212,
 0x0612,0x4612,0x8612,0xC612,0x1612,0x5612,0x9612,0xD612,
 0x2612,0x6612,0xA612,0xE612,0x3612,0x7612,0xB612,0xF612,
 0x0A12,0x4A12,0x8A12,0xCA12,0x1A12,0x5A12,0x9A12,0xDA12,
 0x2A12,0x6A12,0xAA12,0xEA12,0x3A12,0x7A12,0xBA12,0xFA12,
 0x0E12,0x4E12,0x8E12,0xCE12,0x1E12,0x5E12,0x9E12,0xDE12,
 0x2E12,0x6E12,0xAE12,0xEE12,0x3E12,0x7E12,0xBE12,0xFE12,
 0x0312,0x4312,0x8312,0xC312,0x1312,0x5312,0x9312,0xD312,
 0x2312,0x6312,0xA312,0xE312,0x3312,0x7312,0xB312,0xF312,
 0x0712,0x4712,0x8712,0xC712,0x1712,0x5712,0x9712,0xD712,
 0x2712,0x6712,0xA712,0xE712,0x3712,0x7712,0xB712,0xF712,
 0x0B12,0x4B12,0x8B12,0xCB12,0x1B12,0x5B12,0x9B12,0xDB12,
 0x2B12,0x6B12,0xAB12,0xEB12,0x3B12,0x7B12,0xBB12,0xFB12,
 0x0F12,0x4F12,0x8F12,0xCF12,0x1F12,0x5F12,0x9F12,0xDF12,
 0x2F12,0x6F12,0xAF12,0xEF12,0x3F12,0x7F12,0xBF12,0xFF12,
 0x0052,0x4052,0x8052,0xC052,0x1052,0x5052,0x9052,0xD052,
 0x2052,0x6052,0xA052,0xE052,0x3052,0x7052,0xB052,0xF052,
 0x0452,0x4452,0x8452,0xC452,0x1452,0x5452,0x9452,0xD452,
 0x2452,0x6452,0xA452,0xE452,0x3452,0x7452,0xB452,0xF452,
 0x0852,0x4852,0x8852,0xC852,0x1852,0x5852,0x9852,0xD852,
 0x2852,0x6852,0xA852,0xE852,0x3852,0x7852,0xB852,0xF852,
 0x0C52,0x4C52,0x8C52,0xCC52,0x1C52,0x5C52,0x9C52,0xDC52,
 0x2C52,0x6C52,0xAC52,0xEC52,0x3C52,0x7C52,0xBC52,0xFC52,
 0x0152,0x4152,0x8152,0xC152,0x1152,0x5152,0x9152,0xD152,
 0x2152,0x6152,0xA152,0xE152,0x3152,0x7152,0xB152,0xF152,
 0x0552,0x4552,0x8552,0xC552,0x1552,0x5552,0x9552,0xD552,
 0x2552,0x6552,0xA552,0xE552,0x3552,0x7552,0xB552,0xF552,
 0x0952,0x4952,0x8952,0xC952,0x1952,0x5952,0x9952,0xD952,
 0x2952,0x6952,0xA952,0xE952,0x3952,0x7952,0xB952,0xF952,
 0x0D52,0x4D52,0x8D52,0xCD52,0x1D52,0x5D52,0x9D52,0xDD52,
 0x2D52,0x6D52,0xAD52,0xED52,0x3D52,0x7D52,0xBD52,0xFD52,
 0x0252,0x4252,0x8252,0xC252,0x1252,0x5252,0x9252,0xD252,
 0x2252,0x6252,0xA252,0xE252,0x3252,0x7252,0xB252,0xF252,
 0x0652,0x4652,0x8652,0xC652,0x1652,0x5652,0x9652,0xD652,
 0x2652,0x6652,0xA652,0xE652,0x3652,0x7652,0xB652,0xF652,
 0x0A52,0x4A52,0x8A52,0xCA52,0x1A52,0x5A52,0x9A52,0xDA52,
 0x2A52,0x6A52,0xAA52,0xEA52,0x3A52,0x7A52,0xBA52,0xFA52,
 0x0E52,0x4E52,0x8E52,0xCE52,0x1E52,0x5E52,0x9E52,0xDE52,
 0x2E52,0x6E52,0xAE52,0xEE52,0x3E52,0x7E52,0xBE52,0xFE52,
 0x0352,0x4352,0x8352,0xC352,0x1352,0x5352,0x9352,0xD352,
 0x2352,0x6352,0xA352,0xE352,0x3352,0x7352,0xB352,0xF352,
 0x0752,0x4752,0x8752,0xC752,0x1752,0x5752,0x9752,0xD752,
 0x2752,0x6752,0xA752,0xE752,0x3752,0x7752,0xB752,0xF752,
 0x0B52,0x4B52,0x8B52,0xCB52,0x1B52,0x5B52,0x9B52,0xDB52,
 0x2B52,0x6B52,0xAB52,0xEB52,0x3B52,0x7B52,0xBB52,0xFB52,
 0x0F52,0x4F52,0x8F52,0xCF52,0x1F52,0x5F52,0x9F52,0xDF52,
 0x2F52,0x6F52,0xAF52,0xEF52,0x3F52,0x7F52,0xBF52,0xFF52,
 0x0092,0x4092,0x8092,0xC092,0x1092,0x5092,0x9092,0xD092,
 0x2092,0x6092,0xA092,0xE092,0x3092,0x7092,0xB092,0xF092,
 0x0492,0x4492,0x8492,0xC492,0x1492,0x5492,0x9492,0xD492,
 0x2492,0x6492,0xA492,0xE492,0x3492,0x7492,0xB492,0xF492,
 0x0892,0x4892,0x8892,0xC892,0x1892,0x5892,0x9892,0xD892,
 0x2892,0x6892,0xA892,0xE892,0x3892,0x7892,0xB892,0xF892,
 0x0C92,0x4C92,0x8C92,0xCC92,0x1C92,0x5C92,0x9C92,0xDC92,
 0x2C92,0x6C92,0xAC92,0xEC92,0x3C92,0x7C92,0xBC92,0xFC92,
 0x0192,0x4192,0x8192,0xC192,0x1192,0x5192,0x9192,0xD192,
 0x2192,0x6192,0xA192,0xE192,0x3192,0x7192,0xB192,0xF192,
 0x0592,0x4592,0x8592,0xC592,0x1592,0x5592,0x9592,0xD592,
 0x2592,0x6592,0xA592,0xE592,0x3592,0x7592,0xB592,0xF592,
 0x0992,0x4992,0x8992,0xC992,0x1992,0x5992,0x9992,0xD992,
 0x2992,0x6992,0xA992,0xE992,0x3992,0x7992,0xB992,0xF992,
 0x0D92,0x4D92,0x8D92,0xCD92,0x1D92,0x5D92,0x9D92,0xDD92,
 0x2D92,0x6D92,0xAD92,0xED92,0x3D92,0x7D92,0xBD92,0xFD92,
 0x0292,0x4292,0x8292,0xC292,0x1292,0x5292,0x9292,0xD292,
 0x2292,0x6292,0xA292,0xE292,0x3292,0x7292,0xB292,0xF292,
 0x0692,0x4692,0x8692,0xC692,0x1692,0x5692,0x9692,0xD692,
 0x2692,0x6692,0xA692,0xE692,0x3692,0x7692,0xB692,0xF692,
 0x0A92,0x4A92,0x8A92,0xCA92,0x1A92,0x5A92,0x9A92,0xDA92,
 0x2A92,0x6A92,0xAA92,0xEA92,0x3A92,0x7A92,0xBA92,0xFA92,
 0x0E92,0x4E92,0x8E92,0xCE92,0x1E92,0x5E92,0x9E92,0xDE92,
 0x2E92,0x6E92,0xAE92,0xEE92,0x3E92,0x7E92,0xBE92,0xFE92,
 0x0392,0x4392,0x8392,0xC392,0x1392,0x5392,0x9392,0xD392,
 0x2392,0x6392,0xA392,0xE392,0x3392,0x7392,0xB392,0xF392,
 0x0792,0x4792,0x8792,0xC792,0x1792,0x5792,0x9792,0xD792,
 0x2792,0x6792,0xA792,0xE792,0x3792,0x7792,0xB792,0xF792,
 0x0B92,0x4B92,0x8B92,0xCB92,0x1B92,0x5B92,0x9B92,0xDB92,
 0x2B92,0x6B92,0xAB92,0xEB92,0x3B92,0x7B92,0xBB92,0xFB92,
 0x0F92,0x4F92,0x8F92,0xCF92,0x1F92,0x5F92,0x9F92,0xDF92,
 0x2F92,0x6F92,0xAF92,0xEF92,0x3F92,0x7F92,0xBF92,0xFF92,
 0x00D2,0x40D2,0x80D2,0xC0D2,0x10D2,0x50D2,0x90D2,0xD0D2,
 0x20D2,0x60D2,0xA0D2,0xE0D2,0x30D2,0x70D2,0xB0D2,0xF0D2,
 0x04D2,0x44D2,0x84D2,0xC4D2,0x14D2,0x54D2,0x94D2,0xD4D2,
 0x24D2,0x64D2,0xA4D2,0xE4D2,0x34D2,0x74D2,0xB4D2,0xF4D2,
 0x08D2,0x48D2,0x88D2,0xC8D2,0x18D2,0x58D2,0x98D2,0xD8D2,
 0x28D2,0x68D2,0xA8D2,0xE8D2,0x38D2,0x78D2,0xB8D2,0xF8D2,
 0x0CD2,0x4CD2,0x8CD2,0xCCD2,0x1CD2,0x5CD2,0x9CD2,0xDCD2,
 0x2CD2,0x6CD2,0xACD2,0xECD2,0x3CD2,0x7CD2,0xBCD2,0xFCD2,
 0x01D2,0x41D2,0x81D2,0xC1D2,0x11D2,0x51D2,0x91D2,0xD1D2,
 0x21D2,0x61D2,0xA1D2,0xE1D2,0x31D2,0x71D2,0xB1D2,0xF1D2,
 0x05D2,0x45D2,0x85D2,0xC5D2,0x15D2,0x55D2,0x95D2,0xD5D2,
 0x25D2,0x65D2,0xA5D2,0xE5D2,0x35D2,0x75D2,0xB5D2,0xF5D2,
 0x09D2,0x49D2,0x89D2,0xC9D2,0x19D2,0x59D2,0x99D2,0xD9D2,
 0x29D2,0x69D2,0xA9D2,0xE9D2,0x39D2,0x79D2,0xB9D2,0xF9D2,
 0x0DD2,0x4DD2,0x8DD2,0xCDD2,0x1DD2,0x5DD2,0x9DD2,0xDDD2,
 0x2DD2,0x6DD2,0xADD2,0xEDD2,0x3DD2,0x7DD2,0xBDD2,0xFDD2,
 0x02D2,0x42D2,0x82D2,0xC2D2,0x12D2,0x52D2,0x92D2,0xD2D2,
 0x22D2,0x62D2,0xA2D2,0xE2D2,0x32D2,0x72D2,0xB2D2,0xF2D2,
 0x06D2,0x46D2,0x86D2,0xC6D2,0x16D2,0x56D2,0x96D2,0xD6D2,
 0x26D2,0x66D2,0xA6D2,0xE6D2,0x36D2,0x76D2,0xB6D2,0xF6D2,
 0x0AD2,0x4AD2,0x8AD2,0xCAD2,0x1AD2,0x5AD2,0x9AD2,0xDAD2,
 0x2AD2,0x6AD2,0xAAD2,0xEAD2,0x3AD2,0x7AD2,0xBAD2,0xFAD2,
 0x0ED2,0x4ED2,0x8ED2,0xCED2,0x1ED2,0x5ED2,0x9ED2,0xDED2,
 0x2ED2,0x6ED2,0xAED2,0xEED2,0x3ED2,0x7ED2,0xBED2,0xFED2,
 0x03D2,0x43D2,0x83D2,0xC3D2,0x13D2,0x53D2,0x93D2,0xD3D2,
 0x23D2,0x63D2,0xA3D2,0xE3D2,0x33D2,0x73D2,0xB3D2,0xF3D2,
 0x07D2,0x47D2,0x87D2,0xC7D2,0x17D2,0x57D2,0x97D2,0xD7D2,
 0x27D2,0x67D2,0xA7D2,0xE7D2,0x37D2,0x77D2,0xB7D2,0xF7D2,
 0x0BD2,0x4BD2,0x8BD2,0xCBD2,0x1BD2,0x5BD2,0x9BD2,0xDBD2,
 0x2BD2,0x6BD2,0xABD2,0xEBD2,0x3BD2,0x7BD2,0xBBD2,0xFBD2,
 0x0FD2,0x4FD2,0x8FD2,0xCFD2,0x1FD2,0x5FD2,0x9FD2,0xDFD2,
 0x2FD2,0x6FD2,0xAFD2,0xEFD2,0x3FD2,0x7FD2,0xBFD2,0xFFD2,
 0x0022,0x4022,0x8022,0xC022,0x1022,0x5022,0x9022,0xD022,
 0x2022,0x6022,0xA022,0xE022,0x3022,0x7022,0xB022,0xF022,
 0x0422,0x4422,0x8422,0xC422,0x1422,0x5422,0x9422,0xD422,
 0x2422,0x6422,0xA422,0xE422,0x3422,0x7422,0xB422,0xF422,
 0x0822,0x4822,0x8822,0xC822,0x1822,0x5822,0x9822,0xD822,
 0x2822,0x6822,0xA822,0xE822,0x3822,0x7822,0xB822,0xF822,
 0x0C22,0x4C22,0x8C22,0xCC22,0x1C22,0x5C22,0x9C22,0xDC22,
 0x2C22,0x6C22,0xAC22,0xEC22,0x3C22,0x7C22,0xBC22,0xFC22,
 0x0122,0x4122,0x8122,0xC122,0x1122,0x5122,0x9122,0xD122,
 0x2122,0x6122,0xA122,0xE122,0x3122,0x7122,0xB122,0xF122,
 0x0522,0x4522,0x8522,0xC522,0x1522,0x5522,0x9522,0xD522,
 0x2522,0x6522,0xA522,0xE522,0x3522,0x7522,0xB522,0xF522,
 0x0922,0x4922,0x8922,0xC922,0x1922,0x5922,0x9922,0xD922,
 0x2922,0x6922,0xA922,0xE922,0x3922,0x7922,0xB922,0xF922,
 0x0D22,0x4D22,0x8D22,0xCD22,0x1D22,0x5D22,0x9D22,0xDD22,
 0x2D22,0x6D22,0xAD22,0xED22,0x3D22,0x7D22,0xBD22,0xFD22,
 0x0222,0x4222,0x8222,0xC222,0x1222,0x5222,0x9222,0xD222,
 0x2222,0x6222,0xA222,0xE222,0x3222,0x7222,0xB222,0xF222,
 0x0622,0x4622,0x8622,0xC622,0x1622,0x5622,0x9622,0xD622,
 0x2622,0x6622,0xA622,0xE622,0x3622,0x7622,0xB622,0xF622,
 0x0A22,0x4A22,0x8A22,0xCA22,0x1A22,0x5A22,0x9A22,0xDA22,
 0x2A22,0x6A22,0xAA22,0xEA22,0x3A22,0x7A22,0xBA22,0xFA22,
 0x0E22,0x4E22,0x8E22,0xCE22,0x1E22,0x5E22,0x9E22,0xDE22,
 0x2E22,0x6E22,0xAE22,0xEE22,0x3E22,0x7E22,0xBE22,0xFE22,
 0x0322,0x4322,0x8322,0xC322,0x1322,0x5322,0x9322,0xD322,
 0x2322,0x6322,0xA322,0xE322,0x3322,0x7322,0xB322,0xF322,
 0x0722,0x4722,0x8722,0xC722,0x1722,0x5722,0x9722,0xD722,
 0x2722,0x6722,0xA722,0xE722,0x3722,0x7722,0xB722,0xF722,
 0x0B22,0x4B22,0x8B22,0xCB22,0x1B22,0x5B22,0x9B22,0xDB22,
 0x2B22,0x6B22,0xAB22,0xEB22,0x3B22,0x7B22,0xBB22,0xFB22,
 0x0F22,0x4F22,0x8F22,0xCF22,0x1F22,0x5F22,0x9F22,0xDF22,
 0x2F22,0x6F22,0xAF22,0xEF22,0x3F22,0x7F22,0xBF22,0xFF22,
 0x0062,0x4062,0x8062,0xC062,0x1062,0x5062,0x9062,0xD062,
 0x2062,0x6062,0xA062,0xE062,0x3062,0x7062,0xB062,0xF062,
 0x0462,0x4462,0x8462,0xC462,0x1462,0x5462,0x9462,0xD462,
 0x2462,0x6462,0xA462,0xE462,0x3462,0x7462,0xB462,0xF462,
 0x0862,0x4862,0x8862,0xC862,0x1862,0x5862,0x9862,0xD862,
 0x2862,0x6862,0xA862,0xE862,0x3862,0x7862,0xB862,0xF862,
 0x0C62,0x4C62,0x8C62,0xCC62,0x1C62,0x5C62,0x9C62,0xDC62,
 0x2C62,0x6C62,0xAC62,0xEC62,0x3C62,0x7C62,0xBC62,0xFC62,
 0x0162,0x4162,0x8162,0xC162,0x1162,0x5162,0x9162,0xD162,
 0x2162,0x6162,0xA162,0xE162,0x3162,0x7162,0xB162,0xF162,
 0x0562,0x4562,0x8562,0xC562,0x1562,0x5562,0x9562,0xD562,
 0x2562,0x6562,0xA562,0xE562,0x3562,0x7562,0xB562,0xF562,
 0x0962,0x4962,0x8962,0xC962,0x1962,0x5962,0x9962,0xD962,
 0x2962,0x6962,0xA962,0xE962,0x3962,0x7962,0xB962,0xF962,
 0x0D62,0x4D62,0x8D62,0xCD62,0x1D62,0x5D62,0x9D62,0xDD62,
 0x2D62,0x6D62,0xAD62,0xED62,0x3D62,0x7D62,0xBD62,0xFD62,
 0x0262,0x4262,0x8262,0xC262,0x1262,0x5262,0x9262,0xD262,
 0x2262,0x6262,0xA262,0xE262,0x3262,0x7262,0xB262,0xF262,
 0x0662,0x4662,0x8662,0xC662,0x1662,0x5662,0x9662,0xD662,
 0x2662,0x6662,0xA662,0xE662,0x3662,0x7662,0xB662,0xF662,
 0x0A62,0x4A62,0x8A62,0xCA62,0x1A62,0x5A62,0x9A62,0xDA62,
 0x2A62,0x6A62,0xAA62,0xEA62,0x3A62,0x7A62,0xBA62,0xFA62,
 0x0E62,0x4E62,0x8E62,0xCE62,0x1E62,0x5E62,0x9E62,0xDE62,
 0x2E62,0x6E62,0xAE62,0xEE62,0x3E62,0x7E62,0xBE62,0xFE62,
 0x0362,0x4362,0x8362,0xC362,0x1362,0x5362,0x9362,0xD362,
 0x2362,0x6362,0xA362,0xE362,0x3362,0x7362,0xB362,0xF362,
 0x0762,0x4762,0x8762,0xC762,0x1762,0x5762,0x9762,0xD762,
 0x2762,0x6762,0xA762,0xE762,0x3762,0x7762,0xB762,0xF762,
 0x0B62,0x4B62,0x8B62,0xCB62,0x1B62,0x5B62,0x9B62,0xDB62,
 0x2B62,0x6B62,0xAB62,0xEB62,0x3B62,0x7B62,0xBB62,0xFB62,
 0x0F62,0x4F62,0x8F62,0xCF62,0x1F62,0x5F62,0x9F62,0xDF62,
 0x2F62,0x6F62,0xAF62,0xEF62,0x3F62,0x7F62,0xBF62,0xFF62,
 0x00A2,0x40A2,0x80A2,0xC0A2,0x10A2,0x50A2,0x90A2,0xD0A2,
 0x20A2,0x60A2,0xA0A2,0xE0A2,0x30A2,0x70A2,0xB0A2,0xF0A2,
 0x04A2,0x44A2,0x84A2,0xC4A2,0x14A2,0x54A2,0x94A2,0xD4A2,
 0x24A2,0x64A2,0xA4A2,0xE4A2,0x34A2,0x74A2,0xB4A2,0xF4A2,
 0x08A2,0x48A2,0x88A2,0xC8A2,0x18A2,0x58A2,0x98A2,0xD8A2,
 0x28A2,0x68A2,0xA8A2,0xE8A2,0x38A2,0x78A2,0xB8A2,0xF8A2,
 0x0CA2,0x4CA2,0x8CA2,0xCCA2,0x1CA2,0x5CA2,0x9CA2,0xDCA2,
 0x2CA2,0x6CA2,0xACA2,0xECA2,0x3CA2,0x7CA2,0xBCA2,0xFCA2,
 0x01A2,0x41A2,0x81A2,0xC1A2,0x11A2,0x51A2,0x91A2,0xD1A2,
 0x21A2,0x61A2,0xA1A2,0xE1A2,0x31A2,0x71A2,0xB1A2,0xF1A2,
 0x05A2,0x45A2,0x85A2,0xC5A2,0x15A2,0x55A2,0x95A2,0xD5A2,
 0x25A2,0x65A2,0xA5A2,0xE5A2,0x35A2,0x75A2,0xB5A2,0xF5A2,
 0x09A2,0x49A2,0x89A2,0xC9A2,0x19A2,0x59A2,0x99A2,0xD9A2,
 0x29A2,0x69A2,0xA9A2,0xE9A2,0x39A2,0x79A2,0xB9A2,0xF9A2,
 0x0DA2,0x4DA2,0x8DA2,0xCDA2,0x1DA2,0x5DA2,0x9DA2,0xDDA2,
 0x2DA2,0x6DA2,0xADA2,0xEDA2,0x3DA2,0x7DA2,0xBDA2,0xFDA2,
 0x02A2,0x42A2,0x82A2,0xC2A2,0x12A2,0x52A2,0x92A2,0xD2A2,
 0x22A2,0x62A2,0xA2A2,0xE2A2,0x32A2,0x72A2,0xB2A2,0xF2A2,
 0x06A2,0x46A2,0x86A2,0xC6A2,0x16A2,0x56A2,0x96A2,0xD6A2,
 0x26A2,0x66A2,0xA6A2,0xE6A2,0x36A2,0x76A2,0xB6A2,0xF6A2,
 0x0AA2,0x4AA2,0x8AA2,0xCAA2,0x1AA2,0x5AA2,0x9AA2,0xDAA2,
 0x2AA2,0x6AA2,0xAAA2,0xEAA2,0x3AA2,0x7AA2,0xBAA2,0xFAA2,
 0x0EA2,0x4EA2,0x8EA2,0xCEA2,0x1EA2,0x5EA2,0x9EA2,0xDEA2,
 0x2EA2,0x6EA2,0xAEA2,0xEEA2,0x3EA2,0x7EA2,0xBEA2,0xFEA2,
 0x03A2,0x43A2,0x83A2,0xC3A2,0x13A2,0x53A2,0x93A2,0xD3A2,
 0x23A2,0x63A2,0xA3A2,0xE3A2,0x33A2,0x73A2,0xB3A2,0xF3A2,
 0x07A2,0x47A2,0x87A2,0xC7A2,0x17A2,0x57A2,0x97A2,0xD7A2,
 0x27A2,0x67A2,0xA7A2,0xE7A2,0x37A2,0x77A2,0xB7A2,0xF7A2,
 0x0BA2,0x4BA2,0x8BA2,0xCBA2,0x1BA2,0x5BA2,0x9BA2,0xDBA2,
 0x2BA2,0x6BA2,0xABA2,0xEBA2,0x3BA2,0x7BA2,0xBBA2,0xFBA2,
 0x0FA2,0x4FA2,0x8FA2,0xCFA2,0x1FA2,0x5FA2,0x9FA2,0xDFA2,
 0x2FA2,0x6FA2,0xAFA2,0xEFA2,0x3FA2,0x7FA2,0xBFA2,0xFFA2,
 0x00E2,0x40E2,0x80E2,0xC0E2,0x10E2,0x50E2,0x90E2,0xD0E2,
 0x20E2,0x60E2,0xA0E2,0xE0E2,0x30E2,0x70E2,0xB0E2,0xF0E2,
 0x04E2,0x44E2,0x84E2,0xC4E2,0x14E2,0x54E2,0x94E2,0xD4E2,
 0x24E2,0x64E2,0xA4E2,0xE4E2,0x34E2,0x74E2,0xB4E2,0xF4E2,
 0x08E2,0x48E2,0x88E2,0xC8E2,0x18E2,0x58E2,0x98E2,0xD8E2,
 0x28E2,0x68E2,0xA8E2,0xE8E2,0x38E2,0x78E2,0xB8E2,0xF8E2,
 0x0CE2,0x4CE2,0x8CE2,0xCCE2,0x1CE2,0x5CE2,0x9CE2,0xDCE2,
 0x2CE2,0x6CE2,0xACE2,0xECE2,0x3CE2,0x7CE2,0xBCE2,0xFCE2,
 0x01E2,0x41E2,0x81E2,0xC1E2,0x11E2,0x51E2,0x91E2,0xD1E2,
 0x21E2,0x61E2,0xA1E2,0xE1E2,0x31E2,0x71E2,0xB1E2,0xF1E2,
 0x05E2,0x45E2,0x85E2,0xC5E2,0x15E2,0x55E2,0x95E2,0xD5E2,
 0x25E2,0x65E2,0xA5E2,0xE5E2,0x35E2,0x75E2,0xB5E2,0xF5E2,
 0x09E2,0x49E2,0x89E2,0xC9E2,0x19E2,0x59E2,0x99E2,0xD9E2,
 0x29E2,0x69E2,0xA9E2,0xE9E2,0x39E2,0x79E2,0xB9E2,0xF9E2,
 0x0DE2,0x4DE2,0x8DE2,0xCDE2,0x1DE2,0x5DE2,0x9DE2,0xDDE2,
 0x2DE2,0x6DE2,0xADE2,0xEDE2,0x3DE2,0x7DE2,0xBDE2,0xFDE2,
 0x02E2,0x42E2,0x82E2,0xC2E2,0x12E2,0x52E2,0x92E2,0xD2E2,
 0x22E2,0x62E2,0xA2E2,0xE2E2,0x32E2,0x72E2,0xB2E2,0xF2E2,
 0x06E2,0x46E2,0x86E2,0xC6E2,0x16E2,0x56E2,0x96E2,0xD6E2,
 0x26E2,0x66E2,0xA6E2,0xE6E2,0x36E2,0x76E2,0xB6E2,0xF6E2,
 0x0AE2,0x4AE2,0x8AE2,0xCAE2,0x1AE2,0x5AE2,0x9AE2,0xDAE2,
 0x2AE2,0x6AE2,0xAAE2,0xEAE2,0x3AE2,0x7AE2,0xBAE2,0xFAE2,
 0x0EE2,0x4EE2,0x8EE2,0xCEE2,0x1EE2,0x5EE2,0x9EE2,0xDEE2,
 0x2EE2,0x6EE2,0xAEE2,0xEEE2,0x3EE2,0x7EE2,0xBEE2,0xFEE2,
 0x03E2,0x43E2,0x83E2,0xC3E2,0x13E2,0x53E2,0x93E2,0xD3E2,
 0x23E2,0x63E2,0xA3E2,0xE3E2,0x33E2,0x73E2,0xB3E2,0xF3E2,
 0x07E2,0x47E2,0x87E2,0xC7E2,0x17E2,0x57E2,0x97E2,0xD7E2,
 0x27E2,0x67E2,0xA7E2,0xE7E2,0x37E2,0x77E2,0xB7E2,0xF7E2,
 0x0BE2,0x4BE2,0x8BE2,0xCBE2,0x1BE2,0x5BE2,0x9BE2,0xDBE2,
 0x2BE2,0x6BE2,0xABE2,0xEBE2,0x3BE2,0x7BE2,0xBBE2,0xFBE2,
 0x0FE2,0x4FE2,0x8FE2,0xCFE2,0x1FE2,0x5FE2,0x9FE2,0xDFE2,
 0x2FE2,0x6FE2,0xAFE2,0xEFE2,0x3FE2,0x7FE2,0xBFE2,0xFFE2,
 0x0032,0x4032,0x8032,0xC032,0x1032,0x5032,0x9032,0xD032,
 0x2032,0x6032,0xA032,0xE032,0x3032,0x7032,0xB032,0xF032,
 0x0432,0x4432,0x8432,0xC432,0x1432,0x5432,0x9432,0xD432,
 0x2432,0x6432,0xA432,0xE432,0x3432,0x7432,0xB432,0xF432,
 0x0832,0x4832,0x8832,0xC832,0x1832,0x5832,0x9832,0xD832,
 0x2832,0x6832,0xA832,0xE832,0x3832,0x7832,0xB832,0xF832,
 0x0C32,0x4C32,0x8C32,0xCC32,0x1C32,0x5C32,0x9C32,0xDC32,
 0x2C32,0x6C32,0xAC32,0xEC32,0x3C32,0x7C32,0xBC32,0xFC32,
 0x0132,0x4132,0x8132,0xC132,0x1132,0x5132,0x9132,0xD132,
 0x2132,0x6132,0xA132,0xE132,0x3132,0x7132,0xB132,0xF132,
 0x0532,0x4532,0x8532,0xC532,0x1532,0x5532,0x9532,0xD532,
 0x2532,0x6532,0xA532,0xE532,0x3532,0x7532,0xB532,0xF532,
 0x0932,0x4932,0x8932,0xC932,0x1932,0x5932,0x9932,0xD932,
 0x2932,0x6932,0xA932,0xE932,0x3932,0x7932,0xB932,0xF932,
 0x0D32,0x4D32,0x8D32,0xCD32,0x1D32,0x5D32,0x9D32,0xDD32,
 0x2D32,0x6D32,0xAD32,0xED32,0x3D32,0x7D32,0xBD32,0xFD32,
 0x0232,0x4232,0x8232,0xC232,0x1232,0x5232,0x9232,0xD232,
 0x2232,0x6232,0xA232,0xE232,0x3232,0x7232,0xB232,0xF232,
 0x0632,0x4632,0x8632,0xC632,0x1632,0x5632,0x9632,0xD632,
 0x2632,0x6632,0xA632,0xE632,0x3632,0x7632,0xB632,0xF632,
 0x0A32,0x4A32,0x8A32,0xCA32,0x1A32,0x5A32,0x9A32,0xDA32,
 0x2A32,0x6A32,0xAA32,0xEA32,0x3A32,0x7A32,0xBA32,0xFA32,
 0x0E32,0x4E32,0x8E32,0xCE32,0x1E32,0x5E32,0x9E32,0xDE32,
 0x2E32,0x6E32,0xAE32,0xEE32,0x3E32,0x7E32,0xBE32,0xFE32,
 0x0332,0x4332,0x8332,0xC332,0x1332,0x5332,0x9332,0xD332,
 0x2332,0x6332,0xA332,0xE332,0x3332,0x7332,0xB332,0xF332,
 0x0732,0x4732,0x8732,0xC732,0x1732,0x5732,0x9732,0xD732,
 0x2732,0x6732,0xA732,0xE732,0x3732,0x7732,0xB732,0xF732,
 0x0B32,0x4B32,0x8B32,0xCB32,0x1B32,0x5B32,0x9B32,0xDB32,
 0x2B32,0x6B32,0xAB32,0xEB32,0x3B32,0x7B32,0xBB32,0xFB32,
 0x0F32,0x4F32,0x8F32,0xCF32,0x1F32,0x5F32,0x9F32,0xDF32,
 0x2F32,0x6F32,0xAF32,0xEF32,0x3F32,0x7F32,0xBF32,0xFF32,
 0x0072,0x4072,0x8072,0xC072,0x1072,0x5072,0x9072,0xD072,
 0x2072,0x6072,0xA072,0xE072,0x3072,0x7072,0xB072,0xF072,
 0x0472,0x4472,0x8472,0xC472,0x1472,0x5472,0x9472,0xD472,
 0x2472,0x6472,0xA472,0xE472,0x3472,0x7472,0xB472,0xF472,
 0x0872,0x4872,0x8872,0xC872,0x1872,0x5872,0x9872,0xD872,
 0x2872,0x6872,0xA872,0xE872,0x3872,0x7872,0xB872,0xF872,
 0x0C72,0x4C72,0x8C72,0xCC72,0x1C72,0x5C72,0x9C72,0xDC72,
 0x2C72,0x6C72,0xAC72,0xEC72,0x3C72,0x7C72,0xBC72,0xFC72,
 0x0172,0x4172,0x8172,0xC172,0x1172,0x5172,0x9172,0xD172,
 0x2172,0x6172,0xA172,0xE172,0x3172,0x7172,0xB172,0xF172,
 0x0572,0x4572,0x8572,0xC572,0x1572,0x5572,0x9572,0xD572,
 0x2572,0x6572,0xA572,0xE572,0x3572,0x7572,0xB572,0xF572,
 0x0972,0x4972,0x8972,0xC972,0x1972,0x5972,0x9972,0xD972,
 0x2972,0x6972,0xA972,0xE972,0x3972,0x7972,0xB972,0xF972,
 0x0D72,0x4D72,0x8D72,0xCD72,0x1D72,0x5D72,0x9D72,0xDD72,
 0x2D72,0x6D72,0xAD72,0xED72,0x3D72,0x7D72,0xBD72,0xFD72,
 0x0272,0x4272,0x8272,0xC272,0x1272,0x5272,0x9272,0xD272,
 0x2272,0x6272,0xA272,0xE272,0x3272,0x7272,0xB272,0xF272,
 0x0672,0x4672,0x8672,0xC672,0x1672,0x5672,0x9672,0xD672,
 0x2672,0x6672,0xA672,0xE672,0x3672,0x7672,0xB672,0xF672,
 0x0A72,0x4A72,0x8A72,0xCA72,0x1A72,0x5A72,0x9A72,0xDA72,
 0x2A72,0x6A72,0xAA72,0xEA72,0x3A72,0x7A72,0xBA72,0xFA72,
 0x0E72,0x4E72,0x8E72,0xCE72,0x1E72,0x5E72,0x9E72,0xDE72,
 0x2E72,0x6E72,0xAE72,0xEE72,0x3E72,0x7E72,0xBE72,0xFE72,
 0x0372,0x4372,0x8372,0xC372,0x1372,0x5372,0x9372,0xD372,
 0x2372,0x6372,0xA372,0xE372,0x3372,0x7372,0xB372,0xF372,
 0x0772,0x4772,0x8772,0xC772,0x1772,0x5772,0x9772,0xD772,
 0x2772,0x6772,0xA772,0xE772,0x3772,0x7772,0xB772,0xF772,
 0x0B72,0x4B72,0x8B72,0xCB72,0x1B72,0x5B72,0x9B72,0xDB72,
 0x2B72,0x6B72,0xAB72,0xEB72,0x3B72,0x7B72,0xBB72,0xFB72,
 0x0F72,0x4F72,0x8F72,0xCF72,0x1F72,0x5F72,0x9F72,0xDF72,
 0x2F72,0x6F72,0xAF72,0xEF72,0x3F72,0x7F72,0xBF72,0xFF72,
 0x00B2,0x40B2,0x80B2,0xC0B2,0x10B2,0x50B2,0x90B2,0xD0B2,
 0x20B2,0x60B2,0xA0B2,0xE0B2,0x30B2,0x70B2,0xB0B2,0xF0B2,
 0x04B2,0x44B2,0x84B2,0xC4B2,0x14B2,0x54B2,0x94B2,0xD4B2,
 0x24B2,0x64B2,0xA4B2,0xE4B2,0x34B2,0x74B2,0xB4B2,0xF4B2,
 0x08B2,0x48B2,0x88B2,0xC8B2,0x18B2,0x58B2,0x98B2,0xD8B2,
 0x28B2,0x68B2,0xA8B2,0xE8B2,0x38B2,0x78B2,0xB8B2,0xF8B2,
 0x0CB2,0x4CB2,0x8CB2,0xCCB2,0x1CB2,0x5CB2,0x9CB2,0xDCB2,
 0x2CB2,0x6CB2,0xACB2,0xECB2,0x3CB2,0x7CB2,0xBCB2,0xFCB2,
 0x01B2,0x41B2,0x81B2,0xC1B2,0x11B2,0x51B2,0x91B2,0xD1B2,
 0x21B2,0x61B2,0xA1B2,0xE1B2,0x31B2,0x71B2,0xB1B2,0xF1B2,
 0x05B2,0x45B2,0x85B2,0xC5B2,0x15B2,0x55B2,0x95B2,0xD5B2,
 0x25B2,0x65B2,0xA5B2,0xE5B2,0x35B2,0x75B2,0xB5B2,0xF5B2,
 0x09B2,0x49B2,0x89B2,0xC9B2,0x19B2,0x59B2,0x99B2,0xD9B2,
 0x29B2,0x69B2,0xA9B2,0xE9B2,0x39B2,0x79B2,0xB9B2,0xF9B2,
 0x0DB2,0x4DB2,0x8DB2,0xCDB2,0x1DB2,0x5DB2,0x9DB2,0xDDB2,
 0x2DB2,0x6DB2,0xADB2,0xEDB2,0x3DB2,0x7DB2,0xBDB2,0xFDB2,
 0x02B2,0x42B2,0x82B2,0xC2B2,0x12B2,0x52B2,0x92B2,0xD2B2,
 0x22B2,0x62B2,0xA2B2,0xE2B2,0x32B2,0x72B2,0xB2B2,0xF2B2,
 0x06B2,0x46B2,0x86B2,0xC6B2,0x16B2,0x56B2,0x96B2,0xD6B2,
 0x26B2,0x66B2,0xA6B2,0xE6B2,0x36B2,0x76B2,0xB6B2,0xF6B2,
 0x0AB2,0x4AB2,0x8AB2,0xCAB2,0x1AB2,0x5AB2,0x9AB2,0xDAB2,
 0x2AB2,0x6AB2,0xAAB2,0xEAB2,0x3AB2,0x7AB2,0xBAB2,0xFAB2,
 0x0EB2,0x4EB2,0x8EB2,0xCEB2,0x1EB2,0x5EB2,0x9EB2,0xDEB2,
 0x2EB2,0x6EB2,0xAEB2,0xEEB2,0x3EB2,0x7EB2,0xBEB2,0xFEB2,
 0x03B2,0x43B2,0x83B2,0xC3B2,0x13B2,0x53B2,0x93B2,0xD3B2,
 0x23B2,0x63B2,0xA3B2,0xE3B2,0x33B2,0x73B2,0xB3B2,0xF3B2,
 0x07B2,0x47B2,0x87B2,0xC7B2,0x17B2,0x57B2,0x97B2,0xD7B2,
 0x27B2,0x67B2,0xA7B2,0xE7B2,0x37B2,0x77B2,0xB7B2,0xF7B2,
 0x0BB2,0x4BB2,0x8BB2,0xCBB2,0x1BB2,0x5BB2,0x9BB2,0xDBB2,
 0x2BB2,0x6BB2,0xABB2,0xEBB2,0x3BB2,0x7BB2,0xBBB2,0xFBB2,
 0x0FB2,0x4FB2,0x8FB2,0xCFB2,0x1FB2,0x5FB2,0x9FB2,0xDFB2,
 0x2FB2,0x6FB2,0xAFB2,0xEFB2,0x3FB2,0x7FB2,0xBFB2,0xFFB2,
 0x00F2,0x40F2,0x80F2,0xC0F2,0x10F2,0x50F2,0x90F2,0xD0F2,
 0x20F2,0x60F2,0xA0F2,0xE0F2,0x30F2,0x70F2,0xB0F2,0xF0F2,
 0x04F2,0x44F2,0x84F2,0xC4F2,0x14F2,0x54F2,0x94F2,0xD4F2,
 0x24F2,0x64F2,0xA4F2,0xE4F2,0x34F2,0x74F2,0xB4F2,0xF4F2,
 0x08F2,0x48F2,0x88F2,0xC8F2,0x18F2,0x58F2,0x98F2,0xD8F2,
 0x28F2,0x68F2,0xA8F2,0xE8F2,0x38F2,0x78F2,0xB8F2,0xF8F2,
 0x0CF2,0x4CF2,0x8CF2,0xCCF2,0x1CF2,0x5CF2,0x9CF2,0xDCF2,
 0x2CF2,0x6CF2,0xACF2,0xECF2,0x3CF2,0x7CF2,0xBCF2,0xFCF2,
 0x01F2,0x41F2,0x81F2,0xC1F2,0x11F2,0x51F2,0x91F2,0xD1F2,
 0x21F2,0x61F2,0xA1F2,0xE1F2,0x31F2,0x71F2,0xB1F2,0xF1F2,
 0x05F2,0x45F2,0x85F2,0xC5F2,0x15F2,0x55F2,0x95F2,0xD5F2,
 0x25F2,0x65F2,0xA5F2,0xE5F2,0x35F2,0x75F2,0xB5F2,0xF5F2,
 0x09F2,0x49F2,0x89F2,0xC9F2,0x19F2,0x59F2,0x99F2,0xD9F2,
 0x29F2,0x69F2,0xA9F2,0xE9F2,0x39F2,0x79F2,0xB9F2,0xF9F2,
 0x0DF2,0x4DF2,0x8DF2,0xCDF2,0x1DF2,0x5DF2,0x9DF2,0xDDF2,
 0x2DF2,0x6DF2,0xADF2,0xEDF2,0x3DF2,0x7DF2,0xBDF2,0xFDF2,
 0x02F2,0x42F2,0x82F2,0xC2F2,0x12F2,0x52F2,0x92F2,0xD2F2,
 0x22F2,0x62F2,0xA2F2,0xE2F2,0x32F2,0x72F2,0xB2F2,0xF2F2,
 0x06F2,0x46F2,0x86F2,0xC6F2,0x16F2,0x56F2,0x96F2,0xD6F2,
 0x26F2,0x66F2,0xA6F2,0xE6F2,0x36F2,0x76F2,0xB6F2,0xF6F2,
 0x0AF2,0x4AF2,0x8AF2,0xCAF2,0x1AF2,0x5AF2,0x9AF2,0xDAF2,
 0x2AF2,0x6AF2,0xAAF2,0xEAF2,0x3AF2,0x7AF2,0xBAF2,0xFAF2,
 0x0EF2,0x4EF2,0x8EF2,0xCEF2,0x1EF2,0x5EF2,0x9EF2,0xDEF2,
 0x2EF2,0x6EF2,0xAEF2,0xEEF2,0x3EF2,0x7EF2,0xBEF2,0xFEF2,
 0x03F2,0x43F2,0x83F2,0xC3F2,0x13F2,0x53F2,0x93F2,0xD3F2,
 0x23F2,0x63F2,0xA3F2,0xE3F2,0x33F2,0x73F2,0xB3F2,0xF3F2,
 0x07F2,0x47F2,0x87F2,0xC7F2,0x17F2,0x57F2,0x97F2,0xD7F2,
 0x27F2,0x67F2,0xA7F2,0xE7F2,0x37F2,0x77F2,0xB7F2,0xF7F2,
 0x0BF2,0x4BF2,0x8BF2,0xCBF2,0x1BF2,0x5BF2,0x9BF2,0xDBF2,
 0x2BF2,0x6BF2,0xABF2,0xEBF2,0x3BF2,0x7BF2,0xBBF2,0xFBF2,
 0x0FF2,0x4FF2,0x8FF2,0xCFF2,0x1FF2,0x5FF2,0x9FF2,0xDFF2,
 0x2FF2,0x6FF2,0xAFF2,0xEFF2,0x3FF2,0x7FF2,0xBFF2,0xFFF2,
 0x0006,0x4006,0x8006,0xC006,0x1006,0x5006,0x9006,0xD006,
 0x2006,0x6006,0xA006,0xE006,0x3006,0x7006,0xB006,0xF006,
 0x0406,0x4406,0x8406,0xC406,0x1406,0x5406,0x9406,0xD406,
 0x2406,0x6406,0xA406,0xE406,0x3406,0x7406,0xB406,0xF406,
 0x0806,0x4806,0x8806,0xC806,0x1806,0x5806,0x9806,0xD806,
 0x2806,0x6806,0xA806,0xE806,0x3806,0x7806,0xB806,0xF806,
 0x0C06,0x4C06,0x8C06,0xCC06,0x1C06,0x5C06,0x9C06,0xDC06,
 0x2C06,0x6C06,0xAC06,0xEC06,0x3C06,0x7C06,0xBC06,0xFC06,
 0x0106,0x4106,0x8106,0xC106,0x1106,0x5106,0x9106,0xD106,
 0x2106,0x6106,0xA106,0xE106,0x3106,0x7106,0xB106,0xF106,
 0x0506,0x4506,0x8506,0xC506,0x1506,0x5506,0x9506,0xD506,
 0x2506,0x6506,0xA506,0xE506,0x3506,0x7506,0xB506,0xF506,
 0x0906,0x4906,0x8906,0xC906,0x1906,0x5906,0x9906,0xD906,
 0x2906,0x6906,0xA906,0xE906,0x3906,0x7906,0xB906,0xF906,
 0x0D06,0x4D06,0x8D06,0xCD06,0x1D06,0x5D06,0x9D06,0xDD06,
 0x2D06,0x6D06,0xAD06,0xED06,0x3D06,0x7D06,0xBD06,0xFD06,
 0x0206,0x4206,0x8206,0xC206,0x1206,0x5206,0x9206,0xD206,
 0x2206,0x6206,0xA206,0xE206,0x3206,0x7206,0xB206,0xF206,
 0x0606,0x4606,0x8606,0xC606,0x1606,0x5606,0x9606,0xD606,
 0x2606,0x6606,0xA606,0xE606,0x3606,0x7606,0xB606,0xF606,
 0x0A06,0x4A06,0x8A06,0xCA06,0x1A06,0x5A06,0x9A06,0xDA06,
 0x2A06,0x6A06,0xAA06,0xEA06,0x3A06,0x7A06,0xBA06,0xFA06,
 0x0E06,0x4E06,0x8E06,0xCE06,0x1E06,0x5E06,0x9E06,0xDE06,
 0x2E06,0x6E06,0xAE06,0xEE06,0x3E06,0x7E06,0xBE06,0xFE06,
 0x0306,0x4306,0x8306,0xC306,0x1306,0x5306,0x9306,0xD306,
 0x2306,0x6306,0xA306,0xE306,0x3306,0x7306,0xB306,0xF306,
 0x0706,0x4706,0x8706,0xC706,0x1706,0x5706,0x9706,0xD706,
 0x2706,0x6706,0xA706,0xE706,0x3706,0x7706,0xB706,0xF706,
 0x0B06,0x4B06,0x8B06,0xCB06,0x1B06,0x5B06,0x9B06,0xDB06,
 0x2B06,0x6B06,0xAB06,0xEB06,0x3B06,0x7B06,0xBB06,0xFB06,
 0x0F06,0x4F06,0x8F06,0xCF06,0x1F06,0x5F06,0x9F06,0xDF06,
 0x2F06,0x6F06,0xAF06,0xEF06,0x3F06,0x7F06,0xBF06,0xFF06,
 0x0046,0x4046,0x8046,0xC046,0x1046,0x5046,0x9046,0xD046,
 0x2046,0x6046,0xA046,0xE046,0x3046,0x7046,0xB046,0xF046,
 0x0446,0x4446,0x8446,0xC446,0x1446,0x5446,0x9446,0xD446,
 0x2446,0x6446,0xA446,0xE446,0x3446,0x7446,0xB446,0xF446,
 0x0846,0x4846,0x8846,0xC846,0x1846,0x5846,0x9846,0xD846,
 0x2846,0x6846,0xA846,0xE846,0x3846,0x7846,0xB846,0xF846,
 0x0C46,0x4C46,0x8C46,0xCC46,0x1C46,0x5C46,0x9C46,0xDC46,
 0x2C46,0x6C46,0xAC46,0xEC46,0x3C46,0x7C46,0xBC46,0xFC46,
 0x0146,0x4146,0x8146,0xC146,0x1146,0x5146,0x9146,0xD146,
 0x2146,0x6146,0xA146,0xE146,0x3146,0x7146,0xB146,0xF146,
 0x0546,0x4546,0x8546,0xC546,0x1546,0x5546,0x9546,0xD546,
 0x2546,0x6546,0xA546,0xE546,0x3546,0x7546,0xB546,0xF546,
 0x0946,0x4946,0x8946,0xC946,0x1946,0x5946,0x9946,0xD946,
 0x2946,0x6946,0xA946,0xE946,0x3946,0x7946,0xB946,0xF946,
 0x0D46,0x4D46,0x8D46,0xCD46,0x1D46,0x5D46,0x9D46,0xDD46,
 0x2D46,0x6D46,0xAD46,0xED46,0x3D46,0x7D46,0xBD46,0xFD46,
 0x0246,0x4246,0x8246,0xC246,0x1246,0x5246,0x9246,0xD246,
 0x2246,0x6246,0xA246,0xE246,0x3246,0x7246,0xB246,0xF246,
 0x0646,0x4646,0x8646,0xC646,0x1646,0x5646,0x9646,0xD646,
 0x2646,0x6646,0xA646,0xE646,0x3646,0x7646,0xB646,0xF646,
 0x0A46,0x4A46,0x8A46,0xCA46,0x1A46,0x5A46,0x9A46,0xDA46,
 0x2A46,0x6A46,0xAA46,0xEA46,0x3A46,0x7A46,0xBA46,0xFA46,
 0x0E46,0x4E46,0x8E46,0xCE46,0x1E46,0x5E46,0x9E46,0xDE46,
 0x2E46,0x6E46,0xAE46,0xEE46,0x3E46,0x7E46,0xBE46,0xFE46,
 0x0346,0x4346,0x8346,0xC346,0x1346,0x5346,0x9346,0xD346,
 0x2346,0x6346,0xA346,0xE346,0x3346,0x7346,0xB346,0xF346,
 0x0746,0x4746,0x8746,0xC746,0x1746,0x5746,0x9746,0xD746,
 0x2746,0x6746,0xA746,0xE746,0x3746,0x7746,0xB746,0xF746,
 0x0B46,0x4B46,0x8B46,0xCB46,0x1B46,0x5B46,0x9B46,0xDB46,
 0x2B46,0x6B46,0xAB46,0xEB46,0x3B46,0x7B46,0xBB46,0xFB46,
 0x0F46,0x4F46,0x8F46,0xCF46,0x1F46,0x5F46,0x9F46,0xDF46,
 0x2F46,0x6F46,0xAF46,0xEF46,0x3F46,0x7F46,0xBF46,0xFF46,
 0x0086,0x4086,0x8086,0xC086,0x1086,0x5086,0x9086,0xD086,
 0x2086,0x6086,0xA086,0xE086,0x3086,0x7086,0xB086,0xF086,
 0x0486,0x4486,0x8486,0xC486,0x1486,0x5486,0x9486,0xD486,
 0x2486,0x6486,0xA486,0xE486,0x3486,0x7486,0xB486,0xF486,
 0x0886,0x4886,0x8886,0xC886,0x1886,0x5886,0x9886,0xD886,
 0x2886,0x6886,0xA886,0xE886,0x3886,0x7886,0xB886,0xF886,
 0x0C86,0x4C86,0x8C86,0xCC86,0x1C86,0x5C86,0x9C86,0xDC86,
 0x2C86,0x6C86,0xAC86,0xEC86,0x3C86,0x7C86,0xBC86,0xFC86,
 0x0186,0x4186,0x8186,0xC186,0x1186,0x5186,0x9186,0xD186,
 0x2186,0x6186,0xA186,0xE186,0x3186,0x7186,0xB186,0xF186,
 0x0586,0x4586,0x8586,0xC586,0x1586,0x5586,0x9586,0xD586,
 0x2586,0x6586,0xA586,0xE586,0x3586,0x7586,0xB586,0xF586,
 0x0986,0x4986,0x8986,0xC986,0x1986,0x5986,0x9986,0xD986,
 0x2986,0x6986,0xA986,0xE986,0x3986,0x7986,0xB986,0xF986,
 0x0D86,0x4D86,0x8D86,0xCD86,0x1D86,0x5D86,0x9D86,0xDD86,
 0x2D86,0x6D86,0xAD86,0xED86,0x3D86,0x7D86,0xBD86,0xFD86,
 0x0286,0x4286,0x8286,0xC286,0x1286,0x5286,0x9286,0xD286,
 0x2286,0x6286,0xA286,0xE286,0x3286,0x7286,0xB286,0xF286,
 0x0686,0x4686,0x8686,0xC686,0x1686,0x5686,0x9686,0xD686,
 0x2686,0x6686,0xA686,0xE686,0x3686,0x7686,0xB686,0xF686,
 0x0A86,0x4A86,0x8A86,0xCA86,0x1A86,0x5A86,0x9A86,0xDA86,
 0x2A86,0x6A86,0xAA86,0xEA86,0x3A86,0x7A86,0xBA86,0xFA86,
 0x0E86,0x4E86,0x8E86,0xCE86,0x1E86,0x5E86,0x9E86,0xDE86,
 0x2E86,0x6E86,0xAE86,0xEE86,0x3E86,0x7E86,0xBE86,0xFE86,
 0x0386,0x4386,0x8386,0xC386,0x1386,0x5386,0x9386,0xD386,
 0x2386,0x6386,0xA386,0xE386,0x3386,0x7386,0xB386,0xF386,
 0x0786,0x4786,0x8786,0xC786,0x1786,0x5786,0x9786,0xD786,
 0x2786,0x6786,0xA786,0xE786,0x3786,0x7786,0xB786,0xF786,
 0x0B86,0x4B86,0x8B86,0xCB86,0x1B86,0x5B86,0x9B86,0xDB86,
 0x2B86,0x6B86,0xAB86,0xEB86,0x3B86,0x7B86,0xBB86,0xFB86,
 0x0F86,0x4F86,0x8F86,0xCF86,0x1F86,0x5F86,0x9F86,0xDF86,
 0x2F86,0x6F86,0xAF86,0xEF86,0x3F86,0x7F86,0xBF86,0xFF86,
 0x00C6,0x40C6,0x80C6,0xC0C6,0x10C6,0x50C6,0x90C6,0xD0C6,
 0x20C6,0x60C6,0xA0C6,0xE0C6,0x30C6,0x70C6,0xB0C6,0xF0C6,
 0x04C6,0x44C6,0x84C6,0xC4C6,0x14C6,0x54C6,0x94C6,0xD4C6,
 0x24C6,0x64C6,0xA4C6,0xE4C6,0x34C6,0x74C6,0xB4C6,0xF4C6,
 0x08C6,0x48C6,0x88C6,0xC8C6,0x18C6,0x58C6,0x98C6,0xD8C6,
 0x28C6,0x68C6,0xA8C6,0xE8C6,0x38C6,0x78C6,0xB8C6,0xF8C6,
 0x0CC6,0x4CC6,0x8CC6,0xCCC6,0x1CC6,0x5CC6,0x9CC6,0xDCC6,
 0x2CC6,0x6CC6,0xACC6,0xECC6,0x3CC6,0x7CC6,0xBCC6,0xFCC6,
 0x01C6,0x41C6,0x81C6,0xC1C6,0x11C6,0x51C6,0x91C6,0xD1C6,
 0x21C6,0x61C6,0xA1C6,0xE1C6,0x31C6,0x71C6,0xB1C6,0xF1C6,
 0x05C6,0x45C6,0x85C6,0xC5C6,0x15C6,0x55C6,0x95C6,0xD5C6,
 0x25C6,0x65C6,0xA5C6,0xE5C6,0x35C6,0x75C6,0xB5C6,0xF5C6,
 0x09C6,0x49C6,0x89C6,0xC9C6,0x19C6,0x59C6,0x99C6,0xD9C6,
 0x29C6,0x69C6,0xA9C6,0xE9C6,0x39C6,0x79C6,0xB9C6,0xF9C6,
 0x0DC6,0x4DC6,0x8DC6,0xCDC6,0x1DC6,0x5DC6,0x9DC6,0xDDC6,
 0x2DC6,0x6DC6,0xADC6,0xEDC6,0x3DC6,0x7DC6,0xBDC6,0xFDC6,
 0x02C6,0x42C6,0x82C6,0xC2C6,0x12C6,0x52C6,0x92C6,0xD2C6,
 0x22C6,0x62C6,0xA2C6,0xE2C6,0x32C6,0x72C6,0xB2C6,0xF2C6,
 0x06C6,0x46C6,0x86C6,0xC6C6,0x16C6,0x56C6,0x96C6,0xD6C6,
 0x26C6,0x66C6,0xA6C6,0xE6C6,0x36C6,0x76C6,0xB6C6,0xF6C6,
 0x0AC6,0x4AC6,0x8AC6,0xCAC6,0x1AC6,0x5AC6,0x9AC6,0xDAC6,
 0x2AC6,0x6AC6,0xAAC6,0xEAC6,0x3AC6,0x7AC6,0xBAC6,0xFAC6,
 0x0EC6,0x4EC6,0x8EC6,0xCEC6,0x1EC6,0x5EC6,0x9EC6,0xDEC6,
 0x2EC6,0x6EC6,0xAEC6,0xEEC6,0x3EC6,0x7EC6,0xBEC6,0xFEC6,
 0x03C6,0x43C6,0x83C6,0xC3C6,0x13C6,0x53C6,0x93C6,0xD3C6,
 0x23C6,0x63C6,0xA3C6,0xE3C6,0x33C6,0x73C6,0xB3C6,0xF3C6,
 0x07C6,0x47C6,0x87C6,0xC7C6,0x17C6,0x57C6,0x97C6,0xD7C6,
 0x27C6,0x67C6,0xA7C6,0xE7C6,0x37C6,0x77C6,0xB7C6,0xF7C6,
 0x0BC6,0x4BC6,0x8BC6,0xCBC6,0x1BC6,0x5BC6,0x9BC6,0xDBC6,
 0x2BC6,0x6BC6,0xABC6,0xEBC6,0x3BC6,0x7BC6,0xBBC6,0xFBC6,
 0x0FC6,0x4FC6,0x8FC6,0xCFC6,0x1FC6,0x5FC6,0x9FC6,0xDFC6,
 0x2FC6,0x6FC6,0xAFC6,0xEFC6,0x3FC6,0x7FC6,0xBFC6,0xFFC6,
 0x0016,0x4016,0x8016,0xC016,0x1016,0x5016,0x9016,0xD016,
 0x2016,0x6016,0xA016,0xE016,0x3016,0x7016,0xB016,0xF016,
 0x0416,0x4416,0x8416,0xC416,0x1416,0x5416,0x9416,0xD416,
 0x2416,0x6416,0xA416,0xE416,0x3416,0x7416,0xB416,0xF416,
 0x0816,0x4816,0x8816,0xC816,0x1816,0x5816,0x9816,0xD816,
 0x2816,0x6816,0xA816,0xE816,0x3816,0x7816,0xB816,0xF816,
 0x0C16,0x4C16,0x8C16,0xCC16,0x1C16,0x5C16,0x9C16,0xDC16,
 0x2C16,0x6C16,0xAC16,0xEC16,0x3C16,0x7C16,0xBC16,0xFC16,
 0x0116,0x4116,0x8116,0xC116,0x1116,0x5116,0x9116,0xD116,
 0x2116,0x6116,0xA116,0xE116,0x3116,0x7116,0xB116,0xF116,
 0x0516,0x4516,0x8516,0xC516,0x1516,0x5516,0x9516,0xD516,
 0x2516,0x6516,0xA516,0xE516,0x3516,0x7516,0xB516,0xF516,
 0x0916,0x4916,0x8916,0xC916,0x1916,0x5916,0x9916,0xD916,
 0x2916,0x6916,0xA916,0xE916,0x3916,0x7916,0xB916,0xF916,
 0x0D16,0x4D16,0x8D16,0xCD16,0x1D16,0x5D16,0x9D16,0xDD16,
 0x2D16,0x6D16,0xAD16,0xED16,0x3D16,0x7D16,0xBD16,0xFD16,
 0x0216,0x4216,0x8216,0xC216,0x1216,0x5216,0x9216,0xD216,
 0x2216,0x6216,0xA216,0xE216,0x3216,0x7216,0xB216,0xF216,
 0x0616,0x4616,0x8616,0xC616,0x1616,0x5616,0x9616,0xD616,
 0x2616,0x6616,0xA616,0xE616,0x3616,0x7616,0xB616,0xF616,
 0x0A16,0x4A16,0x8A16,0xCA16,0x1A16,0x5A16,0x9A16,0xDA16,
 0x2A16,0x6A16,0xAA16,0xEA16,0x3A16,0x7A16,0xBA16,0xFA16,
 0x0E16,0x4E16,0x8E16,0xCE16,0x1E16,0x5E16,0x9E16,0xDE16,
 0x2E16,0x6E16,0xAE16,0xEE16,0x3E16,0x7E16,0xBE16,0xFE16,
 0x0316,0x4316,0x8316,0xC316,0x1316,0x5316,0x9316,0xD316,
 0x2316,0x6316,0xA316,0xE316,0x3316,0x7316,0xB316,0xF316,
 0x0716,0x4716,0x8716,0xC716,0x1716,0x5716,0x9716,0xD716,
 0x2716,0x6716,0xA716,0xE716,0x3716,0x7716,0xB716,0xF716,
 0x0B16,0x4B16,0x8B16,0xCB16,0x1B16,0x5B16,0x9B16,0xDB16,
 0x2B16,0x6B16,0xAB16,0xEB16,0x3B16,0x7B16,0xBB16,0xFB16,
 0x0F16,0x4F16,0x8F16,0xCF16,0x1F16,0x5F16,0x9F16,0xDF16,
 0x2F16,0x6F16,0xAF16,0xEF16,0x3F16,0x7F16,0xBF16,0xFF16,
 0x0056,0x4056,0x8056,0xC056,0x1056,0x5056,0x9056,0xD056,
 0x2056,0x6056,0xA056,0xE056,0x3056,0x7056,0xB056,0xF056,
 0x0456,0x4456,0x8456,0xC456,0x1456,0x5456,0x9456,0xD456,
 0x2456,0x6456,0xA456,0xE456,0x3456,0x7456,0xB456,0xF456,
 0x0856,0x4856,0x8856,0xC856,0x1856,0x5856,0x9856,0xD856,
 0x2856,0x6856,0xA856,0xE856,0x3856,0x7856,0xB856,0xF856,
 0x0C56,0x4C56,0x8C56,0xCC56,0x1C56,0x5C56,0x9C56,0xDC56,
 0x2C56,0x6C56,0xAC56,0xEC56,0x3C56,0x7C56,0xBC56,0xFC56,
 0x0156,0x4156,0x8156,0xC156,0x1156,0x5156,0x9156,0xD156,
 0x2156,0x6156,0xA156,0xE156,0x3156,0x7156,0xB156,0xF156,
 0x0556,0x4556,0x8556,0xC556,0x1556,0x5556,0x9556,0xD556,
 0x2556,0x6556,0xA556,0xE556,0x3556,0x7556,0xB556,0xF556,
 0x0956,0x4956,0x8956,0xC956,0x1956,0x5956,0x9956,0xD956,
 0x2956,0x6956,0xA956,0xE956,0x3956,0x7956,0xB956,0xF956,
 0x0D56,0x4D56,0x8D56,0xCD56,0x1D56,0x5D56,0x9D56,0xDD56,
 0x2D56,0x6D56,0xAD56,0xED56,0x3D56,0x7D56,0xBD56,0xFD56,
 0x0256,0x4256,0x8256,0xC256,0x1256,0x5256,0x9256,0xD256,
 0x2256,0x6256,0xA256,0xE256,0x3256,0x7256,0xB256,0xF256,
 0x0656,0x4656,0x8656,0xC656,0x1656,0x5656,0x9656,0xD656,
 0x2656,0x6656,0xA656,0xE656,0x3656,0x7656,0xB656,0xF656,
 0x0A56,0x4A56,0x8A56,0xCA56,0x1A56,0x5A56,0x9A56,0xDA56,
 0x2A56,0x6A56,0xAA56,0xEA56,0x3A56,0x7A56,0xBA56,0xFA56,
 0x0E56,0x4E56,0x8E56,0xCE56,0x1E56,0x5E56,0x9E56,0xDE56,
 0x2E56,0x6E56,0xAE56,0xEE56,0x3E56,0x7E56,0xBE56,0xFE56,
 0x0356,0x4356,0x8356,0xC356,0x1356,0x5356,0x9356,0xD356,
 0x2356,0x6356,0xA356,0xE356,0x3356,0x7356,0xB356,0xF356,
 0x0756,0x4756,0x8756,0xC756,0x1756,0x5756,0x9756,0xD756,
 0x2756,0x6756,0xA756,0xE756,0x3756,0x7756,0xB756,0xF756,
 0x0B56,0x4B56,0x8B56,0xCB56,0x1B56,0x5B56,0x9B56,0xDB56,
 0x2B56,0x6B56,0xAB56,0xEB56,0x3B56,0x7B56,0xBB56,0xFB56,
 0x0F56,0x4F56,0x8F56,0xCF56,0x1F56,0x5F56,0x9F56,0xDF56,
 0x2F56,0x6F56,0xAF56,0xEF56,0x3F56,0x7F56,0xBF56,0xFF56,
 0x0096,0x4096,0x8096,0xC096,0x1096,0x5096,0x9096,0xD096,
 0x2096,0x6096,0xA096,0xE096,0x3096,0x7096,0xB096,0xF096,
 0x0496,0x4496,0x8496,0xC496,0x1496,0x5496,0x9496,0xD496,
 0x2496,0x6496,0xA496,0xE496,0x3496,0x7496,0xB496,0xF496,
 0x0896,0x4896,0x8896,0xC896,0x1896,0x5896,0x9896,0xD896,
 0x2896,0x6896,0xA896,0xE896,0x3896,0x7896,0xB896,0xF896,
 0x0C96,0x4C96,0x8C96,0xCC96,0x1C96,0x5C96,0x9C96,0xDC96,
 0x2C96,0x6C96,0xAC96,0xEC96,0x3C96,0x7C96,0xBC96,0xFC96,
 0x0196,0x4196,0x8196,0xC196,0x1196,0x5196,0x9196,0xD196,
 0x2196,0x6196,0xA196,0xE196,0x3196,0x7196,0xB196,0xF196,
 0x0596,0x4596,0x8596,0xC596,0x1596,0x5596,0x9596,0xD596,
 0x2596,0x6596,0xA596,0xE596,0x3596,0x7596,0xB596,0xF596,
 0x0996,0x4996,0x8996,0xC996,0x1996,0x5996,0x9996,0xD996,
 0x2996,0x6996,0xA996,0xE996,0x3996,0x7996,0xB996,0xF996,
 0x0D96,0x4D96,0x8D96,0xCD96,0x1D96,0x5D96,0x9D96,0xDD96,
 0x2D96,0x6D96,0xAD96,0xED96,0x3D96,0x7D96,0xBD96,0xFD96,
 0x0296,0x4296,0x8296,0xC296,0x1296,0x5296,0x9296,0xD296,
 0x2296,0x6296,0xA296,0xE296,0x3296,0x7296,0xB296,0xF296,
 0x0696,0x4696,0x8696,0xC696,0x1696,0x5696,0x9696,0xD696,
 0x2696,0x6696,0xA696,0xE696,0x3696,0x7696,0xB696,0xF696,
 0x0A96,0x4A96,0x8A96,0xCA96,0x1A96,0x5A96,0x9A96,0xDA96,
 0x2A96,0x6A96,0xAA96,0xEA96,0x3A96,0x7A96,0xBA96,0xFA96,
 0x0E96,0x4E96,0x8E96,0xCE96,0x1E96,0x5E96,0x9E96,0xDE96,
 0x2E96,0x6E96,0xAE96,0xEE96,0x3E96,0x7E96,0xBE96,0xFE96,
 0x0396,0x4396,0x8396,0xC396,0x1396,0x5396,0x9396,0xD396,
 0x2396,0x6396,0xA396,0xE396,0x3396,0x7396,0xB396,0xF396,
 0x0796,0x4796,0x8796,0xC796,0x1796,0x5796,0x9796,0xD796,
 0x2796,0x6796,0xA796,0xE796,0x3796,0x7796,0xB796,0xF796,
 0x0B96,0x4B96,0x8B96,0xCB96,0x1B96,0x5B96,0x9B96,0xDB96,
 0x2B96,0x6B96,0xAB96,0xEB96,0x3B96,0x7B96,0xBB96,0xFB96,
 0x0F96,0x4F96,0x8F96,0xCF96,0x1F96,0x5F96,0x9F96,0xDF96,
 0x2F96,0x6F96,0xAF96,0xEF96,0x3F96,0x7F96,0xBF96,0xFF96,
 0x00D6,0x40D6,0x80D6,0xC0D6,0x10D6,0x50D6,0x90D6,0xD0D6,
 0x20D6,0x60D6,0xA0D6,0xE0D6,0x30D6,0x70D6,0xB0D6,0xF0D6,
 0x04D6,0x44D6,0x84D6,0xC4D6,0x14D6,0x54D6,0x94D6,0xD4D6,
 0x24D6,0x64D6,0xA4D6,0xE4D6,0x34D6,0x74D6,0xB4D6,0xF4D6,
 0x08D6,0x48D6,0x88D6,0xC8D6,0x18D6,0x58D6,0x98D6,0xD8D6,
 0x28D6,0x68D6,0xA8D6,0xE8D6,0x38D6,0x78D6,0xB8D6,0xF8D6,
 0x0CD6,0x4CD6,0x8CD6,0xCCD6,0x1CD6,0x5CD6,0x9CD6,0xDCD6,
 0x2CD6,0x6CD6,0xACD6,0xECD6,0x3CD6,0x7CD6,0xBCD6,0xFCD6,
 0x01D6,0x41D6,0x81D6,0xC1D6,0x11D6,0x51D6,0x91D6,0xD1D6,
 0x21D6,0x61D6,0xA1D6,0xE1D6,0x31D6,0x71D6,0xB1D6,0xF1D6,
 0x05D6,0x45D6,0x85D6,0xC5D6,0x15D6,0x55D6,0x95D6,0xD5D6,
 0x25D6,0x65D6,0xA5D6,0xE5D6,0x35D6,0x75D6,0xB5D6,0xF5D6,
 0x09D6,0x49D6,0x89D6,0xC9D6,0x19D6,0x59D6,0x99D6,0xD9D6,
 0x29D6,0x69D6,0xA9D6,0xE9D6,0x39D6,0x79D6,0xB9D6,0xF9D6,
 0x0DD6,0x4DD6,0x8DD6,0xCDD6,0x1DD6,0x5DD6,0x9DD6,0xDDD6,
 0x2DD6,0x6DD6,0xADD6,0xEDD6,0x3DD6,0x7DD6,0xBDD6,0xFDD6,
 0x02D6,0x42D6,0x82D6,0xC2D6,0x12D6,0x52D6,0x92D6,0xD2D6,
 0x22D6,0x62D6,0xA2D6,0xE2D6,0x32D6,0x72D6,0xB2D6,0xF2D6,
 0x06D6,0x46D6,0x86D6,0xC6D6,0x16D6,0x56D6,0x96D6,0xD6D6,
 0x26D6,0x66D6,0xA6D6,0xE6D6,0x36D6,0x76D6,0xB6D6,0xF6D6,
 0x0AD6,0x4AD6,0x8AD6,0xCAD6,0x1AD6,0x5AD6,0x9AD6,0xDAD6,
 0x2AD6,0x6AD6,0xAAD6,0xEAD6,0x3AD6,0x7AD6,0xBAD6,0xFAD6,
 0x0ED6,0x4ED6,0x8ED6,0xCED6,0x1ED6,0x5ED6,0x9ED6,0xDED6,
 0x2ED6,0x6ED6,0xAED6,0xEED6,0x3ED6,0x7ED6,0xBED6,0xFED6,
 0x03D6,0x43D6,0x83D6,0xC3D6,0x13D6,0x53D6,0x93D6,0xD3D6,
 0x23D6,0x63D6,0xA3D6,0xE3D6,0x33D6,0x73D6,0xB3D6,0xF3D6,
 0x07D6,0x47D6,0x87D6,0xC7D6,0x17D6,0x57D6,0x97D6,0xD7D6,
 0x27D6,0x67D6,0xA7D6,0xE7D6,0x37D6,0x77D6,0xB7D6,0xF7D6,
 0x0BD6,0x4BD6,0x8BD6,0xCBD6,0x1BD6,0x5BD6,0x9BD6,0xDBD6,
 0x2BD6,0x6BD6,0xABD6,0xEBD6,0x3BD6,0x7BD6,0xBBD6,0xFBD6,
 0x0FD6,0x4FD6,0x8FD6,0xCFD6,0x1FD6,0x5FD6,0x9FD6,0xDFD6,
 0x2FD6,0x6FD6,0xAFD6,0xEFD6,0x3FD6,0x7FD6,0xBFD6,0xFFD6,
 0x0026,0x4026,0x8026,0xC026,0x1026,0x5026,0x9026,0xD026,
 0x2026,0x6026,0xA026,0xE026,0x3026,0x7026,0xB026,0xF026,
 0x0426,0x4426,0x8426,0xC426,0x1426,0x5426,0x9426,0xD426,
 0x2426,0x6426,0xA426,0xE426,0x3426,0x7426,0xB426,0xF426,
 0x0826,0x4826,0x8826,0xC826,0x1826,0x5826,0x9826,0xD826,
 0x2826,0x6826,0xA826,0xE826,0x3826,0x7826,0xB826,0xF826,
 0x0C26,0x4C26,0x8C26,0xCC26,0x1C26,0x5C26,0x9C26,0xDC26,
 0x2C26,0x6C26,0xAC26,0xEC26,0x3C26,0x7C26,0xBC26,0xFC26,
 0x0126,0x4126,0x8126,0xC126,0x1126,0x5126,0x9126,0xD126,
 0x2126,0x6126,0xA126,0xE126,0x3126,0x7126,0xB126,0xF126,
 0x0526,0x4526,0x8526,0xC526,0x1526,0x5526,0x9526,0xD526,
 0x2526,0x6526,0xA526,0xE526,0x3526,0x7526,0xB526,0xF526,
 0x0926,0x4926,0x8926,0xC926,0x1926,0x5926,0x9926,0xD926,
 0x2926,0x6926,0xA926,0xE926,0x3926,0x7926,0xB926,0xF926,
 0x0D26,0x4D26,0x8D26,0xCD26,0x1D26,0x5D26,0x9D26,0xDD26,
 0x2D26,0x6D26,0xAD26,0xED26,0x3D26,0x7D26,0xBD26,0xFD26,
 0x0226,0x4226,0x8226,0xC226,0x1226,0x5226,0x9226,0xD226,
 0x2226,0x6226,0xA226,0xE226,0x3226,0x7226,0xB226,0xF226,
 0x0626,0x4626,0x8626,0xC626,0x1626,0x5626,0x9626,0xD626,
 0x2626,0x6626,0xA626,0xE626,0x3626,0x7626,0xB626,0xF626,
 0x0A26,0x4A26,0x8A26,0xCA26,0x1A26,0x5A26,0x9A26,0xDA26,
 0x2A26,0x6A26,0xAA26,0xEA26,0x3A26,0x7A26,0xBA26,0xFA26,
 0x0E26,0x4E26,0x8E26,0xCE26,0x1E26,0x5E26,0x9E26,0xDE26,
 0x2E26,0x6E26,0xAE26,0xEE26,0x3E26,0x7E26,0xBE26,0xFE26,
 0x0326,0x4326,0x8326,0xC326,0x1326,0x5326,0x9326,0xD326,
 0x2326,0x6326,0xA326,0xE326,0x3326,0x7326,0xB326,0xF326,
 0x0726,0x4726,0x8726,0xC726,0x1726,0x5726,0x9726,0xD726,
 0x2726,0x6726,0xA726,0xE726,0x3726,0x7726,0xB726,0xF726,
 0x0B26,0x4B26,0x8B26,0xCB26,0x1B26,0x5B26,0x9B26,0xDB26,
 0x2B26,0x6B26,0xAB26,0xEB26,0x3B26,0x7B26,0xBB26,0xFB26,
 0x0F26,0x4F26,0x8F26,0xCF26,0x1F26,0x5F26,0x9F26,0xDF26,
 0x2F26,0x6F26,0xAF26,0xEF26,0x3F26,0x7F26,0xBF26,0xFF26,
 0x0066,0x4066,0x8066,0xC066,0x1066,0x5066,0x9066,0xD066,
 0x2066,0x6066,0xA066,0xE066,0x3066,0x7066,0xB066,0xF066,
 0x0466,0x4466,0x8466,0xC466,0x1466,0x5466,0x9466,0xD466,
 0x2466,0x6466,0xA466,0xE466,0x3466,0x7466,0xB466,0xF466,
 0x0866,0x4866,0x8866,0xC866,0x1866,0x5866,0x9866,0xD866,
 0x2866,0x6866,0xA866,0xE866,0x3866,0x7866,0xB866,0xF866,
 0x0C66,0x4C66,0x8C66,0xCC66,0x1C66,0x5C66,0x9C66,0xDC66,
 0x2C66,0x6C66,0xAC66,0xEC66,0x3C66,0x7C66,0xBC66,0xFC66,
 0x0166,0x4166,0x8166,0xC166,0x1166,0x5166,0x9166,0xD166,
 0x2166,0x6166,0xA166,0xE166,0x3166,0x7166,0xB166,0xF166,
 0x0566,0x4566,0x8566,0xC566,0x1566,0x5566,0x9566,0xD566,
 0x2566,0x6566,0xA566,0xE566,0x3566,0x7566,0xB566,0xF566,
 0x0966,0x4966,0x8966,0xC966,0x1966,0x5966,0x9966,0xD966,
 0x2966,0x6966,0xA966,0xE966,0x3966,0x7966,0xB966,0xF966,
 0x0D66,0x4D66,0x8D66,0xCD66,0x1D66,0x5D66,0x9D66,0xDD66,
 0x2D66,0x6D66,0xAD66,0xED66,0x3D66,0x7D66,0xBD66,0xFD66,
 0x0266,0x4266,0x8266,0xC266,0x1266,0x5266,0x9266,0xD266,
 0x2266,0x6266,0xA266,0xE266,0x3266,0x7266,0xB266,0xF266,
 0x0666,0x4666,0x8666,0xC666,0x1666,0x5666,0x9666,0xD666,
 0x2666,0x6666,0xA666,0xE666,0x3666,0x7666,0xB666,0xF666,
 0x0A66,0x4A66,0x8A66,0xCA66,0x1A66,0x5A66,0x9A66,0xDA66,
 0x2A66,0x6A66,0xAA66,0xEA66,0x3A66,0x7A66,0xBA66,0xFA66,
 0x0E66,0x4E66,0x8E66,0xCE66,0x1E66,0x5E66,0x9E66,0xDE66,
 0x2E66,0x6E66,0xAE66,0xEE66,0x3E66,0x7E66,0xBE66,0xFE66,
 0x0366,0x4366,0x8366,0xC366,0x1366,0x5366,0x9366,0xD366,
 0x2366,0x6366,0xA366,0xE366,0x3366,0x7366,0xB366,0xF366,
 0x0766,0x4766,0x8766,0xC766,0x1766,0x5766,0x9766,0xD766,
 0x2766,0x6766,0xA766,0xE766,0x3766,0x7766,0xB766,0xF766,
 0x0B66,0x4B66,0x8B66,0xCB66,0x1B66,0x5B66,0x9B66,0xDB66,
 0x2B66,0x6B66,0xAB66,0xEB66,0x3B66,0x7B66,0xBB66,0xFB66,
 0x0F66,0x4F66,0x8F66,0xCF66,0x1F66,0x5F66,0x9F66,0xDF66,
 0x2F66,0x6F66,0xAF66,0xEF66,0x3F66,0x7F66,0xBF66,0xFF66,
 0x00A6,0x40A6,0x80A6,0xC0A6,0x10A6,0x50A6,0x90A6,0xD0A6,
 0x20A6,0x60A6,0xA0A6,0xE0A6,0x30A6,0x70A6,0xB0A6,0xF0A6,
 0x04A6,0x44A6,0x84A6,0xC4A6,0x14A6,0x54A6,0x94A6,0xD4A6,
 0x24A6,0x64A6,0xA4A6,0xE4A6,0x34A6,0x74A6,0xB4A6,0xF4A6,
 0x08A6,0x48A6,0x88A6,0xC8A6,0x18A6,0x58A6,0x98A6,0xD8A6,
 0x28A6,0x68A6,0xA8A6,0xE8A6,0x38A6,0x78A6,0xB8A6,0xF8A6,
 0x0CA6,0x4CA6,0x8CA6,0xCCA6,0x1CA6,0x5CA6,0x9CA6,0xDCA6,
 0x2CA6,0x6CA6,0xACA6,0xECA6,0x3CA6,0x7CA6,0xBCA6,0xFCA6,
 0x01A6,0x41A6,0x81A6,0xC1A6,0x11A6,0x51A6,0x91A6,0xD1A6,
 0x21A6,0x61A6,0xA1A6,0xE1A6,0x31A6,0x71A6,0xB1A6,0xF1A6,
 0x05A6,0x45A6,0x85A6,0xC5A6,0x15A6,0x55A6,0x95A6,0xD5A6,
 0x25A6,0x65A6,0xA5A6,0xE5A6,0x35A6,0x75A6,0xB5A6,0xF5A6,
 0x09A6,0x49A6,0x89A6,0xC9A6,0x19A6,0x59A6,0x99A6,0xD9A6,
 0x29A6,0x69A6,0xA9A6,0xE9A6,0x39A6,0x79A6,0xB9A6,0xF9A6,
 0x0DA6,0x4DA6,0x8DA6,0xCDA6,0x1DA6,0x5DA6,0x9DA6,0xDDA6,
 0x2DA6,0x6DA6,0xADA6,0xEDA6,0x3DA6,0x7DA6,0xBDA6,0xFDA6,
 0x02A6,0x42A6,0x82A6,0xC2A6,0x12A6,0x52A6,0x92A6,0xD2A6,
 0x22A6,0x62A6,0xA2A6,0xE2A6,0x32A6,0x72A6,0xB2A6,0xF2A6,
 0x06A6,0x46A6,0x86A6,0xC6A6,0x16A6,0x56A6,0x96A6,0xD6A6,
 0x26A6,0x66A6,0xA6A6,0xE6A6,0x36A6,0x76A6,0xB6A6,0xF6A6,
 0x0AA6,0x4AA6,0x8AA6,0xCAA6,0x1AA6,0x5AA6,0x9AA6,0xDAA6,
 0x2AA6,0x6AA6,0xAAA6,0xEAA6,0x3AA6,0x7AA6,0xBAA6,0xFAA6,
 0x0EA6,0x4EA6,0x8EA6,0xCEA6,0x1EA6,0x5EA6,0x9EA6,0xDEA6,
 0x2EA6,0x6EA6,0xAEA6,0xEEA6,0x3EA6,0x7EA6,0xBEA6,0xFEA6,
 0x03A6,0x43A6,0x83A6,0xC3A6,0x13A6,0x53A6,0x93A6,0xD3A6,
 0x23A6,0x63A6,0xA3A6,0xE3A6,0x33A6,0x73A6,0xB3A6,0xF3A6,
 0x07A6,0x47A6,0x87A6,0xC7A6,0x17A6,0x57A6,0x97A6,0xD7A6,
 0x27A6,0x67A6,0xA7A6,0xE7A6,0x37A6,0x77A6,0xB7A6,0xF7A6,
 0x0BA6,0x4BA6,0x8BA6,0xCBA6,0x1BA6,0x5BA6,0x9BA6,0xDBA6,
 0x2BA6,0x6BA6,0xABA6,0xEBA6,0x3BA6,0x7BA6,0xBBA6,0xFBA6,
 0x0FA6,0x4FA6,0x8FA6,0xCFA6,0x1FA6,0x5FA6,0x9FA6,0xDFA6,
 0x2FA6,0x6FA6,0xAFA6,0xEFA6,0x3FA6,0x7FA6,0xBFA6,0xFFA6,
 0x00E6,0x40E6,0x80E6,0xC0E6,0x10E6,0x50E6,0x90E6,0xD0E6,
 0x20E6,0x60E6,0xA0E6,0xE0E6,0x30E6,0x70E6,0xB0E6,0xF0E6,
 0x04E6,0x44E6,0x84E6,0xC4E6,0x14E6,0x54E6,0x94E6,0xD4E6,
 0x24E6,0x64E6,0xA4E6,0xE4E6,0x34E6,0x74E6,0xB4E6,0xF4E6,
 0x08E6,0x48E6,0x88E6,0xC8E6,0x18E6,0x58E6,0x98E6,0xD8E6,
 0x28E6,0x68E6,0xA8E6,0xE8E6,0x38E6,0x78E6,0xB8E6,0xF8E6,
 0x0CE6,0x4CE6,0x8CE6,0xCCE6,0x1CE6,0x5CE6,0x9CE6,0xDCE6,
 0x2CE6,0x6CE6,0xACE6,0xECE6,0x3CE6,0x7CE6,0xBCE6,0xFCE6,
 0x01E6,0x41E6,0x81E6,0xC1E6,0x11E6,0x51E6,0x91E6,0xD1E6,
 0x21E6,0x61E6,0xA1E6,0xE1E6,0x31E6,0x71E6,0xB1E6,0xF1E6,
 0x05E6,0x45E6,0x85E6,0xC5E6,0x15E6,0x55E6,0x95E6,0xD5E6,
 0x25E6,0x65E6,0xA5E6,0xE5E6,0x35E6,0x75E6,0xB5E6,0xF5E6,
 0x09E6,0x49E6,0x89E6,0xC9E6,0x19E6,0x59E6,0x99E6,0xD9E6,
 0x29E6,0x69E6,0xA9E6,0xE9E6,0x39E6,0x79E6,0xB9E6,0xF9E6,
 0x0DE6,0x4DE6,0x8DE6,0xCDE6,0x1DE6,0x5DE6,0x9DE6,0xDDE6,
 0x2DE6,0x6DE6,0xADE6,0xEDE6,0x3DE6,0x7DE6,0xBDE6,0xFDE6,
 0x02E6,0x42E6,0x82E6,0xC2E6,0x12E6,0x52E6,0x92E6,0xD2E6,
 0x22E6,0x62E6,0xA2E6,0xE2E6,0x32E6,0x72E6,0xB2E6,0xF2E6,
 0x06E6,0x46E6,0x86E6,0xC6E6,0x16E6,0x56E6,0x96E6,0xD6E6,
 0x26E6,0x66E6,0xA6E6,0xE6E6,0x36E6,0x76E6,0xB6E6,0xF6E6,
 0x0AE6,0x4AE6,0x8AE6,0xCAE6,0x1AE6,0x5AE6,0x9AE6,0xDAE6,
 0x2AE6,0x6AE6,0xAAE6,0xEAE6,0x3AE6,0x7AE6,0xBAE6,0xFAE6,
 0x0EE6,0x4EE6,0x8EE6,0xCEE6,0x1EE6,0x5EE6,0x9EE6,0xDEE6,
 0x2EE6,0x6EE6,0xAEE6,0xEEE6,0x3EE6,0x7EE6,0xBEE6,0xFEE6,
 0x03E6,0x43E6,0x83E6,0xC3E6,0x13E6,0x53E6,0x93E6,0xD3E6,
 0x23E6,0x63E6,0xA3E6,0xE3E6,0x33E6,0x73E6,0xB3E6,0xF3E6,
 0x07E6,0x47E6,0x87E6,0xC7E6,0x17E6,0x57E6,0x97E6,0xD7E6,
 0x27E6,0x67E6,0xA7E6,0xE7E6,0x37E6,0x77E6,0xB7E6,0xF7E6,
 0x0BE6,0x4BE6,0x8BE6,0xCBE6,0x1BE6,0x5BE6,0x9BE6,0xDBE6,
 0x2BE6,0x6BE6,0xABE6,0xEBE6,0x3BE6,0x7BE6,0xBBE6,0xFBE6,
 0x0FE6,0x4FE6,0x8FE6,0xCFE6,0x1FE6,0x5FE6,0x9FE6,0xDFE6,
 0x2FE6,0x6FE6,0xAFE6,0xEFE6,0x3FE6,0x7FE6,0xBFE6,0xFFE6,
 0x0036,0x4036,0x8036,0xC036,0x1036,0x5036,0x9036,0xD036,
 0x2036,0x6036,0xA036,0xE036,0x3036,0x7036,0xB036,0xF036,
 0x0436,0x4436,0x8436,0xC436,0x1436,0x5436,0x9436,0xD436,
 0x2436,0x6436,0xA436,0xE436,0x3436,0x7436,0xB436,0xF436,
 0x0836,0x4836,0x8836,0xC836,0x1836,0x5836,0x9836,0xD836,
 0x2836,0x6836,0xA836,0xE836,0x3836,0x7836,0xB836,0xF836,
 0x0C36,0x4C36,0x8C36,0xCC36,0x1C36,0x5C36,0x9C36,0xDC36,
 0x2C36,0x6C36,0xAC36,0xEC36,0x3C36,0x7C36,0xBC36,0xFC36,
 0x0136,0x4136,0x8136,0xC136,0x1136,0x5136,0x9136,0xD136,
 0x2136,0x6136,0xA136,0xE136,0x3136,0x7136,0xB136,0xF136,
 0x0536,0x4536,0x8536,0xC536,0x1536,0x5536,0x9536,0xD536,
 0x2536,0x6536,0xA536,0xE536,0x3536,0x7536,0xB536,0xF536,
 0x0936,0x4936,0x8936,0xC936,0x1936,0x5936,0x9936,0xD936,
 0x2936,0x6936,0xA936,0xE936,0x3936,0x7936,0xB936,0xF936,
 0x0D36,0x4D36,0x8D36,0xCD36,0x1D36,0x5D36,0x9D36,0xDD36,
 0x2D36,0x6D36,0xAD36,0xED36,0x3D36,0x7D36,0xBD36,0xFD36,
 0x0236,0x4236,0x8236,0xC236,0x1236,0x5236,0x9236,0xD236,
 0x2236,0x6236,0xA236,0xE236,0x3236,0x7236,0xB236,0xF236,
 0x0636,0x4636,0x8636,0xC636,0x1636,0x5636,0x9636,0xD636,
 0x2636,0x6636,0xA636,0xE636,0x3636,0x7636,0xB636,0xF636,
 0x0A36,0x4A36,0x8A36,0xCA36,0x1A36,0x5A36,0x9A36,0xDA36,
 0x2A36,0x6A36,0xAA36,0xEA36,0x3A36,0x7A36,0xBA36,0xFA36,
 0x0E36,0x4E36,0x8E36,0xCE36,0x1E36,0x5E36,0x9E36,0xDE36,
 0x2E36,0x6E36,0xAE36,0xEE36,0x3E36,0x7E36,0xBE36,0xFE36,
 0x0336,0x4336,0x8336,0xC336,0x1336,0x5336,0x9336,0xD336,
 0x2336,0x6336,0xA336,0xE336,0x3336,0x7336,0xB336,0xF336,
 0x0736,0x4736,0x8736,0xC736,0x1736,0x5736,0x9736,0xD736,
 0x2736,0x6736,0xA736,0xE736,0x3736,0x7736,0xB736,0xF736,
 0x0B36,0x4B36,0x8B36,0xCB36,0x1B36,0x5B36,0x9B36,0xDB36,
 0x2B36,0x6B36,0xAB36,0xEB36,0x3B36,0x7B36,0xBB36,0xFB36,
 0x0F36,0x4F36,0x8F36,0xCF36,0x1F36,0x5F36,0x9F36,0xDF36,
 0x2F36,0x6F36,0xAF36,0xEF36,0x3F36,0x7F36,0xBF36,0xFF36,
 0x0076,0x4076,0x8076,0xC076,0x1076,0x5076,0x9076,0xD076,
 0x2076,0x6076,0xA076,0xE076,0x3076,0x7076,0xB076,0xF076,
 0x0476,0x4476,0x8476,0xC476,0x1476,0x5476,0x9476,0xD476,
 0x2476,0x6476,0xA476,0xE476,0x3476,0x7476,0xB476,0xF476,
 0x0876,0x4876,0x8876,0xC876,0x1876,0x5876,0x9876,0xD876,
 0x2876,0x6876,0xA876,0xE876,0x3876,0x7876,0xB876,0xF876,
 0x0C76,0x4C76,0x8C76,0xCC76,0x1C76,0x5C76,0x9C76,0xDC76,
 0x2C76,0x6C76,0xAC76,0xEC76,0x3C76,0x7C76,0xBC76,0xFC76,
 0x0176,0x4176,0x8176,0xC176,0x1176,0x5176,0x9176,0xD176,
 0x2176,0x6176,0xA176,0xE176,0x3176,0x7176,0xB176,0xF176,
 0x0576,0x4576,0x8576,0xC576,0x1576,0x5576,0x9576,0xD576,
 0x2576,0x6576,0xA576,0xE576,0x3576,0x7576,0xB576,0xF576,
 0x0976,0x4976,0x8976,0xC976,0x1976,0x5976,0x9976,0xD976,
 0x2976,0x6976,0xA976,0xE976,0x3976,0x7976,0xB976,0xF976,
 0x0D76,0x4D76,0x8D76,0xCD76,0x1D76,0x5D76,0x9D76,0xDD76,
 0x2D76,0x6D76,0xAD76,0xED76,0x3D76,0x7D76,0xBD76,0xFD76,
 0x0276,0x4276,0x8276,0xC276,0x1276,0x5276,0x9276,0xD276,
 0x2276,0x6276,0xA276,0xE276,0x3276,0x7276,0xB276,0xF276,
 0x0676,0x4676,0x8676,0xC676,0x1676,0x5676,0x9676,0xD676,
 0x2676,0x6676,0xA676,0xE676,0x3676,0x7676,0xB676,0xF676,
 0x0A76,0x4A76,0x8A76,0xCA76,0x1A76,0x5A76,0x9A76,0xDA76,
 0x2A76,0x6A76,0xAA76,0xEA76,0x3A76,0x7A76,0xBA76,0xFA76,
 0x0E76,0x4E76,0x8E76,0xCE76,0x1E76,0x5E76,0x9E76,0xDE76,
 0x2E76,0x6E76,0xAE76,0xEE76,0x3E76,0x7E76,0xBE76,0xFE76,
 0x0376,0x4376,0x8376,0xC376,0x1376,0x5376,0x9376,0xD376,
 0x2376,0x6376,0xA376,0xE376,0x3376,0x7376,0xB376,0xF376,
 0x0776,0x4776,0x8776,0xC776,0x1776,0x5776,0x9776,0xD776,
 0x2776,0x6776,0xA776,0xE776,0x3776,0x7776,0xB776,0xF776,
 0x0B76,0x4B76,0x8B76,0xCB76,0x1B76,0x5B76,0x9B76,0xDB76,
 0x2B76,0x6B76,0xAB76,0xEB76,0x3B76,0x7B76,0xBB76,0xFB76,
 0x0F76,0x4F76,0x8F76,0xCF76,0x1F76,0x5F76,0x9F76,0xDF76,
 0x2F76,0x6F76,0xAF76,0xEF76,0x3F76,0x7F76,0xBF76,0xFF76,
 0x00B6,0x40B6,0x80B6,0xC0B6,0x10B6,0x50B6,0x90B6,0xD0B6,
 0x20B6,0x60B6,0xA0B6,0xE0B6,0x30B6,0x70B6,0xB0B6,0xF0B6,
 0x04B6,0x44B6,0x84B6,0xC4B6,0x14B6,0x54B6,0x94B6,0xD4B6,
 0x24B6,0x64B6,0xA4B6,0xE4B6,0x34B6,0x74B6,0xB4B6,0xF4B6,
 0x08B6,0x48B6,0x88B6,0xC8B6,0x18B6,0x58B6,0x98B6,0xD8B6,
 0x28B6,0x68B6,0xA8B6,0xE8B6,0x38B6,0x78B6,0xB8B6,0xF8B6,
 0x0CB6,0x4CB6,0x8CB6,0xCCB6,0x1CB6,0x5CB6,0x9CB6,0xDCB6,
 0x2CB6,0x6CB6,0xACB6,0xECB6,0x3CB6,0x7CB6,0xBCB6,0xFCB6,
 0x01B6,0x41B6,0x81B6,0xC1B6,0x11B6,0x51B6,0x91B6,0xD1B6,
 0x21B6,0x61B6,0xA1B6,0xE1B6,0x31B6,0x71B6,0xB1B6,0xF1B6,
 0x05B6,0x45B6,0x85B6,0xC5B6,0x15B6,0x55B6,0x95B6,0xD5B6,
 0x25B6,0x65B6,0xA5B6,0xE5B6,0x35B6,0x75B6,0xB5B6,0xF5B6,
 0x09B6,0x49B6,0x89B6,0xC9B6,0x19B6,0x59B6,0x99B6,0xD9B6,
 0x29B6,0x69B6,0xA9B6,0xE9B6,0x39B6,0x79B6,0xB9B6,0xF9B6,
 0x0DB6,0x4DB6,0x8DB6,0xCDB6,0x1DB6,0x5DB6,0x9DB6,0xDDB6,
 0x2DB6,0x6DB6,0xADB6,0xEDB6,0x3DB6,0x7DB6,0xBDB6,0xFDB6,
 0x02B6,0x42B6,0x82B6,0xC2B6,0x12B6,0x52B6,0x92B6,0xD2B6,
 0x22B6,0x62B6,0xA2B6,0xE2B6,0x32B6,0x72B6,0xB2B6,0xF2B6,
 0x06B6,0x46B6,0x86B6,0xC6B6,0x16B6,0x56B6,0x96B6,0xD6B6,
 0x26B6,0x66B6,0xA6B6,0xE6B6,0x36B6,0x76B6,0xB6B6,0xF6B6,
 0x0AB6,0x4AB6,0x8AB6,0xCAB6,0x1AB6,0x5AB6,0x9AB6,0xDAB6,
 0x2AB6,0x6AB6,0xAAB6,0xEAB6,0x3AB6,0x7AB6,0xBAB6,0xFAB6,
 0x0EB6,0x4EB6,0x8EB6,0xCEB6,0x1EB6,0x5EB6,0x9EB6,0xDEB6,
 0x2EB6,0x6EB6,0xAEB6,0xEEB6,0x3EB6,0x7EB6,0xBEB6,0xFEB6,
 0x03B6,0x43B6,0x83B6,0xC3B6,0x13B6,0x53B6,0x93B6,0xD3B6,
 0x23B6,0x63B6,0xA3B6,0xE3B6,0x33B6,0x73B6,0xB3B6,0xF3B6,
 0x07B6,0x47B6,0x87B6,0xC7B6,0x17B6,0x57B6,0x97B6,0xD7B6,
 0x27B6,0x67B6,0xA7B6,0xE7B6,0x37B6,0x77B6,0xB7B6,0xF7B6,
 0x0BB6,0x4BB6,0x8BB6,0xCBB6,0x1BB6,0x5BB6,0x9BB6,0xDBB6,
 0x2BB6,0x6BB6,0xABB6,0xEBB6,0x3BB6,0x7BB6,0xBBB6,0xFBB6,
 0x0FB6,0x4FB6,0x8FB6,0xCFB6,0x1FB6,0x5FB6,0x9FB6,0xDFB6,
 0x2FB6,0x6FB6,0xAFB6,0xEFB6,0x3FB6,0x7FB6,0xBFB6,0xFFB6,
 0x00F6,0x40F6,0x80F6,0xC0F6,0x10F6,0x50F6,0x90F6,0xD0F6,
 0x20F6,0x60F6,0xA0F6,0xE0F6,0x30F6,0x70F6,0xB0F6,0xF0F6,
 0x04F6,0x44F6,0x84F6,0xC4F6,0x14F6,0x54F6,0x94F6,0xD4F6,
 0x24F6,0x64F6,0xA4F6,0xE4F6,0x34F6,0x74F6,0xB4F6,0xF4F6,
 0x08F6,0x48F6,0x88F6,0xC8F6,0x18F6,0x58F6,0x98F6,0xD8F6,
 0x28F6,0x68F6,0xA8F6,0xE8F6,0x38F6,0x78F6,0xB8F6,0xF8F6,
 0x0CF6,0x4CF6,0x8CF6,0xCCF6,0x1CF6,0x5CF6,0x9CF6,0xDCF6,
 0x2CF6,0x6CF6,0xACF6,0xECF6,0x3CF6,0x7CF6,0xBCF6,0xFCF6,
 0x01F6,0x41F6,0x81F6,0xC1F6,0x11F6,0x51F6,0x91F6,0xD1F6,
 0x21F6,0x61F6,0xA1F6,0xE1F6,0x31F6,0x71F6,0xB1F6,0xF1F6,
 0x05F6,0x45F6,0x85F6,0xC5F6,0x15F6,0x55F6,0x95F6,0xD5F6,
 0x25F6,0x65F6,0xA5F6,0xE5F6,0x35F6,0x75F6,0xB5F6,0xF5F6,
 0x09F6,0x49F6,0x89F6,0xC9F6,0x19F6,0x59F6,0x99F6,0xD9F6,
 0x29F6,0x69F6,0xA9F6,0xE9F6,0x39F6,0x79F6,0xB9F6,0xF9F6,
 0x0DF6,0x4DF6,0x8DF6,0xCDF6,0x1DF6,0x5DF6,0x9DF6,0xDDF6,
 0x2DF6,0x6DF6,0xADF6,0xEDF6,0x3DF6,0x7DF6,0xBDF6,0xFDF6,
 0x02F6,0x42F6,0x82F6,0xC2F6,0x12F6,0x52F6,0x92F6,0xD2F6,
 0x22F6,0x62F6,0xA2F6,0xE2F6,0x32F6,0x72F6,0xB2F6,0xF2F6,
 0x06F6,0x46F6,0x86F6,0xC6F6,0x16F6,0x56F6,0x96F6,0xD6F6,
 0x26F6,0x66F6,0xA6F6,0xE6F6,0x36F6,0x76F6,0xB6F6,0xF6F6,
 0x0AF6,0x4AF6,0x8AF6,0xCAF6,0x1AF6,0x5AF6,0x9AF6,0xDAF6,
 0x2AF6,0x6AF6,0xAAF6,0xEAF6,0x3AF6,0x7AF6,0xBAF6,0xFAF6,
 0x0EF6,0x4EF6,0x8EF6,0xCEF6,0x1EF6,0x5EF6,0x9EF6,0xDEF6,
 0x2EF6,0x6EF6,0xAEF6,0xEEF6,0x3EF6,0x7EF6,0xBEF6,0xFEF6,
 0x03F6,0x43F6,0x83F6,0xC3F6,0x13F6,0x53F6,0x93F6,0xD3F6,
 0x23F6,0x63F6,0xA3F6,0xE3F6,0x33F6,0x73F6,0xB3F6,0xF3F6,
 0x07F6,0x47F6,0x87F6,0xC7F6,0x17F6,0x57F6,0x97F6,0xD7F6,
 0x27F6,0x67F6,0xA7F6,0xE7F6,0x37F6,0x77F6,0xB7F6,0xF7F6,
 0x0BF6,0x4BF6,0x8BF6,0xCBF6,0x1BF6,0x5BF6,0x9BF6,0xDBF6,
 0x2BF6,0x6BF6,0xABF6,0xEBF6,0x3BF6,0x7BF6,0xBBF6,0xFBF6,
 0x0FF6,0x4FF6,0x8FF6,0xCFF6,0x1FF6,0x5FF6,0x9FF6,0xDFF6,
 0x2FF6,0x6FF6,0xAFF6,0xEFF6,0x3FF6,0x7FF6,0xBFF6,0xFFF6,
 0x000A,0x400A,0x800A,0xC00A,0x100A,0x500A,0x900A,0xD00A,
 0x200A,0x600A,0xA00A,0xE00A,0x300A,0x700A,0xB00A,0xF00A,
 0x040A,0x440A,0x840A,0xC40A,0x140A,0x540A,0x940A,0xD40A,
 0x240A,0x640A,0xA40A,0xE40A,0x340A,0x740A,0xB40A,0xF40A,
 0x080A,0x480A,0x880A,0xC80A,0x180A,0x580A,0x980A,0xD80A,
 0x280A,0x680A,0xA80A,0xE80A,0x380A,0x780A,0xB80A,0xF80A,
 0x0C0A,0x4C0A,0x8C0A,0xCC0A,0x1C0A,0x5C0A,0x9C0A,0xDC0A,
 0x2C0A,0x6C0A,0xAC0A,0xEC0A,0x3C0A,0x7C0A,0xBC0A,0xFC0A,
 0x010A,0x410A,0x810A,0xC10A,0x110A,0x510A,0x910A,0xD10A,
 0x210A,0x610A,0xA10A,0xE10A,0x310A,0x710A,0xB10A,0xF10A,
 0x050A,0x450A,0x850A,0xC50A,0x150A,0x550A,0x950A,0xD50A,
 0x250A,0x650A,0xA50A,0xE50A,0x350A,0x750A,0xB50A,0xF50A,
 0x090A,0x490A,0x890A,0xC90A,0x190A,0x590A,0x990A,0xD90A,
 0x290A,0x690A,0xA90A,0xE90A,0x390A,0x790A,0xB90A,0xF90A,
 0x0D0A,0x4D0A,0x8D0A,0xCD0A,0x1D0A,0x5D0A,0x9D0A,0xDD0A,
 0x2D0A,0x6D0A,0xAD0A,0xED0A,0x3D0A,0x7D0A,0xBD0A,0xFD0A,
 0x020A,0x420A,0x820A,0xC20A,0x120A,0x520A,0x920A,0xD20A,
 0x220A,0x620A,0xA20A,0xE20A,0x320A,0x720A,0xB20A,0xF20A,
 0x060A,0x460A,0x860A,0xC60A,0x160A,0x560A,0x960A,0xD60A,
 0x260A,0x660A,0xA60A,0xE60A,0x360A,0x760A,0xB60A,0xF60A,
 0x0A0A,0x4A0A,0x8A0A,0xCA0A,0x1A0A,0x5A0A,0x9A0A,0xDA0A,
 0x2A0A,0x6A0A,0xAA0A,0xEA0A,0x3A0A,0x7A0A,0xBA0A,0xFA0A,
 0x0E0A,0x4E0A,0x8E0A,0xCE0A,0x1E0A,0x5E0A,0x9E0A,0xDE0A,
 0x2E0A,0x6E0A,0xAE0A,0xEE0A,0x3E0A,0x7E0A,0xBE0A,0xFE0A,
 0x030A,0x430A,0x830A,0xC30A,0x130A,0x530A,0x930A,0xD30A,
 0x230A,0x630A,0xA30A,0xE30A,0x330A,0x730A,0xB30A,0xF30A,
 0x070A,0x470A,0x870A,0xC70A,0x170A,0x570A,0x970A,0xD70A,
 0x270A,0x670A,0xA70A,0xE70A,0x370A,0x770A,0xB70A,0xF70A,
 0x0B0A,0x4B0A,0x8B0A,0xCB0A,0x1B0A,0x5B0A,0x9B0A,0xDB0A,
 0x2B0A,0x6B0A,0xAB0A,0xEB0A,0x3B0A,0x7B0A,0xBB0A,0xFB0A,
 0x0F0A,0x4F0A,0x8F0A,0xCF0A,0x1F0A,0x5F0A,0x9F0A,0xDF0A,
 0x2F0A,0x6F0A,0xAF0A,0xEF0A,0x3F0A,0x7F0A,0xBF0A,0xFF0A,
 0x004A,0x404A,0x804A,0xC04A,0x104A,0x504A,0x904A,0xD04A,
 0x204A,0x604A,0xA04A,0xE04A,0x304A,0x704A,0xB04A,0xF04A,
 0x044A,0x444A,0x844A,0xC44A,0x144A,0x544A,0x944A,0xD44A,
 0x244A,0x644A,0xA44A,0xE44A,0x344A,0x744A,0xB44A,0xF44A,
 0x084A,0x484A,0x884A,0xC84A,0x184A,0x584A,0x984A,0xD84A,
 0x284A,0x684A,0xA84A,0xE84A,0x384A,0x784A,0xB84A,0xF84A,
 0x0C4A,0x4C4A,0x8C4A,0xCC4A,0x1C4A,0x5C4A,0x9C4A,0xDC4A,
 0x2C4A,0x6C4A,0xAC4A,0xEC4A,0x3C4A,0x7C4A,0xBC4A,0xFC4A,
 0x014A,0x414A,0x814A,0xC14A,0x114A,0x514A,0x914A,0xD14A,
 0x214A,0x614A,0xA14A,0xE14A,0x314A,0x714A,0xB14A,0xF14A,
 0x054A,0x454A,0x854A,0xC54A,0x154A,0x554A,0x954A,0xD54A,
 0x254A,0x654A,0xA54A,0xE54A,0x354A,0x754A,0xB54A,0xF54A,
 0x094A,0x494A,0x894A,0xC94A,0x194A,0x594A,0x994A,0xD94A,
 0x294A,0x694A,0xA94A,0xE94A,0x394A,0x794A,0xB94A,0xF94A,
 0x0D4A,0x4D4A,0x8D4A,0xCD4A,0x1D4A,0x5D4A,0x9D4A,0xDD4A,
 0x2D4A,0x6D4A,0xAD4A,0xED4A,0x3D4A,0x7D4A,0xBD4A,0xFD4A,
 0x024A,0x424A,0x824A,0xC24A,0x124A,0x524A,0x924A,0xD24A,
 0x224A,0x624A,0xA24A,0xE24A,0x324A,0x724A,0xB24A,0xF24A,
 0x064A,0x464A,0x864A,0xC64A,0x164A,0x564A,0x964A,0xD64A,
 0x264A,0x664A,0xA64A,0xE64A,0x364A,0x764A,0xB64A,0xF64A,
 0x0A4A,0x4A4A,0x8A4A,0xCA4A,0x1A4A,0x5A4A,0x9A4A,0xDA4A,
 0x2A4A,0x6A4A,0xAA4A,0xEA4A,0x3A4A,0x7A4A,0xBA4A,0xFA4A,
 0x0E4A,0x4E4A,0x8E4A,0xCE4A,0x1E4A,0x5E4A,0x9E4A,0xDE4A,
 0x2E4A,0x6E4A,0xAE4A,0xEE4A,0x3E4A,0x7E4A,0xBE4A,0xFE4A,
 0x034A,0x434A,0x834A,0xC34A,0x134A,0x534A,0x934A,0xD34A,
 0x234A,0x634A,0xA34A,0xE34A,0x334A,0x734A,0xB34A,0xF34A,
 0x074A,0x474A,0x874A,0xC74A,0x174A,0x574A,0x974A,0xD74A,
 0x274A,0x674A,0xA74A,0xE74A,0x374A,0x774A,0xB74A,0xF74A,
 0x0B4A,0x4B4A,0x8B4A,0xCB4A,0x1B4A,0x5B4A,0x9B4A,0xDB4A,
 0x2B4A,0x6B4A,0xAB4A,0xEB4A,0x3B4A,0x7B4A,0xBB4A,0xFB4A,
 0x0F4A,0x4F4A,0x8F4A,0xCF4A,0x1F4A,0x5F4A,0x9F4A,0xDF4A,
 0x2F4A,0x6F4A,0xAF4A,0xEF4A,0x3F4A,0x7F4A,0xBF4A,0xFF4A,
 0x008A,0x408A,0x808A,0xC08A,0x108A,0x508A,0x908A,0xD08A,
 0x208A,0x608A,0xA08A,0xE08A,0x308A,0x708A,0xB08A,0xF08A,
 0x048A,0x448A,0x848A,0xC48A,0x148A,0x548A,0x948A,0xD48A,
 0x248A,0x648A,0xA48A,0xE48A,0x348A,0x748A,0xB48A,0xF48A,
 0x088A,0x488A,0x888A,0xC88A,0x188A,0x588A,0x988A,0xD88A,
 0x288A,0x688A,0xA88A,0xE88A,0x388A,0x788A,0xB88A,0xF88A,
 0x0C8A,0x4C8A,0x8C8A,0xCC8A,0x1C8A,0x5C8A,0x9C8A,0xDC8A,
 0x2C8A,0x6C8A,0xAC8A,0xEC8A,0x3C8A,0x7C8A,0xBC8A,0xFC8A,
 0x018A,0x418A,0x818A,0xC18A,0x118A,0x518A,0x918A,0xD18A,
 0x218A,0x618A,0xA18A,0xE18A,0x318A,0x718A,0xB18A,0xF18A,
 0x058A,0x458A,0x858A,0xC58A,0x158A,0x558A,0x958A,0xD58A,
 0x258A,0x658A,0xA58A,0xE58A,0x358A,0x758A,0xB58A,0xF58A,
 0x098A,0x498A,0x898A,0xC98A,0x198A,0x598A,0x998A,0xD98A,
 0x298A,0x698A,0xA98A,0xE98A,0x398A,0x798A,0xB98A,0xF98A,
 0x0D8A,0x4D8A,0x8D8A,0xCD8A,0x1D8A,0x5D8A,0x9D8A,0xDD8A,
 0x2D8A,0x6D8A,0xAD8A,0xED8A,0x3D8A,0x7D8A,0xBD8A,0xFD8A,
 0x028A,0x428A,0x828A,0xC28A,0x128A,0x528A,0x928A,0xD28A,
 0x228A,0x628A,0xA28A,0xE28A,0x328A,0x728A,0xB28A,0xF28A,
 0x068A,0x468A,0x868A,0xC68A,0x168A,0x568A,0x968A,0xD68A,
 0x268A,0x668A,0xA68A,0xE68A,0x368A,0x768A,0xB68A,0xF68A,
 0x0A8A,0x4A8A,0x8A8A,0xCA8A,0x1A8A,0x5A8A,0x9A8A,0xDA8A,
 0x2A8A,0x6A8A,0xAA8A,0xEA8A,0x3A8A,0x7A8A,0xBA8A,0xFA8A,
 0x0E8A,0x4E8A,0x8E8A,0xCE8A,0x1E8A,0x5E8A,0x9E8A,0xDE8A,
 0x2E8A,0x6E8A,0xAE8A,0xEE8A,0x3E8A,0x7E8A,0xBE8A,0xFE8A,
 0x038A,0x438A,0x838A,0xC38A,0x138A,0x538A,0x938A,0xD38A,
 0x238A,0x638A,0xA38A,0xE38A,0x338A,0x738A,0xB38A,0xF38A,
 0x078A,0x478A,0x878A,0xC78A,0x178A,0x578A,0x978A,0xD78A,
 0x278A,0x678A,0xA78A,0xE78A,0x378A,0x778A,0xB78A,0xF78A,
 0x0B8A,0x4B8A,0x8B8A,0xCB8A,0x1B8A,0x5B8A,0x9B8A,0xDB8A,
 0x2B8A,0x6B8A,0xAB8A,0xEB8A,0x3B8A,0x7B8A,0xBB8A,0xFB8A,
 0x0F8A,0x4F8A,0x8F8A,0xCF8A,0x1F8A,0x5F8A,0x9F8A,0xDF8A,
 0x2F8A,0x6F8A,0xAF8A,0xEF8A,0x3F8A,0x7F8A,0xBF8A,0xFF8A,
 0x00CA,0x40CA,0x80CA,0xC0CA,0x10CA,0x50CA,0x90CA,0xD0CA,
 0x20CA,0x60CA,0xA0CA,0xE0CA,0x30CA,0x70CA,0xB0CA,0xF0CA,
 0x04CA,0x44CA,0x84CA,0xC4CA,0x14CA,0x54CA,0x94CA,0xD4CA,
 0x24CA,0x64CA,0xA4CA,0xE4CA,0x34CA,0x74CA,0xB4CA,0xF4CA,
 0x08CA,0x48CA,0x88CA,0xC8CA,0x18CA,0x58CA,0x98CA,0xD8CA,
 0x28CA,0x68CA,0xA8CA,0xE8CA,0x38CA,0x78CA,0xB8CA,0xF8CA,
 0x0CCA,0x4CCA,0x8CCA,0xCCCA,0x1CCA,0x5CCA,0x9CCA,0xDCCA,
 0x2CCA,0x6CCA,0xACCA,0xECCA,0x3CCA,0x7CCA,0xBCCA,0xFCCA,
 0x01CA,0x41CA,0x81CA,0xC1CA,0x11CA,0x51CA,0x91CA,0xD1CA,
 0x21CA,0x61CA,0xA1CA,0xE1CA,0x31CA,0x71CA,0xB1CA,0xF1CA,
 0x05CA,0x45CA,0x85CA,0xC5CA,0x15CA,0x55CA,0x95CA,0xD5CA,
 0x25CA,0x65CA,0xA5CA,0xE5CA,0x35CA,0x75CA,0xB5CA,0xF5CA,
 0x09CA,0x49CA,0x89CA,0xC9CA,0x19CA,0x59CA,0x99CA,0xD9CA,
 0x29CA,0x69CA,0xA9CA,0xE9CA,0x39CA,0x79CA,0xB9CA,0xF9CA,
 0x0DCA,0x4DCA,0x8DCA,0xCDCA,0x1DCA,0x5DCA,0x9DCA,0xDDCA,
 0x2DCA,0x6DCA,0xADCA,0xEDCA,0x3DCA,0x7DCA,0xBDCA,0xFDCA,
 0x02CA,0x42CA,0x82CA,0xC2CA,0x12CA,0x52CA,0x92CA,0xD2CA,
 0x22CA,0x62CA,0xA2CA,0xE2CA,0x32CA,0x72CA,0xB2CA,0xF2CA,
 0x06CA,0x46CA,0x86CA,0xC6CA,0x16CA,0x56CA,0x96CA,0xD6CA,
 0x26CA,0x66CA,0xA6CA,0xE6CA,0x36CA,0x76CA,0xB6CA,0xF6CA,
 0x0ACA,0x4ACA,0x8ACA,0xCACA,0x1ACA,0x5ACA,0x9ACA,0xDACA,
 0x2ACA,0x6ACA,0xAACA,0xEACA,0x3ACA,0x7ACA,0xBACA,0xFACA,
 0x0ECA,0x4ECA,0x8ECA,0xCECA,0x1ECA,0x5ECA,0x9ECA,0xDECA,
 0x2ECA,0x6ECA,0xAECA,0xEECA,0x3ECA,0x7ECA,0xBECA,0xFECA,
 0x03CA,0x43CA,0x83CA,0xC3CA,0x13CA,0x53CA,0x93CA,0xD3CA,
 0x23CA,0x63CA,0xA3CA,0xE3CA,0x33CA,0x73CA,0xB3CA,0xF3CA,
 0x07CA,0x47CA,0x87CA,0xC7CA,0x17CA,0x57CA,0x97CA,0xD7CA,
 0x27CA,0x67CA,0xA7CA,0xE7CA,0x37CA,0x77CA,0xB7CA,0xF7CA,
 0x0BCA,0x4BCA,0x8BCA,0xCBCA,0x1BCA,0x5BCA,0x9BCA,0xDBCA,
 0x2BCA,0x6BCA,0xABCA,0xEBCA,0x3BCA,0x7BCA,0xBBCA,0xFBCA,
 0x0FCA,0x4FCA,0x8FCA,0xCFCA,0x1FCA,0x5FCA,0x9FCA,0xDFCA,
 0x2FCA,0x6FCA,0xAFCA,0xEFCA,0x3FCA,0x7FCA,0xBFCA,0xFFCA,
 0x001A,0x401A,0x801A,0xC01A,0x101A,0x501A,0x901A,0xD01A,
 0x201A,0x601A,0xA01A,0xE01A,0x301A,0x701A,0xB01A,0xF01A,
 0x041A,0x441A,0x841A,0xC41A,0x141A,0x541A,0x941A,0xD41A,
 0x241A,0x641A,0xA41A,0xE41A,0x341A,0x741A,0xB41A,0xF41A,
 0x081A,0x481A,0x881A,0xC81A,0x181A,0x581A,0x981A,0xD81A,
 0x281A,0x681A,0xA81A,0xE81A,0x381A,0x781A,0xB81A,0xF81A,
 0x0C1A,0x4C1A,0x8C1A,0xCC1A,0x1C1A,0x5C1A,0x9C1A,0xDC1A,
 0x2C1A,0x6C1A,0xAC1A,0xEC1A,0x3C1A,0x7C1A,0xBC1A,0xFC1A,
 0x011A,0x411A,0x811A,0xC11A,0x111A,0x511A,0x911A,0xD11A,
 0x211A,0x611A,0xA11A,0xE11A,0x311A,0x711A,0xB11A,0xF11A,
 0x051A,0x451A,0x851A,0xC51A,0x151A,0x551A,0x951A,0xD51A,
 0x251A,0x651A,0xA51A,0xE51A,0x351A,0x751A,0xB51A,0xF51A,
 0x091A,0x491A,0x891A,0xC91A,0x191A,0x591A,0x991A,0xD91A,
 0x291A,0x691A,0xA91A,0xE91A,0x391A,0x791A,0xB91A,0xF91A,
 0x0D1A,0x4D1A,0x8D1A,0xCD1A,0x1D1A,0x5D1A,0x9D1A,0xDD1A,
 0x2D1A,0x6D1A,0xAD1A,0xED1A,0x3D1A,0x7D1A,0xBD1A,0xFD1A,
 0x021A,0x421A,0x821A,0xC21A,0x121A,0x521A,0x921A,0xD21A,
 0x221A,0x621A,0xA21A,0xE21A,0x321A,0x721A,0xB21A,0xF21A,
 0x061A,0x461A,0x861A,0xC61A,0x161A,0x561A,0x961A,0xD61A,
 0x261A,0x661A,0xA61A,0xE61A,0x361A,0x761A,0xB61A,0xF61A,
 0x0A1A,0x4A1A,0x8A1A,0xCA1A,0x1A1A,0x5A1A,0x9A1A,0xDA1A,
 0x2A1A,0x6A1A,0xAA1A,0xEA1A,0x3A1A,0x7A1A,0xBA1A,0xFA1A,
 0x0E1A,0x4E1A,0x8E1A,0xCE1A,0x1E1A,0x5E1A,0x9E1A,0xDE1A,
 0x2E1A,0x6E1A,0xAE1A,0xEE1A,0x3E1A,0x7E1A,0xBE1A,0xFE1A,
 0x031A,0x431A,0x831A,0xC31A,0x131A,0x531A,0x931A,0xD31A,
 0x231A,0x631A,0xA31A,0xE31A,0x331A,0x731A,0xB31A,0xF31A,
 0x071A,0x471A,0x871A,0xC71A,0x171A,0x571A,0x971A,0xD71A,
 0x271A,0x671A,0xA71A,0xE71A,0x371A,0x771A,0xB71A,0xF71A,
 0x0B1A,0x4B1A,0x8B1A,0xCB1A,0x1B1A,0x5B1A,0x9B1A,0xDB1A,
 0x2B1A,0x6B1A,0xAB1A,0xEB1A,0x3B1A,0x7B1A,0xBB1A,0xFB1A,
 0x0F1A,0x4F1A,0x8F1A,0xCF1A,0x1F1A,0x5F1A,0x9F1A,0xDF1A,
 0x2F1A,0x6F1A,0xAF1A,0xEF1A,0x3F1A,0x7F1A,0xBF1A,0xFF1A,
 0x005A,0x405A,0x805A,0xC05A,0x105A,0x505A,0x905A,0xD05A,
 0x205A,0x605A,0xA05A,0xE05A,0x305A,0x705A,0xB05A,0xF05A,
 0x045A,0x445A,0x845A,0xC45A,0x145A,0x545A,0x945A,0xD45A,
 0x245A,0x645A,0xA45A,0xE45A,0x345A,0x745A,0xB45A,0xF45A,
 0x085A,0x485A,0x885A,0xC85A,0x185A,0x585A,0x985A,0xD85A,
 0x285A,0x685A,0xA85A,0xE85A,0x385A,0x785A,0xB85A,0xF85A,
 0x0C5A,0x4C5A,0x8C5A,0xCC5A,0x1C5A,0x5C5A,0x9C5A,0xDC5A,
 0x2C5A,0x6C5A,0xAC5A,0xEC5A,0x3C5A,0x7C5A,0xBC5A,0xFC5A,
 0x015A,0x415A,0x815A,0xC15A,0x115A,0x515A,0x915A,0xD15A,
 0x215A,0x615A,0xA15A,0xE15A,0x315A,0x715A,0xB15A,0xF15A,
 0x055A,0x455A,0x855A,0xC55A,0x155A,0x555A,0x955A,0xD55A,
 0x255A,0x655A,0xA55A,0xE55A,0x355A,0x755A,0xB55A,0xF55A,
 0x095A,0x495A,0x895A,0xC95A,0x195A,0x595A,0x995A,0xD95A,
 0x295A,0x695A,0xA95A,0xE95A,0x395A,0x795A,0xB95A,0xF95A,
 0x0D5A,0x4D5A,0x8D5A,0xCD5A,0x1D5A,0x5D5A,0x9D5A,0xDD5A,
 0x2D5A,0x6D5A,0xAD5A,0xED5A,0x3D5A,0x7D5A,0xBD5A,0xFD5A,
 0x025A,0x425A,0x825A,0xC25A,0x125A,0x525A,0x925A,0xD25A,
 0x225A,0x625A,0xA25A,0xE25A,0x325A,0x725A,0xB25A,0xF25A,
 0x065A,0x465A,0x865A,0xC65A,0x165A,0x565A,0x965A,0xD65A,
 0x265A,0x665A,0xA65A,0xE65A,0x365A,0x765A,0xB65A,0xF65A,
 0x0A5A,0x4A5A,0x8A5A,0xCA5A,0x1A5A,0x5A5A,0x9A5A,0xDA5A,
 0x2A5A,0x6A5A,0xAA5A,0xEA5A,0x3A5A,0x7A5A,0xBA5A,0xFA5A,
 0x0E5A,0x4E5A,0x8E5A,0xCE5A,0x1E5A,0x5E5A,0x9E5A,0xDE5A,
 0x2E5A,0x6E5A,0xAE5A,0xEE5A,0x3E5A,0x7E5A,0xBE5A,0xFE5A,
 0x035A,0x435A,0x835A,0xC35A,0x135A,0x535A,0x935A,0xD35A,
 0x235A,0x635A,0xA35A,0xE35A,0x335A,0x735A,0xB35A,0xF35A,
 0x075A,0x475A,0x875A,0xC75A,0x175A,0x575A,0x975A,0xD75A,
 0x275A,0x675A,0xA75A,0xE75A,0x375A,0x775A,0xB75A,0xF75A,
 0x0B5A,0x4B5A,0x8B5A,0xCB5A,0x1B5A,0x5B5A,0x9B5A,0xDB5A,
 0x2B5A,0x6B5A,0xAB5A,0xEB5A,0x3B5A,0x7B5A,0xBB5A,0xFB5A,
 0x0F5A,0x4F5A,0x8F5A,0xCF5A,0x1F5A,0x5F5A,0x9F5A,0xDF5A,
 0x2F5A,0x6F5A,0xAF5A,0xEF5A,0x3F5A,0x7F5A,0xBF5A,0xFF5A,
 0x009A,0x409A,0x809A,0xC09A,0x109A,0x509A,0x909A,0xD09A,
 0x209A,0x609A,0xA09A,0xE09A,0x309A,0x709A,0xB09A,0xF09A,
 0x049A,0x449A,0x849A,0xC49A,0x149A,0x549A,0x949A,0xD49A,
 0x249A,0x649A,0xA49A,0xE49A,0x349A,0x749A,0xB49A,0xF49A,
 0x089A,0x489A,0x889A,0xC89A,0x189A,0x589A,0x989A,0xD89A,
 0x289A,0x689A,0xA89A,0xE89A,0x389A,0x789A,0xB89A,0xF89A,
 0x0C9A,0x4C9A,0x8C9A,0xCC9A,0x1C9A,0x5C9A,0x9C9A,0xDC9A,
 0x2C9A,0x6C9A,0xAC9A,0xEC9A,0x3C9A,0x7C9A,0xBC9A,0xFC9A,
 0x019A,0x419A,0x819A,0xC19A,0x119A,0x519A,0x919A,0xD19A,
 0x219A,0x619A,0xA19A,0xE19A,0x319A,0x719A,0xB19A,0xF19A,
 0x059A,0x459A,0x859A,0xC59A,0x159A,0x559A,0x959A,0xD59A,
 0x259A,0x659A,0xA59A,0xE59A,0x359A,0x759A,0xB59A,0xF59A,
 0x099A,0x499A,0x899A,0xC99A,0x199A,0x599A,0x999A,0xD99A,
 0x299A,0x699A,0xA99A,0xE99A,0x399A,0x799A,0xB99A,0xF99A,
 0x0D9A,0x4D9A,0x8D9A,0xCD9A,0x1D9A,0x5D9A,0x9D9A,0xDD9A,
 0x2D9A,0x6D9A,0xAD9A,0xED9A,0x3D9A,0x7D9A,0xBD9A,0xFD9A,
 0x029A,0x429A,0x829A,0xC29A,0x129A,0x529A,0x929A,0xD29A,
 0x229A,0x629A,0xA29A,0xE29A,0x329A,0x729A,0xB29A,0xF29A,
 0x069A,0x469A,0x869A,0xC69A,0x169A,0x569A,0x969A,0xD69A,
 0x269A,0x669A,0xA69A,0xE69A,0x369A,0x769A,0xB69A,0xF69A,
 0x0A9A,0x4A9A,0x8A9A,0xCA9A,0x1A9A,0x5A9A,0x9A9A,0xDA9A,
 0x2A9A,0x6A9A,0xAA9A,0xEA9A,0x3A9A,0x7A9A,0xBA9A,0xFA9A,
 0x0E9A,0x4E9A,0x8E9A,0xCE9A,0x1E9A,0x5E9A,0x9E9A,0xDE9A,
 0x2E9A,0x6E9A,0xAE9A,0xEE9A,0x3E9A,0x7E9A,0xBE9A,0xFE9A,
 0x039A,0x439A,0x839A,0xC39A,0x139A,0x539A,0x939A,0xD39A,
 0x239A,0x639A,0xA39A,0xE39A,0x339A,0x739A,0xB39A,0xF39A,
 0x079A,0x479A,0x879A,0xC79A,0x179A,0x579A,0x979A,0xD79A,
 0x279A,0x679A,0xA79A,0xE79A,0x379A,0x779A,0xB79A,0xF79A,
 0x0B9A,0x4B9A,0x8B9A,0xCB9A,0x1B9A,0x5B9A,0x9B9A,0xDB9A,
 0x2B9A,0x6B9A,0xAB9A,0xEB9A,0x3B9A,0x7B9A,0xBB9A,0xFB9A,
 0x0F9A,0x4F9A,0x8F9A,0xCF9A,0x1F9A,0x5F9A,0x9F9A,0xDF9A,
 0x2F9A,0x6F9A,0xAF9A,0xEF9A,0x3F9A,0x7F9A,0xBF9A,0xFF9A,
 0x00DA,0x40DA,0x80DA,0xC0DA,0x10DA,0x50DA,0x90DA,0xD0DA,
 0x20DA,0x60DA,0xA0DA,0xE0DA,0x30DA,0x70DA,0xB0DA,0xF0DA,
 0x04DA,0x44DA,0x84DA,0xC4DA,0x14DA,0x54DA,0x94DA,0xD4DA,
 0x24DA,0x64DA,0xA4DA,0xE4DA,0x34DA,0x74DA,0xB4DA,0xF4DA,
 0x08DA,0x48DA,0x88DA,0xC8DA,0x18DA,0x58DA,0x98DA,0xD8DA,
 0x28DA,0x68DA,0xA8DA,0xE8DA,0x38DA,0x78DA,0xB8DA,0xF8DA,
 0x0CDA,0x4CDA,0x8CDA,0xCCDA,0x1CDA,0x5CDA,0x9CDA,0xDCDA,
 0x2CDA,0x6CDA,0xACDA,0xECDA,0x3CDA,0x7CDA,0xBCDA,0xFCDA,
 0x01DA,0x41DA,0x81DA,0xC1DA,0x11DA,0x51DA,0x91DA,0xD1DA,
 0x21DA,0x61DA,0xA1DA,0xE1DA,0x31DA,0x71DA,0xB1DA,0xF1DA,
 0x05DA,0x45DA,0x85DA,0xC5DA,0x15DA,0x55DA,0x95DA,0xD5DA,
 0x25DA,0x65DA,0xA5DA,0xE5DA,0x35DA,0x75DA,0xB5DA,0xF5DA,
 0x09DA,0x49DA,0x89DA,0xC9DA,0x19DA,0x59DA,0x99DA,0xD9DA,
 0x29DA,0x69DA,0xA9DA,0xE9DA,0x39DA,0x79DA,0xB9DA,0xF9DA,
 0x0DDA,0x4DDA,0x8DDA,0xCDDA,0x1DDA,0x5DDA,0x9DDA,0xDDDA,
 0x2DDA,0x6DDA,0xADDA,0xEDDA,0x3DDA,0x7DDA,0xBDDA,0xFDDA,
 0x02DA,0x42DA,0x82DA,0xC2DA,0x12DA,0x52DA,0x92DA,0xD2DA,
 0x22DA,0x62DA,0xA2DA,0xE2DA,0x32DA,0x72DA,0xB2DA,0xF2DA,
 0x06DA,0x46DA,0x86DA,0xC6DA,0x16DA,0x56DA,0x96DA,0xD6DA,
 0x26DA,0x66DA,0xA6DA,0xE6DA,0x36DA,0x76DA,0xB6DA,0xF6DA,
 0x0ADA,0x4ADA,0x8ADA,0xCADA,0x1ADA,0x5ADA,0x9ADA,0xDADA,
 0x2ADA,0x6ADA,0xAADA,0xEADA,0x3ADA,0x7ADA,0xBADA,0xFADA,
 0x0EDA,0x4EDA,0x8EDA,0xCEDA,0x1EDA,0x5EDA,0x9EDA,0xDEDA,
 0x2EDA,0x6EDA,0xAEDA,0xEEDA,0x3EDA,0x7EDA,0xBEDA,0xFEDA,
 0x03DA,0x43DA,0x83DA,0xC3DA,0x13DA,0x53DA,0x93DA,0xD3DA,
 0x23DA,0x63DA,0xA3DA,0xE3DA,0x33DA,0x73DA,0xB3DA,0xF3DA,
 0x07DA,0x47DA,0x87DA,0xC7DA,0x17DA,0x57DA,0x97DA,0xD7DA,
 0x27DA,0x67DA,0xA7DA,0xE7DA,0x37DA,0x77DA,0xB7DA,0xF7DA,
 0x0BDA,0x4BDA,0x8BDA,0xCBDA,0x1BDA,0x5BDA,0x9BDA,0xDBDA,
 0x2BDA,0x6BDA,0xABDA,0xEBDA,0x3BDA,0x7BDA,0xBBDA,0xFBDA,
 0x0FDA,0x4FDA,0x8FDA,0xCFDA,0x1FDA,0x5FDA,0x9FDA,0xDFDA,
 0x2FDA,0x6FDA,0xAFDA,0xEFDA,0x3FDA,0x7FDA,0xBFDA,0xFFDA,
 0x002A,0x402A,0x802A,0xC02A,0x102A,0x502A,0x902A,0xD02A,
 0x202A,0x602A,0xA02A,0xE02A,0x302A,0x702A,0xB02A,0xF02A,
 0x042A,0x442A,0x842A,0xC42A,0x142A,0x542A,0x942A,0xD42A,
 0x242A,0x642A,0xA42A,0xE42A,0x342A,0x742A,0xB42A,0xF42A,
 0x082A,0x482A,0x882A,0xC82A,0x182A,0x582A,0x982A,0xD82A,
 0x282A,0x682A,0xA82A,0xE82A,0x382A,0x782A,0xB82A,0xF82A,
 0x0C2A,0x4C2A,0x8C2A,0xCC2A,0x1C2A,0x5C2A,0x9C2A,0xDC2A,
 0x2C2A,0x6C2A,0xAC2A,0xEC2A,0x3C2A,0x7C2A,0xBC2A,0xFC2A,
 0x012A,0x412A,0x812A,0xC12A,0x112A,0x512A,0x912A,0xD12A,
 0x212A,0x612A,0xA12A,0xE12A,0x312A,0x712A,0xB12A,0xF12A,
 0x052A,0x452A,0x852A,0xC52A,0x152A,0x552A,0x952A,0xD52A,
 0x252A,0x652A,0xA52A,0xE52A,0x352A,0x752A,0xB52A,0xF52A,
 0x092A,0x492A,0x892A,0xC92A,0x192A,0x592A,0x992A,0xD92A,
 0x292A,0x692A,0xA92A,0xE92A,0x392A,0x792A,0xB92A,0xF92A,
 0x0D2A,0x4D2A,0x8D2A,0xCD2A,0x1D2A,0x5D2A,0x9D2A,0xDD2A,
 0x2D2A,0x6D2A,0xAD2A,0xED2A,0x3D2A,0x7D2A,0xBD2A,0xFD2A,
 0x022A,0x422A,0x822A,0xC22A,0x122A,0x522A,0x922A,0xD22A,
 0x222A,0x622A,0xA22A,0xE22A,0x322A,0x722A,0xB22A,0xF22A,
 0x062A,0x462A,0x862A,0xC62A,0x162A,0x562A,0x962A,0xD62A,
 0x262A,0x662A,0xA62A,0xE62A,0x362A,0x762A,0xB62A,0xF62A,
 0x0A2A,0x4A2A,0x8A2A,0xCA2A,0x1A2A,0x5A2A,0x9A2A,0xDA2A,
 0x2A2A,0x6A2A,0xAA2A,0xEA2A,0x3A2A,0x7A2A,0xBA2A,0xFA2A,
 0x0E2A,0x4E2A,0x8E2A,0xCE2A,0x1E2A,0x5E2A,0x9E2A,0xDE2A,
 0x2E2A,0x6E2A,0xAE2A,0xEE2A,0x3E2A,0x7E2A,0xBE2A,0xFE2A,
 0x032A,0x432A,0x832A,0xC32A,0x132A,0x532A,0x932A,0xD32A,
 0x232A,0x632A,0xA32A,0xE32A,0x332A,0x732A,0xB32A,0xF32A,
 0x072A,0x472A,0x872A,0xC72A,0x172A,0x572A,0x972A,0xD72A,
 0x272A,0x672A,0xA72A,0xE72A,0x372A,0x772A,0xB72A,0xF72A,
 0x0B2A,0x4B2A,0x8B2A,0xCB2A,0x1B2A,0x5B2A,0x9B2A,0xDB2A,
 0x2B2A,0x6B2A,0xAB2A,0xEB2A,0x3B2A,0x7B2A,0xBB2A,0xFB2A,
 0x0F2A,0x4F2A,0x8F2A,0xCF2A,0x1F2A,0x5F2A,0x9F2A,0xDF2A,
 0x2F2A,0x6F2A,0xAF2A,0xEF2A,0x3F2A,0x7F2A,0xBF2A,0xFF2A,
 0x006A,0x406A,0x806A,0xC06A,0x106A,0x506A,0x906A,0xD06A,
 0x206A,0x606A,0xA06A,0xE06A,0x306A,0x706A,0xB06A,0xF06A,
 0x046A,0x446A,0x846A,0xC46A,0x146A,0x546A,0x946A,0xD46A,
 0x246A,0x646A,0xA46A,0xE46A,0x346A,0x746A,0xB46A,0xF46A,
 0x086A,0x486A,0x886A,0xC86A,0x186A,0x586A,0x986A,0xD86A,
 0x286A,0x686A,0xA86A,0xE86A,0x386A,0x786A,0xB86A,0xF86A,
 0x0C6A,0x4C6A,0x8C6A,0xCC6A,0x1C6A,0x5C6A,0x9C6A,0xDC6A,
 0x2C6A,0x6C6A,0xAC6A,0xEC6A,0x3C6A,0x7C6A,0xBC6A,0xFC6A,
 0x016A,0x416A,0x816A,0xC16A,0x116A,0x516A,0x916A,0xD16A,
 0x216A,0x616A,0xA16A,0xE16A,0x316A,0x716A,0xB16A,0xF16A,
 0x056A,0x456A,0x856A,0xC56A,0x156A,0x556A,0x956A,0xD56A,
 0x256A,0x656A,0xA56A,0xE56A,0x356A,0x756A,0xB56A,0xF56A,
 0x096A,0x496A,0x896A,0xC96A,0x196A,0x596A,0x996A,0xD96A,
 0x296A,0x696A,0xA96A,0xE96A,0x396A,0x796A,0xB96A,0xF96A,
 0x0D6A,0x4D6A,0x8D6A,0xCD6A,0x1D6A,0x5D6A,0x9D6A,0xDD6A,
 0x2D6A,0x6D6A,0xAD6A,0xED6A,0x3D6A,0x7D6A,0xBD6A,0xFD6A,
 0x026A,0x426A,0x826A,0xC26A,0x126A,0x526A,0x926A,0xD26A,
 0x226A,0x626A,0xA26A,0xE26A,0x326A,0x726A,0xB26A,0xF26A,
 0x066A,0x466A,0x866A,0xC66A,0x166A,0x566A,0x966A,0xD66A,
 0x266A,0x666A,0xA66A,0xE66A,0x366A,0x766A,0xB66A,0xF66A,
 0x0A6A,0x4A6A,0x8A6A,0xCA6A,0x1A6A,0x5A6A,0x9A6A,0xDA6A,
 0x2A6A,0x6A6A,0xAA6A,0xEA6A,0x3A6A,0x7A6A,0xBA6A,0xFA6A,
 0x0E6A,0x4E6A,0x8E6A,0xCE6A,0x1E6A,0x5E6A,0x9E6A,0xDE6A,
 0x2E6A,0x6E6A,0xAE6A,0xEE6A,0x3E6A,0x7E6A,0xBE6A,0xFE6A,
 0x036A,0x436A,0x836A,0xC36A,0x136A,0x536A,0x936A,0xD36A,
 0x236A,0x636A,0xA36A,0xE36A,0x336A,0x736A,0xB36A,0xF36A,
 0x076A,0x476A,0x876A,0xC76A,0x176A,0x576A,0x976A,0xD76A,
 0x276A,0x676A,0xA76A,0xE76A,0x376A,0x776A,0xB76A,0xF76A,
 0x0B6A,0x4B6A,0x8B6A,0xCB6A,0x1B6A,0x5B6A,0x9B6A,0xDB6A,
 0x2B6A,0x6B6A,0xAB6A,0xEB6A,0x3B6A,0x7B6A,0xBB6A,0xFB6A,
 0x0F6A,0x4F6A,0x8F6A,0xCF6A,0x1F6A,0x5F6A,0x9F6A,0xDF6A,
 0x2F6A,0x6F6A,0xAF6A,0xEF6A,0x3F6A,0x7F6A,0xBF6A,0xFF6A,
 0x00AA,0x40AA,0x80AA,0xC0AA,0x10AA,0x50AA,0x90AA,0xD0AA,
 0x20AA,0x60AA,0xA0AA,0xE0AA,0x30AA,0x70AA,0xB0AA,0xF0AA,
 0x04AA,0x44AA,0x84AA,0xC4AA,0x14AA,0x54AA,0x94AA,0xD4AA,
 0x24AA,0x64AA,0xA4AA,0xE4AA,0x34AA,0x74AA,0xB4AA,0xF4AA,
 0x08AA,0x48AA,0x88AA,0xC8AA,0x18AA,0x58AA,0x98AA,0xD8AA,
 0x28AA,0x68AA,0xA8AA,0xE8AA,0x38AA,0x78AA,0xB8AA,0xF8AA,
 0x0CAA,0x4CAA,0x8CAA,0xCCAA,0x1CAA,0x5CAA,0x9CAA,0xDCAA,
 0x2CAA,0x6CAA,0xACAA,0xECAA,0x3CAA,0x7CAA,0xBCAA,0xFCAA,
 0x01AA,0x41AA,0x81AA,0xC1AA,0x11AA,0x51AA,0x91AA,0xD1AA,
 0x21AA,0x61AA,0xA1AA,0xE1AA,0x31AA,0x71AA,0xB1AA,0xF1AA,
 0x05AA,0x45AA,0x85AA,0xC5AA,0x15AA,0x55AA,0x95AA,0xD5AA,
 0x25AA,0x65AA,0xA5AA,0xE5AA,0x35AA,0x75AA,0xB5AA,0xF5AA,
 0x09AA,0x49AA,0x89AA,0xC9AA,0x19AA,0x59AA,0x99AA,0xD9AA,
 0x29AA,0x69AA,0xA9AA,0xE9AA,0x39AA,0x79AA,0xB9AA,0xF9AA,
 0x0DAA,0x4DAA,0x8DAA,0xCDAA,0x1DAA,0x5DAA,0x9DAA,0xDDAA,
 0x2DAA,0x6DAA,0xADAA,0xEDAA,0x3DAA,0x7DAA,0xBDAA,0xFDAA,
 0x02AA,0x42AA,0x82AA,0xC2AA,0x12AA,0x52AA,0x92AA,0xD2AA,
 0x22AA,0x62AA,0xA2AA,0xE2AA,0x32AA,0x72AA,0xB2AA,0xF2AA,
 0x06AA,0x46AA,0x86AA,0xC6AA,0x16AA,0x56AA,0x96AA,0xD6AA,
 0x26AA,0x66AA,0xA6AA,0xE6AA,0x36AA,0x76AA,0xB6AA,0xF6AA,
 0x0AAA,0x4AAA,0x8AAA,0xCAAA,0x1AAA,0x5AAA,0x9AAA,0xDAAA,
 0x2AAA,0x6AAA,0xAAAA,0xEAAA,0x3AAA,0x7AAA,0xBAAA,0xFAAA,
 0x0EAA,0x4EAA,0x8EAA,0xCEAA,0x1EAA,0x5EAA,0x9EAA,0xDEAA,
 0x2EAA,0x6EAA,0xAEAA,0xEEAA,0x3EAA,0x7EAA,0xBEAA,0xFEAA,
 0x03AA,0x43AA,0x83AA,0xC3AA,0x13AA,0x53AA,0x93AA,0xD3AA,
 0x23AA,0x63AA,0xA3AA,0xE3AA,0x33AA,0x73AA,0xB3AA,0xF3AA,
 0x07AA,0x47AA,0x87AA,0xC7AA,0x17AA,0x57AA,0x97AA,0xD7AA,
 0x27AA,0x67AA,0xA7AA,0xE7AA,0x37AA,0x77AA,0xB7AA,0xF7AA,
 0x0BAA,0x4BAA,0x8BAA,0xCBAA,0x1BAA,0x5BAA,0x9BAA,0xDBAA,
 0x2BAA,0x6BAA,0xABAA,0xEBAA,0x3BAA,0x7BAA,0xBBAA,0xFBAA,
 0x0FAA,0x4FAA,0x8FAA,0xCFAA,0x1FAA,0x5FAA,0x9FAA,0xDFAA,
 0x2FAA,0x6FAA,0xAFAA,0xEFAA,0x3FAA,0x7FAA,0xBFAA,0xFFAA,
 0x00EA,0x40EA,0x80EA,0xC0EA,0x10EA,0x50EA,0x90EA,0xD0EA,
 0x20EA,0x60EA,0xA0EA,0xE0EA,0x30EA,0x70EA,0xB0EA,0xF0EA,
 0x04EA,0x44EA,0x84EA,0xC4EA,0x14EA,0x54EA,0x94EA,0xD4EA,
 0x24EA,0x64EA,0xA4EA,0xE4EA,0x34EA,0x74EA,0xB4EA,0xF4EA,
 0x08EA,0x48EA,0x88EA,0xC8EA,0x18EA,0x58EA,0x98EA,0xD8EA,
 0x28EA,0x68EA,0xA8EA,0xE8EA,0x38EA,0x78EA,0xB8EA,0xF8EA,
 0x0CEA,0x4CEA,0x8CEA,0xCCEA,0x1CEA,0x5CEA,0x9CEA,0xDCEA,
 0x2CEA,0x6CEA,0xACEA,0xECEA,0x3CEA,0x7CEA,0xBCEA,0xFCEA,
 0x01EA,0x41EA,0x81EA,0xC1EA,0x11EA,0x51EA,0x91EA,0xD1EA,
 0x21EA,0x61EA,0xA1EA,0xE1EA,0x31EA,0x71EA,0xB1EA,0xF1EA,
 0x05EA,0x45EA,0x85EA,0xC5EA,0x15EA,0x55EA,0x95EA,0xD5EA,
 0x25EA,0x65EA,0xA5EA,0xE5EA,0x35EA,0x75EA,0xB5EA,0xF5EA,
 0x09EA,0x49EA,0x89EA,0xC9EA,0x19EA,0x59EA,0x99EA,0xD9EA,
 0x29EA,0x69EA,0xA9EA,0xE9EA,0x39EA,0x79EA,0xB9EA,0xF9EA,
 0x0DEA,0x4DEA,0x8DEA,0xCDEA,0x1DEA,0x5DEA,0x9DEA,0xDDEA,
 0x2DEA,0x6DEA,0xADEA,0xEDEA,0x3DEA,0x7DEA,0xBDEA,0xFDEA,
 0x02EA,0x42EA,0x82EA,0xC2EA,0x12EA,0x52EA,0x92EA,0xD2EA,
 0x22EA,0x62EA,0xA2EA,0xE2EA,0x32EA,0x72EA,0xB2EA,0xF2EA,
 0x06EA,0x46EA,0x86EA,0xC6EA,0x16EA,0x56EA,0x96EA,0xD6EA,
 0x26EA,0x66EA,0xA6EA,0xE6EA,0x36EA,0x76EA,0xB6EA,0xF6EA,
 0x0AEA,0x4AEA,0x8AEA,0xCAEA,0x1AEA,0x5AEA,0x9AEA,0xDAEA,
 0x2AEA,0x6AEA,0xAAEA,0xEAEA,0x3AEA,0x7AEA,0xBAEA,0xFAEA,
 0x0EEA,0x4EEA,0x8EEA,0xCEEA,0x1EEA,0x5EEA,0x9EEA,0xDEEA,
 0x2EEA,0x6EEA,0xAEEA,0xEEEA,0x3EEA,0x7EEA,0xBEEA,0xFEEA,
 0x03EA,0x43EA,0x83EA,0xC3EA,0x13EA,0x53EA,0x93EA,0xD3EA,
 0x23EA,0x63EA,0xA3EA,0xE3EA,0x33EA,0x73EA,0xB3EA,0xF3EA,
 0x07EA,0x47EA,0x87EA,0xC7EA,0x17EA,0x57EA,0x97EA,0xD7EA,
 0x27EA,0x67EA,0xA7EA,0xE7EA,0x37EA,0x77EA,0xB7EA,0xF7EA,
 0x0BEA,0x4BEA,0x8BEA,0xCBEA,0x1BEA,0x5BEA,0x9BEA,0xDBEA,
 0x2BEA,0x6BEA,0xABEA,0xEBEA,0x3BEA,0x7BEA,0xBBEA,0xFBEA,
 0x0FEA,0x4FEA,0x8FEA,0xCFEA,0x1FEA,0x5FEA,0x9FEA,0xDFEA,
 0x2FEA,0x6FEA,0xAFEA,0xEFEA,0x3FEA,0x7FEA,0xBFEA,0xFFEA,
 0x003A,0x403A,0x803A,0xC03A,0x103A,0x503A,0x903A,0xD03A,
 0x203A,0x603A,0xA03A,0xE03A,0x303A,0x703A,0xB03A,0xF03A,
 0x043A,0x443A,0x843A,0xC43A,0x143A,0x543A,0x943A,0xD43A,
 0x243A,0x643A,0xA43A,0xE43A,0x343A,0x743A,0xB43A,0xF43A,
 0x083A,0x483A,0x883A,0xC83A,0x183A,0x583A,0x983A,0xD83A,
 0x283A,0x683A,0xA83A,0xE83A,0x383A,0x783A,0xB83A,0xF83A,
 0x0C3A,0x4C3A,0x8C3A,0xCC3A,0x1C3A,0x5C3A,0x9C3A,0xDC3A,
 0x2C3A,0x6C3A,0xAC3A,0xEC3A,0x3C3A,0x7C3A,0xBC3A,0xFC3A,
 0x013A,0x413A,0x813A,0xC13A,0x113A,0x513A,0x913A,0xD13A,
 0x213A,0x613A,0xA13A,0xE13A,0x313A,0x713A,0xB13A,0xF13A,
 0x053A,0x453A,0x853A,0xC53A,0x153A,0x553A,0x953A,0xD53A,
 0x253A,0x653A,0xA53A,0xE53A,0x353A,0x753A,0xB53A,0xF53A,
 0x093A,0x493A,0x893A,0xC93A,0x193A,0x593A,0x993A,0xD93A,
 0x293A,0x693A,0xA93A,0xE93A,0x393A,0x793A,0xB93A,0xF93A,
 0x0D3A,0x4D3A,0x8D3A,0xCD3A,0x1D3A,0x5D3A,0x9D3A,0xDD3A,
 0x2D3A,0x6D3A,0xAD3A,0xED3A,0x3D3A,0x7D3A,0xBD3A,0xFD3A,
 0x023A,0x423A,0x823A,0xC23A,0x123A,0x523A,0x923A,0xD23A,
 0x223A,0x623A,0xA23A,0xE23A,0x323A,0x723A,0xB23A,0xF23A,
 0x063A,0x463A,0x863A,0xC63A,0x163A,0x563A,0x963A,0xD63A,
 0x263A,0x663A,0xA63A,0xE63A,0x363A,0x763A,0xB63A,0xF63A,
 0x0A3A,0x4A3A,0x8A3A,0xCA3A,0x1A3A,0x5A3A,0x9A3A,0xDA3A,
 0x2A3A,0x6A3A,0xAA3A,0xEA3A,0x3A3A,0x7A3A,0xBA3A,0xFA3A,
 0x0E3A,0x4E3A,0x8E3A,0xCE3A,0x1E3A,0x5E3A,0x9E3A,0xDE3A,
 0x2E3A,0x6E3A,0xAE3A,0xEE3A,0x3E3A,0x7E3A,0xBE3A,0xFE3A,
 0x033A,0x433A,0x833A,0xC33A,0x133A,0x533A,0x933A,0xD33A,
 0x233A,0x633A,0xA33A,0xE33A,0x333A,0x733A,0xB33A,0xF33A,
 0x073A,0x473A,0x873A,0xC73A,0x173A,0x573A,0x973A,0xD73A,
 0x273A,0x673A,0xA73A,0xE73A,0x373A,0x773A,0xB73A,0xF73A,
 0x0B3A,0x4B3A,0x8B3A,0xCB3A,0x1B3A,0x5B3A,0x9B3A,0xDB3A,
 0x2B3A,0x6B3A,0xAB3A,0xEB3A,0x3B3A,0x7B3A,0xBB3A,0xFB3A,
 0x0F3A,0x4F3A,0x8F3A,0xCF3A,0x1F3A,0x5F3A,0x9F3A,0xDF3A,
 0x2F3A,0x6F3A,0xAF3A,0xEF3A,0x3F3A,0x7F3A,0xBF3A,0xFF3A,
 0x007A,0x407A,0x807A,0xC07A,0x107A,0x507A,0x907A,0xD07A,
 0x207A,0x607A,0xA07A,0xE07A,0x307A,0x707A,0xB07A,0xF07A,
 0x047A,0x447A,0x847A,0xC47A,0x147A,0x547A,0x947A,0xD47A,
 0x247A,0x647A,0xA47A,0xE47A,0x347A,0x747A,0xB47A,0xF47A,
 0x087A,0x487A,0x887A,0xC87A,0x187A,0x587A,0x987A,0xD87A,
 0x287A,0x687A,0xA87A,0xE87A,0x387A,0x787A,0xB87A,0xF87A,
 0x0C7A,0x4C7A,0x8C7A,0xCC7A,0x1C7A,0x5C7A,0x9C7A,0xDC7A,
 0x2C7A,0x6C7A,0xAC7A,0xEC7A,0x3C7A,0x7C7A,0xBC7A,0xFC7A,
 0x017A,0x417A,0x817A,0xC17A,0x117A,0x517A,0x917A,0xD17A,
 0x217A,0x617A,0xA17A,0xE17A,0x317A,0x717A,0xB17A,0xF17A,
 0x057A,0x457A,0x857A,0xC57A,0x157A,0x557A,0x957A,0xD57A,
 0x257A,0x657A,0xA57A,0xE57A,0x357A,0x757A,0xB57A,0xF57A,
 0x097A,0x497A,0x897A,0xC97A,0x197A,0x597A,0x997A,0xD97A,
 0x297A,0x697A,0xA97A,0xE97A,0x397A,0x797A,0xB97A,0xF97A,
 0x0D7A,0x4D7A,0x8D7A,0xCD7A,0x1D7A,0x5D7A,0x9D7A,0xDD7A,
 0x2D7A,0x6D7A,0xAD7A,0xED7A,0x3D7A,0x7D7A,0xBD7A,0xFD7A,
 0x027A,0x427A,0x827A,0xC27A,0x127A,0x527A,0x927A,0xD27A,
 0x227A,0x627A,0xA27A,0xE27A,0x327A,0x727A,0xB27A,0xF27A,
 0x067A,0x467A,0x867A,0xC67A,0x167A,0x567A,0x967A,0xD67A,
 0x267A,0x667A,0xA67A,0xE67A,0x367A,0x767A,0xB67A,0xF67A,
 0x0A7A,0x4A7A,0x8A7A,0xCA7A,0x1A7A,0x5A7A,0x9A7A,0xDA7A,
 0x2A7A,0x6A7A,0xAA7A,0xEA7A,0x3A7A,0x7A7A,0xBA7A,0xFA7A,
 0x0E7A,0x4E7A,0x8E7A,0xCE7A,0x1E7A,0x5E7A,0x9E7A,0xDE7A,
 0x2E7A,0x6E7A,0xAE7A,0xEE7A,0x3E7A,0x7E7A,0xBE7A,0xFE7A,
 0x037A,0x437A,0x837A,0xC37A,0x137A,0x537A,0x937A,0xD37A,
 0x237A,0x637A,0xA37A,0xE37A,0x337A,0x737A,0xB37A,0xF37A,
 0x077A,0x477A,0x877A,0xC77A,0x177A,0x577A,0x977A,0xD77A,
 0x277A,0x677A,0xA77A,0xE77A,0x377A,0x777A,0xB77A,0xF77A,
 0x0B7A,0x4B7A,0x8B7A,0xCB7A,0x1B7A,0x5B7A,0x9B7A,0xDB7A,
 0x2B7A,0x6B7A,0xAB7A,0xEB7A,0x3B7A,0x7B7A,0xBB7A,0xFB7A,
 0x0F7A,0x4F7A,0x8F7A,0xCF7A,0x1F7A,0x5F7A,0x9F7A,0xDF7A,
 0x2F7A,0x6F7A,0xAF7A,0xEF7A,0x3F7A,0x7F7A,0xBF7A,0xFF7A,
 0x00BA,0x40BA,0x80BA,0xC0BA,0x10BA,0x50BA,0x90BA,0xD0BA,
 0x20BA,0x60BA,0xA0BA,0xE0BA,0x30BA,0x70BA,0xB0BA,0xF0BA,
 0x04BA,0x44BA,0x84BA,0xC4BA,0x14BA,0x54BA,0x94BA,0xD4BA,
 0x24BA,0x64BA,0xA4BA,0xE4BA,0x34BA,0x74BA,0xB4BA,0xF4BA,
 0x08BA,0x48BA,0x88BA,0xC8BA,0x18BA,0x58BA,0x98BA,0xD8BA,
 0x28BA,0x68BA,0xA8BA,0xE8BA,0x38BA,0x78BA,0xB8BA,0xF8BA,
 0x0CBA,0x4CBA,0x8CBA,0xCCBA,0x1CBA,0x5CBA,0x9CBA,0xDCBA,
 0x2CBA,0x6CBA,0xACBA,0xECBA,0x3CBA,0x7CBA,0xBCBA,0xFCBA,
 0x01BA,0x41BA,0x81BA,0xC1BA,0x11BA,0x51BA,0x91BA,0xD1BA,
 0x21BA,0x61BA,0xA1BA,0xE1BA,0x31BA,0x71BA,0xB1BA,0xF1BA,
 0x05BA,0x45BA,0x85BA,0xC5BA,0x15BA,0x55BA,0x95BA,0xD5BA,
 0x25BA,0x65BA,0xA5BA,0xE5BA,0x35BA,0x75BA,0xB5BA,0xF5BA,
 0x09BA,0x49BA,0x89BA,0xC9BA,0x19BA,0x59BA,0x99BA,0xD9BA,
 0x29BA,0x69BA,0xA9BA,0xE9BA,0x39BA,0x79BA,0xB9BA,0xF9BA,
 0x0DBA,0x4DBA,0x8DBA,0xCDBA,0x1DBA,0x5DBA,0x9DBA,0xDDBA,
 0x2DBA,0x6DBA,0xADBA,0xEDBA,0x3DBA,0x7DBA,0xBDBA,0xFDBA,
 0x02BA,0x42BA,0x82BA,0xC2BA,0x12BA,0x52BA,0x92BA,0xD2BA,
 0x22BA,0x62BA,0xA2BA,0xE2BA,0x32BA,0x72BA,0xB2BA,0xF2BA,
 0x06BA,0x46BA,0x86BA,0xC6BA,0x16BA,0x56BA,0x96BA,0xD6BA,
 0x26BA,0x66BA,0xA6BA,0xE6BA,0x36BA,0x76BA,0xB6BA,0xF6BA,
 0x0ABA,0x4ABA,0x8ABA,0xCABA,0x1ABA,0x5ABA,0x9ABA,0xDABA,
 0x2ABA,0x6ABA,0xAABA,0xEABA,0x3ABA,0x7ABA,0xBABA,0xFABA,
 0x0EBA,0x4EBA,0x8EBA,0xCEBA,0x1EBA,0x5EBA,0x9EBA,0xDEBA,
 0x2EBA,0x6EBA,0xAEBA,0xEEBA,0x3EBA,0x7EBA,0xBEBA,0xFEBA,
 0x03BA,0x43BA,0x83BA,0xC3BA,0x13BA,0x53BA,0x93BA,0xD3BA,
 0x23BA,0x63BA,0xA3BA,0xE3BA,0x33BA,0x73BA,0xB3BA,0xF3BA,
 0x07BA,0x47BA,0x87BA,0xC7BA,0x17BA,0x57BA,0x97BA,0xD7BA,
 0x27BA,0x67BA,0xA7BA,0xE7BA,0x37BA,0x77BA,0xB7BA,0xF7BA,
 0x0BBA,0x4BBA,0x8BBA,0xCBBA,0x1BBA,0x5BBA,0x9BBA,0xDBBA,
 0x2BBA,0x6BBA,0xABBA,0xEBBA,0x3BBA,0x7BBA,0xBBBA,0xFBBA,
 0x0FBA,0x4FBA,0x8FBA,0xCFBA,0x1FBA,0x5FBA,0x9FBA,0xDFBA,
 0x2FBA,0x6FBA,0xAFBA,0xEFBA,0x3FBA,0x7FBA,0xBFBA,0xFFBA,
 0x00FA,0x40FA,0x80FA,0xC0FA,0x10FA,0x50FA,0x90FA,0xD0FA,
 0x20FA,0x60FA,0xA0FA,0xE0FA,0x30FA,0x70FA,0xB0FA,0xF0FA,
 0x04FA,0x44FA,0x84FA,0xC4FA,0x14FA,0x54FA,0x94FA,0xD4FA,
 0x24FA,0x64FA,0xA4FA,0xE4FA,0x34FA,0x74FA,0xB4FA,0xF4FA,
 0x08FA,0x48FA,0x88FA,0xC8FA,0x18FA,0x58FA,0x98FA,0xD8FA,
 0x28FA,0x68FA,0xA8FA,0xE8FA,0x38FA,0x78FA,0xB8FA,0xF8FA,
 0x0CFA,0x4CFA,0x8CFA,0xCCFA,0x1CFA,0x5CFA,0x9CFA,0xDCFA,
 0x2CFA,0x6CFA,0xACFA,0xECFA,0x3CFA,0x7CFA,0xBCFA,0xFCFA,
 0x01FA,0x41FA,0x81FA,0xC1FA,0x11FA,0x51FA,0x91FA,0xD1FA,
 0x21FA,0x61FA,0xA1FA,0xE1FA,0x31FA,0x71FA,0xB1FA,0xF1FA,
 0x05FA,0x45FA,0x85FA,0xC5FA,0x15FA,0x55FA,0x95FA,0xD5FA,
 0x25FA,0x65FA,0xA5FA,0xE5FA,0x35FA,0x75FA,0xB5FA,0xF5FA,
 0x09FA,0x49FA,0x89FA,0xC9FA,0x19FA,0x59FA,0x99FA,0xD9FA,
 0x29FA,0x69FA,0xA9FA,0xE9FA,0x39FA,0x79FA,0xB9FA,0xF9FA,
 0x0DFA,0x4DFA,0x8DFA,0xCDFA,0x1DFA,0x5DFA,0x9DFA,0xDDFA,
 0x2DFA,0x6DFA,0xADFA,0xEDFA,0x3DFA,0x7DFA,0xBDFA,0xFDFA,
 0x02FA,0x42FA,0x82FA,0xC2FA,0x12FA,0x52FA,0x92FA,0xD2FA,
 0x22FA,0x62FA,0xA2FA,0xE2FA,0x32FA,0x72FA,0xB2FA,0xF2FA,
 0x06FA,0x46FA,0x86FA,0xC6FA,0x16FA,0x56FA,0x96FA,0xD6FA,
 0x26FA,0x66FA,0xA6FA,0xE6FA,0x36FA,0x76FA,0xB6FA,0xF6FA,
 0x0AFA,0x4AFA,0x8AFA,0xCAFA,0x1AFA,0x5AFA,0x9AFA,0xDAFA,
 0x2AFA,0x6AFA,0xAAFA,0xEAFA,0x3AFA,0x7AFA,0xBAFA,0xFAFA,
 0x0EFA,0x4EFA,0x8EFA,0xCEFA,0x1EFA,0x5EFA,0x9EFA,0xDEFA,
 0x2EFA,0x6EFA,0xAEFA,0xEEFA,0x3EFA,0x7EFA,0xBEFA,0xFEFA,
 0x03FA,0x43FA,0x83FA,0xC3FA,0x13FA,0x53FA,0x93FA,0xD3FA,
 0x23FA,0x63FA,0xA3FA,0xE3FA,0x33FA,0x73FA,0xB3FA,0xF3FA,
 0x07FA,0x47FA,0x87FA,0xC7FA,0x17FA,0x57FA,0x97FA,0xD7FA,
 0x27FA,0x67FA,0xA7FA,0xE7FA,0x37FA,0x77FA,0xB7FA,0xF7FA,
 0x0BFA,0x4BFA,0x8BFA,0xCBFA,0x1BFA,0x5BFA,0x9BFA,0xDBFA,
 0x2BFA,0x6BFA,0xABFA,0xEBFA,0x3BFA,0x7BFA,0xBBFA,0xFBFA,
 0x0FFA,0x4FFA,0x8FFA,0xCFFA,0x1FFA,0x5FFA,0x9FFA,0xDFFA,
 0x2FFA,0x6FFA,0xAFFA,0xEFFA,0x3FFA,0x7FFA,0xBFFA,0xFFFA,
 0x000E,0x400E,0x800E,0xC00E,0x100E,0x500E,0x900E,0xD00E,
 0x200E,0x600E,0xA00E,0xE00E,0x300E,0x700E,0xB00E,0xF00E,
 0x040E,0x440E,0x840E,0xC40E,0x140E,0x540E,0x940E,0xD40E,
 0x240E,0x640E,0xA40E,0xE40E,0x340E,0x740E,0xB40E,0xF40E,
 0x080E,0x480E,0x880E,0xC80E,0x180E,0x580E,0x980E,0xD80E,
 0x280E,0x680E,0xA80E,0xE80E,0x380E,0x780E,0xB80E,0xF80E,
 0x0C0E,0x4C0E,0x8C0E,0xCC0E,0x1C0E,0x5C0E,0x9C0E,0xDC0E,
 0x2C0E,0x6C0E,0xAC0E,0xEC0E,0x3C0E,0x7C0E,0xBC0E,0xFC0E,
 0x010E,0x410E,0x810E,0xC10E,0x110E,0x510E,0x910E,0xD10E,
 0x210E,0x610E,0xA10E,0xE10E,0x310E,0x710E,0xB10E,0xF10E,
 0x050E,0x450E,0x850E,0xC50E,0x150E,0x550E,0x950E,0xD50E,
 0x250E,0x650E,0xA50E,0xE50E,0x350E,0x750E,0xB50E,0xF50E,
 0x090E,0x490E,0x890E,0xC90E,0x190E,0x590E,0x990E,0xD90E,
 0x290E,0x690E,0xA90E,0xE90E,0x390E,0x790E,0xB90E,0xF90E,
 0x0D0E,0x4D0E,0x8D0E,0xCD0E,0x1D0E,0x5D0E,0x9D0E,0xDD0E,
 0x2D0E,0x6D0E,0xAD0E,0xED0E,0x3D0E,0x7D0E,0xBD0E,0xFD0E,
 0x020E,0x420E,0x820E,0xC20E,0x120E,0x520E,0x920E,0xD20E,
 0x220E,0x620E,0xA20E,0xE20E,0x320E,0x720E,0xB20E,0xF20E,
 0x060E,0x460E,0x860E,0xC60E,0x160E,0x560E,0x960E,0xD60E,
 0x260E,0x660E,0xA60E,0xE60E,0x360E,0x760E,0xB60E,0xF60E,
 0x0A0E,0x4A0E,0x8A0E,0xCA0E,0x1A0E,0x5A0E,0x9A0E,0xDA0E,
 0x2A0E,0x6A0E,0xAA0E,0xEA0E,0x3A0E,0x7A0E,0xBA0E,0xFA0E,
 0x0E0E,0x4E0E,0x8E0E,0xCE0E,0x1E0E,0x5E0E,0x9E0E,0xDE0E,
 0x2E0E,0x6E0E,0xAE0E,0xEE0E,0x3E0E,0x7E0E,0xBE0E,0xFE0E,
 0x030E,0x430E,0x830E,0xC30E,0x130E,0x530E,0x930E,0xD30E,
 0x230E,0x630E,0xA30E,0xE30E,0x330E,0x730E,0xB30E,0xF30E,
 0x070E,0x470E,0x870E,0xC70E,0x170E,0x570E,0x970E,0xD70E,
 0x270E,0x670E,0xA70E,0xE70E,0x370E,0x770E,0xB70E,0xF70E,
 0x0B0E,0x4B0E,0x8B0E,0xCB0E,0x1B0E,0x5B0E,0x9B0E,0xDB0E,
 0x2B0E,0x6B0E,0xAB0E,0xEB0E,0x3B0E,0x7B0E,0xBB0E,0xFB0E,
 0x0F0E,0x4F0E,0x8F0E,0xCF0E,0x1F0E,0x5F0E,0x9F0E,0xDF0E,
 0x2F0E,0x6F0E,0xAF0E,0xEF0E,0x3F0E,0x7F0E,0xBF0E,0xFF0E,
 0x004E,0x404E,0x804E,0xC04E,0x104E,0x504E,0x904E,0xD04E,
 0x204E,0x604E,0xA04E,0xE04E,0x304E,0x704E,0xB04E,0xF04E,
 0x044E,0x444E,0x844E,0xC44E,0x144E,0x544E,0x944E,0xD44E,
 0x244E,0x644E,0xA44E,0xE44E,0x344E,0x744E,0xB44E,0xF44E,
 0x084E,0x484E,0x884E,0xC84E,0x184E,0x584E,0x984E,0xD84E,
 0x284E,0x684E,0xA84E,0xE84E,0x384E,0x784E,0xB84E,0xF84E,
 0x0C4E,0x4C4E,0x8C4E,0xCC4E,0x1C4E,0x5C4E,0x9C4E,0xDC4E,
 0x2C4E,0x6C4E,0xAC4E,0xEC4E,0x3C4E,0x7C4E,0xBC4E,0xFC4E,
 0x014E,0x414E,0x814E,0xC14E,0x114E,0x514E,0x914E,0xD14E,
 0x214E,0x614E,0xA14E,0xE14E,0x314E,0x714E,0xB14E,0xF14E,
 0x054E,0x454E,0x854E,0xC54E,0x154E,0x554E,0x954E,0xD54E,
 0x254E,0x654E,0xA54E,0xE54E,0x354E,0x754E,0xB54E,0xF54E,
 0x094E,0x494E,0x894E,0xC94E,0x194E,0x594E,0x994E,0xD94E,
 0x294E,0x694E,0xA94E,0xE94E,0x394E,0x794E,0xB94E,0xF94E,
 0x0D4E,0x4D4E,0x8D4E,0xCD4E,0x1D4E,0x5D4E,0x9D4E,0xDD4E,
 0x2D4E,0x6D4E,0xAD4E,0xED4E,0x3D4E,0x7D4E,0xBD4E,0xFD4E,
 0x024E,0x424E,0x824E,0xC24E,0x124E,0x524E,0x924E,0xD24E,
 0x224E,0x624E,0xA24E,0xE24E,0x324E,0x724E,0xB24E,0xF24E,
 0x064E,0x464E,0x864E,0xC64E,0x164E,0x564E,0x964E,0xD64E,
 0x264E,0x664E,0xA64E,0xE64E,0x364E,0x764E,0xB64E,0xF64E,
 0x0A4E,0x4A4E,0x8A4E,0xCA4E,0x1A4E,0x5A4E,0x9A4E,0xDA4E,
 0x2A4E,0x6A4E,0xAA4E,0xEA4E,0x3A4E,0x7A4E,0xBA4E,0xFA4E,
 0x0E4E,0x4E4E,0x8E4E,0xCE4E,0x1E4E,0x5E4E,0x9E4E,0xDE4E,
 0x2E4E,0x6E4E,0xAE4E,0xEE4E,0x3E4E,0x7E4E,0xBE4E,0xFE4E,
 0x034E,0x434E,0x834E,0xC34E,0x134E,0x534E,0x934E,0xD34E,
 0x234E,0x634E,0xA34E,0xE34E,0x334E,0x734E,0xB34E,0xF34E,
 0x074E,0x474E,0x874E,0xC74E,0x174E,0x574E,0x974E,0xD74E,
 0x274E,0x674E,0xA74E,0xE74E,0x374E,0x774E,0xB74E,0xF74E,
 0x0B4E,0x4B4E,0x8B4E,0xCB4E,0x1B4E,0x5B4E,0x9B4E,0xDB4E,
 0x2B4E,0x6B4E,0xAB4E,0xEB4E,0x3B4E,0x7B4E,0xBB4E,0xFB4E,
 0x0F4E,0x4F4E,0x8F4E,0xCF4E,0x1F4E,0x5F4E,0x9F4E,0xDF4E,
 0x2F4E,0x6F4E,0xAF4E,0xEF4E,0x3F4E,0x7F4E,0xBF4E,0xFF4E,
 0x008E,0x408E,0x808E,0xC08E,0x108E,0x508E,0x908E,0xD08E,
 0x208E,0x608E,0xA08E,0xE08E,0x308E,0x708E,0xB08E,0xF08E,
 0x048E,0x448E,0x848E,0xC48E,0x148E,0x548E,0x948E,0xD48E,
 0x248E,0x648E,0xA48E,0xE48E,0x348E,0x748E,0xB48E,0xF48E,
 0x088E,0x488E,0x888E,0xC88E,0x188E,0x588E,0x988E,0xD88E,
 0x288E,0x688E,0xA88E,0xE88E,0x388E,0x788E,0xB88E,0xF88E,
 0x0C8E,0x4C8E,0x8C8E,0xCC8E,0x1C8E,0x5C8E,0x9C8E,0xDC8E,
 0x2C8E,0x6C8E,0xAC8E,0xEC8E,0x3C8E,0x7C8E,0xBC8E,0xFC8E,
 0x018E,0x418E,0x818E,0xC18E,0x118E,0x518E,0x918E,0xD18E,
 0x218E,0x618E,0xA18E,0xE18E,0x318E,0x718E,0xB18E,0xF18E,
 0x058E,0x458E,0x858E,0xC58E,0x158E,0x558E,0x958E,0xD58E,
 0x258E,0x658E,0xA58E,0xE58E,0x358E,0x758E,0xB58E,0xF58E,
 0x098E,0x498E,0x898E,0xC98E,0x198E,0x598E,0x998E,0xD98E,
 0x298E,0x698E,0xA98E,0xE98E,0x398E,0x798E,0xB98E,0xF98E,
 0x0D8E,0x4D8E,0x8D8E,0xCD8E,0x1D8E,0x5D8E,0x9D8E,0xDD8E,
 0x2D8E,0x6D8E,0xAD8E,0xED8E,0x3D8E,0x7D8E,0xBD8E,0xFD8E,
 0x028E,0x428E,0x828E,0xC28E,0x128E,0x528E,0x928E,0xD28E,
 0x228E,0x628E,0xA28E,0xE28E,0x328E,0x728E,0xB28E,0xF28E,
 0x068E,0x468E,0x868E,0xC68E,0x168E,0x568E,0x968E,0xD68E,
 0x268E,0x668E,0xA68E,0xE68E,0x368E,0x768E,0xB68E,0xF68E,
 0x0A8E,0x4A8E,0x8A8E,0xCA8E,0x1A8E,0x5A8E,0x9A8E,0xDA8E,
 0x2A8E,0x6A8E,0xAA8E,0xEA8E,0x3A8E,0x7A8E,0xBA8E,0xFA8E,
 0x0E8E,0x4E8E,0x8E8E,0xCE8E,0x1E8E,0x5E8E,0x9E8E,0xDE8E,
 0x2E8E,0x6E8E,0xAE8E,0xEE8E,0x3E8E,0x7E8E,0xBE8E,0xFE8E,
 0x038E,0x438E,0x838E,0xC38E,0x138E,0x538E,0x938E,0xD38E,
 0x238E,0x638E,0xA38E,0xE38E,0x338E,0x738E,0xB38E,0xF38E,
 0x078E,0x478E,0x878E,0xC78E,0x178E,0x578E,0x978E,0xD78E,
 0x278E,0x678E,0xA78E,0xE78E,0x378E,0x778E,0xB78E,0xF78E,
 0x0B8E,0x4B8E,0x8B8E,0xCB8E,0x1B8E,0x5B8E,0x9B8E,0xDB8E,
 0x2B8E,0x6B8E,0xAB8E,0xEB8E,0x3B8E,0x7B8E,0xBB8E,0xFB8E,
 0x0F8E,0x4F8E,0x8F8E,0xCF8E,0x1F8E,0x5F8E,0x9F8E,0xDF8E,
 0x2F8E,0x6F8E,0xAF8E,0xEF8E,0x3F8E,0x7F8E,0xBF8E,0xFF8E,
 0x00CE,0x40CE,0x80CE,0xC0CE,0x10CE,0x50CE,0x90CE,0xD0CE,
 0x20CE,0x60CE,0xA0CE,0xE0CE,0x30CE,0x70CE,0xB0CE,0xF0CE,
 0x04CE,0x44CE,0x84CE,0xC4CE,0x14CE,0x54CE,0x94CE,0xD4CE,
 0x24CE,0x64CE,0xA4CE,0xE4CE,0x34CE,0x74CE,0xB4CE,0xF4CE,
 0x08CE,0x48CE,0x88CE,0xC8CE,0x18CE,0x58CE,0x98CE,0xD8CE,
 0x28CE,0x68CE,0xA8CE,0xE8CE,0x38CE,0x78CE,0xB8CE,0xF8CE,
 0x0CCE,0x4CCE,0x8CCE,0xCCCE,0x1CCE,0x5CCE,0x9CCE,0xDCCE,
 0x2CCE,0x6CCE,0xACCE,0xECCE,0x3CCE,0x7CCE,0xBCCE,0xFCCE,
 0x01CE,0x41CE,0x81CE,0xC1CE,0x11CE,0x51CE,0x91CE,0xD1CE,
 0x21CE,0x61CE,0xA1CE,0xE1CE,0x31CE,0x71CE,0xB1CE,0xF1CE,
 0x05CE,0x45CE,0x85CE,0xC5CE,0x15CE,0x55CE,0x95CE,0xD5CE,
 0x25CE,0x65CE,0xA5CE,0xE5CE,0x35CE,0x75CE,0xB5CE,0xF5CE,
 0x09CE,0x49CE,0x89CE,0xC9CE,0x19CE,0x59CE,0x99CE,0xD9CE,
 0x29CE,0x69CE,0xA9CE,0xE9CE,0x39CE,0x79CE,0xB9CE,0xF9CE,
 0x0DCE,0x4DCE,0x8DCE,0xCDCE,0x1DCE,0x5DCE,0x9DCE,0xDDCE,
 0x2DCE,0x6DCE,0xADCE,0xEDCE,0x3DCE,0x7DCE,0xBDCE,0xFDCE,
 0x02CE,0x42CE,0x82CE,0xC2CE,0x12CE,0x52CE,0x92CE,0xD2CE,
 0x22CE,0x62CE,0xA2CE,0xE2CE,0x32CE,0x72CE,0xB2CE,0xF2CE,
 0x06CE,0x46CE,0x86CE,0xC6CE,0x16CE,0x56CE,0x96CE,0xD6CE,
 0x26CE,0x66CE,0xA6CE,0xE6CE,0x36CE,0x76CE,0xB6CE,0xF6CE,
 0x0ACE,0x4ACE,0x8ACE,0xCACE,0x1ACE,0x5ACE,0x9ACE,0xDACE,
 0x2ACE,0x6ACE,0xAACE,0xEACE,0x3ACE,0x7ACE,0xBACE,0xFACE,
 0x0ECE,0x4ECE,0x8ECE,0xCECE,0x1ECE,0x5ECE,0x9ECE,0xDECE,
 0x2ECE,0x6ECE,0xAECE,0xEECE,0x3ECE,0x7ECE,0xBECE,0xFECE,
 0x03CE,0x43CE,0x83CE,0xC3CE,0x13CE,0x53CE,0x93CE,0xD3CE,
 0x23CE,0x63CE,0xA3CE,0xE3CE,0x33CE,0x73CE,0xB3CE,0xF3CE,
 0x07CE,0x47CE,0x87CE,0xC7CE,0x17CE,0x57CE,0x97CE,0xD7CE,
 0x27CE,0x67CE,0xA7CE,0xE7CE,0x37CE,0x77CE,0xB7CE,0xF7CE,
 0x0BCE,0x4BCE,0x8BCE,0xCBCE,0x1BCE,0x5BCE,0x9BCE,0xDBCE,
 0x2BCE,0x6BCE,0xABCE,0xEBCE,0x3BCE,0x7BCE,0xBBCE,0xFBCE,
 0x0FCE,0x4FCE,0x8FCE,0xCFCE,0x1FCE,0x5FCE,0x9FCE,0xDFCE,
 0x2FCE,0x6FCE,0xAFCE,0xEFCE,0x3FCE,0x7FCE,0xBFCE,0xFFCE,
 0x001E,0x401E,0x801E,0xC01E,0x101E,0x501E,0x901E,0xD01E,
 0x201E,0x601E,0xA01E,0xE01E,0x301E,0x701E,0xB01E,0xF01E,
 0x041E,0x441E,0x841E,0xC41E,0x141E,0x541E,0x941E,0xD41E,
 0x241E,0x641E,0xA41E,0xE41E,0x341E,0x741E,0xB41E,0xF41E,
 0x081E,0x481E,0x881E,0xC81E,0x181E,0x581E,0x981E,0xD81E,
 0x281E,0x681E,0xA81E,0xE81E,0x381E,0x781E,0xB81E,0xF81E,
 0x0C1E,0x4C1E,0x8C1E,0xCC1E,0x1C1E,0x5C1E,0x9C1E,0xDC1E,
 0x2C1E,0x6C1E,0xAC1E,0xEC1E,0x3C1E,0x7C1E,0xBC1E,0xFC1E,
 0x011E,0x411E,0x811E,0xC11E,0x111E,0x511E,0x911E,0xD11E,
 0x211E,0x611E,0xA11E,0xE11E,0x311E,0x711E,0xB11E,0xF11E,
 0x051E,0x451E,0x851E,0xC51E,0x151E,0x551E,0x951E,0xD51E,
 0x251E,0x651E,0xA51E,0xE51E,0x351E,0x751E,0xB51E,0xF51E,
 0x091E,0x491E,0x891E,0xC91E,0x191E,0x591E,0x991E,0xD91E,
 0x291E,0x691E,0xA91E,0xE91E,0x391E,0x791E,0xB91E,0xF91E,
 0x0D1E,0x4D1E,0x8D1E,0xCD1E,0x1D1E,0x5D1E,0x9D1E,0xDD1E,
 0x2D1E,0x6D1E,0xAD1E,0xED1E,0x3D1E,0x7D1E,0xBD1E,0xFD1E,
 0x021E,0x421E,0x821E,0xC21E,0x121E,0x521E,0x921E,0xD21E,
 0x221E,0x621E,0xA21E,0xE21E,0x321E,0x721E,0xB21E,0xF21E,
 0x061E,0x461E,0x861E,0xC61E,0x161E,0x561E,0x961E,0xD61E,
 0x261E,0x661E,0xA61E,0xE61E,0x361E,0x761E,0xB61E,0xF61E,
 0x0A1E,0x4A1E,0x8A1E,0xCA1E,0x1A1E,0x5A1E,0x9A1E,0xDA1E,
 0x2A1E,0x6A1E,0xAA1E,0xEA1E,0x3A1E,0x7A1E,0xBA1E,0xFA1E,
 0x0E1E,0x4E1E,0x8E1E,0xCE1E,0x1E1E,0x5E1E,0x9E1E,0xDE1E,
 0x2E1E,0x6E1E,0xAE1E,0xEE1E,0x3E1E,0x7E1E,0xBE1E,0xFE1E,
 0x031E,0x431E,0x831E,0xC31E,0x131E,0x531E,0x931E,0xD31E,
 0x231E,0x631E,0xA31E,0xE31E,0x331E,0x731E,0xB31E,0xF31E,
 0x071E,0x471E,0x871E,0xC71E,0x171E,0x571E,0x971E,0xD71E,
 0x271E,0x671E,0xA71E,0xE71E,0x371E,0x771E,0xB71E,0xF71E,
 0x0B1E,0x4B1E,0x8B1E,0xCB1E,0x1B1E,0x5B1E,0x9B1E,0xDB1E,
 0x2B1E,0x6B1E,0xAB1E,0xEB1E,0x3B1E,0x7B1E,0xBB1E,0xFB1E,
 0x0F1E,0x4F1E,0x8F1E,0xCF1E,0x1F1E,0x5F1E,0x9F1E,0xDF1E,
 0x2F1E,0x6F1E,0xAF1E,0xEF1E,0x3F1E,0x7F1E,0xBF1E,0xFF1E,
 0x005E,0x405E,0x805E,0xC05E,0x105E,0x505E,0x905E,0xD05E,
 0x205E,0x605E,0xA05E,0xE05E,0x305E,0x705E,0xB05E,0xF05E,
 0x045E,0x445E,0x845E,0xC45E,0x145E,0x545E,0x945E,0xD45E,
 0x245E,0x645E,0xA45E,0xE45E,0x345E,0x745E,0xB45E,0xF45E,
 0x085E,0x485E,0x885E,0xC85E,0x185E,0x585E,0x985E,0xD85E,
 0x285E,0x685E,0xA85E,0xE85E,0x385E,0x785E,0xB85E,0xF85E,
 0x0C5E,0x4C5E,0x8C5E,0xCC5E,0x1C5E,0x5C5E,0x9C5E,0xDC5E,
 0x2C5E,0x6C5E,0xAC5E,0xEC5E,0x3C5E,0x7C5E,0xBC5E,0xFC5E,
 0x015E,0x415E,0x815E,0xC15E,0x115E,0x515E,0x915E,0xD15E,
 0x215E,0x615E,0xA15E,0xE15E,0x315E,0x715E,0xB15E,0xF15E,
 0x055E,0x455E,0x855E,0xC55E,0x155E,0x555E,0x955E,0xD55E,
 0x255E,0x655E,0xA55E,0xE55E,0x355E,0x755E,0xB55E,0xF55E,
 0x095E,0x495E,0x895E,0xC95E,0x195E,0x595E,0x995E,0xD95E,
 0x295E,0x695E,0xA95E,0xE95E,0x395E,0x795E,0xB95E,0xF95E,
 0x0D5E,0x4D5E,0x8D5E,0xCD5E,0x1D5E,0x5D5E,0x9D5E,0xDD5E,
 0x2D5E,0x6D5E,0xAD5E,0xED5E,0x3D5E,0x7D5E,0xBD5E,0xFD5E,
 0x025E,0x425E,0x825E,0xC25E,0x125E,0x525E,0x925E,0xD25E,
 0x225E,0x625E,0xA25E,0xE25E,0x325E,0x725E,0xB25E,0xF25E,
 0x065E,0x465E,0x865E,0xC65E,0x165E,0x565E,0x965E,0xD65E,
 0x265E,0x665E,0xA65E,0xE65E,0x365E,0x765E,0xB65E,0xF65E,
 0x0A5E,0x4A5E,0x8A5E,0xCA5E,0x1A5E,0x5A5E,0x9A5E,0xDA5E,
 0x2A5E,0x6A5E,0xAA5E,0xEA5E,0x3A5E,0x7A5E,0xBA5E,0xFA5E,
 0x0E5E,0x4E5E,0x8E5E,0xCE5E,0x1E5E,0x5E5E,0x9E5E,0xDE5E,
 0x2E5E,0x6E5E,0xAE5E,0xEE5E,0x3E5E,0x7E5E,0xBE5E,0xFE5E,
 0x035E,0x435E,0x835E,0xC35E,0x135E,0x535E,0x935E,0xD35E,
 0x235E,0x635E,0xA35E,0xE35E,0x335E,0x735E,0xB35E,0xF35E,
 0x075E,0x475E,0x875E,0xC75E,0x175E,0x575E,0x975E,0xD75E,
 0x275E,0x675E,0xA75E,0xE75E,0x375E,0x775E,0xB75E,0xF75E,
 0x0B5E,0x4B5E,0x8B5E,0xCB5E,0x1B5E,0x5B5E,0x9B5E,0xDB5E,
 0x2B5E,0x6B5E,0xAB5E,0xEB5E,0x3B5E,0x7B5E,0xBB5E,0xFB5E,
 0x0F5E,0x4F5E,0x8F5E,0xCF5E,0x1F5E,0x5F5E,0x9F5E,0xDF5E,
 0x2F5E,0x6F5E,0xAF5E,0xEF5E,0x3F5E,0x7F5E,0xBF5E,0xFF5E,
 0x009E,0x409E,0x809E,0xC09E,0x109E,0x509E,0x909E,0xD09E,
 0x209E,0x609E,0xA09E,0xE09E,0x309E,0x709E,0xB09E,0xF09E,
 0x049E,0x449E,0x849E,0xC49E,0x149E,0x549E,0x949E,0xD49E,
 0x249E,0x649E,0xA49E,0xE49E,0x349E,0x749E,0xB49E,0xF49E,
 0x089E,0x489E,0x889E,0xC89E,0x189E,0x589E,0x989E,0xD89E,
 0x289E,0x689E,0xA89E,0xE89E,0x389E,0x789E,0xB89E,0xF89E,
 0x0C9E,0x4C9E,0x8C9E,0xCC9E,0x1C9E,0x5C9E,0x9C9E,0xDC9E,
 0x2C9E,0x6C9E,0xAC9E,0xEC9E,0x3C9E,0x7C9E,0xBC9E,0xFC9E,
 0x019E,0x419E,0x819E,0xC19E,0x119E,0x519E,0x919E,0xD19E,
 0x219E,0x619E,0xA19E,0xE19E,0x319E,0x719E,0xB19E,0xF19E,
 0x059E,0x459E,0x859E,0xC59E,0x159E,0x559E,0x959E,0xD59E,
 0x259E,0x659E,0xA59E,0xE59E,0x359E,0x759E,0xB59E,0xF59E,
 0x099E,0x499E,0x899E,0xC99E,0x199E,0x599E,0x999E,0xD99E,
 0x299E,0x699E,0xA99E,0xE99E,0x399E,0x799E,0xB99E,0xF99E,
 0x0D9E,0x4D9E,0x8D9E,0xCD9E,0x1D9E,0x5D9E,0x9D9E,0xDD9E,
 0x2D9E,0x6D9E,0xAD9E,0xED9E,0x3D9E,0x7D9E,0xBD9E,0xFD9E,
 0x029E,0x429E,0x829E,0xC29E,0x129E,0x529E,0x929E,0xD29E,
 0x229E,0x629E,0xA29E,0xE29E,0x329E,0x729E,0xB29E,0xF29E,
 0x069E,0x469E,0x869E,0xC69E,0x169E,0x569E,0x969E,0xD69E,
 0x269E,0x669E,0xA69E,0xE69E,0x369E,0x769E,0xB69E,0xF69E,
 0x0A9E,0x4A9E,0x8A9E,0xCA9E,0x1A9E,0x5A9E,0x9A9E,0xDA9E,
 0x2A9E,0x6A9E,0xAA9E,0xEA9E,0x3A9E,0x7A9E,0xBA9E,0xFA9E,
 0x0E9E,0x4E9E,0x8E9E,0xCE9E,0x1E9E,0x5E9E,0x9E9E,0xDE9E,
 0x2E9E,0x6E9E,0xAE9E,0xEE9E,0x3E9E,0x7E9E,0xBE9E,0xFE9E,
 0x039E,0x439E,0x839E,0xC39E,0x139E,0x539E,0x939E,0xD39E,
 0x239E,0x639E,0xA39E,0xE39E,0x339E,0x739E,0xB39E,0xF39E,
 0x079E,0x479E,0x879E,0xC79E,0x179E,0x579E,0x979E,0xD79E,
 0x279E,0x679E,0xA79E,0xE79E,0x379E,0x779E,0xB79E,0xF79E,
 0x0B9E,0x4B9E,0x8B9E,0xCB9E,0x1B9E,0x5B9E,0x9B9E,0xDB9E,
 0x2B9E,0x6B9E,0xAB9E,0xEB9E,0x3B9E,0x7B9E,0xBB9E,0xFB9E,
 0x0F9E,0x4F9E,0x8F9E,0xCF9E,0x1F9E,0x5F9E,0x9F9E,0xDF9E,
 0x2F9E,0x6F9E,0xAF9E,0xEF9E,0x3F9E,0x7F9E,0xBF9E,0xFF9E,
 0x00DE,0x40DE,0x80DE,0xC0DE,0x10DE,0x50DE,0x90DE,0xD0DE,
 0x20DE,0x60DE,0xA0DE,0xE0DE,0x30DE,0x70DE,0xB0DE,0xF0DE,
 0x04DE,0x44DE,0x84DE,0xC4DE,0x14DE,0x54DE,0x94DE,0xD4DE,
 0x24DE,0x64DE,0xA4DE,0xE4DE,0x34DE,0x74DE,0xB4DE,0xF4DE,
 0x08DE,0x48DE,0x88DE,0xC8DE,0x18DE,0x58DE,0x98DE,0xD8DE,
 0x28DE,0x68DE,0xA8DE,0xE8DE,0x38DE,0x78DE,0xB8DE,0xF8DE,
 0x0CDE,0x4CDE,0x8CDE,0xCCDE,0x1CDE,0x5CDE,0x9CDE,0xDCDE,
 0x2CDE,0x6CDE,0xACDE,0xECDE,0x3CDE,0x7CDE,0xBCDE,0xFCDE,
 0x01DE,0x41DE,0x81DE,0xC1DE,0x11DE,0x51DE,0x91DE,0xD1DE,
 0x21DE,0x61DE,0xA1DE,0xE1DE,0x31DE,0x71DE,0xB1DE,0xF1DE,
 0x05DE,0x45DE,0x85DE,0xC5DE,0x15DE,0x55DE,0x95DE,0xD5DE,
 0x25DE,0x65DE,0xA5DE,0xE5DE,0x35DE,0x75DE,0xB5DE,0xF5DE,
 0x09DE,0x49DE,0x89DE,0xC9DE,0x19DE,0x59DE,0x99DE,0xD9DE,
 0x29DE,0x69DE,0xA9DE,0xE9DE,0x39DE,0x79DE,0xB9DE,0xF9DE,
 0x0DDE,0x4DDE,0x8DDE,0xCDDE,0x1DDE,0x5DDE,0x9DDE,0xDDDE,
 0x2DDE,0x6DDE,0xADDE,0xEDDE,0x3DDE,0x7DDE,0xBDDE,0xFDDE,
 0x02DE,0x42DE,0x82DE,0xC2DE,0x12DE,0x52DE,0x92DE,0xD2DE,
 0x22DE,0x62DE,0xA2DE,0xE2DE,0x32DE,0x72DE,0xB2DE,0xF2DE,
 0x06DE,0x46DE,0x86DE,0xC6DE,0x16DE,0x56DE,0x96DE,0xD6DE,
 0x26DE,0x66DE,0xA6DE,0xE6DE,0x36DE,0x76DE,0xB6DE,0xF6DE,
 0x0ADE,0x4ADE,0x8ADE,0xCADE,0x1ADE,0x5ADE,0x9ADE,0xDADE,
 0x2ADE,0x6ADE,0xAADE,0xEADE,0x3ADE,0x7ADE,0xBADE,0xFADE,
 0x0EDE,0x4EDE,0x8EDE,0xCEDE,0x1EDE,0x5EDE,0x9EDE,0xDEDE,
 0x2EDE,0x6EDE,0xAEDE,0xEEDE,0x3EDE,0x7EDE,0xBEDE,0xFEDE,
 0x03DE,0x43DE,0x83DE,0xC3DE,0x13DE,0x53DE,0x93DE,0xD3DE,
 0x23DE,0x63DE,0xA3DE,0xE3DE,0x33DE,0x73DE,0xB3DE,0xF3DE,
 0x07DE,0x47DE,0x87DE,0xC7DE,0x17DE,0x57DE,0x97DE,0xD7DE,
 0x27DE,0x67DE,0xA7DE,0xE7DE,0x37DE,0x77DE,0xB7DE,0xF7DE,
 0x0BDE,0x4BDE,0x8BDE,0xCBDE,0x1BDE,0x5BDE,0x9BDE,0xDBDE,
 0x2BDE,0x6BDE,0xABDE,0xEBDE,0x3BDE,0x7BDE,0xBBDE,0xFBDE,
 0x0FDE,0x4FDE,0x8FDE,0xCFDE,0x1FDE,0x5FDE,0x9FDE,0xDFDE,
 0x2FDE,0x6FDE,0xAFDE,0xEFDE,0x3FDE,0x7FDE,0xBFDE,0xFFDE,
 0x002E,0x402E,0x802E,0xC02E,0x102E,0x502E,0x902E,0xD02E,
 0x202E,0x602E,0xA02E,0xE02E,0x302E,0x702E,0xB02E,0xF02E,
 0x042E,0x442E,0x842E,0xC42E,0x142E,0x542E,0x942E,0xD42E,
 0x242E,0x642E,0xA42E,0xE42E,0x342E,0x742E,0xB42E,0xF42E,
 0x082E,0x482E,0x882E,0xC82E,0x182E,0x582E,0x982E,0xD82E,
 0x282E,0x682E,0xA82E,0xE82E,0x382E,0x782E,0xB82E,0xF82E,
 0x0C2E,0x4C2E,0x8C2E,0xCC2E,0x1C2E,0x5C2E,0x9C2E,0xDC2E,
 0x2C2E,0x6C2E,0xAC2E,0xEC2E,0x3C2E,0x7C2E,0xBC2E,0xFC2E,
 0x012E,0x412E,0x812E,0xC12E,0x112E,0x512E,0x912E,0xD12E,
 0x212E,0x612E,0xA12E,0xE12E,0x312E,0x712E,0xB12E,0xF12E,
 0x052E,0x452E,0x852E,0xC52E,0x152E,0x552E,0x952E,0xD52E,
 0x252E,0x652E,0xA52E,0xE52E,0x352E,0x752E,0xB52E,0xF52E,
 0x092E,0x492E,0x892E,0xC92E,0x192E,0x592E,0x992E,0xD92E,
 0x292E,0x692E,0xA92E,0xE92E,0x392E,0x792E,0xB92E,0xF92E,
 0x0D2E,0x4D2E,0x8D2E,0xCD2E,0x1D2E,0x5D2E,0x9D2E,0xDD2E,
 0x2D2E,0x6D2E,0xAD2E,0xED2E,0x3D2E,0x7D2E,0xBD2E,0xFD2E,
 0x022E,0x422E,0x822E,0xC22E,0x122E,0x522E,0x922E,0xD22E,
 0x222E,0x622E,0xA22E,0xE22E,0x322E,0x722E,0xB22E,0xF22E,
 0x062E,0x462E,0x862E,0xC62E,0x162E,0x562E,0x962E,0xD62E,
 0x262E,0x662E,0xA62E,0xE62E,0x362E,0x762E,0xB62E,0xF62E,
 0x0A2E,0x4A2E,0x8A2E,0xCA2E,0x1A2E,0x5A2E,0x9A2E,0xDA2E,
 0x2A2E,0x6A2E,0xAA2E,0xEA2E,0x3A2E,0x7A2E,0xBA2E,0xFA2E,
 0x0E2E,0x4E2E,0x8E2E,0xCE2E,0x1E2E,0x5E2E,0x9E2E,0xDE2E,
 0x2E2E,0x6E2E,0xAE2E,0xEE2E,0x3E2E,0x7E2E,0xBE2E,0xFE2E,
 0x032E,0x432E,0x832E,0xC32E,0x132E,0x532E,0x932E,0xD32E,
 0x232E,0x632E,0xA32E,0xE32E,0x332E,0x732E,0xB32E,0xF32E,
 0x072E,0x472E,0x872E,0xC72E,0x172E,0x572E,0x972E,0xD72E,
 0x272E,0x672E,0xA72E,0xE72E,0x372E,0x772E,0xB72E,0xF72E,
 0x0B2E,0x4B2E,0x8B2E,0xCB2E,0x1B2E,0x5B2E,0x9B2E,0xDB2E,
 0x2B2E,0x6B2E,0xAB2E,0xEB2E,0x3B2E,0x7B2E,0xBB2E,0xFB2E,
 0x0F2E,0x4F2E,0x8F2E,0xCF2E,0x1F2E,0x5F2E,0x9F2E,0xDF2E,
 0x2F2E,0x6F2E,0xAF2E,0xEF2E,0x3F2E,0x7F2E,0xBF2E,0xFF2E,
 0x006E,0x406E,0x806E,0xC06E,0x106E,0x506E,0x906E,0xD06E,
 0x206E,0x606E,0xA06E,0xE06E,0x306E,0x706E,0xB06E,0xF06E,
 0x046E,0x446E,0x846E,0xC46E,0x146E,0x546E,0x946E,0xD46E,
 0x246E,0x646E,0xA46E,0xE46E,0x346E,0x746E,0xB46E,0xF46E,
 0x086E,0x486E,0x886E,0xC86E,0x186E,0x586E,0x986E,0xD86E,
 0x286E,0x686E,0xA86E,0xE86E,0x386E,0x786E,0xB86E,0xF86E,
 0x0C6E,0x4C6E,0x8C6E,0xCC6E,0x1C6E,0x5C6E,0x9C6E,0xDC6E,
 0x2C6E,0x6C6E,0xAC6E,0xEC6E,0x3C6E,0x7C6E,0xBC6E,0xFC6E,
 0x016E,0x416E,0x816E,0xC16E,0x116E,0x516E,0x916E,0xD16E,
 0x216E,0x616E,0xA16E,0xE16E,0x316E,0x716E,0xB16E,0xF16E,
 0x056E,0x456E,0x856E,0xC56E,0x156E,0x556E,0x956E,0xD56E,
 0x256E,0x656E,0xA56E,0xE56E,0x356E,0x756E,0xB56E,0xF56E,
 0x096E,0x496E,0x896E,0xC96E,0x196E,0x596E,0x996E,0xD96E,
 0x296E,0x696E,0xA96E,0xE96E,0x396E,0x796E,0xB96E,0xF96E,
 0x0D6E,0x4D6E,0x8D6E,0xCD6E,0x1D6E,0x5D6E,0x9D6E,0xDD6E,
 0x2D6E,0x6D6E,0xAD6E,0xED6E,0x3D6E,0x7D6E,0xBD6E,0xFD6E,
 0x026E,0x426E,0x826E,0xC26E,0x126E,0x526E,0x926E,0xD26E,
 0x226E,0x626E,0xA26E,0xE26E,0x326E,0x726E,0xB26E,0xF26E,
 0x066E,0x466E,0x866E,0xC66E,0x166E,0x566E,0x966E,0xD66E,
 0x266E,0x666E,0xA66E,0xE66E,0x366E,0x766E,0xB66E,0xF66E,
 0x0A6E,0x4A6E,0x8A6E,0xCA6E,0x1A6E,0x5A6E,0x9A6E,0xDA6E,
 0x2A6E,0x6A6E,0xAA6E,0xEA6E,0x3A6E,0x7A6E,0xBA6E,0xFA6E,
 0x0E6E,0x4E6E,0x8E6E,0xCE6E,0x1E6E,0x5E6E,0x9E6E,0xDE6E,
 0x2E6E,0x6E6E,0xAE6E,0xEE6E,0x3E6E,0x7E6E,0xBE6E,0xFE6E,
 0x036E,0x436E,0x836E,0xC36E,0x136E,0x536E,0x936E,0xD36E,
 0x236E,0x636E,0xA36E,0xE36E,0x336E,0x736E,0xB36E,0xF36E,
 0x076E,0x476E,0x876E,0xC76E,0x176E,0x576E,0x976E,0xD76E,
 0x276E,0x676E,0xA76E,0xE76E,0x376E,0x776E,0xB76E,0xF76E,
 0x0B6E,0x4B6E,0x8B6E,0xCB6E,0x1B6E,0x5B6E,0x9B6E,0xDB6E,
 0x2B6E,0x6B6E,0xAB6E,0xEB6E,0x3B6E,0x7B6E,0xBB6E,0xFB6E,
 0x0F6E,0x4F6E,0x8F6E,0xCF6E,0x1F6E,0x5F6E,0x9F6E,0xDF6E,
 0x2F6E,0x6F6E,0xAF6E,0xEF6E,0x3F6E,0x7F6E,0xBF6E,0xFF6E,
 0x00AE,0x40AE,0x80AE,0xC0AE,0x10AE,0x50AE,0x90AE,0xD0AE,
 0x20AE,0x60AE,0xA0AE,0xE0AE,0x30AE,0x70AE,0xB0AE,0xF0AE,
 0x04AE,0x44AE,0x84AE,0xC4AE,0x14AE,0x54AE,0x94AE,0xD4AE,
 0x24AE,0x64AE,0xA4AE,0xE4AE,0x34AE,0x74AE,0xB4AE,0xF4AE,
 0x08AE,0x48AE,0x88AE,0xC8AE,0x18AE,0x58AE,0x98AE,0xD8AE,
 0x28AE,0x68AE,0xA8AE,0xE8AE,0x38AE,0x78AE,0xB8AE,0xF8AE,
 0x0CAE,0x4CAE,0x8CAE,0xCCAE,0x1CAE,0x5CAE,0x9CAE,0xDCAE,
 0x2CAE,0x6CAE,0xACAE,0xECAE,0x3CAE,0x7CAE,0xBCAE,0xFCAE,
 0x01AE,0x41AE,0x81AE,0xC1AE,0x11AE,0x51AE,0x91AE,0xD1AE,
 0x21AE,0x61AE,0xA1AE,0xE1AE,0x31AE,0x71AE,0xB1AE,0xF1AE,
 0x05AE,0x45AE,0x85AE,0xC5AE,0x15AE,0x55AE,0x95AE,0xD5AE,
 0x25AE,0x65AE,0xA5AE,0xE5AE,0x35AE,0x75AE,0xB5AE,0xF5AE,
 0x09AE,0x49AE,0x89AE,0xC9AE,0x19AE,0x59AE,0x99AE,0xD9AE,
 0x29AE,0x69AE,0xA9AE,0xE9AE,0x39AE,0x79AE,0xB9AE,0xF9AE,
 0x0DAE,0x4DAE,0x8DAE,0xCDAE,0x1DAE,0x5DAE,0x9DAE,0xDDAE,
 0x2DAE,0x6DAE,0xADAE,0xEDAE,0x3DAE,0x7DAE,0xBDAE,0xFDAE,
 0x02AE,0x42AE,0x82AE,0xC2AE,0x12AE,0x52AE,0x92AE,0xD2AE,
 0x22AE,0x62AE,0xA2AE,0xE2AE,0x32AE,0x72AE,0xB2AE,0xF2AE,
 0x06AE,0x46AE,0x86AE,0xC6AE,0x16AE,0x56AE,0x96AE,0xD6AE,
 0x26AE,0x66AE,0xA6AE,0xE6AE,0x36AE,0x76AE,0xB6AE,0xF6AE,
 0x0AAE,0x4AAE,0x8AAE,0xCAAE,0x1AAE,0x5AAE,0x9AAE,0xDAAE,
 0x2AAE,0x6AAE,0xAAAE,0xEAAE,0x3AAE,0x7AAE,0xBAAE,0xFAAE,
 0x0EAE,0x4EAE,0x8EAE,0xCEAE,0x1EAE,0x5EAE,0x9EAE,0xDEAE,
 0x2EAE,0x6EAE,0xAEAE,0xEEAE,0x3EAE,0x7EAE,0xBEAE,0xFEAE,
 0x03AE,0x43AE,0x83AE,0xC3AE,0x13AE,0x53AE,0x93AE,0xD3AE,
 0x23AE,0x63AE,0xA3AE,0xE3AE,0x33AE,0x73AE,0xB3AE,0xF3AE,
 0x07AE,0x47AE,0x87AE,0xC7AE,0x17AE,0x57AE,0x97AE,0xD7AE,
 0x27AE,0x67AE,0xA7AE,0xE7AE,0x37AE,0x77AE,0xB7AE,0xF7AE,
 0x0BAE,0x4BAE,0x8BAE,0xCBAE,0x1BAE,0x5BAE,0x9BAE,0xDBAE,
 0x2BAE,0x6BAE,0xABAE,0xEBAE,0x3BAE,0x7BAE,0xBBAE,0xFBAE,
 0x0FAE,0x4FAE,0x8FAE,0xCFAE,0x1FAE,0x5FAE,0x9FAE,0xDFAE,
 0x2FAE,0x6FAE,0xAFAE,0xEFAE,0x3FAE,0x7FAE,0xBFAE,0xFFAE,
 0x00EE,0x40EE,0x80EE,0xC0EE,0x10EE,0x50EE,0x90EE,0xD0EE,
 0x20EE,0x60EE,0xA0EE,0xE0EE,0x30EE,0x70EE,0xB0EE,0xF0EE,
 0x04EE,0x44EE,0x84EE,0xC4EE,0x14EE,0x54EE,0x94EE,0xD4EE,
 0x24EE,0x64EE,0xA4EE,0xE4EE,0x34EE,0x74EE,0xB4EE,0xF4EE,
 0x08EE,0x48EE,0x88EE,0xC8EE,0x18EE,0x58EE,0x98EE,0xD8EE,
 0x28EE,0x68EE,0xA8EE,0xE8EE,0x38EE,0x78EE,0xB8EE,0xF8EE,
 0x0CEE,0x4CEE,0x8CEE,0xCCEE,0x1CEE,0x5CEE,0x9CEE,0xDCEE,
 0x2CEE,0x6CEE,0xACEE,0xECEE,0x3CEE,0x7CEE,0xBCEE,0xFCEE,
 0x01EE,0x41EE,0x81EE,0xC1EE,0x11EE,0x51EE,0x91EE,0xD1EE,
 0x21EE,0x61EE,0xA1EE,0xE1EE,0x31EE,0x71EE,0xB1EE,0xF1EE,
 0x05EE,0x45EE,0x85EE,0xC5EE,0x15EE,0x55EE,0x95EE,0xD5EE,
 0x25EE,0x65EE,0xA5EE,0xE5EE,0x35EE,0x75EE,0xB5EE,0xF5EE,
 0x09EE,0x49EE,0x89EE,0xC9EE,0x19EE,0x59EE,0x99EE,0xD9EE,
 0x29EE,0x69EE,0xA9EE,0xE9EE,0x39EE,0x79EE,0xB9EE,0xF9EE,
 0x0DEE,0x4DEE,0x8DEE,0xCDEE,0x1DEE,0x5DEE,0x9DEE,0xDDEE,
 0x2DEE,0x6DEE,0xADEE,0xEDEE,0x3DEE,0x7DEE,0xBDEE,0xFDEE,
 0x02EE,0x42EE,0x82EE,0xC2EE,0x12EE,0x52EE,0x92EE,0xD2EE,
 0x22EE,0x62EE,0xA2EE,0xE2EE,0x32EE,0x72EE,0xB2EE,0xF2EE,
 0x06EE,0x46EE,0x86EE,0xC6EE,0x16EE,0x56EE,0x96EE,0xD6EE,
 0x26EE,0x66EE,0xA6EE,0xE6EE,0x36EE,0x76EE,0xB6EE,0xF6EE,
 0x0AEE,0x4AEE,0x8AEE,0xCAEE,0x1AEE,0x5AEE,0x9AEE,0xDAEE,
 0x2AEE,0x6AEE,0xAAEE,0xEAEE,0x3AEE,0x7AEE,0xBAEE,0xFAEE,
 0x0EEE,0x4EEE,0x8EEE,0xCEEE,0x1EEE,0x5EEE,0x9EEE,0xDEEE,
 0x2EEE,0x6EEE,0xAEEE,0xEEEE,0x3EEE,0x7EEE,0xBEEE,0xFEEE,
 0x03EE,0x43EE,0x83EE,0xC3EE,0x13EE,0x53EE,0x93EE,0xD3EE,
 0x23EE,0x63EE,0xA3EE,0xE3EE,0x33EE,0x73EE,0xB3EE,0xF3EE,
 0x07EE,0x47EE,0x87EE,0xC7EE,0x17EE,0x57EE,0x97EE,0xD7EE,
 0x27EE,0x67EE,0xA7EE,0xE7EE,0x37EE,0x77EE,0xB7EE,0xF7EE,
 0x0BEE,0x4BEE,0x8BEE,0xCBEE,0x1BEE,0x5BEE,0x9BEE,0xDBEE,
 0x2BEE,0x6BEE,0xABEE,0xEBEE,0x3BEE,0x7BEE,0xBBEE,0xFBEE,
 0x0FEE,0x4FEE,0x8FEE,0xCFEE,0x1FEE,0x5FEE,0x9FEE,0xDFEE,
 0x2FEE,0x6FEE,0xAFEE,0xEFEE,0x3FEE,0x7FEE,0xBFEE,0xFFEE,
 0x003E,0x403E,0x803E,0xC03E,0x103E,0x503E,0x903E,0xD03E,
 0x203E,0x603E,0xA03E,0xE03E,0x303E,0x703E,0xB03E,0xF03E,
 0x043E,0x443E,0x843E,0xC43E,0x143E,0x543E,0x943E,0xD43E,
 0x243E,0x643E,0xA43E,0xE43E,0x343E,0x743E,0xB43E,0xF43E,
 0x083E,0x483E,0x883E,0xC83E,0x183E,0x583E,0x983E,0xD83E,
 0x283E,0x683E,0xA83E,0xE83E,0x383E,0x783E,0xB83E,0xF83E,
 0x0C3E,0x4C3E,0x8C3E,0xCC3E,0x1C3E,0x5C3E,0x9C3E,0xDC3E,
 0x2C3E,0x6C3E,0xAC3E,0xEC3E,0x3C3E,0x7C3E,0xBC3E,0xFC3E,
 0x013E,0x413E,0x813E,0xC13E,0x113E,0x513E,0x913E,0xD13E,
 0x213E,0x613E,0xA13E,0xE13E,0x313E,0x713E,0xB13E,0xF13E,
 0x053E,0x453E,0x853E,0xC53E,0x153E,0x553E,0x953E,0xD53E,
 0x253E,0x653E,0xA53E,0xE53E,0x353E,0x753E,0xB53E,0xF53E,
 0x093E,0x493E,0x893E,0xC93E,0x193E,0x593E,0x993E,0xD93E,
 0x293E,0x693E,0xA93E,0xE93E,0x393E,0x793E,0xB93E,0xF93E,
 0x0D3E,0x4D3E,0x8D3E,0xCD3E,0x1D3E,0x5D3E,0x9D3E,0xDD3E,
 0x2D3E,0x6D3E,0xAD3E,0xED3E,0x3D3E,0x7D3E,0xBD3E,0xFD3E,
 0x023E,0x423E,0x823E,0xC23E,0x123E,0x523E,0x923E,0xD23E,
 0x223E,0x623E,0xA23E,0xE23E,0x323E,0x723E,0xB23E,0xF23E,
 0x063E,0x463E,0x863E,0xC63E,0x163E,0x563E,0x963E,0xD63E,
 0x263E,0x663E,0xA63E,0xE63E,0x363E,0x763E,0xB63E,0xF63E,
 0x0A3E,0x4A3E,0x8A3E,0xCA3E,0x1A3E,0x5A3E,0x9A3E,0xDA3E,
 0x2A3E,0x6A3E,0xAA3E,0xEA3E,0x3A3E,0x7A3E,0xBA3E,0xFA3E,
 0x0E3E,0x4E3E,0x8E3E,0xCE3E,0x1E3E,0x5E3E,0x9E3E,0xDE3E,
 0x2E3E,0x6E3E,0xAE3E,0xEE3E,0x3E3E,0x7E3E,0xBE3E,0xFE3E,
 0x033E,0x433E,0x833E,0xC33E,0x133E,0x533E,0x933E,0xD33E,
 0x233E,0x633E,0xA33E,0xE33E,0x333E,0x733E,0xB33E,0xF33E,
 0x073E,0x473E,0x873E,0xC73E,0x173E,0x573E,0x973E,0xD73E,
 0x273E,0x673E,0xA73E,0xE73E,0x373E,0x773E,0xB73E,0xF73E,
 0x0B3E,0x4B3E,0x8B3E,0xCB3E,0x1B3E,0x5B3E,0x9B3E,0xDB3E,
 0x2B3E,0x6B3E,0xAB3E,0xEB3E,0x3B3E,0x7B3E,0xBB3E,0xFB3E,
 0x0F3E,0x4F3E,0x8F3E,0xCF3E,0x1F3E,0x5F3E,0x9F3E,0xDF3E,
 0x2F3E,0x6F3E,0xAF3E,0xEF3E,0x3F3E,0x7F3E,0xBF3E,0xFF3E,
 0x007E,0x407E,0x807E,0xC07E,0x107E,0x507E,0x907E,0xD07E,
 0x207E,0x607E,0xA07E,0xE07E,0x307E,0x707E,0xB07E,0xF07E,
 0x047E,0x447E,0x847E,0xC47E,0x147E,0x547E,0x947E,0xD47E,
 0x247E,0x647E,0xA47E,0xE47E,0x347E,0x747E,0xB47E,0xF47E,
 0x087E,0x487E,0x887E,0xC87E,0x187E,0x587E,0x987E,0xD87E,
 0x287E,0x687E,0xA87E,0xE87E,0x387E,0x787E,0xB87E,0xF87E,
 0x0C7E,0x4C7E,0x8C7E,0xCC7E,0x1C7E,0x5C7E,0x9C7E,0xDC7E,
 0x2C7E,0x6C7E,0xAC7E,0xEC7E,0x3C7E,0x7C7E,0xBC7E,0xFC7E,
 0x017E,0x417E,0x817E,0xC17E,0x117E,0x517E,0x917E,0xD17E,
 0x217E,0x617E,0xA17E,0xE17E,0x317E,0x717E,0xB17E,0xF17E,
 0x057E,0x457E,0x857E,0xC57E,0x157E,0x557E,0x957E,0xD57E,
 0x257E,0x657E,0xA57E,0xE57E,0x357E,0x757E,0xB57E,0xF57E,
 0x097E,0x497E,0x897E,0xC97E,0x197E,0x597E,0x997E,0xD97E,
 0x297E,0x697E,0xA97E,0xE97E,0x397E,0x797E,0xB97E,0xF97E,
 0x0D7E,0x4D7E,0x8D7E,0xCD7E,0x1D7E,0x5D7E,0x9D7E,0xDD7E,
 0x2D7E,0x6D7E,0xAD7E,0xED7E,0x3D7E,0x7D7E,0xBD7E,0xFD7E,
 0x027E,0x427E,0x827E,0xC27E,0x127E,0x527E,0x927E,0xD27E,
 0x227E,0x627E,0xA27E,0xE27E,0x327E,0x727E,0xB27E,0xF27E,
 0x067E,0x467E,0x867E,0xC67E,0x167E,0x567E,0x967E,0xD67E,
 0x267E,0x667E,0xA67E,0xE67E,0x367E,0x767E,0xB67E,0xF67E,
 0x0A7E,0x4A7E,0x8A7E,0xCA7E,0x1A7E,0x5A7E,0x9A7E,0xDA7E,
 0x2A7E,0x6A7E,0xAA7E,0xEA7E,0x3A7E,0x7A7E,0xBA7E,0xFA7E,
 0x0E7E,0x4E7E,0x8E7E,0xCE7E,0x1E7E,0x5E7E,0x9E7E,0xDE7E,
 0x2E7E,0x6E7E,0xAE7E,0xEE7E,0x3E7E,0x7E7E,0xBE7E,0xFE7E,
 0x037E,0x437E,0x837E,0xC37E,0x137E,0x537E,0x937E,0xD37E,
 0x237E,0x637E,0xA37E,0xE37E,0x337E,0x737E,0xB37E,0xF37E,
 0x077E,0x477E,0x877E,0xC77E,0x177E,0x577E,0x977E,0xD77E,
 0x277E,0x677E,0xA77E,0xE77E,0x377E,0x777E,0xB77E,0xF77E,
 0x0B7E,0x4B7E,0x8B7E,0xCB7E,0x1B7E,0x5B7E,0x9B7E,0xDB7E,
 0x2B7E,0x6B7E,0xAB7E,0xEB7E,0x3B7E,0x7B7E,0xBB7E,0xFB7E,
 0x0F7E,0x4F7E,0x8F7E,0xCF7E,0x1F7E,0x5F7E,0x9F7E,0xDF7E,
 0x2F7E,0x6F7E,0xAF7E,0xEF7E,0x3F7E,0x7F7E,0xBF7E,0xFF7E,
 0x00BE,0x40BE,0x80BE,0xC0BE,0x10BE,0x50BE,0x90BE,0xD0BE,
 0x20BE,0x60BE,0xA0BE,0xE0BE,0x30BE,0x70BE,0xB0BE,0xF0BE,
 0x04BE,0x44BE,0x84BE,0xC4BE,0x14BE,0x54BE,0x94BE,0xD4BE,
 0x24BE,0x64BE,0xA4BE,0xE4BE,0x34BE,0x74BE,0xB4BE,0xF4BE,
 0x08BE,0x48BE,0x88BE,0xC8BE,0x18BE,0x58BE,0x98BE,0xD8BE,
 0x28BE,0x68BE,0xA8BE,0xE8BE,0x38BE,0x78BE,0xB8BE,0xF8BE,
 0x0CBE,0x4CBE,0x8CBE,0xCCBE,0x1CBE,0x5CBE,0x9CBE,0xDCBE,
 0x2CBE,0x6CBE,0xACBE,0xECBE,0x3CBE,0x7CBE,0xBCBE,0xFCBE,
 0x01BE,0x41BE,0x81BE,0xC1BE,0x11BE,0x51BE,0x91BE,0xD1BE,
 0x21BE,0x61BE,0xA1BE,0xE1BE,0x31BE,0x71BE,0xB1BE,0xF1BE,
 0x05BE,0x45BE,0x85BE,0xC5BE,0x15BE,0x55BE,0x95BE,0xD5BE,
 0x25BE,0x65BE,0xA5BE,0xE5BE,0x35BE,0x75BE,0xB5BE,0xF5BE,
 0x09BE,0x49BE,0x89BE,0xC9BE,0x19BE,0x59BE,0x99BE,0xD9BE,
 0x29BE,0x69BE,0xA9BE,0xE9BE,0x39BE,0x79BE,0xB9BE,0xF9BE,
 0x0DBE,0x4DBE,0x8DBE,0xCDBE,0x1DBE,0x5DBE,0x9DBE,0xDDBE,
 0x2DBE,0x6DBE,0xADBE,0xEDBE,0x3DBE,0x7DBE,0xBDBE,0xFDBE,
 0x02BE,0x42BE,0x82BE,0xC2BE,0x12BE,0x52BE,0x92BE,0xD2BE,
 0x22BE,0x62BE,0xA2BE,0xE2BE,0x32BE,0x72BE,0xB2BE,0xF2BE,
 0x06BE,0x46BE,0x86BE,0xC6BE,0x16BE,0x56BE,0x96BE,0xD6BE,
 0x26BE,0x66BE,0xA6BE,0xE6BE,0x36BE,0x76BE,0xB6BE,0xF6BE,
 0x0ABE,0x4ABE,0x8ABE,0xCABE,0x1ABE,0x5ABE,0x9ABE,0xDABE,
 0x2ABE,0x6ABE,0xAABE,0xEABE,0x3ABE,0x7ABE,0xBABE,0xFABE,
 0x0EBE,0x4EBE,0x8EBE,0xCEBE,0x1EBE,0x5EBE,0x9EBE,0xDEBE,
 0x2EBE,0x6EBE,0xAEBE,0xEEBE,0x3EBE,0x7EBE,0xBEBE,0xFEBE,
 0x03BE,0x43BE,0x83BE,0xC3BE,0x13BE,0x53BE,0x93BE,0xD3BE,
 0x23BE,0x63BE,0xA3BE,0xE3BE,0x33BE,0x73BE,0xB3BE,0xF3BE,
 0x07BE,0x47BE,0x87BE,0xC7BE,0x17BE,0x57BE,0x97BE,0xD7BE,
 0x27BE,0x67BE,0xA7BE,0xE7BE,0x37BE,0x77BE,0xB7BE,0xF7BE,
 0x0BBE,0x4BBE,0x8BBE,0xCBBE,0x1BBE,0x5BBE,0x9BBE,0xDBBE,
 0x2BBE,0x6BBE,0xABBE,0xEBBE,0x3BBE,0x7BBE,0xBBBE,0xFBBE,
 0x0FBE,0x4FBE,0x8FBE,0xCFBE,0x1FBE,0x5FBE,0x9FBE,0xDFBE,
 0x2FBE,0x6FBE,0xAFBE,0xEFBE,0x3FBE,0x7FBE,0xBFBE,0xFFBE,
 0x00FE,0x40FE,0x80FE,0xC0FE,0x10FE,0x50FE,0x90FE,0xD0FE,
 0x20FE,0x60FE,0xA0FE,0xE0FE,0x30FE,0x70FE,0xB0FE,0xF0FE,
 0x04FE,0x44FE,0x84FE,0xC4FE,0x14FE,0x54FE,0x94FE,0xD4FE,
 0x24FE,0x64FE,0xA4FE,0xE4FE,0x34FE,0x74FE,0xB4FE,0xF4FE,
 0x08FE,0x48FE,0x88FE,0xC8FE,0x18FE,0x58FE,0x98FE,0xD8FE,
 0x28FE,0x68FE,0xA8FE,0xE8FE,0x38FE,0x78FE,0xB8FE,0xF8FE,
 0x0CFE,0x4CFE,0x8CFE,0xCCFE,0x1CFE,0x5CFE,0x9CFE,0xDCFE,
 0x2CFE,0x6CFE,0xACFE,0xECFE,0x3CFE,0x7CFE,0xBCFE,0xFCFE,
 0x01FE,0x41FE,0x81FE,0xC1FE,0x11FE,0x51FE,0x91FE,0xD1FE,
 0x21FE,0x61FE,0xA1FE,0xE1FE,0x31FE,0x71FE,0xB1FE,0xF1FE,
 0x05FE,0x45FE,0x85FE,0xC5FE,0x15FE,0x55FE,0x95FE,0xD5FE,
 0x25FE,0x65FE,0xA5FE,0xE5FE,0x35FE,0x75FE,0xB5FE,0xF5FE,
 0x09FE,0x49FE,0x89FE,0xC9FE,0x19FE,0x59FE,0x99FE,0xD9FE,
 0x29FE,0x69FE,0xA9FE,0xE9FE,0x39FE,0x79FE,0xB9FE,0xF9FE,
 0x0DFE,0x4DFE,0x8DFE,0xCDFE,0x1DFE,0x5DFE,0x9DFE,0xDDFE,
 0x2DFE,0x6DFE,0xADFE,0xEDFE,0x3DFE,0x7DFE,0xBDFE,0xFDFE,
 0x02FE,0x42FE,0x82FE,0xC2FE,0x12FE,0x52FE,0x92FE,0xD2FE,
 0x22FE,0x62FE,0xA2FE,0xE2FE,0x32FE,0x72FE,0xB2FE,0xF2FE,
 0x06FE,0x46FE,0x86FE,0xC6FE,0x16FE,0x56FE,0x96FE,0xD6FE,
 0x26FE,0x66FE,0xA6FE,0xE6FE,0x36FE,0x76FE,0xB6FE,0xF6FE,
 0x0AFE,0x4AFE,0x8AFE,0xCAFE,0x1AFE,0x5AFE,0x9AFE,0xDAFE,
 0x2AFE,0x6AFE,0xAAFE,0xEAFE,0x3AFE,0x7AFE,0xBAFE,0xFAFE,
 0x0EFE,0x4EFE,0x8EFE,0xCEFE,0x1EFE,0x5EFE,0x9EFE,0xDEFE,
 0x2EFE,0x6EFE,0xAEFE,0xEEFE,0x3EFE,0x7EFE,0xBEFE,0xFEFE,
 0x03FE,0x43FE,0x83FE,0xC3FE,0x13FE,0x53FE,0x93FE,0xD3FE,
 0x23FE,0x63FE,0xA3FE,0xE3FE,0x33FE,0x73FE,0xB3FE,0xF3FE,
 0x07FE,0x47FE,0x87FE,0xC7FE,0x17FE,0x57FE,0x97FE,0xD7FE,
 0x27FE,0x67FE,0xA7FE,0xE7FE,0x37FE,0x77FE,0xB7FE,0xF7FE,
 0x0BFE,0x4BFE,0x8BFE,0xCBFE,0x1BFE,0x5BFE,0x9BFE,0xDBFE,
 0x2BFE,0x6BFE,0xABFE,0xEBFE,0x3BFE,0x7BFE,0xBBFE,0xFBFE,
 0x0FFE,0x4FFE,0x8FFE,0xCFFE,0x1FFE,0x5FFE,0x9FFE,0xDFFE,
 0x2FFE,0x6FFE,0xAFFE,0xEFFE,0x3FFE,0x7FFE,0xBFFE,0xFFFE,
 0x0003,0x4003,0x8003,0xC003,0x1003,0x5003,0x9003,0xD003,
 0x2003,0x6003,0xA003,0xE003,0x3003,0x7003,0xB003,0xF003,
 0x0403,0x4403,0x8403,0xC403,0x1403,0x5403,0x9403,0xD403,
 0x2403,0x6403,0xA403,0xE403,0x3403,0x7403,0xB403,0xF403,
 0x0803,0x4803,0x8803,0xC803,0x1803,0x5803,0x9803,0xD803,
 0x2803,0x6803,0xA803,0xE803,0x3803,0x7803,0xB803,0xF803,
 0x0C03,0x4C03,0x8C03,0xCC03,0x1C03,0x5C03,0x9C03,0xDC03,
 0x2C03,0x6C03,0xAC03,0xEC03,0x3C03,0x7C03,0xBC03,0xFC03,
 0x0103,0x4103,0x8103,0xC103,0x1103,0x5103,0x9103,0xD103,
 0x2103,0x6103,0xA103,0xE103,0x3103,0x7103,0xB103,0xF103,
 0x0503,0x4503,0x8503,0xC503,0x1503,0x5503,0x9503,0xD503,
 0x2503,0x6503,0xA503,0xE503,0x3503,0x7503,0xB503,0xF503,
 0x0903,0x4903,0x8903,0xC903,0x1903,0x5903,0x9903,0xD903,
 0x2903,0x6903,0xA903,0xE903,0x3903,0x7903,0xB903,0xF903,
 0x0D03,0x4D03,0x8D03,0xCD03,0x1D03,0x5D03,0x9D03,0xDD03,
 0x2D03,0x6D03,0xAD03,0xED03,0x3D03,0x7D03,0xBD03,0xFD03,
 0x0203,0x4203,0x8203,0xC203,0x1203,0x5203,0x9203,0xD203,
 0x2203,0x6203,0xA203,0xE203,0x3203,0x7203,0xB203,0xF203,
 0x0603,0x4603,0x8603,0xC603,0x1603,0x5603,0x9603,0xD603,
 0x2603,0x6603,0xA603,0xE603,0x3603,0x7603,0xB603,0xF603,
 0x0A03,0x4A03,0x8A03,0xCA03,0x1A03,0x5A03,0x9A03,0xDA03,
 0x2A03,0x6A03,0xAA03,0xEA03,0x3A03,0x7A03,0xBA03,0xFA03,
 0x0E03,0x4E03,0x8E03,0xCE03,0x1E03,0x5E03,0x9E03,0xDE03,
 0x2E03,0x6E03,0xAE03,0xEE03,0x3E03,0x7E03,0xBE03,0xFE03,
 0x0303,0x4303,0x8303,0xC303,0x1303,0x5303,0x9303,0xD303,
 0x2303,0x6303,0xA303,0xE303,0x3303,0x7303,0xB303,0xF303,
 0x0703,0x4703,0x8703,0xC703,0x1703,0x5703,0x9703,0xD703,
 0x2703,0x6703,0xA703,0xE703,0x3703,0x7703,0xB703,0xF703,
 0x0B03,0x4B03,0x8B03,0xCB03,0x1B03,0x5B03,0x9B03,0xDB03,
 0x2B03,0x6B03,0xAB03,0xEB03,0x3B03,0x7B03,0xBB03,0xFB03,
 0x0F03,0x4F03,0x8F03,0xCF03,0x1F03,0x5F03,0x9F03,0xDF03,
 0x2F03,0x6F03,0xAF03,0xEF03,0x3F03,0x7F03,0xBF03,0xFF03,
 0x0043,0x4043,0x8043,0xC043,0x1043,0x5043,0x9043,0xD043,
 0x2043,0x6043,0xA043,0xE043,0x3043,0x7043,0xB043,0xF043,
 0x0443,0x4443,0x8443,0xC443,0x1443,0x5443,0x9443,0xD443,
 0x2443,0x6443,0xA443,0xE443,0x3443,0x7443,0xB443,0xF443,
 0x0843,0x4843,0x8843,0xC843,0x1843,0x5843,0x9843,0xD843,
 0x2843,0x6843,0xA843,0xE843,0x3843,0x7843,0xB843,0xF843,
 0x0C43,0x4C43,0x8C43,0xCC43,0x1C43,0x5C43,0x9C43,0xDC43,
 0x2C43,0x6C43,0xAC43,0xEC43,0x3C43,0x7C43,0xBC43,0xFC43,
 0x0143,0x4143,0x8143,0xC143,0x1143,0x5143,0x9143,0xD143,
 0x2143,0x6143,0xA143,0xE143,0x3143,0x7143,0xB143,0xF143,
 0x0543,0x4543,0x8543,0xC543,0x1543,0x5543,0x9543,0xD543,
 0x2543,0x6543,0xA543,0xE543,0x3543,0x7543,0xB543,0xF543,
 0x0943,0x4943,0x8943,0xC943,0x1943,0x5943,0x9943,0xD943,
 0x2943,0x6943,0xA943,0xE943,0x3943,0x7943,0xB943,0xF943,
 0x0D43,0x4D43,0x8D43,0xCD43,0x1D43,0x5D43,0x9D43,0xDD43,
 0x2D43,0x6D43,0xAD43,0xED43,0x3D43,0x7D43,0xBD43,0xFD43,
 0x0243,0x4243,0x8243,0xC243,0x1243,0x5243,0x9243,0xD243,
 0x2243,0x6243,0xA243,0xE243,0x3243,0x7243,0xB243,0xF243,
 0x0643,0x4643,0x8643,0xC643,0x1643,0x5643,0x9643,0xD643,
 0x2643,0x6643,0xA643,0xE643,0x3643,0x7643,0xB643,0xF643,
 0x0A43,0x4A43,0x8A43,0xCA43,0x1A43,0x5A43,0x9A43,0xDA43,
 0x2A43,0x6A43,0xAA43,0xEA43,0x3A43,0x7A43,0xBA43,0xFA43,
 0x0E43,0x4E43,0x8E43,0xCE43,0x1E43,0x5E43,0x9E43,0xDE43,
 0x2E43,0x6E43,0xAE43,0xEE43,0x3E43,0x7E43,0xBE43,0xFE43,
 0x0343,0x4343,0x8343,0xC343,0x1343,0x5343,0x9343,0xD343,
 0x2343,0x6343,0xA343,0xE343,0x3343,0x7343,0xB343,0xF343,
 0x0743,0x4743,0x8743,0xC743,0x1743,0x5743,0x9743,0xD743,
 0x2743,0x6743,0xA743,0xE743,0x3743,0x7743,0xB743,0xF743,
 0x0B43,0x4B43,0x8B43,0xCB43,0x1B43,0x5B43,0x9B43,0xDB43,
 0x2B43,0x6B43,0xAB43,0xEB43,0x3B43,0x7B43,0xBB43,0xFB43,
 0x0F43,0x4F43,0x8F43,0xCF43,0x1F43,0x5F43,0x9F43,0xDF43,
 0x2F43,0x6F43,0xAF43,0xEF43,0x3F43,0x7F43,0xBF43,0xFF43,
 0x0083,0x4083,0x8083,0xC083,0x1083,0x5083,0x9083,0xD083,
 0x2083,0x6083,0xA083,0xE083,0x3083,0x7083,0xB083,0xF083,
 0x0483,0x4483,0x8483,0xC483,0x1483,0x5483,0x9483,0xD483,
 0x2483,0x6483,0xA483,0xE483,0x3483,0x7483,0xB483,0xF483,
 0x0883,0x4883,0x8883,0xC883,0x1883,0x5883,0x9883,0xD883,
 0x2883,0x6883,0xA883,0xE883,0x3883,0x7883,0xB883,0xF883,
 0x0C83,0x4C83,0x8C83,0xCC83,0x1C83,0x5C83,0x9C83,0xDC83,
 0x2C83,0x6C83,0xAC83,0xEC83,0x3C83,0x7C83,0xBC83,0xFC83,
 0x0183,0x4183,0x8183,0xC183,0x1183,0x5183,0x9183,0xD183,
 0x2183,0x6183,0xA183,0xE183,0x3183,0x7183,0xB183,0xF183,
 0x0583,0x4583,0x8583,0xC583,0x1583,0x5583,0x9583,0xD583,
 0x2583,0x6583,0xA583,0xE583,0x3583,0x7583,0xB583,0xF583,
 0x0983,0x4983,0x8983,0xC983,0x1983,0x5983,0x9983,0xD983,
 0x2983,0x6983,0xA983,0xE983,0x3983,0x7983,0xB983,0xF983,
 0x0D83,0x4D83,0x8D83,0xCD83,0x1D83,0x5D83,0x9D83,0xDD83,
 0x2D83,0x6D83,0xAD83,0xED83,0x3D83,0x7D83,0xBD83,0xFD83,
 0x0283,0x4283,0x8283,0xC283,0x1283,0x5283,0x9283,0xD283,
 0x2283,0x6283,0xA283,0xE283,0x3283,0x7283,0xB283,0xF283,
 0x0683,0x4683,0x8683,0xC683,0x1683,0x5683,0x9683,0xD683,
 0x2683,0x6683,0xA683,0xE683,0x3683,0x7683,0xB683,0xF683,
 0x0A83,0x4A83,0x8A83,0xCA83,0x1A83,0x5A83,0x9A83,0xDA83,
 0x2A83,0x6A83,0xAA83,0xEA83,0x3A83,0x7A83,0xBA83,0xFA83,
 0x0E83,0x4E83,0x8E83,0xCE83,0x1E83,0x5E83,0x9E83,0xDE83,
 0x2E83,0x6E83,0xAE83,0xEE83,0x3E83,0x7E83,0xBE83,0xFE83,
 0x0383,0x4383,0x8383,0xC383,0x1383,0x5383,0x9383,0xD383,
 0x2383,0x6383,0xA383,0xE383,0x3383,0x7383,0xB383,0xF383,
 0x0783,0x4783,0x8783,0xC783,0x1783,0x5783,0x9783,0xD783,
 0x2783,0x6783,0xA783,0xE783,0x3783,0x7783,0xB783,0xF783,
 0x0B83,0x4B83,0x8B83,0xCB83,0x1B83,0x5B83,0x9B83,0xDB83,
 0x2B83,0x6B83,0xAB83,0xEB83,0x3B83,0x7B83,0xBB83,0xFB83,
 0x0F83,0x4F83,0x8F83,0xCF83,0x1F83,0x5F83,0x9F83,0xDF83,
 0x2F83,0x6F83,0xAF83,0xEF83,0x3F83,0x7F83,0xBF83,0xFF83,
 0x00C3,0x40C3,0x80C3,0xC0C3,0x10C3,0x50C3,0x90C3,0xD0C3,
 0x20C3,0x60C3,0xA0C3,0xE0C3,0x30C3,0x70C3,0xB0C3,0xF0C3,
 0x04C3,0x44C3,0x84C3,0xC4C3,0x14C3,0x54C3,0x94C3,0xD4C3,
 0x24C3,0x64C3,0xA4C3,0xE4C3,0x34C3,0x74C3,0xB4C3,0xF4C3,
 0x08C3,0x48C3,0x88C3,0xC8C3,0x18C3,0x58C3,0x98C3,0xD8C3,
 0x28C3,0x68C3,0xA8C3,0xE8C3,0x38C3,0x78C3,0xB8C3,0xF8C3,
 0x0CC3,0x4CC3,0x8CC3,0xCCC3,0x1CC3,0x5CC3,0x9CC3,0xDCC3,
 0x2CC3,0x6CC3,0xACC3,0xECC3,0x3CC3,0x7CC3,0xBCC3,0xFCC3,
 0x01C3,0x41C3,0x81C3,0xC1C3,0x11C3,0x51C3,0x91C3,0xD1C3,
 0x21C3,0x61C3,0xA1C3,0xE1C3,0x31C3,0x71C3,0xB1C3,0xF1C3,
 0x05C3,0x45C3,0x85C3,0xC5C3,0x15C3,0x55C3,0x95C3,0xD5C3,
 0x25C3,0x65C3,0xA5C3,0xE5C3,0x35C3,0x75C3,0xB5C3,0xF5C3,
 0x09C3,0x49C3,0x89C3,0xC9C3,0x19C3,0x59C3,0x99C3,0xD9C3,
 0x29C3,0x69C3,0xA9C3,0xE9C3,0x39C3,0x79C3,0xB9C3,0xF9C3,
 0x0DC3,0x4DC3,0x8DC3,0xCDC3,0x1DC3,0x5DC3,0x9DC3,0xDDC3,
 0x2DC3,0x6DC3,0xADC3,0xEDC3,0x3DC3,0x7DC3,0xBDC3,0xFDC3,
 0x02C3,0x42C3,0x82C3,0xC2C3,0x12C3,0x52C3,0x92C3,0xD2C3,
 0x22C3,0x62C3,0xA2C3,0xE2C3,0x32C3,0x72C3,0xB2C3,0xF2C3,
 0x06C3,0x46C3,0x86C3,0xC6C3,0x16C3,0x56C3,0x96C3,0xD6C3,
 0x26C3,0x66C3,0xA6C3,0xE6C3,0x36C3,0x76C3,0xB6C3,0xF6C3,
 0x0AC3,0x4AC3,0x8AC3,0xCAC3,0x1AC3,0x5AC3,0x9AC3,0xDAC3,
 0x2AC3,0x6AC3,0xAAC3,0xEAC3,0x3AC3,0x7AC3,0xBAC3,0xFAC3,
 0x0EC3,0x4EC3,0x8EC3,0xCEC3,0x1EC3,0x5EC3,0x9EC3,0xDEC3,
 0x2EC3,0x6EC3,0xAEC3,0xEEC3,0x3EC3,0x7EC3,0xBEC3,0xFEC3,
 0x03C3,0x43C3,0x83C3,0xC3C3,0x13C3,0x53C3,0x93C3,0xD3C3,
 0x23C3,0x63C3,0xA3C3,0xE3C3,0x33C3,0x73C3,0xB3C3,0xF3C3,
 0x07C3,0x47C3,0x87C3,0xC7C3,0x17C3,0x57C3,0x97C3,0xD7C3,
 0x27C3,0x67C3,0xA7C3,0xE7C3,0x37C3,0x77C3,0xB7C3,0xF7C3,
 0x0BC3,0x4BC3,0x8BC3,0xCBC3,0x1BC3,0x5BC3,0x9BC3,0xDBC3,
 0x2BC3,0x6BC3,0xABC3,0xEBC3,0x3BC3,0x7BC3,0xBBC3,0xFBC3,
 0x0FC3,0x4FC3,0x8FC3,0xCFC3,0x1FC3,0x5FC3,0x9FC3,0xDFC3,
 0x2FC3,0x6FC3,0xAFC3,0xEFC3,0x3FC3,0x7FC3,0xBFC3,0xFFC3,
 0x0013,0x4013,0x8013,0xC013,0x1013,0x5013,0x9013,0xD013,
 0x2013,0x6013,0xA013,0xE013,0x3013,0x7013,0xB013,0xF013,
 0x0413,0x4413,0x8413,0xC413,0x1413,0x5413,0x9413,0xD413,
 0x2413,0x6413,0xA413,0xE413,0x3413,0x7413,0xB413,0xF413,
 0x0813,0x4813,0x8813,0xC813,0x1813,0x5813,0x9813,0xD813,
 0x2813,0x6813,0xA813,0xE813,0x3813,0x7813,0xB813,0xF813,
 0x0C13,0x4C13,0x8C13,0xCC13,0x1C13,0x5C13,0x9C13,0xDC13,
 0x2C13,0x6C13,0xAC13,0xEC13,0x3C13,0x7C13,0xBC13,0xFC13,
 0x0113,0x4113,0x8113,0xC113,0x1113,0x5113,0x9113,0xD113,
 0x2113,0x6113,0xA113,0xE113,0x3113,0x7113,0xB113,0xF113,
 0x0513,0x4513,0x8513,0xC513,0x1513,0x5513,0x9513,0xD513,
 0x2513,0x6513,0xA513,0xE513,0x3513,0x7513,0xB513,0xF513,
 0x0913,0x4913,0x8913,0xC913,0x1913,0x5913,0x9913,0xD913,
 0x2913,0x6913,0xA913,0xE913,0x3913,0x7913,0xB913,0xF913,
 0x0D13,0x4D13,0x8D13,0xCD13,0x1D13,0x5D13,0x9D13,0xDD13,
 0x2D13,0x6D13,0xAD13,0xED13,0x3D13,0x7D13,0xBD13,0xFD13,
 0x0213,0x4213,0x8213,0xC213,0x1213,0x5213,0x9213,0xD213,
 0x2213,0x6213,0xA213,0xE213,0x3213,0x7213,0xB213,0xF213,
 0x0613,0x4613,0x8613,0xC613,0x1613,0x5613,0x9613,0xD613,
 0x2613,0x6613,0xA613,0xE613,0x3613,0x7613,0xB613,0xF613,
 0x0A13,0x4A13,0x8A13,0xCA13,0x1A13,0x5A13,0x9A13,0xDA13,
 0x2A13,0x6A13,0xAA13,0xEA13,0x3A13,0x7A13,0xBA13,0xFA13,
 0x0E13,0x4E13,0x8E13,0xCE13,0x1E13,0x5E13,0x9E13,0xDE13,
 0x2E13,0x6E13,0xAE13,0xEE13,0x3E13,0x7E13,0xBE13,0xFE13,
 0x0313,0x4313,0x8313,0xC313,0x1313,0x5313,0x9313,0xD313,
 0x2313,0x6313,0xA313,0xE313,0x3313,0x7313,0xB313,0xF313,
 0x0713,0x4713,0x8713,0xC713,0x1713,0x5713,0x9713,0xD713,
 0x2713,0x6713,0xA713,0xE713,0x3713,0x7713,0xB713,0xF713,
 0x0B13,0x4B13,0x8B13,0xCB13,0x1B13,0x5B13,0x9B13,0xDB13,
 0x2B13,0x6B13,0xAB13,0xEB13,0x3B13,0x7B13,0xBB13,0xFB13,
 0x0F13,0x4F13,0x8F13,0xCF13,0x1F13,0x5F13,0x9F13,0xDF13,
 0x2F13,0x6F13,0xAF13,0xEF13,0x3F13,0x7F13,0xBF13,0xFF13,
 0x0053,0x4053,0x8053,0xC053,0x1053,0x5053,0x9053,0xD053,
 0x2053,0x6053,0xA053,0xE053,0x3053,0x7053,0xB053,0xF053,
 0x0453,0x4453,0x8453,0xC453,0x1453,0x5453,0x9453,0xD453,
 0x2453,0x6453,0xA453,0xE453,0x3453,0x7453,0xB453,0xF453,
 0x0853,0x4853,0x8853,0xC853,0x1853,0x5853,0x9853,0xD853,
 0x2853,0x6853,0xA853,0xE853,0x3853,0x7853,0xB853,0xF853,
 0x0C53,0x4C53,0x8C53,0xCC53,0x1C53,0x5C53,0x9C53,0xDC53,
 0x2C53,0x6C53,0xAC53,0xEC53,0x3C53,0x7C53,0xBC53,0xFC53,
 0x0153,0x4153,0x8153,0xC153,0x1153,0x5153,0x9153,0xD153,
 0x2153,0x6153,0xA153,0xE153,0x3153,0x7153,0xB153,0xF153,
 0x0553,0x4553,0x8553,0xC553,0x1553,0x5553,0x9553,0xD553,
 0x2553,0x6553,0xA553,0xE553,0x3553,0x7553,0xB553,0xF553,
 0x0953,0x4953,0x8953,0xC953,0x1953,0x5953,0x9953,0xD953,
 0x2953,0x6953,0xA953,0xE953,0x3953,0x7953,0xB953,0xF953,
 0x0D53,0x4D53,0x8D53,0xCD53,0x1D53,0x5D53,0x9D53,0xDD53,
 0x2D53,0x6D53,0xAD53,0xED53,0x3D53,0x7D53,0xBD53,0xFD53,
 0x0253,0x4253,0x8253,0xC253,0x1253,0x5253,0x9253,0xD253,
 0x2253,0x6253,0xA253,0xE253,0x3253,0x7253,0xB253,0xF253,
 0x0653,0x4653,0x8653,0xC653,0x1653,0x5653,0x9653,0xD653,
 0x2653,0x6653,0xA653,0xE653,0x3653,0x7653,0xB653,0xF653,
 0x0A53,0x4A53,0x8A53,0xCA53,0x1A53,0x5A53,0x9A53,0xDA53,
 0x2A53,0x6A53,0xAA53,0xEA53,0x3A53,0x7A53,0xBA53,0xFA53,
 0x0E53,0x4E53,0x8E53,0xCE53,0x1E53,0x5E53,0x9E53,0xDE53,
 0x2E53,0x6E53,0xAE53,0xEE53,0x3E53,0x7E53,0xBE53,0xFE53,
 0x0353,0x4353,0x8353,0xC353,0x1353,0x5353,0x9353,0xD353,
 0x2353,0x6353,0xA353,0xE353,0x3353,0x7353,0xB353,0xF353,
 0x0753,0x4753,0x8753,0xC753,0x1753,0x5753,0x9753,0xD753,
 0x2753,0x6753,0xA753,0xE753,0x3753,0x7753,0xB753,0xF753,
 0x0B53,0x4B53,0x8B53,0xCB53,0x1B53,0x5B53,0x9B53,0xDB53,
 0x2B53,0x6B53,0xAB53,0xEB53,0x3B53,0x7B53,0xBB53,0xFB53,
 0x0F53,0x4F53,0x8F53,0xCF53,0x1F53,0x5F53,0x9F53,0xDF53,
 0x2F53,0x6F53,0xAF53,0xEF53,0x3F53,0x7F53,0xBF53,0xFF53,
 0x0093,0x4093,0x8093,0xC093,0x1093,0x5093,0x9093,0xD093,
 0x2093,0x6093,0xA093,0xE093,0x3093,0x7093,0xB093,0xF093,
 0x0493,0x4493,0x8493,0xC493,0x1493,0x5493,0x9493,0xD493,
 0x2493,0x6493,0xA493,0xE493,0x3493,0x7493,0xB493,0xF493,
 0x0893,0x4893,0x8893,0xC893,0x1893,0x5893,0x9893,0xD893,
 0x2893,0x6893,0xA893,0xE893,0x3893,0x7893,0xB893,0xF893,
 0x0C93,0x4C93,0x8C93,0xCC93,0x1C93,0x5C93,0x9C93,0xDC93,
 0x2C93,0x6C93,0xAC93,0xEC93,0x3C93,0x7C93,0xBC93,0xFC93,
 0x0193,0x4193,0x8193,0xC193,0x1193,0x5193,0x9193,0xD193,
 0x2193,0x6193,0xA193,0xE193,0x3193,0x7193,0xB193,0xF193,
 0x0593,0x4593,0x8593,0xC593,0x1593,0x5593,0x9593,0xD593,
 0x2593,0x6593,0xA593,0xE593,0x3593,0x7593,0xB593,0xF593,
 0x0993,0x4993,0x8993,0xC993,0x1993,0x5993,0x9993,0xD993,
 0x2993,0x6993,0xA993,0xE993,0x3993,0x7993,0xB993,0xF993,
 0x0D93,0x4D93,0x8D93,0xCD93,0x1D93,0x5D93,0x9D93,0xDD93,
 0x2D93,0x6D93,0xAD93,0xED93,0x3D93,0x7D93,0xBD93,0xFD93,
 0x0293,0x4293,0x8293,0xC293,0x1293,0x5293,0x9293,0xD293,
 0x2293,0x6293,0xA293,0xE293,0x3293,0x7293,0xB293,0xF293,
 0x0693,0x4693,0x8693,0xC693,0x1693,0x5693,0x9693,0xD693,
 0x2693,0x6693,0xA693,0xE693,0x3693,0x7693,0xB693,0xF693,
 0x0A93,0x4A93,0x8A93,0xCA93,0x1A93,0x5A93,0x9A93,0xDA93,
 0x2A93,0x6A93,0xAA93,0xEA93,0x3A93,0x7A93,0xBA93,0xFA93,
 0x0E93,0x4E93,0x8E93,0xCE93,0x1E93,0x5E93,0x9E93,0xDE93,
 0x2E93,0x6E93,0xAE93,0xEE93,0x3E93,0x7E93,0xBE93,0xFE93,
 0x0393,0x4393,0x8393,0xC393,0x1393,0x5393,0x9393,0xD393,
 0x2393,0x6393,0xA393,0xE393,0x3393,0x7393,0xB393,0xF393,
 0x0793,0x4793,0x8793,0xC793,0x1793,0x5793,0x9793,0xD793,
 0x2793,0x6793,0xA793,0xE793,0x3793,0x7793,0xB793,0xF793,
 0x0B93,0x4B93,0x8B93,0xCB93,0x1B93,0x5B93,0x9B93,0xDB93,
 0x2B93,0x6B93,0xAB93,0xEB93,0x3B93,0x7B93,0xBB93,0xFB93,
 0x0F93,0x4F93,0x8F93,0xCF93,0x1F93,0x5F93,0x9F93,0xDF93,
 0x2F93,0x6F93,0xAF93,0xEF93,0x3F93,0x7F93,0xBF93,0xFF93,
 0x00D3,0x40D3,0x80D3,0xC0D3,0x10D3,0x50D3,0x90D3,0xD0D3,
 0x20D3,0x60D3,0xA0D3,0xE0D3,0x30D3,0x70D3,0xB0D3,0xF0D3,
 0x04D3,0x44D3,0x84D3,0xC4D3,0x14D3,0x54D3,0x94D3,0xD4D3,
 0x24D3,0x64D3,0xA4D3,0xE4D3,0x34D3,0x74D3,0xB4D3,0xF4D3,
 0x08D3,0x48D3,0x88D3,0xC8D3,0x18D3,0x58D3,0x98D3,0xD8D3,
 0x28D3,0x68D3,0xA8D3,0xE8D3,0x38D3,0x78D3,0xB8D3,0xF8D3,
 0x0CD3,0x4CD3,0x8CD3,0xCCD3,0x1CD3,0x5CD3,0x9CD3,0xDCD3,
 0x2CD3,0x6CD3,0xACD3,0xECD3,0x3CD3,0x7CD3,0xBCD3,0xFCD3,
 0x01D3,0x41D3,0x81D3,0xC1D3,0x11D3,0x51D3,0x91D3,0xD1D3,
 0x21D3,0x61D3,0xA1D3,0xE1D3,0x31D3,0x71D3,0xB1D3,0xF1D3,
 0x05D3,0x45D3,0x85D3,0xC5D3,0x15D3,0x55D3,0x95D3,0xD5D3,
 0x25D3,0x65D3,0xA5D3,0xE5D3,0x35D3,0x75D3,0xB5D3,0xF5D3,
 0x09D3,0x49D3,0x89D3,0xC9D3,0x19D3,0x59D3,0x99D3,0xD9D3,
 0x29D3,0x69D3,0xA9D3,0xE9D3,0x39D3,0x79D3,0xB9D3,0xF9D3,
 0x0DD3,0x4DD3,0x8DD3,0xCDD3,0x1DD3,0x5DD3,0x9DD3,0xDDD3,
 0x2DD3,0x6DD3,0xADD3,0xEDD3,0x3DD3,0x7DD3,0xBDD3,0xFDD3,
 0x02D3,0x42D3,0x82D3,0xC2D3,0x12D3,0x52D3,0x92D3,0xD2D3,
 0x22D3,0x62D3,0xA2D3,0xE2D3,0x32D3,0x72D3,0xB2D3,0xF2D3,
 0x06D3,0x46D3,0x86D3,0xC6D3,0x16D3,0x56D3,0x96D3,0xD6D3,
 0x26D3,0x66D3,0xA6D3,0xE6D3,0x36D3,0x76D3,0xB6D3,0xF6D3,
 0x0AD3,0x4AD3,0x8AD3,0xCAD3,0x1AD3,0x5AD3,0x9AD3,0xDAD3,
 0x2AD3,0x6AD3,0xAAD3,0xEAD3,0x3AD3,0x7AD3,0xBAD3,0xFAD3,
 0x0ED3,0x4ED3,0x8ED3,0xCED3,0x1ED3,0x5ED3,0x9ED3,0xDED3,
 0x2ED3,0x6ED3,0xAED3,0xEED3,0x3ED3,0x7ED3,0xBED3,0xFED3,
 0x03D3,0x43D3,0x83D3,0xC3D3,0x13D3,0x53D3,0x93D3,0xD3D3,
 0x23D3,0x63D3,0xA3D3,0xE3D3,0x33D3,0x73D3,0xB3D3,0xF3D3,
 0x07D3,0x47D3,0x87D3,0xC7D3,0x17D3,0x57D3,0x97D3,0xD7D3,
 0x27D3,0x67D3,0xA7D3,0xE7D3,0x37D3,0x77D3,0xB7D3,0xF7D3,
 0x0BD3,0x4BD3,0x8BD3,0xCBD3,0x1BD3,0x5BD3,0x9BD3,0xDBD3,
 0x2BD3,0x6BD3,0xABD3,0xEBD3,0x3BD3,0x7BD3,0xBBD3,0xFBD3,
 0x0FD3,0x4FD3,0x8FD3,0xCFD3,0x1FD3,0x5FD3,0x9FD3,0xDFD3,
 0x2FD3,0x6FD3,0xAFD3,0xEFD3,0x3FD3,0x7FD3,0xBFD3,0xFFD3,
 0x0023,0x4023,0x8023,0xC023,0x1023,0x5023,0x9023,0xD023,
 0x2023,0x6023,0xA023,0xE023,0x3023,0x7023,0xB023,0xF023,
 0x0423,0x4423,0x8423,0xC423,0x1423,0x5423,0x9423,0xD423,
 0x2423,0x6423,0xA423,0xE423,0x3423,0x7423,0xB423,0xF423,
 0x0823,0x4823,0x8823,0xC823,0x1823,0x5823,0x9823,0xD823,
 0x2823,0x6823,0xA823,0xE823,0x3823,0x7823,0xB823,0xF823,
 0x0C23,0x4C23,0x8C23,0xCC23,0x1C23,0x5C23,0x9C23,0xDC23,
 0x2C23,0x6C23,0xAC23,0xEC23,0x3C23,0x7C23,0xBC23,0xFC23,
 0x0123,0x4123,0x8123,0xC123,0x1123,0x5123,0x9123,0xD123,
 0x2123,0x6123,0xA123,0xE123,0x3123,0x7123,0xB123,0xF123,
 0x0523,0x4523,0x8523,0xC523,0x1523,0x5523,0x9523,0xD523,
 0x2523,0x6523,0xA523,0xE523,0x3523,0x7523,0xB523,0xF523,
 0x0923,0x4923,0x8923,0xC923,0x1923,0x5923,0x9923,0xD923,
 0x2923,0x6923,0xA923,0xE923,0x3923,0x7923,0xB923,0xF923,
 0x0D23,0x4D23,0x8D23,0xCD23,0x1D23,0x5D23,0x9D23,0xDD23,
 0x2D23,0x6D23,0xAD23,0xED23,0x3D23,0x7D23,0xBD23,0xFD23,
 0x0223,0x4223,0x8223,0xC223,0x1223,0x5223,0x9223,0xD223,
 0x2223,0x6223,0xA223,0xE223,0x3223,0x7223,0xB223,0xF223,
 0x0623,0x4623,0x8623,0xC623,0x1623,0x5623,0x9623,0xD623,
 0x2623,0x6623,0xA623,0xE623,0x3623,0x7623,0xB623,0xF623,
 0x0A23,0x4A23,0x8A23,0xCA23,0x1A23,0x5A23,0x9A23,0xDA23,
 0x2A23,0x6A23,0xAA23,0xEA23,0x3A23,0x7A23,0xBA23,0xFA23,
 0x0E23,0x4E23,0x8E23,0xCE23,0x1E23,0x5E23,0x9E23,0xDE23,
 0x2E23,0x6E23,0xAE23,0xEE23,0x3E23,0x7E23,0xBE23,0xFE23,
 0x0323,0x4323,0x8323,0xC323,0x1323,0x5323,0x9323,0xD323,
 0x2323,0x6323,0xA323,0xE323,0x3323,0x7323,0xB323,0xF323,
 0x0723,0x4723,0x8723,0xC723,0x1723,0x5723,0x9723,0xD723,
 0x2723,0x6723,0xA723,0xE723,0x3723,0x7723,0xB723,0xF723,
 0x0B23,0x4B23,0x8B23,0xCB23,0x1B23,0x5B23,0x9B23,0xDB23,
 0x2B23,0x6B23,0xAB23,0xEB23,0x3B23,0x7B23,0xBB23,0xFB23,
 0x0F23,0x4F23,0x8F23,0xCF23,0x1F23,0x5F23,0x9F23,0xDF23,
 0x2F23,0x6F23,0xAF23,0xEF23,0x3F23,0x7F23,0xBF23,0xFF23,
 0x0063,0x4063,0x8063,0xC063,0x1063,0x5063,0x9063,0xD063,
 0x2063,0x6063,0xA063,0xE063,0x3063,0x7063,0xB063,0xF063,
 0x0463,0x4463,0x8463,0xC463,0x1463,0x5463,0x9463,0xD463,
 0x2463,0x6463,0xA463,0xE463,0x3463,0x7463,0xB463,0xF463,
 0x0863,0x4863,0x8863,0xC863,0x1863,0x5863,0x9863,0xD863,
 0x2863,0x6863,0xA863,0xE863,0x3863,0x7863,0xB863,0xF863,
 0x0C63,0x4C63,0x8C63,0xCC63,0x1C63,0x5C63,0x9C63,0xDC63,
 0x2C63,0x6C63,0xAC63,0xEC63,0x3C63,0x7C63,0xBC63,0xFC63,
 0x0163,0x4163,0x8163,0xC163,0x1163,0x5163,0x9163,0xD163,
 0x2163,0x6163,0xA163,0xE163,0x3163,0x7163,0xB163,0xF163,
 0x0563,0x4563,0x8563,0xC563,0x1563,0x5563,0x9563,0xD563,
 0x2563,0x6563,0xA563,0xE563,0x3563,0x7563,0xB563,0xF563,
 0x0963,0x4963,0x8963,0xC963,0x1963,0x5963,0x9963,0xD963,
 0x2963,0x6963,0xA963,0xE963,0x3963,0x7963,0xB963,0xF963,
 0x0D63,0x4D63,0x8D63,0xCD63,0x1D63,0x5D63,0x9D63,0xDD63,
 0x2D63,0x6D63,0xAD63,0xED63,0x3D63,0x7D63,0xBD63,0xFD63,
 0x0263,0x4263,0x8263,0xC263,0x1263,0x5263,0x9263,0xD263,
 0x2263,0x6263,0xA263,0xE263,0x3263,0x7263,0xB263,0xF263,
 0x0663,0x4663,0x8663,0xC663,0x1663,0x5663,0x9663,0xD663,
 0x2663,0x6663,0xA663,0xE663,0x3663,0x7663,0xB663,0xF663,
 0x0A63,0x4A63,0x8A63,0xCA63,0x1A63,0x5A63,0x9A63,0xDA63,
 0x2A63,0x6A63,0xAA63,0xEA63,0x3A63,0x7A63,0xBA63,0xFA63,
 0x0E63,0x4E63,0x8E63,0xCE63,0x1E63,0x5E63,0x9E63,0xDE63,
 0x2E63,0x6E63,0xAE63,0xEE63,0x3E63,0x7E63,0xBE63,0xFE63,
 0x0363,0x4363,0x8363,0xC363,0x1363,0x5363,0x9363,0xD363,
 0x2363,0x6363,0xA363,0xE363,0x3363,0x7363,0xB363,0xF363,
 0x0763,0x4763,0x8763,0xC763,0x1763,0x5763,0x9763,0xD763,
 0x2763,0x6763,0xA763,0xE763,0x3763,0x7763,0xB763,0xF763,
 0x0B63,0x4B63,0x8B63,0xCB63,0x1B63,0x5B63,0x9B63,0xDB63,
 0x2B63,0x6B63,0xAB63,0xEB63,0x3B63,0x7B63,0xBB63,0xFB63,
 0x0F63,0x4F63,0x8F63,0xCF63,0x1F63,0x5F63,0x9F63,0xDF63,
 0x2F63,0x6F63,0xAF63,0xEF63,0x3F63,0x7F63,0xBF63,0xFF63,
 0x00A3,0x40A3,0x80A3,0xC0A3,0x10A3,0x50A3,0x90A3,0xD0A3,
 0x20A3,0x60A3,0xA0A3,0xE0A3,0x30A3,0x70A3,0xB0A3,0xF0A3,
 0x04A3,0x44A3,0x84A3,0xC4A3,0x14A3,0x54A3,0x94A3,0xD4A3,
 0x24A3,0x64A3,0xA4A3,0xE4A3,0x34A3,0x74A3,0xB4A3,0xF4A3,
 0x08A3,0x48A3,0x88A3,0xC8A3,0x18A3,0x58A3,0x98A3,0xD8A3,
 0x28A3,0x68A3,0xA8A3,0xE8A3,0x38A3,0x78A3,0xB8A3,0xF8A3,
 0x0CA3,0x4CA3,0x8CA3,0xCCA3,0x1CA3,0x5CA3,0x9CA3,0xDCA3,
 0x2CA3,0x6CA3,0xACA3,0xECA3,0x3CA3,0x7CA3,0xBCA3,0xFCA3,
 0x01A3,0x41A3,0x81A3,0xC1A3,0x11A3,0x51A3,0x91A3,0xD1A3,
 0x21A3,0x61A3,0xA1A3,0xE1A3,0x31A3,0x71A3,0xB1A3,0xF1A3,
 0x05A3,0x45A3,0x85A3,0xC5A3,0x15A3,0x55A3,0x95A3,0xD5A3,
 0x25A3,0x65A3,0xA5A3,0xE5A3,0x35A3,0x75A3,0xB5A3,0xF5A3,
 0x09A3,0x49A3,0x89A3,0xC9A3,0x19A3,0x59A3,0x99A3,0xD9A3,
 0x29A3,0x69A3,0xA9A3,0xE9A3,0x39A3,0x79A3,0xB9A3,0xF9A3,
 0x0DA3,0x4DA3,0x8DA3,0xCDA3,0x1DA3,0x5DA3,0x9DA3,0xDDA3,
 0x2DA3,0x6DA3,0xADA3,0xEDA3,0x3DA3,0x7DA3,0xBDA3,0xFDA3,
 0x02A3,0x42A3,0x82A3,0xC2A3,0x12A3,0x52A3,0x92A3,0xD2A3,
 0x22A3,0x62A3,0xA2A3,0xE2A3,0x32A3,0x72A3,0xB2A3,0xF2A3,
 0x06A3,0x46A3,0x86A3,0xC6A3,0x16A3,0x56A3,0x96A3,0xD6A3,
 0x26A3,0x66A3,0xA6A3,0xE6A3,0x36A3,0x76A3,0xB6A3,0xF6A3,
 0x0AA3,0x4AA3,0x8AA3,0xCAA3,0x1AA3,0x5AA3,0x9AA3,0xDAA3,
 0x2AA3,0x6AA3,0xAAA3,0xEAA3,0x3AA3,0x7AA3,0xBAA3,0xFAA3,
 0x0EA3,0x4EA3,0x8EA3,0xCEA3,0x1EA3,0x5EA3,0x9EA3,0xDEA3,
 0x2EA3,0x6EA3,0xAEA3,0xEEA3,0x3EA3,0x7EA3,0xBEA3,0xFEA3,
 0x03A3,0x43A3,0x83A3,0xC3A3,0x13A3,0x53A3,0x93A3,0xD3A3,
 0x23A3,0x63A3,0xA3A3,0xE3A3,0x33A3,0x73A3,0xB3A3,0xF3A3,
 0x07A3,0x47A3,0x87A3,0xC7A3,0x17A3,0x57A3,0x97A3,0xD7A3,
 0x27A3,0x67A3,0xA7A3,0xE7A3,0x37A3,0x77A3,0xB7A3,0xF7A3,
 0x0BA3,0x4BA3,0x8BA3,0xCBA3,0x1BA3,0x5BA3,0x9BA3,0xDBA3,
 0x2BA3,0x6BA3,0xABA3,0xEBA3,0x3BA3,0x7BA3,0xBBA3,0xFBA3,
 0x0FA3,0x4FA3,0x8FA3,0xCFA3,0x1FA3,0x5FA3,0x9FA3,0xDFA3,
 0x2FA3,0x6FA3,0xAFA3,0xEFA3,0x3FA3,0x7FA3,0xBFA3,0xFFA3,
 0x00E3,0x40E3,0x80E3,0xC0E3,0x10E3,0x50E3,0x90E3,0xD0E3,
 0x20E3,0x60E3,0xA0E3,0xE0E3,0x30E3,0x70E3,0xB0E3,0xF0E3,
 0x04E3,0x44E3,0x84E3,0xC4E3,0x14E3,0x54E3,0x94E3,0xD4E3,
 0x24E3,0x64E3,0xA4E3,0xE4E3,0x34E3,0x74E3,0xB4E3,0xF4E3,
 0x08E3,0x48E3,0x88E3,0xC8E3,0x18E3,0x58E3,0x98E3,0xD8E3,
 0x28E3,0x68E3,0xA8E3,0xE8E3,0x38E3,0x78E3,0xB8E3,0xF8E3,
 0x0CE3,0x4CE3,0x8CE3,0xCCE3,0x1CE3,0x5CE3,0x9CE3,0xDCE3,
 0x2CE3,0x6CE3,0xACE3,0xECE3,0x3CE3,0x7CE3,0xBCE3,0xFCE3,
 0x01E3,0x41E3,0x81E3,0xC1E3,0x11E3,0x51E3,0x91E3,0xD1E3,
 0x21E3,0x61E3,0xA1E3,0xE1E3,0x31E3,0x71E3,0xB1E3,0xF1E3,
 0x05E3,0x45E3,0x85E3,0xC5E3,0x15E3,0x55E3,0x95E3,0xD5E3,
 0x25E3,0x65E3,0xA5E3,0xE5E3,0x35E3,0x75E3,0xB5E3,0xF5E3,
 0x09E3,0x49E3,0x89E3,0xC9E3,0x19E3,0x59E3,0x99E3,0xD9E3,
 0x29E3,0x69E3,0xA9E3,0xE9E3,0x39E3,0x79E3,0xB9E3,0xF9E3,
 0x0DE3,0x4DE3,0x8DE3,0xCDE3,0x1DE3,0x5DE3,0x9DE3,0xDDE3,
 0x2DE3,0x6DE3,0xADE3,0xEDE3,0x3DE3,0x7DE3,0xBDE3,0xFDE3,
 0x02E3,0x42E3,0x82E3,0xC2E3,0x12E3,0x52E3,0x92E3,0xD2E3,
 0x22E3,0x62E3,0xA2E3,0xE2E3,0x32E3,0x72E3,0xB2E3,0xF2E3,
 0x06E3,0x46E3,0x86E3,0xC6E3,0x16E3,0x56E3,0x96E3,0xD6E3,
 0x26E3,0x66E3,0xA6E3,0xE6E3,0x36E3,0x76E3,0xB6E3,0xF6E3,
 0x0AE3,0x4AE3,0x8AE3,0xCAE3,0x1AE3,0x5AE3,0x9AE3,0xDAE3,
 0x2AE3,0x6AE3,0xAAE3,0xEAE3,0x3AE3,0x7AE3,0xBAE3,0xFAE3,
 0x0EE3,0x4EE3,0x8EE3,0xCEE3,0x1EE3,0x5EE3,0x9EE3,0xDEE3,
 0x2EE3,0x6EE3,0xAEE3,0xEEE3,0x3EE3,0x7EE3,0xBEE3,0xFEE3,
 0x03E3,0x43E3,0x83E3,0xC3E3,0x13E3,0x53E3,0x93E3,0xD3E3,
 0x23E3,0x63E3,0xA3E3,0xE3E3,0x33E3,0x73E3,0xB3E3,0xF3E3,
 0x07E3,0x47E3,0x87E3,0xC7E3,0x17E3,0x57E3,0x97E3,0xD7E3,
 0x27E3,0x67E3,0xA7E3,0xE7E3,0x37E3,0x77E3,0xB7E3,0xF7E3,
 0x0BE3,0x4BE3,0x8BE3,0xCBE3,0x1BE3,0x5BE3,0x9BE3,0xDBE3,
 0x2BE3,0x6BE3,0xABE3,0xEBE3,0x3BE3,0x7BE3,0xBBE3,0xFBE3,
 0x0FE3,0x4FE3,0x8FE3,0xCFE3,0x1FE3,0x5FE3,0x9FE3,0xDFE3,
 0x2FE3,0x6FE3,0xAFE3,0xEFE3,0x3FE3,0x7FE3,0xBFE3,0xFFE3,
 0x0033,0x4033,0x8033,0xC033,0x1033,0x5033,0x9033,0xD033,
 0x2033,0x6033,0xA033,0xE033,0x3033,0x7033,0xB033,0xF033,
 0x0433,0x4433,0x8433,0xC433,0x1433,0x5433,0x9433,0xD433,
 0x2433,0x6433,0xA433,0xE433,0x3433,0x7433,0xB433,0xF433,
 0x0833,0x4833,0x8833,0xC833,0x1833,0x5833,0x9833,0xD833,
 0x2833,0x6833,0xA833,0xE833,0x3833,0x7833,0xB833,0xF833,
 0x0C33,0x4C33,0x8C33,0xCC33,0x1C33,0x5C33,0x9C33,0xDC33,
 0x2C33,0x6C33,0xAC33,0xEC33,0x3C33,0x7C33,0xBC33,0xFC33,
 0x0133,0x4133,0x8133,0xC133,0x1133,0x5133,0x9133,0xD133,
 0x2133,0x6133,0xA133,0xE133,0x3133,0x7133,0xB133,0xF133,
 0x0533,0x4533,0x8533,0xC533,0x1533,0x5533,0x9533,0xD533,
 0x2533,0x6533,0xA533,0xE533,0x3533,0x7533,0xB533,0xF533,
 0x0933,0x4933,0x8933,0xC933,0x1933,0x5933,0x9933,0xD933,
 0x2933,0x6933,0xA933,0xE933,0x3933,0x7933,0xB933,0xF933,
 0x0D33,0x4D33,0x8D33,0xCD33,0x1D33,0x5D33,0x9D33,0xDD33,
 0x2D33,0x6D33,0xAD33,0xED33,0x3D33,0x7D33,0xBD33,0xFD33,
 0x0233,0x4233,0x8233,0xC233,0x1233,0x5233,0x9233,0xD233,
 0x2233,0x6233,0xA233,0xE233,0x3233,0x7233,0xB233,0xF233,
 0x0633,0x4633,0x8633,0xC633,0x1633,0x5633,0x9633,0xD633,
 0x2633,0x6633,0xA633,0xE633,0x3633,0x7633,0xB633,0xF633,
 0x0A33,0x4A33,0x8A33,0xCA33,0x1A33,0x5A33,0x9A33,0xDA33,
 0x2A33,0x6A33,0xAA33,0xEA33,0x3A33,0x7A33,0xBA33,0xFA33,
 0x0E33,0x4E33,0x8E33,0xCE33,0x1E33,0x5E33,0x9E33,0xDE33,
 0x2E33,0x6E33,0xAE33,0xEE33,0x3E33,0x7E33,0xBE33,0xFE33,
 0x0333,0x4333,0x8333,0xC333,0x1333,0x5333,0x9333,0xD333,
 0x2333,0x6333,0xA333,0xE333,0x3333,0x7333,0xB333,0xF333,
 0x0733,0x4733,0x8733,0xC733,0x1733,0x5733,0x9733,0xD733,
 0x2733,0x6733,0xA733,0xE733,0x3733,0x7733,0xB733,0xF733,
 0x0B33,0x4B33,0x8B33,0xCB33,0x1B33,0x5B33,0x9B33,0xDB33,
 0x2B33,0x6B33,0xAB33,0xEB33,0x3B33,0x7B33,0xBB33,0xFB33,
 0x0F33,0x4F33,0x8F33,0xCF33,0x1F33,0x5F33,0x9F33,0xDF33,
 0x2F33,0x6F33,0xAF33,0xEF33,0x3F33,0x7F33,0xBF33,0xFF33,
 0x0073,0x4073,0x8073,0xC073,0x1073,0x5073,0x9073,0xD073,
 0x2073,0x6073,0xA073,0xE073,0x3073,0x7073,0xB073,0xF073,
 0x0473,0x4473,0x8473,0xC473,0x1473,0x5473,0x9473,0xD473,
 0x2473,0x6473,0xA473,0xE473,0x3473,0x7473,0xB473,0xF473,
 0x0873,0x4873,0x8873,0xC873,0x1873,0x5873,0x9873,0xD873,
 0x2873,0x6873,0xA873,0xE873,0x3873,0x7873,0xB873,0xF873,
 0x0C73,0x4C73,0x8C73,0xCC73,0x1C73,0x5C73,0x9C73,0xDC73,
 0x2C73,0x6C73,0xAC73,0xEC73,0x3C73,0x7C73,0xBC73,0xFC73,
 0x0173,0x4173,0x8173,0xC173,0x1173,0x5173,0x9173,0xD173,
 0x2173,0x6173,0xA173,0xE173,0x3173,0x7173,0xB173,0xF173,
 0x0573,0x4573,0x8573,0xC573,0x1573,0x5573,0x9573,0xD573,
 0x2573,0x6573,0xA573,0xE573,0x3573,0x7573,0xB573,0xF573,
 0x0973,0x4973,0x8973,0xC973,0x1973,0x5973,0x9973,0xD973,
 0x2973,0x6973,0xA973,0xE973,0x3973,0x7973,0xB973,0xF973,
 0x0D73,0x4D73,0x8D73,0xCD73,0x1D73,0x5D73,0x9D73,0xDD73,
 0x2D73,0x6D73,0xAD73,0xED73,0x3D73,0x7D73,0xBD73,0xFD73,
 0x0273,0x4273,0x8273,0xC273,0x1273,0x5273,0x9273,0xD273,
 0x2273,0x6273,0xA273,0xE273,0x3273,0x7273,0xB273,0xF273,
 0x0673,0x4673,0x8673,0xC673,0x1673,0x5673,0x9673,0xD673,
 0x2673,0x6673,0xA673,0xE673,0x3673,0x7673,0xB673,0xF673,
 0x0A73,0x4A73,0x8A73,0xCA73,0x1A73,0x5A73,0x9A73,0xDA73,
 0x2A73,0x6A73,0xAA73,0xEA73,0x3A73,0x7A73,0xBA73,0xFA73,
 0x0E73,0x4E73,0x8E73,0xCE73,0x1E73,0x5E73,0x9E73,0xDE73,
 0x2E73,0x6E73,0xAE73,0xEE73,0x3E73,0x7E73,0xBE73,0xFE73,
 0x0373,0x4373,0x8373,0xC373,0x1373,0x5373,0x9373,0xD373,
 0x2373,0x6373,0xA373,0xE373,0x3373,0x7373,0xB373,0xF373,
 0x0773,0x4773,0x8773,0xC773,0x1773,0x5773,0x9773,0xD773,
 0x2773,0x6773,0xA773,0xE773,0x3773,0x7773,0xB773,0xF773,
 0x0B73,0x4B73,0x8B73,0xCB73,0x1B73,0x5B73,0x9B73,0xDB73,
 0x2B73,0x6B73,0xAB73,0xEB73,0x3B73,0x7B73,0xBB73,0xFB73,
 0x0F73,0x4F73,0x8F73,0xCF73,0x1F73,0x5F73,0x9F73,0xDF73,
 0x2F73,0x6F73,0xAF73,0xEF73,0x3F73,0x7F73,0xBF73,0xFF73,
 0x00B3,0x40B3,0x80B3,0xC0B3,0x10B3,0x50B3,0x90B3,0xD0B3,
 0x20B3,0x60B3,0xA0B3,0xE0B3,0x30B3,0x70B3,0xB0B3,0xF0B3,
 0x04B3,0x44B3,0x84B3,0xC4B3,0x14B3,0x54B3,0x94B3,0xD4B3,
 0x24B3,0x64B3,0xA4B3,0xE4B3,0x34B3,0x74B3,0xB4B3,0xF4B3,
 0x08B3,0x48B3,0x88B3,0xC8B3,0x18B3,0x58B3,0x98B3,0xD8B3,
 0x28B3,0x68B3,0xA8B3,0xE8B3,0x38B3,0x78B3,0xB8B3,0xF8B3,
 0x0CB3,0x4CB3,0x8CB3,0xCCB3,0x1CB3,0x5CB3,0x9CB3,0xDCB3,
 0x2CB3,0x6CB3,0xACB3,0xECB3,0x3CB3,0x7CB3,0xBCB3,0xFCB3,
 0x01B3,0x41B3,0x81B3,0xC1B3,0x11B3,0x51B3,0x91B3,0xD1B3,
 0x21B3,0x61B3,0xA1B3,0xE1B3,0x31B3,0x71B3,0xB1B3,0xF1B3,
 0x05B3,0x45B3,0x85B3,0xC5B3,0x15B3,0x55B3,0x95B3,0xD5B3,
 0x25B3,0x65B3,0xA5B3,0xE5B3,0x35B3,0x75B3,0xB5B3,0xF5B3,
 0x09B3,0x49B3,0x89B3,0xC9B3,0x19B3,0x59B3,0x99B3,0xD9B3,
 0x29B3,0x69B3,0xA9B3,0xE9B3,0x39B3,0x79B3,0xB9B3,0xF9B3,
 0x0DB3,0x4DB3,0x8DB3,0xCDB3,0x1DB3,0x5DB3,0x9DB3,0xDDB3,
 0x2DB3,0x6DB3,0xADB3,0xEDB3,0x3DB3,0x7DB3,0xBDB3,0xFDB3,
 0x02B3,0x42B3,0x82B3,0xC2B3,0x12B3,0x52B3,0x92B3,0xD2B3,
 0x22B3,0x62B3,0xA2B3,0xE2B3,0x32B3,0x72B3,0xB2B3,0xF2B3,
 0x06B3,0x46B3,0x86B3,0xC6B3,0x16B3,0x56B3,0x96B3,0xD6B3,
 0x26B3,0x66B3,0xA6B3,0xE6B3,0x36B3,0x76B3,0xB6B3,0xF6B3,
 0x0AB3,0x4AB3,0x8AB3,0xCAB3,0x1AB3,0x5AB3,0x9AB3,0xDAB3,
 0x2AB3,0x6AB3,0xAAB3,0xEAB3,0x3AB3,0x7AB3,0xBAB3,0xFAB3,
 0x0EB3,0x4EB3,0x8EB3,0xCEB3,0x1EB3,0x5EB3,0x9EB3,0xDEB3,
 0x2EB3,0x6EB3,0xAEB3,0xEEB3,0x3EB3,0x7EB3,0xBEB3,0xFEB3,
 0x03B3,0x43B3,0x83B3,0xC3B3,0x13B3,0x53B3,0x93B3,0xD3B3,
 0x23B3,0x63B3,0xA3B3,0xE3B3,0x33B3,0x73B3,0xB3B3,0xF3B3,
 0x07B3,0x47B3,0x87B3,0xC7B3,0x17B3,0x57B3,0x97B3,0xD7B3,
 0x27B3,0x67B3,0xA7B3,0xE7B3,0x37B3,0x77B3,0xB7B3,0xF7B3,
 0x0BB3,0x4BB3,0x8BB3,0xCBB3,0x1BB3,0x5BB3,0x9BB3,0xDBB3,
 0x2BB3,0x6BB3,0xABB3,0xEBB3,0x3BB3,0x7BB3,0xBBB3,0xFBB3,
 0x0FB3,0x4FB3,0x8FB3,0xCFB3,0x1FB3,0x5FB3,0x9FB3,0xDFB3,
 0x2FB3,0x6FB3,0xAFB3,0xEFB3,0x3FB3,0x7FB3,0xBFB3,0xFFB3,
 0x00F3,0x40F3,0x80F3,0xC0F3,0x10F3,0x50F3,0x90F3,0xD0F3,
 0x20F3,0x60F3,0xA0F3,0xE0F3,0x30F3,0x70F3,0xB0F3,0xF0F3,
 0x04F3,0x44F3,0x84F3,0xC4F3,0x14F3,0x54F3,0x94F3,0xD4F3,
 0x24F3,0x64F3,0xA4F3,0xE4F3,0x34F3,0x74F3,0xB4F3,0xF4F3,
 0x08F3,0x48F3,0x88F3,0xC8F3,0x18F3,0x58F3,0x98F3,0xD8F3,
 0x28F3,0x68F3,0xA8F3,0xE8F3,0x38F3,0x78F3,0xB8F3,0xF8F3,
 0x0CF3,0x4CF3,0x8CF3,0xCCF3,0x1CF3,0x5CF3,0x9CF3,0xDCF3,
 0x2CF3,0x6CF3,0xACF3,0xECF3,0x3CF3,0x7CF3,0xBCF3,0xFCF3,
 0x01F3,0x41F3,0x81F3,0xC1F3,0x11F3,0x51F3,0x91F3,0xD1F3,
 0x21F3,0x61F3,0xA1F3,0xE1F3,0x31F3,0x71F3,0xB1F3,0xF1F3,
 0x05F3,0x45F3,0x85F3,0xC5F3,0x15F3,0x55F3,0x95F3,0xD5F3,
 0x25F3,0x65F3,0xA5F3,0xE5F3,0x35F3,0x75F3,0xB5F3,0xF5F3,
 0x09F3,0x49F3,0x89F3,0xC9F3,0x19F3,0x59F3,0x99F3,0xD9F3,
 0x29F3,0x69F3,0xA9F3,0xE9F3,0x39F3,0x79F3,0xB9F3,0xF9F3,
 0x0DF3,0x4DF3,0x8DF3,0xCDF3,0x1DF3,0x5DF3,0x9DF3,0xDDF3,
 0x2DF3,0x6DF3,0xADF3,0xEDF3,0x3DF3,0x7DF3,0xBDF3,0xFDF3,
 0x02F3,0x42F3,0x82F3,0xC2F3,0x12F3,0x52F3,0x92F3,0xD2F3,
 0x22F3,0x62F3,0xA2F3,0xE2F3,0x32F3,0x72F3,0xB2F3,0xF2F3,
 0x06F3,0x46F3,0x86F3,0xC6F3,0x16F3,0x56F3,0x96F3,0xD6F3,
 0x26F3,0x66F3,0xA6F3,0xE6F3,0x36F3,0x76F3,0xB6F3,0xF6F3,
 0x0AF3,0x4AF3,0x8AF3,0xCAF3,0x1AF3,0x5AF3,0x9AF3,0xDAF3,
 0x2AF3,0x6AF3,0xAAF3,0xEAF3,0x3AF3,0x7AF3,0xBAF3,0xFAF3,
 0x0EF3,0x4EF3,0x8EF3,0xCEF3,0x1EF3,0x5EF3,0x9EF3,0xDEF3,
 0x2EF3,0x6EF3,0xAEF3,0xEEF3,0x3EF3,0x7EF3,0xBEF3,0xFEF3,
 0x03F3,0x43F3,0x83F3,0xC3F3,0x13F3,0x53F3,0x93F3,0xD3F3,
 0x23F3,0x63F3,0xA3F3,0xE3F3,0x33F3,0x73F3,0xB3F3,0xF3F3,
 0x07F3,0x47F3,0x87F3,0xC7F3,0x17F3,0x57F3,0x97F3,0xD7F3,
 0x27F3,0x67F3,0xA7F3,0xE7F3,0x37F3,0x77F3,0xB7F3,0xF7F3,
 0x0BF3,0x4BF3,0x8BF3,0xCBF3,0x1BF3,0x5BF3,0x9BF3,0xDBF3,
 0x2BF3,0x6BF3,0xABF3,0xEBF3,0x3BF3,0x7BF3,0xBBF3,0xFBF3,
 0x0FF3,0x4FF3,0x8FF3,0xCFF3,0x1FF3,0x5FF3,0x9FF3,0xDFF3,
 0x2FF3,0x6FF3,0xAFF3,0xEFF3,0x3FF3,0x7FF3,0xBFF3,0xFFF3,
 0x0007,0x4007,0x8007,0xC007,0x1007,0x5007,0x9007,0xD007,
 0x2007,0x6007,0xA007,0xE007,0x3007,0x7007,0xB007,0xF007,
 0x0407,0x4407,0x8407,0xC407,0x1407,0x5407,0x9407,0xD407,
 0x2407,0x6407,0xA407,0xE407,0x3407,0x7407,0xB407,0xF407,
 0x0807,0x4807,0x8807,0xC807,0x1807,0x5807,0x9807,0xD807,
 0x2807,0x6807,0xA807,0xE807,0x3807,0x7807,0xB807,0xF807,
 0x0C07,0x4C07,0x8C07,0xCC07,0x1C07,0x5C07,0x9C07,0xDC07,
 0x2C07,0x6C07,0xAC07,0xEC07,0x3C07,0x7C07,0xBC07,0xFC07,
 0x0107,0x4107,0x8107,0xC107,0x1107,0x5107,0x9107,0xD107,
 0x2107,0x6107,0xA107,0xE107,0x3107,0x7107,0xB107,0xF107,
 0x0507,0x4507,0x8507,0xC507,0x1507,0x5507,0x9507,0xD507,
 0x2507,0x6507,0xA507,0xE507,0x3507,0x7507,0xB507,0xF507,
 0x0907,0x4907,0x8907,0xC907,0x1907,0x5907,0x9907,0xD907,
 0x2907,0x6907,0xA907,0xE907,0x3907,0x7907,0xB907,0xF907,
 0x0D07,0x4D07,0x8D07,0xCD07,0x1D07,0x5D07,0x9D07,0xDD07,
 0x2D07,0x6D07,0xAD07,0xED07,0x3D07,0x7D07,0xBD07,0xFD07,
 0x0207,0x4207,0x8207,0xC207,0x1207,0x5207,0x9207,0xD207,
 0x2207,0x6207,0xA207,0xE207,0x3207,0x7207,0xB207,0xF207,
 0x0607,0x4607,0x8607,0xC607,0x1607,0x5607,0x9607,0xD607,
 0x2607,0x6607,0xA607,0xE607,0x3607,0x7607,0xB607,0xF607,
 0x0A07,0x4A07,0x8A07,0xCA07,0x1A07,0x5A07,0x9A07,0xDA07,
 0x2A07,0x6A07,0xAA07,0xEA07,0x3A07,0x7A07,0xBA07,0xFA07,
 0x0E07,0x4E07,0x8E07,0xCE07,0x1E07,0x5E07,0x9E07,0xDE07,
 0x2E07,0x6E07,0xAE07,0xEE07,0x3E07,0x7E07,0xBE07,0xFE07,
 0x0307,0x4307,0x8307,0xC307,0x1307,0x5307,0x9307,0xD307,
 0x2307,0x6307,0xA307,0xE307,0x3307,0x7307,0xB307,0xF307,
 0x0707,0x4707,0x8707,0xC707,0x1707,0x5707,0x9707,0xD707,
 0x2707,0x6707,0xA707,0xE707,0x3707,0x7707,0xB707,0xF707,
 0x0B07,0x4B07,0x8B07,0xCB07,0x1B07,0x5B07,0x9B07,0xDB07,
 0x2B07,0x6B07,0xAB07,0xEB07,0x3B07,0x7B07,0xBB07,0xFB07,
 0x0F07,0x4F07,0x8F07,0xCF07,0x1F07,0x5F07,0x9F07,0xDF07,
 0x2F07,0x6F07,0xAF07,0xEF07,0x3F07,0x7F07,0xBF07,0xFF07,
 0x0047,0x4047,0x8047,0xC047,0x1047,0x5047,0x9047,0xD047,
 0x2047,0x6047,0xA047,0xE047,0x3047,0x7047,0xB047,0xF047,
 0x0447,0x4447,0x8447,0xC447,0x1447,0x5447,0x9447,0xD447,
 0x2447,0x6447,0xA447,0xE447,0x3447,0x7447,0xB447,0xF447,
 0x0847,0x4847,0x8847,0xC847,0x1847,0x5847,0x9847,0xD847,
 0x2847,0x6847,0xA847,0xE847,0x3847,0x7847,0xB847,0xF847,
 0x0C47,0x4C47,0x8C47,0xCC47,0x1C47,0x5C47,0x9C47,0xDC47,
 0x2C47,0x6C47,0xAC47,0xEC47,0x3C47,0x7C47,0xBC47,0xFC47,
 0x0147,0x4147,0x8147,0xC147,0x1147,0x5147,0x9147,0xD147,
 0x2147,0x6147,0xA147,0xE147,0x3147,0x7147,0xB147,0xF147,
 0x0547,0x4547,0x8547,0xC547,0x1547,0x5547,0x9547,0xD547,
 0x2547,0x6547,0xA547,0xE547,0x3547,0x7547,0xB547,0xF547,
 0x0947,0x4947,0x8947,0xC947,0x1947,0x5947,0x9947,0xD947,
 0x2947,0x6947,0xA947,0xE947,0x3947,0x7947,0xB947,0xF947,
 0x0D47,0x4D47,0x8D47,0xCD47,0x1D47,0x5D47,0x9D47,0xDD47,
 0x2D47,0x6D47,0xAD47,0xED47,0x3D47,0x7D47,0xBD47,0xFD47,
 0x0247,0x4247,0x8247,0xC247,0x1247,0x5247,0x9247,0xD247,
 0x2247,0x6247,0xA247,0xE247,0x3247,0x7247,0xB247,0xF247,
 0x0647,0x4647,0x8647,0xC647,0x1647,0x5647,0x9647,0xD647,
 0x2647,0x6647,0xA647,0xE647,0x3647,0x7647,0xB647,0xF647,
 0x0A47,0x4A47,0x8A47,0xCA47,0x1A47,0x5A47,0x9A47,0xDA47,
 0x2A47,0x6A47,0xAA47,0xEA47,0x3A47,0x7A47,0xBA47,0xFA47,
 0x0E47,0x4E47,0x8E47,0xCE47,0x1E47,0x5E47,0x9E47,0xDE47,
 0x2E47,0x6E47,0xAE47,0xEE47,0x3E47,0x7E47,0xBE47,0xFE47,
 0x0347,0x4347,0x8347,0xC347,0x1347,0x5347,0x9347,0xD347,
 0x2347,0x6347,0xA347,0xE347,0x3347,0x7347,0xB347,0xF347,
 0x0747,0x4747,0x8747,0xC747,0x1747,0x5747,0x9747,0xD747,
 0x2747,0x6747,0xA747,0xE747,0x3747,0x7747,0xB747,0xF747,
 0x0B47,0x4B47,0x8B47,0xCB47,0x1B47,0x5B47,0x9B47,0xDB47,
 0x2B47,0x6B47,0xAB47,0xEB47,0x3B47,0x7B47,0xBB47,0xFB47,
 0x0F47,0x4F47,0x8F47,0xCF47,0x1F47,0x5F47,0x9F47,0xDF47,
 0x2F47,0x6F47,0xAF47,0xEF47,0x3F47,0x7F47,0xBF47,0xFF47,
 0x0087,0x4087,0x8087,0xC087,0x1087,0x5087,0x9087,0xD087,
 0x2087,0x6087,0xA087,0xE087,0x3087,0x7087,0xB087,0xF087,
 0x0487,0x4487,0x8487,0xC487,0x1487,0x5487,0x9487,0xD487,
 0x2487,0x6487,0xA487,0xE487,0x3487,0x7487,0xB487,0xF487,
 0x0887,0x4887,0x8887,0xC887,0x1887,0x5887,0x9887,0xD887,
 0x2887,0x6887,0xA887,0xE887,0x3887,0x7887,0xB887,0xF887,
 0x0C87,0x4C87,0x8C87,0xCC87,0x1C87,0x5C87,0x9C87,0xDC87,
 0x2C87,0x6C87,0xAC87,0xEC87,0x3C87,0x7C87,0xBC87,0xFC87,
 0x0187,0x4187,0x8187,0xC187,0x1187,0x5187,0x9187,0xD187,
 0x2187,0x6187,0xA187,0xE187,0x3187,0x7187,0xB187,0xF187,
 0x0587,0x4587,0x8587,0xC587,0x1587,0x5587,0x9587,0xD587,
 0x2587,0x6587,0xA587,0xE587,0x3587,0x7587,0xB587,0xF587,
 0x0987,0x4987,0x8987,0xC987,0x1987,0x5987,0x9987,0xD987,
 0x2987,0x6987,0xA987,0xE987,0x3987,0x7987,0xB987,0xF987,
 0x0D87,0x4D87,0x8D87,0xCD87,0x1D87,0x5D87,0x9D87,0xDD87,
 0x2D87,0x6D87,0xAD87,0xED87,0x3D87,0x7D87,0xBD87,0xFD87,
 0x0287,0x4287,0x8287,0xC287,0x1287,0x5287,0x9287,0xD287,
 0x2287,0x6287,0xA287,0xE287,0x3287,0x7287,0xB287,0xF287,
 0x0687,0x4687,0x8687,0xC687,0x1687,0x5687,0x9687,0xD687,
 0x2687,0x6687,0xA687,0xE687,0x3687,0x7687,0xB687,0xF687,
 0x0A87,0x4A87,0x8A87,0xCA87,0x1A87,0x5A87,0x9A87,0xDA87,
 0x2A87,0x6A87,0xAA87,0xEA87,0x3A87,0x7A87,0xBA87,0xFA87,
 0x0E87,0x4E87,0x8E87,0xCE87,0x1E87,0x5E87,0x9E87,0xDE87,
 0x2E87,0x6E87,0xAE87,0xEE87,0x3E87,0x7E87,0xBE87,0xFE87,
 0x0387,0x4387,0x8387,0xC387,0x1387,0x5387,0x9387,0xD387,
 0x2387,0x6387,0xA387,0xE387,0x3387,0x7387,0xB387,0xF387,
 0x0787,0x4787,0x8787,0xC787,0x1787,0x5787,0x9787,0xD787,
 0x2787,0x6787,0xA787,0xE787,0x3787,0x7787,0xB787,0xF787,
 0x0B87,0x4B87,0x8B87,0xCB87,0x1B87,0x5B87,0x9B87,0xDB87,
 0x2B87,0x6B87,0xAB87,0xEB87,0x3B87,0x7B87,0xBB87,0xFB87,
 0x0F87,0x4F87,0x8F87,0xCF87,0x1F87,0x5F87,0x9F87,0xDF87,
 0x2F87,0x6F87,0xAF87,0xEF87,0x3F87,0x7F87,0xBF87,0xFF87,
 0x00C7,0x40C7,0x80C7,0xC0C7,0x10C7,0x50C7,0x90C7,0xD0C7,
 0x20C7,0x60C7,0xA0C7,0xE0C7,0x30C7,0x70C7,0xB0C7,0xF0C7,
 0x04C7,0x44C7,0x84C7,0xC4C7,0x14C7,0x54C7,0x94C7,0xD4C7,
 0x24C7,0x64C7,0xA4C7,0xE4C7,0x34C7,0x74C7,0xB4C7,0xF4C7,
 0x08C7,0x48C7,0x88C7,0xC8C7,0x18C7,0x58C7,0x98C7,0xD8C7,
 0x28C7,0x68C7,0xA8C7,0xE8C7,0x38C7,0x78C7,0xB8C7,0xF8C7,
 0x0CC7,0x4CC7,0x8CC7,0xCCC7,0x1CC7,0x5CC7,0x9CC7,0xDCC7,
 0x2CC7,0x6CC7,0xACC7,0xECC7,0x3CC7,0x7CC7,0xBCC7,0xFCC7,
 0x01C7,0x41C7,0x81C7,0xC1C7,0x11C7,0x51C7,0x91C7,0xD1C7,
 0x21C7,0x61C7,0xA1C7,0xE1C7,0x31C7,0x71C7,0xB1C7,0xF1C7,
 0x05C7,0x45C7,0x85C7,0xC5C7,0x15C7,0x55C7,0x95C7,0xD5C7,
 0x25C7,0x65C7,0xA5C7,0xE5C7,0x35C7,0x75C7,0xB5C7,0xF5C7,
 0x09C7,0x49C7,0x89C7,0xC9C7,0x19C7,0x59C7,0x99C7,0xD9C7,
 0x29C7,0x69C7,0xA9C7,0xE9C7,0x39C7,0x79C7,0xB9C7,0xF9C7,
 0x0DC7,0x4DC7,0x8DC7,0xCDC7,0x1DC7,0x5DC7,0x9DC7,0xDDC7,
 0x2DC7,0x6DC7,0xADC7,0xEDC7,0x3DC7,0x7DC7,0xBDC7,0xFDC7,
 0x02C7,0x42C7,0x82C7,0xC2C7,0x12C7,0x52C7,0x92C7,0xD2C7,
 0x22C7,0x62C7,0xA2C7,0xE2C7,0x32C7,0x72C7,0xB2C7,0xF2C7,
 0x06C7,0x46C7,0x86C7,0xC6C7,0x16C7,0x56C7,0x96C7,0xD6C7,
 0x26C7,0x66C7,0xA6C7,0xE6C7,0x36C7,0x76C7,0xB6C7,0xF6C7,
 0x0AC7,0x4AC7,0x8AC7,0xCAC7,0x1AC7,0x5AC7,0x9AC7,0xDAC7,
 0x2AC7,0x6AC7,0xAAC7,0xEAC7,0x3AC7,0x7AC7,0xBAC7,0xFAC7,
 0x0EC7,0x4EC7,0x8EC7,0xCEC7,0x1EC7,0x5EC7,0x9EC7,0xDEC7,
 0x2EC7,0x6EC7,0xAEC7,0xEEC7,0x3EC7,0x7EC7,0xBEC7,0xFEC7,
 0x03C7,0x43C7,0x83C7,0xC3C7,0x13C7,0x53C7,0x93C7,0xD3C7,
 0x23C7,0x63C7,0xA3C7,0xE3C7,0x33C7,0x73C7,0xB3C7,0xF3C7,
 0x07C7,0x47C7,0x87C7,0xC7C7,0x17C7,0x57C7,0x97C7,0xD7C7,
 0x27C7,0x67C7,0xA7C7,0xE7C7,0x37C7,0x77C7,0xB7C7,0xF7C7,
 0x0BC7,0x4BC7,0x8BC7,0xCBC7,0x1BC7,0x5BC7,0x9BC7,0xDBC7,
 0x2BC7,0x6BC7,0xABC7,0xEBC7,0x3BC7,0x7BC7,0xBBC7,0xFBC7,
 0x0FC7,0x4FC7,0x8FC7,0xCFC7,0x1FC7,0x5FC7,0x9FC7,0xDFC7,
 0x2FC7,0x6FC7,0xAFC7,0xEFC7,0x3FC7,0x7FC7,0xBFC7,0xFFC7,
 0x0017,0x4017,0x8017,0xC017,0x1017,0x5017,0x9017,0xD017,
 0x2017,0x6017,0xA017,0xE017,0x3017,0x7017,0xB017,0xF017,
 0x0417,0x4417,0x8417,0xC417,0x1417,0x5417,0x9417,0xD417,
 0x2417,0x6417,0xA417,0xE417,0x3417,0x7417,0xB417,0xF417,
 0x0817,0x4817,0x8817,0xC817,0x1817,0x5817,0x9817,0xD817,
 0x2817,0x6817,0xA817,0xE817,0x3817,0x7817,0xB817,0xF817,
 0x0C17,0x4C17,0x8C17,0xCC17,0x1C17,0x5C17,0x9C17,0xDC17,
 0x2C17,0x6C17,0xAC17,0xEC17,0x3C17,0x7C17,0xBC17,0xFC17,
 0x0117,0x4117,0x8117,0xC117,0x1117,0x5117,0x9117,0xD117,
 0x2117,0x6117,0xA117,0xE117,0x3117,0x7117,0xB117,0xF117,
 0x0517,0x4517,0x8517,0xC517,0x1517,0x5517,0x9517,0xD517,
 0x2517,0x6517,0xA517,0xE517,0x3517,0x7517,0xB517,0xF517,
 0x0917,0x4917,0x8917,0xC917,0x1917,0x5917,0x9917,0xD917,
 0x2917,0x6917,0xA917,0xE917,0x3917,0x7917,0xB917,0xF917,
 0x0D17,0x4D17,0x8D17,0xCD17,0x1D17,0x5D17,0x9D17,0xDD17,
 0x2D17,0x6D17,0xAD17,0xED17,0x3D17,0x7D17,0xBD17,0xFD17,
 0x0217,0x4217,0x8217,0xC217,0x1217,0x5217,0x9217,0xD217,
 0x2217,0x6217,0xA217,0xE217,0x3217,0x7217,0xB217,0xF217,
 0x0617,0x4617,0x8617,0xC617,0x1617,0x5617,0x9617,0xD617,
 0x2617,0x6617,0xA617,0xE617,0x3617,0x7617,0xB617,0xF617,
 0x0A17,0x4A17,0x8A17,0xCA17,0x1A17,0x5A17,0x9A17,0xDA17,
 0x2A17,0x6A17,0xAA17,0xEA17,0x3A17,0x7A17,0xBA17,0xFA17,
 0x0E17,0x4E17,0x8E17,0xCE17,0x1E17,0x5E17,0x9E17,0xDE17,
 0x2E17,0x6E17,0xAE17,0xEE17,0x3E17,0x7E17,0xBE17,0xFE17,
 0x0317,0x4317,0x8317,0xC317,0x1317,0x5317,0x9317,0xD317,
 0x2317,0x6317,0xA317,0xE317,0x3317,0x7317,0xB317,0xF317,
 0x0717,0x4717,0x8717,0xC717,0x1717,0x5717,0x9717,0xD717,
 0x2717,0x6717,0xA717,0xE717,0x3717,0x7717,0xB717,0xF717,
 0x0B17,0x4B17,0x8B17,0xCB17,0x1B17,0x5B17,0x9B17,0xDB17,
 0x2B17,0x6B17,0xAB17,0xEB17,0x3B17,0x7B17,0xBB17,0xFB17,
 0x0F17,0x4F17,0x8F17,0xCF17,0x1F17,0x5F17,0x9F17,0xDF17,
 0x2F17,0x6F17,0xAF17,0xEF17,0x3F17,0x7F17,0xBF17,0xFF17,
 0x0057,0x4057,0x8057,0xC057,0x1057,0x5057,0x9057,0xD057,
 0x2057,0x6057,0xA057,0xE057,0x3057,0x7057,0xB057,0xF057,
 0x0457,0x4457,0x8457,0xC457,0x1457,0x5457,0x9457,0xD457,
 0x2457,0x6457,0xA457,0xE457,0x3457,0x7457,0xB457,0xF457,
 0x0857,0x4857,0x8857,0xC857,0x1857,0x5857,0x9857,0xD857,
 0x2857,0x6857,0xA857,0xE857,0x3857,0x7857,0xB857,0xF857,
 0x0C57,0x4C57,0x8C57,0xCC57,0x1C57,0x5C57,0x9C57,0xDC57,
 0x2C57,0x6C57,0xAC57,0xEC57,0x3C57,0x7C57,0xBC57,0xFC57,
 0x0157,0x4157,0x8157,0xC157,0x1157,0x5157,0x9157,0xD157,
 0x2157,0x6157,0xA157,0xE157,0x3157,0x7157,0xB157,0xF157,
 0x0557,0x4557,0x8557,0xC557,0x1557,0x5557,0x9557,0xD557,
 0x2557,0x6557,0xA557,0xE557,0x3557,0x7557,0xB557,0xF557,
 0x0957,0x4957,0x8957,0xC957,0x1957,0x5957,0x9957,0xD957,
 0x2957,0x6957,0xA957,0xE957,0x3957,0x7957,0xB957,0xF957,
 0x0D57,0x4D57,0x8D57,0xCD57,0x1D57,0x5D57,0x9D57,0xDD57,
 0x2D57,0x6D57,0xAD57,0xED57,0x3D57,0x7D57,0xBD57,0xFD57,
 0x0257,0x4257,0x8257,0xC257,0x1257,0x5257,0x9257,0xD257,
 0x2257,0x6257,0xA257,0xE257,0x3257,0x7257,0xB257,0xF257,
 0x0657,0x4657,0x8657,0xC657,0x1657,0x5657,0x9657,0xD657,
 0x2657,0x6657,0xA657,0xE657,0x3657,0x7657,0xB657,0xF657,
 0x0A57,0x4A57,0x8A57,0xCA57,0x1A57,0x5A57,0x9A57,0xDA57,
 0x2A57,0x6A57,0xAA57,0xEA57,0x3A57,0x7A57,0xBA57,0xFA57,
 0x0E57,0x4E57,0x8E57,0xCE57,0x1E57,0x5E57,0x9E57,0xDE57,
 0x2E57,0x6E57,0xAE57,0xEE57,0x3E57,0x7E57,0xBE57,0xFE57,
 0x0357,0x4357,0x8357,0xC357,0x1357,0x5357,0x9357,0xD357,
 0x2357,0x6357,0xA357,0xE357,0x3357,0x7357,0xB357,0xF357,
 0x0757,0x4757,0x8757,0xC757,0x1757,0x5757,0x9757,0xD757,
 0x2757,0x6757,0xA757,0xE757,0x3757,0x7757,0xB757,0xF757,
 0x0B57,0x4B57,0x8B57,0xCB57,0x1B57,0x5B57,0x9B57,0xDB57,
 0x2B57,0x6B57,0xAB57,0xEB57,0x3B57,0x7B57,0xBB57,0xFB57,
 0x0F57,0x4F57,0x8F57,0xCF57,0x1F57,0x5F57,0x9F57,0xDF57,
 0x2F57,0x6F57,0xAF57,0xEF57,0x3F57,0x7F57,0xBF57,0xFF57,
 0x0097,0x4097,0x8097,0xC097,0x1097,0x5097,0x9097,0xD097,
 0x2097,0x6097,0xA097,0xE097,0x3097,0x7097,0xB097,0xF097,
 0x0497,0x4497,0x8497,0xC497,0x1497,0x5497,0x9497,0xD497,
 0x2497,0x6497,0xA497,0xE497,0x3497,0x7497,0xB497,0xF497,
 0x0897,0x4897,0x8897,0xC897,0x1897,0x5897,0x9897,0xD897,
 0x2897,0x6897,0xA897,0xE897,0x3897,0x7897,0xB897,0xF897,
 0x0C97,0x4C97,0x8C97,0xCC97,0x1C97,0x5C97,0x9C97,0xDC97,
 0x2C97,0x6C97,0xAC97,0xEC97,0x3C97,0x7C97,0xBC97,0xFC97,
 0x0197,0x4197,0x8197,0xC197,0x1197,0x5197,0x9197,0xD197,
 0x2197,0x6197,0xA197,0xE197,0x3197,0x7197,0xB197,0xF197,
 0x0597,0x4597,0x8597,0xC597,0x1597,0x5597,0x9597,0xD597,
 0x2597,0x6597,0xA597,0xE597,0x3597,0x7597,0xB597,0xF597,
 0x0997,0x4997,0x8997,0xC997,0x1997,0x5997,0x9997,0xD997,
 0x2997,0x6997,0xA997,0xE997,0x3997,0x7997,0xB997,0xF997,
 0x0D97,0x4D97,0x8D97,0xCD97,0x1D97,0x5D97,0x9D97,0xDD97,
 0x2D97,0x6D97,0xAD97,0xED97,0x3D97,0x7D97,0xBD97,0xFD97,
 0x0297,0x4297,0x8297,0xC297,0x1297,0x5297,0x9297,0xD297,
 0x2297,0x6297,0xA297,0xE297,0x3297,0x7297,0xB297,0xF297,
 0x0697,0x4697,0x8697,0xC697,0x1697,0x5697,0x9697,0xD697,
 0x2697,0x6697,0xA697,0xE697,0x3697,0x7697,0xB697,0xF697,
 0x0A97,0x4A97,0x8A97,0xCA97,0x1A97,0x5A97,0x9A97,0xDA97,
 0x2A97,0x6A97,0xAA97,0xEA97,0x3A97,0x7A97,0xBA97,0xFA97,
 0x0E97,0x4E97,0x8E97,0xCE97,0x1E97,0x5E97,0x9E97,0xDE97,
 0x2E97,0x6E97,0xAE97,0xEE97,0x3E97,0x7E97,0xBE97,0xFE97,
 0x0397,0x4397,0x8397,0xC397,0x1397,0x5397,0x9397,0xD397,
 0x2397,0x6397,0xA397,0xE397,0x3397,0x7397,0xB397,0xF397,
 0x0797,0x4797,0x8797,0xC797,0x1797,0x5797,0x9797,0xD797,
 0x2797,0x6797,0xA797,0xE797,0x3797,0x7797,0xB797,0xF797,
 0x0B97,0x4B97,0x8B97,0xCB97,0x1B97,0x5B97,0x9B97,0xDB97,
 0x2B97,0x6B97,0xAB97,0xEB97,0x3B97,0x7B97,0xBB97,0xFB97,
 0x0F97,0x4F97,0x8F97,0xCF97,0x1F97,0x5F97,0x9F97,0xDF97,
 0x2F97,0x6F97,0xAF97,0xEF97,0x3F97,0x7F97,0xBF97,0xFF97,
 0x00D7,0x40D7,0x80D7,0xC0D7,0x10D7,0x50D7,0x90D7,0xD0D7,
 0x20D7,0x60D7,0xA0D7,0xE0D7,0x30D7,0x70D7,0xB0D7,0xF0D7,
 0x04D7,0x44D7,0x84D7,0xC4D7,0x14D7,0x54D7,0x94D7,0xD4D7,
 0x24D7,0x64D7,0xA4D7,0xE4D7,0x34D7,0x74D7,0xB4D7,0xF4D7,
 0x08D7,0x48D7,0x88D7,0xC8D7,0x18D7,0x58D7,0x98D7,0xD8D7,
 0x28D7,0x68D7,0xA8D7,0xE8D7,0x38D7,0x78D7,0xB8D7,0xF8D7,
 0x0CD7,0x4CD7,0x8CD7,0xCCD7,0x1CD7,0x5CD7,0x9CD7,0xDCD7,
 0x2CD7,0x6CD7,0xACD7,0xECD7,0x3CD7,0x7CD7,0xBCD7,0xFCD7,
 0x01D7,0x41D7,0x81D7,0xC1D7,0x11D7,0x51D7,0x91D7,0xD1D7,
 0x21D7,0x61D7,0xA1D7,0xE1D7,0x31D7,0x71D7,0xB1D7,0xF1D7,
 0x05D7,0x45D7,0x85D7,0xC5D7,0x15D7,0x55D7,0x95D7,0xD5D7,
 0x25D7,0x65D7,0xA5D7,0xE5D7,0x35D7,0x75D7,0xB5D7,0xF5D7,
 0x09D7,0x49D7,0x89D7,0xC9D7,0x19D7,0x59D7,0x99D7,0xD9D7,
 0x29D7,0x69D7,0xA9D7,0xE9D7,0x39D7,0x79D7,0xB9D7,0xF9D7,
 0x0DD7,0x4DD7,0x8DD7,0xCDD7,0x1DD7,0x5DD7,0x9DD7,0xDDD7,
 0x2DD7,0x6DD7,0xADD7,0xEDD7,0x3DD7,0x7DD7,0xBDD7,0xFDD7,
 0x02D7,0x42D7,0x82D7,0xC2D7,0x12D7,0x52D7,0x92D7,0xD2D7,
 0x22D7,0x62D7,0xA2D7,0xE2D7,0x32D7,0x72D7,0xB2D7,0xF2D7,
 0x06D7,0x46D7,0x86D7,0xC6D7,0x16D7,0x56D7,0x96D7,0xD6D7,
 0x26D7,0x66D7,0xA6D7,0xE6D7,0x36D7,0x76D7,0xB6D7,0xF6D7,
 0x0AD7,0x4AD7,0x8AD7,0xCAD7,0x1AD7,0x5AD7,0x9AD7,0xDAD7,
 0x2AD7,0x6AD7,0xAAD7,0xEAD7,0x3AD7,0x7AD7,0xBAD7,0xFAD7,
 0x0ED7,0x4ED7,0x8ED7,0xCED7,0x1ED7,0x5ED7,0x9ED7,0xDED7,
 0x2ED7,0x6ED7,0xAED7,0xEED7,0x3ED7,0x7ED7,0xBED7,0xFED7,
 0x03D7,0x43D7,0x83D7,0xC3D7,0x13D7,0x53D7,0x93D7,0xD3D7,
 0x23D7,0x63D7,0xA3D7,0xE3D7,0x33D7,0x73D7,0xB3D7,0xF3D7,
 0x07D7,0x47D7,0x87D7,0xC7D7,0x17D7,0x57D7,0x97D7,0xD7D7,
 0x27D7,0x67D7,0xA7D7,0xE7D7,0x37D7,0x77D7,0xB7D7,0xF7D7,
 0x0BD7,0x4BD7,0x8BD7,0xCBD7,0x1BD7,0x5BD7,0x9BD7,0xDBD7,
 0x2BD7,0x6BD7,0xABD7,0xEBD7,0x3BD7,0x7BD7,0xBBD7,0xFBD7,
 0x0FD7,0x4FD7,0x8FD7,0xCFD7,0x1FD7,0x5FD7,0x9FD7,0xDFD7,
 0x2FD7,0x6FD7,0xAFD7,0xEFD7,0x3FD7,0x7FD7,0xBFD7,0xFFD7,
 0x0027,0x4027,0x8027,0xC027,0x1027,0x5027,0x9027,0xD027,
 0x2027,0x6027,0xA027,0xE027,0x3027,0x7027,0xB027,0xF027,
 0x0427,0x4427,0x8427,0xC427,0x1427,0x5427,0x9427,0xD427,
 0x2427,0x6427,0xA427,0xE427,0x3427,0x7427,0xB427,0xF427,
 0x0827,0x4827,0x8827,0xC827,0x1827,0x5827,0x9827,0xD827,
 0x2827,0x6827,0xA827,0xE827,0x3827,0x7827,0xB827,0xF827,
 0x0C27,0x4C27,0x8C27,0xCC27,0x1C27,0x5C27,0x9C27,0xDC27,
 0x2C27,0x6C27,0xAC27,0xEC27,0x3C27,0x7C27,0xBC27,0xFC27,
 0x0127,0x4127,0x8127,0xC127,0x1127,0x5127,0x9127,0xD127,
 0x2127,0x6127,0xA127,0xE127,0x3127,0x7127,0xB127,0xF127,
 0x0527,0x4527,0x8527,0xC527,0x1527,0x5527,0x9527,0xD527,
 0x2527,0x6527,0xA527,0xE527,0x3527,0x7527,0xB527,0xF527,
 0x0927,0x4927,0x8927,0xC927,0x1927,0x5927,0x9927,0xD927,
 0x2927,0x6927,0xA927,0xE927,0x3927,0x7927,0xB927,0xF927,
 0x0D27,0x4D27,0x8D27,0xCD27,0x1D27,0x5D27,0x9D27,0xDD27,
 0x2D27,0x6D27,0xAD27,0xED27,0x3D27,0x7D27,0xBD27,0xFD27,
 0x0227,0x4227,0x8227,0xC227,0x1227,0x5227,0x9227,0xD227,
 0x2227,0x6227,0xA227,0xE227,0x3227,0x7227,0xB227,0xF227,
 0x0627,0x4627,0x8627,0xC627,0x1627,0x5627,0x9627,0xD627,
 0x2627,0x6627,0xA627,0xE627,0x3627,0x7627,0xB627,0xF627,
 0x0A27,0x4A27,0x8A27,0xCA27,0x1A27,0x5A27,0x9A27,0xDA27,
 0x2A27,0x6A27,0xAA27,0xEA27,0x3A27,0x7A27,0xBA27,0xFA27,
 0x0E27,0x4E27,0x8E27,0xCE27,0x1E27,0x5E27,0x9E27,0xDE27,
 0x2E27,0x6E27,0xAE27,0xEE27,0x3E27,0x7E27,0xBE27,0xFE27,
 0x0327,0x4327,0x8327,0xC327,0x1327,0x5327,0x9327,0xD327,
 0x2327,0x6327,0xA327,0xE327,0x3327,0x7327,0xB327,0xF327,
 0x0727,0x4727,0x8727,0xC727,0x1727,0x5727,0x9727,0xD727,
 0x2727,0x6727,0xA727,0xE727,0x3727,0x7727,0xB727,0xF727,
 0x0B27,0x4B27,0x8B27,0xCB27,0x1B27,0x5B27,0x9B27,0xDB27,
 0x2B27,0x6B27,0xAB27,0xEB27,0x3B27,0x7B27,0xBB27,0xFB27,
 0x0F27,0x4F27,0x8F27,0xCF27,0x1F27,0x5F27,0x9F27,0xDF27,
 0x2F27,0x6F27,0xAF27,0xEF27,0x3F27,0x7F27,0xBF27,0xFF27,
 0x0067,0x4067,0x8067,0xC067,0x1067,0x5067,0x9067,0xD067,
 0x2067,0x6067,0xA067,0xE067,0x3067,0x7067,0xB067,0xF067,
 0x0467,0x4467,0x8467,0xC467,0x1467,0x5467,0x9467,0xD467,
 0x2467,0x6467,0xA467,0xE467,0x3467,0x7467,0xB467,0xF467,
 0x0867,0x4867,0x8867,0xC867,0x1867,0x5867,0x9867,0xD867,
 0x2867,0x6867,0xA867,0xE867,0x3867,0x7867,0xB867,0xF867,
 0x0C67,0x4C67,0x8C67,0xCC67,0x1C67,0x5C67,0x9C67,0xDC67,
 0x2C67,0x6C67,0xAC67,0xEC67,0x3C67,0x7C67,0xBC67,0xFC67,
 0x0167,0x4167,0x8167,0xC167,0x1167,0x5167,0x9167,0xD167,
 0x2167,0x6167,0xA167,0xE167,0x3167,0x7167,0xB167,0xF167,
 0x0567,0x4567,0x8567,0xC567,0x1567,0x5567,0x9567,0xD567,
 0x2567,0x6567,0xA567,0xE567,0x3567,0x7567,0xB567,0xF567,
 0x0967,0x4967,0x8967,0xC967,0x1967,0x5967,0x9967,0xD967,
 0x2967,0x6967,0xA967,0xE967,0x3967,0x7967,0xB967,0xF967,
 0x0D67,0x4D67,0x8D67,0xCD67,0x1D67,0x5D67,0x9D67,0xDD67,
 0x2D67,0x6D67,0xAD67,0xED67,0x3D67,0x7D67,0xBD67,0xFD67,
 0x0267,0x4267,0x8267,0xC267,0x1267,0x5267,0x9267,0xD267,
 0x2267,0x6267,0xA267,0xE267,0x3267,0x7267,0xB267,0xF267,
 0x0667,0x4667,0x8667,0xC667,0x1667,0x5667,0x9667,0xD667,
 0x2667,0x6667,0xA667,0xE667,0x3667,0x7667,0xB667,0xF667,
 0x0A67,0x4A67,0x8A67,0xCA67,0x1A67,0x5A67,0x9A67,0xDA67,
 0x2A67,0x6A67,0xAA67,0xEA67,0x3A67,0x7A67,0xBA67,0xFA67,
 0x0E67,0x4E67,0x8E67,0xCE67,0x1E67,0x5E67,0x9E67,0xDE67,
 0x2E67,0x6E67,0xAE67,0xEE67,0x3E67,0x7E67,0xBE67,0xFE67,
 0x0367,0x4367,0x8367,0xC367,0x1367,0x5367,0x9367,0xD367,
 0x2367,0x6367,0xA367,0xE367,0x3367,0x7367,0xB367,0xF367,
 0x0767,0x4767,0x8767,0xC767,0x1767,0x5767,0x9767,0xD767,
 0x2767,0x6767,0xA767,0xE767,0x3767,0x7767,0xB767,0xF767,
 0x0B67,0x4B67,0x8B67,0xCB67,0x1B67,0x5B67,0x9B67,0xDB67,
 0x2B67,0x6B67,0xAB67,0xEB67,0x3B67,0x7B67,0xBB67,0xFB67,
 0x0F67,0x4F67,0x8F67,0xCF67,0x1F67,0x5F67,0x9F67,0xDF67,
 0x2F67,0x6F67,0xAF67,0xEF67,0x3F67,0x7F67,0xBF67,0xFF67,
 0x00A7,0x40A7,0x80A7,0xC0A7,0x10A7,0x50A7,0x90A7,0xD0A7,
 0x20A7,0x60A7,0xA0A7,0xE0A7,0x30A7,0x70A7,0xB0A7,0xF0A7,
 0x04A7,0x44A7,0x84A7,0xC4A7,0x14A7,0x54A7,0x94A7,0xD4A7,
 0x24A7,0x64A7,0xA4A7,0xE4A7,0x34A7,0x74A7,0xB4A7,0xF4A7,
 0x08A7,0x48A7,0x88A7,0xC8A7,0x18A7,0x58A7,0x98A7,0xD8A7,
 0x28A7,0x68A7,0xA8A7,0xE8A7,0x38A7,0x78A7,0xB8A7,0xF8A7,
 0x0CA7,0x4CA7,0x8CA7,0xCCA7,0x1CA7,0x5CA7,0x9CA7,0xDCA7,
 0x2CA7,0x6CA7,0xACA7,0xECA7,0x3CA7,0x7CA7,0xBCA7,0xFCA7,
 0x01A7,0x41A7,0x81A7,0xC1A7,0x11A7,0x51A7,0x91A7,0xD1A7,
 0x21A7,0x61A7,0xA1A7,0xE1A7,0x31A7,0x71A7,0xB1A7,0xF1A7,
 0x05A7,0x45A7,0x85A7,0xC5A7,0x15A7,0x55A7,0x95A7,0xD5A7,
 0x25A7,0x65A7,0xA5A7,0xE5A7,0x35A7,0x75A7,0xB5A7,0xF5A7,
 0x09A7,0x49A7,0x89A7,0xC9A7,0x19A7,0x59A7,0x99A7,0xD9A7,
 0x29A7,0x69A7,0xA9A7,0xE9A7,0x39A7,0x79A7,0xB9A7,0xF9A7,
 0x0DA7,0x4DA7,0x8DA7,0xCDA7,0x1DA7,0x5DA7,0x9DA7,0xDDA7,
 0x2DA7,0x6DA7,0xADA7,0xEDA7,0x3DA7,0x7DA7,0xBDA7,0xFDA7,
 0x02A7,0x42A7,0x82A7,0xC2A7,0x12A7,0x52A7,0x92A7,0xD2A7,
 0x22A7,0x62A7,0xA2A7,0xE2A7,0x32A7,0x72A7,0xB2A7,0xF2A7,
 0x06A7,0x46A7,0x86A7,0xC6A7,0x16A7,0x56A7,0x96A7,0xD6A7,
 0x26A7,0x66A7,0xA6A7,0xE6A7,0x36A7,0x76A7,0xB6A7,0xF6A7,
 0x0AA7,0x4AA7,0x8AA7,0xCAA7,0x1AA7,0x5AA7,0x9AA7,0xDAA7,
 0x2AA7,0x6AA7,0xAAA7,0xEAA7,0x3AA7,0x7AA7,0xBAA7,0xFAA7,
 0x0EA7,0x4EA7,0x8EA7,0xCEA7,0x1EA7,0x5EA7,0x9EA7,0xDEA7,
 0x2EA7,0x6EA7,0xAEA7,0xEEA7,0x3EA7,0x7EA7,0xBEA7,0xFEA7,
 0x03A7,0x43A7,0x83A7,0xC3A7,0x13A7,0x53A7,0x93A7,0xD3A7,
 0x23A7,0x63A7,0xA3A7,0xE3A7,0x33A7,0x73A7,0xB3A7,0xF3A7,
 0x07A7,0x47A7,0x87A7,0xC7A7,0x17A7,0x57A7,0x97A7,0xD7A7,
 0x27A7,0x67A7,0xA7A7,0xE7A7,0x37A7,0x77A7,0xB7A7,0xF7A7,
 0x0BA7,0x4BA7,0x8BA7,0xCBA7,0x1BA7,0x5BA7,0x9BA7,0xDBA7,
 0x2BA7,0x6BA7,0xABA7,0xEBA7,0x3BA7,0x7BA7,0xBBA7,0xFBA7,
 0x0FA7,0x4FA7,0x8FA7,0xCFA7,0x1FA7,0x5FA7,0x9FA7,0xDFA7,
 0x2FA7,0x6FA7,0xAFA7,0xEFA7,0x3FA7,0x7FA7,0xBFA7,0xFFA7,
 0x00E7,0x40E7,0x80E7,0xC0E7,0x10E7,0x50E7,0x90E7,0xD0E7,
 0x20E7,0x60E7,0xA0E7,0xE0E7,0x30E7,0x70E7,0xB0E7,0xF0E7,
 0x04E7,0x44E7,0x84E7,0xC4E7,0x14E7,0x54E7,0x94E7,0xD4E7,
 0x24E7,0x64E7,0xA4E7,0xE4E7,0x34E7,0x74E7,0xB4E7,0xF4E7,
 0x08E7,0x48E7,0x88E7,0xC8E7,0x18E7,0x58E7,0x98E7,0xD8E7,
 0x28E7,0x68E7,0xA8E7,0xE8E7,0x38E7,0x78E7,0xB8E7,0xF8E7,
 0x0CE7,0x4CE7,0x8CE7,0xCCE7,0x1CE7,0x5CE7,0x9CE7,0xDCE7,
 0x2CE7,0x6CE7,0xACE7,0xECE7,0x3CE7,0x7CE7,0xBCE7,0xFCE7,
 0x01E7,0x41E7,0x81E7,0xC1E7,0x11E7,0x51E7,0x91E7,0xD1E7,
 0x21E7,0x61E7,0xA1E7,0xE1E7,0x31E7,0x71E7,0xB1E7,0xF1E7,
 0x05E7,0x45E7,0x85E7,0xC5E7,0x15E7,0x55E7,0x95E7,0xD5E7,
 0x25E7,0x65E7,0xA5E7,0xE5E7,0x35E7,0x75E7,0xB5E7,0xF5E7,
 0x09E7,0x49E7,0x89E7,0xC9E7,0x19E7,0x59E7,0x99E7,0xD9E7,
 0x29E7,0x69E7,0xA9E7,0xE9E7,0x39E7,0x79E7,0xB9E7,0xF9E7,
 0x0DE7,0x4DE7,0x8DE7,0xCDE7,0x1DE7,0x5DE7,0x9DE7,0xDDE7,
 0x2DE7,0x6DE7,0xADE7,0xEDE7,0x3DE7,0x7DE7,0xBDE7,0xFDE7,
 0x02E7,0x42E7,0x82E7,0xC2E7,0x12E7,0x52E7,0x92E7,0xD2E7,
 0x22E7,0x62E7,0xA2E7,0xE2E7,0x32E7,0x72E7,0xB2E7,0xF2E7,
 0x06E7,0x46E7,0x86E7,0xC6E7,0x16E7,0x56E7,0x96E7,0xD6E7,
 0x26E7,0x66E7,0xA6E7,0xE6E7,0x36E7,0x76E7,0xB6E7,0xF6E7,
 0x0AE7,0x4AE7,0x8AE7,0xCAE7,0x1AE7,0x5AE7,0x9AE7,0xDAE7,
 0x2AE7,0x6AE7,0xAAE7,0xEAE7,0x3AE7,0x7AE7,0xBAE7,0xFAE7,
 0x0EE7,0x4EE7,0x8EE7,0xCEE7,0x1EE7,0x5EE7,0x9EE7,0xDEE7,
 0x2EE7,0x6EE7,0xAEE7,0xEEE7,0x3EE7,0x7EE7,0xBEE7,0xFEE7,
 0x03E7,0x43E7,0x83E7,0xC3E7,0x13E7,0x53E7,0x93E7,0xD3E7,
 0x23E7,0x63E7,0xA3E7,0xE3E7,0x33E7,0x73E7,0xB3E7,0xF3E7,
 0x07E7,0x47E7,0x87E7,0xC7E7,0x17E7,0x57E7,0x97E7,0xD7E7,
 0x27E7,0x67E7,0xA7E7,0xE7E7,0x37E7,0x77E7,0xB7E7,0xF7E7,
 0x0BE7,0x4BE7,0x8BE7,0xCBE7,0x1BE7,0x5BE7,0x9BE7,0xDBE7,
 0x2BE7,0x6BE7,0xABE7,0xEBE7,0x3BE7,0x7BE7,0xBBE7,0xFBE7,
 0x0FE7,0x4FE7,0x8FE7,0xCFE7,0x1FE7,0x5FE7,0x9FE7,0xDFE7,
 0x2FE7,0x6FE7,0xAFE7,0xEFE7,0x3FE7,0x7FE7,0xBFE7,0xFFE7,
 0x0037,0x4037,0x8037,0xC037,0x1037,0x5037,0x9037,0xD037,
 0x2037,0x6037,0xA037,0xE037,0x3037,0x7037,0xB037,0xF037,
 0x0437,0x4437,0x8437,0xC437,0x1437,0x5437,0x9437,0xD437,
 0x2437,0x6437,0xA437,0xE437,0x3437,0x7437,0xB437,0xF437,
 0x0837,0x4837,0x8837,0xC837,0x1837,0x5837,0x9837,0xD837,
 0x2837,0x6837,0xA837,0xE837,0x3837,0x7837,0xB837,0xF837,
 0x0C37,0x4C37,0x8C37,0xCC37,0x1C37,0x5C37,0x9C37,0xDC37,
 0x2C37,0x6C37,0xAC37,0xEC37,0x3C37,0x7C37,0xBC37,0xFC37,
 0x0137,0x4137,0x8137,0xC137,0x1137,0x5137,0x9137,0xD137,
 0x2137,0x6137,0xA137,0xE137,0x3137,0x7137,0xB137,0xF137,
 0x0537,0x4537,0x8537,0xC537,0x1537,0x5537,0x9537,0xD537,
 0x2537,0x6537,0xA537,0xE537,0x3537,0x7537,0xB537,0xF537,
 0x0937,0x4937,0x8937,0xC937,0x1937,0x5937,0x9937,0xD937,
 0x2937,0x6937,0xA937,0xE937,0x3937,0x7937,0xB937,0xF937,
 0x0D37,0x4D37,0x8D37,0xCD37,0x1D37,0x5D37,0x9D37,0xDD37,
 0x2D37,0x6D37,0xAD37,0xED37,0x3D37,0x7D37,0xBD37,0xFD37,
 0x0237,0x4237,0x8237,0xC237,0x1237,0x5237,0x9237,0xD237,
 0x2237,0x6237,0xA237,0xE237,0x3237,0x7237,0xB237,0xF237,
 0x0637,0x4637,0x8637,0xC637,0x1637,0x5637,0x9637,0xD637,
 0x2637,0x6637,0xA637,0xE637,0x3637,0x7637,0xB637,0xF637,
 0x0A37,0x4A37,0x8A37,0xCA37,0x1A37,0x5A37,0x9A37,0xDA37,
 0x2A37,0x6A37,0xAA37,0xEA37,0x3A37,0x7A37,0xBA37,0xFA37,
 0x0E37,0x4E37,0x8E37,0xCE37,0x1E37,0x5E37,0x9E37,0xDE37,
 0x2E37,0x6E37,0xAE37,0xEE37,0x3E37,0x7E37,0xBE37,0xFE37,
 0x0337,0x4337,0x8337,0xC337,0x1337,0x5337,0x9337,0xD337,
 0x2337,0x6337,0xA337,0xE337,0x3337,0x7337,0xB337,0xF337,
 0x0737,0x4737,0x8737,0xC737,0x1737,0x5737,0x9737,0xD737,
 0x2737,0x6737,0xA737,0xE737,0x3737,0x7737,0xB737,0xF737,
 0x0B37,0x4B37,0x8B37,0xCB37,0x1B37,0x5B37,0x9B37,0xDB37,
 0x2B37,0x6B37,0xAB37,0xEB37,0x3B37,0x7B37,0xBB37,0xFB37,
 0x0F37,0x4F37,0x8F37,0xCF37,0x1F37,0x5F37,0x9F37,0xDF37,
 0x2F37,0x6F37,0xAF37,0xEF37,0x3F37,0x7F37,0xBF37,0xFF37,
 0x0077,0x4077,0x8077,0xC077,0x1077,0x5077,0x9077,0xD077,
 0x2077,0x6077,0xA077,0xE077,0x3077,0x7077,0xB077,0xF077,
 0x0477,0x4477,0x8477,0xC477,0x1477,0x5477,0x9477,0xD477,
 0x2477,0x6477,0xA477,0xE477,0x3477,0x7477,0xB477,0xF477,
 0x0877,0x4877,0x8877,0xC877,0x1877,0x5877,0x9877,0xD877,
 0x2877,0x6877,0xA877,0xE877,0x3877,0x7877,0xB877,0xF877,
 0x0C77,0x4C77,0x8C77,0xCC77,0x1C77,0x5C77,0x9C77,0xDC77,
 0x2C77,0x6C77,0xAC77,0xEC77,0x3C77,0x7C77,0xBC77,0xFC77,
 0x0177,0x4177,0x8177,0xC177,0x1177,0x5177,0x9177,0xD177,
 0x2177,0x6177,0xA177,0xE177,0x3177,0x7177,0xB177,0xF177,
 0x0577,0x4577,0x8577,0xC577,0x1577,0x5577,0x9577,0xD577,
 0x2577,0x6577,0xA577,0xE577,0x3577,0x7577,0xB577,0xF577,
 0x0977,0x4977,0x8977,0xC977,0x1977,0x5977,0x9977,0xD977,
 0x2977,0x6977,0xA977,0xE977,0x3977,0x7977,0xB977,0xF977,
 0x0D77,0x4D77,0x8D77,0xCD77,0x1D77,0x5D77,0x9D77,0xDD77,
 0x2D77,0x6D77,0xAD77,0xED77,0x3D77,0x7D77,0xBD77,0xFD77,
 0x0277,0x4277,0x8277,0xC277,0x1277,0x5277,0x9277,0xD277,
 0x2277,0x6277,0xA277,0xE277,0x3277,0x7277,0xB277,0xF277,
 0x0677,0x4677,0x8677,0xC677,0x1677,0x5677,0x9677,0xD677,
 0x2677,0x6677,0xA677,0xE677,0x3677,0x7677,0xB677,0xF677,
 0x0A77,0x4A77,0x8A77,0xCA77,0x1A77,0x5A77,0x9A77,0xDA77,
 0x2A77,0x6A77,0xAA77,0xEA77,0x3A77,0x7A77,0xBA77,0xFA77,
 0x0E77,0x4E77,0x8E77,0xCE77,0x1E77,0x5E77,0x9E77,0xDE77,
 0x2E77,0x6E77,0xAE77,0xEE77,0x3E77,0x7E77,0xBE77,0xFE77,
 0x0377,0x4377,0x8377,0xC377,0x1377,0x5377,0x9377,0xD377,
 0x2377,0x6377,0xA377,0xE377,0x3377,0x7377,0xB377,0xF377,
 0x0777,0x4777,0x8777,0xC777,0x1777,0x5777,0x9777,0xD777,
 0x2777,0x6777,0xA777,0xE777,0x3777,0x7777,0xB777,0xF777,
 0x0B77,0x4B77,0x8B77,0xCB77,0x1B77,0x5B77,0x9B77,0xDB77,
 0x2B77,0x6B77,0xAB77,0xEB77,0x3B77,0x7B77,0xBB77,0xFB77,
 0x0F77,0x4F77,0x8F77,0xCF77,0x1F77,0x5F77,0x9F77,0xDF77,
 0x2F77,0x6F77,0xAF77,0xEF77,0x3F77,0x7F77,0xBF77,0xFF77,
 0x00B7,0x40B7,0x80B7,0xC0B7,0x10B7,0x50B7,0x90B7,0xD0B7,
 0x20B7,0x60B7,0xA0B7,0xE0B7,0x30B7,0x70B7,0xB0B7,0xF0B7,
 0x04B7,0x44B7,0x84B7,0xC4B7,0x14B7,0x54B7,0x94B7,0xD4B7,
 0x24B7,0x64B7,0xA4B7,0xE4B7,0x34B7,0x74B7,0xB4B7,0xF4B7,
 0x08B7,0x48B7,0x88B7,0xC8B7,0x18B7,0x58B7,0x98B7,0xD8B7,
 0x28B7,0x68B7,0xA8B7,0xE8B7,0x38B7,0x78B7,0xB8B7,0xF8B7,
 0x0CB7,0x4CB7,0x8CB7,0xCCB7,0x1CB7,0x5CB7,0x9CB7,0xDCB7,
 0x2CB7,0x6CB7,0xACB7,0xECB7,0x3CB7,0x7CB7,0xBCB7,0xFCB7,
 0x01B7,0x41B7,0x81B7,0xC1B7,0x11B7,0x51B7,0x91B7,0xD1B7,
 0x21B7,0x61B7,0xA1B7,0xE1B7,0x31B7,0x71B7,0xB1B7,0xF1B7,
 0x05B7,0x45B7,0x85B7,0xC5B7,0x15B7,0x55B7,0x95B7,0xD5B7,
 0x25B7,0x65B7,0xA5B7,0xE5B7,0x35B7,0x75B7,0xB5B7,0xF5B7,
 0x09B7,0x49B7,0x89B7,0xC9B7,0x19B7,0x59B7,0x99B7,0xD9B7,
 0x29B7,0x69B7,0xA9B7,0xE9B7,0x39B7,0x79B7,0xB9B7,0xF9B7,
 0x0DB7,0x4DB7,0x8DB7,0xCDB7,0x1DB7,0x5DB7,0x9DB7,0xDDB7,
 0x2DB7,0x6DB7,0xADB7,0xEDB7,0x3DB7,0x7DB7,0xBDB7,0xFDB7,
 0x02B7,0x42B7,0x82B7,0xC2B7,0x12B7,0x52B7,0x92B7,0xD2B7,
 0x22B7,0x62B7,0xA2B7,0xE2B7,0x32B7,0x72B7,0xB2B7,0xF2B7,
 0x06B7,0x46B7,0x86B7,0xC6B7,0x16B7,0x56B7,0x96B7,0xD6B7,
 0x26B7,0x66B7,0xA6B7,0xE6B7,0x36B7,0x76B7,0xB6B7,0xF6B7,
 0x0AB7,0x4AB7,0x8AB7,0xCAB7,0x1AB7,0x5AB7,0x9AB7,0xDAB7,
 0x2AB7,0x6AB7,0xAAB7,0xEAB7,0x3AB7,0x7AB7,0xBAB7,0xFAB7,
 0x0EB7,0x4EB7,0x8EB7,0xCEB7,0x1EB7,0x5EB7,0x9EB7,0xDEB7,
 0x2EB7,0x6EB7,0xAEB7,0xEEB7,0x3EB7,0x7EB7,0xBEB7,0xFEB7,
 0x03B7,0x43B7,0x83B7,0xC3B7,0x13B7,0x53B7,0x93B7,0xD3B7,
 0x23B7,0x63B7,0xA3B7,0xE3B7,0x33B7,0x73B7,0xB3B7,0xF3B7,
 0x07B7,0x47B7,0x87B7,0xC7B7,0x17B7,0x57B7,0x97B7,0xD7B7,
 0x27B7,0x67B7,0xA7B7,0xE7B7,0x37B7,0x77B7,0xB7B7,0xF7B7,
 0x0BB7,0x4BB7,0x8BB7,0xCBB7,0x1BB7,0x5BB7,0x9BB7,0xDBB7,
 0x2BB7,0x6BB7,0xABB7,0xEBB7,0x3BB7,0x7BB7,0xBBB7,0xFBB7,
 0x0FB7,0x4FB7,0x8FB7,0xCFB7,0x1FB7,0x5FB7,0x9FB7,0xDFB7,
 0x2FB7,0x6FB7,0xAFB7,0xEFB7,0x3FB7,0x7FB7,0xBFB7,0xFFB7,
 0x00F7,0x40F7,0x80F7,0xC0F7,0x10F7,0x50F7,0x90F7,0xD0F7,
 0x20F7,0x60F7,0xA0F7,0xE0F7,0x30F7,0x70F7,0xB0F7,0xF0F7,
 0x04F7,0x44F7,0x84F7,0xC4F7,0x14F7,0x54F7,0x94F7,0xD4F7,
 0x24F7,0x64F7,0xA4F7,0xE4F7,0x34F7,0x74F7,0xB4F7,0xF4F7,
 0x08F7,0x48F7,0x88F7,0xC8F7,0x18F7,0x58F7,0x98F7,0xD8F7,
 0x28F7,0x68F7,0xA8F7,0xE8F7,0x38F7,0x78F7,0xB8F7,0xF8F7,
 0x0CF7,0x4CF7,0x8CF7,0xCCF7,0x1CF7,0x5CF7,0x9CF7,0xDCF7,
 0x2CF7,0x6CF7,0xACF7,0xECF7,0x3CF7,0x7CF7,0xBCF7,0xFCF7,
 0x01F7,0x41F7,0x81F7,0xC1F7,0x11F7,0x51F7,0x91F7,0xD1F7,
 0x21F7,0x61F7,0xA1F7,0xE1F7,0x31F7,0x71F7,0xB1F7,0xF1F7,
 0x05F7,0x45F7,0x85F7,0xC5F7,0x15F7,0x55F7,0x95F7,0xD5F7,
 0x25F7,0x65F7,0xA5F7,0xE5F7,0x35F7,0x75F7,0xB5F7,0xF5F7,
 0x09F7,0x49F7,0x89F7,0xC9F7,0x19F7,0x59F7,0x99F7,0xD9F7,
 0x29F7,0x69F7,0xA9F7,0xE9F7,0x39F7,0x79F7,0xB9F7,0xF9F7,
 0x0DF7,0x4DF7,0x8DF7,0xCDF7,0x1DF7,0x5DF7,0x9DF7,0xDDF7,
 0x2DF7,0x6DF7,0xADF7,0xEDF7,0x3DF7,0x7DF7,0xBDF7,0xFDF7,
 0x02F7,0x42F7,0x82F7,0xC2F7,0x12F7,0x52F7,0x92F7,0xD2F7,
 0x22F7,0x62F7,0xA2F7,0xE2F7,0x32F7,0x72F7,0xB2F7,0xF2F7,
 0x06F7,0x46F7,0x86F7,0xC6F7,0x16F7,0x56F7,0x96F7,0xD6F7,
 0x26F7,0x66F7,0xA6F7,0xE6F7,0x36F7,0x76F7,0xB6F7,0xF6F7,
 0x0AF7,0x4AF7,0x8AF7,0xCAF7,0x1AF7,0x5AF7,0x9AF7,0xDAF7,
 0x2AF7,0x6AF7,0xAAF7,0xEAF7,0x3AF7,0x7AF7,0xBAF7,0xFAF7,
 0x0EF7,0x4EF7,0x8EF7,0xCEF7,0x1EF7,0x5EF7,0x9EF7,0xDEF7,
 0x2EF7,0x6EF7,0xAEF7,0xEEF7,0x3EF7,0x7EF7,0xBEF7,0xFEF7,
 0x03F7,0x43F7,0x83F7,0xC3F7,0x13F7,0x53F7,0x93F7,0xD3F7,
 0x23F7,0x63F7,0xA3F7,0xE3F7,0x33F7,0x73F7,0xB3F7,0xF3F7,
 0x07F7,0x47F7,0x87F7,0xC7F7,0x17F7,0x57F7,0x97F7,0xD7F7,
 0x27F7,0x67F7,0xA7F7,0xE7F7,0x37F7,0x77F7,0xB7F7,0xF7F7,
 0x0BF7,0x4BF7,0x8BF7,0xCBF7,0x1BF7,0x5BF7,0x9BF7,0xDBF7,
 0x2BF7,0x6BF7,0xABF7,0xEBF7,0x3BF7,0x7BF7,0xBBF7,0xFBF7,
 0x0FF7,0x4FF7,0x8FF7,0xCFF7,0x1FF7,0x5FF7,0x9FF7,0xDFF7,
 0x2FF7,0x6FF7,0xAFF7,0xEFF7,0x3FF7,0x7FF7,0xBFF7,0xFFF7,
 0x000B,0x400B,0x800B,0xC00B,0x100B,0x500B,0x900B,0xD00B,
 0x200B,0x600B,0xA00B,0xE00B,0x300B,0x700B,0xB00B,0xF00B,
 0x040B,0x440B,0x840B,0xC40B,0x140B,0x540B,0x940B,0xD40B,
 0x240B,0x640B,0xA40B,0xE40B,0x340B,0x740B,0xB40B,0xF40B,
 0x080B,0x480B,0x880B,0xC80B,0x180B,0x580B,0x980B,0xD80B,
 0x280B,0x680B,0xA80B,0xE80B,0x380B,0x780B,0xB80B,0xF80B,
 0x0C0B,0x4C0B,0x8C0B,0xCC0B,0x1C0B,0x5C0B,0x9C0B,0xDC0B,
 0x2C0B,0x6C0B,0xAC0B,0xEC0B,0x3C0B,0x7C0B,0xBC0B,0xFC0B,
 0x010B,0x410B,0x810B,0xC10B,0x110B,0x510B,0x910B,0xD10B,
 0x210B,0x610B,0xA10B,0xE10B,0x310B,0x710B,0xB10B,0xF10B,
 0x050B,0x450B,0x850B,0xC50B,0x150B,0x550B,0x950B,0xD50B,
 0x250B,0x650B,0xA50B,0xE50B,0x350B,0x750B,0xB50B,0xF50B,
 0x090B,0x490B,0x890B,0xC90B,0x190B,0x590B,0x990B,0xD90B,
 0x290B,0x690B,0xA90B,0xE90B,0x390B,0x790B,0xB90B,0xF90B,
 0x0D0B,0x4D0B,0x8D0B,0xCD0B,0x1D0B,0x5D0B,0x9D0B,0xDD0B,
 0x2D0B,0x6D0B,0xAD0B,0xED0B,0x3D0B,0x7D0B,0xBD0B,0xFD0B,
 0x020B,0x420B,0x820B,0xC20B,0x120B,0x520B,0x920B,0xD20B,
 0x220B,0x620B,0xA20B,0xE20B,0x320B,0x720B,0xB20B,0xF20B,
 0x060B,0x460B,0x860B,0xC60B,0x160B,0x560B,0x960B,0xD60B,
 0x260B,0x660B,0xA60B,0xE60B,0x360B,0x760B,0xB60B,0xF60B,
 0x0A0B,0x4A0B,0x8A0B,0xCA0B,0x1A0B,0x5A0B,0x9A0B,0xDA0B,
 0x2A0B,0x6A0B,0xAA0B,0xEA0B,0x3A0B,0x7A0B,0xBA0B,0xFA0B,
 0x0E0B,0x4E0B,0x8E0B,0xCE0B,0x1E0B,0x5E0B,0x9E0B,0xDE0B,
 0x2E0B,0x6E0B,0xAE0B,0xEE0B,0x3E0B,0x7E0B,0xBE0B,0xFE0B,
 0x030B,0x430B,0x830B,0xC30B,0x130B,0x530B,0x930B,0xD30B,
 0x230B,0x630B,0xA30B,0xE30B,0x330B,0x730B,0xB30B,0xF30B,
 0x070B,0x470B,0x870B,0xC70B,0x170B,0x570B,0x970B,0xD70B,
 0x270B,0x670B,0xA70B,0xE70B,0x370B,0x770B,0xB70B,0xF70B,
 0x0B0B,0x4B0B,0x8B0B,0xCB0B,0x1B0B,0x5B0B,0x9B0B,0xDB0B,
 0x2B0B,0x6B0B,0xAB0B,0xEB0B,0x3B0B,0x7B0B,0xBB0B,0xFB0B,
 0x0F0B,0x4F0B,0x8F0B,0xCF0B,0x1F0B,0x5F0B,0x9F0B,0xDF0B,
 0x2F0B,0x6F0B,0xAF0B,0xEF0B,0x3F0B,0x7F0B,0xBF0B,0xFF0B,
 0x004B,0x404B,0x804B,0xC04B,0x104B,0x504B,0x904B,0xD04B,
 0x204B,0x604B,0xA04B,0xE04B,0x304B,0x704B,0xB04B,0xF04B,
 0x044B,0x444B,0x844B,0xC44B,0x144B,0x544B,0x944B,0xD44B,
 0x244B,0x644B,0xA44B,0xE44B,0x344B,0x744B,0xB44B,0xF44B,
 0x084B,0x484B,0x884B,0xC84B,0x184B,0x584B,0x984B,0xD84B,
 0x284B,0x684B,0xA84B,0xE84B,0x384B,0x784B,0xB84B,0xF84B,
 0x0C4B,0x4C4B,0x8C4B,0xCC4B,0x1C4B,0x5C4B,0x9C4B,0xDC4B,
 0x2C4B,0x6C4B,0xAC4B,0xEC4B,0x3C4B,0x7C4B,0xBC4B,0xFC4B,
 0x014B,0x414B,0x814B,0xC14B,0x114B,0x514B,0x914B,0xD14B,
 0x214B,0x614B,0xA14B,0xE14B,0x314B,0x714B,0xB14B,0xF14B,
 0x054B,0x454B,0x854B,0xC54B,0x154B,0x554B,0x954B,0xD54B,
 0x254B,0x654B,0xA54B,0xE54B,0x354B,0x754B,0xB54B,0xF54B,
 0x094B,0x494B,0x894B,0xC94B,0x194B,0x594B,0x994B,0xD94B,
 0x294B,0x694B,0xA94B,0xE94B,0x394B,0x794B,0xB94B,0xF94B,
 0x0D4B,0x4D4B,0x8D4B,0xCD4B,0x1D4B,0x5D4B,0x9D4B,0xDD4B,
 0x2D4B,0x6D4B,0xAD4B,0xED4B,0x3D4B,0x7D4B,0xBD4B,0xFD4B,
 0x024B,0x424B,0x824B,0xC24B,0x124B,0x524B,0x924B,0xD24B,
 0x224B,0x624B,0xA24B,0xE24B,0x324B,0x724B,0xB24B,0xF24B,
 0x064B,0x464B,0x864B,0xC64B,0x164B,0x564B,0x964B,0xD64B,
 0x264B,0x664B,0xA64B,0xE64B,0x364B,0x764B,0xB64B,0xF64B,
 0x0A4B,0x4A4B,0x8A4B,0xCA4B,0x1A4B,0x5A4B,0x9A4B,0xDA4B,
 0x2A4B,0x6A4B,0xAA4B,0xEA4B,0x3A4B,0x7A4B,0xBA4B,0xFA4B,
 0x0E4B,0x4E4B,0x8E4B,0xCE4B,0x1E4B,0x5E4B,0x9E4B,0xDE4B,
 0x2E4B,0x6E4B,0xAE4B,0xEE4B,0x3E4B,0x7E4B,0xBE4B,0xFE4B,
 0x034B,0x434B,0x834B,0xC34B,0x134B,0x534B,0x934B,0xD34B,
 0x234B,0x634B,0xA34B,0xE34B,0x334B,0x734B,0xB34B,0xF34B,
 0x074B,0x474B,0x874B,0xC74B,0x174B,0x574B,0x974B,0xD74B,
 0x274B,0x674B,0xA74B,0xE74B,0x374B,0x774B,0xB74B,0xF74B,
 0x0B4B,0x4B4B,0x8B4B,0xCB4B,0x1B4B,0x5B4B,0x9B4B,0xDB4B,
 0x2B4B,0x6B4B,0xAB4B,0xEB4B,0x3B4B,0x7B4B,0xBB4B,0xFB4B,
 0x0F4B,0x4F4B,0x8F4B,0xCF4B,0x1F4B,0x5F4B,0x9F4B,0xDF4B,
 0x2F4B,0x6F4B,0xAF4B,0xEF4B,0x3F4B,0x7F4B,0xBF4B,0xFF4B,
 0x008B,0x408B,0x808B,0xC08B,0x108B,0x508B,0x908B,0xD08B,
 0x208B,0x608B,0xA08B,0xE08B,0x308B,0x708B,0xB08B,0xF08B,
 0x048B,0x448B,0x848B,0xC48B,0x148B,0x548B,0x948B,0xD48B,
 0x248B,0x648B,0xA48B,0xE48B,0x348B,0x748B,0xB48B,0xF48B,
 0x088B,0x488B,0x888B,0xC88B,0x188B,0x588B,0x988B,0xD88B,
 0x288B,0x688B,0xA88B,0xE88B,0x388B,0x788B,0xB88B,0xF88B,
 0x0C8B,0x4C8B,0x8C8B,0xCC8B,0x1C8B,0x5C8B,0x9C8B,0xDC8B,
 0x2C8B,0x6C8B,0xAC8B,0xEC8B,0x3C8B,0x7C8B,0xBC8B,0xFC8B,
 0x018B,0x418B,0x818B,0xC18B,0x118B,0x518B,0x918B,0xD18B,
 0x218B,0x618B,0xA18B,0xE18B,0x318B,0x718B,0xB18B,0xF18B,
 0x058B,0x458B,0x858B,0xC58B,0x158B,0x558B,0x958B,0xD58B,
 0x258B,0x658B,0xA58B,0xE58B,0x358B,0x758B,0xB58B,0xF58B,
 0x098B,0x498B,0x898B,0xC98B,0x198B,0x598B,0x998B,0xD98B,
 0x298B,0x698B,0xA98B,0xE98B,0x398B,0x798B,0xB98B,0xF98B,
 0x0D8B,0x4D8B,0x8D8B,0xCD8B,0x1D8B,0x5D8B,0x9D8B,0xDD8B,
 0x2D8B,0x6D8B,0xAD8B,0xED8B,0x3D8B,0x7D8B,0xBD8B,0xFD8B,
 0x028B,0x428B,0x828B,0xC28B,0x128B,0x528B,0x928B,0xD28B,
 0x228B,0x628B,0xA28B,0xE28B,0x328B,0x728B,0xB28B,0xF28B,
 0x068B,0x468B,0x868B,0xC68B,0x168B,0x568B,0x968B,0xD68B,
 0x268B,0x668B,0xA68B,0xE68B,0x368B,0x768B,0xB68B,0xF68B,
 0x0A8B,0x4A8B,0x8A8B,0xCA8B,0x1A8B,0x5A8B,0x9A8B,0xDA8B,
 0x2A8B,0x6A8B,0xAA8B,0xEA8B,0x3A8B,0x7A8B,0xBA8B,0xFA8B,
 0x0E8B,0x4E8B,0x8E8B,0xCE8B,0x1E8B,0x5E8B,0x9E8B,0xDE8B,
 0x2E8B,0x6E8B,0xAE8B,0xEE8B,0x3E8B,0x7E8B,0xBE8B,0xFE8B,
 0x038B,0x438B,0x838B,0xC38B,0x138B,0x538B,0x938B,0xD38B,
 0x238B,0x638B,0xA38B,0xE38B,0x338B,0x738B,0xB38B,0xF38B,
 0x078B,0x478B,0x878B,0xC78B,0x178B,0x578B,0x978B,0xD78B,
 0x278B,0x678B,0xA78B,0xE78B,0x378B,0x778B,0xB78B,0xF78B,
 0x0B8B,0x4B8B,0x8B8B,0xCB8B,0x1B8B,0x5B8B,0x9B8B,0xDB8B,
 0x2B8B,0x6B8B,0xAB8B,0xEB8B,0x3B8B,0x7B8B,0xBB8B,0xFB8B,
 0x0F8B,0x4F8B,0x8F8B,0xCF8B,0x1F8B,0x5F8B,0x9F8B,0xDF8B,
 0x2F8B,0x6F8B,0xAF8B,0xEF8B,0x3F8B,0x7F8B,0xBF8B,0xFF8B,
 0x00CB,0x40CB,0x80CB,0xC0CB,0x10CB,0x50CB,0x90CB,0xD0CB,
 0x20CB,0x60CB,0xA0CB,0xE0CB,0x30CB,0x70CB,0xB0CB,0xF0CB,
 0x04CB,0x44CB,0x84CB,0xC4CB,0x14CB,0x54CB,0x94CB,0xD4CB,
 0x24CB,0x64CB,0xA4CB,0xE4CB,0x34CB,0x74CB,0xB4CB,0xF4CB,
 0x08CB,0x48CB,0x88CB,0xC8CB,0x18CB,0x58CB,0x98CB,0xD8CB,
 0x28CB,0x68CB,0xA8CB,0xE8CB,0x38CB,0x78CB,0xB8CB,0xF8CB,
 0x0CCB,0x4CCB,0x8CCB,0xCCCB,0x1CCB,0x5CCB,0x9CCB,0xDCCB,
 0x2CCB,0x6CCB,0xACCB,0xECCB,0x3CCB,0x7CCB,0xBCCB,0xFCCB,
 0x01CB,0x41CB,0x81CB,0xC1CB,0x11CB,0x51CB,0x91CB,0xD1CB,
 0x21CB,0x61CB,0xA1CB,0xE1CB,0x31CB,0x71CB,0xB1CB,0xF1CB,
 0x05CB,0x45CB,0x85CB,0xC5CB,0x15CB,0x55CB,0x95CB,0xD5CB,
 0x25CB,0x65CB,0xA5CB,0xE5CB,0x35CB,0x75CB,0xB5CB,0xF5CB,
 0x09CB,0x49CB,0x89CB,0xC9CB,0x19CB,0x59CB,0x99CB,0xD9CB,
 0x29CB,0x69CB,0xA9CB,0xE9CB,0x39CB,0x79CB,0xB9CB,0xF9CB,
 0x0DCB,0x4DCB,0x8DCB,0xCDCB,0x1DCB,0x5DCB,0x9DCB,0xDDCB,
 0x2DCB,0x6DCB,0xADCB,0xEDCB,0x3DCB,0x7DCB,0xBDCB,0xFDCB,
 0x02CB,0x42CB,0x82CB,0xC2CB,0x12CB,0x52CB,0x92CB,0xD2CB,
 0x22CB,0x62CB,0xA2CB,0xE2CB,0x32CB,0x72CB,0xB2CB,0xF2CB,
 0x06CB,0x46CB,0x86CB,0xC6CB,0x16CB,0x56CB,0x96CB,0xD6CB,
 0x26CB,0x66CB,0xA6CB,0xE6CB,0x36CB,0x76CB,0xB6CB,0xF6CB,
 0x0ACB,0x4ACB,0x8ACB,0xCACB,0x1ACB,0x5ACB,0x9ACB,0xDACB,
 0x2ACB,0x6ACB,0xAACB,0xEACB,0x3ACB,0x7ACB,0xBACB,0xFACB,
 0x0ECB,0x4ECB,0x8ECB,0xCECB,0x1ECB,0x5ECB,0x9ECB,0xDECB,
 0x2ECB,0x6ECB,0xAECB,0xEECB,0x3ECB,0x7ECB,0xBECB,0xFECB,
 0x03CB,0x43CB,0x83CB,0xC3CB,0x13CB,0x53CB,0x93CB,0xD3CB,
 0x23CB,0x63CB,0xA3CB,0xE3CB,0x33CB,0x73CB,0xB3CB,0xF3CB,
 0x07CB,0x47CB,0x87CB,0xC7CB,0x17CB,0x57CB,0x97CB,0xD7CB,
 0x27CB,0x67CB,0xA7CB,0xE7CB,0x37CB,0x77CB,0xB7CB,0xF7CB,
 0x0BCB,0x4BCB,0x8BCB,0xCBCB,0x1BCB,0x5BCB,0x9BCB,0xDBCB,
 0x2BCB,0x6BCB,0xABCB,0xEBCB,0x3BCB,0x7BCB,0xBBCB,0xFBCB,
 0x0FCB,0x4FCB,0x8FCB,0xCFCB,0x1FCB,0x5FCB,0x9FCB,0xDFCB,
 0x2FCB,0x6FCB,0xAFCB,0xEFCB,0x3FCB,0x7FCB,0xBFCB,0xFFCB,
 0x001B,0x401B,0x801B,0xC01B,0x101B,0x501B,0x901B,0xD01B,
 0x201B,0x601B,0xA01B,0xE01B,0x301B,0x701B,0xB01B,0xF01B,
 0x041B,0x441B,0x841B,0xC41B,0x141B,0x541B,0x941B,0xD41B,
 0x241B,0x641B,0xA41B,0xE41B,0x341B,0x741B,0xB41B,0xF41B,
 0x081B,0x481B,0x881B,0xC81B,0x181B,0x581B,0x981B,0xD81B,
 0x281B,0x681B,0xA81B,0xE81B,0x381B,0x781B,0xB81B,0xF81B,
 0x0C1B,0x4C1B,0x8C1B,0xCC1B,0x1C1B,0x5C1B,0x9C1B,0xDC1B,
 0x2C1B,0x6C1B,0xAC1B,0xEC1B,0x3C1B,0x7C1B,0xBC1B,0xFC1B,
 0x011B,0x411B,0x811B,0xC11B,0x111B,0x511B,0x911B,0xD11B,
 0x211B,0x611B,0xA11B,0xE11B,0x311B,0x711B,0xB11B,0xF11B,
 0x051B,0x451B,0x851B,0xC51B,0x151B,0x551B,0x951B,0xD51B,
 0x251B,0x651B,0xA51B,0xE51B,0x351B,0x751B,0xB51B,0xF51B,
 0x091B,0x491B,0x891B,0xC91B,0x191B,0x591B,0x991B,0xD91B,
 0x291B,0x691B,0xA91B,0xE91B,0x391B,0x791B,0xB91B,0xF91B,
 0x0D1B,0x4D1B,0x8D1B,0xCD1B,0x1D1B,0x5D1B,0x9D1B,0xDD1B,
 0x2D1B,0x6D1B,0xAD1B,0xED1B,0x3D1B,0x7D1B,0xBD1B,0xFD1B,
 0x021B,0x421B,0x821B,0xC21B,0x121B,0x521B,0x921B,0xD21B,
 0x221B,0x621B,0xA21B,0xE21B,0x321B,0x721B,0xB21B,0xF21B,
 0x061B,0x461B,0x861B,0xC61B,0x161B,0x561B,0x961B,0xD61B,
 0x261B,0x661B,0xA61B,0xE61B,0x361B,0x761B,0xB61B,0xF61B,
 0x0A1B,0x4A1B,0x8A1B,0xCA1B,0x1A1B,0x5A1B,0x9A1B,0xDA1B,
 0x2A1B,0x6A1B,0xAA1B,0xEA1B,0x3A1B,0x7A1B,0xBA1B,0xFA1B,
 0x0E1B,0x4E1B,0x8E1B,0xCE1B,0x1E1B,0x5E1B,0x9E1B,0xDE1B,
 0x2E1B,0x6E1B,0xAE1B,0xEE1B,0x3E1B,0x7E1B,0xBE1B,0xFE1B,
 0x031B,0x431B,0x831B,0xC31B,0x131B,0x531B,0x931B,0xD31B,
 0x231B,0x631B,0xA31B,0xE31B,0x331B,0x731B,0xB31B,0xF31B,
 0x071B,0x471B,0x871B,0xC71B,0x171B,0x571B,0x971B,0xD71B,
 0x271B,0x671B,0xA71B,0xE71B,0x371B,0x771B,0xB71B,0xF71B,
 0x0B1B,0x4B1B,0x8B1B,0xCB1B,0x1B1B,0x5B1B,0x9B1B,0xDB1B,
 0x2B1B,0x6B1B,0xAB1B,0xEB1B,0x3B1B,0x7B1B,0xBB1B,0xFB1B,
 0x0F1B,0x4F1B,0x8F1B,0xCF1B,0x1F1B,0x5F1B,0x9F1B,0xDF1B,
 0x2F1B,0x6F1B,0xAF1B,0xEF1B,0x3F1B,0x7F1B,0xBF1B,0xFF1B,
 0x005B,0x405B,0x805B,0xC05B,0x105B,0x505B,0x905B,0xD05B,
 0x205B,0x605B,0xA05B,0xE05B,0x305B,0x705B,0xB05B,0xF05B,
 0x045B,0x445B,0x845B,0xC45B,0x145B,0x545B,0x945B,0xD45B,
 0x245B,0x645B,0xA45B,0xE45B,0x345B,0x745B,0xB45B,0xF45B,
 0x085B,0x485B,0x885B,0xC85B,0x185B,0x585B,0x985B,0xD85B,
 0x285B,0x685B,0xA85B,0xE85B,0x385B,0x785B,0xB85B,0xF85B,
 0x0C5B,0x4C5B,0x8C5B,0xCC5B,0x1C5B,0x5C5B,0x9C5B,0xDC5B,
 0x2C5B,0x6C5B,0xAC5B,0xEC5B,0x3C5B,0x7C5B,0xBC5B,0xFC5B,
 0x015B,0x415B,0x815B,0xC15B,0x115B,0x515B,0x915B,0xD15B,
 0x215B,0x615B,0xA15B,0xE15B,0x315B,0x715B,0xB15B,0xF15B,
 0x055B,0x455B,0x855B,0xC55B,0x155B,0x555B,0x955B,0xD55B,
 0x255B,0x655B,0xA55B,0xE55B,0x355B,0x755B,0xB55B,0xF55B,
 0x095B,0x495B,0x895B,0xC95B,0x195B,0x595B,0x995B,0xD95B,
 0x295B,0x695B,0xA95B,0xE95B,0x395B,0x795B,0xB95B,0xF95B,
 0x0D5B,0x4D5B,0x8D5B,0xCD5B,0x1D5B,0x5D5B,0x9D5B,0xDD5B,
 0x2D5B,0x6D5B,0xAD5B,0xED5B,0x3D5B,0x7D5B,0xBD5B,0xFD5B,
 0x025B,0x425B,0x825B,0xC25B,0x125B,0x525B,0x925B,0xD25B,
 0x225B,0x625B,0xA25B,0xE25B,0x325B,0x725B,0xB25B,0xF25B,
 0x065B,0x465B,0x865B,0xC65B,0x165B,0x565B,0x965B,0xD65B,
 0x265B,0x665B,0xA65B,0xE65B,0x365B,0x765B,0xB65B,0xF65B,
 0x0A5B,0x4A5B,0x8A5B,0xCA5B,0x1A5B,0x5A5B,0x9A5B,0xDA5B,
 0x2A5B,0x6A5B,0xAA5B,0xEA5B,0x3A5B,0x7A5B,0xBA5B,0xFA5B,
 0x0E5B,0x4E5B,0x8E5B,0xCE5B,0x1E5B,0x5E5B,0x9E5B,0xDE5B,
 0x2E5B,0x6E5B,0xAE5B,0xEE5B,0x3E5B,0x7E5B,0xBE5B,0xFE5B,
 0x035B,0x435B,0x835B,0xC35B,0x135B,0x535B,0x935B,0xD35B,
 0x235B,0x635B,0xA35B,0xE35B,0x335B,0x735B,0xB35B,0xF35B,
 0x075B,0x475B,0x875B,0xC75B,0x175B,0x575B,0x975B,0xD75B,
 0x275B,0x675B,0xA75B,0xE75B,0x375B,0x775B,0xB75B,0xF75B,
 0x0B5B,0x4B5B,0x8B5B,0xCB5B,0x1B5B,0x5B5B,0x9B5B,0xDB5B,
 0x2B5B,0x6B5B,0xAB5B,0xEB5B,0x3B5B,0x7B5B,0xBB5B,0xFB5B,
 0x0F5B,0x4F5B,0x8F5B,0xCF5B,0x1F5B,0x5F5B,0x9F5B,0xDF5B,
 0x2F5B,0x6F5B,0xAF5B,0xEF5B,0x3F5B,0x7F5B,0xBF5B,0xFF5B,
 0x009B,0x409B,0x809B,0xC09B,0x109B,0x509B,0x909B,0xD09B,
 0x209B,0x609B,0xA09B,0xE09B,0x309B,0x709B,0xB09B,0xF09B,
 0x049B,0x449B,0x849B,0xC49B,0x149B,0x549B,0x949B,0xD49B,
 0x249B,0x649B,0xA49B,0xE49B,0x349B,0x749B,0xB49B,0xF49B,
 0x089B,0x489B,0x889B,0xC89B,0x189B,0x589B,0x989B,0xD89B,
 0x289B,0x689B,0xA89B,0xE89B,0x389B,0x789B,0xB89B,0xF89B,
 0x0C9B,0x4C9B,0x8C9B,0xCC9B,0x1C9B,0x5C9B,0x9C9B,0xDC9B,
 0x2C9B,0x6C9B,0xAC9B,0xEC9B,0x3C9B,0x7C9B,0xBC9B,0xFC9B,
 0x019B,0x419B,0x819B,0xC19B,0x119B,0x519B,0x919B,0xD19B,
 0x219B,0x619B,0xA19B,0xE19B,0x319B,0x719B,0xB19B,0xF19B,
 0x059B,0x459B,0x859B,0xC59B,0x159B,0x559B,0x959B,0xD59B,
 0x259B,0x659B,0xA59B,0xE59B,0x359B,0x759B,0xB59B,0xF59B,
 0x099B,0x499B,0x899B,0xC99B,0x199B,0x599B,0x999B,0xD99B,
 0x299B,0x699B,0xA99B,0xE99B,0x399B,0x799B,0xB99B,0xF99B,
 0x0D9B,0x4D9B,0x8D9B,0xCD9B,0x1D9B,0x5D9B,0x9D9B,0xDD9B,
 0x2D9B,0x6D9B,0xAD9B,0xED9B,0x3D9B,0x7D9B,0xBD9B,0xFD9B,
 0x029B,0x429B,0x829B,0xC29B,0x129B,0x529B,0x929B,0xD29B,
 0x229B,0x629B,0xA29B,0xE29B,0x329B,0x729B,0xB29B,0xF29B,
 0x069B,0x469B,0x869B,0xC69B,0x169B,0x569B,0x969B,0xD69B,
 0x269B,0x669B,0xA69B,0xE69B,0x369B,0x769B,0xB69B,0xF69B,
 0x0A9B,0x4A9B,0x8A9B,0xCA9B,0x1A9B,0x5A9B,0x9A9B,0xDA9B,
 0x2A9B,0x6A9B,0xAA9B,0xEA9B,0x3A9B,0x7A9B,0xBA9B,0xFA9B,
 0x0E9B,0x4E9B,0x8E9B,0xCE9B,0x1E9B,0x5E9B,0x9E9B,0xDE9B,
 0x2E9B,0x6E9B,0xAE9B,0xEE9B,0x3E9B,0x7E9B,0xBE9B,0xFE9B,
 0x039B,0x439B,0x839B,0xC39B,0x139B,0x539B,0x939B,0xD39B,
 0x239B,0x639B,0xA39B,0xE39B,0x339B,0x739B,0xB39B,0xF39B,
 0x079B,0x479B,0x879B,0xC79B,0x179B,0x579B,0x979B,0xD79B,
 0x279B,0x679B,0xA79B,0xE79B,0x379B,0x779B,0xB79B,0xF79B,
 0x0B9B,0x4B9B,0x8B9B,0xCB9B,0x1B9B,0x5B9B,0x9B9B,0xDB9B,
 0x2B9B,0x6B9B,0xAB9B,0xEB9B,0x3B9B,0x7B9B,0xBB9B,0xFB9B,
 0x0F9B,0x4F9B,0x8F9B,0xCF9B,0x1F9B,0x5F9B,0x9F9B,0xDF9B,
 0x2F9B,0x6F9B,0xAF9B,0xEF9B,0x3F9B,0x7F9B,0xBF9B,0xFF9B,
 0x00DB,0x40DB,0x80DB,0xC0DB,0x10DB,0x50DB,0x90DB,0xD0DB,
 0x20DB,0x60DB,0xA0DB,0xE0DB,0x30DB,0x70DB,0xB0DB,0xF0DB,
 0x04DB,0x44DB,0x84DB,0xC4DB,0x14DB,0x54DB,0x94DB,0xD4DB,
 0x24DB,0x64DB,0xA4DB,0xE4DB,0x34DB,0x74DB,0xB4DB,0xF4DB,
 0x08DB,0x48DB,0x88DB,0xC8DB,0x18DB,0x58DB,0x98DB,0xD8DB,
 0x28DB,0x68DB,0xA8DB,0xE8DB,0x38DB,0x78DB,0xB8DB,0xF8DB,
 0x0CDB,0x4CDB,0x8CDB,0xCCDB,0x1CDB,0x5CDB,0x9CDB,0xDCDB,
 0x2CDB,0x6CDB,0xACDB,0xECDB,0x3CDB,0x7CDB,0xBCDB,0xFCDB,
 0x01DB,0x41DB,0x81DB,0xC1DB,0x11DB,0x51DB,0x91DB,0xD1DB,
 0x21DB,0x61DB,0xA1DB,0xE1DB,0x31DB,0x71DB,0xB1DB,0xF1DB,
 0x05DB,0x45DB,0x85DB,0xC5DB,0x15DB,0x55DB,0x95DB,0xD5DB,
 0x25DB,0x65DB,0xA5DB,0xE5DB,0x35DB,0x75DB,0xB5DB,0xF5DB,
 0x09DB,0x49DB,0x89DB,0xC9DB,0x19DB,0x59DB,0x99DB,0xD9DB,
 0x29DB,0x69DB,0xA9DB,0xE9DB,0x39DB,0x79DB,0xB9DB,0xF9DB,
 0x0DDB,0x4DDB,0x8DDB,0xCDDB,0x1DDB,0x5DDB,0x9DDB,0xDDDB,
 0x2DDB,0x6DDB,0xADDB,0xEDDB,0x3DDB,0x7DDB,0xBDDB,0xFDDB,
 0x02DB,0x42DB,0x82DB,0xC2DB,0x12DB,0x52DB,0x92DB,0xD2DB,
 0x22DB,0x62DB,0xA2DB,0xE2DB,0x32DB,0x72DB,0xB2DB,0xF2DB,
 0x06DB,0x46DB,0x86DB,0xC6DB,0x16DB,0x56DB,0x96DB,0xD6DB,
 0x26DB,0x66DB,0xA6DB,0xE6DB,0x36DB,0x76DB,0xB6DB,0xF6DB,
 0x0ADB,0x4ADB,0x8ADB,0xCADB,0x1ADB,0x5ADB,0x9ADB,0xDADB,
 0x2ADB,0x6ADB,0xAADB,0xEADB,0x3ADB,0x7ADB,0xBADB,0xFADB,
 0x0EDB,0x4EDB,0x8EDB,0xCEDB,0x1EDB,0x5EDB,0x9EDB,0xDEDB,
 0x2EDB,0x6EDB,0xAEDB,0xEEDB,0x3EDB,0x7EDB,0xBEDB,0xFEDB,
 0x03DB,0x43DB,0x83DB,0xC3DB,0x13DB,0x53DB,0x93DB,0xD3DB,
 0x23DB,0x63DB,0xA3DB,0xE3DB,0x33DB,0x73DB,0xB3DB,0xF3DB,
 0x07DB,0x47DB,0x87DB,0xC7DB,0x17DB,0x57DB,0x97DB,0xD7DB,
 0x27DB,0x67DB,0xA7DB,0xE7DB,0x37DB,0x77DB,0xB7DB,0xF7DB,
 0x0BDB,0x4BDB,0x8BDB,0xCBDB,0x1BDB,0x5BDB,0x9BDB,0xDBDB,
 0x2BDB,0x6BDB,0xABDB,0xEBDB,0x3BDB,0x7BDB,0xBBDB,0xFBDB,
 0x0FDB,0x4FDB,0x8FDB,0xCFDB,0x1FDB,0x5FDB,0x9FDB,0xDFDB,
 0x2FDB,0x6FDB,0xAFDB,0xEFDB,0x3FDB,0x7FDB,0xBFDB,0xFFDB,
 0x002B,0x402B,0x802B,0xC02B,0x102B,0x502B,0x902B,0xD02B,
 0x202B,0x602B,0xA02B,0xE02B,0x302B,0x702B,0xB02B,0xF02B,
 0x042B,0x442B,0x842B,0xC42B,0x142B,0x542B,0x942B,0xD42B,
 0x242B,0x642B,0xA42B,0xE42B,0x342B,0x742B,0xB42B,0xF42B,
 0x082B,0x482B,0x882B,0xC82B,0x182B,0x582B,0x982B,0xD82B,
 0x282B,0x682B,0xA82B,0xE82B,0x382B,0x782B,0xB82B,0xF82B,
 0x0C2B,0x4C2B,0x8C2B,0xCC2B,0x1C2B,0x5C2B,0x9C2B,0xDC2B,
 0x2C2B,0x6C2B,0xAC2B,0xEC2B,0x3C2B,0x7C2B,0xBC2B,0xFC2B,
 0x012B,0x412B,0x812B,0xC12B,0x112B,0x512B,0x912B,0xD12B,
 0x212B,0x612B,0xA12B,0xE12B,0x312B,0x712B,0xB12B,0xF12B,
 0x052B,0x452B,0x852B,0xC52B,0x152B,0x552B,0x952B,0xD52B,
 0x252B,0x652B,0xA52B,0xE52B,0x352B,0x752B,0xB52B,0xF52B,
 0x092B,0x492B,0x892B,0xC92B,0x192B,0x592B,0x992B,0xD92B,
 0x292B,0x692B,0xA92B,0xE92B,0x392B,0x792B,0xB92B,0xF92B,
 0x0D2B,0x4D2B,0x8D2B,0xCD2B,0x1D2B,0x5D2B,0x9D2B,0xDD2B,
 0x2D2B,0x6D2B,0xAD2B,0xED2B,0x3D2B,0x7D2B,0xBD2B,0xFD2B,
 0x022B,0x422B,0x822B,0xC22B,0x122B,0x522B,0x922B,0xD22B,
 0x222B,0x622B,0xA22B,0xE22B,0x322B,0x722B,0xB22B,0xF22B,
 0x062B,0x462B,0x862B,0xC62B,0x162B,0x562B,0x962B,0xD62B,
 0x262B,0x662B,0xA62B,0xE62B,0x362B,0x762B,0xB62B,0xF62B,
 0x0A2B,0x4A2B,0x8A2B,0xCA2B,0x1A2B,0x5A2B,0x9A2B,0xDA2B,
 0x2A2B,0x6A2B,0xAA2B,0xEA2B,0x3A2B,0x7A2B,0xBA2B,0xFA2B,
 0x0E2B,0x4E2B,0x8E2B,0xCE2B,0x1E2B,0x5E2B,0x9E2B,0xDE2B,
 0x2E2B,0x6E2B,0xAE2B,0xEE2B,0x3E2B,0x7E2B,0xBE2B,0xFE2B,
 0x032B,0x432B,0x832B,0xC32B,0x132B,0x532B,0x932B,0xD32B,
 0x232B,0x632B,0xA32B,0xE32B,0x332B,0x732B,0xB32B,0xF32B,
 0x072B,0x472B,0x872B,0xC72B,0x172B,0x572B,0x972B,0xD72B,
 0x272B,0x672B,0xA72B,0xE72B,0x372B,0x772B,0xB72B,0xF72B,
 0x0B2B,0x4B2B,0x8B2B,0xCB2B,0x1B2B,0x5B2B,0x9B2B,0xDB2B,
 0x2B2B,0x6B2B,0xAB2B,0xEB2B,0x3B2B,0x7B2B,0xBB2B,0xFB2B,
 0x0F2B,0x4F2B,0x8F2B,0xCF2B,0x1F2B,0x5F2B,0x9F2B,0xDF2B,
 0x2F2B,0x6F2B,0xAF2B,0xEF2B,0x3F2B,0x7F2B,0xBF2B,0xFF2B,
 0x006B,0x406B,0x806B,0xC06B,0x106B,0x506B,0x906B,0xD06B,
 0x206B,0x606B,0xA06B,0xE06B,0x306B,0x706B,0xB06B,0xF06B,
 0x046B,0x446B,0x846B,0xC46B,0x146B,0x546B,0x946B,0xD46B,
 0x246B,0x646B,0xA46B,0xE46B,0x346B,0x746B,0xB46B,0xF46B,
 0x086B,0x486B,0x886B,0xC86B,0x186B,0x586B,0x986B,0xD86B,
 0x286B,0x686B,0xA86B,0xE86B,0x386B,0x786B,0xB86B,0xF86B,
 0x0C6B,0x4C6B,0x8C6B,0xCC6B,0x1C6B,0x5C6B,0x9C6B,0xDC6B,
 0x2C6B,0x6C6B,0xAC6B,0xEC6B,0x3C6B,0x7C6B,0xBC6B,0xFC6B,
 0x016B,0x416B,0x816B,0xC16B,0x116B,0x516B,0x916B,0xD16B,
 0x216B,0x616B,0xA16B,0xE16B,0x316B,0x716B,0xB16B,0xF16B,
 0x056B,0x456B,0x856B,0xC56B,0x156B,0x556B,0x956B,0xD56B,
 0x256B,0x656B,0xA56B,0xE56B,0x356B,0x756B,0xB56B,0xF56B,
 0x096B,0x496B,0x896B,0xC96B,0x196B,0x596B,0x996B,0xD96B,
 0x296B,0x696B,0xA96B,0xE96B,0x396B,0x796B,0xB96B,0xF96B,
 0x0D6B,0x4D6B,0x8D6B,0xCD6B,0x1D6B,0x5D6B,0x9D6B,0xDD6B,
 0x2D6B,0x6D6B,0xAD6B,0xED6B,0x3D6B,0x7D6B,0xBD6B,0xFD6B,
 0x026B,0x426B,0x826B,0xC26B,0x126B,0x526B,0x926B,0xD26B,
 0x226B,0x626B,0xA26B,0xE26B,0x326B,0x726B,0xB26B,0xF26B,
 0x066B,0x466B,0x866B,0xC66B,0x166B,0x566B,0x966B,0xD66B,
 0x266B,0x666B,0xA66B,0xE66B,0x366B,0x766B,0xB66B,0xF66B,
 0x0A6B,0x4A6B,0x8A6B,0xCA6B,0x1A6B,0x5A6B,0x9A6B,0xDA6B,
 0x2A6B,0x6A6B,0xAA6B,0xEA6B,0x3A6B,0x7A6B,0xBA6B,0xFA6B,
 0x0E6B,0x4E6B,0x8E6B,0xCE6B,0x1E6B,0x5E6B,0x9E6B,0xDE6B,
 0x2E6B,0x6E6B,0xAE6B,0xEE6B,0x3E6B,0x7E6B,0xBE6B,0xFE6B,
 0x036B,0x436B,0x836B,0xC36B,0x136B,0x536B,0x936B,0xD36B,
 0x236B,0x636B,0xA36B,0xE36B,0x336B,0x736B,0xB36B,0xF36B,
 0x076B,0x476B,0x876B,0xC76B,0x176B,0x576B,0x976B,0xD76B,
 0x276B,0x676B,0xA76B,0xE76B,0x376B,0x776B,0xB76B,0xF76B,
 0x0B6B,0x4B6B,0x8B6B,0xCB6B,0x1B6B,0x5B6B,0x9B6B,0xDB6B,
 0x2B6B,0x6B6B,0xAB6B,0xEB6B,0x3B6B,0x7B6B,0xBB6B,0xFB6B,
 0x0F6B,0x4F6B,0x8F6B,0xCF6B,0x1F6B,0x5F6B,0x9F6B,0xDF6B,
 0x2F6B,0x6F6B,0xAF6B,0xEF6B,0x3F6B,0x7F6B,0xBF6B,0xFF6B,
 0x00AB,0x40AB,0x80AB,0xC0AB,0x10AB,0x50AB,0x90AB,0xD0AB,
 0x20AB,0x60AB,0xA0AB,0xE0AB,0x30AB,0x70AB,0xB0AB,0xF0AB,
 0x04AB,0x44AB,0x84AB,0xC4AB,0x14AB,0x54AB,0x94AB,0xD4AB,
 0x24AB,0x64AB,0xA4AB,0xE4AB,0x34AB,0x74AB,0xB4AB,0xF4AB,
 0x08AB,0x48AB,0x88AB,0xC8AB,0x18AB,0x58AB,0x98AB,0xD8AB,
 0x28AB,0x68AB,0xA8AB,0xE8AB,0x38AB,0x78AB,0xB8AB,0xF8AB,
 0x0CAB,0x4CAB,0x8CAB,0xCCAB,0x1CAB,0x5CAB,0x9CAB,0xDCAB,
 0x2CAB,0x6CAB,0xACAB,0xECAB,0x3CAB,0x7CAB,0xBCAB,0xFCAB,
 0x01AB,0x41AB,0x81AB,0xC1AB,0x11AB,0x51AB,0x91AB,0xD1AB,
 0x21AB,0x61AB,0xA1AB,0xE1AB,0x31AB,0x71AB,0xB1AB,0xF1AB,
 0x05AB,0x45AB,0x85AB,0xC5AB,0x15AB,0x55AB,0x95AB,0xD5AB,
 0x25AB,0x65AB,0xA5AB,0xE5AB,0x35AB,0x75AB,0xB5AB,0xF5AB,
 0x09AB,0x49AB,0x89AB,0xC9AB,0x19AB,0x59AB,0x99AB,0xD9AB,
 0x29AB,0x69AB,0xA9AB,0xE9AB,0x39AB,0x79AB,0xB9AB,0xF9AB,
 0x0DAB,0x4DAB,0x8DAB,0xCDAB,0x1DAB,0x5DAB,0x9DAB,0xDDAB,
 0x2DAB,0x6DAB,0xADAB,0xEDAB,0x3DAB,0x7DAB,0xBDAB,0xFDAB,
 0x02AB,0x42AB,0x82AB,0xC2AB,0x12AB,0x52AB,0x92AB,0xD2AB,
 0x22AB,0x62AB,0xA2AB,0xE2AB,0x32AB,0x72AB,0xB2AB,0xF2AB,
 0x06AB,0x46AB,0x86AB,0xC6AB,0x16AB,0x56AB,0x96AB,0xD6AB,
 0x26AB,0x66AB,0xA6AB,0xE6AB,0x36AB,0x76AB,0xB6AB,0xF6AB,
 0x0AAB,0x4AAB,0x8AAB,0xCAAB,0x1AAB,0x5AAB,0x9AAB,0xDAAB,
 0x2AAB,0x6AAB,0xAAAB,0xEAAB,0x3AAB,0x7AAB,0xBAAB,0xFAAB,
 0x0EAB,0x4EAB,0x8EAB,0xCEAB,0x1EAB,0x5EAB,0x9EAB,0xDEAB,
 0x2EAB,0x6EAB,0xAEAB,0xEEAB,0x3EAB,0x7EAB,0xBEAB,0xFEAB,
 0x03AB,0x43AB,0x83AB,0xC3AB,0x13AB,0x53AB,0x93AB,0xD3AB,
 0x23AB,0x63AB,0xA3AB,0xE3AB,0x33AB,0x73AB,0xB3AB,0xF3AB,
 0x07AB,0x47AB,0x87AB,0xC7AB,0x17AB,0x57AB,0x97AB,0xD7AB,
 0x27AB,0x67AB,0xA7AB,0xE7AB,0x37AB,0x77AB,0xB7AB,0xF7AB,
 0x0BAB,0x4BAB,0x8BAB,0xCBAB,0x1BAB,0x5BAB,0x9BAB,0xDBAB,
 0x2BAB,0x6BAB,0xABAB,0xEBAB,0x3BAB,0x7BAB,0xBBAB,0xFBAB,
 0x0FAB,0x4FAB,0x8FAB,0xCFAB,0x1FAB,0x5FAB,0x9FAB,0xDFAB,
 0x2FAB,0x6FAB,0xAFAB,0xEFAB,0x3FAB,0x7FAB,0xBFAB,0xFFAB,
 0x00EB,0x40EB,0x80EB,0xC0EB,0x10EB,0x50EB,0x90EB,0xD0EB,
 0x20EB,0x60EB,0xA0EB,0xE0EB,0x30EB,0x70EB,0xB0EB,0xF0EB,
 0x04EB,0x44EB,0x84EB,0xC4EB,0x14EB,0x54EB,0x94EB,0xD4EB,
 0x24EB,0x64EB,0xA4EB,0xE4EB,0x34EB,0x74EB,0xB4EB,0xF4EB,
 0x08EB,0x48EB,0x88EB,0xC8EB,0x18EB,0x58EB,0x98EB,0xD8EB,
 0x28EB,0x68EB,0xA8EB,0xE8EB,0x38EB,0x78EB,0xB8EB,0xF8EB,
 0x0CEB,0x4CEB,0x8CEB,0xCCEB,0x1CEB,0x5CEB,0x9CEB,0xDCEB,
 0x2CEB,0x6CEB,0xACEB,0xECEB,0x3CEB,0x7CEB,0xBCEB,0xFCEB,
 0x01EB,0x41EB,0x81EB,0xC1EB,0x11EB,0x51EB,0x91EB,0xD1EB,
 0x21EB,0x61EB,0xA1EB,0xE1EB,0x31EB,0x71EB,0xB1EB,0xF1EB,
 0x05EB,0x45EB,0x85EB,0xC5EB,0x15EB,0x55EB,0x95EB,0xD5EB,
 0x25EB,0x65EB,0xA5EB,0xE5EB,0x35EB,0x75EB,0xB5EB,0xF5EB,
 0x09EB,0x49EB,0x89EB,0xC9EB,0x19EB,0x59EB,0x99EB,0xD9EB,
 0x29EB,0x69EB,0xA9EB,0xE9EB,0x39EB,0x79EB,0xB9EB,0xF9EB,
 0x0DEB,0x4DEB,0x8DEB,0xCDEB,0x1DEB,0x5DEB,0x9DEB,0xDDEB,
 0x2DEB,0x6DEB,0xADEB,0xEDEB,0x3DEB,0x7DEB,0xBDEB,0xFDEB,
 0x02EB,0x42EB,0x82EB,0xC2EB,0x12EB,0x52EB,0x92EB,0xD2EB,
 0x22EB,0x62EB,0xA2EB,0xE2EB,0x32EB,0x72EB,0xB2EB,0xF2EB,
 0x06EB,0x46EB,0x86EB,0xC6EB,0x16EB,0x56EB,0x96EB,0xD6EB,
 0x26EB,0x66EB,0xA6EB,0xE6EB,0x36EB,0x76EB,0xB6EB,0xF6EB,
 0x0AEB,0x4AEB,0x8AEB,0xCAEB,0x1AEB,0x5AEB,0x9AEB,0xDAEB,
 0x2AEB,0x6AEB,0xAAEB,0xEAEB,0x3AEB,0x7AEB,0xBAEB,0xFAEB,
 0x0EEB,0x4EEB,0x8EEB,0xCEEB,0x1EEB,0x5EEB,0x9EEB,0xDEEB,
 0x2EEB,0x6EEB,0xAEEB,0xEEEB,0x3EEB,0x7EEB,0xBEEB,0xFEEB,
 0x03EB,0x43EB,0x83EB,0xC3EB,0x13EB,0x53EB,0x93EB,0xD3EB,
 0x23EB,0x63EB,0xA3EB,0xE3EB,0x33EB,0x73EB,0xB3EB,0xF3EB,
 0x07EB,0x47EB,0x87EB,0xC7EB,0x17EB,0x57EB,0x97EB,0xD7EB,
 0x27EB,0x67EB,0xA7EB,0xE7EB,0x37EB,0x77EB,0xB7EB,0xF7EB,
 0x0BEB,0x4BEB,0x8BEB,0xCBEB,0x1BEB,0x5BEB,0x9BEB,0xDBEB,
 0x2BEB,0x6BEB,0xABEB,0xEBEB,0x3BEB,0x7BEB,0xBBEB,0xFBEB,
 0x0FEB,0x4FEB,0x8FEB,0xCFEB,0x1FEB,0x5FEB,0x9FEB,0xDFEB,
 0x2FEB,0x6FEB,0xAFEB,0xEFEB,0x3FEB,0x7FEB,0xBFEB,0xFFEB,
 0x003B,0x403B,0x803B,0xC03B,0x103B,0x503B,0x903B,0xD03B,
 0x203B,0x603B,0xA03B,0xE03B,0x303B,0x703B,0xB03B,0xF03B,
 0x043B,0x443B,0x843B,0xC43B,0x143B,0x543B,0x943B,0xD43B,
 0x243B,0x643B,0xA43B,0xE43B,0x343B,0x743B,0xB43B,0xF43B,
 0x083B,0x483B,0x883B,0xC83B,0x183B,0x583B,0x983B,0xD83B,
 0x283B,0x683B,0xA83B,0xE83B,0x383B,0x783B,0xB83B,0xF83B,
 0x0C3B,0x4C3B,0x8C3B,0xCC3B,0x1C3B,0x5C3B,0x9C3B,0xDC3B,
 0x2C3B,0x6C3B,0xAC3B,0xEC3B,0x3C3B,0x7C3B,0xBC3B,0xFC3B,
 0x013B,0x413B,0x813B,0xC13B,0x113B,0x513B,0x913B,0xD13B,
 0x213B,0x613B,0xA13B,0xE13B,0x313B,0x713B,0xB13B,0xF13B,
 0x053B,0x453B,0x853B,0xC53B,0x153B,0x553B,0x953B,0xD53B,
 0x253B,0x653B,0xA53B,0xE53B,0x353B,0x753B,0xB53B,0xF53B,
 0x093B,0x493B,0x893B,0xC93B,0x193B,0x593B,0x993B,0xD93B,
 0x293B,0x693B,0xA93B,0xE93B,0x393B,0x793B,0xB93B,0xF93B,
 0x0D3B,0x4D3B,0x8D3B,0xCD3B,0x1D3B,0x5D3B,0x9D3B,0xDD3B,
 0x2D3B,0x6D3B,0xAD3B,0xED3B,0x3D3B,0x7D3B,0xBD3B,0xFD3B,
 0x023B,0x423B,0x823B,0xC23B,0x123B,0x523B,0x923B,0xD23B,
 0x223B,0x623B,0xA23B,0xE23B,0x323B,0x723B,0xB23B,0xF23B,
 0x063B,0x463B,0x863B,0xC63B,0x163B,0x563B,0x963B,0xD63B,
 0x263B,0x663B,0xA63B,0xE63B,0x363B,0x763B,0xB63B,0xF63B,
 0x0A3B,0x4A3B,0x8A3B,0xCA3B,0x1A3B,0x5A3B,0x9A3B,0xDA3B,
 0x2A3B,0x6A3B,0xAA3B,0xEA3B,0x3A3B,0x7A3B,0xBA3B,0xFA3B,
 0x0E3B,0x4E3B,0x8E3B,0xCE3B,0x1E3B,0x5E3B,0x9E3B,0xDE3B,
 0x2E3B,0x6E3B,0xAE3B,0xEE3B,0x3E3B,0x7E3B,0xBE3B,0xFE3B,
 0x033B,0x433B,0x833B,0xC33B,0x133B,0x533B,0x933B,0xD33B,
 0x233B,0x633B,0xA33B,0xE33B,0x333B,0x733B,0xB33B,0xF33B,
 0x073B,0x473B,0x873B,0xC73B,0x173B,0x573B,0x973B,0xD73B,
 0x273B,0x673B,0xA73B,0xE73B,0x373B,0x773B,0xB73B,0xF73B,
 0x0B3B,0x4B3B,0x8B3B,0xCB3B,0x1B3B,0x5B3B,0x9B3B,0xDB3B,
 0x2B3B,0x6B3B,0xAB3B,0xEB3B,0x3B3B,0x7B3B,0xBB3B,0xFB3B,
 0x0F3B,0x4F3B,0x8F3B,0xCF3B,0x1F3B,0x5F3B,0x9F3B,0xDF3B,
 0x2F3B,0x6F3B,0xAF3B,0xEF3B,0x3F3B,0x7F3B,0xBF3B,0xFF3B,
 0x007B,0x407B,0x807B,0xC07B,0x107B,0x507B,0x907B,0xD07B,
 0x207B,0x607B,0xA07B,0xE07B,0x307B,0x707B,0xB07B,0xF07B,
 0x047B,0x447B,0x847B,0xC47B,0x147B,0x547B,0x947B,0xD47B,
 0x247B,0x647B,0xA47B,0xE47B,0x347B,0x747B,0xB47B,0xF47B,
 0x087B,0x487B,0x887B,0xC87B,0x187B,0x587B,0x987B,0xD87B,
 0x287B,0x687B,0xA87B,0xE87B,0x387B,0x787B,0xB87B,0xF87B,
 0x0C7B,0x4C7B,0x8C7B,0xCC7B,0x1C7B,0x5C7B,0x9C7B,0xDC7B,
 0x2C7B,0x6C7B,0xAC7B,0xEC7B,0x3C7B,0x7C7B,0xBC7B,0xFC7B,
 0x017B,0x417B,0x817B,0xC17B,0x117B,0x517B,0x917B,0xD17B,
 0x217B,0x617B,0xA17B,0xE17B,0x317B,0x717B,0xB17B,0xF17B,
 0x057B,0x457B,0x857B,0xC57B,0x157B,0x557B,0x957B,0xD57B,
 0x257B,0x657B,0xA57B,0xE57B,0x357B,0x757B,0xB57B,0xF57B,
 0x097B,0x497B,0x897B,0xC97B,0x197B,0x597B,0x997B,0xD97B,
 0x297B,0x697B,0xA97B,0xE97B,0x397B,0x797B,0xB97B,0xF97B,
 0x0D7B,0x4D7B,0x8D7B,0xCD7B,0x1D7B,0x5D7B,0x9D7B,0xDD7B,
 0x2D7B,0x6D7B,0xAD7B,0xED7B,0x3D7B,0x7D7B,0xBD7B,0xFD7B,
 0x027B,0x427B,0x827B,0xC27B,0x127B,0x527B,0x927B,0xD27B,
 0x227B,0x627B,0xA27B,0xE27B,0x327B,0x727B,0xB27B,0xF27B,
 0x067B,0x467B,0x867B,0xC67B,0x167B,0x567B,0x967B,0xD67B,
 0x267B,0x667B,0xA67B,0xE67B,0x367B,0x767B,0xB67B,0xF67B,
 0x0A7B,0x4A7B,0x8A7B,0xCA7B,0x1A7B,0x5A7B,0x9A7B,0xDA7B,
 0x2A7B,0x6A7B,0xAA7B,0xEA7B,0x3A7B,0x7A7B,0xBA7B,0xFA7B,
 0x0E7B,0x4E7B,0x8E7B,0xCE7B,0x1E7B,0x5E7B,0x9E7B,0xDE7B,
 0x2E7B,0x6E7B,0xAE7B,0xEE7B,0x3E7B,0x7E7B,0xBE7B,0xFE7B,
 0x037B,0x437B,0x837B,0xC37B,0x137B,0x537B,0x937B,0xD37B,
 0x237B,0x637B,0xA37B,0xE37B,0x337B,0x737B,0xB37B,0xF37B,
 0x077B,0x477B,0x877B,0xC77B,0x177B,0x577B,0x977B,0xD77B,
 0x277B,0x677B,0xA77B,0xE77B,0x377B,0x777B,0xB77B,0xF77B,
 0x0B7B,0x4B7B,0x8B7B,0xCB7B,0x1B7B,0x5B7B,0x9B7B,0xDB7B,
 0x2B7B,0x6B7B,0xAB7B,0xEB7B,0x3B7B,0x7B7B,0xBB7B,0xFB7B,
 0x0F7B,0x4F7B,0x8F7B,0xCF7B,0x1F7B,0x5F7B,0x9F7B,0xDF7B,
 0x2F7B,0x6F7B,0xAF7B,0xEF7B,0x3F7B,0x7F7B,0xBF7B,0xFF7B,
 0x00BB,0x40BB,0x80BB,0xC0BB,0x10BB,0x50BB,0x90BB,0xD0BB,
 0x20BB,0x60BB,0xA0BB,0xE0BB,0x30BB,0x70BB,0xB0BB,0xF0BB,
 0x04BB,0x44BB,0x84BB,0xC4BB,0x14BB,0x54BB,0x94BB,0xD4BB,
 0x24BB,0x64BB,0xA4BB,0xE4BB,0x34BB,0x74BB,0xB4BB,0xF4BB,
 0x08BB,0x48BB,0x88BB,0xC8BB,0x18BB,0x58BB,0x98BB,0xD8BB,
 0x28BB,0x68BB,0xA8BB,0xE8BB,0x38BB,0x78BB,0xB8BB,0xF8BB,
 0x0CBB,0x4CBB,0x8CBB,0xCCBB,0x1CBB,0x5CBB,0x9CBB,0xDCBB,
 0x2CBB,0x6CBB,0xACBB,0xECBB,0x3CBB,0x7CBB,0xBCBB,0xFCBB,
 0x01BB,0x41BB,0x81BB,0xC1BB,0x11BB,0x51BB,0x91BB,0xD1BB,
 0x21BB,0x61BB,0xA1BB,0xE1BB,0x31BB,0x71BB,0xB1BB,0xF1BB,
 0x05BB,0x45BB,0x85BB,0xC5BB,0x15BB,0x55BB,0x95BB,0xD5BB,
 0x25BB,0x65BB,0xA5BB,0xE5BB,0x35BB,0x75BB,0xB5BB,0xF5BB,
 0x09BB,0x49BB,0x89BB,0xC9BB,0x19BB,0x59BB,0x99BB,0xD9BB,
 0x29BB,0x69BB,0xA9BB,0xE9BB,0x39BB,0x79BB,0xB9BB,0xF9BB,
 0x0DBB,0x4DBB,0x8DBB,0xCDBB,0x1DBB,0x5DBB,0x9DBB,0xDDBB,
 0x2DBB,0x6DBB,0xADBB,0xEDBB,0x3DBB,0x7DBB,0xBDBB,0xFDBB,
 0x02BB,0x42BB,0x82BB,0xC2BB,0x12BB,0x52BB,0x92BB,0xD2BB,
 0x22BB,0x62BB,0xA2BB,0xE2BB,0x32BB,0x72BB,0xB2BB,0xF2BB,
 0x06BB,0x46BB,0x86BB,0xC6BB,0x16BB,0x56BB,0x96BB,0xD6BB,
 0x26BB,0x66BB,0xA6BB,0xE6BB,0x36BB,0x76BB,0xB6BB,0xF6BB,
 0x0ABB,0x4ABB,0x8ABB,0xCABB,0x1ABB,0x5ABB,0x9ABB,0xDABB,
 0x2ABB,0x6ABB,0xAABB,0xEABB,0x3ABB,0x7ABB,0xBABB,0xFABB,
 0x0EBB,0x4EBB,0x8EBB,0xCEBB,0x1EBB,0x5EBB,0x9EBB,0xDEBB,
 0x2EBB,0x6EBB,0xAEBB,0xEEBB,0x3EBB,0x7EBB,0xBEBB,0xFEBB,
 0x03BB,0x43BB,0x83BB,0xC3BB,0x13BB,0x53BB,0x93BB,0xD3BB,
 0x23BB,0x63BB,0xA3BB,0xE3BB,0x33BB,0x73BB,0xB3BB,0xF3BB,
 0x07BB,0x47BB,0x87BB,0xC7BB,0x17BB,0x57BB,0x97BB,0xD7BB,
 0x27BB,0x67BB,0xA7BB,0xE7BB,0x37BB,0x77BB,0xB7BB,0xF7BB,
 0x0BBB,0x4BBB,0x8BBB,0xCBBB,0x1BBB,0x5BBB,0x9BBB,0xDBBB,
 0x2BBB,0x6BBB,0xABBB,0xEBBB,0x3BBB,0x7BBB,0xBBBB,0xFBBB,
 0x0FBB,0x4FBB,0x8FBB,0xCFBB,0x1FBB,0x5FBB,0x9FBB,0xDFBB,
 0x2FBB,0x6FBB,0xAFBB,0xEFBB,0x3FBB,0x7FBB,0xBFBB,0xFFBB,
 0x00FB,0x40FB,0x80FB,0xC0FB,0x10FB,0x50FB,0x90FB,0xD0FB,
 0x20FB,0x60FB,0xA0FB,0xE0FB,0x30FB,0x70FB,0xB0FB,0xF0FB,
 0x04FB,0x44FB,0x84FB,0xC4FB,0x14FB,0x54FB,0x94FB,0xD4FB,
 0x24FB,0x64FB,0xA4FB,0xE4FB,0x34FB,0x74FB,0xB4FB,0xF4FB,
 0x08FB,0x48FB,0x88FB,0xC8FB,0x18FB,0x58FB,0x98FB,0xD8FB,
 0x28FB,0x68FB,0xA8FB,0xE8FB,0x38FB,0x78FB,0xB8FB,0xF8FB,
 0x0CFB,0x4CFB,0x8CFB,0xCCFB,0x1CFB,0x5CFB,0x9CFB,0xDCFB,
 0x2CFB,0x6CFB,0xACFB,0xECFB,0x3CFB,0x7CFB,0xBCFB,0xFCFB,
 0x01FB,0x41FB,0x81FB,0xC1FB,0x11FB,0x51FB,0x91FB,0xD1FB,
 0x21FB,0x61FB,0xA1FB,0xE1FB,0x31FB,0x71FB,0xB1FB,0xF1FB,
 0x05FB,0x45FB,0x85FB,0xC5FB,0x15FB,0x55FB,0x95FB,0xD5FB,
 0x25FB,0x65FB,0xA5FB,0xE5FB,0x35FB,0x75FB,0xB5FB,0xF5FB,
 0x09FB,0x49FB,0x89FB,0xC9FB,0x19FB,0x59FB,0x99FB,0xD9FB,
 0x29FB,0x69FB,0xA9FB,0xE9FB,0x39FB,0x79FB,0xB9FB,0xF9FB,
 0x0DFB,0x4DFB,0x8DFB,0xCDFB,0x1DFB,0x5DFB,0x9DFB,0xDDFB,
 0x2DFB,0x6DFB,0xADFB,0xEDFB,0x3DFB,0x7DFB,0xBDFB,0xFDFB,
 0x02FB,0x42FB,0x82FB,0xC2FB,0x12FB,0x52FB,0x92FB,0xD2FB,
 0x22FB,0x62FB,0xA2FB,0xE2FB,0x32FB,0x72FB,0xB2FB,0xF2FB,
 0x06FB,0x46FB,0x86FB,0xC6FB,0x16FB,0x56FB,0x96FB,0xD6FB,
 0x26FB,0x66FB,0xA6FB,0xE6FB,0x36FB,0x76FB,0xB6FB,0xF6FB,
 0x0AFB,0x4AFB,0x8AFB,0xCAFB,0x1AFB,0x5AFB,0x9AFB,0xDAFB,
 0x2AFB,0x6AFB,0xAAFB,0xEAFB,0x3AFB,0x7AFB,0xBAFB,0xFAFB,
 0x0EFB,0x4EFB,0x8EFB,0xCEFB,0x1EFB,0x5EFB,0x9EFB,0xDEFB,
 0x2EFB,0x6EFB,0xAEFB,0xEEFB,0x3EFB,0x7EFB,0xBEFB,0xFEFB,
 0x03FB,0x43FB,0x83FB,0xC3FB,0x13FB,0x53FB,0x93FB,0xD3FB,
 0x23FB,0x63FB,0xA3FB,0xE3FB,0x33FB,0x73FB,0xB3FB,0xF3FB,
 0x07FB,0x47FB,0x87FB,0xC7FB,0x17FB,0x57FB,0x97FB,0xD7FB,
 0x27FB,0x67FB,0xA7FB,0xE7FB,0x37FB,0x77FB,0xB7FB,0xF7FB,
 0x0BFB,0x4BFB,0x8BFB,0xCBFB,0x1BFB,0x5BFB,0x9BFB,0xDBFB,
 0x2BFB,0x6BFB,0xABFB,0xEBFB,0x3BFB,0x7BFB,0xBBFB,0xFBFB,
 0x0FFB,0x4FFB,0x8FFB,0xCFFB,0x1FFB,0x5FFB,0x9FFB,0xDFFB,
 0x2FFB,0x6FFB,0xAFFB,0xEFFB,0x3FFB,0x7FFB,0xBFFB,0xFFFB,
 0x000F,0x400F,0x800F,0xC00F,0x100F,0x500F,0x900F,0xD00F,
 0x200F,0x600F,0xA00F,0xE00F,0x300F,0x700F,0xB00F,0xF00F,
 0x040F,0x440F,0x840F,0xC40F,0x140F,0x540F,0x940F,0xD40F,
 0x240F,0x640F,0xA40F,0xE40F,0x340F,0x740F,0xB40F,0xF40F,
 0x080F,0x480F,0x880F,0xC80F,0x180F,0x580F,0x980F,0xD80F,
 0x280F,0x680F,0xA80F,0xE80F,0x380F,0x780F,0xB80F,0xF80F,
 0x0C0F,0x4C0F,0x8C0F,0xCC0F,0x1C0F,0x5C0F,0x9C0F,0xDC0F,
 0x2C0F,0x6C0F,0xAC0F,0xEC0F,0x3C0F,0x7C0F,0xBC0F,0xFC0F,
 0x010F,0x410F,0x810F,0xC10F,0x110F,0x510F,0x910F,0xD10F,
 0x210F,0x610F,0xA10F,0xE10F,0x310F,0x710F,0xB10F,0xF10F,
 0x050F,0x450F,0x850F,0xC50F,0x150F,0x550F,0x950F,0xD50F,
 0x250F,0x650F,0xA50F,0xE50F,0x350F,0x750F,0xB50F,0xF50F,
 0x090F,0x490F,0x890F,0xC90F,0x190F,0x590F,0x990F,0xD90F,
 0x290F,0x690F,0xA90F,0xE90F,0x390F,0x790F,0xB90F,0xF90F,
 0x0D0F,0x4D0F,0x8D0F,0xCD0F,0x1D0F,0x5D0F,0x9D0F,0xDD0F,
 0x2D0F,0x6D0F,0xAD0F,0xED0F,0x3D0F,0x7D0F,0xBD0F,0xFD0F,
 0x020F,0x420F,0x820F,0xC20F,0x120F,0x520F,0x920F,0xD20F,
 0x220F,0x620F,0xA20F,0xE20F,0x320F,0x720F,0xB20F,0xF20F,
 0x060F,0x460F,0x860F,0xC60F,0x160F,0x560F,0x960F,0xD60F,
 0x260F,0x660F,0xA60F,0xE60F,0x360F,0x760F,0xB60F,0xF60F,
 0x0A0F,0x4A0F,0x8A0F,0xCA0F,0x1A0F,0x5A0F,0x9A0F,0xDA0F,
 0x2A0F,0x6A0F,0xAA0F,0xEA0F,0x3A0F,0x7A0F,0xBA0F,0xFA0F,
 0x0E0F,0x4E0F,0x8E0F,0xCE0F,0x1E0F,0x5E0F,0x9E0F,0xDE0F,
 0x2E0F,0x6E0F,0xAE0F,0xEE0F,0x3E0F,0x7E0F,0xBE0F,0xFE0F,
 0x030F,0x430F,0x830F,0xC30F,0x130F,0x530F,0x930F,0xD30F,
 0x230F,0x630F,0xA30F,0xE30F,0x330F,0x730F,0xB30F,0xF30F,
 0x070F,0x470F,0x870F,0xC70F,0x170F,0x570F,0x970F,0xD70F,
 0x270F,0x670F,0xA70F,0xE70F,0x370F,0x770F,0xB70F,0xF70F,
 0x0B0F,0x4B0F,0x8B0F,0xCB0F,0x1B0F,0x5B0F,0x9B0F,0xDB0F,
 0x2B0F,0x6B0F,0xAB0F,0xEB0F,0x3B0F,0x7B0F,0xBB0F,0xFB0F,
 0x0F0F,0x4F0F,0x8F0F,0xCF0F,0x1F0F,0x5F0F,0x9F0F,0xDF0F,
 0x2F0F,0x6F0F,0xAF0F,0xEF0F,0x3F0F,0x7F0F,0xBF0F,0xFF0F,
 0x004F,0x404F,0x804F,0xC04F,0x104F,0x504F,0x904F,0xD04F,
 0x204F,0x604F,0xA04F,0xE04F,0x304F,0x704F,0xB04F,0xF04F,
 0x044F,0x444F,0x844F,0xC44F,0x144F,0x544F,0x944F,0xD44F,
 0x244F,0x644F,0xA44F,0xE44F,0x344F,0x744F,0xB44F,0xF44F,
 0x084F,0x484F,0x884F,0xC84F,0x184F,0x584F,0x984F,0xD84F,
 0x284F,0x684F,0xA84F,0xE84F,0x384F,0x784F,0xB84F,0xF84F,
 0x0C4F,0x4C4F,0x8C4F,0xCC4F,0x1C4F,0x5C4F,0x9C4F,0xDC4F,
 0x2C4F,0x6C4F,0xAC4F,0xEC4F,0x3C4F,0x7C4F,0xBC4F,0xFC4F,
 0x014F,0x414F,0x814F,0xC14F,0x114F,0x514F,0x914F,0xD14F,
 0x214F,0x614F,0xA14F,0xE14F,0x314F,0x714F,0xB14F,0xF14F,
 0x054F,0x454F,0x854F,0xC54F,0x154F,0x554F,0x954F,0xD54F,
 0x254F,0x654F,0xA54F,0xE54F,0x354F,0x754F,0xB54F,0xF54F,
 0x094F,0x494F,0x894F,0xC94F,0x194F,0x594F,0x994F,0xD94F,
 0x294F,0x694F,0xA94F,0xE94F,0x394F,0x794F,0xB94F,0xF94F,
 0x0D4F,0x4D4F,0x8D4F,0xCD4F,0x1D4F,0x5D4F,0x9D4F,0xDD4F,
 0x2D4F,0x6D4F,0xAD4F,0xED4F,0x3D4F,0x7D4F,0xBD4F,0xFD4F,
 0x024F,0x424F,0x824F,0xC24F,0x124F,0x524F,0x924F,0xD24F,
 0x224F,0x624F,0xA24F,0xE24F,0x324F,0x724F,0xB24F,0xF24F,
 0x064F,0x464F,0x864F,0xC64F,0x164F,0x564F,0x964F,0xD64F,
 0x264F,0x664F,0xA64F,0xE64F,0x364F,0x764F,0xB64F,0xF64F,
 0x0A4F,0x4A4F,0x8A4F,0xCA4F,0x1A4F,0x5A4F,0x9A4F,0xDA4F,
 0x2A4F,0x6A4F,0xAA4F,0xEA4F,0x3A4F,0x7A4F,0xBA4F,0xFA4F,
 0x0E4F,0x4E4F,0x8E4F,0xCE4F,0x1E4F,0x5E4F,0x9E4F,0xDE4F,
 0x2E4F,0x6E4F,0xAE4F,0xEE4F,0x3E4F,0x7E4F,0xBE4F,0xFE4F,
 0x034F,0x434F,0x834F,0xC34F,0x134F,0x534F,0x934F,0xD34F,
 0x234F,0x634F,0xA34F,0xE34F,0x334F,0x734F,0xB34F,0xF34F,
 0x074F,0x474F,0x874F,0xC74F,0x174F,0x574F,0x974F,0xD74F,
 0x274F,0x674F,0xA74F,0xE74F,0x374F,0x774F,0xB74F,0xF74F,
 0x0B4F,0x4B4F,0x8B4F,0xCB4F,0x1B4F,0x5B4F,0x9B4F,0xDB4F,
 0x2B4F,0x6B4F,0xAB4F,0xEB4F,0x3B4F,0x7B4F,0xBB4F,0xFB4F,
 0x0F4F,0x4F4F,0x8F4F,0xCF4F,0x1F4F,0x5F4F,0x9F4F,0xDF4F,
 0x2F4F,0x6F4F,0xAF4F,0xEF4F,0x3F4F,0x7F4F,0xBF4F,0xFF4F,
 0x008F,0x408F,0x808F,0xC08F,0x108F,0x508F,0x908F,0xD08F,
 0x208F,0x608F,0xA08F,0xE08F,0x308F,0x708F,0xB08F,0xF08F,
 0x048F,0x448F,0x848F,0xC48F,0x148F,0x548F,0x948F,0xD48F,
 0x248F,0x648F,0xA48F,0xE48F,0x348F,0x748F,0xB48F,0xF48F,
 0x088F,0x488F,0x888F,0xC88F,0x188F,0x588F,0x988F,0xD88F,
 0x288F,0x688F,0xA88F,0xE88F,0x388F,0x788F,0xB88F,0xF88F,
 0x0C8F,0x4C8F,0x8C8F,0xCC8F,0x1C8F,0x5C8F,0x9C8F,0xDC8F,
 0x2C8F,0x6C8F,0xAC8F,0xEC8F,0x3C8F,0x7C8F,0xBC8F,0xFC8F,
 0x018F,0x418F,0x818F,0xC18F,0x118F,0x518F,0x918F,0xD18F,
 0x218F,0x618F,0xA18F,0xE18F,0x318F,0x718F,0xB18F,0xF18F,
 0x058F,0x458F,0x858F,0xC58F,0x158F,0x558F,0x958F,0xD58F,
 0x258F,0x658F,0xA58F,0xE58F,0x358F,0x758F,0xB58F,0xF58F,
 0x098F,0x498F,0x898F,0xC98F,0x198F,0x598F,0x998F,0xD98F,
 0x298F,0x698F,0xA98F,0xE98F,0x398F,0x798F,0xB98F,0xF98F,
 0x0D8F,0x4D8F,0x8D8F,0xCD8F,0x1D8F,0x5D8F,0x9D8F,0xDD8F,
 0x2D8F,0x6D8F,0xAD8F,0xED8F,0x3D8F,0x7D8F,0xBD8F,0xFD8F,
 0x028F,0x428F,0x828F,0xC28F,0x128F,0x528F,0x928F,0xD28F,
 0x228F,0x628F,0xA28F,0xE28F,0x328F,0x728F,0xB28F,0xF28F,
 0x068F,0x468F,0x868F,0xC68F,0x168F,0x568F,0x968F,0xD68F,
 0x268F,0x668F,0xA68F,0xE68F,0x368F,0x768F,0xB68F,0xF68F,
 0x0A8F,0x4A8F,0x8A8F,0xCA8F,0x1A8F,0x5A8F,0x9A8F,0xDA8F,
 0x2A8F,0x6A8F,0xAA8F,0xEA8F,0x3A8F,0x7A8F,0xBA8F,0xFA8F,
 0x0E8F,0x4E8F,0x8E8F,0xCE8F,0x1E8F,0x5E8F,0x9E8F,0xDE8F,
 0x2E8F,0x6E8F,0xAE8F,0xEE8F,0x3E8F,0x7E8F,0xBE8F,0xFE8F,
 0x038F,0x438F,0x838F,0xC38F,0x138F,0x538F,0x938F,0xD38F,
 0x238F,0x638F,0xA38F,0xE38F,0x338F,0x738F,0xB38F,0xF38F,
 0x078F,0x478F,0x878F,0xC78F,0x178F,0x578F,0x978F,0xD78F,
 0x278F,0x678F,0xA78F,0xE78F,0x378F,0x778F,0xB78F,0xF78F,
 0x0B8F,0x4B8F,0x8B8F,0xCB8F,0x1B8F,0x5B8F,0x9B8F,0xDB8F,
 0x2B8F,0x6B8F,0xAB8F,0xEB8F,0x3B8F,0x7B8F,0xBB8F,0xFB8F,
 0x0F8F,0x4F8F,0x8F8F,0xCF8F,0x1F8F,0x5F8F,0x9F8F,0xDF8F,
 0x2F8F,0x6F8F,0xAF8F,0xEF8F,0x3F8F,0x7F8F,0xBF8F,0xFF8F,
 0x00CF,0x40CF,0x80CF,0xC0CF,0x10CF,0x50CF,0x90CF,0xD0CF,
 0x20CF,0x60CF,0xA0CF,0xE0CF,0x30CF,0x70CF,0xB0CF,0xF0CF,
 0x04CF,0x44CF,0x84CF,0xC4CF,0x14CF,0x54CF,0x94CF,0xD4CF,
 0x24CF,0x64CF,0xA4CF,0xE4CF,0x34CF,0x74CF,0xB4CF,0xF4CF,
 0x08CF,0x48CF,0x88CF,0xC8CF,0x18CF,0x58CF,0x98CF,0xD8CF,
 0x28CF,0x68CF,0xA8CF,0xE8CF,0x38CF,0x78CF,0xB8CF,0xF8CF,
 0x0CCF,0x4CCF,0x8CCF,0xCCCF,0x1CCF,0x5CCF,0x9CCF,0xDCCF,
 0x2CCF,0x6CCF,0xACCF,0xECCF,0x3CCF,0x7CCF,0xBCCF,0xFCCF,
 0x01CF,0x41CF,0x81CF,0xC1CF,0x11CF,0x51CF,0x91CF,0xD1CF,
 0x21CF,0x61CF,0xA1CF,0xE1CF,0x31CF,0x71CF,0xB1CF,0xF1CF,
 0x05CF,0x45CF,0x85CF,0xC5CF,0x15CF,0x55CF,0x95CF,0xD5CF,
 0x25CF,0x65CF,0xA5CF,0xE5CF,0x35CF,0x75CF,0xB5CF,0xF5CF,
 0x09CF,0x49CF,0x89CF,0xC9CF,0x19CF,0x59CF,0x99CF,0xD9CF,
 0x29CF,0x69CF,0xA9CF,0xE9CF,0x39CF,0x79CF,0xB9CF,0xF9CF,
 0x0DCF,0x4DCF,0x8DCF,0xCDCF,0x1DCF,0x5DCF,0x9DCF,0xDDCF,
 0x2DCF,0x6DCF,0xADCF,0xEDCF,0x3DCF,0x7DCF,0xBDCF,0xFDCF,
 0x02CF,0x42CF,0x82CF,0xC2CF,0x12CF,0x52CF,0x92CF,0xD2CF,
 0x22CF,0x62CF,0xA2CF,0xE2CF,0x32CF,0x72CF,0xB2CF,0xF2CF,
 0x06CF,0x46CF,0x86CF,0xC6CF,0x16CF,0x56CF,0x96CF,0xD6CF,
 0x26CF,0x66CF,0xA6CF,0xE6CF,0x36CF,0x76CF,0xB6CF,0xF6CF,
 0x0ACF,0x4ACF,0x8ACF,0xCACF,0x1ACF,0x5ACF,0x9ACF,0xDACF,
 0x2ACF,0x6ACF,0xAACF,0xEACF,0x3ACF,0x7ACF,0xBACF,0xFACF,
 0x0ECF,0x4ECF,0x8ECF,0xCECF,0x1ECF,0x5ECF,0x9ECF,0xDECF,
 0x2ECF,0x6ECF,0xAECF,0xEECF,0x3ECF,0x7ECF,0xBECF,0xFECF,
 0x03CF,0x43CF,0x83CF,0xC3CF,0x13CF,0x53CF,0x93CF,0xD3CF,
 0x23CF,0x63CF,0xA3CF,0xE3CF,0x33CF,0x73CF,0xB3CF,0xF3CF,
 0x07CF,0x47CF,0x87CF,0xC7CF,0x17CF,0x57CF,0x97CF,0xD7CF,
 0x27CF,0x67CF,0xA7CF,0xE7CF,0x37CF,0x77CF,0xB7CF,0xF7CF,
 0x0BCF,0x4BCF,0x8BCF,0xCBCF,0x1BCF,0x5BCF,0x9BCF,0xDBCF,
 0x2BCF,0x6BCF,0xABCF,0xEBCF,0x3BCF,0x7BCF,0xBBCF,0xFBCF,
 0x0FCF,0x4FCF,0x8FCF,0xCFCF,0x1FCF,0x5FCF,0x9FCF,0xDFCF,
 0x2FCF,0x6FCF,0xAFCF,0xEFCF,0x3FCF,0x7FCF,0xBFCF,0xFFCF,
 0x001F,0x401F,0x801F,0xC01F,0x101F,0x501F,0x901F,0xD01F,
 0x201F,0x601F,0xA01F,0xE01F,0x301F,0x701F,0xB01F,0xF01F,
 0x041F,0x441F,0x841F,0xC41F,0x141F,0x541F,0x941F,0xD41F,
 0x241F,0x641F,0xA41F,0xE41F,0x341F,0x741F,0xB41F,0xF41F,
 0x081F,0x481F,0x881F,0xC81F,0x181F,0x581F,0x981F,0xD81F,
 0x281F,0x681F,0xA81F,0xE81F,0x381F,0x781F,0xB81F,0xF81F,
 0x0C1F,0x4C1F,0x8C1F,0xCC1F,0x1C1F,0x5C1F,0x9C1F,0xDC1F,
 0x2C1F,0x6C1F,0xAC1F,0xEC1F,0x3C1F,0x7C1F,0xBC1F,0xFC1F,
 0x011F,0x411F,0x811F,0xC11F,0x111F,0x511F,0x911F,0xD11F,
 0x211F,0x611F,0xA11F,0xE11F,0x311F,0x711F,0xB11F,0xF11F,
 0x051F,0x451F,0x851F,0xC51F,0x151F,0x551F,0x951F,0xD51F,
 0x251F,0x651F,0xA51F,0xE51F,0x351F,0x751F,0xB51F,0xF51F,
 0x091F,0x491F,0x891F,0xC91F,0x191F,0x591F,0x991F,0xD91F,
 0x291F,0x691F,0xA91F,0xE91F,0x391F,0x791F,0xB91F,0xF91F,
 0x0D1F,0x4D1F,0x8D1F,0xCD1F,0x1D1F,0x5D1F,0x9D1F,0xDD1F,
 0x2D1F,0x6D1F,0xAD1F,0xED1F,0x3D1F,0x7D1F,0xBD1F,0xFD1F,
 0x021F,0x421F,0x821F,0xC21F,0x121F,0x521F,0x921F,0xD21F,
 0x221F,0x621F,0xA21F,0xE21F,0x321F,0x721F,0xB21F,0xF21F,
 0x061F,0x461F,0x861F,0xC61F,0x161F,0x561F,0x961F,0xD61F,
 0x261F,0x661F,0xA61F,0xE61F,0x361F,0x761F,0xB61F,0xF61F,
 0x0A1F,0x4A1F,0x8A1F,0xCA1F,0x1A1F,0x5A1F,0x9A1F,0xDA1F,
 0x2A1F,0x6A1F,0xAA1F,0xEA1F,0x3A1F,0x7A1F,0xBA1F,0xFA1F,
 0x0E1F,0x4E1F,0x8E1F,0xCE1F,0x1E1F,0x5E1F,0x9E1F,0xDE1F,
 0x2E1F,0x6E1F,0xAE1F,0xEE1F,0x3E1F,0x7E1F,0xBE1F,0xFE1F,
 0x031F,0x431F,0x831F,0xC31F,0x131F,0x531F,0x931F,0xD31F,
 0x231F,0x631F,0xA31F,0xE31F,0x331F,0x731F,0xB31F,0xF31F,
 0x071F,0x471F,0x871F,0xC71F,0x171F,0x571F,0x971F,0xD71F,
 0x271F,0x671F,0xA71F,0xE71F,0x371F,0x771F,0xB71F,0xF71F,
 0x0B1F,0x4B1F,0x8B1F,0xCB1F,0x1B1F,0x5B1F,0x9B1F,0xDB1F,
 0x2B1F,0x6B1F,0xAB1F,0xEB1F,0x3B1F,0x7B1F,0xBB1F,0xFB1F,
 0x0F1F,0x4F1F,0x8F1F,0xCF1F,0x1F1F,0x5F1F,0x9F1F,0xDF1F,
 0x2F1F,0x6F1F,0xAF1F,0xEF1F,0x3F1F,0x7F1F,0xBF1F,0xFF1F,
 0x005F,0x405F,0x805F,0xC05F,0x105F,0x505F,0x905F,0xD05F,
 0x205F,0x605F,0xA05F,0xE05F,0x305F,0x705F,0xB05F,0xF05F,
 0x045F,0x445F,0x845F,0xC45F,0x145F,0x545F,0x945F,0xD45F,
 0x245F,0x645F,0xA45F,0xE45F,0x345F,0x745F,0xB45F,0xF45F,
 0x085F,0x485F,0x885F,0xC85F,0x185F,0x585F,0x985F,0xD85F,
 0x285F,0x685F,0xA85F,0xE85F,0x385F,0x785F,0xB85F,0xF85F,
 0x0C5F,0x4C5F,0x8C5F,0xCC5F,0x1C5F,0x5C5F,0x9C5F,0xDC5F,
 0x2C5F,0x6C5F,0xAC5F,0xEC5F,0x3C5F,0x7C5F,0xBC5F,0xFC5F,
 0x015F,0x415F,0x815F,0xC15F,0x115F,0x515F,0x915F,0xD15F,
 0x215F,0x615F,0xA15F,0xE15F,0x315F,0x715F,0xB15F,0xF15F,
 0x055F,0x455F,0x855F,0xC55F,0x155F,0x555F,0x955F,0xD55F,
 0x255F,0x655F,0xA55F,0xE55F,0x355F,0x755F,0xB55F,0xF55F,
 0x095F,0x495F,0x895F,0xC95F,0x195F,0x595F,0x995F,0xD95F,
 0x295F,0x695F,0xA95F,0xE95F,0x395F,0x795F,0xB95F,0xF95F,
 0x0D5F,0x4D5F,0x8D5F,0xCD5F,0x1D5F,0x5D5F,0x9D5F,0xDD5F,
 0x2D5F,0x6D5F,0xAD5F,0xED5F,0x3D5F,0x7D5F,0xBD5F,0xFD5F,
 0x025F,0x425F,0x825F,0xC25F,0x125F,0x525F,0x925F,0xD25F,
 0x225F,0x625F,0xA25F,0xE25F,0x325F,0x725F,0xB25F,0xF25F,
 0x065F,0x465F,0x865F,0xC65F,0x165F,0x565F,0x965F,0xD65F,
 0x265F,0x665F,0xA65F,0xE65F,0x365F,0x765F,0xB65F,0xF65F,
 0x0A5F,0x4A5F,0x8A5F,0xCA5F,0x1A5F,0x5A5F,0x9A5F,0xDA5F,
 0x2A5F,0x6A5F,0xAA5F,0xEA5F,0x3A5F,0x7A5F,0xBA5F,0xFA5F,
 0x0E5F,0x4E5F,0x8E5F,0xCE5F,0x1E5F,0x5E5F,0x9E5F,0xDE5F,
 0x2E5F,0x6E5F,0xAE5F,0xEE5F,0x3E5F,0x7E5F,0xBE5F,0xFE5F,
 0x035F,0x435F,0x835F,0xC35F,0x135F,0x535F,0x935F,0xD35F,
 0x235F,0x635F,0xA35F,0xE35F,0x335F,0x735F,0xB35F,0xF35F,
 0x075F,0x475F,0x875F,0xC75F,0x175F,0x575F,0x975F,0xD75F,
 0x275F,0x675F,0xA75F,0xE75F,0x375F,0x775F,0xB75F,0xF75F,
 0x0B5F,0x4B5F,0x8B5F,0xCB5F,0x1B5F,0x5B5F,0x9B5F,0xDB5F,
 0x2B5F,0x6B5F,0xAB5F,0xEB5F,0x3B5F,0x7B5F,0xBB5F,0xFB5F,
 0x0F5F,0x4F5F,0x8F5F,0xCF5F,0x1F5F,0x5F5F,0x9F5F,0xDF5F,
 0x2F5F,0x6F5F,0xAF5F,0xEF5F,0x3F5F,0x7F5F,0xBF5F,0xFF5F,
 0x009F,0x409F,0x809F,0xC09F,0x109F,0x509F,0x909F,0xD09F,
 0x209F,0x609F,0xA09F,0xE09F,0x309F,0x709F,0xB09F,0xF09F,
 0x049F,0x449F,0x849F,0xC49F,0x149F,0x549F,0x949F,0xD49F,
 0x249F,0x649F,0xA49F,0xE49F,0x349F,0x749F,0xB49F,0xF49F,
 0x089F,0x489F,0x889F,0xC89F,0x189F,0x589F,0x989F,0xD89F,
 0x289F,0x689F,0xA89F,0xE89F,0x389F,0x789F,0xB89F,0xF89F,
 0x0C9F,0x4C9F,0x8C9F,0xCC9F,0x1C9F,0x5C9F,0x9C9F,0xDC9F,
 0x2C9F,0x6C9F,0xAC9F,0xEC9F,0x3C9F,0x7C9F,0xBC9F,0xFC9F,
 0x019F,0x419F,0x819F,0xC19F,0x119F,0x519F,0x919F,0xD19F,
 0x219F,0x619F,0xA19F,0xE19F,0x319F,0x719F,0xB19F,0xF19F,
 0x059F,0x459F,0x859F,0xC59F,0x159F,0x559F,0x959F,0xD59F,
 0x259F,0x659F,0xA59F,0xE59F,0x359F,0x759F,0xB59F,0xF59F,
 0x099F,0x499F,0x899F,0xC99F,0x199F,0x599F,0x999F,0xD99F,
 0x299F,0x699F,0xA99F,0xE99F,0x399F,0x799F,0xB99F,0xF99F,
 0x0D9F,0x4D9F,0x8D9F,0xCD9F,0x1D9F,0x5D9F,0x9D9F,0xDD9F,
 0x2D9F,0x6D9F,0xAD9F,0xED9F,0x3D9F,0x7D9F,0xBD9F,0xFD9F,
 0x029F,0x429F,0x829F,0xC29F,0x129F,0x529F,0x929F,0xD29F,
 0x229F,0x629F,0xA29F,0xE29F,0x329F,0x729F,0xB29F,0xF29F,
 0x069F,0x469F,0x869F,0xC69F,0x169F,0x569F,0x969F,0xD69F,
 0x269F,0x669F,0xA69F,0xE69F,0x369F,0x769F,0xB69F,0xF69F,
 0x0A9F,0x4A9F,0x8A9F,0xCA9F,0x1A9F,0x5A9F,0x9A9F,0xDA9F,
 0x2A9F,0x6A9F,0xAA9F,0xEA9F,0x3A9F,0x7A9F,0xBA9F,0xFA9F,
 0x0E9F,0x4E9F,0x8E9F,0xCE9F,0x1E9F,0x5E9F,0x9E9F,0xDE9F,
 0x2E9F,0x6E9F,0xAE9F,0xEE9F,0x3E9F,0x7E9F,0xBE9F,0xFE9F,
 0x039F,0x439F,0x839F,0xC39F,0x139F,0x539F,0x939F,0xD39F,
 0x239F,0x639F,0xA39F,0xE39F,0x339F,0x739F,0xB39F,0xF39F,
 0x079F,0x479F,0x879F,0xC79F,0x179F,0x579F,0x979F,0xD79F,
 0x279F,0x679F,0xA79F,0xE79F,0x379F,0x779F,0xB79F,0xF79F,
 0x0B9F,0x4B9F,0x8B9F,0xCB9F,0x1B9F,0x5B9F,0x9B9F,0xDB9F,
 0x2B9F,0x6B9F,0xAB9F,0xEB9F,0x3B9F,0x7B9F,0xBB9F,0xFB9F,
 0x0F9F,0x4F9F,0x8F9F,0xCF9F,0x1F9F,0x5F9F,0x9F9F,0xDF9F,
 0x2F9F,0x6F9F,0xAF9F,0xEF9F,0x3F9F,0x7F9F,0xBF9F,0xFF9F,
 0x00DF,0x40DF,0x80DF,0xC0DF,0x10DF,0x50DF,0x90DF,0xD0DF,
 0x20DF,0x60DF,0xA0DF,0xE0DF,0x30DF,0x70DF,0xB0DF,0xF0DF,
 0x04DF,0x44DF,0x84DF,0xC4DF,0x14DF,0x54DF,0x94DF,0xD4DF,
 0x24DF,0x64DF,0xA4DF,0xE4DF,0x34DF,0x74DF,0xB4DF,0xF4DF,
 0x08DF,0x48DF,0x88DF,0xC8DF,0x18DF,0x58DF,0x98DF,0xD8DF,
 0x28DF,0x68DF,0xA8DF,0xE8DF,0x38DF,0x78DF,0xB8DF,0xF8DF,
 0x0CDF,0x4CDF,0x8CDF,0xCCDF,0x1CDF,0x5CDF,0x9CDF,0xDCDF,
 0x2CDF,0x6CDF,0xACDF,0xECDF,0x3CDF,0x7CDF,0xBCDF,0xFCDF,
 0x01DF,0x41DF,0x81DF,0xC1DF,0x11DF,0x51DF,0x91DF,0xD1DF,
 0x21DF,0x61DF,0xA1DF,0xE1DF,0x31DF,0x71DF,0xB1DF,0xF1DF,
 0x05DF,0x45DF,0x85DF,0xC5DF,0x15DF,0x55DF,0x95DF,0xD5DF,
 0x25DF,0x65DF,0xA5DF,0xE5DF,0x35DF,0x75DF,0xB5DF,0xF5DF,
 0x09DF,0x49DF,0x89DF,0xC9DF,0x19DF,0x59DF,0x99DF,0xD9DF,
 0x29DF,0x69DF,0xA9DF,0xE9DF,0x39DF,0x79DF,0xB9DF,0xF9DF,
 0x0DDF,0x4DDF,0x8DDF,0xCDDF,0x1DDF,0x5DDF,0x9DDF,0xDDDF,
 0x2DDF,0x6DDF,0xADDF,0xEDDF,0x3DDF,0x7DDF,0xBDDF,0xFDDF,
 0x02DF,0x42DF,0x82DF,0xC2DF,0x12DF,0x52DF,0x92DF,0xD2DF,
 0x22DF,0x62DF,0xA2DF,0xE2DF,0x32DF,0x72DF,0xB2DF,0xF2DF,
 0x06DF,0x46DF,0x86DF,0xC6DF,0x16DF,0x56DF,0x96DF,0xD6DF,
 0x26DF,0x66DF,0xA6DF,0xE6DF,0x36DF,0x76DF,0xB6DF,0xF6DF,
 0x0ADF,0x4ADF,0x8ADF,0xCADF,0x1ADF,0x5ADF,0x9ADF,0xDADF,
 0x2ADF,0x6ADF,0xAADF,0xEADF,0x3ADF,0x7ADF,0xBADF,0xFADF,
 0x0EDF,0x4EDF,0x8EDF,0xCEDF,0x1EDF,0x5EDF,0x9EDF,0xDEDF,
 0x2EDF,0x6EDF,0xAEDF,0xEEDF,0x3EDF,0x7EDF,0xBEDF,0xFEDF,
 0x03DF,0x43DF,0x83DF,0xC3DF,0x13DF,0x53DF,0x93DF,0xD3DF,
 0x23DF,0x63DF,0xA3DF,0xE3DF,0x33DF,0x73DF,0xB3DF,0xF3DF,
 0x07DF,0x47DF,0x87DF,0xC7DF,0x17DF,0x57DF,0x97DF,0xD7DF,
 0x27DF,0x67DF,0xA7DF,0xE7DF,0x37DF,0x77DF,0xB7DF,0xF7DF,
 0x0BDF,0x4BDF,0x8BDF,0xCBDF,0x1BDF,0x5BDF,0x9BDF,0xDBDF,
 0x2BDF,0x6BDF,0xABDF,0xEBDF,0x3BDF,0x7BDF,0xBBDF,0xFBDF,
 0x0FDF,0x4FDF,0x8FDF,0xCFDF,0x1FDF,0x5FDF,0x9FDF,0xDFDF,
 0x2FDF,0x6FDF,0xAFDF,0xEFDF,0x3FDF,0x7FDF,0xBFDF,0xFFDF,
 0x002F,0x402F,0x802F,0xC02F,0x102F,0x502F,0x902F,0xD02F,
 0x202F,0x602F,0xA02F,0xE02F,0x302F,0x702F,0xB02F,0xF02F,
 0x042F,0x442F,0x842F,0xC42F,0x142F,0x542F,0x942F,0xD42F,
 0x242F,0x642F,0xA42F,0xE42F,0x342F,0x742F,0xB42F,0xF42F,
 0x082F,0x482F,0x882F,0xC82F,0x182F,0x582F,0x982F,0xD82F,
 0x282F,0x682F,0xA82F,0xE82F,0x382F,0x782F,0xB82F,0xF82F,
 0x0C2F,0x4C2F,0x8C2F,0xCC2F,0x1C2F,0x5C2F,0x9C2F,0xDC2F,
 0x2C2F,0x6C2F,0xAC2F,0xEC2F,0x3C2F,0x7C2F,0xBC2F,0xFC2F,
 0x012F,0x412F,0x812F,0xC12F,0x112F,0x512F,0x912F,0xD12F,
 0x212F,0x612F,0xA12F,0xE12F,0x312F,0x712F,0xB12F,0xF12F,
 0x052F,0x452F,0x852F,0xC52F,0x152F,0x552F,0x952F,0xD52F,
 0x252F,0x652F,0xA52F,0xE52F,0x352F,0x752F,0xB52F,0xF52F,
 0x092F,0x492F,0x892F,0xC92F,0x192F,0x592F,0x992F,0xD92F,
 0x292F,0x692F,0xA92F,0xE92F,0x392F,0x792F,0xB92F,0xF92F,
 0x0D2F,0x4D2F,0x8D2F,0xCD2F,0x1D2F,0x5D2F,0x9D2F,0xDD2F,
 0x2D2F,0x6D2F,0xAD2F,0xED2F,0x3D2F,0x7D2F,0xBD2F,0xFD2F,
 0x022F,0x422F,0x822F,0xC22F,0x122F,0x522F,0x922F,0xD22F,
 0x222F,0x622F,0xA22F,0xE22F,0x322F,0x722F,0xB22F,0xF22F,
 0x062F,0x462F,0x862F,0xC62F,0x162F,0x562F,0x962F,0xD62F,
 0x262F,0x662F,0xA62F,0xE62F,0x362F,0x762F,0xB62F,0xF62F,
 0x0A2F,0x4A2F,0x8A2F,0xCA2F,0x1A2F,0x5A2F,0x9A2F,0xDA2F,
 0x2A2F,0x6A2F,0xAA2F,0xEA2F,0x3A2F,0x7A2F,0xBA2F,0xFA2F,
 0x0E2F,0x4E2F,0x8E2F,0xCE2F,0x1E2F,0x5E2F,0x9E2F,0xDE2F,
 0x2E2F,0x6E2F,0xAE2F,0xEE2F,0x3E2F,0x7E2F,0xBE2F,0xFE2F,
 0x032F,0x432F,0x832F,0xC32F,0x132F,0x532F,0x932F,0xD32F,
 0x232F,0x632F,0xA32F,0xE32F,0x332F,0x732F,0xB32F,0xF32F,
 0x072F,0x472F,0x872F,0xC72F,0x172F,0x572F,0x972F,0xD72F,
 0x272F,0x672F,0xA72F,0xE72F,0x372F,0x772F,0xB72F,0xF72F,
 0x0B2F,0x4B2F,0x8B2F,0xCB2F,0x1B2F,0x5B2F,0x9B2F,0xDB2F,
 0x2B2F,0x6B2F,0xAB2F,0xEB2F,0x3B2F,0x7B2F,0xBB2F,0xFB2F,
 0x0F2F,0x4F2F,0x8F2F,0xCF2F,0x1F2F,0x5F2F,0x9F2F,0xDF2F,
 0x2F2F,0x6F2F,0xAF2F,0xEF2F,0x3F2F,0x7F2F,0xBF2F,0xFF2F,
 0x006F,0x406F,0x806F,0xC06F,0x106F,0x506F,0x906F,0xD06F,
 0x206F,0x606F,0xA06F,0xE06F,0x306F,0x706F,0xB06F,0xF06F,
 0x046F,0x446F,0x846F,0xC46F,0x146F,0x546F,0x946F,0xD46F,
 0x246F,0x646F,0xA46F,0xE46F,0x346F,0x746F,0xB46F,0xF46F,
 0x086F,0x486F,0x886F,0xC86F,0x186F,0x586F,0x986F,0xD86F,
 0x286F,0x686F,0xA86F,0xE86F,0x386F,0x786F,0xB86F,0xF86F,
 0x0C6F,0x4C6F,0x8C6F,0xCC6F,0x1C6F,0x5C6F,0x9C6F,0xDC6F,
 0x2C6F,0x6C6F,0xAC6F,0xEC6F,0x3C6F,0x7C6F,0xBC6F,0xFC6F,
 0x016F,0x416F,0x816F,0xC16F,0x116F,0x516F,0x916F,0xD16F,
 0x216F,0x616F,0xA16F,0xE16F,0x316F,0x716F,0xB16F,0xF16F,
 0x056F,0x456F,0x856F,0xC56F,0x156F,0x556F,0x956F,0xD56F,
 0x256F,0x656F,0xA56F,0xE56F,0x356F,0x756F,0xB56F,0xF56F,
 0x096F,0x496F,0x896F,0xC96F,0x196F,0x596F,0x996F,0xD96F,
 0x296F,0x696F,0xA96F,0xE96F,0x396F,0x796F,0xB96F,0xF96F,
 0x0D6F,0x4D6F,0x8D6F,0xCD6F,0x1D6F,0x5D6F,0x9D6F,0xDD6F,
 0x2D6F,0x6D6F,0xAD6F,0xED6F,0x3D6F,0x7D6F,0xBD6F,0xFD6F,
 0x026F,0x426F,0x826F,0xC26F,0x126F,0x526F,0x926F,0xD26F,
 0x226F,0x626F,0xA26F,0xE26F,0x326F,0x726F,0xB26F,0xF26F,
 0x066F,0x466F,0x866F,0xC66F,0x166F,0x566F,0x966F,0xD66F,
 0x266F,0x666F,0xA66F,0xE66F,0x366F,0x766F,0xB66F,0xF66F,
 0x0A6F,0x4A6F,0x8A6F,0xCA6F,0x1A6F,0x5A6F,0x9A6F,0xDA6F,
 0x2A6F,0x6A6F,0xAA6F,0xEA6F,0x3A6F,0x7A6F,0xBA6F,0xFA6F,
 0x0E6F,0x4E6F,0x8E6F,0xCE6F,0x1E6F,0x5E6F,0x9E6F,0xDE6F,
 0x2E6F,0x6E6F,0xAE6F,0xEE6F,0x3E6F,0x7E6F,0xBE6F,0xFE6F,
 0x036F,0x436F,0x836F,0xC36F,0x136F,0x536F,0x936F,0xD36F,
 0x236F,0x636F,0xA36F,0xE36F,0x336F,0x736F,0xB36F,0xF36F,
 0x076F,0x476F,0x876F,0xC76F,0x176F,0x576F,0x976F,0xD76F,
 0x276F,0x676F,0xA76F,0xE76F,0x376F,0x776F,0xB76F,0xF76F,
 0x0B6F,0x4B6F,0x8B6F,0xCB6F,0x1B6F,0x5B6F,0x9B6F,0xDB6F,
 0x2B6F,0x6B6F,0xAB6F,0xEB6F,0x3B6F,0x7B6F,0xBB6F,0xFB6F,
 0x0F6F,0x4F6F,0x8F6F,0xCF6F,0x1F6F,0x5F6F,0x9F6F,0xDF6F,
 0x2F6F,0x6F6F,0xAF6F,0xEF6F,0x3F6F,0x7F6F,0xBF6F,0xFF6F,
 0x00AF,0x40AF,0x80AF,0xC0AF,0x10AF,0x50AF,0x90AF,0xD0AF,
 0x20AF,0x60AF,0xA0AF,0xE0AF,0x30AF,0x70AF,0xB0AF,0xF0AF,
 0x04AF,0x44AF,0x84AF,0xC4AF,0x14AF,0x54AF,0x94AF,0xD4AF,
 0x24AF,0x64AF,0xA4AF,0xE4AF,0x34AF,0x74AF,0xB4AF,0xF4AF,
 0x08AF,0x48AF,0x88AF,0xC8AF,0x18AF,0x58AF,0x98AF,0xD8AF,
 0x28AF,0x68AF,0xA8AF,0xE8AF,0x38AF,0x78AF,0xB8AF,0xF8AF,
 0x0CAF,0x4CAF,0x8CAF,0xCCAF,0x1CAF,0x5CAF,0x9CAF,0xDCAF,
 0x2CAF,0x6CAF,0xACAF,0xECAF,0x3CAF,0x7CAF,0xBCAF,0xFCAF,
 0x01AF,0x41AF,0x81AF,0xC1AF,0x11AF,0x51AF,0x91AF,0xD1AF,
 0x21AF,0x61AF,0xA1AF,0xE1AF,0x31AF,0x71AF,0xB1AF,0xF1AF,
 0x05AF,0x45AF,0x85AF,0xC5AF,0x15AF,0x55AF,0x95AF,0xD5AF,
 0x25AF,0x65AF,0xA5AF,0xE5AF,0x35AF,0x75AF,0xB5AF,0xF5AF,
 0x09AF,0x49AF,0x89AF,0xC9AF,0x19AF,0x59AF,0x99AF,0xD9AF,
 0x29AF,0x69AF,0xA9AF,0xE9AF,0x39AF,0x79AF,0xB9AF,0xF9AF,
 0x0DAF,0x4DAF,0x8DAF,0xCDAF,0x1DAF,0x5DAF,0x9DAF,0xDDAF,
 0x2DAF,0x6DAF,0xADAF,0xEDAF,0x3DAF,0x7DAF,0xBDAF,0xFDAF,
 0x02AF,0x42AF,0x82AF,0xC2AF,0x12AF,0x52AF,0x92AF,0xD2AF,
 0x22AF,0x62AF,0xA2AF,0xE2AF,0x32AF,0x72AF,0xB2AF,0xF2AF,
 0x06AF,0x46AF,0x86AF,0xC6AF,0x16AF,0x56AF,0x96AF,0xD6AF,
 0x26AF,0x66AF,0xA6AF,0xE6AF,0x36AF,0x76AF,0xB6AF,0xF6AF,
 0x0AAF,0x4AAF,0x8AAF,0xCAAF,0x1AAF,0x5AAF,0x9AAF,0xDAAF,
 0x2AAF,0x6AAF,0xAAAF,0xEAAF,0x3AAF,0x7AAF,0xBAAF,0xFAAF,
 0x0EAF,0x4EAF,0x8EAF,0xCEAF,0x1EAF,0x5EAF,0x9EAF,0xDEAF,
 0x2EAF,0x6EAF,0xAEAF,0xEEAF,0x3EAF,0x7EAF,0xBEAF,0xFEAF,
 0x03AF,0x43AF,0x83AF,0xC3AF,0x13AF,0x53AF,0x93AF,0xD3AF,
 0x23AF,0x63AF,0xA3AF,0xE3AF,0x33AF,0x73AF,0xB3AF,0xF3AF,
 0x07AF,0x47AF,0x87AF,0xC7AF,0x17AF,0x57AF,0x97AF,0xD7AF,
 0x27AF,0x67AF,0xA7AF,0xE7AF,0x37AF,0x77AF,0xB7AF,0xF7AF,
 0x0BAF,0x4BAF,0x8BAF,0xCBAF,0x1BAF,0x5BAF,0x9BAF,0xDBAF,
 0x2BAF,0x6BAF,0xABAF,0xEBAF,0x3BAF,0x7BAF,0xBBAF,0xFBAF,
 0x0FAF,0x4FAF,0x8FAF,0xCFAF,0x1FAF,0x5FAF,0x9FAF,0xDFAF,
 0x2FAF,0x6FAF,0xAFAF,0xEFAF,0x3FAF,0x7FAF,0xBFAF,0xFFAF,
 0x00EF,0x40EF,0x80EF,0xC0EF,0x10EF,0x50EF,0x90EF,0xD0EF,
 0x20EF,0x60EF,0xA0EF,0xE0EF,0x30EF,0x70EF,0xB0EF,0xF0EF,
 0x04EF,0x44EF,0x84EF,0xC4EF,0x14EF,0x54EF,0x94EF,0xD4EF,
 0x24EF,0x64EF,0xA4EF,0xE4EF,0x34EF,0x74EF,0xB4EF,0xF4EF,
 0x08EF,0x48EF,0x88EF,0xC8EF,0x18EF,0x58EF,0x98EF,0xD8EF,
 0x28EF,0x68EF,0xA8EF,0xE8EF,0x38EF,0x78EF,0xB8EF,0xF8EF,
 0x0CEF,0x4CEF,0x8CEF,0xCCEF,0x1CEF,0x5CEF,0x9CEF,0xDCEF,
 0x2CEF,0x6CEF,0xACEF,0xECEF,0x3CEF,0x7CEF,0xBCEF,0xFCEF,
 0x01EF,0x41EF,0x81EF,0xC1EF,0x11EF,0x51EF,0x91EF,0xD1EF,
 0x21EF,0x61EF,0xA1EF,0xE1EF,0x31EF,0x71EF,0xB1EF,0xF1EF,
 0x05EF,0x45EF,0x85EF,0xC5EF,0x15EF,0x55EF,0x95EF,0xD5EF,
 0x25EF,0x65EF,0xA5EF,0xE5EF,0x35EF,0x75EF,0xB5EF,0xF5EF,
 0x09EF,0x49EF,0x89EF,0xC9EF,0x19EF,0x59EF,0x99EF,0xD9EF,
 0x29EF,0x69EF,0xA9EF,0xE9EF,0x39EF,0x79EF,0xB9EF,0xF9EF,
 0x0DEF,0x4DEF,0x8DEF,0xCDEF,0x1DEF,0x5DEF,0x9DEF,0xDDEF,
 0x2DEF,0x6DEF,0xADEF,0xEDEF,0x3DEF,0x7DEF,0xBDEF,0xFDEF,
 0x02EF,0x42EF,0x82EF,0xC2EF,0x12EF,0x52EF,0x92EF,0xD2EF,
 0x22EF,0x62EF,0xA2EF,0xE2EF,0x32EF,0x72EF,0xB2EF,0xF2EF,
 0x06EF,0x46EF,0x86EF,0xC6EF,0x16EF,0x56EF,0x96EF,0xD6EF,
 0x26EF,0x66EF,0xA6EF,0xE6EF,0x36EF,0x76EF,0xB6EF,0xF6EF,
 0x0AEF,0x4AEF,0x8AEF,0xCAEF,0x1AEF,0x5AEF,0x9AEF,0xDAEF,
 0x2AEF,0x6AEF,0xAAEF,0xEAEF,0x3AEF,0x7AEF,0xBAEF,0xFAEF,
 0x0EEF,0x4EEF,0x8EEF,0xCEEF,0x1EEF,0x5EEF,0x9EEF,0xDEEF,
 0x2EEF,0x6EEF,0xAEEF,0xEEEF,0x3EEF,0x7EEF,0xBEEF,0xFEEF,
 0x03EF,0x43EF,0x83EF,0xC3EF,0x13EF,0x53EF,0x93EF,0xD3EF,
 0x23EF,0x63EF,0xA3EF,0xE3EF,0x33EF,0x73EF,0xB3EF,0xF3EF,
 0x07EF,0x47EF,0x87EF,0xC7EF,0x17EF,0x57EF,0x97EF,0xD7EF,
 0x27EF,0x67EF,0xA7EF,0xE7EF,0x37EF,0x77EF,0xB7EF,0xF7EF,
 0x0BEF,0x4BEF,0x8BEF,0xCBEF,0x1BEF,0x5BEF,0x9BEF,0xDBEF,
 0x2BEF,0x6BEF,0xABEF,0xEBEF,0x3BEF,0x7BEF,0xBBEF,0xFBEF,
 0x0FEF,0x4FEF,0x8FEF,0xCFEF,0x1FEF,0x5FEF,0x9FEF,0xDFEF,
 0x2FEF,0x6FEF,0xAFEF,0xEFEF,0x3FEF,0x7FEF,0xBFEF,0xFFEF,
 0x003F,0x403F,0x803F,0xC03F,0x103F,0x503F,0x903F,0xD03F,
 0x203F,0x603F,0xA03F,0xE03F,0x303F,0x703F,0xB03F,0xF03F,
 0x043F,0x443F,0x843F,0xC43F,0x143F,0x543F,0x943F,0xD43F,
 0x243F,0x643F,0xA43F,0xE43F,0x343F,0x743F,0xB43F,0xF43F,
 0x083F,0x483F,0x883F,0xC83F,0x183F,0x583F,0x983F,0xD83F,
 0x283F,0x683F,0xA83F,0xE83F,0x383F,0x783F,0xB83F,0xF83F,
 0x0C3F,0x4C3F,0x8C3F,0xCC3F,0x1C3F,0x5C3F,0x9C3F,0xDC3F,
 0x2C3F,0x6C3F,0xAC3F,0xEC3F,0x3C3F,0x7C3F,0xBC3F,0xFC3F,
 0x013F,0x413F,0x813F,0xC13F,0x113F,0x513F,0x913F,0xD13F,
 0x213F,0x613F,0xA13F,0xE13F,0x313F,0x713F,0xB13F,0xF13F,
 0x053F,0x453F,0x853F,0xC53F,0x153F,0x553F,0x953F,0xD53F,
 0x253F,0x653F,0xA53F,0xE53F,0x353F,0x753F,0xB53F,0xF53F,
 0x093F,0x493F,0x893F,0xC93F,0x193F,0x593F,0x993F,0xD93F,
 0x293F,0x693F,0xA93F,0xE93F,0x393F,0x793F,0xB93F,0xF93F,
 0x0D3F,0x4D3F,0x8D3F,0xCD3F,0x1D3F,0x5D3F,0x9D3F,0xDD3F,
 0x2D3F,0x6D3F,0xAD3F,0xED3F,0x3D3F,0x7D3F,0xBD3F,0xFD3F,
 0x023F,0x423F,0x823F,0xC23F,0x123F,0x523F,0x923F,0xD23F,
 0x223F,0x623F,0xA23F,0xE23F,0x323F,0x723F,0xB23F,0xF23F,
 0x063F,0x463F,0x863F,0xC63F,0x163F,0x563F,0x963F,0xD63F,
 0x263F,0x663F,0xA63F,0xE63F,0x363F,0x763F,0xB63F,0xF63F,
 0x0A3F,0x4A3F,0x8A3F,0xCA3F,0x1A3F,0x5A3F,0x9A3F,0xDA3F,
 0x2A3F,0x6A3F,0xAA3F,0xEA3F,0x3A3F,0x7A3F,0xBA3F,0xFA3F,
 0x0E3F,0x4E3F,0x8E3F,0xCE3F,0x1E3F,0x5E3F,0x9E3F,0xDE3F,
 0x2E3F,0x6E3F,0xAE3F,0xEE3F,0x3E3F,0x7E3F,0xBE3F,0xFE3F,
 0x033F,0x433F,0x833F,0xC33F,0x133F,0x533F,0x933F,0xD33F,
 0x233F,0x633F,0xA33F,0xE33F,0x333F,0x733F,0xB33F,0xF33F,
 0x073F,0x473F,0x873F,0xC73F,0x173F,0x573F,0x973F,0xD73F,
 0x273F,0x673F,0xA73F,0xE73F,0x373F,0x773F,0xB73F,0xF73F,
 0x0B3F,0x4B3F,0x8B3F,0xCB3F,0x1B3F,0x5B3F,0x9B3F,0xDB3F,
 0x2B3F,0x6B3F,0xAB3F,0xEB3F,0x3B3F,0x7B3F,0xBB3F,0xFB3F,
 0x0F3F,0x4F3F,0x8F3F,0xCF3F,0x1F3F,0x5F3F,0x9F3F,0xDF3F,
 0x2F3F,0x6F3F,0xAF3F,0xEF3F,0x3F3F,0x7F3F,0xBF3F,0xFF3F,
 0x007F,0x407F,0x807F,0xC07F,0x107F,0x507F,0x907F,0xD07F,
 0x207F,0x607F,0xA07F,0xE07F,0x307F,0x707F,0xB07F,0xF07F,
 0x047F,0x447F,0x847F,0xC47F,0x147F,0x547F,0x947F,0xD47F,
 0x247F,0x647F,0xA47F,0xE47F,0x347F,0x747F,0xB47F,0xF47F,
 0x087F,0x487F,0x887F,0xC87F,0x187F,0x587F,0x987F,0xD87F,
 0x287F,0x687F,0xA87F,0xE87F,0x387F,0x787F,0xB87F,0xF87F,
 0x0C7F,0x4C7F,0x8C7F,0xCC7F,0x1C7F,0x5C7F,0x9C7F,0xDC7F,
 0x2C7F,0x6C7F,0xAC7F,0xEC7F,0x3C7F,0x7C7F,0xBC7F,0xFC7F,
 0x017F,0x417F,0x817F,0xC17F,0x117F,0x517F,0x917F,0xD17F,
 0x217F,0x617F,0xA17F,0xE17F,0x317F,0x717F,0xB17F,0xF17F,
 0x057F,0x457F,0x857F,0xC57F,0x157F,0x557F,0x957F,0xD57F,
 0x257F,0x657F,0xA57F,0xE57F,0x357F,0x757F,0xB57F,0xF57F,
 0x097F,0x497F,0x897F,0xC97F,0x197F,0x597F,0x997F,0xD97F,
 0x297F,0x697F,0xA97F,0xE97F,0x397F,0x797F,0xB97F,0xF97F,
 0x0D7F,0x4D7F,0x8D7F,0xCD7F,0x1D7F,0x5D7F,0x9D7F,0xDD7F,
 0x2D7F,0x6D7F,0xAD7F,0xED7F,0x3D7F,0x7D7F,0xBD7F,0xFD7F,
 0x027F,0x427F,0x827F,0xC27F,0x127F,0x527F,0x927F,0xD27F,
 0x227F,0x627F,0xA27F,0xE27F,0x327F,0x727F,0xB27F,0xF27F,
 0x067F,0x467F,0x867F,0xC67F,0x167F,0x567F,0x967F,0xD67F,
 0x267F,0x667F,0xA67F,0xE67F,0x367F,0x767F,0xB67F,0xF67F,
 0x0A7F,0x4A7F,0x8A7F,0xCA7F,0x1A7F,0x5A7F,0x9A7F,0xDA7F,
 0x2A7F,0x6A7F,0xAA7F,0xEA7F,0x3A7F,0x7A7F,0xBA7F,0xFA7F,
 0x0E7F,0x4E7F,0x8E7F,0xCE7F,0x1E7F,0x5E7F,0x9E7F,0xDE7F,
 0x2E7F,0x6E7F,0xAE7F,0xEE7F,0x3E7F,0x7E7F,0xBE7F,0xFE7F,
 0x037F,0x437F,0x837F,0xC37F,0x137F,0x537F,0x937F,0xD37F,
 0x237F,0x637F,0xA37F,0xE37F,0x337F,0x737F,0xB37F,0xF37F,
 0x077F,0x477F,0x877F,0xC77F,0x177F,0x577F,0x977F,0xD77F,
 0x277F,0x677F,0xA77F,0xE77F,0x377F,0x777F,0xB77F,0xF77F,
 0x0B7F,0x4B7F,0x8B7F,0xCB7F,0x1B7F,0x5B7F,0x9B7F,0xDB7F,
 0x2B7F,0x6B7F,0xAB7F,0xEB7F,0x3B7F,0x7B7F,0xBB7F,0xFB7F,
 0x0F7F,0x4F7F,0x8F7F,0xCF7F,0x1F7F,0x5F7F,0x9F7F,0xDF7F,
 0x2F7F,0x6F7F,0xAF7F,0xEF7F,0x3F7F,0x7F7F,0xBF7F,0xFF7F,
 0x00BF,0x40BF,0x80BF,0xC0BF,0x10BF,0x50BF,0x90BF,0xD0BF,
 0x20BF,0x60BF,0xA0BF,0xE0BF,0x30BF,0x70BF,0xB0BF,0xF0BF,
 0x04BF,0x44BF,0x84BF,0xC4BF,0x14BF,0x54BF,0x94BF,0xD4BF,
 0x24BF,0x64BF,0xA4BF,0xE4BF,0x34BF,0x74BF,0xB4BF,0xF4BF,
 0x08BF,0x48BF,0x88BF,0xC8BF,0x18BF,0x58BF,0x98BF,0xD8BF,
 0x28BF,0x68BF,0xA8BF,0xE8BF,0x38BF,0x78BF,0xB8BF,0xF8BF,
 0x0CBF,0x4CBF,0x8CBF,0xCCBF,0x1CBF,0x5CBF,0x9CBF,0xDCBF,
 0x2CBF,0x6CBF,0xACBF,0xECBF,0x3CBF,0x7CBF,0xBCBF,0xFCBF,
 0x01BF,0x41BF,0x81BF,0xC1BF,0x11BF,0x51BF,0x91BF,0xD1BF,
 0x21BF,0x61BF,0xA1BF,0xE1BF,0x31BF,0x71BF,0xB1BF,0xF1BF,
 0x05BF,0x45BF,0x85BF,0xC5BF,0x15BF,0x55BF,0x95BF,0xD5BF,
 0x25BF,0x65BF,0xA5BF,0xE5BF,0x35BF,0x75BF,0xB5BF,0xF5BF,
 0x09BF,0x49BF,0x89BF,0xC9BF,0x19BF,0x59BF,0x99BF,0xD9BF,
 0x29BF,0x69BF,0xA9BF,0xE9BF,0x39BF,0x79BF,0xB9BF,0xF9BF,
 0x0DBF,0x4DBF,0x8DBF,0xCDBF,0x1DBF,0x5DBF,0x9DBF,0xDDBF,
 0x2DBF,0x6DBF,0xADBF,0xEDBF,0x3DBF,0x7DBF,0xBDBF,0xFDBF,
 0x02BF,0x42BF,0x82BF,0xC2BF,0x12BF,0x52BF,0x92BF,0xD2BF,
 0x22BF,0x62BF,0xA2BF,0xE2BF,0x32BF,0x72BF,0xB2BF,0xF2BF,
 0x06BF,0x46BF,0x86BF,0xC6BF,0x16BF,0x56BF,0x96BF,0xD6BF,
 0x26BF,0x66BF,0xA6BF,0xE6BF,0x36BF,0x76BF,0xB6BF,0xF6BF,
 0x0ABF,0x4ABF,0x8ABF,0xCABF,0x1ABF,0x5ABF,0x9ABF,0xDABF,
 0x2ABF,0x6ABF,0xAABF,0xEABF,0x3ABF,0x7ABF,0xBABF,0xFABF,
 0x0EBF,0x4EBF,0x8EBF,0xCEBF,0x1EBF,0x5EBF,0x9EBF,0xDEBF,
 0x2EBF,0x6EBF,0xAEBF,0xEEBF,0x3EBF,0x7EBF,0xBEBF,0xFEBF,
 0x03BF,0x43BF,0x83BF,0xC3BF,0x13BF,0x53BF,0x93BF,0xD3BF,
 0x23BF,0x63BF,0xA3BF,0xE3BF,0x33BF,0x73BF,0xB3BF,0xF3BF,
 0x07BF,0x47BF,0x87BF,0xC7BF,0x17BF,0x57BF,0x97BF,0xD7BF,
 0x27BF,0x67BF,0xA7BF,0xE7BF,0x37BF,0x77BF,0xB7BF,0xF7BF,
 0x0BBF,0x4BBF,0x8BBF,0xCBBF,0x1BBF,0x5BBF,0x9BBF,0xDBBF,
 0x2BBF,0x6BBF,0xABBF,0xEBBF,0x3BBF,0x7BBF,0xBBBF,0xFBBF,
 0x0FBF,0x4FBF,0x8FBF,0xCFBF,0x1FBF,0x5FBF,0x9FBF,0xDFBF,
 0x2FBF,0x6FBF,0xAFBF,0xEFBF,0x3FBF,0x7FBF,0xBFBF,0xFFBF,
 0x00FF,0x40FF,0x80FF,0xC0FF,0x10FF,0x50FF,0x90FF,0xD0FF,
 0x20FF,0x60FF,0xA0FF,0xE0FF,0x30FF,0x70FF,0xB0FF,0xF0FF,
 0x04FF,0x44FF,0x84FF,0xC4FF,0x14FF,0x54FF,0x94FF,0xD4FF,
 0x24FF,0x64FF,0xA4FF,0xE4FF,0x34FF,0x74FF,0xB4FF,0xF4FF,
 0x08FF,0x48FF,0x88FF,0xC8FF,0x18FF,0x58FF,0x98FF,0xD8FF,
 0x28FF,0x68FF,0xA8FF,0xE8FF,0x38FF,0x78FF,0xB8FF,0xF8FF,
 0x0CFF,0x4CFF,0x8CFF,0xCCFF,0x1CFF,0x5CFF,0x9CFF,0xDCFF,
 0x2CFF,0x6CFF,0xACFF,0xECFF,0x3CFF,0x7CFF,0xBCFF,0xFCFF,
 0x01FF,0x41FF,0x81FF,0xC1FF,0x11FF,0x51FF,0x91FF,0xD1FF,
 0x21FF,0x61FF,0xA1FF,0xE1FF,0x31FF,0x71FF,0xB1FF,0xF1FF,
 0x05FF,0x45FF,0x85FF,0xC5FF,0x15FF,0x55FF,0x95FF,0xD5FF,
 0x25FF,0x65FF,0xA5FF,0xE5FF,0x35FF,0x75FF,0xB5FF,0xF5FF,
 0x09FF,0x49FF,0x89FF,0xC9FF,0x19FF,0x59FF,0x99FF,0xD9FF,
 0x29FF,0x69FF,0xA9FF,0xE9FF,0x39FF,0x79FF,0xB9FF,0xF9FF,
 0x0DFF,0x4DFF,0x8DFF,0xCDFF,0x1DFF,0x5DFF,0x9DFF,0xDDFF,
 0x2DFF,0x6DFF,0xADFF,0xEDFF,0x3DFF,0x7DFF,0xBDFF,0xFDFF,
 0x02FF,0x42FF,0x82FF,0xC2FF,0x12FF,0x52FF,0x92FF,0xD2FF,
 0x22FF,0x62FF,0xA2FF,0xE2FF,0x32FF,0x72FF,0xB2FF,0xF2FF,
 0x06FF,0x46FF,0x86FF,0xC6FF,0x16FF,0x56FF,0x96FF,0xD6FF,
 0x26FF,0x66FF,0xA6FF,0xE6FF,0x36FF,0x76FF,0xB6FF,0xF6FF,
 0x0AFF,0x4AFF,0x8AFF,0xCAFF,0x1AFF,0x5AFF,0x9AFF,0xDAFF,
 0x2AFF,0x6AFF,0xAAFF,0xEAFF,0x3AFF,0x7AFF,0xBAFF,0xFAFF,
 0x0EFF,0x4EFF,0x8EFF,0xCEFF,0x1EFF,0x5EFF,0x9EFF,0xDEFF,
 0x2EFF,0x6EFF,0xAEFF,0xEEFF,0x3EFF,0x7EFF,0xBEFF,0xFEFF,
 0x03FF,0x43FF,0x83FF,0xC3FF,0x13FF,0x53FF,0x93FF,0xD3FF,
 0x23FF,0x63FF,0xA3FF,0xE3FF,0x33FF,0x73FF,0xB3FF,0xF3FF,
 0x07FF,0x47FF,0x87FF,0xC7FF,0x17FF,0x57FF,0x97FF,0xD7FF,
 0x27FF,0x67FF,0xA7FF,0xE7FF,0x37FF,0x77FF,0xB7FF,0xF7FF,
 0x0BFF,0x4BFF,0x8BFF,0xCBFF,0x1BFF,0x5BFF,0x9BFF,0xDBFF,
 0x2BFF,0x6BFF,0xABFF,0xEBFF,0x3BFF,0x7BFF,0xBBFF,0xFBFF,
 0x0FFF,0x4FFF,0x8FFF,0xCFFF,0x1FFF,0x5FFF,0x9FFF,0xDFFF,
 0x2FFF,0x6FFF,0xAFFF,0xEFFF,0x3FFF,0x7FFF,0xBFFF,0xFFFF,
};
#endif



/* Code starts here */

/* Shortoligmer_T is a short oligomer, representing 3 amino acids, or
   9 nt, requiring 18 bits or 2.25 bytes */

#define STRAIGHT_MASK_2  0x0000000F /* 2-mer: 1111 */
#define STRAIGHT_MASK_3  0x0000003F /* 3-mer: 11 1111 */
#define STRAIGHT_MASK_4  0x000000FF /* 4-mer: 1111 1111 */
#define STRAIGHT_MASK_5  0x000003FF /* 5-mer: 11 1111 1111 */
#define STRAIGHT_MASK_6  0x00000FFF /* 6-mer: 1111 1111 1111 */
#define STRAIGHT_MASK_7  0x00003FFF /* 7-mer: 11 1111 1111 1111 */
#define STRAIGHT_MASK_8  0x0000FFFF /* 8-mer: 1111 1111 1111 1111 */
#define STRAIGHT_MASK_9  0x0003FFFF /* 9-mer: 11 1111 1111 1111 1111 */
#define STRAIGHT_MASK_10 0x000FFFFF /* 10-mer: 1111 1111 1111 1111 1111 */
#define STRAIGHT_MASK_11 0x003FFFFF /* 11-mer: 11 1111 1111 1111 1111 1111 */

#define WOBBLE_MASK_2  0x0000000F /* 2-mer: 1111 */
#define WOBBLE_MASK_3  0x0000003C /* 3-mer: 11 1100 */
#define WOBBLE_MASK_4  0x000000F3 /* 4-mer: 1111 0011 */
#define WOBBLE_MASK_5  0x000003CF /* 5-mer: 11 1100 1111 */
#define WOBBLE_MASK_6  0x00000F3C /* 6-mer: 1111 0011 1100 */
#define WOBBLE_MASK_7  0x00003CF3 /* 7-mer: 11 1100 1111 0011 */
#define WOBBLE_MASK_8  0x0000F3CF /* 8-mer: 1111 0011 1100 1111 */
#define WOBBLE_MASK_9  0x0003CF3C /* 9-mer: 11 1100 1111 0011 1100 */
#define WOBBLE_MASK_10 0x000F3CF3 /* 10-mer: 1111 0011 1100 1111 0011 */
#define WOBBLE_MASK_11 0x003CF3CF /* 11-mer: 11 1100 1111 0011 1100 1111 */


#if defined(GSNAP)

/* Previously, set to 8 for localdb, but no longer using localdb for Oligoindex_hr_tally */
#define NOLIGOINDICES_MAJOR 1
static int indexsizes_major[NOLIGOINDICES_MAJOR] = {9};
static Shortoligomer_T masks_major[NOLIGOINDICES_MAJOR] = {STRAIGHT_MASK_9};
static int diag_lookbacks_major[NOLIGOINDICES_MAJOR] = {120};
static int suffnconsecutives_major[NOLIGOINDICES_MAJOR] = {20};

#define NOLIGOINDICES_MINOR 1
static int indexsizes_minor[NOLIGOINDICES_MINOR] = {9};
static Shortoligomer_T masks_minor[NOLIGOINDICES_MINOR] = {STRAIGHT_MASK_9};
static int diag_lookbacks_minor[NOLIGOINDICES_MINOR] = {60};
static int suffnconsecutives_minor[NOLIGOINDICES_MINOR] = {10};

#elif 0
/* Version from 2018-03-25, but has decreased sensitivity at ends for GMAP */

#define NOLIGOINDICES_MAJOR 3
static int indexsizes_major[NOLIGOINDICES_MAJOR] = {9, 8, 7};
static Shortoligomer_T masks_major[NOLIGOINDICES_MAJOR] = {STRAIGHT_MASK_9, STRAIGHT_MASK_8, STRAIGHT_MASK_7};
static int diag_lookbacks_major[NOLIGOINDICES_MAJOR] = {120, 60, 30};
static int suffnconsecutives_major[NOLIGOINDICES_MAJOR] = {10, 10, 10};
/* previously was 20, 15, 10, but with limit of 256 hits, need to be equal */

#define NOLIGOINDICES_MINOR 3
static int indexsizes_minor[NOLIGOINDICES_MINOR] = {8, 7, 6};
static Shortoligomer_T masks_minor[NOLIGOINDICES_MINOR] = {STRAIGHT_MASK_8, STRAIGHT_MASK_7, STRAIGHT_MASK_6};
static int diag_lookbacks_minor[NOLIGOINDICES_MINOR] = {120, 60, 30};
static int suffnconsecutives_minor[NOLIGOINDICES_MINOR] = {10, 10, 10};
/* previously was 20, 15, 10, but with limit of 256 hits, need to be equal */

#else

/* For localdb of indexsize 8 */
#define NOLIGOINDICES_MAJOR 1
static int indexsizes_major[NOLIGOINDICES_MAJOR] = {8};
static Shortoligomer_T masks_major[NOLIGOINDICES_MAJOR] = {STRAIGHT_MASK_8};
static int diag_lookbacks_major[NOLIGOINDICES_MAJOR] = {120};
static int suffnconsecutives_major[NOLIGOINDICES_MAJOR] = {20};

#define NOLIGOINDICES_MINOR 1
static int indexsizes_minor[NOLIGOINDICES_MINOR] = {8};
static Shortoligomer_T masks_minor[NOLIGOINDICES_MINOR] = {STRAIGHT_MASK_8};
static int diag_lookbacks_minor[NOLIGOINDICES_MINOR] = {60};
static int suffnconsecutives_minor[NOLIGOINDICES_MINOR] = {10};

#endif


#define MASK9 0x0003FFFF
#define MASK8 0x0000FFFF
#define MASK7 0x00003FFF
#define MASK6 0x00000FFF
#define MASK5 0x000003FF

static Mode_T mode;

#ifdef HAVE_SSE2
static __m128i mask9;
static __m128i mask8;
static __m128i mask7;
static __m128i mask6;
static __m128i mask5;
#endif

#ifdef HAVE_SSE4_1
static __m128i mask7_epi16;
static __m128i mask6_epi16;
static __m128i mask5_epi16;
#endif

#if defined(HAVE_AVX2)
static __m256i bigshift0to14;
static __m256i bigmask9;
static __m256i bigmask8;
static __m256i bigmask7;
static __m256i bigmask6;
static __m256i bigmask5;
static __m256i bigmask7_epi16;
static __m256i bigmask6_epi16;
static __m256i bigmask5_epi16;
#endif

#ifdef HAVE_AVX512
static __m512i hugeshift0to14;
static __m512i hugemask9;
static __m512i hugemask8;
static __m512i hugemask7;
static __m512i hugemask6;
static __m512i hugemask5;
static __m512i highmask8;
static __m512i highmask7;
static __m512i highmask6;
static __m512i highmask5;

#endif



void
Oligoindex_hr_setup (Mode_T mode_in) {
  mode = mode_in;

#ifdef HAVE_SSE2
  mask9 = _mm_set1_epi32(262143U);
  mask8 = _mm_set1_epi32(65535U);
  mask7 = _mm_set1_epi32(16383U);
  mask6 = _mm_set1_epi32(4095U);
  mask5 = _mm_set1_epi32(1023U);
#endif

#ifdef HAVE_SSE4_1
  mask7_epi16 = _mm_set1_epi16(16383U);
  mask6_epi16 = _mm_set1_epi16(4095U);
  mask5_epi16 = _mm_set1_epi16(1023U);
#endif

#if defined(HAVE_AVX2)
  bigshift0to14 = _mm256_setr_epi32(0,2,4,6,8,10,12,14);
  bigmask9 = _mm256_set1_epi32(262143U);
  bigmask8 = _mm256_set1_epi32(65535U);
  bigmask7 = _mm256_set1_epi32(16383U);
  bigmask6 = _mm256_set1_epi32(4095U);
  bigmask5 = _mm256_set1_epi32(1023U);
  bigmask7_epi16 = _mm256_set1_epi16(16383U);
  bigmask6_epi16 = _mm256_set1_epi16(4095U);
  bigmask5_epi16 = _mm256_set1_epi16(1023U);
#endif

#ifdef HAVE_AVX512
  hugeshift0to14 = _mm512_setr_epi32(0,2,4,6,8,10,12,14, 0,2,4,6,8,10,12,14);
  hugemask9 = _mm512_set1_epi32(262143U);
  hugemask8 = _mm512_set1_epi32(65535U); /* 0x0000FFFF */
  hugemask7 = _mm512_set1_epi32(16383U); /* 0x00003FFF */
  hugemask6 = _mm512_set1_epi32(4095U);	 /* 0x00000FFF */
  hugemask5 = _mm512_set1_epi32(1023U);	 /* 0x000003FF */
  highmask8 = _mm512_set1_epi32(0xFFFF0000);
  highmask7 = _mm512_set1_epi32(0x3FFF0000);
  highmask6 = _mm512_set1_epi32(0x0FFF0000);
  highmask5 = _mm512_set1_epi32(0x03FF0000);
#endif

  return;
}


int
Oligoindex_indexsize (T this) {
  return this->indexsize;
}


static int
power (int base, int exponent) {
  int result = 1, i;

  for (i = 0; i < exponent; i++) {
    result *= base;
  }
  return result;
}


static T
Oligoindex_new (int indexsize, int diag_lookback, int suffnconsecutive, Shortoligomer_T mask) {
  T new = (T) MALLOC_KEEP(sizeof(*new));

  new->indexsize = indexsize;
  new->mask = mask;
  new->oligospace = power(4,indexsize);

  new->diag_lookback = diag_lookback;
  new->suffnconsecutive = suffnconsecutive;

  /* new->query_evaluated_p = false; */
#if defined(HAVE_AVX512)
  new->inquery_allocated = (__m512i *) _mm_malloc(new->oligospace * sizeof(Inquery_T),64);
  new->counts_allocated = (__m512i *) _mm_malloc(new->oligospace * sizeof(Count_T),64);
  assert((long) new->inquery_allocated % 64 == 0);
  assert((long) new->counts_allocated % 64 == 0);
  new->inquery = (Inquery_T *) new->inquery_allocated;
  new->counts = (Count_T *) new->counts_allocated;
#elif defined(HAVE_AVX2)
  new->inquery_allocated = (__m256i *) _mm_malloc(new->oligospace * sizeof(Inquery_T),32);
  new->counts_allocated = (__m256i *) _mm_malloc(new->oligospace * sizeof(Count_T),32);
  assert((long) new->inquery_allocated % 32 == 0);
  assert((long) new->counts_allocated % 32 == 0);
  new->inquery = (Inquery_T *) new->inquery_allocated;
  new->counts = (Count_T *) new->counts_allocated;
#elif defined(HAVE_SSE2)
  new->inquery_allocated = (__m128i *) _mm_malloc(new->oligospace * sizeof(Inquery_T),16);
  new->counts_allocated = (__m128i *) _mm_malloc(new->oligospace * sizeof(Count_T),16);
  assert((long) new->inquery_allocated % 16 == 0);
  assert((long) new->counts_allocated % 16 == 0);
  new->inquery = (Inquery_T *) new->inquery_allocated;
  new->counts = (Count_T *) new->counts_allocated;
#else
  new->inquery = (Inquery_T *) CALLOC_KEEP(new->oligospace,sizeof(Inquery_T));
  new->counts = (Count_T *) CALLOC_KEEP(new->oligospace,sizeof(Count_T));
#endif

  memset((void *) new->inquery,INQUERY_FALSE,new->oligospace*sizeof(Inquery_T));
  memset((void *) new->counts,0,new->oligospace*sizeof(Count_T));

  /* new->pointers_allocated = (UINT4 *) MALLOC((new->oligospace+1) * sizeof(UINT4)); */
  /* new->pointers = &(new->pointers_allocated[1]); */
  new->positions = (UINT4 *) MALLOC_KEEP(new->oligospace * sizeof(UINT4));
  new->table = (Chrpos_T *) NULL;

  return new;
}


int
Oligoindex_array_length (Oligoindex_array_T oligoindices) {
  return oligoindices->length;
}

T
Oligoindex_array_elt (Oligoindex_array_T oligoindices, int source) {
  return oligoindices->array[source];
}


Oligoindex_array_T
Oligoindex_array_new_major (int max_querylength, int max_genomiclength) {
  Oligoindex_array_T new = (Oligoindex_array_T) MALLOC_KEEP(sizeof(*new));
  int source;
  int max_indexsize = 0;

  new->length = NOLIGOINDICES_MAJOR;
  new->array = (T *) CALLOC_KEEP(NOLIGOINDICES_MAJOR,sizeof(T));
  for (source = 0; source < NOLIGOINDICES_MAJOR; source++) {
    new->array[source] = Oligoindex_new(indexsizes_major[source],diag_lookbacks_major[source],
					suffnconsecutives_major[source],
					masks_major[source]);
    if (indexsizes_major[source] > max_indexsize) {
      max_indexsize = indexsizes_major[source];
    }
  }
  
  /* Allocate storage space for Oligoindex_get_mappings */
  new->max_querylength = max_querylength;
  new->max_genomiclength = max_genomiclength;
  new->genomicdiag_init_p = (bool *) MALLOC_KEEP((max_querylength+max_genomiclength+1) * sizeof(bool));
  new->genomicdiag = (struct Genomicdiag_T *) MALLOC_KEEP((max_querylength+max_genomiclength+1) * sizeof(struct Genomicdiag_T));
  new->cum_nohits_allocated = (int *) MALLOC_KEEP((max_querylength+max_indexsize+1) * sizeof(int));

  return new;
}

Oligoindex_array_T
Oligoindex_array_new_minor (int max_querylength, int max_genomiclength) {
  Oligoindex_array_T new = (Oligoindex_array_T) MALLOC_KEEP(sizeof(*new));
  int source;
  int max_indexsize = 0;

  new->length = NOLIGOINDICES_MINOR;
  new->array = (T *) CALLOC_KEEP(NOLIGOINDICES_MINOR,sizeof(T));
  for (source = 0; source < NOLIGOINDICES_MINOR; source++) {
    new->array[source] = Oligoindex_new(indexsizes_minor[source],diag_lookbacks_minor[source],
					suffnconsecutives_minor[source],
					masks_minor[source]);
    if (indexsizes_minor[source] > max_indexsize) {
      max_indexsize = indexsizes_minor[source];
    }
  }
  
  /* Allocate storage space for Oligoindex_get_mappings */
  new->max_querylength = max_querylength;
  new->max_genomiclength = max_genomiclength;
  new->genomicdiag_init_p = (bool *) MALLOC_KEEP((max_querylength+max_genomiclength+1) * sizeof(bool));
  new->genomicdiag = (struct Genomicdiag_T *) MALLOC_KEEP((max_querylength+max_genomiclength+1) * sizeof(struct Genomicdiag_T));
  new->cum_nohits_allocated = (int *) MALLOC_KEEP((max_querylength+max_indexsize+1) * sizeof(int));

  return new;
}


#if 0
/* For debugging */
static void
write_chars (Genomecomp_T high, Genomecomp_T low, Genomecomp_T flags) {
  char Buffer[33];
  int i;

  Buffer[32] = '\0';
  /* printf("%08X %08X %08X => ",high,low,flags); */
  for (i = 0; i < 16; i++) {
    switch (low & 3U) {
    case 0U: Buffer[i] = 'A'; break;
    case 1U: Buffer[i] = 'C'; break;
    case 2U: Buffer[i] = 'G'; break;
    case 3U: Buffer[i] = 'T'; break;
    default: abort();
    }
    low >>= 2;
  }
  for ( ; i < 32; i++) {
    switch (high & 3U) {
    case 0U: Buffer[i] = 'A'; break;
    case 1U: Buffer[i] = 'C'; break;
    case 2U: Buffer[i] = 'G'; break;
    case 3U: Buffer[i] = 'T'; break;
    default: abort();
    }
    high >>= 2;
  }
  for (i = 0; i < 32; i++) {
    if ((flags & 1U) == 1U) {
      Buffer[i] = 'N';
    }
    flags >>= 1;
  }

  printf("%s",Buffer);
  return;
}


static void
Genome_print_blocks (Genomecomp_T *blocks, Univcoord_T startpos, Univcoord_T endpos) {
  /* Chrpos_T length = endpos - startpos; */
  Univcoord_T startblock, endblock, ptr;
  int startdiscard, enddiscard;
  Genomecomp_T high, low, flags;

  /* sequence = (char *) CALLOC(length+1,sizeof(char)); */

  ptr = startblock = startpos/32U*3;
  endblock = endpos/32U*3;
  startdiscard = startpos % 32;
  enddiscard = endpos % 32;
  
  for (ptr = startblock ; ptr <= endblock; ptr += 3) {
#ifdef WORDS_BIGENDIAN
    high = Bigendian_convert_uint(blocks[ptr]);
    low = Bigendian_convert_uint(blocks[ptr+1]);
    flags = Bigendian_convert_uint(blocks[ptr+2]);
#else
    high = blocks[ptr]; low = blocks[ptr+1]; flags = blocks[ptr+2];
#endif
    printf("high: %08X  low: %08X  flags: %08X\t",high,low,flags);
    write_chars(high,low,flags);
    printf("\n");
  }

  return;
}
#endif


/*                      87654321 */
#define LOW_TWO_BITS  0x00000003

#if defined(DEBUG) || defined(DEBUG9)
static char *
shortoligo_nt (Shortoligomer_T oligo, int oligosize) {
  char *nt;
  int i, j;
  Shortoligomer_T lowbits;

  nt = (char *) CALLOC(oligosize+1,sizeof(char));
  j = oligosize-1;
  for (i = 0; i < oligosize; i++) {
    lowbits = oligo & LOW_TWO_BITS;
    switch (lowbits) {
    case RIGHT_A: nt[j] = 'A'; break;
    case RIGHT_C: nt[j] = 'C'; break;
    case RIGHT_G: nt[j] = 'G'; break;
    case RIGHT_T: nt[j] = 'T'; break;
    }
    oligo >>= 2;
    j--;
  }

  return nt;
}
#endif

#ifdef DEBUG
static void
dump_allocations (Chrpos_T **positions, Count_T *counts, int oligospace, int indexsize,
		  Chrpos_T *positions_space) {
  int i;
  char *nt;
  Chrpos_T *lastptr = positions_space;

  printf("Entered dump_allocations with oligospace %d\n",oligospace);

  for (i = 0; i < oligospace; i++) {
    nt = shortoligo_nt(i,indexsize);
    if (counts[i] == 0) {
      printf("Oligo_hr %s (%llu) => %u entries\n",
	     nt,(unsigned long long) i,counts[i]);
    } else {
      printf("Oligo_hr %s (%llu) => %u entries: allocation %p (%lu entries)\n",
	     nt,(unsigned long long) i,counts[i],positions[i],positions[i] - lastptr);
      lastptr = positions[i];
    }
    FREE(nt);
  }

  return;
}
#endif

#if defined(DEBUG) || defined(DEBUG9)
static void
dump_positions (Chrpos_T *table, UINT4 *positions, Count_T *counts, Inquery_T *inquery, int oligospace, int indexsize) {
  int i;
  char *nt;

  printf("Entered dump_positions new with oligospace %d\n",oligospace);

  for (i = 0; i < oligospace; i++) {
    if (inquery[i] == INQUERY_TRUE) {
      nt = shortoligo_nt(i,indexsize);
      if (counts[i] == 0) {
	printf("Oligo_hr %s => 0 entries\n",nt);
      } else {
	printf("Oligo_hr %s => %d entries: %u...%u\n",
	       nt,counts[i],table[positions[i]],table[positions[i]+counts[i]-1]);
      }
      FREE(nt);
    }
  }

  return;
}
#endif


/************************************************************************
 *   Counting and storage procedures.  We count the number of
 *   occurrences of each oligomer in the genomic region, modulo 256
 *   (because Count_T is an unsigned char).  The allocate_positions
 *   procedure then sets counts to 0 when oligomers are not in the
 *   query sequence, and then assigns positions based on the counts.
 *   During storage, we decrement count and store at positions +
 *   count, which could lead to cycling if the count overflowed.
 ************************************************************************/

/************************************************************************
 *   Use SIMD to process 256 k-mers at a time:
 *      extract_*mers_{fwd|rev}_simd_256 (AVX512)
 *      extract_*mers_{fwd|rev}_simd_256_ordered (AVX512)
 *
 *   Use SIMD to process 128 k-mers at a time:
 *      extract_*mers_{fwd|rev}_simd_128 (AVX2)
 *      extract_*mers_{fwd|rev}_simd_128_ordered (AVX2)
 *
 *   Use SIMD to process 64 k-mers at a time:
 *      extract_*mers_{fwd|rev}_simd_64 (SSE2)
 *      extract_*mers_{fwd|rev}_simd_64_ordered (SSE2 for 9mers, SSE4.1 for 8mers and smaller)
 *
 *      count_fwdrev_simd_n
 *
 *      store_fwdrev_simd_256 (AVX512)
 *      store_fwdrev_simd_128
 *      store_fwdrev_simd_64
 *
 *      store_fwdrev_simd_256_ordered
 *      store_fwdrev_simd_128_ordered
 *      store_fwdrev_simd_64_ordered (AVX2)
 *
 *   Use a special procedure to compute an odd block of 32 k-mers
 *      count_*mers_{fwd|rev}_32
 *      This procedure can use SIMD if we compute backwards
 *
 *   Use a serial procedure to compute the start and end blocks (< 32)
 *      count_*mers_{fwd|rev}_partial
 ************************************************************************/


/************************************************************************
 *   FWD
 ************************************************************************/

static void
count_9mers_fwd_partial (Count_T *counts, Genomecomp_T high_rev, Genomecomp_T low_rev,
			 Genomecomp_T nexthigh_rev, int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = enddiscard;

  while (pos >= startdiscard && pos >= 24) {
    masked = nexthigh_rev >> ((96 - 2*9) - 2*pos);
    masked |= low_rev << (2*pos - (64 - 2*9));
    masked &= MASK9;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial Counting masked %04X (%u) => %d\n",pos,masked,masked,counts[masked]));
    pos--;
  }

  while (pos >= startdiscard && pos >= 16) {
    masked = low_rev >> ((64 - 2*9) - 2*pos);
    masked &= MASK9;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial Counting masked %04X (%u) => %d\n",pos,masked,masked,counts[masked]));
    pos--;
  }

  while (pos >= startdiscard && pos >= 8) {
    masked = low_rev >> ((64 - 2*9) - 2*pos);
    masked |= high_rev << (2*pos - (32 - 2*9));
    masked &= MASK9;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial Counting masked %04X (%u) => %d\n",pos,masked,masked,counts[masked]));
    pos--;
  }

  while (pos >= startdiscard) {
    masked = high_rev >> ((32 - 2*9) - 2*pos);
    masked &= MASK9;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial Counting masked %04X (%u) => %d\n",pos,masked,masked,counts[masked]));
    pos--;
  }

  return;
}

static int
store_9mers_fwd_partial (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev,
			 int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = enddiscard;

  while (pos >= startdiscard && pos >= 24) {
    masked = nexthigh_rev >> ((96 - 2*9) - 2*pos);
    masked |= low_rev << (2*pos - (64 - 2*9));
    masked &= MASK9;
    if (counts[masked]) {
      debug(printf("Storing masked %04X (%u) at %u (partial)\n",masked,masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }

  while (pos >= startdiscard && pos >= 16) {
    masked = low_rev >> ((64 - 2*9) - 2*pos);
    masked &= MASK9;
    if (counts[masked]) {
      debug(printf("Storing masked %04X (%u) at %u (partial)\n",masked,masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }
    
  while (pos >= startdiscard && pos >= 8) {
    masked = low_rev >> ((64 - 2*9) - 2*pos);
    masked |= high_rev << (2*pos - (32 - 2*9));
    masked &= MASK9;
    if (counts[masked]) {
      debug(printf("Storing masked %04X (%u) at %u (partial)\n",masked,masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }

  while (pos >= startdiscard) {
    masked = high_rev >> ((32 - 2*9) - 2*pos);
    masked &= MASK9;
    if (counts[masked]) {
      debug(printf("Storing masked %04X (%u) at %u (partial)\n",masked,masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }

  return chrpos;
}


static void
count_8mers_fwd_partial (Count_T *counts, Genomecomp_T high_rev, Genomecomp_T low_rev,
			 Genomecomp_T nexthigh_rev, int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = enddiscard;

  while (pos >= startdiscard && pos >= 25) {
    masked = nexthigh_rev >> ((96 - 2*8) - 2*pos);
    masked |= low_rev << (2*pos - (64 - 2*8));
    masked &= MASK8;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial Counting masked %04X (%u) => %d\n",pos,masked,masked,counts[masked]));
    pos--;
  }

  while (pos >= startdiscard && pos >= 16) {
    masked = low_rev >> ((64 - 2*8) - 2*pos);
    masked &= MASK8;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial Counting masked %04X (%u) => %d\n",pos,masked,masked,counts[masked]));
    pos--;
  }

  while (pos >= startdiscard && pos >= 9) {
    masked = low_rev >> ((64 - 2*8) - 2*pos);
    masked |= high_rev << (2*pos - (32 - 2*8));
    masked &= MASK8;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial Counting masked %04X (%u) => %d\n",pos,masked,masked,counts[masked]));
    pos--;
  }

  while (pos >= startdiscard) {
    masked = high_rev >> ((32 - 2*8) - 2*pos);
    masked &= MASK8;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial Counting masked %04X (%u) => %d\n",pos,masked,masked,counts[masked]));
    pos--;
  }

  return;
}

static int
store_8mers_fwd_partial (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev,
			 int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = enddiscard;

  while (pos >= startdiscard && pos >= 25) {
    masked = nexthigh_rev >> ((96 - 2*8) - 2*pos);
    masked |= low_rev << (2*pos - (64 - 2*8));
    masked &= MASK8;
     if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }

  while (pos >= startdiscard && pos >= 16) {
    masked = low_rev >> ((64 - 2*8) - 2*pos);
    masked &= MASK8;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }
    
  while (pos >= startdiscard && pos >= 9) {
    masked = low_rev >> ((64 - 2*8) - 2*pos);
    masked |= high_rev << (2*pos - (32 - 2*8));
    masked &= MASK8;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }

  while (pos >= startdiscard) {
    masked = high_rev >> ((32 - 2*8) - 2*pos);
    masked &= MASK8;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }

  return chrpos;
}


static void
count_7mers_fwd_partial (Count_T *counts, Genomecomp_T high_rev, Genomecomp_T low_rev,
			 Genomecomp_T nexthigh_rev, int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = enddiscard;

  while (pos >= startdiscard && pos >= 26) {
    masked = nexthigh_rev >> ((96 - 2*7) - 2*pos);
    masked |= low_rev << (2*pos - (64 - 2*7));
    masked &= MASK7;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos--;
  }

  while (pos >= startdiscard && pos >= 16) {
    masked = low_rev >> ((64 - 2*7) - 2*pos);
    masked &= MASK7;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos--;
  }

  while (pos >= startdiscard && pos >= 10) {
    masked = low_rev >> ((64 - 2*7) - 2*pos);
    masked |= high_rev << (2*pos - (32 - 2*7));
    masked &= MASK7;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos--;
  }

  while (pos >= startdiscard) {
    masked = high_rev >> ((32 - 2*7) - 2*pos);
    masked &= MASK7;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos--;
  }
    
  return;
}

static int
store_7mers_fwd_partial (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev,
			 int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = enddiscard;

  while (pos >= startdiscard && pos >= 26) {
    masked = nexthigh_rev >> ((96 - 2*7) - 2*pos);
    masked |= low_rev << (2*pos - (64 - 2*7));
    masked &= MASK7;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }

  while (pos >= startdiscard && pos >= 16) {
    masked = low_rev >> ((64 - 2*7) - 2*pos);
    masked &= MASK7;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }
    
  while (pos >= startdiscard && pos >= 10) {
    masked = low_rev >> ((64 - 2*7) - 2*pos);
    masked |= high_rev << (2*pos - (32 - 2*7));
    masked &= MASK7;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }

  while (pos >= startdiscard) {
    masked = high_rev >> ((32 - 2*7) - 2*pos);
    masked &= MASK7;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }

  return chrpos;
}


static void
count_6mers_fwd_partial (Count_T *counts, Genomecomp_T high_rev, Genomecomp_T low_rev,
			 Genomecomp_T nexthigh_rev, int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = enddiscard;

  while (pos >= startdiscard && pos >= 27) {
    masked = nexthigh_rev >> ((96 - 2*6) - 2*pos);
    masked |= low_rev << (2*pos - (64 - 2*6));
    masked &= MASK6;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos--;
  }

  while (pos >= startdiscard && pos >= 16) {
    masked = low_rev >> ((64 - 2*6) - 2*pos);
    masked &= MASK6;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos--;
  }
    
  while (pos >= startdiscard && pos >= 11) {
    masked = low_rev >> ((64 - 2*6) - 2*pos);
    masked |= high_rev << (2*pos - (32 - 2*6));
    masked &= MASK6;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos--;
  }

  while (pos >= startdiscard) {
    masked = high_rev >> ((32 - 2*6) - 2*pos);
    masked &= MASK6;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos--;
  }

  return;
}

static int
store_6mers_fwd_partial (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev,
			 int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = enddiscard;

  while (pos >= startdiscard && pos >= 27) {
    masked = nexthigh_rev >> ((96 - 2*6) - 2*pos);
    masked |= low_rev << (2*pos - (64 - 2*6));
    masked &= MASK6;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }

  while (pos >= startdiscard && pos >= 16) {
    masked = low_rev >> ((64 - 2*6) - 2*pos);
    masked &= MASK6;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }
    
  while (pos >= startdiscard && pos >= 11) {
    masked = low_rev >> ((64 - 2*6) - 2*pos);
    masked |= high_rev << (2*pos - (32 - 2*6));
    masked &= MASK6;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }

  while (pos >= startdiscard) {
    masked = high_rev >> ((32 - 2*6) - 2*pos);
    masked &= MASK6;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }

  return chrpos;
}


static void
count_5mers_fwd_partial (Count_T *counts, Genomecomp_T high_rev, Genomecomp_T low_rev,
			 Genomecomp_T nexthigh_rev, int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = enddiscard;

  while (pos >= startdiscard && pos >= 28) {
    masked = nexthigh_rev >> ((96 - 2*5) - 2*pos);
    masked |= low_rev << (2*pos - (64 - 2*5));
    masked &= MASK5;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos--;
  }

  while (pos >= startdiscard && pos >= 16) {
    masked = low_rev >> ((64 - 2*5) - 2*pos);
    masked &= MASK5;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos--;
  }
    
  while (pos >= startdiscard && pos >= 12) {
    masked = low_rev >> ((64 - 2*5) - 2*pos);
    masked |= high_rev << (2*pos - (32 - 2*5));
    masked &= MASK5;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos--;
  }

  while (pos >= startdiscard) {
    masked = high_rev >> ((32 - 2*5) - 2*pos);
    masked &= MASK5;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos--;
  }

  return;
}

static int
store_5mers_fwd_partial (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev,
			 int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = enddiscard;

  while (pos >= startdiscard && pos >= 28) {
    masked = nexthigh_rev >> ((96 - 2*5) - 2*pos);
    masked |= low_rev << (2*pos - (64- 2*5));
    masked &= MASK5;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }

  while (pos >= startdiscard && pos >= 48) {
    masked = low_rev >> ((64 - 2*5) - 2*pos);
    masked &= MASK5;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }
    
  while (pos >= startdiscard && pos >= 12) {
    masked = low_rev >> ((64 - 2*5) - 2*pos);
    masked |= high_rev << (2*pos - (32 - 2*5));
    masked &= MASK5;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }

  while (pos >= startdiscard) {
    masked = high_rev >> ((32 - 2*5) - 2*pos);
    masked &= MASK5;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos--;
  }

  return chrpos;
}


#if 0
  /* Replaced by individual count_*mer_{fwd|rev}_simd procedures */
  /* array is filled by extract_*mers_{fwd|rev}_simd */
  /* Fwd and rev procedures differ only in the order of indices */
static void
count_fwdrev_simd (Count_T *counts, UINT4 *array) {
  UINT4 *ptr;

  /* Fwd: Starts with 0 because we used _setr_ and not _set_ */
  /* Rev: Starts with 63 because we used _set_ and not _setr_ */
  ptr = &(array[0]);
  debug(printf("Fwd:  0 %04X, 16 %04X, 32 %04X, 48 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 63 %04X, 47 %04X, 31 %04X, 15 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1;	/* 0 */ /* 63 */
  counts[*ptr++] += 1;  /* 16 */ /* 47 */
  counts[*ptr++] += 1; 	/* 32 */ /* 31 */
  counts[*ptr++] += 1; 	/* 48 */ /* 15 */

  debug(printf("Fwd:  1 %04X, 17 %04X, 33 %04X, 49 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 62 %04X, 46 %04X, 30 %04X, 14 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1; 	/* 1 */ /* 62 */
  counts[*ptr++] += 1; 	/* 17 */ /* 46 */
  counts[*ptr++] += 1; 	/* 33 */ /* 30 */
  counts[*ptr++] += 1; 	/* 49 */ /* 14 */

  debug(printf("Fwd:  2 %04X, 18 %04X, 34 %04X, 50 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 61 %04X, 45 %04X, 29 %04X, 13 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1;	/* 2 */ /* 61 */
  counts[*ptr++] += 1;	/* 18 */ /* 45 */
  counts[*ptr++] += 1;	/* 34 */ /* 29 */
  counts[*ptr++] += 1;	/* 50 */ /* 13 */

  debug(printf("Fwd:  3 %04X, 19 %04X, 35 %04X, 51 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 60 %04X, 44 %04X, 28 %04X, 12 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1;	/* 3 */ /* 60 */
  counts[*ptr++] += 1;	/* 19 */ /* 44 */
  counts[*ptr++] += 1;	/* 35 */ /* 28 */
  counts[*ptr++] += 1;	/* 51 */ /* 12 */

  debug(printf("Fwd:  4 %04X, 20 %04X, 36 %04X, 52 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 59 %04X, 43 %04X, 27 %04X, 11 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1;	/* 4 */ /* 59 */
  counts[*ptr++] += 1;	/* 20 */ /* 43 */
  counts[*ptr++] += 1;	/* 36 */ /* 27 */
  counts[*ptr++] += 1;	/* 52 */ /* 11 */

  debug(printf("Fwd:  5 %04X, 21 %04X, 37 %04X, 53 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 58 %04X, 42 %04X, 26 %04X, 10 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1;	/* 5 */ /* 58 */
  counts[*ptr++] += 1;	/* 21 */ /* 42 */
  counts[*ptr++] += 1;	/* 37 */ /* 26 */
  counts[*ptr++] += 1;	/* 53 */ /* 10 */

  debug(printf("Fwd:  6 %04X, 22 %04X, 38 %04X, 54 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 57 %04X, 41 %04X, 25 %04X,  9 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1;	/* 6 */ /* 57 */
  counts[*ptr++] += 1;	/* 22 */ /* 41 */
  counts[*ptr++] += 1;	/* 38 */ /* 25 */
  counts[*ptr++] += 1;	/* 54 */ /* 9 */

  debug(printf("Fwd:  7 %04X, 23 %04X, 39 %04X, 55 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 56 %04X, 40 %04X, 24 %04X,  8 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1;	/* 7 */ /* 56 */
  counts[*ptr++] += 1;	/* 23 */ /* 50 */
  counts[*ptr++] += 1;	/* 39 */ /* 24 */
  counts[*ptr++] += 1;	/* 55 */ /* 8 */

  debug(printf("Fwd:  8 %04X, 24 %04X, 40 %04X, 56 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 55 %04X, 39 %04X, 23 %04X,  7 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1;	/* 8 */ /* 55 */
  counts[*ptr++] += 1;	/* 24 */ /* 39 */
  counts[*ptr++] += 1;	/* 40 */ /* 23 */
  counts[*ptr++] += 1;	/* 56 */ /* 7 */

  debug(printf("Fwd:  9 %04X, 25 %04X, 41 %04X, 57 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 54 %04X, 38 %04X, 22 %04X,  6 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1;	/* 9 */ /* 54 */
  counts[*ptr++] += 1;	/* 25 */ /* 38 */
  counts[*ptr++] += 1;	/* 41 */ /* 22 */
  counts[*ptr++] += 1;	/* 57 */ /* 6 */

  debug(printf("Fwd: 10 %04X, 26 %04X, 42 %04X, 58 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 53 %04X, 37 %04X, 21 %04X,  5 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1;	/* 10 */ /* 53 */
  counts[*ptr++] += 1;	/* 26 */ /* 37 */
  counts[*ptr++] += 1;	/* 42 */ /* 21 */
  counts[*ptr++] += 1;	/* 58 */ /* 5 */

  debug(printf("Fwd: 11 %04X, 27 %04X, 43 %04X, 59 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 52 %04X, 36 %04X, 20 %04X,  4 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1;	/* 11 */ /* 52 */
  counts[*ptr++] += 1;	/* 27 */ /* 36 */
  counts[*ptr++] += 1;	/* 43 */ /* 20 */
  counts[*ptr++] += 1;	/* 59 */ /* 4 */

  debug(printf("Fwd: 12 %04X, 28 %04X, 44 %04X, 60 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 51 %04X, 35 %04X, 19 %04X,  3 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1;	/* 12 */ /* 51 */
  counts[*ptr++] += 1;	/* 28 */ /* 35 */
  counts[*ptr++] += 1;	/* 44 */ /* 19 */
  counts[*ptr++] += 1;	/* 60 */ /* 3 */

  debug(printf("Fwd: 13 %04X, 29 %04X, 45 %04X, 61 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 50 %04X, 34 %04X, 18 %04X,  2 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1;	/* 13 */ /* 50 */
  counts[*ptr++] += 1;	/* 29 */ /* 34 */
  counts[*ptr++] += 1;	/* 45 */ /* 18 */
  counts[*ptr++] += 1;	/* 61 */ /* 2 */

  debug(printf("Fwd: 14 %04X, 30 %04X, 46 %04X, 62 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 49 %04X, 33 %04X, 17 %04X,  1 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1;	/* 14 */ /* 49 */
  counts[*ptr++] += 1;	/* 30 */ /* 33 */
  counts[*ptr++] += 1;	/* 46 */ /* 17 */
  counts[*ptr++] += 1;	/* 62 */ /* 1 */

  debug(printf("Fwd: 15 %04X, 31 %04X, 47 %04X, 63 %04X || ",ptr[0],ptr[1],ptr[2],ptr[3]));
  debug(printf("Rev: 48 %04X, 32 %04X, 16 %04X,  0 %04X\n",ptr[0],ptr[1],ptr[2],ptr[3]));
  counts[*ptr++] += 1;	/* 15 */ /* 48 */
  counts[*ptr++] += 1;	/* 31 */ /* 32 */
  counts[*ptr++] += 1;	/* 47 */ /* 16 */
  counts[*ptr++] += 1;	/* 63 */ /* 0 */

  return;
}
#endif


#ifdef HAVE_AVX512
/* Uses gather, conflict detection, and scatter.  Not worth it for
   AVX2, since we don't have conflict detection or scatter */
static void
count_fwdrev_simd_n (Count_T *counts, UINT4 *array, int n) {
  UINT4 *ptr;
  __m512i _envelopes, _increment;
  __m512i _masked, _conflicts, _blocks, _address_mask;
  __m512i _zeroes;
  __mmask16 pending_mask, current_mask;
  int i;

#if defined(HAVE_AVX512BW)
  __m512i _addresses, _ones;
#elif defined(USE_ROTATE)
  __m512i _rotates;
#else
  __m512i _new_envelopes, _addresses, _add_mask, _byte_mask, _ones;
#endif

  
#ifdef DEBUG
  if (n == 64) {
    printf("Counting of %d\n",n);
    for (i = 0; i < n; i += 4) {
      printf("%d: %08X %08X %08X %08X\n",i,array[i],array[i+1],array[i+2],array[i+3]);
    }
  } else if (n == 128) {
    printf("Counting of %d\n",n);
    for (i = 0; i < n; i += 8) {
      printf("%d: %08X %08X %08X %08X %08X %08X %08X %08X\n",
	     i,array[i],array[i+1],array[i+2],array[i+3],array[i+4],array[i+5],array[i+6],array[i+7]);
    }
  } else if (n == 256) {
    printf("Counting of %d\n",n);
    for (i = 0; i < n; i += 16) {
      printf("%d: %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X\n",
	     i,array[i],array[i+1],array[i+2],array[i+3],array[i+4],array[i+5],array[i+6],array[i+7],
	     array[i+8],array[i+9],array[i+10],array[i+11],array[i+12],array[i+13],array[i+14],array[i+15]);
      
    }
  }
#endif

  _address_mask = _mm512_set1_epi32(0x3);
  _zeroes = _mm512_setzero_si512();


#if defined(HAVE_AVX512BW)
  _ones = _mm512_set1_epi32(1);
#elif defined(USE_ROTATE)
  _increment = _mm512_set1_epi32(0x01000000); /* Add 1 to most significante byte */
#else
  _ones = _mm512_set1_epi32(1);
#endif


  ptr = &(array[0]);
#ifdef HAVE_AVX512BW
  while (ptr < &(array[n])) {
    _masked = _mm512_loadu_si512((__m512i *) ptr);
    _blocks = _mm512_srli_epi32(_masked,2); /* div by 4 bytes/int */

    _addresses = _mm512_and_si512(_masked,_address_mask);
    _addresses = _mm512_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */

    /* Note: Have to check for conflicts in _blocks, not _masked, since we update one address per block */
    _conflicts = _mm512_conflict_epi32(_blocks);
    pending_mask = 0xFFFF;
    while (pending_mask) {
      current_mask = _mm512_cmpeq_epi32_mask(_conflicts,_zeroes);
      current_mask = current_mask & pending_mask;
#if 0
      _envelopes = _mm512_mask_i32gather_epi32(_zeroes,current_mask,_blocks,(const void *) counts,/*scale*/4);
#else
      _envelopes = _mm512_i32gather_epi32(_blocks,(const void *) counts,/*scale*/4); /* Not using mask */
#endif
      /* _increment = _mm512_sllv_epi32(_mm512_mask_set1_epi32(_zeroes,current_mask,1),_addresses); */
      _increment = _mm512_sllv_epi32(_ones,_addresses); /* Puts 1 in correct byte, but not masked */
      _envelopes = _mm512_add_epi8(_envelopes,_increment);

      _mm512_mask_i32scatter_epi32((void *) counts,current_mask,_blocks,_envelopes,/*scale*/4);
      _conflicts = _mm512_andnot_si512(_mm512_set1_epi32(current_mask),_conflicts);
      pending_mask = pending_mask & (~current_mask);
    }

    ptr += 16;
  }

#elif defined(USE_ROTATE)
  /* rolv command is slow */
  while (ptr < &(array[n])) {
    _masked = _mm512_loadu_si512((__m512i *) ptr);
    _blocks = _mm512_srli_epi32(_masked,2); /* div by 4 bytes/int */
    _rotates = _mm512_andnot_si512(_masked,_address_mask); /* Faster way to subtract addresses from 3 */
    _rotates = _mm512_slli_epi32(_rotates,3); /* Multiply by 8 bits/byte */

    /* Note: Have to check for conflicts in _blocks, not _masked, since we update one address per block */
    _conflicts = _mm512_conflict_epi32(_blocks);
    pending_mask = 0xFFFF;
    while (pending_mask) {
      current_mask = _mm512_cmpeq_epi32_mask(_conflicts,_zeroes);
      current_mask = current_mask & pending_mask;
#if 0
      _envelopes = _mm512_mask_i32gather_epi32(_zeroes,current_mask,_blocks,(const void *) counts,/*scale*/4);
#else
      _envelopes = _mm512_i32gather_epi32(_blocks,(const void *) counts,/*scale*/4); /* Not using mask */
#endif

      /* rolv command is slow */
      _envelopes = _mm512_rolv_epi32(_envelopes,_rotates);
      _envelopes = _mm512_add_epi32(_envelopes,_increment);
      _envelopes = _mm512_rorv_epi32(_envelopes,_rotates);

      _mm512_mask_i32scatter_epi32((void *) counts,current_mask,_blocks,_envelopes,/*scale*/4);
      _conflicts = _mm512_andnot_si512(_mm512_set1_epi32(current_mask),_conflicts);
      pending_mask = pending_mask & (~current_mask);
    }

    ptr += 16;
  }

#else
  _byte_mask = _mm512_set1_epi32(0xFF);

  while (ptr < &(array[n])) {
    _masked = _mm512_loadu_si512((__m512i *) ptr);
    _blocks = _mm512_srli_epi32(_masked,2); /* div by 4 bytes/int */

    _addresses = _mm512_and_si512(_masked,_address_mask);
    _addresses = _mm512_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */

    /* Note: Have to check for conflicts in _blocks, not _masked, since we update one address per block */
    _conflicts = _mm512_conflict_epi32(_blocks);
    pending_mask = 0xFFFF;
    while (pending_mask) {
      current_mask = _mm512_cmpeq_epi32_mask(_conflicts,_zeroes);
      current_mask = current_mask & pending_mask;
#if 0
      _envelopes = _mm512_mask_i32gather_epi32(_zeroes,current_mask,_blocks,(const void *) counts,/*scale*/4);
#else
      _envelopes = _mm512_i32gather_epi32(_blocks,(const void *) counts,/*scale*/4); /* Not using mask */
#endif
      /* _increment = _mm512_sllv_epi32(_mm512_mask_set1_epi32(_zeroes,current_mask,1),_addresses); */
      _increment = _mm512_sllv_epi32(_ones,_addresses); /* Puts 1 in correct byte, but not masked */

      /* Need to add epi32, mask the carry, and combine previous solution */
      _add_mask = _mm512_sllv_epi32(_byte_mask,_addresses);
      _new_envelopes = _mm512_add_epi32(_envelopes,_increment);
#if 0
      _envelopes = _mm512_or_si512(_mm512_andnot_si512(_add_mask,_envelopes),_mm512_and_si512(_add_mask,_new_envelopes));
#else
      _envelopes = _mm512_ternarylogic_epi32(_add_mask,_envelopes,_new_envelopes,0xAC);
#endif

      _mm512_mask_i32scatter_epi32((void *) counts,current_mask,_blocks,_envelopes,/*scale*/4);
      _conflicts = _mm512_andnot_si512(_mm512_set1_epi32(current_mask),_conflicts);
      pending_mask = pending_mask & (~current_mask);
    }

    ptr += 16;
  }
#endif

  return;
}

#else
/* Serial */
static void
count_fwdrev_simd_n (Count_T *counts, UINT4 *array, int n) {
  UINT4 *ptr;
  
#ifdef DEBUG
  int i;
  printf("Counting of %d\n",n);
  for (i = 0; i < n; i += 16) {
    printf("%d: %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X\n",
	   i,array[i],array[i+1],array[i+2],array[i+3],array[i+4],array[i+5],array[i+6],array[i+7],
	   array[i+8],array[i+9],array[i+10],array[i+11],array[i+12],array[i+13],array[i+14],array[i+15]);
  }
#endif

  ptr = &(array[0]);
  while (ptr < &(array[n])) {
    counts[*ptr++] += 1;
  }

  return;
}
#endif


#define nonzero_p_32(diff) diff

#if !defined(HAVE_SSE4_2)
#define count_trailing_zeroes_32(diff) mod_37_bit_position[(-diff & diff) % 37]
#elif defined(HAVE_TZCNT)
#define count_trailing_zeroes_32(diff) _tzcnt_u32(diff)
#elif defined(HAVE_BUILTIN_CTZ)
#define count_trailing_zeroes_32(diff) __builtin_ctz(diff)
#else
/* lowbit = -diff & diff */
#define count_trailing_zeroes_32(diff) mod_37_bit_position[(-diff & diff) % 37]
#endif

/* Slower: clear_lowbit(diff,relpos) diff -= (1 << relpos) */
#define clear_lowbit_32(diff,relpos) (diff & (diff - 1));



#if defined(HAVE_SSE2) && defined(USE_UNORDERED)
/* Forward and reverse procedures are identical, because forward has
   chrpos ascending from left and reverse has chrpos ascending from
   right.  Right now using SSE2.  For AVX2, can use gather by shifting
   bytes. */
static Chrpos_T
store_fwdrev_simd_64 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
		      UINT4 *array) {
  Genomecomp_T masked;
  int relpos;

#ifdef DEBUG
  int i;
  printf("Storing of %d\n",64);
  for (i = 0; i < 64; i += 4) {
    printf("%d: %08X %08X %08X %08X\n",i,array[i],array[i+1],array[i+2],array[i+3]);
  }
#endif

  /* Row 3 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[63 - relpos*4];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 2 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[62 - relpos*4];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 1 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[61 - relpos*4];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 0 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[60 - relpos*4];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  return chrpos;
}
#endif


#ifdef HAVE_AVX2
static Chrpos_T
store_fwdrev_simd_64_ordered (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			      UINT4 *array) {
  Genomecomp_T masked;
  UINT4 *ptr;
  __m128i _present, _counts, _zeroes;
  __m128i _masked, _blocks, _envelopes, _addresses, _address_mask, _byte_mask;
  unsigned int diff_32;
  int relpos;
  int i;

#ifdef DEBUG
  printf("Storing of %d\n",64);
  for (i = 0; i < 64; i += 4) {
    printf("%d: %08X %08X %08X %08X\n",i,array[i],array[i+1],array[i+2],array[i+3]);
  }
#endif

  _address_mask = _mm_set1_epi32(0x3);
  _byte_mask = _mm_set1_epi32(0xFF);
  _zeroes = _mm_setzero_si128();

  ptr = &(array[0]);
  for (i = 0; i < 16; i++) {
    _masked = _mm_load_si128((__m128i *) ptr);
    _blocks = _mm_srli_epi32(_masked,2); /* div by 4 bytes/int */
    _addresses = _mm_and_si128(_masked,_address_mask);
    _addresses = _mm_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
    _envelopes = _mm_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
    _counts = _mm_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
    _counts = _mm_and_si128(_counts,_byte_mask);    /* Ignore bytes to left */

    _present = _mm_cmpgt_epi32(_counts,_zeroes);
    diff_32 = _mm_movemask_ps(_mm_castsi128_ps(_present));

    while (nonzero_p_32(diff_32)) {
      relpos = count_trailing_zeroes_32(diff_32);
      masked = ptr[relpos];
      if (counts[masked]) {
	debug(printf("64: Storing masked %u (%08X) at %u (%u - %d) using relpos\n",masked,masked,chrpos - relpos,chrpos,relpos));
	table[positions[masked] + (--counts[masked])] = chrpos - relpos;
      }
      diff_32 = clear_lowbit_32(diff_32,relpos);
    }

    chrpos -= 4;
    ptr += 4;
  }

  return chrpos;
}
#endif


#if defined(HAVE_AVX2) && defined(USE_UNORDERED)
static Chrpos_T
store_fwdrev_simd_128 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
		       UINT4 *array) {
  Genomecomp_T masked;
  int relpos;
#ifdef DEBUG
  int i;
#endif

#ifdef DEBUG
  printf("Storage of 128\n");
  for (i = 0; i < 128; i += 8) {
    printf("%d: %08X %08X %08X %08X %08X %08X %08X %08X\n",
	   i,array[i],array[i+1],array[i+2],array[i+3],array[i+4],array[i+5],array[i+6],array[i+7]);
  }
#endif

  /* Row 7 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[127 - relpos*8];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 6 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[126 - relpos*8];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;


  /* Row 5 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[125 - relpos*8];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;


  /* Row 4 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[124 - relpos*8];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;


  /* Row 3 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[123 - relpos*8];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;


  /* Row 2 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[122 - relpos*8];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;


  /* Row 1 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[121 - relpos*8];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;


  /* Row 0 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[120 - relpos*8];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  return chrpos;
}
#endif


#ifdef HAVE_AVX2
static Chrpos_T
store_fwdrev_simd_128_ordered (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			       UINT4 *array) {
  Genomecomp_T masked;
  UINT4 *ptr;
  __m256i _present, _counts, _zeroes;
  __m256i _masked, _blocks, _envelopes, _addresses, _address_mask, _count_mask;
  unsigned int diff_32;
  int relpos;
  int i;

#ifdef DEBUG
  printf("Storage of 128\n");
  for (i = 0; i < 128; i += 8) {
    printf("%d: %08X %08X %08X %08X %08X %08X %08X %08X\n",
	   i,array[i],array[i+1],array[i+2],array[i+3],array[i+4],array[i+5],array[i+6],array[i+7]);
  }
#endif

  _address_mask = _mm256_set1_epi32(0x3);
  _count_mask = _mm256_set1_epi32(0xFF);
  _zeroes = _mm256_setzero_si256();

  ptr = &(array[0]);
  for (i = 0; i < 16; i++) {
    _masked = _mm256_load_si256((__m256i *) ptr);
    _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
    _addresses = _mm256_and_si256(_masked,_address_mask);
    _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
    _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
    _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
    _counts = _mm256_and_si256(_counts,_count_mask);    /* Ignore bytes to left */

    _present = _mm256_cmpgt_epi32(_counts,_zeroes);
    diff_32 = _mm256_movemask_ps(_mm256_castsi256_ps(_present));

    while (nonzero_p_32(diff_32)) {
      relpos = count_trailing_zeroes_32(diff_32);
      masked = ptr[relpos];
      if (counts[masked]) {
	debug(printf("128: Storing masked %u (%08X) at %u (%u - %d) using relpos\n",masked,masked,chrpos - relpos,chrpos,relpos));
	table[positions[masked] + (--counts[masked])] = chrpos - relpos;
      }
      diff_32 = clear_lowbit_32(diff_32,relpos);
    }

    chrpos -= 8;
    ptr += 8;
  }

  return chrpos;
}
#endif	/* HAVE_AVX2 */


#ifdef HAVE_AVX512
static Chrpos_T
store_fwdrev_simd_256 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
		       UINT4 *array) {
  Genomecomp_T masked;
  int relpos;
#ifdef DEBUG
  int i;
#endif

#ifdef DEBUG
  printf("Storage of 256\n");
  for (i = 0; i < 256; i += 16) {
    printf("%d: %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X\n",
	   i,array[i],array[i+1],array[i+2],array[i+3],array[i+4],array[i+5],array[i+6],array[i+7],
	   array[i+8],array[i+9],array[i+10],array[i+11],array[i+12],array[i+13],array[i+14],array[i+15]);
  }
#endif

  /* Row 15 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[255 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 14 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[254 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 13 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[253 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 12 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[252 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 11 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[251 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 10 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[250 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 9 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[249 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 8 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[248 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 7 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[247 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 6 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[246 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 5 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[245 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 4 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[244 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 3 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[243 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 2 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[242 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 1 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[241 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  /* Row 0 */
  for (relpos = 0; relpos < 16; relpos++) {
    masked = array[240 - relpos*16];
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (%u - %d)\n",masked,chrpos - relpos,chrpos,relpos));
      table[positions[masked] + (--counts[masked])] = chrpos - relpos;
    }
  }
  chrpos -= 16;

  return chrpos;
}

static Chrpos_T
store_fwdrev_simd_256_ordered (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			       UINT4 *array) {
  Genomecomp_T masked;
  UINT4 *ptr;
  __m512i _counts, _zeroes;
  __m512i _masked, _blocks, _envelopes, _addresses, _address_mask, _count_mask;
  __mmask16 diff_32;
  int relpos;
  int i;

#ifdef DEBUG
  printf("Storage of 256\n");
  for (i = 0; i < 256; i += 16) {
    printf("%d: %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X %08X\n",
	   i,array[i],array[i+1],array[i+2],array[i+3],array[i+4],array[i+5],array[i+6],array[i+7],
	   array[i+8],array[i+9],array[i+10],array[i+11],array[i+12],array[i+13],array[i+14],array[i+15]);
  }
#endif

  _address_mask = _mm512_set1_epi32(0x3);
  _count_mask = _mm512_set1_epi32(0xFF);
  _zeroes = _mm512_setzero_si512();

  ptr = &(array[0]);
  for (i = 0; i < 16; i++) {
    _masked = _mm512_load_si512((__m512i *) ptr);
    _blocks = _mm512_srli_epi32(_masked,2); /* div by 4 bytes/int */
    _addresses = _mm512_and_si512(_masked,_address_mask);
    _addresses = _mm512_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
    _envelopes = _mm512_i32gather_epi32(_blocks,(const void *) counts,/*scale*/4);
    _counts = _mm512_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
    _counts = _mm512_and_si512(_counts,_count_mask);    /* Ignore bytes to left */

    diff_32 = _mm512_cmpgt_epi32_mask(_counts,_zeroes);
    while (nonzero_p_32(diff_32)) {
      relpos = count_trailing_zeroes_32(diff_32);
      masked = ptr[relpos];
      if (counts[masked]) {
	debug(printf("256: Storing masked %u (%08X) at %u (%u - %d) using relpos\n",masked,masked,chrpos - relpos,chrpos,relpos));
	table[positions[masked] + (--counts[masked])] = chrpos - relpos;
      }
      diff_32 = clear_lowbit_32(diff_32,relpos);
    }

    chrpos -= 16;
    ptr += 16;
  }

  return chrpos;
}
#endif	/* HAVE_AVX512 */




#if !defined(HAVE_AVX2)

static void
count_9mers_fwd_32 (Count_T *counts, Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
#ifdef INDIVIDUAL_SHIFTS
#elif defined(SIMD_MASK_THEN_STORE)
  UINT4 _masked[4] __attribute__ ((aligned (16)));
  __m128i _oligo;
#else
  __m128i _oligo, _masked;
#endif


  oligo = nexthigh_rev >> 16;	/* For 31..24 */
  oligo |= low_rev << 16;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK9; /* 31 */
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 2) & MASK9; /* 30 */
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 4) & MASK9; /* 29 */
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 6) & MASK9; /* 28 */
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 8) & MASK9; /* 27 */
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 10) & MASK9; /* 26 */
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 12) & MASK9; /* 25 */
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 14) & MASK9; /* 24 */
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = low_rev & MASK9;	/* 23 */
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 2) & MASK9;	/* 22 */
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 4) & MASK9;	/* 21 */
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 6) & MASK9;	/* 20 */
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 8) & MASK9; /* 19 */
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 10) & MASK9; /* 18 */
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 12) & MASK9; /* 17 */
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = low_rev >> 14;		/* 16, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(low_rev, low_rev >> 2, low_rev >> 4, low_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));
#endif


  oligo = low_rev >> 16;		/* For 15..8 */
  oligo |= high_rev << 16;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK9; /* 15 */
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 2) & MASK9; /* 14 */
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 4) & MASK9; /* 13 */
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 6) & MASK9; /* 12 */
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 8) & MASK9; /* 11 */
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 10) & MASK9; /* 10 */
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 12) & MASK9; /* 9 */
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 14) & MASK9; /* 8 */
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = high_rev & MASK9;		/* 7 */
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 2) & MASK9;	/* 6 */
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 4) & MASK9;	/* 5 */
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 6) & MASK9;	/* 4 */
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 8) & MASK9;	/* 3 */
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 10) & MASK9;	/* 2 */
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 12) & MASK9;	/* 1 */
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = high_rev >> 14;		/* 0, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(high_rev, high_rev >> 2, high_rev >> 4, high_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));
#endif

  return;
}

#else

static void
count_9mers_fwd_32 (Count_T *counts, Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
  __m256i _oligo, _masked;


  oligo = nexthigh_rev >> 16;	/* For 31..24 */
  oligo |= low_rev << 16;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask9);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(low_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask9);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));


  oligo = low_rev >> 16;		/* For 15..8 */
  oligo |= high_rev << 16;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask9);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(high_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask9);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));

  return;
}

#endif	/* HAVE_AVX2 */


/* Expecting current to have {high0_rev, low0_rev, high1_rev,
   low1_rev}, and next to have {low0_rev, high1_rev, low1_rev, and
   high2_rev} */
#ifdef HAVE_SSE2
static void
extract_9mers_fwd_simd_64 (__m128i *out, __m128i current, __m128i next) {
  __m128i oligo;

  _mm_store_si128(out++, _mm_srli_epi32(current,14)); /* No mask necessary */
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,12), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,10), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,8), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,6), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,4), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,2), mask9));
  _mm_store_si128(out++, _mm_and_si128( current, mask9));

  oligo = _mm_or_si128( _mm_srli_epi32(next,16), _mm_slli_epi32(current,16));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,14), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,12), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,10), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,8), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,6), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,4), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,2), mask9));
  _mm_store_si128(out++, _mm_and_si128( oligo, mask9));

  return;
}

#ifdef USE_UNORDERED_9
static Chrpos_T
store_9mers_fwd_simd_64 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m128i current, __m128i next) {
  __m128i array[16];
			  
  extract_9mers_fwd_simd_64(array,current,next);
  return store_fwdrev_simd_64(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_9mers_fwd_simd_64_ordered (__m128i *out, __m128i current, __m128i next) */
static Chrpos_T
store_9mers_fwd_simd_64 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m128i current, __m128i next) {
  __m128i array[16], *out;
  __m128i oligo;
  __m128i _row0, _row1, _row2, _row3, _row4, _row5, _row6, _row7,
    _row8, _row9, _row10, _row11, _row12, _row13, _row14, _row15;
  __m128i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;

  out = &(array[0]);

  oligo = _mm_or_si128( _mm_srli_epi32(next,16), _mm_slli_epi32(current,16));
  _row0 = _mm_and_si128( oligo, mask9);
  _row1 = _mm_and_si128( _mm_srli_epi32(oligo,2), mask9);
  _row2 = _mm_and_si128( _mm_srli_epi32(oligo,4), mask9);
  _row3 = _mm_and_si128( _mm_srli_epi32(oligo,6), mask9);
  _row4 = _mm_and_si128( _mm_srli_epi32(oligo,8), mask9);
  _row5 = _mm_and_si128( _mm_srli_epi32(oligo,10), mask9);
  _row6 = _mm_and_si128( _mm_srli_epi32(oligo,12), mask9);
  _row7 = _mm_and_si128( _mm_srli_epi32(oligo,14), mask9);

  _row8 = _mm_and_si128( current, mask9);
  _row9 = _mm_and_si128( _mm_srli_epi32(current,2), mask9);
  _row10 = _mm_and_si128( _mm_srli_epi32(current,4), mask9);
  _row11 = _mm_and_si128( _mm_srli_epi32(current,6), mask9);
  _row12 = _mm_and_si128( _mm_srli_epi32(current,8), mask9);
  _row13 = _mm_and_si128( _mm_srli_epi32(current,10), mask9);
  _row14 = _mm_and_si128( _mm_srli_epi32(current,12), mask9);
  _row15 = _mm_srli_epi32(current,14); /* No mask necessary */


  /* Split: top half */
  _t0 = _mm_unpackhi_epi32(_row0,_row1);
  _t1 = _mm_unpackhi_epi32(_row2,_row3);
  _t2 = _mm_unpackhi_epi32(_row4,_row5);
  _t3 = _mm_unpackhi_epi32(_row6,_row7);
  _t4 = _mm_unpackhi_epi32(_row8,_row9);
  _t5 = _mm_unpackhi_epi32(_row10,_row11);
  _t6 = _mm_unpackhi_epi32(_row12,_row13);
  _t7 = _mm_unpackhi_epi32(_row14,_row15);

  _mm_store_si128(out++, _mm_unpackhi_epi64(_t0,_t1));
  _mm_store_si128(out++, _mm_unpackhi_epi64(_t2,_t3));
  _mm_store_si128(out++, _mm_unpackhi_epi64(_t4,_t5));
  _mm_store_si128(out++, _mm_unpackhi_epi64(_t6,_t7));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t0,_t1));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t2,_t3));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t4,_t5));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t6,_t7));


  /* Split: bottom half */
  _t0 = _mm_unpacklo_epi32(_row0,_row1);
  _t1 = _mm_unpacklo_epi32(_row2,_row3);
  _t2 = _mm_unpacklo_epi32(_row4,_row5);
  _t3 = _mm_unpacklo_epi32(_row6,_row7);
  _t4 = _mm_unpacklo_epi32(_row8,_row9);
  _t5 = _mm_unpacklo_epi32(_row10,_row11);
  _t6 = _mm_unpacklo_epi32(_row12,_row13);
  _t7 = _mm_unpacklo_epi32(_row14,_row15);

  _mm_store_si128(out++, _mm_unpackhi_epi64(_t0,_t1));
  _mm_store_si128(out++, _mm_unpackhi_epi64(_t2,_t3));
  _mm_store_si128(out++, _mm_unpackhi_epi64(_t4,_t5));
  _mm_store_si128(out++, _mm_unpackhi_epi64(_t6,_t7));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t0,_t1));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t2,_t3));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t4,_t5));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t6,_t7));

  return store_fwdrev_simd_64_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif


#ifdef HAVE_AVX2
static void
extract_9mers_fwd_simd_128 (__m256i *out, __m256i current, __m256i next) {
  __m256i oligo;

  _mm256_store_si256(out++, _mm256_srli_epi32(current,14)); /* No mask necessary */
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,12), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,10), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,8), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,6), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,4), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,2), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( current, bigmask9));

  oligo = _mm256_or_si256( _mm256_srli_epi32(next,16), _mm256_slli_epi32(current,16));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,14), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,12), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,10), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,8), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,6), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,4), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,2), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( oligo, bigmask9));

  return;
}

#ifdef USE_UNORDERED_9
static Chrpos_T
store_9mers_fwd_simd_128 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			  __m256i current, __m256i next) {
  __m256i array[16];
			  
  extract_9mers_fwd_simd_128(array,current,next);
  return store_fwdrev_simd_128(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_9mers_fwd_simd_128_ordered (__m256i *out, __m256i current, __m256i next) */
static Chrpos_T
store_9mers_fwd_simd_128 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			  __m256i current, __m256i next) {
  __m256i array[16], *out;
  __m256i oligo;
  __m256i _row0, _row1, _row2, _row3, _row4, _row5, _row6, _row7,
    _row8, _row9, _row10, _row11, _row12, _row13, _row14, _row15;
  __m256i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m256i _u0, _u1, _u2, _u3, _u4, _u5, _u6, _u7;

  out = &(array[0]);

  oligo = _mm256_or_si256( _mm256_srli_epi32(next,16), _mm256_slli_epi32(current,16));
  _row0 = _mm256_and_si256( oligo, bigmask9);
  _row1 = _mm256_and_si256( _mm256_srli_epi32(oligo,2), bigmask9);
  _row2 = _mm256_and_si256( _mm256_srli_epi32(oligo,4), bigmask9);
  _row3 = _mm256_and_si256( _mm256_srli_epi32(oligo,6), bigmask9);
  _row4 = _mm256_and_si256( _mm256_srli_epi32(oligo,8), bigmask9);
  _row5 = _mm256_and_si256( _mm256_srli_epi32(oligo,10), bigmask9);
  _row6 = _mm256_and_si256( _mm256_srli_epi32(oligo,12), bigmask9);
  _row7 = _mm256_and_si256( _mm256_srli_epi32(oligo,14), bigmask9);

  _row8 = _mm256_and_si256( current, bigmask9);
  _row9 = _mm256_and_si256( _mm256_srli_epi32(current,2), bigmask9);
  _row10 = _mm256_and_si256( _mm256_srli_epi32(current,4), bigmask9);
  _row11 = _mm256_and_si256( _mm256_srli_epi32(current,6), bigmask9);
  _row12 = _mm256_and_si256( _mm256_srli_epi32(current,8), bigmask9);
  _row13 = _mm256_and_si256( _mm256_srli_epi32(current,10), bigmask9);
  _row14 = _mm256_and_si256( _mm256_srli_epi32(current,12), bigmask9);
  _row15 = _mm256_srli_epi32(current,14);


  /* Split: top half */
  _t0 = _mm256_unpackhi_epi32(_row0,_row1);
  _t1 = _mm256_unpackhi_epi32(_row2,_row3);
  _t2 = _mm256_unpackhi_epi32(_row4,_row5);
  _t3 = _mm256_unpackhi_epi32(_row6,_row7);
  _t4 = _mm256_unpackhi_epi32(_row8,_row9);
  _t5 = _mm256_unpackhi_epi32(_row10,_row11);
  _t6 = _mm256_unpackhi_epi32(_row12,_row13);
  _t7 = _mm256_unpackhi_epi32(_row14,_row15);

  _u0 = _mm256_unpackhi_epi64(_t0,_t1);
  _u1 = _mm256_unpackhi_epi64(_t2,_t3);
  _u2 = _mm256_unpackhi_epi64(_t4,_t5);
  _u3 = _mm256_unpackhi_epi64(_t6,_t7);
  _u4 = _mm256_unpacklo_epi64(_t0,_t1);
  _u5 = _mm256_unpacklo_epi64(_t2,_t3);
  _u6 = _mm256_unpacklo_epi64(_t4,_t5);
  _u7 = _mm256_unpacklo_epi64(_t6,_t7);

  /* Split: bottom half */
  _t0 = _mm256_unpacklo_epi32(_row0,_row1);
  _t1 = _mm256_unpacklo_epi32(_row2,_row3);
  _t2 = _mm256_unpacklo_epi32(_row4,_row5);
  _t3 = _mm256_unpacklo_epi32(_row6,_row7);
  _t4 = _mm256_unpacklo_epi32(_row8,_row9);
  _t5 = _mm256_unpacklo_epi32(_row10,_row11);
  _t6 = _mm256_unpacklo_epi32(_row12,_row13);
  _t7 = _mm256_unpacklo_epi32(_row14,_row15);

  _row8 = _mm256_unpackhi_epi64(_t0,_t1);
  _row9 = _mm256_unpackhi_epi64(_t2,_t3);
  _row10 = _mm256_unpackhi_epi64(_t4,_t5);
  _row11 = _mm256_unpackhi_epi64(_t6,_t7);
  _row12 = _mm256_unpacklo_epi64(_t0,_t1);
  _row13 = _mm256_unpacklo_epi64(_t2,_t3);
  _row14 = _mm256_unpacklo_epi64(_t4,_t5);
  _row15 = _mm256_unpacklo_epi64(_t6,_t7);


  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u0, _u1, 0x31));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u2, _u3, 0x31));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u4, _u5, 0x31));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u6, _u7, 0x31));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row8, _row9, 0x31));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row10, _row11, 0x31));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row12, _row13, 0x31));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row14, _row15, 0x31));

  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u0, _u1, 0x20));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u2, _u3, 0x20));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u4, _u5, 0x20));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u6, _u7, 0x20));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row8, _row9, 0x20));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row10, _row11, 0x20));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row12, _row13, 0x20));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row14, _row15, 0x20));

  return store_fwdrev_simd_128_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif

#ifdef HAVE_AVX512
static void
extract_9mers_fwd_simd_256 (__m512i *out, __m512i current, __m512i next) {
  __m512i oligo;

  _mm512_store_si512(out++, _mm512_srli_epi32(current,14)); /* No mask necessary */
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,12), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,10), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,8), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,6), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,4), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,2), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( current, hugemask9));

  oligo = _mm512_or_si512( _mm512_srli_epi32(next,16), _mm512_slli_epi32(current,16));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,14), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,12), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,10), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,8), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,6), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,4), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,2), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( oligo, hugemask9));

  return;
}

#ifdef USE_UNORDERED_9
static Chrpos_T
store_9mers_fwd_simd_256 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m512i current, __m512i next) {
  __m512i array[16];
			  
  extract_9mers_fwd_simd_256(array,current,next);
  return store_fwdrev_simd_256(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_9mers_fwd_simd_256_ordered (__m512i *out, __m512i current, __m512i next) */
static Chrpos_T
store_9mers_fwd_simd_256 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m512i current, __m512i next) {
  __m512i array[16], *out;
  __m512i oligo, _shuffle0, _shuffle1, _shuffle2;
  __m512i _row0, _row1, _row2, _row3, _row4, _row5, _row6, _row7,
    _row8, _row9, _row10, _row11, _row12, _row13, _row14, _row15;
  __m512i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m512i _u0, _u1, _u2, _u3, _u4, _u5, _u6, _u7;

  out = &(array[0]);

  oligo = _mm512_or_si512( _mm512_srli_epi32(next,16), _mm512_slli_epi32(current,16));
  _row0 = _mm512_and_si512( oligo, hugemask9);
  _row1 = _mm512_and_si512( _mm512_srli_epi32(oligo,2), hugemask9);
  _row2 = _mm512_and_si512( _mm512_srli_epi32(oligo,4), hugemask9);
  _row3 = _mm512_and_si512( _mm512_srli_epi32(oligo,6), hugemask9);
  _row4 = _mm512_and_si512( _mm512_srli_epi32(oligo,8), hugemask9);
  _row5 = _mm512_and_si512( _mm512_srli_epi32(oligo,10), hugemask9);
  _row6 = _mm512_and_si512( _mm512_srli_epi32(oligo,12), hugemask9);
  _row7 = _mm512_and_si512( _mm512_srli_epi32(oligo,14), hugemask9);

  _row8 = _mm512_and_si512( current, hugemask9);
  _row9 = _mm512_and_si512( _mm512_srli_epi32(current,2), hugemask9);
  _row10 = _mm512_and_si512( _mm512_srli_epi32(current,4), hugemask9);
  _row11 = _mm512_and_si512( _mm512_srli_epi32(current,6), hugemask9);
  _row12 = _mm512_and_si512( _mm512_srli_epi32(current,8), hugemask9);
  _row13 = _mm512_and_si512( _mm512_srli_epi32(current,10), hugemask9);
  _row14 = _mm512_and_si512( _mm512_srli_epi32(current,12), hugemask9);
  _row15 = _mm512_srli_epi32(current,14); /* No mask necessary */


  /* Split: top half */
  _t0 = _mm512_unpackhi_epi32(_row0,_row1);
  _t1 = _mm512_unpackhi_epi32(_row2,_row3);
  _t2 = _mm512_unpackhi_epi32(_row4,_row5);
  _t3 = _mm512_unpackhi_epi32(_row6,_row7);
  _t4 = _mm512_unpackhi_epi32(_row8,_row9);
  _t5 = _mm512_unpackhi_epi32(_row10,_row11);
  _t6 = _mm512_unpackhi_epi32(_row12,_row13);
  _t7 = _mm512_unpackhi_epi32(_row14,_row15);

  _u0 = _mm512_unpackhi_epi64(_t0,_t1);
  _u1 = _mm512_unpackhi_epi64(_t2,_t3);
  _u2 = _mm512_unpackhi_epi64(_t4,_t5);
  _u3 = _mm512_unpackhi_epi64(_t6,_t7);
  _u4 = _mm512_unpacklo_epi64(_t0,_t1);
  _u5 = _mm512_unpacklo_epi64(_t2,_t3);
  _u6 = _mm512_unpacklo_epi64(_t4,_t5);
  _u7 = _mm512_unpacklo_epi64(_t6,_t7);

  /* Split: bottom half */
  _t0 = _mm512_unpacklo_epi32(_row0,_row1);
  _t1 = _mm512_unpacklo_epi32(_row2,_row3);
  _t2 = _mm512_unpacklo_epi32(_row4,_row5);
  _t3 = _mm512_unpacklo_epi32(_row6,_row7);
  _t4 = _mm512_unpacklo_epi32(_row8,_row9);
  _t5 = _mm512_unpacklo_epi32(_row10,_row11);
  _t6 = _mm512_unpacklo_epi32(_row12,_row13);
  _t7 = _mm512_unpacklo_epi32(_row14,_row15);

  _row8 = _mm512_unpackhi_epi64(_t0,_t1);
  _row9 = _mm512_unpackhi_epi64(_t2,_t3);
  _row10 = _mm512_unpackhi_epi64(_t4,_t5);
  _row11 = _mm512_unpackhi_epi64(_t6,_t7);
  _row12 = _mm512_unpacklo_epi64(_t0,_t1);
  _row13 = _mm512_unpacklo_epi64(_t2,_t3);
  _row14 = _mm512_unpacklo_epi64(_t4,_t5);
  _row15 = _mm512_unpacklo_epi64(_t6,_t7);


  /* Split: top half */
  _shuffle0 = _mm512_setr_epi64(6, 7, 8+6, 8+7, 4, 5, 8+4, 8+5);
  _t0 = _mm512_permutex2var_epi64(_u0, _shuffle0, _u1);
  _t1 = _mm512_permutex2var_epi64(_u2, _shuffle0, _u3);
  _t2 = _mm512_permutex2var_epi64(_u4, _shuffle0, _u5);
  _t3 = _mm512_permutex2var_epi64(_u6, _shuffle0, _u7);
  _t4 = _mm512_permutex2var_epi64(_row8, _shuffle0, _row9);
  _t5 = _mm512_permutex2var_epi64(_row10, _shuffle0, _row11);
  _t6 = _mm512_permutex2var_epi64(_row12, _shuffle0, _row13);
  _t7 = _mm512_permutex2var_epi64(_row14, _shuffle0, _row15);

  _shuffle1 = _mm512_setr_epi64(0, 1, 2, 3, 8+0, 8+1, 8+2, 8+3);
  _shuffle2 = _mm512_setr_epi64(4, 5, 6, 7, 8+4, 8+5, 8+6, 8+7);
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t0, _shuffle1, _t1));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t2, _shuffle1, _t3));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t4, _shuffle1, _t5));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t6, _shuffle1, _t7));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t0, _shuffle2, _t1));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t2, _shuffle2, _t3));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t4, _shuffle2, _t5));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t6, _shuffle2, _t7));

  /* Split: bottom half */
  _shuffle0 = _mm512_setr_epi64(2, 3, 8+2, 8+3, 0, 1, 8+0, 8+1);
  _t0 = _mm512_permutex2var_epi64(_u0, _shuffle0, _u1);
  _t1 = _mm512_permutex2var_epi64(_u2, _shuffle0, _u3);
  _t2 = _mm512_permutex2var_epi64(_u4, _shuffle0, _u5);
  _t3 = _mm512_permutex2var_epi64(_u6, _shuffle0, _u7);
  _t4 = _mm512_permutex2var_epi64(_row8, _shuffle0, _row9);
  _t5 = _mm512_permutex2var_epi64(_row10, _shuffle0, _row11);
  _t6 = _mm512_permutex2var_epi64(_row12, _shuffle0, _row13);
  _t7 = _mm512_permutex2var_epi64(_row14, _shuffle0, _row15);

  /* _shuffle1 = _mm512_setr_epi64(0, 1, 2, 3, 8+0, 8+1, 8+2, 8+3); */
  /* _shuffle2 = _mm512_setr_epi64(4, 5, 6, 7, 8+4, 8+5, 8+6, 8+7); */
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t0, _shuffle1, _t1));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t2, _shuffle1, _t3));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t4, _shuffle1, _t5));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t6, _shuffle1, _t7));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t0, _shuffle2, _t1));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t2, _shuffle2, _t3));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t4, _shuffle2, _t5));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t6, _shuffle2, _t7));

  return store_fwdrev_simd_256_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif


#if !defined(HAVE_AVX2)
static int
store_9mers_fwd_32 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
		    Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
#ifdef INDIVIDUAL_SHIFTS
#elif defined(SIMD_MASK_THEN_STORE)
  UINT4 _masked[4] __attribute__ ((aligned (16)));
  __m128i _oligo;
#else
  __m128i _oligo, _masked;
#endif


  oligo = nexthigh_rev >> 16;	/* For 31..24 */
  oligo |= low_rev << 16;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK9; /* 31 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos));
    table[positions[masked] + (--counts[masked])] = chrpos;
  }

  masked = (oligo >> 2) & MASK9; /* 30 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
    table[positions[masked] + (--counts[masked])] = chrpos - 1;
  }

  masked = (oligo >> 4) & MASK9; /* 29 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
    table[positions[masked] + (--counts[masked])] = chrpos - 2;
  }

  masked = (oligo >> 6) & MASK9; /* 28 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
    table[positions[masked] + (--counts[masked])] = chrpos - 3;
  }

  masked = (oligo >> 8) & MASK9; /* 27 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
    table[positions[masked] + (--counts[masked])] = chrpos - 4;
  }

  masked = (oligo >> 10) & MASK9; /* 26 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
    table[positions[masked] + (--counts[masked])] = chrpos - 5;
  }

  masked = (oligo >> 12) & MASK9; /* 25 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
    table[positions[masked] + (--counts[masked])] = chrpos - 6;
  }

  masked = (oligo >> 14) & MASK9; /* 24 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
    table[positions[masked] + (--counts[masked])] = chrpos - 7;
  }

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos));
    table[positions[masked] + (--counts[masked])] = chrpos;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
    table[positions[masked] + (--counts[masked])] = chrpos - 1;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
    table[positions[masked] + (--counts[masked])] = chrpos - 2;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
    table[positions[masked] + (--counts[masked])] = chrpos - 3;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
    table[positions[masked] + (--counts[masked])] = chrpos - 4;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
    table[positions[masked] + (--counts[masked])] = chrpos - 5;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
    table[positions[masked] + (--counts[masked])] = chrpos - 6;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
    table[positions[masked] + (--counts[masked])] = chrpos - 7;
  }
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = low_rev & MASK9;	/* 23 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 8));
    table[positions[masked] + (--counts[masked])] = chrpos - 8;
  }

  masked = (low_rev >> 2) & MASK9;	/* 22 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 9));
    table[positions[masked] + (--counts[masked])] = chrpos - 9;
  }

  masked = (low_rev >> 4) & MASK9;	/* 21 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 10));
    table[positions[masked] + (--counts[masked])] = chrpos - 10;
  }

  masked = (low_rev >> 6) & MASK9;	/* 20 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 11));
    table[positions[masked] + (--counts[masked])] = chrpos - 11;
  }

  masked = (low_rev >> 8) & MASK9; /* 19 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 12));
    table[positions[masked] + (--counts[masked])] = chrpos - 12;
  }

  masked = (low_rev >> 10) & MASK9; /* 18 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 13));
    table[positions[masked] + (--counts[masked])] = chrpos - 13;
  }

  masked = (low_rev >> 12) & MASK9; /* 17 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 14));
    table[positions[masked] + (--counts[masked])] = chrpos - 14;
  }

  masked = low_rev >> 14;		/* 16, No mask necessary */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 15));
    table[positions[masked] + (--counts[masked])] = chrpos - 15;
  }

#else
  _oligo = _mm_setr_epi32(low_rev, low_rev >> 2, low_rev >> 4, low_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 8));
    table[positions[masked] + (--counts[masked])] = chrpos - 8;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 9));
    table[positions[masked] + (--counts[masked])] = chrpos - 9;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 10));
    table[positions[masked] + (--counts[masked])] = chrpos - 10;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 11));
    table[positions[masked] + (--counts[masked])] = chrpos - 11;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 12));
    table[positions[masked] + (--counts[masked])] = chrpos - 12;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 13));
    table[positions[masked] + (--counts[masked])] = chrpos - 13;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 14));
    table[positions[masked] + (--counts[masked])] = chrpos - 14;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 15));
    table[positions[masked] + (--counts[masked])] = chrpos - 15;
  }
#endif


  oligo = low_rev >> 16;		/* For 15..8 */
  oligo |= high_rev << 16;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK9; /* 15 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 16));
    table[positions[masked] + (--counts[masked])] = chrpos - 16;
  }

  masked = (oligo >> 2) & MASK9; /* 14 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 17));
    table[positions[masked] + (--counts[masked])] = chrpos - 17;
  }

  masked = (oligo >> 4) & MASK9; /* 13 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 18));
    table[positions[masked] + (--counts[masked])] = chrpos - 18;
  }

  masked = (oligo >> 6) & MASK9; /* 12 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 19));
    table[positions[masked] + (--counts[masked])] = chrpos - 19;
  }

  masked = (oligo >> 8) & MASK9; /* 11 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 20));
    table[positions[masked] + (--counts[masked])] = chrpos - 20;
  }

  masked = (oligo >> 10) & MASK9; /* 10 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 21));
    table[positions[masked] + (--counts[masked])] = chrpos - 21;
  }

  masked = (oligo >> 12) & MASK9; /* 9 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 22));
    table[positions[masked] + (--counts[masked])] = chrpos - 22;
  }

  masked = (oligo >> 14) & MASK9; /* 9 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 23));
    table[positions[masked] + (--counts[masked])] = chrpos - 23;
  }

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 16));
    table[positions[masked] + (--counts[masked])] = chrpos - 16;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 17));
    table[positions[masked] + (--counts[masked])] = chrpos - 17;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 18));
    table[positions[masked] + (--counts[masked])] = chrpos - 18;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 19));
    table[positions[masked] + (--counts[masked])] = chrpos - 19;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 20));
    table[positions[masked] + (--counts[masked])] = chrpos - 20;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 21));
    table[positions[masked] + (--counts[masked])] = chrpos - 21;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 22));
    table[positions[masked] + (--counts[masked])] = chrpos - 22;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 23));
    table[positions[masked] + (--counts[masked])] = chrpos - 23;
  }
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = high_rev & MASK9;		/* 7 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 24));
    table[positions[masked] + (--counts[masked])] = chrpos - 24;
  }

  masked = (high_rev >> 2) & MASK9;	/* 6 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 25));
    table[positions[masked] + (--counts[masked])] = chrpos - 25;
  }

  masked = (high_rev >> 4) & MASK9;	/* 5 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 26));
    table[positions[masked] + (--counts[masked])] = chrpos - 26;
  }

  masked = (high_rev >> 6) & MASK9;	/* 4 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 27));
    table[positions[masked] + (--counts[masked])] = chrpos - 27;
  }

  masked = (high_rev >> 8) & MASK9;	/* 3 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 28));
    table[positions[masked] + (--counts[masked])] = chrpos - 28;
  }

  masked = (high_rev >> 10) & MASK9;	/* 2 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 29));
    table[positions[masked] + (--counts[masked])] = chrpos - 29;
  }

  masked = (high_rev >> 12) & MASK9;	/* 1 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 30));
    table[positions[masked] + (--counts[masked])] = chrpos - 30;
  }

  masked = high_rev >> 14;		/* 0, No mask necessary */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 31));
    table[positions[masked] + (--counts[masked])] = chrpos - 31;
  }

#else
  _oligo = _mm_setr_epi32(high_rev, high_rev >> 2, high_rev >> 4, high_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 24));
    table[positions[masked] + (--counts[masked])] = chrpos - 24;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 25));
    table[positions[masked] + (--counts[masked])] = chrpos - 25;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 26));
    table[positions[masked] + (--counts[masked])] = chrpos - 26;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 27));
    table[positions[masked] + (--counts[masked])] = chrpos - 27;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 28));
    table[positions[masked] + (--counts[masked])] = chrpos - 28;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 29));
    table[positions[masked] + (--counts[masked])] = chrpos - 29;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 30));
    table[positions[masked] + (--counts[masked])] = chrpos - 30;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 31));
    table[positions[masked] + (--counts[masked])] = chrpos - 31;
  }
#endif

  return chrpos - 32;
}

#else  /* HAVE_AVX2 */

static int
store_9mers_fwd_32 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
		    Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
  __m256i _oligo, _masked, _counts;
  __m256i _blocks, _envelopes, _addresses, _address_mask, _count_mask;


  _address_mask = _mm256_set1_epi32(0x3);
  _count_mask = _mm256_set1_epi32(0xFF);


  oligo = nexthigh_rev >> 16;	/* For 31..24 */
  oligo |= low_rev << 16;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask9);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);


  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
      table[positions[masked] + (--counts[masked])] = chrpos - 1;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
      table[positions[masked] + (--counts[masked])] = chrpos - 2;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
      table[positions[masked] + (--counts[masked])] = chrpos - 3;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
      table[positions[masked] + (--counts[masked])] = chrpos - 4;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
      table[positions[masked] + (--counts[masked])] = chrpos - 5;
    }
  }

  if (EXTRACT256(_counts,6)) {
    masked = EXTRACT256(_masked,6);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
      table[positions[masked] + (--counts[masked])] = chrpos - 6;
    }
  }

  if (EXTRACT256(_counts,7)) {
    masked = EXTRACT256(_masked,7);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
      table[positions[masked] + (--counts[masked])] = chrpos - 7;
    }
  }


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(low_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask9);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 8));
      table[positions[masked] + (--counts[masked])] = chrpos - 8;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 9));
      table[positions[masked] + (--counts[masked])] = chrpos - 9;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 10));
      table[positions[masked] + (--counts[masked])] = chrpos - 10;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 11));
      table[positions[masked] + (--counts[masked])] = chrpos - 11;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 12));
      table[positions[masked] + (--counts[masked])] = chrpos - 12;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 13));
      table[positions[masked] + (--counts[masked])] = chrpos - 13;
    }
  }

  if (EXTRACT256(_counts,6)) {
    masked = EXTRACT256(_masked,6);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 14));
      table[positions[masked] + (--counts[masked])] = chrpos - 14;
    }
  }

  if (EXTRACT256(_counts,7)) {
    masked = EXTRACT256(_masked,7);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 15));
      table[positions[masked] + (--counts[masked])] = chrpos - 15;
    }
  }


  oligo = low_rev >> 16;		/* For 15..8 */
  oligo |= high_rev << 16;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask9);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 16));
      table[positions[masked] + (--counts[masked])] = chrpos - 16;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 17));
      table[positions[masked] + (--counts[masked])] = chrpos - 17;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 18));
      table[positions[masked] + (--counts[masked])] = chrpos - 18;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 19));
      table[positions[masked] + (--counts[masked])] = chrpos - 19;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 20));
      table[positions[masked] + (--counts[masked])] = chrpos - 20;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 21));
      table[positions[masked] + (--counts[masked])] = chrpos - 21;
    }
  }

  if (EXTRACT256(_counts,6)) {
    masked = EXTRACT256(_masked,6);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 22));
      table[positions[masked] + (--counts[masked])] = chrpos - 22;
    }
  }

  if (EXTRACT256(_counts,7)) {
    masked = EXTRACT256(_masked,7);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 23));
      table[positions[masked] + (--counts[masked])] = chrpos - 23;
    }
  }


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(high_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask9);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 24));
      table[positions[masked] + (--counts[masked])] = chrpos - 24;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 25));
      table[positions[masked] + (--counts[masked])] = chrpos - 25;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 26));
      table[positions[masked] + (--counts[masked])] = chrpos - 26;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 27));
      table[positions[masked] + (--counts[masked])] = chrpos - 27;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 28));
      table[positions[masked] + (--counts[masked])] = chrpos - 28;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 29));
      table[positions[masked] + (--counts[masked])] = chrpos - 29;
    }
  }

  if (EXTRACT256(_counts,6)) {
    masked = EXTRACT256(_masked,6);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 30));
      table[positions[masked] + (--counts[masked])] = chrpos - 30;
    }
  }

  if (EXTRACT256(_counts,7)) {
    masked = EXTRACT256(_masked,7);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 31));
      table[positions[masked] + (--counts[masked])] = chrpos - 31;
    }
  }

  return chrpos - 32;
}

#endif	/* HAVE_AVX2 */


#if !defined(HAVE_AVX2)

static void
count_8mers_fwd_32 (Count_T *counts, Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
#ifdef INDIVIDUAL_SHIFTS
#elif defined(SIMD_MASK_THEN_STORE)
  UINT4 _masked[4] __attribute__ ((aligned (16)));
  __m128i _oligo;
#else
  __m128i _oligo, _masked;
#endif


  oligo = nexthigh_rev >> 18;	/* For 31..25 */
  oligo |= low_rev << 14;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK8; /* 31 */
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 2) & MASK8; /* 30 */
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 4) & MASK8; /* 29 */
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 6) & MASK8; /* 28 */
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 8) & MASK8; /* 27 */
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 10) & MASK8; /* 26 */
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 12) & MASK8; /* 25 */
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = low_rev & MASK8;	/* 24 */
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 2) & MASK8;	/* 23 */
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 4) & MASK8;	/* 22 */
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 6) & MASK8;	/* 21 */
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 8) & MASK8;	/* 20 */
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 10) & MASK8; /* 19 */
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 12) & MASK8; /* 18 */
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 14) & MASK8; /* 17 */
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = low_rev >> 16;		/* 16, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));
  
#else
  _oligo = _mm_setr_epi32(low_rev, low_rev >> 2, low_rev >> 4, low_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));


  masked = low_rev >> 16;		/* 16, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));
#endif


  oligo = low_rev >> 18;		/* For 15..9 */
  oligo |= high_rev << 14;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK8; /* 15 */
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 2) & MASK8; /* 14 */
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 4) & MASK8; /* 13 */
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 6) & MASK8; /* 12 */
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 8) & MASK8; /* 11 */
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 10) & MASK8; /* 10 */
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 12) & MASK8; /* 9 */
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = high_rev & MASK8;		/* 8 */
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 2) & MASK8;	/* 7 */
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 4) & MASK8;	/* 6 */
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 6) & MASK8;	/* 5 */
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));
 
  masked = (high_rev >> 8) & MASK8;	/* 4 */
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 10) & MASK8;	/* 3 */
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 12) & MASK8;	/* 2 */
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 14) & MASK8;	/* 1 */
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = high_rev >> 16;		/* 0, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));
  
#else
  _oligo = _mm_setr_epi32(high_rev, high_rev >> 2, high_rev >> 4, high_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));


  masked = high_rev >> 16;		/* 0, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));
#endif

  return;
}

#else	/* HAVE_AVX2 */

static void
count_8mers_fwd_32 (Count_T *counts, Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
  __m256i _oligo, _masked;


  oligo = nexthigh_rev >> 18;	/* For 31..25 */
  oligo |= low_rev << 14;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask8);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(low_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask8);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));


  masked = low_rev >> 16;		/* 16, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));


  oligo = low_rev >> 18;		/* For 15..9 */
  oligo |= high_rev << 14;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask8);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(high_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask8);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));


  masked = high_rev >> 16;		/* 0, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));

  return;
}

#endif  /* HAVE_AVX2 */



/* Expecting current to have {high0_rev, low0_rev, high1_rev,
   low1_rev}, and next to have {low0_rev, high1_rev, low1_rev, and
   high2_rev} */
#ifdef HAVE_SSE2
static void
extract_8mers_fwd_simd_64 (__m128i *out, __m128i current, __m128i next) {
  __m128i oligo;

  _mm_store_si128(out++, _mm_srli_epi32(current,16)); /* No mask necessary */
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,14), mask8));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,12), mask8));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,10), mask8));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,8), mask8));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,6), mask8));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,4), mask8));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,2), mask8));
  _mm_store_si128(out++, _mm_and_si128( current, mask8));

  oligo = _mm_or_si128( _mm_srli_epi32(next,18), _mm_slli_epi32(current,14));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,12), mask8));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,10), mask8));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,8), mask8));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,6), mask8));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,4), mask8));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,2), mask8));
  _mm_store_si128(out++, _mm_and_si128( oligo, mask8));

  return;
}

#ifdef USE_UNORDERED_8
static Chrpos_T
store_8mers_fwd_simd_64 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m128i current, __m128i next) {
  __m128i array[16];
			  
  extract_8mers_fwd_simd_64(array,current,next);
  return store_fwdrev_simd_64(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_8mers_fwd_simd_64_ordered (__m128i *out, __m128i current, __m128i next) */
static Chrpos_T
store_8mers_fwd_simd_64 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m128i current, __m128i next) {
  __m128i array[16], *out;
  __m128i oligo;
  __m128i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m128i _u0, _u1, _u2, _u3;

  out = &(array[0]);

  /* As a special case, 8_mers don't need to be masked, since they fill each 16-mer */

  oligo = _mm_or_si128( _mm_srli_epi32(next,18), _mm_slli_epi32(current,14));
  /* _row0 = _mm_and_si128( oligo, mask8); */
  /* _row1 = _mm_and_si128( _mm_srli_epi32(oligo,2), mask8); */
  _t0 = _mm_blend_epi16(_mm_slli_epi32(oligo,14), oligo, 0x55);

  /* _row2 = _mm_and_si128( _mm_srli_epi32(oligo,4), mask8); */
  /* _row3 = _mm_and_si128( _mm_srli_epi32(oligo,6), mask8); */
  _t1 = _mm_blend_epi16(_mm_slli_epi32(oligo,10), _mm_srli_epi32(oligo,4), 0x55);

  /* _row4 = _mm_and_si128( _mm_srli_epi32(oligo,8), mask8); */
  /* _row5 = _mm_and_si128( _mm_srli_epi32(oligo,10), mask8); */
  _t2 = _mm_blend_epi16(_mm_slli_epi32(oligo,6), _mm_srli_epi32(oligo,8), 0x55);


  /* _row6 = _mm_and_si128( _mm_srli_epi32(oligo,12), mask8);*/
  /* _row7 = _mm_and_si128( current, mask8); */
  _t3 = _mm_blend_epi16(_mm_slli_epi32(current,16), _mm_srli_epi32(oligo,12), 0x55);

  /* _row8 = _mm_and_si128( _mm_srli_epi32(current,2), mask8); */
  /* _row9 = _mm_and_si128( _mm_srli_epi32(current,4), mask8); */
  _t4 = _mm_blend_epi16(_mm_slli_epi32(current,12), _mm_srli_epi32(current,2), 0x55);

  /* _row10 = _mm_and_si128( _mm_srli_epi32(current,6), mask8); */
  /* _row11 = _mm_and_si128( _mm_srli_epi32(current,8), mask8); */
  _t5 = _mm_blend_epi16(_mm_slli_epi32(current,8), _mm_srli_epi32(current,6), 0x55);

  /* _row12 = _mm_and_si128( _mm_srli_epi32(current,10), mask8); */
  /* _row13 = _mm_and_si128( _mm_srli_epi32(current,12), mask8); */
  _t6 = _mm_blend_epi16(_mm_slli_epi32(current,4), _mm_srli_epi32(current,10), 0x55);

  /* _row14 = _mm_and_si128( _mm_srli_epi32(current,14), mask8); */
  /* _row15 = _mm_srli_epi32(current,16); */ /* No mask necessary */
  _t7 = _mm_blend_epi16(current, _mm_srli_epi32(current,14), 0x55);


  /* Split: top half */
  _u0 = _mm_unpackhi_epi32(_t0,_t1);
  _u1 = _mm_unpackhi_epi32(_t2,_t3);
  _u2 = _mm_unpackhi_epi32(_t4,_t5);
  _u3 = _mm_unpackhi_epi32(_t6,_t7);

  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u0,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u1,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u2,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u3,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u0));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u1));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u2));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u3));

  /* Split: bottom half */
  _u0 = _mm_unpacklo_epi32(_t0,_t1);
  _u1 = _mm_unpacklo_epi32(_t2,_t3);
  _u2 = _mm_unpacklo_epi32(_t4,_t5);
  _u3 = _mm_unpacklo_epi32(_t6,_t7);

  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u0,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u1,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u2,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u3,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u0));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u1));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u2));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u3));

  return store_fwdrev_simd_64_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif

#ifdef HAVE_AVX2
static void
extract_8mers_fwd_simd_128 (__m256i *out, __m256i current, __m256i next) {
  __m256i oligo;

  _mm256_store_si256(out++, _mm256_srli_epi32(current,16)); /* No mask necessary */
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,14), bigmask8));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,12), bigmask8));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,10), bigmask8));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,8), bigmask8));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,6), bigmask8));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,4), bigmask8));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,2), bigmask8));
  _mm256_store_si256(out++, _mm256_and_si256( current, bigmask8));

  oligo = _mm256_or_si256( _mm256_srli_epi32(next,18), _mm256_slli_epi32(current,14));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,12), bigmask8));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,10), bigmask8));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,8), bigmask8));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,6), bigmask8));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,4), bigmask8));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,2), bigmask8));
  _mm256_store_si256(out++, _mm256_and_si256( oligo, bigmask8));

  return;
}

#ifdef USE_UNORDERED_8
static Chrpos_T
store_8mers_fwd_simd_128 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m256i current, __m256i next) {
  __m256i array[16];
			  
  extract_8mers_fwd_simd_128(array,current,next);
  return store_fwdrev_simd_128(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_8mers_fwd_simd_128_ordered (__m256i *out, __m256i current, __m256i next) */
static Chrpos_T
store_8mers_fwd_simd_128 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m256i current, __m256i next) {
  __m256i array[16], *out;
  __m256i oligo;
  __m256i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m256i _u0, _u1, _u2, _u3, _u4, _u5, _u6, _u7;

  out = &(array[0]);

  /* As a special case, 8_mers don't need to be masked, since they fill each 16-mer */

  oligo = _mm256_or_si256( _mm256_srli_epi32(next,18), _mm256_slli_epi32(current,14));
  /* _row0 = _mm256_and_si256( oligo, bigmask8); */
  /* _row1 = _mm256_and_si256( _mm256_srli_epi32(oligo,2), bigmask8); */
  _t0 = _mm256_blend_epi16(_mm256_slli_epi32(oligo,14), oligo, 0x55);

  /* _row2 = _mm256_and_si256( _mm256_srli_epi32(oligo,4), bigmask8); */
  /* _row3 = _mm256_and_si256( _mm256_srli_epi32(oligo,6), bigmask8); */
  _t1 = _mm256_blend_epi16(_mm256_slli_epi32(oligo,10), _mm256_srli_epi32(oligo,4), 0x55);

  /* _row4 = _mm256_and_si256( _mm256_srli_epi32(oligo,8), bigmask8); */
  /* _row5 = _mm256_and_si256( _mm256_srli_epi32(oligo,10), bigmask8); */
  _t2 = _mm256_blend_epi16(_mm256_slli_epi32(oligo,6), _mm256_srli_epi32(oligo,8), 0x55);

  /* _row6 = _mm256_and_si256( _mm256_srli_epi32(oligo,12), bigmask8); */
  /* _row7 = _mm256_and_si256( current, bigmask8); */
  _t3 = _mm256_blend_epi16(_mm256_slli_epi32(current,16), _mm256_srli_epi32(oligo,12), 0x55);

  /* _row8 = _mm256_and_si256( _mm256_srli_epi32(current,2), bigmask8); */
  /* _row9 = _mm256_and_si256( _mm256_srli_epi32(current,4), bigmask8); */
  _t4 = _mm256_blend_epi16(_mm256_slli_epi32(current,12), _mm256_srli_epi32(current,2), 0x55);

  /* _row10 = _mm256_and_si256( _mm256_srli_epi32(current,6), bigmask8); */
  /* _row11 = _mm256_and_si256( _mm256_srli_epi32(current,8), bigmask8); */
  _t5 = _mm256_blend_epi16(_mm256_slli_epi32(current,8), _mm256_srli_epi32(current,6), 0x55);

  /* _row12 = _mm256_and_si256( _mm256_srli_epi32(current,10), bigmask8); */
  /* _row13 = _mm256_and_si256( _mm256_srli_epi32(current,12), bigmask8); */
  _t6 = _mm256_blend_epi16(_mm256_slli_epi32(current,4), _mm256_srli_epi32(current,10), 0x55);

  /* _row14 = _mm256_and_si256( _mm256_srli_epi32(current,14), bigmask8); */
  /* _row15 = _mm256_srli_epi32(current,16); */ /* No mask necessary */
  _t7 = _mm256_blend_epi16(current, _mm256_srli_epi32(current,14), 0x55);


  _u0 = _mm256_unpackhi_epi32(_t0,_t1);
  _u1 = _mm256_unpackhi_epi32(_t2,_t3);
  _u2 = _mm256_unpackhi_epi32(_t4,_t5);
  _u3 = _mm256_unpackhi_epi32(_t6,_t7);
  _u4 = _mm256_unpacklo_epi32(_t0,_t1);
  _u5 = _mm256_unpacklo_epi32(_t2,_t3);
  _u6 = _mm256_unpacklo_epi32(_t4,_t5);
  _u7 = _mm256_unpacklo_epi32(_t6,_t7);


  _t0 = _mm256_unpackhi_epi64(_u0,_u1);
  _t1 = _mm256_unpackhi_epi64(_u2,_u3);
  _t2 = _mm256_unpacklo_epi64(_u0,_u1);
  _t3 = _mm256_unpacklo_epi64(_u2,_u3);
  _t4 = _mm256_unpackhi_epi64(_u4,_u5);
  _t5 = _mm256_unpackhi_epi64(_u6,_u7);
  _t6 = _mm256_unpacklo_epi64(_u4,_u5);
  _t7 = _mm256_unpacklo_epi64(_u6,_u7);


  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t0,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t1,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t2,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t3,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t4,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t5,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t6,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t7,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t0,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t1,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t2,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t3,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t4,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t5,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t6,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t7,0)));

  return store_fwdrev_simd_128_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif

#ifdef HAVE_AVX512
static void
extract_8mers_fwd_simd_256 (__m512i *out, __m512i current, __m512i next) {
  __m512i oligo;

  _mm512_store_si512(out++, _mm512_srli_epi32(current,16)); /* No mask necessary */
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,14), hugemask8));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,12), hugemask8));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,10), hugemask8));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,8), hugemask8));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,6), hugemask8));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,4), hugemask8));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,2), hugemask8));
  _mm512_store_si512(out++, _mm512_and_si512( current, hugemask8));

  oligo = _mm512_or_si512( _mm512_srli_epi32(next,18), _mm512_slli_epi32(current,14));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,12), hugemask8));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,10), hugemask8));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,8), hugemask8));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,6), hugemask8));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,4), hugemask8));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,2), hugemask8));
  _mm512_store_si512(out++, _mm512_and_si512( oligo, hugemask8));

  return;
}

#ifdef USE_UNORDERED_8
static Chrpos_T
store_8mers_fwd_simd_256 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m512i current, __m512i next) {
  __m512i array[16];
			  
  extract_8mers_fwd_simd_256(array,current,next);
  return store_fwdrev_simd_256(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_8mers_fwd_simd_256_ordered (__m512i *out, __m512i current, __m512i next) */
static Chrpos_T
store_8mers_fwd_simd_256 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m512i current, __m512i next) {
  __m512i array[16], *out;
  __m512i oligo, _shuffle0, _shuffle1, _shuffle2;
  __m512i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m512i _u0, _u1, _u2, _u3, _u4, _u5, _u6, _u7;

  out = &(array[0]);

  oligo = _mm512_or_si512( _mm512_srli_epi32(next,18), _mm512_slli_epi32(current,14));
  _u0 = _mm512_and_si512( oligo, hugemask8);
  /* _row1 = _mm512_and_si512( _mm512_srli_epi32(oligo,2), hugemask8); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(oligo,14), highmask8);
  _t0 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(oligo,4), hugemask8);
  /* _row3 = _mm512_and_si512( _mm512_srli_epi32(oligo,6), hugemask8); */
  _u1 = _mm512_and_si512(_mm512_slli_epi32(oligo,10), highmask8);
  _t1 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(oligo,8), hugemask8);
  /* _row5 = _mm512_and_si512( _mm512_srli_epi32(oligo,10), hugemask8); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(oligo,6), highmask8);
  _t2 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(oligo,12), hugemask8);
  /* _row7 = _mm512_and_si512( current, hugemask8); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(current,16), highmask8);
  _t3 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,2), hugemask8);
  /* _row9 = _mm512_and_si512( _mm512_srli_epi32(current,4), hugemask8); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(current,12), highmask8);
  _t4 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,6), hugemask8);
  /* _row11 = _mm512_and_si512( _mm512_srli_epi32(current,8), hugemask8); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(current,8), highmask8);
  _t5 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,10), hugemask8);
  /* _row13 = _mm512_and_si512( _mm512_srli_epi32(current,12), hugemask8); */
  _u1 = _mm512_and_si512(_mm512_slli_epi32(current,4), highmask8);
  _t6 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,14), hugemask8);
  /* _row15 = _mm512_srli_epi32(current,16); */ /* No mask necessary */
  _u1 = _mm512_and_si512(current, highmask8);
  _t7 = _mm512_or_si512(_u0, _u1);


  _u0 = _mm512_unpackhi_epi32(_t0,_t1);
  _u1 = _mm512_unpackhi_epi32(_t2,_t3);
  _u2 = _mm512_unpackhi_epi32(_t4,_t5);
  _u3 = _mm512_unpackhi_epi32(_t6,_t7);
  _u4 = _mm512_unpacklo_epi32(_t0,_t1);
  _u5 = _mm512_unpacklo_epi32(_t2,_t3);
  _u6 = _mm512_unpacklo_epi32(_t4,_t5);
  _u7 = _mm512_unpacklo_epi32(_t6,_t7);


  /* Split: top half */
  _shuffle0 = _mm512_setr_epi64(7, 8+7, 6, 8+6, 5, 8+5, 4, 8+4);
  _t0 = _mm512_permutex2var_epi64(_u0, _shuffle0, _u1);
  _t1 = _mm512_permutex2var_epi64(_u2, _shuffle0, _u3);
  _t2 = _mm512_permutex2var_epi64(_u4, _shuffle0, _u5);
  _t3 = _mm512_permutex2var_epi64(_u6, _shuffle0, _u7);


  _shuffle1 = _mm512_setr_epi64(0, 1, 8+0, 8+1, 2, 3, 8+2, 8+3);
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle1, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1))); 

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle1, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  _shuffle2 = _mm512_setr_epi64(4, 5, 8+4, 8+5, 6, 7, 8+6, 8+7);
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle2, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle2, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));


  /* Split: bottom half */
  _shuffle0 = _mm512_setr_epi64(3, 8+3, 2, 8+2, 1, 8+1, 0, 8+0);
  _t0 = _mm512_permutex2var_epi64(_u0, _shuffle0, _u1);
  _t1 = _mm512_permutex2var_epi64(_u2, _shuffle0, _u3);
  _t2 = _mm512_permutex2var_epi64(_u4, _shuffle0, _u5);
  _t3 = _mm512_permutex2var_epi64(_u6, _shuffle0, _u7);


  /* _shuffle1 = _mm512_setr_epi64(0, 1, 8+0, 8+1, 2, 3, 8+2, 8+3); */
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle1, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1))); 

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle1, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  /* _shuffle2 = _mm512_setr_epi64(4, 5, 8+4, 8+5, 6, 7, 8+6, 8+7); */
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle2, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle2, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  return store_fwdrev_simd_256_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif


#if !defined(HAVE_AVX2)

static int
store_8mers_fwd_32 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
		    Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
#ifdef INDIVIDUAL_SHIFTS
#elif defined(SIMD_MASK_THEN_STORE)
  UINT4 _masked[4] __attribute__ ((aligned (16)));
  __m128i _oligo;
#else
  __m128i _oligo, _masked;
#endif


  oligo = nexthigh_rev >> 18;	/* For 31..25 */
  oligo |= low_rev << 14;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK8; /* 31 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos));
    table[positions[masked] + (--counts[masked])] = chrpos;
  }

  masked = (oligo >> 2) & MASK8; /* 30 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
    table[positions[masked] + (--counts[masked])] = chrpos - 1;
  }

  masked = (oligo >> 4) & MASK8; /* 29 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
    table[positions[masked] + (--counts[masked])] = chrpos - 2;
  }

  masked = (oligo >> 6) & MASK8; /* 28 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
    table[positions[masked] + (--counts[masked])] = chrpos - 3;
  }

  masked = (oligo >> 8) & MASK8; /* 27 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
    table[positions[masked] + (--counts[masked])] = chrpos - 4;
  }

  masked = (oligo >> 10) & MASK8; /* 26 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
    table[positions[masked] + (--counts[masked])] = chrpos - 5;
  }

  masked = (oligo >> 12) & MASK8; /* 25 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
    table[positions[masked] + (--counts[masked])] = chrpos - 6;
  }

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos));
    table[positions[masked] + (--counts[masked])] = chrpos;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
    table[positions[masked] + (--counts[masked])] = chrpos - 1;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
    table[positions[masked] + (--counts[masked])] = chrpos - 2;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
    table[positions[masked] + (--counts[masked])] = chrpos - 3;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
    table[positions[masked] + (--counts[masked])] = chrpos - 4;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
    table[positions[masked] + (--counts[masked])] = chrpos - 5;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
    table[positions[masked] + (--counts[masked])] = chrpos - 6;
  }
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = low_rev & MASK8;	/* 24 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
    table[positions[masked] + (--counts[masked])] = chrpos - 7;
  }

  masked = (low_rev >> 2) & MASK8;	/* 23 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 8));
    table[positions[masked] + (--counts[masked])] = chrpos - 8;
  }

  masked = (low_rev >> 4) & MASK8;	/* 22 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 9));
    table[positions[masked] + (--counts[masked])] = chrpos - 9;
  }

  masked = (low_rev >> 6) & MASK8;	/* 21 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 10));
    table[positions[masked] + (--counts[masked])] = chrpos - 10;
  }

  masked = (low_rev >> 8) & MASK8;	/* 20 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 11));
    table[positions[masked] + (--counts[masked])] = chrpos - 11;
  }

  masked = (low_rev >> 10) & MASK8; /* 19 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 12));
    table[positions[masked] + (--counts[masked])] = chrpos - 12;
  }

  masked = (low_rev >> 12) & MASK8; /* 18 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 13));
    table[positions[masked] + (--counts[masked])] = chrpos - 13;
  }

  masked = (low_rev >> 14) & MASK8; /* 17 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 14));
    table[positions[masked] + (--counts[masked])] = chrpos - 14;
  }

  masked = low_rev >> 16;		/* 16, No mask necessary */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 15));
    table[positions[masked] + (--counts[masked])] = chrpos - 15;
  }

#else
  _oligo = _mm_setr_epi32(low_rev, low_rev >> 2, low_rev >> 4, low_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
    table[positions[masked] + (--counts[masked])] = chrpos - 7;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 8));
    table[positions[masked] + (--counts[masked])] = chrpos - 8;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 9));
    table[positions[masked] + (--counts[masked])] = chrpos - 9;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 10));
    table[positions[masked] + (--counts[masked])] = chrpos - 10;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 11));
    table[positions[masked] + (--counts[masked])] = chrpos - 11;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 12));
    table[positions[masked] + (--counts[masked])] = chrpos - 12;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 13));
    table[positions[masked] + (--counts[masked])] = chrpos - 13;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 14));
    table[positions[masked] + (--counts[masked])] = chrpos - 14;
  }


  masked = low_rev >> 16;		/* 16, No mask necessary */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 15));
    table[positions[masked] + (--counts[masked])] = chrpos - 15;
  }
#endif


  oligo = low_rev >> 18;		/* For 9..15 */
  oligo |= high_rev << 14;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK8; /* 15 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 16));
    table[positions[masked] + (--counts[masked])] = chrpos - 16;
  }

  masked = (oligo >> 2) & MASK8; /* 14 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 17));
    table[positions[masked] + (--counts[masked])] = chrpos - 17;
  }

  masked = (oligo >> 4) & MASK8; /* 13 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 18));
    table[positions[masked] + (--counts[masked])] = chrpos - 18;
  }

  masked = (oligo >> 6) & MASK8; /* 12 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 19));
    table[positions[masked] + (--counts[masked])] = chrpos - 19;
  }

  masked = (oligo >> 8) & MASK8; /* 11 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 20));
    table[positions[masked] + (--counts[masked])] = chrpos - 20;
  }

  masked = (oligo >> 10) & MASK8; /* 10 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 21));
    table[positions[masked] + (--counts[masked])] = chrpos - 21;
  }

  masked = (oligo >> 12) & MASK8; /* 9 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 22));
    table[positions[masked] + (--counts[masked])] = chrpos - 22;
  }

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 16));
    table[positions[masked] + (--counts[masked])] = chrpos - 16;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 17));
    table[positions[masked] + (--counts[masked])] = chrpos - 17;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 18));
    table[positions[masked] + (--counts[masked])] = chrpos - 18;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 19));
    table[positions[masked] + (--counts[masked])] = chrpos - 19;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 20));
    table[positions[masked] + (--counts[masked])] = chrpos - 20;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 21));
    table[positions[masked] + (--counts[masked])] = chrpos - 21;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 22));
    table[positions[masked] + (--counts[masked])] = chrpos - 22;
  }
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = high_rev & MASK8;		/* 8 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 23));
    table[positions[masked] + (--counts[masked])] = chrpos - 23;
  }

  masked = (high_rev >> 2) & MASK8;	/* 7 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 24));
    table[positions[masked] + (--counts[masked])] = chrpos - 24;
  }

  masked = (high_rev >> 4) & MASK8;	/* 6 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 25));
    table[positions[masked] + (--counts[masked])] = chrpos - 25;
  }

  masked = (high_rev >> 6) & MASK8;	/* 5 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 26));
    table[positions[masked] + (--counts[masked])] = chrpos - 26;
  }

  masked = (high_rev >> 8) & MASK8;	/* 4 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 27));
    table[positions[masked] + (--counts[masked])] = chrpos - 27;
  }

  masked = (high_rev >> 10) & MASK8;	/* 3 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 28));
    table[positions[masked] + (--counts[masked])] = chrpos - 28;
  }

  masked = (high_rev >> 12) & MASK8;	/* 2 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 29));
    table[positions[masked] + (--counts[masked])] = chrpos - 29;
  }

  masked = (high_rev >> 14) & MASK8;	/* 1 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 30));
    table[positions[masked] + (--counts[masked])] = chrpos - 30;
  }

  masked = high_rev >> 16;		/* 0, No mask necessary */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 31));
    table[positions[masked] + (--counts[masked])] = chrpos - 31;
  }

#else
  _oligo = _mm_setr_epi32(high_rev, high_rev >> 2, high_rev >> 4, high_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 23));
    table[positions[masked] + (--counts[masked])] = chrpos - 23;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 24));
    table[positions[masked] + (--counts[masked])] = chrpos - 24;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 25));
    table[positions[masked] + (--counts[masked])] = chrpos - 25;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 26));
    table[positions[masked] + (--counts[masked])] = chrpos - 26;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask8));
#else
  _masked = _mm_and_si128(_oligo, mask8);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 27));
    table[positions[masked] + (--counts[masked])] = chrpos - 27;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 28));
    table[positions[masked] + (--counts[masked])] = chrpos - 28;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 29));
    table[positions[masked] + (--counts[masked])] = chrpos - 29;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 30));
    table[positions[masked] + (--counts[masked])] = chrpos - 30;
  }

  masked = high_rev >> 16;		/* 0, No mask necessary */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 31));
    table[positions[masked] + (--counts[masked])] = chrpos - 31;
  }
#endif

  return chrpos - 32;
}

#else	/* HAVE_AVX2 */

static int
store_8mers_fwd_32 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
		    Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
  __m256i _oligo, _masked, _counts;
  __m256i _blocks, _envelopes, _addresses, _address_mask, _count_mask;


  _address_mask = _mm256_set1_epi32(0x3);
  _count_mask = _mm256_set1_epi32(0xFF);


  oligo = nexthigh_rev >> 18;	/* For 31..25 */
  oligo |= low_rev << 14;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask8);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
      table[positions[masked] + (--counts[masked])] = chrpos - 1;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
      table[positions[masked] + (--counts[masked])] = chrpos - 2;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
      table[positions[masked] + (--counts[masked])] = chrpos - 3;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
      table[positions[masked] + (--counts[masked])] = chrpos - 4;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
      table[positions[masked] + (--counts[masked])] = chrpos - 5;
    }
  }

  if (EXTRACT256(_counts,6)) {
    masked = EXTRACT256(_masked,6);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
      table[positions[masked] + (--counts[masked])] = chrpos - 6;
    }
  }


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(low_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask8);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
      table[positions[masked] + (--counts[masked])] = chrpos - 7;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 8));
      table[positions[masked] + (--counts[masked])] = chrpos - 8;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 9));
      table[positions[masked] + (--counts[masked])] = chrpos - 9;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 10));
      table[positions[masked] + (--counts[masked])] = chrpos - 10;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 11));
      table[positions[masked] + (--counts[masked])] = chrpos - 11;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 12));
      table[positions[masked] + (--counts[masked])] = chrpos - 12;
    }
  }

  if (EXTRACT256(_counts,6)) {
    masked = EXTRACT256(_masked,6);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 13));
      table[positions[masked] + (--counts[masked])] = chrpos - 13;
    }
  }

  if (EXTRACT256(_counts,7)) {
    masked = EXTRACT256(_masked,7);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 14));
      table[positions[masked] + (--counts[masked])] = chrpos - 14;
    }
  }


  masked = low_rev >> 16;		/* 16, No mask necessary */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 15));
    table[positions[masked] + (--counts[masked])] = chrpos - 15;
  }



  oligo = low_rev >> 18;		/* For 9..15 */
  oligo |= high_rev << 14;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask8);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 16));
      table[positions[masked] + (--counts[masked])] = chrpos - 16;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 17));
      table[positions[masked] + (--counts[masked])] = chrpos - 17;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 18));
      table[positions[masked] + (--counts[masked])] = chrpos - 18;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 19));
      table[positions[masked] + (--counts[masked])] = chrpos - 19;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 20));
      table[positions[masked] + (--counts[masked])] = chrpos - 20;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 21));
      table[positions[masked] + (--counts[masked])] = chrpos - 21;
    }
  }

  if (EXTRACT256(_counts,6)) {
    masked = EXTRACT256(_masked,6);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 22));
      table[positions[masked] + (--counts[masked])] = chrpos - 22;
    }
  }


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(high_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask8);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 23));
      table[positions[masked] + (--counts[masked])] = chrpos - 23;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 24));
      table[positions[masked] + (--counts[masked])] = chrpos - 24;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 25));
      table[positions[masked] + (--counts[masked])] = chrpos - 25;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 26));
      table[positions[masked] + (--counts[masked])] = chrpos - 26;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 27));
      table[positions[masked] + (--counts[masked])] = chrpos - 27;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 28));
      table[positions[masked] + (--counts[masked])] = chrpos - 28;
    }
  }

  if (EXTRACT256(_counts,6)) {
    masked = EXTRACT256(_masked,6); 
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 29));
      table[positions[masked] + (--counts[masked])] = chrpos - 29;
    }
  }

  if (EXTRACT256(_counts,7)) {
    masked = EXTRACT256(_masked,7);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 30));
      table[positions[masked] + (--counts[masked])] = chrpos - 30;
    }
  }

  masked = high_rev >> 16;		/* 0, No mask necessary */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 31));
    table[positions[masked] + (--counts[masked])] = chrpos - 31;
  }

  return chrpos - 32;
}

#endif  /* HAVE_AVX2 */




#if !defined(HAVE_AVX2)

static void
count_7mers_fwd_32 (Count_T *counts, Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
#ifdef INDIVIDUAL_SHIFTS
#elif defined(SIMD_MASK_THEN_STORE)
  UINT4 _masked[4] __attribute__ ((aligned (16)));
  __m128i _oligo;
#else
  __m128i _oligo, _masked;
#endif


  oligo = nexthigh_rev >> 20;	/* For 31..26 */
  oligo |= low_rev << 12;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK7; /* 31 */
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 2) & MASK7; /* 30 */
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 4) & MASK7; /* 29 */
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 6) & MASK7; /* 28 */
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 8) & MASK7; /* 27 */
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 10) & MASK7; /* 26 */
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = low_rev & MASK7;	/* 25 */
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 2) & MASK7;	/* 24 */
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 4) & MASK7;	/* 23 */
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 6) & MASK7;	/* 22 */
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 8) & MASK7;	/* 21 */
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 10) & MASK7;	/* 20 */
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 12) & MASK7; /* 19 */
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 14) & MASK7; /* 18 */
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 16) & MASK7; /* 17 */
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = low_rev >> 18;		/* 16, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(low_rev, low_rev >> 2, low_rev >> 4, low_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));
#endif


  oligo = low_rev >> 20;	/* For 15..10 */
  oligo |= high_rev << 12;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK7; /* 15 */
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 2) & MASK7; /* 14 */
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 4) & MASK7; /* 13 */
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 6) & MASK7; /* 12 */
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 8) & MASK7; /* 11 */
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 10) & MASK7; /* 10 */
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = high_rev & MASK7;	/* 9 */
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 2) & MASK7; /* 8 */
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 4) & MASK7;	/* 7 */
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 6) & MASK7;	/* 6 */
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 8) & MASK7;	/* 5 */
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 10) & MASK7;	/* 4 */
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 12) & MASK7;	/* 3 */
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 14) & MASK7;	/* 2 */
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 16) & MASK7;	/* 1 */
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = high_rev >> 18;		/* 0, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(high_rev, high_rev >> 2, high_rev >> 4, high_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));
#endif

  return;
}

#else	/* HAVE_AVX2 */

static void
count_7mers_fwd_32 (Count_T *counts, Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
  __m256i _oligo, _masked;


  oligo = nexthigh_rev >> 20;	/* For 31..26 */
  oligo |= low_rev << 12;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask7);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(low_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask7);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srli_epi32(_oligo, 16);
  _masked = _mm256_and_si256(_oligo, bigmask7);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));



  oligo = low_rev >> 20;	/* For 15..10 */
  oligo |= high_rev << 12;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask7);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(high_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask7);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srli_epi32(_oligo, 16);
  _masked = _mm256_and_si256(_oligo, bigmask7);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));

  return;
}

#endif  /* HAVE_AVX2 */



/* Expecting current to have {high0_rev, low0_rev, high1_rev,
   low1_rev}, and next to have {low0_rev, high1_rev, low1_rev, and
   high2_rev} */
#ifdef HAVE_SSE2
static void
extract_7mers_fwd_simd_64 (__m128i *out, __m128i current, __m128i next) {
  __m128i oligo;

  _mm_store_si128(out++, _mm_srli_epi32(current,18)); /* No mask necessary */
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,16), mask7));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,14), mask7));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,12), mask7));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,10), mask7));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,8), mask7));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,6), mask7));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,4), mask7));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,2), mask7));
  _mm_store_si128(out++, _mm_and_si128( current, mask7));

  oligo = _mm_or_si128( _mm_srli_epi32(next,20), _mm_slli_epi32(current,12));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,10), mask7));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,8), mask7));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,6), mask7));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,4), mask7));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,2), mask7));
  _mm_store_si128(out++, _mm_and_si128( oligo, mask7));

  return;
}

#ifdef USE_UNORDERED_7
static Chrpos_T
store_7mers_fwd_simd_64 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m128i current, __m128i next) {
  __m128i array[16];
			  
  extract_7mers_fwd_simd_64(array,current,next);
  return store_fwdrev_simd_64(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_7mers_fwd_simd_64_ordered (__m128i *out, __m128i current, __m128i next) */
static Chrpos_T
store_7mers_fwd_simd_64 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m128i current, __m128i next) {
  __m128i array[16], *out;
  __m128i oligo;
  __m128i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m128i _u0, _u1, _u2, _u3;

  out = &(array[0]);

  oligo = _mm_or_si128( _mm_srli_epi32(next,20), _mm_slli_epi32(current,12));
  /* _row0 = _mm_and_si128( oligo, mask7); */
  /* _row1 = _mm_and_si128( _mm_srli_epi32(oligo,2), mask7); */
  _t0 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(oligo,14), oligo, 0x55), mask7_epi16);

  /* _row2 = _mm_and_si128( _mm_srli_epi32(oligo,4), mask7); */
  /* _row3 = _mm_and_si128( _mm_srli_epi32(oligo,6), mask7); */
  _t1 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(oligo,10), _mm_srli_epi32(oligo, 4), 0x55), mask7_epi16);

  /* _row4 = _mm_and_si128( _mm_srli_epi32(oligo,8), mask7); */
  /* _row5 = _mm_and_si128( _mm_srli_epi32(oligo,10), mask7); */
  _t2 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(oligo,6), _mm_srli_epi32(oligo, 8), 0x55), mask7_epi16);


  /* _row6 = _mm_and_si128( current, mask7); */
  /* _row7 = _mm_and_si128( _mm_srli_epi32(current,2), mask7); */
  _t3 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(current,14), current, 0x55), mask7_epi16);

  /* _row8 = _mm_and_si128( _mm_srli_epi32(current,4), mask7); */
  /* _row9 = _mm_and_si128( _mm_srli_epi32(current,6), mask7); */
  _t4 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(current,10), _mm_srli_epi32(current, 4), 0x55), mask7_epi16);

  /* _row10 = _mm_and_si128( _mm_srli_epi32(current,8), mask7); */
  /* _row11 = _mm_and_si128( _mm_srli_epi32(current,10), mask7); */
  _t5 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(current,6), _mm_srli_epi32(current, 8), 0x55), mask7_epi16);

  /* _row12 = _mm_and_si128( _mm_srli_epi32(current,12), mask7); */
  /* _row13 = _mm_and_si128( _mm_srli_epi32(current,14), mask7); */
  _t6 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(current,2), _mm_srli_epi32(current, 12), 0x55), mask7_epi16);
  
  /* _row14 = _mm_and_si128( _mm_srli_epi32(current,16), mask7); */
  /* _row15 = _mm_srli_epi32(current,18); */ /* No mask necessary */
  _t7 = _mm_and_si128(_mm_blend_epi16(_mm_srli_epi32(current,2), _mm_srli_epi32(current, 16), 0x55), mask7_epi16);


  /* Split: top half */
  _u0 = _mm_unpackhi_epi32(_t0,_t1);
  _u1 = _mm_unpackhi_epi32(_t2,_t3);
  _u2 = _mm_unpackhi_epi32(_t4,_t5);
  _u3 = _mm_unpackhi_epi32(_t6,_t7);

  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u0,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u1,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u2,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u3,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u0));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u1));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u2));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u3));

  /* Split: bottom half */
  _u0 = _mm_unpacklo_epi32(_t0,_t1);
  _u1 = _mm_unpacklo_epi32(_t2,_t3);
  _u2 = _mm_unpacklo_epi32(_t4,_t5);
  _u3 = _mm_unpacklo_epi32(_t6,_t7);

  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u0,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u1,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u2,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u3,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u0));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u1));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u2));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u3));

  return store_fwdrev_simd_64_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif

#ifdef HAVE_AVX2
static void
extract_7mers_fwd_simd_128 (__m256i *out, __m256i current, __m256i next) {
  __m256i oligo;

  _mm256_store_si256(out++, _mm256_srli_epi32(current,18)); /* No mask necessary */
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,16), bigmask7));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,14), bigmask7));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,12), bigmask7));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,10), bigmask7));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,8), bigmask7));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,6), bigmask7));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,4), bigmask7));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,2), bigmask7));
  _mm256_store_si256(out++, _mm256_and_si256( current, bigmask7));

  oligo = _mm256_or_si256( _mm256_srli_epi32(next,20), _mm256_slli_epi32(current,12));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,10), bigmask7));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,8), bigmask7));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,6), bigmask7));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,4), bigmask7));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,2), bigmask7));
  _mm256_store_si256(out++, _mm256_and_si256( oligo, bigmask7));

  return;
}

#ifdef USE_UNORDERED_7
static Chrpos_T
store_7mers_fwd_simd_128 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m256i current, __m256i next) {
  __m256i array[16];
			  
  extract_7mers_fwd_simd_128(array,current,next);
  return store_fwdrev_simd_128(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_7mers_fwd_simd_128_ordered (__m256i *out, __m256i current, __m256i next) */
static Chrpos_T
store_7mers_fwd_simd_128 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m256i current, __m256i next) {
  __m256i array[16], *out;
  __m256i oligo;
  __m256i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m256i _u0, _u1, _u2, _u3, _u4, _u5, _u6, _u7;

  out = &(array[0]);

  oligo = _mm256_or_si256( _mm256_srli_epi32(next,20), _mm256_slli_epi32(current,12));
  /* _row0 = _mm256_and_si256( oligo, bigmask7); */
  /* _row1 = _mm256_and_si256( _mm256_srli_epi32(oligo,2), bigmask7); */
  _t0 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(oligo,14), oligo, 0x55), bigmask7_epi16);

  /* _row2 = _mm256_and_si256( _mm256_srli_epi32(oligo,4), bigmask7); */
  /* _row3 = _mm256_and_si256( _mm256_srli_epi32(oligo,6), bigmask7); */
  _t1 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(oligo,10), _mm256_srli_epi32(oligo,4), 0x55), bigmask7_epi16);

  /* _row4 = _mm256_and_si256( _mm256_srli_epi32(oligo,8), bigmask7); */
  /* _row5 = _mm256_and_si256( _mm256_srli_epi32(oligo,10), bigmask7); */
  _t2 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(oligo,6), _mm256_srli_epi32(oligo,8), 0x55), bigmask7_epi16);


  /* _row6 = _mm256_and_si256( current, bigmask7); */
  /* _row7 = _mm256_and_si256( _mm256_srli_epi32(current,2), bigmask7); */
  _t3 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(current,14), current, 0x55), bigmask7_epi16);

  /* _row8 = _mm256_and_si256( _mm256_srli_epi32(current,4), bigmask7); */
  /* _row9 = _mm256_and_si256( _mm256_srli_epi32(current,6), bigmask7); */
  _t4 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(current,10), _mm256_srli_epi32(current,4), 0x55), bigmask7_epi16);

  /* _row10 = _mm256_and_si256( _mm256_srli_epi32(current,8), bigmask7); */
  /* _row11 = _mm256_and_si256( _mm256_srli_epi32(current,10), bigmask7); */
  _t5 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(current,6), _mm256_srli_epi32(current,8), 0x55), bigmask7_epi16);

  /* _row12 = _mm256_and_si256( _mm256_srli_epi32(current,12), bigmask7); */
  /* _row13 = _mm256_and_si256( _mm256_srli_epi32(current,14), bigmask7); */
  _t6 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(current,2), _mm256_srli_epi32(current,12), 0x55), bigmask7_epi16);

  /* _row14 = _mm256_and_si256( _mm256_srli_epi32(current,16), bigmask7); */
  /* _row15 = _mm256_srli_epi32(current,18)); */ /* No mask necessary */
  _t7 = _mm256_and_si256(_mm256_blend_epi16(_mm256_srli_epi32(current,2), _mm256_srli_epi32(current,16), 0x55), bigmask7_epi16);


  _u0 = _mm256_unpackhi_epi32(_t0,_t1);
  _u1 = _mm256_unpackhi_epi32(_t2,_t3);
  _u2 = _mm256_unpackhi_epi32(_t4,_t5);
  _u3 = _mm256_unpackhi_epi32(_t6,_t7);
  _u4 = _mm256_unpacklo_epi32(_t0,_t1);
  _u5 = _mm256_unpacklo_epi32(_t2,_t3);
  _u6 = _mm256_unpacklo_epi32(_t4,_t5);
  _u7 = _mm256_unpacklo_epi32(_t6,_t7);


  _t0 = _mm256_unpackhi_epi64(_u0,_u1);
  _t1 = _mm256_unpackhi_epi64(_u2,_u3);
  _t2 = _mm256_unpacklo_epi64(_u0,_u1);
  _t3 = _mm256_unpacklo_epi64(_u2,_u3);
  _t4 = _mm256_unpackhi_epi64(_u4,_u5);
  _t5 = _mm256_unpackhi_epi64(_u6,_u7);
  _t6 = _mm256_unpacklo_epi64(_u4,_u5);
  _t7 = _mm256_unpacklo_epi64(_u6,_u7);


  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t0,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t1,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t2,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t3,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t4,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t5,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t6,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t7,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t0,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t1,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t2,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t3,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t4,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t5,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t6,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t7,0)));

  return store_fwdrev_simd_128_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif

#ifdef HAVE_AVX512
static void
extract_7mers_fwd_simd_256 (__m512i *out, __m512i current, __m512i next) {
  __m512i oligo;

  _mm512_store_si512(out++, _mm512_srli_epi32(current,18)); /* No mask necessary */
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,16), hugemask7));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,14), hugemask7));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,12), hugemask7));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,10), hugemask7));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,8), hugemask7));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,6), hugemask7));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,4), hugemask7));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,2), hugemask7));
  _mm512_store_si512(out++, _mm512_and_si512( current, hugemask7));

  oligo = _mm512_or_si512( _mm512_srli_epi32(next,20), _mm512_slli_epi32(current,12));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,10), hugemask7));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,8), hugemask7));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,6), hugemask7));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,4), hugemask7));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,2), hugemask7));
  _mm512_store_si512(out++, _mm512_and_si512( oligo, hugemask7));

  return;
}

#ifdef USE_UNORDERED_7
static Chrpos_T
store_7mers_fwd_simd_256 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m512i current, __m512i next) {
  __m512i array[16];
			  
  extract_7mers_fwd_simd_256(array,current,next);
  return store_fwdrev_simd_256(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_7mers_fwd_simd_256_ordered (__m512i *out, __m512i current, __m512i next) */
static Chrpos_T
store_7mers_fwd_simd_256 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m512i current, __m512i next) {
  __m512i array[16], *out;
  __m512i oligo, _shuffle0, _shuffle1, _shuffle2;
  __m512i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m512i _u0, _u1, _u2, _u3, _u4, _u5, _u6, _u7;

  out = &(array[0]);

  oligo = _mm512_or_si512( _mm512_srli_epi32(next,20), _mm512_slli_epi32(current,12));
  _u0 = _mm512_and_si512( oligo, hugemask7);
  /* _row1 = _mm512_and_si512( _mm512_srli_epi32(oligo,2), hugemask7); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(oligo,14), highmask7);
  _t0 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(oligo,4), hugemask7);
  /* _row3 = _mm512_and_si512( _mm512_srli_epi32(oligo,6), hugemask7); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(oligo,10), highmask7);
  _t1 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(oligo,8), hugemask7);
  /* _row5 = _mm512_and_si512( _mm512_srli_epi32(oligo,10), hugemask7); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(oligo,6), highmask7);
  _t2 = _mm512_or_si512(_u0, _u1);


  _u0 = _mm512_and_si512( current, hugemask7);
  /* _row7 = _mm512_and_si512( _mm512_srli_epi32(current,2), hugemask7); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(current,14), highmask7);
  _t3 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,4), hugemask7);
  /* _row9 = _mm512_and_si512( _mm512_srli_epi32(current,6), hugemask7); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(current,10), highmask7);
  _t4 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,8), hugemask7);
  /* _row11 = _mm512_and_si512( _mm512_srli_epi32(current,10), hugemask7); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(current,6), highmask7);
  _t5 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,12), hugemask7);
  /* _row13 = _mm512_and_si512( _mm512_srli_epi32(current,14), hugemask7); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(current,2), highmask7);
  _t6 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,16), hugemask7);
  /* _row15 = _mm512_srli_epi32(current,18)); */ /* No mask necessary */
  _u1 = _mm512_and_si512( _mm512_srli_epi32(current,2), highmask7);
  _t7 = _mm512_or_si512(_u0, _u1);


  _u0 = _mm512_unpackhi_epi32(_t0,_t1);
  _u1 = _mm512_unpackhi_epi32(_t2,_t3);
  _u2 = _mm512_unpackhi_epi32(_t4,_t5);
  _u3 = _mm512_unpackhi_epi32(_t6,_t7);
  _u4 = _mm512_unpacklo_epi32(_t0,_t1);
  _u5 = _mm512_unpacklo_epi32(_t2,_t3);
  _u6 = _mm512_unpacklo_epi32(_t4,_t5);
  _u7 = _mm512_unpacklo_epi32(_t6,_t7);


  /* Split: top half */
  _shuffle0 = _mm512_setr_epi64(7, 8+7, 6, 8+6, 5, 8+5, 4, 8+4);
  _t0 = _mm512_permutex2var_epi64(_u0, _shuffle0, _u1);
  _t1 = _mm512_permutex2var_epi64(_u2, _shuffle0, _u3);
  _t2 = _mm512_permutex2var_epi64(_u4, _shuffle0, _u5);
  _t3 = _mm512_permutex2var_epi64(_u6, _shuffle0, _u7);


  _shuffle1 = _mm512_setr_epi64(0, 1, 8+0, 8+1, 2, 3, 8+2, 8+3);
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle1, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1))); 

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle1, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  _shuffle2 = _mm512_setr_epi64(4, 5, 8+4, 8+5, 6, 7, 8+6, 8+7);
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle2, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle2, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));


  /* Split: bottom half */
  _shuffle0 = _mm512_setr_epi64(3, 8+3, 2, 8+2, 1, 8+1, 0, 8+0);
  _t0 = _mm512_permutex2var_epi64(_u0, _shuffle0, _u1);
  _t1 = _mm512_permutex2var_epi64(_u2, _shuffle0, _u3);
  _t2 = _mm512_permutex2var_epi64(_u4, _shuffle0, _u5);
  _t3 = _mm512_permutex2var_epi64(_u6, _shuffle0, _u7);


  /* _shuffle1 = _mm512_setr_epi64(0, 1, 8+0, 8+1, 2, 3, 8+2, 8+3); */
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle1, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1))); 

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle1, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  /* _shuffle2 = _mm512_setr_epi64(4, 5, 8+4, 8+5, 6, 7, 8+6, 8+7); */
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle2, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle2, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  return store_fwdrev_simd_256_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif



#if !defined(HAVE_AVX2)

static int
store_7mers_fwd_32 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
		    Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
#ifdef INDIVIDUAL_SHIFTS
#elif defined(SIMD_MASK_THEN_STORE)
  UINT4 _masked[4] __attribute__ ((aligned (16)));
  __m128i _oligo;
#else
  __m128i _oligo, _masked;
#endif

  
  oligo = nexthigh_rev >> 20;	/* For 31..26 */
  oligo |= low_rev << 12;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK7; /* 31 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos));
    table[positions[masked] + (--counts[masked])] = chrpos;
  }

  masked = (oligo >> 2) & MASK7; /* 30 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
    table[positions[masked] + (--counts[masked])] = chrpos - 1;
  }

  masked = (oligo >> 4) & MASK7; /* 29 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
    table[positions[masked] + (--counts[masked])] = chrpos - 2;
  }

  masked = (oligo >> 6) & MASK7; /* 28 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
    table[positions[masked] + (--counts[masked])] = chrpos - 3;
  }

  masked = (oligo >> 8) & MASK7; /* 27 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
    table[positions[masked] + (--counts[masked])] = chrpos - 4;
  }

  masked = (oligo >> 10) & MASK7; /* 26 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
    table[positions[masked] + (--counts[masked])] = chrpos - 5;
  }

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos));
    table[positions[masked] + (--counts[masked])] = chrpos;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
    table[positions[masked] + (--counts[masked])] = chrpos - 1;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
    table[positions[masked] + (--counts[masked])] = chrpos - 2;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
    table[positions[masked] + (--counts[masked])] = chrpos - 3;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
    table[positions[masked] + (--counts[masked])] = chrpos - 4;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
    table[positions[masked] + (--counts[masked])] = chrpos - 5;
  }
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = low_rev & MASK7;	/* 25 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
    table[positions[masked] + (--counts[masked])] = chrpos - 6;
  }

  masked = (low_rev >> 2) & MASK7;	/* 24 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
    table[positions[masked] + (--counts[masked])] = chrpos - 7;
  }

  masked = (low_rev >> 4) & MASK7;	/* 23 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 8));
    table[positions[masked] + (--counts[masked])] = chrpos - 8;
  }

  masked = (low_rev >> 6) & MASK7;	/* 22 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 9));
    table[positions[masked] + (--counts[masked])] = chrpos - 9;
  }

  masked = (low_rev >> 8) & MASK7;	/* 21 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 10));
    table[positions[masked] + (--counts[masked])] = chrpos - 10;
  }

  masked = (low_rev >> 10) & MASK7;	/* 20 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 11));
    table[positions[masked] + (--counts[masked])] = chrpos - 11;
  }

  masked = (low_rev >> 12) & MASK7; /* 19 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 12));
    table[positions[masked] + (--counts[masked])] = chrpos - 12;
  }

  masked = (low_rev >> 14) & MASK7; /* 18 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 13));
    table[positions[masked] + (--counts[masked])] = chrpos - 13;
  }

  masked = (low_rev >> 16) & MASK7; /* 17 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 14));
    table[positions[masked] + (--counts[masked])] = chrpos - 14;
  }

  masked = low_rev >> 18;		/* 16, No mask necessary */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 15));
    table[positions[masked] + (--counts[masked])] = chrpos - 15;
  }

#else
  _oligo = _mm_setr_epi32(low_rev, low_rev >> 2, low_rev >> 4, low_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
    table[positions[masked] + (--counts[masked])] = chrpos - 6;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
    table[positions[masked] + (--counts[masked])] = chrpos - 7;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 8));
    table[positions[masked] + (--counts[masked])] = chrpos - 8;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 9));
    table[positions[masked] + (--counts[masked])] = chrpos - 9;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 10));
    table[positions[masked] + (--counts[masked])] = chrpos - 10;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 11));
    table[positions[masked] + (--counts[masked])] = chrpos - 11;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 12));
    table[positions[masked] + (--counts[masked])] = chrpos - 12;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 13));
    table[positions[masked] + (--counts[masked])] = chrpos - 13;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 14));
    table[positions[masked] + (--counts[masked])] = chrpos - 14;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 15));
    table[positions[masked] + (--counts[masked])] = chrpos - 15;
  }
#endif


  oligo = low_rev >> 20;	/* For 15..10 */
  oligo |= high_rev << 12;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK7; /* 15 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 16));
    table[positions[masked] + (--counts[masked])] = chrpos - 16;
  }

  masked = (oligo >> 2) & MASK7; /* 14 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 17));
    table[positions[masked] + (--counts[masked])] = chrpos - 17;
  }

  masked = (oligo >> 4) & MASK7; /* 13 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 18));
    table[positions[masked] + (--counts[masked])] = chrpos - 18;
  }

  masked = (oligo >> 6) & MASK7; /* 12 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 19));
    table[positions[masked] + (--counts[masked])] = chrpos - 19;
  }

  masked = (oligo >> 8) & MASK7; /* 11 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 20));
    table[positions[masked] + (--counts[masked])] = chrpos - 20;
  }

  masked = (oligo >> 10) & MASK7; /* 10 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 21));
    table[positions[masked] + (--counts[masked])] = chrpos - 21;
  }

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 16));
    table[positions[masked] + (--counts[masked])] = chrpos - 16;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 17));
    table[positions[masked] + (--counts[masked])] = chrpos - 17;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 18));
    table[positions[masked] + (--counts[masked])] = chrpos - 18;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 19));
    table[positions[masked] + (--counts[masked])] = chrpos - 19;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 20));
    table[positions[masked] + (--counts[masked])] = chrpos - 20;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 21));
    table[positions[masked] + (--counts[masked])] = chrpos - 21;
  }
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = high_rev & MASK7;	/* 9 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 22));
    table[positions[masked] + (--counts[masked])] = chrpos - 22;
  }

  masked = (high_rev >> 2) & MASK7; /* 8 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 23));
    table[positions[masked] + (--counts[masked])] = chrpos - 23;
  }

  masked = (high_rev >> 4) & MASK7;	/* 7 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 24));
    table[positions[masked] + (--counts[masked])] = chrpos - 24;
  }

  masked = (high_rev >> 6) & MASK7;	/* 6 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 25));
    table[positions[masked] + (--counts[masked])] = chrpos - 25;
  }

  masked = (high_rev >> 8) & MASK7;	/* 5 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 26));
    table[positions[masked] + (--counts[masked])] = chrpos - 26;
  }

  masked = (high_rev >> 10) & MASK7;	/* 4 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 27));
    table[positions[masked] + (--counts[masked])] = chrpos - 27;
  }

  masked = (high_rev >> 12) & MASK7;	/* 3 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 28));
    table[positions[masked] + (--counts[masked])] = chrpos - 28;
  }

  masked = (high_rev >> 14) & MASK7;	/* 2 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 29));
    table[positions[masked] + (--counts[masked])] = chrpos - 29;
  }

  masked = (high_rev >> 16) & MASK7;	/* 1 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 30));
    table[positions[masked] + (--counts[masked])] = chrpos - 30;
  }

  masked = high_rev >> 18;		/* 0, No mask necessary */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 31));
    table[positions[masked] + (--counts[masked])] = chrpos - 31;
  }
  
#else
  _oligo = _mm_setr_epi32(high_rev, high_rev >> 2, high_rev >> 4, high_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 22));
    table[positions[masked] + (--counts[masked])] = chrpos - 22;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 23));
    table[positions[masked] + (--counts[masked])] = chrpos - 23;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 24));
    table[positions[masked] + (--counts[masked])] = chrpos - 24;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 25));
    table[positions[masked] + (--counts[masked])] = chrpos - 25;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 26));
    table[positions[masked] + (--counts[masked])] = chrpos - 26;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 27));
    table[positions[masked] + (--counts[masked])] = chrpos - 27;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 28));
    table[positions[masked] + (--counts[masked])] = chrpos - 28;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 29));
    table[positions[masked] + (--counts[masked])] = chrpos - 29;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask7));
#else
  _masked = _mm_and_si128(_oligo, mask7);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 30));
    table[positions[masked] + (--counts[masked])] = chrpos - 30;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 31));
    table[positions[masked] + (--counts[masked])] = chrpos - 31;
  }
#endif

  return chrpos - 32;
}

#else	/* HAVE_AVX2 */

static int
store_7mers_fwd_32 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
		    Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
  __m256i _oligo, _masked, _counts;
  __m256i _blocks, _envelopes, _addresses, _address_mask, _count_mask;


  _address_mask = _mm256_set1_epi32(0x3);
  _count_mask = _mm256_set1_epi32(0xFF);


  oligo = nexthigh_rev >> 20;	/* For 31..26 */
  oligo |= low_rev << 12;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask7);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
      table[positions[masked] + (--counts[masked])] = chrpos - 1;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
      table[positions[masked] + (--counts[masked])] = chrpos - 2;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
      table[positions[masked] + (--counts[masked])] = chrpos - 3;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
      table[positions[masked] + (--counts[masked])] = chrpos - 4;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
      table[positions[masked] + (--counts[masked])] = chrpos - 5;
    }
  }


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(low_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask7);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
      table[positions[masked] + (--counts[masked])] = chrpos - 6;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
      table[positions[masked] + (--counts[masked])] = chrpos - 7;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 8));
      table[positions[masked] + (--counts[masked])] = chrpos - 8;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 9));
      table[positions[masked] + (--counts[masked])] = chrpos - 9;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 10));
      table[positions[masked] + (--counts[masked])] = chrpos - 10;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 11));
      table[positions[masked] + (--counts[masked])] = chrpos - 11;
    }
  }

  if (EXTRACT256(_counts,6)) {
    masked = EXTRACT256(_masked,6);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 12));
      table[positions[masked] + (--counts[masked])] = chrpos - 12;
    }
  }

  if (EXTRACT256(_counts,7)) {
    masked = EXTRACT256(_masked,7);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 13));
      table[positions[masked] + (--counts[masked])] = chrpos - 13;
    }
  }


  _oligo = _mm256_srli_epi32(_oligo, 16);
  _masked = _mm256_and_si256(_oligo, bigmask7);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 14));
      table[positions[masked] + (--counts[masked])] = chrpos - 14;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 15));
      table[positions[masked] + (--counts[masked])] = chrpos - 15;
    }
  }


  oligo = low_rev >> 20;	/* For 15..10 */
  oligo |= high_rev << 12;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask7);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 16));
      table[positions[masked] + (--counts[masked])] = chrpos - 16;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 17));
      table[positions[masked] + (--counts[masked])] = chrpos - 17;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 18));
      table[positions[masked] + (--counts[masked])] = chrpos - 18;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 19));
      table[positions[masked] + (--counts[masked])] = chrpos - 19;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 20));
      table[positions[masked] + (--counts[masked])] = chrpos - 20;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 21));
      table[positions[masked] + (--counts[masked])] = chrpos - 21;
    }
  }


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(high_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask7);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 22));
      table[positions[masked] + (--counts[masked])] = chrpos - 22;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 23));
      table[positions[masked] + (--counts[masked])] = chrpos - 23;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 24));
      table[positions[masked] + (--counts[masked])] = chrpos - 24;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 25));
      table[positions[masked] + (--counts[masked])] = chrpos - 25;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 26));
      table[positions[masked] + (--counts[masked])] = chrpos - 26;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 27));
      table[positions[masked] + (--counts[masked])] = chrpos - 27;
    }
  }

  if (EXTRACT256(_counts,6)) {
    masked = EXTRACT256(_masked,6);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 28));
      table[positions[masked] + (--counts[masked])] = chrpos - 28;
    }
  }

  if (EXTRACT256(_counts,7)) {
    masked = EXTRACT256(_masked,7);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 29));
      table[positions[masked] + (--counts[masked])] = chrpos - 29;
    }
  }


  _oligo = _mm256_srli_epi32(_oligo, 16);
  _masked = _mm256_and_si256(_oligo, bigmask7);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 30));
      table[positions[masked] + (--counts[masked])] = chrpos - 30;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 31));
      table[positions[masked] + (--counts[masked])] = chrpos - 31;
    }
  }

  return chrpos - 32;
}

#endif  /* HAVE_AVX2 */



#if !defined(HAVE_AVX2)

static void
count_6mers_fwd_32 (Count_T *counts, Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
#ifdef INDIVIDUAL_SHIFTS
#elif defined(SIMD_MASK_THEN_STORE)
  UINT4 _masked[4] __attribute__ ((aligned (16)));
  __m128i _oligo;
#else
  __m128i _oligo, _masked;
#endif


  oligo = nexthigh_rev >> 22;	/* For 31..27 */
  oligo |= low_rev << 10;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK6; /* 31 */
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 2) & MASK6; /* 30 */
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 4) & MASK6; /* 29 */
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 6) & MASK6; /* 28 */
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 8) & MASK6; /* 27 */
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));


  masked = (oligo >> 8) & MASK6; /* 27 */
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = low_rev & MASK6;	/* 26 */
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 2) & MASK6;	/* 25 */
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 4) & MASK6;	/* 24 */
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 6) & MASK6;	/* 23 */
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 8) & MASK6;	/* 22 */
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 10) & MASK6;	/* 21 */
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 12) & MASK6;	/* 20 */
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 14) & MASK6; /* 19 */
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 16) & MASK6; /* 18 */
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 18) & MASK6; /* 17 */
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = low_rev >> 20;	/* 16, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(low_rev, low_rev >> 2, low_rev >> 4, low_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));
#endif


  oligo = low_rev >> 22;	/* For 15..11 */
  oligo |= high_rev << 10;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK6; /* 15 */
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 2) & MASK6; /* 14 */
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 4) & MASK6; /* 13 */
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 6) & MASK6; /* 12 */
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 8) & MASK6; /* 11 */
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));


  masked = (oligo >> 8) & MASK6; /* 11 */
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = high_rev & MASK6;	/* 10 */
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 2) & MASK6; /* 9 */
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 4) & MASK6; /* 8 */
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 6) & MASK6;	/* 7 */
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 8) & MASK6;	/* 6 */
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 10) & MASK6;	/* 5 */
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 12) & MASK6;	/* 4 */
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 14) & MASK6;	/* 3 */
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 16) & MASK6;	/* 2 */
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 18) & MASK6;	/* 1 */
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = high_rev >> 20;		/* 0, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(high_rev, high_rev >> 2, high_rev >> 4, high_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));
#endif

  return;
}

#else	/* HAVE_AVX2 */

static void
count_6mers_fwd_32 (Count_T *counts, Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
  __m256i _oligo, _masked;


  oligo = nexthigh_rev >> 22;	/* For 31..27 */
  oligo |= low_rev << 10;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask6);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(low_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask6);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srli_epi32(_oligo, 16);
  _masked = _mm256_and_si256(_oligo, bigmask6);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));


  oligo = low_rev >> 22;	/* For 15..11 */
  oligo |= high_rev << 10;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask6);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(high_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask6);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srli_epi32(_oligo, 16);
  _masked = _mm256_and_si256(_oligo, bigmask6);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));

  return;
}

#endif  /* HAVE_AVX2 */



/* Expecting current to have {high0_rev, low0_rev, high1_rev,
   low1_rev}, and next to have {low0_rev, high1_rev, low1_rev, and
   high2_rev} */
#ifdef HAVE_SSE2
static void
extract_6mers_fwd_simd_64 (__m128i *out, __m128i current, __m128i next) {
  __m128i oligo;

  _mm_store_si128(out++, _mm_srli_epi32(current,20)); /* No mask necessary */;
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,18), mask6));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,16), mask6));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,14), mask6));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,12), mask6));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,10), mask6));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,8), mask6));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,6), mask6));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,4), mask6));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,2), mask6));
  _mm_store_si128(out++, _mm_and_si128( current, mask6));

  oligo = _mm_or_si128( _mm_srli_epi32(next,22), _mm_slli_epi32(current,10));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,8), mask6));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,6), mask6));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,4), mask6));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,2), mask6));
  _mm_store_si128(out++, _mm_and_si128( oligo, mask6));

  return;
}

#ifdef USE_UNORDERED_6
static Chrpos_T
store_6mers_fwd_simd_64 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m128i current, __m128i next) {
  __m128i array[16];
			  
  extract_6mers_fwd_simd_64(array,current,next);
  return store_fwdrev_simd_64(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_6mers_fwd_simd_64_ordered (__m128i *out, __m128i current, __m128i next) */
static Chrpos_T
store_6mers_fwd_simd_64 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m128i current, __m128i next) {
  __m128i array[16], *out;
  __m128i oligo;
  __m128i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m128i _u0, _u1, _u2, _u3;

  out = &(array[0]);

  oligo = _mm_or_si128( _mm_srli_epi32(next,22), _mm_slli_epi32(current,10));
  /* _row0 = _mm_and_si128( oligo, mask6); */
  /* _row1 = _mm_and_si128( _mm_srli_epi32(oligo,2), mask6); */
  _t0 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(oligo,14), oligo, 0x55), mask6_epi16);

  /* _row2 = _mm_and_si128( _mm_srli_epi32(oligo,4), mask6); */
  /* _row3 = _mm_and_si128( _mm_srli_epi32(oligo,6), mask6); */
  _t1 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(oligo,10), _mm_srli_epi32(oligo, 4), 0x55), mask6_epi16);

  /* _row4 = _mm_and_si128( _mm_srli_epi32(oligo,8), mask6); */
  /* _row5 = _mm_and_si128( current, mask6); */
  _t2 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(current,16), _mm_srli_epi32(oligo, 8), 0x55), mask6_epi16);


  /* _row6 = _mm_and_si128( _mm_srli_epi32(current,2), mask6); */
  /* _row7 = _mm_and_si128( _mm_srli_epi32(current,4), mask6); */
  _t3 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(current,12), _mm_srli_epi32(current, 2), 0x55), mask6_epi16);

  /* _row8 = _mm_and_si128( _mm_srli_epi32(current,6), mask6); */
  /* _row9 = _mm_and_si128( _mm_srli_epi32(current,8), mask6); */
  _t4 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(current,8), _mm_srli_epi32(current, 6), 0x55), mask6_epi16);

  /* _row10 = _mm_and_si128( _mm_srli_epi32(current,10), mask6); */
  /* _row11 = _mm_and_si128( _mm_srli_epi32(current,12), mask6); */
  _t5 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(current,4), _mm_srli_epi32(current, 10), 0x55), mask6_epi16);

  /* _row12 = _mm_and_si128( _mm_srli_epi32(current,14), mask6); */
  /* _row13 = _mm_and_si128( _mm_srli_epi32(current,16), mask6); */
  _t6 = _mm_and_si128(_mm_blend_epi16(current, _mm_srli_epi32(current, 14), 0x55), mask6_epi16);

  /* _row14 = _mm_and_si128( _mm_srli_epi32(current,18), mask6); */
  /* _row15 = _mm_srli_epi32(current,20); */ /* No mask necessary */;
  _t7 = _mm_and_si128(_mm_blend_epi16(_mm_srli_epi32(current,4), _mm_srli_epi32(current, 18), 0x55), mask6_epi16);


  /* Split: top half */
  _u0 = _mm_unpackhi_epi32(_t0,_t1);
  _u1 = _mm_unpackhi_epi32(_t2,_t3);
  _u2 = _mm_unpackhi_epi32(_t4,_t5);
  _u3 = _mm_unpackhi_epi32(_t6,_t7);

  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u0,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u1,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u2,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u3,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u0));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u1));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u2));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u3));

  /* Split: bottom half */
  _u0 = _mm_unpacklo_epi32(_t0,_t1);
  _u1 = _mm_unpacklo_epi32(_t2,_t3);
  _u2 = _mm_unpacklo_epi32(_t4,_t5);
  _u3 = _mm_unpacklo_epi32(_t6,_t7);

  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u0,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u1,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u2,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u3,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u0));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u1));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u2));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u3));

  return store_fwdrev_simd_64_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif

#ifdef HAVE_AVX2
static void
extract_6mers_fwd_simd_128 (__m256i *out, __m256i current, __m256i next) {
  __m256i oligo;

  _mm256_store_si256(out++, _mm256_srli_epi32(current,20)); /* No mask necessary */;
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,18), bigmask6));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,16), bigmask6));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,14), bigmask6));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,12), bigmask6));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,10), bigmask6));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,8), bigmask6));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,6), bigmask6));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,4), bigmask6));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,2), bigmask6));
  _mm256_store_si256(out++, _mm256_and_si256( current, bigmask6));

  oligo = _mm256_or_si256( _mm256_srli_epi32(next,22), _mm256_slli_epi32(current,10));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,8), bigmask6));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,6), bigmask6));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,4), bigmask6));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,2), bigmask6));
  _mm256_store_si256(out++, _mm256_and_si256( oligo, bigmask6));

  return;
}

#ifdef USE_UNORDERED_6
static Chrpos_T
store_6mers_fwd_simd_128 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m256i current, __m256i next) {
  __m256i array[16];
			  
  extract_6mers_fwd_simd_128(array,current,next);
  return store_fwdrev_simd_128(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_6mers_fwd_simd_128_ordered (__m256i *out, __m256i current, __m256i next) */
static Chrpos_T
store_6mers_fwd_simd_128 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m256i current, __m256i next) {
  __m256i array[16], *out;
  __m256i oligo;
  __m256i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m256i _u0, _u1, _u2, _u3, _u4, _u5, _u6, _u7;

  out = &(array[0]);

  oligo = _mm256_or_si256( _mm256_srli_epi32(next,22), _mm256_slli_epi32(current,10));
  /* _row0 = _mm256_and_si256( oligo, bigmask6); */
  /* _row1 = _mm256_and_si256( _mm256_srli_epi32(oligo,2), bigmask6); */
  _t0 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(oligo,14), oligo, 0x55), bigmask6_epi16);

  /* _row2 = _mm256_and_si256( _mm256_srli_epi32(oligo,4), bigmask6); */
  /* _row3 = _mm256_and_si256( _mm256_srli_epi32(oligo,6), bigmask6); */
  _t1 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(oligo,10), _mm256_srli_epi32(oligo,4), 0x55), bigmask6_epi16);


  /* _row4 = _mm256_and_si256( _mm256_srli_epi32(oligo,8), bigmask6); */
  /* _row5 = _mm256_and_si256( current, bigmask6); */
  _t2 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(current,16), _mm256_srli_epi32(oligo,8), 0x55), bigmask6_epi16);

  /* _row6 = _mm256_and_si256( _mm256_srli_epi32(current,2), bigmask6); */
  /* _row7 = _mm256_and_si256( _mm256_srli_epi32(current,4), bigmask6); */
  _t3 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(current,12), _mm256_srli_epi32(current,2), 0x55), bigmask6_epi16);

  /* _row8 = _mm256_and_si256( _mm256_srli_epi32(current,6), bigmask6); */
  /* _row9 = _mm256_and_si256( _mm256_srli_epi32(current,8), bigmask6); */
  _t4 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(current,8), _mm256_srli_epi32(current,6), 0x55), bigmask6_epi16);

  /* _row10 = _mm256_and_si256( _mm256_srli_epi32(current,10), bigmask6); */
  /* _row11 = _mm256_and_si256( _mm256_srli_epi32(current,12), bigmask6); */
  _t5 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(current,4), _mm256_srli_epi32(current,10), 0x55), bigmask6_epi16);

  /* _row12 = _mm256_and_si256( _mm256_srli_epi32(current,14), bigmask6); */
  /* _row13 = _mm256_and_si256( _mm256_srli_epi32(current,16), bigmask6); */
  _t6 = _mm256_and_si256(_mm256_blend_epi16(current, _mm256_srli_epi32(current,14), 0x55), bigmask6_epi16);

  /* _row14 = _mm256_and_si256( _mm256_srli_epi32(current,18), bigmask6); */
  /* _row15 = _mm256_srli_epi32(current,20); */ /* No mask necessary */;
  _t7 = _mm256_and_si256(_mm256_blend_epi16(_mm256_srli_epi32(current,4), _mm256_srli_epi32(current,18), 0x55), bigmask6_epi16);


  _u0 = _mm256_unpackhi_epi32(_t0,_t1);
  _u1 = _mm256_unpackhi_epi32(_t2,_t3);
  _u2 = _mm256_unpackhi_epi32(_t4,_t5);
  _u3 = _mm256_unpackhi_epi32(_t6,_t7);
  _u4 = _mm256_unpacklo_epi32(_t0,_t1);
  _u5 = _mm256_unpacklo_epi32(_t2,_t3);
  _u6 = _mm256_unpacklo_epi32(_t4,_t5);
  _u7 = _mm256_unpacklo_epi32(_t6,_t7);


  _t0 = _mm256_unpackhi_epi64(_u0,_u1);
  _t1 = _mm256_unpackhi_epi64(_u2,_u3);
  _t2 = _mm256_unpacklo_epi64(_u0,_u1);
  _t3 = _mm256_unpacklo_epi64(_u2,_u3);
  _t4 = _mm256_unpackhi_epi64(_u4,_u5);
  _t5 = _mm256_unpackhi_epi64(_u6,_u7);
  _t6 = _mm256_unpacklo_epi64(_u4,_u5);
  _t7 = _mm256_unpacklo_epi64(_u6,_u7);


  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t0,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t1,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t2,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t3,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t4,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t5,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t6,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t7,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t0,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t1,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t2,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t3,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t4,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t5,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t6,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t7,0)));

  return store_fwdrev_simd_128_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif

#ifdef HAVE_AVX512
static void
extract_6mers_fwd_simd_256 (__m512i *out, __m512i current, __m512i next) {
  __m512i oligo;

  _mm512_store_si512(out++, _mm512_srli_epi32(current,20)); /* No mask necessary */;
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,18), hugemask6));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,16), hugemask6));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,14), hugemask6));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,12), hugemask6));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,10), hugemask6));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,8), hugemask6));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,6), hugemask6));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,4), hugemask6));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,2), hugemask6));
  _mm512_store_si512(out++, _mm512_and_si512( current, hugemask6));

  oligo = _mm512_or_si512( _mm512_srli_epi32(next,22), _mm512_slli_epi32(current,10));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,8), hugemask6));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,6), hugemask6));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,4), hugemask6));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,2), hugemask6));
  _mm512_store_si512(out++, _mm512_and_si512( oligo, hugemask6));

  return;
}

#ifdef USE_UNORDERED_6
static Chrpos_T
store_6mers_fwd_simd_256 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m512i current, __m512i next) {
  __m512i array[16];
			  
  extract_6mers_fwd_simd_256(array,current,next);
  return store_fwdrev_simd_256(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_6mers_fwd_simd_256_ordered (__m512i *out, __m512i current, __m512i next) */
static Chrpos_T
store_6mers_fwd_simd_256 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m512i current, __m512i next) {
  __m512i array[16], *out;
  __m512i oligo, _shuffle0, _shuffle1, _shuffle2;
  __m512i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m512i _u0, _u1, _u2, _u3, _u4, _u5, _u6, _u7;

  out = &(array[0]);

  oligo = _mm512_or_si512( _mm512_srli_epi32(next,22), _mm512_slli_epi32(current,10));
  _u0 = _mm512_and_si512( oligo, hugemask6);
  /* _row1 = _mm512_and_si512( _mm512_srli_epi32(oligo,2), hugemask6); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(oligo,14), highmask6);
  _t0 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(oligo,4), hugemask6);
  /* _row3 = _mm512_and_si512( _mm512_srli_epi32(oligo,6), hugemask6); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(oligo,10), highmask6);
  _t1 = _mm512_or_si512(_u0, _u1);


  _u0 = _mm512_and_si512( _mm512_srli_epi32(oligo,8), hugemask6);
  /* _row5 = _mm512_and_si512( current, hugemask6); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(current,16), highmask6);
  _t2 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,2), hugemask6);
  /* _row7 = _mm512_and_si512( _mm512_srli_epi32(current,4), hugemask6); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(current,12), highmask6);
  _t3 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,6), hugemask6);
  /* _row9 = _mm512_and_si512( _mm512_srli_epi32(current,8), hugemask6); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(current,8), highmask6);
  _t4 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,10), hugemask6);
  /* _row11 = _mm512_and_si512( _mm512_srli_epi32(current,12), hugemask6); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(current,4), highmask6);
  _t5 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,14), hugemask6);
  /* _row13 = _mm512_and_si512( _mm512_srli_epi32(current,16), hugemask6); */
  _u1 = _mm512_and_si512( current, highmask6);
  _t6 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,18), hugemask6);
  /* _row15 = _mm512_srli_epi32(current,20); */ /* No mask necessary */;
  _u1 = _mm512_and_si512( _mm512_srli_epi32(current,4), highmask6);
  _t7 = _mm512_or_si512(_u0, _u1);


  _u0 = _mm512_unpackhi_epi32(_t0,_t1);
  _u1 = _mm512_unpackhi_epi32(_t2,_t3);
  _u2 = _mm512_unpackhi_epi32(_t4,_t5);
  _u3 = _mm512_unpackhi_epi32(_t6,_t7);
  _u4 = _mm512_unpacklo_epi32(_t0,_t1);
  _u5 = _mm512_unpacklo_epi32(_t2,_t3);
  _u6 = _mm512_unpacklo_epi32(_t4,_t5);
  _u7 = _mm512_unpacklo_epi32(_t6,_t7);


  /* Split: top half */
  _shuffle0 = _mm512_setr_epi64(7, 8+7, 6, 8+6, 5, 8+5, 4, 8+4);
  _t0 = _mm512_permutex2var_epi64(_u0, _shuffle0, _u1);
  _t1 = _mm512_permutex2var_epi64(_u2, _shuffle0, _u3);
  _t2 = _mm512_permutex2var_epi64(_u4, _shuffle0, _u5);
  _t3 = _mm512_permutex2var_epi64(_u6, _shuffle0, _u7);


  _shuffle1 = _mm512_setr_epi64(0, 1, 8+0, 8+1, 2, 3, 8+2, 8+3);
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle1, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1))); 

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle1, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  _shuffle2 = _mm512_setr_epi64(4, 5, 8+4, 8+5, 6, 7, 8+6, 8+7);
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle2, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle2, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));


  /* Split: bottom half */
  _shuffle0 = _mm512_setr_epi64(3, 8+3, 2, 8+2, 1, 8+1, 0, 8+0);
  _t0 = _mm512_permutex2var_epi64(_u0, _shuffle0, _u1);
  _t1 = _mm512_permutex2var_epi64(_u2, _shuffle0, _u3);
  _t2 = _mm512_permutex2var_epi64(_u4, _shuffle0, _u5);
  _t3 = _mm512_permutex2var_epi64(_u6, _shuffle0, _u7);


  /* _shuffle1 = _mm512_setr_epi64(0, 1, 8+0, 8+1, 2, 3, 8+2, 8+3); */
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle1, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1))); 

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle1, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  /* _shuffle2 = _mm512_setr_epi64(4, 5, 8+4, 8+5, 6, 7, 8+6, 8+7); */
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle2, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle2, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  return store_fwdrev_simd_256_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif


#if !defined(HAVE_AVX2)

static int
store_6mers_fwd_32 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
		    Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
#ifdef INDIVIDUAL_SHIFTS
#elif defined(SIMD_MASK_THEN_STORE)
  UINT4 _masked[4] __attribute__ ((aligned (16)));
  __m128i _oligo;
#else
  __m128i _oligo, _masked;
#endif


  oligo = nexthigh_rev >> 22;	/* For 27..31 */
  oligo |= low_rev << 10;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK6; /* 31 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos));
    table[positions[masked] + (--counts[masked])] = chrpos;
  }

  masked = (oligo >> 2) & MASK6; /* 30 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
    table[positions[masked] + (--counts[masked])] = chrpos - 1;
  }

  masked = (oligo >> 4) & MASK6; /* 29 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
    table[positions[masked] + (--counts[masked])] = chrpos - 2;
  }

  masked = (oligo >> 6) & MASK6; /* 28 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
    table[positions[masked] + (--counts[masked])] = chrpos - 3;
  }

  masked = (oligo >> 8) & MASK6; /* 27 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
    table[positions[masked] + (--counts[masked])] = chrpos - 4;
  }

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos));
    table[positions[masked] + (--counts[masked])] = chrpos;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
    table[positions[masked] + (--counts[masked])] = chrpos - 1;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
    table[positions[masked] + (--counts[masked])] = chrpos - 2;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
    table[positions[masked] + (--counts[masked])] = chrpos - 3;
  }


  masked = (oligo >> 8) & MASK6; /* 27 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
    table[positions[masked] + (--counts[masked])] = chrpos - 4;
  }
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = low_rev & MASK6;	/* 26 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
    table[positions[masked] + (--counts[masked])] = chrpos - 5;
  }

  masked = (low_rev >> 2) & MASK6;	/* 25 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
    table[positions[masked] + (--counts[masked])] = chrpos - 6;
  }

  masked = (low_rev >> 4) & MASK6;	/* 24 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
    table[positions[masked] + (--counts[masked])] = chrpos - 7;
  }

  masked = (low_rev >> 6) & MASK6;	/* 23 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 8));
    table[positions[masked] + (--counts[masked])] = chrpos - 8;
  }

  masked = (low_rev >> 8) & MASK6;	/* 22 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 9));
    table[positions[masked] + (--counts[masked])] = chrpos - 9;
  }

  masked = (low_rev >> 10) & MASK6;	/* 21 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 10));
    table[positions[masked] + (--counts[masked])] = chrpos - 10;
  }

  masked = (low_rev >> 12) & MASK6;	/* 20 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 11));
    table[positions[masked] + (--counts[masked])] = chrpos - 11;
  }

  masked = (low_rev >> 14) & MASK6; /* 19 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 12));
    table[positions[masked] + (--counts[masked])] = chrpos - 12;
  }

  masked = (low_rev >> 16) & MASK6; /* 18 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 13));
    table[positions[masked] + (--counts[masked])] = chrpos - 13;
  }

  masked = (low_rev >> 18) & MASK6; /* 17 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 14));
    table[positions[masked] + (--counts[masked])] = chrpos - 14;
  }

  masked = low_rev >> 20;	/* 16, No mask necessary */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 15));
    table[positions[masked] + (--counts[masked])] = chrpos - 15;
  }
  
#else
  _oligo = _mm_setr_epi32(low_rev, low_rev >> 2, low_rev >> 4, low_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
    table[positions[masked] + (--counts[masked])] = chrpos - 5;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
    table[positions[masked] + (--counts[masked])] = chrpos - 6;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
    table[positions[masked] + (--counts[masked])] = chrpos - 7;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 8));
    table[positions[masked] + (--counts[masked])] = chrpos - 8;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 9));
    table[positions[masked] + (--counts[masked])] = chrpos - 9;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 10));
    table[positions[masked] + (--counts[masked])] = chrpos - 10;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 11));
    table[positions[masked] + (--counts[masked])] = chrpos - 11;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 12));
    table[positions[masked] + (--counts[masked])] = chrpos - 12;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 13));
    table[positions[masked] + (--counts[masked])] = chrpos - 13;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 14));
    table[positions[masked] + (--counts[masked])] = chrpos - 14;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 15));
    table[positions[masked] + (--counts[masked])] = chrpos - 15;
  }
#endif


  oligo = low_rev >> 22;	/* For 15..11 */
  oligo |= high_rev << 10;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK6; /* 15 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 16));
    table[positions[masked] + (--counts[masked])] = chrpos - 16;
  }

  masked = (oligo >> 2) & MASK6; /* 14 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 17));
    table[positions[masked] + (--counts[masked])] = chrpos - 17;
  }

  masked = (oligo >> 4) & MASK6; /* 13 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 18));
    table[positions[masked] + (--counts[masked])] = chrpos - 18;
  }

  masked = (oligo >> 6) & MASK6; /* 12 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 19));
    table[positions[masked] + (--counts[masked])] = chrpos - 19;
  }

  masked = (oligo >> 8) & MASK6; /* 11 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 20));
    table[positions[masked] + (--counts[masked])] = chrpos - 20;
  }

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 16));
    table[positions[masked] + (--counts[masked])] = chrpos - 16;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 17));
    table[positions[masked] + (--counts[masked])] = chrpos - 17;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 18));
    table[positions[masked] + (--counts[masked])] = chrpos - 18;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 19));
    table[positions[masked] + (--counts[masked])] = chrpos - 19;
  }


  masked = (oligo >> 8) & MASK6; /* 11 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 20));
    table[positions[masked] + (--counts[masked])] = chrpos - 20;
  }
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = high_rev & MASK6;	/* 10 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 21));
    table[positions[masked] + (--counts[masked])] = chrpos - 21;
  }

  masked = (high_rev >> 2) & MASK6; /* 9 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 22));
    table[positions[masked] + (--counts[masked])] = chrpos - 22;
  }

  masked = (high_rev >> 4) & MASK6; /* 8 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 23));
    table[positions[masked] + (--counts[masked])] = chrpos - 23;
  }

  masked = (high_rev >> 6) & MASK6;	/* 7 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 24));
    table[positions[masked] + (--counts[masked])] = chrpos - 24;
  }

  masked = (high_rev >> 8) & MASK6;	/* 6 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 25));
    table[positions[masked] + (--counts[masked])] = chrpos - 25;
  }

  masked = (high_rev >> 10) & MASK6;	/* 5 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 26));
    table[positions[masked] + (--counts[masked])] = chrpos - 26;
  }

  masked = (high_rev >> 12) & MASK6;	/* 4 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 27));
    table[positions[masked] + (--counts[masked])] = chrpos - 27;
  }

  masked = (high_rev >> 14) & MASK6;	/* 3 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 28));
    table[positions[masked] + (--counts[masked])] = chrpos - 28;
  }

  masked = (high_rev >> 16) & MASK6;	/* 2 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 29));
    table[positions[masked] + (--counts[masked])] = chrpos - 29;
  }

  masked = (high_rev >> 18) & MASK6;	/* 1 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 30));
    table[positions[masked] + (--counts[masked])] = chrpos - 30;
  }

  masked = high_rev >> 20;		/* 0, No mask necessary */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 31));
    table[positions[masked] + (--counts[masked])] = chrpos - 31;
  }
  
#else
  _oligo = _mm_setr_epi32(high_rev, high_rev >> 2, high_rev >> 4, high_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 21));
    table[positions[masked] + (--counts[masked])] = chrpos - 21;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 22));
    table[positions[masked] + (--counts[masked])] = chrpos - 22;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 23));
    table[positions[masked] + (--counts[masked])] = chrpos - 23;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 24));
    table[positions[masked] + (--counts[masked])] = chrpos - 24;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 25));
    table[positions[masked] + (--counts[masked])] = chrpos - 25;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 26));
    table[positions[masked] + (--counts[masked])] = chrpos - 26;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 27));
    table[positions[masked] + (--counts[masked])] = chrpos - 27;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 28));
    table[positions[masked] + (--counts[masked])] = chrpos - 28;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask6));
#else
  _masked = _mm_and_si128(_oligo, mask6);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 29));
    table[positions[masked] + (--counts[masked])] = chrpos - 29;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 30));
    table[positions[masked] + (--counts[masked])] = chrpos - 30;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 31));
    table[positions[masked] + (--counts[masked])] = chrpos - 31;
  }
#endif


  return chrpos - 32;
}

#else  /* HAVE_AVX2 */

static int
store_6mers_fwd_32 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
		    Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
  __m256i _oligo, _masked, _counts;
  __m256i _blocks, _envelopes, _addresses, _address_mask, _count_mask;


  _address_mask = _mm256_set1_epi32(0x3);
  _count_mask = _mm256_set1_epi32(0xFF);


  oligo = nexthigh_rev >> 22;	/* For 27..31 */
  oligo |= low_rev << 10;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask6);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
      table[positions[masked] + (--counts[masked])] = chrpos - 1;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
      table[positions[masked] + (--counts[masked])] = chrpos - 2;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
      table[positions[masked] + (--counts[masked])] = chrpos - 3;
    }
  }


  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
      table[positions[masked] + (--counts[masked])] = chrpos - 4;
    }
  }


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(low_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask6);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
      table[positions[masked] + (--counts[masked])] = chrpos - 5;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
      table[positions[masked] + (--counts[masked])] = chrpos - 6;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
      table[positions[masked] + (--counts[masked])] = chrpos - 7;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 8));
      table[positions[masked] + (--counts[masked])] = chrpos - 8;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 9));
      table[positions[masked] + (--counts[masked])] = chrpos - 9;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 10));
      table[positions[masked] + (--counts[masked])] = chrpos - 10;
    }
  }

  if (EXTRACT256(_counts,6)) {
    masked = EXTRACT256(_masked,6);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 11));
      table[positions[masked] + (--counts[masked])] = chrpos - 11;
    }
  }

  if (EXTRACT256(_counts,7)) {
    masked = EXTRACT256(_masked,7);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 12));
      table[positions[masked] + (--counts[masked])] = chrpos - 12;
    }
  }


  _oligo = _mm256_srli_epi32(_oligo, 16);
  _masked = _mm256_and_si256(_oligo, bigmask6);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 13));
      table[positions[masked] + (--counts[masked])] = chrpos - 13;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 14));
      table[positions[masked] + (--counts[masked])] = chrpos - 14;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 15));
      table[positions[masked] + (--counts[masked])] = chrpos - 15;
    }
  }


  oligo = low_rev >> 22;	/* For 15..11 */
  oligo |= high_rev << 10;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask6);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 16));
      table[positions[masked] + (--counts[masked])] = chrpos - 16;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 17));
      table[positions[masked] + (--counts[masked])] = chrpos - 17;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 18));
      table[positions[masked] + (--counts[masked])] = chrpos - 18;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 19));
      table[positions[masked] + (--counts[masked])] = chrpos - 19;
    }
  }


  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 20));
      table[positions[masked] + (--counts[masked])] = chrpos - 20;
    }
  }



  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(high_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask6);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 21));
      table[positions[masked] + (--counts[masked])] = chrpos - 21;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 22));
      table[positions[masked] + (--counts[masked])] = chrpos - 22;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 23));
      table[positions[masked] + (--counts[masked])] = chrpos - 23;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 24));
      table[positions[masked] + (--counts[masked])] = chrpos - 24;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 25));
      table[positions[masked] + (--counts[masked])] = chrpos - 25;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 26));
      table[positions[masked] + (--counts[masked])] = chrpos - 26;
    }
  }

  if (EXTRACT256(_counts,6)) {
    masked = EXTRACT256(_masked,6);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 27));
      table[positions[masked] + (--counts[masked])] = chrpos - 27;
    }
  }

  if (EXTRACT256(_counts,7)) {
    masked = EXTRACT256(_masked,7);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 28));
      table[positions[masked] + (--counts[masked])] = chrpos - 28;
    }
  }


  _oligo = _mm256_srli_epi32(_oligo, 16);
  _masked = _mm256_and_si256(_oligo, bigmask6);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 29));
      table[positions[masked] + (--counts[masked])] = chrpos - 29;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 30));
      table[positions[masked] + (--counts[masked])] = chrpos - 30;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 31));
      table[positions[masked] + (--counts[masked])] = chrpos - 31;
    }
  }

  return chrpos - 32;
}

#endif	/* HAVE_AVX2 */


#if !defined(HAVE_AVX2)

static void
count_5mers_fwd_32 (Count_T *counts, Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
#ifdef INDIVIDUAL_SHIFTS
#elif defined(SIMD_MASK_THEN_STORE)
  UINT4 _masked[4] __attribute__ ((aligned (16)));
  __m128i _oligo;
#else
  __m128i _oligo, _masked;
#endif


  oligo = nexthigh_rev >> 24;	/* For 31..28 */
  oligo |= low_rev << 8;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK5; /* 31 */
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 2) & MASK5; /* 30 */
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 4) & MASK5; /* 29 */
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 6) & MASK5; /* 28 */
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = low_rev & MASK5;	/* 27 */
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 2) & MASK5;	/* 26 */
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 4) & MASK5;	/* 25 */
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 6) & MASK5;	/* 24 */
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 8) & MASK5;	/* 23 */
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 10) & MASK5;	/* 22 */
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 12) & MASK5;	/* 21 */
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 14) & MASK5;	/* 20 */
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 16) & MASK5; /* 19 */
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 18) & MASK5; /* 18 */
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = (low_rev >> 20) & MASK5; /* 17 */
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = low_rev >> 22;		/* 16, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(low_rev, low_rev >> 2, low_rev >> 4, low_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));
#endif


  oligo = low_rev >> 24;	/* For 15..12 */
  oligo |= high_rev << 8;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK5; /* 15 */
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 2) & MASK5; /* 14 */
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 4) & MASK5; /* 13 */
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 6) & MASK5; /* 12 */
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = high_rev & MASK5;	/* 11 */
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 2) & MASK5; /* 10 */
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 4) & MASK5; /* 9 */
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 6) & MASK5; /* 8 */
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 8) & MASK5;	/* 7 */
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 10) & MASK5;	/* 6 */
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 12) & MASK5;	/* 5 */
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 14) & MASK5;	/* 4 */
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 16) & MASK5;	/* 3 */
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 18) & MASK5;	/* 2 */
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = (high_rev >> 20) & MASK5;	/* 1 */
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = high_rev >> 22;		/* 0, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));
  
#else
  _oligo = _mm_setr_epi32(high_rev, high_rev >> 2, high_rev >> 4, high_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));
#endif

  return;
}

#else	/* HAVE_AVX2 */

static void
count_5mers_fwd_32 (Count_T *counts, Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
  __m256i _oligo, _masked;


  oligo = nexthigh_rev >> 24;	/* For 31..28 */
  oligo |= low_rev << 8;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask5);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(low_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask5);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srli_epi32(_oligo, 16);
  _masked = _mm256_and_si256(_oligo, bigmask5);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));


  oligo = low_rev >> 24;	/* For 15..12 */
  oligo |= high_rev << 8;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask5);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(high_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask5);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srli_epi32(_oligo, 16);
  _masked = _mm256_and_si256(_oligo, bigmask5);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));

  return;
}

#endif  /* HAVE_AVX2 */



#ifdef HAVE_SSE2
static void
extract_5mers_fwd_simd_64 (__m128i *out, __m128i current, __m128i next) {
  __m128i oligo;

  _mm_store_si128(out++, _mm_srli_epi32(current,22)); /* No mask necessary */
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,20), mask5));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,18), mask5));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,16), mask5));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,14), mask5));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,12), mask5));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,10), mask5));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,8), mask5));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,6), mask5));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,4), mask5));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,2), mask5));
  _mm_store_si128(out++, _mm_and_si128( current, mask5));

  oligo = _mm_or_si128( _mm_srli_epi32(next,24), _mm_slli_epi32(current,8));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,6), mask5));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,4), mask5));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,2), mask5));
  _mm_store_si128(out++, _mm_and_si128( oligo, mask5));

  return;
}

#ifdef USE_UNORDERED_5
static Chrpos_T
store_5mers_fwd_simd_64 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m128i current, __m128i next) {
  __m128i array[16];
			  
  extract_5mers_fwd_simd_64(array,current,next);
  return store_fwdrev_simd_64(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_5mers_fwd_simd_64_ordered (__m128i *out, __m128i current, __m128i next) */
static Chrpos_T
store_5mers_fwd_simd_64 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m128i current, __m128i next) {
  __m128i array[16], *out;
  __m128i oligo;
  __m128i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m128i _u0, _u1, _u2, _u3;

  out = &(array[0]);

  oligo = _mm_or_si128( _mm_srli_epi32(next,24), _mm_slli_epi32(current,8));
  /* _row0 = _mm_and_si128( oligo, mask5); */
  /* _row1 = _mm_and_si128( _mm_srli_epi32(oligo,2), mask5); */
  _t0 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(oligo,14), oligo, 0x55), mask5_epi16);

  /* _row2 = _mm_and_si128( _mm_srli_epi32(oligo,4), mask5); */
  /* _row3 = _mm_and_si128( _mm_srli_epi32(oligo,6), mask5); */
  _t1 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(oligo,10), _mm_srli_epi32(oligo, 4), 0x55), mask5_epi16);


  /* _row4 = _mm_and_si128( current, mask5); */
  /* _row5 = _mm_and_si128( _mm_srli_epi32(current,2), mask5); */
  _t2 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(current,14), current, 0x55), mask5_epi16);

  /* _row6 = _mm_and_si128( _mm_srli_epi32(current,4), mask5); */
  /* _row7 = _mm_and_si128( _mm_srli_epi32(current,6), mask5); */
  _t3 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(current,10), _mm_srli_epi32(current, 4), 0x55), mask5_epi16);

  /* _row8 = _mm_and_si128( _mm_srli_epi32(current,8), mask5); */
  /* _row9 = _mm_and_si128( _mm_srli_epi32(current,10), mask5); */
  _t4 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(current,6), _mm_srli_epi32(current, 8), 0x55), mask5_epi16);

  /* _row10 = _mm_and_si128( _mm_srli_epi32(current,12), mask5); */
  /* _row11 = _mm_and_si128( _mm_srli_epi32(current,14), mask5); */
  _t5 = _mm_and_si128(_mm_blend_epi16(_mm_slli_epi32(current,2), _mm_srli_epi32(current, 12), 0x55), mask5_epi16);

  /* _row12 = _mm_and_si128( _mm_srli_epi32(current,16), mask5); */
  /* _row13 = _mm_and_si128( _mm_srli_epi32(current,18), mask5); */
  _t6 = _mm_and_si128(_mm_blend_epi16(_mm_srli_epi32(current,2), _mm_srli_epi32(current, 16), 0x55), mask5_epi16);

  /* _row14 = _mm_and_si128( _mm_srli_epi32(current,20), mask5); */
  /* _row15 = _mm_srli_epi32(current,22); */ /* No mask necessary */
  _t7 = _mm_and_si128(_mm_blend_epi16(_mm_srli_epi32(current,6), _mm_srli_epi32(current, 20), 0x55), mask5_epi16);


  /* Split: top half */
  _u0 = _mm_unpackhi_epi32(_t0,_t1);
  _u1 = _mm_unpackhi_epi32(_t2,_t3);
  _u2 = _mm_unpackhi_epi32(_t4,_t5);
  _u3 = _mm_unpackhi_epi32(_t6,_t7);

  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u0,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u1,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u2,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u3,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u0));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u1));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u2));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u3));

  /* Split: bottom half */
  _u0 = _mm_unpacklo_epi32(_t0,_t1);
  _u1 = _mm_unpacklo_epi32(_t2,_t3);
  _u2 = _mm_unpacklo_epi32(_t4,_t5);
  _u3 = _mm_unpacklo_epi32(_t6,_t7);

  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u0,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u1,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u2,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_mm_srli_si128(_u3,8)));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u0));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u1));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u2));
  _mm_store_si128(out++, _mm_cvtepu16_epi32(_u3));

  return store_fwdrev_simd_64_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif

#ifdef HAVE_AVX2
static void
extract_5mers_fwd_simd_128 (__m256i *out, __m256i current, __m256i next) {
  __m256i oligo;

  _mm256_store_si256(out++, _mm256_srli_epi32(current,22)); /* No mask necessary */
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,20), bigmask5));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,18), bigmask5));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,16), bigmask5));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,14), bigmask5));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,12), bigmask5));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,10), bigmask5));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,8), bigmask5));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,6), bigmask5));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,4), bigmask5));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,2), bigmask5));
  _mm256_store_si256(out++, _mm256_and_si256( current, bigmask5));

  oligo = _mm256_or_si256( _mm256_srli_epi32(next,24), _mm256_slli_epi32(current,8));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,6), bigmask5));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,4), bigmask5));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,2), bigmask5));
  _mm256_store_si256(out++, _mm256_and_si256( oligo, bigmask5));

  return;
}

#ifdef USE_UNORDERED_5
static Chrpos_T
store_5mers_fwd_simd_128 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m256i current, __m256i next) {
  __m256i array[16];
			  
  extract_5mers_fwd_simd_128(array,current,next);
  return store_fwdrev_simd_128(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_5mers_fwd_simd_128_ordered (__m256i *out, __m256i current, __m256i next) */
static Chrpos_T
store_5mers_fwd_simd_128 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m256i current, __m256i next) {
  __m256i array[16], *out;
  __m256i oligo;
  __m256i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m256i _u0, _u1, _u2, _u3, _u4, _u5, _u6, _u7;

  out = &(array[0]);

  oligo = _mm256_or_si256( _mm256_srli_epi32(next,24), _mm256_slli_epi32(current,8));
  /* _row0 = _mm256_and_si256( oligo, bigmask5); */
  /* _row1 = _mm256_and_si256( _mm256_srli_epi32(oligo,2), bigmask5); */
  _t0 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(oligo,14), oligo, 0x55), bigmask5_epi16);

  /* _row2 = _mm256_and_si256( _mm256_srli_epi32(oligo,4), bigmask5); */
  /* _row3 = _mm256_and_si256( _mm256_srli_epi32(oligo,6), bigmask5); */
  _t1 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(oligo,10), _mm256_srli_epi32(oligo,4), 0x55), bigmask5_epi16);


  /* _row4 = _mm256_and_si256( current, bigmask5); */
  /* _row5 = _mm256_and_si256( _mm256_srli_epi32(current,2), bigmask5); */
  _t2 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(current,14), current, 0x55), bigmask5_epi16);

  /* _row6 = _mm256_and_si256( _mm256_srli_epi32(current,4), bigmask5); */
  /* _row7 = _mm256_and_si256( _mm256_srli_epi32(current,6), bigmask5); */
  _t3 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(current,10), _mm256_srli_epi32(current,4), 0x55), bigmask5_epi16);

  /* _row8 = _mm256_and_si256( _mm256_srli_epi32(current,8), bigmask5); */
  /* _row9 = _mm256_and_si256( _mm256_srli_epi32(current,10), bigmask5); */
  _t4 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(current,6), _mm256_srli_epi32(current,8), 0x55), bigmask5_epi16);

  /* _row10 = _mm256_and_si256( _mm256_srli_epi32(current,12), bigmask5); */
  /* _row11 = _mm256_and_si256( _mm256_srli_epi32(current,14), bigmask5); */
  _t5 = _mm256_and_si256(_mm256_blend_epi16(_mm256_slli_epi32(current,2), _mm256_srli_epi32(current,12), 0x55), bigmask5_epi16);

  /* _row12 = _mm256_and_si256( _mm256_srli_epi32(current,16), bigmask5); */
  /* _row13 = _mm256_and_si256( _mm256_srli_epi32(current,18), bigmask5); */
  _t6 = _mm256_and_si256(_mm256_blend_epi16(_mm256_srli_epi32(current,2), _mm256_srli_epi32(current,16), 0x55), bigmask5_epi16);

  /* _row14 = _mm256_and_si256( _mm256_srli_epi32(current,20), bigmask5); */
  /* _row15 = _mm256_srli_epi32(current,22); */ /* No mask necessary */
  _t7 = _mm256_and_si256(_mm256_blend_epi16(_mm256_srli_epi32(current,6), _mm256_srli_epi32(current,20), 0x55), bigmask5_epi16);


  _u0 = _mm256_unpackhi_epi32(_t0,_t1);
  _u1 = _mm256_unpackhi_epi32(_t2,_t3);
  _u2 = _mm256_unpackhi_epi32(_t4,_t5);
  _u3 = _mm256_unpackhi_epi32(_t6,_t7);
  _u4 = _mm256_unpacklo_epi32(_t0,_t1);
  _u5 = _mm256_unpacklo_epi32(_t2,_t3);
  _u6 = _mm256_unpacklo_epi32(_t4,_t5);
  _u7 = _mm256_unpacklo_epi32(_t6,_t7);


  _t0 = _mm256_unpackhi_epi64(_u0,_u1);
  _t1 = _mm256_unpackhi_epi64(_u2,_u3);
  _t2 = _mm256_unpacklo_epi64(_u0,_u1);
  _t3 = _mm256_unpacklo_epi64(_u2,_u3);
  _t4 = _mm256_unpackhi_epi64(_u4,_u5);
  _t5 = _mm256_unpackhi_epi64(_u6,_u7);
  _t6 = _mm256_unpacklo_epi64(_u4,_u5);
  _t7 = _mm256_unpacklo_epi64(_u6,_u7);


  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t0,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t1,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t2,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t3,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t4,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t5,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t6,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t7,1)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t0,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t1,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t2,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t3,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t4,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t5,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t6,0)));
  _mm256_store_si256(out++, _mm256_cvtepu16_epi32(_mm256_extracti128_si256(_t7,0)));

  return store_fwdrev_simd_128_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif

#ifdef HAVE_AVX512
static void
extract_5mers_fwd_simd_256 (__m512i *out, __m512i current, __m512i next) {
  __m512i oligo;

  _mm512_store_si512(out++, _mm512_srli_epi32(current,22)); /* No mask necessary */
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,20), hugemask5));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,18), hugemask5));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,16), hugemask5));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,14), hugemask5));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,12), hugemask5));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,10), hugemask5));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,8), hugemask5));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,6), hugemask5));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,4), hugemask5));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,2), hugemask5));
  _mm512_store_si512(out++, _mm512_and_si512( current, hugemask5));

  oligo = _mm512_or_si512( _mm512_srli_epi32(next,24), _mm512_slli_epi32(current,8));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,6), hugemask5));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,4), hugemask5));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,2), hugemask5));
  _mm512_store_si512(out++, _mm512_and_si512( oligo, hugemask5));

  return;
}

#ifdef USE_UNORDERED_5
static Chrpos_T
store_5mers_fwd_simd_256 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m512i current, __m512i next) {
  __m512i array[16];
			  
  extract_5mers_fwd_simd_256(array,current,next);
  return store_fwdrev_simd_256(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_5mers_fwd_simd_256_ordered (__m512i *out, __m512i current, __m512i next) */
static Chrpos_T
store_5mers_fwd_simd_256 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m512i current, __m512i next) {
  __m512i array[16], *out;
  __m512i oligo, _shuffle0, _shuffle1, _shuffle2;
  __m512i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m512i _u0, _u1, _u2, _u3, _u4, _u5, _u6, _u7;

  out = &(array[0]);

  oligo = _mm512_or_si512( _mm512_srli_epi32(next,24), _mm512_slli_epi32(current,8));
  _u0 = _mm512_and_si512( oligo, hugemask5);
  /* _row1 = _mm512_and_si512( _mm512_srli_epi32(oligo,2), hugemask5); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(oligo,14), highmask5);
  _t0 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(oligo,4), hugemask5);
  /* _row3 = _mm512_and_si512( _mm512_srli_epi32(oligo,6), hugemask5); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(oligo,10), highmask5);
  _t1 = _mm512_or_si512(_u0, _u1);


  _u0 = _mm512_and_si512( current, hugemask5);
  /* _row5 = _mm512_and_si512( _mm512_srli_epi32(current,2), hugemask5); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(current,14), highmask5);
  _t2 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,4), hugemask5);
  /* _row7 = _mm512_and_si512( _mm512_srli_epi32(current,6), hugemask5); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(current,10), highmask5);
  _t3 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,8), hugemask5);
  /* _row9 = _mm512_and_si512( _mm512_srli_epi32(current,10), hugemask5); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(current,6), highmask5);
  _t4 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,12), hugemask5);
  /* _row11 = _mm512_and_si512( _mm512_srli_epi32(current,14), hugemask5); */
  _u1 = _mm512_and_si512( _mm512_slli_epi32(current,2), highmask5);
  _t5 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,16), hugemask5);
  /* _row13 = _mm512_and_si512( _mm512_srli_epi32(current,18), hugemask5); */
  _u1 = _mm512_and_si512( _mm512_srli_epi32(current,2), highmask5);
  _t6 = _mm512_or_si512(_u0, _u1);

  _u0 = _mm512_and_si512( _mm512_srli_epi32(current,20), hugemask5);
  /* _row15 = _mm512_srli_epi32(current,22); */ /* No mask necessary */
  _u1 = _mm512_and_si512( _mm512_srli_epi32(current,6), highmask5);
  _t7 = _mm512_or_si512(_u0, _u1);


  _u0 = _mm512_unpackhi_epi32(_t0,_t1);
  _u1 = _mm512_unpackhi_epi32(_t2,_t3);
  _u2 = _mm512_unpackhi_epi32(_t4,_t5);
  _u3 = _mm512_unpackhi_epi32(_t6,_t7);
  _u4 = _mm512_unpacklo_epi32(_t0,_t1);
  _u5 = _mm512_unpacklo_epi32(_t2,_t3);
  _u6 = _mm512_unpacklo_epi32(_t4,_t5);
  _u7 = _mm512_unpacklo_epi32(_t6,_t7);


  /* Split: top half */
  _shuffle0 = _mm512_setr_epi64(7, 8+7, 6, 8+6, 5, 8+5, 4, 8+4);
  _t0 = _mm512_permutex2var_epi64(_u0, _shuffle0, _u1);
  _t1 = _mm512_permutex2var_epi64(_u2, _shuffle0, _u3);
  _t2 = _mm512_permutex2var_epi64(_u4, _shuffle0, _u5);
  _t3 = _mm512_permutex2var_epi64(_u6, _shuffle0, _u7);


  _shuffle1 = _mm512_setr_epi64(0, 1, 8+0, 8+1, 2, 3, 8+2, 8+3);
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle1, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1))); 

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle1, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  _shuffle2 = _mm512_setr_epi64(4, 5, 8+4, 8+5, 6, 7, 8+6, 8+7);
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle2, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle2, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));


  /* Split: bottom half */
  _shuffle0 = _mm512_setr_epi64(3, 8+3, 2, 8+2, 1, 8+1, 0, 8+0);
  _t0 = _mm512_permutex2var_epi64(_u0, _shuffle0, _u1);
  _t1 = _mm512_permutex2var_epi64(_u2, _shuffle0, _u3);
  _t2 = _mm512_permutex2var_epi64(_u4, _shuffle0, _u5);
  _t3 = _mm512_permutex2var_epi64(_u6, _shuffle0, _u7);


  /* _shuffle1 = _mm512_setr_epi64(0, 1, 8+0, 8+1, 2, 3, 8+2, 8+3); */
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle1, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle1, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  /* _shuffle2 = _mm512_setr_epi64(4, 5, 8+4, 8+5, 6, 7, 8+6, 8+7); */
  _t7 = _mm512_permutex2var_epi64(_t0, _shuffle2, _t1);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  _t7 = _mm512_permutex2var_epi64(_t2, _shuffle2, _t3);
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,0)));
  _mm512_store_si512(out++, _mm512_cvtepu16_epi32(_mm512_extracti64x4_epi64(_t7,1)));

  return store_fwdrev_simd_256_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif


#if !defined(HAVE_AVX2)

static int
store_5mers_fwd_32 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
		    Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
#ifdef INDIVIDUAL_SHIFTS
#elif defined(SIMD_MASK_THEN_STORE)
  UINT4 _masked[4] __attribute__ ((aligned (16)));
  __m128i _oligo;
#else
  __m128i _oligo, _masked;
#endif


  oligo = nexthigh_rev >> 24;	/* For 31..28 */
  oligo |= low_rev << 8;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK5; /* 31 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos));
    table[positions[masked] + (--counts[masked])] = chrpos;
  }

  masked = (oligo >> 2) & MASK5; /* 30 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
    table[positions[masked] + (--counts[masked])] = chrpos - 1;
  }

  masked = (oligo >> 4) & MASK5; /* 29 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
    table[positions[masked] + (--counts[masked])] = chrpos - 2;
  }

  masked = (oligo >> 6) & MASK5; /* 28 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
    table[positions[masked] + (--counts[masked])] = chrpos - 3;
  }

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
    table[positions[masked] + (--counts[masked])] = chrpos;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
    table[positions[masked] + (--counts[masked])] = chrpos - 1;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
    table[positions[masked] + (--counts[masked])] = chrpos - 2;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
    table[positions[masked] + (--counts[masked])] = chrpos - 3;
  }
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = low_rev & MASK5;	/* 27 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
    table[positions[masked] + (--counts[masked])] = chrpos - 4;
  }

  masked = (low_rev >> 2) & MASK5;	/* 26 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
    table[positions[masked] + (--counts[masked])] = chrpos - 5;
  }

  masked = (low_rev >> 4) & MASK5;	/* 25 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
    table[positions[masked] + (--counts[masked])] = chrpos - 6;
  }

  masked = (low_rev >> 6) & MASK5;	/* 24 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
    table[positions[masked] + (--counts[masked])] = chrpos - 7;
  }

  masked = (low_rev >> 8) & MASK5;	/* 23 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 8));
    table[positions[masked] + (--counts[masked])] = chrpos - 8;
  }

  masked = (low_rev >> 10) & MASK5;	/* 22 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 9));
    table[positions[masked] + (--counts[masked])] = chrpos - 9;
  }

  masked = (low_rev >> 12) & MASK5;	/* 21 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 10));
    table[positions[masked] + (--counts[masked])] = chrpos - 10;
  }

  masked = (low_rev >> 14) & MASK5;	/* 20 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 11));
    table[positions[masked] + (--counts[masked])] = chrpos - 11;
  }

  masked = (low_rev >> 16) & MASK5; /* 19 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 12));
    table[positions[masked] + (--counts[masked])] = chrpos - 12;
  }

  masked = (low_rev >> 18) & MASK5; /* 18 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 13));
    table[positions[masked] + (--counts[masked])] = chrpos - 13;
  }

  masked = (low_rev >> 20) & MASK5; /* 17 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 14));
    table[positions[masked] + (--counts[masked])] = chrpos - 14;
  }

  masked = low_rev >> 22;		/* 16, No mask necessary */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 15));
    table[positions[masked] + (--counts[masked])] = chrpos - 15;
  }
  
#else
  _oligo = _mm_setr_epi32(low_rev, low_rev >> 2, low_rev >> 4, low_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
    table[positions[masked] + (--counts[masked])] = chrpos - 4;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
    table[positions[masked] + (--counts[masked])] = chrpos - 5;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
    table[positions[masked] + (--counts[masked])] = chrpos - 6;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
    table[positions[masked] + (--counts[masked])] = chrpos - 7;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 8));
    table[positions[masked] + (--counts[masked])] = chrpos - 8;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 9));
    table[positions[masked] + (--counts[masked])] = chrpos - 9;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 10));
    table[positions[masked] + (--counts[masked])] = chrpos - 10;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 11));
    table[positions[masked] + (--counts[masked])] = chrpos - 11;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 12));
    table[positions[masked] + (--counts[masked])] = chrpos - 12;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 13));
    table[positions[masked] + (--counts[masked])] = chrpos - 13;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 14));
    table[positions[masked] + (--counts[masked])] = chrpos - 14;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 15));
    table[positions[masked] + (--counts[masked])] = chrpos - 15;
  }
#endif


  oligo = low_rev >> 24;	/* For 15..12 */
  oligo |= high_rev << 8;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK5; /* 15 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 16));
    table[positions[masked] + (--counts[masked])] = chrpos - 16;
  }

  masked = (oligo >> 2) & MASK5; /* 14 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 17));
    table[positions[masked] + (--counts[masked])] = chrpos - 17;
  }

  masked = (oligo >> 4) & MASK5; /* 13 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 18));
    table[positions[masked] + (--counts[masked])] = chrpos - 18;
  }

  masked = (oligo >> 6) & MASK5; /* 12 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 19));
    table[positions[masked] + (--counts[masked])] = chrpos - 19;
  }

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 16));
    table[positions[masked] + (--counts[masked])] = chrpos - 16;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 17));
    table[positions[masked] + (--counts[masked])] = chrpos - 17;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 18));
    table[positions[masked] + (--counts[masked])] = chrpos - 18;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 19));
    table[positions[masked] + (--counts[masked])] = chrpos - 19;
  }
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = high_rev & MASK5;	/* 11 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 20));
    table[positions[masked] + (--counts[masked])] = chrpos - 20;
  }

  masked = (high_rev >> 2) & MASK5; /* 10 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 21));
    table[positions[masked] + (--counts[masked])] = chrpos - 21;
  }

  masked = (high_rev >> 4) & MASK5; /* 9 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 22));
    table[positions[masked] + (--counts[masked])] = chrpos - 22;
  }

  masked = (high_rev >> 6) & MASK5; /* 8 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 23));
    table[positions[masked] + (--counts[masked])] = chrpos - 23;
  }

  masked = (high_rev >> 8) & MASK5;	/* 7 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 24));
    table[positions[masked] + (--counts[masked])] = chrpos - 24;
  }

  masked = (high_rev >> 10) & MASK5;	/* 6 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 25));
    table[positions[masked] + (--counts[masked])] = chrpos - 25;
  }

  masked = (high_rev >> 12) & MASK5;	/* 5 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 26));
    table[positions[masked] + (--counts[masked])] = chrpos - 26;
  }

  masked = (high_rev >> 14) & MASK5;	/* 4 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 27));
    table[positions[masked] + (--counts[masked])] = chrpos - 27;
  }

  masked = (high_rev >> 16) & MASK5;	/* 3 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 28));
    table[positions[masked] + (--counts[masked])] = chrpos - 28;
  }

  masked = (high_rev >> 18) & MASK5;	/* 2 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 29));
    table[positions[masked] + (--counts[masked])] = chrpos - 29;
  }

  masked = (high_rev >> 20) & MASK5;	/* 1 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 30));
    table[positions[masked] + (--counts[masked])] = chrpos - 30;
  }

  masked = high_rev >> 22;		/* 0, No mask necessary */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 31));
    table[positions[masked] + (--counts[masked])] = chrpos - 31;
  }
  
#else
  _oligo = _mm_setr_epi32(high_rev, high_rev >> 2, high_rev >> 4, high_rev >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 20));
    table[positions[masked] + (--counts[masked])] = chrpos - 20;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 21));
    table[positions[masked] + (--counts[masked])] = chrpos - 21;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 22));
    table[positions[masked] + (--counts[masked])] = chrpos - 22;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 23));
    table[positions[masked] + (--counts[masked])] = chrpos - 23;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 24));
    table[positions[masked] + (--counts[masked])] = chrpos - 24;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 25));
    table[positions[masked] + (--counts[masked])] = chrpos - 25;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 26));
    table[positions[masked] + (--counts[masked])] = chrpos - 26;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 27));
    table[positions[masked] + (--counts[masked])] = chrpos - 27;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask5));
#else
  _masked = _mm_and_si128(_oligo, mask5);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 28));
    table[positions[masked] + (--counts[masked])] = chrpos - 28;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 29));
    table[positions[masked] + (--counts[masked])] = chrpos - 29;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 30));
    table[positions[masked] + (--counts[masked])] = chrpos - 30;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 31));
    table[positions[masked] + (--counts[masked])] = chrpos - 31;
  }
#endif

  return chrpos - 32;
}

#else	/* HAVE_AVX2 */

static int
store_5mers_fwd_32 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
		    Genomecomp_T high_rev, Genomecomp_T low_rev, Genomecomp_T nexthigh_rev) {
  Genomecomp_T masked, oligo;
  __m256i _oligo, _masked, _counts;
  __m256i _blocks, _envelopes, _addresses, _address_mask, _count_mask;


  _address_mask = _mm256_set1_epi32(0x3);
  _count_mask = _mm256_set1_epi32(0xFF);


  oligo = nexthigh_rev >> 24;	/* For 31..28 */
  oligo |= low_rev << 8;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask5);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
      table[positions[masked] + (--counts[masked])] = chrpos - 1;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
      table[positions[masked] + (--counts[masked])] = chrpos - 2;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
      table[positions[masked] + (--counts[masked])] = chrpos - 3;
    }
  }


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(low_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask5);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
      table[positions[masked] + (--counts[masked])] = chrpos - 4;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
      table[positions[masked] + (--counts[masked])] = chrpos - 5;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
      table[positions[masked] + (--counts[masked])] = chrpos - 6;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
      table[positions[masked] + (--counts[masked])] = chrpos - 7;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 8));
      table[positions[masked] + (--counts[masked])] = chrpos - 8;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 9));
      table[positions[masked] + (--counts[masked])] = chrpos - 9;
    }
  }

  if (EXTRACT256(_counts,6)) {
    masked = EXTRACT256(_masked,6);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 10));
      table[positions[masked] + (--counts[masked])] = chrpos - 10;
    }
  }

  if (EXTRACT256(_counts,7)) {
    masked = EXTRACT256(_masked,7);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 11));
      table[positions[masked] + (--counts[masked])] = chrpos - 11;
    }
  }


  _oligo = _mm256_srli_epi32(_oligo, 16);
  _masked = _mm256_and_si256(_oligo, bigmask5);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 12));
      table[positions[masked] + (--counts[masked])] = chrpos - 12;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 13));
      table[positions[masked] + (--counts[masked])] = chrpos - 13;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 14));
      table[positions[masked] + (--counts[masked])] = chrpos - 14;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 15));
      table[positions[masked] + (--counts[masked])] = chrpos - 15;
    }
  }


  oligo = low_rev >> 24;	/* For 15..12 */
  oligo |= high_rev << 8;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask5);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 16));
      table[positions[masked] + (--counts[masked])] = chrpos - 16;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 17));
      table[positions[masked] + (--counts[masked])] = chrpos - 17;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 18));
      table[positions[masked] + (--counts[masked])] = chrpos - 18;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 19));
      table[positions[masked] + (--counts[masked])] = chrpos - 19;
    }
  }


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(high_rev),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask5);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 20));
      table[positions[masked] + (--counts[masked])] = chrpos - 20;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 21));
      table[positions[masked] + (--counts[masked])] = chrpos - 21;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 22));
      table[positions[masked] + (--counts[masked])] = chrpos - 22;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 23));
      table[positions[masked] + (--counts[masked])] = chrpos - 23;
    }
  }

  if (EXTRACT256(_counts,4)) {
    masked = EXTRACT256(_masked,4);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 24));
      table[positions[masked] + (--counts[masked])] = chrpos - 24;
    }
  }

  if (EXTRACT256(_counts,5)) {
    masked = EXTRACT256(_masked,5);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 25));
      table[positions[masked] + (--counts[masked])] = chrpos - 25;
    }
  }

  if (EXTRACT256(_counts,6)) {
    masked = EXTRACT256(_masked,6);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 26));
      table[positions[masked] + (--counts[masked])] = chrpos - 26;
    }
  }

  if (EXTRACT256(_counts,7)) {
    masked = EXTRACT256(_masked,7);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 27));
      table[positions[masked] + (--counts[masked])] = chrpos - 27;
    }
  }


  _oligo = _mm256_srli_epi32(_oligo, 16);
  _masked = _mm256_and_si256(_oligo, bigmask5);

  _blocks = _mm256_srli_epi32(_masked,2); /* div by 4 bytes/int */
  _addresses = _mm256_and_si256(_masked,_address_mask);
  _addresses = _mm256_slli_epi32(_addresses,3); /* Multiply by 8 bits/byte */
  _envelopes = _mm256_i32gather_epi32((const int *) counts,_blocks,/*scale*/4);
  _counts = _mm256_srlv_epi32(_envelopes,_addresses); /* Puts byte on right */
  _counts = _mm256_and_si256(_counts,_count_mask);

  if (EXTRACT256(_counts,0)) {
    masked = EXTRACT256(_masked,0);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 28));
      table[positions[masked] + (--counts[masked])] = chrpos - 28;
    }
  }

  if (EXTRACT256(_counts,1)) {
    masked = EXTRACT256(_masked,1);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 29));
      table[positions[masked] + (--counts[masked])] = chrpos - 29;
    }
  }

  if (EXTRACT256(_counts,2)) {
    masked = EXTRACT256(_masked,2);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 30));
      table[positions[masked] + (--counts[masked])] = chrpos - 30;
    }
  }

  if (EXTRACT256(_counts,3)) {
    masked = EXTRACT256(_masked,3);
    if (counts[masked]) {	/* Have to re-check if there is a conflict */
      debug(printf("Storing masked %u at %u\n",masked,chrpos - 31));
      table[positions[masked] + (--counts[masked])] = chrpos - 31;
    }
  }

  return chrpos - 32;
}

#endif  /* HAVE_AVX2 */



#ifndef HAVE_SSE2

static void
count_positions_fwd_std (Count_T *counts, int indexsize, Univcoord_T left, Univcoord_T left_plus_length,
			 Genome_T genome, int genestrand) {
  int startdiscard, enddiscard;
  Genomecomp_T ptr, startptr, endptr, high_rev, low_rev, nexthigh_rev,
    low, high, nextlow;

  debug(printf("Starting count_positions_fwd_std\n"));

  if (left_plus_length < (Univcoord_T) indexsize) {
    left_plus_length = 0;
  } else {
    left_plus_length -= indexsize;
  }

  startptr = left/32U*3;
  ptr = endptr = left_plus_length/32U*3;
  startdiscard = left % 32; /* (left+pos5) % 32 */
  enddiscard = left_plus_length % 32; /* (left+pos3) % 32 */
  
  if (left_plus_length <= left) {
    /* Skip */

  } else if (startptr == endptr) {
#ifdef WORDS_BIGENDIAN
    high = Bigendian_convert_uint(genome->blocks[ptr]);
    low = Bigendian_convert_uint(genome->blocks[ptr+1]);
    nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
    high = genome->blocks[ptr];
    low = genome->blocks[ptr+1];
    nextlow = genome->blocks[ptr+4];
#endif

    if (mode == STANDARD) {
      /* Skip */
    } else if (mode == CMET_STRANDED) {
      high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
    } else if (mode == CMET_NONSTRANDED) {
      if (genestrand > 0) {
	high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
      } else {
	high = Cmet_reduce_ga(high); low = Cmet_reduce_ga(low); nextlow = Cmet_reduce_ga(nextlow);
      }
    } else if (mode == ATOI_STRANDED) {
      high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
    } else if (mode == ATOI_NONSTRANDED) {
      if (genestrand > 0) {
	high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
      } else {
	high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
      }
    } else if (mode == TTOC_STRANDED) {
      high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
    } else if (mode == TTOC_NONSTRANDED) {
      if (genestrand > 0) {
	high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
      } else {
	high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
      }
    }

    high_rev = reverse_nt[low >> 16];
    high_rev |= (reverse_nt[low & 0x0000FFFF] << 16);
    low_rev = reverse_nt[high >> 16];
    low_rev |= (reverse_nt[high & 0x0000FFFF] << 16);
    nexthigh_rev = reverse_nt[nextlow >> 16];
    nexthigh_rev |= (reverse_nt[nextlow & 0x0000FFFF] << 16);

    if (indexsize == 9) {
      count_9mers_fwd_partial(counts,high_rev,low_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 8) {
      count_8mers_fwd_partial(counts,high_rev,low_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 7) {
      count_7mers_fwd_partial(counts,high_rev,low_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 6) {
      count_6mers_fwd_partial(counts,high_rev,low_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 5) {
      count_5mers_fwd_partial(counts,high_rev,low_rev,nexthigh_rev,startdiscard,enddiscard);
    } else {
      fprintf(stderr,"indexsize %d not supported\n",indexsize);
      abort();
    }

  } else {
    /* Genome_print_blocks(genome->blocks,left,left+16); */

    /* End block */
#ifdef WORDS_BIGENDIAN
    high = Bigendian_convert_uint(genome->blocks[ptr]);
    low = Bigendian_convert_uint(genome->blocks[ptr+1]);
    nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
    high = genome->blocks[ptr];
    low = genome->blocks[ptr+1];
    nextlow = genome->blocks[ptr+4];
#endif

    if (mode == STANDARD) {
      /* Skip */
    } else if (mode == CMET_STRANDED) {
      high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
    } else if (mode == CMET_NONSTRANDED) {
      if (genestrand > 0) {
	high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
      } else {
	high = Cmet_reduce_ga(high); low = Cmet_reduce_ga(low); nextlow = Cmet_reduce_ga(nextlow);
      }
    } else if (mode == ATOI_STRANDED) {
      high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
    } else if (mode == ATOI_NONSTRANDED) {
      if (genestrand > 0) {
	high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
      } else {
	high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
      }
    } else if (mode == TTOC_STRANDED) {
      high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
    } else if (mode == TTOC_NONSTRANDED) {
      if (genestrand > 0) {
	high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
      } else {
	high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
      }
    }

    high_rev = reverse_nt[low >> 16];
    high_rev |= (reverse_nt[low & 0x0000FFFF] << 16);
    low_rev = reverse_nt[high >> 16];
    low_rev |= (reverse_nt[high & 0x0000FFFF] << 16);
    nexthigh_rev = reverse_nt[nextlow >> 16];
    nexthigh_rev |= (reverse_nt[nextlow & 0x0000FFFF] << 16);

    if (indexsize == 9) {
      count_9mers_fwd_partial(counts,high_rev,low_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 8) {
      count_8mers_fwd_partial(counts,high_rev,low_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 7) {
      count_7mers_fwd_partial(counts,high_rev,low_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 6) {
      count_6mers_fwd_partial(counts,high_rev,low_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 5) {
      count_5mers_fwd_partial(counts,high_rev,low_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else {
      abort();
    }

    /* Middle blocks */
    while (ptr > startptr + 3) {
      ptr -= 3;

#ifdef WORDS_BIGENDIAN
      high = Bigendian_convert_uint(genome->blocks[ptr]);
      low = Bigendian_convert_uint(genome->blocks[ptr+1]);
      nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
      high = genome->blocks[ptr];
      low = genome->blocks[ptr+1];
      nextlow = genome->blocks[ptr+4];
#endif

      if (mode == STANDARD) {
	/* Skip */
      } else if (mode == CMET_STRANDED) {
	high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
      } else if (mode == CMET_NONSTRANDED) {
	if (genestrand > 0) {
	  high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
	} else {
	  high = Cmet_reduce_ga(high); low = Cmet_reduce_ga(low); nextlow = Cmet_reduce_ga(nextlow);
	}
      } else if (mode == ATOI_STRANDED) {
	high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
      } else if (mode == ATOI_NONSTRANDED) {
	if (genestrand > 0) {
	  high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
	} else {
	  high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
	}
      } else if (mode == TTOC_STRANDED) {
	high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
      } else if (mode == TTOC_NONSTRANDED) {
	if (genestrand > 0) {
	  high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
	} else {
	  high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
	}
      }

      high_rev = reverse_nt[low >> 16];
      high_rev |= (reverse_nt[low & 0x0000FFFF] << 16);
      low_rev = reverse_nt[high >> 16];
      low_rev |= (reverse_nt[high & 0x0000FFFF] << 16);
      nexthigh_rev = reverse_nt[nextlow >> 16];
      nexthigh_rev |= (reverse_nt[nextlow & 0x0000FFFF] << 16);

      if (indexsize == 9) {
	count_9mers_fwd_32(counts,high_rev,low_rev,nexthigh_rev);
      } else if (indexsize == 8) {
	count_8mers_fwd_32(counts,high_rev,low_rev,nexthigh_rev);
      } else if (indexsize == 7) {
	count_7mers_fwd_32(counts,high_rev,low_rev,nexthigh_rev);
      } else if (indexsize == 6) {
	count_6mers_fwd_32(counts,high_rev,low_rev,nexthigh_rev);
      } else if (indexsize == 5) {
	count_5mers_fwd_32(counts,high_rev,low_rev,nexthigh_rev);
      } else {
	abort();
      }
    }

    ptr -= 3;

    /* Start block */
    assert(ptr == startptr);

#ifdef WORDS_BIGENDIAN
    high = Bigendian_convert_uint(genome->blocks[ptr]);
    low = Bigendian_convert_uint(genome->blocks[ptr+1]);
    nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
    high = genome->blocks[ptr];
    low = genome->blocks[ptr+1];
    nextlow = genome->blocks[ptr+4];
#endif

    if (mode == STANDARD) {
      /* Skip */
    } else if (mode == CMET_STRANDED) {
      high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
    } else if (mode == CMET_NONSTRANDED) {
      if (genestrand > 0) {
	high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
      } else {
	high = Cmet_reduce_ga(high); low = Cmet_reduce_ga(low); nextlow = Cmet_reduce_ga(nextlow);
      }
    } else if (mode == ATOI_STRANDED) {
      high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
    } else if (mode == ATOI_NONSTRANDED) {
      if (genestrand > 0) {
	high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
      } else {
	high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
      }
    } else if (mode == TTOC_STRANDED) {
      high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
    } else if (mode == TTOC_NONSTRANDED) {
      if (genestrand > 0) {
	high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
      } else {
	high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
      }
    }

    high_rev = reverse_nt[low >> 16];
    high_rev |= (reverse_nt[low & 0x0000FFFF] << 16);
    low_rev = reverse_nt[high >> 16];
    low_rev |= (reverse_nt[high & 0x0000FFFF] << 16);
    nexthigh_rev = reverse_nt[nextlow >> 16];
    nexthigh_rev |= (reverse_nt[nextlow & 0x0000FFFF] << 16);

    if (indexsize == 9) {
      count_9mers_fwd_partial(counts,high_rev,low_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 8) {
      count_8mers_fwd_partial(counts,high_rev,low_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 7) {
      count_7mers_fwd_partial(counts,high_rev,low_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 6) {
      count_6mers_fwd_partial(counts,high_rev,low_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 5) {
      count_5mers_fwd_partial(counts,high_rev,low_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else {
      fprintf(stderr,"indexsize %d not supported\n",indexsize);
      abort();
    }

  }

  return;
}
#endif


#ifdef HAVE_AVX2
static __m256i
apply_mode_fwd_256 (Genomecomp_T *block_ptr, Mode_T mode, int genestrand) {
  Genomecomp_T low0, high0, low1, high1, low2, high2, low3, high3, nextlow;

  high0 = block_ptr[0]; low0 = block_ptr[1];
  high1 = block_ptr[3]; low1 = block_ptr[4];
  high2 = block_ptr[6]; low2 = block_ptr[7];
  high3 = block_ptr[9]; low3 = block_ptr[10];
  nextlow = block_ptr[13];

  if (mode == CMET_STRANDED) {
    high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0);
    high1 = Cmet_reduce_ct(high1); low1 = Cmet_reduce_ct(low1);
    high2 = Cmet_reduce_ct(high2); low2 = Cmet_reduce_ct(low2);
    high3 = Cmet_reduce_ct(high3); low3 = Cmet_reduce_ct(low3);
    nextlow = Cmet_reduce_ct(nextlow);
  } else if (mode == CMET_NONSTRANDED) {
    if (genestrand > 0) {
      high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0);
      high1 = Cmet_reduce_ct(high1); low1 = Cmet_reduce_ct(low1);
      high2 = Cmet_reduce_ct(high2); low2 = Cmet_reduce_ct(low2);
      high3 = Cmet_reduce_ct(high3); low3 = Cmet_reduce_ct(low3);
      nextlow = Cmet_reduce_ct(nextlow);
    } else {
      high0 = Cmet_reduce_ga(high0); low0 = Cmet_reduce_ga(low0);
      high1 = Cmet_reduce_ga(high1); low1 = Cmet_reduce_ga(low1);
      high2 = Cmet_reduce_ga(high2); low2 = Cmet_reduce_ga(low2);
      high3 = Cmet_reduce_ga(high3); low3 = Cmet_reduce_ga(low3);
      nextlow = Cmet_reduce_ga(nextlow);
    }

  } else if (mode == ATOI_STRANDED) {
    high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
    high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
    high2 = Atoi_reduce_tc(high2); low2 = Atoi_reduce_tc(low2);
    high3 = Atoi_reduce_tc(high3); low3 = Atoi_reduce_tc(low3);
    nextlow = Atoi_reduce_tc(nextlow);
  } else if (mode == ATOI_NONSTRANDED) {
    if (genestrand > 0) {
      high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
      high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
      high2 = Atoi_reduce_tc(high2); low2 = Atoi_reduce_tc(low2);
      high3 = Atoi_reduce_tc(high3); low3 = Atoi_reduce_tc(low3);
      nextlow = Atoi_reduce_tc(nextlow);
    } else {
      high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
      high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
      high2 = Atoi_reduce_ag(high2); low2 = Atoi_reduce_ag(low2);
      high3 = Atoi_reduce_ag(high3); low3 = Atoi_reduce_ag(low3);
      nextlow = Atoi_reduce_ag(nextlow);
    }

  } else if (mode == TTOC_STRANDED) {
    high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
    high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
    high2 = Atoi_reduce_ag(high2); low2 = Atoi_reduce_ag(low2);
    high3 = Atoi_reduce_ag(high3); low3 = Atoi_reduce_ag(low3);
    nextlow = Atoi_reduce_ag(nextlow);
  } else if (mode == TTOC_NONSTRANDED) {
    if (genestrand > 0) {
      high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
      high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
      high2 = Atoi_reduce_ag(high2); low2 = Atoi_reduce_ag(low2);
      high3 = Atoi_reduce_ag(high3); low3 = Atoi_reduce_ag(low3);
      nextlow = Atoi_reduce_ag(nextlow);
    } else {
      high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
      high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
      high2 = Atoi_reduce_tc(high2); low2 = Atoi_reduce_tc(low2);
      high3 = Atoi_reduce_tc(high3); low3 = Atoi_reduce_tc(low3);
      nextlow = Atoi_reduce_tc(nextlow);
    }
  }

  return _mm256_set_epi32(high3,low3,high2,low2,high1,low1,high0,low0);
}
#endif



#ifdef HAVE_AVX512
static __m512i
apply_mode_fwd_512 (Genomecomp_T *block_ptr, Mode_T mode, int genestrand) {
  Genomecomp_T low0, high0, low1, high1, low2, high2, low3, high3,
    low4, high4, low5, high5, low6, high6, low7, high7, nextlow;

  high0 = block_ptr[0]; low0 = block_ptr[1];
  high1 = block_ptr[3]; low1 = block_ptr[4];
  high2 = block_ptr[6]; low2 = block_ptr[7];
  high3 = block_ptr[9]; low3 = block_ptr[10];
  
  high4 = block_ptr[12]; low4 = block_ptr[13];
  high5 = block_ptr[15]; low5 = block_ptr[16];
  high6 = block_ptr[18]; low6 = block_ptr[19];
  high7 = block_ptr[21]; low7 = block_ptr[22];
  nextlow = block_ptr[25];

  if (mode == CMET_STRANDED) {
    high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0);
    high1 = Cmet_reduce_ct(high1); low1 = Cmet_reduce_ct(low1);
    high2 = Cmet_reduce_ct(high2); low2 = Cmet_reduce_ct(low2);
    high3 = Cmet_reduce_ct(high3); low3 = Cmet_reduce_ct(low3);
    high4 = Cmet_reduce_ct(high4); low4 = Cmet_reduce_ct(low4);
    high5 = Cmet_reduce_ct(high5); low5 = Cmet_reduce_ct(low5);
    high6 = Cmet_reduce_ct(high6); low6 = Cmet_reduce_ct(low6);
    high7 = Cmet_reduce_ct(high7); low7 = Cmet_reduce_ct(low7);
    nextlow = Cmet_reduce_ct(nextlow);
  } else if (mode == CMET_NONSTRANDED) {
    if (genestrand > 0) {
      high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0);
      high1 = Cmet_reduce_ct(high1); low1 = Cmet_reduce_ct(low1);
      high2 = Cmet_reduce_ct(high2); low2 = Cmet_reduce_ct(low2);
      high3 = Cmet_reduce_ct(high3); low3 = Cmet_reduce_ct(low3);
      high4 = Cmet_reduce_ct(high4); low4 = Cmet_reduce_ct(low4);
      high5 = Cmet_reduce_ct(high5); low5 = Cmet_reduce_ct(low5);
      high6 = Cmet_reduce_ct(high6); low6 = Cmet_reduce_ct(low6);
      high7 = Cmet_reduce_ct(high7); low7 = Cmet_reduce_ct(low7);
      nextlow = Cmet_reduce_ct(nextlow);
    } else {
      high0 = Cmet_reduce_ga(high0); low0 = Cmet_reduce_ga(low0);
      high1 = Cmet_reduce_ga(high1); low1 = Cmet_reduce_ga(low1);
      high2 = Cmet_reduce_ga(high2); low2 = Cmet_reduce_ga(low2);
      high3 = Cmet_reduce_ga(high3); low3 = Cmet_reduce_ga(low3);
      high4 = Cmet_reduce_ga(high4); low0 = Cmet_reduce_ga(low4);
      high5 = Cmet_reduce_ga(high5); low1 = Cmet_reduce_ga(low5);
      high6 = Cmet_reduce_ga(high6); low2 = Cmet_reduce_ga(low6);
      high7 = Cmet_reduce_ga(high7); low3 = Cmet_reduce_ga(low7);
      nextlow = Cmet_reduce_ga(nextlow);
    }

  } else if (mode == ATOI_STRANDED) {
    high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
    high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
    high2 = Atoi_reduce_tc(high2); low2 = Atoi_reduce_tc(low2);
    high3 = Atoi_reduce_tc(high3); low3 = Atoi_reduce_tc(low3);
    high4 = Atoi_reduce_tc(high4); low4 = Atoi_reduce_tc(low4);
    high5 = Atoi_reduce_tc(high5); low5 = Atoi_reduce_tc(low5);
    high6 = Atoi_reduce_tc(high6); low6 = Atoi_reduce_tc(low6);
    high7 = Atoi_reduce_tc(high7); low7 = Atoi_reduce_tc(low7);
    nextlow = Atoi_reduce_tc(nextlow);
  } else if (mode == ATOI_NONSTRANDED) {
    if (genestrand > 0) {
      high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
      high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
      high2 = Atoi_reduce_tc(high2); low2 = Atoi_reduce_tc(low2);
      high3 = Atoi_reduce_tc(high3); low3 = Atoi_reduce_tc(low3);
      high4 = Atoi_reduce_tc(high4); low4 = Atoi_reduce_tc(low4);
      high5 = Atoi_reduce_tc(high5); low5 = Atoi_reduce_tc(low5);
      high6 = Atoi_reduce_tc(high6); low6 = Atoi_reduce_tc(low6);
      high7 = Atoi_reduce_tc(high7); low7 = Atoi_reduce_tc(low7);
      nextlow = Atoi_reduce_tc(nextlow);
    } else {
      high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
      high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
      high2 = Atoi_reduce_ag(high2); low2 = Atoi_reduce_ag(low2);
      high3 = Atoi_reduce_ag(high3); low3 = Atoi_reduce_ag(low3);
      high4 = Atoi_reduce_ag(high4); low0 = Atoi_reduce_ag(low4);
      high5 = Atoi_reduce_ag(high5); low1 = Atoi_reduce_ag(low5);
      high6 = Atoi_reduce_ag(high6); low2 = Atoi_reduce_ag(low6);
      high7 = Atoi_reduce_ag(high7); low3 = Atoi_reduce_ag(low7);
      nextlow = Atoi_reduce_ag(nextlow);
    }

  } else if (mode == TTOC_STRANDED) {
    high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
    high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
    high2 = Atoi_reduce_ag(high2); low2 = Atoi_reduce_ag(low2);
    high3 = Atoi_reduce_ag(high3); low3 = Atoi_reduce_ag(low3);
    high4 = Atoi_reduce_ag(high4); low4 = Atoi_reduce_ag(low4);
    high5 = Atoi_reduce_ag(high5); low5 = Atoi_reduce_ag(low5);
    high6 = Atoi_reduce_ag(high6); low6 = Atoi_reduce_ag(low6);
    high7 = Atoi_reduce_ag(high7); low7 = Atoi_reduce_ag(low7);
    nextlow = Atoi_reduce_ag(nextlow);
  } else if (mode == ATOI_NONSTRANDED) {
    if (genestrand > 0) {
      high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
      high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
      high2 = Atoi_reduce_ag(high2); low2 = Atoi_reduce_ag(low2);
      high3 = Atoi_reduce_ag(high3); low3 = Atoi_reduce_ag(low3);
      high4 = Atoi_reduce_ag(high4); low4 = Atoi_reduce_ag(low4);
      high5 = Atoi_reduce_ag(high5); low5 = Atoi_reduce_ag(low5);
      high6 = Atoi_reduce_ag(high6); low6 = Atoi_reduce_ag(low6);
      high7 = Atoi_reduce_ag(high7); low7 = Atoi_reduce_ag(low7);
      nextlow = Atoi_reduce_ag(nextlow);
    } else {
      high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
      high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
      high2 = Atoi_reduce_tc(high2); low2 = Atoi_reduce_tc(low2);
      high3 = Atoi_reduce_tc(high3); low3 = Atoi_reduce_tc(low3);
      high4 = Atoi_reduce_tc(high4); low0 = Atoi_reduce_tc(low4);
      high5 = Atoi_reduce_tc(high5); low1 = Atoi_reduce_tc(low5);
      high6 = Atoi_reduce_tc(high6); low2 = Atoi_reduce_tc(low6);
      high7 = Atoi_reduce_tc(high7); low3 = Atoi_reduce_tc(low7);
      nextlow = Atoi_reduce_tc(nextlow);
    }
  }

  return _mm512_set_epi32(high7,low7,high6,low6,high5,low5,high4,low4,
			  high3,low3,high2,low2,high1,low1,high0,low0);
}
#endif


#ifdef HAVE_SSE2
static void
count_positions_fwd_simd (Count_T *counts, int indexsize,
			  Univcoord_T left, Univcoord_T left_plus_length,
			  Genome_T genome, int genestrand) {
  int startdiscard, enddiscard;
  Genomecomp_T ptr, startptr, endptr, nexthigh_rev, nextlow;
  Genomecomp_T high0_rev, low0_rev, low0, high0, low1, high1;
  __m128i current, a, b, next, mask2, mask4;
  __m128i array[16];
#ifdef HAVE_SSSE3
  __m128i reverse8;
#else
  __m128i mask8;
#endif
#ifdef HAVE_SSE4_1
  /* __m128i temp; */
#else
  Genomecomp_T high1_rev, low1_rev;
#endif
#ifdef HAVE_AVX2
  __m256i array256[16];
  /* Genomecomp_T low2, high2, low3, high3; */
  __m256i current256, a256, b256, c256, d256, next256, temp256, bigmask2, bigmask4, bigreverse8;
  __m256i shift256;
#endif
#ifdef HAVE_AVX512
  __m512i array512[16];
  Genomecomp_T low4, high4, low5, high5, low6, high6, low7, high7;
  __m512i current512, a512, b512, next512, temp512, hugemask2, hugemask4;
  __m512i shift512;
  __m128i temp;
#endif


  debug(printf("Starting count_positions_fwd_simd\n"));

  if (left_plus_length < (Univcoord_T) indexsize) {
    left_plus_length = 0;
  } else {
    left_plus_length -= indexsize;
  }

  startptr = left/32U*3;
  ptr = endptr = left_plus_length/32U*3;
  startdiscard = left % 32; /* (left+pos5) % 32 */
  enddiscard = left_plus_length % 32; /* (left+pos3) % 32 */
  
  mask2 = _mm_set1_epi32(0x33333333);
  mask4 = _mm_set1_epi32(0x0F0F0F0F);
#ifdef HAVE_SSSE3
  reverse8 = _mm_set_epi8(0x0C,0x0D,0x0E,0x0F, 0x08,0x09,0x0A,0x0B, 0x04,0x05,0x06,0x07, 0x00,0x01,0x02,0x03);
#else
  mask8 = _mm_set1_epi32(0x00FF00FF);
#endif
#ifdef HAVE_AVX2
  bigmask2 = _mm256_set1_epi32(0x33333333);
  bigmask4 = _mm256_set1_epi32(0x0F0F0F0F);
  bigreverse8 = _mm256_set_epi8(0x0C,0x0D,0x0E,0x0F, 0x08,0x09,0x0A,0x0B, 0x04,0x05,0x06,0x07, 0x00,0x01,0x02,0x03,
                                0x0C,0x0D,0x0E,0x0F, 0x08,0x09,0x0A,0x0B, 0x04,0x05,0x06,0x07, 0x00,0x01,0x02,0x03);
  shift256 = _mm256_setr_epi32(1,2,3,4,5,6,7,0);
#endif
#ifdef HAVE_AVX512
  hugemask2 = _mm512_set1_epi32(0x33333333);
  hugemask4 = _mm512_set1_epi32(0x0F0F0F0F);
  /* hugereverse8 = _mm512_broadcast_i64x4(bigreverse8); */
  shift512 = _mm512_setr_epi32(1,2,3,4,5,6,7,8, 9,10,11,12,13,14,15,0);
#endif

  if (left_plus_length <= left) {
    /* Skip */

  } else if (startptr == endptr) {
#ifdef WORDS_BIGENDIAN
    high0 = Bigendian_convert_uint(genome->blocks[ptr]);
    low0 = Bigendian_convert_uint(genome->blocks[ptr+1]);
    nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
    high0 = genome->blocks[ptr];
    low0 = genome->blocks[ptr+1];
    nextlow = genome->blocks[ptr+4];
#endif

    if (mode == STANDARD) {
      /* Skip */
    } else if (mode == CMET_STRANDED) {
      high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
    } else if (mode == CMET_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
      } else {
	high0 = Cmet_reduce_ga(high0); low0 = Cmet_reduce_ga(low0); nextlow = Cmet_reduce_ga(nextlow);
      }
    } else if (mode == ATOI_STRANDED) {
      high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
    } else if (mode == ATOI_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
      } else {
	high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
      }
    } else if (mode == TTOC_STRANDED) {
      high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
    } else if (mode == TTOC_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
      } else {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
      }
    }

    current = _mm_set_epi32(0,nextlow,high0,low0);
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,2),mask2),_mm_slli_epi32(_mm_and_si128(current,mask2),2)); /* Swap pairs */
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,4),mask4),_mm_slli_epi32(_mm_and_si128(current,mask4),4)); /* Swap nibbles */
#ifdef HAVE_SSSE3
    current = _mm_shuffle_epi8(current,reverse8); /* Reverse bytes */
#else
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,8),mask8),_mm_slli_epi32(_mm_and_si128(current,mask8),8)); /* Swap bytes */
    current = _mm_or_si128(_mm_srli_epi32(current,16),_mm_slli_epi32(current,16)); /* Swap 16-bit quantities */
#endif

    /* nexthigh_rev = high0_rev; */
#ifdef HAVE_SSE4_1
    high0_rev = (unsigned int) _mm_extract_epi32(current,0);
    low0_rev = (unsigned int) _mm_extract_epi32(current,1);
    nexthigh_rev = (unsigned int) _mm_extract_epi32(current,2);
#else
    high0_rev = (reverse_nt[low0 >> 16] | reverse_nt[low0 & 0x0000FFFF] << 16);
    low0_rev = (reverse_nt[high0 >> 16] | reverse_nt[high0 & 0x0000FFFF] << 16);
    nexthigh_rev = (reverse_nt[nextlow >> 16] | reverse_nt[nextlow & 0x0000FFFF] << 16);
#endif

    if (indexsize == 9) {
      count_9mers_fwd_partial(counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 8) {
      count_8mers_fwd_partial(counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 7) {
      count_7mers_fwd_partial(counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 6) {
      count_6mers_fwd_partial(counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 5) {
      count_5mers_fwd_partial(counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,enddiscard);
    } else {
      fprintf(stderr,"indexsize %d not supported\n",indexsize);
      abort();
    }

  } else {
    /* Genome_print_blocks(genome->blocks,left,left+16); */

    /* End block */
#ifdef WORDS_BIGENDIAN
    high0 = Bigendian_convert_uint(genome->blocks[ptr]);
    low0 = Bigendian_convert_uint(genome->blocks[ptr+1]);
    nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
    high0 = genome->blocks[ptr];
    low0 = genome->blocks[ptr+1];
    nextlow = genome->blocks[ptr+4];
#endif

    if (mode == STANDARD) {
      /* Skip */
    } else if (mode == CMET_STRANDED) {
      high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
    } else if (mode == CMET_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
      } else {
	high0 = Cmet_reduce_ga(high0); low0 = Cmet_reduce_ga(low0); nextlow = Cmet_reduce_ga(nextlow);
      }
    } else if (mode == ATOI_STRANDED) {
      high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
    } else if (mode == ATOI_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
      } else {
	high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
      }
    } else if (mode == TTOC_STRANDED) {
      high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
    } else if (mode == TTOC_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
      } else {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
      }
    }

    current = _mm_set_epi32(0,nextlow,high0,low0);
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,2),mask2),_mm_slli_epi32(_mm_and_si128(current,mask2),2)); /* Swap pairs */
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,4),mask4),_mm_slli_epi32(_mm_and_si128(current,mask4),4)); /* Swap nibbles */
#ifdef HAVE_SSSE3
    current = _mm_shuffle_epi8(current,reverse8); /* Reverse bytes */
#else
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,8),mask8),_mm_slli_epi32(_mm_and_si128(current,mask8),8)); /* Swap bytes */
    current = _mm_or_si128(_mm_srli_epi32(current,16),_mm_slli_epi32(current,16)); /* Swap 16-bit quantities */
#endif

    /* nexthigh_rev = high0_rev; */
#ifdef HAVE_SSE4_1
    high0_rev = (unsigned int) _mm_extract_epi32(current,0);
    low0_rev = (unsigned int) _mm_extract_epi32(current,1);
    nexthigh_rev = (unsigned int) _mm_extract_epi32(current,2);
#else
    high0_rev = (reverse_nt[low0 >> 16] | reverse_nt[low0 & 0x0000FFFF] << 16);
    low0_rev = (reverse_nt[high0 >> 16] | reverse_nt[high0 & 0x0000FFFF] << 16);
    nexthigh_rev = (reverse_nt[nextlow >> 16] | reverse_nt[nextlow & 0x0000FFFF] << 16);
#endif

    if (indexsize == 9) {
      count_9mers_fwd_partial(counts,high0_rev,low0_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 8) {
      count_8mers_fwd_partial(counts,high0_rev,low0_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 7) {
      count_7mers_fwd_partial(counts,high0_rev,low0_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 6) {
      count_6mers_fwd_partial(counts,high0_rev,low0_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 5) {
      count_5mers_fwd_partial(counts,high0_rev,low0_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else {
      abort();
    }

    /* Middle blocks */
#ifdef HAVE_AVX512
    while (ptr > startptr + 24) {
      ptr -= 24;

      if (mode == STANDARD) {
	a512 = _mm512_loadu_si512((__m512i *) &(genome->blocks[ptr]));
	b512 = _mm512_loadu_si512((__m512i *) &(genome->blocks[ptr+7]));
	current512 = _mm512_permutex2var_epi32(a512,_mm512_setr_epi32(1, 0, 4, 3, 7, 6, 10, 9, 13, 12, 16+9, 16+8, 16+12, 16+11, 16+15, 16+14), b512);
      } else {
	current512 = apply_mode_fwd_512(&(genome->blocks[ptr]),mode,genestrand);
      }

      current512 = _mm512_or_si512(_mm512_and_si512(_mm512_srli_epi32(current512,2),hugemask2),_mm512_slli_epi32(_mm512_and_si512(current512,hugemask2),2)); /* Swap pairs */
      current512 = _mm512_or_si512(_mm512_and_si512(_mm512_srli_epi32(current512,4),hugemask4),_mm512_slli_epi32(_mm512_and_si512(current512,hugemask4),4)); /* Swap nibbles */
#ifdef HAVE_AVX512BW
      current512 = _mm512_shuffle_epi8(current512,hugereverse8); /* Reverse bytes within 128-bit lanes*/
#else
      /* Reverse bytes within 128-bit lanes*/
      current256 = _mm256_shuffle_epi8(_mm512_extracti64x4_epi64(current512,0x0),bigreverse8);
      next256 = _mm256_shuffle_epi8(_mm512_extracti64x4_epi64(current512,0x1),bigreverse8);
      current512 = _mm512_broadcast_i64x4(next256);
      current512 = _mm512_inserti64x4(current512,current256,0x0);
#endif

      nexthigh_rev = high0_rev;	/* Take from previous loop */

      current = _mm512_extracti32x4_epi32(current512,0);
      high0_rev = (unsigned int) _mm_extract_epi32(current, 0); /* Generate for next loop */
      
      temp = _mm_insert_epi32(current,nexthigh_rev,0x00);
      temp512 = _mm512_inserti32x4(current512,temp,0x00);
      next512 = _mm512_permutexvar_epi32(shift512,temp512); /* shift goes first! */

      if (indexsize == 9) {
	extract_9mers_fwd_simd_256(array512,current512,next512);
      } else if (indexsize == 8) {
	extract_8mers_fwd_simd_256(array512,current512,next512);
      } else if (indexsize == 7) {
	extract_7mers_fwd_simd_256(array512,current512,next512);
      } else if (indexsize == 6) {
	extract_6mers_fwd_simd_256(array512,current512,next512);
      } else if (indexsize == 5) {
	extract_5mers_fwd_simd_256(array512,current512,next512);
      } else {
	abort();
      }
      count_fwdrev_simd_n(counts,(Genomecomp_T *) array512,256);
    }
#endif


#ifdef HAVE_AVX2
    while (ptr > startptr + 12) {
      ptr -= 12;

      if (mode == STANDARD) {
	a256 = _mm256_loadu_si256((__m256i *) &(genome->blocks[ptr]));
	b256 = _mm256_loadu_si256((__m256i *) &(genome->blocks[ptr+3]));
	c256 = _mm256_unpacklo_epi64(a256,b256);
	d256 = _mm256_unpackhi_epi64(a256,b256);
	current256 = _mm256_permute2x128_si256(c256, d256, 0x30);
	current256 = _mm256_shuffle_epi32(current256, 0xB1); /* 0b10110001 */
      } else {
	current256 = apply_mode_fwd_256(&(genome->blocks[ptr]),mode,genestrand);
      }

      current256 = _mm256_or_si256(_mm256_and_si256(_mm256_srli_epi32(current256,2),bigmask2),_mm256_slli_epi32(_mm256_and_si256(current256,bigmask2),2)); /* Swap pairs */
      current256 = _mm256_or_si256(_mm256_and_si256(_mm256_srli_epi32(current256,4),bigmask4),_mm256_slli_epi32(_mm256_and_si256(current256,bigmask4),4)); /* Swap nibbles */
      current256 = _mm256_shuffle_epi8(current256,bigreverse8); /* Reverse bytes within 128-bit lanes*/

      nexthigh_rev = high0_rev;	/* Take from previous loop */
      high0_rev = (unsigned int) _mm256_extract_epi32(current256,0); /* Generate for next loop */

#if 0
      /* Doesn't work, because performs shift within 128-bit lanes */
      next256 = _mm256_alignr_epi8(_mm256_set1_epi32(nexthigh_rev),current256,4);
#else
      temp256 = _mm256_insert_epi32(current256,nexthigh_rev,0x00);
      next256 = _mm256_permutevar8x32_epi32(temp256,shift256);
#endif

      if (indexsize == 9) {
	extract_9mers_fwd_simd_128(array256,current256,next256);
      } else if (indexsize == 8) {
	extract_8mers_fwd_simd_128(array256,current256,next256);
      } else if (indexsize == 7) {
	extract_7mers_fwd_simd_128(array256,current256,next256);
      } else if (indexsize == 6) {
	extract_6mers_fwd_simd_128(array256,current256,next256);
      } else if (indexsize == 5) {
	extract_5mers_fwd_simd_128(array256,current256,next256);
      } else {
	abort();
      }
      count_fwdrev_simd_n(counts,(Genomecomp_T *) array256,128);
    }
#endif

    while (ptr > startptr + 6) {
      ptr -= 6;

#ifdef HAVE_SSSE3
      if (mode == STANDARD) {
	a = _mm_loadu_si128((__m128i *) &(genome->blocks[ptr]));
	b = _mm_loadu_si128((__m128i *) &(genome->blocks[ptr+3]));
	current = _mm_unpacklo_epi64(a,b);
	current = _mm_shuffle_epi32(current, 0xB1); /* 0b10110001 */
#ifndef HAVE_SSE4_1
#ifdef WORDS_BIGENDIAN
	low0 = Bigendian_convert_uint(genome->blocks[ptr+1]);
#else
	low0 = genome->blocks[ptr+1];
#endif
#endif
	
      } else {
#ifdef WORDS_BIGENDIAN
	high0 = Bigendian_convert_uint(genome->blocks[ptr]); low0 = Bigendian_convert_uint(genome->blocks[ptr+1]);
	high1 = Bigendian_convert_uint(genome->blocks[ptr+3]); low1 = Bigendian_convert_uint(genome->blocks[ptr+4]);
	nextlow = Bigendian_convert_uint(genome->blocks[ptr+7]);
#else
	high0 = genome->blocks[ptr]; low0 = genome->blocks[ptr+1];
	high1 = genome->blocks[ptr+3]; low1 = genome->blocks[ptr+4];
	nextlow = genome->blocks[ptr+7];
#endif

	if (mode == STANDARD) {
	  /* Skip */
	} else if (mode == CMET_STRANDED) {
	  high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0);
	  high1 = Cmet_reduce_ct(high1); low1 = Cmet_reduce_ct(low1);
	  nextlow = Cmet_reduce_ct(nextlow);
	} else if (mode == CMET_NONSTRANDED) {
	  if (genestrand > 0) {
	    high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0);
	    high1 = Cmet_reduce_ct(high1); low1 = Cmet_reduce_ct(low1);
	    nextlow = Cmet_reduce_ct(nextlow);
	  } else {
	    high0 = Cmet_reduce_ga(high0); low0 = Cmet_reduce_ga(low0);
	    high1 = Cmet_reduce_ga(high1); low1 = Cmet_reduce_ga(low1);
	    nextlow = Cmet_reduce_ga(nextlow);
	  }

	} else if (mode == ATOI_STRANDED) {
	  high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
	  high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
	  nextlow = Atoi_reduce_tc(nextlow);
	} else if (mode == ATOI_NONSTRANDED) {
	  if (genestrand > 0) {
	    high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
	    high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
	    nextlow = Atoi_reduce_tc(nextlow);
	  } else {
	    high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
	    high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
	    nextlow = Atoi_reduce_ag(nextlow);
	  }

	} else if (mode == TTOC_STRANDED) {
	  high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
	  high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
	  nextlow = Atoi_reduce_ag(nextlow);
	} else if (mode == TTOC_NONSTRANDED) {
	  if (genestrand > 0) {
	    high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
	    high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
	    nextlow = Atoi_reduce_ag(nextlow);
	  } else {
	    high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
	    high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
	    nextlow = Atoi_reduce_tc(nextlow);
	  }
	}

	current = _mm_set_epi32(high1,low1,high0,low0);
      }

      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,2),mask2),_mm_slli_epi32(_mm_and_si128(current,mask2),2)); /* Swap pairs */
      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,4),mask4),_mm_slli_epi32(_mm_and_si128(current,mask4),4)); /* Swap nibbles */
      current = _mm_shuffle_epi8(current,reverse8); /* Reverse bytes */

      nexthigh_rev = high0_rev;	/* Take from previous loop */
#ifdef HAVE_SSE4_1
      high0_rev = (unsigned int) _mm_extract_epi32(current,0); /* Generate for next loop (SSE4.1 and higher) */
#else
      high0_rev = (reverse_nt[low0 >> 16] | reverse_nt[low0 & 0x0000FFFF] << 16); /* Generate for next loop (SSSE3) */
#endif

#if 1
      next = _mm_alignr_epi8(_mm_set1_epi32(nexthigh_rev),current,4);
#else
      /* Previous solution for SSE4.1 */
      temp = _mm_insert_epi32(current,nexthigh_rev,0x00);
      next = _mm_shuffle_epi32(temp,0x39);
#endif


#else
      /* Non-SSSE3 */
#ifdef WORDS_BIGENDIAN
      high0 = Bigendian_convert_uint(genome->blocks[ptr]); low0 = Bigendian_convert_uint(genome->blocks[ptr+1]);
      high1 = Bigendian_convert_uint(genome->blocks[ptr+3]); low1 = Bigendian_convert_uint(genome->blocks[ptr+4]);
      nextlow = Bigendian_convert_uint(genome->blocks[ptr+7]);
#else
      high0 = genome->blocks[ptr]; low0 = genome->blocks[ptr+1];
      high1 = genome->blocks[ptr+3]; low1 = genome->blocks[ptr+4];
      nextlow = genome->blocks[ptr+7];
#endif

      if (mode == STANDARD) {
	/* Skip */
      } else if (mode == CMET_STRANDED) {
	high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0);
	high1 = Cmet_reduce_ct(high1); low1 = Cmet_reduce_ct(low1);
	nextlow = Cmet_reduce_ct(nextlow);
      } else if (mode == CMET_NONSTRANDED) {
	if (genestrand > 0) {
	  high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0);
	  high1 = Cmet_reduce_ct(high1); low1 = Cmet_reduce_ct(low1);
	  nextlow = Cmet_reduce_ct(nextlow);
	} else {
	  high0 = Cmet_reduce_ga(high0); low0 = Cmet_reduce_ga(low0);
	  high1 = Cmet_reduce_ga(high1); low1 = Cmet_reduce_ga(low1);
	  nextlow = Cmet_reduce_ga(nextlow);
	}

      } else if (mode == ATOI_STRANDED) {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
	high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
	nextlow = Atoi_reduce_tc(nextlow);
      } else if (mode == ATOI_NONSTRANDED) {
	if (genestrand > 0) {
	  high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
	  high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
	  nextlow = Atoi_reduce_tc(nextlow);
	} else {
	  high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
	  high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
	  nextlow = Atoi_reduce_ag(nextlow);
	}

      } else if (mode == TTOC_STRANDED) {
	high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
	high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
	nextlow = Atoi_reduce_ag(nextlow);
      } else if (mode == TTOC_NONSTRANDED) {
	if (genestrand > 0) {
	  high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
	  high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
	  nextlow = Atoi_reduce_ag(nextlow);
	} else {
	  high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
	  high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
	  nextlow = Atoi_reduce_tc(nextlow);
	}
      }

      current = _mm_set_epi32(high1,low1,high0,low0);

      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,2),mask2),_mm_slli_epi32(_mm_and_si128(current,mask2),2)); /* Swap pairs */
      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,4),mask4),_mm_slli_epi32(_mm_and_si128(current,mask4),4)); /* Swap nibbles */
      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,8),mask8),_mm_slli_epi32(_mm_and_si128(current,mask8),8)); /* Swap bytes */
      current = _mm_or_si128(_mm_srli_epi32(current,16),_mm_slli_epi32(current,16)); /* Swap 16-bit quantities */

      nexthigh_rev = high0_rev;	/* Take from previous loop */

      high0_rev = (reverse_nt[low0 >> 16] | reverse_nt[low0 & 0x0000FFFF] << 16); /* Generate for next loop */
      low0_rev = (reverse_nt[high0 >> 16] | reverse_nt[high0 & 0x0000FFFF] << 16);
      high1_rev = (reverse_nt[low1 >> 16] | reverse_nt[low1 & 0x0000FFFF] << 16);
      low1_rev = (reverse_nt[high1 >> 16] | reverse_nt[high1 & 0x0000FFFF] << 16);

      next = _mm_setr_epi32(low0_rev,high1_rev,low1_rev,nexthigh_rev);
#endif

      if (indexsize == 9) {
	extract_9mers_fwd_simd_64(array,current,next);
      } else if (indexsize == 8) {
	extract_8mers_fwd_simd_64(array,current,next);
      } else if (indexsize == 7) {
	extract_7mers_fwd_simd_64(array,current,next);
      } else if (indexsize == 6) {
	extract_6mers_fwd_simd_64(array,current,next);
      } else if (indexsize == 5) {
	extract_5mers_fwd_simd_64(array,current,next);
      } else {
	abort();
      }
      count_fwdrev_simd_n(counts,(Genomecomp_T *) array,64);
    }

    if (ptr > startptr + 3) {
      ptr -= 3;

#ifdef WORDS_BIGENDIAN
      high0 = Bigendian_convert_uint(genome->blocks[ptr]);
      low0 = Bigendian_convert_uint(genome->blocks[ptr+1]);
      nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
      high0 = genome->blocks[ptr];
      low0 = genome->blocks[ptr+1];
      nextlow = genome->blocks[ptr+4];
#endif

      if (mode == STANDARD) {
	/* Skip */
      } else if (mode == CMET_STRANDED) {
	high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
      } else if (mode == CMET_NONSTRANDED) {
	if (genestrand > 0) {
	  high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
	} else {
	  high0 = Cmet_reduce_ga(high0); low0 = Cmet_reduce_ga(low0); nextlow = Cmet_reduce_ga(nextlow);
	}
      } else if (mode == ATOI_STRANDED) {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
      } else if (mode == ATOI_NONSTRANDED) {
	if (genestrand > 0) {
	  high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
	} else {
	  high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
	}
      } else if (mode == TTOC_STRANDED) {
	high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
      } else if (mode == TTOC_NONSTRANDED) {
	if (genestrand > 0) {
	  high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
	} else {
	  high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
	}
      }

      current = _mm_set_epi32(0,nextlow,high0,low0);
      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,2),mask2),_mm_slli_epi32(_mm_and_si128(current,mask2),2)); /* Swap pairs */
      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,4),mask4),_mm_slli_epi32(_mm_and_si128(current,mask4),4)); /* Swap nibbles */
#ifdef HAVE_SSSE3
      current = _mm_shuffle_epi8(current,reverse8); /* Reverse bytes */
#else
      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,8),mask8),_mm_slli_epi32(_mm_and_si128(current,mask8),8)); /* Swap bytes */
      current = _mm_or_si128(_mm_srli_epi32(current,16),_mm_slli_epi32(current,16)); /* Swap 16-bit quantities */
#endif

      /* nexthigh_rev = high0_rev; */
#ifdef HAVE_SSE4_1
      high0_rev = (unsigned int) _mm_extract_epi32(current,0);
      low0_rev = (unsigned int) _mm_extract_epi32(current,1);
      nexthigh_rev = (unsigned int) _mm_extract_epi32(current,2);
#else
      high0_rev = (reverse_nt[low0 >> 16] | reverse_nt[low0 & 0x0000FFFF] << 16);
      low0_rev = (reverse_nt[high0 >> 16] | reverse_nt[high0 & 0x0000FFFF] << 16);
      nexthigh_rev = (reverse_nt[nextlow >> 16] | reverse_nt[nextlow & 0x0000FFFF] << 16);
#endif
      
      if (indexsize == 9) {
	count_9mers_fwd_32(counts,high0_rev,low0_rev,nexthigh_rev);
      } else if (indexsize == 8) {
	count_8mers_fwd_32(counts,high0_rev,low0_rev,nexthigh_rev);
      } else if (indexsize == 7) {
	count_7mers_fwd_32(counts,high0_rev,low0_rev,nexthigh_rev);
      } else if (indexsize == 6) {
	count_6mers_fwd_32(counts,high0_rev,low0_rev,nexthigh_rev);
      } else if (indexsize == 5) {
	count_5mers_fwd_32(counts,high0_rev,low0_rev,nexthigh_rev);
      } else {
	abort();
      }
    }

    ptr -= 3;

    /* Start block */
    assert(ptr == startptr);

#ifdef WORDS_BIGENDIAN
    high0 = Bigendian_convert_uint(genome->blocks[ptr]);
    low0 = Bigendian_convert_uint(genome->blocks[ptr+1]);
    nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
    high0 = genome->blocks[ptr];
    low0 = genome->blocks[ptr+1];
    nextlow = genome->blocks[ptr+4];
#endif

    if (mode == STANDARD) {
      /* Skip */
    } else if (mode == CMET_STRANDED) {
      high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
    } else if (mode == CMET_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
      } else {
	high0 = Cmet_reduce_ga(high0); low0 = Cmet_reduce_ga(low0); nextlow = Cmet_reduce_ga(nextlow);
      }
    } else if (mode == ATOI_STRANDED) {
      high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
    } else if (mode == ATOI_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
      } else {
	high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
      }
    } else if (mode == TTOC_STRANDED) {
      high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
    } else if (mode == TTOC_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
      } else {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
      }
    }

    current = _mm_set_epi32(0,nextlow,high0,low0);
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,2),mask2),_mm_slli_epi32(_mm_and_si128(current,mask2),2)); /* Swap pairs */
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,4),mask4),_mm_slli_epi32(_mm_and_si128(current,mask4),4)); /* Swap nibbles */
#ifdef HAVE_SSSE3
    current = _mm_shuffle_epi8(current,reverse8); /* Reverse bytes */
#else
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,8),mask8),_mm_slli_epi32(_mm_and_si128(current,mask8),8)); /* Swap bytes */
    current = _mm_or_si128(_mm_srli_epi32(current,16),_mm_slli_epi32(current,16)); /* Swap 16-bit quantities */
#endif

    /* nexthigh_rev = high0_rev; */
#ifdef HAVE_SSE4_1
    high0_rev = (unsigned int) _mm_extract_epi32(current,0);
    low0_rev = (unsigned int) _mm_extract_epi32(current,1);
    nexthigh_rev = (unsigned int) _mm_extract_epi32(current,2);
#else
    high0_rev = (reverse_nt[low0 >> 16] | reverse_nt[low0 & 0x0000FFFF] << 16);
    low0_rev = (reverse_nt[high0 >> 16] | reverse_nt[high0 & 0x0000FFFF] << 16);
    nexthigh_rev = (reverse_nt[nextlow >> 16] | reverse_nt[nextlow & 0x0000FFFF] << 16);
#endif

    if (indexsize == 9) {
      count_9mers_fwd_partial(counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 8) {
      count_8mers_fwd_partial(counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 7) {
      count_7mers_fwd_partial(counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 6) {
      count_6mers_fwd_partial(counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 5) {
      count_5mers_fwd_partial(counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else {
      fprintf(stderr,"indexsize %d not supported\n",indexsize);
      abort();
    }
  }
  
  return;
}

#endif


#ifndef HAVE_SSE2
static void
store_positions_fwd_std (Chrpos_T *table, UINT4 *positions, Count_T *counts, int indexsize,
			 Univcoord_T left, Univcoord_T left_plus_length, Chrpos_T chrpos,
			 Genome_T genome, int genestrand) {
  int startdiscard, enddiscard;
  Genomecomp_T ptr, startptr, endptr, high_rev, low_rev, nexthigh_rev,
    low, high, nextlow;


  if (left_plus_length < (Univcoord_T) indexsize) {
    left_plus_length = 0;
  } else {
    left_plus_length -= indexsize;
  }
  chrpos += (left_plus_length - left); /* We are starting from the right */

  startptr = left/32U*3;
  ptr = endptr = left_plus_length/32U*3;
  startdiscard = left % 32; /* (left+pos5) % 32 */
  enddiscard = left_plus_length % 32; /* (left+pos3) % 32 */
  
  if (left_plus_length <= left) {
    /* Skip */

  } else if (startptr == endptr) {
#ifdef WORDS_BIGENDIAN
    high = Bigendian_convert_uint(genome->blocks[ptr]);
    low = Bigendian_convert_uint(genome->blocks[ptr+1]);
    nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
    high = genome->blocks[ptr];
    low = genome->blocks[ptr+1];
    nextlow = genome->blocks[ptr+4];
#endif

    if (mode == STANDARD) {
      /* Skip */
    } else if (mode == CMET_STRANDED) {
      high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
    } else if (mode == CMET_NONSTRANDED) {
      if (genestrand > 0) {
	high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
      } else {
	high = Cmet_reduce_ga(high); low = Cmet_reduce_ga(low); nextlow = Cmet_reduce_ga(nextlow);
      }
    } else if (mode == ATOI_STRANDED) {
      high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
    } else if (mode == ATOI_NONSTRANDED) {
      if (genestrand > 0) {
	high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
      } else {
	high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
      }
    } else if (mode == TTOC_STRANDED) {
      high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
    } else if (mode == TTOC_NONSTRANDED) {
      if (genestrand > 0) {
	high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
      } else {
	high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
      }
    }

    high_rev = reverse_nt[low >> 16];
    high_rev |= (reverse_nt[low & 0x0000FFFF] << 16);
    low_rev = reverse_nt[high >> 16];
    low_rev |= (reverse_nt[high & 0x0000FFFF] << 16);
    nexthigh_rev = reverse_nt[nextlow >> 16];
    nexthigh_rev |= (reverse_nt[nextlow & 0x0000FFFF] << 16);

    if (indexsize == 9) {
      chrpos = store_9mers_fwd_partial(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 8) {
      chrpos = store_8mers_fwd_partial(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 7) {
      chrpos = store_7mers_fwd_partial(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 6) {
      chrpos = store_6mers_fwd_partial(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 5) {
      chrpos = store_5mers_fwd_partial(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev,startdiscard,enddiscard);
    } else {
      fprintf(stderr,"indexsize %d not supported\n",indexsize);
      abort();
    }

  } else {
    /* Genome_print_blocks(genome->blocks,left,left+16); */

    /* End block */
#ifdef WORDS_BIGENDIAN
    high = Bigendian_convert_uint(genome->blocks[ptr]);
    low = Bigendian_convert_uint(genome->blocks[ptr+1]);
    nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
    high = genome->blocks[ptr];
    low = genome->blocks[ptr+1];
    nextlow = genome->blocks[ptr+4];
#endif

    if (mode == STANDARD) {
      /* Skip */
    } else if (mode == CMET_STRANDED) {
      high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
    } else if (mode == CMET_NONSTRANDED) {
      if (genestrand > 0) {
	high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
      } else {
	high = Cmet_reduce_ga(high); low = Cmet_reduce_ga(low); nextlow = Cmet_reduce_ga(nextlow);
      }
    } else if (mode == ATOI_STRANDED) {
      high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
    } else if (mode == ATOI_NONSTRANDED) {
      if (genestrand > 0) {
	high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
      } else {
	high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
      }
    } else if (mode == TTOC_STRANDED) {
      high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
    } else if (mode == TTOC_NONSTRANDED) {
      if (genestrand > 0) {
	high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
      } else {
	high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
      }
    }

    high_rev = reverse_nt[low >> 16];
    high_rev |= (reverse_nt[low & 0x0000FFFF] << 16);
    low_rev = reverse_nt[high >> 16];
    low_rev |= (reverse_nt[high & 0x0000FFFF] << 16);
    nexthigh_rev = reverse_nt[nextlow >> 16];
    nexthigh_rev |= (reverse_nt[nextlow & 0x0000FFFF] << 16);

    if (indexsize == 9) {
      chrpos = store_9mers_fwd_partial(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 8) {
      chrpos = store_8mers_fwd_partial(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 7) {
      chrpos = store_7mers_fwd_partial(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 6) {
      chrpos = store_6mers_fwd_partial(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 5) {
      chrpos = store_5mers_fwd_partial(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else {
      abort();
    }

    while (ptr > startptr + 3) {
      ptr -= 3;

#ifdef WORDS_BIGENDIAN
      high = Bigendian_convert_uint(genome->blocks[ptr]);
      low = Bigendian_convert_uint(genome->blocks[ptr+1]);
      nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
      high = genome->blocks[ptr];
      low = genome->blocks[ptr+1];
      nextlow = genome->blocks[ptr+4];
#endif

      if (mode == STANDARD) {
	/* Skip */
      } else if (mode == CMET_STRANDED) {
	high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
      } else if (mode == CMET_NONSTRANDED) {
	if (genestrand > 0) {
	  high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
	} else {
	  high = Cmet_reduce_ga(high); low = Cmet_reduce_ga(low); nextlow = Cmet_reduce_ga(nextlow);
	}
      } else if (mode == ATOI_STRANDED) {
	high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
      } else if (mode == ATOI_NONSTRANDED) {
	if (genestrand > 0) {
	  high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
	} else {
	  high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
	}
      } else if (mode == TTOC_STRANDED) {
	high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
      } else if (mode == TTOC_NONSTRANDED) {
	if (genestrand > 0) {
	  high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
	} else {
	  high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
	}
      }

      high_rev = reverse_nt[low >> 16];
      high_rev |= (reverse_nt[low & 0x0000FFFF] << 16);
      low_rev = reverse_nt[high >> 16];
      low_rev |= (reverse_nt[high & 0x0000FFFF] << 16);
      nexthigh_rev = reverse_nt[nextlow >> 16];
      nexthigh_rev |= (reverse_nt[nextlow & 0x0000FFFF] << 16);
      
      if (indexsize == 9) {
	chrpos = store_9mers_fwd_32(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev);
      } else if (indexsize == 8) {
	chrpos = store_8mers_fwd_32(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev);
      } else if (indexsize == 7) {
	chrpos = store_7mers_fwd_32(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev);
      } else if (indexsize == 6) {
	chrpos = store_6mers_fwd_32(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev);
      } else if (indexsize == 5) {
	chrpos = store_5mers_fwd_32(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev);
      } else {
	abort();
      }
    }

    ptr -= 3;

    /* Start block */
    assert(ptr == startptr);

#ifdef WORDS_BIGENDIAN
    high = Bigendian_convert_uint(genome->blocks[ptr]);
    low = Bigendian_convert_uint(genome->blocks[ptr+1]);
    nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
    high = genome->blocks[ptr];
    low = genome->blocks[ptr+1];
    nextlow = genome->blocks[ptr+4];
#endif

    if (mode == STANDARD) {
      /* Skip */
    } else if (mode == CMET_STRANDED) {
      high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
    } else if (mode == CMET_NONSTRANDED) {
      if (genestrand > 0) {
	high = Cmet_reduce_ct(high); low = Cmet_reduce_ct(low); nextlow = Cmet_reduce_ct(nextlow);
      } else {
	high = Cmet_reduce_ga(high); low = Cmet_reduce_ga(low); nextlow = Cmet_reduce_ga(nextlow);
      }
    } else if (mode == ATOI_STRANDED) {
      high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
    } else if (mode == ATOI_NONSTRANDED) {
      if (genestrand > 0) {
	high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
      } else {
	high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
      }
    } else if (mode == TTOC_STRANDED) {
      high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
    } else if (mode == TTOC_NONSTRANDED) {
      if (genestrand > 0) {
	high = Atoi_reduce_ag(high); low = Atoi_reduce_ag(low); nextlow = Atoi_reduce_ag(nextlow);
      } else {
	high = Atoi_reduce_tc(high); low = Atoi_reduce_tc(low); nextlow = Atoi_reduce_tc(nextlow);
      }
    }

    high_rev = reverse_nt[low >> 16];
    high_rev |= (reverse_nt[low & 0x0000FFFF] << 16);
    low_rev = reverse_nt[high >> 16];
    low_rev |= (reverse_nt[high & 0x0000FFFF] << 16);
    nexthigh_rev = reverse_nt[nextlow >> 16];
    nexthigh_rev |= (reverse_nt[nextlow & 0x0000FFFF] << 16);

    if (indexsize == 9) {
      chrpos = store_9mers_fwd_partial(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 8) {
      chrpos = store_8mers_fwd_partial(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 7) {
      chrpos = store_7mers_fwd_partial(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 6) {
      chrpos = store_6mers_fwd_partial(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 5) {
      chrpos = store_5mers_fwd_partial(chrpos,table,positions,counts,high_rev,low_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else {
      fprintf(stderr,"indexsize %d not supported\n",indexsize);
      abort();
    }

  }
  
  return;
}
#endif


#ifdef HAVE_SSE2
static void
store_positions_fwd_simd (Chrpos_T *table, UINT4 *positions, Count_T *counts, int indexsize,
			  Univcoord_T left, Univcoord_T left_plus_length, Chrpos_T chrpos,
			  Genome_T genome, int genestrand) {
  int startdiscard, enddiscard;
  Genomecomp_T ptr, startptr, endptr, nexthigh_rev, nextlow;
  Genomecomp_T high0_rev, low0_rev, low0, high0, low1, high1;
  __m128i current, a, b, next, mask2, mask4;
#ifdef HAVE_SSSE3
  __m128i reverse8;
#else
  __m128i mask8;
#endif
#ifdef HAVE_SSE4_1
  /* __m128i temp; */
#else
  Genomecomp_T high1_rev, low1_rev;
#endif
#ifdef HAVE_AVX2
  /* Genomecomp_T low2, high2, low3, high3; */
  __m256i current256, a256, b256, c256, d256, next256, temp256, bigmask2, bigmask4, bigreverse8;
  __m256i shift256;
#endif
#ifdef HAVE_AVX512
  Genomecomp_T low4, high4, low5, high5, low6, high6, low7, high7;
  __m512i current512, a512, b512, next512, temp512, hugemask2, hugemask4;
  __m512i shift512;
  __m128i temp;
#endif


  debug(printf("Starting store_positions_fwd_simd\n"));

  if (left_plus_length < (Univcoord_T) indexsize) {
    left_plus_length = 0;
  } else {
    left_plus_length -= indexsize;
  }
  chrpos += (left_plus_length - left); /* We are starting from the right */

  startptr = left/32U*3;
  ptr = endptr = left_plus_length/32U*3;
  startdiscard = left % 32; /* (left+pos5) % 32 */
  enddiscard = left_plus_length % 32; /* (left+pos3) % 32 */
  
  mask2 = _mm_set1_epi32(0x33333333);
  mask4 = _mm_set1_epi32(0x0F0F0F0F);
#ifdef HAVE_SSSE3
  reverse8 = _mm_set_epi8(0x0C,0x0D,0x0E,0x0F, 0x08,0x09,0x0A,0x0B, 0x04,0x05,0x06,0x07, 0x00,0x01,0x02,0x03);
#else
  mask8 = _mm_set1_epi32(0x00FF00FF);
#endif
#ifdef HAVE_AVX2
  bigmask2 = _mm256_set1_epi32(0x33333333);
  bigmask4 = _mm256_set1_epi32(0x0F0F0F0F);
  bigreverse8 = _mm256_set_epi8(0x0C,0x0D,0x0E,0x0F, 0x08,0x09,0x0A,0x0B, 0x04,0x05,0x06,0x07, 0x00,0x01,0x02,0x03,
                                0x0C,0x0D,0x0E,0x0F, 0x08,0x09,0x0A,0x0B, 0x04,0x05,0x06,0x07, 0x00,0x01,0x02,0x03);
  shift256 = _mm256_setr_epi32(1,2,3,4,5,6,7,0);
#endif
#ifdef HAVE_AVX512
  hugemask2 = _mm512_set1_epi32(0x33333333);
  hugemask4 = _mm512_set1_epi32(0x0F0F0F0F);
  shift512 = _mm512_setr_epi32(1,2,3,4,5,6,7,8, 9,10,11,12,13,14,15,0);
#endif

  if (left_plus_length <= left) {
    /* Skip */

  } else if (startptr == endptr) {
#ifdef WORDS_BIGENDIAN
    high0 = Bigendian_convert_uint(genome->blocks[ptr]);
    low0 = Bigendian_convert_uint(genome->blocks[ptr+1]);
    nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
    high0 = genome->blocks[ptr];
    low0 = genome->blocks[ptr+1];
    nextlow = genome->blocks[ptr+4];
#endif

    if (mode == STANDARD) {
      /* Skip */
    } else if (mode == CMET_STRANDED) {
      high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
    } else if (mode == CMET_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
      } else {
	high0 = Cmet_reduce_ga(high0); low0 = Cmet_reduce_ga(low0); nextlow = Cmet_reduce_ga(nextlow);
      }
    } else if (mode == ATOI_STRANDED) {
      high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
    } else if (mode == ATOI_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
      } else {
	high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
      }
    } else if (mode == TTOC_STRANDED) {
      high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
    } else if (mode == TTOC_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
      } else {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
      }
    }

    current = _mm_set_epi32(0,nextlow,high0,low0);
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,2),mask2),_mm_slli_epi32(_mm_and_si128(current,mask2),2)); /* Swap pairs */
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,4),mask4),_mm_slli_epi32(_mm_and_si128(current,mask4),4)); /* Swap nibbles */
#ifdef HAVE_SSSE3
    current = _mm_shuffle_epi8(current,reverse8); /* Reverse bytes */
#else
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,8),mask8),_mm_slli_epi32(_mm_and_si128(current,mask8),8)); /* Swap bytes */
    current = _mm_or_si128(_mm_srli_epi32(current,16),_mm_slli_epi32(current,16)); /* Swap 16-bit quantities */
#endif

    /* nexthigh_rev = high0_rev; */
#ifdef HAVE_SSE4_1
    high0_rev = (unsigned int) _mm_extract_epi32(current,0);
    low0_rev = (unsigned int) _mm_extract_epi32(current,1);
    nexthigh_rev = (unsigned int) _mm_extract_epi32(current,2);
#else
    high0_rev = (reverse_nt[low0 >> 16] | reverse_nt[low0 & 0x0000FFFF] << 16);
    low0_rev = (reverse_nt[high0 >> 16] | reverse_nt[high0 & 0x0000FFFF] << 16);
    nexthigh_rev = (reverse_nt[nextlow >> 16] | reverse_nt[nextlow & 0x0000FFFF] << 16);
#endif

    if (indexsize == 9) {
      /* chrpos = */ store_9mers_fwd_partial(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 8) {
      /* chrpos = */ store_8mers_fwd_partial(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 7) {
      /* chrpos = */ store_7mers_fwd_partial(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 6) {
      /* chrpos = */ store_6mers_fwd_partial(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,enddiscard);
    } else if (indexsize == 5) {
      /* chrpos = */ store_5mers_fwd_partial(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,enddiscard);
    } else {
      fprintf(stderr,"indexsize %d not supported\n",indexsize);
      abort();
    }

  } else {
    /* Genome_print_blocks(genome->blocks,left,left+16); */

    /* End block */
#ifdef WORDS_BIGENDIAN
    high0 = Bigendian_convert_uint(genome->blocks[ptr]);
    low0 = Bigendian_convert_uint(genome->blocks[ptr+1]);
    nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
    high0 = genome->blocks[ptr];
    low0 = genome->blocks[ptr+1];
    nextlow = genome->blocks[ptr+4];
#endif

    if (mode == STANDARD) {
      /* Skip */
    } else if (mode == CMET_STRANDED) {
      high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
    } else if (mode == CMET_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
      } else {
	high0 = Cmet_reduce_ga(high0); low0 = Cmet_reduce_ga(low0); nextlow = Cmet_reduce_ga(nextlow);
      }
    } else if (mode == ATOI_STRANDED) {
      high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
    } else if (mode == ATOI_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
      } else {
	high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
      }
    } else if (mode == TTOC_STRANDED) {
      high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
    } else if (mode == TTOC_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
      } else {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
      }
    }

    current = _mm_set_epi32(0,nextlow,high0,low0);
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,2),mask2),_mm_slli_epi32(_mm_and_si128(current,mask2),2)); /* Swap pairs */
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,4),mask4),_mm_slli_epi32(_mm_and_si128(current,mask4),4)); /* Swap nibbles */
#ifdef HAVE_SSSE3
    current = _mm_shuffle_epi8(current,reverse8); /* Reverse bytes */
#else
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,8),mask8),_mm_slli_epi32(_mm_and_si128(current,mask8),8)); /* Swap bytes */
    current = _mm_or_si128(_mm_srli_epi32(current,16),_mm_slli_epi32(current,16)); /* Swap 16-bit quantities */
#endif

    /* nexthigh_rev = high0_rev; */
#ifdef HAVE_SSE4_1
    high0_rev = (unsigned int) _mm_extract_epi32(current,0);
    low0_rev = (unsigned int) _mm_extract_epi32(current,1);
    nexthigh_rev = (unsigned int) _mm_extract_epi32(current,2);
#else
    high0_rev = (reverse_nt[low0 >> 16] | reverse_nt[low0 & 0x0000FFFF] << 16);
    low0_rev = (reverse_nt[high0 >> 16] | reverse_nt[high0 & 0x0000FFFF] << 16);
    nexthigh_rev = (reverse_nt[nextlow >> 16] | reverse_nt[nextlow & 0x0000FFFF] << 16);
#endif

    if (indexsize == 9) {
      chrpos = store_9mers_fwd_partial(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 8) {
      chrpos = store_8mers_fwd_partial(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 7) {
      chrpos = store_7mers_fwd_partial(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 6) {
      chrpos = store_6mers_fwd_partial(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else if (indexsize == 5) {
      chrpos = store_5mers_fwd_partial(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev,/*startdiscard*/0,enddiscard);
    } else {
      abort();
    }

    /* Middle blocks */
#ifdef HAVE_AVX512
    while (ptr > startptr + 24) {
      ptr -= 24;

      if (mode == STANDARD) {
	a512 = _mm512_loadu_si512((__m512i *) &(genome->blocks[ptr]));
	b512 = _mm512_loadu_si512((__m512i *) &(genome->blocks[ptr+7]));
	current512 = _mm512_permutex2var_epi32(a512,_mm512_setr_epi32(1, 0, 4, 3, 7, 6, 10, 9, 13, 12, 16+9, 16+8, 16+12, 16+11, 16+15, 16+14), b512);
      } else {
	current512 = apply_mode_fwd_512(&(genome->blocks[ptr]),mode,genestrand);
      }

      current512 = _mm512_or_si512(_mm512_and_si512(_mm512_srli_epi32(current512,2),hugemask2),_mm512_slli_epi32(_mm512_and_si512(current512,hugemask2),2)); /* Swap pairs */
      current512 = _mm512_or_si512(_mm512_and_si512(_mm512_srli_epi32(current512,4),hugemask4),_mm512_slli_epi32(_mm512_and_si512(current512,hugemask4),4)); /* Swap nibbles */
#ifdef HAVE_AVX512BW
      current512 = _mm512_shuffle_epi8(current512,hugereverse8); /* Reverse bytes within 128-bit lanes*/
#else
      /* Reverse bytes within 128-bit lanes*/
      current256 = _mm256_shuffle_epi8(_mm512_extracti64x4_epi64(current512,0x0),bigreverse8);
      next256 = _mm256_shuffle_epi8(_mm512_extracti64x4_epi64(current512,0x1),bigreverse8);
      current512 = _mm512_broadcast_i64x4(next256);
      current512 = _mm512_inserti64x4(current512,current256,0x0);
#endif

      nexthigh_rev = high0_rev;	/* Take from previous loop */

      current = _mm512_extracti32x4_epi32(current512,0);
      high0_rev = (unsigned int) _mm_extract_epi32(current, 0); /* Generate for next loop */
      
      temp = _mm_insert_epi32(current,nexthigh_rev,0x00);
      temp512 = _mm512_inserti32x4(current512,temp,0x00);
      next512 = _mm512_permutexvar_epi32(shift512,temp512); /* shift goes first! */

      if (indexsize == 9) {
	chrpos = store_9mers_fwd_simd_256(chrpos,table,positions,counts,current512,next512);
      } else if (indexsize == 8) {
	chrpos = store_8mers_fwd_simd_256(chrpos,table,positions,counts,current512,next512);
      } else if (indexsize == 7) {
	chrpos = store_7mers_fwd_simd_256(chrpos,table,positions,counts,current512,next512);
      } else if (indexsize == 6) {
	chrpos = store_6mers_fwd_simd_256(chrpos,table,positions,counts,current512,next512);
      } else if (indexsize == 5) {
	chrpos = store_5mers_fwd_simd_256(chrpos,table,positions,counts,current512,next512);
      } else {
	abort();
      }
    }
#endif


#ifdef HAVE_AVX2
    while (ptr > startptr + 12) {
      ptr -= 12;

      if (mode == STANDARD) {
	a256 = _mm256_loadu_si256((__m256i *) &(genome->blocks[ptr]));
	b256 = _mm256_loadu_si256((__m256i *) &(genome->blocks[ptr+3]));
	c256 = _mm256_unpacklo_epi64(a256,b256);
	d256 = _mm256_unpackhi_epi64(a256,b256);
	current256 = _mm256_permute2x128_si256(c256, d256, 0x30);
	current256 = _mm256_shuffle_epi32(current256, 0xB1); /* 0b10110001 */
      } else {
	current256 = apply_mode_fwd_256(&(genome->blocks[ptr]),mode,genestrand);
      }

      current256 = _mm256_or_si256(_mm256_and_si256(_mm256_srli_epi32(current256,2),bigmask2),_mm256_slli_epi32(_mm256_and_si256(current256,bigmask2),2)); /* Swap pairs */
      current256 = _mm256_or_si256(_mm256_and_si256(_mm256_srli_epi32(current256,4),bigmask4),_mm256_slli_epi32(_mm256_and_si256(current256,bigmask4),4)); /* Swap nibbles */
      current256 = _mm256_shuffle_epi8(current256,bigreverse8); /* Reverse bytes within 128-bit lanes */
      
      nexthigh_rev = high0_rev;	/* Take from previous loop */
      high0_rev = (unsigned int) _mm256_extract_epi32(current256,0); /* Generate for next loop */
      
#if 0
      /* Doesn't work, because performs shift within 128-bit lanes */
      next256 = _mm256_alignr_epi8(_mm256_set1_epi32(nexthigh_rev),current256,4);
#else
      temp256 = _mm256_insert_epi32(current256,nexthigh_rev,0x00);
      next256 = _mm256_permutevar8x32_epi32(temp256,shift256);
#endif
      
      if (indexsize == 9) {
	chrpos = store_9mers_fwd_simd_128(chrpos,table,positions,counts,current256,next256);
      } else if (indexsize == 8) {
	chrpos = store_8mers_fwd_simd_128(chrpos,table,positions,counts,current256,next256);
      } else if (indexsize == 7) {
	chrpos = store_7mers_fwd_simd_128(chrpos,table,positions,counts,current256,next256);
      } else if (indexsize == 6) {
	chrpos = store_6mers_fwd_simd_128(chrpos,table,positions,counts,current256,next256);
      } else if (indexsize == 5) {
	chrpos = store_5mers_fwd_simd_128(chrpos,table,positions,counts,current256,next256);
      } else {
	abort();
      }
    }
#endif

    while (ptr > startptr + 6) {
      ptr -= 6;

#ifdef HAVE_SSSE3
      if (mode == STANDARD) {
	a = _mm_loadu_si128((__m128i *) &(genome->blocks[ptr]));
	b = _mm_loadu_si128((__m128i *) &(genome->blocks[ptr+3]));
	current = _mm_unpacklo_epi64(a,b);
	current = _mm_shuffle_epi32(current, 0xB1); /* 0b10110001 */
#ifndef HAVE_SSE4_1
#ifdef WORDS_BIGENDIAN
	low0 = Bigendian_convert_uint(genome->blocks[ptr+1]);
#else
	low0 = genome->blocks[ptr+1];
#endif
#endif

      } else {
#ifdef WORDS_BIGENDIAN
	high0 = Bigendian_convert_uint(genome->blocks[ptr]); low0 = Bigendian_convert_uint(genome->blocks[ptr+1]);
	high1 = Bigendian_convert_uint(genome->blocks[ptr+3]); low1 = Bigendian_convert_uint(genome->blocks[ptr+4]);
	nextlow = Bigendian_convert_uint(genome->blocks[ptr+7]);
#else
	high0 = genome->blocks[ptr]; low0 = genome->blocks[ptr+1];
	high1 = genome->blocks[ptr+3]; low1 = genome->blocks[ptr+4];
	nextlow = genome->blocks[ptr+7];
#endif

	if (mode == STANDARD) {
	  /* Skip */
	} else if (mode == CMET_STRANDED) {
	  high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0);
	  high1 = Cmet_reduce_ct(high1); low1 = Cmet_reduce_ct(low1);
	  nextlow = Cmet_reduce_ct(nextlow);
	} else if (mode == CMET_NONSTRANDED) {
	  if (genestrand > 0) {
	    high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0);
	    high1 = Cmet_reduce_ct(high1); low1 = Cmet_reduce_ct(low1);
	    nextlow = Cmet_reduce_ct(nextlow);
	  } else {
	    high0 = Cmet_reduce_ga(high0); low0 = Cmet_reduce_ga(low0);
	    high1 = Cmet_reduce_ga(high1); low1 = Cmet_reduce_ga(low1);
	    nextlow = Cmet_reduce_ga(nextlow);
	  }
	} else if (mode == ATOI_STRANDED) {
	  high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
	  high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
	  nextlow = Atoi_reduce_tc(nextlow);
	} else if (mode == ATOI_NONSTRANDED) {
	  if (genestrand > 0) {
	    high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
	    high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
	    nextlow = Atoi_reduce_tc(nextlow);
	  } else {
	    high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
	    high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
	    nextlow = Atoi_reduce_ag(nextlow);
	  }
	} else if (mode == TTOC_STRANDED) {
	  high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
	  high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
	  nextlow = Atoi_reduce_ag(nextlow);
	} else if (mode == TTOC_NONSTRANDED) {
	  if (genestrand > 0) {
	    high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
	    high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
	    nextlow = Atoi_reduce_ag(nextlow);
	  } else {
	    high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
	    high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
	    nextlow = Atoi_reduce_tc(nextlow);
	  }
	}

	current = _mm_set_epi32(high1,low1,high0,low0);
      }

      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,2),mask2),_mm_slli_epi32(_mm_and_si128(current,mask2),2)); /* Swap pairs */
      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,4),mask4),_mm_slli_epi32(_mm_and_si128(current,mask4),4)); /* Swap nibbles */
      current = _mm_shuffle_epi8(current,reverse8); /* Reverse bytes */
      
      nexthigh_rev = high0_rev;	/* Take from previous loop */
#ifdef HAVE_SSE4_1
      high0_rev = (unsigned int) _mm_extract_epi32(current,0); /* Generate for next loop (SSE4.1 and higher) */
#else
      high0_rev = (reverse_nt[low0 >> 16] | reverse_nt[low0 & 0x0000FFFF] << 16); /* Generate for next loop (SSSE3) */
#endif

#if 1
      next = _mm_alignr_epi8(_mm_set1_epi32(nexthigh_rev),current,4);
#else
      /* Previous solution for SSE4.1 */
      temp = _mm_insert_epi32(current,nexthigh_rev,0x00);
      next = _mm_shuffle_epi32(temp,0x39);
#endif


#else
      /* Non-SSSE3 */
#ifdef WORDS_BIGENDIAN
      high0 = Bigendian_convert_uint(genome->blocks[ptr]); low0 = Bigendian_convert_uint(genome->blocks[ptr+1]);
      high1 = Bigendian_convert_uint(genome->blocks[ptr+3]); ow1 = Bigendian_convert_uint(genome->blocks[ptr+4]);
      nextlow = Bigendian_convert_uint(genome->blocks[ptr+7]);
#else
      high0 = genome->blocks[ptr]; low0 = genome->blocks[ptr+1];
      high1 = genome->blocks[ptr+3]; low1 = genome->blocks[ptr+4];
      nextlow = genome->blocks[ptr+7];
#endif

      if (mode == STANDARD) {
	/* Skip */
      } else if (mode == CMET_STRANDED) {
	high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0);
	high1 = Cmet_reduce_ct(high1); low1 = Cmet_reduce_ct(low1);
	nextlow = Cmet_reduce_ct(nextlow);
      } else if (mode == CMET_NONSTRANDED) {
	if (genestrand > 0) {
	  high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0);
	  high1 = Cmet_reduce_ct(high1); low1 = Cmet_reduce_ct(low1);
	  nextlow = Cmet_reduce_ct(nextlow);
	} else {
	  high0 = Cmet_reduce_ga(high0); low0 = Cmet_reduce_ga(low0);
	  high1 = Cmet_reduce_ga(high1); low1 = Cmet_reduce_ga(low1);
	  nextlow = Cmet_reduce_ga(nextlow);
	}
      } else if (mode == ATOI_STRANDED) {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
	high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
	nextlow = Atoi_reduce_tc(nextlow);
      } else if (mode == ATOI_NONSTRANDED) {
	if (genestrand > 0) {
	  high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0);
	  high1 = Atoi_reduce_tc(high1); low1 = Atoi_reduce_tc(low1);
	  nextlow = Atoi_reduce_tc(nextlow);
	} else {
	  high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0);
	  high1 = Atoi_reduce_ag(high1); low1 = Atoi_reduce_ag(low1);
	  nextlow = Atoi_reduce_ag(nextlow);
	}
      }

      current = _mm_set_epi32(high1,low1,high0,low0);

      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,2),mask2),_mm_slli_epi32(_mm_and_si128(current,mask2),2)); /* Swap pairs */
      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,4),mask4),_mm_slli_epi32(_mm_and_si128(current,mask4),4)); /* Swap nibbles */
      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,8),mask8),_mm_slli_epi32(_mm_and_si128(current,mask8),8)); /* Swap bytes */
      current = _mm_or_si128(_mm_srli_epi32(current,16),_mm_slli_epi32(current,16)); /* Swap 16-bit quantities */
      
      nexthigh_rev = high0_rev;	/* Take from previous loop */

      high0_rev = (reverse_nt[low0 >> 16] | reverse_nt[low0 & 0x0000FFFF] << 16); /* Generate for next loop */
      low0_rev = (reverse_nt[high0 >> 16] | reverse_nt[high0 & 0x0000FFFF] << 16);
      high1_rev = (reverse_nt[low1 >> 16] | reverse_nt[low1 & 0x0000FFFF] << 16);
      low1_rev = (reverse_nt[high1 >> 16] | reverse_nt[high1 & 0x0000FFFF] << 16);
      
      next = _mm_setr_epi32(low0_rev,high1_rev,low1_rev,nexthigh_rev);
#endif

      if (indexsize == 9) {
	chrpos = store_9mers_fwd_simd_64(chrpos,table,positions,counts,current,next);
      } else if (indexsize == 8) {
	chrpos = store_8mers_fwd_simd_64(chrpos,table,positions,counts,current,next);
      } else if (indexsize == 7) {
	chrpos = store_7mers_fwd_simd_64(chrpos,table,positions,counts,current,next);
      } else if (indexsize == 6) {
	chrpos = store_6mers_fwd_simd_64(chrpos,table,positions,counts,current,next);
      } else if (indexsize == 5) {
	chrpos = store_5mers_fwd_simd_64(chrpos,table,positions,counts,current,next);
      } else {
	abort();
      }
    }

    if (ptr > startptr + 3) {
      ptr -= 3;

#ifdef WORDS_BIGENDIAN
      high0 = Bigendian_convert_uint(genome->blocks[ptr]);
      low0 = Bigendian_convert_uint(genome->blocks[ptr+1]);
      nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
      high0 = genome->blocks[ptr];
      low0 = genome->blocks[ptr+1];
      nextlow = genome->blocks[ptr+4];
#endif

      if (mode == STANDARD) {
	/* Skip */
      } else if (mode == CMET_STRANDED) {
	high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
      } else if (mode == CMET_NONSTRANDED) {
	if (genestrand > 0) {
	  high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
	} else {
	  high0 = Cmet_reduce_ga(high0); low0 = Cmet_reduce_ga(low0); nextlow = Cmet_reduce_ga(nextlow);
	}
      } else if (mode == ATOI_STRANDED) {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
      } else if (mode == ATOI_NONSTRANDED) {
	if (genestrand > 0) {
	  high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
	} else {
	  high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
	}
      } else if (mode == TTOC_STRANDED) {
	high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
      } else if (mode == TTOC_NONSTRANDED) {
	if (genestrand > 0) {
	  high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
	} else {
	  high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
	}
      }
      
      current = _mm_set_epi32(0,nextlow,high0,low0);
      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,2),mask2),_mm_slli_epi32(_mm_and_si128(current,mask2),2)); /* Swap pairs */
      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,4),mask4),_mm_slli_epi32(_mm_and_si128(current,mask4),4)); /* Swap nibbles */
#ifdef HAVE_SSSE3
      current = _mm_shuffle_epi8(current,reverse8); /* Reverse bytes */
#else
      current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,8),mask8),_mm_slli_epi32(_mm_and_si128(current,mask8),8)); /* Swap bytes */
      current = _mm_or_si128(_mm_srli_epi32(current,16),_mm_slli_epi32(current,16)); /* Swap 16-bit quantities */
#endif
      
      /* nexthigh_rev = high0_rev; */
#ifdef HAVE_SSE4_1
      high0_rev = (unsigned int) _mm_extract_epi32(current,0);
      low0_rev = (unsigned int) _mm_extract_epi32(current,1);
      nexthigh_rev = (unsigned int) _mm_extract_epi32(current,2);
#else
      high0_rev = (reverse_nt[low0 >> 16] | reverse_nt[low0 & 0x0000FFFF] << 16);
      low0_rev = (reverse_nt[high0 >> 16] | reverse_nt[high0 & 0x0000FFFF] << 16);
      nexthigh_rev = (reverse_nt[nextlow >> 16] | reverse_nt[nextlow & 0x0000FFFF] << 16);
#endif
      
      if (indexsize == 9) {
	chrpos = store_9mers_fwd_32(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev);
      } else if (indexsize == 8) {
	chrpos = store_8mers_fwd_32(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev);
      } else if (indexsize == 7) {
	chrpos = store_7mers_fwd_32(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev);
      } else if (indexsize == 6) {
	chrpos = store_6mers_fwd_32(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev);
      } else if (indexsize == 5) {
	chrpos = store_5mers_fwd_32(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev);
      } else {
	abort();
      }
    }

    ptr -= 3;

    /* Start block */
    assert(ptr == startptr);

#ifdef WORDS_BIGENDIAN
    high0 = Bigendian_convert_uint(genome->blocks[ptr]);
    low0 = Bigendian_convert_uint(genome->blocks[ptr+1]);
    nextlow = Bigendian_convert_uint(genome->blocks[ptr+4]);
#else
    high0 = genome->blocks[ptr];
    low0 = genome->blocks[ptr+1];
    nextlow = genome->blocks[ptr+4];
#endif

    if (mode == STANDARD) {
      /* Skip */
    } else if (mode == CMET_STRANDED) {
      high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
    } else if (mode == CMET_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Cmet_reduce_ct(high0); low0 = Cmet_reduce_ct(low0); nextlow = Cmet_reduce_ct(nextlow);
      } else {
	high0 = Cmet_reduce_ga(high0); low0 = Cmet_reduce_ga(low0); nextlow = Cmet_reduce_ga(nextlow);
      }
    } else if (mode == ATOI_STRANDED) {
      high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
    } else if (mode == ATOI_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
      } else {
	high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
      }
    } else if (mode == TTOC_STRANDED) {
      high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
    } else if (mode == TTOC_NONSTRANDED) {
      if (genestrand > 0) {
	high0 = Atoi_reduce_ag(high0); low0 = Atoi_reduce_ag(low0); nextlow = Atoi_reduce_ag(nextlow);
      } else {
	high0 = Atoi_reduce_tc(high0); low0 = Atoi_reduce_tc(low0); nextlow = Atoi_reduce_tc(nextlow);
      }
    }

    current = _mm_set_epi32(0,nextlow,high0,low0);
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,2),mask2),_mm_slli_epi32(_mm_and_si128(current,mask2),2)); /* Swap pairs */
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,4),mask4),_mm_slli_epi32(_mm_and_si128(current,mask4),4)); /* Swap nibbles */
#ifdef HAVE_SSSE3
    current = _mm_shuffle_epi8(current,reverse8); /* Reverse bytes */
#else
    current = _mm_or_si128(_mm_and_si128(_mm_srli_epi32(current,8),mask8),_mm_slli_epi32(_mm_and_si128(current,mask8),8)); /* Swap bytes */
    current = _mm_or_si128(_mm_srli_epi32(current,16),_mm_slli_epi32(current,16)); /* Swap 16-bit quantities */
#endif

    /* nexthigh_rev = high0_rev; */
#ifdef HAVE_SSE4_1
    high0_rev = (unsigned int) _mm_extract_epi32(current,0);
    low0_rev = (unsigned int) _mm_extract_epi32(current,1);
    nexthigh_rev = (unsigned int) _mm_extract_epi32(current,2);
#else
    high0_rev = (reverse_nt[low0 >> 16] | reverse_nt[low0 & 0x0000FFFF] << 16);
    low0_rev = (reverse_nt[high0 >> 16] | reverse_nt[high0 & 0x0000FFFF] << 16);
    nexthigh_rev = (reverse_nt[nextlow >> 16] | reverse_nt[nextlow & 0x0000FFFF] << 16);
#endif

    if (indexsize == 9) {
      chrpos = store_9mers_fwd_partial(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 8) {
      chrpos = store_8mers_fwd_partial(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 7) {
      chrpos = store_7mers_fwd_partial(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 6) {
      chrpos = store_6mers_fwd_partial(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else if (indexsize == 5) {
      chrpos = store_5mers_fwd_partial(chrpos,table,positions,counts,high0_rev,low0_rev,nexthigh_rev,startdiscard,/*enddiscard*/31);
    } else {
      fprintf(stderr,"indexsize %d not supported\n",indexsize);
      abort();
    }
  }
  
  return;
}
#endif


/************************************************************************
 *   REV
 ************************************************************************/

static void
count_9mers_rev_partial (Count_T *counts, Genomecomp_T low_rc, Genomecomp_T high_rc,
			 Genomecomp_T nextlow_rc, int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = startdiscard;

  while (pos <= enddiscard && pos <= 7) {
    masked = low_rc >> 2*pos;
    masked &= MASK9;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  while (pos <= enddiscard && pos <= 15) {
    masked = low_rc >> 2*pos;
    masked |= high_rc << (32 - 2*pos);
    masked &= MASK9;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  while (pos <= enddiscard && pos <= 23) {
    masked = high_rc >> (2*pos - 32);
    masked &= MASK9;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  while (pos <= enddiscard) {
    masked = high_rc >> (2*pos - 32);
    masked |= nextlow_rc << (64 - 2*pos);
    masked &= MASK9;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  return;
}

static int
store_9mers_rev_partial (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 Genomecomp_T low_rc, Genomecomp_T high_rc, Genomecomp_T nextlow_rc,
			 int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = startdiscard;

  while (pos <= enddiscard && pos <= 7) {
    masked = low_rc >> 2*pos;
    masked &= MASK9;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  while (pos <= enddiscard && pos <= 15) {
    masked = low_rc >> 2*pos;
    masked |= high_rc << (32 - 2*pos);
    masked &= MASK9;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  while (pos <= enddiscard && pos <= 23) {
    masked = high_rc >> (2*pos - 32);
    masked &= MASK9;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  while (pos <= enddiscard) {
    masked = high_rc >> (2*pos - 32);
    masked |= nextlow_rc << (64 - 2*pos);
    masked &= MASK9;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  return chrpos;
}


static void
count_8mers_rev_partial (Count_T *counts, Genomecomp_T low_rc, Genomecomp_T high_rc,
			 Genomecomp_T nextlow_rc, int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = startdiscard;

  while (pos <= enddiscard && pos <= 8) {
    masked = low_rc >> 2*pos;
    masked &= MASK8;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  while (pos <= enddiscard && pos <= 15) {
    masked = low_rc >> 2*pos;
    masked |= high_rc << (32 - 2*pos);
    masked &= MASK8;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  while (pos <= enddiscard && pos <= 24) {
    masked = high_rc >> (2*pos - 32);
    masked &= MASK8;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  while (pos <= enddiscard) {
    masked = high_rc >> (2*pos - 32);
    masked |= nextlow_rc << (64 - 2*pos);
    masked &= MASK8;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  return;
}

static int
store_8mers_rev_partial (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 Genomecomp_T low_rc, Genomecomp_T high_rc, Genomecomp_T nextlow_rc,
			 int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = startdiscard;

  while (pos <= enddiscard && pos <= 8) {
    masked = low_rc >> 2*pos;
    masked &= MASK8;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  while (pos <= enddiscard && pos <= 15) {
    masked = low_rc >> 2*pos;
    masked |= high_rc << (32 - 2*pos);
    masked &= MASK8;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  while (pos <= enddiscard && pos <= 24) {
    masked = high_rc >> (2*pos - 32);
    masked &= MASK8;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  while (pos <= enddiscard) {
    masked = high_rc >> (2*pos - 32);
    masked |= nextlow_rc << (64 - 2*pos);
    masked &= MASK8;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  return chrpos;
}

static void
count_7mers_rev_partial (Count_T *counts, Genomecomp_T low_rc, Genomecomp_T high_rc,
			 Genomecomp_T nextlow_rc, int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = startdiscard;

  while (pos <= enddiscard && pos <= 9) {
    masked = low_rc >> 2*pos;
    masked &= MASK7;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  while (pos <= enddiscard && pos <= 15) {
    masked = low_rc >> 2*pos;
    masked |= high_rc << (32 - 2*pos);
    masked &= MASK7;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  while (pos <= enddiscard && pos <= 25) {
    masked = high_rc >> (2*pos - 32);
    masked &= MASK7;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  while (pos <= enddiscard) {
    masked = high_rc >> (2*pos - 32);
    masked |= nextlow_rc << (64 - 2*pos);
    masked &= MASK7;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  return;
}

static int
store_7mers_rev_partial (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 Genomecomp_T low_rc, Genomecomp_T high_rc, Genomecomp_T nextlow_rc,
			 int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = startdiscard;

  while (pos <= enddiscard && pos <= 9) {
    masked = low_rc >> 2*pos;
    masked &= MASK7;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  while (pos <= enddiscard && pos <= 15) {
    masked = low_rc >> 2*pos;
    masked |= high_rc << (32 - 2*pos);
    masked &= MASK7;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  while (pos <= enddiscard && pos <= 25) {
    masked = high_rc >> (2*pos - 32);
    masked &= MASK7;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  while (pos <= enddiscard) {
    masked = high_rc >> (2*pos - 32);
    masked |= nextlow_rc << (64 - 2*pos);
    masked &= MASK7;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  return chrpos;
}


static void
count_6mers_rev_partial (Count_T *counts, Genomecomp_T low_rc, Genomecomp_T high_rc,
			 Genomecomp_T nextlow_rc, int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = startdiscard;

  while (pos <= enddiscard && pos <= 10) {
    masked = low_rc >> 2*pos;
    masked &= MASK6;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  while (pos <= enddiscard && pos <= 15) {
    masked = low_rc >> 2*pos;
    masked |= high_rc << (32 - 2*pos);
    masked &= MASK6;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  while (pos <= enddiscard && pos <= 26) {
    masked = high_rc >> (2*pos - 32);
    masked &= MASK6;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  while (pos <= enddiscard) {
    masked = high_rc >> (2*pos - 32);
    masked |= nextlow_rc << (64 - 2*pos);
    masked &= MASK6;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  return;
}

static int
store_6mers_rev_partial (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 Genomecomp_T low_rc, Genomecomp_T high_rc, Genomecomp_T nextlow_rc,
			 int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = startdiscard;

  while (pos <= enddiscard && pos <= 10) {
    masked = low_rc >> 2*pos;
    masked &= MASK6;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  while (pos <= enddiscard && pos <= 15) {
    masked = low_rc >> 2*pos;
    masked |= high_rc << (32 - 2*pos);
    masked &= MASK6;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  while (pos <= enddiscard && pos <= 26) {
    masked = high_rc >> (2*pos - 32);
    masked &= MASK6;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  while (pos <= enddiscard) {
    masked = high_rc >> (2*pos - 32);
    masked |= nextlow_rc << (64 - 2*pos);
    masked &= MASK6;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  return chrpos;
}

static void
count_5mers_rev_partial (Count_T *counts, Genomecomp_T low_rc, Genomecomp_T high_rc,
			 Genomecomp_T nextlow_rc, int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = startdiscard;

  while (pos <= enddiscard && pos <= 11) {
    masked = low_rc >> 2*pos;
    masked &= MASK5;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  while (pos <= enddiscard && pos <= 15) {
    masked = low_rc >> 2*pos;
    masked |= high_rc << (32 - 2*pos);
    masked &= MASK5;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  while (pos <= enddiscard && pos <= 27) {
    masked = high_rc >> (2*pos - 32);
    masked &= MASK5;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  while (pos <= enddiscard) {
    masked = high_rc >> (2*pos - 32);
    masked |= nextlow_rc << (64 - 2*pos);
    masked &= MASK5;
    INCR_COUNT(counts[masked]);
    debug(printf("%d partial %04X => %d\n",pos,masked,counts[masked]));
    pos++;
  }

  return;
}

static int
store_5mers_rev_partial (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 Genomecomp_T low_rc, Genomecomp_T high_rc, Genomecomp_T nextlow_rc,
			 int startdiscard, int enddiscard) {
  Genomecomp_T masked;
  int pos;

  pos = startdiscard;

  while (pos <= enddiscard && pos <= 11) {
    masked = low_rc >> 2*pos;
    masked &= MASK5;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  while (pos <= enddiscard && pos <= 15) {
    masked = low_rc >> 2*pos;
    masked |= high_rc << (32 - 2*pos);
    masked &= MASK5;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  while (pos <= enddiscard && pos <= 27) {
    masked = high_rc >> (2*pos - 32);
    masked &= MASK5;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  while (pos <= enddiscard) {
    masked = high_rc >> (2*pos - 32);
    masked |= nextlow_rc << (64 - 2*pos);
    masked &= MASK5;
    if (counts[masked]) {
      debug(printf("Storing masked %u at %u (partial)\n",masked,chrpos));
      table[positions[masked] + (--counts[masked])] = chrpos;
    }
    chrpos--;
    pos++;
  }

  return chrpos;
}



#if !defined(HAVE_AVX2)

static void
count_9mers_rev_32 (Count_T *counts, Genomecomp_T low_rc, Genomecomp_T high_rc, Genomecomp_T nextlow_rc) {
  Genomecomp_T masked, oligo;
#ifdef INDIVIDUAL_SHIFTS
#elif defined(SIMD_MASK_THEN_STORE)
  UINT4 _masked[4] __attribute__ ((aligned (16)));
  __m128i _oligo;
#else
  __m128i _oligo, _masked;
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = low_rc & MASK9;	/* 0 */
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));

  masked = (low_rc >> 2) & MASK9; /* 1 */
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = (low_rc >> 4) & MASK9; /* 2 */
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = (low_rc >> 6) & MASK9; /* 3 */
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));

  masked = (low_rc >> 8) & MASK9; /* 4 */
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));

  masked = (low_rc >> 10) & MASK9; /* 5 */
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = (low_rc >> 12) & MASK9; /* 6 */
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = low_rc >> 14;	/* 7, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(low_rc, low_rc >> 2, low_rc >> 4, low_rc >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));
#endif


  oligo = low_rc >> 16;		/* For 15..8 */
  oligo |= high_rc << 16;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK9; /* 8 */
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 2) & MASK9; /* 9 */
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 4) & MASK9; /* 10 */
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 6) & MASK9; /* 11 */
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 8) & MASK9; /* 12 */
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 10) & MASK9; /* 13 */
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 12) & MASK9; /* 14 */
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 14) & MASK9; /* 15 */
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = high_rc & MASK9;	/* 16 */
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));

  masked = (high_rc >> 2) & MASK9; /* 17 */
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = (high_rc >> 4) & MASK9; /* 18 */
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = (high_rc >> 6) & MASK9; /* 19 */
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));

  masked = (high_rc >> 8) & MASK9; /* 20 */
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));

  masked = (high_rc >> 10) & MASK9; /* 21 */
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = (high_rc >> 12) & MASK9; /* 22 */
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = high_rc >> 14;	/* 23, No mask necessary */
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(high_rc, high_rc >> 2, high_rc >> 4, high_rc >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));
#endif


  oligo = high_rc >> 16;	/* For 31..24 */
  oligo |= nextlow_rc << 16;

#ifdef INDIVIDUAL_SHIFTS
  masked = oligo & MASK9; /* 24 */
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 2) & MASK9; /* 25 */
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 4) & MASK9; /* 26 */
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 6) & MASK9; /* 27 */
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 8) & MASK9; /* 28 */
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 10) & MASK9; /* 29 */
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 12) & MASK9; /* 30 */
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = (oligo >> 14) & MASK9; /* 31 */
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

#else
  _oligo = _mm_setr_epi32(oligo, oligo >> 2, oligo >> 4, oligo >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));
#endif

  return;
}

#else	/* HAVE_AVX2 */

static void
count_9mers_rev_32 (Count_T *counts, Genomecomp_T low_rc, Genomecomp_T high_rc, Genomecomp_T nextlow_rc) {
  Genomecomp_T masked, oligo;
  __m256i _oligo, _masked;


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(low_rc),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask9);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("0 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("1 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("2 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("3 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("4 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("5 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("6 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("7 %04X => %d\n",masked,counts[masked]));


  oligo = low_rc >> 16;		/* For 15..8 */
  oligo |= high_rc << 16;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask9);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("8 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("9 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("10 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("11 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("12 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("13 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("14 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("15 %04X => %d\n",masked,counts[masked]));


  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(high_rc),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask9);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("16 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("17 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("18 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("19 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("20 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("21 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("22 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("23 %04X => %d\n",masked,counts[masked]));


  oligo = high_rc >> 16;	/* For 31..24 */
  oligo |= nextlow_rc << 16;

  _oligo = _mm256_srlv_epi32(_mm256_set1_epi32(oligo),bigshift0to14);
  _masked = _mm256_and_si256(_oligo, bigmask9);

  masked = EXTRACT256(_masked,0);
  INCR_COUNT(counts[masked]);
  debug(printf("24 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,1);
  INCR_COUNT(counts[masked]);
  debug(printf("25 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,2);
  INCR_COUNT(counts[masked]);
  debug(printf("26 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,3);
  INCR_COUNT(counts[masked]);
  debug(printf("27 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,4);
  INCR_COUNT(counts[masked]);
  debug(printf("28 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,5);
  INCR_COUNT(counts[masked]);
  debug(printf("29 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,6);
  INCR_COUNT(counts[masked]);
  debug(printf("30 %04X => %d\n",masked,counts[masked]));

  masked = EXTRACT256(_masked,7);
  INCR_COUNT(counts[masked]);
  debug(printf("31 %04X => %d\n",masked,counts[masked]));

  return;
}

#endif  /* HAVE_AVX2 */



/* Expecting current to have {low0_rc, high0_rc, low1_rc, high1_rc},
   and next to have {high0_rc, low1_rc, high1_rc, nextlow_rc} */
#ifdef HAVE_SSE2
static void
extract_9mers_rev_simd_64 (__m128i *out, __m128i current, __m128i next) {
  __m128i oligo;

  oligo = _mm_or_si128( _mm_srli_epi32(current,16), _mm_slli_epi32(next,16));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,14), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,12), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,10), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,8), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,6), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,4), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(oligo,2), mask9));
  _mm_store_si128(out++, _mm_and_si128( oligo, mask9));

  _mm_store_si128(out++, _mm_srli_epi32(current,14)); /* No mask necessary */;
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,12), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,10), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,8), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,6), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,4), mask9));
  _mm_store_si128(out++, _mm_and_si128( _mm_srli_epi32(current,2), mask9));
  _mm_store_si128(out++, _mm_and_si128( current, mask9));

  return;
}

#ifdef USE_UNORDERED_9
static Chrpos_T
store_9mers_rev_simd_64 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m128i current, __m128i next) {
  __m128i array[16];
			  
  extract_9mers_rev_simd_64(array,current,next);
  return store_fwdrev_simd_64(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_9mers_rev_simd_64_ordered (__m128i *out, __m128i current, __m128i next) */
static Chrpos_T
store_9mers_rev_simd_64 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m128i current, __m128i next) {
  __m128i array[16], *out;
  __m128i oligo;
  __m128i _row0, _row1, _row2, _row3, _row4, _row5, _row6, _row7,
    _row8, _row9, _row10, _row11, _row12, _row13, _row14, _row15;
  __m128i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;

  out = &(array[0]);

  _row0 = _mm_and_si128( current, mask9);
  _row1 = _mm_and_si128( _mm_srli_epi32(current,2), mask9);
  _row2 = _mm_and_si128( _mm_srli_epi32(current,4), mask9);
  _row3 = _mm_and_si128( _mm_srli_epi32(current,6), mask9);
  _row4 = _mm_and_si128( _mm_srli_epi32(current,8), mask9);
  _row5 = _mm_and_si128( _mm_srli_epi32(current,10), mask9);
  _row6 = _mm_and_si128( _mm_srli_epi32(current,12), mask9);
  _row7 = _mm_srli_epi32(current,14); /* No mask necessary */;

  oligo = _mm_or_si128( _mm_srli_epi32(current,16), _mm_slli_epi32(next,16));
  _row8 = _mm_and_si128( oligo, mask9);
  _row9 = _mm_and_si128( _mm_srli_epi32(oligo,2), mask9);
  _row10 = _mm_and_si128( _mm_srli_epi32(oligo,4), mask9);
  _row11 = _mm_and_si128( _mm_srli_epi32(oligo,6), mask9);
  _row12 = _mm_and_si128( _mm_srli_epi32(oligo,8), mask9);
  _row13 = _mm_and_si128( _mm_srli_epi32(oligo,10), mask9);
  _row14 = _mm_and_si128( _mm_srli_epi32(oligo,12), mask9);
  _row15 = _mm_and_si128( _mm_srli_epi32(oligo,14), mask9);


  /* Split: top half */
  _t0 = _mm_unpackhi_epi32(_row0,_row1);
  _t1 = _mm_unpackhi_epi32(_row2,_row3);
  _t2 = _mm_unpackhi_epi32(_row4,_row5);
  _t3 = _mm_unpackhi_epi32(_row6,_row7);
  _t4 = _mm_unpackhi_epi32(_row8,_row9);
  _t5 = _mm_unpackhi_epi32(_row10,_row11);
  _t6 = _mm_unpackhi_epi32(_row12,_row13);
  _t7 = _mm_unpackhi_epi32(_row14,_row15);

  _mm_store_si128(out++, _mm_unpackhi_epi64(_t0,_t1));
  _mm_store_si128(out++, _mm_unpackhi_epi64(_t2,_t3));
  _mm_store_si128(out++, _mm_unpackhi_epi64(_t4,_t5));
  _mm_store_si128(out++, _mm_unpackhi_epi64(_t6,_t7));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t0,_t1));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t2,_t3));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t4,_t5));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t6,_t7));


  /* Split: bottom half */
  _t0 = _mm_unpacklo_epi32(_row0,_row1);
  _t1 = _mm_unpacklo_epi32(_row2,_row3);
  _t2 = _mm_unpacklo_epi32(_row4,_row5);
  _t3 = _mm_unpacklo_epi32(_row6,_row7);
  _t4 = _mm_unpacklo_epi32(_row8,_row9);
  _t5 = _mm_unpacklo_epi32(_row10,_row11);
  _t6 = _mm_unpacklo_epi32(_row12,_row13);
  _t7 = _mm_unpacklo_epi32(_row14,_row15);

  _mm_store_si128(out++, _mm_unpackhi_epi64(_t0,_t1));
  _mm_store_si128(out++, _mm_unpackhi_epi64(_t2,_t3));
  _mm_store_si128(out++, _mm_unpackhi_epi64(_t4,_t5));
  _mm_store_si128(out++, _mm_unpackhi_epi64(_t6,_t7));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t0,_t1));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t2,_t3));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t4,_t5));
  _mm_store_si128(out++, _mm_unpacklo_epi64(_t6,_t7));

  return store_fwdrev_simd_64_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif

#ifdef HAVE_AVX2
static void
extract_9mers_rev_simd_128 (__m256i *out, __m256i current, __m256i next) {
  __m256i oligo;

  oligo = _mm256_or_si256( _mm256_srli_epi32(current,16), _mm256_slli_epi32(next,16));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,14), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,12), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,10), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,8), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,6), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,4), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(oligo,2), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( oligo, bigmask9));

  _mm256_store_si256(out++, _mm256_srli_epi32(current,14)); /* No mask necessary */;
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,12), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,10), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,8), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,6), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,4), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( _mm256_srli_epi32(current,2), bigmask9));
  _mm256_store_si256(out++, _mm256_and_si256( current, bigmask9));

  return;
}

#ifdef USE_UNORDERED_9
static Chrpos_T
store_9mers_rev_simd_128 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			  __m256i current, __m256i next) {
  __m256i array[16];
			  
  extract_9mers_rev_simd_128(array,current,next);
  return store_fwdrev_simd_128(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_9mers_rev_simd_128_ordered (__m256i *out, __m256i current, __m256i next) */
static Chrpos_T
store_9mers_rev_simd_128 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			  __m256i current, __m256i next) {
  __m256i array[16], *out;
  __m256i oligo;
  __m256i _row0, _row1, _row2, _row3, _row4, _row5, _row6, _row7,
    _row8, _row9, _row10, _row11, _row12, _row13, _row14, _row15;
  __m256i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m256i _u0, _u1, _u2, _u3, _u4, _u5, _u6, _u7;

  out = &(array[0]);

  _row0 = _mm256_and_si256( current, bigmask9);
  _row1 = _mm256_and_si256( _mm256_srli_epi32(current,2), bigmask9);
  _row2 = _mm256_and_si256( _mm256_srli_epi32(current,4), bigmask9);
  _row3 = _mm256_and_si256( _mm256_srli_epi32(current,6), bigmask9);
  _row4 = _mm256_and_si256( _mm256_srli_epi32(current,8), bigmask9);
  _row5 = _mm256_and_si256( _mm256_srli_epi32(current,10), bigmask9);
  _row6 = _mm256_and_si256( _mm256_srli_epi32(current,12), bigmask9);
  _row7 = _mm256_srli_epi32(current,14); /* No mask necessary */;

  oligo = _mm256_or_si256( _mm256_srli_epi32(current,16), _mm256_slli_epi32(next,16));
  _row8 = _mm256_and_si256( oligo, bigmask9);
  _row9 = _mm256_and_si256( _mm256_srli_epi32(oligo,2), bigmask9);
  _row10 = _mm256_and_si256( _mm256_srli_epi32(oligo,4), bigmask9);
  _row11 = _mm256_and_si256( _mm256_srli_epi32(oligo,6), bigmask9);
  _row12 = _mm256_and_si256( _mm256_srli_epi32(oligo,8), bigmask9);
  _row13 = _mm256_and_si256( _mm256_srli_epi32(oligo,10), bigmask9);
  _row14 = _mm256_and_si256( _mm256_srli_epi32(oligo,12), bigmask9);
  _row15 = _mm256_and_si256( _mm256_srli_epi32(oligo,14), bigmask9);


  /* Split: top half */
  _t0 = _mm256_unpackhi_epi32(_row0,_row1);
  _t1 = _mm256_unpackhi_epi32(_row2,_row3);
  _t2 = _mm256_unpackhi_epi32(_row4,_row5);
  _t3 = _mm256_unpackhi_epi32(_row6,_row7);
  _t4 = _mm256_unpackhi_epi32(_row8,_row9);
  _t5 = _mm256_unpackhi_epi32(_row10,_row11);
  _t6 = _mm256_unpackhi_epi32(_row12,_row13);
  _t7 = _mm256_unpackhi_epi32(_row14,_row15);

  _u0 = _mm256_unpackhi_epi64(_t0,_t1);
  _u1 = _mm256_unpackhi_epi64(_t2,_t3);
  _u2 = _mm256_unpackhi_epi64(_t4,_t5);
  _u3 = _mm256_unpackhi_epi64(_t6,_t7);
  _u4 = _mm256_unpacklo_epi64(_t0,_t1);
  _u5 = _mm256_unpacklo_epi64(_t2,_t3);
  _u6 = _mm256_unpacklo_epi64(_t4,_t5);
  _u7 = _mm256_unpacklo_epi64(_t6,_t7);


  /* Split: bottom half */
  _t0 = _mm256_unpacklo_epi32(_row0,_row1);
  _t1 = _mm256_unpacklo_epi32(_row2,_row3);
  _t2 = _mm256_unpacklo_epi32(_row4,_row5);
  _t3 = _mm256_unpacklo_epi32(_row6,_row7);
  _t4 = _mm256_unpacklo_epi32(_row8,_row9);
  _t5 = _mm256_unpacklo_epi32(_row10,_row11);
  _t6 = _mm256_unpacklo_epi32(_row12,_row13);
  _t7 = _mm256_unpacklo_epi32(_row14,_row15);

  _row8 = _mm256_unpackhi_epi64(_t0,_t1);
  _row9 = _mm256_unpackhi_epi64(_t2,_t3);
  _row10 = _mm256_unpackhi_epi64(_t4,_t5);
  _row11 = _mm256_unpackhi_epi64(_t6,_t7);
  _row12 = _mm256_unpacklo_epi64(_t0,_t1);
  _row13 = _mm256_unpacklo_epi64(_t2,_t3);
  _row14 = _mm256_unpacklo_epi64(_t4,_t5);
  _row15 = _mm256_unpacklo_epi64(_t6,_t7);


  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u0, _u1, 0x31));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u2, _u3, 0x31));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u4, _u5, 0x31));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u6, _u7, 0x31));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row8, _row9, 0x31));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row10, _row11, 0x31));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row12, _row13, 0x31));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row14, _row15, 0x31));

  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u0, _u1, 0x20));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u2, _u3, 0x20));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u4, _u5, 0x20));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_u6, _u7, 0x20));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row8, _row9, 0x20));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row10, _row11, 0x20));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row12, _row13, 0x20));
  _mm256_store_si256(out++, _mm256_permute2x128_si256(_row14, _row15, 0x20));

  return store_fwdrev_simd_128_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif

#ifdef HAVE_AVX512
static void
extract_9mers_rev_simd_256 (__m512i *out, __m512i current, __m512i next) {
  __m512i oligo;

  oligo = _mm512_or_si512( _mm512_srli_epi32(current,16), _mm512_slli_epi32(next,16));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,14), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,12), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,10), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,8), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,6), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,4), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(oligo,2), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( oligo, hugemask9));

  _mm512_store_si512(out++, _mm512_srli_epi32(current,14)); /* No mask necessary */;
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,12), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,10), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,8), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,6), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,4), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( _mm512_srli_epi32(current,2), hugemask9));
  _mm512_store_si512(out++, _mm512_and_si512( current, hugemask9));

  return;
}

#ifdef USE_UNORDERED_9
static Chrpos_T
store_9mers_rev_simd_256 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m512i current, __m512i next) {
  __m512i array[16];
			  
  extract_9mers_rev_simd_256(array,current,next);
  return store_fwdrev_simd_256(chrpos,table,positions,counts,(UINT4 *) array);
}

#else
/* Includes extract_9mers_rev_simd_256_ordered (__m512i *out, __m512i current, __m512i next) */
static Chrpos_T
store_9mers_rev_simd_256 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
			 __m512i current, __m512i next) {
  __m512i array[16], *out;
  __m512i oligo, _shuffle0, _shuffle1, _shuffle2;
  __m512i _row0, _row1, _row2, _row3, _row4, _row5, _row6, _row7,
    _row8, _row9, _row10, _row11, _row12, _row13, _row14, _row15;
  __m512i _t0, _t1, _t2, _t3, _t4, _t5, _t6, _t7;
  __m512i _u0, _u1, _u2, _u3, _u4, _u5, _u6, _u7;

  out = &(array[0]);

  _row0 = _mm512_and_si512( current, hugemask9);
  _row1 = _mm512_and_si512( _mm512_srli_epi32(current,2), hugemask9);
  _row2 = _mm512_and_si512( _mm512_srli_epi32(current,4), hugemask9);
  _row3 = _mm512_and_si512( _mm512_srli_epi32(current,6), hugemask9);
  _row4 = _mm512_and_si512( _mm512_srli_epi32(current,8), hugemask9);
  _row5 = _mm512_and_si512( _mm512_srli_epi32(current,10), hugemask9);
  _row6 = _mm512_and_si512( _mm512_srli_epi32(current,12), hugemask9);
  _row7 = _mm512_srli_epi32(current,14); /* No mask necessary */;

  oligo = _mm512_or_si512( _mm512_srli_epi32(current,16), _mm512_slli_epi32(next,16));
  _row8 = _mm512_and_si512( oligo, hugemask9);
  _row9 = _mm512_and_si512( _mm512_srli_epi32(oligo,2), hugemask9);
  _row10 = _mm512_and_si512( _mm512_srli_epi32(oligo,4), hugemask9);
  _row11 = _mm512_and_si512( _mm512_srli_epi32(oligo,6), hugemask9);
  _row12 = _mm512_and_si512( _mm512_srli_epi32(oligo,8), hugemask9);
  _row13 = _mm512_and_si512( _mm512_srli_epi32(oligo,10), hugemask9);
  _row14 = _mm512_and_si512( _mm512_srli_epi32(oligo,12), hugemask9);
  _row15 = _mm512_and_si512( _mm512_srli_epi32(oligo,14), hugemask9);


  /* Split: top half */
  _t0 = _mm512_unpackhi_epi32(_row0,_row1);
  _t1 = _mm512_unpackhi_epi32(_row2,_row3);
  _t2 = _mm512_unpackhi_epi32(_row4,_row5);
  _t3 = _mm512_unpackhi_epi32(_row6,_row7);
  _t4 = _mm512_unpackhi_epi32(_row8,_row9);
  _t5 = _mm512_unpackhi_epi32(_row10,_row11);
  _t6 = _mm512_unpackhi_epi32(_row12,_row13);
  _t7 = _mm512_unpackhi_epi32(_row14,_row15);

  _u0 = _mm512_unpackhi_epi64(_t0,_t1);
  _u1 = _mm512_unpackhi_epi64(_t2,_t3);
  _u2 = _mm512_unpackhi_epi64(_t4,_t5);
  _u3 = _mm512_unpackhi_epi64(_t6,_t7);
  _u4 = _mm512_unpacklo_epi64(_t0,_t1);
  _u5 = _mm512_unpacklo_epi64(_t2,_t3);
  _u6 = _mm512_unpacklo_epi64(_t4,_t5);
  _u7 = _mm512_unpacklo_epi64(_t6,_t7);

  /* Split: bottom half */
  _t0 = _mm512_unpacklo_epi32(_row0,_row1);
  _t1 = _mm512_unpacklo_epi32(_row2,_row3);
  _t2 = _mm512_unpacklo_epi32(_row4,_row5);
  _t3 = _mm512_unpacklo_epi32(_row6,_row7);
  _t4 = _mm512_unpacklo_epi32(_row8,_row9);
  _t5 = _mm512_unpacklo_epi32(_row10,_row11);
  _t6 = _mm512_unpacklo_epi32(_row12,_row13);
  _t7 = _mm512_unpacklo_epi32(_row14,_row15);

  _row8 = _mm512_unpackhi_epi64(_t0,_t1);
  _row9 = _mm512_unpackhi_epi64(_t2,_t3);
  _row10 = _mm512_unpackhi_epi64(_t4,_t5);
  _row11 = _mm512_unpackhi_epi64(_t6,_t7);
  _row12 = _mm512_unpacklo_epi64(_t0,_t1);
  _row13 = _mm512_unpacklo_epi64(_t2,_t3);
  _row14 = _mm512_unpacklo_epi64(_t4,_t5);
  _row15 = _mm512_unpacklo_epi64(_t6,_t7);


  /* Split: top half */
  _shuffle0 = _mm512_setr_epi64(6, 7, 8+6, 8+7, 4, 5, 8+4, 8+5);
  _t0 = _mm512_permutex2var_epi64(_u0, _shuffle0, _u1);
  _t1 = _mm512_permutex2var_epi64(_u2, _shuffle0, _u3);
  _t2 = _mm512_permutex2var_epi64(_u4, _shuffle0, _u5);
  _t3 = _mm512_permutex2var_epi64(_u6, _shuffle0, _u7);
  _t4 = _mm512_permutex2var_epi64(_row8, _shuffle0, _row9);
  _t5 = _mm512_permutex2var_epi64(_row10, _shuffle0, _row11);
  _t6 = _mm512_permutex2var_epi64(_row12, _shuffle0, _row13);
  _t7 = _mm512_permutex2var_epi64(_row14, _shuffle0, _row15);

  _shuffle1 = _mm512_setr_epi64(0, 1, 2, 3, 8+0, 8+1, 8+2, 8+3);
  _shuffle2 = _mm512_setr_epi64(4, 5, 6, 7, 8+4, 8+5, 8+6, 8+7);
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t0, _shuffle1, _t1));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t2, _shuffle1, _t3));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t4, _shuffle1, _t5));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t6, _shuffle1, _t7));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t0, _shuffle2, _t1));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t2, _shuffle2, _t3));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t4, _shuffle2, _t5));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t6, _shuffle2, _t7));

  /* Split: bottom half */
  _shuffle0 = _mm512_setr_epi64(2, 3, 8+2, 8+3, 0, 1, 8+0, 8+1);
  _t0 = _mm512_permutex2var_epi64(_u0, _shuffle0, _u1);
  _t1 = _mm512_permutex2var_epi64(_u2, _shuffle0, _u3);
  _t2 = _mm512_permutex2var_epi64(_u4, _shuffle0, _u5);
  _t3 = _mm512_permutex2var_epi64(_u6, _shuffle0, _u7);
  _t4 = _mm512_permutex2var_epi64(_row8, _shuffle0, _row9);
  _t5 = _mm512_permutex2var_epi64(_row10, _shuffle0, _row11);
  _t6 = _mm512_permutex2var_epi64(_row12, _shuffle0, _row13);
  _t7 = _mm512_permutex2var_epi64(_row14, _shuffle0, _row15);

  /* _shuffle1 = _mm512_setr_epi64(0, 1, 2, 3, 8+0, 8+1, 8+2, 8+3); */
  /* _shuffle2 = _mm512_setr_epi64(4, 5, 6, 7, 8+4, 8+5, 8+6, 8+7); */
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t0, _shuffle1, _t1));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t2, _shuffle1, _t3));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t4, _shuffle1, _t5));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t6, _shuffle1, _t7));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t0, _shuffle2, _t1));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t2, _shuffle2, _t3));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t4, _shuffle2, _t5));
  _mm512_store_si512(out++, _mm512_permutex2var_epi64(_t6, _shuffle2, _t7));

  return store_fwdrev_simd_256_ordered(chrpos,table,positions,counts,(UINT4 *) array);
}
#endif
#endif


#if !defined(HAVE_AVX2)

static int
store_9mers_rev_32 (Chrpos_T chrpos, Chrpos_T *table, UINT4 *positions, Count_T *counts,
		    Genomecomp_T low_rc, Genomecomp_T high_rc, Genomecomp_T nextlow_rc) {
  Genomecomp_T masked, oligo;
#ifdef INDIVIDUAL_SHIFTS
#elif defined(SIMD_MASK_THEN_STORE)
  UINT4 _masked[4] __attribute__ ((aligned (16)));
  __m128i _oligo;
#else
  __m128i _oligo, _masked;
#endif


#ifdef INDIVIDUAL_SHIFTS
  masked = low_rc & MASK9;	/* 0 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos));
    table[positions[masked] + (--counts[masked])] = chrpos;
  }

  masked = (low_rc >> 2) & MASK9; /* 1 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
    table[positions[masked] + (--counts[masked])] = chrpos - 1;
  }

  masked = (low_rc >> 4) & MASK9; /* 2 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
    table[positions[masked] + (--counts[masked])] = chrpos - 2;
  }

  masked = (low_rc >> 6) & MASK9; /* 3 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
    table[positions[masked] + (--counts[masked])] = chrpos - 3;
  }

  masked = (low_rc >> 8) & MASK9; /* 4 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
    table[positions[masked] + (--counts[masked])] = chrpos - 4;
  }

  masked = (low_rc >> 10) & MASK9; /* 5 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
    table[positions[masked] + (--counts[masked])] = chrpos - 5;
  }

  masked = (low_rc >> 12) & MASK9; /* 6 */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
    table[positions[masked] + (--counts[masked])] = chrpos - 6;
  }

  masked = low_rc >> 14;	/* 7, No mask necessary */
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 7));
    table[positions[masked] + (--counts[masked])] = chrpos - 7;
  }

#else
  _oligo = _mm_setr_epi32(low_rc, low_rc >> 2, low_rc >> 4, low_rc >> 6);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos));
    table[positions[masked] + (--counts[masked])] = chrpos;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 1));
    table[positions[masked] + (--counts[masked])] = chrpos - 1;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 2));
    table[positions[masked] + (--counts[masked])] = chrpos - 2;
  }

  masked = EXTRACT(_masked,3);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 3));
    table[positions[masked] + (--counts[masked])] = chrpos - 3;
  }


  _oligo = _mm_srli_epi32(_oligo, 8);
#ifdef SIMD_MASK_THEN_STORE
  _mm_store_si128((__m128i *) _masked,_mm_and_si128(_oligo, mask9));
#else
  _masked = _mm_and_si128(_oligo, mask9);
#endif

  masked = EXTRACT(_masked,0);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 4));
    table[positions[masked] + (--counts[masked])] = chrpos - 4;
  }

  masked = EXTRACT(_masked,1);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 5));
    table[positions[masked] + (--counts[masked])] = chrpos - 5;
  }

  masked = EXTRACT(_masked,2);
  if (counts[masked]) {
    debug(printf("Storing masked %u at %u\n",masked,chrpos - 6));
    table[positions[masked] + (--counts[masked])] = chrpos - 6;
  }