// Copyright 2018 The go-libvirt Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// WARNING: This file has automatically been generated
// Code generated by https://git.io/c-for-go. DO NOT EDIT.

package libvirt

const (
	// Deprecated as defined in libvirt/libvirt-common.h:40
	Deprecated = 0x618a00
	// ExportVar as defined in libvirt/libvirt-common.h:57
	ExportVar = 0x618a00
	// TypedParamFieldLength as defined in libvirt/libvirt-common.h:188
	TypedParamFieldLength = 80
	// DomainSchedulerCPUShares as defined in libvirt/libvirt-domain.h:388
	DomainSchedulerCPUShares = "cpu_shares"
	// DomainSchedulerGlobalPeriod as defined in libvirt/libvirt-domain.h:398
	DomainSchedulerGlobalPeriod = "global_period"
	// DomainSchedulerGlobalQuota as defined in libvirt/libvirt-domain.h:408
	DomainSchedulerGlobalQuota = "global_quota"
	// DomainSchedulerVCPUPeriod as defined in libvirt/libvirt-domain.h:418
	DomainSchedulerVCPUPeriod = "vcpu_period"
	// DomainSchedulerVCPUQuota as defined in libvirt/libvirt-domain.h:428
	DomainSchedulerVCPUQuota = "vcpu_quota"
	// DomainSchedulerEmulatorPeriod as defined in libvirt/libvirt-domain.h:439
	DomainSchedulerEmulatorPeriod = "emulator_period"
	// DomainSchedulerEmulatorQuota as defined in libvirt/libvirt-domain.h:450
	DomainSchedulerEmulatorQuota = "emulator_quota"
	// DomainSchedulerIothreadPeriod as defined in libvirt/libvirt-domain.h:460
	DomainSchedulerIothreadPeriod = "iothread_period"
	// DomainSchedulerIothreadQuota as defined in libvirt/libvirt-domain.h:470
	DomainSchedulerIothreadQuota = "iothread_quota"
	// DomainSchedulerWeight as defined in libvirt/libvirt-domain.h:480
	DomainSchedulerWeight = "weight"
	// DomainSchedulerCap as defined in libvirt/libvirt-domain.h:490
	DomainSchedulerCap = "cap"
	// DomainSchedulerReservation as defined in libvirt/libvirt-domain.h:500
	DomainSchedulerReservation = "reservation"
	// DomainSchedulerLimit as defined in libvirt/libvirt-domain.h:510
	DomainSchedulerLimit = "limit"
	// DomainSchedulerShares as defined in libvirt/libvirt-domain.h:520
	DomainSchedulerShares = "shares"
	// DomainBlockStatsFieldLength as defined in libvirt/libvirt-domain.h:584
	DomainBlockStatsFieldLength = TypedParamFieldLength
	// DomainBlockStatsReadBytes as defined in libvirt/libvirt-domain.h:594
	DomainBlockStatsReadBytes = "rd_bytes"
	// DomainBlockStatsReadReq as defined in libvirt/libvirt-domain.h:604
	DomainBlockStatsReadReq = "rd_operations"
	// DomainBlockStatsReadTotalTimes as defined in libvirt/libvirt-domain.h:614
	DomainBlockStatsReadTotalTimes = "rd_total_times"
	// DomainBlockStatsWriteBytes as defined in libvirt/libvirt-domain.h:624
	DomainBlockStatsWriteBytes = "wr_bytes"
	// DomainBlockStatsWriteReq as defined in libvirt/libvirt-domain.h:634
	DomainBlockStatsWriteReq = "wr_operations"
	// DomainBlockStatsWriteTotalTimes as defined in libvirt/libvirt-domain.h:644
	DomainBlockStatsWriteTotalTimes = "wr_total_times"
	// DomainBlockStatsFlushReq as defined in libvirt/libvirt-domain.h:654
	DomainBlockStatsFlushReq = "flush_operations"
	// DomainBlockStatsFlushTotalTimes as defined in libvirt/libvirt-domain.h:664
	DomainBlockStatsFlushTotalTimes = "flush_total_times"
	// DomainBlockStatsErrs as defined in libvirt/libvirt-domain.h:673
	DomainBlockStatsErrs = "errs"
	// MigrateParamURI as defined in libvirt/libvirt-domain.h:1134
	MigrateParamURI = "migrate_uri"
	// MigrateParamDestName as defined in libvirt/libvirt-domain.h:1146
	MigrateParamDestName = "destination_name"
	// MigrateParamDestXML as defined in libvirt/libvirt-domain.h:1167
	MigrateParamDestXML = "destination_xml"
	// MigrateParamPersistXML as defined in libvirt/libvirt-domain.h:1184
	MigrateParamPersistXML = "persistent_xml"
	// MigrateParamBandwidth as defined in libvirt/libvirt-domain.h:1196
	MigrateParamBandwidth = "bandwidth"
	// MigrateParamBandwidthPostcopy as defined in libvirt/libvirt-domain.h:1207
	MigrateParamBandwidthPostcopy = "bandwidth.postcopy"
	// MigrateParamBandwidthAvailSwitchover as defined in libvirt/libvirt-domain.h:1225
	MigrateParamBandwidthAvailSwitchover = "bandwidth.avail.switchover"
	// MigrateParamGraphicsURI as defined in libvirt/libvirt-domain.h:1248
	MigrateParamGraphicsURI = "graphics_uri"
	// MigrateParamListenAddress as defined in libvirt/libvirt-domain.h:1261
	MigrateParamListenAddress = "listen_address"
	// MigrateParamMigrateDisks as defined in libvirt/libvirt-domain.h:1272
	MigrateParamMigrateDisks = "migrate_disks"
	// MigrateParamMigrateDisksDetectZeroes as defined in libvirt/libvirt-domain.h:1286
	MigrateParamMigrateDisksDetectZeroes = "migrate_disks_detect_zeroes"
	// MigrateParamDisksPort as defined in libvirt/libvirt-domain.h:1298
	MigrateParamDisksPort = "disks_port"
	// MigrateParamDisksURI as defined in libvirt/libvirt-domain.h:1313
	MigrateParamDisksURI = "disks_uri"
	// MigrateParamCompression as defined in libvirt/libvirt-domain.h:1327
	MigrateParamCompression = "compression"
	// MigrateParamCompressionMtLevel as defined in libvirt/libvirt-domain.h:1338
	MigrateParamCompressionMtLevel = "compression.mt.level"
	// MigrateParamCompressionMtThreads as defined in libvirt/libvirt-domain.h:1348
	MigrateParamCompressionMtThreads = "compression.mt.threads"
	// MigrateParamCompressionMtDthreads as defined in libvirt/libvirt-domain.h:1358
	MigrateParamCompressionMtDthreads = "compression.mt.dthreads"
	// MigrateParamCompressionXbzrleCache as defined in libvirt/libvirt-domain.h:1368
	MigrateParamCompressionXbzrleCache = "compression.xbzrle.cache"
	// MigrateParamCompressionZlibLevel as defined in libvirt/libvirt-domain.h:1379
	MigrateParamCompressionZlibLevel = "compression.zlib.level"
	// MigrateParamCompressionZstdLevel as defined in libvirt/libvirt-domain.h:1390
	MigrateParamCompressionZstdLevel = "compression.zstd.level"
	// MigrateParamAutoConvergeInitial as defined in libvirt/libvirt-domain.h:1401
	MigrateParamAutoConvergeInitial = "auto_converge.initial"
	// MigrateParamAutoConvergeIncrement as defined in libvirt/libvirt-domain.h:1413
	MigrateParamAutoConvergeIncrement = "auto_converge.increment"
	// MigrateParamParallelConnections as defined in libvirt/libvirt-domain.h:1423
	MigrateParamParallelConnections = "parallel.connections"
	// MigrateParamTLSDestination as defined in libvirt/libvirt-domain.h:1439
	MigrateParamTLSDestination = "tls.destination"
	// DomainSaveParamFile as defined in libvirt/libvirt-domain.h:1686
	DomainSaveParamFile = "file"
	// DomainSaveParamDxml as defined in libvirt/libvirt-domain.h:1699
	DomainSaveParamDxml = "dxml"
	// DomainSaveParamImageFormat as defined in libvirt/libvirt-domain.h:1711
	DomainSaveParamImageFormat = "image_format"
	// DomainSaveParamParallelChannels as defined in libvirt/libvirt-domain.h:1721
	DomainSaveParamParallelChannels = "parallel.channels"
	// DomainCPUStatsCputime as defined in libvirt/libvirt-domain.h:1790
	DomainCPUStatsCputime = "cpu_time"
	// DomainCPUStatsUsertime as defined in libvirt/libvirt-domain.h:1798
	DomainCPUStatsUsertime = "user_time"
	// DomainCPUStatsSystemtime as defined in libvirt/libvirt-domain.h:1806
	DomainCPUStatsSystemtime = "system_time"
	// DomainCPUStatsVcputime as defined in libvirt/libvirt-domain.h:1815
	DomainCPUStatsVcputime = "vcpu_time"
	// DomainBlkioWeight as defined in libvirt/libvirt-domain.h:1845
	DomainBlkioWeight = "weight"
	// DomainBlkioDeviceWeight as defined in libvirt/libvirt-domain.h:1856
	DomainBlkioDeviceWeight = "device_weight"
	// DomainBlkioDeviceReadIops as defined in libvirt/libvirt-domain.h:1868
	DomainBlkioDeviceReadIops = "device_read_iops_sec"
	// DomainBlkioDeviceWriteIops as defined in libvirt/libvirt-domain.h:1881
	DomainBlkioDeviceWriteIops = "device_write_iops_sec"
	// DomainBlkioDeviceReadBps as defined in libvirt/libvirt-domain.h:1894
	DomainBlkioDeviceReadBps = "device_read_bytes_sec"
	// DomainBlkioDeviceWriteBps as defined in libvirt/libvirt-domain.h:1907
	DomainBlkioDeviceWriteBps = "device_write_bytes_sec"
	// DomainMemoryParamUnlimited as defined in libvirt/libvirt-domain.h:1927
	DomainMemoryParamUnlimited = int64(9007199254740991)
	// DomainMemoryHardLimit as defined in libvirt/libvirt-domain.h:1937
	DomainMemoryHardLimit = "hard_limit"
	// DomainMemorySoftLimit as defined in libvirt/libvirt-domain.h:1947
	DomainMemorySoftLimit = "soft_limit"
	// DomainMemoryMinGuarantee as defined in libvirt/libvirt-domain.h:1957
	DomainMemoryMinGuarantee = "min_guarantee"
	// DomainMemorySwapHardLimit as defined in libvirt/libvirt-domain.h:1968
	DomainMemorySwapHardLimit = "swap_hard_limit"
	// DomainNumaNodeset as defined in libvirt/libvirt-domain.h:2022
	DomainNumaNodeset = "numa_nodeset"
	// DomainNumaMode as defined in libvirt/libvirt-domain.h:2032
	DomainNumaMode = "numa_mode"
	// DomainBandwidthInAverage as defined in libvirt/libvirt-domain.h:2172
	DomainBandwidthInAverage = "inbound.average"
	// DomainBandwidthInPeak as defined in libvirt/libvirt-domain.h:2181
	DomainBandwidthInPeak = "inbound.peak"
	// DomainBandwidthInBurst as defined in libvirt/libvirt-domain.h:2190
	DomainBandwidthInBurst = "inbound.burst"
	// DomainBandwidthInFloor as defined in libvirt/libvirt-domain.h:2199
	DomainBandwidthInFloor = "inbound.floor"
	// DomainBandwidthOutAverage as defined in libvirt/libvirt-domain.h:2208
	DomainBandwidthOutAverage = "outbound.average"
	// DomainBandwidthOutPeak as defined in libvirt/libvirt-domain.h:2217
	DomainBandwidthOutPeak = "outbound.peak"
	// DomainBandwidthOutBurst as defined in libvirt/libvirt-domain.h:2226
	DomainBandwidthOutBurst = "outbound.burst"
	// DomainIothreadPollMaxNs as defined in libvirt/libvirt-domain.h:2599
	DomainIothreadPollMaxNs = "poll_max_ns"
	// DomainIothreadPollGrow as defined in libvirt/libvirt-domain.h:2612
	DomainIothreadPollGrow = "poll_grow"
	// DomainIothreadPollShrink as defined in libvirt/libvirt-domain.h:2626
	DomainIothreadPollShrink = "poll_shrink"
	// DomainIothreadThreadPoolMin as defined in libvirt/libvirt-domain.h:2637
	DomainIothreadThreadPoolMin = "thread_pool_min"
	// DomainIothreadThreadPoolMax as defined in libvirt/libvirt-domain.h:2650
	DomainIothreadThreadPoolMax = "thread_pool_max"
	// DomainStatsStateState as defined in libvirt/libvirt-domain.h:2818
	DomainStatsStateState = "state.state"
	// DomainStatsStateReason as defined in libvirt/libvirt-domain.h:2828
	DomainStatsStateReason = "state.reason"
	// DomainStatsCPUTime as defined in libvirt/libvirt-domain.h:2838
	DomainStatsCPUTime = "cpu.time"
	// DomainStatsCPUUser as defined in libvirt/libvirt-domain.h:2847
	DomainStatsCPUUser = "cpu.user"
	// DomainStatsCPUSystem as defined in libvirt/libvirt-domain.h:2856
	DomainStatsCPUSystem = "cpu.system"
	// DomainStatsCPUHaltpollSuccessTime as defined in libvirt/libvirt-domain.h:2866
	DomainStatsCPUHaltpollSuccessTime = "cpu.haltpoll.success.time"
	// DomainStatsCPUHaltpollFailTime as defined in libvirt/libvirt-domain.h:2877
	DomainStatsCPUHaltpollFailTime = "cpu.haltpoll.fail.time"
	// DomainStatsCPUCacheMonitorCount as defined in libvirt/libvirt-domain.h:2886
	DomainStatsCPUCacheMonitorCount = "cpu.cache.monitor.count"
	// DomainStatsCPUCacheMonitorPrefix as defined in libvirt/libvirt-domain.h:2897
	DomainStatsCPUCacheMonitorPrefix = "cpu.cache.monitor."
	// DomainStatsCPUCacheMonitorSuffixName as defined in libvirt/libvirt-domain.h:2906
	DomainStatsCPUCacheMonitorSuffixName = ".name"
	// DomainStatsCPUCacheMonitorSuffixVcpus as defined in libvirt/libvirt-domain.h:2915
	DomainStatsCPUCacheMonitorSuffixVcpus = ".vcpus"
	// DomainStatsCPUCacheMonitorSuffixBankCount as defined in libvirt/libvirt-domain.h:2924
	DomainStatsCPUCacheMonitorSuffixBankCount = ".bank.count"
	// DomainStatsCPUCacheMonitorSuffixBankPrefix as defined in libvirt/libvirt-domain.h:2937
	DomainStatsCPUCacheMonitorSuffixBankPrefix = ".bank."
	// DomainStatsCPUCacheMonitorSuffixBankSuffixID as defined in libvirt/libvirt-domain.h:2946
	DomainStatsCPUCacheMonitorSuffixBankSuffixID = ".id"
	// DomainStatsCPUCacheMonitorSuffixBankSuffixBytes as defined in libvirt/libvirt-domain.h:2956
	DomainStatsCPUCacheMonitorSuffixBankSuffixBytes = ".bytes"
	// DomainStatsBalloonCurrent as defined in libvirt/libvirt-domain.h:2966
	DomainStatsBalloonCurrent = "balloon.current"
	// DomainStatsBalloonMaximum as defined in libvirt/libvirt-domain.h:2975
	DomainStatsBalloonMaximum = "balloon.maximum"
	// DomainStatsBalloonSwapIn as defined in libvirt/libvirt-domain.h:2984
	DomainStatsBalloonSwapIn = "balloon.swap_in"
	// DomainStatsBalloonSwapOut as defined in libvirt/libvirt-domain.h:2994
	DomainStatsBalloonSwapOut = "balloon.swap_out"
	// DomainStatsBalloonMajorFault as defined in libvirt/libvirt-domain.h:3003
	DomainStatsBalloonMajorFault = "balloon.major_fault"
	// DomainStatsBalloonMinorFault as defined in libvirt/libvirt-domain.h:3012
	DomainStatsBalloonMinorFault = "balloon.minor_fault"
	// DomainStatsBalloonUnused as defined in libvirt/libvirt-domain.h:3022
	DomainStatsBalloonUnused = "balloon.unused"
	// DomainStatsBalloonAvailable as defined in libvirt/libvirt-domain.h:3032
	DomainStatsBalloonAvailable = "balloon.available"
	// DomainStatsBalloonRss as defined in libvirt/libvirt-domain.h:3042
	DomainStatsBalloonRss = "balloon.rss"
	// DomainStatsBalloonUsable as defined in libvirt/libvirt-domain.h:3052
	DomainStatsBalloonUsable = "balloon.usable"
	// DomainStatsBalloonLastUpdate as defined in libvirt/libvirt-domain.h:3062
	DomainStatsBalloonLastUpdate = "balloon.last-update"
	// DomainStatsBalloonDiskCaches as defined in libvirt/libvirt-domain.h:3072
	DomainStatsBalloonDiskCaches = "balloon.disk_caches"
	// DomainStatsBalloonHugetlbPgalloc as defined in libvirt/libvirt-domain.h:3082
	DomainStatsBalloonHugetlbPgalloc = "balloon.hugetlb_pgalloc"
	// DomainStatsBalloonHugetlbPgfail as defined in libvirt/libvirt-domain.h:3092
	DomainStatsBalloonHugetlbPgfail = "balloon.hugetlb_pgfail"
	// DomainStatsVCPUCurrent as defined in libvirt/libvirt-domain.h:3102
	DomainStatsVCPUCurrent = "vcpu.current"
	// DomainStatsVCPUMaximum as defined in libvirt/libvirt-domain.h:3111
	DomainStatsVCPUMaximum = "vcpu.maximum"
	// DomainStatsVCPUPrefix as defined in libvirt/libvirt-domain.h:3126
	DomainStatsVCPUPrefix = "vcpu."
	// DomainStatsVCPUSuffixState as defined in libvirt/libvirt-domain.h:3135
	DomainStatsVCPUSuffixState = ".state"
	// DomainStatsVCPUSuffixTime as defined in libvirt/libvirt-domain.h:3144
	DomainStatsVCPUSuffixTime = ".time"
	// DomainStatsVCPUSuffixWait as defined in libvirt/libvirt-domain.h:3154
	DomainStatsVCPUSuffixWait = ".wait"
	// DomainStatsVCPUSuffixHalted as defined in libvirt/libvirt-domain.h:3164
	DomainStatsVCPUSuffixHalted = ".halted"
	// DomainStatsVCPUSuffixDelay as defined in libvirt/libvirt-domain.h:3175
	DomainStatsVCPUSuffixDelay = ".delay"
	// DomainStatsCustomSuffixTypeCur as defined in libvirt/libvirt-domain.h:3189
	DomainStatsCustomSuffixTypeCur = ".cur"
	// DomainStatsCustomSuffixTypeSum as defined in libvirt/libvirt-domain.h:3202
	DomainStatsCustomSuffixTypeSum = ".sum"
	// DomainStatsCustomSuffixTypeMax as defined in libvirt/libvirt-domain.h:3215
	DomainStatsCustomSuffixTypeMax = ".max"
	// DomainStatsNetCount as defined in libvirt/libvirt-domain.h:3225
	DomainStatsNetCount = "net.count"
	// DomainStatsNetPrefix as defined in libvirt/libvirt-domain.h:3236
	DomainStatsNetPrefix = "net."
	// DomainStatsNetSuffixName as defined in libvirt/libvirt-domain.h:3245
	DomainStatsNetSuffixName = ".name"
	// DomainStatsNetSuffixRxBytes as defined in libvirt/libvirt-domain.h:3254
	DomainStatsNetSuffixRxBytes = ".rx.bytes"
	// DomainStatsNetSuffixRxPkts as defined in libvirt/libvirt-domain.h:3263
	DomainStatsNetSuffixRxPkts = ".rx.pkts"
	// DomainStatsNetSuffixRxErrs as defined in libvirt/libvirt-domain.h:3272
	DomainStatsNetSuffixRxErrs = ".rx.errs"
	// DomainStatsNetSuffixRxDrop as defined in libvirt/libvirt-domain.h:3281
	DomainStatsNetSuffixRxDrop = ".rx.drop"
	// DomainStatsNetSuffixTxBytes as defined in libvirt/libvirt-domain.h:3290
	DomainStatsNetSuffixTxBytes = ".tx.bytes"
	// DomainStatsNetSuffixTxPkts as defined in libvirt/libvirt-domain.h:3299
	DomainStatsNetSuffixTxPkts = ".tx.pkts"
	// DomainStatsNetSuffixTxErrs as defined in libvirt/libvirt-domain.h:3308
	DomainStatsNetSuffixTxErrs = ".tx.errs"
	// DomainStatsNetSuffixTxDrop as defined in libvirt/libvirt-domain.h:3317
	DomainStatsNetSuffixTxDrop = ".tx.drop"
	// DomainStatsBlockCount as defined in libvirt/libvirt-domain.h:3327
	DomainStatsBlockCount = "block.count"
	// DomainStatsBlockPrefix as defined in libvirt/libvirt-domain.h:3338
	DomainStatsBlockPrefix = "block."
	// DomainStatsBlockSuffixName as defined in libvirt/libvirt-domain.h:3349
	DomainStatsBlockSuffixName = ".name"
	// DomainStatsBlockSuffixBackingindex as defined in libvirt/libvirt-domain.h:3359
	DomainStatsBlockSuffixBackingindex = ".backingIndex"
	// DomainStatsBlockSuffixPath as defined in libvirt/libvirt-domain.h:3369
	DomainStatsBlockSuffixPath = ".path"
	// DomainStatsBlockSuffixRdReqs as defined in libvirt/libvirt-domain.h:3378
	DomainStatsBlockSuffixRdReqs = ".rd.reqs"
	// DomainStatsBlockSuffixRdBytes as defined in libvirt/libvirt-domain.h:3387
	DomainStatsBlockSuffixRdBytes = ".rd.bytes"
	// DomainStatsBlockSuffixRdTimes as defined in libvirt/libvirt-domain.h:3396
	DomainStatsBlockSuffixRdTimes = ".rd.times"
	// DomainStatsBlockSuffixWrReqs as defined in libvirt/libvirt-domain.h:3405
	DomainStatsBlockSuffixWrReqs = ".wr.reqs"
	// DomainStatsBlockSuffixWrBytes as defined in libvirt/libvirt-domain.h:3414
	DomainStatsBlockSuffixWrBytes = ".wr.bytes"
	// DomainStatsBlockSuffixWrTimes as defined in libvirt/libvirt-domain.h:3423
	DomainStatsBlockSuffixWrTimes = ".wr.times"
	// DomainStatsBlockSuffixFlReqs as defined in libvirt/libvirt-domain.h:3432
	DomainStatsBlockSuffixFlReqs = ".fl.reqs"
	// DomainStatsBlockSuffixFlTimes as defined in libvirt/libvirt-domain.h:3441
	DomainStatsBlockSuffixFlTimes = ".fl.times"
	// DomainStatsBlockSuffixErrors as defined in libvirt/libvirt-domain.h:3450
	DomainStatsBlockSuffixErrors = ".errors"
	// DomainStatsBlockSuffixAllocation as defined in libvirt/libvirt-domain.h:3459
	DomainStatsBlockSuffixAllocation = ".allocation"
	// DomainStatsBlockSuffixCapacity as defined in libvirt/libvirt-domain.h:3469
	DomainStatsBlockSuffixCapacity = ".capacity"
	// DomainStatsBlockSuffixPhysical as defined in libvirt/libvirt-domain.h:3479
	DomainStatsBlockSuffixPhysical = ".physical"
	// DomainStatsBlockSuffixThreshold as defined in libvirt/libvirt-domain.h:3489
	DomainStatsBlockSuffixThreshold = ".threshold"
	// DomainStatsPerfCmt as defined in libvirt/libvirt-domain.h:3500
	DomainStatsPerfCmt = "perf.cmt"
	// DomainStatsPerfMbmt as defined in libvirt/libvirt-domain.h:3510
	DomainStatsPerfMbmt = "perf.mbmt"
	// DomainStatsPerfMbml as defined in libvirt/libvirt-domain.h:3520
	DomainStatsPerfMbml = "perf.mbml"
	// DomainStatsPerfCacheMisses as defined in libvirt/libvirt-domain.h:3530
	DomainStatsPerfCacheMisses = "perf.cache_misses"
	// DomainStatsPerfCacheReferences as defined in libvirt/libvirt-domain.h:3540
	DomainStatsPerfCacheReferences = "perf.cache_references"
	// DomainStatsPerfInstructions as defined in libvirt/libvirt-domain.h:3550
	DomainStatsPerfInstructions = "perf.instructions"
	// DomainStatsPerfCPUCycles as defined in libvirt/libvirt-domain.h:3560
	DomainStatsPerfCPUCycles = "perf.cpu_cycles"
	// DomainStatsPerfBranchInstructions as defined in libvirt/libvirt-domain.h:3570
	DomainStatsPerfBranchInstructions = "perf.branch_instructions"
	// DomainStatsPerfBranchMisses as defined in libvirt/libvirt-domain.h:3580
	DomainStatsPerfBranchMisses = "perf.branch_misses"
	// DomainStatsPerfBusCycles as defined in libvirt/libvirt-domain.h:3590
	DomainStatsPerfBusCycles = "perf.bus_cycles"
	// DomainStatsPerfStalledCyclesFrontend as defined in libvirt/libvirt-domain.h:3601
	DomainStatsPerfStalledCyclesFrontend = "perf.stalled_cycles_frontend"
	// DomainStatsPerfStalledCyclesBackend as defined in libvirt/libvirt-domain.h:3612
	DomainStatsPerfStalledCyclesBackend = "perf.stalled_cycles_backend"
	// DomainStatsPerfRefCPUCycles as defined in libvirt/libvirt-domain.h:3623
	DomainStatsPerfRefCPUCycles = "perf.ref_cpu_cycles"
	// DomainStatsPerfCPUClock as defined in libvirt/libvirt-domain.h:3633
	DomainStatsPerfCPUClock = "perf.cpu_clock"
	// DomainStatsPerfTaskClock as defined in libvirt/libvirt-domain.h:3643
	DomainStatsPerfTaskClock = "perf.task_clock"
	// DomainStatsPerfPageFaults as defined in libvirt/libvirt-domain.h:3653
	DomainStatsPerfPageFaults = "perf.page_faults"
	// DomainStatsPerfContextSwitches as defined in libvirt/libvirt-domain.h:3663
	DomainStatsPerfContextSwitches = "perf.context_switches"
	// DomainStatsPerfCPUMigrations as defined in libvirt/libvirt-domain.h:3673
	DomainStatsPerfCPUMigrations = "perf.cpu_migrations"
	// DomainStatsPerfPageFaultsMin as defined in libvirt/libvirt-domain.h:3683
	DomainStatsPerfPageFaultsMin = "perf.page_faults_min"
	// DomainStatsPerfPageFaultsMaj as defined in libvirt/libvirt-domain.h:3693
	DomainStatsPerfPageFaultsMaj = "perf.page_faults_maj"
	// DomainStatsPerfAlignmentFaults as defined in libvirt/libvirt-domain.h:3703
	DomainStatsPerfAlignmentFaults = "perf.alignment_faults"
	// DomainStatsPerfEmulationFaults as defined in libvirt/libvirt-domain.h:3713
	DomainStatsPerfEmulationFaults = "perf.emulation_faults"
	// DomainStatsIothreadCount as defined in libvirt/libvirt-domain.h:3726
	DomainStatsIothreadCount = "iothread.count"
	// DomainStatsIothreadPrefix as defined in libvirt/libvirt-domain.h:3737
	DomainStatsIothreadPrefix = "iothread."
	// DomainStatsIothreadSuffixPollMaxNs as defined in libvirt/libvirt-domain.h:3747
	DomainStatsIothreadSuffixPollMaxNs = ".poll-max-ns"
	// DomainStatsIothreadSuffixPollGrow as defined in libvirt/libvirt-domain.h:3758
	DomainStatsIothreadSuffixPollGrow = ".poll-grow"
	// DomainStatsIothreadSuffixPollShrink as defined in libvirt/libvirt-domain.h:3769
	DomainStatsIothreadSuffixPollShrink = ".poll-shrink"
	// DomainStatsMemoryBandwidthMonitorCount as defined in libvirt/libvirt-domain.h:3779
	DomainStatsMemoryBandwidthMonitorCount = "memory.bandwidth.monitor.count"
	// DomainStatsMemoryBandwidthMonitorPrefix as defined in libvirt/libvirt-domain.h:3791
	DomainStatsMemoryBandwidthMonitorPrefix = "memory.bandwidth.monitor."
	// DomainStatsMemoryBandwidthMonitorSuffixName as defined in libvirt/libvirt-domain.h:3800
	DomainStatsMemoryBandwidthMonitorSuffixName = ".name"
	// DomainStatsMemoryBandwidthMonitorSuffixVcpus as defined in libvirt/libvirt-domain.h:3809
	DomainStatsMemoryBandwidthMonitorSuffixVcpus = ".vcpus"
	// DomainStatsMemoryBandwidthMonitorSuffixNodeCount as defined in libvirt/libvirt-domain.h:3818
	DomainStatsMemoryBandwidthMonitorSuffixNodeCount = ".node.count"
	// DomainStatsMemoryBandwidthMonitorSuffixNodePrefix as defined in libvirt/libvirt-domain.h:3831
	DomainStatsMemoryBandwidthMonitorSuffixNodePrefix = ".node."
	// DomainStatsMemoryBandwidthMonitorSuffixNodeSuffixID as defined in libvirt/libvirt-domain.h:3840
	DomainStatsMemoryBandwidthMonitorSuffixNodeSuffixID = ".id"
	// DomainStatsMemoryBandwidthMonitorSuffixNodeSuffixBytesLocal as defined in libvirt/libvirt-domain.h:3851
	DomainStatsMemoryBandwidthMonitorSuffixNodeSuffixBytesLocal = ".bytes.local"
	// DomainStatsMemoryBandwidthMonitorSuffixNodeSuffixBytesTotal as defined in libvirt/libvirt-domain.h:3861
	DomainStatsMemoryBandwidthMonitorSuffixNodeSuffixBytesTotal = ".bytes.total"
	// DomainStatsDirtyrateCalcStatus as defined in libvirt/libvirt-domain.h:3872
	DomainStatsDirtyrateCalcStatus = "dirtyrate.calc_status"
	// DomainStatsDirtyrateCalcStartTime as defined in libvirt/libvirt-domain.h:3882
	DomainStatsDirtyrateCalcStartTime = "dirtyrate.calc_start_time"
	// DomainStatsDirtyrateCalcPeriod as defined in libvirt/libvirt-domain.h:3891
	DomainStatsDirtyrateCalcPeriod = "dirtyrate.calc_period"
	// DomainStatsDirtyrateMegabytesPerSecond as defined in libvirt/libvirt-domain.h:3901
	DomainStatsDirtyrateMegabytesPerSecond = "dirtyrate.megabytes_per_second"
	// DomainStatsDirtyrateCalcMode as defined in libvirt/libvirt-domain.h:3911
	DomainStatsDirtyrateCalcMode = "dirtyrate.calc_mode"
	// DomainStatsDirtyrateVCPUPrefix as defined in libvirt/libvirt-domain.h:3922
	DomainStatsDirtyrateVCPUPrefix = "dirtyrate.vcpu."
	// DomainStatsDirtyrateVCPUSuffixMegabytesPerSecond as defined in libvirt/libvirt-domain.h:3931
	DomainStatsDirtyrateVCPUSuffixMegabytesPerSecond = ".megabytes_per_second"
	// DomainStatsVmPrefix as defined in libvirt/libvirt-domain.h:3943
	DomainStatsVmPrefix = "vm."
	// PerfParamCmt as defined in libvirt/libvirt-domain.h:4013
	PerfParamCmt = "cmt"
	// PerfParamMbmt as defined in libvirt/libvirt-domain.h:4025
	PerfParamMbmt = "mbmt"
	// PerfParamMbml as defined in libvirt/libvirt-domain.h:4037
	PerfParamMbml = "mbml"
	// PerfParamCacheMisses as defined in libvirt/libvirt-domain.h:4049
	PerfParamCacheMisses = "cache_misses"
	// PerfParamCacheReferences as defined in libvirt/libvirt-domain.h:4061
	PerfParamCacheReferences = "cache_references"
	// PerfParamInstructions as defined in libvirt/libvirt-domain.h:4073
	PerfParamInstructions = "instructions"
	// PerfParamCPUCycles as defined in libvirt/libvirt-domain.h:4085
	PerfParamCPUCycles = "cpu_cycles"
	// PerfParamBranchInstructions as defined in libvirt/libvirt-domain.h:4097
	PerfParamBranchInstructions = "branch_instructions"
	// PerfParamBranchMisses as defined in libvirt/libvirt-domain.h:4109
	PerfParamBranchMisses = "branch_misses"
	// PerfParamBusCycles as defined in libvirt/libvirt-domain.h:4121
	PerfParamBusCycles = "bus_cycles"
	// PerfParamStalledCyclesFrontend as defined in libvirt/libvirt-domain.h:4134
	PerfParamStalledCyclesFrontend = "stalled_cycles_frontend"
	// PerfParamStalledCyclesBackend as defined in libvirt/libvirt-domain.h:4147
	PerfParamStalledCyclesBackend = "stalled_cycles_backend"
	// PerfParamRefCPUCycles as defined in libvirt/libvirt-domain.h:4160
	PerfParamRefCPUCycles = "ref_cpu_cycles"
	// PerfParamCPUClock as defined in libvirt/libvirt-domain.h:4173
	PerfParamCPUClock = "cpu_clock"
	// PerfParamTaskClock as defined in libvirt/libvirt-domain.h:4186
	PerfParamTaskClock = "task_clock"
	// PerfParamPageFaults as defined in libvirt/libvirt-domain.h:4198
	PerfParamPageFaults = "page_faults"
	// PerfParamContextSwitches as defined in libvirt/libvirt-domain.h:4210
	PerfParamContextSwitches = "context_switches"
	// PerfParamCPUMigrations as defined in libvirt/libvirt-domain.h:4222
	PerfParamCPUMigrations = "cpu_migrations"
	// PerfParamPageFaultsMin as defined in libvirt/libvirt-domain.h:4234
	PerfParamPageFaultsMin = "page_faults_min"
	// PerfParamPageFaultsMaj as defined in libvirt/libvirt-domain.h:4246
	PerfParamPageFaultsMaj = "page_faults_maj"
	// PerfParamAlignmentFaults as defined in libvirt/libvirt-domain.h:4258
	PerfParamAlignmentFaults = "alignment_faults"
	// PerfParamEmulationFaults as defined in libvirt/libvirt-domain.h:4270
	PerfParamEmulationFaults = "emulation_faults"
	// DomainBlockCopyBandwidth as defined in libvirt/libvirt-domain.h:4506
	DomainBlockCopyBandwidth = "bandwidth"
	// DomainBlockCopyGranularity as defined in libvirt/libvirt-domain.h:4519
	DomainBlockCopyGranularity = "granularity"
	// DomainBlockCopyBufSize as defined in libvirt/libvirt-domain.h:4530
	DomainBlockCopyBufSize = "buf-size"
	// DomainBlockIotuneTotalBytesSec as defined in libvirt/libvirt-domain.h:4575
	DomainBlockIotuneTotalBytesSec = "total_bytes_sec"
	// DomainBlockIotuneReadBytesSec as defined in libvirt/libvirt-domain.h:4585
	DomainBlockIotuneReadBytesSec = "read_bytes_sec"
	// DomainBlockIotuneWriteBytesSec as defined in libvirt/libvirt-domain.h:4595
	DomainBlockIotuneWriteBytesSec = "write_bytes_sec"
	// DomainBlockIotuneTotalIopsSec as defined in libvirt/libvirt-domain.h:4605
	DomainBlockIotuneTotalIopsSec = "total_iops_sec"
	// DomainBlockIotuneReadIopsSec as defined in libvirt/libvirt-domain.h:4615
	DomainBlockIotuneReadIopsSec = "read_iops_sec"
	// DomainBlockIotuneWriteIopsSec as defined in libvirt/libvirt-domain.h:4624
	DomainBlockIotuneWriteIopsSec = "write_iops_sec"
	// DomainBlockIotuneTotalBytesSecMax as defined in libvirt/libvirt-domain.h:4634
	DomainBlockIotuneTotalBytesSecMax = "total_bytes_sec_max"
	// DomainBlockIotuneReadBytesSecMax as defined in libvirt/libvirt-domain.h:4644
	DomainBlockIotuneReadBytesSecMax = "read_bytes_sec_max"
	// DomainBlockIotuneWriteBytesSecMax as defined in libvirt/libvirt-domain.h:4654
	DomainBlockIotuneWriteBytesSecMax = "write_bytes_sec_max"
	// DomainBlockIotuneTotalIopsSecMax as defined in libvirt/libvirt-domain.h:4664
	DomainBlockIotuneTotalIopsSecMax = "total_iops_sec_max"
	// DomainBlockIotuneReadIopsSecMax as defined in libvirt/libvirt-domain.h:4674
	DomainBlockIotuneReadIopsSecMax = "read_iops_sec_max"
	// DomainBlockIotuneWriteIopsSecMax as defined in libvirt/libvirt-domain.h:4683
	DomainBlockIotuneWriteIopsSecMax = "write_iops_sec_max"
	// DomainBlockIotuneTotalBytesSecMaxLength as defined in libvirt/libvirt-domain.h:4693
	DomainBlockIotuneTotalBytesSecMaxLength = "total_bytes_sec_max_length"
	// DomainBlockIotuneReadBytesSecMaxLength as defined in libvirt/libvirt-domain.h:4703
	DomainBlockIotuneReadBytesSecMaxLength = "read_bytes_sec_max_length"
	// DomainBlockIotuneWriteBytesSecMaxLength as defined in libvirt/libvirt-domain.h:4713
	DomainBlockIotuneWriteBytesSecMaxLength = "write_bytes_sec_max_length"
	// DomainBlockIotuneTotalIopsSecMaxLength as defined in libvirt/libvirt-domain.h:4723
	DomainBlockIotuneTotalIopsSecMaxLength = "total_iops_sec_max_length"
	// DomainBlockIotuneReadIopsSecMaxLength as defined in libvirt/libvirt-domain.h:4733
	DomainBlockIotuneReadIopsSecMaxLength = "read_iops_sec_max_length"
	// DomainBlockIotuneWriteIopsSecMaxLength as defined in libvirt/libvirt-domain.h:4743
	DomainBlockIotuneWriteIopsSecMaxLength = "write_iops_sec_max_length"
	// DomainBlockIotuneSizeIopsSec as defined in libvirt/libvirt-domain.h:4752
	DomainBlockIotuneSizeIopsSec = "size_iops_sec"
	// DomainBlockIotuneGroupName as defined in libvirt/libvirt-domain.h:4761
	DomainBlockIotuneGroupName = "group_name"
	// KeycodeSetRfb as defined in libvirt/libvirt-domain.h:4857
	KeycodeSetRfb = 0x618a00
	// DomainSendKeyMaxKeys as defined in libvirt/libvirt-domain.h:4866
	DomainSendKeyMaxKeys = 16
	// DomainJobOperationStr as defined in libvirt/libvirt-domain.h:5441
	DomainJobOperationStr = "operation"
	// DomainJobTimeElapsed as defined in libvirt/libvirt-domain.h:5453
	DomainJobTimeElapsed = "time_elapsed"
	// DomainJobTimeElapsedNet as defined in libvirt/libvirt-domain.h:5465
	DomainJobTimeElapsedNet = "time_elapsed_net"
	// DomainJobTimeRemaining as defined in libvirt/libvirt-domain.h:5477
	DomainJobTimeRemaining = "time_remaining"
	// DomainJobDowntime as defined in libvirt/libvirt-domain.h:5489
	DomainJobDowntime = "downtime"
	// DomainJobDowntimeNet as defined in libvirt/libvirt-domain.h:5500
	DomainJobDowntimeNet = "downtime_net"
	// DomainJobSetupTime as defined in libvirt/libvirt-domain.h:5511
	DomainJobSetupTime = "setup_time"
	// DomainJobDataTotal as defined in libvirt/libvirt-domain.h:5528
	DomainJobDataTotal = "data_total"
	// DomainJobDataProcessed as defined in libvirt/libvirt-domain.h:5540
	DomainJobDataProcessed = "data_processed"
	// DomainJobDataRemaining as defined in libvirt/libvirt-domain.h:5552
	DomainJobDataRemaining = "data_remaining"
	// DomainJobMemoryTotal as defined in libvirt/libvirt-domain.h:5564
	DomainJobMemoryTotal = "memory_total"
	// DomainJobMemoryProcessed as defined in libvirt/libvirt-domain.h:5576
	DomainJobMemoryProcessed = "memory_processed"
	// DomainJobMemoryRemaining as defined in libvirt/libvirt-domain.h:5588
	DomainJobMemoryRemaining = "memory_remaining"
	// DomainJobMemoryConstant as defined in libvirt/libvirt-domain.h:5602
	DomainJobMemoryConstant = "memory_constant"
	// DomainJobMemoryNormal as defined in libvirt/libvirt-domain.h:5614
	DomainJobMemoryNormal = "memory_normal"
	// DomainJobMemoryNormalBytes as defined in libvirt/libvirt-domain.h:5626
	DomainJobMemoryNormalBytes = "memory_normal_bytes"
	// DomainJobMemoryBps as defined in libvirt/libvirt-domain.h:5636
	DomainJobMemoryBps = "memory_bps"
	// DomainJobMemoryDirtyRate as defined in libvirt/libvirt-domain.h:5646
	DomainJobMemoryDirtyRate = "memory_dirty_rate"
	// DomainJobMemoryPageSize as defined in libvirt/libvirt-domain.h:5659
	DomainJobMemoryPageSize = "memory_page_size"
	// DomainJobMemoryIteration as defined in libvirt/libvirt-domain.h:5672
	DomainJobMemoryIteration = "memory_iteration"
	// DomainJobMemoryPostcopyReqs as defined in libvirt/libvirt-domain.h:5684
	DomainJobMemoryPostcopyReqs = "memory_postcopy_requests"
	// DomainJobDiskTotal as defined in libvirt/libvirt-domain.h:5696
	DomainJobDiskTotal = "disk_total"
	// DomainJobDiskProcessed as defined in libvirt/libvirt-domain.h:5708
	DomainJobDiskProcessed = "disk_processed"
	// DomainJobDiskRemaining as defined in libvirt/libvirt-domain.h:5720
	DomainJobDiskRemaining = "disk_remaining"
	// DomainJobDiskBps as defined in libvirt/libvirt-domain.h:5730
	DomainJobDiskBps = "disk_bps"
	// DomainJobCompressionCache as defined in libvirt/libvirt-domain.h:5741
	DomainJobCompressionCache = "compression_cache"
	// DomainJobCompressionBytes as defined in libvirt/libvirt-domain.h:5751
	DomainJobCompressionBytes = "compression_bytes"
	// DomainJobCompressionPages as defined in libvirt/libvirt-domain.h:5761
	DomainJobCompressionPages = "compression_pages"
	// DomainJobCompressionCacheMisses as defined in libvirt/libvirt-domain.h:5772
	DomainJobCompressionCacheMisses = "compression_cache_misses"
	// DomainJobCompressionOverflow as defined in libvirt/libvirt-domain.h:5784
	DomainJobCompressionOverflow = "compression_overflow"
	// DomainJobAutoConvergeThrottle as defined in libvirt/libvirt-domain.h:5795
	DomainJobAutoConvergeThrottle = "auto_converge_throttle"
	// DomainJobSuccess as defined in libvirt/libvirt-domain.h:5805
	DomainJobSuccess = "success"
	// DomainJobErrmsg as defined in libvirt/libvirt-domain.h:5815
	DomainJobErrmsg = "errmsg"
	// DomainJobDiskTempUsed as defined in libvirt/libvirt-domain.h:5825
	DomainJobDiskTempUsed = "disk_temp_used"
	// DomainJobDiskTempTotal as defined in libvirt/libvirt-domain.h:5834
	DomainJobDiskTempTotal = "disk_temp_total"
	// DomainJobVfioDataTransferred as defined in libvirt/libvirt-domain.h:5843
	DomainJobVfioDataTransferred = "vfio_data_transferred"
	// DomainTunableCPUVcpupin as defined in libvirt/libvirt-domain.h:6501
	DomainTunableCPUVcpupin = "cputune.vcpupin%u"
	// DomainTunableCPUEmulatorpin as defined in libvirt/libvirt-domain.h:6511
	DomainTunableCPUEmulatorpin = "cputune.emulatorpin"
	// DomainTunableCPUIothreadspin as defined in libvirt/libvirt-domain.h:6522
	DomainTunableCPUIothreadspin = "cputune.iothreadpin%u"
	// DomainTunableCPUCpuShares as defined in libvirt/libvirt-domain.h:6532
	DomainTunableCPUCpuShares = "cputune.cpu_shares"
	// DomainTunableCPUGlobalPeriod as defined in libvirt/libvirt-domain.h:6542
	DomainTunableCPUGlobalPeriod = "cputune.global_period"
	// DomainTunableCPUGlobalQuota as defined in libvirt/libvirt-domain.h:6552
	DomainTunableCPUGlobalQuota = "cputune.global_quota"
	// DomainTunableCPUVCPUPeriod as defined in libvirt/libvirt-domain.h:6562
	DomainTunableCPUVCPUPeriod = "cputune.vcpu_period"
	// DomainTunableCPUVCPUQuota as defined in libvirt/libvirt-domain.h:6572
	DomainTunableCPUVCPUQuota = "cputune.vcpu_quota"
	// DomainTunableCPUEmulatorPeriod as defined in libvirt/libvirt-domain.h:6583
	DomainTunableCPUEmulatorPeriod = "cputune.emulator_period"
	// DomainTunableCPUEmulatorQuota as defined in libvirt/libvirt-domain.h:6594
	DomainTunableCPUEmulatorQuota = "cputune.emulator_quota"
	// DomainTunableCPUIothreadPeriod as defined in libvirt/libvirt-domain.h:6604
	DomainTunableCPUIothreadPeriod = "cputune.iothread_period"
	// DomainTunableCPUIothreadQuota as defined in libvirt/libvirt-domain.h:6614
	DomainTunableCPUIothreadQuota = "cputune.iothread_quota"
	// DomainTunableBlkdevDisk as defined in libvirt/libvirt-domain.h:6624
	DomainTunableBlkdevDisk = "blkdeviotune.disk"
	// DomainTunableBlkdevTotalBytesSec as defined in libvirt/libvirt-domain.h:6634
	DomainTunableBlkdevTotalBytesSec = "blkdeviotune.total_bytes_sec"
	// DomainTunableBlkdevReadBytesSec as defined in libvirt/libvirt-domain.h:6644
	DomainTunableBlkdevReadBytesSec = "blkdeviotune.read_bytes_sec"
	// DomainTunableBlkdevWriteBytesSec as defined in libvirt/libvirt-domain.h:6654
	DomainTunableBlkdevWriteBytesSec = "blkdeviotune.write_bytes_sec"
	// DomainTunableBlkdevTotalIopsSec as defined in libvirt/libvirt-domain.h:6664
	DomainTunableBlkdevTotalIopsSec = "blkdeviotune.total_iops_sec"
	// DomainTunableBlkdevReadIopsSec as defined in libvirt/libvirt-domain.h:6674
	DomainTunableBlkdevReadIopsSec = "blkdeviotune.read_iops_sec"
	// DomainTunableBlkdevWriteIopsSec as defined in libvirt/libvirt-domain.h:6684
	DomainTunableBlkdevWriteIopsSec = "blkdeviotune.write_iops_sec"
	// DomainTunableBlkdevTotalBytesSecMax as defined in libvirt/libvirt-domain.h:6694
	DomainTunableBlkdevTotalBytesSecMax = "blkdeviotune.total_bytes_sec_max"
	// DomainTunableBlkdevReadBytesSecMax as defined in libvirt/libvirt-domain.h:6704
	DomainTunableBlkdevReadBytesSecMax = "blkdeviotune.read_bytes_sec_max"
	// DomainTunableBlkdevWriteBytesSecMax as defined in libvirt/libvirt-domain.h:6714
	DomainTunableBlkdevWriteBytesSecMax = "blkdeviotune.write_bytes_sec_max"
	// DomainTunableBlkdevTotalIopsSecMax as defined in libvirt/libvirt-domain.h:6724
	DomainTunableBlkdevTotalIopsSecMax = "blkdeviotune.total_iops_sec_max"
	// DomainTunableBlkdevReadIopsSecMax as defined in libvirt/libvirt-domain.h:6734
	DomainTunableBlkdevReadIopsSecMax = "blkdeviotune.read_iops_sec_max"
	// DomainTunableBlkdevWriteIopsSecMax as defined in libvirt/libvirt-domain.h:6744
	DomainTunableBlkdevWriteIopsSecMax = "blkdeviotune.write_iops_sec_max"
	// DomainTunableBlkdevSizeIopsSec as defined in libvirt/libvirt-domain.h:6754
	DomainTunableBlkdevSizeIopsSec = "blkdeviotune.size_iops_sec"
	// DomainTunableBlkdevGroupName as defined in libvirt/libvirt-domain.h:6764
	DomainTunableBlkdevGroupName = "blkdeviotune.group_name"
	// DomainTunableBlkdevTotalBytesSecMaxLength as defined in libvirt/libvirt-domain.h:6775
	DomainTunableBlkdevTotalBytesSecMaxLength = "blkdeviotune.total_bytes_sec_max_length"
	// DomainTunableBlkdevReadBytesSecMaxLength as defined in libvirt/libvirt-domain.h:6786
	DomainTunableBlkdevReadBytesSecMaxLength = "blkdeviotune.read_bytes_sec_max_length"
	// DomainTunableBlkdevWriteBytesSecMaxLength as defined in libvirt/libvirt-domain.h:6797
	DomainTunableBlkdevWriteBytesSecMaxLength = "blkdeviotune.write_bytes_sec_max_length"
	// DomainTunableBlkdevTotalIopsSecMaxLength as defined in libvirt/libvirt-domain.h:6808
	DomainTunableBlkdevTotalIopsSecMaxLength = "blkdeviotune.total_iops_sec_max_length"
	// DomainTunableBlkdevReadIopsSecMaxLength as defined in libvirt/libvirt-domain.h:6819
	DomainTunableBlkdevReadIopsSecMaxLength = "blkdeviotune.read_iops_sec_max_length"
	// DomainTunableBlkdevWriteIopsSecMaxLength as defined in libvirt/libvirt-domain.h:6830
	DomainTunableBlkdevWriteIopsSecMaxLength = "blkdeviotune.write_iops_sec_max_length"
	// DomainSchedFieldLength as defined in libvirt/libvirt-domain.h:7242
	DomainSchedFieldLength = TypedParamFieldLength
	// DomainBlkioFieldLength as defined in libvirt/libvirt-domain.h:7299
	DomainBlkioFieldLength = TypedParamFieldLength
	// DomainMemoryFieldLength as defined in libvirt/libvirt-domain.h:7356
	DomainMemoryFieldLength = TypedParamFieldLength
	// DomainLaunchSecuritySevMeasurement as defined in libvirt/libvirt-domain.h:7536
	DomainLaunchSecuritySevMeasurement = "sev-measurement"
	// DomainLaunchSecuritySevAPIMajor as defined in libvirt/libvirt-domain.h:7547
	DomainLaunchSecuritySevAPIMajor = "sev-api-major"
	// DomainLaunchSecuritySevAPIMinor as defined in libvirt/libvirt-domain.h:7557
	DomainLaunchSecuritySevAPIMinor = "sev-api-minor"
	// DomainLaunchSecuritySevBuildID as defined in libvirt/libvirt-domain.h:7567
	DomainLaunchSecuritySevBuildID = "sev-build-id"
	// DomainLaunchSecuritySevPolicy as defined in libvirt/libvirt-domain.h:7577
	DomainLaunchSecuritySevPolicy = "sev-policy"
	// DomainLaunchSecuritySevSnpPolicy as defined in libvirt/libvirt-domain.h:7587
	DomainLaunchSecuritySevSnpPolicy = "sev-snp-policy"
	// DomainLaunchSecuritySevSecretHeader as defined in libvirt/libvirt-domain.h:7600
	DomainLaunchSecuritySevSecretHeader = "sev-secret-header"
	// DomainLaunchSecuritySevSecret as defined in libvirt/libvirt-domain.h:7612
	DomainLaunchSecuritySevSecret = "sev-secret"
	// DomainLaunchSecuritySevSecretSetAddress as defined in libvirt/libvirt-domain.h:7623
	DomainLaunchSecuritySevSecretSetAddress = "sev-secret-set-address"
	// DomainGuestInfoUserCount as defined in libvirt/libvirt-domain.h:7642
	DomainGuestInfoUserCount = "user.count"
	// DomainGuestInfoUserPrefix as defined in libvirt/libvirt-domain.h:7653
	DomainGuestInfoUserPrefix = "user."
	// DomainGuestInfoUserSuffixName as defined in libvirt/libvirt-domain.h:7662
	DomainGuestInfoUserSuffixName = ".name"
	// DomainGuestInfoUserSuffixDomain as defined in libvirt/libvirt-domain.h:7672
	DomainGuestInfoUserSuffixDomain = ".domain"
	// DomainGuestInfoUserSuffixLoginTime as defined in libvirt/libvirt-domain.h:7682
	DomainGuestInfoUserSuffixLoginTime = ".login-time"
	// DomainGuestInfoOsID as defined in libvirt/libvirt-domain.h:7692
	DomainGuestInfoOsID = "os.id"
	// DomainGuestInfoOsName as defined in libvirt/libvirt-domain.h:7702
	DomainGuestInfoOsName = "os.name"
	// DomainGuestInfoOsPrettyName as defined in libvirt/libvirt-domain.h:7712
	DomainGuestInfoOsPrettyName = "os.pretty-name"
	// DomainGuestInfoOsVersion as defined in libvirt/libvirt-domain.h:7722
	DomainGuestInfoOsVersion = "os.version"
	// DomainGuestInfoOsVersionID as defined in libvirt/libvirt-domain.h:7732
	DomainGuestInfoOsVersionID = "os.version-id"
	// DomainGuestInfoOsKernelRelease as defined in libvirt/libvirt-domain.h:7741
	DomainGuestInfoOsKernelRelease = "os.kernel-release"
	// DomainGuestInfoOsKernelVersion as defined in libvirt/libvirt-domain.h:7750
	DomainGuestInfoOsKernelVersion = "os.kernel-version"
	// DomainGuestInfoOsMachine as defined in libvirt/libvirt-domain.h:7759
	DomainGuestInfoOsMachine = "os.machine"
	// DomainGuestInfoOsVariant as defined in libvirt/libvirt-domain.h:7769
	DomainGuestInfoOsVariant = "os.variant"
	// DomainGuestInfoOsVariantID as defined in libvirt/libvirt-domain.h:7779
	DomainGuestInfoOsVariantID = "os.variant-id"
	// DomainGuestInfoTimezoneName as defined in libvirt/libvirt-domain.h:7789
	DomainGuestInfoTimezoneName = "timezone.name"
	// DomainGuestInfoTimezoneOffset as defined in libvirt/libvirt-domain.h:7798
	DomainGuestInfoTimezoneOffset = "timezone.offset"
	// DomainGuestInfoHostnameHostname as defined in libvirt/libvirt-domain.h:7808
	DomainGuestInfoHostnameHostname = "hostname"
	// DomainGuestInfoFsCount as defined in libvirt/libvirt-domain.h:7818
	DomainGuestInfoFsCount = "fs.count"
	// DomainGuestInfoFsPrefix as defined in libvirt/libvirt-domain.h:7829
	DomainGuestInfoFsPrefix = "fs."
	// DomainGuestInfoFsSuffixMountpoint as defined in libvirt/libvirt-domain.h:7838
	DomainGuestInfoFsSuffixMountpoint = ".mountpoint"
	// DomainGuestInfoFsSuffixName as defined in libvirt/libvirt-domain.h:7847
	DomainGuestInfoFsSuffixName = ".name"
	// DomainGuestInfoFsSuffixFstype as defined in libvirt/libvirt-domain.h:7856
	DomainGuestInfoFsSuffixFstype = ".fstype"
	// DomainGuestInfoFsSuffixTotalBytes as defined in libvirt/libvirt-domain.h:7865
	DomainGuestInfoFsSuffixTotalBytes = ".total-bytes"
	// DomainGuestInfoFsSuffixUsedBytes as defined in libvirt/libvirt-domain.h:7874
	DomainGuestInfoFsSuffixUsedBytes = ".used-bytes"
	// DomainGuestInfoFsSuffixDiskCount as defined in libvirt/libvirt-domain.h:7883
	DomainGuestInfoFsSuffixDiskCount = ".disk.count"
	// DomainGuestInfoFsSuffixDiskPrefix as defined in libvirt/libvirt-domain.h:7896
	DomainGuestInfoFsSuffixDiskPrefix = ".disk."
	// DomainGuestInfoFsSuffixDiskSuffixAlias as defined in libvirt/libvirt-domain.h:7905
	DomainGuestInfoFsSuffixDiskSuffixAlias = ".alias"
	// DomainGuestInfoFsSuffixDiskSuffixSerial as defined in libvirt/libvirt-domain.h:7914
	DomainGuestInfoFsSuffixDiskSuffixSerial = ".serial"
	// DomainGuestInfoFsSuffixDiskSuffixDevice as defined in libvirt/libvirt-domain.h:7923
	DomainGuestInfoFsSuffixDiskSuffixDevice = ".device"
	// DomainGuestInfoDiskCount as defined in libvirt/libvirt-domain.h:7933
	DomainGuestInfoDiskCount = "disk.count"
	// DomainGuestInfoDiskPrefix as defined in libvirt/libvirt-domain.h:7944
	DomainGuestInfoDiskPrefix = "disk."
	// DomainGuestInfoDiskSuffixName as defined in libvirt/libvirt-domain.h:7953
	DomainGuestInfoDiskSuffixName = ".name"
	// DomainGuestInfoDiskSuffixPartition as defined in libvirt/libvirt-domain.h:7962
	DomainGuestInfoDiskSuffixPartition = ".partition"
	// DomainGuestInfoDiskSuffixDependencyCount as defined in libvirt/libvirt-domain.h:7974
	DomainGuestInfoDiskSuffixDependencyCount = ".dependency.count"
	// DomainGuestInfoDiskSuffixDependencyPrefix as defined in libvirt/libvirt-domain.h:7987
	DomainGuestInfoDiskSuffixDependencyPrefix = ".dependency."
	// DomainGuestInfoDiskSuffixDependencySuffixName as defined in libvirt/libvirt-domain.h:7996
	DomainGuestInfoDiskSuffixDependencySuffixName = ".name"
	// DomainGuestInfoDiskSuffixSerial as defined in libvirt/libvirt-domain.h:8005
	DomainGuestInfoDiskSuffixSerial = ".serial"
	// DomainGuestInfoDiskSuffixAlias as defined in libvirt/libvirt-domain.h:8014
	DomainGuestInfoDiskSuffixAlias = ".alias"
	// DomainGuestInfoDiskSuffixGuestAlias as defined in libvirt/libvirt-domain.h:8024
	DomainGuestInfoDiskSuffixGuestAlias = ".guest_alias"
	// DomainGuestInfoDiskSuffixGuestBus as defined in libvirt/libvirt-domain.h:8033
	DomainGuestInfoDiskSuffixGuestBus = ".guest_bus"
	// DomainGuestInfoIfCount as defined in libvirt/libvirt-domain.h:8043
	DomainGuestInfoIfCount = "if.count"
	// DomainGuestInfoIfPrefix as defined in libvirt/libvirt-domain.h:8054
	DomainGuestInfoIfPrefix = "if."
	// DomainGuestInfoIfSuffixName as defined in libvirt/libvirt-domain.h:8063
	DomainGuestInfoIfSuffixName = ".name"
	// DomainGuestInfoIfSuffixHwaddr as defined in libvirt/libvirt-domain.h:8072
	DomainGuestInfoIfSuffixHwaddr = ".hwaddr"
	// DomainGuestInfoIfSuffixAddrCount as defined in libvirt/libvirt-domain.h:8081
	DomainGuestInfoIfSuffixAddrCount = ".addr.count"
	// DomainGuestInfoIfSuffixAddrPrefix as defined in libvirt/libvirt-domain.h:8094
	DomainGuestInfoIfSuffixAddrPrefix = ".addr."
	// DomainGuestInfoIfSuffixAddrSuffixType as defined in libvirt/libvirt-domain.h:8103
	DomainGuestInfoIfSuffixAddrSuffixType = ".type"
	// DomainGuestInfoIfSuffixAddrSuffixAddr as defined in libvirt/libvirt-domain.h:8112
	DomainGuestInfoIfSuffixAddrSuffixAddr = ".addr"
	// DomainGuestInfoIfSuffixAddrSuffixPrefix as defined in libvirt/libvirt-domain.h:8121
	DomainGuestInfoIfSuffixAddrSuffixPrefix = ".prefix"
	// DomainGuestInfoLoad1m as defined in libvirt/libvirt-domain.h:8131
	DomainGuestInfoLoad1m = "load.1m"
	// DomainGuestInfoLoad5m as defined in libvirt/libvirt-domain.h:8140
	DomainGuestInfoLoad5m = "load.5m"
	// DomainGuestInfoLoad15m as defined in libvirt/libvirt-domain.h:8149
	DomainGuestInfoLoad15m = "load.15m"
	// SecurityLabelBuflen as defined in libvirt/libvirt-host.h:96
	SecurityLabelBuflen = (4096 + 1)
	// SecurityModelBuflen as defined in libvirt/libvirt-host.h:130
	SecurityModelBuflen = (256 + 1)
	// SecurityDoiBuflen as defined in libvirt/libvirt-host.h:139
	SecurityDoiBuflen = (256 + 1)
	// NodeCPUStatsFieldLength as defined in libvirt/libvirt-host.h:207
	NodeCPUStatsFieldLength = 80
	// NodeCPUStatsKernel as defined in libvirt/libvirt-host.h:228
	NodeCPUStatsKernel = "kernel"
	// NodeCPUStatsUser as defined in libvirt/libvirt-host.h:238
	NodeCPUStatsUser = "user"
	// NodeCPUStatsIdle as defined in libvirt/libvirt-host.h:248
	NodeCPUStatsIdle = "idle"
	// NodeCPUStatsIowait as defined in libvirt/libvirt-host.h:258
	NodeCPUStatsIowait = "iowait"
	// NodeCPUStatsIntr as defined in libvirt/libvirt-host.h:268
	NodeCPUStatsIntr = "intr"
	// NodeCPUStatsUtilization as defined in libvirt/libvirt-host.h:279
	NodeCPUStatsUtilization = "utilization"
	// NodeMemoryStatsFieldLength as defined in libvirt/libvirt-host.h:303
	NodeMemoryStatsFieldLength = 80
	// NodeMemoryStatsTotal as defined in libvirt/libvirt-host.h:324
	NodeMemoryStatsTotal = "total"
	// NodeMemoryStatsFree as defined in libvirt/libvirt-host.h:335
	NodeMemoryStatsFree = "free"
	// NodeMemoryStatsBuffers as defined in libvirt/libvirt-host.h:345
	NodeMemoryStatsBuffers = "buffers"
	// NodeMemoryStatsCached as defined in libvirt/libvirt-host.h:355
	NodeMemoryStatsCached = "cached"
	// NodeMemorySharedPagesToScan as defined in libvirt/libvirt-host.h:380
	NodeMemorySharedPagesToScan = "shm_pages_to_scan"
	// NodeMemorySharedSleepMillisecs as defined in libvirt/libvirt-host.h:390
	NodeMemorySharedSleepMillisecs = "shm_sleep_millisecs"
	// NodeMemorySharedPagesShared as defined in libvirt/libvirt-host.h:400
	NodeMemorySharedPagesShared = "shm_pages_shared"
	// NodeMemorySharedPagesSharing as defined in libvirt/libvirt-host.h:410
	NodeMemorySharedPagesSharing = "shm_pages_sharing"
	// NodeMemorySharedPagesUnshared as defined in libvirt/libvirt-host.h:420
	NodeMemorySharedPagesUnshared = "shm_pages_unshared"
	// NodeMemorySharedPagesVolatile as defined in libvirt/libvirt-host.h:430
	NodeMemorySharedPagesVolatile = "shm_pages_volatile"
	// NodeMemorySharedFullScans as defined in libvirt/libvirt-host.h:440
	NodeMemorySharedFullScans = "shm_full_scans"
	// NodeMemorySharedMergeAcrossNodes as defined in libvirt/libvirt-host.h:454
	NodeMemorySharedMergeAcrossNodes = "shm_merge_across_nodes"
	// NodeSevPdh as defined in libvirt/libvirt-host.h:527
	NodeSevPdh = "pdh"
	// NodeSevCertChain as defined in libvirt/libvirt-host.h:538
	NodeSevCertChain = "cert-chain"
	// NodeSevCpu0ID as defined in libvirt/libvirt-host.h:549
	NodeSevCpu0ID = "cpu0-id"
	// NodeSevCbitpos as defined in libvirt/libvirt-host.h:558
	NodeSevCbitpos = "cbitpos"
	// NodeSevReducedPhysBits as defined in libvirt/libvirt-host.h:568
	NodeSevReducedPhysBits = "reduced-phys-bits"
	// NodeSevMaxGuests as defined in libvirt/libvirt-host.h:578
	NodeSevMaxGuests = "max-guests"
	// NodeSevMaxEsGuests as defined in libvirt/libvirt-host.h:588
	NodeSevMaxEsGuests = "max-es-guests"
	// UUIDBuflen as defined in libvirt/libvirt-host.h:715
	UUIDBuflen = (16)
	// UUIDStringBuflen as defined in libvirt/libvirt-host.h:725
	UUIDStringBuflen = (36 + 1)
	// ConnectIdentityUserName as defined in libvirt/libvirt-host.h:752
	ConnectIdentityUserName = "user-name"
	// ConnectIdentityUnixUserID as defined in libvirt/libvirt-host.h:761
	ConnectIdentityUnixUserID = "unix-user-id"
	// ConnectIdentityGroupName as defined in libvirt/libvirt-host.h:770
	ConnectIdentityGroupName = "group-name"
	// ConnectIdentityUnixGroupID as defined in libvirt/libvirt-host.h:779
	ConnectIdentityUnixGroupID = "unix-group-id"
	// ConnectIdentityProcessID as defined in libvirt/libvirt-host.h:788
	ConnectIdentityProcessID = "process-id"
	// ConnectIdentityProcessTime as defined in libvirt/libvirt-host.h:801
	ConnectIdentityProcessTime = "process-time"
	// ConnectIdentitySaslUserName as defined in libvirt/libvirt-host.h:810
	ConnectIdentitySaslUserName = "sasl-user-name"
	// ConnectIdentityX509DistinguishedName as defined in libvirt/libvirt-host.h:819
	ConnectIdentityX509DistinguishedName = "x509-distinguished-name"
	// ConnectIdentitySelinuxContext as defined in libvirt/libvirt-host.h:828
	ConnectIdentitySelinuxContext = "selinux-context"
	// NetworkPortBandwidthInAverage as defined in libvirt/libvirt-network.h:469
	NetworkPortBandwidthInAverage = "inbound.average"
	// NetworkPortBandwidthInPeak as defined in libvirt/libvirt-network.h:478
	NetworkPortBandwidthInPeak = "inbound.peak"
	// NetworkPortBandwidthInBurst as defined in libvirt/libvirt-network.h:487
	NetworkPortBandwidthInBurst = "inbound.burst"
	// NetworkPortBandwidthInFloor as defined in libvirt/libvirt-network.h:496
	NetworkPortBandwidthInFloor = "inbound.floor"
	// NetworkPortBandwidthOutAverage as defined in libvirt/libvirt-network.h:505
	NetworkPortBandwidthOutAverage = "outbound.average"
	// NetworkPortBandwidthOutPeak as defined in libvirt/libvirt-network.h:514
	NetworkPortBandwidthOutPeak = "outbound.peak"
	// NetworkPortBandwidthOutBurst as defined in libvirt/libvirt-network.h:523
	NetworkPortBandwidthOutBurst = "outbound.burst"
)

// ConnectCloseReason as declared in libvirt/libvirt-common.h:129
type ConnectCloseReason int32

// ConnectCloseReason enumeration from libvirt/libvirt-common.h:129
const (
	ConnectCloseReasonError     ConnectCloseReason = iota
	ConnectCloseReasonEOF       ConnectCloseReason = 1
	ConnectCloseReasonKeepalive ConnectCloseReason = 2
	ConnectCloseReasonClient    ConnectCloseReason = 3
)

// TypedParameterType as declared in libvirt/libvirt-common.h:150
type TypedParameterType int32

// TypedParameterType enumeration from libvirt/libvirt-common.h:150
const (
	TypedParamInt     TypedParameterType = 1
	TypedParamUint    TypedParameterType = 2
	TypedParamLlong   TypedParameterType = 3
	TypedParamUllong  TypedParameterType = 4
	TypedParamDouble  TypedParameterType = 5
	TypedParamBoolean TypedParameterType = 6
	TypedParamString  TypedParameterType = 7
)

// TypedParameterFlags as declared in libvirt/libvirt-common.h:179
type TypedParameterFlags int32

// TypedParameterFlags enumeration from libvirt/libvirt-common.h:179
const (
	TypedParamStringOkay TypedParameterFlags = 4
)

// DomainCheckpointCreateFlags as declared in libvirt/libvirt-domain-checkpoint.h:71
type DomainCheckpointCreateFlags int32

// DomainCheckpointCreateFlags enumeration from libvirt/libvirt-domain-checkpoint.h:71
const (
	DomainCheckpointCreateRedefine         DomainCheckpointCreateFlags = 1
	DomainCheckpointCreateQuiesce          DomainCheckpointCreateFlags = 2
	DomainCheckpointCreateRedefineValidate DomainCheckpointCreateFlags = 4
)

// DomainCheckpointXMLFlags as declared in libvirt/libvirt-domain-checkpoint.h:88
type DomainCheckpointXMLFlags int32

// DomainCheckpointXMLFlags enumeration from libvirt/libvirt-domain-checkpoint.h:88
const (
	DomainCheckpointXMLSecure   DomainCheckpointXMLFlags = 1
	DomainCheckpointXMLNoDomain DomainCheckpointXMLFlags = 2
	DomainCheckpointXMLSize     DomainCheckpointXMLFlags = 4
)

// DomainCheckpointListFlags as declared in libvirt/libvirt-domain-checkpoint.h:121
type DomainCheckpointListFlags int32

// DomainCheckpointListFlags enumeration from libvirt/libvirt-domain-checkpoint.h:121
const (
	DomainCheckpointListRoots       DomainCheckpointListFlags = 1
	DomainCheckpointListDescendants DomainCheckpointListFlags = 1
	DomainCheckpointListTopological DomainCheckpointListFlags = 2
	DomainCheckpointListLeaves      DomainCheckpointListFlags = 4
	DomainCheckpointListNoLeaves    DomainCheckpointListFlags = 8
)

// DomainCheckpointDeleteFlags as declared in libvirt/libvirt-domain-checkpoint.h:153
type DomainCheckpointDeleteFlags int32

// DomainCheckpointDeleteFlags enumeration from libvirt/libvirt-domain-checkpoint.h:153
const (
	DomainCheckpointDeleteChildren     DomainCheckpointDeleteFlags = 1
	DomainCheckpointDeleteMetadataOnly DomainCheckpointDeleteFlags = 2
	DomainCheckpointDeleteChildrenOnly DomainCheckpointDeleteFlags = 4
)

// DomainSnapshotCreateFlags as declared in libvirt/libvirt-domain-snapshot.h:85
type DomainSnapshotCreateFlags int32

// DomainSnapshotCreateFlags enumeration from libvirt/libvirt-domain-snapshot.h:85
const (
	DomainSnapshotCreateRedefine   DomainSnapshotCreateFlags = 1
	DomainSnapshotCreateCurrent    DomainSnapshotCreateFlags = 2
	DomainSnapshotCreateNoMetadata DomainSnapshotCreateFlags = 4
	DomainSnapshotCreateHalt       DomainSnapshotCreateFlags = 8
	DomainSnapshotCreateDiskOnly   DomainSnapshotCreateFlags = 16
	DomainSnapshotCreateReuseExt   DomainSnapshotCreateFlags = 32
	DomainSnapshotCreateQuiesce    DomainSnapshotCreateFlags = 64
	DomainSnapshotCreateAtomic     DomainSnapshotCreateFlags = 128
	DomainSnapshotCreateLive       DomainSnapshotCreateFlags = 256
	DomainSnapshotCreateValidate   DomainSnapshotCreateFlags = 512
)

// DomainSnapshotXMLFlags as declared in libvirt/libvirt-domain-snapshot.h:98
type DomainSnapshotXMLFlags int32

// DomainSnapshotXMLFlags enumeration from libvirt/libvirt-domain-snapshot.h:98
const (
	DomainSnapshotXMLSecure DomainSnapshotXMLFlags = 1
)

// DomainSnapshotListFlags as declared in libvirt/libvirt-domain-snapshot.h:158
type DomainSnapshotListFlags int32

// DomainSnapshotListFlags enumeration from libvirt/libvirt-domain-snapshot.h:158
const (
	DomainSnapshotListRoots       DomainSnapshotListFlags = 1
	DomainSnapshotListDescendants DomainSnapshotListFlags = 1
	DomainSnapshotListLeaves      DomainSnapshotListFlags = 4
	DomainSnapshotListNoLeaves    DomainSnapshotListFlags = 8
	DomainSnapshotListMetadata    DomainSnapshotListFlags = 2
	DomainSnapshotListNoMetadata  DomainSnapshotListFlags = 16
	DomainSnapshotListInactive    DomainSnapshotListFlags = 32
	DomainSnapshotListActive      DomainSnapshotListFlags = 64
	DomainSnapshotListDiskOnly    DomainSnapshotListFlags = 128
	DomainSnapshotListInternal    DomainSnapshotListFlags = 256
	DomainSnapshotListExternal    DomainSnapshotListFlags = 512
	DomainSnapshotListTopological DomainSnapshotListFlags = 1024
)

// DomainSnapshotRevertFlags as declared in libvirt/libvirt-domain-snapshot.h:221
type DomainSnapshotRevertFlags int32

// DomainSnapshotRevertFlags enumeration from libvirt/libvirt-domain-snapshot.h:221
const (
	DomainSnapshotRevertRunning    DomainSnapshotRevertFlags = 1
	DomainSnapshotRevertPaused     DomainSnapshotRevertFlags = 2
	DomainSnapshotRevertForce      DomainSnapshotRevertFlags = 4
	DomainSnapshotRevertResetNvram DomainSnapshotRevertFlags = 8
)

// DomainSnapshotDeleteFlags as declared in libvirt/libvirt-domain-snapshot.h:241
type DomainSnapshotDeleteFlags int32

// DomainSnapshotDeleteFlags enumeration from libvirt/libvirt-domain-snapshot.h:241
const (
	DomainSnapshotDeleteChildren     DomainSnapshotDeleteFlags = 1
	DomainSnapshotDeleteMetadataOnly DomainSnapshotDeleteFlags = 2
	DomainSnapshotDeleteChildrenOnly DomainSnapshotDeleteFlags = 4
)

// DomainState as declared in libvirt/libvirt-domain.h:78
type DomainState int32

// DomainState enumeration from libvirt/libvirt-domain.h:78
const (
	DomainNostate     DomainState = iota
	DomainRunning     DomainState = 1
	DomainBlocked     DomainState = 2
	DomainPaused      DomainState = 3
	DomainShutdown    DomainState = 4
	DomainShutoff     DomainState = 5
	DomainCrashed     DomainState = 6
	DomainPmsuspended DomainState = 7
)

// DomainNostateReason as declared in libvirt/libvirt-domain.h:91
type DomainNostateReason int32

// DomainNostateReason enumeration from libvirt/libvirt-domain.h:91
const (
	DomainNostateUnknown DomainNostateReason = iota
)

// DomainRunningReason as declared in libvirt/libvirt-domain.h:116
type DomainRunningReason int32

// DomainRunningReason enumeration from libvirt/libvirt-domain.h:116
const (
	DomainRunningUnknown           DomainRunningReason = iota
	DomainRunningBooted            DomainRunningReason = 1
	DomainRunningMigrated          DomainRunningReason = 2
	DomainRunningRestored          DomainRunningReason = 3
	DomainRunningFromSnapshot      DomainRunningReason = 4
	DomainRunningUnpaused          DomainRunningReason = 5
	DomainRunningMigrationCanceled DomainRunningReason = 6
	DomainRunningSaveCanceled      DomainRunningReason = 7
	DomainRunningWakeup            DomainRunningReason = 8
	DomainRunningCrashed           DomainRunningReason = 9
	DomainRunningPostcopy          DomainRunningReason = 10
	DomainRunningPostcopyFailed    DomainRunningReason = 11
)

// DomainBlockedReason as declared in libvirt/libvirt-domain.h:129
type DomainBlockedReason int32

// DomainBlockedReason enumeration from libvirt/libvirt-domain.h:129
const (
	DomainBlockedUnknown DomainBlockedReason = iota
)

// DomainPausedReason as declared in libvirt/libvirt-domain.h:156
type DomainPausedReason int32

// DomainPausedReason enumeration from libvirt/libvirt-domain.h:156
const (
	DomainPausedUnknown        DomainPausedReason = iota
	DomainPausedUser           DomainPausedReason = 1
	DomainPausedMigration      DomainPausedReason = 2
	DomainPausedSave           DomainPausedReason = 3
	DomainPausedDump           DomainPausedReason = 4
	DomainPausedIoerror        DomainPausedReason = 5
	DomainPausedWatchdog       DomainPausedReason = 6
	DomainPausedFromSnapshot   DomainPausedReason = 7
	DomainPausedShuttingDown   DomainPausedReason = 8
	DomainPausedSnapshot       DomainPausedReason = 9
	DomainPausedCrashed        DomainPausedReason = 10
	DomainPausedStartingUp     DomainPausedReason = 11
	DomainPausedPostcopy       DomainPausedReason = 12
	DomainPausedPostcopyFailed DomainPausedReason = 13
	DomainPausedAPIError       DomainPausedReason = 14
)

// DomainShutdownReason as declared in libvirt/libvirt-domain.h:170
type DomainShutdownReason int32

// DomainShutdownReason enumeration from libvirt/libvirt-domain.h:170
const (
	DomainShutdownUnknown DomainShutdownReason = iota
	DomainShutdownUser    DomainShutdownReason = 1
)

// DomainShutoffReason as declared in libvirt/libvirt-domain.h:192
type DomainShutoffReason int32

// DomainShutoffReason enumeration from libvirt/libvirt-domain.h:192
const (
	DomainShutoffUnknown      DomainShutoffReason = iota
	DomainShutoffShutdown     DomainShutoffReason = 1
	DomainShutoffDestroyed    DomainShutoffReason = 2
	DomainShutoffCrashed      DomainShutoffReason = 3
	DomainShutoffMigrated     DomainShutoffReason = 4
	DomainShutoffSaved        DomainShutoffReason = 5
	DomainShutoffFailed       DomainShutoffReason = 6
	DomainShutoffFromSnapshot DomainShutoffReason = 7
	DomainShutoffDaemon       DomainShutoffReason = 8
)

// DomainCrashedReason as declared in libvirt/libvirt-domain.h:206
type DomainCrashedReason int32

// DomainCrashedReason enumeration from libvirt/libvirt-domain.h:206
const (
	DomainCrashedUnknown  DomainCrashedReason = iota
	DomainCrashedPanicked DomainCrashedReason = 1
)

// DomainPMSuspendedReason as declared in libvirt/libvirt-domain.h:219
type DomainPMSuspendedReason int32

// DomainPMSuspendedReason enumeration from libvirt/libvirt-domain.h:219
const (
	DomainPmsuspendedUnknown DomainPMSuspendedReason = iota
)

// DomainPMSuspendedDiskReason as declared in libvirt/libvirt-domain.h:232
type DomainPMSuspendedDiskReason int32

// DomainPMSuspendedDiskReason enumeration from libvirt/libvirt-domain.h:232
const (
	DomainPmsuspendedDiskUnknown DomainPMSuspendedDiskReason = iota
)

// DomainControlState as declared in libvirt/libvirt-domain.h:254
type DomainControlState int32

// DomainControlState enumeration from libvirt/libvirt-domain.h:254
const (
	DomainControlOk       DomainControlState = iota
	DomainControlJob      DomainControlState = 1
	DomainControlOccupied DomainControlState = 2
	DomainControlError    DomainControlState = 3
)

// DomainControlErrorReason as declared in libvirt/libvirt-domain.h:276
type DomainControlErrorReason int32

// DomainControlErrorReason enumeration from libvirt/libvirt-domain.h:276
const (
	DomainControlErrorReasonNone     DomainControlErrorReason = iota
	DomainControlErrorReasonUnknown  DomainControlErrorReason = 1
	DomainControlErrorReasonMonitor  DomainControlErrorReason = 2
	DomainControlErrorReasonInternal DomainControlErrorReason = 3
)

// DomainModificationImpact as declared in libvirt/libvirt-domain.h:330
type DomainModificationImpact int32

// DomainModificationImpact enumeration from libvirt/libvirt-domain.h:330
const (
	DomainAffectCurrent DomainModificationImpact = iota
	DomainAffectLive    DomainModificationImpact = 1
	DomainAffectConfig  DomainModificationImpact = 2
)

// DomainCreateFlags as declared in libvirt/libvirt-domain.h:375
type DomainCreateFlags int32

// DomainCreateFlags enumeration from libvirt/libvirt-domain.h:375
const (
	DomainNone             DomainCreateFlags = iota
	DomainStartPaused      DomainCreateFlags = 1
	DomainStartAutodestroy DomainCreateFlags = 2
	DomainStartBypassCache DomainCreateFlags = 4
	DomainStartForceBoot   DomainCreateFlags = 8
	DomainStartValidate    DomainCreateFlags = 16
	DomainStartResetNvram  DomainCreateFlags = 32
)

// DomainMemoryStatTags as declared in libvirt/libvirt-domain.h:822
type DomainMemoryStatTags int32

// DomainMemoryStatTags enumeration from libvirt/libvirt-domain.h:822
const (
	DomainMemoryStatSwapIn         DomainMemoryStatTags = iota
	DomainMemoryStatSwapOut        DomainMemoryStatTags = 1
	DomainMemoryStatMajorFault     DomainMemoryStatTags = 2
	DomainMemoryStatMinorFault     DomainMemoryStatTags = 3
	DomainMemoryStatUnused         DomainMemoryStatTags = 4
	DomainMemoryStatAvailable      DomainMemoryStatTags = 5
	DomainMemoryStatActualBalloon  DomainMemoryStatTags = 6
	DomainMemoryStatRss            DomainMemoryStatTags = 7
	DomainMemoryStatUsable         DomainMemoryStatTags = 8
	DomainMemoryStatLastUpdate     DomainMemoryStatTags = 9
	DomainMemoryStatDiskCaches     DomainMemoryStatTags = 10
	DomainMemoryStatHugetlbPgalloc DomainMemoryStatTags = 11
	DomainMemoryStatHugetlbPgfail  DomainMemoryStatTags = 12
	DomainMemoryStatNr             DomainMemoryStatTags = 13
)

// DomainCoreDumpFlags as declared in libvirt/libvirt-domain.h:857
type DomainCoreDumpFlags int32

// DomainCoreDumpFlags enumeration from libvirt/libvirt-domain.h:857
const (
	DumpCrash       DomainCoreDumpFlags = 1
	DumpLive        DomainCoreDumpFlags = 2
	DumpBypassCache DomainCoreDumpFlags = 4
	DumpReset       DomainCoreDumpFlags = 8
	DumpMemoryOnly  DomainCoreDumpFlags = 16
)

// DomainCoreDumpFormat as declared in libvirt/libvirt-domain.h:885
type DomainCoreDumpFormat int32

// DomainCoreDumpFormat enumeration from libvirt/libvirt-domain.h:885
const (
	DomainCoreDumpFormatRaw         DomainCoreDumpFormat = iota
	DomainCoreDumpFormatKdumpZlib   DomainCoreDumpFormat = 1
	DomainCoreDumpFormatKdumpLzo    DomainCoreDumpFormat = 2
	DomainCoreDumpFormatKdumpSnappy DomainCoreDumpFormat = 3
	DomainCoreDumpFormatWinDmp      DomainCoreDumpFormat = 4
)

// DomainMigrateFlags as declared in libvirt/libvirt-domain.h:1116
type DomainMigrateFlags int32

// DomainMigrateFlags enumeration from libvirt/libvirt-domain.h:1116
const (
	MigrateLive                       DomainMigrateFlags = 1
	MigratePeer2peer                  DomainMigrateFlags = 2
	MigrateTunnelled                  DomainMigrateFlags = 4
	MigratePersistDest                DomainMigrateFlags = 8
	MigrateUndefineSource             DomainMigrateFlags = 16
	MigratePaused                     DomainMigrateFlags = 32
	MigrateNonSharedDisk              DomainMigrateFlags = 64
	MigrateNonSharedInc               DomainMigrateFlags = 128
	MigrateChangeProtection           DomainMigrateFlags = 256
	MigrateUnsafe                     DomainMigrateFlags = 512
	MigrateOffline                    DomainMigrateFlags = 1024
	MigrateCompressed                 DomainMigrateFlags = 2048
	MigrateAbortOnError               DomainMigrateFlags = 4096
	MigrateAutoConverge               DomainMigrateFlags = 8192
	MigrateRdmaPinAll                 DomainMigrateFlags = 16384
	MigratePostcopy                   DomainMigrateFlags = 32768
	MigrateTLS                        DomainMigrateFlags = 65536
	MigrateParallel                   DomainMigrateFlags = 131072
	MigrateNonSharedSynchronousWrites DomainMigrateFlags = 262144
	MigratePostcopyResume             DomainMigrateFlags = 524288
	MigrateZerocopy                   DomainMigrateFlags = 1048576
)

// DomainMigrateMaxSpeedFlags as declared in libvirt/libvirt-domain.h:1497
type DomainMigrateMaxSpeedFlags int32

// DomainMigrateMaxSpeedFlags enumeration from libvirt/libvirt-domain.h:1497
const (
	DomainMigrateMaxSpeedPostcopy DomainMigrateMaxSpeedFlags = 1
)

// ConnectGetDomainCapabilitiesFlags as declared in libvirt/libvirt-domain.h:1520
type ConnectGetDomainCapabilitiesFlags int32

// ConnectGetDomainCapabilitiesFlags enumeration from libvirt/libvirt-domain.h:1520
const (
	ConnectGetDomainCapabilitiesDisableDeprecatedFeatures ConnectGetDomainCapabilitiesFlags = 1
)

// DomainShutdownFlagValues as declared in libvirt/libvirt-domain.h:1580
type DomainShutdownFlagValues int32

// DomainShutdownFlagValues enumeration from libvirt/libvirt-domain.h:1580
const (
	DomainShutdownDefault      DomainShutdownFlagValues = iota
	DomainShutdownAcpiPowerBtn DomainShutdownFlagValues = 1
	DomainShutdownGuestAgent   DomainShutdownFlagValues = 2
	DomainShutdownInitctl      DomainShutdownFlagValues = 4
	DomainShutdownSignal       DomainShutdownFlagValues = 8
	DomainShutdownParavirt     DomainShutdownFlagValues = 16
)

// DomainRebootFlagValues as declared in libvirt/libvirt-domain.h:1598
type DomainRebootFlagValues int32

// DomainRebootFlagValues enumeration from libvirt/libvirt-domain.h:1598
const (
	DomainRebootDefault      DomainRebootFlagValues = iota
	DomainRebootAcpiPowerBtn DomainRebootFlagValues = 1
	DomainRebootGuestAgent   DomainRebootFlagValues = 2
	DomainRebootInitctl      DomainRebootFlagValues = 4
	DomainRebootSignal       DomainRebootFlagValues = 8
	DomainRebootParavirt     DomainRebootFlagValues = 16
)

// DomainDestroyFlagsValues as declared in libvirt/libvirt-domain.h:1619
type DomainDestroyFlagsValues int32

// DomainDestroyFlagsValues enumeration from libvirt/libvirt-domain.h:1619
const (
	DomainDestroyDefault    DomainDestroyFlagsValues = iota
	DomainDestroyGraceful   DomainDestroyFlagsValues = 1
	DomainDestroyRemoveLogs DomainDestroyFlagsValues = 2
)

// DomainSaveRestoreFlags as declared in libvirt/libvirt-domain.h:1656
type DomainSaveRestoreFlags int32

// DomainSaveRestoreFlags enumeration from libvirt/libvirt-domain.h:1656
const (
	DomainSaveBypassCache DomainSaveRestoreFlags = 1
	DomainSaveRunning     DomainSaveRestoreFlags = 2
	DomainSavePaused      DomainSaveRestoreFlags = 4
	DomainSaveResetNvram  DomainSaveRestoreFlags = 8
)

// DomainMemoryModFlags as declared in libvirt/libvirt-domain.h:1991
type DomainMemoryModFlags int32

// DomainMemoryModFlags enumeration from libvirt/libvirt-domain.h:1991
const (
	DomainMemCurrent DomainMemoryModFlags = iota
	DomainMemLive    DomainMemoryModFlags = 1
	DomainMemConfig  DomainMemoryModFlags = 2
	DomainMemMaximum DomainMemoryModFlags = 4
)

// DomainNumatuneMemMode as declared in libvirt/libvirt-domain.h:2012
type DomainNumatuneMemMode int32

// DomainNumatuneMemMode enumeration from libvirt/libvirt-domain.h:2012
const (
	DomainNumatuneMemStrict      DomainNumatuneMemMode = iota
	DomainNumatuneMemPreferred   DomainNumatuneMemMode = 1
	DomainNumatuneMemInterleave  DomainNumatuneMemMode = 2
	DomainNumatuneMemRestrictive DomainNumatuneMemMode = 3
)

// DomainGetHostnameFlags as declared in libvirt/libvirt-domain.h:2073
type DomainGetHostnameFlags int32

// DomainGetHostnameFlags enumeration from libvirt/libvirt-domain.h:2073
const (
	DomainGetHostnameLease DomainGetHostnameFlags = 1
	DomainGetHostnameAgent DomainGetHostnameFlags = 2
)

// DomainMetadataType as declared in libvirt/libvirt-domain.h:2093
type DomainMetadataType int32

// DomainMetadataType enumeration from libvirt/libvirt-domain.h:2093
const (
	DomainMetadataDescription DomainMetadataType = iota
	DomainMetadataTitle       DomainMetadataType = 1
	DomainMetadataElement     DomainMetadataType = 2
)

// DomainXMLFlags as declared in libvirt/libvirt-domain.h:2125
type DomainXMLFlags int32

// DomainXMLFlags enumeration from libvirt/libvirt-domain.h:2125
const (
	DomainXMLSecure     DomainXMLFlags = 1
	DomainXMLInactive   DomainXMLFlags = 2
	DomainXMLUpdateCPU  DomainXMLFlags = 4
	DomainXMLMigratable DomainXMLFlags = 8
)

// DomainSaveImageXMLFlags as declared in libvirt/libvirt-domain.h:2134
type DomainSaveImageXMLFlags int32

// DomainSaveImageXMLFlags enumeration from libvirt/libvirt-domain.h:2134
const (
	DomainSaveImageXMLSecure DomainSaveImageXMLFlags = 1
)

// DomainBlockResizeFlags as declared in libvirt/libvirt-domain.h:2256
type DomainBlockResizeFlags int32

// DomainBlockResizeFlags enumeration from libvirt/libvirt-domain.h:2256
const (
	DomainBlockResizeBytes    DomainBlockResizeFlags = 1
	DomainBlockResizeCapacity DomainBlockResizeFlags = 2
)

// DomainMemoryFlags as declared in libvirt/libvirt-domain.h:2332
type DomainMemoryFlags int32

// DomainMemoryFlags enumeration from libvirt/libvirt-domain.h:2332
const (
	MemoryVirtual  DomainMemoryFlags = 1
	MemoryPhysical DomainMemoryFlags = 2
)

// DomainDefineFlags as declared in libvirt/libvirt-domain.h:2347
type DomainDefineFlags int32

// DomainDefineFlags enumeration from libvirt/libvirt-domain.h:2347
const (
	DomainDefineValidate DomainDefineFlags = 1
)

// DomainUndefineFlagsValues as declared in libvirt/libvirt-domain.h:2381
type DomainUndefineFlagsValues int32

// DomainUndefineFlagsValues enumeration from libvirt/libvirt-domain.h:2381
const (
	DomainUndefineManagedSave         DomainUndefineFlagsValues = 1
	DomainUndefineSnapshotsMetadata   DomainUndefineFlagsValues = 2
	DomainUndefineNvram               DomainUndefineFlagsValues = 4
	DomainUndefineKeepNvram           DomainUndefineFlagsValues = 8
	DomainUndefineCheckpointsMetadata DomainUndefineFlagsValues = 16
	DomainUndefineTpm                 DomainUndefineFlagsValues = 32
	DomainUndefineKeepTpm             DomainUndefineFlagsValues = 64
)

// ConnectListAllDomainsFlags as declared in libvirt/libvirt-domain.h:2422
type ConnectListAllDomainsFlags int32

// ConnectListAllDomainsFlags enumeration from libvirt/libvirt-domain.h:2422
const (
	ConnectListDomainsActive        ConnectListAllDomainsFlags = 1
	ConnectListDomainsInactive      ConnectListAllDomainsFlags = 2
	ConnectListDomainsPersistent    ConnectListAllDomainsFlags = 4
	ConnectListDomainsTransient     ConnectListAllDomainsFlags = 8
	ConnectListDomainsRunning       ConnectListAllDomainsFlags = 16
	ConnectListDomainsPaused        ConnectListAllDomainsFlags = 32
	ConnectListDomainsShutoff       ConnectListAllDomainsFlags = 64
	ConnectListDomainsOther         ConnectListAllDomainsFlags = 128
	ConnectListDomainsManagedsave   ConnectListAllDomainsFlags = 256
	ConnectListDomainsNoManagedsave ConnectListAllDomainsFlags = 512
	ConnectListDomainsAutostart     ConnectListAllDomainsFlags = 1024
	ConnectListDomainsNoAutostart   ConnectListAllDomainsFlags = 2048
	ConnectListDomainsHasSnapshot   ConnectListAllDomainsFlags = 4096
	ConnectListDomainsNoSnapshot    ConnectListAllDomainsFlags = 8192
	ConnectListDomainsHasCheckpoint ConnectListAllDomainsFlags = 16384
	ConnectListDomainsNoCheckpoint  ConnectListAllDomainsFlags = 32768
)

// VCPUState as declared in libvirt/libvirt-domain.h:2460
type VCPUState int32

// VCPUState enumeration from libvirt/libvirt-domain.h:2460
const (
	VCPUOffline VCPUState = iota
	VCPURunning VCPUState = 1
	VCPUBlocked VCPUState = 2
)

// VCPUHostCPUState as declared in libvirt/libvirt-domain.h:2470
type VCPUHostCPUState int32

// VCPUHostCPUState enumeration from libvirt/libvirt-domain.h:2470
const (
	VCPUInfoCPUOffline     VCPUHostCPUState = -1
	VCPUInfoCPUUnavailable VCPUHostCPUState = -2
)

// DomainVCPUFlags as declared in libvirt/libvirt-domain.h:2507
type DomainVCPUFlags int32

// DomainVCPUFlags enumeration from libvirt/libvirt-domain.h:2507
const (
	DomainVCPUCurrent      DomainVCPUFlags = iota
	DomainVCPULive         DomainVCPUFlags = 1
	DomainVCPUConfig       DomainVCPUFlags = 2
	DomainVCPUMaximum      DomainVCPUFlags = 4
	DomainVCPUGuest        DomainVCPUFlags = 8
	DomainVCPUHotpluggable DomainVCPUFlags = 16
)

// DomainDeviceModifyFlags as declared in libvirt/libvirt-domain.h:2776
type DomainDeviceModifyFlags int32

// DomainDeviceModifyFlags enumeration from libvirt/libvirt-domain.h:2776
const (
	DomainDeviceModifyCurrent DomainDeviceModifyFlags = iota
	DomainDeviceModifyLive    DomainDeviceModifyFlags = 1
	DomainDeviceModifyConfig  DomainDeviceModifyFlags = 2
	DomainDeviceModifyForce   DomainDeviceModifyFlags = 4
)

// DomainStatsTypes as declared in libvirt/libvirt-domain.h:3962
type DomainStatsTypes int32

// DomainStatsTypes enumeration from libvirt/libvirt-domain.h:3962
const (
	DomainStatsState     DomainStatsTypes = 1
	DomainStatsCPUTotal  DomainStatsTypes = 2
	DomainStatsBalloon   DomainStatsTypes = 4
	DomainStatsVCPU      DomainStatsTypes = 8
	DomainStatsInterface DomainStatsTypes = 16
	DomainStatsBlock     DomainStatsTypes = 32
	DomainStatsPerf      DomainStatsTypes = 64
	DomainStatsIothread  DomainStatsTypes = 128
	DomainStatsMemory    DomainStatsTypes = 256
	DomainStatsDirtyrate DomainStatsTypes = 512
	DomainStatsVm        DomainStatsTypes = 1024
)

// ConnectGetAllDomainStatsFlags as declared in libvirt/libvirt-domain.h:3985
type ConnectGetAllDomainStatsFlags uint32

// ConnectGetAllDomainStatsFlags enumeration from libvirt/libvirt-domain.h:3985
const (
	ConnectGetAllDomainsStatsActive       ConnectGetAllDomainStatsFlags = 1
	ConnectGetAllDomainsStatsInactive     ConnectGetAllDomainStatsFlags = 2
	ConnectGetAllDomainsStatsPersistent   ConnectGetAllDomainStatsFlags = 4
	ConnectGetAllDomainsStatsTransient    ConnectGetAllDomainStatsFlags = 8
	ConnectGetAllDomainsStatsRunning      ConnectGetAllDomainStatsFlags = 16
	ConnectGetAllDomainsStatsPaused       ConnectGetAllDomainStatsFlags = 32
	ConnectGetAllDomainsStatsShutoff      ConnectGetAllDomainStatsFlags = 64
	ConnectGetAllDomainsStatsOther        ConnectGetAllDomainStatsFlags = 128
	ConnectGetAllDomainsStatsNowait       ConnectGetAllDomainStatsFlags = 536870912
	ConnectGetAllDomainsStatsBacking      ConnectGetAllDomainStatsFlags = 1073741824
	ConnectGetAllDomainsStatsEnforceStats ConnectGetAllDomainStatsFlags = 2147483648
)

// DomainBlockJobType as declared in libvirt/libvirt-domain.h:4333
type DomainBlockJobType int32

// DomainBlockJobType enumeration from libvirt/libvirt-domain.h:4333
const (
	DomainBlockJobTypeUnknown      DomainBlockJobType = iota
	DomainBlockJobTypePull         DomainBlockJobType = 1
	DomainBlockJobTypeCopy         DomainBlockJobType = 2
	DomainBlockJobTypeCommit       DomainBlockJobType = 3
	DomainBlockJobTypeActiveCommit DomainBlockJobType = 4
	DomainBlockJobTypeBackup       DomainBlockJobType = 5
)

// DomainBlockJobAbortFlags as declared in libvirt/libvirt-domain.h:4347
type DomainBlockJobAbortFlags int32

// DomainBlockJobAbortFlags enumeration from libvirt/libvirt-domain.h:4347
const (
	DomainBlockJobAbortAsync DomainBlockJobAbortFlags = 1
	DomainBlockJobAbortPivot DomainBlockJobAbortFlags = 2
)

// DomainBlockJobInfoFlags as declared in libvirt/libvirt-domain.h:4362
type DomainBlockJobInfoFlags int32

// DomainBlockJobInfoFlags enumeration from libvirt/libvirt-domain.h:4362
const (
	DomainBlockJobInfoBandwidthBytes DomainBlockJobInfoFlags = 1
)

// DomainBlockJobSetSpeedFlags as declared in libvirt/libvirt-domain.h:4414
type DomainBlockJobSetSpeedFlags int32

// DomainBlockJobSetSpeedFlags enumeration from libvirt/libvirt-domain.h:4414
const (
	DomainBlockJobSpeedBandwidthBytes DomainBlockJobSetSpeedFlags = 1
)

// DomainBlockPullFlags as declared in libvirt/libvirt-domain.h:4430
type DomainBlockPullFlags int32

// DomainBlockPullFlags enumeration from libvirt/libvirt-domain.h:4430
const (
	DomainBlockPullBandwidthBytes DomainBlockPullFlags = 64
)

// DomainBlockRebaseFlags as declared in libvirt/libvirt-domain.h:4456
type DomainBlockRebaseFlags int32

// DomainBlockRebaseFlags enumeration from libvirt/libvirt-domain.h:4456
const (
	DomainBlockRebaseShallow        DomainBlockRebaseFlags = 1
	DomainBlockRebaseReuseExt       DomainBlockRebaseFlags = 2
	DomainBlockRebaseCopyRaw        DomainBlockRebaseFlags = 4
	DomainBlockRebaseCopy           DomainBlockRebaseFlags = 8
	DomainBlockRebaseRelative       DomainBlockRebaseFlags = 16
	DomainBlockRebaseCopyDev        DomainBlockRebaseFlags = 32
	DomainBlockRebaseBandwidthBytes DomainBlockRebaseFlags = 64
)

// DomainBlockCopyFlags as declared in libvirt/libvirt-domain.h:4485
type DomainBlockCopyFlags int32

// DomainBlockCopyFlags enumeration from libvirt/libvirt-domain.h:4485
const (
	DomainBlockCopyShallow           DomainBlockCopyFlags = 1
	DomainBlockCopyReuseExt          DomainBlockCopyFlags = 2
	DomainBlockCopyTransientJob      DomainBlockCopyFlags = 4
	DomainBlockCopySynchronousWrites DomainBlockCopyFlags = 8
)

// DomainBlockCommitFlags as declared in libvirt/libvirt-domain.h:4558
type DomainBlockCommitFlags int32

// DomainBlockCommitFlags enumeration from libvirt/libvirt-domain.h:4558
const (
	DomainBlockCommitShallow        DomainBlockCommitFlags = 1
	DomainBlockCommitDelete         DomainBlockCommitFlags = 2
	DomainBlockCommitActive         DomainBlockCommitFlags = 4
	DomainBlockCommitRelative       DomainBlockCommitFlags = 8
	DomainBlockCommitBandwidthBytes DomainBlockCommitFlags = 16
)

// DomainDiskErrorCode as declared in libvirt/libvirt-domain.h:4791
type DomainDiskErrorCode int32

// DomainDiskErrorCode enumeration from libvirt/libvirt-domain.h:4791
const (
	DomainDiskErrorNone    DomainDiskErrorCode = iota
	DomainDiskErrorUnspec  DomainDiskErrorCode = 1
	DomainDiskErrorNoSpace DomainDiskErrorCode = 2
)

// KeycodeSet as declared in libvirt/libvirt-domain.h:4848
type KeycodeSet int32

// KeycodeSet enumeration from libvirt/libvirt-domain.h:4848
const (
	KeycodeSetLinux  KeycodeSet = iota
	KeycodeSetXt     KeycodeSet = 1
	KeycodeSetAtset1 KeycodeSet = 2
	KeycodeSetAtset2 KeycodeSet = 3
	KeycodeSetAtset3 KeycodeSet = 4
	KeycodeSetOsx    KeycodeSet = 5
	KeycodeSetXtKbd  KeycodeSet = 6
	KeycodeSetUsb    KeycodeSet = 7
	KeycodeSetWin32  KeycodeSet = 8
	KeycodeSetQnum   KeycodeSet = 9
)

// DomainProcessSignal as declared in libvirt/libvirt-domain.h:4965
type DomainProcessSignal int32

// DomainProcessSignal enumeration from libvirt/libvirt-domain.h:4965
const (
	DomainProcessSignalNop    DomainProcessSignal = iota
	DomainProcessSignalHup    DomainProcessSignal = 1
	DomainProcessSignalInt    DomainProcessSignal = 2
	DomainProcessSignalQuit   DomainProcessSignal = 3
	DomainProcessSignalIll    DomainProcessSignal = 4
	DomainProcessSignalTrap   DomainProcessSignal = 5
	DomainProcessSignalAbrt   DomainProcessSignal = 6
	DomainProcessSignalBus    DomainProcessSignal = 7
	DomainProcessSignalFpe    DomainProcessSignal = 8
	DomainProcessSignalKill   DomainProcessSignal = 9
	DomainProcessSignalUsr1   DomainProcessSignal = 10
	DomainProcessSignalSegv   DomainProcessSignal = 11
	DomainProcessSignalUsr2   DomainProcessSignal = 12
	DomainProcessSignalPipe   DomainProcessSignal = 13
	DomainProcessSignalAlrm   DomainProcessSignal = 14
	DomainProcessSignalTerm   DomainProcessSignal = 15
	DomainProcessSignalStkflt DomainProcessSignal = 16
	DomainProcessSignalChld   DomainProcessSignal = 17
	DomainProcessSignalCont   DomainProcessSignal = 18
	DomainProcessSignalStop   DomainProcessSignal = 19
	DomainProcessSignalTstp   DomainProcessSignal = 20
	DomainProcessSignalTtin   DomainProcessSignal = 21
	DomainProcessSignalTtou   DomainProcessSignal = 22
	DomainProcessSignalUrg    DomainProcessSignal = 23
	DomainProcessSignalXcpu   DomainProcessSignal = 24
	DomainProcessSignalXfsz   DomainProcessSignal = 25
	DomainProcessSignalVtalrm DomainProcessSignal = 26
	DomainProcessSignalProf   DomainProcessSignal = 27
	DomainProcessSignalWinch  DomainProcessSignal = 28
	DomainProcessSignalPoll   DomainProcessSignal = 29
	DomainProcessSignalPwr    DomainProcessSignal = 30
	DomainProcessSignalSys    DomainProcessSignal = 31
	DomainProcessSignalRt0    DomainProcessSignal = 32
	DomainProcessSignalRt1    DomainProcessSignal = 33
	DomainProcessSignalRt2    DomainProcessSignal = 34
	DomainProcessSignalRt3    DomainProcessSignal = 35
	DomainProcessSignalRt4    DomainProcessSignal = 36
	DomainProcessSignalRt5    DomainProcessSignal = 37
	DomainProcessSignalRt6    DomainProcessSignal = 38
	DomainProcessSignalRt7    DomainProcessSignal = 39
	DomainProcessSignalRt8    DomainProcessSignal = 40
	DomainProcessSignalRt9    DomainProcessSignal = 41
	DomainProcessSignalRt10   DomainProcessSignal = 42
	DomainProcessSignalRt11   DomainProcessSignal = 43
	DomainProcessSignalRt12   DomainProcessSignal = 44
	DomainProcessSignalRt13   DomainProcessSignal = 45
	DomainProcessSignalRt14   DomainProcessSignal = 46
	DomainProcessSignalRt15   DomainProcessSignal = 47
	DomainProcessSignalRt16   DomainProcessSignal = 48
	DomainProcessSignalRt17   DomainProcessSignal = 49
	DomainProcessSignalRt18   DomainProcessSignal = 50
	DomainProcessSignalRt19   DomainProcessSignal = 51
	DomainProcessSignalRt20   DomainProcessSignal = 52
	DomainProcessSignalRt21   DomainProcessSignal = 53
	DomainProcessSignalRt22   DomainProcessSignal = 54
	DomainProcessSignalRt23   DomainProcessSignal = 55
	DomainProcessSignalRt24   DomainProcessSignal = 56
	DomainProcessSignalRt25   DomainProcessSignal = 57
	DomainProcessSignalRt26   DomainProcessSignal = 58
	DomainProcessSignalRt27   DomainProcessSignal = 59
	DomainProcessSignalRt28   DomainProcessSignal = 60
	DomainProcessSignalRt29   DomainProcessSignal = 61
	DomainProcessSignalRt30   DomainProcessSignal = 62
	DomainProcessSignalRt31   DomainProcessSignal = 63
	DomainProcessSignalRt32   DomainProcessSignal = 64
)

// DomainEventType as declared in libvirt/libvirt-domain.h:5005
type DomainEventType int32

// DomainEventType enumeration from libvirt/libvirt-domain.h:5005
const (
	DomainEventDefined     DomainEventType = iota
	DomainEventUndefined   DomainEventType = 1
	DomainEventStarted     DomainEventType = 2
	DomainEventSuspended   DomainEventType = 3
	DomainEventResumed     DomainEventType = 4
	DomainEventStopped     DomainEventType = 5
	DomainEventShutdown    DomainEventType = 6
	DomainEventPmsuspended DomainEventType = 7
	DomainEventCrashed     DomainEventType = 8
)

// DomainEventDefinedDetailType as declared in libvirt/libvirt-domain.h:5023
type DomainEventDefinedDetailType int32

// DomainEventDefinedDetailType enumeration from libvirt/libvirt-domain.h:5023
const (
	DomainEventDefinedAdded        DomainEventDefinedDetailType = iota
	DomainEventDefinedUpdated      DomainEventDefinedDetailType = 1
	DomainEventDefinedRenamed      DomainEventDefinedDetailType = 2
	DomainEventDefinedFromSnapshot DomainEventDefinedDetailType = 3
)

// DomainEventUndefinedDetailType as declared in libvirt/libvirt-domain.h:5039
type DomainEventUndefinedDetailType int32

// DomainEventUndefinedDetailType enumeration from libvirt/libvirt-domain.h:5039
const (
	DomainEventUndefinedRemoved DomainEventUndefinedDetailType = iota
	DomainEventUndefinedRenamed DomainEventUndefinedDetailType = 1
)

// DomainEventStartedDetailType as declared in libvirt/libvirt-domain.h:5059
type DomainEventStartedDetailType int32

// DomainEventStartedDetailType enumeration from libvirt/libvirt-domain.h:5059
const (
	DomainEventStartedBooted       DomainEventStartedDetailType = iota
	DomainEventStartedMigrated     DomainEventStartedDetailType = 1
	DomainEventStartedRestored     DomainEventStartedDetailType = 2
	DomainEventStartedFromSnapshot DomainEventStartedDetailType = 3
	DomainEventStartedWakeup       DomainEventStartedDetailType = 4
	DomainEventStartedRecreated    DomainEventStartedDetailType = 5
)

// DomainEventSuspendedDetailType as declared in libvirt/libvirt-domain.h:5082
type DomainEventSuspendedDetailType int32

// DomainEventSuspendedDetailType enumeration from libvirt/libvirt-domain.h:5082
const (
	DomainEventSuspendedPaused         DomainEventSuspendedDetailType = iota
	DomainEventSuspendedMigrated       DomainEventSuspendedDetailType = 1
	DomainEventSuspendedIoerror        DomainEventSuspendedDetailType = 2
	DomainEventSuspendedWatchdog       DomainEventSuspendedDetailType = 3
	DomainEventSuspendedRestored       DomainEventSuspendedDetailType = 4
	DomainEventSuspendedFromSnapshot   DomainEventSuspendedDetailType = 5
	DomainEventSuspendedAPIError       DomainEventSuspendedDetailType = 6
	DomainEventSuspendedPostcopy       DomainEventSuspendedDetailType = 7
	DomainEventSuspendedPostcopyFailed DomainEventSuspendedDetailType = 8
)

// DomainEventResumedDetailType as declared in libvirt/libvirt-domain.h:5102
type DomainEventResumedDetailType int32

// DomainEventResumedDetailType enumeration from libvirt/libvirt-domain.h:5102
const (
	DomainEventResumedUnpaused       DomainEventResumedDetailType = iota
	DomainEventResumedMigrated       DomainEventResumedDetailType = 1
	DomainEventResumedFromSnapshot   DomainEventResumedDetailType = 2
	DomainEventResumedPostcopy       DomainEventResumedDetailType = 3
	DomainEventResumedPostcopyFailed DomainEventResumedDetailType = 4
)

// DomainEventStoppedDetailType as declared in libvirt/libvirt-domain.h:5124
type DomainEventStoppedDetailType int32

// DomainEventStoppedDetailType enumeration from libvirt/libvirt-domain.h:5124
const (
	DomainEventStoppedShutdown     DomainEventStoppedDetailType = iota
	DomainEventStoppedDestroyed    DomainEventStoppedDetailType = 1
	DomainEventStoppedCrashed      DomainEventStoppedDetailType = 2
	DomainEventStoppedMigrated     DomainEventStoppedDetailType = 3
	DomainEventStoppedSaved        DomainEventStoppedDetailType = 4
	DomainEventStoppedFailed       DomainEventStoppedDetailType = 5
	DomainEventStoppedFromSnapshot DomainEventStoppedDetailType = 6
	DomainEventStoppedRecreated    DomainEventStoppedDetailType = 7
)

// DomainEventShutdownDetailType as declared in libvirt/libvirt-domain.h:5152
type DomainEventShutdownDetailType int32

// DomainEventShutdownDetailType enumeration from libvirt/libvirt-domain.h:5152
const (
	DomainEventShutdownFinished DomainEventShutdownDetailType = iota
	DomainEventShutdownGuest    DomainEventShutdownDetailType = 1
	DomainEventShutdownHost     DomainEventShutdownDetailType = 2
)

// DomainEventPMSuspendedDetailType as declared in libvirt/libvirt-domain.h:5168
type DomainEventPMSuspendedDetailType int32

// DomainEventPMSuspendedDetailType enumeration from libvirt/libvirt-domain.h:5168
const (
	DomainEventPmsuspendedMemory DomainEventPMSuspendedDetailType = iota
	DomainEventPmsuspendedDisk   DomainEventPMSuspendedDetailType = 1
)

// DomainEventCrashedDetailType as declared in libvirt/libvirt-domain.h:5184
type DomainEventCrashedDetailType int32

// DomainEventCrashedDetailType enumeration from libvirt/libvirt-domain.h:5184
const (
	DomainEventCrashedPanicked    DomainEventCrashedDetailType = iota
	DomainEventCrashedCrashloaded DomainEventCrashedDetailType = 1
)

// DomainMemoryFailureRecipientType as declared in libvirt/libvirt-domain.h:5203
type DomainMemoryFailureRecipientType int32

// DomainMemoryFailureRecipientType enumeration from libvirt/libvirt-domain.h:5203
const (
	DomainEventMemoryFailureRecipientHypervisor DomainMemoryFailureRecipientType = iota
	DomainEventMemoryFailureRecipientGuest      DomainMemoryFailureRecipientType = 1
)

// DomainMemoryFailureActionType as declared in libvirt/libvirt-domain.h:5246
type DomainMemoryFailureActionType int32

// DomainMemoryFailureActionType enumeration from libvirt/libvirt-domain.h:5246
const (
	DomainEventMemoryFailureActionIgnore DomainMemoryFailureActionType = iota
	DomainEventMemoryFailureActionInject DomainMemoryFailureActionType = 1
	DomainEventMemoryFailureActionFatal  DomainMemoryFailureActionType = 2
	DomainEventMemoryFailureActionReset  DomainMemoryFailureActionType = 3
)

// DomainMemoryFailureFlags as declared in libvirt/libvirt-domain.h:5265
type DomainMemoryFailureFlags int32

// DomainMemoryFailureFlags enumeration from libvirt/libvirt-domain.h:5265
const (
	DomainMemoryFailureActionRequired DomainMemoryFailureFlags = 1
	DomainMemoryFailureRecursive      DomainMemoryFailureFlags = 2
)

// DomainJobType as declared in libvirt/libvirt-domain.h:5317
type DomainJobType int32

// DomainJobType enumeration from libvirt/libvirt-domain.h:5317
const (
	DomainJobNone      DomainJobType = iota
	DomainJobBounded   DomainJobType = 1
	DomainJobUnbounded DomainJobType = 2
	DomainJobCompleted DomainJobType = 3
	DomainJobFailed    DomainJobType = 4
	DomainJobCancelled DomainJobType = 5
)

// DomainGetJobStatsFlags as declared in libvirt/libvirt-domain.h:5379
type DomainGetJobStatsFlags int32

// DomainGetJobStatsFlags enumeration from libvirt/libvirt-domain.h:5379
const (
	DomainJobStatsCompleted     DomainGetJobStatsFlags = 1
	DomainJobStatsKeepCompleted DomainGetJobStatsFlags = 2
)

// DomainAbortJobFlagsValues as declared in libvirt/libvirt-domain.h:5404
type DomainAbortJobFlagsValues int32

// DomainAbortJobFlagsValues enumeration from libvirt/libvirt-domain.h:5404
const (
	DomainAbortJobPostcopy DomainAbortJobFlagsValues = 1
)

// DomainJobOperation as declared in libvirt/libvirt-domain.h:5430
type DomainJobOperation int32

// DomainJobOperation enumeration from libvirt/libvirt-domain.h:5430
const (
	DomainJobOperationStrUnknown        DomainJobOperation = iota
	DomainJobOperationStrStart          DomainJobOperation = 1
	DomainJobOperationStrSave           DomainJobOperation = 2
	DomainJobOperationStrRestore        DomainJobOperation = 3
	DomainJobOperationStrMigrationIn    DomainJobOperation = 4
	DomainJobOperationStrMigrationOut   DomainJobOperation = 5
	DomainJobOperationStrSnapshot       DomainJobOperation = 6
	DomainJobOperationStrSnapshotRevert DomainJobOperation = 7
	DomainJobOperationStrDump           DomainJobOperation = 8
	DomainJobOperationStrBackup         DomainJobOperation = 9
	DomainJobOperationStrSnapshotDelete DomainJobOperation = 10
)

// DomainEventWatchdogAction as declared in libvirt/libvirt-domain.h:5899
type DomainEventWatchdogAction int32

// DomainEventWatchdogAction enumeration from libvirt/libvirt-domain.h:5899
const (
	DomainEventWatchdogNone      DomainEventWatchdogAction = iota
	DomainEventWatchdogPause     DomainEventWatchdogAction = 1
	DomainEventWatchdogReset     DomainEventWatchdogAction = 2
	DomainEventWatchdogPoweroff  DomainEventWatchdogAction = 3
	DomainEventWatchdogShutdown  DomainEventWatchdogAction = 4
	DomainEventWatchdogDebug     DomainEventWatchdogAction = 5
	DomainEventWatchdogInjectnmi DomainEventWatchdogAction = 6
)

// DomainEventIOErrorAction as declared in libvirt/libvirt-domain.h:5933
type DomainEventIOErrorAction int32

// DomainEventIOErrorAction enumeration from libvirt/libvirt-domain.h:5933
const (
	DomainEventIoErrorNone   DomainEventIOErrorAction = iota
	DomainEventIoErrorPause  DomainEventIOErrorAction = 1
	DomainEventIoErrorReport DomainEventIOErrorAction = 2
)

// DomainEventGraphicsPhase as declared in libvirt/libvirt-domain.h:6007
type DomainEventGraphicsPhase int32

// DomainEventGraphicsPhase enumeration from libvirt/libvirt-domain.h:6007
const (
	DomainEventGraphicsConnect    DomainEventGraphicsPhase = iota
	DomainEventGraphicsInitialize DomainEventGraphicsPhase = 1
	DomainEventGraphicsDisconnect DomainEventGraphicsPhase = 2
)

// DomainEventGraphicsAddressType as declared in libvirt/libvirt-domain.h:6024
type DomainEventGraphicsAddressType int32

// DomainEventGraphicsAddressType enumeration from libvirt/libvirt-domain.h:6024
const (
	DomainEventGraphicsAddressIpv4 DomainEventGraphicsAddressType = iota
	DomainEventGraphicsAddressIpv6 DomainEventGraphicsAddressType = 1
	DomainEventGraphicsAddressUnix DomainEventGraphicsAddressType = 2
)

// ConnectDomainEventBlockJobStatus as declared in libvirt/libvirt-domain.h:6155
type ConnectDomainEventBlockJobStatus int32

// ConnectDomainEventBlockJobStatus enumeration from libvirt/libvirt-domain.h:6155
const (
	DomainBlockJobCompleted ConnectDomainEventBlockJobStatus = iota
	DomainBlockJobFailed    ConnectDomainEventBlockJobStatus = 1
	DomainBlockJobCanceled  ConnectDomainEventBlockJobStatus = 2
	DomainBlockJobReady     ConnectDomainEventBlockJobStatus = 3
)

// ConnectDomainEventDiskChangeReason as declared in libvirt/libvirt-domain.h:6215
type ConnectDomainEventDiskChangeReason int32

// ConnectDomainEventDiskChangeReason enumeration from libvirt/libvirt-domain.h:6215
const (
	DomainEventDiskChangeMissingOnStart ConnectDomainEventDiskChangeReason = iota
	DomainEventDiskDropMissingOnStart   ConnectDomainEventDiskChangeReason = 1
)

// DomainEventTrayChangeReason as declared in libvirt/libvirt-domain.h:6260
type DomainEventTrayChangeReason int32

// DomainEventTrayChangeReason enumeration from libvirt/libvirt-domain.h:6260
const (
	DomainEventTrayChangeOpen  DomainEventTrayChangeReason = iota
	DomainEventTrayChangeClose DomainEventTrayChangeReason = 1
)

// ConnectDomainEventAgentLifecycleState as declared in libvirt/libvirt-domain.h:6872
type ConnectDomainEventAgentLifecycleState int32

// ConnectDomainEventAgentLifecycleState enumeration from libvirt/libvirt-domain.h:6872
const (
	ConnectDomainEventAgentLifecycleStateConnected    ConnectDomainEventAgentLifecycleState = 1
	ConnectDomainEventAgentLifecycleStateDisconnected ConnectDomainEventAgentLifecycleState = 2
)

// ConnectDomainEventAgentLifecycleReason as declared in libvirt/libvirt-domain.h:6887
type ConnectDomainEventAgentLifecycleReason int32

// ConnectDomainEventAgentLifecycleReason enumeration from libvirt/libvirt-domain.h:6887
const (
	ConnectDomainEventAgentLifecycleReasonUnknown       ConnectDomainEventAgentLifecycleReason = iota
	ConnectDomainEventAgentLifecycleReasonDomainStarted ConnectDomainEventAgentLifecycleReason = 1
	ConnectDomainEventAgentLifecycleReasonChannel       ConnectDomainEventAgentLifecycleReason = 2
)

// DomainEventID as declared in libvirt/libvirt-domain.h:7083
type DomainEventID int32

// DomainEventID enumeration from libvirt/libvirt-domain.h:7083
const (
	DomainEventIDLifecycle              DomainEventID = iota
	DomainEventIDReboot                 DomainEventID = 1
	DomainEventIDRtcChange              DomainEventID = 2
	DomainEventIDWatchdog               DomainEventID = 3
	DomainEventIDIoError                DomainEventID = 4
	DomainEventIDGraphics               DomainEventID = 5
	DomainEventIDIoErrorReason          DomainEventID = 6
	DomainEventIDControlError           DomainEventID = 7
	DomainEventIDBlockJob               DomainEventID = 8
	DomainEventIDDiskChange             DomainEventID = 9
	DomainEventIDTrayChange             DomainEventID = 10
	DomainEventIDPmwakeup               DomainEventID = 11
	DomainEventIDPmsuspend              DomainEventID = 12
	DomainEventIDBalloonChange          DomainEventID = 13
	DomainEventIDPmsuspendDisk          DomainEventID = 14
	DomainEventIDDeviceRemoved          DomainEventID = 15
	DomainEventIDBlockJob2              DomainEventID = 16
	DomainEventIDTunable                DomainEventID = 17
	DomainEventIDAgentLifecycle         DomainEventID = 18
	DomainEventIDDeviceAdded            DomainEventID = 19
	DomainEventIDMigrationIteration     DomainEventID = 20
	DomainEventIDJobCompleted           DomainEventID = 21
	DomainEventIDDeviceRemovalFailed    DomainEventID = 22
	DomainEventIDMetadataChange         DomainEventID = 23
	DomainEventIDBlockThreshold         DomainEventID = 24
	DomainEventIDMemoryFailure          DomainEventID = 25
	DomainEventIDMemoryDeviceSizeChange DomainEventID = 26
	DomainEventIDNicMacChange           DomainEventID = 27
)

// DomainConsoleFlags as declared in libvirt/libvirt-domain.h:7110
type DomainConsoleFlags int32

// DomainConsoleFlags enumeration from libvirt/libvirt-domain.h:7110
const (
	DomainConsoleForce DomainConsoleFlags = 1
	DomainConsoleSafe  DomainConsoleFlags = 2
)

// DomainChannelFlags as declared in libvirt/libvirt-domain.h:7126
type DomainChannelFlags int32

// DomainChannelFlags enumeration from libvirt/libvirt-domain.h:7126
const (
	DomainChannelForce DomainChannelFlags = 1
)

// DomainOpenGraphicsFlags as declared in libvirt/libvirt-domain.h:7140
type DomainOpenGraphicsFlags int32

// DomainOpenGraphicsFlags enumeration from libvirt/libvirt-domain.h:7140
const (
	DomainOpenGraphicsSkipauth DomainOpenGraphicsFlags = 1
)

// DomainSetTimeFlags as declared in libvirt/libvirt-domain.h:7209
type DomainSetTimeFlags int32

// DomainSetTimeFlags enumeration from libvirt/libvirt-domain.h:7209
const (
	DomainTimeSync DomainSetTimeFlags = 1
)

// SchedParameterType as declared in libvirt/libvirt-domain.h:7231
type SchedParameterType int32

// SchedParameterType enumeration from libvirt/libvirt-domain.h:7231
const (
	DomainSchedFieldInt     SchedParameterType = 1
	DomainSchedFieldUint    SchedParameterType = 2
	DomainSchedFieldLlong   SchedParameterType = 3
	DomainSchedFieldUllong  SchedParameterType = 4
	DomainSchedFieldDouble  SchedParameterType = 5
	DomainSchedFieldBoolean SchedParameterType = 6
)

// BlkioParameterType as declared in libvirt/libvirt-domain.h:7288
type BlkioParameterType int32

// BlkioParameterType enumeration from libvirt/libvirt-domain.h:7288
const (
	DomainBlkioParamInt     BlkioParameterType = 1
	DomainBlkioParamUint    BlkioParameterType = 2
	DomainBlkioParamLlong   BlkioParameterType = 3
	DomainBlkioParamUllong  BlkioParameterType = 4
	DomainBlkioParamDouble  BlkioParameterType = 5
	DomainBlkioParamBoolean BlkioParameterType = 6
)

// MemoryParameterType as declared in libvirt/libvirt-domain.h:7345
type MemoryParameterType int32

// MemoryParameterType enumeration from libvirt/libvirt-domain.h:7345
const (
	DomainMemoryParamInt     MemoryParameterType = 1
	DomainMemoryParamUint    MemoryParameterType = 2
	DomainMemoryParamLlong   MemoryParameterType = 3
	DomainMemoryParamUllong  MemoryParameterType = 4
	DomainMemoryParamDouble  MemoryParameterType = 5
	DomainMemoryParamBoolean MemoryParameterType = 6
)

// DomainInterfaceAddressesSource as declared in libvirt/libvirt-domain.h:7400
type DomainInterfaceAddressesSource int32

// DomainInterfaceAddressesSource enumeration from libvirt/libvirt-domain.h:7400
const (
	DomainInterfaceAddressesSrcLease DomainInterfaceAddressesSource = iota
	DomainInterfaceAddressesSrcAgent DomainInterfaceAddressesSource = 1
	DomainInterfaceAddressesSrcArp   DomainInterfaceAddressesSource = 2
)

// DomainSetUserPasswordFlags as declared in libvirt/libvirt-domain.h:7455
type DomainSetUserPasswordFlags int32

// DomainSetUserPasswordFlags enumeration from libvirt/libvirt-domain.h:7455
const (
	DomainPasswordEncrypted DomainSetUserPasswordFlags = 1
)

// DomainLifecycle as declared in libvirt/libvirt-domain.h:7499
type DomainLifecycle int32

// DomainLifecycle enumeration from libvirt/libvirt-domain.h:7499
const (
	DomainLifecyclePoweroff DomainLifecycle = iota
	DomainLifecycleReboot   DomainLifecycle = 1
	DomainLifecycleCrash    DomainLifecycle = 2
)

// DomainLifecycleAction as declared in libvirt/libvirt-domain.h:7517
type DomainLifecycleAction int32

// DomainLifecycleAction enumeration from libvirt/libvirt-domain.h:7517
const (
	DomainLifecycleActionDestroy         DomainLifecycleAction = iota
	DomainLifecycleActionRestart         DomainLifecycleAction = 1
	DomainLifecycleActionRestartRename   DomainLifecycleAction = 2
	DomainLifecycleActionPreserve        DomainLifecycleAction = 3
	DomainLifecycleActionCoredumpDestroy DomainLifecycleAction = 4
	DomainLifecycleActionCoredumpRestart DomainLifecycleAction = 5
)

// DomainGuestInfoTypes as declared in libvirt/libvirt-domain.h:8165
type DomainGuestInfoTypes int32

// DomainGuestInfoTypes enumeration from libvirt/libvirt-domain.h:8165
const (
	DomainGuestInfoUsers      DomainGuestInfoTypes = 1
	DomainGuestInfoOs         DomainGuestInfoTypes = 2
	DomainGuestInfoTimezone   DomainGuestInfoTypes = 4
	DomainGuestInfoHostname   DomainGuestInfoTypes = 8
	DomainGuestInfoFilesystem DomainGuestInfoTypes = 16
	DomainGuestInfoDisks      DomainGuestInfoTypes = 32
	DomainGuestInfoInterfaces DomainGuestInfoTypes = 64
	DomainGuestInfoLoad       DomainGuestInfoTypes = 128
)

// DomainAgentResponseTimeoutValues as declared in libvirt/libvirt-domain.h:8182
type DomainAgentResponseTimeoutValues int32

// DomainAgentResponseTimeoutValues enumeration from libvirt/libvirt-domain.h:8182
const (
	DomainAgentResponseTimeoutBlock   DomainAgentResponseTimeoutValues = -2
	DomainAgentResponseTimeoutDefault DomainAgentResponseTimeoutValues = -1
	DomainAgentResponseTimeoutNowait  DomainAgentResponseTimeoutValues = 0
)

// DomainBackupBeginFlags as declared in libvirt/libvirt-domain.h:8196
type DomainBackupBeginFlags int32

// DomainBackupBeginFlags enumeration from libvirt/libvirt-domain.h:8196
const (
	DomainBackupBeginReuseExternal DomainBackupBeginFlags = 1
)

// DomainAuthorizedSSHKeysSetFlags as declared in libvirt/libvirt-domain.h:8220
type DomainAuthorizedSSHKeysSetFlags int32

// DomainAuthorizedSSHKeysSetFlags enumeration from libvirt/libvirt-domain.h:8220
const (
	DomainAuthorizedSSHKeysSetAppend DomainAuthorizedSSHKeysSetFlags = 1
	DomainAuthorizedSSHKeysSetRemove DomainAuthorizedSSHKeysSetFlags = 2
)

// DomainMessageType as declared in libvirt/libvirt-domain.h:8239
type DomainMessageType int32

// DomainMessageType enumeration from libvirt/libvirt-domain.h:8239
const (
	DomainMessageDeprecation DomainMessageType = 1
	DomainMessageTainting    DomainMessageType = 2
	DomainMessageIoerrors    DomainMessageType = 4
)

// DomainDirtyRateStatus as declared in libvirt/libvirt-domain.h:8263
type DomainDirtyRateStatus int32

// DomainDirtyRateStatus enumeration from libvirt/libvirt-domain.h:8263
const (
	DomainDirtyrateUnstarted DomainDirtyRateStatus = iota
	DomainDirtyrateMeasuring DomainDirtyRateStatus = 1
	DomainDirtyrateMeasured  DomainDirtyRateStatus = 2
)

// DomainDirtyRateCalcFlags as declared in libvirt/libvirt-domain.h:8278
type DomainDirtyRateCalcFlags int32

// DomainDirtyRateCalcFlags enumeration from libvirt/libvirt-domain.h:8278
const (
	DomainDirtyrateModePageSampling DomainDirtyRateCalcFlags = iota
	DomainDirtyrateModeDirtyBitmap  DomainDirtyRateCalcFlags = 1
	DomainDirtyrateModeDirtyRing    DomainDirtyRateCalcFlags = 2
)

// DomainFDAssociateFlags as declared in libvirt/libvirt-domain.h:8295
type DomainFDAssociateFlags int32

// DomainFDAssociateFlags enumeration from libvirt/libvirt-domain.h:8295
const (
	DomainFdAssociateSeclabelRestore  DomainFDAssociateFlags = 1
	DomainFdAssociateSeclabelWritable DomainFDAssociateFlags = 2
)

// DomainGraphicsReloadType as declared in libvirt/libvirt-domain.h:8315
type DomainGraphicsReloadType int32

// DomainGraphicsReloadType enumeration from libvirt/libvirt-domain.h:8315
const (
	DomainGraphicsReloadTypeAny DomainGraphicsReloadType = iota
	DomainGraphicsReloadTypeVnc DomainGraphicsReloadType = 1
)

// EventHandleType as declared in libvirt/libvirt-event.h:45
type EventHandleType int32

// EventHandleType enumeration from libvirt/libvirt-event.h:45
const (
	EventHandleReadable EventHandleType = 1
	EventHandleWritable EventHandleType = 2
	EventHandleError    EventHandleType = 4
	EventHandleHangup   EventHandleType = 8
)

// NodeSuspendTarget as declared in libvirt/libvirt-host.h:67
type NodeSuspendTarget int32

// NodeSuspendTarget enumeration from libvirt/libvirt-host.h:67
const (
	NodeSuspendTargetMem    NodeSuspendTarget = iota
	NodeSuspendTargetDisk   NodeSuspendTarget = 1
	NodeSuspendTargetHybrid NodeSuspendTarget = 2
)

// NodeGetCPUStatsAllCPUs as declared in libvirt/libvirt-host.h:218
type NodeGetCPUStatsAllCPUs int32

// NodeGetCPUStatsAllCPUs enumeration from libvirt/libvirt-host.h:218
const (
	NodeCPUStatsAllCpus NodeGetCPUStatsAllCPUs = -1
)

// NodeGetMemoryStatsAllCells as declared in libvirt/libvirt-host.h:314
type NodeGetMemoryStatsAllCells int32

// NodeGetMemoryStatsAllCells enumeration from libvirt/libvirt-host.h:314
const (
	NodeMemoryStatsAllCells NodeGetMemoryStatsAllCells = -1
)

// ConnectFlags as declared in libvirt/libvirt-host.h:605
type ConnectFlags int32

// ConnectFlags enumeration from libvirt/libvirt-host.h:605
const (
	ConnectRo        ConnectFlags = 1
	ConnectNoAliases ConnectFlags = 2
)

// ConnectCredentialType as declared in libvirt/libvirt-host.h:626
type ConnectCredentialType int32

// ConnectCredentialType enumeration from libvirt/libvirt-host.h:626
const (
	CredUsername     ConnectCredentialType = 1
	CredAuthname     ConnectCredentialType = 2
	CredLanguage     ConnectCredentialType = 3
	CredCnonce       ConnectCredentialType = 4
	CredPassphrase   ConnectCredentialType = 5
	CredEchoprompt   ConnectCredentialType = 6
	CredNoechoprompt ConnectCredentialType = 7
	CredRealm        ConnectCredentialType = 8
	CredExternal     ConnectCredentialType = 9
)

// CPUCompareResult as declared in libvirt/libvirt-host.h:935
type CPUCompareResult int32

// CPUCompareResult enumeration from libvirt/libvirt-host.h:935
const (
	CPUCompareError        CPUCompareResult = -1
	CPUCompareIncompatible CPUCompareResult = 0
	CPUCompareIdentical    CPUCompareResult = 1
	CPUCompareSuperset     CPUCompareResult = 2
)

// ConnectCompareCPUFlags as declared in libvirt/libvirt-host.h:947
type ConnectCompareCPUFlags int32

// ConnectCompareCPUFlags enumeration from libvirt/libvirt-host.h:947
const (
	ConnectCompareCPUFailIncompatible ConnectCompareCPUFlags = 1
	ConnectCompareCPUValidateXML      ConnectCompareCPUFlags = 2
)

// ConnectBaselineCPUFlags as declared in libvirt/libvirt-host.h:980
type ConnectBaselineCPUFlags int32

// ConnectBaselineCPUFlags enumeration from libvirt/libvirt-host.h:980
const (
	ConnectBaselineCPUExpandFeatures ConnectBaselineCPUFlags = 1
	ConnectBaselineCPUMigratable     ConnectBaselineCPUFlags = 2
	ConnectBaselineCPUIgnoreHost     ConnectBaselineCPUFlags = 4
)

// NodeAllocPagesFlags as declared in libvirt/libvirt-host.h:1014
type NodeAllocPagesFlags int32

// NodeAllocPagesFlags enumeration from libvirt/libvirt-host.h:1014
const (
	NodeAllocPagesAdd NodeAllocPagesFlags = iota
	NodeAllocPagesSet NodeAllocPagesFlags = 1
)

// ConnectListAllInterfacesFlags as declared in libvirt/libvirt-interface.h:70
type ConnectListAllInterfacesFlags int32

// ConnectListAllInterfacesFlags enumeration from libvirt/libvirt-interface.h:70
const (
	ConnectListInterfacesInactive ConnectListAllInterfacesFlags = 1
	ConnectListInterfacesActive   ConnectListAllInterfacesFlags = 2
)

// InterfaceXMLFlags as declared in libvirt/libvirt-interface.h:91
type InterfaceXMLFlags int32

// InterfaceXMLFlags enumeration from libvirt/libvirt-interface.h:91
const (
	InterfaceXMLInactive InterfaceXMLFlags = 1
)

// InterfaceDefineFlags as declared in libvirt/libvirt-interface.h:100
type InterfaceDefineFlags int32

// InterfaceDefineFlags enumeration from libvirt/libvirt-interface.h:100
const (
	InterfaceDefineValidate InterfaceDefineFlags = 1
)

// NetworkXMLFlags as declared in libvirt/libvirt-network.h:37
type NetworkXMLFlags int32

// NetworkXMLFlags enumeration from libvirt/libvirt-network.h:37
const (
	NetworkXMLInactive NetworkXMLFlags = 1
)

// ConnectListAllNetworksFlags as declared in libvirt/libvirt-network.h:115
type ConnectListAllNetworksFlags int32

// ConnectListAllNetworksFlags enumeration from libvirt/libvirt-network.h:115
const (
	ConnectListNetworksInactive    ConnectListAllNetworksFlags = 1
	ConnectListNetworksActive      ConnectListAllNetworksFlags = 2
	ConnectListNetworksPersistent  ConnectListAllNetworksFlags = 4
	ConnectListNetworksTransient   ConnectListAllNetworksFlags = 8
	ConnectListNetworksAutostart   ConnectListAllNetworksFlags = 16
	ConnectListNetworksNoAutostart ConnectListAllNetworksFlags = 32
)

// NetworkCreateFlags as declared in libvirt/libvirt-network.h:137
type NetworkCreateFlags int32

// NetworkCreateFlags enumeration from libvirt/libvirt-network.h:137
const (
	NetworkCreateValidate NetworkCreateFlags = 1
)

// NetworkDefineFlags as declared in libvirt/libvirt-network.h:154
type NetworkDefineFlags int32

// NetworkDefineFlags enumeration from libvirt/libvirt-network.h:154
const (
	NetworkDefineValidate NetworkDefineFlags = 1
)

// NetworkUpdateCommand as declared in libvirt/libvirt-network.h:187
type NetworkUpdateCommand int32

// NetworkUpdateCommand enumeration from libvirt/libvirt-network.h:187
const (
	NetworkUpdateCommandNone     NetworkUpdateCommand = iota
	NetworkUpdateCommandModify   NetworkUpdateCommand = 1
	NetworkUpdateCommandDelete   NetworkUpdateCommand = 2
	NetworkUpdateCommandAddLast  NetworkUpdateCommand = 3
	NetworkUpdateCommandAddFirst NetworkUpdateCommand = 4
)

// NetworkUpdateSection as declared in libvirt/libvirt-network.h:214
type NetworkUpdateSection int32

// NetworkUpdateSection enumeration from libvirt/libvirt-network.h:214
const (
	NetworkSectionNone             NetworkUpdateSection = iota
	NetworkSectionBridge           NetworkUpdateSection = 1
	NetworkSectionDomain           NetworkUpdateSection = 2
	NetworkSectionIP               NetworkUpdateSection = 3
	NetworkSectionIPDhcpHost       NetworkUpdateSection = 4
	NetworkSectionIPDhcpRange      NetworkUpdateSection = 5
	NetworkSectionForward          NetworkUpdateSection = 6
	NetworkSectionForwardInterface NetworkUpdateSection = 7
	NetworkSectionForwardPf        NetworkUpdateSection = 8
	NetworkSectionPortgroup        NetworkUpdateSection = 9
	NetworkSectionDNSHost          NetworkUpdateSection = 10
	NetworkSectionDNSTxt           NetworkUpdateSection = 11
	NetworkSectionDNSSrv           NetworkUpdateSection = 12
)

// NetworkUpdateFlags as declared in libvirt/libvirt-network.h:228
type NetworkUpdateFlags int32

// NetworkUpdateFlags enumeration from libvirt/libvirt-network.h:228
const (
	NetworkUpdateAffectCurrent NetworkUpdateFlags = iota
	NetworkUpdateAffectLive    NetworkUpdateFlags = 1
	NetworkUpdateAffectConfig  NetworkUpdateFlags = 2
)

// NetworkEventLifecycleType as declared in libvirt/libvirt-network.h:288
type NetworkEventLifecycleType int32

// NetworkEventLifecycleType enumeration from libvirt/libvirt-network.h:288
const (
	NetworkEventDefined   NetworkEventLifecycleType = iota
	NetworkEventUndefined NetworkEventLifecycleType = 1
	NetworkEventStarted   NetworkEventLifecycleType = 2
	NetworkEventStopped   NetworkEventLifecycleType = 3
)

// NetworkEventID as declared in libvirt/libvirt-network.h:345
type NetworkEventID int32

// NetworkEventID enumeration from libvirt/libvirt-network.h:345
const (
	NetworkEventIDLifecycle      NetworkEventID = iota
	NetworkEventIDMetadataChange NetworkEventID = 1
)

// IPAddrType as declared in libvirt/libvirt-network.h:359
type IPAddrType int32

// IPAddrType enumeration from libvirt/libvirt-network.h:359
const (
	IPAddrTypeIpv4 IPAddrType = iota
	IPAddrTypeIpv6 IPAddrType = 1
)

// NetworkPortCreateFlags as declared in libvirt/libvirt-network.h:439
type NetworkPortCreateFlags int32

// NetworkPortCreateFlags enumeration from libvirt/libvirt-network.h:439
const (
	NetworkPortCreateReclaim  NetworkPortCreateFlags = 1
	NetworkPortCreateValidate NetworkPortCreateFlags = 2
)

// NetworkMetadataType as declared in libvirt/libvirt-network.h:564
type NetworkMetadataType int32

// NetworkMetadataType enumeration from libvirt/libvirt-network.h:564
const (
	NetworkMetadataDescription NetworkMetadataType = iota
	NetworkMetadataTitle       NetworkMetadataType = 1
	NetworkMetadataElement     NetworkMetadataType = 2
)

// ConnectListAllNodeDeviceFlags as declared in libvirt/libvirt-nodedev.h:100
type ConnectListAllNodeDeviceFlags uint32

// ConnectListAllNodeDeviceFlags enumeration from libvirt/libvirt-nodedev.h:100
const (
	ConnectListNodeDevicesCapSystem         ConnectListAllNodeDeviceFlags = 1
	ConnectListNodeDevicesCapPciDev         ConnectListAllNodeDeviceFlags = 2
	ConnectListNodeDevicesCapUsbDev         ConnectListAllNodeDeviceFlags = 4
	ConnectListNodeDevicesCapUsbInterface   ConnectListAllNodeDeviceFlags = 8
	ConnectListNodeDevicesCapNet            ConnectListAllNodeDeviceFlags = 16
	ConnectListNodeDevicesCapScsiHost       ConnectListAllNodeDeviceFlags = 32
	ConnectListNodeDevicesCapScsiTarget     ConnectListAllNodeDeviceFlags = 64
	ConnectListNodeDevicesCapScsi           ConnectListAllNodeDeviceFlags = 128
	ConnectListNodeDevicesCapStorage        ConnectListAllNodeDeviceFlags = 256
	ConnectListNodeDevicesCapFcHost         ConnectListAllNodeDeviceFlags = 512
	ConnectListNodeDevicesCapVports         ConnectListAllNodeDeviceFlags = 1024
	ConnectListNodeDevicesCapScsiGeneric    ConnectListAllNodeDeviceFlags = 2048
	ConnectListNodeDevicesCapDrm            ConnectListAllNodeDeviceFlags = 4096
	ConnectListNodeDevicesCapMdevTypes      ConnectListAllNodeDeviceFlags = 8192
	ConnectListNodeDevicesCapMdev           ConnectListAllNodeDeviceFlags = 16384
	ConnectListNodeDevicesCapCcwDev         ConnectListAllNodeDeviceFlags = 32768
	ConnectListNodeDevicesCapCssDev         ConnectListAllNodeDeviceFlags = 65536
	ConnectListNodeDevicesCapVdpa           ConnectListAllNodeDeviceFlags = 131072
	ConnectListNodeDevicesCapApCard         ConnectListAllNodeDeviceFlags = 262144
	ConnectListNodeDevicesCapApQueue        ConnectListAllNodeDeviceFlags = 524288
	ConnectListNodeDevicesCapApMatrix       ConnectListAllNodeDeviceFlags = 1048576
	ConnectListNodeDevicesCapVpd            ConnectListAllNodeDeviceFlags = 2097152
	ConnectListNodeDevicesCapCcwgroupDev    ConnectListAllNodeDeviceFlags = 4194304
	ConnectListNodeDevicesCapCcwgroupMember ConnectListAllNodeDeviceFlags = 8388608
	ConnectListNodeDevicesPersistent        ConnectListAllNodeDeviceFlags = 268435456
	ConnectListNodeDevicesTransient         ConnectListAllNodeDeviceFlags = 536870912
	ConnectListNodeDevicesInactive          ConnectListAllNodeDeviceFlags = 1073741824
	ConnectListNodeDevicesActive            ConnectListAllNodeDeviceFlags = 2147483648
)

// NodeDeviceXMLFlags as declared in libvirt/libvirt-nodedev.h:133
type NodeDeviceXMLFlags int32

// NodeDeviceXMLFlags enumeration from libvirt/libvirt-nodedev.h:133
const (
	NodeDeviceXMLInactive NodeDeviceXMLFlags = 1
)

// NodeDeviceCreateXMLFlags as declared in libvirt/libvirt-nodedev.h:155
type NodeDeviceCreateXMLFlags int32

// NodeDeviceCreateXMLFlags enumeration from libvirt/libvirt-nodedev.h:155
const (
	NodeDeviceCreateXMLValidate NodeDeviceCreateXMLFlags = 1
)

// NodeDeviceDefineXMLFlags as declared in libvirt/libvirt-nodedev.h:171
type NodeDeviceDefineXMLFlags int32

// NodeDeviceDefineXMLFlags enumeration from libvirt/libvirt-nodedev.h:171
const (
	NodeDeviceDefineXMLValidate NodeDeviceDefineXMLFlags = 1
)

// NodeDeviceUpdateFlags as declared in libvirt/libvirt-nodedev.h:205
type NodeDeviceUpdateFlags int32

// NodeDeviceUpdateFlags enumeration from libvirt/libvirt-nodedev.h:205
const (
	NodeDeviceUpdateAffectCurrent NodeDeviceUpdateFlags = iota
	NodeDeviceUpdateAffectLive    NodeDeviceUpdateFlags = 1
	NodeDeviceUpdateAffectConfig  NodeDeviceUpdateFlags = 2
)

// NodeDeviceEventID as declared in libvirt/libvirt-nodedev.h:244
type NodeDeviceEventID int32

// NodeDeviceEventID enumeration from libvirt/libvirt-nodedev.h:244
const (
	NodeDeviceEventIDLifecycle NodeDeviceEventID = iota
	NodeDeviceEventIDUpdate    NodeDeviceEventID = 1
)

// NodeDeviceEventLifecycleType as declared in libvirt/libvirt-nodedev.h:292
type NodeDeviceEventLifecycleType int32

// NodeDeviceEventLifecycleType enumeration from libvirt/libvirt-nodedev.h:292
const (
	NodeDeviceEventCreated   NodeDeviceEventLifecycleType = iota
	NodeDeviceEventDeleted   NodeDeviceEventLifecycleType = 1
	NodeDeviceEventDefined   NodeDeviceEventLifecycleType = 2
	NodeDeviceEventUndefined NodeDeviceEventLifecycleType = 3
)

// NWFilterDefineFlags as declared in libvirt/libvirt-nwfilter.h:97
type NWFilterDefineFlags int32

// NWFilterDefineFlags enumeration from libvirt/libvirt-nwfilter.h:97
const (
	NwfilterDefineValidate NWFilterDefineFlags = 1
)

// NWFilterBindingCreateFlags as declared in libvirt/libvirt-nwfilter.h:130
type NWFilterBindingCreateFlags int32

// NWFilterBindingCreateFlags enumeration from libvirt/libvirt-nwfilter.h:130
const (
	NwfilterBindingCreateValidate NWFilterBindingCreateFlags = 1
)

// SecretUsageType as declared in libvirt/libvirt-secret.h:71
type SecretUsageType int32

// SecretUsageType enumeration from libvirt/libvirt-secret.h:71
const (
	SecretUsageTypeNone   SecretUsageType = iota
	SecretUsageTypeVolume SecretUsageType = 1
	SecretUsageTypeCeph   SecretUsageType = 2
	SecretUsageTypeIscsi  SecretUsageType = 3
	SecretUsageTypeTLS    SecretUsageType = 4
	SecretUsageTypeVtpm   SecretUsageType = 5
)

// ConnectListAllSecretsFlags as declared in libvirt/libvirt-secret.h:96
type ConnectListAllSecretsFlags int32

// ConnectListAllSecretsFlags enumeration from libvirt/libvirt-secret.h:96
const (
	ConnectListSecretsEphemeral   ConnectListAllSecretsFlags = 1
	ConnectListSecretsNoEphemeral ConnectListAllSecretsFlags = 2
	ConnectListSecretsPrivate     ConnectListAllSecretsFlags = 4
	ConnectListSecretsNoPrivate   ConnectListAllSecretsFlags = 8
)

// SecretDefineFlags as declared in libvirt/libvirt-secret.h:115
type SecretDefineFlags int32

// SecretDefineFlags enumeration from libvirt/libvirt-secret.h:115
const (
	SecretDefineValidate SecretDefineFlags = 1
)

// SecretEventID as declared in libvirt/libvirt-secret.h:172
type SecretEventID int32

// SecretEventID enumeration from libvirt/libvirt-secret.h:172
const (
	SecretEventIDLifecycle    SecretEventID = iota
	SecretEventIDValueChanged SecretEventID = 1
)

// SecretEventLifecycleType as declared in libvirt/libvirt-secret.h:218
type SecretEventLifecycleType int32

// SecretEventLifecycleType enumeration from libvirt/libvirt-secret.h:218
const (
	SecretEventDefined   SecretEventLifecycleType = iota
	SecretEventUndefined SecretEventLifecycleType = 1
)

// StoragePoolState as declared in libvirt/libvirt-storage.h:66
type StoragePoolState int32

// StoragePoolState enumeration from libvirt/libvirt-storage.h:66
const (
	StoragePoolInactive     StoragePoolState = iota
	StoragePoolBuilding     StoragePoolState = 1
	StoragePoolRunning      StoragePoolState = 2
	StoragePoolDegraded     StoragePoolState = 3
	StoragePoolInaccessible StoragePoolState = 4
)

// StoragePoolBuildFlags as declared in libvirt/libvirt-storage.h:79
type StoragePoolBuildFlags int32

// StoragePoolBuildFlags enumeration from libvirt/libvirt-storage.h:79
const (
	StoragePoolBuildNew         StoragePoolBuildFlags = iota
	StoragePoolBuildRepair      StoragePoolBuildFlags = 1
	StoragePoolBuildResize      StoragePoolBuildFlags = 2
	StoragePoolBuildNoOverwrite StoragePoolBuildFlags = 4
	StoragePoolBuildOverwrite   StoragePoolBuildFlags = 8
)

// StoragePoolDeleteFlags as declared in libvirt/libvirt-storage.h:89
type StoragePoolDeleteFlags int32

// StoragePoolDeleteFlags enumeration from libvirt/libvirt-storage.h:89
const (
	StoragePoolDeleteNormal StoragePoolDeleteFlags = iota
	StoragePoolDeleteZeroed StoragePoolDeleteFlags = 1
)

// StoragePoolCreateFlags as declared in libvirt/libvirt-storage.h:118
type StoragePoolCreateFlags int32

// StoragePoolCreateFlags enumeration from libvirt/libvirt-storage.h:118
const (
	StoragePoolCreateNormal               StoragePoolCreateFlags = iota
	StoragePoolCreateWithBuild            StoragePoolCreateFlags = 1
	StoragePoolCreateWithBuildOverwrite   StoragePoolCreateFlags = 2
	StoragePoolCreateWithBuildNoOverwrite StoragePoolCreateFlags = 4
)

// StorageVolType as declared in libvirt/libvirt-storage.h:179
type StorageVolType int32

// StorageVolType enumeration from libvirt/libvirt-storage.h:179
const (
	StorageVolFile    StorageVolType = iota
	StorageVolBlock   StorageVolType = 1
	StorageVolDir     StorageVolType = 2
	StorageVolNetwork StorageVolType = 3
	StorageVolNetdir  StorageVolType = 4
	StorageVolPloop   StorageVolType = 5
)

// StorageVolDeleteFlags as declared in libvirt/libvirt-storage.h:190
type StorageVolDeleteFlags int32

// StorageVolDeleteFlags enumeration from libvirt/libvirt-storage.h:190
const (
	StorageVolDeleteNormal        StorageVolDeleteFlags = iota
	StorageVolDeleteZeroed        StorageVolDeleteFlags = 1
	StorageVolDeleteWithSnapshots StorageVolDeleteFlags = 2
)

// StorageVolWipeAlgorithm as declared in libvirt/libvirt-storage.h:229
type StorageVolWipeAlgorithm int32

// StorageVolWipeAlgorithm enumeration from libvirt/libvirt-storage.h:229
const (
	StorageVolWipeAlgZero       StorageVolWipeAlgorithm = iota
	StorageVolWipeAlgNnsa       StorageVolWipeAlgorithm = 1
	StorageVolWipeAlgDod        StorageVolWipeAlgorithm = 2
	StorageVolWipeAlgBsi        StorageVolWipeAlgorithm = 3
	StorageVolWipeAlgGutmann    StorageVolWipeAlgorithm = 4
	StorageVolWipeAlgSchneier   StorageVolWipeAlgorithm = 5
	StorageVolWipeAlgPfitzner7  StorageVolWipeAlgorithm = 6
	StorageVolWipeAlgPfitzner33 StorageVolWipeAlgorithm = 7
	StorageVolWipeAlgRandom     StorageVolWipeAlgorithm = 8
	StorageVolWipeAlgTrim       StorageVolWipeAlgorithm = 9
)

// StorageVolInfoFlags as declared in libvirt/libvirt-storage.h:239
type StorageVolInfoFlags int32

// StorageVolInfoFlags enumeration from libvirt/libvirt-storage.h:239
const (
	StorageVolUseAllocation StorageVolInfoFlags = iota
	StorageVolGetPhysical   StorageVolInfoFlags = 1
)

// StorageXMLFlags as declared in libvirt/libvirt-storage.h:269
type StorageXMLFlags int32

// StorageXMLFlags enumeration from libvirt/libvirt-storage.h:269
const (
	StorageXMLInactive StorageXMLFlags = 1
)

// ConnectListAllStoragePoolsFlags as declared in libvirt/libvirt-storage.h:329
type ConnectListAllStoragePoolsFlags int32

// ConnectListAllStoragePoolsFlags enumeration from libvirt/libvirt-storage.h:329
const (
	ConnectListStoragePoolsInactive    ConnectListAllStoragePoolsFlags = 1
	ConnectListStoragePoolsActive      ConnectListAllStoragePoolsFlags = 2
	ConnectListStoragePoolsPersistent  ConnectListAllStoragePoolsFlags = 4
	ConnectListStoragePoolsTransient   ConnectListAllStoragePoolsFlags = 8
	ConnectListStoragePoolsAutostart   ConnectListAllStoragePoolsFlags = 16
	ConnectListStoragePoolsNoAutostart ConnectListAllStoragePoolsFlags = 32
	ConnectListStoragePoolsDir         ConnectListAllStoragePoolsFlags = 64
	ConnectListStoragePoolsFs          ConnectListAllStoragePoolsFlags = 128
	ConnectListStoragePoolsNetfs       ConnectListAllStoragePoolsFlags = 256
	ConnectListStoragePoolsLogical     ConnectListAllStoragePoolsFlags = 512
	ConnectListStoragePoolsDisk        ConnectListAllStoragePoolsFlags = 1024
	ConnectListStoragePoolsIscsi       ConnectListAllStoragePoolsFlags = 2048
	ConnectListStoragePoolsScsi        ConnectListAllStoragePoolsFlags = 4096
	ConnectListStoragePoolsMpath       ConnectListAllStoragePoolsFlags = 8192
	ConnectListStoragePoolsRbd         ConnectListAllStoragePoolsFlags = 16384
	ConnectListStoragePoolsSheepdog    ConnectListAllStoragePoolsFlags = 32768
	ConnectListStoragePoolsGluster     ConnectListAllStoragePoolsFlags = 65536
	ConnectListStoragePoolsZfs         ConnectListAllStoragePoolsFlags = 131072
	ConnectListStoragePoolsVstorage    ConnectListAllStoragePoolsFlags = 262144
	ConnectListStoragePoolsIscsiDirect ConnectListAllStoragePoolsFlags = 524288
)

// StoragePoolDefineFlags as declared in libvirt/libvirt-storage.h:361
type StoragePoolDefineFlags int32

// StoragePoolDefineFlags enumeration from libvirt/libvirt-storage.h:361
const (
	StoragePoolDefineValidate StoragePoolDefineFlags = 1
)

// StorageVolCreateFlags as declared in libvirt/libvirt-storage.h:441
type StorageVolCreateFlags int32

// StorageVolCreateFlags enumeration from libvirt/libvirt-storage.h:441
const (
	StorageVolCreatePreallocMetadata StorageVolCreateFlags = 1
	StorageVolCreateReflink          StorageVolCreateFlags = 2
	StorageVolCreateValidate         StorageVolCreateFlags = 4
)

// StorageVolDownloadFlags as declared in libvirt/libvirt-storage.h:457
type StorageVolDownloadFlags int32

// StorageVolDownloadFlags enumeration from libvirt/libvirt-storage.h:457
const (
	StorageVolDownloadSparseStream StorageVolDownloadFlags = 1
)

// StorageVolUploadFlags as declared in libvirt/libvirt-storage.h:472
type StorageVolUploadFlags int32

// StorageVolUploadFlags enumeration from libvirt/libvirt-storage.h:472
const (
	StorageVolUploadSparseStream StorageVolUploadFlags = 1
)

// StorageVolResizeFlags as declared in libvirt/libvirt-storage.h:508
type StorageVolResizeFlags int32

// StorageVolResizeFlags enumeration from libvirt/libvirt-storage.h:508
const (
	StorageVolResizeAllocate StorageVolResizeFlags = 1
	StorageVolResizeDelta    StorageVolResizeFlags = 2
	StorageVolResizeShrink   StorageVolResizeFlags = 4
)

// StoragePoolEventID as declared in libvirt/libvirt-storage.h:550
type StoragePoolEventID int32

// StoragePoolEventID enumeration from libvirt/libvirt-storage.h:550
const (
	StoragePoolEventIDLifecycle StoragePoolEventID = iota
	StoragePoolEventIDRefresh   StoragePoolEventID = 1
)

// StoragePoolEventLifecycleType as declared in libvirt/libvirt-storage.h:600
type StoragePoolEventLifecycleType int32

// StoragePoolEventLifecycleType enumeration from libvirt/libvirt-storage.h:600
const (
	StoragePoolEventDefined   StoragePoolEventLifecycleType = iota
	StoragePoolEventUndefined StoragePoolEventLifecycleType = 1
	StoragePoolEventStarted   StoragePoolEventLifecycleType = 2
	StoragePoolEventStopped   StoragePoolEventLifecycleType = 3
	StoragePoolEventCreated   StoragePoolEventLifecycleType = 4
	StoragePoolEventDeleted   StoragePoolEventLifecycleType = 5
)

// StreamFlags as declared in libvirt/libvirt-stream.h:38
type StreamFlags int32

// StreamFlags enumeration from libvirt/libvirt-stream.h:38
const (
	StreamNonblock StreamFlags = 1
)

// StreamRecvFlagsValues as declared in libvirt/libvirt-stream.h:59
type StreamRecvFlagsValues int32

// StreamRecvFlagsValues enumeration from libvirt/libvirt-stream.h:59
const (
	StreamRecvStopAtHole StreamRecvFlagsValues = 1
)

// StreamEventType as declared in libvirt/libvirt-stream.h:262
type StreamEventType int32

// StreamEventType enumeration from libvirt/libvirt-stream.h:262
const (
	StreamEventReadable StreamEventType = 1
	StreamEventWritable StreamEventType = 2
	StreamEventError    StreamEventType = 4
	StreamEventHangup   StreamEventType = 8
)

// ErrorLevel as declared in libvirt/virterror.h:44
type ErrorLevel int32

// ErrorLevel enumeration from libvirt/virterror.h:44
const (
	ErrNone    ErrorLevel = iota
	ErrWarning ErrorLevel = 1
	ErrError   ErrorLevel = 2
)

// ErrorDomain as declared in libvirt/virterror.h:148
type ErrorDomain int32

// ErrorDomain enumeration from libvirt/virterror.h:148
const (
	fromNone             ErrorDomain = iota
	fromXen              ErrorDomain = 1
	fromXend             ErrorDomain = 2
	fromXenstore         ErrorDomain = 3
	fromSexpr            ErrorDomain = 4
	fromXML              ErrorDomain = 5
	fromDom              ErrorDomain = 6
	fromRPC              ErrorDomain = 7
	fromProxy            ErrorDomain = 8
	fromConf             ErrorDomain = 9
	fromQemu             ErrorDomain = 10
	fromNet              ErrorDomain = 11
	fromTest             ErrorDomain = 12
	fromRemote           ErrorDomain = 13
	fromOpenvz           ErrorDomain = 14
	fromXenxm            ErrorDomain = 15
	fromStatsLinux       ErrorDomain = 16
	fromLxc              ErrorDomain = 17
	fromStorage          ErrorDomain = 18
	fromNetwork          ErrorDomain = 19
	fromDomain           ErrorDomain = 20
	fromUml              ErrorDomain = 21
	fromNodedev          ErrorDomain = 22
	fromXenInotify       ErrorDomain = 23
	fromSecurity         ErrorDomain = 24
	fromVbox             ErrorDomain = 25
	fromInterface        ErrorDomain = 26
	fromOne              ErrorDomain = 27
	fromEsx              ErrorDomain = 28
	fromPhyp             ErrorDomain = 29
	fromSecret           ErrorDomain = 30
	fromCPU              ErrorDomain = 31
	fromXenapi           ErrorDomain = 32
	fromNwfilter         ErrorDomain = 33
	fromHook             ErrorDomain = 34
	fromDomainSnapshot   ErrorDomain = 35
	fromAudit            ErrorDomain = 36
	fromSysinfo          ErrorDomain = 37
	fromStreams          ErrorDomain = 38
	fromVmware           ErrorDomain = 39
	fromEvent            ErrorDomain = 40
	fromLibxl            ErrorDomain = 41
	fromLocking          ErrorDomain = 42
	fromHyperv           ErrorDomain = 43
	fromCapabilities     ErrorDomain = 44
	fromURI              ErrorDomain = 45
	fromAuth             ErrorDomain = 46
	fromDbus             ErrorDomain = 47
	fromParallels        ErrorDomain = 48
	fromDevice           ErrorDomain = 49
	fromSSH              ErrorDomain = 50
	fromLockspace        ErrorDomain = 51
	fromInitctl          ErrorDomain = 52
	fromIdentity         ErrorDomain = 53
	fromCgroup           ErrorDomain = 54
	fromAccess           ErrorDomain = 55
	fromSystemd          ErrorDomain = 56
	fromBhyve            ErrorDomain = 57
	fromCrypto           ErrorDomain = 58
	fromFirewall         ErrorDomain = 59
	fromPolkit           ErrorDomain = 60
	fromThread           ErrorDomain = 61
	fromAdmin            ErrorDomain = 62
	fromLogging          ErrorDomain = 63
	fromXenxl            ErrorDomain = 64
	fromPerf             ErrorDomain = 65
	fromLibssh           ErrorDomain = 66
	fromResctrl          ErrorDomain = 67
	fromFirewalld        ErrorDomain = 68
	fromDomainCheckpoint ErrorDomain = 69
	fromTpm              ErrorDomain = 70
	fromBpf              ErrorDomain = 71
	fromCh               ErrorDomain = 72
)

// ErrorNumber as declared in libvirt/virterror.h:360
type ErrorNumber int32

// ErrorNumber enumeration from libvirt/virterror.h:360
const (
	ErrOk                      ErrorNumber = iota
	ErrInternalError           ErrorNumber = 1
	ErrNoMemory                ErrorNumber = 2
	ErrNoSupport               ErrorNumber = 3
	ErrUnknownHost             ErrorNumber = 4
	ErrNoConnect               ErrorNumber = 5
	ErrInvalidConn             ErrorNumber = 6
	ErrInvalidDomain           ErrorNumber = 7
	ErrInvalidArg              ErrorNumber = 8
	ErrOperationFailed         ErrorNumber = 9
	ErrGetFailed               ErrorNumber = 10
	ErrPostFailed              ErrorNumber = 11
	ErrHTTPError               ErrorNumber = 12
	ErrSexprSerial             ErrorNumber = 13
	ErrNoXen                   ErrorNumber = 14
	ErrXenCall                 ErrorNumber = 15
	ErrOsType                  ErrorNumber = 16
	ErrNoKernel                ErrorNumber = 17
	ErrNoRoot                  ErrorNumber = 18
	ErrNoSource                ErrorNumber = 19
	ErrNoTarget                ErrorNumber = 20
	ErrNoName                  ErrorNumber = 21
	ErrNoOs                    ErrorNumber = 22
	ErrNoDevice                ErrorNumber = 23
	ErrNoXenstore              ErrorNumber = 24
	ErrDriverFull              ErrorNumber = 25
	ErrCallFailed              ErrorNumber = 26
	ErrXMLError                ErrorNumber = 27
	ErrDomExist                ErrorNumber = 28
	ErrOperationDenied         ErrorNumber = 29
	ErrOpenFailed              ErrorNumber = 30
	ErrReadFailed              ErrorNumber = 31
	ErrParseFailed             ErrorNumber = 32
	ErrConfSyntax              ErrorNumber = 33
	ErrWriteFailed             ErrorNumber = 34
	ErrXMLDetail               ErrorNumber = 35
	ErrInvalidNetwork          ErrorNumber = 36
	ErrNetworkExist            ErrorNumber = 37
	ErrSystemError             ErrorNumber = 38
	ErrRPC                     ErrorNumber = 39
	ErrGnutlsError             ErrorNumber = 40
	WarNoNetwork               ErrorNumber = 41
	ErrNoDomain                ErrorNumber = 42
	ErrNoNetwork               ErrorNumber = 43
	ErrInvalidMac              ErrorNumber = 44
	ErrAuthFailed              ErrorNumber = 45
	ErrInvalidStoragePool      ErrorNumber = 46
	ErrInvalidStorageVol       ErrorNumber = 47
	WarNoStorage               ErrorNumber = 48
	ErrNoStoragePool           ErrorNumber = 49
	ErrNoStorageVol            ErrorNumber = 50
	WarNoNode                  ErrorNumber = 51
	ErrInvalidNodeDevice       ErrorNumber = 52
	ErrNoNodeDevice            ErrorNumber = 53
	ErrNoSecurityModel         ErrorNumber = 54
	ErrOperationInvalid        ErrorNumber = 55
	WarNoInterface             ErrorNumber = 56
	ErrNoInterface             ErrorNumber = 57
	ErrInvalidInterface        ErrorNumber = 58
	ErrMultipleInterfaces      ErrorNumber = 59
	WarNoNwfilter              ErrorNumber = 60
	ErrInvalidNwfilter         ErrorNumber = 61
	ErrNoNwfilter              ErrorNumber = 62
	ErrBuildFirewall           ErrorNumber = 63
	WarNoSecret                ErrorNumber = 64
	ErrInvalidSecret           ErrorNumber = 65
	ErrNoSecret                ErrorNumber = 66
	ErrConfigUnsupported       ErrorNumber = 67
	ErrOperationTimeout        ErrorNumber = 68
	ErrMigratePersistFailed    ErrorNumber = 69
	ErrHookScriptFailed        ErrorNumber = 70
	ErrInvalidDomainSnapshot   ErrorNumber = 71
	ErrNoDomainSnapshot        ErrorNumber = 72
	ErrInvalidStream           ErrorNumber = 73
	ErrArgumentUnsupported     ErrorNumber = 74
	ErrStorageProbeFailed      ErrorNumber = 75
	ErrStoragePoolBuilt        ErrorNumber = 76
	ErrSnapshotRevertRisky     ErrorNumber = 77
	ErrOperationAborted        ErrorNumber = 78
	ErrAuthCancelled           ErrorNumber = 79
	ErrNoDomainMetadata        ErrorNumber = 80
	ErrMigrateUnsafe           ErrorNumber = 81
	ErrOverflow                ErrorNumber = 82
	ErrBlockCopyActive         ErrorNumber = 83
	ErrOperationUnsupported    ErrorNumber = 84
	ErrSSH                     ErrorNumber = 85
	ErrAgentUnresponsive       ErrorNumber = 86
	ErrResourceBusy            ErrorNumber = 87
	ErrAccessDenied            ErrorNumber = 88
	ErrDbusService             ErrorNumber = 89
	ErrStorageVolExist         ErrorNumber = 90
	ErrCPUIncompatible         ErrorNumber = 91
	ErrXMLInvalidSchema        ErrorNumber = 92
	ErrMigrateFinishOk         ErrorNumber = 93
	ErrAuthUnavailable         ErrorNumber = 94
	ErrNoServer                ErrorNumber = 95
	ErrNoClient                ErrorNumber = 96
	ErrAgentUnsynced           ErrorNumber = 97
	ErrLibssh                  ErrorNumber = 98
	ErrDeviceMissing           ErrorNumber = 99
	ErrInvalidNwfilterBinding  ErrorNumber = 100
	ErrNoNwfilterBinding       ErrorNumber = 101
	ErrInvalidDomainCheckpoint ErrorNumber = 102
	ErrNoDomainCheckpoint      ErrorNumber = 103
	ErrNoDomainBackup          ErrorNumber = 104
	ErrInvalidNetworkPort      ErrorNumber = 105
	ErrNetworkPortExist        ErrorNumber = 106
	ErrNoNetworkPort           ErrorNumber = 107
	ErrNoHostname              ErrorNumber = 108
	ErrCheckpointInconsistent  ErrorNumber = 109
	ErrMultipleDomains         ErrorNumber = 110
	ErrNoNetworkMetadata       ErrorNumber = 111
	ErrAgentCommandTimeout     ErrorNumber = 112
	ErrAgentCommandFailed      ErrorNumber = 113
)
